require.config({"config": {
        "jsbuild":{"Magento_Ui/js/lib/knockout/bindings/staticChecked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.staticChecked = {\n        'after': ['value', 'attr'],\n\n        /**\n         * Implements same functionality as a standard 'checked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor, allBindings) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                isValueArray,\n                oldElemValue,\n                useCheckedValue,\n                checkedValue,\n                updateModel,\n                updateView;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            checkedValue = ko.pureComputed(function () {\n                if (allBindings.has('checkedValue')) {\n                    return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                } else if (allBindings.has('value')) {\n                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                }\n\n                return element.value;\n            });\n\n            isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array;\n            oldElemValue = isValueArray ? checkedValue() : undefined;\n            useCheckedValue = isRadio || isValueArray;\n\n            /**\n             * Updates values array if it's necessary.\n             */\n            updateModel = function () {\n                var isChecked = element.checked,\n                    elemValue = useCheckedValue ? checkedValue() : isChecked,\n                    modelValue;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue = ko.dependencyDetection.ignore(valueAccessor);\n\n                if (isValueArray) {\n                    if (oldElemValue !== elemValue) {\n                        oldElemValue = elemValue;\n                    } else {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                    }\n                } else {\n                    ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                }\n            };\n\n            /**\n             * Updates checkbox state.\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                if (isValueArray) {\n                    element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n                } else if (isCheckbox) {\n                    element.checked = modelValue;\n                } else {\n                    element.checked = checkedValue() === modelValue;\n                }\n            };\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n\n            ko.utils.registerEventHandler(element, 'click', updateModel);\n\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.staticChecked = true;\n\n    renderer.addAttribute('staticChecked');\n});\n","Magento_Ui/js/lib/knockout/bindings/optgroup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'mageUtils'\n    ], function (ko, utils) {\n    'use strict';\n\n    var captionPlaceholder = {},\n        optgroupTmpl = '<optgroup label=\"${ $.label }\"></optgroup>',\n        nbspRe = /&nbsp;/g,\n        optionsText,\n        optionsValue,\n        optionTitle;\n\n    ko.bindingHandlers.optgroup = {\n        /**\n         * @param {*} element\n         */\n        init: function (element) {\n            if (ko.utils.tagNameLower(element) !== 'select') {\n                throw new Error('options binding applies only to SELECT elements');\n            }\n\n            // Remove all existing <option>s.\n            while (element.length > 0) {\n                element.remove(0);\n            }\n        },\n\n        /**\n         * @param {*} element\n         * @param {*} valueAccessor\n         * @param {*} allBindings\n         */\n        update: function (element, valueAccessor, allBindings) {\n            var selectWasPreviouslyEmpty = element.length === 0,\n                previousScrollTop = !selectWasPreviouslyEmpty && element.multiple ? element.scrollTop : null,\n                includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                arrayToDomNodeChildrenOptions = {},\n                captionValue,\n                unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                filteredArray,\n                previousSelectedValues,\n                itemUpdate = false,\n                callback = setSelectionCallback,//eslint-disable-line no-use-before-define\n                nestedOptionsLevel = -1;\n\n            optionsText = ko.utils.unwrapObservable(allBindings.get('optionsText')) || 'text';\n            optionsValue = ko.utils.unwrapObservable(allBindings.get('optionsValue')) || 'value';\n            optionTitle = optionsText + 'title';\n\n            if (element.multiple) {\n                previousSelectedValues = ko.utils.arrayMap(\n                    selectedOptions(),//eslint-disable-line no-use-before-define\n                    ko.selectExtensions.readValue\n                );\n            } else {\n                previousSelectedValues = element.selectedIndex >= 0 ?\n                    [ko.selectExtensions.readValue(element.options[element.selectedIndex])] :\n                    [];\n            }\n\n            if (unwrappedArray) {\n                if (typeof unwrappedArray.length === 'undefined') { // Coerce single value into array\n                    unwrappedArray = [unwrappedArray];\n                }\n\n                // Filter out any entries marked as destroyed\n                filteredArray = ko.utils.arrayFilter(unwrappedArray, function (item) {\n                    if (item && !item.label) {\n                        return false;\n                    }\n\n                    return includeDestroyed ||\n                        item === undefined ||\n                        item === null ||\n                        !ko.utils.unwrapObservable(item._destroy);\n                });\n                filteredArray.map(recursivePathBuilder, null);//eslint-disable-line no-use-before-define\n            }\n\n            /**\n             * @param {*} option\n             */\n            arrayToDomNodeChildrenOptions.beforeRemove = function (option) {\n                element.removeChild(option);\n            };\n\n            if (allBindings.has('optionsAfterRender')) {\n\n                /**\n                 * @param {*} arrayEntry\n                 * @param {*} newOptions\n                 */\n                callback = function (arrayEntry, newOptions) {\n                    setSelectionCallback(arrayEntry, newOptions);//eslint-disable-line no-use-before-define\n                    ko.dependencyDetection.ignore(\n                        allBindings.get('optionsAfterRender'),\n                        null,\n                        [newOptions[0],\n                        arrayEntry !== captionPlaceholder ? arrayEntry : undefined]\n                    );\n                };\n            }\n\n            filteredArray = formatOptions(filteredArray);//eslint-disable-line no-use-before-define\n            ko.utils.setDomNodeChildrenFromArrayMapping(\n                element,\n                filteredArray,\n                optionNodeFromArray,//eslint-disable-line no-use-before-define\n                arrayToDomNodeChildrenOptions,\n                callback\n            );\n\n            ko.dependencyDetection.ignore(function () {\n                var selectionChanged;\n\n                if (allBindings.get('valueAllowUnset') && allBindings.has('value')) {\n                    // The model value is authoritative, so make sure its value is the one selected\n                    ko.selectExtensions.writeValue(\n                        element,\n                        ko.utils.unwrapObservable(allBindings.get('value')),\n                        true /* allowUnset */\n                    );\n                } else {\n                    // Determine if the selection has changed as a result of updating the options list\n                    if (element.multiple) {\n                        // For a multiple-select box, compare the new selection count to the previous one\n                        // But if nothing was selected before, the selection can't have changed\n                        selectionChanged = previousSelectedValues.length &&\n                            selectedOptions().length < //eslint-disable-line no-use-before-define\n                            previousSelectedValues.length;\n                    } else {\n                        // For a single-select box, compare the current value to the previous value\n                        // But if nothing was selected before or nothing is selected now,\n                        // just look for a change in selection\n                        selectionChanged = previousSelectedValues.length && element.selectedIndex >= 0 ?\n                            ko.selectExtensions.readValue(element.options[element.selectedIndex]) !==\n                            previousSelectedValues[0] : previousSelectedValues.length || element.selectedIndex >= 0;\n                    }\n\n                    // Ensure consistency between model value and selected option.\n                    // If the dropdown was changed so that selection is no longer the same,\n                    // notify the value or selectedOptions binding.\n                    if (selectionChanged) {\n                        ko.utils.triggerEvent(element, 'change');\n                    }\n                }\n            });\n\n            /*eslint-enable max-len, no-use-before-define*/\n\n            if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) {\n                element.scrollTop = previousScrollTop;\n            }\n\n            /**\n             * @returns {*}\n             */\n            function selectedOptions() {\n                return ko.utils.arrayFilter(element.options, function (node) {\n                    return node.selected;\n                });\n            }\n\n            /**\n             * @param {*} object\n             * @param {*} predicate\n             * @param {*} defaultValue\n             * @returns {*}\n             */\n            function applyToObject(object, predicate, defaultValue) {\n                var predicateType = typeof predicate;\n\n                if (predicateType === 'function') {   // run it against the data value\n                    return predicate(object);\n                } else if (predicateType === 'string') { // treat it as a property name on the data value\n                    return object[predicate];\n                }\n\n                return defaultValue;\n            }\n\n            /**\n             * @param {*} obj\n             */\n            function recursivePathBuilder(obj) {\n\n                obj[optionTitle] = (this && this[optionTitle] ? this[optionTitle] + '/' : '') + obj[optionsText].trim();\n\n                if (Array.isArray(obj[optionsValue])) {\n                    obj[optionsValue].map(recursivePathBuilder, obj);\n                }\n            }\n\n            /**\n             * @param {Array} arrayEntry\n             * @param {*} oldOptions\n             * @returns {*[]}\n             */\n            function optionNodeFromArray(arrayEntry, oldOptions) {\n                var option;\n\n                if (oldOptions.length) {\n                    previousSelectedValues = oldOptions[0].selected ?\n                        [ko.selectExtensions.readValue(oldOptions[0])] : [];\n                    itemUpdate = true;\n                }\n\n                if (arrayEntry === captionPlaceholder) { // empty value, label === caption\n                    option = element.ownerDocument.createElement('option');\n                    ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                    ko.selectExtensions.writeValue(option, undefined);\n                } else if (typeof arrayEntry[optionsValue] === 'undefined') { // empty value === optgroup\n                    if (arrayEntry.__disableTmpl) {\n                        option = '<optgroup label=\"' + arrayEntry[optionsText] + '\"></optgroup>';\n                    } else {\n                        option = utils.template(optgroupTmpl, {\n                            label: arrayEntry[optionsText],\n                            title: arrayEntry[optionsText + 'title']\n                        });\n                    }\n                    option = ko.utils.parseHtmlFragment(option)[0];\n\n                } else {\n                    option = element.ownerDocument.createElement('option');\n                    option.setAttribute('data-title', arrayEntry[optionsText + 'title']);\n                    ko.selectExtensions.writeValue(option, arrayEntry[optionsValue]);\n                    ko.utils.setTextContent(option, arrayEntry[optionsText]);\n                }\n\n                return [option];\n            }\n\n            /**\n             * @param {*} newOptions\n             */\n            function setSelectionCallback(newOptions) {\n                var isSelected;\n\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                if (previousSelectedValues.length && newOptions.value) {\n                    isSelected = ko.utils.arrayIndexOf(\n                        previousSelectedValues,\n                        ko.selectExtensions.readValue(newOptions.value)\n                    ) >= 0;\n\n                    ko.utils.setOptionNodeSelectionState(newOptions.value, isSelected);\n\n                    // If this option was changed from being selected during a single-item update, notify the change\n                    if (itemUpdate && !isSelected) {\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, 'change']);\n                    }\n                }\n            }\n\n            /**\n             * @param {*} string\n             * @param {Number} times\n             * @returns {Array}\n             */\n            function strPad(string, times) {\n                return new Array(times + 1).join(string);\n            }\n\n            /**\n             * @param {*} options\n             * @returns {Array}\n             */\n            function formatOptions(options) {\n                var res = [];\n\n                nestedOptionsLevel++;\n\n                if (!nestedOptionsLevel) { // zero level\n                    // If caption is included, add it to the array\n                    if (allBindings.has('optionsCaption')) {\n                        captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                        // If caption value is null or undefined, don't show a caption\n                        if (//eslint-disable-line max-depth\n                            captionValue !== null &&\n                            captionValue !== undefined &&\n                            captionValue !== false\n                        ) {\n                            res.push(captionPlaceholder);\n                        }\n                    }\n                }\n\n                ko.utils.arrayForEach(options, function (option) {\n                    var value = applyToObject(option, optionsValue, option),\n                        label = applyToObject(option, optionsText, value) || '',\n                        disabled = applyToObject(option, 'disabled', false) || false,\n                        obj = {},\n                        space = '\\u2007\\u2007\\u2007';\n\n                    obj[optionTitle] = applyToObject(option, optionsText + 'title', value);\n\n                    if (disabled) {\n                        obj.disabled = disabled;\n                    }\n\n                    if (option.hasOwnProperty('__disableTmpl')) {\n                        obj.__disableTmpl = option.__disableTmpl;\n                    }\n\n                    label = label.replace(nbspRe, '').trim();\n\n                    if (Array.isArray(value)) {\n                        obj[optionsText] = strPad('&nbsp;', nestedOptionsLevel * 4) + label;\n                        res.push(obj);\n                        res = res.concat(formatOptions(value));\n                    } else {\n                        obj[optionsText] = strPad(space, nestedOptionsLevel * 2) + label;\n                        obj[optionsValue] = value;\n                        res.push(obj);\n                    }\n                });\n                nestedOptionsLevel--;\n\n                return res;\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/keyboard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.keyboard = {\n\n        /**\n         * Attaches keypress handlers to element\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param  {Object} allBindings - all bindings object\n         * @param  {Object} viewModel - reference to viewmodel\n         */\n        init: function (el, valueAccessor, allBindings, viewModel) {\n            var map = valueAccessor();\n\n            ko.utils.registerEventHandler(el, 'keyup', function (e) {\n                var callback = map[e.keyCode];\n\n                if (callback) {\n                    return callback.call(viewModel, e);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('keyboard');\n});\n","Magento_Ui/js/lib/knockout/bindings/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer',\n    'spectrum',\n    'tinycolor'\n], function (ko, $, renderer, spectrum, tinycolor) {\n    'use strict';\n\n    /**\n     * Change color picker status to be enabled or disabled\n     *\n     * @param {HTMLElement} element - Element to apply colorpicker enable/disable status to.\n     * @param {Object} viewModel - Object, which represents view model binded to el.\n     */\n    function changeColorPickerStateBasedOnViewModel(element, viewModel) {\n        $(element).spectrum(viewModel.disabled() ? 'disable' : 'enable');\n    }\n\n    ko.bindingHandlers.colorPicker = {\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor(),\n\n                /** change value */\n                changeValue = function (value) {\n                    if (value == null) {\n                        value = '';\n                    }\n                    config.value(value.toString());\n                };\n\n            config.change = changeValue;\n\n            config.hide = changeValue;\n\n            /** show value */\n            config.show = function () {\n                if (!viewModel.focused()) {\n                    viewModel.focused(true);\n                }\n\n                return true;\n            };\n\n            $(element).spectrum(config);\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         *\n         * @param {HTMLElement} element - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to element.\n         */\n        update: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor();\n\n            /** Initialise value as empty if it is undefined when color picker input is reset **/\n            if (config.value() === undefined) {\n                config.value('');\n            }\n\n            if (tinycolor(config.value()).isValid() || config.value() === '') {\n                $(element).spectrum('set', config.value());\n\n                if (config.value() !== '') {\n                    config.value($(element).spectrum('get').toString());\n                }\n            }\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        }\n    };\n\n    renderer.addAttribute('colorPicker');\n});\n","Magento_Ui/js/lib/knockout/bindings/autoselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer'\n], function (ko, $, renderer) {\n    'use strict';\n\n    /**\n     * 'Focus' event handler.\n     *\n     * @param {EventObject} e\n     */\n    function onFocus(e) {\n        e.target.select();\n    }\n\n    ko.bindingHandlers.autoselect = {\n\n        /**\n         * Adds event handler which automatically\n         * selects inputs' element text when field gets focused.\n         */\n        init: function (element, valueAccessor) {\n            var enabled = ko.unwrap(valueAccessor());\n\n            if (enabled !== false) {\n                $(element).on('focus', onFocus);\n            }\n        }\n    };\n\n    renderer.addAttribute('autoselect');\n});\n","Magento_Ui/js/lib/knockout/bindings/i18n.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'module',\n    '../template/renderer',\n    'mage/translate'\n], function ($, ko, module, renderer) {\n    'use strict';\n\n    var locations = {\n            'legend': 'Caption for the fieldset element',\n            'label': 'Label for an input element.',\n            'button': 'Push button',\n            'a': 'Link label',\n            'b': 'Bold text',\n            'strong': 'Strong emphasized text',\n            'i': 'Italic text',\n            'em': 'Emphasized text',\n            'u': 'Underlined text',\n            'sup': 'Superscript text',\n            'sub': 'Subscript text',\n            'span': 'Span element',\n            'small': 'Smaller text',\n            'big': 'Bigger text',\n            'address': 'Contact information',\n            'blockquote': 'Long quotation',\n            'q': 'Short quotation',\n            'cite': 'Citation',\n            'caption': 'Table caption',\n            'abbr': 'Abbreviated phrase',\n            'acronym': 'An acronym',\n            'var': 'Variable part of a text',\n            'dfn': 'Term',\n            'strike': 'Strikethrough text',\n            'del': 'Deleted text',\n            'ins': 'Inserted text',\n            'h1': 'Heading level 1',\n            'h2': 'Heading level 2',\n            'h3': 'Heading level 3',\n            'h4': 'Heading level 4',\n            'h5': 'Heading level 5',\n            'h6': 'Heading level 6',\n            'center': 'Centered text',\n            'select': 'List options',\n            'img': 'Image',\n            'input': 'Form element'\n        },\n\n        /**\n         * Generates [data-translate] attribute's value\n         * @param {Object} translationData\n         * @param {String} location\n         */\n        composeTranslateAttr = function (translationData, location) {\n            var obj = [{\n                'shown': translationData.shown,\n                'translated': translationData.translated,\n                'original': translationData.original,\n                'location': locations[location] || 'Text'\n            }];\n\n            return JSON.stringify(obj);\n        },\n\n        /**\n         * Sets text for the element\n         * @param {Object} el\n         * @param {String} text\n         */\n        setText = function (el, text) {\n            $(el).text(text);\n        },\n\n        /**\n         * Sets [data-translate] attribute for the element\n         * @param {Object} el - The element which is binded\n         * @param {String} original - The original value of the element\n         */\n        setTranslateProp = function (el, original) {\n            var location = $(el).prop('tagName').toLowerCase(),\n                translated = $.mage.__(original),\n                translationData = {\n                    shown: translated,\n                    translated: translated,\n                    original: original\n                },\n                translateAttr = composeTranslateAttr(translationData, location);\n\n            $(el).attr('data-translate', translateAttr);\n\n            setText(el, translationData.shown);\n        },\n\n        /**\n         * Checks if node represents ko virtual node (nodeType === 8, nodeName === '#comment').\n         *\n         * @param {HTMLElement} node\n         * @returns {Boolean}\n         */\n        isVirtualElement = function (node) {\n            return node.nodeType === 8;\n        },\n\n        /**\n        * Checks if it's real DOM element\n        * in case of virtual element, returns span wrapper\n        * @param {Object} el\n        * @param {bool} isUpdate\n        * @return {Object} el\n        */\n        getRealElement = function (el, isUpdate) {\n            if (isVirtualElement(el)) {\n                if (isUpdate) {\n                    return $(el).next('span');\n                }\n\n                return $('<span></span>').insertAfter(el);\n            }\n\n            return el;\n        },\n\n        /**\n         * execute i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         * @param {bool} isUpdate\n         */\n        execute = function (element, valueAccessor, isUpdate) {\n            var original = ko.unwrap(valueAccessor() || ''),\n                el = getRealElement(element, isUpdate),\n                inlineTranslation = (module.config() || {}).inlineTranslation;\n\n            if (inlineTranslation) {\n                setTranslateProp(el, original);\n            } else {\n                setText(el, $.mage.__(original));\n            }\n        };\n\n    /**\n     * i18n binding\n     * @property {Function}  init\n     * @property {Function}  update\n     */\n    ko.bindingHandlers.i18n = {\n\n        /**\n         * init i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            execute(element, valueAccessor);\n        },\n\n        /**\n         * update i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            execute(element, valueAccessor, true);\n        }\n    };\n\n    ko.virtualElements.allowedBindings.i18n = true;\n\n    renderer\n        .addNode('translate', {\n            binding: 'i18n'\n        })\n        .addAttribute('translate', {\n            binding: 'i18n'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var collapsible,\n        defaults;\n\n    defaults = {\n        closeOnOuter: true,\n        onTarget: false,\n        openClass: '_active',\n        as: '$collapsible'\n    };\n\n    collapsible = {\n\n        /**\n         * Sets 'opened' property to true.\n         */\n        open: function () {\n            this.opened(true);\n        },\n\n        /**\n         * Sets 'opened' property to false.\n         */\n        close: function () {\n            this.opened(false);\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         */\n        toggle: function () {\n            this.opened(!this.opened());\n        }\n    };\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element, closes collapsible model.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} model\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, model, e) {\n        var target = e.target;\n\n        if (target !== container && !container.contains(target)) {\n            model.close();\n        }\n    }\n\n    /**\n     * Creates 'css' binding which toggles\n     * class specified in 'name' parameter.\n     *\n     * @param {Object} model\n     * @param {String} name\n     * @returns {Object}\n     */\n    function getClassBinding(model, name) {\n        var binding = {};\n\n        binding[name] = model.opened;\n\n        return {\n            css: binding\n        };\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {Object} [options={}]\n     * @returns {Object} Complete instance configuration.\n     */\n    function buildConfig(options) {\n        if (typeof options !== 'object') {\n            options = {};\n        }\n\n        return _.extend({}, defaults, options);\n    }\n\n    ko.bindingHandlers.collapsible = {\n\n        /**\n         * Initializes 'collapsible' binding.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var $collapsible = Object.create(collapsible),\n                config = buildConfig(valueAccessor()),\n                outerClick,\n                bindings;\n\n            _.bindAll($collapsible, 'open', 'close', 'toggle');\n\n            $collapsible.opened = ko.observable(!!config.opened);\n\n            bindingCtx[config.as] = $collapsible;\n\n            if (config.closeOnOuter) {\n                outerClick = onOuterClick.bind(null, element, $collapsible);\n\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n\n            if (config.openClass) {\n                bindings = getClassBinding($collapsible, config.openClass);\n\n                ko.applyBindingsToNode(element, bindings, bindingCtx);\n            }\n\n            if (config.onTarget) {\n                $(element).on('click', $collapsible.toggle);\n            }\n\n            if (viewModel && _.isFunction(viewModel.on)) {\n                viewModel.on({\n                    close:          $collapsible.close,\n                    open:           $collapsible.open,\n                    toggleOpened:   $collapsible.toggle\n                });\n            }\n        }\n    };\n\n    ko.bindingHandlers.closeCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which closes associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.close);\n            }\n        }\n    };\n\n    ko.bindingHandlers.openCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which opens associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.open);\n            }\n        }\n    };\n\n    ko.bindingHandlers.toggleCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which toggles associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.toggle);\n            }\n        }\n    };\n\n    renderer\n        .addAttribute('collapsible')\n        .addAttribute('openCollapsible')\n        .addAttribute('closeCollapsible')\n        .addAttribute('toggleCollapsible');\n});\n","Magento_Ui/js/lib/knockout/bindings/after-render.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.afterRender = {\n\n        /**\n         * Binding init callback.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var callback = valueAccessor();\n\n            if (typeof callback === 'function') {\n                callback.call(viewModel, element, viewModel);\n            }\n        }\n    };\n\n    renderer.addAttribute('afterRender');\n});\n","Magento_Ui/js/lib/knockout/bindings/resizable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, async, registry, _, renderer) {\n    'use strict';\n\n    var sizeOptions = [\n            'minHeight',\n            'maxHeight',\n            'minWidth',\n            'maxWidth'\n        ],\n\n        handles = {\n            height: '.ui-resizable-s, .ui-resizable-n',\n            width: '.ui-resizable-w, .ui-resizable-e'\n        };\n\n    /**\n     * Recalcs visibility of handles, width and height of resizable based on content\n     * @param {HTMLElement} element\n     */\n    function adjustSize(element) {\n        var maxHeight,\n            maxWidth;\n\n        element = $(element);\n        maxHeight = element.resizable('option').maxHeight;\n        maxWidth = element.resizable('option').maxWidth;\n\n        if (maxHeight && element.height() > maxHeight) {\n            element.height(maxHeight + 1);\n            $(handles.height).hide();\n        } else {\n            $(handles.height).show();\n        }\n\n        if (maxWidth && element.width() > maxWidth) {\n            element.width(maxWidth + 1);\n            $(handles.width).hide();\n        } else {\n            $(handles.width).show();\n        }\n    }\n\n    /**\n     * Recalcs allowed min, max width and height based on configured selectors\n     * @param {Object} sizeConstraints\n     * @param {String} componentName\n     * @param {HTMLElement} element\n     * @param {Boolean} hasWidthUpdate\n     */\n    function recalcAllowedSize(sizeConstraints, componentName, element, hasWidthUpdate) {\n        var size;\n\n        element = $(element);\n\n        if (!element.data('resizable')) {\n            return;\n        }\n\n        if (!hasWidthUpdate) {\n            element.css('width', 'auto');\n        }\n\n        _.each(sizeConstraints, function (selector, key) {\n            async.async({\n                component: componentName,\n                selector: selector\n            }, function (elem) {\n                size = key.indexOf('Height') !== -1 ? $(elem).outerHeight(true) : $(elem).outerWidth(true);\n\n                if (element.data('resizable')) {\n                    element.resizable('option', key, size + 1);\n                }\n            });\n        }, this);\n\n        adjustSize(element);\n    }\n\n    /**\n     * Preprocess config to separate options,\n     * which must be processed further before applying\n     *\n     * @param {Object} config\n     * @param {Object} viewModel\n     * @param {*} element\n     * @return {Object} config\n     */\n    function processConfig(config, viewModel, element) {\n        var sizeConstraint,\n            sizeConstraints = {},\n            recalc,\n            hasWidthUpdate;\n\n        if (_.isEmpty(config)) {\n            return {};\n        }\n        _.each(sizeOptions, function (key) {\n            sizeConstraint = config[key];\n\n            if (sizeConstraint && !_.isNumber(sizeConstraint)) {\n                sizeConstraints[key] = sizeConstraint;\n                delete config[key];\n            }\n        });\n        hasWidthUpdate =  _.some(sizeConstraints, function (value, key) {\n            return key.indexOf('Width') !== -1;\n        });\n\n        recalc = recalcAllowedSize.bind(null, sizeConstraints, viewModel.name, element, hasWidthUpdate);\n        config.start = recalc;\n        $(window).on('resize.resizable', recalc);\n        registry.get(viewModel.provider).on('reloaded', recalc);\n\n        return config;\n    }\n\n    ko.bindingHandlers.resizable = {\n\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = processConfig(valueAccessor(), viewModel, element);\n\n            require(['jquery-ui-modules/resizable'], function () {\n                if ($.fn.resizable) {\n                    $(element).resizable(config);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('resizable');\n});\n","Magento_Ui/js/lib/knockout/bindings/datepicker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates datepicker binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (ko, _, $, $t) {\n    'use strict';\n\n    var defaults = {\n        dateFormat: 'mm\\/dd\\/yyyy',\n        showsTime: false,\n        timeFormat: null,\n        buttonImage: null,\n        buttonImageOnly: null,\n        buttonText: $t('Select Date')\n    };\n\n    ko.bindingHandlers.datepicker = {\n        /**\n         * Initializes calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * For more info about options take a look at \"mage/calendar\" and jquery.ui.datepicker widget.\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param {object} allBindings\n         * @param {object} viewModel\n         * @param {object} bindingContext\n         */\n        init: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var config = valueAccessor(),\n                observable,\n                options = {};\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['mage/calendar'], function () {\n                $(el).calendar(options);\n\n                ko.utils.registerEventHandler(el, 'change', function () {\n                    observable(this.value);\n                });\n            });\n\n            if (bindingContext.$data) {\n                bindingContext.$data.value.subscribe(function (newVal) {\n                    if (!newVal) {\n                        $(el).val('');\n                    }\n                }, this);\n            }\n\n\n        },\n\n        /**\n         * Update calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * @param {HTMLElement} element - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor(),\n                $element = $(element),\n                observable,\n                options = {},\n                newVal;\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['moment', 'mage/utils/misc', 'mage/calendar'], function (moment, utils) {\n                if (_.isEmpty(observable())) {\n                    newVal = null;\n                } else {\n                    newVal = moment(\n                        observable(),\n                        utils.convertToMomentFormat(\n                            options.dateFormat + (options.showsTime ? ' ' + options.timeFormat : '')\n                        )\n                    ).toDate();\n                }\n\n                if (!options.timeOnly) {\n                    $element.datepicker('setDate', newVal);\n                    $element.trigger('blur');\n                }\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/bound-nodes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/utils/wrapper',\n    'uiEvents'\n], function (ko, _, wrapper, Events) {\n    'use strict';\n\n    var nodesMap = new WeakMap();\n\n    /**\n     * Returns a array of nodes associated with a specified model.\n     *\n     * @param {Object} model\n     * @returns {Undefined|Array}\n     */\n    function getBounded(model) {\n        return nodesMap.get(model);\n    }\n\n    /**\n     * Removes specified node to models' associations list, if it's\n     * a root node (node is not a descendant of any previously added nodes).\n     * Triggers 'addNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function addBounded(model, node) {\n        var nodes = getBounded(model),\n            isRoot;\n\n        if (!nodes) {\n            nodesMap.set(model, [node]);\n\n            Events.trigger.call(model, 'addNode', node);\n\n            return;\n        }\n\n        isRoot = nodes.every(function (bounded) {\n            return !bounded.contains(node);\n        });\n\n        if (isRoot) {\n            nodes.push(node);\n\n            Events.trigger.call(model, 'addNode', node);\n        }\n    }\n\n    /**\n     * Removes specified node from models' associations list.\n     * Triggers 'removeNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function removeBounded(model, node) {\n        var nodes = getBounded(model),\n            index;\n\n        if (!nodes) {\n            return;\n        }\n\n        index = nodes.indexOf(node);\n\n        if (~index) {\n            nodes.splice(index, 0);\n\n            Events.trigger.call(model, 'removeNode', node);\n        }\n\n        if (!nodes.length) {\n            nodesMap.delete(model);\n        }\n    }\n\n    /**\n     * Returns node's first sibling of 'element' type within the common component scope\n     *\n     * @param {HTMLElement} node\n     * @param {*} data\n     * @returns {HTMLElement}\n     */\n    function getElement(node, data) {\n        var elem;\n\n        while (node.nextElementSibling) {\n            node = node.nextElementSibling;\n\n            if (node.nodeType === 1 && ko.dataFor(node) === data) {\n                elem = node;\n                break;\n            }\n        }\n\n        return elem;\n    }\n\n    wrapper.extend(ko, {\n\n        /**\n         * Extends knockouts' 'applyBindings'\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'applyBindings' method.\n         * @param {Object} ctx\n         * @param {HTMLElement} node - Original 'applyBindings' method.\n         */\n        applyBindings: function (orig, ctx, node) {\n            var result = orig(),\n                data = ctx && (ctx.$data || ctx);\n\n            if (node && node.nodeType === 8) {\n                node = getElement(node, data);\n            }\n\n            if (!node || node.nodeType !== 1) {\n                return result;\n            }\n\n            if (data && data.registerNodes) {\n                addBounded(data, node);\n            }\n\n            return result;\n        },\n\n        /**\n         * Extends knockouts' cleanNode\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'cleanNode' method.\n         * @param {HTMLElement} node - Original 'cleanNode' method.\n         */\n        cleanNode: function (orig, node) {\n            var result = orig(),\n                data;\n\n            if (node.nodeType !== 1) {\n                return result;\n            }\n\n            data = ko.dataFor(node);\n\n            if (data && data.registerNodes) {\n                removeBounded(data, node);\n            }\n\n            return result;\n        }\n    });\n\n    return {\n\n        /**\n         * Returns root nodes associated with a model. If callback is provided,\n         * will iterate through all of the present nodes triggering callback\n         * for each of it. Also it will subscribe to the 'addNode' event.\n         *\n         * @param {Object} model\n         * @param {Function} [callback]\n         * @returns {Array|Undefined}\n         */\n        get: function (model, callback) {\n            var nodes = getBounded(model) || [];\n\n            if (!_.isFunction(callback)) {\n                return nodes;\n            }\n\n            nodes.forEach(function (node) {\n                callback(node);\n            });\n\n            this.add.apply(this, arguments);\n        },\n\n        /**\n         * Subscribes to adding of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        add: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('addNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Subscribes to removal of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        remove: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('removeNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Removes subscriptions from the model.\n         *\n         * @param {Object} model\n         */\n        off: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            Events.off.apply(model, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/observable_array.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Iterator function.\n     *\n     * @param {String} callback\n     * @param {Array} args\n     * @param {Object} elem\n     * @returns {*}\n     */\n    function iterator(callback, args, elem) {\n        callback = elem[callback];\n\n        if (_.isFunction(callback)) {\n            return callback.apply(elem, args);\n        }\n\n        return callback;\n    }\n\n    /**\n     * Wrapper function.\n     *\n     * @param {String} method\n     * @returns {Function}\n     */\n    function wrapper(method) {\n        return function (iteratee) {\n            var callback = iteratee,\n                elems = this(),\n                args = _.toArray(arguments);\n\n            if (_.isString(iteratee)) {\n                callback = iterator.bind(null, iteratee, args.slice(1));\n\n                args.unshift(callback);\n            }\n\n            args.unshift(elems);\n\n            return _[method].apply(_, args);\n        };\n    }\n\n    _.extend(ko.observableArray.fn, {\n        each: wrapper('each'),\n\n        map: wrapper('map'),\n\n        filter: wrapper('filter'),\n\n        some: wrapper('some'),\n\n        every: wrapper('every'),\n\n        groupBy: wrapper('groupBy'),\n\n        sortBy: wrapper('sortBy'),\n\n        /**\n         * Wrapper for underscore findWhere function.\n         *\n         * @param {Object} properties\n         * @return {Object}\n         */\n        findWhere: function (properties) {\n            return _.findWhere(this(), properties);\n        },\n\n        /**\n         * Wrapper for underscore contains function.\n         *\n         * @param {*} value\n         * @return {Boolean}\n         */\n        contains: function (value) {\n            return _.contains(this(), value);\n        },\n\n        /**\n         * Inverse contains call.\n         *\n         * @return {Boolean}\n         */\n        hasNo: function () {\n            return !this.contains.apply(this, arguments);\n        },\n\n        /**\n         * Getter for length property.\n         *\n         * @return {Number}\n         */\n        getLength: function () {\n            return this().length;\n        },\n\n        /**\n         * Create object with keys that gets from each object property.\n         *\n         * @return {Object}\n         */\n        indexBy: function (key) {\n            return _.indexBy(this(), key);\n        },\n\n        /**\n         * Returns a copy of the array with all instances of the values removed.\n         *\n         * @return {Array}\n         */\n        without: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.without.apply(_, args);\n        },\n\n        /**\n         * Returns the first element of an array.\n         *\n         * @return {*}\n         */\n        first: function () {\n            return _.first(this());\n        },\n\n        /**\n         * Returns the last element of an array\n         *\n         * @return {*}\n         */\n        last: function () {\n            return _.last(this());\n        },\n\n        /**\n         * Iterate and pick provided properties.\n         *\n         * @return {Array}\n         */\n        pluck: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.pluck.apply(_, args);\n        }\n    });\n});\n","Magento_Ui/js/lib/validation/utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    var utils = {\n        /**\n         * Check if string is empty with trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || value == null || value.length === 0 || /^\\s+$/.test(value);\n        },\n\n        /**\n         * Check if string is empty no trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmptyNoTrim: function (value) {\n            return value === '' || value == null || value.length === 0;\n        },\n\n        /**\n         * Checks if {value} is between numbers {from} and {to}.\n         *\n         * @param {String} value\n         * @param {String} from\n         * @param {String} to\n         * @return {Boolean}\n         */\n        isBetween: function (value, from, to) {\n            return (from === null || from === '' || value >= utils.parseNumber(from)) &&\n                   (to === null || to === '' || value <= utils.parseNumber(to));\n        },\n\n        /**\n         * Parse price string.\n         *\n         * @param {String} value\n         * @return {Number}\n         */\n        parseNumber: function (value) {\n            var isDot, isComa;\n\n            if (typeof value !== 'string') {\n                return parseFloat(value);\n            }\n            isDot = value.indexOf('.');\n            isComa = value.indexOf(',');\n\n            if (isDot !== -1 && isComa !== -1) {\n                if (isComa > isDot) {\n                    value = value.replace('.', '').replace(',', '.');\n                } else {\n                    value = value.replace(',', '');\n                }\n            } else if (isComa !== -1) {\n                value = value.replace(',', '.');\n            }\n\n            return parseFloat(value);\n        },\n\n        /**\n         * Removes HTML tags and space characters, numbers and punctuation.\n         *\n         * @param {String} value -  Value being stripped.\n         * @return {String}\n         */\n        stripHtml: function (value) {\n            return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n        }\n    };\n\n    return utils;\n});\n","Magento_Ui/js/lib/validation/validator.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './rules'\n], function (_, rulesList) {\n    'use strict';\n\n    /**\n     * Validates provided value be the specified rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {*} value - Value to be checked.\n     * @param {*} [params]\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validate(id, value, params, additionalParams) {\n        var rule,\n            message,\n            valid,\n            result = {\n                rule: id,\n                passed: true,\n                message: ''\n            };\n\n        if (_.isObject(params)) {\n            message = params.message || '';\n        }\n\n        if (!rulesList[id]) {\n            return result;\n        }\n\n        rule    = rulesList[id];\n        message = message || rule.message;\n        valid   = rule.handler(value, params, additionalParams);\n\n        if (!valid) {\n            params = Array.isArray(params) ?\n                params :\n                [params];\n\n            if (typeof message === 'function') {\n                message = message.call(rule);\n            }\n\n            message = params.reduce(function (msg, param, idx) {\n                return msg.replace(new RegExp('\\\\{' + idx + '\\\\}', 'g'), param);\n            }, message);\n\n            result.passed = false;\n            result.message = message;\n        }\n\n        return result;\n    }\n\n    /**\n     * Validates provided value by a specified set of rules.\n     *\n     * @param {(String|Object)} rules - One or many validation rules.\n     * @param {*} value - Value to be checked.\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validator(rules, value, additionalParams) {\n        var result;\n\n        if (typeof rules === 'object') {\n            result = {\n                passed: true\n            };\n\n            _.every(rules, function (ruleParams, id) {\n                if (ruleParams.validate || ruleParams !== false || additionalParams) {\n                    result = validate(id, value, ruleParams, additionalParams);\n\n                    return result.passed;\n                }\n\n                return true;\n            });\n\n            return result;\n        }\n\n        return validate.apply(null, arguments);\n    }\n\n    /**\n     * Adds new validation rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {Function} handler - Validation function.\n     * @param {String} message - Error message.\n     */\n    validator.addRule = function (id, handler, message) {\n        rulesList[id] = {\n            handler: handler,\n            message: message\n        };\n    };\n\n    /**\n     * Returns rule object found by provided identifier.\n     *\n     * @param {String} id - Rule identifier.\n     * @returns {Object}\n     */\n    validator.getRule = function (id) {\n        return rulesList[id];\n    };\n\n    return validator;\n});\n","Magento_Ui/js/lib/validation/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    './utils',\n    'moment',\n    'tinycolor',\n    'jquery/validate',\n    'mage/translate'\n], function ($, _, utils, moment, tinycolor) {\n    'use strict';\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    return _.mapObject({\n        'min_text_length': [\n            function (value, params) {\n                return _.isUndefined(value) || value.length === 0 || value.length >= +params;\n            },\n            $.mage.__('Please enter more or equal than {0} symbols.')\n        ],\n        'max_text_length': [\n            function (value, params) {\n                return !_.isUndefined(value) && value.length <= +params;\n            },\n            $.mage.__('Please enter less or equal than {0} symbols.')\n        ],\n        'max-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, params) {\n                var match = utils.stripHtml(value).match(/\\b\\w+\\b/g) || [];\n\n                return utils.isEmpty(value) || match.length >= params[0] &&\n                    match.length <= params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z\\-.,()\\u0027\\u0022\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value) {\n                return !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value) {\n                return utils.isEmpty(value) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value) {\n                return utils.isEmpty(value) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (value) {\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (value.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv,//eslint-disable-line vars-on-top\n                    LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],//eslint-disable-line max-len\n                    VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9],\n                    FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2],\n                    rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = value.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {//eslint-disable-line max-depth\n                            if (d.toUpperCase() === LL[n]) {//eslint-disable-line max-depth\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {//eslint-disable-line max-depth\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value) {\n                return /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            $.mage.__('Vul hier een geldige datum in.')\n        ],\n        'time': [\n            function (value) {\n                return utils.isEmpty(value) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value) {\n                return utils.isEmpty(value) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (value) {\n                value = value.replace(/\\s+/g, '');\n\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 && value.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, param) {\n                return _.isUndefined(value) || value.length === 0 || utils.stripHtml(value).length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n        'email2': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\u0022)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\u0022)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value) {\n                return utils.isEmpty(value) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.url\n        ],\n        'credit-card-types': [\n            function (value, param) {\n                var validTypes;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'ipv4': [\n            function (value) {\n                return utils.isEmpty(value) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n        'pattern': [\n            function (value, param) {\n                return utils.isEmpty(value) || new RegExp(param).test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9 ]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[\\S ]+$/.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(value) || !/[0-9]/.test(value)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = v.trim(),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets);//eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = (value || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(value);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (value) {\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/,\n                    d;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                if (utils.isEmpty(value) || !regex.test(value)) {\n                    return false;\n                }\n                d = new Date(value.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value > 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number greater than 0, without comma in this field.')\n        ],\n        'validate-css-length': [\n            function (value) {\n                if (value !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        'validate-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    !isNaN(utils.parseNumber(value)) &&\n                    /^\\s*-?\\d*(?:[.,|'|\\s]\\d+)*(?:[.,|'|\\s]\\d{2})?-?\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-integer': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid integer in this field.')\n        ],\n        'validate-number-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-positive-percent-decimal': [\n            function (value) {\n                var numValue;\n\n                if (utils.isEmptyNoTrim(value) || !/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(value)) {\n                    return false;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                return utils.isBetween(numValue, 0.01, 100);\n            },\n            $.mage.__('Please enter a valid percentage discount value greater than 0.')\n        ],\n        'validate-digits': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !/[^\\d]/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-digits-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-range': [\n            function (value) {\n                var minValue, maxValue, ranges;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](value)) {\n                    minValue = maxValue = utils.parseNumber(value);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(value);\n\n                    if (ranges) {\n                        minValue = utils.parseNumber(ranges[1]);\n                        maxValue = utils.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) {//eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z]+$/.test(value);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z]+[a-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only lowercase letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.')//eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, additionalParams.dateFormat);\n\n                return utils.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n        ],\n        'validate-date-range': [\n            function (value, params) {\n                var fromDate = $('input[name*=\"' + params + '\"]').val();\n\n                return moment.utc(value).unix() >= moment.utc(fromDate).unix() || isNaN(moment.utc(value).unix());\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(value);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").')//eslint-disable-line max-len\n        ],\n        'validate-trailing-hyphen': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(?!-)(?!.*-$).+$/.test(value);\n            },\n            $.mage.__('Trailing hyphens are not allowed.')\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n            // @TODO: Cleanup\n            return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n            }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-state': [\n            function (value) {\n                return value !== 0;\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'less-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.lteToVal = params;\n\n                    return value <= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value less than or equal to %s.').replace('%s', this.lteToVal);\n            }\n        ],\n        'greater-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.gteToVal = params;\n\n                    return value >= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value greater than or equal to %s.').replace('%s', this.gteToVal);\n            }\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^[a-z0-9\\._-]{1,30}@([a-z0-9_-]{1,30}\\.){1,5}[a-z]{2,4}$/i;\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].strip())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.')//eslint-disable-line max-len\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {String} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {String} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'required-entry': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'checked': [\n            function (value) {\n                return value;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (value) {\n                if (value.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (value) {\n                var isValid = true,\n                    values = value.split(','),\n                    i;\n\n                if (utils.isEmpty(value)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-new-password': [\n            function (value) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](value)) {\n                    return false;\n                }\n\n                if (utils.isEmpty(value) && value !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-item-quantity': [\n            function (value, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = utils.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= utils.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= utils.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        qty % utils.parseNumber(params.qtyIncrements) === 0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'equalTo': [\n            function (value, param) {\n                return value === $(param).val();\n            },\n            $.validator.messages.equalTo\n        ],\n        'validate-file-type': [\n            function (name, types) {\n                var extension = name.split('.').pop().toLowerCase();\n\n                if (types && typeof types === 'string') {\n                    types = types.split(' ');\n                }\n\n                return !types || !types.length || ~types.indexOf(extension);\n            },\n            $.mage.__('We don\\'t recognize or support this file extension type.')\n        ],\n        'validate-max-size': [\n            function (size, maxSize) {\n                return maxSize === false || size < maxSize;\n            },\n            $.mage.__('File you are trying to upload exceeds maximum file size limit.')\n        ],\n        'validate-if-tag-script-exist': [\n            function (value) {\n                return !value || (/<script\\b[^>]*>([\\s\\S]*?)<\\/script>$/ig).test(value);\n            },\n            $.mage.__('Please use tag SCRIPT with SRC attribute or with proper content to include JavaScript to the document.')//eslint-disable-line max-len\n        ],\n        'date_range_min': [\n            function (value, minValue, params) {\n                return moment.utc(value, params.dateFormat).unix() >= minValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'date_range_max': [\n            function (value, maxValue, params) {\n                return moment.utc(value, params.dateFormat).unix() <= maxValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'validate-color': [\n            function (value) {\n                if (value === '') {\n                    return true;\n                }\n\n                return tinycolor(value).isValid();\n            },\n            $.mage.__('Wrong color format. Please specify color in HEX, RGBa, HSVa, HSLa or use color name.')\n        ],\n        'blacklist-url': [\n            function (value, param) {\n                return new RegExp(param).test(value);\n            },\n            $.mage.__('This link is not allowed.')\n        ],\n        'validate-dob': [\n            function (value, param, params) {\n                if (value === '') {\n                    return true;\n                }\n\n                return moment.utc(value, params.dateFormat).isSameOrBefore(moment.utc());\n            },\n            $.mage.__('The Date of Birth should not be greater than today.')\n        ],\n        'validate-no-utf8mb4-characters': [\n            function (value) {\n                var validator = this,\n                    message = $.mage.__('Please remove invalid characters: {0}.'),\n                    matches = value.match(/(?:[\\uD800-\\uDBFF][\\uDC00-\\uDFFF])/g),\n                    result = matches === null;\n\n                if (!result) {\n                    validator.charErrorMessage = message.replace('{0}', matches.join());\n                }\n\n                return result;\n            }, function () {\n                return this.charErrorMessage;\n            }\n        ]\n    }, function (data) {\n        return {\n            handler: data[0],\n            message: data[1]\n        };\n    });\n});\n","Magento_Ui/js/core/app.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './renderer/types',\n    './renderer/layout',\n    '../lib/knockout/bootstrap'\n], function (types, layout) {\n    'use strict';\n\n    return function (data, merge) {\n        types.set(data.types);\n        layout(data.components, undefined, true, merge);\n    };\n});\n","Magento_Ui/js/core/renderer/layout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiRegistry',\n    './types',\n    '../../lib/logger/console-logger'\n], function (_, $, utils, registry, types, consoleLogger) {\n    'use strict';\n\n    var templates = registry.create(),\n        layout = {},\n        cachedConfig = {};\n\n    /**\n     * Build name from parent name and node name\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @param {String} [name]\n     * @returns {String}\n     */\n    function getNodeName(parent, node, name) {\n        var parentName = parent && parent.name;\n\n        if (typeof name !== 'string') {\n            name = node.name || name;\n        }\n\n        return utils.fullPath(parentName, name);\n    }\n\n    /**\n     * Get node type from node or parent.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getNodeType(parent, node) {\n        return node.type || parent && parent.childType;\n    }\n\n    /**\n     * Get data scope based on parent data scope and node data scope.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getDataScope(parent, node) {\n        var dataScope = node.dataScope,\n            parentScope = parent && parent.dataScope;\n\n        return !utils.isEmpty(parentScope) ?\n            !utils.isEmpty(dataScope) ?\n                parentScope + '.' + dataScope :\n                parentScope :\n            dataScope || '';\n    }\n\n    /**\n     * Load node dependencies on other instances.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadDeps(node) {\n        var loaded = $.Deferred(),\n            loggerUtils = consoleLogger.utils;\n\n        if (node.deps) {\n            consoleLogger.utils.asyncLog(\n                loaded,\n                {\n                    data: {\n                        component: node.name,\n                        deps: node.deps\n                    },\n                    messages: loggerUtils.createMessages(\n                        'depsStartRequesting',\n                        'depsFinishRequesting',\n                        'depsLoadingFail'\n                    )\n                }\n            );\n        }\n\n        registry.get(node.deps, function (deps) {\n            node.provider = node.extendProvider ? deps && deps.name : node.provider;\n            loaded.resolve(node);\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Load node component file via requirejs.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadSource(node) {\n        var loaded = $.Deferred(),\n            source = node.component;\n\n        consoleLogger.info('componentStartLoading', {\n            component: node.component\n        });\n\n        require([source], function (constr) {\n            consoleLogger.info('componentFinishLoading', {\n                component: node.component\n            });\n            loaded.resolve(node, constr);\n        }, function () {\n            consoleLogger.error('componentLoadingFail', {\n                component: node.component\n            });\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Create a new component instance and set it to the registry.\n     *\n     * @param {Object} node\n     * @param {Function} Constr\n     */\n    function initComponent(node, Constr) {\n        var component = new Constr(_.omit(node, 'children'));\n\n        consoleLogger.info('componentStartInitialization', {\n            component: node.component,\n            componentName: node.name\n        });\n\n        registry.set(node.name, component);\n    }\n\n    /**\n     * Application entry point.\n     *\n     * @param {Object} nodes\n     * @param {Object} parent\n     * @param {Boolean} cached\n     * @param {Boolean} merge\n     * @returns {Boolean|undefined}\n     */\n    function run(nodes, parent, cached, merge) {\n        if (_.isBoolean(merge) && merge) {\n            layout.merge(nodes);\n\n            return false;\n        }\n\n        if (cached) {\n            cachedConfig[_.keys(nodes)[0]] = JSON.parse(JSON.stringify(nodes));\n        }\n\n        _.each(nodes || [], layout.iterator.bind(layout, parent));\n    }\n\n    _.extend(layout, {\n        /**\n         * Determines if node ready to be added or process it.\n         *\n         * @param {Object} parent\n         * @param {Object|String} node\n         */\n        iterator: function (parent, node) {\n            var action = _.isString(node) ?\n                this.addChild :\n                this.process;\n\n            action.apply(this, arguments);\n        },\n\n        /**\n         * Prepare component.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        process: function (parent, node, name) {\n            if (!parent && node.parent) {\n                return this.waitParent(node, name);\n            }\n\n            if (node.nodeTemplate) {\n                return this.waitTemplate.apply(this, arguments);\n            }\n\n            node = this.build.apply(this, arguments);\n\n            if (!registry.has(node.name)) {\n                this.addChild(parent, node)\n                    .manipulate(node)\n                    .initComponent(node);\n            }\n\n            if (node) {\n                run(node.children, node);\n            }\n\n            return this;\n        },\n\n        /**\n         * Detailed processing of component config.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Boolean|Object}\n         */\n        build: function (parent, node, name) {\n            var defaults    = parent && parent.childDefaults || {},\n                children    = this.filterDisabledChildren(node.children),\n                type        = getNodeType(parent, node),\n                dataScope   = getDataScope(parent, node),\n                component,\n                extendDeps  = true,\n                nodeName;\n\n            node.children = false;\n            node.extendProvider = true;\n\n            if (node.config && node.config.provider || node.provider) {\n                node.extendProvider = false;\n            }\n\n            if (node.config && node.config.deps || node.deps) {\n                extendDeps = false;\n            }\n\n            node = utils.extend({\n            }, types.get(type), defaults, node);\n\n            nodeName = getNodeName(parent, node, name);\n\n            if (registry.has(nodeName)) {\n                component = registry.get(nodeName);\n                component.children = children;\n\n                return component;\n            }\n\n            if (extendDeps && parent && parent.deps && type) {\n                node.deps = parent.deps;\n            }\n\n            _.extend(node, node.config || {}, {\n                index: node.name || name,\n                name: nodeName,\n                dataScope: dataScope,\n                parentName: utils.getPart(nodeName, -2),\n                parentScope: utils.getPart(dataScope, -2)\n            });\n\n            node.children = children;\n            node.componentType = node.type;\n\n            delete node.type;\n            delete node.config;\n\n            if (children) {\n                node.initChildCount = _.size(children);\n            }\n\n            if (node.isTemplate) {\n                node.isTemplate = false;\n\n                templates.set(node.name, node);\n                registry.get(node.parentName, function (parentComp) {\n                    parentComp.childTemplate = node;\n                });\n\n                return false;\n            }\n\n            if (node.componentDisabled === true) {\n                return false;\n            }\n\n            return node;\n        },\n\n        /**\n         * Filter out all disabled components.\n         *\n         * @param {Object} children\n         * @returns {*}\n         */\n        filterDisabledChildren: function (children) {\n            var cIds;\n\n            //cleanup children config.componentDisabled = true\n            if (children && typeof children === 'object') {\n                cIds = Object.keys(children);\n\n                if (cIds) {\n                    _.each(cIds, function (cId) {\n                        if (typeof children[cId] === 'object' &&\n                            children[cId].hasOwnProperty('config') &&\n                            typeof children[cId].config === 'object' &&\n                            children[cId].config.hasOwnProperty('componentDisabled') &&\n                            children[cId].config.componentDisabled === true) {\n                            delete children[cId];\n                        }\n                    });\n                }\n            }\n\n            return children;\n        },\n\n        /**\n         * Init component.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        initComponent: function (node) {\n            if (!node.component) {\n                return this;\n            }\n\n            loadDeps(node)\n                .then(loadSource)\n                .done(initComponent);\n\n            return this;\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Loading component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @returns {Object}\n         */\n        waitTemplate: function (parent, node) {\n            var args = _.toArray(arguments);\n\n            templates.get(node.nodeTemplate, function () {\n                this.applyTemplate.apply(this, args);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Waiting for parent component and process provided component.\n         *\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        waitParent: function (node, name) {\n            var process = this.process.bind(this);\n\n            registry.get(node.parent, function (parent) {\n                process(parent, node, name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Processing component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         */\n        applyTemplate: function (parent, node, name) {\n            var template = templates.get(node.nodeTemplate);\n\n            node = utils.extend({}, template, node);\n\n            delete node.nodeTemplate;\n\n            this.process(parent, node, name);\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Determines inserting strategy.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        manipulate: function (node) {\n            var name = node.name;\n\n            if (node.appendTo) {\n                this.insert(name, node.appendTo, -1);\n            }\n\n            if (node.prependTo) {\n                this.insert(name, node.prependTo, 0);\n            }\n\n            if (node.insertTo) {\n                this.insertTo(name, node.insertTo);\n            }\n\n            return this;\n        },\n\n        /**\n         * Insert component to provide target and position.\n         *\n         * @param {Object|String} item\n         * @param {Object} target\n         * @param {Number} position\n         * @returns {Object}\n         */\n        insert: function (item, target, position) {\n            registry.get(target, function (container) {\n                container.insertChild(item, position);\n            });\n\n            return this;\n        },\n\n        /**\n         * Insert component into multiple targets.\n         *\n         * @param {Object} item\n         * @param {Array} targets\n         * @returns {Object}\n         */\n        insertTo: function (item, targets) {\n            _.each(targets, function (info, target) {\n                this.insert(item, target, info.position);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Add provided child to parent.\n         *\n         * @param {Object} parent\n         * @param {Object|String} child\n         * @returns {Object}\n         */\n        addChild: function (parent, child) {\n            var name;\n\n            if (parent && parent.component) {\n                name = child.name || child;\n\n                this.insert(name, parent.name, child.sortOrder);\n            }\n\n            return this;\n        },\n\n        /**\n         * Merge components configuration with cached configuration.\n         *\n         * @param {Array} components\n         */\n        merge: function (components) {\n            var cachedKey = _.keys(components)[0],\n                compared = utils.compare(cachedConfig[cachedKey], components),\n                remove = this.filterComponents(this.getByProperty(compared.changes, 'type', 'remove'), true),\n                update = this.getByProperty(compared.changes, 'type', 'update'),\n                dataSources = this.getDataSources(components),\n                names, index, name, component;\n\n            _.each(dataSources, function (val, key) {\n                name = key.replace(/\\.children|\\.config/g, '');\n                component = registry.get(name);\n\n                component.cacheData();\n                component.updateConfig(\n                    true,\n                    this.getFullConfig(key, components),\n                    this.getFullConfig(key, cachedConfig[cachedKey])\n                );\n            }, this);\n\n            _.each(remove, function (val) {\n                component = registry.get(val.path);\n\n                if (component) {\n                    component.destroy();\n                }\n            });\n\n            update = _.compact(_.filter(update, function (val) {\n                return !_.isEqual(val.oldValue, val.value);\n            }));\n\n            _.each(update, function (val) {\n                names = val.path.split('.');\n                index = Math.max(_.lastIndexOf(names, 'config'), _.lastIndexOf(names, 'children') + 2);\n                name = _.without(names.splice(0, index), 'children', 'config').join('.');\n                component = registry.get(name);\n\n                if (val.name === 'sortOrder' && component) {\n                    registry.get(component.parentName).insertChild(component, val.value);\n                } else if (component) {\n                    component.updateConfig(\n                        val.oldValue,\n                        val.value,\n                        val.path\n                    );\n                }\n            }, this);\n\n            run(components, undefined, true);\n        },\n\n        /**\n         * Recursive dataSource assignment.\n         *\n         * @param {Object} config\n         * @param {String} parentPath\n         * @returns {Object}\n         */\n        getDataSources: function (config, parentPath) {\n            var dataSources = {},\n                key, obj;\n\n            /* eslint-disable no-loop-func, max-depth */\n            for (key in config) {\n                if (config.hasOwnProperty(key)) {\n                    if (\n                        key === 'type' &&\n                        config[key] === 'dataSource' &&\n                        config.hasOwnProperty('config')\n                    ) {\n                        dataSources[parentPath + '.config'] = config.config;\n                    } else if (_.isObject(config[key])) {\n                        obj = this.getDataSources(config[key], utils.fullPath(parentPath, key));\n\n                        _.each(obj, function (value, path) {\n                            dataSources[path] = value;\n                        });\n                    }\n                }\n            }\n\n            /* eslint-enable no-loop-func, max-depth */\n\n            return dataSources;\n        },\n\n        /**\n         * Configuration getter.\n         *\n         * @param {String} path\n         * @param {Object} config\n         * @returns {Boolean|Object}\n         */\n        getFullConfig: function (path, config) {\n            var index;\n\n            path = path.split('.');\n            index = _.lastIndexOf(path, 'config');\n\n            if (!~index) {\n                return false;\n            }\n            path = path.splice(0, index);\n\n            _.each(path, function (val) {\n                config = config[val];\n            });\n\n            return config.config;\n        },\n\n        /**\n         * Filter data by property and value.\n         *\n         * @param {Object} data\n         * @param {String} prop\n         * @param {*} propValue\n         */\n        getByProperty: function (data, prop, propValue) {\n            return _.filter(data, function (value) {\n                return value[prop] === propValue;\n            });\n        },\n\n        /**\n         * Filter components.\n         *\n         * @param {Array} data\n         * @param {Boolean} splitPath\n         * @param {Number} index\n         * @param {String} separator\n         * @param {String} keyName\n         * @returns {Array}\n         */\n        filterComponents: function (data, splitPath, index, separator, keyName) {\n            var result = [],\n                names, length;\n\n            index = -2;\n            separator = '.' || separator;\n            keyName = 'children' || keyName;\n\n            _.each(data, function (val) {\n                names = val.path.split(separator);\n                length  = names.length;\n\n                if (names[length + index] === keyName) {\n                    val.path = splitPath ? _.without(names, keyName).join(separator) : val.path;\n                    result.push(val);\n                }\n            });\n\n            return result;\n        }\n    });\n\n    return run;\n});\n","Magento_Ui/js/core/renderer/types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils'\n], function (_, utils) {\n    'use strict';\n\n    var store = {};\n\n    /**\n     * Flatten a nested data.\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function flatten(data) {\n        var extender = data.extends || [],\n            result = {};\n\n        extender = utils.stringToArray(extender);\n\n        extender.push(data);\n\n        extender.forEach(function (item) {\n            if (_.isString(item)) {\n                item = store[item] || {};\n            }\n\n            utils.extend(result, item);\n        });\n\n        delete result.extends;\n\n        return result;\n    }\n\n    return {\n        /**\n         * Set types to store object.\n         *\n         * @param {Object} types\n         */\n        set: function (types) {\n            types = types || {};\n\n            utils.extend(store, types);\n\n            _.each(types, function (data, type) {\n                store[type] = flatten(data);\n            });\n        },\n\n        /**\n         * Get type from store object.\n         *\n         * @param {String} type\n         * @returns {*|{}}\n         */\n        get: function (type) {\n            return store[type] || {};\n        }\n    };\n});\n","Magento_Ui/js/timeline/timeline-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, raf, registry, Class) {\n    'use strict';\n\n    var hasClassList = (function () {\n        var list = document.createElement('_').classList;\n\n        return !!list && !list.toggle('_test', false);\n    })();\n\n    /**\n     * Polyfill of the 'classList.toggle' method.\n     *\n     * @param {HTMLElement} elem\n     */\n    function toggleClass(elem) {\n        var classList   = elem.classList,\n            args        = Array.prototype.slice.call(arguments, 1),\n            $elem;\n\n        if (hasClassList) {\n            classList.toggle.apply(classList, args);\n        } else {\n            $elem = $(elem);\n            $elem.toggleClass.apply($elem, args);\n        }\n    }\n\n    return Class.extend({\n        defaults: {\n            selectors: {\n                content: '.timeline-content',\n                timeUnit: '.timeline-unit',\n                item: '.timeline-item:not([data-role=no-data-msg])',\n                event: '.timeline-event'\n            }\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                'initContent',\n                'initItem',\n                'initTimeUnit',\n                'getItemBindings',\n                'updateItemsPosition',\n                'onScaleChange',\n                'onEventElementRender',\n                'onWindowResize',\n                'onContentScroll',\n                'onDataReloaded',\n                'onToStartClick',\n                'onToEndClick'\n            );\n\n            this._super()\n                .initModel()\n                .waitContent();\n\n            return this;\n        },\n\n        /**\n         * Applies listeners for the model properties changes.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initModel: function () {\n            var model = registry.get(this.model);\n\n            model.on('scale', this.onScaleChange);\n            model.source.on('reloaded', this.onDataReloaded);\n\n            this.model = model;\n\n            return this;\n        },\n\n        /**\n         * Applies DOM watcher for the\n         * content element rendering.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        waitContent: function () {\n            $.async({\n                selector: this.selectors.content,\n                component: this.model\n            }, this.initContent);\n\n            return this;\n        },\n\n        /**\n         * Initializes timelines' content element.\n         *\n         * @param {HTMLElement} content\n         * @returns {TimelineView} Chainable.\n         */\n        initContent: function (content) {\n            this.$content = content;\n\n            $(content).on('scroll', this.onContentScroll);\n            $(window).on('resize', this.onWindowResize);\n\n            $.async(this.selectors.item, content, this.initItem);\n            $.async(this.selectors.event, content, this.onEventElementRender);\n            $.async(this.selectors.timeUnit, content, this.initTimeUnit);\n\n            this.refresh();\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline item element,\n         * e.g. establishes event listeners and applies data bindings.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initItem: function (elem) {\n            $(elem)\n                .bindings(this.getItemBindings)\n                .on('click', '._toend', this.onToEndClick)\n                .on('click', '._tostart', this.onToStartClick);\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline unit element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initTimeUnit: function (elem) {\n            $(elem).bindings(this.getTimeUnitBindings());\n\n            return this;\n        },\n\n        /**\n         * Updates items positions in a\n         * loop if state of a view has changed.\n         */\n        refresh: function () {\n            raf(this.refresh);\n\n            if (this._update) {\n                this._update = false;\n\n                this.updateItemsPosition();\n            }\n        },\n\n        /**\n         * Returns object width additional bindings\n         * for a timeline unit element.\n         *\n         * @returns {Object}\n         */\n        getTimeUnitBindings: function () {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getTimeUnitWidth() + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Returns object with additional\n         * bindings for a timeline item element.\n         *\n         * @param {Object} ctx\n         * @returns {Object}\n         */\n        getItemBindings: function (ctx) {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getItemWidth(ctx.$row()) + '%';\n                    }.bind(this)),\n\n                    'margin-left': ko.computed(function () {\n                        return this.getItemMargin(ctx.$row()) + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Calculates width in percents of a timeline unit element.\n         *\n         * @returns {Number}\n         */\n        getTimeUnitWidth: function () {\n            return 100 / this.model.scale;\n        },\n\n        /**\n         * Calculates width of a record in percents.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemWidth: function (record) {\n            var days = 0;\n\n            if (record) {\n                days = this.model.getDaysLength(record);\n            }\n\n            return this.getTimeUnitWidth()  * days;\n        },\n\n        /**\n         * Calculates left margin value for provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemMargin: function (record) {\n            var offset = 0;\n\n            if (record) {\n                offset = this.model.getStartDelta(record);\n            }\n\n            return this.getTimeUnitWidth() * offset;\n        },\n\n        /**\n         * Returns collection of currently available\n         * timeline item elements.\n         *\n         * @returns {Array<HTMLElement>}\n         */\n        getItems: function () {\n            var items = this.$content.querySelectorAll(this.selectors.item);\n\n            return _.toArray(items);\n        },\n\n        /**\n         * Updates positions of timeline elements.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        updateItemsPosition: function () {\n            this.getItems()\n                .forEach(this.updatePositionFor, this);\n\n            return this;\n        },\n\n        /**\n         * Updates position of provided timeline element.\n         *\n         * @param {HTMLElement} $elem\n         * @returns {TimelineView} Chainable.\n         */\n        updatePositionFor: function ($elem) {\n            var $event      = $elem.querySelector(this.selectors.event),\n                leftEdge    = this.getLeftEdgeFor($elem),\n                rightEdge   = this.getRightEdgeFor($elem);\n\n            if ($event) {\n                $event.style.left = Math.max(-leftEdge, 0) + 'px';\n                $event.style.right = Math.max(rightEdge, 0) + 'px';\n            }\n\n            toggleClass($elem, '_scroll-start', leftEdge < 0);\n            toggleClass($elem, '_scroll-end', rightEdge > 0);\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the start of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toStartOf: function (elem) {\n            var leftEdge = this.getLeftEdgeFor(elem);\n\n            this.$content.scrollLeft += leftEdge;\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the end of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toEndOf: function (elem) {\n            var rightEdge = this.getRightEdgeFor(elem);\n\n            this.$content.scrollLeft += rightEdge + 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates location of the left edge of an element\n         * relative to the contents' left edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getLeftEdgeFor: function (elem) {\n            var leftOffset = elem.getBoundingClientRect().left;\n\n            return leftOffset - this.$content.getBoundingClientRect().left;\n        },\n\n        /**\n         * Calculates location of the right edge of an element\n         * relative to the contents' right edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getRightEdgeFor: function (elem) {\n            var elemWidth   = elem.offsetWidth,\n                leftEdge    = this.getLeftEdgeFor(elem);\n\n            return leftEdge + elemWidth - this.$content.offsetWidth;\n        },\n\n        /**\n         * 'To Start' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToStartClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toStartOf(elem);\n        },\n\n        /**\n         * 'To End' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToEndClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toEndOf(elem);\n        },\n\n        /**\n         * Handler of the scale value 'change' event.\n         */\n        onScaleChange: function () {\n            this._update = true;\n        },\n\n        /**\n         * Callback function which is invoked\n         * when event element was rendered.\n         */\n        onEventElementRender: function () {\n            this._update = true;\n        },\n\n        /**\n         * Window 'resize' event handler.\n         */\n        onWindowResize: function () {\n            this._update = true;\n        },\n\n        /**\n         * Content container 'scroll' event handler.\n         */\n        onContentScroll: function () {\n            this._update = true;\n        },\n\n        /**\n         * Data 'reload' event handler.\n         */\n        onDataReloaded: function () {\n            this._update = true;\n        }\n    });\n});\n","Magento_Ui/js/timeline/timeline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'moment',\n    'uiLayout',\n    'Magento_Ui/js/grid/listing'\n], function (_, moment, layout, Listing) {\n    'use strict';\n\n    var ONE_DAY = 86400000;\n\n    return Listing.extend({\n        defaults: {\n            recordTmpl: 'ui/timeline/record',\n            dateFormat: 'YYYY-MM-DD HH:mm:ss',\n            headerFormat: 'ddd MM/DD',\n            detailsFormat: 'DD/MM/YYYY HH:mm:ss',\n            scale: 7,\n            scaleStep: 1,\n            minScale: 7,\n            maxScale: 28,\n            minDays: 28,\n            displayMode: 'timeline',\n            displayModes: {\n                timeline: {\n                    label: 'Timeline',\n                    value: 'timeline',\n                    template: 'ui/timeline/timeline'\n                }\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/timeline/timeline-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }'\n            },\n            tracks: {\n                scale: true\n            },\n            statefull: {\n                scale: true\n            },\n            range: {}\n        },\n\n        /**\n         * Initializes Timeline component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initView()\n                .updateRange();\n\n            return this;\n        },\n\n        /**\n         * Initializes components configuration.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.maxScale = Math.min(this.minDays, this.maxScale);\n            this.minScale = Math.min(this.maxScale, this.minScale);\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe.call(this.range, true, 'hasToday');\n\n            return this;\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided event record is active,\n         * i.e. it has already started.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isActive: function (record) {\n            return Number(record.status) === 1;\n        },\n\n        /**\n         * Checks if provided event record is upcoming,\n         * i.e. it will start later on.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isUpcoming: function (record) {\n            return Number(record.status) === 2;\n        },\n\n        /**\n         * Checks if provided event record is permanent,\n         * i.e. it has no ending time.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isPermanent: function (record) {\n            return !this.getEndDate(record);\n        },\n\n        /**\n         * Checks if provided date indicates current day.\n         *\n         * @param {(Number|Moment)} date\n         * @returns {Boolenan}\n         */\n        isToday: function (date) {\n            return moment().isSame(date, 'day');\n        },\n\n        /**\n         * Checks if range object contains todays date.\n         *\n         * @returns {Boolean}\n         */\n        hasToday: function () {\n            return this.range.hasToday;\n        },\n\n        /**\n         * Returns start date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getStartDate: function (record) {\n            return record['start_time'];\n        },\n\n        /**\n         * Returns end date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getEndDate: function (record) {\n            return record['end_time'];\n        },\n\n        /**\n         * Returns difference in days between records' start date\n         * and a first day of a range.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getStartDelta: function (record) {\n            var start    = this.createDate(this.getStartDate(record)),\n                firstDay = this.range.firstDay;\n\n            return start.diff(firstDay, 'days', true);\n        },\n\n        /**\n         * Calculates the amount of days that provided event lasts.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getDaysLength: function (record) {\n            var start   = this.createDate(this.getStartDate(record)),\n                end     = this.createDate(this.getEndDate(record));\n\n            if (!end.isValid()) {\n                end = this.range.lastDay.endOf('day');\n            }\n\n            return end.diff(start, 'days', true);\n        },\n\n        /**\n         * Creates new date object based on provided date string value.\n         *\n         * @param {String} dateStr\n         * @returns {Moment}\n         */\n        createDate: function (dateStr) {\n            return moment(dateStr, this.dateFormat);\n        },\n\n        /**\n         * Converts days to weeks.\n         *\n         * @param {Number} days\n         * @returns {Number}\n         */\n        daysToWeeks: function (days) {\n            var weeks = days / 7;\n\n            if (weeks % 1) {\n                weeks = weeks.toFixed(1);\n            }\n\n            return weeks;\n        },\n\n        /**\n         * Updates data of a range object,\n         * e.g. total days, first day and last day, etc.\n         *\n         * @returns {Object} Range instance.\n         */\n        updateRange: function () {\n            var firstDay    = this._getFirstDay(),\n                lastDay     = this._getLastDay(),\n                totalDays   = lastDay.diff(firstDay, 'days'),\n                days        = [],\n                i           = -1;\n\n            if (totalDays < this.minDays) {\n                totalDays += this.minDays - totalDays - 1;\n            }\n\n            while (++i <= totalDays) {\n                days.push(+firstDay + ONE_DAY * i);\n            }\n\n            return _.extend(this.range, {\n                days:       days,\n                totalDays:  totalDays,\n                firstDay:   firstDay,\n                lastDay:    moment(_.last(days)),\n                hasToday:   this.isToday(firstDay)\n            });\n        },\n\n        /**\n         *\n         * @private\n         * @param {String} key\n         * @returns {Array<Moment>}\n         */\n        _getDates: function (key) {\n            var dates = [];\n\n            this.rows.forEach(function (record) {\n                if (record[key]) {\n                    dates.push(this.createDate(record[key]));\n                }\n            }, this);\n\n            return dates;\n        },\n\n        /**\n         * Returns date which is closest to the current day.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getFirstDay: function () {\n            var dates = this._getDates('start_time'),\n                first = moment.min(dates).subtract(1, 'day'),\n                today = moment();\n\n            if (!first.isValid() || first < today) {\n                first = today;\n            }\n\n            return first.startOf('day');\n        },\n\n        /**\n         * Returns the most distant date\n         * specified in available records.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getLastDay: function () {\n            var startDates  = this._getDates('start_time'),\n                endDates    = this._getDates('end_time'),\n                last        = moment.max(startDates.concat(endDates));\n\n            return last.add(1, 'day').startOf('day');\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {Number} timestamp\n         * @returns {String}\n         */\n        formatHeader: function (timestamp) {\n            return moment(timestamp).format(this.headerFormat);\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {String} date\n         * @returns {String}\n         */\n        formatDetails: function (date) {\n            return moment(date).format(this.detailsFormat);\n        }\n    });\n});\n","Magento_Ui/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiElement'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/sortBy',\n            options: [],\n            applied: {},\n            sorting: 'asc',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            selectedOption: '',\n            isVisible: true,\n            listens: {\n                'selectedOption': 'applyChanges'\n            },\n            statefull: {\n                selectedOption: true,\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.sorting'\n            },\n            imports: {\n                preparedOptions: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'applied',\n                    'selectedOption',\n                    'isVisible'\n                ]);\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        this.options.push({\n                            value: column.index,\n                            label: column.label\n                        });\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            this.applied({\n                field: this.selectedOption(),\n                direction: this.sorting\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (ko, _, loader, resolver, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/listing',\n            listTemplate: 'ui/list/listing',\n            stickyTmpl: 'ui/grid/sticky/listing',\n            viewSwitcherTmpl: 'ui/grid/view-switcher',\n            positions: false,\n            displayMode: 'grid',\n            displayModes: {\n                grid: {\n                    value: 'grid',\n                    label: 'Grid',\n                    template: '${ $.template }'\n                },\n                list: {\n                    value: 'list',\n                    label: 'List',\n                    template: '${ $.listTemplate }'\n                }\n            },\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/grid/dnd',\n                columnsProvider: '${ $.name }',\n                enabled: true\n            },\n            editorConfig: {\n                name: '${ $.name }_editor',\n                component: 'Magento_Ui/js/grid/editing/editor',\n                columnsProvider: '${ $.name }',\n                dataProvider: '${ $.provider }',\n                enabled: false\n            },\n            resizeConfig: {\n                name: '${ $.name }_resize',\n                columnsProvider: '${ $.name }',\n                component: 'Magento_Ui/js/grid/resize',\n                enabled: false\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            },\n            listens: {\n                elems: 'updatePositions updateVisible',\n                '${ $.provider }:reload': 'onBeforeReload',\n                '${ $.provider }:reloaded': 'onDataReloaded'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }',\n                resize: '${ $.resizeConfig.name }'\n            },\n            tracks: {\n                displayMode: true\n            },\n            statefull: {\n                displayMode: true\n            }\n        },\n\n        /**\n         * Initializes Listing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateVisible');\n\n            this._super()\n                .initDnd()\n                .initEditor()\n                .initResize();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: [],\n                    visibleColumns: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Creates drag&drop widget instance.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes resize component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initResize: function () {\n            if (this.resizeConfig.enabled) {\n                layout([this.resizeConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates inline editing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initEditor: function () {\n            if (this.editorConfig.enabled) {\n                layout([this.editorConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initElement: function (element) {\n            var currentCount = this.elems().length,\n                totalCount = this.initChildCount;\n\n            if (totalCount === currentCount) {\n                this.initPositions();\n            }\n\n            element.on('visible', this.updateVisible);\n\n            return this._super();\n        },\n\n        /**\n         * Defines initial order of child elements.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initPositions: function () {\n            this.on('positions', this.applyPositions.bind(this));\n\n            this.setStatefull('positions');\n\n            return this;\n        },\n\n        /**\n         * Updates current state of child positions.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updatePositions: function () {\n            var positions = {};\n\n            this.elems.each(function (elem, index) {\n                positions[elem.index] = index;\n            });\n\n            this.set('positions', positions);\n\n            return this;\n        },\n\n        /**\n         * Resorts child elements array according to provided positions.\n         *\n         * @param {Object} positions - Object where key represents child\n         *      index and value is its' position.\n         * @returns {Listing} Chainable.\n         */\n        applyPositions: function (positions) {\n            var sorting;\n\n            sorting = this.elems.map(function (elem) {\n                return {\n                    elem: elem,\n                    position: positions[elem.index]\n                };\n            });\n\n            this.insertChild(sorting);\n\n            return this;\n        },\n\n        /**\n         * Returns reference to 'visibleColumns' array.\n         *\n         * @returns {Array}\n         */\n        getVisible: function () {\n            var observable = ko.getObservable(this, 'visibleColumns');\n\n            return observable || this.visibleColumns;\n        },\n\n        /**\n         * Returns path to the template\n         * defined for a current display mode.\n         *\n         * @returns {String} Path to the template.\n         */\n        getTemplate: function () {\n            var mode = this.displayModes[this.displayMode];\n\n            return mode.template;\n        },\n\n        /**\n         * Returns an array of available display modes.\n         *\n         * @returns {Array<Object>}\n         */\n        getDisplayModes: function () {\n            var modes = this.displayModes;\n\n            return _.values(modes);\n        },\n\n        /**\n         * Sets display mode to provided value.\n         *\n         * @param {String} index\n         * @returns {Listing} Chainable\n         */\n        setDisplayMode: function (index) {\n            this.displayMode = index;\n\n            return this;\n        },\n\n        /**\n         * Returns total number of displayed columns in grid.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.visibleColumns.length;\n        },\n\n        /**\n         * Updates array of visible columns.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updateVisible: function () {\n            this.visibleColumns = this.elems.filter('visible');\n\n            return this;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows && !!this.rows.length;\n        },\n\n        /**\n         * Hides loader.\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n        },\n\n        /**\n         * Shows loader.\n         */\n        showLoader: function () {\n            loader.get(this.name).show();\n        },\n\n        /**\n         * Handler of the data providers' 'reload' event.\n         */\n        onBeforeReload: function () {\n            this.showLoader();\n        },\n\n        /**\n         * Handler of the data providers' 'reloaded' event.\n         */\n        onDataReloaded: function () {\n            resolver(this.hideLoader, this);\n        }\n    });\n});\n","Magento_Ui/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'rjsResolver',\n    'uiLayout',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'uiElement',\n    'uiRegistry',\n    'Magento_Ui/js/grid/data-storage'\n], function ($, _, utils, resolver, layout, alert, $t, Element, registry) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            firstLoad: true,\n            lastError: false,\n            storageConfig: {\n                component: 'Magento_Ui/js/grid/data-storage',\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                updateUrl: '${ $.update_url }'\n            },\n            listens: {\n                params: 'onParamsChange',\n                requestConfig: 'updateRequestConfig'\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            triggerDataReload: false\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'onParamsChange', 5);\n            _.bindAll(this, 'onReload');\n\n            this._super()\n                .initStorage()\n                .clearData();\n\n            // Load data when there will\n            // be no more pending assets.\n            resolver(this.reload, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes storage component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Clears provider's data properties.\n         *\n         * @returns {Provider} Chainable.\n         */\n        clearData: function () {\n            this.setData({\n                items: [],\n                totalRecords: 0,\n                showTotalRecords: true\n            });\n\n            return this;\n        },\n\n        /**\n         * Overrides current data with a provided one.\n         *\n         * @param {Object} data - New data object.\n         * @returns {Provider} Chainable.\n         */\n        setData: function (data) {\n            data = this.processData(data);\n\n            this.set('data', data);\n\n            return this;\n        },\n\n        /**\n         * Processes data before applying it.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        processData: function (data) {\n            var items = data.items;\n\n            _.each(items, function (record, index) {\n                record._rowIndex = index;\n            });\n\n            return data;\n        },\n\n        /**\n         * Reloads data with current parameters.\n         *\n         * @returns {Promise} Reload promise object.\n         */\n        reload: function (options) {\n            var request = this.storage().getData(this.params, options);\n\n            this.trigger('reload');\n\n            request\n                .done(this.onReload)\n                .fail(this.onError.bind(this));\n\n            return request;\n        },\n\n        /**\n         * Handles changes of 'params' object.\n         */\n        onParamsChange: function () {\n            // It's necessary to make a reload only\n            // after the initial loading has been made.\n            if (!this.firstLoad) {\n                this.reload();\n            } else {\n                this.triggerDataReload = true;\n            }\n        },\n\n        /**\n         * Handles reload error.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            this.set('lastError', true);\n\n            this.firstLoad = false;\n            this.triggerDataReload = false;\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Handles successful data reload.\n         *\n         * @param {Object} data - Retrieved data object.\n         */\n        onReload: function (data) {\n            this.firstLoad = false;\n            this.set('lastError', false);\n            this.setData(data)\n                .trigger('reloaded');\n\n            if (this.triggerDataReload) {\n                this.triggerDataReload = false;\n                this.reload();\n            }\n        },\n\n        /**\n         * Updates storage's request configuration\n         *\n         * @param {Object} requestConfig\n         */\n        updateRequestConfig: function (requestConfig) {\n            registry.get(this.storageConfig.provider, function (storage) {\n                _.extend(storage.requestConfig, requestConfig);\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined',\n        transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.body.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Returns first touch data if it's available.\n     *\n     * @param {(MouseEvent|TouchEvent)} e - Event object.\n     * @returns {Object}\n     */\n    function getTouch(e) {\n        return e.touches ? e.touches[0] : e;\n    }\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    /*eslint-disable no-extra-parens*/\n    /**\n     * Checks if specified coordinate is inside of the provided area.\n     *\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     * @param {Object} area - Object which represents area.\n     * @returns {Boolean}\n     */\n    function isInside(x, y, area) {\n        return (\n            area &&\n            x >= area.left && x <= area.right &&\n            y >= area.top && y <= area.bottom\n        );\n    }\n\n    /*eslint-enable no-extra-parens*/\n\n    /**\n     * Calculates distance between two points.\n     *\n     * @param {Number} x1 - X coordinate of a first point.\n     * @param {Number} y1 - Y coordinate of a first point.\n     * @param {Number} x2 - X coordinate of a second point.\n     * @param {Number} y2 - Y coordinate of a second point.\n     * @returns {Number} Distance between points.\n     */\n    function distance(x1, y1, x2, y2) {\n        var dx = x2 - x1,\n            dy = y2 - y1;\n\n        dx *= dx;\n        dy *= dy;\n\n        return Math.sqrt(dx + dy);\n    }\n\n    /**\n     * Returns viewModel associated with a provided DOM element.\n     *\n     * @param {HTMLElement} elem\n     * @returns {Object|Array}\n     */\n    function getModel(elem) {\n        return ko.dataFor(elem);\n    }\n\n    /**\n     * Checks whether cols are identical\n     *\n     * @param {HTMLElement} c1\n     * @param {HTMLElement} c2\n     * @returns {Boolean}\n     */\n    function compareCols(c1, c2) {\n        return c1.cellIndex === c2.cellIndex;\n    }\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            noSelectClass: '_no-select',\n            hiddenClass: '_hidden',\n            fixedX: false,\n            fixedY: true,\n            minDistance: 2,\n            columns: []\n        },\n\n        /**\n         * Initializes Dnd component.\n         *\n         * @returns {Dnd} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'removeColumn',\n                'onMouseMove',\n                'onMouseUp',\n                'onMouseDown'\n            );\n\n            this.$body = $('body');\n\n            this._super()\n                .initListeners();\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Binds necessary events listeners.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        initListeners: function () {\n            if (isTouchDevice) {\n                $(document).on({\n                    touchmove: this.onMouseMove,\n                    touchend: this.onMouseUp,\n                    touchleave: this.onMouseUp\n                });\n            } else {\n                $(document).on({\n                    mousemove: this.onMouseMove,\n                    mouseup: this.onMouseUp\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Defines specified table element as a main container.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {Dnd} Chainable.\n         */\n        initTable: function (table) {\n            this.table =  $(table).is(this.mainTableSelector) ?  table : this.table;\n\n            $(table).addClass('data-grid-draggable');\n\n            return this;\n        },\n\n        /**\n         * Sets specified column as a draggable element.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        initColumn: function (column) {\n            var model = getModel(column),\n                eventName;\n\n            if (!model || !model.draggable) {\n                return this;\n            }\n\n            if (!ko.es5.isTracked(model, 'dragover')) {\n                model.track('dragover');\n            }\n\n            this.columns.push(column);\n\n            $(column).bindings({\n                css: {\n                    '_dragover-left': ko.computed(function () {\n                        return model.dragover === 'right';\n                    }),\n                    '_dragover-right': ko.computed(function () {\n                        return model.dragover === 'left';\n                    })\n                }\n            });\n\n            eventName = isTouchDevice ?\n                'touchstart' :\n                'mousedown';\n\n            $(column).on(eventName, this.onMouseDown);\n            $.async.remove(column, this.removeColumn);\n\n            return this;\n        },\n\n        /**\n         * Removes specified column element from the columns array.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        removeColumn: function (column) {\n            var columns = this.columns,\n                index = columns.indexOf(column);\n\n            if (~index) {\n                columns.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns index of column.\n         *\n         * @param {HTMLTableHeaderCellElement} elem\n         * @returns {Number}\n         */\n        _getColumnIndex: function (elem) {\n            return _.toArray(elem.parentNode.cells).indexOf(elem);\n        },\n\n        /**\n         * Calculates coordinates of draggable elements.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        _cacheCoords: function () {\n            var container   = this.table.getBoundingClientRect(),\n                bodyRect    = document.body.getBoundingClientRect(),\n                grabbed     = this.grabbed,\n                dragElem    = grabbed.elem,\n                cells       = _.toArray(dragElem.parentNode.cells),\n                rect;\n\n            this.coords = this.columns.map(function (column) {\n                var data,\n                    colIndex = _.findIndex(cells, function (cell) {\n                        return compareCols(cell, column);\n                    });\n\n                rect = column.getBoundingClientRect();\n\n                data = {\n                    index: colIndex,\n                    target: column,\n                    orig: rect,\n                    left: rect.left - bodyRect.left,\n                    right: rect.right - bodyRect.left,\n                    top: rect.top - bodyRect.top,\n                    bottom: container.bottom - bodyRect.top\n                };\n\n                if (column === dragElem) {\n                    this.dragArea = data;\n\n                    grabbed.shiftX = rect.left - grabbed.x;\n                    grabbed.shiftY = rect.top - grabbed.y;\n                }\n\n                return data;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates clone of a target table with only specified column visible.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Dragging column.\n         * @returns {Dnd} Chainbale.\n         */\n        _cloneTable: function (elem) {\n            var clone       = this.table.cloneNode(true),\n                columnIndex = this._getColumnIndex(elem),\n                headRow     = clone.tHead.firstElementChild,\n                headCells   = _.toArray(headRow.cells),\n                tableBody   = clone.tBodies[0],\n                bodyRows    = _.toArray(tableBody.children),\n                origTrs     = this.table.tBodies[0].children;\n\n            clone.style.width = elem.offsetWidth + 'px';\n\n            headCells.forEach(function (th, index) {\n                if (index !== columnIndex) {\n                    headRow.removeChild(th);\n                }\n            });\n\n            headRow.cells[0].style.height = elem.offsetHeight + 'px';\n\n            bodyRows.forEach(function (row, rowIndex) {\n                var cells = row.cells,\n                    cell;\n\n                if (cells.length !== headCells.length) {\n                    tableBody.removeChild(row);\n\n                    return;\n                }\n\n                cell = row.cells[columnIndex].cloneNode(true);\n\n                while (row.firstElementChild) {\n                    row.removeChild(row.firstElementChild);\n                }\n\n                cell.style.height = origTrs[rowIndex].cells[columnIndex].offsetHeight + 'px';\n\n                row.appendChild(cell);\n            });\n\n            this.dragTable = clone;\n\n            $(clone)\n                .addClass('_dragging-copy')\n                .appendTo('body');\n\n            return this;\n        },\n\n        /**\n         * Matches provided coordinates to available areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         * @returns {Object|Undefined} Matched area.\n         */\n        _getDropArea: function (x, y) {\n            return _.find(this.coords, function (area) {\n                return isInside(x, y, area);\n            });\n        },\n\n        /**\n         * Updates state of hovered areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         */\n        _updateAreas: function (x, y) {\n            var leavedArea = this.dropArea,\n                area = this.dropArea = this._getDropArea(x, y);\n\n            if (leavedArea) {\n                this.dragleave(leavedArea);\n            }\n\n            if (area && !compareCols(area.target, this.dragArea.target)) {\n                this.dragenter(area);\n            }\n        },\n\n        /**\n         * Grab action handler.\n         *\n         * @param {Number} x - X coordinate of a grabbed point.\n         * @param {Number} y - Y coordinate of a grabbed point.\n         * @param {HTMLElement} elem - Grabbed element.\n         */\n        grab: function (x, y, elem) {\n            this.initDrag = true;\n\n            this.grabbed = {\n                x: x,\n                y: y,\n                elem: elem\n            };\n\n            this.$body.addClass(this.noSelectClass);\n        },\n\n        /**\n         * Dragstart action handler.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Element which is dragging.\n         */\n        dragstart: function (elem) {\n            this.initDrag = false;\n            this.dropArea = false;\n            this.dragging = true;\n\n            getModel(elem).dragging(true);\n\n            this._cacheCoords()\n                ._cloneTable(elem);\n        },\n\n        /**\n         * Drag action handler. Locates draggable\n         * grid at a specified coordinates.\n         *\n         * @param {Number} x - X coordinate.\n         * @param {Number} y - Y coordinate.\n         */\n        drag: function (x, y) {\n            var grabbed  = this.grabbed,\n                dragArea = this.dragArea,\n                posX     = x + grabbed.shiftX,\n                posY     = y + grabbed.shiftY;\n\n            if (this.fixedX) {\n                x    = dragArea.left;\n                posX = dragArea.orig.left;\n            }\n\n            if (this.fixedY) {\n                y    = dragArea.top;\n                posY = dragArea.orig.top;\n            }\n\n            locate(this.dragTable, posX, posY);\n\n            if (!isInside(x, y, this.dropArea)) {\n                this._updateAreas(x, y);\n            }\n        },\n\n        /**\n         * Dragenter action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragenter: function (dropArea) {\n            var direction = this.dragArea.index < dropArea.index ?\n                'left' :\n                'right';\n\n            getModel(dropArea.target).dragover = direction;\n        },\n\n        /**\n         * Dragleave action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragleave: function (dropArea) {\n            getModel(dropArea.target).dragover = false;\n        },\n\n        /**\n         * Dragend action handler.\n         *\n         * @param {Object} dragArea\n         */\n        dragend: function (dragArea) {\n            var dropArea = this.dropArea,\n                dragElem = dragArea.target;\n\n            this.dragging = false;\n\n            document.body.removeChild(this.dragTable);\n\n            getModel(dragElem).dragging(false);\n\n            if (dropArea && !compareCols(dropArea.target, dragElem)) {\n                this.drop(dropArea, dragArea);\n            }\n        },\n\n        /**\n         * Drop action handler.\n         *\n         * @param {Object} dropArea\n         * @param {Object} dragArea\n         */\n        drop: function (dropArea, dragArea) {\n            var dropModel = getModel(dropArea.target),\n                dragModel = getModel(dragArea.target);\n\n            getModel(this.table).insertChild(dragModel, dropModel);\n            dropModel.dragover = false;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseMove: function (e) {\n            var grab    = this.grabbed,\n                touch   = getTouch(e),\n                x       = touch.pageX,\n                y       = touch.pageY;\n\n            if (this.initDrag || this.dragging) {\n                e.preventDefault();\n            }\n\n            if (this.initDrag && distance(x, y, grab.x, grab.y) >= this.minDistance) {\n                this.dragstart(grab.elem);\n            }\n\n            if (this.dragging) {\n                this.drag(x, y);\n            }\n        },\n\n        /**\n         * Documents' 'mouseup' event handler.\n         */\n        onMouseUp: function () {\n            if (this.initDrag || this.dragging) {\n                this.initDrag = false;\n                this.$body.removeClass(this.noSelectClass);\n            }\n\n            if (this.dragging) {\n                this.dragend(this.dragArea);\n            }\n        },\n\n        /**\n         * Columns' 'mousedown' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseDown: function (e) {\n            var touch = getTouch(e);\n\n            this.grab(touch.pageX, touch.pageY, e.currentTarget);\n        }\n    });\n});\n","Magento_Ui/js/grid/export.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement'\n], function ($, _, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/exportButton',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            checked: '',\n            additionalParams: [],\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChecked();\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            _.each(this.additionalParams, function (value, key) {\n                key = 'additionalParams.' + key;\n                this.imports[key] = value;\n            }, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            return this;\n        },\n\n        /**\n         * Checks first option if checked not defined.\n         *\n         * @returns {Object}\n         */\n        initChecked: function () {\n            if (!this.checked()) {\n                this.checked(\n                    this.options[0].value\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Compose params object that will be added to request.\n         *\n         * @returns {Object}\n         */\n        getParams: function () {\n            var selections = this.selections(),\n                data = selections ? selections.getSelections() : null,\n                itemsType,\n                result = {};\n\n            if (data) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                result.filters = data.params.filters;\n                result.search = data.params.search;\n                result.namespace = data.params.namespace;\n                result[itemsType] = data[itemsType];\n                _.each(this.additionalParams, function (param, key) {\n                    result[key] = param;\n                });\n\n                if (!result[itemsType].length) {\n                    result[itemsType] = false;\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Find checked option.\n         *\n         * @returns {Object}\n         */\n        getActiveOption: function () {\n            return _.findWhere(this.options, {\n                value: this.checked()\n            });\n        },\n\n        /**\n         * Build option url.\n         *\n         * @param {Object} option\n         * @returns {String}\n         */\n        buildOptionUrl: function (option) {\n            var params = this.getParams();\n\n            if (!params) {\n                return 'javascript:void(0);';\n            }\n\n            return option.url + '?' + $.param(params);\n            //TODO: MAGETWO-40250\n        },\n\n        /**\n         * Redirect to built option url.\n         */\n        applyOption: function () {\n            var option = this.getActiveOption(),\n                url = this.buildOptionUrl(option);\n\n            location.href = url;\n\n        }\n    });\n});\n","Magento_Ui/js/grid/tree-massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/massactions'\n], function (ko, _, Massactions) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            template: 'ui/grid/tree-massactions',\n            submenuTemplate: 'ui/grid/submenu',\n            listens: {\n                opened: 'hideSubmenus'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .recursiveObserveActions(this.actions());\n\n            return this;\n        },\n\n        /**\n         * Recursive initializes observable actions.\n         *\n         * @param {Array} actions - Action objects.\n         * @param {String} [prefix] - An optional string that will be prepended\n         *      to the \"type\" field of all child actions.\n         * @returns {Massactions} Chainable.\n         */\n        recursiveObserveActions: function (actions, prefix) {\n            _.each(actions, function (action) {\n                if (prefix) {\n                    action.type = prefix + '.' + action.type;\n                }\n\n                if (action.actions) {\n                    action.visible = ko.observable(false);\n                    action.parent = actions;\n                    this.recursiveObserveActions(action.actions, action.type);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var action = this.getAction(actionIndex),\n                visibility;\n\n            if (action.visible) {\n                visibility = action.visible();\n\n                this.hideSubmenus(action.parent);\n                action.visible(!visibility);\n\n                return this;\n            }\n\n            return this._super(actionIndex);\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Array} actions - Action objects.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex, actions) {\n            var currentActions = actions || this.actions(),\n                result = false;\n\n            _.find(currentActions, function (action) {\n                if (action.type === actionIndex) {\n                    result = action;\n\n                    return true;\n                }\n\n                if (action.actions) {\n                    result = this.getAction(actionIndex, action.actions);\n\n                    return result;\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Recursive hide all sub folders in given array.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        hideSubmenus: function (actions) {\n            var currentActions = actions || this.actions();\n\n            _.each(currentActions, function (action) {\n                if (action.visible && action.visible()) {\n                    action.visible(false);\n                }\n\n                if (action.actions) {\n                    this.hideSubmenus(action.actions);\n                }\n            }, this);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/resize.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    'uiElement'\n], function ($, ko, _, utils, registry, boundedNodes, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            fieldSelector: '${ $.tableSelector } tbody tr td',\n\n            imports: {\n                storageColumnsData: '${ $.storageConfig.path }.storageColumnsData'\n            },\n            storageColumnsData: {},\n            columnsElements: {},\n            tableWidth: 0,\n            sumColumnsWidth: 0,\n            showLines: 4,\n            resizableElementClass: 'shadow-div',\n            resizingColumnClass: '_resizing',\n            fixedLayoutClass: '_layout-fixed',\n            inResizeClass: '_in-resize',\n            visibleClass: '_resize-visible',\n            cellContentElement: 'div.data-grid-cell-content',\n            minColumnWidth: 40,\n            layoutFixedPolyfillIterator: 0,\n            windowResize: false,\n            resizable: false,\n            resizeConfig: {\n                maxRowsHeight: [],\n                curResizeElem: {},\n                depResizeElem: {},\n                previousWidth: null\n            }\n        },\n\n        /**\n         * Initialize application -\n         * binding functions context,\n         * set handlers for table elements\n         *\n         * @returns {Object} Chainable\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'mousedownHandler',\n                'mousemoveHandler',\n                'mouseupHandler',\n                'refreshLastColumn',\n                'refreshMaxRowHeight',\n                'preprocessingWidth',\n                '_eventProxy',\n                'checkAfterResize'\n            );\n\n            this._super();\n            this.observe(['maxRowsHeight']);\n            this.maxRowsHeight([]);\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Set table element and adds handler to mousedown on headers\n         *\n         * @returns {Object} Chainable\n         */\n        initTable: function (table) {\n            if ($(table).is(this.mainTableSelector)) {\n                this.table = table;\n                this.tableWidth = $(table).outerWidth();\n                $(window).on('resize', this.checkAfterResize);\n            }\n\n            //TODO - Must be deleted when Firefox fixed problem with table-layout: fixed\n            //ticket to Firefox: https://bugs.webkit.org/show_bug.cgi?id=90068\n            if (navigator.userAgent.search(/Firefox/) > -1) {\n                this._layoutFixedPolyfill();\n            }\n\n            $(table).addClass(this.fixedLayoutClass);\n\n            return this;\n        },\n\n        /**\n         * Window resize handler,\n         * check changes on table width and\n         * set new width to variable\n         * after window resize start preprocessingWidth method\n         */\n        checkAfterResize: function () {\n            var tableWidth,\n                self = this;\n\n            setTimeout(function () {\n                tableWidth = $(self.table).outerWidth();\n\n                if (self.tableWidth !== tableWidth) {\n                    self.tableWidth = tableWidth;\n                } else {\n                    self.preprocessingWidth();\n                }\n            }, 300);\n        },\n\n        /**\n         * Check conditions to set minimal width\n         */\n        checkSumColumnsWidth: function () {\n            var table = $(this.table),\n                elems = table.find('th:not([style*=\"width: auto\"]):visible'),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible'),\n                model;\n\n            this.sumColumnsWidth = 0;\n            _.each(elems, function (elem) {\n                model = ko.dataFor(elem);\n                model.width && model.width !== 'auto' ? this.sumColumnsWidth += model.width : false;\n            }, this);\n\n            if (\n                    this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length *\n                    this.minColumnWidth > this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set minimal width to element with \"auto\" width\n         */\n        setWidthToColumnsWidthAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: auto\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth(this.minColumnWidth - 1);\n            }, this);\n        },\n\n        /**\n         * Check conditions to set auto width\n         */\n        hasMinimal: function () {\n            var table = $(this.table),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible');\n\n            if (\n                    elemsWidthAuto && this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length * this.minColumnWidth + 5 < this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set \"auto\" width to element with minimal width\n         */\n        setAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth('auto');\n            }, this);\n        },\n\n        /**\n         * Check columns width and preprocessing\n         */\n        preprocessingWidth: function () {\n            if (this.checkSumColumnsWidth()) {\n                this.setWidthToColumnsWidthAuto();\n            } else if (this.hasMinimal()) {\n                this.setAuto();\n            }\n        },\n\n        /**\n         * Init columns elements,\n         * set width to current column element,\n         * add resizable element to columns header,\n         * check and add no-resize class to last column,\n         * stop parents events,\n         * add handler to visibility column\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        initColumn: function (column) {\n            var model = ko.dataFor(column),\n                ctxIndex = this.getCtxIndex(ko.contextFor(column));\n\n            model.width = this.getDefaultWidth(column);\n\n            if (!this.hasColumn(model, ctxIndex, false)) {\n                this.columnsElements[model.index] = this.columnsElements[model.index] || {};\n                this.columnsElements[model.index][ctxIndex] = column;\n                this.initResizableElement(column);\n                this.setStopPropagationHandler(column);\n                $(column).outerWidth(model.width);\n            }\n\n            this.refreshLastColumn(column);\n            this.preprocessingWidth();\n\n            model.on('visible', this.refreshLastColumn.bind(this, column));\n            model.on('visible', this.preprocessingWidth.bind(this));\n        },\n\n        /**\n         * Hack for mozilla firefox\n         */\n        _layoutFixedPolyfill: function () {\n            var self = this;\n\n            setTimeout(function () {\n                if (self.layoutFixedPolyfillIterator < 20) {\n                    $(window).trigger('resize');\n                    self.layoutFixedPolyfillIterator++;\n                    self._layoutFixedPolyfill();\n                } else {\n                    return false;\n                }\n            }, 500);\n        },\n\n        /**\n         * Check element is resizable or not\n         * and append resizable element to DOM\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        initResizableElement: function (column) {\n            var model = ko.dataFor(column),\n                templateDragElement = '<div class=\"' + this.resizableElementClass + '\"></div>';\n\n            if (_.isUndefined(model.resizeEnabled) || model.resizeEnabled) {\n                $(column).append(templateDragElement);\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check event target and if need stop parents event,\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        setStopPropagationHandler: function (column) {\n            var events,\n                click,\n                mousedown;\n\n            $(column).on('click', this._eventProxy);\n            $(column).on('mousedown', this._eventProxy);\n\n            events = $._data(column, 'events');\n\n            click = events.click;\n            mousedown = events.mousedown;\n            click.unshift(click.pop());\n            mousedown.unshift(mousedown.pop());\n\n            return this;\n        },\n\n        /**\n         * Check event target and stop event if need\n         *\n         * @param {Object} event\n         */\n        _eventProxy: function (event) {\n            if ($(event.target).is('.' + this.resizableElementClass)) {\n\n                if (event.type === 'click') {\n                    event.stopImmediatePropagation();\n                } else if (event.type === 'mousedown') {\n                    this.mousedownHandler(event);\n                }\n            }\n        },\n\n        /**\n         * Check visible columns and set disable class to resizable elements,\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        refreshLastColumn: function (column) {\n            var i = 0,\n                columns = $(column).parent().children().not(':hidden'),\n                length = columns.length;\n\n            $('.' + this.visibleClass).removeClass(this.visibleClass);\n\n            $(column).parent().children().not(':hidden').last().addClass(this.visibleClass);\n\n            for (i; i < length; i++) {\n\n                if (!columns.eq(i).find('.' + this.resizableElementClass).length && i) {\n                    columns.eq(i - 1).addClass(this.visibleClass);\n                }\n            }\n\n        },\n\n        /**\n         * Refresh max height to row elements,\n         *\n         * @param {Object} elem - (td)\n         */\n        refreshMaxRowHeight: function (elem) {\n            var rowsH = this.maxRowsHeight(),\n                curEL = $(elem).find('div'),\n                height,\n                obj = this.hasRow($(elem).parent()[0], true);\n\n            curEL.css('white-space', 'nowrap');\n            height = curEL.height() * this.showLines;\n            curEL.css('white-space', 'normal');\n\n            if (obj) {\n                if (obj.maxHeight < height) {\n                    rowsH[_.indexOf(rowsH, obj)].maxHeight = height;\n                } else {\n                    return false;\n                }\n            } else {\n                rowsH.push({\n                    elem: $(elem).parent()[0],\n                    maxHeight: height\n                });\n            }\n\n            $(elem).parent().children().find(this.cellContentElement).css('max-height', height + 'px');\n            this.maxRowsHeight(rowsH);\n        },\n\n        /**\n         * Set resize class to elements when resizable\n         */\n        _setResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Remove resize class to elements when resizable\n         */\n        _removeResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Check conditions to resize\n         *\n         * @returns {Boolean}\n         */\n        _canResize: function (column) {\n            if (\n                $(column).hasClass(this.visibleClass) ||\n                !$(this.resizeConfig.depResizeElem.elems[0]).find('.' + this.resizableElementClass).length\n            ) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Mouse down event handler,\n         * find current and dep column to resize\n         *\n         * @param {Object} event\n         */\n        mousedownHandler: function (event) {\n            var target = event.target,\n                column = $(target).parent()[0],\n                cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopImmediatePropagation();\n            cfg.curResizeElem.model = ko.dataFor(column);\n            cfg.curResizeElem.ctx = ko.contextFor(column);\n            cfg.curResizeElem.elems = this.hasColumn(cfg.curResizeElem.model, false, true);\n            cfg.curResizeElem.position = event.pageX;\n            cfg.depResizeElem.elems = this.getNextElements(cfg.curResizeElem.elems[0]);\n            cfg.depResizeElem.model = ko.dataFor(cfg.depResizeElem.elems[0]);\n            cfg.depResizeElem.ctx = ko.contextFor(cfg.depResizeElem.elems[0]);\n\n            this._setResizeClass();\n\n            if (!this._canResize(column)) {\n                return false;\n            }\n\n            event.stopPropagation();\n            this.resizable = true;\n            cfg.curResizeElem.model.width = $(cfg.curResizeElem.elems[0]).outerWidth();\n            cfg.depResizeElem.model.width = $(cfg.depResizeElem.elems[0]).outerWidth();\n            body.addClass(this.inResizeClass);\n            body.on('mousemove', this.mousemoveHandler);\n            $(window).on('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mousemoveHandler: function (event) {\n            var cfg = this.resizeConfig,\n                width = event.pageX - cfg.curResizeElem.position,\n                self = this;\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            if (\n                this.resizable &&\n                this.minColumnWidth < cfg.curResizeElem.model.width + width &&\n                this.minColumnWidth < cfg.depResizeElem.model.width - width &&\n                cfg.previousWidth !== width\n            ) {\n                cfg.curResizeElem.model.width += width;\n                cfg.depResizeElem.model.width -= width;\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.curResizeElem.model.width);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.depResizeElem.model.width);\n                });\n\n                cfg.previousWidth = width;\n                cfg.curResizeElem.position = event.pageX;\n            } else if (width <= -(cfg.curResizeElem.model.width - this.minColumnWidth)) {\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                    cfg.depResizeElem.model.width +\n                    cfg.curResizeElem.model.width -\n                    self.minColumnWidth);\n                });\n\n            } else if (width >= cfg.depResizeElem.model.width - this.minColumnWidth) {\n\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                        cfg.curResizeElem.model.width +\n                        cfg.depResizeElem.model.width -\n                        self.minColumnWidth\n                    );\n                });\n            }\n        },\n\n        /**\n         * Mouse up event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mouseupHandler: function (event) {\n            var cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            this._removeResizeClass();\n            this.storageColumnsData[cfg.curResizeElem.model.index] = cfg.curResizeElem.model.width;\n            this.storageColumnsData[cfg.depResizeElem.model.index] = cfg.depResizeElem.model.width;\n            this.resizable = false;\n\n            this.store('storageColumnsData');\n\n            body.removeClass(this.inResizeClass);\n            body.off('mousemove', this.mousemoveHandler);\n            $(window).off('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Find dependency element\n         *\n         * @param {Object} element - current element\n         * @returns {Object} next element data\n         */\n        getNextElements: function (element) {\n            var nextElem = $(element).next()[0],\n                nextElemModel = ko.dataFor(nextElem),\n                nextElemData = this.hasColumn(nextElemModel, false, true);\n\n            if (nextElemData) {\n                if (nextElemModel.visible) {\n                    return nextElemData;\n                }\n\n                return this.getNextElements(nextElem);\n            }\n        },\n\n        /**\n         * Get default width\n         *\n         * @param {Object} column - (th) element\n         * @return {String} width for current column\n         */\n        getDefaultWidth: function (column) {\n            var model = ko.dataFor(column);\n\n            if (this.storageColumnsData[model.index]) {\n                return this.storageColumnsData[model.index];\n            }\n\n            if (model.resizeDefaultWidth) {\n                return parseInt(model.resizeDefaultWidth, 10);\n            }\n\n            return 'auto';\n        },\n\n        /**\n         * Check column is render or not\n         *\n         * @param {Object} model - cur column model\n         * @param {String|Boolean} ctxIndex - index of context, or false, if want to get cols from all ctx\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean} if returned param is false, returned boolean value, else return current object data\n         */\n        hasColumn: function (model, ctxIndex, returned) {\n            var colElem = this.columnsElements[model.index] || {},\n                getFromAllCtx = ctxIndex === false;\n\n            if (colElem && (getFromAllCtx || colElem.hasOwnProperty(ctxIndex))) {\n\n                if (returned) {\n                    return getFromAllCtx ?\n                        _.values(colElem) :\n                        colElem[ctxIndex];\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check row is render or not\n         *\n         * @param {Object} elem - cur column element\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean|Object} if returned param is false, returned boolean value, else return current object data\n         */\n        hasRow: function (elem, returned) {\n            var i = 0,\n                el = this.maxRowsHeight(),\n                length = el.length;\n\n            for (i; i < length; i++) {\n                if (this.maxRowsHeight()[i].elem === elem) {\n                    if (returned) {//eslint-disable-line max-depth\n                        return this.maxRowsHeight()[i];\n                    }\n\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Generate index that will identify context\n         *\n         * @param {Object} ctx\n         * @return {String}\n         */\n        getCtxIndex: function (ctx) {\n            return ctx ? ctx.$parents.reduce(function (pv, cv) {\n                return (pv.index || pv) + (cv || {}).index;\n            }) : ctx;\n        }\n    });\n});\n","Magento_Ui/js/grid/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            cacheRequests: true,\n            cachedRequestDelay: 50,\n            indexField: 'entity_id',\n            requestConfig: {\n                url: '${ $.updateUrl }',\n                method: 'GET',\n                dataType: 'json'\n            },\n            dataScope: '',\n            data: {}\n        },\n\n        /**\n         * Initializes dataStorage configuration.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        initConfig: function () {\n            var scope;\n\n            this._super();\n\n            scope = this.dataScope;\n\n            if (typeof scope === 'string') {\n                this.dataScope = scope ? [scope] : [];\n            }\n\n            this._requests = [];\n\n            return this;\n        },\n\n        /**\n         * Extracts data which matches specified set of identifiers.\n         *\n         * @param {Array} ids - Records identifiers.\n         * @returns {Array|Boolean}\n         */\n        getByIds: function (ids) {\n            var result = [],\n                hasData;\n\n            hasData = ids.every(function (id) {\n                var item = this.data[id];\n\n                return item ? result.push(item) : false;\n            }, this);\n\n            return hasData ? result : false;\n        },\n\n        /**\n         * Extracts identifiers of provided records.\n         * If no records were provided then full list of\n         * current data id's will be returned.\n         *\n         * @param {Object|Array} [data=this.data]\n         * @returns {Array}\n         */\n        getIds: function (data) {\n            data = data || this.data;\n\n            return _.pluck(data, this.indexField);\n        },\n\n        /**\n         * Extracts data which matches specified parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} [options={}]\n         * @returns {jQueryPromise}\n         */\n        getData: function (params, options) {\n            var cachedRequest;\n\n            if (this.hasScopeChanged(params)) {\n                this.clearRequests();\n            } else {\n                cachedRequest = this.getRequest(params);\n            }\n\n            options = options || {};\n\n            return !options.refresh && cachedRequest ?\n                this.getRequestData(cachedRequest) :\n                this.requestData(params);\n        },\n\n        /**\n         * Tells whether one of the parameters defined in the \"dataScope\" has\n         * changed since the last request.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Boolean}\n         */\n        hasScopeChanged: function (params) {\n            var lastRequest = _.last(this._requests),\n                keys,\n                diff;\n\n            if (!lastRequest) {\n                return false;\n            }\n\n            diff = utils.compare(lastRequest.params, params);\n\n            keys = _.pluck(diff.changes, 'path');\n            keys = keys.concat(Object.keys(diff.containers));\n\n            return _.intersection(this.dataScope, keys).length > 0;\n        },\n\n        /**\n         * Extends records of current data object\n         * with the provided records collection.\n         *\n         * @param {Array} data - An array of records.\n         * @returns {DataStorage} Chainable.\n         */\n        updateData: function (data) {\n            var records = _.indexBy(data || [], this.indexField);\n\n            _.extend(this.data, records);\n\n            return this;\n        },\n\n        /**\n         * Sends request to the server with provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {jQueryPromise}\n         */\n        requestData: function (params) {\n            var query = utils.copy(params),\n                handler = this.onRequestComplete.bind(this, query),\n                request;\n\n            this.requestConfig.data = query;\n            request = $.ajax(this.requestConfig).done(handler);\n\n            return request;\n        },\n\n        /**\n         * Returns request's instance which\n         * contains provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Object} Instance of request.\n         */\n        getRequest: function (params) {\n            return _.find(this._requests, function (request) {\n                return _.isEqual(params, request.params);\n            }, this);\n        },\n\n        /**\n         * Forms data object associated with provided request.\n         *\n         * @param {Object} request - Request object.\n         * @returns {jQueryPromise}\n         */\n        getRequestData: function (request) {\n            var defer = $.Deferred(),\n                resolve = defer.resolve.bind(defer),\n                delay = this.cachedRequestDelay,\n                result;\n\n            if (request.showTotalRecords === undefined) {\n                request.showTotalRecords = true;\n            }\n\n            result = {\n                items: this.getByIds(request.ids),\n                totalRecords: request.totalRecords,\n                showTotalRecords: request.showTotalRecords,\n                errorMessage: request.errorMessage\n            };\n\n            delay ?\n                _.delay(resolve, delay, result) :\n                resolve(result);\n\n            return defer.promise();\n        },\n\n        /**\n         * Caches requests object with provided parameters\n         * and data object associated with it.\n         *\n         * @param {Object} data - Data associated with request.\n         * @param {Object} params - Request parameters.\n         * @returns {DataStorage} Chainable.\n         */\n        cacheRequest: function (data, params) {\n            var cached = this.getRequest(params);\n\n            if (cached) {\n                this.removeRequest(cached);\n            }\n\n            if (data.showTotalRecords === undefined) {\n                data.showTotalRecords = true;\n            }\n\n            this._requests.push({\n                ids: this.getIds(data.items),\n                params: params,\n                totalRecords: data.totalRecords,\n                showTotalRecords: data.showTotalRecords,\n                errorMessage: data.errorMessage\n            });\n\n            return this;\n        },\n\n        /**\n         * Clears all cached requests.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        clearRequests: function () {\n            this._requests.splice(0);\n\n            return this;\n        },\n\n        /**\n         * Removes provided request object from cached requests list.\n         *\n         * @param {Object} request - Request object.\n         * @returns {DataStorage} Chainable.\n         */\n        removeRequest: function (request) {\n            var requests = this._requests,\n                index = requests.indexOf(request);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if request with a specified parameters was cached.\n         *\n         * @param {Object} params - Parameters of the request.\n         * @returns {Boolean}\n         */\n        wasRequested: function (params) {\n            return !!this.getRequest(params);\n        },\n\n        /**\n         * Handles successful data request.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} data - Response data.\n         */\n        onRequestComplete: function (params, data) {\n            this.updateData(data.items);\n\n            if (this.cacheRequests) {\n                this.cacheRequest(data, params);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function (_, registry, utils, Collapsible, confirm, alert, $t) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/grid/actions',\n            stickyTmpl: 'ui/grid/sticky/actions',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            actions: [],\n            noItemsMsg: $t('You haven\\'t selected any items!'),\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('actions');\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var data = this.getSelections(),\n                action,\n                callback;\n\n            if (!data.total) {\n                alert({\n                    content: this.noItemsMsg\n                });\n\n                return this;\n            }\n\n            action   = this.getAction(actionIndex);\n            callback = this._getCallback(action, data);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Retrieves selections data from the selections provider.\n         *\n         * @returns {Object|Undefined}\n         */\n        getSelections: function () {\n            var provider = this.selections(),\n                selections = provider && provider.getSelections();\n\n            return selections;\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex) {\n            return _.findWhere(this.actions(), {\n                type: actionIndex\n            });\n        },\n\n        /**\n         * Adds new action. If action with a specified identifier\n         * already exists, than the original one will be overrided.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Massactions} Chainable.\n         */\n        addAction: function (action) {\n            var actions = this.actions(),\n                index = _.findIndex(actions, {\n                    type: action.type\n                });\n\n            ~index ?\n                actions[index] = action :\n                actions.push(action);\n\n            this.actions(actions);\n\n            return this;\n        },\n\n        /**\n         * Creates action callback based on its' data. If action doesn't spicify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Actions' object.\n         * @param {Object} selections - Selections data.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action, selections) {\n            var callback = action.callback,\n                args     = [action, selections];\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (typeof callback != 'function') {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(null, args);\n            };\n        },\n\n        /**\n         * Default action callback. Sends selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Actions' data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm,\n                data = this.getSelections(),\n                total = data.total ? data.total : 0,\n                confirmMessage = confirmData.message + (data.showTotalRecords || data.showTotalRecords === undefined ?\n                    ' (' + total + ' record' + (total > 1 ? 's' : '') + ')'\n                    : '');\n\n            confirm({\n                title: confirmData.title,\n                content: confirmMessage,\n                actions: {\n                    confirm: callback\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'rjsResolver',\n    'uiCollection'\n], function (_, $, raf, resolver, Collection) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.documentElement.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/toolbar',\n            stickyTmpl: 'ui/grid/sticky/sticky',\n            tableSelector: 'table',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            refreshFPS: 15,\n            sticky: false,\n            visible: false,\n            _resized: true,\n            _scrolled: true,\n            _tableScrolled: true,\n            _requiredNodes: {\n                '$stickyToolbar': true,\n                '$stickyTable': true,\n                '$table': true,\n                '$sticky': true\n            },\n            stickyClass: {\n                'sticky-header': true\n            }\n        },\n\n        /**\n         * Initializes sticky toolbar component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.sticky) {\n                this.waitDOMElements()\n                    .then(this.run.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Establishes DOM elements wait process.\n         *\n         * @returns {jQueryPromise} Promise which will be resolved\n         *      when all of the required DOM elements are defined.\n         */\n        waitDOMElements: function () {\n            var _domPromise = $.Deferred();\n\n            _.bindAll(this, 'setStickyTable', 'setTableNode');\n\n            $.async({\n                ctx: ':not([data-role=\"sticky-el-root\"])',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setTableNode);\n\n            $.async({\n                ctx: '[data-role=\"sticky-el-root\"]',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setStickyTable);\n\n            this._domPromise = _domPromise;\n\n            return _domPromise.promise();\n        },\n\n        /**\n         * Defines left caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setLeftCap: function (node) {\n            this.$leftCap = node;\n        },\n\n        /**\n         * Defines right caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setRightCap: function (node) {\n            this.$rightCap = node;\n        },\n\n        /**\n         * Defines original table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setTableNode: function (node) {\n            this.$cols = node.tHead.children[0].cells;\n            this.$tableContainer = node.parentNode;\n\n            this.setNode('$table', node);\n        },\n\n        /**\n         * Defines sticky table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setStickyTable: function (node) {\n            this.$stickyCols = node.tHead.children[0].cells;\n\n            this.setNode('$stickyTable', node);\n        },\n\n        /**\n         * Defines sticky toolbar node.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyToolbarNode: function (node) {\n            this.setNode('$stickyToolbar', node);\n        },\n\n        /**\n         * Defines sticky element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyNode: function (node) {\n            this.setNode('$sticky', node);\n        },\n\n        /**\n         * Defines toolbar element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setToolbarNode: function (node) {\n            this.$toolbar = node;\n        },\n\n        /**\n         * Sets provided node as a value of 'key' property and\n         * performs check for required DOM elements.\n         *\n         * @param {String} key - Properties key.\n         * @param {HTMLElement} node - DOM element.\n         */\n        setNode: function (key, node) {\n            var nodes = this._requiredNodes,\n                promise = this._domPromise,\n                defined;\n\n            this[key] = node;\n\n            defined = _.every(nodes, function (enabled, name) {\n                return enabled ? this[name] : true;\n            }, this);\n\n            if (defined) {\n                resolver(promise.resolve, promise);\n            }\n        },\n\n        /**\n         * Starts refresh process of the sticky element\n         * and assigns DOM elements events handlers.\n         */\n        run: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                '_onWindowResize',\n                '_onWindowScroll',\n                '_onTableScroll'\n            );\n\n            $(window).on({\n                scroll: this._onWindowScroll,\n                resize: this._onWindowResize\n            });\n\n            $(this.$tableContainer).on('scroll', this._onTableScroll);\n\n            this.refresh();\n            this.checkTableWidth();\n        },\n\n        /**\n         * Refreshes state of the sticky element and\n         * invokes DOM elements events handlers\n         * if corresponding event has been triggered.\n         */\n        refresh: function () {\n            if (!raf(this.refresh, this.refreshFPS)) {\n                return;\n            }\n\n            if (this._scrolled) {\n                this.onWindowScroll();\n            }\n\n            if (this._tableScrolled) {\n                this.onTableScroll();\n            }\n\n            if (this._resized) {\n                this.onWindowResize();\n            }\n\n            if (this.visible) {\n                this.checkTableWidth();\n            }\n        },\n\n        /**\n         * Shows sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        show: function () {\n            this.visible = true;\n            //Check admin grid button has addedr not\n            if ($('.page-main-actions').length === 0) {\n                this.$sticky.style.top = 0;\n            }\n            this.$sticky.style.display = '';\n            this.$toolbar.style.visibility = 'hidden';\n\n            return this;\n        },\n\n        /**\n         * Hides sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        hide: function () {\n            this.visible = false;\n\n            this.$sticky.style.display = 'none';\n            this.$toolbar.style.visibility = '';\n\n            return this;\n        },\n\n        /**\n         * Checks if sticky toolbar covers original elements.\n         *\n         * @returns {Boolean}\n         */\n        isCovered: function () {\n            var stickyTop = this._stickyTableTop + this._wScrollTop;\n\n            return stickyTop > this._tableTop;\n        },\n\n        /**\n         * Updates offset of the sticky table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateStickyTableOffset: function () {\n            var style,\n                top;\n\n            if (this.visible) {\n                top = this.$stickyTable.getBoundingClientRect().top;\n            } else {\n                style = this.$sticky.style;\n\n                style.visibility = 'hidden';\n                style.display = '';\n\n                top = this.$stickyTable.getBoundingClientRect().top;\n\n                style.display = 'none';\n                style.visibility = '';\n            }\n\n            this._stickyTableTop = top;\n\n            return this;\n        },\n\n        /**\n         * Updates offset of the original table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableOffset: function () {\n            var box = this.$table.getBoundingClientRect(),\n                top = box.top + this._wScrollTop;\n\n            if (this._tableTop !== top) {\n                this._tableTop = top;\n\n                this.onTableTopChange(top);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if width of the table or it's columns has changed.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkTableWidth: function () {\n            var cols        = this.$cols,\n                total       = cols.length,\n                rightBorder = cols[total - 2].offsetLeft,\n                tableWidth  = this.$table.offsetWidth;\n\n            if (this._tableWidth !== tableWidth) {\n                this._tableWidth = tableWidth;\n\n                this.onTableWidthChange(tableWidth);\n            }\n\n            if (this._rightBorder !== rightBorder) {\n                this._rightBorder = rightBorder;\n\n                this.onColumnsWidthChange();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableWidth: function () {\n            this.$stickyTable.style.width = this._tableWidth + 'px';\n\n            if (this._tableWidth < this._toolbarWidth) {\n                this.checkToolbarSize();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky columns.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateColumnsWidth: function () {\n            var cols        = this.$cols,\n                index       = cols.length,\n                stickyCols  = this.$stickyCols;\n\n            while (index--) {\n                stickyCols[index].width = cols[index].offsetWidth;\n            }\n\n            return this;\n        },\n\n        /**\n         * Upadates size of the sticky toolbar element\n         * and invokes corresponding 'change' event handlers.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkToolbarSize: function () {\n            var width = this.$tableContainer.offsetWidth;\n\n            if (this._toolbarWidth !== width) {\n                this._toolbarWidth = width;\n\n                this.onToolbarWidthChange(width);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sticky toolbar visibility if it's necessary.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateVisibility: function () {\n            if (this.visible !== this.isCovered()) {\n                this.visible ? this.hide() : this.show();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates position of the left cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateLeftCap: function () {\n            locate(this.$leftCap, -this._wScrollLeft, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the right cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateRightCap: function () {\n            var left = this._toolbarWidth - this._wScrollLeft;\n\n            locate(this.$rightCap, left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableScroll: function () {\n            var container = this.$tableContainer,\n                left = container.scrollLeft + this._wScrollLeft;\n\n            locate(this.$stickyTable, -left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates width of the toolbar element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateToolbarWidth: function () {\n            this.$stickyToolbar.style.width = this._toolbarWidth + 'px';\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the toolbar element's width.\n         */\n        onToolbarWidthChange: function () {\n            this.updateToolbarWidth()\n                .updateRightCap();\n        },\n\n        /**\n         * Handles changes of the table top position.\n         */\n        onTableTopChange: function () {\n            this.updateStickyTableOffset();\n        },\n\n        /**\n         * Handles change of the table width.\n         */\n        onTableWidthChange: function () {\n            this.updateTableWidth();\n        },\n\n        /**\n         * Handles change of the table columns width.\n         */\n        onColumnsWidthChange: function () {\n            this.updateColumnsWidth();\n        },\n\n        /**\n         * Handles changes of the window's size.\n         */\n        onWindowResize: function () {\n            this.checkToolbarSize();\n\n            this._resized = false;\n        },\n\n        /**\n         * Handles changes of the original table scroll position.\n         */\n        onTableScroll: function () {\n            this.updateTableScroll();\n\n            this._tableScrolled = false;\n        },\n\n        /**\n         * Handles changes of window's scroll position.\n         */\n        onWindowScroll: function () {\n            var scrollTop = window.pageYOffset,\n                scrollLeft = window.pageXOffset;\n\n            if (this._wScrollTop !== scrollTop) {\n                this._wScrollTop = scrollTop;\n\n                this.onWindowScrollTop(scrollTop);\n            }\n\n            if (this._wScrollLeft !== scrollLeft) {\n                this._wScrollLeft = scrollLeft;\n\n                this.onWindowScrollLeft(scrollLeft);\n            }\n\n            this._scrolled = false;\n        },\n\n        /**\n         * Handles changes of windows' top scroll position.\n         */\n        onWindowScrollTop: function () {\n            this.updateTableOffset()\n                .updateVisibility();\n        },\n\n        /**\n         * Handles changes of windows' left scroll position.\n         */\n        onWindowScrollLeft: function () {\n            this.updateRightCap()\n                .updateLeftCap()\n                .updateTableScroll();\n        },\n\n        /**\n         * Original window 'scroll' event handler.\n         * Sets 'scrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowScroll: function () {\n            this._scrolled = true;\n        },\n\n        /**\n         * Original window 'resize' event handler.\n         * Sets 'resized' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowResize: function () {\n            this._resized = true;\n        },\n\n        /**\n         * Original table 'scroll' event handler.\n         * Sets '_tableScrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onTableScroll: function () {\n            this._tableScrolled = true;\n        }\n    });\n});\n","Magento_Ui/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Listing, raf, $, ko, _) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            template: 'ui/grid/masonry',\n            imports: {\n                rows: '${ $.provider }:data.items',\n                errorMessage: '${ $.provider }:data.errorMessage'\n            },\n            listens: {\n                rows: 'initComponent'\n            },\n\n            /**\n             * Images container id\n             * @param string\n             */\n            containerId: null,\n\n            /**\n             * Minimum aspect ratio for each image\n             * @param int\n             */\n            minRatio: null,\n\n            /**\n             * Container width\n             * @param int\n             */\n            containerWidth: window.innerWidth,\n\n            /**\n             * Margin between images\n             * @param int\n             */\n            imageMargin: 20,\n\n            /**\n             * Maximum image height value\n             * @param int\n             */\n            maxImageHeight: 240,\n\n            /**\n             * The value is minimum image width to height ratio when container width is less than the key\n             * @param {Object}\n             */\n            containerWidthToMinRatio: {\n                640: 3,\n                1280: 5,\n                1920: 8\n            },\n\n            /**\n             * Default minimal image width to height ratio.\n             * Applied when container width is greater than max width in the containerWidthToMinRatio matrix.\n             * @param int\n             */\n            defaultMinRatio: 10,\n\n            /**\n             * Layout update FPS during window resizing\n             */\n            refreshFPS: 60\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'rows',\n                    'errorMessage'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component handler\n         * @param {Object} rows\n         * @return {Object}\n         */\n        initComponent: function (rows) {\n            if (!rows.length) {\n                return;\n            }\n            this.imageMargin = parseInt(this.imageMargin, 10);\n            this.container = $('[data-id=\"' + this.containerId + '\"]')[0];\n\n            this.setLayoutStyles();\n            this.setEventListener();\n\n            return this;\n        },\n\n        /**\n         * Set event listener to track resize event\n         */\n        setEventListener: function () {\n            window.addEventListener('resize', function () {\n                this.updateStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Updates styles for component.\n         */\n        updateStyles: function () {\n            raf(function () {\n                this.containerWidth = window.innerWidth;\n                this.setLayoutStyles();\n            }.bind(this), this.refreshFPS);\n        },\n\n        /**\n         * Set layout styles inside the container\n         */\n        setLayoutStyles: function () {\n            var containerWidth = parseInt(this.container.clientWidth, 10),\n                rowImages = [],\n                ratio = 0,\n                rowHeight = 0,\n                calcHeight = 0,\n                isLastRow = false,\n                rowNumber = 1;\n\n            this.setMinRatio();\n\n            this.rows().forEach(function (image, index) {\n                ratio += parseFloat((image.width / image.height).toFixed(2));\n                rowImages.push(image);\n\n                if (ratio < this.minRatio && index + 1 !== this.rows().length) {\n                    // Row has more space for images and the image is not the last one - proceed to the next iteration\n                    return;\n                }\n\n                ratio = Math.max(ratio, this.minRatio);\n                calcHeight = (containerWidth - this.imageMargin * rowImages.length) / ratio;\n                rowHeight = calcHeight < this.maxImageHeight ? calcHeight : this.maxImageHeight;\n                isLastRow = index + 1 === this.rows().length;\n\n                this.assignImagesToRow(rowImages, rowNumber, rowHeight, isLastRow);\n\n                rowImages = [];\n                ratio = 0;\n                rowNumber++;\n\n            }.bind(this));\n        },\n\n        /**\n         * Apply styles, css classes and add properties for images in the row\n         *\n         * @param {Object[]} images\n         * @param {Number} rowNumber\n         * @param {Number} rowHeight\n         * @param {Boolean} isLastRow\n         */\n        assignImagesToRow: function (images, rowNumber, rowHeight, isLastRow) {\n            var imageWidth;\n\n            images.forEach(function (img) {\n                imageWidth = rowHeight * (img.width / img.height).toFixed(2);\n                this.setImageStyles(img, imageWidth, rowHeight);\n                this.setImageClass(img, {\n                    bottom: isLastRow\n                });\n                img.rowNumber = rowNumber;\n            }.bind(this));\n\n            images[0].firstInRow = true;\n            images[images.length - 1].lastInRow = true;\n        },\n\n        /**\n         * Wait for container to initialize\n         */\n        waitForContainer: function (callback) {\n            if (typeof this.container === 'undefined') {\n                setTimeout(function () {\n                    this.waitForContainer(callback);\n                }.bind(this), 500);\n            } else {\n                setTimeout(callback, 0);\n            }\n        },\n\n        /**\n         * Set layout styles when container element is loaded.\n         */\n        setLayoutStylesWhenLoaded: function () {\n            this.waitForContainer(function () {\n                this.setLayoutStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Set styles for every image in layout\n         *\n         * @param {Object} img\n         * @param {Number} width\n         * @param {Number} height\n         */\n        setImageStyles: function (img, width, height) {\n            if (!img.styles) {\n                img.styles = ko.observable();\n            }\n            img.styles({\n                width: parseInt(width, 10) + 'px',\n                height: parseInt(height, 10) + 'px'\n            });\n        },\n\n        /**\n         * Set css classes to and an image\n         *\n         * @param {Object} image\n         * @param {Object} classes\n         */\n        setImageClass: function (image, classes) {\n            if (!image.css) {\n                image.css = ko.observable(classes);\n            }\n            image.css(classes);\n        },\n\n        /**\n         * Set min ratio for images in layout\n         */\n        setMinRatio: function () {\n            var minRatio = _.find(\n                this.containerWidthToMinRatio,\n\n                /**\n                 * Find the minimal ratio for container width in the matrix\n                 *\n                 * @param {Number} ratio\n                 * @param {Number} width\n                 * @returns {Boolean}\n                 */\n                function (ratio, width) {\n                    return this.containerWidth <= width;\n                },\n                this\n            );\n\n            this.minRatio = minRatio ? minRatio : this.defaultMinRatio;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows() && !!this.rows().length;\n        },\n\n        /**\n         * Returns error message returned by the data provider\n         *\n         * @returns {String|null}\n         */\n        getErrorMessageUnsanitizedHtml: function () {\n            return this.errorMessage();\n        }\n    });\n});\n","Magento_Ui/js/grid/url-filter-applier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingNamespace: null,\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.listingNamespace }',\n            filterProvider: 'componentType = filters, ns = ${ $.listingNamespace }',\n            filterKey: 'filters',\n            searchString: location.search,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                filterComponent: '${ $.filterProvider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Apply filter\n         */\n        apply: function () {\n            var urlFilter = this.getFilterParam(this.searchString),\n                applied,\n                filters;\n\n            if (_.isUndefined(this.filterComponent())) {\n                setTimeout(function () {\n                    this.apply();\n                }.bind(this), 100);\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.apply();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n\n            if (Object.keys(urlFilter).length) {\n                applied = this.filterComponent().get('applied');\n                filters = $.extend({}, applied, urlFilter);\n                this.filterComponent().set('applied', filters);\n            }\n        },\n\n        /**\n         * Get filter param from url\n         *\n         * @returns {Object}\n         */\n        getFilterParam: function (url) {\n            var searchString = decodeURI(url),\n                itemArray;\n\n            return _.chain(searchString.slice(1).split('&'))\n                .map(function (item) {\n\n                    if (item && item.search(this.filterKey) !== -1) {\n                        itemArray = item.split('=');\n\n                        if (itemArray[1].search('\\\\[') === 0) {\n                            itemArray[1] = itemArray[1].replace(/[\\[\\]]/g, '').split(',');\n                        }\n\n                        itemArray[0] = itemArray[0].replace(this.filterKey, '')\n                                .replace(/[\\[\\]]/g, '');\n\n                        return itemArray;\n                    }\n                }.bind(this))\n                .compact()\n                .object()\n                .value();\n        }\n    });\n});\n","Magento_Ui/js/grid/cells/sanitizedHtml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'escaper'\n], function (Column, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        },\n\n        /**\n         * UnsanitizedHtml version of getSafeHtml.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeUnsanitizedHtml: function (label) {\n            return this.getSafeHtml(label);\n        }\n    });\n});\n","Magento_Ui/js/grid/search/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'mageUtils',\n    'uiElement',\n    'jquery'\n], function (_, layout, $t, utils, Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/search/search',\n            placeholder: $t('Search by keyword'),\n            label: $t('Keyword'),\n            value: '',\n            keywordUpdated: false,\n            previews: [],\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            statefull: {\n                value: true\n            },\n            tracks: {\n                value: true,\n                previews: true,\n                inputValue: true,\n                focused: true,\n                keywordUpdated: true\n            },\n            imports: {\n                inputValue: 'value',\n                updatePreview: 'value',\n                focused: false\n            },\n            exports: {\n                value: '${ $.provider }:params.search',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n            modules: {\n                chips: '${ $.chipsProvider }'\n            }\n        },\n\n        /**\n         * Initializes search component.\n         *\n         * @returns {Search} Chainable.\n         */\n        initialize: function () {\n            var urlParams = window.location.href.slice(window.location.href.search('[\\&\\?](search=)')).split('&'),\n                searchTerm = [];\n\n            this._super()\n                .initChips();\n\n            if (urlParams[0]) {\n                searchTerm = urlParams[0].split('=');\n\n                if (searchTerm[1]) {\n                    this.apply(decodeURIComponent(searchTerm[1]));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Search} Chainbale.\n         */\n        initChips: function () {\n            this.chips('insertChild', this, 0);\n\n            return this;\n        },\n\n        /**\n         * Clears search.\n         *\n         * @returns {Search} Chainable.\n         */\n        clear: function () {\n            this.value = '';\n\n            return this;\n        },\n\n        /**\n         * Click To ScrollTop.\n         */\n        scrollTo: function ($data) {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 'slow', function () {\n                $data.focused = false;\n                $data.focused = true;\n            });\n        },\n\n        /**\n         * Resets input value to the last applied state.\n         *\n         * @returns {Search} Chainable.\n         */\n        cancel: function () {\n            this.inputValue = this.value;\n\n            return this;\n        },\n\n        /**\n         * Applies search query.\n         *\n         * @param {String} [value=inputValue] - If not specified, then\n         *      value of the input field will be used.\n         * @returns {Search} Chainable.\n         */\n        apply: function (value) {\n            value = value || this.inputValue;\n\n            this.keywordUpdated = this.value !== value;\n            this.value = this.inputValue = value.trim();\n\n            return this;\n        },\n\n        /**\n         * Updates preview data.\n         *\n         * @returns {Search} Chainable.\n         */\n        updatePreview: function () {\n            var preview = [];\n\n            if (this.value) {\n                preview.push({\n                    elem: this,\n                    label: this.label,\n                    preview: this.value\n                });\n            }\n\n            this.previews = preview;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/columns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/columns',\n            minVisible: 1,\n            maxVisible: 30,\n            viewportSize: 18,\n            displayArea: 'dataGridActions',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            imports: {\n                addColumns: '${ $.columnsProvider }:elems'\n            },\n            templates: {\n                headerMsg: $t('${ $.visible } out of ${ $.total } visible')\n            }\n        },\n\n        /**\n         * Resets columns visibility to theirs default state.\n         *\n         * @returns {Columns} Chainable.\n         */\n        reset: function () {\n            this.elems.each('applyState', 'default', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Applies last saved state of columns visibility.\n         *\n         * @returns {Columns} Chainable.\n         */\n        cancel: function () {\n            this.elems.each('applyState', '', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Adds columns whose visibility can be controlled to the component.\n         *\n         * @param {Array} columns - Elements array that will be added to component.\n         * @returns {Columns} Chainable.\n         */\n        addColumns: function (columns) {\n            columns = _.where(columns, {\n                controlVisibility: true\n            });\n\n            this.insertChild(columns);\n\n            return this;\n        },\n\n        /**\n         * Defines whether child elements array length\n         * is greater than the 'viewportSize' property.\n         *\n         * @returns {Boolean}\n         */\n        hasOverflow: function () {\n            return this.elems().length > this.viewportSize;\n        },\n\n        /**\n         * Helper, checks\n         *  - if less than one item choosen\n         *  - if more then viewportMaxSize choosen\n         *\n         * @param {Object} elem\n         * @returns {Boolean}\n         */\n        isDisabled: function (elem) {\n            var visible = this.countVisible();\n\n            return elem.visible ?\n                    visible === this.minVisible :\n                    visible === this.maxVisible;\n        },\n\n        /**\n         * Counts number of visible columns.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.elems.filter('visible').length;\n        },\n\n        /**\n         * Compile header message from headerMessage setting.\n         *\n         * @returns {String}\n         */\n        getHeaderMessage: function () {\n            return utils.template(this.templates.headerMsg, {\n                visible: this.countVisible(),\n                total: this.elems().length\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/button/split.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).on('click.splitDefault', '.action-default', function () {\n            $(this).siblings('.dropdown-menu').find('.item-default').trigger('click');\n        });\n    };\n});\n","Magento_Ui/js/grid/controls/bookmarks/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ui/js/lib/core/storage/local',\n    'uiClass'\n], function ($, utils, storage, Class) {\n    'use strict';\n\n    /**\n     * Removes ns prefix for path.\n     *\n     * @param {String} ns\n     * @param {String} path\n     * @returns {String}\n     */\n    function removeNs(ns, path) {\n        return path.replace(ns + '.', '');\n    }\n\n    return Class.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                data: {\n                    namespace: '${ $.namespace }'\n                }\n            }\n        },\n\n        /**\n         * Delegates call to the localStorage adapter.\n         */\n        get: function () {\n            return {};\n        },\n\n        /**\n         * Sends request to store specified data.\n         *\n         * @param {String} path - Path by which data should be stored.\n         * @param {*} value - Value to be sent.\n         */\n        set: function (path, value) {\n            var property = removeNs(this.namespace, path),\n                data = {},\n                config;\n\n            utils.nested(data, property, value);\n\n            config = utils.extend({\n                url: this.saveUrl,\n                data: {\n                    data: JSON.stringify(data)\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        },\n\n        /**\n         * Sends request to remove specified data.\n         *\n         * @param {String} path - Path to the property to be removed.\n         */\n        remove: function (path) {\n            var property = removeNs(this.namespace, path),\n                config;\n\n            config = utils.extend({\n                url: this.deleteUrl,\n                data: {\n                    data: property\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/bookmarks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, $t, resolver, layout, Collection) {\n    'use strict';\n\n    /**\n     * Removes 'current' namespace from a 'path' string.\n     *\n     * @param {String} path\n     * @returns {String} Path without namespace.\n     */\n    function removeStateNs(path) {\n        path = typeof path == 'string' ? path.split('.') : [];\n\n        if (path[0] === 'current') {\n            path.shift();\n        }\n\n        return path.join('.');\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/bookmarks/bookmarks',\n            viewTmpl: 'ui/grid/controls/bookmarks/view',\n            newViewLabel: $t('New View'),\n            defaultIndex: 'default',\n            activeIndex: 'default',\n            viewsArray: [],\n            storageConfig: {\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                component: 'Magento_Ui/js/grid/controls/bookmarks/storage'\n            },\n            views: {\n                default: {\n                    label: $t('Default View'),\n                    index: 'default',\n                    editable: false\n                }\n            },\n            tracks: {\n                editing: true,\n                viewsArray: true,\n                activeView: true,\n                hasChanges: true,\n                customLabel: true,\n                customVisible: true\n            },\n            listens: {\n                activeIndex: 'onActiveIndexChange',\n                activeView: 'checkState',\n                current: 'onStateChange'\n            }\n        },\n\n        /**\n         * Initializes bookmarks component.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'checkState', 5);\n            utils.limit(this, 'saveState', 2000);\n\n            this._super()\n                .restore()\n                .initStorage()\n                .initViews();\n\n            return this;\n        },\n\n        /**\n         * Creates custom storage instance.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Defines default data if it wasn't gathered previously.\n         *\n         * @private\n         * @returns {Bookmarks} Chainbale.\n         */\n        initDefaultView: function () {\n            var data = this.getViewData(this.defaultIndex);\n\n            if (!_.size(data) && (this.current.columns && this.current.positions)) {\n                    this.setViewData(this.defaultIndex, this.current)\n                        .saveView(this.defaultIndex);\n                    this.defaultDefined = true;\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates instances of a previously saved views.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initViews: function () {\n            _.each(this.views, function (config) {\n                this.addView(config);\n            }, this);\n\n            this.activeView = this.getActiveView();\n\n            return this;\n        },\n\n        /**\n         * Creates complete configuration for a view.\n         *\n         * @param {Object} [config] - Additional configuration object.\n         * @returns {Object}\n         */\n        buildView: function (config) {\n            var view = {\n                label: this.newViewLabel,\n                index: '_' + Date.now(),\n                editable: true\n            };\n\n            utils.extend(view, config || {});\n\n            view.data   = view.data || utils.copy(this.current);\n            view.value  = view.label;\n\n            this.observe.call(view, true, 'label value');\n\n            return view;\n        },\n\n        /**\n         * Creates instance of a view with a provided configuration.\n         *\n         * @param {Object} [config] - View configuration.\n         * @param {Boolean} [saveView=false] - Whether to save created view automatically or not.\n         * @param {Boolean} [applyView=false] - Whether to apply created view automatically or not.\n         * @returns {View} Created view.\n         */\n        addView: function (config, saveView, applyView) {\n            var view    = this.buildView(config),\n                index   = view.index;\n\n            this.views[index] = view;\n\n            if (saveView) {\n                this.saveView(index);\n            }\n\n            if (applyView) {\n                this.applyView(index);\n            }\n\n            this.updateArray();\n\n            return view;\n        },\n\n        /**\n         * Removes specified view.\n         *\n         * @param {String} index - Index of a view to be removed.\n         * @returns {Bookmarks} Chainable.\n         */\n        removeView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            if (this.isViewActive(index)) {\n                this.applyView(this.defaultIndex);\n            }\n\n            this.endEdit(index)\n                .remove(viewPath)\n                .removeStored(viewPath)\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Saves data of a specified view.\n         *\n         * @param {String} index - Index of a view to be saved.\n         * @returns {Bookmarks} Chainable.\n         */\n        saveView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            this.updateViewLabel(index)\n                .endEdit(index)\n                .store(viewPath)\n                .checkState();\n\n            return this;\n        },\n\n        /**\n         * Sets specified view as active\n         * and applies its' state.\n         *\n         * @param {String} index - Index of a view to be applied.\n         * @returns {Bookmarks} Chainable.\n         */\n        applyView: function (index) {\n            this.applyStateOf(index)\n                .set('activeIndex', index);\n\n            return this;\n        },\n\n        /**\n         * Updates data of a specified view if it's\n         * currently active and saves its' data.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateAndSave: function (index) {\n            if (this.isViewActive(index)) {\n                this.updateActiveView(index);\n            }\n\n            this.saveView(index);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified view.\n         *\n         * @param {String} index - Index of a view to be retrieved.\n         * @returns {View}\n         */\n        getView: function (index) {\n            return this.views[index];\n        },\n\n        /**\n         * Returns instance of an active view.\n         *\n         * @returns {View}\n         */\n        getActiveView: function () {\n            return this.views[this.activeIndex];\n        },\n\n        /**\n         * Checks if specified view is active.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isViewActive: function (index) {\n            return this.activeView === this.getView(index);\n        },\n\n        /**\n         * Sets current state as a data of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        updateActiveView: function () {\n            this.setViewData(this.activeIndex, this.current);\n\n            return this;\n        },\n\n        /**\n         * Replaces label a view with a provided one.\n         * If new label is not specified, then views'\n         * 'value' property will be taken.\n         *\n         * @param {String} index - Index of a view.\n         * @param {String} [label=view.value] - New labels' value.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateViewLabel: function (index, label) {\n            var view    = this.getView(index),\n                current = view.label;\n\n            label = (label || view.value).trim() || current;\n            label = this.uniqueLabel(label, current);\n\n            view.label = view.value = label;\n\n            return this;\n        },\n\n        /**\n         * Retrieves data of a specified view.\n         *\n         * @param {String} index - Index of a view whose data should be retrieved.\n         * @param {String} [property] - If not specified then whole views' data will be retrieved.\n         * @returns {Object} Views' data.\n         */\n        getViewData: function (index, property) {\n            var view = this.getView(index),\n                data = view.data;\n\n            if (property) {\n                data = utils.nested(data, property);\n            }\n\n            return utils.copy(data);\n        },\n\n        /**\n         * Sets data to the specified view.\n         *\n         * @param {String} index - Index of a view whose data will be replaced.\n         * @param {Object} data - New view data.\n         * @returns {Bookmarks} Chainable.\n         */\n        setViewData: function (index, data) {\n            var path = this.getViewPath(index) + '.data';\n\n            this.set(path, utils.copy(data));\n\n            return this;\n        },\n\n        /**\n         * Starts editing of a specified view.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        editView: function (index) {\n            this.editing = index;\n\n            return this;\n        },\n\n        /**\n         * Ends editing of specified view\n         * and restores its' label.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        endEdit: function (index) {\n            var view;\n\n            if (!this.isEditing(index)) {\n                return this;\n            }\n\n            index   = index || this.editing;\n            view    = this.getView(index);\n\n            view.value = view.label;\n\n            this.editing = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if specified view is in editing state.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (index) {\n            return this.editing === index;\n        },\n\n        /**\n         * Generates label unique among present views, based\n         * on the incoming label pattern.\n         *\n         * @param {String} [label=this.newViewLabel] - Label pattern.\n         * @param {String} [exclude]\n         * @returns {String}\n         */\n        uniqueLabel: function (label, exclude) {\n            var labels      = _.pluck(this.views, 'label'),\n                hasParenth  = _.last(label) === ')',\n                index       = 2,\n                result,\n                suffix;\n\n            labels = _.without(labels, exclude);\n            result = label = label || this.newViewLabel;\n\n            for (index = 2; _.contains(labels, result); index++) {\n                suffix = '(' + index + ')';\n\n                if (!hasParenth) {\n                    suffix = ' ' + suffix;\n                }\n\n                result = label + suffix;\n            }\n\n            return result;\n        },\n\n        /**\n         * Applies state of a specified view, without\n         * making it active.\n         *\n         * @param {String} [state=this.activeIndex]\n         * @param {String} [property]\n         * @returns {Bookmarks} Chainable.\n         */\n        applyStateOf: function (state, property) {\n            var index    = state || this.activeIndex,\n                dataPath = removeStateNs(property),\n                viewData = this.getViewData(index, dataPath);\n\n            dataPath = dataPath ?\n                'current.' + dataPath :\n                'current';\n\n            this.set(dataPath, viewData);\n\n            return this;\n        },\n\n        /**\n         * Saves current state.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        saveState: function () {\n            this.store('current');\n            return this;\n        },\n\n        /**\n         * Applies state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        resetState: function () {\n            this.applyStateOf(this.activeIndex);\n\n            return this;\n        },\n\n        /**\n         * Checks if current state is different\n         * from the state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        checkState: function () {\n            var viewData = this.getViewData(this.activeIndex),\n                diff     = utils.compare(viewData, this.current);\n\n            this.hasChanges = !diff.equal;\n\n            return this;\n        },\n\n        /**\n         * Returns path to the view instance,\n         * based on a provided index.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {String}\n         */\n        getViewPath: function (index) {\n            return 'views.' + index;\n        },\n\n        /**\n         * Updates the array of views.\n         *\n         * @returns {Bookmarks} Chainable\n         */\n        updateArray: function () {\n            this.viewsArray = _.values(this.views);\n\n            return this;\n        },\n\n        /**\n         * Shows custom view field and creates unique label for it.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        showCustom: function () {\n            this.customLabel    = this.uniqueLabel();\n            this.customVisible  = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if custom view field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Creates new view instance with a label specified\n         * in a custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        applyCustom: function () {\n            var label = this.customLabel.trim();\n\n            this.hideCustom()\n                .addView({\n                    label: this.uniqueLabel(label)\n                }, true, true);\n\n            return this;\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onActiveIndexChange: function () {\n            this.activeView = this.getActiveView();\n            this.updateActiveView();\n            this.store('activeIndex');\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onStateChange: function () {\n            this.checkState();\n            this.saveState();\n\n            if (!this.defaultDefined) {\n                resolver(this.initDefaultView, this);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mageUtils',\n    'Magento_Ui/js/form/components/group',\n    'mage/translate'\n], function (_, layout, utils, Group, $t) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            template: 'ui/grid/filters/elements/group',\n            isRange: true,\n            templates: {\n                base: {\n                    parent: '${ $.$data.group.name }',\n                    provider: '${ $.$data.group.provider }',\n                    template: 'ui/grid/filters/field'\n                },\n                date: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter'\n                },\n                datetime: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter',\n                    options: {\n                        showsTime: true\n                    }\n                },\n                text: {\n                    component: 'Magento_Ui/js/form/element/abstract'\n                },\n                ranges: {\n                    from: {\n                        label: $t('from'),\n                        dataScope: 'from'\n                    },\n                    to: {\n                        label: $t('to'),\n                        dataScope: 'to'\n                    }\n                }\n            }\n        },\n\n        /**\n         * Initializes range component.\n         *\n         * @returns {Range} Chainable.\n         */\n        initialize: function (config) {\n            if (config.dateFormat) {\n                this.constructor.defaults.templates.date.pickerDefaultDateFormat = config.dateFormat;\n            }\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Creates instances of child components.\n         *\n         * @returns {Range} Chainable.\n         */\n        initChildren: function () {\n            var children = this.buildChildren();\n\n            layout(children);\n\n            return this;\n        },\n\n        /**\n         * Creates configuration for the child components.\n         *\n         * @returns {Object}\n         */\n        buildChildren: function () {\n            var templates   = this.templates,\n                typeTmpl    = templates[this.rangeType],\n                tmpl        = utils.extend({}, templates.base, typeTmpl),\n                children    = {};\n\n            _.each(templates.ranges, function (range, key) {\n                children[key] = utils.extend({}, tmpl, range);\n            });\n\n            return utils.template(children, {\n                group: this\n            }, true, true);\n        },\n\n        /**\n         * Clears childrens data.\n         *\n         * @returns {Range} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Checks if some children has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return this.elems.some('hasData');\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection',\n    'mage/translate',\n    'jquery'\n], function (_, utils, layout, Collection, $t, $) {\n    'use strict';\n\n    /**\n     * Extracts and formats preview of an element.\n     *\n     * @param {Object} elem - Element whose preview should be extracted.\n     * @returns {Object} Formatted data.\n     */\n    function extractPreview(elem) {\n        return {\n            label: elem.label,\n            preview: elem.getPreview(),\n            elem: elem\n        };\n    }\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        var result = utils.mapRecursive(data, utils.removeEmptyValues.bind(utils));\n\n        return utils.mapRecursive(result, function (value) {\n            return _.isString(value) ? value.trim() : value;\n        });\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/filters',\n            stickyTmpl: 'ui/grid/sticky/filters',\n            _processed: [],\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            bookmarksProvider: 'ns = ${ $.ns }, componentType = bookmark',\n            applied: {\n                placeholder: true\n            },\n            filters: {\n                placeholder: true\n            },\n            templates: {\n                filters: {\n                    base: {\n                        parent: '${ $.$data.filters.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.filters.name }',\n                        dataScope: '${ $.$data.column.index }',\n                        label: '${ $.$data.column.label }',\n                        imports: {\n                            visible: '${ $.$data.column.name }:visible'\n                        }\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/grid/filters/field'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/grid/filters/field',\n                        options: '${ JSON.stringify($.$data.column.options) }',\n                        caption: ' '\n                    },\n                    dateRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'date'\n                    },\n                    datetimeRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'datetime'\n                    },\n                    textRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'text'\n                    }\n                }\n            },\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Ui/js/grid/filters/chips'\n            },\n            listens: {\n                active: 'updatePreviews',\n                applied: 'cancel updateActive'\n            },\n            statefull: {\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.filters'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems',\n                onBackendError: '${ $.provider }:lastError',\n                bookmarksActiveIndex: '${ $.bookmarksProvider }:activeIndex'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                chips: '${ $.chipsConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes filters component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initialize: function (config) {\n            if (typeof config.options !== 'undefined' && config.options.dateFormat) {\n                this.constructor.defaults.templates.filters.dateRange.dateFormat = config.options.dateFormat;\n            }\n            _.bindAll(this, 'updateActive');\n\n            this._super()\n                .initChips()\n                .cancel();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    active: [],\n                    previews: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initChips: function () {\n            layout([this.chipsConfig]);\n\n            this.chips('insertChild', this.name);\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to filters collection.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on('elems', this.updateActive);\n\n            this.updateActive();\n\n            return this;\n        },\n\n        /**\n         * Clears filters data.\n         *\n         * @param {Object} [filter] - If provided, then only specified\n         *      filter will be cleared. Otherwise, clears all data.\n         * @returns {Filters} Chainable.\n         */\n        clear: function (filter) {\n            filter ?\n                filter.clear() :\n                _.invoke(this.active, 'clear');\n\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Sets filters data to the applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        apply: function () {\n            if (typeof $('body').notification === 'function') {\n                $('body').notification('clear');\n            }\n            this.set('applied', removeEmpty(this.filters));\n            return this;\n        },\n\n        /**\n         * Resets filters to the last applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        cancel: function () {\n            this.set('filters', utils.copy(this.applied));\n\n            return this;\n        },\n\n        /**\n         * Sets provided data to filter components (without applying it).\n         *\n         * @param {Object} data - Filters data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current filters data or to extend it.\n         * @returns {Filters} Chainable.\n         */\n        setData: function (data, partial) {\n            var filters = partial ? this.filters : {};\n\n            data = utils.extend({}, filters, data);\n\n            this.set('filters', data);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a filter associated with the provided column.\n         *\n         * @param {Column} column - Column component for which to create a filter.\n         * @returns {Filters} Chainable.\n         */\n        addFilter: function (column) {\n            var index       = column.index,\n                processed   = this._processed,\n                filter;\n\n            if (!column.filter || _.contains(processed, index)) {\n                return this;\n            }\n\n            filter = this.buildFilter(column);\n\n            processed.push(index);\n\n            layout([filter]);\n\n            return this;\n        },\n\n        /**\n         * Creates filter component configuration associated with the provided column.\n         *\n         * @param {Column} column - Column component with a basic filter declaration.\n         * @returns {Object} Filters' configuration.\n         */\n        buildFilter: function (column) {\n            var filters = this.templates.filters,\n                filter  = column.filter,\n                type    = filters[filter.filterType];\n\n            if (_.isObject(filter) && type) {\n                filter = utils.extend({}, type, filter);\n            } else if (_.isString(filter)) {\n                filter = filters[filter];\n            }\n\n            filter = utils.extend({}, filters.base, filter);\n            //Accepting labels as is.\n            filter.__disableTmpl = {\n                label: 1,\n                options: 1\n            };\n\n            filter = utils.template(filter, {\n                filters: this,\n                column: column\n            }, true, true);\n\n            filter.__disableTmpl = {\n                label: true\n            };\n\n            return filter;\n        },\n\n        /**\n         * Returns an array of range filters.\n         *\n         * @returns {Array}\n         */\n        getRanges: function () {\n            return this.elems.filter(function (filter) {\n                return filter.isRange;\n            });\n        },\n\n        /**\n         * Returns an array of non-range filters.\n         *\n         * @returns {Array}\n         */\n        getPlain: function () {\n            return this.elems.filter(function (filter) {\n                return !filter.isRange;\n            });\n        },\n\n        /**\n         * Tells wether specified filter should be visible.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterVisible: function (filter) {\n            return filter.visible() || this.isFilterActive(filter);\n        },\n\n        /**\n         * Checks if specified filter is active.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterActive: function (filter) {\n            return _.contains(this.active, filter);\n        },\n\n        /**\n         * Checks if collection has visible filters.\n         *\n         * @returns {Boolean}\n         */\n        hasVisible: function () {\n            return this.elems.some(this.isFilterVisible, this);\n        },\n\n        /**\n         * Finds filters with a not empty data\n         * and sets them to the 'active' filters array.\n         *\n         * @returns {Filters} Chainable.\n         */\n        updateActive: function () {\n            var applied = _.keys(this.applied);\n\n            this.active = this.elems.filter(function (elem) {\n                return _.contains(applied, elem.index);\n            });\n\n            return this;\n        },\n\n        /**\n         * Returns number of applied filters.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.active.length;\n        },\n\n        /**\n         * Extract previews of a specified filters.\n         *\n         * @param {Array} filters - Filters to be processed.\n         * @returns {Filters} Chainable.\n         */\n        updatePreviews: function (filters) {\n            var previews = filters.map(extractPreview);\n\n            this.previews = _.compact(previews);\n\n            return this;\n        },\n\n        /**\n         * Listener of the columns provider children array changes.\n         *\n         * @param {Array} columns - Current columns list.\n         */\n        onColumnsUpdate: function (columns) {\n            columns.forEach(this.addFilter, this);\n        },\n\n        /**\n         * Provider ajax error listener.\n         *\n         * @param {bool} isError - Selected index of the filter.\n         */\n        onBackendError: function (isError) {\n            var defaultMessage = 'Something went wrong with processing the default view and we have restored the ' +\n                    'filter to its original state.',\n                customMessage  = 'Something went wrong with processing current custom view and filters have been ' +\n                    'reset to its original state. Please edit filters then click apply.';\n\n            if (isError) {\n                this.clear();\n\n                $('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: $.mage.__(this.bookmarksActiveIndex !== 'default' ? customMessage : defaultMessage),\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            var $wrapper = $('<div></div>').html(message);\n\n                            $('.page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/chips',\n            componentType: 'filtersChips'\n        },\n\n        /**\n         * Defines if some of components' children has available previews.\n         *\n         * @returns {Boolean}\n         */\n        hasPreviews: function () {\n            return this.elems().some(function (elem) {\n                return !!elem.previews.length;\n            });\n        },\n\n        /**\n         * Calls clear method on all of its' children.\n         *\n         * @returns {Chips} Chainable.\n         */\n        clear: function () {\n            _.invoke(this.elems(), 'clear');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/elements/ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            bookmarkProvider: 'ns = ${ $.ns }, index = bookmarks',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true,\n            imports: {\n                applied: '${ $.filterChipsProvider }:applied',\n                activeIndex: '${ $.bookmarkProvider }:activeIndex'\n            },\n            modules: {\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                activeIndex: 'validateInitialValue',\n                applied: 'validateInitialValue'\n            }\n\n        },\n\n        /**\n         * Initializes UiSelect component.\n         *\n         * @returns {UiSelect} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (_.isEmpty(this.value())) {\n                this.validationLoading(false);\n\n                return;\n            }\n\n            $.ajax({\n                url: this.validationUrl,\n                type: 'GET',\n                dataType: 'json',\n                context: this,\n                data: {\n                    ids: this.value()\n                },\n\n                /** @param {Object} response */\n                success: function (response) {\n                    if (!_.isEmpty(response)) {\n                        this.options([]);\n                        this.success({\n                            options: response\n                        });\n                    }\n                    this.filterChips().updateActive();\n                },\n\n                /** set empty array if error occurs */\n                error: function () {\n                    this.options([]);\n                },\n\n                /** stop loader */\n                complete: function () {\n                    this.validationLoading(false);\n                    this.setCaption();\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/sticky/sticky.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/lib/view/utils/raf'\n], function ($, _, Component, raf) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingSelector: '${ $.listingProvider }::not([data-role = \"sticky-el-root\"])',\n            toolbarSelector: '${ $.toolbarProvider }::not([data-role = \"sticky-el-root\"])',\n            bulkRowSelector: '[data-role = \"data-grid-bulk-row\"]',\n            bulkRowHeaderSelector: '.data-grid-info-panel:visible',\n            tableSelector: 'table',\n            columnSelector: 'thead tr th',\n            rowSelector: 'tbody tr',\n            toolbarCollapsiblesSelector: '[data-role=\"toolbar-menu-item\"]',\n            toolbarCollapsiblesActiveClass: '_active',\n            template: 'ui/grid/sticky/sticky',\n            stickyContainerSelector: '.sticky-header',\n            stickyElementSelector: '[data-role = \"sticky-el-root\"]',\n            leftDataGridCapSelector: '.data-grid-cap-left',\n            rightDataGridCapSelector: '.data-grid-cap-right',\n            visible: false,\n            enableToolbar: true,\n            enableHeader: true,\n            modules: {\n                toolbar: '${ $.toolbarProvider }',\n                listing: '${ $.listingProvider }'\n            },\n            otherStickyElsSize: 77,\n            containerNode: null,\n            listingNode: null,\n            toolbarNode: null,\n            stickyListingNode: null,\n            stickyToolbarNode: null,\n            storedOriginalToolbarElements: [],\n            cache: {},\n            flags: {},\n            dirtyFlag: 'dirty'\n        },\n\n        /**\n         * Initializes Sticky component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'adjustStickyElems',\n                'initListingNode',\n                'initToolbarNode',\n                'initContainerNode',\n                'initColumns',\n                'initStickyListingNode',\n                'initStickyToolbarNode',\n                'initLeftDataGridCap',\n                'initRightDataGridCap'\n            );\n\n            $.async(this.listingSelector,\n                this.initListingNode);\n            $.async(this.toolbarSelector,\n                this.initToolbarNode);\n\n            $.async(this.stickyContainerSelector,\n                this,\n                this.initContainerNode);\n\n            return this;\n        },\n\n        /**\n         * Init observables\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('visible');\n\n            return this;\n        },\n\n        /**\n         * Init original listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initListingNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.listingNode = $(node);\n            $.async(this.columnSelector, node, this.initColumns);\n        },\n\n        /**\n         * Init original toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initToolbarNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.toolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyListingNode: function (node) {\n            this.stickyListingNode = $(node);\n            this.checkPos();\n            this.initListeners();\n        },\n\n        /**\n         * Init sticky toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyToolbarNode: function (node) {\n            this.stickyToolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky header container node\n         *\n         * @param {HTMLElement} node\n         */\n        initContainerNode: function (node) {\n            this.containerNode = $(node);\n\n            $.async(this.leftDataGridCapSelector,\n                node,\n                this.initLeftDataGridCap);\n            $.async(this.rightDataGridCapSelector,\n                node,\n                this.initRightDataGridCap);\n\n            $.async(this.stickyElementSelector,\n                this.listing(),\n                this.initStickyListingNode);\n            $.async(this.stickyElementSelector,\n                this.toolbar(),\n                this.initStickyToolbarNode);\n        },\n\n        /**\n         * Init columns (each time when amount of columns is changed)\n         *\n         */\n        initColumns: function () {\n            this.columns = this.listingNode.find(this.columnSelector);\n        },\n\n        /**\n         * Init left DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initLeftDataGridCap: function (node) {\n            this.leftDataGridCap = $(node);\n        },\n\n        /**\n         * Init right DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initRightDataGridCap: function (node) {\n            this.rightDataGridCap = $(node);\n        },\n\n        /**\n         * Init listeners\n         *\n         * @returns {Object} Chainable.\n         */\n        initListeners: function () {\n            this.adjustStickyElems();\n            this.initOnResize()\n                .initOnScroll()\n                .initOnListingScroll();\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnScroll: function () {\n            this.lastHorizontalScrollPos = $(window).scrollLeft();\n            document.addEventListener('scroll', function () {\n                this.flags.scrolled = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to original listing scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnListingScroll: function () {\n            $(this.listingNode).on('scroll', function (e) {\n                this.flags.listingScrolled = true;\n                this.flags.listingScrolledValue = $(e.target).scrollLeft();\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window resize event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnResize: function () {\n            $(window).on('resize', function () {\n                this.flags.resized = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Adjust sticky header elements according to flags of the events that have happened in the endless RAF loop\n         */\n        adjustStickyElems: function () {\n            if (this.flags.resized ||\n                this.flags.scrolled) {\n                this.checkPos();\n            }\n\n            if (this.visible) {\n                this.checkTableElemsWidth();\n\n                if (this.flags.originalWidthChanged) {\n                    this.adjustContainerElemsWidth();\n                }\n\n                if (this.flags.resized) {\n                    this.onResize();\n                }\n\n                if (this.flags.scrolled) {\n                    this.onWindowScroll();\n                }\n\n                if (this.flags.listingScrolled) {\n                    this.onListingScroll(this.flags.listingScrolledValue);\n                }\n            }\n            _.each(this.flags, function (val, key) {\n                if (val === this.dirtyFlag) {\n                    this.flags[key] = false;\n                } else if (val) {\n                    this.flags[key] = this.dirtyFlag;\n                }\n            }, this);\n\n            raf(this.adjustStickyElems);\n        },\n\n        /**\n         * Handles window scroll\n         */\n        onWindowScroll: function () {\n            var scrolled = $(window).scrollLeft(),\n                horizontal = this.lastHorizontalScrollPos !== scrolled;\n\n            if (horizontal) {\n                this.adjustOffset()\n                    .adjustDataGridCapPositions();\n                this.lastHorizontalScrollPos = scrolled;\n            } else {\n                this.checkPos();\n            }\n        },\n\n        /**\n         * Handles original listing scroll\n         *\n         * @param {Number} scrolled\n         */\n        onListingScroll: function (scrolled) {\n            this.adjustOffset(scrolled);\n        },\n\n        /**\n         * Handles window resize\n         */\n        onResize: function () {\n            this.checkPos();\n            this.adjustContainerElemsWidth()\n                .adjustDataGridCapPositions();\n        },\n\n        /**\n         * Check if original table or columns change it dimensions and sets appropriate flag\n         */\n        checkTableElemsWidth: function () {\n            var newWidth = this.getTableWidth();\n\n            if (this.cache.tableWidth !== newWidth) {\n                this.cache.tableWidth = newWidth;\n                this.flags.originalWidthChanged = true;\n            } else if (this.cache.colChecksum !== this.getColsChecksum()) {\n                this.cache.colChecksum = this.getColsChecksum();\n                this.flags.originalWidthChanged = true;\n            }\n        },\n\n        /**\n         * Get the checksum of original columns width\n         *\n         * @returns {Number}.\n         */\n        getColsChecksum: function () {\n            return _.reduce(this.columns,\n            function (pv, cv) {\n                return ($(pv).width() || pv) + '' + $(cv).width();\n            });\n        },\n\n        /**\n         * Get the width of the sticky table wrapper\n         *\n         * @returns {Number}.\n         */\n        getListingWidth: function () {\n            return this.listingNode.width();\n        },\n\n        /**\n         * Get the width of the original table\n         *\n         * @returns {Number}.\n         */\n        getTableWidth: function () {\n            return this.listingNode.find(this.tableSelector).width();\n        },\n\n        /**\n         * Get the top elem: header or toolbar\n         *\n         * @returns {HTMLElement}.\n         */\n        getTopElement: function () {\n            return this.toolbarNode || this.listingNode;\n        },\n\n        /**\n         * Get the height of the other sticky elem (Page header)\n         *\n         * @returns {Number}.\n         */\n        getOtherStickyElementsSize: function () {\n            return this.otherStickyElsSize;\n        },\n\n        /**\n         * Get original bulk row height, if is visible\n         *\n         * @returns {Number}.\n         */\n        getBulkRowHeight: function () {\n            return this.listingNode.find(this.bulkRowSelector).filter(':visible').height();\n        },\n\n        /**\n         * Get top Y coord of the sticky header\n         *\n         * @returns {Number}.\n         */\n        getListingTopYCoord: function () {\n            var bulkRowHeight = this.getBulkRowHeight();\n\n            return this.listingNode.find('tbody').offset().top -\n                this.containerNode.height() -\n                $(window).scrollTop() +\n                bulkRowHeight;\n        },\n\n        /**\n         * Check if sticky header must be visible\n         *\n         * @returns {Boolean}.\n         */\n        getMustBeSticky: function () {\n            var stickyTopCondition = this.getListingTopYCoord() - this.getOtherStickyElementsSize(),\n                stickyBottomCondition = this.listingNode.offset().top +\n                    this.listingNode.height() -\n                    $(window).scrollTop() +\n                    this.getBulkRowHeight() -\n                    this.getOtherStickyElementsSize();\n\n            return stickyTopCondition < 0 && stickyBottomCondition > 0;\n        },\n\n        /**\n         * Resize sticky header and cols\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustContainerElemsWidth: function () {\n            this.resizeContainer()\n                .resizeCols()\n                .resizeBulk();\n\n            return this;\n        },\n\n        /**\n         * Resize sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeContainer: function () {\n            var listingWidth = this.getListingWidth();\n\n            this.stickyListingNode.innerWidth(listingWidth);\n            this.stickyListingNode.find(this.tableSelector).innerWidth(this.getTableWidth());\n\n            if (this.stickyToolbarNode) {\n                this.stickyToolbarNode.innerWidth(listingWidth);\n            }\n\n            return this;\n        },\n\n        /**\n         * Resize sticky cols\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeCols: function () {\n            var cols = this.listingNode.find(this.columnSelector);\n\n            this.stickyListingNode.find(this.columnSelector).each(function (ind) {\n                var originalColWidth =  $(cols[ind]).width();\n\n                $(this).width(originalColWidth);\n            });\n\n            return this;\n        },\n\n        /**\n         * Resize bulk row header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeBulk: function () {\n            var bulk = this.containerNode.find(this.bulkRowHeaderSelector)[0];\n\n            if (bulk) {\n                $(bulk).innerWidth(this.getListingWidth());\n            }\n\n            return this;\n        },\n\n        /**\n         * Reset viewport to the top of listing\n         */\n        resetToTop: function () {\n            var posOfTopEl = this.getTopElement().offset().top - this.getOtherStickyElementsSize() || 0;\n\n            $(window).scrollTop(posOfTopEl);\n        },\n\n        /**\n         * Adjust sticky header offset\n         *\n         * @param {Number} val\n         * @returns {Object} Chainable.\n         */\n        adjustOffset: function (val) {\n            val = val || this.listingNode.scrollLeft();\n            this.stickyListingNode.offset({\n                left: this.listingNode.offset().left - val\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust both DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustDataGridCapPositions: function () {\n            this.adjustLeftDataGridCapPos()\n                .adjustRightDataGridCapPos();\n\n            return this;\n        },\n\n        /**\n         * Adjust left DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustLeftDataGridCapPos: function () {\n            this.leftDataGridCap.offset({\n                left: this.listingNode.offset().left - this.leftDataGridCap.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust right DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustRightDataGridCapPos: function () {\n            this.rightDataGridCap.offset({\n                left: this.listingNode.offset().left + this.listingNode.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Hides the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        collapseOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'hidden');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'hidden');\n        },\n\n        /**\n         * Restores the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        restoreOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'visible');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'visible');\n        },\n\n        /**\n         * Toggle the visibility of sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleContainerVisibility: function () {\n            this.visible = !this.visible;\n\n            return this;\n        },\n\n        /**\n         * Checks position of the listing to know if need to show/hide sticky header\n         *\n         * @returns {Boolean} whether the visibility of the sticky header was toggled.\n         */\n        checkPos: function () {\n            var isSticky = this.visible,\n                mustBeSticky = this.getMustBeSticky(),\n                needChange = isSticky !== mustBeSticky;\n\n            if (needChange) {\n                if (mustBeSticky) {\n                    this.collapseOriginalElements();\n                    this.toggleContainerVisibility();\n                    this.adjustContainerElemsWidth()\n                        .adjustOffset()\n                        .adjustDataGridCapPositions();\n\n                } else {\n                    this.toggleContainerVisibility();\n                    this.restoreOriginalElements();\n                }\n            }\n\n            return needChange;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            validateBeforeSave: true,\n            requestConfig: {\n                dataType: 'json',\n                type: 'POST'\n            }\n        },\n\n        /**\n         * Initializes client instance.\n         *\n         * @returns {Client} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onSuccess', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Sends XMLHttpRequest with a provided configuration.\n         *\n         * @param {Object} config - Configuration of request.\n         * @returns {jQueryPromise}\n         */\n        send: function (config) {\n            var deffer  = $.Deferred();\n\n            config = utils.extend({}, this.requestConfig, config);\n\n            $.ajax(config)\n                .done(_.partial(this.onSuccess, deffer))\n                .fail(_.partial(this.onError, deffer));\n\n            return deffer.promise();\n        },\n\n        /**\n         * Proxy save method which might invoke\n         * data validation prior to its' saving.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {jQueryPromise}\n         */\n        save: function (data) {\n            var save = this._save.bind(this, data);\n\n            return this.validateBeforeSave ?\n                this.validate(data).pipe(save) :\n                save();\n        },\n\n        /**\n         * Sends request to validate provided data.\n         *\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        validate: function (data) {\n            return this.send({\n                url: this.validateUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Sends request to save provided data.\n         *\n         * @private\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        _save: function (data) {\n            return this.send({\n                url: this.saveUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Creates error object with a provided message.\n         *\n         * @param {String} msg - Errors' message.\n         * @returns {Object}\n         */\n        createError: function (msg) {\n            return {\n                type: 'error',\n                message: msg\n            };\n        },\n\n        /**\n         * Handles ajax error callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be rejected.\n         * @param {jQueryXHR} xhr - See 'jquery' ajax error callback.\n         * @param {String} status - See 'jquery' ajax error callback.\n         * @param {(String|Object)} err - See 'jquery' ajax error callback.\n         */\n        onError: function (promise, xhr, status, err) {\n            var msg;\n\n            msg = xhr.status !== 200 ?\n                xhr.status + ' (' + xhr.statusText + ')' :\n                err;\n\n            promise.reject(this.createError(msg));\n        },\n\n        /**\n         * Handles ajax success callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be resolved.\n         * @param {*} data - See 'jquery' ajax success callback.\n         */\n        onSuccess: function (promise, data) {\n            var errors;\n\n            if (data.error) {\n                errors = _.map(data.messages, this.createError, this);\n\n                promise.reject(errors);\n            } else {\n                promise.resolve(data);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            active: true,\n            hasChanges: false,\n            fields: [],\n            errorsCount: 0,\n            fieldTmpl: 'ui/grid/editing/field',\n            rowTmpl: 'ui/grid/editing/row',\n            templates: {\n                fields: {\n                    base: {\n                        parent: '${ $.$data.record.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.record.name }',\n                        dataScope: 'data.${ $.$data.column.index }',\n                        imports: {\n                            disabled: '${ $.$data.record.parentName }:fields.${ $.$data.column.index }.disabled'\n                        },\n                        isEditor: true\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/form/element/input'\n                    },\n                    date: {\n                        component: 'Magento_Ui/js/form/element/date',\n                        template: 'ui/form/element/date',\n                        dateFormat: 'MMM d, y h:mm:ss a'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/form/element/select',\n                        options: '${ JSON.stringify($.$data.column.options) }'\n                    }\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            listens: {\n                elems: 'updateFields',\n                data: 'updateState'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                editor: '${ $.editorProvider }'\n            }\n        },\n\n        /**\n         * Initializes record component.\n         *\n         * @returns {Record} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'countErrors');\n            utils.limit(this, 'updateState', 10);\n\n            return this._super();\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Record} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('errorsCount hasChanges')\n                .observe('active fields');\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a field.\n         *\n         * @returns {Record} Chainable.\n         */\n        initElement: function (field) {\n            field.on('error', this.countErrors);\n\n            return this._super();\n        },\n\n        /**\n         * Creates new instance of a field.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Record} Chainable.\n         */\n        initField: function (column) {\n            var field = this.buildField(column);\n\n            layout([field]);\n\n            return this;\n        },\n\n        /**\n         * Builds fields' configuration described in a provided column.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Object} Complete fields' configuration.\n         */\n        buildField: function (column) {\n            var fields = this.templates.fields,\n                field  = column.editor;\n\n            if (_.isObject(field) && field.editorType) {\n                field = utils.extend({}, fields[field.editorType], field);\n            } else if (_.isString(field)) {\n                field = fields[field];\n            }\n\n            field = utils.extend({}, fields.base, field);\n\n            return utils.template(field, {\n                record: this,\n                column: column\n            }, true, true);\n        },\n\n        /**\n         * Creates fields for the specified columns.\n         *\n         * @param {Array} columns - An array of column instances.\n         * @returns {Record} Chainable.\n         */\n        createFields: function (columns) {\n            columns.forEach(function (column) {\n                if (column.editor && !this.hasChild(column.index)) {\n                    this.initField(column);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a column found by provided index.\n         *\n         * @param {String} index - Index of a column (e.g. 'title').\n         * @returns {Column}\n         */\n        getColumn: function (index) {\n            return this.columns().getChild(index);\n        },\n\n        /**\n         * Returns records' current data object.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            return this.filterData(this.data);\n        },\n\n        /**\n         * Returns saved records' data. Data will be processed\n         * with a 'filterData' and 'normalizeData' methods.\n         *\n         * @returns {Object} Saved records' data.\n         */\n        getSavedData: function () {\n            var editor      = this.editor(),\n                savedData   = editor.getRowData(this.index);\n\n            savedData = this.filterData(savedData);\n\n            return this.normalizeData(savedData);\n        },\n\n        /**\n         * Replaces current records' data with the provided one.\n         *\n         * @param {Object} data - New records data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current data or to extend it.\n         * @returns {Record} Chainable.\n         */\n        setData: function (data, partial) {\n            var currentData = partial ? this.data : {};\n\n            data = this.normalizeData(data);\n            data = utils.extend({}, currentData, data);\n\n            this.set('data', data)\n                .updateState();\n\n            return this;\n        },\n\n        /**\n         * Filters provided object extracting from it values\n         * that can be matched with an existing fields.\n         *\n         * @param {Object} data - Object to be processed.\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var fields = _.pluck(this.elems(), 'index');\n\n            _.each(this.preserveFields, function (enabled, field) {\n                if (enabled && !_.contains(fields, field)) {\n                    fields.push(field);\n                }\n            });\n\n            return _.pick(data, fields);\n        },\n\n        /**\n         * Parses values of a provided object with\n         * a 'normalizeData' method of a corresponding field.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        normalizeData: function (data) {\n            var index;\n\n            this.elems.each(function (elem) {\n                index = elem.index;\n\n                if (data.hasOwnProperty(index)) {\n                    data[index] = elem.normalizeData(data[index]);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Clears values of all fields.\n         *\n         * @returns {Record} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Validates all of the available fields.\n         *\n         * @returns {Array} An array with validation results.\n         */\n        validate: function () {\n            return this.elems.map('validate');\n        },\n\n        /**\n         * Checks if all fields are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Counts total errors amount across all fields.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = this.elems.filter('error').length;\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Returns difference between current data and its'\n         * initial state, retrieved from the records collection.\n         *\n         * @returns {Object} Object with changes descriptions.\n         */\n        checkChanges: function () {\n            var savedData   = this.getSavedData(),\n                data        = this.normalizeData(this.getData());\n\n            return utils.compare(savedData, data);\n        },\n\n        /**\n         * Updates 'fields' array filling it with available editors\n         * or with column instances if associated field is not present.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateFields: function () {\n            var fields;\n\n            fields = this.columns().elems.map(function (column) {\n                return this.getChild(column.index) || column;\n            }, this);\n\n            this.fields(fields);\n\n            return this;\n        },\n\n        /**\n         * Updates state of a 'hasChanges' property.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateState: function () {\n            var diff = this.checkChanges(),\n                changed = {};\n\n            this.hasChanges = !diff.equal;\n            changed[this.index] = this.data;\n            this.editor().set('changed', [changed]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided column is an actions column.\n         *\n         * @param {Column} column - Column to be checked.\n         * @returns {Boolean}\n         */\n        isActionsColumn: function (column) {\n            return column.dataType === 'actions';\n        },\n\n        /**\n         * Listener of columns provider child array changes.\n         *\n         * @param {Array} columns - Modified child elements array.\n         */\n        onColumnsUpdate: function (columns) {\n            this.createFields(columns)\n                .updateFields();\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './record'\n], function (_, utils, Record) {\n    'use strict';\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        data = utils.flatten(data);\n        data = _.omit(data, utils.isEmpty);\n\n        return utils.unflatten(data);\n    }\n\n    return Record.extend({\n        defaults: {\n            template: 'ui/grid/editing/bulk',\n            active: false,\n            templates: {\n                fields: {\n                    select: {\n                        caption: ' '\n                    }\n                }\n            },\n            imports: {\n                active: '${ $.editorProvider }:isMultiEditing'\n            },\n            listens: {\n                data: 'updateState',\n                active: 'updateState'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    hasData: false\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends original method to disable possible\n         * 'required-entry' validation rule.\n         *\n         * @returns {Object} Columns' field definition.\n         */\n        buildField: function () {\n            var field = this._super(),\n                rules = field.validation;\n\n            if (rules) {\n                delete rules['required-entry'];\n            }\n\n            return field;\n        },\n\n        /**\n         * Applies current data to all active records.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        apply: function () {\n            if (this.isValid()) {\n                this.applyData()\n                    .clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets available data to all active records.\n         *\n         * @param {Object} [data] -  If not specified, then current fields data will be used.\n         * @returns {Bulk} Chainable.\n         */\n        applyData: function (data) {\n            data = data || this.getData();\n\n            this.editor('setData', data, true);\n\n            return this;\n        },\n\n        /**\n         * Returns data of all non-empty fields.\n         *\n         * @returns {Object} Fields data without empty values.\n         */\n        getData: function () {\n            return removeEmpty(this._super());\n        },\n\n        /**\n         * Updates own 'hasData' property and defines\n         * whether regular rows editing can be resumed.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        updateState: function () {\n            var fields  = _.keys(this.getData()),\n                hasData = !!fields.length;\n\n            this.hasData = hasData;\n\n            if (!this.active()) {\n                fields = [];\n            }\n\n            this.editor('disableFields', fields);\n            this.editor('canSave', !fields.length);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table',\n            rowSelector: '${ $.tableSelector } tbody tr.data-row',\n            headerButtonsTmpl:\n                '<!-- ko template: headerButtonsTmpl --><!-- /ko -->',\n            bulkTmpl:\n                '<!-- ko scope: bulk -->' +\n                    '<!-- ko template: getTemplate() --><!-- /ko -->' +\n                '<!-- /ko -->',\n            rowTmpl:\n                '<!-- ko with: _editor -->' +\n                    '<!-- ko if: isActive($row()._rowIndex, true) -->' +\n                        '<!-- ko with: getRecord($row()._rowIndex, true) -->' +\n                            '<!-- ko template: rowTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                        '<!-- ko if: isSingleEditing && singleEditingButtons -->' +\n                            '<!-- ko template: rowButtonsTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                    '<!-- /ko -->' +\n               '<!-- /ko -->'\n        },\n\n        /**\n         * Initializes view component.\n         *\n         * @returns {View} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initRoot',\n                'initTable',\n                'initRow',\n                'rowBindings',\n                'tableBindings'\n            );\n\n            this._super();\n\n            this.model = registry.get(this.model);\n\n            $.async(this.rootSelector, this.initRoot);\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.rowSelector, this.initRow);\n\n            return this;\n        },\n\n        /**\n         * Initializes columns root container.\n         *\n         * @param {HTMLElement} node\n         * @returns {View} Chainable.\n         */\n        initRoot: function (node) {\n            $(this.headerButtonsTmpl)\n                .insertBefore(node)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table element.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initTable: function (table) {\n            $(table).bindings(this.tableBindings);\n\n            this.initBulk(table);\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editor element\n         * for the provided table.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initBulk: function (table) {\n            var tableBody = $('tbody', table)[0];\n\n            $(this.bulkTmpl)\n                .prependTo(tableBody)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table row.\n         *\n         * @param {HTMLTableRowElement} row\n         * @returns {View} Chainable.\n         */\n        initRow: function (row) {\n            var $editingRow;\n\n            $(row).extendCtx({\n                    _editor: this.model\n                }).bindings(this.rowBindings);\n\n            $editingRow = $(this.rowTmpl)\n                .insertBefore(row)\n                .applyBindings(row);\n\n            ko.utils.domNodeDisposal.addDisposeCallback(row, this.removeEditingRow.bind(this, $editingRow));\n\n            return this;\n        },\n\n        /**\n         * Returns row bindings.\n         *\n         * @param {Object} ctx - Current context of a row.\n         * @returns {Object}\n         */\n        rowBindings: function (ctx) {\n            var model = this.model;\n\n            return {\n                visible: ko.computed(function () {\n                    var record = ctx.$row(),\n                        index = record && record._rowIndex;\n\n                    return !model.isActive(index, true);\n                })\n            };\n        },\n\n        /**\n         * Returns table bindings.\n         *\n         * @returns {Object}\n         */\n        tableBindings: function () {\n            var model = this.model;\n\n            return {\n                css: {\n                    '_in-edit': ko.computed(function () {\n                        return model.hasActive() && !model.permanentlyActive;\n                    })\n                }\n            };\n        },\n\n        /**\n         * Removes specified array of nodes.\n         *\n         * @param {ArrayLike} row\n         */\n        removeEditingRow: function (row) {\n            _.toArray(row).forEach(ko.removeNode);\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, layout, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            rowButtonsTmpl: 'ui/grid/editing/row-buttons',\n            headerButtonsTmpl: 'ui/grid/editing/header-buttons',\n            successMsg: $t('You have successfully saved your edits.'),\n            errorsCount: 0,\n            bulkEnabled: true,\n            multiEditingButtons: true,\n            singleEditingButtons: true,\n            isMultiEditing: false,\n            isSingleEditing: false,\n            permanentlyActive: false,\n            rowsData: [],\n            fields: {},\n\n            templates: {\n                record: {\n                    parent: '${ $.$data.editor.name }',\n                    name: '${ $.$data.recordId }',\n                    component: 'Magento_Ui/js/grid/editing/record',\n                    columnsProvider: '${ $.$data.editor.columnsProvider }',\n                    editorProvider: '${ $.$data.editor.name }',\n                    preserveFields: {\n                        '${ $.$data.editor.indexField }': true\n                    }\n                }\n            },\n            bulkConfig: {\n                component: 'Magento_Ui/js/grid/editing/bulk',\n                name: '${ $.name }_bulk',\n                editorProvider: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            clientConfig: {\n                component: 'Magento_Ui/js/grid/editing/client',\n                name: '${ $.name }_client'\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/grid/editing/editor-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            imports: {\n                rowsData: '${ $.dataProvider }:data.items'\n            },\n            listens: {\n                '${ $.dataProvider }:reloaded': 'cancel',\n                '${ $.selectProvider }:selected': 'onSelectionsChange'\n            },\n            modules: {\n                source: '${ $.dataProvider }',\n                client: '${ $.clientConfig.name }',\n                columns: '${ $.columnsProvider }',\n                bulk: '${ $.bulkConfig.name }',\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes editor component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateState', 'countErrors', 'onDataSaved', 'onSaveError');\n\n            this._super()\n                .initBulk()\n                .initClient()\n                .initView();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'errorsCount',\n                    'isMultiEditing',\n                    'isSingleEditing',\n                    'isSingleColumnEditing',\n                    'changed'\n                ])\n                .observe({\n                    canSave: true,\n                    activeRecords: [],\n                    messages: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editing component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initBulk: function () {\n            if (this.bulkEnabled) {\n                layout([this.bulkConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes editors' view component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initClient: function () {\n            layout([this.clientConfig]);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a new record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        initRecord: function (id, isIndex) {\n            var record = this.buildRecord(id, isIndex);\n\n            layout([record]);\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a new record.\n         *\n         * @param {Record} record\n         * @returns {Editor} Chainable.\n         */\n        initElement: function (record) {\n            record.on({\n                'active': this.updateState,\n                'errorsCount': this.countErrors\n            });\n\n            this.updateState();\n\n            return this._super();\n        },\n\n        /**\n         * Creates configuration for a new record associated with a row data.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object} Record configuration.\n         */\n        buildRecord: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                recordTmpl = this.templates.record,\n                record;\n\n            if (this.getRecord(recordId)) {\n                return this;\n            }\n\n            record = utils.template(recordTmpl, {\n                editor: this,\n                recordId: id\n            });\n\n            record.recordId = id;\n            record.data     = this.getRowData(id);\n\n            return record;\n        },\n\n        /**\n         * Starts editing of a specified record. If records'\n         * instance doesn't exist, than it will be created.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        edit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                record   = this.getRecord(recordId);\n\n            record ?\n                record.active(true) :\n                this.initRecord(recordId);\n\n            return this;\n        },\n\n        /**\n         * Drops list of selections while activating only the specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        startEdit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex);\n\n            this.selections()\n                .deselectAll()\n                .select(recordId);\n\n            return this.edit(recordId);\n        },\n\n        /**\n         * Hides records and resets theirs data.\n         *\n         * @returns {Editor} Chainable.\n         */\n        cancel: function () {\n            this.reset()\n                .hide()\n                .clearMessages()\n                .bulk('clear');\n\n            return this;\n        },\n\n        /**\n         * Hides records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        hide: function () {\n            this.activeRecords.each('active', false);\n\n            return this;\n        },\n\n        /**\n         * Resets active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        reset: function () {\n            this.elems.each(function (record) {\n                this.resetRecord(record.recordId);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Validates and saves data of active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        save: function () {\n            var data;\n\n            if (!this.isValid()) {\n                return this;\n            }\n\n            data = {\n                items: this.getData()\n            };\n\n            this.clearMessages()\n                .columns('showLoader');\n\n            this.client()\n                .save(data)\n                .done(this.onDataSaved)\n                .fail(this.onSaveError);\n\n            return this;\n        },\n\n        /**\n         * Validates all active records.\n         *\n         * @returns {Array} An array of records and theirs validation results.\n         */\n        validate: function () {\n            return this.activeRecords.map(function (record) {\n                return {\n                    target: record,\n                    valid: record.isValid()\n                };\n            });\n        },\n\n        /**\n         * Checks if all active records are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Returns active records data, indexed by a theirs ids.\n         *\n         * @returns {Object} Collection of records data.\n         */\n        getData: function () {\n            var data = this.activeRecords.map(function (record) {\n                var elemKey,\n                    recordData = record.getData();\n\n                for (elemKey in recordData) {\n                    if (_.isUndefined(recordData[elemKey])) {\n                        recordData[elemKey] = null;\n                    }\n                }\n\n                return recordData;\n            });\n\n            return _.indexBy(data, this.indexField);\n        },\n\n        /**\n         * Sets provided data to all active records.\n         *\n         * @param {Object} data - See 'setData' method of a 'Record'.\n         * @param {Boolean} partial - See 'setData' method of a 'Record'.\n         * @returns {Editor} Chainable.\n         */\n        setData: function (data, partial) {\n            this.activeRecords.each('setData', data, partial);\n\n            return this;\n        },\n\n        /**\n         * Resets specific records' data\n         * to the data present in associated row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        resetRecord: function (id, isIndex) {\n            var record  = this.getRecord(id, isIndex),\n                data    = this.getRowData(id, isIndex);\n\n            if (record && data) {\n                record.setData(data);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Record}\n         */\n        getRecord: function (id, isIndex) {\n            return this.elems.findWhere({\n                recordId: this.getId(id, isIndex)\n            });\n        },\n\n        /**\n         * Creates record name based on a provided id.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {String}\n         */\n        formRecordName: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.name + '.' + id;\n        },\n\n        /**\n         * Disables editing of specified fields.\n         *\n         * @param {Array} fields - An array of fields indexes to be disabled.\n         * @returns {Editor} Chainable.\n         */\n        disableFields: function (fields) {\n            var columns = this.columns().elems(),\n                data    = utils.copy(this.fields);\n\n            columns.forEach(function (column) {\n                var index = column.index,\n                    field = data[index] = data[index] || {};\n\n                field.disabled = _.contains(fields, index);\n            });\n\n            this.set('fields', data);\n\n            return this;\n        },\n\n        /**\n         * Converts index of a row into the record id.\n         *\n         * @param {(Number|String)} id - Records' identifier or its' index in the rows array.\n         * @param {Boolean} [isIndex=false] - Flag that indicates if first\n         *      parameter is an index or identifier.\n         * @returns {String} Records' id.\n         */\n        getId: function (id, isIndex) {\n            var rowsData = this.rowsData,\n                record;\n\n            if (isIndex === true) {\n                record  = rowsData[id];\n                id      = record ? record[this.indexField] : false;\n            }\n\n            return id;\n        },\n\n        /**\n         * Returns data of a specified row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object}\n         */\n        getRowData: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return _.find(this.rowsData, function (row) {\n                return row[this.indexField] === id;\n            }, this);\n        },\n\n        /**\n         * Checks if specified record is active.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See'getId' method.\n         * @returns {Boolean}\n         */\n        isActive: function (id, isIndex) {\n            var record = this.getRecord(id, isIndex);\n\n            return _.contains(this.activeRecords(), record);\n        },\n\n        /**\n         * Checks if editor has active records.\n         *\n         * @returns {Boolean}\n         */\n        hasActive: function () {\n            return !!this.activeRecords().length || this.permanentlyActive;\n        },\n\n        /**\n         * Counts number of active records.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.activeRecords().length;\n        },\n\n        /**\n         * Counts number of invalid fields across all active records.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = 0;\n\n            this.activeRecords.each(function (record) {\n                errorsCount += record.errorsCount;\n            });\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Translatable error message text.\n         *\n         * @returns {String}\n         */\n        countErrorsMessage: function () {\n            return $t('There are {placeholder} messages requires your attention.')\n                .replace('{placeholder}', this.countErrors());\n        },\n\n        /**\n         * Checks if editor has any errors.\n         *\n         * @returns {Boolean}\n         */\n        hasErrors: function () {\n            return !!this.countErrors();\n        },\n\n        /**\n         * Handles changes of the records 'active' property.\n         *\n         * @returns {Editor} Chainable.\n         */\n        updateState: function () {\n            var active      = this.elems.filter('active'),\n                activeCount = active.length,\n                columns     = this.columns().elems;\n\n            columns.each('disableAction', !!activeCount);\n\n            this.isMultiEditing = activeCount > 1;\n            this.isSingleEditing = activeCount === 1;\n\n            this.activeRecords(active);\n\n            return this;\n        },\n\n        /**\n         * Returns list of selections from a current page.\n         *\n         * @returns {Array}\n         */\n        getSelections: function () {\n            return this.selections().getPageSelections();\n        },\n\n        /**\n         * Starts editing of selected records. If record\n         * is not in the selections list, then it will get hidden.\n         *\n         * @returns {Editor} Chainable.\n         */\n        editSelected: function () {\n            var selections = this.getSelections();\n\n            this.elems.each(function (record) {\n                if (!_.contains(selections, record.recordId)) {\n                    record.active(false);\n                }\n            });\n\n            selections.forEach(function (id) {\n                this.edit(id);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if there is any additional messages.\n         *\n         * @returns {Boolean}\n         */\n        hasMessages: function () {\n            return this.messages().length;\n        },\n\n        /**\n         * Adds new additional message or a set of messages.\n         *\n         * @param {(Object|Array)} message - Messages to be added.\n         * @returns {Editor} Chainable.\n         */\n        addMessage: function (message) {\n            var messages = this.messages();\n\n            Array.isArray(message) ?\n                messages.push.apply(messages, message) :\n                messages.push(message);\n\n            this.messages(messages);\n\n            return this;\n        },\n\n        /**\n         * Removes all additional messages.\n         *\n         * @returns {Editor} Chainable.\n         */\n        clearMessages: function () {\n            this.messages.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Listener of the selections data changes.\n         */\n        onSelectionsChange: function () {\n            if (this.hasActive()) {\n                this.editSelected();\n            }\n        },\n\n        /**\n         * Handles successful save request.\n         */\n        onDataSaved: function () {\n            var msg = {\n                type: 'success',\n                message: this.successMsg\n            };\n\n            this.addMessage(msg)\n                .source('reload', {\n                    refresh: true\n                });\n        },\n\n        /**\n         * Handles failed save request.\n         *\n         * @param {(Array|Object)} errors - List of errors or a single error object.\n         */\n        onSaveError: function (errors) {\n            this.addMessage(errors)\n                .columns('hideLoader');\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement'\n], function (ko, _, utils, layout, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/paging',\n            totalTmpl: 'ui/grid/paging-total',\n            totalRecords: 0,\n            showTotalRecords: true,\n            pages: 1,\n            current: 1,\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                }\n            },\n\n            imports: {\n                totalSelected: '${ $.selectProvider }:totalSelected',\n                totalRecords: '${ $.provider }:data.totalRecords',\n                showTotalRecords: '${ $.provider }:data.showTotalRecords',\n                filters: '${ $.provider }:params.filters',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n\n            exports: {\n                pageSize: '${ $.provider }:params.paging.pageSize',\n                current: '${ $.provider }:params.paging.current'\n            },\n\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n\n            statefull: {\n                pageSize: true,\n                current: true\n            },\n\n            listens: {\n                'pages': 'onPagesChange',\n                'pageSize': 'onPageSizeChange',\n                'totalRecords': 'updateCounter',\n                'showTotalRecords': 'updateShowTotalRecords',\n                '${ $.provider }:params.filters': 'goFirst',\n                '${ $.provider }:params.search': 'onSearchUpdate'\n            },\n\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes()\n                .updateCounter();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'totalSelected',\n                    'totalRecords',\n                    'showTotalRecords',\n                    'pageSize',\n                    'pages',\n                    'current'\n                ]);\n\n            this._current = ko.pureComputed({\n                read: ko.getObservable(this, 'current'),\n\n                /**\n                 * Validates page change according to user's input.\n                 * Sets current observable to result of validation.\n                 * Calls reload method then.\n                 */\n                write: function (value) {\n                    this.setPage(value)\n                        ._current.notifySubscribers(this.current);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            layout([this.sizesConfig]);\n\n            return this;\n        },\n\n        /**\n         * Gets first item index on current page.\n         *\n         * @returns {Number}\n         */\n        getFirstItemIndex: function () {\n            return this.pageSize * (this.current - 1) + 1;\n        },\n\n        /**\n         * Gets last item index on current page.\n         *\n         * @returns {Number}\n         */\n        getLastItemIndex: function () {\n            var lastItem = this.getFirstItemIndex() + this.pageSize - 1;\n\n            return this.totalRecords < lastItem ? this.totalRecords : lastItem;\n        },\n\n        /**\n         * Sets cursor to the provied value.\n         *\n         * @param {(Number|String)} value - New value of the cursor.\n         * @returns {Paging} Chainable.\n         */\n        setPage: function (value) {\n            this.current = this.normalize(value);\n\n            return this;\n        },\n\n        /**\n         * Increments current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        next: function () {\n            this.setPage(this.current + 1);\n\n            return this;\n        },\n\n        /**\n         * Decrements current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        prev: function () {\n            this.setPage(this.current - 1);\n\n            return this;\n        },\n\n        /**\n         * Goes to the first page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goFirst: function () {\n            if (!_.isUndefined(this.filters)) {\n                this.current = 1;\n            }\n\n            return this;\n        },\n\n        /**\n         * Goes to the last page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goLast: function () {\n            this.current = this.pages;\n\n            return this;\n        },\n\n        /**\n         * Checks if current page is the first one.\n         *\n         * @returns {Boolean}\n         */\n        isFirst: function () {\n            return this.current === 1;\n        },\n\n        /**\n         * Checks if current page is the last one.\n         *\n         * @returns {Boolean}\n         */\n        isLast: function () {\n            return this.current === this.pages;\n        },\n\n        /**\n         * Updates number of pages.\n         */\n        updateCounter: function () {\n            this.pages = Math.ceil(this.totalRecords / this.pageSize) || 1;\n\n            return this;\n        },\n\n        /**\n         * Updates show total records flag.\n         */\n        updateShowTotalRecords: function () {\n            if (this.showTotalRecords === undefined) {\n                this.showTotalRecords = true;\n            }\n            return this;\n        },\n\n        /**\n         * Calculates new page cursor based on the\n         * previous and current page size values.\n         */\n        updateCursor: function () {\n            var cursor = this.current - 1,\n                size = this.pageSize,\n                oldSize = _.isUndefined(this.previousSize) ? this.pageSize : this.previousSize,\n                delta = cursor * (oldSize - size) / size;\n\n            delta = size > oldSize ?\n                Math.ceil(delta) :\n                Math.floor(delta);\n\n            cursor += delta + 1;\n\n            this.previousSize = size;\n\n            this.setPage(cursor);\n\n            return this;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 1 and total amount of pages.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return 1;\n            }\n\n            return utils.inRange(Math.round(value), 1, this.pages);\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            this.updateCounter()\n                .updateCursor();\n        },\n\n        /**\n         * Handles changes of the pages amount.\n         */\n        onPagesChange: function () {\n            this.updateCursor();\n        },\n\n        /**\n         * Resent the pagination to Page 1 on search keyword update\n         */\n        onSearchUpdate: function () {\n            if (!_.isUndefined(this.keywordUpdated) && this.keywordUpdated) {\n                this.goFirst();\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiElement'\n], function (ko, _, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/sizes',\n            minSize: 1,\n            maxSize: 999,\n            statefull: {\n                options: true,\n                value: true\n            },\n            listens: {\n                value: 'onValueChange',\n                options: 'onSizesChange'\n            }\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'value',\n                    'editing',\n                    'customVisible',\n                    'customValue'\n                ])\n                .track({\n                    optionsArray: []\n                });\n\n            this._value = ko.pureComputed({\n                read: ko.getObservable(this, 'value'),\n\n                /**\n                 * Validates input field prior to updating 'value' property.\n                 */\n                write: function (value) {\n                    value = this.normalize(value);\n\n                    this.value = value;\n                    this._value.notifySubscribers(value);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Starts editing of the specified size.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        edit: function (value) {\n            this.editing = value;\n\n            return this;\n        },\n\n        /**\n         * Discards changes made to the currently editable size.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardEditing: function () {\n            var value = this.editing;\n\n            if (value) {\n                this.updateSize(value, value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Invokes 'discardEditing' and 'discardCustom' actions.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardAll: function () {\n            this.discardEditing()\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Returns value of the first size.\n         *\n         * @returns {Number}\n         */\n        getFirst: function () {\n            return this.optionsArray[0].value;\n        },\n\n        /**\n         * Returns size which matches specified value.\n         *\n         * @param {Number} value - Value of the item.\n         * @returns {Object|Undefined}\n         */\n        getSize: function (value) {\n            return this.options[value];\n        },\n\n        /**\n         * Sets current size to the specified value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        setSize: function (value) {\n            this.value = value;\n\n            return this;\n        },\n\n        /**\n         * Adds a new value to sizes list.\n         *\n         * @param {Number} value - Value to be added.\n         * @returns {Sizes} Chainable.\n         */\n        addSize: function (value) {\n            var size;\n\n            if (!this.hasSize(value)) {\n                size = this.createSize(value);\n\n                this.set('options.' + value, size);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes provided value from the sizes list.\n         *\n         * @param {Number} value - Value to be removed.\n         * @returns {Sizes} Chainable.\n         */\n        removeSize: function (value) {\n            if (!this.hasSize(value)) {\n                return this;\n            }\n\n            this.remove('options.' + value);\n\n            if (this.isSelected(value)) {\n                this.setSize(this.getFirst());\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates existing value to the provided one. If new value\n         * is not specified, then sizes' '_value' property will be taken.\n         *\n         * @param {Number} value - Existing value that should be updated.\n         * @param {(Number|String)} [newValue=size._value] - New size value.\n         * @returns {Sizes} Chainable.\n         */\n        updateSize: function (value, newValue) {\n            var size = this.getSize(value);\n\n            if (!size) {\n                return this;\n            }\n\n            newValue = newValue || size._value;\n\n            if (isNaN(+newValue)) {\n                this.discardEditing();\n\n                return this;\n            }\n\n            newValue = this.normalize(newValue);\n\n            this.remove('options.' + value)\n                .addSize(newValue);\n\n            if (this.isSelected(value)) {\n                this.setSize(newValue);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates new editable size instance with the provided value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Object}\n         */\n        createSize: function (value) {\n            return {\n                value: value,\n                label: value,\n                _value: value,\n                editable: true\n            };\n        },\n\n        /**\n         * Checks if provided value exists in the sizes list.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        hasSize: function (value) {\n            return !!this.getSize(value);\n        },\n\n        /**\n         * Hides and clears custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardCustom: function () {\n            this.hideCustom()\n                .clearCustom();\n\n            return this;\n        },\n\n        /**\n         * Shows custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        showCustom: function () {\n            this.customVisible = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Empties value of the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        clearCustom: function () {\n            this.customValue = '';\n\n            return this;\n        },\n\n        /**\n         * Adds a new size specified in the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        applyCustom: function () {\n            var value = this.customValue;\n\n            value = this.normalize(value);\n\n            this.addSize(value)\n                .setSize(value)\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Checks if custom field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 'minSize' and 'maxSize' properties.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return this.getFirst();\n            }\n\n            return utils.inRange(Math.round(value), this.minSize, this.maxSize);\n        },\n\n        /**\n         * Updates the array of options.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        updateArray: function () {\n            var array = _.values(this.options);\n\n            this.optionsArray = _.sortBy(array, 'value');\n\n            return this;\n        },\n\n        /**\n         * Checks if provided value is in editing state.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (value) {\n            return this.editing === value;\n        },\n\n        /**\n         * Checks if provided value is selected.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isSelected: function (value) {\n            return this.value === value;\n        },\n\n        /**\n         * Listener of the 'value' property changes.\n         */\n        onValueChange: function () {\n            this.discardAll()\n                .trigger('close');\n        },\n\n        /**\n         * Listener of the 'options' object changes.\n         */\n        onSizesChange: function () {\n            this.editing = false;\n\n            this.updateArray();\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/column.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction || !!this.fieldActions;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property\n         * or actions described in 'fieldActions' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            if (this.fieldActions) {\n                this.fieldActions.forEach(this.applySingleAction.bind(this, rowIndex), this);\n            } else {\n                this.applySingleAction(rowIndex);\n            }\n\n            return this;\n        },\n\n        /**\n         * Applies single action\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @param {Object} action - Action (fieldAction) to be applied\n         *\n         */\n        applySingleAction: function (rowIndex, action) {\n            var callback;\n\n            action = action || this.fieldAction;\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * UnsanitizedHtml version of getLabel.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabelUnsanitizedHtml: function (record) {\n            return this.getLabel(record);\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/expandable.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/expandable',\n            tooltipTmpl: 'ui/grid/cells/expandable/content',\n            visibeItemsLimit: 5,\n            tooltipTitle: ''\n        },\n\n        /**\n         * Gets label from full options array.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getFullLabel: function (record) {\n            return this.getLabelsArray(record).join(', ');\n        },\n\n        /**\n         * Gets label from options array limited by 'visibeItemsLimit'.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getShortLabel: function (record) {\n            return this.getLabelsArray(record).slice(0, this.visibeItemsLimit).join(', ');\n        },\n\n        /**\n         * Extracts array of labels associated with provided values and sort it alphabetically.\n         *\n         * @param {Object} record - Record object.\n         * @returns {Array}\n         */\n        getLabelsArray: function (record) {\n            var values = this.getLabel(record),\n                options = this.options || [],\n                labels = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!Array.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    labels.push(item.label);\n                }\n            });\n\n            return labels.sort(\n                function (labelFirst, labelSecond) {\n                    return labelFirst.toLowerCase().localeCompare(labelSecond.toLowerCase());\n                }\n            );\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        },\n\n        /**\n         * Checks if amount of options is more than limit value.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isExpandable: function (record) {\n            return this.getLabel(record).length > this.visibeItemsLimit;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'mageUtils'\n], function (Column, utils) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            link: 'link',\n            bodyTmpl: 'ui/grid/cells/link'\n        },\n\n        /**\n         * Returns link to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLink: function (record) {\n            return utils.nested(record, this.link);\n        },\n\n        /**\n         * Check if link parameter exist in record.\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isLink: function (record) {\n            return !!utils.nested(record, this.link);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/onoff.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './multiselect',\n    'uiRegistry'\n], function (_, $t, Column, registry) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/onoff',\n            bodyTmpl: 'ui/grid/cells/onoff',\n            fieldClass: {\n                'admin__scope-old': true,\n                'data-grid-onoff-cell': true,\n                'data-grid-checkbox-cell': false\n            },\n            imports: {\n                selectedData: '${ $.provider }:data.selectedData'\n            },\n            listens: {\n                '${ $.provider }:reloaded': 'setDefaultSelections'\n            }\n        },\n\n        /**\n         * @param {Number} id\n         * @returns {*}\n         */\n        getLabel: function (id) {\n            return this.selected.indexOf(id) !== -1 ? $t('On') : $t('Off');\n        },\n\n        /**\n         * Sets the ids for preselected elements\n         * @returns void\n         */\n        setDefaultSelections: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                selectedFromCache = registry.get('selected_cache'),\n                key,\n                i;\n\n            if (positionCacheValid && this.selected().length === 0) {\n                // Check selected data\n                selectedFromCache = JSON.parse(selectedFromCache);\n\n                for (i = 0; i < selectedFromCache.length; i++) {\n                    this.selected.push(selectedFromCache[i]);\n                }\n\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (this.selectedData.length === 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify([]));\n\n                return;\n            }\n\n            // Check selected data\n            for (key in this.selectedData) {\n                if (this.selectedData.hasOwnProperty(key) && this.selected().indexOf(key) === -1) {\n                    this.selected.push(key);\n                }\n            }\n            // Uncheck unselected data\n            for (i = 0; i < this.selected().length; i++) {\n                key = this.selected()[i];\n                this.selectedData.hasOwnProperty(key) || this.selected.splice(this.selected().indexOf(key), 1);\n                this.selectedData.hasOwnProperty(key) || i--;\n            }\n            registry.set('position_cache_valid', true);\n            registry.set('selected_cache', JSON.stringify(this.selected()));\n        },\n\n        /**\n         * Show/hide action in the massaction menu\n         * @param {Number} actionId\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var relevant = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  this.isPageSelected();\n                    break;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        updateState: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                totalRecords    = this.totalRecords(),\n                selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                allSelected;\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n            }\n\n            // When filters are enabled then totalRecords is unknown\n            if (this.getFiltering()) {\n                if (this.getFiltering().search !== '') {\n                    totalRecords = -1;\n                }\n            }\n\n            allSelected = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    'moment',\n    './column',\n    'underscore',\n    'moment-timezone-with-data'\n], function (utils, moment, Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            dateFormat: 'MMM d, YYYY h:mm:ss A',\n            calendarConfig: []\n        },\n\n        /**\n         * Overrides base method to normalize date format\n         *\n         * @returns {DateColumn} Chainable\n         */\n        initConfig: function () {\n            this._super();\n\n            this.dateFormat = utils.normalizeDate(this.dateFormat ? this.dateFormat : this.options.dateFormat);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming date based on the 'dateFormat' property.\n         *\n         * @returns {String} Formatted date.\n         */\n        getLabel: function (value, format) {\n            var date;\n\n            if (this.storeLocale !== undefined) {\n                moment.locale(this.storeLocale, utils.extend({}, this.calendarConfig));\n            }\n\n            date = moment.utc(this._super());\n\n            if (!_.isUndefined(this.timezone) && moment.tz.zone(this.timezone) !== null) {\n                date = date.tz(this.timezone);\n            }\n\n            date = date.isValid() && value[this.index] ?\n                date.format(format || this.dateFormat) :\n                '';\n\n            return date;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Ui/js/lib/key-codes'\n], function ($, _, Column, keyCodes) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/image-preview',\n            previewImageSelector: '[data-image-preview]',\n            visibleRecord: null,\n            height: 0,\n            displayedRecord: {},\n            lastOpenedImage: false,\n            fields: {\n                previewUrl: 'preview_url',\n                title: 'title'\n            },\n            modules: {\n                masonry: '${ $.parentName }',\n                thumbnailComponent: '${ $.parentName }.thumbnail_url'\n            },\n            statefull: {\n                sorting: true,\n                lastOpenedImage: true\n            },\n            listens: {\n                '${ $.provider }:params.filters': 'hide',\n                '${ $.provider }:params.search': 'hide',\n                '${ $.provider }:params.paging': 'hide',\n                '${ $.provider }:data.items': 'updateDisplayedRecord'\n            },\n            exports: {\n                height: '${ $.parentName }.thumbnail_url:previewHeight'\n            }\n        },\n\n        /**\n         * Initialize image preview component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(document).on('keydown', this.handleKeyDown.bind(this));\n\n            this.lastOpenedImage.subscribe(function (newValue) {\n\n                if (newValue === false && _.isNull(this.visibleRecord())) {\n                    return;\n                }\n\n                if (newValue === this.visibleRecord()) {\n                    return;\n                }\n\n                if (newValue === false) {\n                    this.hide();\n\n                    return;\n                }\n\n                this.show(this.masonry().rows()[newValue]);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'visibleRecord',\n                    'height',\n                    'displayedRecord',\n                    'lastOpenedImage'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Next image preview\n         *\n         * @param {Object} record\n         */\n        next: function (record) {\n            var recordToShow;\n\n            if (record._rowIndex + 1 === this.masonry().rows().length) {\n                return;\n            }\n\n            recordToShow = this.getRecord(record._rowIndex + 1);\n            recordToShow.rowNumber = record.lastInRow ? record.rowNumber + 1 : record.rowNumber;\n            this.show(recordToShow);\n        },\n\n        /**\n         * Previous image preview\n         *\n         * @param {Object} record\n         */\n        prev: function (record) {\n            var recordToShow;\n\n            if (record._rowIndex === 0) {\n                return;\n            }\n            recordToShow = this.getRecord(record._rowIndex - 1);\n\n            recordToShow.rowNumber = record.firstInRow ? record.rowNumber - 1 : record.rowNumber;\n            this.show(recordToShow);\n        },\n\n        /**\n         * Get record\n         *\n         * @param {Integer} recordIndex\n         *\n         * @return {Object}\n         */\n        getRecord: function (recordIndex) {\n            return this.masonry().rows()[recordIndex];\n        },\n\n        /**\n         * Set selected row id\n         *\n         * @param {Number} rowId\n         * @private\n         */\n        _selectRow: function (rowId) {\n            this.thumbnailComponent().previewRowId(rowId);\n        },\n\n        /**\n         * Show image preview\n         *\n         * @param {Object} record\n         */\n        show: function (record) {\n            if (record._rowIndex === this.visibleRecord()) {\n                this.hide();\n\n                return;\n            }\n\n            this.hide();\n            this.displayedRecord(record);\n            this._selectRow(record.rowNumber || null);\n            this.visibleRecord(record._rowIndex);\n\n            this.lastOpenedImage(record._rowIndex);\n            this.updateImageData();\n        },\n\n        /**\n         * Update image data when image preview is opened\n         */\n        updateImageData: function () {\n            var img = $(this.previewImageSelector + ' img'), self;\n\n            if (!img.get(0)) {\n                setTimeout(function () {\n                    this.updateImageData();\n                }.bind(this), 100);\n            } else if (img.get(0).complete) {\n                this.updateHeight();\n                this.scrollToPreview();\n            } else {\n                self = this;\n\n                img.on('load', function () {\n                    self.updateHeight();\n                    self.scrollToPreview();\n                });\n            }\n        },\n\n        /**\n         * Update preview displayed record data from the new items data if the preview is expanded\n         *\n         * @param {Array} items\n         */\n        updateDisplayedRecord: function (items) {\n            if (!_.isNull(this.visibleRecord())) {\n                this.displayedRecord(items[this.visibleRecord()]);\n            }\n        },\n\n        /**\n         * Update image preview section height\n         */\n        updateHeight: function () {\n            this.height($(this.previewImageSelector).height() + 'px');\n        },\n\n        /**\n         * Close image preview\n         */\n        hide: function () {\n            this.lastOpenedImage(false);\n            this.visibleRecord(null);\n            this.height(0);\n            this._selectRow(null);\n        },\n\n        /**\n         * Returns visibility for given record.\n         *\n         * @param {Object} record\n         * @return {*|bool}\n         */\n        isVisible: function (record) {\n            if (this.lastOpenedImage() === record._rowIndex &&\n                this.visibleRecord() === null\n            ) {\n                this.show(record);\n            }\n\n            return this.visibleRecord() === record._rowIndex || false;\n        },\n\n        /**\n         * Returns preview image url for a given record.\n         *\n         * @param {Object} record\n         * @return {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.previewUrl];\n        },\n\n        /**\n         * Returns image title for a given record.\n         *\n         * @param {Object} record\n         * @return {String}\n         */\n        getTitle: function (record) {\n            return record[this.fields.title];\n        },\n\n        /**\n         * Get styles for preview\n         *\n         * @returns {Object}\n         */\n        getStyles: function () {\n            return {\n                'margin-top': '-' + this.height()\n            };\n        },\n\n        /**\n         * Scroll to preview window\n         */\n        scrollToPreview: function () {\n            $(this.previewImageSelector).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        },\n\n        /**\n         * Handle keyboard navigation for image preview\n         *\n         * @param {Object} e\n         */\n        handleKeyDown: function (e) {\n            var key = keyCodes[e.keyCode];\n\n            if (this.visibleRecord() !== null && document.activeElement.tagName !== 'INPUT') {\n                if (key === 'pageLeftKey') {\n                    this.prev(this.displayedRecord());\n                } else if (key === 'pageRightKey') {\n                    this.next(this.displayedRecord());\n                }\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './column'\n], function (_, Column) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Retrieves label associated with a provided value.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            var options = this.options || [],\n                values = this._super(),\n                label = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!_.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    label.push(item.label);\n                }\n            });\n\n            return label.join(', ');\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            if (!_.isArray(options)) {\n                options = _.values(options);\n            }\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './column'\n], function (_, $t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/multiselect',\n            bodyTmpl: 'ui/grid/cells/multiselect',\n            controlVisibility: false,\n            sortable: false,\n            draggable: false,\n            menuVisible: false,\n            excludeMode: false,\n            allSelected: false,\n            indetermine: false,\n            preserveSelectionsOnFilter: false,\n            disabled: [],\n            selected: [],\n            excluded: [],\n            fieldClass: {\n                'data-grid-checkbox-cell': true\n            },\n            actions: [{\n                value: 'selectAll',\n                label: $t('Select All')\n            }, {\n                value: 'deselectAll',\n                label: $t('Deselect All')\n            }, {\n                value: 'selectPage',\n                label: $t('Select All on This Page')\n            }, {\n                value: 'deselectPage',\n                label: $t('Deselect All on This Page')\n            }],\n\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords',\n                showTotalRecords: '${ $.provider }:data.showTotalRecords',\n                rows: '${ $.provider }:data.items'\n            },\n\n            listens: {\n                '${ $.provider }:params.filters': 'onFilter',\n                '${ $.provider }:params.search': 'onSearch',\n                selected: 'onSelectedChange',\n                rows: 'onRowsChange'\n            },\n\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'disabled',\n                    'selected',\n                    'excluded',\n                    'excludeMode',\n                    'totalSelected',\n                    'allSelected',\n                    'indetermine',\n                    'totalRecords',\n                    'showTotalRecords',\n                    'rows'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Selects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        select: function (id, isIndex) {\n            this._setSelection(id, isIndex, true);\n\n            return this;\n        },\n\n        /**\n         * Deselects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        deselect: function (id, isIndex) {\n            this._setSelection(id, isIndex, false);\n\n            return this;\n        },\n\n        /**\n         * Toggles selection of a specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelect: function (id, isIndex) {\n            this._setSelection(id, isIndex, !this.isSelected(id, isIndex));\n\n            return this;\n        },\n\n        /**\n         * Checks if specified record is selected.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Boolean}\n         */\n        isSelected: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.selected.contains(id);\n        },\n\n        /**\n         * Selects/deselects specified record base on a 'select' parameter value.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @param {Boolean} select - Whether to select/deselect record.\n         * @returns {Multiselect} Chainable.\n         */\n        _setSelection: function (id, isIndex, select) {\n            var selected = this.selected;\n\n            id = this.getId(id, isIndex);\n\n            if (!select && this.isSelected(id)) {\n                selected.remove(id);\n            } else if (select) {\n                selected.push(id);\n            }\n\n            return this;\n        },\n\n        /**\n         * Selects all records, even those that\n         * are not visible on the page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectAll: function () {\n            this.excludeMode(true);\n\n            this.clearExcluded()\n                .selectPage();\n\n            return this;\n        },\n\n        /**\n         * Deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectAll: function () {\n            this.excludeMode(false);\n\n            this.clearExcluded();\n            this.selected.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Selects or deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelectAll: function () {\n            this.allSelected() ?\n                this.deselectAll() :\n                this.selectAll();\n\n            return this;\n        },\n\n        /**\n         * Selects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectPage: function () {\n            var selected = _.union(this.selected(), this.getIds());\n\n            selected = _.difference(selected, this.disabled());\n\n            this.selected(selected);\n\n            return this;\n        },\n\n        /**\n         * Deselects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectPage: function () {\n            var pageIds = this.getIds();\n\n            this.selected.remove(function (value) {\n                return !!~pageIds.indexOf(value);\n            });\n\n            return this;\n        },\n\n        /**\n        * Selects or deselects all records on the current page.\n        *\n        * @returns {Multiselect} Chainable.\n        */\n        togglePage: function () {\n            return this.isPageSelected() && !this.excluded().length ? this.deselectPage() : this.selectPage();\n        },\n\n        /**\n         * Clears the array of not selected records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        clearExcluded: function () {\n            this.excluded.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Retrieve all id's from available records.\n         *\n         * @param {Boolean} [exclude] - Whether to exclude not selected ids' from result.\n         * @returns {Array} An array of ids'.\n         */\n        getIds: function (exclude) {\n            var items = this.rows(),\n                ids = _.pluck(items, this.indexField);\n\n            return exclude ?\n                _.difference(ids, this.excluded()) :\n                ids;\n        },\n\n        /**\n         * Returns identifier of a record.\n         *\n         * @param {*} id - Id of a record or its' index in a rows array.\n         * @param {Boolean} [isIndex=false] - Flag that specifies with what\n         *      kind of identifier we are dealing with.\n         * @returns {*}\n         */\n        getId: function (id, isIndex) {\n            var record = this.rows()[id];\n\n            if (isIndex && record) {\n                id = record[this.indexField];\n            }\n\n            return id;\n        },\n\n        /**\n         * Recalculates list of the excluded records.\n         * Changes value of `excluded`.\n         *\n         * @param {Array} selected - List of the currently selected records.\n         * @returns {Multiselect} Chainable.\n         */\n        updateExcluded: function (selected) {\n            var excluded = this.excluded(),\n                fromPage = _.difference(this.getIds(), selected);\n\n            excluded = _.union(excluded, fromPage);\n            excluded = _.difference(excluded, selected);\n\n            this.excluded(excluded);\n\n            return this;\n        },\n\n        /**\n         * Calculates number of selected records and\n         * updates 'totalSelected' property.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        countSelected: function () {\n            var total = this.totalRecords(),\n                excluded = this.excluded().length,\n                selected = this.selected().length;\n\n            if (this.excludeMode()) {\n                selected = total - excluded;\n            }\n\n            this.totalSelected(selected);\n\n            return this;\n        },\n\n        /**\n         * Returns selected items on a current page.\n         *\n         * @returns {Array}\n         */\n        getPageSelections: function () {\n            var ids = this.getIds();\n\n            return this.selected.filter(function (id) {\n                return _.contains(ids, id);\n            });\n        },\n\n        /**\n         * Returns selections data.\n         *\n         * @returns {Object}\n         */\n        getSelections: function () {\n            return {\n                excluded: this.excluded(),\n                selected: this.selected(),\n                total: this.totalSelected(),\n                showTotalRecords: this.showTotalRecords(),\n                excludeMode: this.excludeMode(),\n                params: this.getFiltering()\n            };\n        },\n\n        /**\n         * Extracts filtering data from data provider.\n         *\n         * @returns {Object} Current filters state.\n         */\n        getFiltering: function () {\n            var source = this.source(),\n                keys = ['filters', 'search', 'namespace'];\n\n            if (!source) {\n                return {};\n            }\n\n            return _.pick(source.get('params'), keys);\n        },\n\n        /**\n         * Defines if provided select/deselect actions is relevant.\n         * E.g. there is no need in a 'select page' action if only one\n         * page is available.\n         *\n         * @param {String} actionId - Id of the action to be checked.\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var pageIds         = this.getIds().length,\n                multiplePages   = pageIds < this.totalRecords(),\n                relevant        = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = multiplePages && !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  multiplePages && this.isPageSelected();\n                    break;\n\n                case 'selectAll':\n                    relevant = !this.allSelected();\n                    break;\n\n                case 'deselectAll':\n                    relevant = this.totalSelected() > 0;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Checks if current page has selected records.\n         *\n         * @param {Boolean} [all=false] - If set to 'true' checks that every\n         *      record on the page is selected. Otherwise checks that\n         *      page has some selected records.\n         * @returns {Boolean}\n         */\n        isPageSelected: function (all) {\n            var pageIds = this.getIds(),\n                selected = this.selected(),\n                excluded = this.excluded(),\n                iterator = all ? 'every' : 'some';\n\n            if (this.allSelected()) {\n                return true;\n            }\n\n            if (this.excludeMode()) {\n                return pageIds[iterator](function (id) {\n                    return !~excluded.indexOf(id);\n                });\n            }\n\n            return pageIds[iterator](function (id) {\n                return !!~selected.indexOf(id);\n            });\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        updateState: function () {\n            var selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                totalRecords    = this.totalRecords(),\n                allSelected     = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords && !this.preserveSelectionsOnFilter) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords && !this.preserveSelectionsOnFilter) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        },\n\n        /**\n         * Callback method to handle changes of selected items.\n         *\n         * @param {Array} selected - An array of currently selected items.\n         */\n        onSelectedChange: function (selected) {\n            this.updateExcluded(selected)\n                .countSelected()\n                .updateState();\n        },\n\n        /**\n         * Is invoked when rows has changed. Recalculates selected items\n         * based on \"selectMode\" property.\n         */\n        onRowsChange: function () {\n            var newSelections;\n\n            if (this.excludeMode()) {\n                newSelections = _.union(this.getIds(true), this.selected());\n\n                this.selected(newSelections);\n            }\n        },\n\n        /**\n         * Is invoked when filtration is applied or removed\n         */\n        onFilter: function () {\n            if (!this.preserveSelectionsOnFilter) {\n                this.deselectAll();\n            }\n        },\n\n        /**\n         * Is invoked when search is applied or removed\n         */\n        onSearch: function () {\n            this.onFilter();\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/image',\n            modules: {\n                masonry: '${ $.parentName }',\n                previewComponent: '${ $.parentName }.preview'\n            },\n            previewRowId: null,\n            previewHeight: 0,\n            fields: {\n                id: 'id',\n                url: 'url'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'previewRowId',\n                    'previewHeight'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Updates styles when image loaded.\n         *\n         * @param {Object} record\n         */\n        updateStyles: function (record) {\n            !record.lastInRow || this.masonry().updateStyles();\n        },\n\n        /**\n         * Returns url to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.url];\n        },\n\n        /**\n         * Returns id to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Number}\n         */\n        getId: function (record) {\n            return record[this.fields.id];\n        },\n\n        /**\n         * Returns container styles to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getStyles: function (record) {\n            var styles = record.styles();\n\n            styles['margin-bottom'] = this.previewRowId() === record.rowNumber ? this.previewHeight : 0;\n            record.styles(styles);\n\n            return record.styles;\n        },\n\n        /**\n         * Returns class list to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getClasses: function (record) {\n            return record.css || {};\n        },\n\n        /**\n         * Get is active record\n         *\n         * @param {Object} record - Data to be preprocessed.\n         *\n         * @returns {Boolean}\n         */\n        getIsActive: function (record) {\n            return this.previewComponent().visibleRecord() === record._rowIndex || false;\n        },\n\n        /**\n         * Expand image preview\n         */\n        expandPreview: function (record) {\n            this.previewComponent().show(record);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'jquery',\n    'mage/template',\n    'text!Magento_Ui/templates/grid/cells/thumbnail/preview.html',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function (Column, $, mageTemplate, thumbnailPreviewTemplate, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/thumbnail',\n            fieldClass: {\n                'data-grid-thumbnail-cell': true\n            }\n        },\n\n        /**\n         * Get image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getSrc: function (row) {\n            return row[this.index + '_src'];\n        },\n\n        /**\n         * Get original image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getOrigSrc: function (row) {\n            return row[this.index + '_orig_src'];\n        },\n\n        /**\n         * Get link data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLink: function (row) {\n            return row[this.index + '_link'];\n        },\n\n        /**\n         * Get alternative text data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getAlt: function (row) {\n            return _.escape(row[this.index + '_alt']);\n        },\n\n        /**\n         * Check if preview available.\n         *\n         * @returns {Boolean}\n         */\n        isPreviewAvailable: function () {\n            return this['has_preview'] || false;\n        },\n\n        /**\n         * Build preview.\n         *\n         * @param {Object} row\n         */\n        preview: function (row) {\n            var modalHtml = mageTemplate(\n                    thumbnailPreviewTemplate,\n                    {\n                        src: this.getOrigSrc(row), alt: this.getAlt(row), link: this.getLink(row),\n                        linkText: $.mage.__('Go to Details Page')\n                    }\n                ),\n                previewPopup = $('<div></div>').html(modalHtml);\n\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                modalClass: '_image-box',\n                buttons: []\n            }).trigger('openModal');\n        },\n\n        /**\n         * Get field handler per row.\n         *\n         * @param {Object} row\n         * @returns {Function}\n         */\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    './column',\n    'Magento_Ui/js/modal/confirm',\n    'mage/dataPost'\n], function (_, utils, registry, Column, confirm, dataPost) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/actions',\n            sortable: false,\n            draggable: false,\n            actions: [],\n            rows: [],\n            rowsProvider: '${ $.parentName }',\n            fieldClass: {\n                'data-grid-actions-cell': true\n            },\n            templates: {\n                actions: {}\n            },\n            imports: {\n                rows: '${ $.rowsProvider }:rows'\n            },\n            listens: {\n                rows: 'updateActions'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('actions');\n\n            return this;\n        },\n\n        /**\n         * Returns specific action of a specified row\n         * or all action objects associated with it.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @param {String} [actionIndex] - Action identifier.\n         * @returns {Array|Object}\n         */\n        getAction: function (rowIndex, actionIndex) {\n            var rowActions = this.actions[rowIndex];\n\n            return rowActions && actionIndex ?\n                rowActions[actionIndex] :\n                rowActions;\n        },\n\n        /**\n         * Returns visible actions for a specified row.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array} Visible actions.\n         */\n        getVisibleActions: function (rowIndex) {\n            var rowActions = this.getAction(rowIndex);\n\n            return _.filter(rowActions, this.isActionVisible, this);\n        },\n\n        /**\n         * Adds new action. If an action with the specified identifier\n         * already exists, then the original will be overridden.\n         *\n         * @param {String} index - Actions' identifier.\n         * @param {Object} action - Actions' data.\n         * @returns {ActionsColumn} Chainable.\n         */\n        addAction: function (index, action) {\n            var actionTmpls = this.templates.actions;\n\n            actionTmpls[index] = action;\n\n            this.updateActions();\n\n            return this;\n        },\n\n        /**\n         * Recreates actions for each row.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        updateActions: function () {\n            this.actions = this.rows.map(this._formatActions, this);\n\n            return this;\n        },\n\n        /**\n         * Processes actions, setting additional information to them and\n         * evaluating their properties as string templates.\n         *\n         * @private\n         * @param {Object} row - Row object.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array}\n         */\n        _formatActions: function (row, rowIndex) {\n            var rowActions      = row[this.index] || {},\n                recordId        = row[this.indexField],\n                customActions   = this.templates.actions;\n\n            /**\n             * Actions iterator.\n             */\n            function iterate(action, index) {\n                action = utils.extend({\n                    index: index,\n                    rowIndex: rowIndex,\n                    recordId: recordId\n                }, action);\n\n                return utils.template(action, row, true);\n            }\n\n            rowActions      = _.mapObject(rowActions, iterate);\n            customActions   = _.map(customActions, iterate);\n\n            customActions.forEach(function (action) {\n                rowActions[action.index] = action;\n            });\n\n            return rowActions;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {ActionsColumn} Chainable.\n         */\n        applyAction: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex),\n                callback = this._getCallback(action);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Creates handler for the provided action if it's required.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Function|Undefined}\n         */\n        getActionHandler: function (action) {\n            var index = action.index,\n                rowIndex = action.rowIndex;\n\n            if (this.isHandlerRequired(index, rowIndex)) {\n                return this.applyAction.bind(this, index, rowIndex);\n            }\n        },\n\n        /**\n         * Returns target of action if it's been set.\n         *\n         * @param {Object} action - Action object.\n         * @returns {String}\n         */\n        getTarget: function (action) {\n            if (action.target) {\n                return action.target;\n            }\n\n            return '_self';\n        },\n\n        /**\n         * Checks if specified action requires a handler function.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Boolean}\n         */\n        isHandlerRequired: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex);\n\n            return _.isObject(action.callback) || action.confirm || !action.href;\n        },\n\n        /**\n         * Creates action callback based on it's data. If the action doesn't specify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action) {\n            var args = [action.index, action.recordId, action],\n                callback = action.callback;\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (_.isArray(callback)) {\n                return this._getCallbacks(action);\n            } else if (!_.isFunction(callback)) {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Creates action callback for multiple actions.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallbacks: function (action) {\n            var callback = action.callback,\n                callbacks = [],\n                tmpCallback;\n\n            _.each(callback, function (cb) {\n                tmpCallback = {\n                    action: registry.async(cb.provider),\n                    args: _.compact([cb.target, cb.params])\n                };\n                callbacks.push(tmpCallback);\n            });\n\n            return function () {\n                _.each(callbacks, function (cb) {\n                    cb.action.apply(cb.action, cb.args);\n                });\n            };\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.post) {\n                dataPost().postData({\n                    action: action.href,\n                    data: {}\n                });\n            } else {\n                window.location.href = action.href;\n            }\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Action's data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm;\n\n            confirm({\n                title: confirmData.title,\n                content: confirmData.message,\n                actions: {\n                    confirm: callback\n                }\n            });\n        },\n\n        /**\n         * Checks if row has only one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isSingle: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length === 1;\n        },\n\n        /**\n         * Checks if row has more than one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isMultiple: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length > 1;\n        },\n\n        /**\n         * Checks if action should be displayed.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Boolean}\n         */\n        isActionVisible: function (action) {\n            return action.hidden !== true;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/overlay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/overlay'\n        },\n\n        /**\n         * If overlay should be visible\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isVisible: function (row) {\n            return !!row[this.index];\n        },\n\n        /**\n         * Get overlay label\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLabel: function (row) {\n            return row[this.index];\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/configurable-quantity-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiCollection',\n    'jquery',\n    'ko',\n    'uiLayout',\n    'mageUtils',\n    'underscore',\n    'mage/translate'\n], function (Collection, $, ko, layout, utils, _, $t) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            attribute: {},\n            template: 'Magento_InventoryConfigurableProductAdminUi/container',\n            identifier: 'source_code',\n            dataScope: '',\n            currentAttribute: '',\n            insertListingComponent: '',\n            dynamicRowsName: 'dynamicRows',\n            type: '',\n            templateElementNames: {\n                button: 'button_template',\n                dynamicRows: 'dynamic_rows_template',\n                group: 'group_template'\n            },\n            ignoreTmpls: {\n                childTemplate: true\n            },\n            listens: {\n                'attribute': 'handlerAttributeChange',\n                'insertListingValue': 'handlerInsertValueChange',\n                'type': 'handlerTypeChange'\n            },\n            dynamicRowsCollection: {},\n            imports: {\n                insertListingValue: '${$.insertListingComponent}:value'\n            },\n            modules: {\n                insertListing: '${$.insertListingComponent}'\n            }\n        },\n\n        /**\n         * Generates data for dynamic-rows records\n         * @param {Array} data\n         *\n         * @returns {Array}\n         */\n        generateDynamicRowsData: function (data) {\n            var items = [];\n\n            _.each(data, function (item) {\n                items.push({\n                    'source': item.name,\n                    'source_code': item[this.identifier],\n                    'source_status': parseInt(item.enabled, 10) ? $.mage.__('Enabled') : $.mage.__('Disabled')\n                });\n            }.bind(this));\n\n            return items;\n        },\n\n        /**\n         * Handler for InsertListing value\n         *\n         * @param {Array} data\n         */\n        handlerInsertValueChange: function (data) {\n            var items,\n                path = this.dynamicRowsName + '.' + this.currentDynamicRows;\n\n            if (!this.currentDynamicRows) {\n                return;\n            }\n\n            if (!data.length) {\n                return;\n            }\n\n            items = this.generateDynamicRowsData(data);\n            this.source.set(path, items);\n        },\n\n        /**\n         * Handler for attribute property\n         *\n         * @param {Object} data\n         */\n        handlerAttributeChange: function (data) {\n            if (data && data !== this.currentAttribute) {\n                this.currentAttribute = data;\n                this.destroyChildren();\n\n                _.each(data.chosen, function (item) {\n                    this.addChild(item);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for type property\n         *\n         * @param {String} data\n         */\n        handlerTypeChange: function (data) {\n            if (data === 'single') {\n                this.destroyChildren();\n                this.currentAttribute = {};\n                this.addChild();\n            } else if (data === 'each' && this.attribute) {\n                this.handlerAttributeChange(this.attribute);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid &= elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Parses string templates.\n         * Skip parse if deferredTmpl property set to \"true\"\n         *\n         * @param {Object} obj\n         *\n         * @returns obj\n         */\n        parseTemplateString: function (obj) {\n            var children;\n\n            if (obj.children) {\n                children = utils.copy(obj.children);\n                delete obj.children;\n            }\n\n            obj = utils.template(obj, obj);\n            obj.children = children;\n\n            if (children) {\n                _.each(children, function (child, name) {\n                    obj.children[name] = child.config.deferredTmpl ? child : this.parseTemplateString(child);\n                }, this);\n            }\n\n            obj.name = obj.config.name || obj.name;\n\n            return obj;\n        },\n\n        /**\n         * Handler for modal\n         *\n         * @param {String} id - dynamic-rows name that open modal\n         */\n        handleToggleSourcesModal: function (id) {\n            this.currentDynamicRows = this.type === 'each' ? this.currentAttribute.code + '.' + id : id;\n            this.insertListing().value(this.source.get(this.dynamicRowsName + '.' + this.currentDynamicRows));\n        },\n\n        /**\n         * Generates dynamic data for child.\n         *\n         * @param {Object | Undefined} data - optional.\n         */\n        generateDynamicData: function (data) {\n            var key = data ? data.label : this.dynamicRowsName,\n                drExportTo = this.name + ':dynamicRowsCollection.',\n                drDataScope = 'data.' + this.name + '.',\n                drDataProvider = this.dynamicRowsName + '.';\n\n            if (this.type === 'each') {\n                drDataScope += this.currentAttribute.code + '.';\n                drExportTo += this.currentAttribute.code + '.';\n                drDataProvider += this.currentAttribute.code + '.';\n            }\n\n            drDataScope += key;\n            drExportTo += key;\n            drDataProvider += key;\n\n            return {\n                group: {\n                    name: key\n                },\n                button: {\n                    label: data ? data.label : $t('Quantity'),\n                    targetName: this.name,\n                    param: key\n                },\n                dynamicRows: {\n                    dataScope: drDataScope,\n                    dataProvider: drDataProvider,\n                    name: this.dynamicRowsName,\n                    exportTo: drExportTo\n                }\n            };\n        },\n\n        /**\n         * @param {Object | Undefined} data - optional.\n         */\n        addChild: function (data) {\n            var template = utils.copy(this.childTemplate.templates).children,\n                dynamicRows = template[this.templateElementNames.dynamicRows],\n                button = template[this.templateElementNames.button],\n                group = template[this.templateElementNames.group],\n                dynamicData = this.generateDynamicData(data);\n\n            group.dynamicData = dynamicData.group;\n            group.parent = this.name;\n            group = this.parseTemplateString(group);\n\n            button.dynamicData = dynamicData.button;\n            button.parent = this.name + '.' + group.name;\n            button = this.parseTemplateString(button);\n\n            dynamicRows.dynamicData = dynamicData.dynamicRows;\n            dynamicRows.parent = this.name + '.' + group.name;\n            dynamicRows = this.parseTemplateString(dynamicRows);\n\n            layout([group, button, dynamicRows]);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/dynamic-rows-configurable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n        'use strict';\n\n        var mixin = {\n\n            /**\n             * Parsed data\n             *\n             * @param {Array} data - array with data\n             * about selected records\n             */\n            processingInsertDataFromGrid: function (data) {\n                var changes,\n                    tmpArray;\n\n                if (!data.length) {\n                    return;\n                }\n\n                tmpArray = this.getUnionInsertData();\n\n                changes = this._checkGridData(data);\n                this.cacheGridData = data;\n\n                changes.each(function (changedObject) {\n                    var mappedData = this.mappingValue(changedObject),\n                        sources = [];\n\n                    mappedData[this.canEditField] = 0;\n                    mappedData[this.newProductField] = 0;\n                    mappedData.variationKey = this._getVariationKey(changedObject);\n                    mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n\n                    if ('quantity_per_source' in changedObject) {\n                        changedObject['quantity_per_source'].each(function (source) {\n                            sources.push({\n                                'quantity_per_source': source.qty,\n                                'source': source['source_name'],\n                                'source_code': source['source_code']\n                            });\n                        });\n                        mappedData['quantity_per_source'] = sources;\n                    }\n\n                    tmpArray.push(mappedData);\n                }, this);\n\n                // Attributes cannot be changed before regeneration thought wizard\n                if (!this.source.get('data.attributes').length) {\n                    this.source.set('data.attributes', this.attributesTmp);\n                }\n                this.unionInsertData(tmpArray);\n            }\n        };\n\n        return function (target) {\n            return target.extend(mixin);\n        };\n    }\n);\n","Magento_InventoryConfigurableProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryConfigurableProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 5,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} data\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/summary',\n    'jquery',\n    'mage/translate'\n], function (Summary, $) {\n    'use strict';\n\n    return Summary.extend({\n        defaults: {\n            attributesName: [\n                $.mage.__('Images'),\n                $.mage.__('SKU'),\n                $.mage.__('Quantity Per Source'),\n                $.mage.__('Price')\n            ],\n            quantityFieldName: 'quantityPerSource'\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/bulk',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Bulk, $, ko, _) {\n    'use strict';\n\n    return Bulk.extend({\n        defaults: {\n            quantityModuleName: '',\n            quantityPerSource: '',\n            exports: {\n                attribute: '${$.provider}:data.inventoryAttribute',\n                type: '${$.provider}:data.inventoryType'\n            },\n            modules: {\n                quantityResolver: '${$.quantityResolver}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var sections;\n\n            this._super();\n\n            sections = this.sections();\n            sections.quantityPerSource = {\n                label: 'Quantity Per Source',\n                type: ko.observable('none'),\n                value: ko.observable(),\n                attribute: ko.observable()\n            };\n            this.sections(sections);\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantityPerSource: this.quantityPerSource\n                };\n            }.bind(this);\n\n            this.initAttributeListener();\n\n            return this;\n        },\n\n        /**\n         * Inits listeners for attribute change.\n         */\n        initAttributeListener: function () {\n            var quantityPerSource = this.sections().quantityPerSource;\n\n            quantityPerSource.attribute.subscribe(function (data) {\n                this.attribute(data);\n            }.bind(this));\n\n            quantityPerSource.type.subscribe(function (data) {\n                this.type(data);\n            }.bind(this));\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'attribute',\n                    'type'\n                ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        force: function (wizard) {\n            if (this.type() === 'each' && this.attribute() || this.type() === 'single') {\n                this.prepareDynamicRowsData();\n            }\n\n            this._super(wizard);\n        },\n\n        /**\n         * Prepares dynamic rows data for the next step\n         */\n        prepareDynamicRowsData: function () {\n            var data,\n                module = this.quantityResolver();\n\n            if (this.type() === 'each') {\n                data = module.dynamicRowsCollection[this.attribute().code];\n\n                _.each(this.attribute().chosen, function (item) {\n                    item.sections().quantityPerSource = data[item.label];\n                });\n            } else if (this.type() === 'single') {\n                data = module.dynamicRowsCollection[module.dynamicRowsName];\n                this.sections().quantityPerSource.value(data);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function () {\n            var valid = true,\n                quantityPerSource = this.quantityResolver();\n\n            this._super();\n\n            if (this.type() && this.type() !== 'none') {\n                quantityPerSource.valid = true;\n\n                quantityPerSource.elems().forEach(function (item) {\n                    quantityPerSource.validate.call(quantityPerSource, item);\n                    valid = valid && item.elems()[1].elems().length;\n                });\n\n                if (!quantityPerSource.valid || !valid) {\n                    throw new Error($.mage.__('Please fill-in correct values.'));\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/components/sources-visibility-checker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'uiComponent'\n], function (_, registry, component) {\n    'use strict';\n\n    return component.extend({\n        defaults: {\n            sourcesIndex: ''\n        },\n\n        /**\n         * Hide source tab if convert product to configurable and show it if to simple.\n         */\n        applySourcesConfiguration: function (visibleMatrix) {\n            var source = registry.get('index = ' + this.sourcesIndex);\n\n            if (!_.isUndefined(source)) {\n                source.visible(!visibleMatrix);\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/components/dynamic-rows-configurable'\n], function (dynamicRowsConfigurable) {\n    'use strict';\n\n    return dynamicRowsConfigurable.extend({\n        defaults: {\n            quantityFieldName: 'quantity_per_source'\n        },\n\n        /** @inheritdoc */\n        getProductData: function (row) {\n            var product = this._super(row);\n\n            product[this.quantityFieldName] = row.quantityPerSource;\n\n            return product;\n        }\n    });\n});\n","Sm_BackEnd/jscolor/jscolor.js":"/**\n * jscolor, JavaScript Color Picker\n *\n * @version 1.4.3\n * @license GNU Lesser General Public License, http://www.gnu.org/copyleft/lesser.html\n * @author  Jan Odvarko, http://odvarko.cz\n * @created 2008-06-15\n * @updated 2014-07-16\n * @link    http://jscolor.com\n */\n\n\nvar jscolor = {\n\n\n\tdir : '', // location of jscolor directory (leave empty to autodetect)\n\tbindClass : 'color', // class name\n\tbinding : true, // automatic binding via <input class=\"...\">\n\tpreloading : true, // use image preloading?\n\n\n\tinstall : function() {\n\t\tjscolor.addEvent(window, 'load', jscolor.init);\n\t},\n\n\n\tinit : function() {\n\t\tif(jscolor.binding) {\n\t\t\tjscolor.bind();\n\t\t}\n\t\tif(jscolor.preloading) {\n\t\t\tjscolor.preload();\n\t\t}\n\t},\n\n\n\tgetDir : function() {\n\t\tif(!jscolor.dir) {\n\t\t\tvar detected = jscolor.detectDir();\n\t\t\tjscolor.dir = detected!==false ? detected : 'jscolor/';\n\t\t}\n\t\treturn jscolor.dir;\n\t},\n\n\n\tdetectDir : function() {\n\t\tvar base = location.href;\n\n\t\tvar e = document.getElementsByTagName('base');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tif(e[i].href) { base = e[i].href; }\n\t\t}\n\n\t\tvar e = document.getElementsByTagName('script');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tif(e[i].src && /(^|\\/)jscolor\\.js([?#].*)?$/i.test(e[i].src)) {\n\t\t\t\tvar src = new jscolor.URI(e[i].src);\n\t\t\t\tvar srcAbs = src.toAbsolute(base);\n\t\t\t\tsrcAbs.path = srcAbs.path.replace(/[^\\/]+$/, ''); // remove filename\n\t\t\t\tsrcAbs.query = null;\n\t\t\t\tsrcAbs.fragment = null;\n\t\t\t\treturn srcAbs.toString();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t},\n\n\n\tbind : function() {\n\t\tvar matchClass = new RegExp('(^|\\\\s)('+jscolor.bindClass+')(\\\\s*(\\\\{[^}]*\\\\})|\\\\s|$)', 'i');\n\t\tvar e = document.getElementsByTagName('input');\n\t\tfor(var i=0; i<e.length; i+=1) {\n\t\t\tvar m;\n\t\t\tif(!e[i].color && e[i].className && (m = e[i].className.match(matchClass))) {\n\t\t\t\tvar prop = {};\n\t\t\t\tif(m[4]) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tprop = (new Function ('return (' + m[4] + ')'))();\n\t\t\t\t\t} catch(eInvalidProp) {}\n\t\t\t\t}\n\t\t\t\te[i].color = new jscolor.color(e[i], prop);\n\t\t\t}\n\t\t}\n\t},\n\n\n\tpreload : function() {\n\t\tfor(var fn in jscolor.imgRequire) {\n\t\t\tif(jscolor.imgRequire.hasOwnProperty(fn)) {\n\t\t\t\tjscolor.loadImage(fn);\n\t\t\t}\n\t\t}\n\t},\n\n\n\timages : {\n\t\tpad : [ 181, 101 ],\n\t\tsld : [ 16, 101 ],\n\t\tcross : [ 15, 15 ],\n\t\tarrow : [ 7, 11 ]\n\t},\n\n\n\timgRequire : {},\n\timgLoaded : {},\n\n\n\trequireImage : function(filename) {\n\t\tjscolor.imgRequire[filename] = true;\n\t},\n\n\n\tloadImage : function(filename) {\n\t\tif(!jscolor.imgLoaded[filename]) {\n\t\t\tjscolor.imgLoaded[filename] = new Image();\n\t\t\tjscolor.imgLoaded[filename].src = jscolor.getDir()+filename;\n\t\t}\n\t},\n\n\n\tfetchElement : function(mixed) {\n\t\treturn typeof mixed === 'string' ? document.getElementById(mixed) : mixed;\n\t},\n\n\n\taddEvent : function(el, evnt, func) {\n\t\tif(el.addEventListener) {\n\t\t\tel.addEventListener(evnt, func, false);\n\t\t} else if(el.attachEvent) {\n\t\t\tel.attachEvent('on'+evnt, func);\n\t\t}\n\t},\n\n\n\tfireEvent : function(el, evnt) {\n\t\tif(!el) {\n\t\t\treturn;\n\t\t}\n\t\tif(document.createEvent) {\n\t\t\tvar ev = document.createEvent('HTMLEvents');\n\t\t\tev.initEvent(evnt, true, true);\n\t\t\tel.dispatchEvent(ev);\n\t\t} else if(document.createEventObject) {\n\t\t\tvar ev = document.createEventObject();\n\t\t\tel.fireEvent('on'+evnt, ev);\n\t\t} else if(el['on'+evnt]) { // alternatively use the traditional event model (IE5)\n\t\t\tel['on'+evnt]();\n\t\t}\n\t},\n\n\n\tgetElementPos : function(e) {\n\t\tvar e1=e, e2=e;\n\t\tvar x=0, y=0;\n\t\tif(e1.offsetParent) {\n\t\t\tdo {\n\t\t\t\tx += e1.offsetLeft;\n\t\t\t\ty += e1.offsetTop;\n\t\t\t} while(e1 = e1.offsetParent);\n\t\t}\n\t\twhile((e2 = e2.parentNode) && e2.nodeName.toUpperCase() !== 'BODY') {\n\t\t\tx -= e2.scrollLeft;\n\t\t\ty -= e2.scrollTop;\n\t\t}\n\t\treturn [x, y];\n\t},\n\n\n\tgetElementSize : function(e) {\n\t\treturn [e.offsetWidth, e.offsetHeight];\n\t},\n\n\n\tgetRelMousePos : function(e) {\n\t\tvar x = 0, y = 0;\n\t\tif (!e) { e = window.event; }\n\t\tif (typeof e.offsetX === 'number') {\n\t\t\tx = e.offsetX;\n\t\t\ty = e.offsetY;\n\t\t} else if (typeof e.layerX === 'number') {\n\t\t\tx = e.layerX;\n\t\t\ty = e.layerY;\n\t\t}\n\t\treturn { x: x, y: y };\n\t},\n\n\n\tgetViewPos : function() {\n\t\tif(typeof window.pageYOffset === 'number') {\n\t\t\treturn [window.pageXOffset, window.pageYOffset];\n\t\t} else if(document.body && (document.body.scrollLeft || document.body.scrollTop)) {\n\t\t\treturn [document.body.scrollLeft, document.body.scrollTop];\n\t\t} else if(document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {\n\t\t\treturn [document.documentElement.scrollLeft, document.documentElement.scrollTop];\n\t\t} else {\n\t\t\treturn [0, 0];\n\t\t}\n\t},\n\n\n\tgetViewSize : function() {\n\t\tif(typeof window.innerWidth === 'number') {\n\t\t\treturn [window.innerWidth, window.innerHeight];\n\t\t} else if(document.body && (document.body.clientWidth || document.body.clientHeight)) {\n\t\t\treturn [document.body.clientWidth, document.body.clientHeight];\n\t\t} else if(document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {\n\t\t\treturn [document.documentElement.clientWidth, document.documentElement.clientHeight];\n\t\t} else {\n\t\t\treturn [0, 0];\n\t\t}\n\t},\n\n\n\tURI : function(uri) { // See RFC3986\n\n\t\tthis.scheme = null;\n\t\tthis.authority = null;\n\t\tthis.path = '';\n\t\tthis.query = null;\n\t\tthis.fragment = null;\n\n\t\tthis.parse = function(uri) {\n\t\t\tvar m = uri.match(/^(([A-Za-z][0-9A-Za-z+.-]*)(:))?((\\/\\/)([^\\/?#]*))?([^?#]*)((\\?)([^#]*))?((#)(.*))?/);\n\t\t\tthis.scheme = m[3] ? m[2] : null;\n\t\t\tthis.authority = m[5] ? m[6] : null;\n\t\t\tthis.path = m[7];\n\t\t\tthis.query = m[9] ? m[10] : null;\n\t\t\tthis.fragment = m[12] ? m[13] : null;\n\t\t\treturn this;\n\t\t};\n\n\t\tthis.toString = function() {\n\t\t\tvar result = '';\n\t\t\tif(this.scheme !== null) { result = result + this.scheme + ':'; }\n\t\t\tif(this.authority !== null) { result = result + '//' + this.authority; }\n\t\t\tif(this.path !== null) { result = result + this.path; }\n\t\t\tif(this.query !== null) { result = result + '?' + this.query; }\n\t\t\tif(this.fragment !== null) { result = result + '#' + this.fragment; }\n\t\t\treturn result;\n\t\t};\n\n\t\tthis.toAbsolute = function(base) {\n\t\t\tvar base = new jscolor.URI(base);\n\t\t\tvar r = this;\n\t\t\tvar t = new jscolor.URI;\n\n\t\t\tif(base.scheme === null) { return false; }\n\n\t\t\tif(r.scheme !== null && r.scheme.toLowerCase() === base.scheme.toLowerCase()) {\n\t\t\t\tr.scheme = null;\n\t\t\t}\n\n\t\t\tif(r.scheme !== null) {\n\t\t\t\tt.scheme = r.scheme;\n\t\t\t\tt.authority = r.authority;\n\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\tt.query = r.query;\n\t\t\t} else {\n\t\t\t\tif(r.authority !== null) {\n\t\t\t\t\tt.authority = r.authority;\n\t\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\t\tt.query = r.query;\n\t\t\t\t} else {\n\t\t\t\t\tif(r.path === '') {\n\t\t\t\t\t\tt.path = base.path;\n\t\t\t\t\t\tif(r.query !== null) {\n\t\t\t\t\t\t\tt.query = r.query;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tt.query = base.query;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif(r.path.substr(0,1) === '/') {\n\t\t\t\t\t\t\tt.path = removeDotSegments(r.path);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tif(base.authority !== null && base.path === '') {\n\t\t\t\t\t\t\t\tt.path = '/'+r.path;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tt.path = base.path.replace(/[^\\/]+$/,'')+r.path;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tt.path = removeDotSegments(t.path);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tt.query = r.query;\n\t\t\t\t\t}\n\t\t\t\t\tt.authority = base.authority;\n\t\t\t\t}\n\t\t\t\tt.scheme = base.scheme;\n\t\t\t}\n\t\t\tt.fragment = r.fragment;\n\n\t\t\treturn t;\n\t\t};\n\n\t\tfunction removeDotSegments(path) {\n\t\t\tvar out = '';\n\t\t\twhile(path) {\n\t\t\t\tif(path.substr(0,3)==='../' || path.substr(0,2)==='./') {\n\t\t\t\t\tpath = path.replace(/^\\.+/,'').substr(1);\n\t\t\t\t} else if(path.substr(0,3)==='/./' || path==='/.') {\n\t\t\t\t\tpath = '/'+path.substr(3);\n\t\t\t\t} else if(path.substr(0,4)==='/../' || path==='/..') {\n\t\t\t\t\tpath = '/'+path.substr(4);\n\t\t\t\t\tout = out.replace(/\\/?[^\\/]*$/, '');\n\t\t\t\t} else if(path==='.' || path==='..') {\n\t\t\t\t\tpath = '';\n\t\t\t\t} else {\n\t\t\t\t\tvar rm = path.match(/^\\/?[^\\/]*/)[0];\n\t\t\t\t\tpath = path.substr(rm.length);\n\t\t\t\t\tout = out + rm;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn out;\n\t\t}\n\n\t\tif(uri) {\n\t\t\tthis.parse(uri);\n\t\t}\n\n\t},\n\n\n\t//\n\t// Usage example:\n\t// var myColor = new jscolor.color(myInputElement)\n\t//\n\n\tcolor : function(target, prop) {\n\n\n\t\tthis.required = true; // refuse empty values?\n\t\tthis.adjust = true; // adjust value to uniform notation?\n\t\tthis.hash = false; // prefix color with # symbol?\n\t\tthis.caps = true; // uppercase?\n\t\tthis.slider = true; // show the value/saturation slider?\n\t\tthis.valueElement = target; // value holder\n\t\tthis.styleElement = target; // where to reflect current color\n\t\tthis.onImmediateChange = null; // onchange callback (can be either string or function)\n\t\tthis.hsv = [0, 0, 1]; // read-only  0-6, 0-1, 0-1\n\t\tthis.rgb = [1, 1, 1]; // read-only  0-1, 0-1, 0-1\n\t\tthis.minH = 0; // read-only  0-6\n\t\tthis.maxH = 6; // read-only  0-6\n\t\tthis.minS = 0; // read-only  0-1\n\t\tthis.maxS = 1; // read-only  0-1\n\t\tthis.minV = 0; // read-only  0-1\n\t\tthis.maxV = 1; // read-only  0-1\n\n\t\tthis.pickerOnfocus = true; // display picker on focus?\n\t\tthis.pickerMode = 'HSV'; // HSV | HVS\n\t\tthis.pickerPosition = 'bottom'; // left | right | top | bottom\n\t\tthis.pickerSmartPosition = true; // automatically adjust picker position when necessary\n\t\tthis.pickerButtonHeight = 20; // px\n\t\tthis.pickerClosable = false;\n\t\tthis.pickerCloseText = 'Close';\n\t\tthis.pickerButtonColor = 'ButtonText'; // px\n\t\tthis.pickerFace = 10; // px\n\t\tthis.pickerFaceColor = 'ThreeDFace'; // CSS color\n\t\tthis.pickerBorder = 1; // px\n\t\tthis.pickerBorderColor = 'ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight'; // CSS color\n\t\tthis.pickerInset = 1; // px\n\t\tthis.pickerInsetColor = 'ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow'; // CSS color\n\t\tthis.pickerZIndex = 10000;\n\n\n\t\tfor(var p in prop) {\n\t\t\tif(prop.hasOwnProperty(p)) {\n\t\t\t\tthis[p] = prop[p];\n\t\t\t}\n\t\t}\n\n\n\t\tthis.hidePicker = function() {\n\t\t\tif(isPickerOwner()) {\n\t\t\t\tremovePicker();\n\t\t\t}\n\t\t};\n\n\n\t\tthis.showPicker = function() {\n\t\t\tif(!isPickerOwner()) {\n\t\t\t\tvar tp = jscolor.getElementPos(target); // target pos\n\t\t\t\tvar ts = jscolor.getElementSize(target); // target size\n\t\t\t\tvar vp = jscolor.getViewPos(); // view pos\n\t\t\t\tvar vs = jscolor.getViewSize(); // view size\n\t\t\t\tvar ps = getPickerDims(this); // picker size\n\t\t\t\tvar a, b, c;\n\t\t\t\tswitch(this.pickerPosition.toLowerCase()) {\n\t\t\t\t\tcase 'left': a=1; b=0; c=-1; break;\n\t\t\t\t\tcase 'right':a=1; b=0; c=1; break;\n\t\t\t\t\tcase 'top':  a=0; b=1; c=-1; break;\n\t\t\t\t\tdefault:     a=0; b=1; c=1; break;\n\t\t\t\t}\n\t\t\t\tvar l = (ts[b]+ps[b])/2;\n\n\t\t\t\t// picker pos\n\t\t\t\tif (!this.pickerSmartPosition) {\n\t\t\t\t\tvar pp = [\n\t\t\t\t\t\ttp[a],\n\t\t\t\t\t\ttp[b]+ts[b]-l+l*c\n\t\t\t\t\t];\n\t\t\t\t} else {\n\t\t\t\t\tvar pp = [\n\t\t\t\t\t\t-vp[a]+tp[a]+ps[a] > vs[a] ?\n\t\t\t\t\t\t\t(-vp[a]+tp[a]+ts[a]/2 > vs[a]/2 && tp[a]+ts[a]-ps[a] >= 0 ? tp[a]+ts[a]-ps[a] : tp[a]) :\n\t\t\t\t\t\t\ttp[a],\n\t\t\t\t\t\t-vp[b]+tp[b]+ts[b]+ps[b]-l+l*c > vs[b] ?\n\t\t\t\t\t\t\t(-vp[b]+tp[b]+ts[b]/2 > vs[b]/2 && tp[b]+ts[b]-l-l*c >= 0 ? tp[b]+ts[b]-l-l*c : tp[b]+ts[b]-l+l*c) :\n\t\t\t\t\t\t\t(tp[b]+ts[b]-l+l*c >= 0 ? tp[b]+ts[b]-l+l*c : tp[b]+ts[b]-l-l*c)\n\t\t\t\t\t];\n\t\t\t\t}\n\t\t\t\tdrawPicker(pp[a], pp[b]);\n\t\t\t}\n\t\t};\n\n\n\t\tthis.importColor = function() {\n\t\t\tif(!valueElement) {\n\t\t\t\tthis.exportColor();\n\t\t\t} else {\n\t\t\t\tif(!this.adjust) {\n\t\t\t\t\tif(!this.fromString(valueElement.value, leaveValue)) {\n\t\t\t\t\t\tstyleElement.style.backgroundImage = styleElement.jscStyle.backgroundImage;\n\t\t\t\t\t\tstyleElement.style.backgroundColor = styleElement.jscStyle.backgroundColor;\n\t\t\t\t\t\tstyleElement.style.color = styleElement.jscStyle.color;\n\t\t\t\t\t\tthis.exportColor(leaveValue | leaveStyle);\n\t\t\t\t\t}\n\t\t\t\t} else if(!this.required && /^\\s*$/.test(valueElement.value)) {\n\t\t\t\t\tvalueElement.value = '';\n\t\t\t\t\tstyleElement.style.backgroundImage = styleElement.jscStyle.backgroundImage;\n\t\t\t\t\tstyleElement.style.backgroundColor = styleElement.jscStyle.backgroundColor;\n\t\t\t\t\tstyleElement.style.color = styleElement.jscStyle.color;\n\t\t\t\t\tthis.exportColor(leaveValue | leaveStyle);\n\n\t\t\t\t} else if(this.fromString(valueElement.value)) {\n\t\t\t\t\t// OK\n\t\t\t\t} else {\n\t\t\t\t\tthis.exportColor();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\n\t\tthis.exportColor = function(flags) {\n\t\t\tif(!(flags & leaveValue) && valueElement) {\n\t\t\t\tvar value = this.toString();\n\t\t\t\tif(this.caps) { value = value.toUpperCase(); }\n\t\t\t\tif(this.hash) { value = '#'+value; }\n\t\t\t\tvalueElement.value = value;\n\t\t\t}\n\t\t\tif(!(flags & leaveStyle) && styleElement) {\n\t\t\t\tstyleElement.style.backgroundImage = \"none\";\n\t\t\t\tstyleElement.style.backgroundColor =\n\t\t\t\t\t'#'+this.toString();\n\t\t\t\tstyleElement.style.color =\n\t\t\t\t\t0.213 * this.rgb[0] +\n\t\t\t\t\t0.715 * this.rgb[1] +\n\t\t\t\t\t0.072 * this.rgb[2]\n\t\t\t\t\t< 0.5 ? '#FFF' : '#000';\n\t\t\t}\n\t\t\tif(!(flags & leavePad) && isPickerOwner()) {\n\t\t\t\tredrawPad();\n\t\t\t}\n\t\t\tif(!(flags & leaveSld) && isPickerOwner()) {\n\t\t\t\tredrawSld();\n\t\t\t}\n\t\t};\n\n\n\t\tthis.fromHSV = function(h, s, v, flags) { // null = don't change\n\t\t\tif(h !== null) { h = Math.max(0.0, this.minH, Math.min(6.0, this.maxH, h)); }\n\t\t\tif(s !== null) { s = Math.max(0.0, this.minS, Math.min(1.0, this.maxS, s)); }\n\t\t\tif(v !== null) { v = Math.max(0.0, this.minV, Math.min(1.0, this.maxV, v)); }\n\n\t\t\tthis.rgb = HSV_RGB(\n\t\t\t\th===null ? this.hsv[0] : (this.hsv[0]=h),\n\t\t\t\ts===null ? this.hsv[1] : (this.hsv[1]=s),\n\t\t\t\tv===null ? this.hsv[2] : (this.hsv[2]=v)\n\t\t\t);\n\n\t\t\tthis.exportColor(flags);\n\t\t};\n\n\n\t\tthis.fromRGB = function(r, g, b, flags) { // null = don't change\n\t\t\tif(r !== null) { r = Math.max(0.0, Math.min(1.0, r)); }\n\t\t\tif(g !== null) { g = Math.max(0.0, Math.min(1.0, g)); }\n\t\t\tif(b !== null) { b = Math.max(0.0, Math.min(1.0, b)); }\n\n\t\t\tvar hsv = RGB_HSV(\n\t\t\t\tr===null ? this.rgb[0] : r,\n\t\t\t\tg===null ? this.rgb[1] : g,\n\t\t\t\tb===null ? this.rgb[2] : b\n\t\t\t);\n\t\t\tif(hsv[0] !== null) {\n\t\t\t\tthis.hsv[0] = Math.max(0.0, this.minH, Math.min(6.0, this.maxH, hsv[0]));\n\t\t\t}\n\t\t\tif(hsv[2] !== 0) {\n\t\t\t\tthis.hsv[1] = hsv[1]===null ? null : Math.max(0.0, this.minS, Math.min(1.0, this.maxS, hsv[1]));\n\t\t\t}\n\t\t\tthis.hsv[2] = hsv[2]===null ? null : Math.max(0.0, this.minV, Math.min(1.0, this.maxV, hsv[2]));\n\n\t\t\t// update RGB according to final HSV, as some values might be trimmed\n\t\t\tvar rgb = HSV_RGB(this.hsv[0], this.hsv[1], this.hsv[2]);\n\t\t\tthis.rgb[0] = rgb[0];\n\t\t\tthis.rgb[1] = rgb[1];\n\t\t\tthis.rgb[2] = rgb[2];\n\n\t\t\tthis.exportColor(flags);\n\t\t};\n\n\n\t\tthis.fromString = function(hex, flags) {\n\t\t\tvar m = hex.match(/^\\W*([0-9A-F]{3}([0-9A-F]{3})?)\\W*$/i);\n\t\t\tif(!m) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tif(m[1].length === 6) { // 6-char notation\n\t\t\t\t\tthis.fromRGB(\n\t\t\t\t\t\tparseInt(m[1].substr(0,2),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].substr(2,2),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].substr(4,2),16) / 255,\n\t\t\t\t\t\tflags\n\t\t\t\t\t);\n\t\t\t\t} else { // 3-char notation\n\t\t\t\t\tthis.fromRGB(\n\t\t\t\t\t\tparseInt(m[1].charAt(0)+m[1].charAt(0),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].charAt(1)+m[1].charAt(1),16) / 255,\n\t\t\t\t\t\tparseInt(m[1].charAt(2)+m[1].charAt(2),16) / 255,\n\t\t\t\t\t\tflags\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t}\n\t\t};\n\n\n\t\tthis.toString = function() {\n\t\t\treturn (\n\t\t\t\t(0x100 | Math.round(255*this.rgb[0])).toString(16).substr(1) +\n\t\t\t\t(0x100 | Math.round(255*this.rgb[1])).toString(16).substr(1) +\n\t\t\t\t(0x100 | Math.round(255*this.rgb[2])).toString(16).substr(1)\n\t\t\t);\n\t\t};\n\n\n\t\tfunction RGB_HSV(r, g, b) {\n\t\t\tvar n = Math.min(Math.min(r,g),b);\n\t\t\tvar v = Math.max(Math.max(r,g),b);\n\t\t\tvar m = v - n;\n\t\t\tif(m === 0) { return [ null, 0, v ]; }\n\t\t\tvar h = r===n ? 3+(b-g)/m : (g===n ? 5+(r-b)/m : 1+(g-r)/m);\n\t\t\treturn [ h===6?0:h, m/v, v ];\n\t\t}\n\n\n\t\tfunction HSV_RGB(h, s, v) {\n\t\t\tif(h === null) { return [ v, v, v ]; }\n\t\t\tvar i = Math.floor(h);\n\t\t\tvar f = i%2 ? h-i : 1-(h-i);\n\t\t\tvar m = v * (1 - s);\n\t\t\tvar n = v * (1 - s*f);\n\t\t\tswitch(i) {\n\t\t\t\tcase 6:\n\t\t\t\tcase 0: return [v,n,m];\n\t\t\t\tcase 1: return [n,v,m];\n\t\t\t\tcase 2: return [m,v,n];\n\t\t\t\tcase 3: return [m,n,v];\n\t\t\t\tcase 4: return [n,m,v];\n\t\t\t\tcase 5: return [v,m,n];\n\t\t\t}\n\t\t}\n\n\n\t\tfunction removePicker() {\n\t\t\tdelete jscolor.picker.owner;\n\t\t\tdocument.getElementsByTagName('body')[0].removeChild(jscolor.picker.boxB);\n\t\t}\n\n\n\t\tfunction drawPicker(x, y) {\n\t\t\tif(!jscolor.picker) {\n\t\t\t\tjscolor.picker = {\n\t\t\t\t\tbox : document.createElement('div'),\n\t\t\t\t\tboxB : document.createElement('div'),\n\t\t\t\t\tpad : document.createElement('div'),\n\t\t\t\t\tpadB : document.createElement('div'),\n\t\t\t\t\tpadM : document.createElement('div'),\n\t\t\t\t\tsld : document.createElement('div'),\n\t\t\t\t\tsldB : document.createElement('div'),\n\t\t\t\t\tsldM : document.createElement('div'),\n\t\t\t\t\tbtn : document.createElement('div'),\n\t\t\t\t\tbtnS : document.createElement('span'),\n\t\t\t\t\tbtnT : document.createTextNode(THIS.pickerCloseText)\n\t\t\t\t};\n\t\t\t\tfor(var i=0,segSize=4; i<jscolor.images.sld[1]; i+=segSize) {\n\t\t\t\t\tvar seg = document.createElement('div');\n\t\t\t\t\tseg.style.height = segSize+'px';\n\t\t\t\t\tseg.style.fontSize = '1px';\n\t\t\t\t\tseg.style.lineHeight = '0';\n\t\t\t\t\tjscolor.picker.sld.appendChild(seg);\n\t\t\t\t}\n\t\t\t\tjscolor.picker.sldB.appendChild(jscolor.picker.sld);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.sldB);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.sldM);\n\t\t\t\tjscolor.picker.padB.appendChild(jscolor.picker.pad);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.padB);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.padM);\n\t\t\t\tjscolor.picker.btnS.appendChild(jscolor.picker.btnT);\n\t\t\t\tjscolor.picker.btn.appendChild(jscolor.picker.btnS);\n\t\t\t\tjscolor.picker.box.appendChild(jscolor.picker.btn);\n\t\t\t\tjscolor.picker.boxB.appendChild(jscolor.picker.box);\n\t\t\t}\n\n\t\t\tvar p = jscolor.picker;\n\n\t\t\t// controls interaction\n\t\t\tp.box.onmouseup =\n\t\t\tp.box.onmouseout = function() { target.focus(); };\n\t\t\tp.box.onmousedown = function() { abortBlur=true; };\n\t\t\tp.box.onmousemove = function(e) {\n\t\t\t\tif (holdPad || holdSld) {\n\t\t\t\t\tholdPad && setPad(e);\n\t\t\t\t\tholdSld && setSld(e);\n\t\t\t\t\tif (document.selection) {\n\t\t\t\t\t\tdocument.selection.empty();\n\t\t\t\t\t} else if (window.getSelection) {\n\t\t\t\t\t\twindow.getSelection().removeAllRanges();\n\t\t\t\t\t}\n\t\t\t\t\tdispatchImmediateChange();\n\t\t\t\t}\n\t\t\t};\n\t\t\tif('ontouchstart' in window) { // if touch device\n\t\t\t\tvar handle_touchmove = function(e) {\n\t\t\t\t\tvar event={\n\t\t\t\t\t\t'offsetX': e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY': e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t};\n\t\t\t\t\tif (holdPad || holdSld) {\n\t\t\t\t\t\tholdPad && setPad(event);\n\t\t\t\t\t\tholdSld && setSld(event);\n\t\t\t\t\t\tdispatchImmediateChange();\n\t\t\t\t\t}\n\t\t\t\t\te.stopPropagation(); // prevent move \"view\" on broswer\n\t\t\t\t\te.preventDefault(); // prevent Default - Android Fix (else android generated only 1-2 touchmove events)\n\t\t\t\t};\n\t\t\t\tp.box.removeEventListener('touchmove', handle_touchmove, false)\n\t\t\t\tp.box.addEventListener('touchmove', handle_touchmove, false)\n\t\t\t}\n\t\t\tp.padM.onmouseup =\n\t\t\tp.padM.onmouseout = function() { if(holdPad) { holdPad=false; jscolor.fireEvent(valueElement,'change'); } };\n\t\t\tp.padM.onmousedown = function(e) {\n\t\t\t\t// if the slider is at the bottom, move it up\n\t\t\t\tswitch(modeID) {\n\t\t\t\t\tcase 0: if (THIS.hsv[2] === 0) { THIS.fromHSV(null, null, 1.0); }; break;\n\t\t\t\t\tcase 1: if (THIS.hsv[1] === 0) { THIS.fromHSV(null, 1.0, null); }; break;\n\t\t\t\t}\n\t\t\t\tholdSld=false;\n\t\t\t\tholdPad=true;\n\t\t\t\tsetPad(e);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tif('ontouchstart' in window) {\n\t\t\t\tp.padM.addEventListener('touchstart', function(e) {\n\t\t\t\t\ttouchOffset={\n\t\t\t\t\t\t'X': e.target.offsetParent.offsetLeft,\n\t\t\t\t\t\t'Y': e.target.offsetParent.offsetTop\n\t\t\t\t\t};\n\t\t\t\t\tthis.onmousedown({\n\t\t\t\t\t\t'offsetX':e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY':e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t\tp.sldM.onmouseup =\n\t\t\tp.sldM.onmouseout = function() { if(holdSld) { holdSld=false; jscolor.fireEvent(valueElement,'change'); } };\n\t\t\tp.sldM.onmousedown = function(e) {\n\t\t\t\tholdPad=false;\n\t\t\t\tholdSld=true;\n\t\t\t\tsetSld(e);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tif('ontouchstart' in window) {\n\t\t\t\tp.sldM.addEventListener('touchstart', function(e) {\n\t\t\t\t\ttouchOffset={\n\t\t\t\t\t\t'X': e.target.offsetParent.offsetLeft,\n\t\t\t\t\t\t'Y': e.target.offsetParent.offsetTop\n\t\t\t\t\t};\n\t\t\t\t\tthis.onmousedown({\n\t\t\t\t\t\t'offsetX':e.touches[0].pageX-touchOffset.X,\n\t\t\t\t\t\t'offsetY':e.touches[0].pageY-touchOffset.Y\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// picker\n\t\t\tvar dims = getPickerDims(THIS);\n\t\t\tp.box.style.width = dims[0] + 'px';\n\t\t\tp.box.style.height = dims[1] + 'px';\n\n\t\t\t// picker border\n\t\t\tp.boxB.style.position = 'absolute';\n\t\t\tp.boxB.style.clear = 'both';\n\t\t\tp.boxB.style.left = x+'px';\n\t\t\tp.boxB.style.top = y+'px';\n\t\t\tp.boxB.style.zIndex = THIS.pickerZIndex;\n\t\t\tp.boxB.style.border = THIS.pickerBorder+'px solid';\n\t\t\tp.boxB.style.borderColor = THIS.pickerBorderColor;\n\t\t\tp.boxB.style.background = THIS.pickerFaceColor;\n\n\t\t\t// pad image\n\t\t\tp.pad.style.width = jscolor.images.pad[0]+'px';\n\t\t\tp.pad.style.height = jscolor.images.pad[1]+'px';\n\n\t\t\t// pad border\n\t\t\tp.padB.style.position = 'absolute';\n\t\t\tp.padB.style.left = THIS.pickerFace+'px';\n\t\t\tp.padB.style.top = THIS.pickerFace+'px';\n\t\t\tp.padB.style.border = THIS.pickerInset+'px solid';\n\t\t\tp.padB.style.borderColor = THIS.pickerInsetColor;\n\n\t\t\t// pad mouse area\n\t\t\tp.padM.style.position = 'absolute';\n\t\t\tp.padM.style.left = '0';\n\t\t\tp.padM.style.top = '0';\n\t\t\tp.padM.style.width = THIS.pickerFace + 2*THIS.pickerInset + jscolor.images.pad[0] + jscolor.images.arrow[0] + 'px';\n\t\t\tp.padM.style.height = p.box.style.height;\n\t\t\tp.padM.style.cursor = 'crosshair';\n\n\t\t\t// slider image\n\t\t\tp.sld.style.overflow = 'hidden';\n\t\t\tp.sld.style.width = jscolor.images.sld[0]+'px';\n\t\t\tp.sld.style.height = jscolor.images.sld[1]+'px';\n\n\t\t\t// slider border\n\t\t\tp.sldB.style.display = THIS.slider ? 'block' : 'none';\n\t\t\tp.sldB.style.position = 'absolute';\n\t\t\tp.sldB.style.right = THIS.pickerFace+'px';\n\t\t\tp.sldB.style.top = THIS.pickerFace+'px';\n\t\t\tp.sldB.style.border = THIS.pickerInset+'px solid';\n\t\t\tp.sldB.style.borderColor = THIS.pickerInsetColor;\n\n\t\t\t// slider mouse area\n\t\t\tp.sldM.style.display = THIS.slider ? 'block' : 'none';\n\t\t\tp.sldM.style.position = 'absolute';\n\t\t\tp.sldM.style.right = '0';\n\t\t\tp.sldM.style.top = '0';\n\t\t\tp.sldM.style.width = jscolor.images.sld[0] + jscolor.images.arrow[0] + THIS.pickerFace + 2*THIS.pickerInset + 'px';\n\t\t\tp.sldM.style.height = p.box.style.height;\n\t\t\ttry {\n\t\t\t\tp.sldM.style.cursor = 'pointer';\n\t\t\t} catch(eOldIE) {\n\t\t\t\tp.sldM.style.cursor = 'hand';\n\t\t\t}\n\n\t\t\t// \"close\" button\n\t\t\tfunction setBtnBorder() {\n\t\t\t\tvar insetColors = THIS.pickerInsetColor.split(/\\s+/);\n\t\t\t\tvar pickerOutsetColor = insetColors.length < 2 ? insetColors[0] : insetColors[1] + ' ' + insetColors[0] + ' ' + insetColors[0] + ' ' + insetColors[1];\n\t\t\t\tp.btn.style.borderColor = pickerOutsetColor;\n\t\t\t}\n\t\t\tp.btn.style.display = THIS.pickerClosable ? 'block' : 'none';\n\t\t\tp.btn.style.position = 'absolute';\n\t\t\tp.btn.style.left = THIS.pickerFace + 'px';\n\t\t\tp.btn.style.bottom = THIS.pickerFace + 'px';\n\t\t\tp.btn.style.padding = '0 15px';\n\t\t\tp.btn.style.height = '18px';\n\t\t\tp.btn.style.border = THIS.pickerInset + 'px solid';\n\t\t\tsetBtnBorder();\n\t\t\tp.btn.style.color = THIS.pickerButtonColor;\n\t\t\tp.btn.style.font = '12px sans-serif';\n\t\t\tp.btn.style.textAlign = 'center';\n\t\t\ttry {\n\t\t\t\tp.btn.style.cursor = 'pointer';\n\t\t\t} catch(eOldIE) {\n\t\t\t\tp.btn.style.cursor = 'hand';\n\t\t\t}\n\t\t\tp.btn.onmousedown = function () {\n\t\t\t\tTHIS.hidePicker();\n\t\t\t};\n\t\t\tp.btnS.style.lineHeight = p.btn.style.height;\n\n\t\t\t// load images in optimal order\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var padImg = 'hs.png'; break;\n\t\t\t\tcase 1: var padImg = 'hv.png'; break;\n\t\t\t}\n\t\t\tp.padM.style.backgroundImage = \"url('\"+jscolor.getDir()+\"cross.gif')\";\n\t\t\tp.padM.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.sldM.style.backgroundImage = \"url('\"+jscolor.getDir()+\"arrow.gif')\";\n\t\t\tp.sldM.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.pad.style.backgroundImage = \"url('\"+jscolor.getDir()+padImg+\"')\";\n\t\t\tp.pad.style.backgroundRepeat = \"no-repeat\";\n\t\t\tp.pad.style.backgroundPosition = \"0 0\";\n\n\t\t\t// place pointers\n\t\t\tredrawPad();\n\t\t\tredrawSld();\n\n\t\t\tjscolor.picker.owner = THIS;\n\t\t\tdocument.getElementsByTagName('body')[0].appendChild(p.boxB);\n\t\t}\n\n\n\t\tfunction getPickerDims(o) {\n\t\t\tvar dims = [\n\t\t\t\t2*o.pickerInset + 2*o.pickerFace + jscolor.images.pad[0] +\n\t\t\t\t\t(o.slider ? 2*o.pickerInset + 2*jscolor.images.arrow[0] + jscolor.images.sld[0] : 0),\n\t\t\t\to.pickerClosable ?\n\t\t\t\t\t4*o.pickerInset + 3*o.pickerFace + jscolor.images.pad[1] + o.pickerButtonHeight :\n\t\t\t\t\t2*o.pickerInset + 2*o.pickerFace + jscolor.images.pad[1]\n\t\t\t];\n\t\t\treturn dims;\n\t\t}\n\n\n\t\tfunction redrawPad() {\n\t\t\t// redraw the pad pointer\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var yComponent = 1; break;\n\t\t\t\tcase 1: var yComponent = 2; break;\n\t\t\t}\n\t\t\tvar x = Math.round((THIS.hsv[0]/6) * (jscolor.images.pad[0]-1));\n\t\t\tvar y = Math.round((1-THIS.hsv[yComponent]) * (jscolor.images.pad[1]-1));\n\t\t\tjscolor.picker.padM.style.backgroundPosition =\n\t\t\t\t(THIS.pickerFace+THIS.pickerInset+x - Math.floor(jscolor.images.cross[0]/2)) + 'px ' +\n\t\t\t\t(THIS.pickerFace+THIS.pickerInset+y - Math.floor(jscolor.images.cross[1]/2)) + 'px';\n\n\t\t\t// redraw the slider image\n\t\t\tvar seg = jscolor.picker.sld.childNodes;\n\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0:\n\t\t\t\t\tvar rgb = HSV_RGB(THIS.hsv[0], THIS.hsv[1], 1);\n\t\t\t\t\tfor(var i=0; i<seg.length; i+=1) {\n\t\t\t\t\t\tseg[i].style.backgroundColor = 'rgb('+\n\t\t\t\t\t\t\t(rgb[0]*(1-i/seg.length)*100)+'%,'+\n\t\t\t\t\t\t\t(rgb[1]*(1-i/seg.length)*100)+'%,'+\n\t\t\t\t\t\t\t(rgb[2]*(1-i/seg.length)*100)+'%)';\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase 1:\n\t\t\t\t\tvar rgb, s, c = [ THIS.hsv[2], 0, 0 ];\n\t\t\t\t\tvar i = Math.floor(THIS.hsv[0]);\n\t\t\t\t\tvar f = i%2 ? THIS.hsv[0]-i : 1-(THIS.hsv[0]-i);\n\t\t\t\t\tswitch(i) {\n\t\t\t\t\t\tcase 6:\n\t\t\t\t\t\tcase 0: rgb=[0,1,2]; break;\n\t\t\t\t\t\tcase 1: rgb=[1,0,2]; break;\n\t\t\t\t\t\tcase 2: rgb=[2,0,1]; break;\n\t\t\t\t\t\tcase 3: rgb=[2,1,0]; break;\n\t\t\t\t\t\tcase 4: rgb=[1,2,0]; break;\n\t\t\t\t\t\tcase 5: rgb=[0,2,1]; break;\n\t\t\t\t\t}\n\t\t\t\t\tfor(var i=0; i<seg.length; i+=1) {\n\t\t\t\t\t\ts = 1 - 1/(seg.length-1)*i;\n\t\t\t\t\t\tc[1] = c[0] * (1 - s*f);\n\t\t\t\t\t\tc[2] = c[0] * (1 - s);\n\t\t\t\t\t\tseg[i].style.backgroundColor = 'rgb('+\n\t\t\t\t\t\t\t(c[rgb[0]]*100)+'%,'+\n\t\t\t\t\t\t\t(c[rgb[1]]*100)+'%,'+\n\t\t\t\t\t\t\t(c[rgb[2]]*100)+'%)';\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction redrawSld() {\n\t\t\t// redraw the slider pointer\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: var yComponent = 2; break;\n\t\t\t\tcase 1: var yComponent = 1; break;\n\t\t\t}\n\t\t\tvar y = Math.round((1-THIS.hsv[yComponent]) * (jscolor.images.sld[1]-1));\n\t\t\tjscolor.picker.sldM.style.backgroundPosition =\n\t\t\t\t'0 ' + (THIS.pickerFace+THIS.pickerInset+y - Math.floor(jscolor.images.arrow[1]/2)) + 'px';\n\t\t}\n\n\n\t\tfunction isPickerOwner() {\n\t\t\treturn jscolor.picker && jscolor.picker.owner === THIS;\n\t\t}\n\n\n\t\tfunction blurTarget() {\n\t\t\tif(valueElement === target) {\n\t\t\t\tTHIS.importColor();\n\t\t\t}\n\t\t\tif(THIS.pickerOnfocus) {\n\t\t\t\tTHIS.hidePicker();\n\t\t\t}\n\t\t}\n\n\n\t\tfunction blurValue() {\n\t\t\tif(valueElement !== target) {\n\t\t\t\tTHIS.importColor();\n\t\t\t}\n\t\t}\n\n\n\t\tfunction setPad(e) {\n\t\t\tvar mpos = jscolor.getRelMousePos(e);\n\t\t\tvar x = mpos.x - THIS.pickerFace - THIS.pickerInset;\n\t\t\tvar y = mpos.y - THIS.pickerFace - THIS.pickerInset;\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: THIS.fromHSV(x*(6/(jscolor.images.pad[0]-1)), 1 - y/(jscolor.images.pad[1]-1), null, leaveSld); break;\n\t\t\t\tcase 1: THIS.fromHSV(x*(6/(jscolor.images.pad[0]-1)), null, 1 - y/(jscolor.images.pad[1]-1), leaveSld); break;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction setSld(e) {\n\t\t\tvar mpos = jscolor.getRelMousePos(e);\n\t\t\tvar y = mpos.y - THIS.pickerFace - THIS.pickerInset;\n\t\t\tswitch(modeID) {\n\t\t\t\tcase 0: THIS.fromHSV(null, null, 1 - y/(jscolor.images.sld[1]-1), leavePad); break;\n\t\t\t\tcase 1: THIS.fromHSV(null, 1 - y/(jscolor.images.sld[1]-1), null, leavePad); break;\n\t\t\t}\n\t\t}\n\n\n\t\tfunction dispatchImmediateChange() {\n\t\t\tif (THIS.onImmediateChange) {\n\t\t\t\tvar callback;\n\t\t\t\tif (typeof THIS.onImmediateChange === 'string') {\n\t\t\t\t\tcallback = new Function (THIS.onImmediateChange);\n\t\t\t\t} else {\n\t\t\t\t\tcallback = THIS.onImmediateChange;\n\t\t\t\t}\n\t\t\t\tcallback.call(THIS);\n\t\t\t}\n\t\t}\n\n\n\t\tvar THIS = this;\n\t\tvar modeID = this.pickerMode.toLowerCase()==='hvs' ? 1 : 0;\n\t\tvar abortBlur = false;\n\t\tvar\n\t\t\tvalueElement = jscolor.fetchElement(this.valueElement),\n\t\t\tstyleElement = jscolor.fetchElement(this.styleElement);\n\t\tvar\n\t\t\tholdPad = false,\n\t\t\tholdSld = false,\n\t\t\ttouchOffset = {};\n\t\tvar\n\t\t\tleaveValue = 1<<0,\n\t\t\tleaveStyle = 1<<1,\n\t\t\tleavePad = 1<<2,\n\t\t\tleaveSld = 1<<3;\n\n\t\t// target\n\t\tjscolor.addEvent(target, 'focus', function() {\n\t\t\tif(THIS.pickerOnfocus) { THIS.showPicker(); }\n\t\t});\n\t\tjscolor.addEvent(target, 'blur', function() {\n\t\t\tif(!abortBlur) {\n\t\t\t\twindow.setTimeout(function(){ abortBlur || blurTarget(); abortBlur=false; }, 0);\n\t\t\t} else {\n\t\t\t\tabortBlur = false;\n\t\t\t}\n\t\t});\n\n\t\t// valueElement\n\t\tif(valueElement) {\n\t\t\tvar updateField = function() {\n\t\t\t\tTHIS.fromString(valueElement.value, leaveValue);\n\t\t\t\tdispatchImmediateChange();\n\t\t\t};\n\t\t\tjscolor.addEvent(valueElement, 'keyup', updateField);\n\t\t\tjscolor.addEvent(valueElement, 'input', updateField);\n\t\t\tjscolor.addEvent(valueElement, 'blur', blurValue);\n\t\t\tvalueElement.setAttribute('autocomplete', 'off');\n\t\t}\n\n\t\t// styleElement\n\t\tif(styleElement) {\n\t\t\tstyleElement.jscStyle = {\n\t\t\t\tbackgroundImage : styleElement.style.backgroundImage,\n\t\t\t\tbackgroundColor : styleElement.style.backgroundColor,\n\t\t\t\tcolor : styleElement.style.color\n\t\t\t};\n\t\t}\n\n\t\t// require images\n\t\tswitch(modeID) {\n\t\t\tcase 0: jscolor.requireImage('hs.png'); break;\n\t\t\tcase 1: jscolor.requireImage('hv.png'); break;\n\t\t}\n\t\tjscolor.requireImage('cross.gif');\n\t\tjscolor.requireImage('arrow.gif');\n\n\t\tthis.importColor();\n\t}\n\n};\n\n\njscolor.install();\n","Magento_Vault/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/* @api */\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            fieldset: '',\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this,\n                paymentSelector = '[name=\"payment[method]\"][value=\"' + this.getCode() + '\"]:checked';\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe(['active']);\n\n            if (self.$selector.find(paymentSelector).length !== 0) {\n                this.active(true);\n            }\n\n            $('#' + self.fieldset).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.rememberTokenSwitcher.bind(this));\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.getCode())\n                .on('changePaymentMethod.' + this.getCode(), this.changePaymentMethod.bind(this));\n\n            if (this.active()) {\n                this.chooseTokenSwitcher();\n            }\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.getCode());\n\n            return this;\n        },\n\n        /**\n         * Save last chosen token switcher\n         * @param {Object} event\n         * @returns {exports.rememberTokenSwitcher}\n         */\n        rememberTokenSwitcher: function (event) {\n            $('#' + this.selector).data('lastTokenSwitcherId', event.target.id);\n\n            return this;\n        },\n\n        /**\n         * Select token switcher\n         * @returns {exports.chooseTokenSwitcher}\n         */\n        chooseTokenSwitcher: function () {\n            var lastTokenSwitcherId = $('#' + this.selector).data('lastTokenSwitcherId');\n\n            if (lastTokenSwitcherId) {\n                $('#' + lastTokenSwitcherId).trigger('click');\n            } else {\n                $('#' + this.fieldset + ' input:radio:first').trigger('click');\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.trigger('setVaultNotActive.' + this.getCode());\n\n                return;\n            }\n            this.chooseTokenSwitcher();\n            window.order.addExcludedPaymentMethod(this.getCode());\n        },\n\n        /**\n         * Get payment method code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        }\n    });\n});\n","Magento_Integration/js/integration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jQuery plugin is added.\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.integration', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            /**\n             * URL of the integration grid.\n             * @type {String}\n             */\n            gridUrl: ''\n        },\n\n        /**\n         * Bind event handler for the action when admin clicks \"Save & Activate\" button.\n         * @private\n         */\n        _create: function () {\n            if ($('#save-split-button-activate').length) {\n                // We're on the \"New integration\" page - bind related handler\n                this._form = $('#edit_form');\n                this._form.on('saveAndActivate', $.proxy(this._saveAndActivate, this));\n            }\n        },\n\n        /**\n         * Save new integration, then kick off the activate dialog.\n         * @private\n         */\n        _saveAndActivate: function () {\n            if (this._form.validation && !this._form.validation('isValid')) {\n                return false;\n            }\n\n            $.ajax({\n                url: this._form.prop('action'),\n                type: 'post',\n                data: this._form.serialize(),\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (data) {\n                    var integrationName, that;\n\n                    if (data._redirect) {\n                        window.location.href = data._redirect;\n                    } else if (data.integrationId) {\n                        integrationName = $('#integration_properties_name').val();\n                        window.integration.popup.show($('<span>').attr({\n                            'data-row-dialog': 'permissions',\n                            'data-row-id': data.integrationId,\n                            // We do escaping here instead of the place of actual output because _showPopup()\n                            // actually receives dialog window title from couple of places: from here and from the grid.\n                            // The issue is we always should escape values in the grid, so that value is already\n                            // escaped. To avoid double escaping we do it here instead of the output.\n                            'data-row-name': $('<div>').text(integrationName).html(),\n                            'data-row-is-reauthorize': '0',\n                            'data-row-is-token-exchange': data.isTokenExchange\n                        }));\n                        that = this;\n                        $('#integration-popup-container').on('dialogclose', function () {\n                            $('body').trigger('processStart');\n                            window.location.href = that.options.gridUrl;\n\n                            return false;\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n\n            return true;\n        }\n    });\n\n    /**\n     * @param {*} permissionsDialogUrl\n     * @param {*} tokensDialogUrl\n     * @param {*} tokensExchangeUrl\n     * @param {*} gridUrl\n     * @param {*} successCallbackUrl\n     * @return {Object}\n     * @constructor\n     */\n    window.Integration = function (\n        permissionsDialogUrl,\n        tokensDialogUrl,\n        tokensExchangeUrl,\n        gridUrl,\n        successCallbackUrl\n    ) {\n        var url = {\n            permissions: permissionsDialogUrl,\n            tokens: tokensDialogUrl,\n            tokensExchange: tokensExchangeUrl,\n            grid: gridUrl\n        },\n        IdentityLogin = {\n            win: null,\n            strLocation: null,\n            checker: null,\n            isCalledBack: false,\n            //Info popup dialog. Should be hidden when login window is closed\n            jqInfoDialog: $('#integration-popup-container'),\n            successCallbackUrl: successCallbackUrl,\n            Constants: {\n                /*\n                 This interval is set such that it adjusts to the child window closing timeout of 1000 ms. This will\n                 give the checker function enough time to detect if the successCallback has been invoked\n                 */\n                CHECKER_INTERVAL: 500,\n                //Login screen size plus some buffer\n                WIDTH: 680,\n                HEIGHT: 510,\n                // subtract pixels(30) and width(680) from screen width to move popup from extreme left\n                LEFT: screen.width - 680 - 30,\n                // subtract pixels(300) and height(300) from screen height to move from top\n                TOP: screen.height - 510 - 300\n            },\n\n            /**\n             * @param {*} identityCallbackUrl\n             * @param {*} consumerKey\n             * @param {*} jqInfoDialog\n             */\n            invokePopup: function (identityCallbackUrl, consumerKey, jqInfoDialog) {\n                var param;\n\n                // Callback should be invoked only once. Reset callback flag on subsequent invocations.\n                IdentityLogin.isCalledBack = false;\n                IdentityLogin.jqInfoDialog = jqInfoDialog;\n                param = $.param({\n                    'oauth_consumer_key': consumerKey,\n                    'success_call_back': IdentityLogin.successCallbackUrl\n                });\n                IdentityLogin.win = window.open(identityCallbackUrl + '?' + param, '',\n                    'top=' + IdentityLogin.Constants.TOP +\n                        ', left=' + IdentityLogin.Constants.LEFT +\n                        ', width=' + IdentityLogin.Constants.WIDTH +\n                        ', height=' + IdentityLogin.Constants.HEIGHT + ',scrollbars=no');\n\n                if (IdentityLogin.checker != null) {\n                    //Clear any previous check\n                    clearInterval(IdentityLogin.checker);\n                }\n                //Polling to detect url of the child window.\n                IdentityLogin.checker = setInterval(\n                    IdentityLogin.fnCheckLocation, IdentityLogin.Constants.CHECKER_INTERVAL\n                );\n            },\n\n            /**\n             * Function to check the location of the child popup window.\n             * Once detected if the callback is successful, parent window will be reloaded\n             */\n            fnCheckLocation: function () {\n                if (IdentityLogin.win == null) {\n                    return;\n                }\n                // Check to see if the location has changed.\n                try {\n                    //Is the success callback invoked\n                    if (IdentityLogin.win.closed ||\n                        IdentityLogin.win.location.href == IdentityLogin.successCallbackUrl //eslint-disable-line eqeqeq\n                    ) {\n                        //Stop the polling\n                        clearInterval(IdentityLogin.checker);\n                        $('body').trigger('processStart');\n                        //Check for window closed\n                        window.location.href = url.grid;\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                    }\n                } catch (e) {\n                    //squash. In case Window closed without success callback, clear polling\n                    if (IdentityLogin.win.closed) {\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                        clearInterval(IdentityLogin.checker);\n                    }\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         * @param {Object} popupWindow\n         * @return {Boolean}\n         */\n        isPopupBlocked = function (popupWindow) {\n            try {\n                popupWindow.focus();\n            } catch (e) {\n                alert({\n                    content: $.mage.__('Popup Blocker is enabled! Please add this site to your exception list.')\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} dialog\n         * @param {*} title\n         * @param {*} okButton\n         * @param {*} ajaxUrl\n         * @private\n         */\n        _showPopup = function (dialog, title, okButton, ajaxUrl) {\n            $.ajax({\n                url: ajaxUrl,\n                cache: false,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                method: 'GET',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    // Show the spinner\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (result) {\n                    var redirect = result._redirect,\n                        identityLinkUrl, consumerKey, popupHtml, popup, resultObj, buttons, dialogProperties;\n\n                    if (redirect) {\n                        window.location.href = redirect;\n\n                        return;\n                    }\n\n                    identityLinkUrl = null;\n                    consumerKey = null;\n                    popupHtml = null;\n                    popup = $('#integration-popup-container');\n\n                    try {\n                        resultObj = typeof result === 'string' ?\n                            JSON.parse(result) :\n                            result;\n\n                        identityLinkUrl = resultObj['identity_link_url'];\n                        consumerKey      = resultObj['oauth_consumer_key'];\n                        popupHtml       = resultObj['popup_content'];\n\n                    } catch (e) {\n                        //This is expected if result is not json. Do nothing.\n                    }\n\n                    if (identityLinkUrl && consumerKey && popupHtml) {\n                        IdentityLogin.invokePopup(identityLinkUrl, consumerKey, popup);\n\n                        if (isPopupBlocked(IdentityLogin.win)) {\n                            return;\n                        }\n                    } else {\n                        popupHtml = result;\n                    }\n\n                    if (popup.length === 0) {\n                        popup = $('<div></div>');\n                    }\n                    popup.html(popupHtml);\n\n                    buttons = [];\n                    dialogProperties = {\n                        title: title,\n                        type: 'slide',\n                        dialogClass: dialog == 'permissions' ? 'integration-dialog' : 'integration-dialog no-close' //eslint-disable-line\n                    };\n\n                    // Add confirmation button to the list of dialog buttons. okButton not set for tokenExchange dialog\n                    if (okButton) {\n                        buttons.push(okButton);\n                    }\n                    // Add button only if its not empty\n                    if (buttons.length > 0) {\n                        dialogProperties.buttons = buttons;\n                    }\n                    popup.modal(dialogProperties);\n                    popup.modal('openModal');\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    // Hide the spinner\n                    $('body').trigger('processStop');\n                }\n            });\n        };\n\n        return {\n            popup: {\n                /**\n                 * @param {*} ctx\n                 */\n                show: function (ctx) {\n                    var dialog = $(ctx).attr('data-row-dialog'),\n                        isReauthorize = $(ctx).attr('data-row-is-reauthorize'),\n                        isTokenExchange = $(ctx).attr('data-row-is-token-exchange'),\n                        integrationId, ajaxUrl, integrationName, okButton;\n\n                    if (!url.hasOwnProperty(dialog)) {\n                        throw 'Invalid dialog type';\n                    }\n\n                    integrationId = $(ctx).attr('data-row-id');\n\n                    if (!integrationId) {\n                        throw 'Unable to find integration ID';\n                    }\n\n                    // Replace placeholders in URL\n                    ajaxUrl = url[dialog].replace(':id', integrationId).replace(':isReauthorize', isReauthorize);\n\n                    try {\n                        // Get integration name either from current element or from neighbor column\n                        integrationName = $(ctx).attr('data-row-name') ||\n                            $(ctx).parents('tr').find('.col-name').html().trim(); // eslint-disable-line jquery-no-trim\n\n                        if (integrationName.indexOf('<span') > -1) {\n                            // Remove unsecure URL warning from popup window title if it is present\n                            integrationName = integrationName.substring(0, integrationName.indexOf('<span'));\n                        }\n                    } catch (e) {\n                        throw 'Unable to find integration name';\n                    }\n\n                    okButton = {\n                        permissions: {\n                            text: isReauthorize == '1' ? $.mage.__('Reauthorize') : $.mage.__('Allow'), //eslint-disable-line\n                            'class': 'action-primary',\n                            attr: {\n                                'data-row-id': integrationId,\n                                'data-row-name': integrationName,\n                                'data-row-dialog': isTokenExchange == '1' ? 'tokensExchange' : 'tokens', //eslint-disable-line\n                                'data-row-is-reauthorize': isReauthorize,\n                                'data-row-is-token-exchange': isTokenExchange\n                            },\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Find the 'Allow' button and clone - it has all necessary data, but is going to be\n                                // destroyed along with the current dialog\n                                var context = this.modal.find('button.action-primary').clone(true);\n\n                                this.closeModal();\n                                this.modal.remove();\n                                // Make popup out of data we saved from 'Allow' button\n                                window.integration.popup.show(context);\n                            }\n                        },\n                        tokens: {\n                            text: $.mage.__('Done'),\n                            'class': 'action-primary',\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Integration has been activated at the point of generating tokens\n                                window.location.href = url.grid;\n                            }\n                        }\n                    };\n\n                    _showPopup(dialog, integrationName, okButton[dialog], ajaxUrl);\n                }\n            }\n        };\n    };\n\n    return $.mage.integration;\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            var value;\n\n            name = name.split('/').join('][');\n            value = $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n            if (value === undefined) {\n                value = this.source.get('data.product.' + name);\n            }\n            return value;\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            newOption.label = newOption.label.trim();\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }',\n                matrixGridComponent: '${ $.matrixGridComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [],\n                matrixGridData = this.matrixGridComponent() ?\n                    _.indexBy(this.matrixGridComponent().getUnionInsertData(), 'variationKey') : {};\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    variationsKey = this.variationsComponent().getVariationKey(options),\n                    productDataFromGrid = matrixGridData[variationsKey] || {},\n                    productDataFromWizard = {},\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (quantity) {\n                    productDataFromWizard[this.quantityFieldName] = quantity;\n                }\n                price = getSectionValue('price', options);\n\n                if (price) {\n                    productDataFromWizard.price = price;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                productDataFromGrid = _.pick(\n                    productDataFromGrid,\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    'qty'\n                );\n\n                if (productDataFromGrid.hasOwnProperty('qty')) {\n                    productDataFromGrid[this.quantityFieldName] = productDataFromGrid.qty;\n                }\n                delete productDataFromGrid.qty;\n                product = _.pick(\n                    product || {},\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    this.quantityFieldName\n                );\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: productPrice,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n                variation = _.extend(variation, product, productDataFromGrid, productDataFromWizard);\n\n                if (productId) {\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(variationsKey);\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/file-uploader',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n                case 'each':\n                    return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                        return _.find(options, function (option) {\n                            return chosen.id == option.id; //eslint-disable-line eqeqeq\n                        });\n                    }).sections()[section];\n\n                case 'single':\n                    return this.sections()[section].value();\n\n                case 'none':\n                    return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData'),\n                        positionElement;\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    positionElement =\n                        $(image).find('[name=\"product[media_gallery][images][' + imageData.file_id + '][position]\"]');\n                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    if (!_.isEmpty(positionElement.val())) {\n                        imageData.position = positionElement.val();\n                    }\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    if (this.sections().images.attribute()) {\n                        this.sections().images.attribute().chosen.each(function (option) {\n                            option.sections().images = new this.makeImages(\n                                this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                                'thumbnail'\n                            );\n                        }, this);\n                    }\n                    break;\n\n                case 'single':\n                    this.sections().images.value(new this.makeImages(\n                        this.getImageProperty($('[data-role=step-gallery-single]')),\n                        'thumbnail'\n                    ));\n                    break;\n\n                default:\n                    this.sections().images.value(new this.makeImages());\n                    break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                    case 'each':\n                        if (!section.attribute()) {\n                            throw new Error($.mage.__('Please select attribute for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n\n                    case 'single':\n                        if (!section.value()) {\n                            throw new Error($.mage.__('Please fill in the values for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    _.each(this.sections().images.attribute().chosen, function (option) {\n                        if (!option.sections().images.images.length) {\n                            throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                        }\n                    });\n                    break;\n\n                case 'single':\n                    if (this.sections().images.value().file == null) {\n                        throw new Error($.mage.__('Please choose image(s).'));\n                    }\n                    break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('[name=image]')),\n                    dropZone = $(gallery).find('.image-placeholder');\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    uploadInput.fileupload({\n                        dataType: 'json',\n                        dropZone: dropZone,\n                        process: [{\n                            action: 'load',\n                            fileTypes: /^image\\/(gif|jpeg|png)$/\n                        }, {\n                            action: 'resize',\n                            maxWidth: 1920,\n                            maxHeight: 1200\n                        }, {\n                            action: 'save'\n                        }],\n                        formData: {\n                            'form_key': FORM_KEY\n                        },\n                        sequentialUploads: true,\n                        acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        add: function (e, data) {\n                            var progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            $.each(data.files, function (i, file) {\n                                fileSize = typeof file.size == 'undefined' ?\n                                    $.mage.__('We could not detect a size.') :\n                                    byteConvert(file.size);\n\n                                data.fileId = Math.random().toString(33).substr(2, 18);\n\n                                tmpl = progressTmpl({\n                                    data: {\n                                        name: file.name,\n                                        size: fileSize,\n                                        id: data.fileId\n                                    }\n                                });\n\n                                $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            });\n\n                            $(this).fileupload('process', data).done(function () {\n                                data.submit();\n                            });\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        done: function (e, data) {\n                            if (data.result && !data.result.error) {\n                                gallery.trigger('addItem', data.result);\n                            } else {\n                                $('#' + data.fileId)\n                                    .delay(2000)\n                                    .hide('highlight');\n                                alert({\n                                    content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                                });\n                            }\n                            $('#' + data.fileId).remove();\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        progress: function (e, data) {\n                            var progress = parseInt(data.loaded / data.total * 100, 10),\n                                progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                            $(progressSelector).css('width', progress + '%');\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        fail: function (e, data) {\n                            var progressSelector = '#' + data.fileId;\n\n                            $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                                .delay(2000)\n                                .hide('highlight')\n                                .remove();\n                        }\n                    });\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + parseInt(this.pageSize, 10));\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = tmpData.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                tmpData.each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            return this;\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': row.name,\n                'sku': row.sku,\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n            this.required(!!this.isUseDefault() || !isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/qty-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handleQtyValue(this.isConfigurable);\n\n            /** important to set this listener in initialize because of a different order of processing.\n             * Do not move to defaults->listens section */\n            this.setListeners({\n                isConfigurable: 'handleQtyValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Disable and clear Qty if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handleQtyValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document is no longer loading, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState !== \"loading\") {\n            // Handle it asynchronously to allow scripts the opportunity to delay ready\n            setTimeout(pageLoaded);\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, this.disabled() || false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: '',\n            disableParent: false,\n            listens: {\n                disabled: 'processState',\n                checked: 'processState onCheckedChanged'\n            },\n            imports: {\n                readOnly: 'ns = ${ $.ns }, index = stock_data:disabled'\n            }\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue', 'disableParent']);\n        },\n\n        /**\n         * Handle checked and disabled changes to calculate disableParent value\n         */\n        processState: function () {\n            this.disableParent(this.checked() || this.readOnly);\n\n            if (this.readOnly) {\n                this.disable();\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryBundleProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryBundleProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Sm_MegaMenu/js/jquery.nestable.js":"/**\n * Copyright \u00a9 2015 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine( [ \"jquery\" ], function ( $ ) {\n(function($, window, document, undefined)\n{\n\n\tvar hasTouch = 'ontouchstart' in document;\n\n\t/**\n\t * Detect CSS pointer-events property\n\t * events are normally disabled on the dragging element to avoid conflicts\n\t * https://github.com/ausi/Feature-detection-technique-for-pointer-events/blob/master/modernizr-pointerevents.js\n\t */\n\tvar hasPointerEvents = (function () {\n\t\tvar el = document.createElement('div'),\n\t\t\tdocEl = document.documentElement;\n\t\tif (!('pointerEvents' in el.style)) {\n\t\t\treturn false;\n\t\t}\n\t\tel.style.pointerEvents = 'auto';\n\t\tel.style.pointerEvents = 'x';\n\t\tdocEl.appendChild(el);\n\t\tvar supports = window.getComputedStyle && window.getComputedStyle(el, '').pointerEvents === 'auto';\n\t\tdocEl.removeChild(el);\n\t\treturn !!supports;\n\t})();\n\n\tvar defaults = {\n\t\tlistNodeName: 'ol',\n\t\titemNodeName: 'li',\n\t\trootClass: 'dd',\n\t\tlistClass: 'dd-list',\n\t\titemClass: 'dd-item',\n\t\tdragClass: 'dd-dragel',\n\t\thandleClass: 'dd-handle',\n\t\tcollapsedClass: 'dd-collapsed',\n\t\tplaceClass: 'dd-placeholder',\n\t\tnoDragClass: 'dd-nodrag',\n\t\temptyClass: 'dd-empty',\n\t\texpandBtnHTML: '<button data-action=\"expand\" type=\"button\">Expand</button>',\n\t\tcollapseBtnHTML: '<button data-action=\"collapse\" type=\"button\">Collapse</button>',\n\t\tgroup: 0,\n\t\tmaxDepth: 5,\n\t\tthreshold: 20\n\t};\n\n\tfunction Plugin(element, options) {\n\t\tthis.w = $(document);\n\t\tthis.el = $(element);\n\t\tthis.options = $.extend({}, defaults, options);\n\t\tthis.init();\n\t}\n\n\tPlugin.prototype = {\n\n\t\tinit: function () {\n\t\t\tvar list = this;\n\n\t\t\tlist.reset();\n\n\t\t\tlist.el.data('nestable-group', this.options.group);\n\n\t\t\tlist.placeEl = $('<div class=\"' + list.options.placeClass + '\"/>');\n\n\t\t\t$.each(this.el.find(list.options.itemNodeName), function (k, el) {\n\t\t\t\tlist.setParent($(el));\n\t\t\t});\n\n\t\t\tlist.el.on('click', 'button', function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar target = $(e.currentTarget),\n\t\t\t\t\taction = target.data('action'),\n\t\t\t\t\titem = target.parent(list.options.itemNodeName);\n\t\t\t\tif (action === 'collapse') {\n\t\t\t\t\tlist.collapseItem(item);\n\t\t\t\t}\n\t\t\t\tif (action === 'expand') {\n\t\t\t\t\tlist.expandItem(item);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tvar onStartEvent = function (e) {\n\t\t\t\tvar handle = $(e.target);\n\t\t\t\tif (!handle.hasClass(list.options.handleClass)) {\n\t\t\t\t\tif (handle.closest('.' + list.options.noDragClass).length) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\thandle = handle.closest('.' + list.options.handleClass);\n\t\t\t\t}\n\n\t\t\t\tif (!handle.length || list.dragEl) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tlist.isTouch = /^touch/.test(e.type);\n\t\t\t\tif (list.isTouch && e.touches.length !== 1) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\te.preventDefault();\n\t\t\t\tlist.dragStart(e.touches ? e.touches[0] : e);\n\t\t\t};\n\n\t\t\tvar onMoveEvent = function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\tlist.dragMove(e.touches ? e.touches[0] : e);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tvar onEndEvent = function (e) {\n\t\t\t\tif (list.dragEl) {\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\tlist.dragStop(e.touches ? e.touches[0] : e);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (hasTouch) {\n\t\t\t\tlist.el[0].addEventListener('touchstart', onStartEvent, false);\n\t\t\t\twindow.addEventListener('touchmove', onMoveEvent, false);\n\t\t\t\twindow.addEventListener('touchend', onEndEvent, false);\n\t\t\t\twindow.addEventListener('touchcancel', onEndEvent, false);\n\t\t\t}\n\n\t\t\tlist.el.on('mousedown', onStartEvent);\n\t\t\tlist.w.on('mousemove', onMoveEvent);\n\t\t\tlist.w.on('mouseup', onEndEvent);\n\n\t\t},\n\n\t\tserialize: function () {\n\t\t\tvar data,\n\t\t\t\tdepth = 0,\n\t\t\t\tlist = this;\n\t\t\tstep = function (level, depth) {\n\t\t\t\tvar array = [],\n\t\t\t\t\titems = level.children(list.options.itemNodeName);\n\t\t\t\titems.each(function () {\n\t\t\t\t\tvar li = $(this),\n\t\t\t\t\t\titem = $.extend({}, li.data()),\n\t\t\t\t\t\tsub = li.children(list.options.listNodeName);\n\t\t\t\t\tif (sub.length) {\n\t\t\t\t\t\titem.children = step(sub, depth + 1);\n\t\t\t\t\t}\n\t\t\t\t\tarray.push(item);\n\t\t\t\t});\n\t\t\t\treturn array;\n\t\t\t};\n\t\t\tdata = step(list.el.find(list.options.listNodeName).first(), depth);\n\t\t\treturn data;\n\t\t},\n\n\t\tserialise: function () {\n\t\t\treturn this.serialize();\n\t\t},\n\n\t\treset: function () {\n\t\t\tthis.mouse = {\n\t\t\t\toffsetX: 0,\n\t\t\t\toffsetY: 0,\n\t\t\t\tstartX: 0,\n\t\t\t\tstartY: 0,\n\t\t\t\tlastX: 0,\n\t\t\t\tlastY: 0,\n\t\t\t\tnowX: 0,\n\t\t\t\tnowY: 0,\n\t\t\t\tdistX: 0,\n\t\t\t\tdistY: 0,\n\t\t\t\tdirAx: 0,\n\t\t\t\tdirX: 0,\n\t\t\t\tdirY: 0,\n\t\t\t\tlastDirX: 0,\n\t\t\t\tlastDirY: 0,\n\t\t\t\tdistAxX: 0,\n\t\t\t\tdistAxY: 0\n\t\t\t};\n\t\t\tthis.isTouch = false;\n\t\t\tthis.moving = false;\n\t\t\tthis.dragEl = null;\n\t\t\tthis.dragRootEl = null;\n\t\t\tthis.dragDepth = 0;\n\t\t\tthis.hasNewRoot = false;\n\t\t\tthis.pointEl = null;\n\t\t},\n\n\t\texpandItem: function (li) {\n\t\t\tli.removeClass(this.options.collapsedClass);\n\t\t\tli.children('[data-action=\"expand\"]').hide();\n\t\t\tli.children('[data-action=\"collapse\"]').show();\n\t\t\tli.children(this.options.listNodeName).show();\n\t\t},\n\n\t\tcollapseItem: function (li) {\n\t\t\tvar lists = li.children(this.options.listNodeName);\n\t\t\tif (lists.length) {\n\t\t\t\tli.addClass(this.options.collapsedClass);\n\t\t\t\tli.children('[data-action=\"collapse\"]').hide();\n\t\t\t\tli.children('[data-action=\"expand\"]').show();\n\t\t\t\tli.children(this.options.listNodeName).hide();\n\t\t\t}\n\t\t},\n\n\t\texpandAll: function () {\n\t\t\tvar list = this;\n\t\t\tlist.el.find(list.options.itemNodeName).each(function () {\n\t\t\t\tlist.expandItem($(this));\n\t\t\t});\n\t\t},\n\n\t\tcollapseAll: function () {\n\t\t\tvar list = this;\n\t\t\tlist.el.find(list.options.itemNodeName).each(function () {\n\t\t\t\tlist.collapseItem($(this));\n\t\t\t});\n\t\t},\n\n\t\tsetParent: function (li) {\n\t\t\tif (li.children(this.options.listNodeName).length) {\n\t\t\t\tli.prepend($(this.options.expandBtnHTML));\n\t\t\t\tli.prepend($(this.options.collapseBtnHTML));\n\t\t\t}\n\t\t\tli.children('[data-action=\"expand\"]').hide();\n\t\t},\n\n\t\tunsetParent: function (li) {\n\t\t\tli.removeClass(this.options.collapsedClass);\n\t\t\tli.children('[data-action]').remove();\n\t\t\tli.children(this.options.listNodeName).remove();\n\t\t},\n\n\t\tdragStart: function (e) {\n\t\t\tvar mouse = this.mouse,\n\t\t\t\ttarget = $(e.target),\n\t\t\t\tdragItem = target.closest(this.options.itemNodeName);\n\n\t\t\tthis.placeEl.css('height', dragItem.height());\n\n\t\t\tmouse.offsetX = e.offsetX !== undefined ? e.offsetX : e.pageX - target.offset().left;\n\t\t\tmouse.offsetY = e.offsetY !== undefined ? e.offsetY : e.pageY - target.offset().top;\n\t\t\tmouse.startX = mouse.lastX = e.pageX;\n\t\t\tmouse.startY = mouse.lastY = e.pageY;\n\n\t\t\tthis.dragRootEl = this.el;\n\n\t\t\tthis.dragEl = $(document.createElement(this.options.listNodeName)).addClass(this.options.listClass + ' ' + this.options.dragClass);\n\t\t\tthis.dragEl.css('width', dragItem.width());\n\n\t\t\tdragItem.after(this.placeEl);\n\t\t\tdragItem[0].parentNode.removeChild(dragItem[0]);\n\t\t\tdragItem.appendTo(this.dragEl);\n\n\t\t\t$(document.body).append(this.dragEl);\n\t\t\tthis.dragEl.css({\n\t\t\t\t'left': e.pageX - mouse.offsetX,\n\t\t\t\t'top': e.pageY - mouse.offsetY\n\t\t\t});\n\t\t\t// total depth of dragging item\n\t\t\tvar i, depth,\n\t\t\t\titems = this.dragEl.find(this.options.itemNodeName);\n\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\tdepth = $(items[i]).parents(this.options.listNodeName).length;\n\t\t\t\tif (depth > this.dragDepth) {\n\t\t\t\t\tthis.dragDepth = depth;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tdragStop: function (e) {\n\t\t\tvar el = this.dragEl.children(this.options.itemNodeName).first();\n\t\t\tel[0].parentNode.removeChild(el[0]);\n\t\t\tthis.placeEl.replaceWith(el);\n\n\t\t\tthis.dragEl.remove();\n\t\t\tthis.el.trigger('change');\n\t\t\tif (this.hasNewRoot) {\n\t\t\t\tthis.dragRootEl.trigger('change');\n\t\t\t}\n\t\t\tthis.reset();\n\t\t},\n\n\t\tdragMove: function (e) {\n\t\t\tvar list, parent, prev, next, depth,\n\t\t\t\topt = this.options,\n\t\t\t\tmouse = this.mouse;\n\n\t\t\tthis.dragEl.css({\n\t\t\t\t'left': e.pageX - mouse.offsetX,\n\t\t\t\t'top': e.pageY - mouse.offsetY\n\t\t\t});\n\n\t\t\t// mouse position last events\n\t\t\tmouse.lastX = mouse.nowX;\n\t\t\tmouse.lastY = mouse.nowY;\n\t\t\t// mouse position this events\n\t\t\tmouse.nowX = e.pageX;\n\t\t\tmouse.nowY = e.pageY;\n\t\t\t// distance mouse moved between events\n\t\t\tmouse.distX = mouse.nowX - mouse.lastX;\n\t\t\tmouse.distY = mouse.nowY - mouse.lastY;\n\t\t\t// direction mouse was moving\n\t\t\tmouse.lastDirX = mouse.dirX;\n\t\t\tmouse.lastDirY = mouse.dirY;\n\t\t\t// direction mouse is now moving (on both axis)\n\t\t\tmouse.dirX = mouse.distX === 0 ? 0 : mouse.distX > 0 ? 1 : -1;\n\t\t\tmouse.dirY = mouse.distY === 0 ? 0 : mouse.distY > 0 ? 1 : -1;\n\t\t\t// axis mouse is now moving on\n\t\t\tvar newAx = Math.abs(mouse.distX) > Math.abs(mouse.distY) ? 1 : 0;\n\n\t\t\t// do nothing on first move\n\t\t\tif (!mouse.moving) {\n\t\t\t\tmouse.dirAx = newAx;\n\t\t\t\tmouse.moving = true;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// calc distance moved on this axis (and direction)\n\t\t\tif (mouse.dirAx !== newAx) {\n\t\t\t\tmouse.distAxX = 0;\n\t\t\t\tmouse.distAxY = 0;\n\t\t\t} else {\n\t\t\t\tmouse.distAxX += Math.abs(mouse.distX);\n\t\t\t\tif (mouse.dirX !== 0 && mouse.dirX !== mouse.lastDirX) {\n\t\t\t\t\tmouse.distAxX = 0;\n\t\t\t\t}\n\t\t\t\tmouse.distAxY += Math.abs(mouse.distY);\n\t\t\t\tif (mouse.dirY !== 0 && mouse.dirY !== mouse.lastDirY) {\n\t\t\t\t\tmouse.distAxY = 0;\n\t\t\t\t}\n\t\t\t}\n\t\t\tmouse.dirAx = newAx;\n\n\t\t\t/**\n\t\t\t * move horizontal\n\t\t\t */\n\t\t\tif (mouse.dirAx && mouse.distAxX >= opt.threshold) {\n\t\t\t\t// reset move distance on x-axis for new phase\n\t\t\t\tmouse.distAxX = 0;\n\t\t\t\tprev = this.placeEl.prev(opt.itemNodeName);\n\t\t\t\t// increase horizontal level if previous sibling exists and is not collapsed\n\t\t\t\tif (mouse.distX > 0 && prev.length && !prev.hasClass(opt.collapsedClass)) {\n\t\t\t\t\t// cannot increase level when item above is collapsed\n\t\t\t\t\tlist = prev.find(opt.listNodeName).last();\n\t\t\t\t\t// check if depth limit has reached\n\t\t\t\t\tdepth = this.placeEl.parents(opt.listNodeName).length;\n\t\t\t\t\tif (depth + this.dragDepth <= opt.maxDepth) {\n\t\t\t\t\t\t// create new sub-level if one doesn't exist\n\t\t\t\t\t\tif (!list.length) {\n\t\t\t\t\t\t\tlist = $('<' + opt.listNodeName + '/>').addClass(opt.listClass);\n\t\t\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\t\t\tprev.append(list);\n\t\t\t\t\t\t\tthis.setParent(prev);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// else append to next level up\n\t\t\t\t\t\t\tlist = prev.children(opt.listNodeName).last();\n\t\t\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// decrease horizontal level\n\t\t\t\tif (mouse.distX < 0) {\n\t\t\t\t\t// we can't decrease a level if an item preceeds the current one\n\t\t\t\t\tnext = this.placeEl.next(opt.itemNodeName);\n\t\t\t\t\tif (!next.length) {\n\t\t\t\t\t\tparent = this.placeEl.parent();\n\t\t\t\t\t\tthis.placeEl.closest(opt.itemNodeName).after(this.placeEl);\n\t\t\t\t\t\tif (!parent.children().length) {\n\t\t\t\t\t\t\tthis.unsetParent(parent.parent());\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar isEmpty = false;\n\n\t\t\t// find list item under cursor\n\t\t\tif (!hasPointerEvents) {\n\t\t\t\tthis.dragEl[0].style.visibility = 'hidden';\n\t\t\t}\n\t\t\tthis.pointEl = $(document.elementFromPoint(e.pageX - document.body.scrollLeft, e.pageY - (window.pageYOffset || document.documentElement.scrollTop)));\n\t\t\tif (!hasPointerEvents) {\n\t\t\t\tthis.dragEl[0].style.visibility = 'visible';\n\t\t\t}\n\t\t\tif (this.pointEl.hasClass(opt.handleClass)) {\n\t\t\t\tthis.pointEl = this.pointEl.parent(opt.itemNodeName);\n\t\t\t}\n\t\t\tif (this.pointEl.hasClass(opt.emptyClass)) {\n\t\t\t\tisEmpty = true;\n\t\t\t}\n\t\t\telse if (!this.pointEl.length || !this.pointEl.hasClass(opt.itemClass)) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// find parent list of item under cursor\n\t\t\tvar pointElRoot = this.pointEl.closest('.' + opt.rootClass),\n\t\t\t\tisNewRoot = this.dragRootEl.data('nestable-id') !== pointElRoot.data('nestable-id');\n\n\t\t\t/**\n\t\t\t * move vertical\n\t\t\t */\n\t\t\tif (!mouse.dirAx || isNewRoot || isEmpty) {\n\t\t\t\t// check if groups match if dragging over new root\n\t\t\t\tif (isNewRoot && opt.group !== pointElRoot.data('nestable-group')) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t// check depth limit\n\t\t\t\tdepth = this.dragDepth - 1 + this.pointEl.parents(opt.listNodeName).length;\n\t\t\t\tif (depth > opt.maxDepth) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar before = e.pageY < (this.pointEl.offset().top + this.pointEl.height() / 2);\n\t\t\t\tparent = this.placeEl.parent();\n\t\t\t\t// if empty create new list to replace empty placeholder\n\t\t\t\tif (isEmpty) {\n\t\t\t\t\tlist = $(document.createElement(opt.listNodeName)).addClass(opt.listClass);\n\t\t\t\t\tlist.append(this.placeEl);\n\t\t\t\t\tthis.pointEl.replaceWith(list);\n\t\t\t\t}\n\t\t\t\telse if (before) {\n\t\t\t\t\tthis.pointEl.before(this.placeEl);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.pointEl.after(this.placeEl);\n\t\t\t\t}\n\t\t\t\tif (!parent.children().length) {\n\t\t\t\t\tthis.unsetParent(parent.parent());\n\t\t\t\t}\n\t\t\t\tif (!this.dragRootEl.find(opt.itemNodeName).length) {\n\t\t\t\t\tthis.dragRootEl.append('<div class=\"' + opt.emptyClass + '\"/>');\n\t\t\t\t}\n\t\t\t\t// parent root list has changed\n\t\t\t\tif (isNewRoot) {\n\t\t\t\t\tthis.dragRootEl = pointElRoot;\n\t\t\t\t\tthis.hasNewRoot = this.el[0] !== this.dragRootEl[0];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t};\n\n\t$.fn.nestable = function (params) {\n\t\tvar lists = this,\n\t\t\tretval = this;\n\n\t\tlists.each(function () {\n\t\t\tvar plugin = $(this).data(\"nestable\");\n\n\t\t\tif (!plugin) {\n\t\t\t\t$(this).data(\"nestable\", new Plugin(this, params));\n\t\t\t\t$(this).data(\"nestable-id\", new Date().getTime());\n\t\t\t} else {\n\t\t\t\tif (typeof params === 'string' && typeof plugin[params] === 'function') {\n\t\t\t\t\tretval = plugin[params]();\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\treturn retval || lists;\n\t};\n\n}(window.jQuery || window.Zepto, window, document));\n });","Magento_Weee/js/regions-tax-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            filterBy: {\n                field: 'country',\n                target: '${ $.parentName }.country:value'\n            }\n        },\n\n        /** @inheritdoc */\n        filter: function () {\n            this._super();\n            this.disableSelect();\n        },\n\n        /**\n         * Disables select if there's no regions/states\n         *\n         * @returns {*} instance - Chainable\n         */\n        disableSelect: function () {\n            var empty = !this.options().length;\n\n            this.disabled(empty);\n\n            if (empty) {\n                this.error('');\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/fpt-attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global RegionUpdater */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/adminhtml/form'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.fptAttribute', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this;\n\n            this.rowTmpl = mageTemplate(this.element.find('[data-role=\"row-template\"]').html());\n\n            this._initOptionItem();\n\n            if ($(this.options.bundlePriceType).val() === '0') {\n                this.element.hide();\n            }\n\n            $.each(this.options.itemsData, function () {\n                widget.addItem(this);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initOptionItem: function () {\n            var widget = this,\n                isOriginalRequired = $(widget.element).hasClass('required');\n\n            this._on({\n                /**\n                 * Add new tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=add-fpt-item]': function (event) {\n                    this.addItem(event);\n                },\n\n                /**\n                 * Delete tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=delete-fpt-item]': function (event) {\n                    var parent = $(event.target).closest('[data-role=\"fpt-item-row\"]');\n\n                    parent.find('[data-role=\"delete-fpt-item\"]').val(1);\n                    parent.addClass('ignore-validate').hide();\n                },\n\n                /**\n                 * Change tax item country/state.\n                 *\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                'change [data-role=\"select-country\"]': function (event, data) {\n                    var currentElement = event.target || event.srcElement || event.currentTarget,\n                        parentElement = $(currentElement).closest('[data-role=\"fpt-item-row\"]'),\n                        updater;\n\n                    data = data || {};\n                    updater = new RegionUpdater(\n                        parentElement.find('[data-role=\"select-country\"]').attr('id'), null,\n                        parentElement.find('[data-role=\"select-state\"]').attr('id'),\n                        widget.options.region, 'disable', true\n                    );\n                    updater.update();\n                    //set selected state value if set\n                    if (data.state) {\n                        parentElement.find('[data-role=\"select-state\"]').val(data.state);\n                    }\n\n                    if (!isOriginalRequired && $(widget.element).hasClass('required')) {\n                        $(widget.element).removeClass('required');\n                    }\n                }\n            });\n\n            $(this.options.bundlePriceType).on('change', function (event) {\n                var attributeItems = widget.element.find('[data-role=\"delete-fpt-item\"]');\n\n                if ($(event.target).val() === '0') {\n                    widget.element.hide();\n                    attributeItems.each(function () {\n                        $(this).val(1);\n                    });\n                } else {\n                    widget.element.show();\n                    attributeItems.each(function () {\n                        if ($(this).closest('[data-role=\"fpt-item-row\"]').is(':visible')) {\n                            $(this).val(0);\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Add custom option.\n         *\n         * @param {jQuery.Event} event\n         */\n        addItem: function (event) {\n            var data = {},\n                currentElement = event.target || event.srcElement || event.currentTarget,\n                tmpl;\n\n            if (typeof currentElement !== 'undefined') {\n                data['website_id'] = 0;\n            } else {\n                data = event;\n            }\n\n            data.index = this.element.find('[data-role=\"fpt-item-row\"]').length;\n\n            tmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(tmpl).appendTo(this.element.find('[data-role=\"fpt-item-container\"]'));\n\n            //set selected website_id value if set\n            if (data['website_id']) {\n                this.element.find('[data-role=\"select-website\"][id$=\"_' + data.index + '_website\"]')\n                    .val(data['website_id']);\n            }\n\n            //set selected country value if set\n            if (data.country) {\n                this.element.find('[data-role=\"select-country\"][id$=\"_' + data.index + '_country\"]')\n                    .val(data.country).trigger('change', data);\n            }\n        }\n    });\n\n    return $.mage.fptAttribute;\n});\n","Magento_Weee/js/fpt-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/group',\n    'uiRegistry',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'underscore'\n], function (Group, uiRegistry, validation, $t, _) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            validation.addRule('validate-fpt-group', function (value) {\n                if (value.indexOf('?') !== -1) {\n\n                    return false;\n                }\n\n                return true;\n            }, $t(\n                'Set unique country-state combinations within the same fixed product tax. ' +\n                'Verify the combinations and try again.'\n            ));\n\n            this._super();\n        },\n\n        /**\n         *\n         * @private\n         */\n        _handleOptionsAvailability: function () {\n            var parent,\n                dup;\n\n            dup = {};\n            parent = uiRegistry.get(uiRegistry.get(this.parentName).parentName);\n            _.each(parent.elems(), function (elem) {\n                var country,\n                    state,\n                    val,\n                    key;\n\n                country = uiRegistry.get(elem.name + '.countryState.country');\n                state = uiRegistry.get(elem.name + '.countryState.state');\n                val = uiRegistry.get(elem.name + '.countryState.val');\n\n                key = country.value() + (state.value() > 0 ? state.value() : 0);\n                dup[key]++;\n\n                if (!dup[key]) {\n                    dup[key] = 1;\n                    val.value('');\n                } else {\n                    dup[key]++;\n                    val.value(country.value() + '?' + country.name);\n                }\n            });\n        },\n\n        /** @inheritdoc */\n        initElement: function (elem) {\n            var obj;\n\n            obj = this;\n            this._super();\n            elem.on('value', function () {\n                obj._handleOptionsAvailability();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithoutTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithoutTax(taxAmount);\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithTax(taxAmount);\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeAdjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustmentUnsanitizedHtml: function (row) {\n            return this.getWeeeAdjustment(row);\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryGroupedProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryGroupedProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_Tax/js/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'mage/backend/editablemultiselect'\n]);\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * UnsanitizedHtml version of getTax.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTaxUnsanitizedHtml: function (row) {\n            return this.getTax(row);\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magefan_Blog/js/post-gallery.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\n/*jshint jquery:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'uiRegistry',\n    'productGallery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget',\n    'baseImage'\n], function ($, _, mageTemplate, registry, productGallery) {\n    'use strict';\n\n    $.widget('mage.productGallery', $.mage.productGallery, {\n        _showDialog: function (imageData) {}\n    });\n\n    return $.mage.productGallery;\n});\n","Magefan_Blog/js/jquery.tagsinput.js":"/*\r\n\r\n\tjQuery Tags Input Plugin 1.3.3\r\n\r\n\tCopyright (c) 2011 XOXCO, Inc\r\n\r\n\tDocumentation for this plugin lives here:\r\n\thttp://xoxco.com/clickable/jquery-tags-input\r\n\r\n\tLicensed under the MIT license:\r\n\thttp://www.opensource.org/licenses/mit-license.php\r\n\r\n\tben@xoxco.com\r\n\r\n*/\r\n\r\n(function($) {\r\n\r\n\tvar delimiter = new Array();\r\n\tvar tags_callbacks = new Array();\r\n\t$.fn.doAutosize = function(o){\r\n\t    var minWidth = $(this).data('minwidth'),\r\n\t        maxWidth = $(this).data('maxwidth'),\r\n\t        val = '',\r\n\t        input = $(this),\r\n\t        testSubject = $('#'+$(this).data('tester_id'));\r\n\r\n\t    if (val === (val = input.val())) {return;}\r\n\r\n\t    // Enter new content into testSubject\r\n\t    var escaped = val.replace(/&/g, '&amp;').replace(/\\s/g,' ').replace(/</g, '&lt;').replace(/>/g, '&gt;');\r\n\t    testSubject.html(escaped);\r\n\t    // Calculate new width + whether to change\r\n\t    var testerWidth = testSubject.width(),\r\n\t        newWidth = (testerWidth + o.comfortZone) >= minWidth ? testerWidth + o.comfortZone : minWidth,\r\n\t        currentWidth = input.width(),\r\n\t        isValidWidthChange = (newWidth < currentWidth && newWidth >= minWidth)\r\n\t                             || (newWidth > minWidth && newWidth < maxWidth);\r\n\r\n\t    // Animate width\r\n\t    if (isValidWidthChange) {\r\n\t        input.width(newWidth);\r\n\t    }\r\n\r\n\r\n  };\r\n  $.fn.resetAutosize = function(options){\r\n    // alert(JSON.stringify(options));\r\n    var minWidth =  $(this).data('minwidth') || options.minInputWidth || $(this).width(),\r\n        maxWidth = $(this).data('maxwidth') || options.maxInputWidth || ($(this).closest('.tagsinput').width() - options.inputPadding),\r\n        val = '',\r\n        input = $(this),\r\n        testSubject = $('<tester/>').css({\r\n            position: 'absolute',\r\n            top: -9999,\r\n            left: -9999,\r\n            width: 'auto',\r\n            fontSize: input.css('fontSize'),\r\n            fontFamily: input.css('fontFamily'),\r\n            fontWeight: input.css('fontWeight'),\r\n            letterSpacing: input.css('letterSpacing'),\r\n            whiteSpace: 'nowrap'\r\n        }),\r\n        testerId = $(this).attr('id')+'_autosize_tester';\r\n    if(! $('#'+testerId).length > 0){\r\n      testSubject.attr('id', testerId);\r\n      testSubject.appendTo('body');\r\n    }\r\n\r\n    input.data('minwidth', minWidth);\r\n    input.data('maxwidth', maxWidth);\r\n    input.data('tester_id', testerId);\r\n    input.css('width', minWidth);\r\n  };\r\n\r\n\t$.fn.addTag = function(value,options) {\r\n\t\t\toptions = jQuery.extend({focus:false,callback:true},options);\r\n\t\t\tthis.each(function() {\r\n\t\t\t\tvar id = $(this).attr('id');\r\n\r\n\t\t\t\tvar tagslist = $(this).val().split(delimiter[id]);\r\n\t\t\t\tif (tagslist[0] == '') {\r\n\t\t\t\t\ttagslist = new Array();\r\n\t\t\t\t}\r\n\r\n\t\t\t\tvalue = jQuery.trim(value);\r\n\r\n\t\t\t\tif (options.unique) {\r\n\t\t\t\t\tvar skipTag = $(this).tagExist(value);\r\n\t\t\t\t\tif(skipTag == true) {\r\n\t\t\t\t\t    //Marks fake input as not_valid to let styling it\r\n    \t\t\t\t    $('#'+id+'_tag').addClass('not_valid');\r\n    \t\t\t\t}\r\n\t\t\t\t} else {\r\n\t\t\t\t\tvar skipTag = false;\r\n\t\t\t\t}\r\n\r\n\t\t\t\tif (value !='' && skipTag != true) {\r\n                    $('<span>').addClass('tag').append(\r\n                        $('<span>').text(value).append('&nbsp;&nbsp;'),\r\n                        $('<a>', {\r\n                            href  : '#',\r\n                            title : 'Removing tag',\r\n                            text  : 'x'\r\n                        }).click(function () {\r\n                            return $('#' + id).removeTag(escape(value));\r\n                        })\r\n                    ).insertBefore('#' + id + '_addTag');\r\n\r\n\t\t\t\t\ttagslist.push(value);\r\n\r\n\t\t\t\t\t$('#'+id+'_tag').val('');\r\n\t\t\t\t\tif (options.focus) {\r\n\t\t\t\t\t\t$('#'+id+'_tag').focus();\r\n\t\t\t\t\t} else {\r\n\t\t\t\t\t\t$('#'+id+'_tag').blur();\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\t$.fn.tagsInput.updateTagsField(this,tagslist);\r\n\r\n\t\t\t\t\tif (options.callback && tags_callbacks[id] && tags_callbacks[id]['onAddTag']) {\r\n\t\t\t\t\t\tvar f = tags_callbacks[id]['onAddTag'];\r\n\t\t\t\t\t\tf.call(this, value);\r\n\t\t\t\t\t}\r\n\t\t\t\t\tif(tags_callbacks[id] && tags_callbacks[id]['onChange'])\r\n\t\t\t\t\t{\r\n\t\t\t\t\t\tvar i = tagslist.length;\r\n\t\t\t\t\t\tvar f = tags_callbacks[id]['onChange'];\r\n\t\t\t\t\t\tf.call(this, $(this), tagslist[i-1]);\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\r\n\t\t\t});\r\n\r\n\t\t\treturn false;\r\n\t\t};\r\n\r\n\t$.fn.removeTag = function(value) {\r\n\t\t\tvalue = unescape(value);\r\n\t\t\tthis.each(function() {\r\n\t\t\t\tvar id = $(this).attr('id');\r\n\r\n\t\t\t\tvar old = $(this).val().split(delimiter[id]);\r\n\r\n\t\t\t\t$('#'+id+'_tagsinput .tag').remove();\r\n\t\t\t\tstr = '';\r\n\t\t\t\tfor (i=0; i< old.length; i++) {\r\n\t\t\t\t\tif (old[i]!=value) {\r\n\t\t\t\t\t\tstr = str + delimiter[id] +old[i];\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\r\n\t\t\t\t$.fn.tagsInput.importTags(this,str);\r\n\r\n\t\t\t\tif (tags_callbacks[id] && tags_callbacks[id]['onRemoveTag']) {\r\n\t\t\t\t\tvar f = tags_callbacks[id]['onRemoveTag'];\r\n\t\t\t\t\tf.call(this, value);\r\n\t\t\t\t}\r\n\t\t\t});\r\n\r\n\t\t\treturn false;\r\n\t\t};\r\n\r\n\t$.fn.tagExist = function(val) {\r\n\t\tvar id = $(this).attr('id');\r\n\t\tvar tagslist = $(this).val().split(delimiter[id]);\r\n\t\treturn (jQuery.inArray(val, tagslist) >= 0); //true when tag exists, false when not\r\n\t};\r\n\r\n   // clear all existing tags and import new ones from a string\r\n   $.fn.importTags = function(str) {\r\n      var id = $(this).attr('id');\r\n      $('#'+id+'_tagsinput .tag').remove();\r\n      $.fn.tagsInput.importTags(this,str);\r\n   }\r\n\r\n\t$.fn.tagsInput = function(options) {\r\n    var settings = jQuery.extend({\r\n      interactive:true,\r\n      defaultText:'add a tag',\r\n      minChars:0,\r\n      width:'300px',\r\n      height:'100px',\r\n      autocomplete: {selectFirst: false },\r\n      hide:true,\r\n      delimiter: ',',\r\n      unique:true,\r\n      removeWithBackspace:true,\r\n      placeholderColor:'#666666',\r\n      autosize: true,\r\n      comfortZone: 20,\r\n      inputPadding: 6*2\r\n    },options);\r\n\r\n    \tvar uniqueIdCounter = 0;\r\n\r\n\t\tthis.each(function() {\r\n         // If we have already initialized the field, do not do it again\r\n         if (typeof $(this).attr('data-tagsinput-init') !== 'undefined') {\r\n            return;\r\n         }\r\n\r\n         // Mark the field as having been initialized\r\n         $(this).attr('data-tagsinput-init', true);\r\n\r\n\t\t\tif (settings.hide) {\r\n\t\t\t\t$(this).hide();\r\n\t\t\t}\r\n\t\t\tvar id = $(this).attr('id');\r\n\t\t\tif (!id || delimiter[$(this).attr('id')]) {\r\n\t\t\t\tid = $(this).attr('id', 'tags' + new Date().getTime() + (uniqueIdCounter++)).attr('id');\r\n\t\t\t}\r\n\r\n\t\t\tvar data = jQuery.extend({\r\n\t\t\t\tpid:id,\r\n\t\t\t\treal_input: '#'+id,\r\n\t\t\t\tholder: '#'+id+'_tagsinput',\r\n\t\t\t\tinput_wrapper: '#'+id+'_addTag',\r\n\t\t\t\tfake_input: '#'+id+'_tag'\r\n\t\t\t},settings);\r\n\r\n\t\t\tdelimiter[id] = data.delimiter;\r\n\r\n\t\t\tif (settings.onAddTag || settings.onRemoveTag || settings.onChange) {\r\n\t\t\t\ttags_callbacks[id] = new Array();\r\n\t\t\t\ttags_callbacks[id]['onAddTag'] = settings.onAddTag;\r\n\t\t\t\ttags_callbacks[id]['onRemoveTag'] = settings.onRemoveTag;\r\n\t\t\t\ttags_callbacks[id]['onChange'] = settings.onChange;\r\n\t\t\t}\r\n\r\n\t\t\tvar markup = '<div id=\"'+id+'_tagsinput\" class=\"tagsinput\"><div id=\"'+id+'_addTag\">';\r\n\r\n\t\t\tif (settings.interactive) {\r\n\t\t\t\tmarkup = markup + '<input id=\"'+id+'_tag\" value=\"\" data-default=\"'+settings.defaultText+'\" />';\r\n\t\t\t}\r\n\r\n\t\t\tmarkup = markup + '</div><div class=\"tags_clear\"></div></div>';\r\n\r\n\t\t\t$(markup).insertAfter(this);\r\n\r\n\t\t\t$(data.holder).css('width',settings.width);\r\n\t\t\t$(data.holder).css('min-height',settings.height);\r\n\t\t\t$(data.holder).css('height',settings.height);\r\n\r\n\t\t\tif ($(data.real_input).val()!='') {\r\n\t\t\t\t$.fn.tagsInput.importTags($(data.real_input),$(data.real_input).val());\r\n\t\t\t}\r\n\t\t\tif (settings.interactive) {\r\n\t\t\t\t$(data.fake_input).val($(data.fake_input).attr('data-default'));\r\n\t\t\t\t$(data.fake_input).css('color',settings.placeholderColor);\r\n\t\t        $(data.fake_input).resetAutosize(settings);\r\n\r\n\t\t\t\t$(data.holder).bind('click',data,function(event) {\r\n\t\t\t\t\t$(event.data.fake_input).focus();\r\n\t\t\t\t});\r\n\r\n\t\t\t\t$(data.fake_input).bind('focus',data,function(event) {\r\n\t\t\t\t\tif ($(event.data.fake_input).val()==$(event.data.fake_input).attr('data-default')) {\r\n\t\t\t\t\t\t$(event.data.fake_input).val('');\r\n\t\t\t\t\t}\r\n\t\t\t\t\t$(event.data.fake_input).css('color','#000000');\r\n\t\t\t\t});\r\n\r\n\t\t\t\tif (settings.autocomplete_url != undefined) {\r\n\t\t\t\t\tautocomplete_options = {source: settings.autocomplete_url};\r\n\t\t\t\t\tfor (attrname in settings.autocomplete) {\r\n\t\t\t\t\t\tautocomplete_options[attrname] = settings.autocomplete[attrname];\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t\tif (jQuery.Autocompleter !== undefined) {\r\n\t\t\t\t\t\t$(data.fake_input).autocomplete(settings.autocomplete_url, settings.autocomplete);\r\n\t\t\t\t\t\t$(data.fake_input).bind('result',data,function(event,data,formatted) {\r\n\t\t\t\t\t\t\tif (data) {\r\n\t\t\t\t\t\t\t\t$('#'+id).addTag(data[0] + \"\",{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\t}\r\n\t\t\t\t\t  \t});\r\n\t\t\t\t\t} else if (jQuery.ui.autocomplete !== undefined) {\r\n\t\t\t\t\t\t$(data.fake_input).autocomplete(autocomplete_options);\r\n\t\t\t\t\t\t$(data.fake_input).bind('autocompleteselect',data,function(event,ui) {\r\n\t\t\t\t\t\t\t$(event.data.real_input).addTag(ui.item.value,{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t});\r\n\t\t\t\t\t}\r\n\r\n\r\n\t\t\t\t} else {\r\n\t\t\t\t\t\t// if a user tabs out of the field, create a new tag\r\n\t\t\t\t\t\t// this is only available if autocomplete is not used.\r\n\t\t\t\t\t\t$(data.fake_input).bind('blur',data,function(event) {\r\n\t\t\t\t\t\t\tvar d = $(this).attr('data-default');\r\n\t\t\t\t\t\t\tif ($(event.data.fake_input).val()!='' && $(event.data.fake_input).val()!=d) {\r\n\t\t\t\t\t\t\t\tif( (event.data.minChars <= $(event.data.fake_input).val().length) && (!event.data.maxChars || (event.data.maxChars >= $(event.data.fake_input).val().length)) )\r\n\t\t\t\t\t\t\t\t\t$(event.data.real_input).addTag($(event.data.fake_input).val(),{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t\t\t} else {\r\n\t\t\t\t\t\t\t\t$(event.data.fake_input).val($(event.data.fake_input).attr('data-default'));\r\n\t\t\t\t\t\t\t\t$(event.data.fake_input).css('color',settings.placeholderColor);\r\n\t\t\t\t\t\t\t}\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t});\r\n\r\n\t\t\t\t}\r\n\t\t\t\t// if user types a default delimiter like comma,semicolon and then create a new tag\r\n\t\t\t\t$(data.fake_input).bind('keypress',data,function(event) {\r\n\t\t\t\t\tif (_checkDelimiter(event)) {\r\n\t\t\t\t\t    event.preventDefault();\r\n\t\t\t\t\t\tif( (event.data.minChars <= $(event.data.fake_input).val().length) && (!event.data.maxChars || (event.data.maxChars >= $(event.data.fake_input).val().length)) )\r\n\t\t\t\t\t\t\t$(event.data.real_input).addTag($(event.data.fake_input).val(),{focus:true,unique:(settings.unique)});\r\n\t\t\t\t\t  \t$(event.data.fake_input).resetAutosize(settings);\r\n\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t} else if (event.data.autosize) {\r\n\t\t\t            $(event.data.fake_input).doAutosize(settings);\r\n\r\n          \t\t\t}\r\n\t\t\t\t});\r\n\t\t\t\t//Delete last tag on backspace\r\n\t\t\t\t// data.removeWithBackspace && $(data.fake_input).bind('keydown', function(event)\r\n\t\t\t\t// {\r\n\t\t\t\t// \tif(event.keyCode == 8 && $(this).val() == '')\r\n\t\t\t\t// \t{\r\n\t\t\t\t// \t\t event.preventDefault();\r\n\t\t\t\t// \t\t var last_tag = $(this).closest('.tagsinput').find('.tag:last').text();\r\n\t\t\t\t// \t\t var id = $(this).attr('id').replace(/_tag$/, '');\r\n\t\t\t\t// \t\t last_tag = last_tag.replace(/[\\s]+x$/, '');\r\n\t\t\t\t// \t\t $('#' + id).removeTag(escape(last_tag));\r\n\t\t\t\t// \t\t $(this).trigger('focus');\r\n\t\t\t\t// \t}\r\n\t\t\t\t// });\r\n\t\t\t\t// $(data.fake_input).blur();\r\n\r\n\t\t\t\t//Removes the not_valid class when user changes the value of the fake input\r\n\t\t\t\tif(data.unique) {\r\n\t\t\t\t    $(data.fake_input).keydown(function(event){\r\n\t\t\t\t        if(event.keyCode == 8 || String.fromCharCode(event.which).match(/\\w+|[\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1,/]+/)) {\r\n\t\t\t\t            $(this).removeClass('not_valid');\r\n\t\t\t\t        }\r\n\t\t\t\t    });\r\n\t\t\t\t}\r\n\t\t\t} // if settings.interactive\r\n\t\t});\r\n\r\n\t\treturn this;\r\n\r\n\t};\r\n\r\n\t$.fn.tagsInput.updateTagsField = function(obj,tagslist) {\r\n\t\tvar id = $(obj).attr('id');\r\n\t\t$(obj).val(tagslist.join(delimiter[id]));\r\n\t};\r\n\r\n\t$.fn.tagsInput.importTags = function(obj,val) {\r\n\t\t$(obj).val('');\r\n\t\tvar id = $(obj).attr('id');\r\n\t\tvar tags = val.split(delimiter[id]);\r\n\t\tfor (i=0; i<tags.length; i++) {\r\n\t\t\t$(obj).addTag(tags[i],{focus:false,callback:false});\r\n\t\t}\r\n\t\tif(tags_callbacks[id] && tags_callbacks[id]['onChange'])\r\n\t\t{\r\n\t\t\tvar f = tags_callbacks[id]['onChange'];\r\n\t\t\tf.call(obj, obj, tags[i]);\r\n\t\t}\r\n\t};\r\n\r\n   /**\r\n     * check delimiter Array\r\n     * @param event\r\n     * @returns {boolean}\r\n     * @private\r\n     */\r\n   var _checkDelimiter = function(event){\r\n      var found = false;\r\n      if (event.which == 13) {\r\n         return true;\r\n      }\r\n\r\n      if (typeof event.data.delimiter === 'string') {\r\n         if (event.which == event.data.delimiter.charCodeAt(0)) {\r\n            found = true;\r\n         }\r\n      } else {\r\n         $.each(event.data.delimiter, function(index, delimiter) {\r\n            if (event.which == delimiter.charCodeAt(0)) {\r\n               found = true;\r\n            }\r\n         });\r\n      }\r\n\r\n      return found;\r\n   }\r\n})(jQuery);\r\n","Magefan_Blog/js/form/element/link.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractElement) {\n    'use strict';\n\n    return AbstractElement.extend({\n        defaults: {\n            elementTmpl: 'Magefan_Blog/form/element/link'\n        },\n\n        initialize: function () {\n            this._super();\n\n            var value = this.value();\n            this.url = value.url;\n            this.title = value.title;\n            this.text = value.text;\n        },\n\n    });\n});","Magefan_Blog/js/components/new-category.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'Magefan_Blog/js/components/new-tag'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.model['is_active'],\n                level: data.model['level'],\n                value: data.model['category_id'],\n                label: data.model['title'],\n                parent: data.model['parent_id']\n            };\n        }\n    });\n});\n","Magefan_Blog/js/components/new-tag.js":"/**\n * Copyright \u00a9 Magefan (support@magefan.com). All rights reserved.\n * Please visit Magefan.com for license details (https://magefan.com/end-user-license-agreement).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/ui-select'\n], function (_, Select) {\n    'use strict';\n\n    function flatten(a, s, cr)\n    {\n        var i = 0, c;\n        a = _.compact(a);\n        cr = cr || [];\n        for (i; i < a.length; i++) {\n            cr.push(a[i]);\n            if (a[i].hasOwnProperty(s)) {\n                c = a[i][s];\n                delete a[i][s];\n                flatten.call(this, c, s, cr);\n            }\n        }\n        return cr;\n    }\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data),\n                copyOptionsTree\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            if (!option.parent) {\n                this.cacheOptions.tree.push(option);\n                copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\n                this.cacheOptions.plain = flatten(copyOptionsTree, this.separator);\n                this.options(this.cacheOptions.tree);\n            } else {\n                this.setOption(option);\n            }\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': \"1\",\n                level: 0,\n                value: data.model['tag_id'],\n                label: data.model['title'],\n                parent: 0\n            };\n        }\n    });\n});\n","js-cookie/cookie-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/js.cookie'\n], function ($, cookie) {\n    'use strict';\n\n    window.Cookies = window.Cookies || cookie;\n\n    var config = $.cookie = function (key, value, options) {\n        if (value !== undefined) {\n            options = $.extend({}, config.defaults, options);\n\n            return cookie.set(key, value, options);\n        }\n\n        var result = key ? undefined : {},\n            cookies = document.cookie ? document.cookie.split('; ') : [],\n            i;\n\n        for (i = 0; i < cookies.length; i++) {\n            var parts = cookies[i].split('='),\n                name = config.raw ? parts.shift() : decodeURIComponent(parts.shift()),\n                cookieValue = parts.join('=');\n\n            if (key && key === name) {\n                result = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '));\n                break;\n            }\n\n            if (!key && (cookieValue = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '))) !== undefined) {\n                result[name] = cookieValue;\n            }\n        }\n\n        return result;\n    };\n\n    config.defaults = {};\n\n    $.removeCookie = function (key, options) {\n        if ($.cookie(key) === undefined) {\n            return false;\n        }\n\n        $.cookie(key, '', $.extend({}, options, { expires: -1 }));\n        return !$.cookie(key);\n    };\n});\n","js-cookie/js.cookie.js":"/*! js-cookie v3.0.1 | MIT */\n;\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = global || self, (function () {\n                var current = global.Cookies;\n                var exports = global.Cookies = factory();\n                exports.noConflict = function () { global.Cookies = current; return exports; };\n            }()));\n}(this, (function () { 'use strict';\n\n    /* eslint-disable no-var */\n    function assign (target) {\n        for (var i = 1; i < arguments.length; i++) {\n            var source = arguments[i];\n            for (var key in source) {\n                target[key] = source[key];\n            }\n        }\n        return target\n    }\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n    var defaultConverter = {\n        read: function (value) {\n            if (value[0] === '\"') {\n                value = value.slice(1, -1);\n            }\n            return value.replace(/(%[\\dA-F]{2})+/gi, decodeURIComponent)\n        },\n        write: function (value) {\n            return encodeURIComponent(value).replace(\n                /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,\n                decodeURIComponent\n            )\n        }\n    };\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n\n    function init (converter, defaultAttributes) {\n        function set (key, value, attributes) {\n            if (typeof document === 'undefined') {\n                return\n            }\n\n            attributes = assign({}, defaultAttributes, attributes);\n\n            if (typeof attributes.expires === 'number') {\n                attributes.expires = new Date(Date.now() + attributes.expires * 864e5);\n            }\n            if (attributes.expires) {\n                attributes.expires = attributes.expires.toUTCString();\n            }\n\n            key = encodeURIComponent(key)\n                .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)\n                .replace(/[()]/g, escape);\n\n            var stringifiedAttributes = '';\n            for (var attributeName in attributes) {\n                if (!attributes[attributeName]) {\n                    continue\n                }\n\n                stringifiedAttributes += '; ' + attributeName;\n\n                if (attributes[attributeName] === true) {\n                    continue\n                }\n\n                // Considers RFC 6265 section 5.2:\n                // ...\n                // 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n                //     character:\n                // Consume the characters of the unparsed-attributes up to,\n                // not including, the first %x3B (\";\") character.\n                // ...\n                stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n            }\n\n            return (document.cookie =\n                key + '=' + converter.write(value, key) + stringifiedAttributes)\n        }\n\n        function get (key) {\n            if (typeof document === 'undefined' || (arguments.length && !key)) {\n                return\n            }\n\n            // To prevent the for loop in the first place assign an empty array\n            // in case there are no cookies at all.\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\n            var jar = {};\n            for (var i = 0; i < cookies.length; i++) {\n                var parts = cookies[i].split('=');\n                var value = parts.slice(1).join('=');\n\n                try {\n                    var foundKey = decodeURIComponent(parts[0]);\n                    jar[foundKey] = converter.read(value, foundKey);\n\n                    if (key === foundKey) {\n                        break\n                    }\n                } catch (e) {}\n            }\n\n            return key ? jar[key] : jar\n        }\n\n        return Object.create(\n            {\n                set: set,\n                get: get,\n                remove: function (key, attributes) {\n                    set(\n                        key,\n                        '',\n                        assign({}, attributes, {\n                            expires: -1\n                        })\n                    );\n                },\n                withAttributes: function (attributes) {\n                    return init(this.converter, assign({}, this.attributes, attributes))\n                },\n                withConverter: function (converter) {\n                    return init(assign({}, this.converter, converter), this.attributes)\n                }\n            },\n            {\n                attributes: { value: Object.freeze(defaultAttributes) },\n                converter: { value: Object.freeze(converter) }\n            }\n        )\n    }\n\n    var api = init(defaultConverter, { path: '/' });\n    /* eslint-enable no-var */\n\n    return api;\n\n})));\n","Magento_Swatches/js/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n *  @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionTextDefaultInputType = 'radio',\n            swatchTextOption = {\n                table: $('swatch-text-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-text-row-template'),\n\n                /**\n                 * Add option\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionTextDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * Remove option\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-text-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-text-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render action\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-text-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render action with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_text_option_button')) {\n            Event.observe(\n                'add_new_swatch_text_option_button',\n                'click',\n                swatchTextOption.add.bind(swatchTextOption, true)\n            );\n        }\n        jQuery('#swatch-text-options-panel').on('render', function () {\n            swatchTextOption.ignoreValidate();\n\n            if (swatchTextOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchTextOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchTextOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-text-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update components\n                     */\n                    update: function () {\n                        $('[data-role=swatch-text-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        jQuery(function () {\n            if (jQuery('#frontend_input').val() !== 'swatch_text') {\n                jQuery('.swatch-text-field-0').removeClass('required-option');\n            }\n        });\n\n        window.swatchTextOption = swatchTextOption;\n        window.swatchOptionTextDefaultInputType = swatchOptionTextDefaultInputType;\n\n        rg.set('swatch-text-options-panel', swatchTextOption);\n    };\n});\n","Magento_Swatches/js/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/prompt',\n    'uiRegistry',\n    'collapsable'\n], function ($, alert, prompt, rg) {\n    'use strict';\n\n    return function (optionConfig) {\n        var activePanelClass = 'selected-type-options',\n            swatchProductAttributes = {\n                frontendInput: $('#frontend_input'),\n                isFilterable: $('#is_filterable'),\n                isFilterableInSearch: $('#is_filterable_in_search'),\n                backendType: $('#backend_type'),\n                usedForSortBy: $('#used_for_sort_by'),\n                frontendClass: $('#frontend_class'),\n                isWysiwygEnabled: $('#is_wysiwyg_enabled'),\n                isHtmlAllowedOnFront: $('#is_html_allowed_on_front'),\n                isRequired: $('#is_required'),\n                isUnique: $('#is_unique'),\n                defaultValueText: $('#default_value_text'),\n                defaultValueTextarea: $('#default_value_textarea'),\n                defaultValueDate: $('#default_value_date'),\n                defaultValueDatetime: $('#default_value_datetime'),\n                defaultValueYesno: $('#default_value_yesno'),\n                isGlobal: $('#is_global'),\n                useProductImageForSwatch: $('#use_product_image_for_swatch'),\n                updateProductPreviewImage: $('#update_product_preview_image'),\n                usedInProductListing: $('#used_in_product_listing'),\n                isVisibleOnFront: $('#is_visible_on_front'),\n                position: $('#position'),\n                attrTabsFront: $('#product_attribute_tabs_front'),\n\n                /**\n                 * @returns {*|jQuery|HTMLElement}\n                 */\n                get tabsFront() {\n                    return this.attrTabsFront.length ? this.attrTabsFront.closest('li') : $('#front_fieldset-wrapper');\n                },\n                selectFields: ['boolean', 'select', 'multiselect', 'price', 'swatch_text', 'swatch_visual'],\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                toggleApplyVisibility: function (select) {\n                    if ($(select).val() === 1) {\n                        $(select).next('select').removeClass('no-display');\n                        $(select).next('select').removeClass('ignore-validate');\n                    } else {\n                        $(select).next('select').addClass('no-display');\n                        $(select).next('select').addClass('ignore-validate');\n                        $(select).next('select option:selected').each(function () {\n                            this.selected = false;\n                        });\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                checkOptionsPanelVisibility: function () {\n                    var selectOptionsPanel = $('#manage-options-panel'),\n                        visualOptionsPanel = $('#swatch-visual-options-panel'),\n                        textOptionsPanel = $('#swatch-text-options-panel');\n\n                    this._hidePanel(selectOptionsPanel);\n                    this._hidePanel(visualOptionsPanel);\n                    this._hidePanel(textOptionsPanel);\n\n                    switch (this.frontendInput.val()) {\n                        case 'swatch_visual':\n                            this._showPanel(visualOptionsPanel);\n                            break;\n\n                        case 'swatch_text':\n                            this._showPanel(textOptionsPanel);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this._showPanel(selectOptionsPanel);\n                            break;\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                bindAttributeInputType: function () {\n                    this.checkOptionsPanelVisibility();\n                    this.switchDefaultValueField();\n\n                    if (!~$.inArray(this.frontendInput.val(), this.selectFields)) {\n                        // not in array\n                        this.isFilterable.selectedIndex = 0;\n                        this._disable(this.isFilterable);\n                        this._disable(this.isFilterableInSearch);\n                    } else {\n                        // in array\n                        this._enable(this.isFilterable);\n                        this._enable(this.isFilterableInSearch);\n                        this.backendType.val('int');\n                    }\n\n                    if (this.frontendInput.val() === 'multiselect' ||\n                        this.frontendInput.val() === 'gallery' ||\n                        this.frontendInput.val() === 'textarea'\n                    ) {\n                        this._disable(this.usedForSortBy);\n                    } else {\n                        this._enable(this.usedForSortBy);\n                    }\n\n                    if (this.frontendInput.val() === 'swatch_text') {\n                        $('.swatch-text-field-0').addClass('required-option');\n                    } else {\n                        $('.swatch-text-field-0').removeClass('required-option');\n                    }\n\n                    this.setRowVisibility(this.isWysiwygEnabled, false);\n                    this.setRowVisibility(this.isHtmlAllowedOnFront, false);\n\n                    switch (this.frontendInput.val()) {\n                        case 'textarea':\n                            this.setRowVisibility(this.isWysiwygEnabled, true);\n\n                            if (this.isWysiwygEnabled.val() === '0') {\n                                this._enable(this.isHtmlAllowedOnFront);\n                            }\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n\n                        case 'text':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this._enable(this.frontendClass);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n                        default:\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                    }\n\n                    this.switchIsFilterable();\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchIsFilterable: function () {\n                    if (this.isFilterable.selectedIndex === 0) {\n                        this._disable(this.position);\n                    } else {\n                        this._enable(this.position);\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchDefaultValueField: function () {\n                    var currentValue = this.frontendInput.val(),\n                        defaultValueTextVisibility = false,\n                        defaultValueTextareaVisibility = false,\n                        defaultValueDateVisibility = false,\n                        defaultValueDatetimeVisibility = false,\n                        defaultValueYesnoVisibility = false,\n                        scopeVisibility = true,\n                        useProductImageForSwatch = false,\n                        defaultValueUpdateImage = false,\n                        optionDefaultInputType = '',\n                        isFrontTabHidden = false,\n                        thing = this;\n\n                    if (!this.frontendInput.length) {\n                        return;\n                    }\n\n                    switch (currentValue) {\n                        case 'select':\n                            optionDefaultInputType = 'radio';\n                            break;\n\n                        case 'multiselect':\n                            optionDefaultInputType = 'checkbox';\n                            break;\n\n                        case 'date':\n                            defaultValueDateVisibility = true;\n                            break;\n\n                        case 'datetime':\n                            defaultValueDatetimeVisibility = true;\n                            break;\n\n                        case 'boolean':\n                            defaultValueYesnoVisibility = true;\n                            break;\n\n                        case 'textarea':\n                        case 'texteditor':\n                            defaultValueTextareaVisibility = true;\n                            break;\n\n                        case 'media_image':\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'price':\n                            scopeVisibility = false;\n                            break;\n\n                        case 'swatch_visual':\n                            useProductImageForSwatch = true;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'swatch_text':\n                            useProductImageForSwatch = false;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n                        default:\n                            defaultValueTextVisibility = true;\n                            break;\n                    }\n\n                    delete optionConfig.hiddenFields['swatch_visual'];\n                    delete optionConfig.hiddenFields['swatch_text'];\n\n                    if (currentValue === 'media_image') {\n                        this.tabsFront.hide();\n                        this.setRowVisibility(this.isRequired, false);\n                        this.setRowVisibility(this.isUnique, false);\n                        this.setRowVisibility(this.frontendClass, false);\n                    } else if (optionConfig.hiddenFields[currentValue]) {\n                        $.each(optionConfig.hiddenFields[currentValue], function (key, option) {\n                            switch (option) {\n                                case '_front_fieldset':\n                                    thing.tabsFront.hide();\n                                    isFrontTabHidden = true;\n                                    break;\n\n                                case '_default_value':\n                                    defaultValueTextVisibility = false;\n                                    defaultValueTextareaVisibility = false;\n                                    defaultValueDateVisibility = false;\n                                    defaultValueDatetimeVisibility = false;\n                                    defaultValueYesnoVisibility = false;\n                                    break;\n\n                                case '_scope':\n                                    scopeVisibility = false;\n                                    break;\n                                default:\n                                    thing.setRowVisibility($('#' + option), false);\n                            }\n                        });\n\n                        if (!isFrontTabHidden) {\n                            thing.tabsFront.show();\n                        }\n\n                    } else {\n                        this.tabsFront.show();\n                        this.showDefaultRows();\n                    }\n\n                    this.setRowVisibility(this.defaultValueText, defaultValueTextVisibility);\n                    this.setRowVisibility(this.defaultValueTextarea, defaultValueTextareaVisibility);\n                    this.setRowVisibility(this.defaultValueDate, defaultValueDateVisibility);\n                    this.setRowVisibility(this.defaultValueDatetime, defaultValueDatetimeVisibility);\n                    this.setRowVisibility(this.defaultValueYesno, defaultValueYesnoVisibility);\n                    this.setRowVisibility(this.isGlobal, scopeVisibility);\n\n                    /* swatch attributes */\n                    this.setRowVisibility(this.useProductImageForSwatch, useProductImageForSwatch);\n                    this.setRowVisibility(this.updateProductPreviewImage, defaultValueUpdateImage);\n\n                    $('input[name=\\'default[]\\']').each(function () {\n                        $(this).attr('type', optionDefaultInputType);\n                    });\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                showDefaultRows: function () {\n                    this.setRowVisibility(this.isRequired, true);\n                    this.setRowVisibility(this.isUnique, true);\n                    this.setRowVisibility(this.frontendClass, true);\n                },\n\n                /**\n                 * @param {Object} el\n                 * @param {Boolean} isVisible\n                 * @this {swatchProductAttributes}\n                 */\n                setRowVisibility: function (el, isVisible) {\n                    if (isVisible) {\n                        el.show();\n                        el.closest('.field').show();\n                    } else {\n                        el.hide();\n                        el.closest('.field').hide();\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _disable: function (el) {\n                    el.attr('disabled', 'disabled');\n                },\n\n                /**\n                 * @param {jQuery} el\n                 * @this {swatchProductAttributes}\n                 */\n                _enable: function (el) {\n                    if (!el.attr('readonly')) {\n                        el.prop('disabled', false);\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _showPanel: function (el) {\n                    el.closest('.fieldset').show();\n                    el.addClass(activePanelClass);\n                    this._render(el.attr('id'));\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _hidePanel: function (el) {\n                    el.closest('.fieldset').hide();\n                    el.removeClass(activePanelClass);\n                },\n\n                /**\n                 * @param {String} id\n                 * @this {swatchProductAttributes}\n                 */\n                _render: function (id) {\n                    rg.get(id, function () {\n                        $('#' + id).trigger('render');\n                    });\n                },\n\n                /**\n                 * @param {String} promptMessage\n                 * @this {swatchProductAttributes}\n                 */\n                saveAttributeInNewSet: function (promptMessage) {\n\n                    prompt({\n                        content: promptMessage,\n                        actions: {\n\n                            /**\n                             * @param {String} val\n                             * @this {actions}\n                             */\n                            confirm: function (val) {\n                                var rules = ['required-entry', 'validate-no-html-tags'],\n                                    newAttributeSetNameInputId = $('#new_attribute_set_name'),\n                                    editForm = $('#edit_form'),\n                                    newAttributeSetName = val,\n                                    i;\n\n                                if (!newAttributeSetName) {\n                                    return;\n                                }\n\n                                for (i = 0; i < rules.length; i++) {\n                                    if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                        alert({\n                                            content: $.validator.messages[rules[i]]\n                                        });\n\n                                        return;\n                                    }\n                                }\n\n                                if (newAttributeSetNameInputId.length) {\n                                    newAttributeSetNameInputId.val(newAttributeSetName);\n                                } else {\n                                    editForm.append(new Element('input', {\n                                            type: 'hidden',\n                                            id: newAttributeSetNameInputId,\n                                            name: 'new_attribute_set_name',\n                                            value: newAttributeSetName\n                                        })\n                                    );\n                                }\n                                // Temporary solution will replaced after refactoring of attributes functionality\n                                editForm.triggerHandler('save');\n                            }\n                        }\n                    });\n                }\n            };\n\n        $(function () {\n            var editForm = $('#edit_form'),\n                swatchVisualPanel = $('#swatch-visual-options-panel'),\n                swatchTextPanel = $('#swatch-text-options-panel'),\n                tableBody = $(),\n                activePanel = $();\n\n            $('#frontend_input').on('change', function () {\n                swatchProductAttributes.bindAttributeInputType();\n            });\n            $('#is_filterable').on('change', function () {\n                swatchProductAttributes.switchIsFilterable();\n            });\n\n            swatchProductAttributes.bindAttributeInputType();\n\n            // @todo: refactor collapsible component\n            $('.attribute-popup .collapse, [data-role=\"advanced_fieldset-content\"]')\n                .collapsable()\n                .collapse('hide');\n\n            editForm.on('beforeSubmit', function () {\n                var optionContainer, optionsValues;\n\n                activePanel = swatchTextPanel.hasClass(activePanelClass) ? swatchTextPanel : swatchVisualPanel;\n                optionContainer = activePanel.find('table tbody');\n\n                if (activePanel.hasClass(activePanelClass)) {\n                    optionsValues = $.map(\n                        optionContainer.find('tr'),\n                        function (row) {\n                            return $(row).find('input, select, textarea').serialize();\n                        }\n                    );\n                    $('<input>')\n                        .attr({\n                            type: 'hidden',\n                            name: 'serialized_options'\n                        })\n                        .val(JSON.stringify(optionsValues))\n                        .prependTo(editForm);\n                }\n\n                tableBody = optionContainer.detach();\n            });\n\n            editForm.on('afterValidate.error highlight.validate', function () {\n                if (activePanel.hasClass(activePanelClass)) {\n                    activePanel.find('table').append(tableBody);\n                    $('input[name=\"serialized_options\"]').remove();\n                }\n            });\n        });\n\n        window.saveAttributeInNewSet = swatchProductAttributes.saveAttributeInNewSet;\n        window.toggleApplyVisibility = swatchProductAttributes.toggleApplyVisibility;\n    };\n});\n","Magento_Swatches/js/visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/colorpicker/js/colorpicker',\n    'prototype',\n    'jquery/ui',\n    'validation'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionVisualDefaultInputType = 'radio',\n            swatchVisualOption = {\n                table: $('swatch-visual-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-visual-row-template'),\n\n                /**\n                 * Add new option using template\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'empty_class': 'unavailable'\n                        };\n                        isNewOption = true;\n                    } else if (data.defaultswatch0 === '') {\n                        data['empty_class'] = 'unavailable';\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionVisualDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * ColorPicker initialization process\n                 */\n                initColorPicker: function () {\n                    var element = this,\n                        hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                    jQuery(this).ColorPicker({\n\n                        /**\n                         * ColorPicker onShow action\n                         */\n                        onShow: function () {\n                            var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                                menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                            menu.hide();\n                            jQuery(element).ColorPickerSetColor(color);\n                        },\n\n                        /**\n                         * ColorPicker onSubmit action\n                         *\n                         * @param {String} hsb\n                         * @param {String} hex\n                         * @param {String} rgb\n                         * @param {String} el\n                         */\n                        onSubmit: function (hsb, hex, rgb, el) {\n                            var container = jQuery(el).parent().parent().prev();\n\n                            jQuery(el).ColorPickerHide();\n                            container.parent().removeClass('unavailable');\n                            container.prev('input').val('#' + hex);\n                            container.css('background', '#' + hex);\n                        }\n                    });\n\n                    if (hiddenColorPicker) {\n                        jQuery(this).ColorPickerShow();\n                    }\n                },\n\n                /**\n                 * Remove action\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render options\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-visual-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render elements with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_visual_option_button')) {\n            Event.observe(\n                'add_new_swatch_visual_option_button',\n                'click',\n                swatchVisualOption.add.bind(swatchVisualOption, {}, true)\n            );\n        }\n\n        jQuery('#swatch-visual-options-panel').on('render', function () {\n            swatchVisualOption.ignoreValidate();\n\n            if (swatchVisualOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchVisualOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchVisualOption.bindRemoveButtons();\n            jQuery('#swatch-visual-options-panel').on(\n                'click',\n                '.colorpicker_handler',\n                swatchVisualOption.initColorPicker\n            );\n        });\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-visual-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update component\n                     */\n                    update: function () {\n                        $('[data-role=swatch-visual-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        window.swatchVisualOption = swatchVisualOption;\n        window.swatchOptionVisualDefaultInputType = swatchOptionVisualDefaultInputType;\n\n        rg.set('swatch-visual-options-panel', swatchVisualOption);\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        id:  'upload_iframe',\n                        name: 'upload_iframe'\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        id: 'swatch_form_image_upload',\n                        name: 'swatch_form_image_upload',\n                        target: 'upload_iframe',\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: config.uploadActionUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var container = $('#' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        container.prev('input').val(imageParams['file_path']);\n                        container.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        container.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.on('load', iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(document).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).attr('id'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(document).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('');\n                optionPanel.children('.swatch_window').css('background', '');\n\n                optionPanel.addClass('unavailable');\n\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(document).on('click', '.swatches-visual-col', function () {\n                var currentElement = $(this).find('.swatch_sub-menu_container');\n\n                jQuery('.swatch_sub-menu_container').not(currentElement).hide();\n                currentElement.toggle();\n            });\n        });\n    };\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                    .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: this.products\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        disableSwatchForOutOfStockProducts: function () {\n            let $widget = this, container = this.element;\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                let item = this;\n\n                if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                    let salableProducts = $widget.options.jsonConfig.salable[item.id],\n                        swatchOptions = $(container).find(`[data-attribute-id='${item.id}']`).find('.swatch-option');\n\n                    swatchOptions.each(function (key, value) {\n                        let optionId = $(value).data('option-id');\n\n                        if (!salableProducts.hasOwnProperty(optionId)) {\n                            $(value).attr('disabled', true).addClass('disabled');\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                    .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.trigger('blur').remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]')\n                .removeClass('disabled')\n                .prop('disabled', false);\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n            this.disableSwatchForOutOfStockProducts();\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $(this.options.normalPriceLabelSelector).hide();\n\n            _.each($('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n\n            images.map(function (img) {\n                if (!img.type) {\n                    img.type = 'image';\n                }\n            });\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(imagesToUpdate, initialImages);\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        },\n\n        /**\n         * Callback for quantity change event.\n         */\n        _onQtyChanged: function () {\n            var $price = this.element.parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n\n            $price.trigger(\n                'updatePrice',\n                {\n                    'prices': this._getPrices(this._getNewPrices(), $price.priceBox('option').prices)\n                }\n            );\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/form/element/swatch-visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'mage/template',\n    'uiRegistry',\n    'prototype',\n    'Magento_Ui/js/form/element/abstract',\n    'jquery/colorpicker/js/colorpicker',\n    'jquery/ui'\n], function (_, jQuery, mageTemplate, rg, prototype, Abstract) {\n    'use strict';\n\n    /**\n     * Former implementation.\n     *\n     * @param {*} value\n     * @param {Object} container\n     * @param {String} uploadUrl\n     * @param {String} elementName\n     */\n    function oldCode(value, container, uploadUrl, elementName) {\n        var swatchVisualOption = {\n            itemCount: 0,\n            totalItems: 0,\n            rendered: 0,\n            isReadOnly: false,\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                if (_.isEmpty(value)) {\n                    container.addClassName('unavailable');\n                }\n\n                jQuery(container).on(\n                    'click',\n                    '.colorpicker_handler',\n                    this.initColorPicker\n                );\n            },\n\n            /**\n             * ColorPicker initialization process\n             */\n            initColorPicker: function () {\n                var element = this,\n                    hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                jQuery(this).ColorPicker({\n\n                    /**\n                     * ColorPicker onShow action\n                     */\n                    onShow: function () {\n                        var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                            menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                        menu.hide();\n                        jQuery(element).ColorPickerSetColor(color);\n                    },\n\n                    /**\n                     * ColorPicker onSubmit action\n                     *\n                     * @param {String} hsb\n                     * @param {String} hex\n                     * @param {String} rgb\n                     * @param {String} el\n                     */\n                    onSubmit: function (hsb, hex, rgb, el) {\n                        var localContainer = jQuery(el).parent().parent().prev();\n\n                        jQuery(el).ColorPickerHide();\n                        localContainer.parent().removeClass('unavailable');\n                        localContainer.prev('input').val('#' + hex).trigger('change');\n                        localContainer.css('background', '#' + hex);\n                    }\n                });\n\n                if (hiddenColorPicker) {\n                    jQuery(this).ColorPickerShow();\n                }\n            },\n\n            /**\n             * Remove action\n             *\n             * @param {Object} event\n             */\n            remove: function (event) {\n                var element = $(Event.findElement(event, 'tr')),\n                    elementFlags; // !!! Button already have table parent in safari\n\n                // Safari workaround\n                element.ancestors().each(function (parentItem) {\n                    if (parentItem.hasClassName('option-row')) {\n                        element = parentItem;\n                        throw $break;\n                    } else if (parentItem.hasClassName('box')) {\n                        throw $break;\n                    }\n                });\n\n                if (element) {\n                    elementFlags = element.getElementsByClassName('delete-flag');\n\n                    if (elementFlags[0]) {\n                        elementFlags[0].value = 1;\n                    }\n\n                    element.addClassName('no-display');\n                    element.addClassName('template');\n                    element.hide();\n                    this.totalItems--;\n                    this.updateItemsCountField();\n                }\n            },\n\n            /**\n             * Update items count field\n             */\n            updateItemsCountField: function () {\n                $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n            }\n        };\n\n        //swatchVisualOption.initColorPicker();\n\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        name: 'upload_iframe_' + elementName\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        name: 'swatch_form_image_upload_' + elementName,\n                        target: 'upload_iframe_' + elementName,\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: uploadUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            swatchVisualOption.initialize();\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var localContainer = $('.' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        localContainer.prev('input').val(imageParams['file_path']).trigger('change');\n                        localContainer.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        localContainer.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.on('load', iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(container).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).data('class'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(container).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('').trigger('change');\n                optionPanel.children('.swatch_window').css('background', '');\n                optionPanel.addClass('unavailable');\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(container).on('click', '.swatch_window', function () {\n                jQuery('.swatch_sub-menu_container').hide();\n                $(this).next('div').toggle();\n            });\n        });\n    }\n\n    return Abstract.extend({\n        defaults: {\n            elementId: 0,\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            value: '',\n            uploadUrl: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Initialize.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initOldCode()\n                .on('value', this.onChangeColor.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Handler function that execute when color changes.\n         *\n         * @param {String} data - color\n         */\n        onChangeColor: function (data) {\n            if (!data) {\n                jQuery('.' + this.elementName).parent().removeClass('unavailable');\n            }\n        },\n\n        /**\n         * Initialize wrapped former implementation.\n         *\n         * @returns {Object} Chainable.\n         */\n        initOldCode: function () {\n            jQuery.async('.' + this.elementName, this.name, function (elem) {\n                oldCode(this.value(), elem.parentElement, this.uploadUrl, this.elementName);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId, prefixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            this.inputName = prefixName + '[' + this.elementName + ']';\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_Security/js/confirm-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*eslint-disable no-undef*/\ndefine(\n    ['jquery'],\n    function ($) {\n        'use strict';\n\n        return function (config, element) {\n            $(element).on('click', config, function () {\n                confirmSetLocation(config.message, config.url);\n            });\n        };\n    }\n);\n","Magento_Security/js/system/config/session-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, inputEl) {\n        var $inputEl = $(inputEl);\n\n        $inputEl.on('blur', function () {\n            var inputVal = parseInt($inputEl.val(), 10);\n\n            if (inputVal < 256000) {\n                confirm({\n                    title: $t(config.modalTitleText),\n                    content: $t(config.modalContentBody),\n                    buttons: [{\n                        text: $t('No'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal and trigger 'cancel' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Yes'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Close modal and trigger 'confirm' action on click\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }],\n                    actions: {\n\n                        /**\n                         * Revert back to original value\n                         */\n                        cancel: function () {\n                            $inputEl.val(256000);\n                        }\n                    }\n                });\n            }\n        });\n    };\n});\n","Mageplaza_Smtp/js/testconnection.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    \"jquery\",\r\n    \"Magento_Ui/js/modal/alert\",\r\n    \"mage/translate\",\r\n    \"jquery/ui\"\r\n], function ($, alert, $t) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.testconnection', {\r\n        options: {\r\n            ajaxUrl: '',\r\n            testConnection: '#email_marketing_general_test_connection',\r\n            appID: '#email_marketing_general_app_id',\r\n            secretKey: '#email_marketing_general_secret_key',\r\n        },\r\n        _create: function () {\r\n            var self = this;\r\n\r\n            $(this.options.testConnection).click(function (e) {\r\n                e.preventDefault();\r\n                self._ajaxSubmit();\r\n            });\r\n        },\r\n\r\n        _ajaxSubmit: function () {\r\n            $.ajax({\r\n                url: this.options.ajaxUrl,\r\n                data: {\r\n                    appID: $(this.options.appID).val(),\r\n                    secretKey: $(this.options.secretKey).val()\r\n                },\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    alert({\r\n                        title: result.status ? $t('Success') : $t('Error'),\r\n                        content: result.content\r\n                    });\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.testconnection;\r\n});\r\n","Mageplaza_Smtp/js/abandonedcart.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_SMTP\r\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    'jquery',\r\n    'Magento_Ui/js/modal/modal'\r\n], function ($, modal) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.abandonedcarts', {\r\n\r\n        _create: function () {\r\n            this.initObserve();\r\n        },\r\n\r\n        /**\r\n         * Init observe\r\n         */\r\n        initObserve: function () {\r\n            var self = this,\r\n                popupSendEmailElement = $('#popup-send-email'),\r\n                copyElement = $('#copy');\r\n\r\n            $(\"#send\").click(function () {\r\n                $('#popup-send-email-details').show();\r\n                $('#popup-send-email-preview').show();\r\n                $('#preview').hide();\r\n                $('#popup-send-email-back').hide();\r\n\r\n                modal({\r\n                    type: 'popup',\r\n                    responsive: true,\r\n                    innerScroll: true,\r\n                    title: '',\r\n                    buttons: []\r\n                }, popupSendEmailElement);\r\n\r\n                popupSendEmailElement.modal('openModal');\r\n            });\r\n\r\n            $('#popup-send-email-preview').click(function () {\r\n                self.preview();\r\n            });\r\n\r\n            $('#popup-send-email form').submit(function(){\r\n                $(this).find(':submit').attr('disabled','disabled');\r\n            });\r\n\r\n\r\n            $('#popup-send-email-back').click(function () {\r\n                $('#popup-send-email-details').show();\r\n                $('#popup-send-email-preview').show();\r\n                $('#preview').hide();\r\n                this.hide();\r\n            });\r\n\r\n            copyElement.click(function () {\r\n               self.copyToClipboard();\r\n               $('#link-tooltip').text(self.options.copied_message);\r\n\r\n            });\r\n\r\n            copyElement.mouseout(function () {\r\n                $('#link-tooltip').text(self.options.tooltip);\r\n            })\r\n\r\n        },\r\n        copyToClipboard: function(){\r\n            var temp = $('<input>');\r\n\r\n            $('body').append(temp);\r\n            temp.val($('#recovery_link > span').text()).select();\r\n            document.execCommand('copy');\r\n            temp.remove();\r\n        },\r\n\r\n        /**\r\n         * @param type\r\n         * @param message\r\n         * @returns {string}\r\n         */\r\n        getMessageHtml: function (type, message) {\r\n            return '<div class=\"message message-' + type + '\"> <span>' + message + '</span> </div>';\r\n        },\r\n        getParams: function () {\r\n            return {\r\n                from: $('#sender').val(),\r\n                quote_id: this.options.quote_id,\r\n                template_id: $('#email-template').val(),\r\n                customer_name: this.options.customer_name,\r\n                additional_message: $('#additional-message').val()\r\n            }\r\n        },\r\n        preview: function () {\r\n            var self = this;\r\n\r\n            $.ajax({\r\n                url: this.options.preview_url,\r\n                data: this.getParams(),\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    if (result.status) {\r\n                        var dstFrame = document.getElementById('iframe-preview'),\r\n                            dstDoc   = dstFrame.contentDocument || dstFrame.contentWindow.document;\r\n\r\n                        dstDoc.write(result.content);\r\n                        dstDoc.close();\r\n                        $('#popup-send-email-details').hide();\r\n                        $('#popup-send-email-back').show();\r\n                        $('#preview').show();\r\n                        $('#popup-send-email-preview').hide();\r\n                        $('#subject strong').text(result.subject);\r\n                        $('#preview-from').text(result.from.email);\r\n                    } else {\r\n                        $('#popup-send-email #messages').html(self.getMessageHtml('error error', result.message));\r\n                    }\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.abandonedcarts;\r\n});\r\n","Mageplaza_Smtp/js/testemail.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\ndefine([\r\n    \"jquery\",\r\n    \"Magento_Ui/js/modal/alert\",\r\n    \"mage/translate\",\r\n    \"jquery/ui\"\r\n], function ($, alert, $t) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.testEmail', {\r\n        options: {\r\n            ajaxUrl: '',\r\n            testEmail: '#smtp_configuration_option_test_email_sent',\r\n            fromEmailElem: '#smtp_configuration_option_test_email_from',\r\n            hostElem: '#smtp_configuration_option_host',\r\n            portElem: '#smtp_configuration_option_port',\r\n            authenticationElem: '#smtp_configuration_option_authentication',\r\n            protocolElem: '#smtp_configuration_option_protocol',\r\n            usernameElem: '#smtp_configuration_option_username',\r\n            passwordElem: '#smtp_configuration_option_password',\r\n            rerutnPathElem: '#smtp_configuration_option_return_path_email'\r\n        },\r\n        _create: function () {\r\n            var self = this;\r\n\r\n            $(this.options.testEmail).click(function (e) {\r\n                e.preventDefault();\r\n                if (self.element.val()) {\r\n                    self._ajaxSubmit();\r\n                }\r\n            });\r\n        },\r\n\r\n        _ajaxSubmit: function () {\r\n            $.ajax({\r\n                url: this.options.ajaxUrl,\r\n                data: {\r\n                    from: $(this.options.fromEmailElem).val(),\r\n                    to: this.element.val(),\r\n                    host: $(this.options.hostElem).val(),\r\n                    port: $(this.options.portElem).val(),\r\n                    authentication: $(this.options.authenticationElem).val(),\r\n                    protocol: $(this.options.protocolElem).val(),\r\n                    username: $(this.options.usernameElem).val(),\r\n                    password: $(this.options.passwordElem).val(),\r\n                    returnpath: $(this.options.rerutnPathElem).val()\r\n                },\r\n                dataType: 'json',\r\n                showLoader: true,\r\n                success: function (result) {\r\n                    alert({\r\n                        title: result.status ? $t('Success') : $t('Error'),\r\n                        content: result.content\r\n                    });\r\n                }\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.testEmail;\r\n});\r\n","Mageplaza_Smtp/js/sync/sync.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\ndefine([\n    'jquery',\n    'Mageplaza_Smtp/js/model/sync'\n], function ($, Sync) {\n    'use strict';\n\n    $.widget('mageplaza.sync', {\n        options: {\n            ajaxUrl: '',\n            websiteId: '',\n            storeId: '',\n            estimateUrl: '',\n            buttonElement: '#email_marketing_general_synchronization_sync',\n            saveLog: '#email_marketing_general_synchronization_sync_log',\n            prefix: '#mp-synchronize',\n            console: '.email_marketing_general_synchronization_sync_console'\n        },\n        _create: function () {\n            var self = this;\n\n            $(this.options.buttonElement).click(function (e) {\n                e.preventDefault();\n                Sync.process(self.options);\n            });\n\n            $(this.options.saveLog).click(function (e) {\n                e.preventDefault();\n                Sync.saveLog(self.options.console);\n            });\n        },\n    });\n\n    return $.mageplaza.sync;\n});\n","Mageplaza_Smtp/js/model/sync.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function ($, _, $t) {\n    \"use strict\";\n\n    return {\n        options: {},\n        currentResult: {},\n        totalSync: 0,\n\n        /**\n         * @param classCss\n         * @param message\n         */\n        showMessage: function (classCss, message) {\n            var messageElement = this.getElement(\".message\");\n\n            messageElement.removeClass('message-error message-success message-notice');\n            this.getElement(\".message-text strong\").text(message);\n            messageElement.addClass(classCss).show();\n        },\n\n        /**\n         * @param value\n         * @returns {*|n.fn.init|r.fn.init|jQuery.fn.init|jQuery|HTMLElement}\n         */\n        getElement: function (value) {\n            return $(this.options.prefix + ' ' + value);\n        },\n\n        /**\n         * @param start\n         * @param i\n         */\n        syncData: function (start, i) {\n            var end         = start + 100,\n                ids         = this.currentResult.ids.slice(start, end),\n                self        = this,\n                createdFrom = $('#datepicker-from').val(),\n                createdTo   = $('#datepicker-to').val(),\n                daysRange   = $('#email_marketing_general_synchronization_days_range').val(),\n                type        = $('#email_marketing_general_synchronization_sync_type').val(),\n                syncOptions = $('#email_marketing_general_synchronization_sync_options').val(),\n                percent, percentText;\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'post',\n                dataType: 'json',\n                data: {\n                    type: i ? i : type,\n                    syncOptions: syncOptions,\n                    ids: ids,\n                    from: createdFrom,\n                    to: createdTo,\n                    daysRange: daysRange\n                },\n                success: function (result) {\n                    var inputLog = self.getElement('#mp-log-data').val();\n\n                    inputLog += JSON.stringify(result.log) + '|';\n\n                    if (result.status) {\n                        percent = ids.length / self.currentResult.total * 100;\n                        self.totalSync += result.total;\n                        percent = percent.toFixed(2);\n\n                        self.currentResult.percent += parseFloat(percent);\n                        if (self.currentResult.percent > 100) {\n                            self.currentResult.percent = 100;\n                        }\n                        self.getElement('#mp-log-data').val(inputLog);\n                        self.getElement('#mp-console-log').val(self.formatLog(result.log, self));\n                        percentText = self.currentResult.percent.toFixed(2) + '%';\n                        if (percentText === '100.00%' || self.totalSync === self.currentResult.total) {\n                            percentText = '100%';\n                            $(self.options.buttonElement).removeClass('disabled');\n                        }\n\n                        self.getElement('.progress-bar').css('width', percentText);\n                        self.getElement('#sync-percent').text(\n                            percentText + ' (' + self.totalSync + '/' + self.currentResult.total + ')'\n                        );\n\n                        if (i && i >= 1 && i <= 3) {\n                            self.getElement('.progress-bar-' + i).css('width', percentText);\n                            self.getElement('#sync-percent-' + i).text(\n                                percentText + ' (' + self.totalSync + '/' + self.currentResult.total + ')'\n                            );\n                        }\n\n                        if (end < self.currentResult.total) {\n                            self.syncData(end, i);\n                        } else {\n                            self.getElement('.syncing').hide();\n                            if (type === 'all') {\n                                self.showMultiMessages('message message-success', self.options.successMessage[i]);\n                            } else {\n                                self.showMessage('message-success', self.options.successMessage[type]);\n                            }\n                            if (i !== null) {\n                                self.estimateSyncAll(i + 1, syncOptions, createdFrom, createdTo, daysRange);\n                            }\n                        }\n                    } else {\n                        self.getElement('#mp-console-log').val(self.formatLog(result.log, self));\n                        self.getElement('#mp-log-data').val(inputLog);\n                        if (type === 'all') {\n                            self.showMultiMessages('message message-error', result.message);\n                        } else {\n                            self.showMessage('message-error', result.message);\n                        }\n                        $(self.options.buttonElement).removeClass('disabled');\n                    }\n                }\n            });\n        },\n\n        formatLog: function (log, self) {\n            var rs = self.getElement('#mp-console-log').val();\n\n            rs += log.message + '\\n';\n\n            _.each(log.data, function (item, index) {\n                if (index === 'success') {\n                    rs += ($t('Success: ') + item + '\\n')\n                }\n\n                if (index === 'error') {\n                    rs += ($t('Error: ') + item + '\\n')\n                }\n\n                if (index === 'error_details') {\n                    _.each(item, function (detail) {\n                        rs += ($t('Item ID: ' + detail.id + '\\n'))\n                        rs += ($t('Error: ' + detail.message + '\\n\\n'))\n                    })\n                }\n            });\n\n            return rs;\n        },\n\n        /**\n         * @param options\n         */\n        process: function (options) {\n            var self        = this,\n                type        = $('#email_marketing_general_synchronization_sync_type').val(),\n                syncOptions = $('#email_marketing_general_synchronization_sync_options').val(),\n                createdFrom = $('#datepicker-from').val(),\n                createdTo   = $('#datepicker-to').val(),\n                daysRange   = $('#email_marketing_general_synchronization_days_range').val();\n\n            options.buttonElement = '#email_marketing_general_synchronization button';\n            this.options          = options;\n            this.currentResult    = {};\n\n            self.getElement('.progress-content').hide();\n\n            if (type !== 'all') {\n                self.estimateSync(type, syncOptions, createdFrom, createdTo, daysRange);\n            } else {\n                self.getElement('#mp-console-log').val('');\n                self.getElement('#mp-log-data').val('');\n                self.estimateSyncAll(null, syncOptions, createdFrom, createdTo, daysRange);\n            }\n        },\n\n        estimateSync: function (type, syncOptions, createdFrom, createdTo, daysRange) {\n            var self = this;\n\n            $.ajax({\n                url: this.options.estimateUrl,\n                data: {\n                    websiteId: this.options.websiteId,\n                    storeId: this.options.storeId,\n                    type: type,\n                    syncOptions: syncOptions,\n                    from: createdFrom,\n                    to: createdTo,\n                    daysRange: daysRange\n                },\n                dataType: 'json',\n                showLoader: true,\n                success: function (result) {\n                    window.onbeforeunload = (e) => {\n                        e.preventDefault();\n                        e.returnValue = $t('Changes you made may not be saved.');\n                    };\n\n                    self.getElement('.multi-messages').hide();\n\n                    if (result.status) {\n                        self.currentResult = result;\n                        self.getElement('.message').hide();\n                        if (self.currentResult.total > 0) {\n                            self.getElement('#console-log').show();\n                        }\n                        self.getElement('#mp-console-log').val('');\n                        self.getElement('#mp-log-data').val('');\n\n                        if (self.currentResult.total > 0) {\n                            self.getElement('#sync-percent').text('0%');\n                            self.getElement('.progress-bar').removeAttr('style');\n                            self.currentResult.percent = 0;\n                            self.getElement('#progress-content').show();\n                            self.totalSync = 0;\n                            self.getElement('.syncing').hide();\n                            self.getElement('#syncing').show();\n                            $(self.options.buttonElement).addClass('disabled');\n                            self.syncData(0, null);\n                        } else {\n                            self.showMessage('message-notice', result.message);\n                            $(self.options.buttonElement).removeClass('disabled');\n                            self.getElement('#progress-content').hide();\n                        }\n                    } else {\n                        self.showMessage('message-error', result.message);\n                        $(self.options.buttonElement).removeClass('disabled');\n                        self.getElement('#progress-content').hide();\n                    }\n                }\n            });\n        },\n\n        estimateSyncAll: function (i = null, syncOptions, createdFrom, createdTo, daysRange) {\n            var self = this;\n\n            if (i === null) {\n                self.getElement('.multi-messages').html('');\n                i = 1;\n            }\n\n            if (i <= 3) {\n                $.ajax({\n                    url: this.options.estimateUrl,\n                    data: {\n                        websiteId: this.options.websiteId,\n                        storeId: this.options.storeId,\n                        type: i,\n                        syncOptions: syncOptions,\n                        from: createdFrom,\n                        to: createdTo,\n                        daysRange: daysRange\n                    },\n                    dataType: 'json',\n                    showLoader: true,\n                    success: function (result) {\n                        window.onbeforeunload = (e) => {\n                            e.preventDefault();\n                            e.returnValue = $t('Changes you made may not be saved.');\n                        };\n\n                        if (result.status) {\n                            self.currentResult = result;\n                            self.getElement('.message').hide();\n                            self.getElement('.multi-messages').show();\n                            self.getElement('.multi-messages .message').show();\n                            if (self.currentResult.total > 0) {\n                                self.getElement('#console-log').show();\n                            }\n\n                            if (self.currentResult.total > 0) {\n                                self.getElement('#sync-percent-' + i).text('0%');\n                                self.getElement('.progress-bar-' + i).removeAttr('style');\n                                self.currentResult.percent = 0;\n                                self.getElement('#progress-content-' + i).show();\n                                self.totalSync = 0;\n                                self.getElement('.syncing').hide();\n                                self.getElement('#syncing-' + i).show();\n                                $(self.options.buttonElement).addClass('disabled');\n                                self.syncData(0, i);\n                            } else {\n                                self.showMultiMessages('message message-notice', result.message);\n                                $(self.options.buttonElement).removeClass('disabled');\n                                self.getElement('#progress-content-' + i).hide();\n                                self.estimateSyncAll(i + 1, syncOptions, createdFrom, createdTo, daysRange);\n                            }\n                        } else {\n                            self.showMultiMessages('message message-error', result.message);\n                            $(self.options.buttonElement).removeClass('disabled');\n                            self.getElement('#progress-content-' + i).hide();\n                        }\n                    }\n                });\n            }\n        },\n\n        showMultiMessages: function (classCss, message) {\n            var messageElement = this.getElement('.multi-messages'),\n                html           = '<div class=\"' + classCss + '\"><span class=\"message-text\"><strong>'\n                    + message + '</strong></span><br></div>';\n\n            messageElement.append(html);\n            messageElement.find('.message').show();\n        },\n\n        saveLog: function (console) {\n            var log     = $(console).val(),\n                content = 'status,message,success,error,detail' + '\\n',\n                arrLog  = log.split('|');\n\n            _.each(arrLog, function (item) {\n                if (item) {\n                    var data   = JSON.parse(item),\n                        detail = '';\n\n                    content += data.success + ',' + data.message + ',' + data.data.success + ',' + data.data.error + ',';\n                    _.each(data.data.error_details, function (error) {\n                        if (error) {\n                            detail += JSON.stringify(error) + '\\n';\n                        }\n                    });\n                    var newDetail = detail.replace(',', ';');\n                    newDetail     = newDetail.replace(/['\"]+/g, '');\n                    content += '\"' + newDetail + '\"' + '\\n';\n                }\n            });\n\n            var hiddenElement      = document.createElement('a');\n            hiddenElement.href     = 'data:text/csv;charset=utf-8,' + encodeURI(content);\n            hiddenElement.target   = '_blank';\n            hiddenElement.download = 'mp-console-log.csv';\n            hiddenElement.click();\n        }\n    };\n});\n","Mageplaza_Smtp/js/grid/columns/status.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license sliderConfig is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Smtp\r\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/grid/columns/select'\r\n], function (Column) {\r\n    'use strict';\r\n\r\n    return Column.extend({\r\n        defaults: {\r\n            bodyTmpl: 'ui/grid/cells/html'\r\n        },\r\n        getLabel: function (record) {\r\n            var label = this._super(record);\r\n\r\n            if (label !== '') {\r\n                if (record.status == 1) {\r\n                    label = '<span class=\"grid-severity-notice\"><span>' + label + '</span></span>';\r\n                } else {\r\n                    label = '<span class=\"grid-severity-minor\"><span>' + label + '</span></span>';\r\n                }\r\n            }\r\n\r\n            return label;\r\n        }\r\n    });\r\n});\r\n\r\n","Mageplaza_Smtp/js/grid/columns/actions.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Mageplaza.com license sliderConfig is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Smtp\n * @copyright   Copyright (c) Mageplaza (http://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/grid/columns/actions',\n    'Magento_Ui/js/modal/modal'\n], function ($, Column) {\n    'use strict';\n\n    function strip(html){\n        var doc = new DOMParser().parseFromString(html, 'text/html');\n\n        return doc.body.textContent || \"\";\n    }\n\n    return Column.extend({\n        modal: {},\n\n        /**\n         * @inheritDoc\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (actionIndex !== 'view') {\n                return this._super();\n            }\n\n            if (typeof this.modal[action.rowIndex] === 'undefined' || typeof this.modal[action.rowIndex] === 'object') {\n                var row = this.rows[action.rowIndex],\n                    modalHtml = '<iframe srcdoc=\"' + row['email_content'] + '\" style=\"width: 100%; height: 100%\"></iframe>';\n\n                this.modal[action.rowIndex] = $('<div>')\n                    .html(modalHtml)\n                    .modal({\n                        type: 'slide',\n                        title: strip(row['subject']),\n                        modalClass: 'mpsmtp-modal-email',\n                        innerScroll: true,\n                        buttons: []\n                    });\n            }\n\n            this.modal[action.rowIndex].trigger('openModal');\n        }\n    });\n});\n\n","Magento_Theme/js/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * @param {*} selected\n     * @param {Object} defaultsById\n     */\n    function parentThemeOnChange(selected, defaultsById) {\n        var statusBar = $$('.tab-item-link')[0],\n            isChanged = statusBar.hasClassName('changed'),\n            defaults;\n\n        if (!isChanged) {\n            defaults = defaultsById[selected];\n            $('theme_title').value = defaults['theme_title'];\n        }\n    }\n\n    window.parentThemeOnChange = parentThemeOnChange;\n});\n","Magento_Theme/js/custom-js-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('theme.themeJsList', {\n        options: {\n            templateId: null,\n            emptyTemplateId: null,\n            refreshFileListEvent: null,\n            prefixItemId: '',\n            suffixItemId: ''\n        },\n\n        /**\n         * Initialize widget\n         *\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind event handlers\n         *\n         * @protected\n         */\n        _bind: function () {\n            $('body').on(this.options.refreshFileListEvent, $.proxy(this._onRefreshList, this));\n        },\n\n        /**\n         * Render js files list\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @protected\n         */\n        _onRefreshList: function (event, data) {\n            $(this.element).html('');\n\n            if (data.jsList.length) {\n                this._renderList(data.jsList);\n            } else {\n                this._renderEmptyList();\n            }\n        },\n\n        /**\n         * Get item js list id\n         *\n         * @param {*} fileId\n         * @return {String}\n         * @protected\n         */\n        _getItemId: function (fileId) {\n            return this.options.prefixItemId + fileId + this.options.suffixItemId;\n        },\n\n        /**\n         * Render js list\n         *\n         * @param {Array} jsList\n         * @protected\n         */\n        _renderList: function (jsList) {\n            var itemTmpl,\n                index,\n                tmpl;\n\n            for (index = 0; index < jsList.length; index++) {\n                itemTmpl = $('<li></li>').html($(this.options.templateId).html());\n\n                $(itemTmpl).attr('class', $(this.options.templateId).attr('class'));\n\n                itemTmpl.attr('id', this._getItemId(jsList[index].id));\n\n                tmpl = mageTemplate(itemTmpl.html(), {\n                    data: jsList[index]\n                });\n\n                itemTmpl.html(tmpl);\n\n                itemTmpl.removeClass('no-display');\n                itemTmpl.appendTo(this.element);\n            }\n        },\n\n        /**\n         * Set empty js list\n         *\n         * @protected\n         */\n        _renderEmptyList: function () {\n            var itemTmpl = $('<li></li>').html($(this.options.emptyTemplateId).html());\n\n            $(itemTmpl).attr('class', $(this.options.emptyTemplateId).attr('class'));\n\n            itemTmpl.attr('id', 'empty-js-list');\n            itemTmpl.removeClass('no-display');\n            itemTmpl.appendTo(this.element);\n        }\n    });\n});\n","Magento_Theme/js/bootstrap.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery/fileUploader/jquery.fileupload-ui',\n    'mage/adminhtml/browser',\n    'Magento_Theme/js/form'\n]);\n","Magento_Theme/js/sortable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.sortable'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Widget panel\n     */\n    $.widget('mage.sortable', $.ui.sortable, {\n        options: {\n            moveUpEvent:   'moveUp',\n            moveDownEvent: 'moveDown'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this.initButtons();\n            this.bind();\n        },\n\n        /**\n         * Init buttons.\n         */\n        initButtons: function () {\n            this.element.find('input.up').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveUpEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n            this.element.find('input.down').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveDownEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n        },\n\n        /**\n         * Bind.\n         */\n        bind: function () {\n            var $body = $('body');\n\n            $body.on(this.options.moveUpEvent, $.proxy(this._onMoveUp, this));\n            $body.on(this.options.moveDownEvent, $.proxy(this._onMoveDown, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveUp: function (event, data) {\n            data.item.insertBefore(data.item.prev());\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveDown: function (event, data) {\n            data.item.insertAfter(data.item.next());\n        }\n    });\n\n    return $.mage.sortable;\n});\n","Magento_Theme/js/form/component/robots-reset-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry'\n], function (Button, registry) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            customInstructionField: '${ $.parentName }.custom_instructions',\n            label: '',\n            buttonTpl: 'Magento_Theme/form/element/button'\n        },\n\n        /**\n         * @private\n         * @param {String} json\n         * @return {String}\n         */\n        _parseJson: function (json) {\n            return JSON.parse(json);\n        },\n\n        /**\n         * @param {String} defaultRobotsTxt\n         */\n        reset: function (defaultRobotsTxt) {\n            var customInstructions = registry.get(this.customInstructionField);\n\n            if (customInstructions) {\n                customInstructions.set('value', this._parseJson(defaultRobotsTxt));\n            }\n        }\n    });\n});\n","Magento_AdvancedSearch/js/testconnection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.testConnection', {\n        options: {\n            url: '',\n            elementId: '',\n            successText: '',\n            failedText: '',\n            fieldMapping: ''\n        },\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this._on({\n                'click': $.proxy(this._connect, this)\n            });\n        },\n\n        /**\n         * Method triggers an AJAX request to check search engine connection\n         * @private\n         */\n        _connect: function () {\n            var result = this.options.failedText,\n                element =  $('#' + this.options.elementId),\n                self = this,\n                params = {},\n                msg = '',\n                fieldToCheck = this.options.fieldToCheck || 'success';\n\n            element.removeClass('success').addClass('fail');\n            $.each(JSON.parse(this.options.fieldMapping), function (key, el) {\n                params[key] = $('#' + el).val();\n            });\n            $.ajax({\n                url: this.options.url,\n                showLoader: true,\n                data: params,\n                headers: this.options.headers || {}\n            }).done(function (response) {\n                if (response[fieldToCheck]) {\n                    element.removeClass('fail').addClass('success');\n                    result = self.options.successText;\n                } else {\n                    msg = response.errorMessage;\n\n                    if (msg) {\n                        alert({\n                            content: msg\n                        });\n                    }\n                }\n            }).always(function () {\n                $('#' + self.options.elementId + '_result').text(result);\n            });\n        }\n    });\n\n    return $.mage.testConnection;\n});\n","Magento_ReleaseNotification/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Modal, alert, $t) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            imports: {\n                logAction:  '${ $.provider }:data.logAction'\n            }\n        },\n\n        /**\n         * Error handler.\n         *\n         * @param {Object} xhr - request result.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            alert({\n                content: xhr.message || $t('An error occurred while logging process.')\n            });\n        },\n\n        /**\n         * Log release notes show\n         */\n        logReleaseNotesShow: function () {\n            var self = this,\n                data = {\n                    'form_key': window.FORM_KEY\n                };\n\n            $.ajax({\n                type: 'POST',\n                url: this.logAction,\n                data: data,\n                showLoader: true\n            }).done(function (xhr) {\n                if (xhr.error) {\n                    self.onError(xhr);\n                }\n            }).fail(this.onError);\n        },\n\n        /**\n         * Close release notes\n         */\n        closeReleaseNotes: function () {\n            this.logReleaseNotesShow();\n            this.closeModal();\n        }\n    });\n});\n","Magento_Shipping/js/packages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return function (config, element) {\n        config.buttons = [\n            {\n                text: $t('Print'),\n                'class': 'action action-primary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    window.location.href = this.options.url;\n                }\n            }, {\n                text: $t('Cancel'),\n                'class': 'action action-secondary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }\n        ];\n        modal(config, element);\n    };\n});\n","Magento_Shipping/order/packaging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['prototype'], function () {\n\n    window.Packaging = Class.create();\n    Packaging.prototype = {\n        /**\n         * Initialize object\n         */\n        initialize: function (params) {\n            this.packageIncrement = 0;\n            this.packages = [];\n            this.itemsAll = [];\n            this.createLabelUrl = params.createLabelUrl ? params.createLabelUrl : null;\n            this.itemsGridUrl = params.itemsGridUrl ? params.itemsGridUrl : null;\n            this.errorQtyOverLimit = params.errorQtyOverLimit;\n            this.titleDisabledSaveBtn = params.titleDisabledSaveBtn;\n            this.window = $('packaging_window');\n            this.messages = this.window.select('.message-warning')[0];\n            this.packagesContent = $('packages_content');\n            this.template = $('package_template');\n            this.paramsCreateLabelRequest = {};\n            this.validationErrorMsg = params.validationErrorMsg;\n\n            this.defaultItemsQty            = params.shipmentItemsQty ? params.shipmentItemsQty : null;\n            this.defaultItemsPrice          = params.shipmentItemsPrice ? params.shipmentItemsPrice : null;\n            this.defaultItemsName           = params.shipmentItemsName ? params.shipmentItemsName : null;\n            this.defaultItemsWeight         = params.shipmentItemsWeight ? params.shipmentItemsWeight : null;\n            this.defaultItemsProductId      = params.shipmentItemsProductId ? params.shipmentItemsProductId : null;\n            this.defaultItemsOrderItemId    = params.shipmentItemsOrderItemId ? params.shipmentItemsOrderItemId : null;\n\n            this.shippingInformation = params.shippingInformation ? params.shippingInformation : null;\n            this.thisPage           = params.thisPage ? params.thisPage : null;\n            this.customizableContainers = params.customizable ? params.customizable : [];\n\n            this.eps = 0.000001;\n        },\n\n        /**\n         * Get Package Id\n         */\n        getPackageId: function (packageBlock) {\n            return packageBlock.id.match(/\\d{0,}$/)[0];\n        },\n\n        //******************** Setters **********************************//\n        setLabelCreatedCallback: function (callback) {\n            this.labelCreatedCallback = callback;\n        },\n        setCancelCallback: function (callback) {\n            this.cancelCallback = callback;\n        },\n        setConfirmPackagingCallback: function (callback) {\n            this.confirmPackagingCallback = callback;\n        },\n        setItemQtyCallback: function (callback) {\n            this.itemQtyCallback = callback;\n        },\n        setCreateLabelUrl: function (url) {\n            this.createLabelUrl = url;\n        },\n        setParamsCreateLabelRequest: function (params) {\n            Object.extend(this.paramsCreateLabelRequest, params);\n        },\n        //******************** End Setters *******************************//\n\n        showWindow: function () {\n            if (this.packagesContent.childElements().length == 0) {\n                this.newPackage();\n            }\n            const allowedPackageTypes = [\"N\",\"D\"];\n\n            if (!Object.values(this.customizableContainers).some(packageType => allowedPackageTypes.includes(packageType))) {\n                $('packaging_window').select(\n                    'th.col-length,th.col-width,th.col-height'\n                ).forEach(element => {\n                    element.classList.remove('_required')\n                });\n            }\n            jQuery(this.window).modal('openModal');\n        },\n\n        cancelPackaging: function () {\n            if (Object.isFunction(this.cancelCallback)) {\n                this.cancelCallback();\n            }\n        },\n\n        confirmPackaging: function (params) {\n            if (Object.isFunction(this.confirmPackagingCallback)) {\n                this.confirmPackagingCallback();\n            }\n        },\n\n        checkAllItems: function (headCheckbox) {\n            $(headCheckbox).up('table').select('tbody input[type=\"checkbox\"]').each(function (checkbox) {\n                checkbox.checked = headCheckbox.checked;\n                this._observeQty.call(checkbox);\n            }.bind(this));\n        },\n\n        cleanPackages: function () {\n            this.packagesContent.update();\n            this.packages = [];\n            this.itemsAll = [];\n            this.packageIncrement = 0;\n            this._setAllItemsPackedState();\n            this.messages.hide().update();\n        },\n\n        sendCreateLabelRequest: function () {\n            var self = this;\n\n            if (!this.validate()) {\n                this.messages.show().update(this.validationErrorMsg);\n\n                return;\n            }\n            this.messages.hide().update();\n\n            if (this.createLabelUrl) {\n                var weight, length, width, height = null;\n                var packagesParams = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    weight = parseFloat(pack.select('input[name=\"container_weight\"]')[0].value);\n                    length = parseFloat(pack.select('input[name=\"container_length\"]')[0].value);\n                    width = parseFloat(pack.select('input[name=\"container_width\"]')[0].value);\n                    height = parseFloat(pack.select('input[name=\"container_height\"]')[0].value);\n                    packagesParams[packageId] = {\n                        container:                  pack.select('select[name=\"package_container\"]')[0].value,\n                        customs_value:              parseFloat(pack.select('input[name=\"package_customs_value\"]')[0].value, 10),\n                        weight:                     isNaN(weight) ? '' : weight,\n                        length:                     isNaN(length) ? '' : length,\n                        width:                      isNaN(width) ? '' : width,\n                        height:                     isNaN(height) ? '' : height,\n                        weight_units:               pack.select('select[name=\"container_weight_units\"]')[0].value,\n                        dimension_units:            pack.select('select[name=\"container_dimension_units\"]')[0].value\n                    };\n\n                    if (isNaN(packagesParams[packageId]['customs_value'])) {\n                        packagesParams[packageId]['customs_value'] = 0;\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"package_size\"]')[0]) {\n                        if ('' != pack.select('select[name=\"package_size\"]')[0].value) {\n                            packagesParams[packageId]['size'] = pack.select('select[name=\"package_size\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('input[name=\"container_girth\"]')[0]) {\n                        if ('' != pack.select('input[name=\"container_girth\"]')[0].value) {\n                            packagesParams[packageId]['girth'] = pack.select('input[name=\"container_girth\"]')[0].value;\n                            packagesParams[packageId]['girth_dimension_units'] = pack.select('select[name=\"container_girth_dimension_units\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"content_type\"]')[0] && 'undefined' != typeof pack.select('input[name=\"content_type_other\"]')[0]) {\n                        packagesParams[packageId]['content_type'] = pack.select('select[name=\"content_type\"]')[0].value;\n                        packagesParams[packageId]['content_type_other'] = pack.select('input[name=\"content_type_other\"]')[0].value;\n                    } else {\n                        packagesParams[packageId]['content_type'] = '';\n                        packagesParams[packageId]['content_type_other'] = '';\n                    }\n                    var deliveryConfirmation = pack.select('select[name=\"delivery_confirmation_types\"]');\n\n                    if (deliveryConfirmation.length) {\n                        packagesParams[packageId]['delivery_confirmation'] =  deliveryConfirmation[0].value;\n                    }\n                }.bind(this));\n\n                for (var packageId in this.packages) {\n                    if (!isNaN(packageId)) {\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[container]']              = packagesParams[packageId]['container'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight]']                 = packagesParams[packageId]['weight'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[customs_value]']          = packagesParams[packageId]['customs_value'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[length]']                 = packagesParams[packageId]['length'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[width]']                  = packagesParams[packageId]['width'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[height]']                 = packagesParams[packageId]['height'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight_units]']           = packagesParams[packageId]['weight_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[dimension_units]']        = packagesParams[packageId]['dimension_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type]']           = packagesParams[packageId]['content_type'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type_other]']     = packagesParams[packageId]['content_type_other'];\n\n                        if ('undefined' != typeof packagesParams[packageId]['size']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[size]'] = packagesParams[packageId]['size'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['girth']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth]'] = packagesParams[packageId]['girth'];\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth_dimension_units]'] = packagesParams[packageId]['girth_dimension_units'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['delivery_confirmation']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[delivery_confirmation]']  = packagesParams[packageId]['delivery_confirmation'];\n                        }\n\n                        for (var packedItemId in this.packages[packageId]['items']) {\n                            if (!isNaN(packedItemId)) {\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][qty]']           = this.packages[packageId]['items'][packedItemId]['qty'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][customs_value]'] = this.packages[packageId]['items'][packedItemId]['customs_value'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][price]']         = self.defaultItemsPrice[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][name]']          = self.defaultItemsName[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][weight]']        = self.defaultItemsWeight[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][product_id]']    = self.defaultItemsProductId[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][order_item_id]'] = self.defaultItemsOrderItemId[packedItemId];\n                            }\n                        }\n                    }\n                }\n\n                new Ajax.Request(this.createLabelUrl, {\n                    parameters: this.paramsCreateLabelRequest,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.messages.show().innerHTML = response.message;\n                            } else if (response.ok && Object.isFunction(this.labelCreatedCallback)) {\n                                this.labelCreatedCallback(response);\n                            }\n                        }\n                    }.bind(this)\n                });\n\n                if (this.paramsCreateLabelRequest['code'] &&\n                    this.paramsCreateLabelRequest['carrier_title'] &&\n                    this.paramsCreateLabelRequest['method_title'] &&\n                    this.paramsCreateLabelRequest['price']\n                ) {\n                    var a = this.paramsCreateLabelRequest['code'];\n                    var b = this.paramsCreateLabelRequest['carrier_title'];\n                    var c = this.paramsCreateLabelRequest['method_title'];\n                    var d = this.paramsCreateLabelRequest['price'];\n\n                    this.paramsCreateLabelRequest = {};\n                    this.paramsCreateLabelRequest['code']           = a;\n                    this.paramsCreateLabelRequest['carrier_title']  = b;\n                    this.paramsCreateLabelRequest['method_title']   = c;\n                    this.paramsCreateLabelRequest['price']          = d;\n                } else {\n                    this.paramsCreateLabelRequest = {};\n                }\n            }\n        },\n\n        validate: function () {\n            var dimensionElements = $('packaging_window').select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],input[name=container_girth]:not(\"._disabled\")'\n            );\n            var callback = null;\n\n            if (dimensionElements.any(function (element) {\n                return !!element.value;\n            })) {\n                callback = function (element) {\n                    $(element).addClassName('required-entry');\n                };\n            } else {\n                callback = function (element) {\n                    $(element).removeClassName('required-entry');\n                };\n            }\n            dimensionElements.each(callback);\n\n            const allowedPackageTypes = [\"N\",\"D\"];\n\n            if (Object.values(this.customizableContainers).some(packageType => allowedPackageTypes.includes(packageType))) {\n                dimensionElements.each(function(element) {\n                    $(element).addClassName('required-entry');\n                });\n            }\n\n            return result = $$('[id^=\"package_block_\"]      input').collect(function (element) {\n                return this.validateElement(element);\n            }, this).all();\n        },\n\n        validateElement: function (elm) {\n            var cn = $w(elm.className);\n\n            return result = cn.all(function (value) {\n                var v = Validation.get(value);\n\n                if (Validation.isVisible(elm) && !v.test($F(elm), elm)) {\n                    $(elm).addClassName('validation-failed');\n\n                    return false;\n                }\n                $(elm).removeClassName('validation-failed');\n\n                return true;\n\n            });\n        },\n\n        validateCustomsValue: function () {\n            var items = [];\n            var isValid = true;\n            var itemsPrepare = [];\n            var itemsPacked = [];\n\n            this.packagesContent.childElements().each(function (pack) {\n                itemsPrepare = pack.select('[data-role=\"package-items\"]')[0];\n\n                if (itemsPrepare) {\n                    items = items.concat(itemsPrepare.select('.grid tbody tr'));\n                }\n                itemsPacked = pack.select('.package_items')[0];\n\n                if (itemsPacked) {\n                    items = items.concat(itemsPacked.select('.grid tbody tr'));\n                }\n            });\n\n            items.each(function (item) {\n                var itemCustomsValue = item.select('[name=\"customs_value\"]')[0];\n\n                if (!this.validateElement(itemCustomsValue)) {\n                    isValid = false;\n                }\n            }.bind(this));\n\n            if (isValid) {\n                this.messages.hide().update();\n            } else {\n                this.messages.show().update(this.validationErrorMsg);\n            }\n\n            return isValid;\n        },\n\n        newPackage: function () {\n            var pack = this.template.cloneNode(true);\n\n            pack.id = 'package_block_' + ++this.packageIncrement;\n            pack.addClassName('package-block');\n            pack.select('[data-role=package-number]')[0].update(this.packageIncrement);\n            this.packagesContent.insert({\n                top: pack\n            });\n            pack.select('[data-action=package-save-items]')[0].hide();\n            pack.show();\n        },\n\n        deletePackage: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId];\n            pack.remove();\n            this.messages.hide().update();\n            this._setAllItemsPackedState();\n        },\n\n        deleteItem: function (obj) {\n            var item = $(obj).up('tr');\n            var itemId = item.select('[type=\"checkbox\"]')[0].value;\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId]['items'][itemId];\n\n            if (item.offsetParent.rows.length <= 2) { /* head + this last row */\n                $(packItems).hide();\n            }\n            item.remove();\n            this.messages.hide().update();\n            this._recalcContainerWeightAndCustomsValue(packItems);\n            this._setAllItemsPackedState();\n        },\n\n        recalcContainerWeightAndCustomsValue: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n\n            if (packItems) {\n                if (!this.validateCustomsValue()) {\n                    return;\n                }\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            }\n        },\n\n        getItemsForPack: function (obj) {\n            if (this.itemsGridUrl) {\n                var parameters = $H({\n                    'shipment_id': this.shipmentId\n                });\n                var packageBlock = $(obj).up('[id^=\"package_block\"]');\n                var packagePrapare = packageBlock.select('[data-role=package-items]')[0];\n                var packagePrapareGrid = packagePrapare.select('.grid_prepare')[0];\n\n                new Ajax.Request(this.itemsGridUrl, {\n                    parameters: parameters,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response) {\n                            packagePrapareGrid.update(response);\n                            this.processPackagePrepare(packagePrapareGrid);\n\n                            if (packagePrapareGrid.select('.grid tbody tr').length) {\n                                packageBlock.select('[data-action=package-add-items]')[0].hide();\n                                packageBlock.select('[data-action=package-save-items]')[0].show();\n                                packagePrapare.show();\n                            } else {\n                                packagePrapareGrid.update();\n                            }\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        getPackedItemsQty: function () {\n            var items = [];\n\n            for (var packageId in this.packages) {\n                if (!isNaN(packageId)) {\n                    for (var packedItemId in this.packages[packageId]['items']) {\n                        if (!isNaN(packedItemId)) {\n                            if (items[packedItemId]) {\n                                items[packedItemId] += this.packages[packageId]['items'][packedItemId]['qty'];\n                            } else {\n                                items[packedItemId] = this.packages[packageId]['items'][packedItemId]['qty'];\n                            }\n                        }\n                    }\n                }\n            }\n\n            return items;\n        },\n\n        _parseQty: function (obj) {\n            var qty = $(obj).hasClassName('qty-decimal') ? parseFloat(obj.value) : parseInt(obj.value);\n\n            if (isNaN(qty) || qty <= 0) {\n                qty = 1;\n            }\n\n            return qty;\n        },\n\n        packItems: function (obj) {\n            var anySelected = false;\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var packagePrepare = packageBlock.select('[data-role=package-items]')[0];\n            var packagePrepareGrid = packagePrepare.select('.grid_prepare')[0];\n\n            // check for exceeds the total shipped quantity\n            var checkExceedsQty = false;\n\n            this.messages.hide().update();\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n                var itemId = checkbox.value;\n                var qtyValue  = this._parseQty(item.select('[name=\"qty\"]')[0]);\n\n                item.select('[name=\"qty\"]')[0].value = qtyValue;\n\n                if (checkbox.checked && this._checkExceedsQty(itemId, qtyValue)) {\n                    this.messages.show().update(this.errorQtyOverLimit);\n                    checkExceedsQty = true;\n                }\n            }.bind(this));\n\n            if (checkExceedsQty) {\n                return;\n            }\n\n            if (!this.validateCustomsValue()) {\n                return;\n            }\n\n            // prepare items for packing\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n\n                if (checkbox.checked) {\n                    var qty  = item.select('[name=\"qty\"]')[0];\n                    var qtyValue  = this._parseQty(qty);\n\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                    anySelected = true;\n                    qty.disabled = 'disabled';\n                    checkbox.disabled = 'disabled';\n                    packagePrepareGrid.select('.grid th [type=\"checkbox\"]')[0].up('th label').hide();\n                    item.select('[data-action=package-delete-item]')[0].show();\n                } else {\n                    item.remove();\n                }\n            }.bind(this));\n\n            // packing items\n            if (anySelected) {\n                var packItems = packageBlock.select('.package_items')[0];\n\n                if (!packItems) {\n                    packagePrepare.insert(new Element('div').addClassName('grid_prepare'));\n                    packagePrepare.insert({\n                        after: packagePrepareGrid\n                    });\n                    packItems = packagePrepareGrid.removeClassName('grid_prepare').addClassName('package_items');\n                    packItems.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]) {\n                            this.packages[packageId] = {\n                                'items': [], 'params': {}\n                            };\n                        }\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                        }\n                    }.bind(this));\n                } else {\n                    packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                            packItems.select('.grid tbody')[0].insert(item);\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                            var packItem = packItems.select('[type=\"checkbox\"][value=\"' + itemId + '\"]')[0].up('tr').select('[name=\"qty\"]')[0];\n\n                            packItem.value = this.packages[packageId]['items'][itemId]['qty'];\n                        }\n                    }.bind(this));\n                    packagePrepareGrid.update();\n                }\n                $(packItems).show();\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            } else {\n                packagePrepareGrid.update();\n            }\n\n            // show/hide disable/enable\n            packagePrepare.hide();\n            packageBlock.select('[data-action=package-save-items]')[0].hide();\n            packageBlock.select('[data-action=package-add-items]')[0].show();\n            this._setAllItemsPackedState();\n        },\n\n        validateItemQty: function (itemId, qty) {\n            return this.defaultItemsQty[itemId] < qty ? this.defaultItemsQty[itemId] : qty;\n        },\n\n        changeMeasures: function (obj) {\n            var incr = 0;\n            var incrSelected = 0;\n\n            obj.childElements().each(function (option) {\n                if (option.selected) {\n                    incrSelected = incr;\n                }\n                incr++;\n            });\n\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n\n            packageBlock.select('.measures').each(function (item) {\n                if (item.name != obj.name) {\n                    var incr = 0;\n\n                    item.select('option').each(function (option) {\n                        if (incr == incrSelected) {\n                            item.value = option.value;\n                            //option.selected = true\n                        }\n                        incr++;\n                    });\n                }\n            });\n\n        },\n\n        checkSizeAndGirthParameter: function (obj, enabled) {\n            if (enabled == 0) {\n                return;\n            }\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            var packageSize = currentNode.select('select[name=package_size]');\n            var packageContainer = currentNode.select('select[name=package_container]');\n            var packageGirth = currentNode.select('input[name=container_girth]');\n            var packageGirthDimensionUnits = currentNode.select('select[name=container_girth_dimension_units]');\n\n            if (packageSize.length <= 0) {\n                return;\n            }\n\n            var girthEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'VARIABLE';\n\n            if (!girthEnabled) {\n                packageGirth[0].value = '';\n                packageGirth[0].disable();\n                packageGirth[0].addClassName('_disabled');\n                packageGirthDimensionUnits[0].disable();\n                packageGirthDimensionUnits[0].addClassName('_disabled');\n            } else {\n                packageGirth[0].enable();\n                packageGirth[0].removeClassName('_disabled');\n                packageGirthDimensionUnits[0].enable();\n                packageGirthDimensionUnits[0].removeClassName('_disabled');\n            }\n\n            var sizeEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'RECTANGULAR' ||\n                packageContainer[0].value == 'VARIABLE';\n\n            if (!sizeEnabled) {\n                option = document.createElement('OPTION');\n                option.value = '';\n                option.text = '';\n                packageSize[0].options.add(option);\n                packageSize[0].value = '';\n                packageSize[0].disable();\n                packageSize[0].addClassName('_disabled');\n            } else {\n                for (i = 0; i < packageSize[0].length; i++) {\n                    if (packageSize[0].options[i].value == '') {\n                        packageSize[0].removeChild(packageSize[0].options[i]);\n                    }\n                }\n                packageSize[0].enable();\n                packageSize[0].removeClassName('_disabled');\n            }\n        },\n\n        changeContainerType: function (obj) {\n            if (this.customizableContainers.length <= 0) {\n                return;\n            }\n\n            var disable = true;\n\n            for (var i in this.customizableContainers) {\n                if (this.customizableContainers[i] == obj.value) {\n                    disable = false;\n                    break;\n                }\n            }\n\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            $(currentNode).select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],select[name=container_dimension_units]'\n            ).each(function (inputElement) {\n                if (disable) {\n                    Form.Element.disable(inputElement);\n                    inputElement.addClassName('_disabled');\n\n                    if (inputElement.nodeName == 'INPUT') {\n                        $(inputElement).value = '';\n                    }\n                } else {\n                    Form.Element.enable(inputElement);\n                    inputElement.removeClassName('_disabled');\n                }\n            });\n        },\n\n        changeContentTypes: function (obj) {\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var contentType = packageBlock.select('[name=content_type]')[0];\n            var contentTypeOther = packageBlock.select('[name=content_type_other]')[0];\n\n            if (contentType.value == 'OTHER') {\n                Form.Element.enable(contentTypeOther);\n                contentTypeOther.removeClassName('_disabled');\n            } else {\n                Form.Element.disable(contentTypeOther);\n                contentTypeOther.addClassName('_disabled');\n            }\n\n        },\n\n        //******************** Private functions **********************************//\n        _getItemsCount: function (items) {\n            var count = 0;\n\n            items.each(function (itemCount) {\n                if (!isNaN(itemCount)) {\n                    count += parseFloat(itemCount);\n                }\n            });\n\n            return count;\n        },\n\n        /**\n         * Show/hide disable/enable buttons in case of all items packed state\n         */\n        _setAllItemsPackedState: function () {\n            var addPackageBtn = $$('[data-action=add-packages]')[0];\n            var savePackagesBtn = $$('[data-action=save-packages]')[0];\n\n            if (this._getItemsCount(this.itemsAll) > 0 &&\n                    this._checkExceedsQtyFinal(this._getItemsCount(this.getPackedItemsQty()), this._getItemsCount(this.itemsAll))\n            ) {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.disabled = 'disabled';\n                    button.addClassName('_disabled');\n                });\n                addPackageBtn.addClassName('_disabled');\n                Form.Element.disable(addPackageBtn);\n                savePackagesBtn.removeClassName('_disabled');\n                Form.Element.enable(savePackagesBtn);\n                savePackagesBtn.title = '';\n\n                // package number recalculation\n                var packagesRecalc = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    if (!pack.select('.package_items .grid tbody tr').length) {\n                        pack.remove();\n                    }\n                });\n                var packagesCount = this.packagesContent.childElements().length;\n\n                this.packageIncrement = packagesCount;\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    pack.id = 'package_block_' + packagesCount;\n                    pack.select('[data-role=package-number]')[0].update(packagesCount);\n                    packagesRecalc[packagesCount] = this.packages[packageId];\n                    --packagesCount;\n                }.bind(this));\n                this.packages = packagesRecalc;\n\n            } else {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.removeClassName('_disabled');\n                    Form.Element.enable(button);\n                });\n                addPackageBtn.removeClassName('_disabled');\n                Form.Element.enable(addPackageBtn);\n                savePackagesBtn.addClassName('_disabled');\n                Form.Element.disable(savePackagesBtn);\n                savePackagesBtn.title = this.titleDisabledSaveBtn;\n            }\n        },\n\n        processPackagePrepare: function (packagePrepare) {\n            var itemsAll = [],\n                qty,\n                itemId,\n                qtyValue = 0,\n                value = 1;\n\n            packagePrepare.select('.grid tbody tr').each(function (item) {\n                qty = item.select('[name=\"qty\"]')[0],\n                    itemId = item.select('[type=\"checkbox\"]')[0].value,\n                    qtyValue = parseFloat(qty.value);\n\n                if (Object.isFunction(this.itemQtyCallback)) {\n                    value = this.itemQtyCallback(itemId);\n\n                    if (typeof value !== 'undefined') {\n                        qtyValue = parseFloat(value);\n                        qtyValue = this.validateItemQty(itemId, qtyValue);\n                        qty.value = qtyValue;\n                    }\n                } else {\n                    value = item.select('[name=\"qty\"]')[0].value;\n                    qtyValue = typeof value == 'string' && value.length == 0 ? 0 : parseFloat(value);\n\n                    if (isNaN(qtyValue) || qtyValue < 0) {\n                        qtyValue = 1;\n                    }\n                }\n\n                if (qtyValue == 0) {\n                    item.remove();\n\n                    return;\n                }\n                var packedItems = this.getPackedItemsQty();\n\n                itemsAll[itemId] = qtyValue;\n\n                for (var packedItemId in packedItems) {\n                    if (!isNaN(packedItemId)) {\n                        var packedQty = packedItems[packedItemId];\n\n                        if (itemId == packedItemId) {\n                            if (qtyValue == packedQty || qtyValue <= packedQty) {\n                                item.remove();\n                            } else if (qtyValue > packedQty) {\n                                /* fix float number precision */\n                                qty.value = Number(Number(Math.round(qtyValue - packedQty + 'e+4') + 'e-4').toFixed(4));\n                            }\n                        }\n                    }\n                }\n            }.bind(this));\n\n            if (!this.itemsAll.length) {\n                this.itemsAll = itemsAll;\n            }\n\n            packagePrepare.select('tbody input[type=\"checkbox\"]').each(function (item) {\n                $(item).observe('change', this._observeQty);\n                this._observeQty.call(item);\n            }.bind(this));\n        },\n\n        _observeQty: function () {\n            /** this = input[type=\"checkbox\"] */\n            var tr  = jQuery(this).closest('tr')[0],\n                qty = $(tr.cells[tr.cells.length - 1]).select('input[name=\"qty\"]')[0];\n\n            if (qty.disabled = !this.checked) {\n                $(qty).addClassName('_disabled');\n            } else {\n                $(qty).removeClassName('_disabled');\n            }\n        },\n\n        _checkExceedsQty: function (itemId, qty) {\n            var packedItemQty = this.getPackedItemsQty()[itemId] ? this.getPackedItemsQty()[itemId] : 0;\n            var allItemQty = this.itemsAll[itemId];\n\n            return qty * (1 - this.eps) > allItemQty *  (1 + this.eps)  - packedItemQty * (1 - this.eps);\n        },\n\n        _checkExceedsQtyFinal: function (checkOne, defQty) {\n            return checkOne * (1 + this.eps) >= defQty * (1 - this.eps);\n        },\n\n        _recalcContainerWeightAndCustomsValue: function (container) {\n            var packageBlock = container.up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var containerWeight = packageBlock.select('[name=\"container_weight\"]')[0];\n            var containerCustomsValue = packageBlock.select('[name=\"package_customs_value\"]')[0];\n\n            containerWeight.value = 0;\n            containerCustomsValue.value = 0;\n            container.select('.grid tbody tr').each(function (item) {\n                var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                if (isNaN(qtyValue) || qtyValue <= 0) {\n                    qtyValue = 1;\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                }\n                var itemWeight = parseFloat(this._getElementText(item.select('[data-role=item-weight]')[0]));\n\n                containerWeight.value = parseFloat(containerWeight.value) + itemWeight * qtyValue;\n                var itemCustomsValue = parseFloat(item.select('[name=\"customs_value\"]')[0].value) || 0;\n\n                containerCustomsValue.value = parseFloat(containerCustomsValue.value) + itemCustomsValue * qtyValue;\n                this.packages[packageId]['items'][itemId]['customs_value'] = itemCustomsValue;\n            }.bind(this));\n            containerWeight.value = parseFloat(parseFloat(Math.round(containerWeight.value + 'e+4') + 'e-4').toFixed(4));\n            containerCustomsValue.value = parseFloat(Math.round(containerCustomsValue.value + 'e+2') + 'e-2').toFixed(2);\n\n            if (containerCustomsValue.value == 0) {\n                containerCustomsValue.value = '';\n            }\n        },\n\n        _getElementText: function (el) {\n            if ('string' == typeof el.textContent) {\n                return el.textContent;\n            }\n\n            if ('string' == typeof el.innerText) {\n                return el.innerText;\n            }\n\n            return el.innerHTML.replace(/<[^>]*>/g, '');\n        }\n        //******************** End Private functions ******************************//\n    };\n\n});\n","Magento_AdminAdobeIms/postcss.config.js":"module.exports = {\n    plugins: [\n        require('postcss-import'),\n        require('postcss-varfallback'),\n        require('postcss-dropunusedvars'),\n        require('cssnano')\n    ]\n};\n","Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_AdminAdobeIms/js/loadicons'\n], function ($, _, loadicons) {\n    'use strict';\n\n    var icons = {},\n\n    loadIcons = {\n        /**\n         * loadicons initialization\n         */\n        init: function () {\n            loadicons(icons.spectrumCssIcons);\n            loadicons(icons.spectrumIcons);\n        },\n\n        /**\n         * @param {Object} iconUrls\n         * @constructor\n         */\n        'Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons': function (iconUrls) {\n            icons = iconUrls;\n            loadIcons.init();\n        }\n    };\n\n    return loadIcons;\n});\n","Magento_AdminAdobeIms/js/adobe-ims-reauth.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_AdobeIms/js/action/authorization'\n], function (Component, $, login) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            loginConfig: {\n                url: 'https://ims-na1-stg.adobelogin.com/ims/authorize',\n                callbackParsingParams: {\n                    regexpPattern: /auth\\[code=(success|error);message=(.+)\\]/,\n                    codeIndex: 1,\n                    messageIndex: 2,\n                    nameIndex: 3,\n                    successCode: 'success',\n                    errorCode: 'error'\n                },\n                popupWindowParams: {\n                    width: 500,\n                    height: 600,\n                    top: 100,\n                    left: 300\n                },\n                popupWindowTimeout: 60000\n            }\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.login();\n        },\n\n        /**\n         * Open popup for Adobe reauth\n         *\n         * @return {window.Promise}\n         */\n        login: function () {\n            var deferred = $.Deferred(),\n                loginConfig = this.loginConfig;\n\n            $('input.ims_verification').on('click', function () {\n                login(loginConfig)\n                    .then(function (response) {\n                        if (response.isAuthorized === true) {\n                            $('input.ims_verified').val(true);\n                        }\n                        deferred.resolve(response);\n                    })\n                    .fail(function (error) {\n                        deferred.reject(error);\n                    });\n            });\n\n            return deferred.promise();\n        }\n    });\n});\n","Magento_AdminAdobeIms/js/loadicons.js":"/*\nCopyright 2018 Adobe. All rights reserved.\nThis file is licensed to you under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License. You may obtain a copy\nof the License at http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under\nthe License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS\nOF ANY KIND, either express or implied. See the License for the specific language\ngoverning permissions and limitations under the License.\n*/\n\n// UMD pattern via umdjs\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    // AMD\n    define([], factory);\n  }\n  else if (typeof module === 'object' && module.exports) {\n    // CommonJS-like\n    module.exports = factory();\n  }\n  else {\n    // Browser\n    root.loadIcons = factory();\n  }\n}(typeof self !== 'undefined' ? self : this, function() {\n  function handleError(string) {\n    string = 'loadIcons: '+string;\n    var error = new Error(string);\n\n    console.error(error.toString());\n\n    if (typeof callback === 'function') {\n      callback(error);\n    }\n  }\n\n  function injectSVG(svgURL, callback) {\n    var error;\n    // 200 for web servers, 0 for CEP panels\n    if (this.status !== 200 && this.status !== 0) {\n      handleError('Failed to fetch icons, server returned ' + this.status);\n      return;\n    }\n\n    // Parse the SVG\n    var parser = new DOMParser();\n    try {\n      var doc = parser.parseFromString(this.responseText, 'image/svg+xml');\n      var svg = doc.firstChild;\n    }\n    catch (err) {\n      handleError('Error parsing SVG: ' + err);\n      return;\n    }\n\n    // Make sure a real SVG was returned\n    if (svg && svg.tagName === 'svg') {\n      // Hide the element\n      svg.style.display = 'none';\n\n      svg.setAttribute('data-url', svgURL);\n\n      // Insert it into the head\n      document.head.insertBefore(svg, null);\n\n      // Pass the SVG to the callback\n      if (typeof callback === 'function') {\n        callback(null, svg);\n      }\n    }\n    else {\n      handleError('Parsed SVG document contained something other than an SVG');\n    }\n  }\n\n  function loadIcons(svgURL, callback) {\n    // Request the SVG sprite\n    var req = new XMLHttpRequest();\n    req.open('GET', svgURL, true);\n    req.addEventListener('load', injectSVG.bind(req, svgURL, callback));\n    req.addEventListener('error', function(event) {\n      handleError('Request failed');\n    });\n    req.send();\n  }\n\n  return loadIcons;\n}));\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_InventoryAdminUi/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.general.region'\n        },\n\n        /**\n         * Set region to source form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/dynamic-rows/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            cacheGridDataIndex: []\n        },\n\n        /**\n         * Performance optimization of setting initial property to records data of only first page\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            var startIndex,\n                stopIndex;\n\n            if (_.isArray(this.recordData())) {\n                startIndex = (~~this.currentPage() - 1) * this.pageSize;\n                stopIndex = startIndex + parseInt(this.pageSize, 10);\n                this.recordData.each(function (data, index) {\n                    if (index < stopIndex) {\n                        this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                    }\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Performance optimization of checking changed records\n         * skip when checks are not necessary\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                changes = [],\n                dataIndex = [],\n                changesIndex = [];\n\n            if (cacheLength === curData || cacheLength > curData) {\n                return [];\n            }\n\n            if (!cacheLength) {\n                return data;\n            }\n            data.forEach(function (record, index) {\n                dataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n            changesIndex = _.difference(dataIndex, this.cacheGridDataIndex);\n            changesIndex.forEach(function (changeIndex) {\n                data.forEach(function (record, index) {\n                    if (changeIndex === record[this.map[this.identificationDRProperty]]) {\n                        changes.push(data[index]);\n                    }\n                }, this);\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Performance optimization of processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            this._super(data);\n            data.forEach(function (record, index) {\n                this.cacheGridDataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/cell/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryAdminUi/stock/grid/cell/assigned-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index].map(function (source) {\n                return {\n                    sourceCode: source.sourceCode,\n                    name: source.name\n                };\n            });\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourcesAssignedToStockOrderedByPriority: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/components/fieldset.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'ko'\n], function (Fieldset, ko) {\n    'use strict';\n\n    /**\n     * TODO Remove when issue is resolved in core.\n     * @see Please check issue in core for more details: https://github.com/magento/magento2/issues/22067.\n     */\n    return Fieldset.extend(ko).extend(\n        {\n            /**\n             * Convert `visible` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var visible = this.visible;\n\n                this.visible = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return visible();\n                    },\n\n                    /**\n                     * @param {String} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n                        visible(value);\n                    },\n                    owner: this\n                });\n                this.visible(visible());\n            }\n        }\n    );\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/element/conditional-required.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'ko',\n    'underscore',\n    'mageUtils'\n], function (uiElement, ko, _, utils) {\n    'use strict';\n\n    /**\n     * Provide possibility to make field required by dependency on other field value.\n     */\n    return uiElement.extend(\n        {\n            /**\n             * Convert `required` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var required = this.required;\n\n                this.required = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return required();\n                    },\n\n                    /**\n                     * @param {String|Boolean} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n\n                        if (required() !== value) {\n                            required(value);\n                            this.setValidation('required-entry', required());\n                        }\n                    },\n                    owner: this\n                });\n                this.required(required());\n            },\n\n            /**\n             * @param {(String|Object)} rule\n             * @param {(Object|Boolean)} [options]\n             * @returns {Abstract} Chainable.\n             */\n            setValidation: function (rule, options) {\n                var rules = utils.copy(this.validation),\n                    changed;\n\n                if (_.isObject(rule)) {\n                    _.extend(this.validation, rule);\n                } else {\n                    this.validation[rule] = options;\n                }\n\n                changed = !utils.compare(rules, this.validation).equal;\n\n                if (changed) {\n                    this.required(!!this.validation['required-entry']);\n                    this.validate();\n                }\n\n                return this;\n            }\n        }\n    );\n});\n","PayPal_Braintree/js/system.js":"require(['jquery', 'Magento_Ui/js/modal/alert', 'mage/translate', 'domReady!'], function ($, alert, $t) {\n    function disablePayLaterMessages()\n    {\n        let merchantCountry = $('[data-ui-id=\"adminhtml-system-config-field-country-0-select-groups-account-fields-merchant-country-value\"]').val();\n        let payPalCredit = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-fields-braintree-paypal-credit-active-value\"]').val();\n        let cart = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-cart-fields-message-cart-enable-value\"]');\n        let product = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-checkout-fields-message-checkout-enable-value\"]')\n        let checkout = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-button-productpage-fields-message-productpage-enable-value\"]')\n        let allowedCountries = ['GB', 'FR', 'US', 'DE', 'AU'];\n\n        if($.inArray(merchantCountry, allowedCountries) === -1 || payPalCredit === 1){\n            //hide pay later message\n            cart.val(0).attr('readonly',true).click();\n            product.val(0).attr('readonly',true).click();\n            checkout.val(0).attr('readonly',true).click();\n        }\n        if (merchantCountry) {\n            if ( merchantCountry === 'GB') {\n                merchantCountry = 'UK'\n            }\n            cart.next().find('a').attr('href', cart.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            product.next().find('a').attr('href', product.next().find('a').attr('href') + merchantCountry.toLowerCase());\n            checkout.next().find('a').attr('href', checkout.next().find('a').attr('href') + merchantCountry.toLowerCase());\n        }\n\n    }\n\n    window.braintreeValidator = function (endpoint, environmentId, skip = false) {\n        environmentId = $('[data-ui-id=\"' + environmentId + '\"]').val();\n\n        let merchantId = '', publicId = '', privateId = '';\n\n        if (environmentId === 'sandbox') {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-sandbox-private-key-value\"]').val();\n        } else {\n            merchantId = $('[data-ui-id=\"text-groups-braintree-section-groups-braintree-groups-braintree-required-fields-merchant-id-value\"]').val();\n            publicId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-public-key-value\"]').val();\n            privateId = $('[data-ui-id=\"password-groups-braintree-section-groups-braintree-groups-braintree-required-fields-private-key-value\"]').val();\n        }\n\n        /* Remove previous success message if present */\n        if ($(\".braintree-credentials-success-message\")) {\n            $(\".braintree-credentials-success-message\").remove();\n        }\n\n        /* Basic field validation */\n        var errors = [];\n\n        if (!environmentId || environmentId !== 'sandbox' && environmentId !== 'production') {\n            errors.push($t(\"Please select an Environment\"));\n        }\n\n        if (!merchantId) {\n            errors.push($t(\"Please enter a Merchant ID\"));\n        }\n\n        if (!publicId) {\n            errors.push($t('Please enter a Public Key'));\n        }\n\n        if (!privateId) {\n            errors.push($t('Please enter a Private Key'));\n        }\n\n        if (errors.length > 0) {\n            alert({\n                title: $t('Braintree Credential Validation Failed'),\n                content:  errors.join('<br />')\n            });\n            return false;\n        }\n\n        $(this).text($t(\"We're validating your credentials...\")).attr('disabled', true);\n\n        var self = this;\n        $.ajax({\n            type: 'POST',\n            url: endpoint,\n            data: {\n                environment: environmentId,\n                merchant_id: merchantId,\n                public_key: publicId,\n                private_key: privateId\n            },\n            showLoader: true,\n            success: function (result) {\n                if (result.success === 'true') {\n                    if (skip === true) {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter($('.paypal-styling-buttons'));\n                    } else {\n                        $('<div class=\"message message-success braintree-credentials-success-message\">' + $t(\"Your credentials are valid.\") + '</div>').insertAfter(self);\n                    }\n                } else {\n                    alert({\n                        title: $t('Braintree Credential Validation Failed'),\n                        content: $t('Your Braintree Credentials could not be validated. Please ensure you have selected the correct environment and entered a valid Merchant ID, Public Key and Private Key.')\n                    });\n                }\n            }\n        }).always(function () {\n            $(self).text($t(\"Validate Credentials\")).attr('disabled', false);\n        });\n    };\n\n    window.applyForAll = function () {\n        let buttonShowStatus = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        let location = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').val();\n        let buttonType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-fields-paypal-location-' + location + '-button-type-value\"]').val();\n        buttonShowStatus = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-show-value\"]').val();\n        buttonLabel = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-label-value\"]').val();\n        buttonColor = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-color-value\"]').val();\n        buttonShape = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-shape-value\"]').val();\n        buttonSize = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + location + '-groups-button-location-' + location + '-type-' + buttonType + '-fields-button-location-' + location + '-type-' + buttonType + '-size-value\"]').val();\n\n        // pay later messaging styling field values\n        let messagingShow = $('.' + location + '-messaging-show').val();\n        let messagingLayout = $('.' + location + '-messaging-layout').val();\n        let messagingLogo = $('.' + location + '-messaging-logo').val();\n        let messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n        let messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // apply pay later messaging styling for all locations\n            $('.' + loc + '-messaging-show').val(messagingShow).click();\n            $('.' + loc + '-messaging-layout').val(messagingLayout).click();\n            $('.' + loc + '-messaging-logo').val(messagingLogo).click();\n            $('.' + loc + '-messaging-logo-position').val(messagingLogoPosition).click();\n            $('.' + loc + '-messaging-text-color').val(messagingTextColor).click();\n        });\n        $('#save').click();\n    };\n\n    window.resetAll = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        let buttonShowStatus = 1, buttonLabel = 'paypal', buttonColor = 'gold', buttonShape = 'rect', buttonSize = 'responsive';\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').val(buttonShowStatus).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').val(buttonLabel).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').val(buttonColor).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').val(buttonShape).click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').val(buttonSize).click();\n            });\n\n            // reset pay later messaging styling to recommended defaults\n            $('.' + loc + '-messaging-show').val(1).click();\n            $('.' + loc + '-messaging-layout').val('text').click();\n            $('.' + loc + '-messaging-logo').val('inline').click();\n            $('.' + loc + '-messaging-logo-position').val('left').click();\n            $('.' + loc + '-messaging-text-color').val('black').click();\n        });\n        $('#save').click();\n    };\n\n    window.applyButton = function () {\n        let locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n\n        locations.each(function (loc) {\n            buttonTypes.each(function (type) {\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-show-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-label-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-color-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-shape-value\"]').click();\n                $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-' + loc + '-groups-button-location-' + loc + '-type-' + type + '-fields-button-location-' + loc + '-type-' + type + '-size-value\"]').click();\n            });\n\n            // apply pay later messaging styling to current location\n            $('.' + loc + '-messaging-show').click();\n            $('.' + loc + '-messaging-layout').click();\n            $('.' + loc + '-messaging-logo').click();\n            $('.' + loc + '-messaging-logo-position').click();\n            $('.' + loc + '-messaging-text-color').click();\n        });\n        $('#save').click();\n    };\n\n    var locations = ['checkout', 'productpage', 'cart'];\n    hidePaypalSections();\n    $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]').change(function () {\n        hidePaypalSections();\n    });\n    locations.each(function (loc) {\n        $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+loc+'-fields-paypal-location-'+loc+'-button-type-value\"]').change(function () {\n            hidePaypalSections();\n        });\n    });\n\n    function hidePaypalSections() {\n        var mainLocation, merchantCountryIndex, mainType;\n        var locations = ['checkout', 'productpage', 'cart'], buttonTypes = ['paypal', 'paylater', 'credit'];\n        mainLocation = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-fields-payment-location-value\"]');\n        if (mainLocation.length < 1) {\n            return false;\n        }\n        merchantCountryIndex = mainLocation.attr('id').split('_')[1];\n        mainType = $('[data-ui-id=\"select-groups-braintree-section-groups-braintree-groups-braintree-paypal-groups-styling-groups-button-'+mainLocation.val()+'-fields-paypal-location-'+mainLocation.val()+'-button-type-value\"]');\n        locations.each(function (loc) {\n            $('#row_payment_' + merchantCountryIndex + '_braintree_section_braintree_braintree_paypal_styling_button_' + loc).hide();\n            buttonTypes.each(function (type) {\n                $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+loc+'_button_location_'+loc+'_type_' + type).hide();\n            });\n        });\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_'+mainLocation.val()+'_button_location_'+mainLocation.val()+'_type_' + mainType.val()).show();\n        $('#row_payment_'+merchantCountryIndex+'_braintree_section_braintree_braintree_paypal_styling_button_' + mainLocation.val()).show();\n    }\n    disablePayLaterMessages();\n});\n","PayPal_Braintree/js/virtual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $container: null,\n            container: 'payment_form_braintree',\n            braintree: null,\n            selectedCardType: null,\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$container = $('#' + self.container);\n            this._super()\n                .observe([\n                    'selectedCardType'\n                ]);\n\n            domObserver.get('#' + self.container, function () {\n                self.initBraintree();\n            });\n\n            return this;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        alert({\n                            content: $t('Please configure your Braintree Payments account in order to use the virtual terminal.')\n                        });\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.$container.on('takePayment', self.submitOrder.bind(self));\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            return {\n                number: {\n                    selector: this.getSelector('cc_number'),\n                    placeholder: $t('4111 1111 1111 1111')\n                },\n                expirationMonth: {\n                    selector: this.getSelector('cc_exp_month'),\n                    placeholder: $t('MM')\n                },\n                expirationYear: {\n                    selector: this.getSelector('cc_exp_year'),\n                    placeholder: $t('YY')\n                },\n                cvv: {\n                    selector: this.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                }\n            };\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n            $container.find('[name=\"payment_method_nonce\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function (event) {\n            event.preventDefault();\n\n            this.$container.validate().form();\n            this.$container.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$container.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$container.submit();\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    this.placeOrder();\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/paypalStylingPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'underscore',\n    'jquery',\n    'domReady!'\n], function (_, $) {\n    'use strict';\n    let buttonIds = [], currentButtonId = '';\n    let location = '', buttonType = '', buttonShow = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n    let messagingShow = '', messagingLayout = '', messagingLogo = '', messagingLogoPosition = '', messagingTextColor = '';\n\n    function getCurrentLocationAndButtonType()\n    {\n        location = $('.payment-location').val();\n        buttonType = $('.' + location + '-button-type').val();\n    }\n\n    $(document).ready(function () {\n        getCurrentLocationAndButtonType();\n\n        $('.payment-location').on('change', function (customEvent) {\n            location = $(this).val();\n            buttonType = $('.' + location + '-button-type').val();\n            buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n            buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n            buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n            buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n            buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n            updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n\n            // render pay later messages when location changed\n            messagingShow = $('.' + location + '-messaging-show').val();\n            messagingLayout = $('.' + location + '-messaging-layout').val();\n            messagingLogo = $('.' + location + '-messaging-logo').val();\n            messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n            messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n            renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n            customEvent.stopImmediatePropagation();\n        });\n\n        $(\"select\").change(function () {\n            $(document).on('change', '.' + location + '-button-type', function (customEvent) {\n                buttonType = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-show', function (customEvent) {\n                buttonShow = $(this).val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-label', function (customEvent) {\n                buttonLabel = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-color', function (customEvent) {\n                buttonColor = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-shape', function (customEvent) {\n                buttonShape = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-size', function (customEvent) {\n                buttonSize = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-show', function (customEvent) {\n                messagingShow = $(this).val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-layout', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $(this).val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $(this).val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo-position', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $(this).val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-text-color', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $(this).val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n        });\n    });\n\n    /**\n     * Update PayPal, Credit and Pay Later button styling if applicable\n     * @param location\n     * @param buttonType\n     * @param buttonShow\n     * @param buttonLabel\n     * @param buttonColor\n     * @param buttonShape\n     * @param buttonSize\n     */\n    let updatePayPalButtonStyling = function (location, buttonType, buttonShow, buttonLabel, buttonColor, buttonShape, buttonSize) {\n        $('.action-braintree-paypal-logo').each(function () {\n            if ($.inArray($(this).attr('id'), buttonIds) === -1) {\n                buttonIds.push($(this).attr('id'));\n            }\n        });\n\n        buttonIds.each(function (id) {\n            let result = id.startsWith(buttonType);\n            if (result === true) {\n                currentButtonId = id;\n            }\n        });\n\n        let currentButtonElement = $('#' + currentButtonId);\n        if (currentButtonElement.length) {\n            let style = {\n                color: buttonColor,\n                shape: buttonShape,\n                size: buttonSize,\n                label: buttonLabel\n            };\n            style.fundingicons = true;\n            let fundingSource = buttonType;\n\n            // Render\n            let button = paypal.Buttons({\n                fundingSource: fundingSource,\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not eligible');\n                currentButtonElement.parent().remove();\n                return;\n            }\n            if (currentButtonElement.length) {\n                currentButtonElement.empty();\n                if (buttonShow === '1') {\n                    button.render('#' + currentButtonElement.attr('id'));\n                }\n            }\n        }\n    };\n\n    /**\n     * Render and update Pay Later messaging style\n     * @param location\n     * @param messagingShow\n     * @param messagingLayout\n     * @param messagingLogo\n     * @param messagingLogoPosition\n     * @param messagingTextColor\n     */\n    let renderPayLaterMessages = function (location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor) {\n        $('.action-braintree-paypal-message').each(function () {\n            let messageElement = $('#' + $(this).attr('id'));\n\n            let payLaterMessageStyle = {\n                layout: messagingLayout,\n                text: {\n                    color: messagingTextColor\n                },\n                logo: {\n                    type: messagingLogo,\n                    position: messagingLogoPosition\n                }\n            };\n\n            let messageElementId = $(messageElement).attr('id');\n            let messageAmount = $(messageElement).data('pp-amount');\n            let parentElementId = messageElement.closest('tr').attr('id');\n\n            let messages = paypal.Messages({\n                amount: $(messageElement).data('pp-amount'),\n                pageType: location,\n                style: payLaterMessageStyle\n            });\n\n            if (messageElement.length) {\n                if (messagingShow === '1') {\n                    messageElement.remove();\n                    $('#' + parentElementId + ' td.value').append('<div class=\"action-braintree-paypal-message\" id=\"' + messageElementId + '\" data-pp-amount=\"' + messageAmount + '\" data-pp-type=\"' + location + '\" data-messaging-show=\"' + messagingShow + '\" data-messaging-layout=\"' + messagingLayout + '\" data-messaging-logo=\"' + messagingLogo + '\" data-messaging-logo-position=\"' + messagingLogoPosition + '\" data-messaging-text-color=\"' + messagingTextColor + '\"></div>');\n                    messages.render('#' + messageElementId);\n                } else {\n                    messageElement.hide();\n                }\n            }\n        });\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert'\n], function ($, Class, alert) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            $container: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            self.$selector = $('#' + self.selector);\n            self.$container =  $('#' + self.container);\n            self.$selector.on(\n                'setVaultNotActive.' + self.getCode(),\n                function () {\n                    self.$selector.off('submitOrder.' + self.getCode());\n                }\n            );\n            self._super();\n\n            self.initEventHandlers();\n\n            return self;\n        },\n\n        /**\n         * Get payment code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Init event handlers\n         */\n        initEventHandlers: function () {\n            $(this.$container).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.selectPaymentMethod.bind(this));\n        },\n\n        /**\n         * Select current payment token\n         */\n        selectPaymentMethod: function () {\n            this.disableEventListeners();\n            this.enableEventListeners();\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.' + this.getCode(), this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n        },\n\n        /**\n         * Pre submit for order\n         * @returns {Boolean}\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$selector.trigger('realOrder');\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            $('body').trigger('processStart');\n\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                self.setPaymentDetails(response.paymentMethodNonce);\n                self.placeOrder();\n            }).fail(function (response) {\n                var failed = JSON.parse(response.responseText);\n\n                self.error(failed.message);\n            }).always(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            this.createPublicHashSelector();\n\n            this.$selector.find('[name=\"payment[public_hash]\"]').val(this.publicHash);\n            this.$selector.find('[name=\"payment[payment_method_nonce]\"]').val(nonce).prop('disabled', false);\n        },\n\n        /**\n         * Creates public hash selector\n         */\n        createPublicHashSelector: function () {\n            var $input;\n\n            if (this.$selector.find('[name=\"payment[payment_method_nonce]\"]').length === 0) {\n                $input = $('<input>').attr(\n                    {\n                        type: 'hidden',\n                        id: this.getNonceSelectorName(),\n                        name: 'payment[payment_method_nonce]'\n                    }\n                );\n\n                $input.appendTo(this.$selector);\n                $input.prop('disabled', false);\n            }\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Get selector name for nonce input\n         * @returns {String}\n         */\n        getNonceSelectorName: function () {\n            return 'nonce_' + this.getCode();\n        }\n    });\n});\n","PayPal_Braintree/js/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_braintree',\n            active: false,\n            scriptLoaded: false,\n            braintree: null,\n            selectedCardType: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe([\n                    'active',\n                    'scriptLoaded',\n                    'selectedCardType'\n                ]);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            // listen block changes\n            domObserver.get('#' + self.container, function () {\n                if (self.scriptLoaded()) {\n                    self.$selector.off('submit');\n                    self.initBraintree();\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.off('submitOrder.braintree');\n                this.$selector.on('submitOrder', function () {\n                    $('#payment_form_braintree').find('[type=\"submit\"]').trigger('click');\n                    $('#edit_form').trigger('realOrder');\n                });\n\n                return;\n            }\n            this.disableEventListeners();\n\n            if (typeof window.order !== 'undefined') {\n                window.order.addExcludedPaymentMethod(this.code);\n            }\n\n            if (!this.clientToken) {\n                this.error($.mage.__('This payment is not available'));\n\n                return;\n            }\n\n            this.enableEventListeners();\n\n            if (!this.scriptLoaded()) {\n                this.initBraintree();\n            }\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n            this.scriptLoaded(true);\n\n            self.disableEventListeners();\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.enableEventListeners();\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('cc_exp_month'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('cc_exp_year'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.useCvv) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.braintree', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n\n            $container.find('[name=\"payment[payment_method_nonce]\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            $('#' + this.selector).trigger('realOrder');\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                           