/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
    "jquery",
    'mage/translate',
    'Magento_Ui/js/modal/alert',
    "jquery/validate", // Jquery Validation Library
    "jquery/ui",
    "mage/calendar",
], function ($, $t, alert) {
    'use strict';

    $.validator.addMethod(
        'validate-date-today',
        function (value) {
            var currentYear = new Date().getFullYear() + '';
            var v = value;
            var formattedDate = $.datepicker.formatDate('yy-mm-dd', new Date());
            var normalizedTime = function (v) {
                v = v.split(/[.\-]/);
                for (var i=0, len=v.length; i<len; i++) {
                    v[i] = parseInt(v[i]);
                }
                if (v[2] && v[2].length < 4) {
                    v[2] = currentYear.substr(0, v[2].length) + v[2];
                }
                return new Date(v.join('/')).getTime();
            };
            if (normalizedTime(v) < normalizedTime(formattedDate)) {
                return false;
            } else {
                return true;
            }

        },
        $.mage.__('Please enter today\'s date or future date.')
    );

    $.widget(
        'bookingsystem.bookingsystem',
        {
            options: {},
            _create: function () {
                var self = this;
                var dateFormat = "yy-mm-dd";

                var bookingDateFrom = $("#start_date").calendar({
                    showsTime: false,
                    hideIfNoPrevNext: true,
                    buttonText: "",
                    minDate: new Date(),
                    dateFormat: 'yy-mm-dd'
                }).on("change", function () {
                    bookingDateTo.datepicker("option", "minDate", getBookingDate(this));
                });
                var bookingDateTo = $("#end_date").calendar({
                    showsTime: false,
                    hideIfNoPrevNext: true,
                    buttonText: "",
                    minDate: new Date(),
                    dateFormat: 'yy-mm-dd'
                }).on("change", function () {
                    bookingDateFrom.datepicker("option", "maxDate", getBookingDate(this));
                });
                $(".wk-dec wk-obmd-h-dec").unbind("click");
                $(".wk-inc wk-obmd-h-inc").unbind("click");
                $(document).ready(
                    function () {
                        var startSelectHtml = self.options.startSelectHtml;
                        var endSelectHtml = self.options.endSelectHtml;
                        var selectCounts = self.options.selectCounts;
                        showBookingPanel();
                        manageRequiredFields();
                        $(document).on(
                            'change',
                            '#booking_type',
                            function () {
                                showBookingPanel();
                                manageRequiredFields();
                            }
                        );
                        
                        $(document).on(
                            'click',
                            '.wk-obmd-m-inc',
                            function () {
                                let MnVal1 = $(this).parent().find("input").val();
                                if ($(this).siblings('input[name$="[start_minute]"]').length) {
                                    let startHrVal = $(this).parents('.wk-time.start').find('.start-hour input').val();
                                    let endHrVal = $(this).parents('.wk-time.start').siblings('.wk-time.end').find('.end-hour input').val();
                                    let endMnVal = $(this).parents('.wk-time.start').siblings('.wk-time.end').find('.end-min input').val();
                                    if (parseInt(endHrVal) == parseInt(startHrVal)) {
                                        if (parseInt(MnVal1)+1 > parseInt(endMnVal)) {
                                            $(this).parent().find("input").val(MnVal1);
                                            alert({
                                                content: $t('Cannot increment value greater than end minute')
                                            });
                                        } else {
                                            if ($.isNumeric(MnVal1)) {
                                                MnVal1++;
                                            } else {
                                                MnVal1 = 0;
                                            }
                                            if (MnVal1 >= 60) {
                                                MnVal1 = 59;
                                            }
                                            $(this).parent().find("input").val(MnVal1);
                                        }
                                    } else {
                                        if ($.isNumeric(MnVal1)) {
                                            MnVal1++;
                                        } else {
                                            MnVal1 = 0;
                                        }
                                        if (MnVal1 >= 60) {
                                            MnVal1 = 59;
                                        }
                                        $(this).parent().find("input").val(MnVal1);
                                    }
                                } else {
                                    if ($.isNumeric(MnVal1)) {
                                        MnVal1++;
                                    } else {
                                        MnVal1 = 0;
                                    }
                                    if (MnVal1 >= 60) {
                                        MnVal1 = 59;
                                    }
                                    $(this).parent().find("input").val(MnVal1);
                                }
                            }
                        );
                        $(document).on(
                            'click',
                            '.wk-obmd-m-dec',
                            function () {
                                let MnVal1 = $(this).parent().find("input").val();
                                if ($(this).siblings('input[name$="[end_minute]"]').length) {
                                    let endHrVal = $(this).parents('.wk-time.end').find('.end-hour input').val();
                                    let startHrVal = $(this).parents('.wk-time.end').siblings('.wk-time.start').find('.start-hour input').val();
                                    let startMnVal = $(this).parents('.wk-time.end').siblings('.wk-time.start').find('.start-min input').val();
                                    if (parseInt(endHrVal) == parseInt(startHrVal)) {
                                        if (parseInt(MnVal1)-1 < parseInt(startMnVal)) {
                                            $(this).parent().find("input").val(MnVal1);
                                            alert({
                                                content: $t('Cannot decrement value less than start minute')
                                            });
                                        } else {
                                            if ($.isNumeric(MnVal1)) {
                                                MnVal1--;
                                            } else {
                                                MnVal1 = 0;
                                            }
                                            if (MnVal1 < 0) {
                                                MnVal1 = 0;
                                            }
                                            $(this).parent().find("input").val(MnVal1);
                                        }
                                    } else {
                                        if ($.isNumeric(MnVal1)) {
                                            MnVal1--;
                                        } else {
                                            MnVal1 = 0;
                                        }
                                        if (MnVal1 < 0) {
                                            MnVal1 = 0;
                                        }
                                        $(this).parent().find("input").val(MnVal1);
                                    }
                                } else {
                                    if ($.isNumeric(MnVal1)) {
                                        MnVal1--;
                                    } else {
                                        MnVal1 = 0;
                                    }
                                    if (MnVal1 < 0) {
                                        MnVal1 = 0;
                                    }
                                    $(this).parent().find("input").val(MnVal1);
                                }
                            }
                        );
                        $(document).on(
                            'click',
                            '.wk-obmd-h-inc',
                            function () {
                                let HrVal1 = $(this).parent().find("input").val();
                                if ($(this).siblings('input[name$="[start_hour]"]').length) {
                                    let HrVal2 = $(this).parents('.wk-time.start').siblings('.wk-time.end').find('.end-hour input').val();
                                    if (parseInt(HrVal1)+1 > parseInt(HrVal2)) {
                                        $(this).parent().find("input").val(HrVal1);
                                        alert({
                                            content: $t('Cannot increment value more than end hour')
                                        });
                                    } else if(parseInt(HrVal1)+1 == parseInt(HrVal2)) {
                                        let startMn = $(this).parents('.wk-time.start').find('.start-min input');
                                        let endMn = $(this).parents('.wk-time.start').siblings('.wk-time.end').find('.end-min input');
                                        if (parseInt(startMn.val()) > parseInt(endMn.val())) {
                                            startMn.val(0);
                                            endMn.val(0);
                                        }
                                        if ($.isNumeric(HrVal1)) {
                                            HrVal1++;
                                        } else {
                                            HrVal1 = 0;
                                        }
                                        if (HrVal1 > 24) {
                                            HrVal1 = 24;
                                        }
                                        $(this).parent().find("input").val(HrVal1);
                                    } else {
                                        if ($.isNumeric(HrVal1)) {
                                            HrVal1++;
                                        } else {
                                            HrVal1 = 0;
                                        }
                                        if (HrVal1 > 24) {
                                            HrVal1 = 24;
                                        }
                                        $(this).parent().find("input").val(HrVal1);
                                    }
                                } else {
                                    if ($.isNumeric(HrVal1)) {
                                        HrVal1++;
                                    } else {
                                        HrVal1 = 0;
                                    }
                                    if (HrVal1 > 24) {
                                        HrVal1 = 24;
                                    }
                                    $(this).parent().find("input").val(HrVal1);
                                }
                            }
                        );
                       
                        $(document).on(
                            'click',
                            '.wk-obmd-h-dec',
                            function () {
                                let HrVal1 = $(this).parent().find("input").val();
                                if ($(this).siblings('input[name$="[end_hour]"]').length) {
                                    let HrVal2 = $(this).parents('.wk-time.end').siblings('.wk-time.start').find('.start-hour input').val();
                                    if (parseInt(HrVal1)-1 < parseInt(HrVal2)) {
                                        $(this).parent().find("input").val(HrVal1);
                                        alert({
                                            content: $t('Cannot decrement value less than start hour')
                                        });
                                    } else if (parseInt(HrVal1)-1 == parseInt(HrVal2)) {
                                        let endMn = $(this).parents('.wk-time.end').find('.end-min input');
                                        let startMn = $(this).parents('.wk-time.end').siblings('.wk-time.start').find('.start-min input');
                                        if (parseInt(startMn.val()) > parseInt(endMn.val())) {
                                            startMn.val(0);
                                            endMn.val(0);
                                        }
                                        if ($.isNumeric(HrVal1)) {
                                            HrVal1--;
                                        } else {
                                            HrVal1 = 0;
                                        }
                                        if (HrVal1 < 0) {
                                            HrVal1 = 0;
                                        }
                                        $(this).parent().find("input").val(HrVal1);
                                    } else {
                                        if ($.isNumeric(HrVal1)) {
                                            HrVal1--;
                                        } else {
                                            HrVal1 = 0;
                                        }
                                        if (HrVal1 < 0) {
                                            HrVal1 = 0;
                                        }
                                        $(this).parent().find("input").val(HrVal1);
                                    }
                                } else {
                                    if ($.isNumeric(HrVal1)) {
                                        HrVal1--;
                                    } else {
                                        HrVal1 = 0;
                                    }
                                    if (HrVal1 < 0) {
                                        HrVal1 = 0;
                                    }
                                    $(this).parent().find("input").val(HrVal1);
                                }
                            }
                        );

                        $(document).on(
                            'input',
                            '.start-hour input',
                            function () {
                                let startHrVal = $(this).val();
                                let endHrVal = $(this).parents('.wk-time').siblings('.wk-time.end').find('.end-hour input').val();
                                if (parseInt(startHrVal) > parseInt(endHrVal)) {
                                    $(this).val(0);
                                    alert({
                                        content: $t('Please enter a value less than end hour')
                                    });
                                }
                                if (parseInt(startHrVal) < 0) {
                                    $(this).val(0);
                                    alert({
                                        content: $t('Please enter a value between 0 to '+endHrVal)
                                    });
                                }
                            }
                        );

                        $(document).on(
                            'input',
                            '.end-hour input',
                            function () {
                                let endHrVal = $(this).val();
                                let startHrVal = $(this).parents('.wk-time').siblings('.wk-time.start').find('.start-hour input').val();
                                if (parseInt(endHrVal) < parseInt(startHrVal)) {
                                    $(this).val(24);
                                    alert({
                                        content: $t('Please enter a value greater start hour')
                                    });
                                }
                                if (parseInt(endHrVal) > 24) {
                                    $(this).val(24);
                                    alert({
                                        content: $t('Please enter a value between '+startHrVal+' to 24')
                                    });
                                }
                            }
                        );

                        $(document).on(
                            'input',
                            '.start-min input',
                            function () {
                                let startMnVal = $(this).val();
                                let startHrVal = $(this).parents('.wk-time.start').find('.start-hour input').val();
                                let endMnVal = $(this).parents('.wk-time').siblings('.wk-time.end').find('.end-min input').val();
                                let endHrVal = $(this).parents('.wk-time').siblings('.wk-time.end').find('.end-hour input').val();
                                
                                if (parseInt(startHrVal) == parseInt(endHrVal)) {
                                    if (parseInt(startMnVal) > parseInt(endMnVal)) {
                                        $(this).val(0);
                                        alert({
                                            content: $t('Please enter a value less than end minute')
                                        });
                                    }
                                    if (parseInt(startMnVal) < 0) {
                                        $(this).val(0);
                                        alert({
                                            content: $t('Please enter a value between 0 to '+endMnVal)
                                        });
                                    }
                                }
                                if (parseInt(startMnVal) < 0 || parseInt(startMnVal) > 59) {
                                    $(this).val(0);
                                    alert({
                                        content: $t('Please enter a value between 0 to 59')
                                    });
                                } 
                            }
                        );

                        $(document).on(
                            'input',
                            '.end-min input',
                            function () {
                                let endMnVal = $(this).val();
                                let endHrVal = $(this).parents('.wk-time.end').find('.end-hour input').val();
                                let startMnVal = $(this).parents('.wk-time').siblings('.wk-time.start').find('.start-min input').val();
                                let startHrVal = $(this).parents('.wk-time').siblings('.wk-time.start').find('.start-hour input').val();
                                
                                if (parseInt(startHrVal) == parseInt(endHrVal)) {
                                    if (parseInt(startMnVal) > parseInt(endMnVal)) {
                                        $(this).val(59);
                                        alert({
                                            content: $t('Please enter a value greater than end minute')
                                        });
                                    }
                                    if (parseInt(endMnVal) > 59) {
                                        $(this).val(59);
                                        alert({
                                            content: $t('Please enter a value between '+startMnVal+' to 59')
                                        });
                                    }
                                }
                                if (parseInt(endMnVal) < 0 || parseInt(endMnVal) > 59) {
                                    $(this).val(0);
                                    alert({
                                        content: $t('Please enter a value between 0 to 59')
                                    });
                                }
                            }
                        );

                        $(document).on(
                            'click',
                            '.wk-btn',
                            function () {
                                selectCounts++;
                                var startHtml = $(startSelectHtml).attr("name", "info[start][day]["+selectCounts+"]");
                                var endHtml = $(endSelectHtml).attr("name", "info[end][day]["+selectCounts+"]");

                                var html = $('<div>', { class : 'wk-row wk-primary-row wk-text-center lll' });
                                html.append(
                                    $('<div>', { class : 'wk-one-booking-col' })
                                    .append(
                                        $('<div>', { class : 'wk-col-wrapper' })
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append(startHtml)
                                        )
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append('<input data-form-part="product_form" class="admin__control-text" readonly type="text" name="info[start][hour]['+selectCounts+']" value="1">')
                                            .append($('<div>', { class : 'wk-dec wk-obmd-h-dec', text : '-' }))
                                            .append($('<div>', { class : 'wk-inc wk-obmd-h-inc', text : '+' }))
                                        )
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append('<input data-form-part="product_form" class="admin__control-text" readonly type="text" name="info[start][minute]['+selectCounts+']" value="0">')
                                            .append($('<div>', { class : 'wk-dec wk-obmd-m-dec', text : '-' }))
                                            .append($('<div>', { class : 'wk-inc wk-obmd-m-inc', text : '+' }))
                                        )
                                    )
                                );
                                html.append(
                                    $('<div>', { class : 'wk-one-booking-col' })
                                    .append(
                                        $('<div>', { class : 'wk-col-wrapper' })
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append(endHtml)
                                        )
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append('<input data-form-part="product_form" class="admin__control-text" readonly type="text" name="info[end][hour]['+selectCounts+']" value="1">')
                                            .append($('<div>', { class : 'wk-dec wk-obmd-h-dec', text : '-' }))
                                            .append($('<div>', { class : 'wk-inc wk-obmd-h-inc', text : '+' }))
                                        )
                                        .append(
                                            $('<div>', { class : 'wk-input-col' })
                                            .append('<input data-form-part="product_form" class="admin__control-text" readonly type="text" name="info[end][minute]['+selectCounts+']" value="0">')
                                            .append($('<div>', { class : 'wk-dec wk-obmd-m-dec', text : '-' }))
                                            .append($('<div>', { class : 'wk-inc wk-obmd-m-inc', text : '+' }))
                                        )
                                    )
                                );
                                html.append(
                                    $('<div>', { class : 'wk-one-booking-remove-col wk-text-center' })
                                    .append('<div class="wk-remove wk-del"></div>')
                                );
                                $(".wk-one-booking-panel").append(html);
                            }
                        );
                        $(document).on(
                            'click',
                            '.wk-remove',
                            function () {
                                $(this).parent().parent().remove();
                            }
                        );
                    }
                );

                $(document).on(
                    "mouseenter",
                    "#start_date,#end_date",
                    function () {
                        $(this).removeClass("validate-date-today");
                        $(this).addClass("validate-date-today");
                    }
                );

                function showBookingPanel()
                {
                    var val = $('#booking_type').val();
                    if (val == 0) {
                        $(".wk-secondary-container").hide();
                        $("#wk-booking-type-holiday-msg").css('display','none');                      
                    } else if (val == 1) {
                        $(".wk-secondary-container").show();
                        $(".wk-one-booking-container").hide();
                        $("#wk-booking-type-holiday-msg").css('display','none');                      
                    } else {
                        $(".wk-secondary-container").show();
                        $(".wk-many-booking-container").hide();
                        $("#wk-booking-type-holiday-msg").css('display','block');
                    }
                }
                function manageRequiredFields()
                {
                    var val = $('#booking_type').val();
                    $(".wk-bs").removeClass("required-entry");
                    if (val == 1) {
                        $(".wk-bs").addClass("required-entry");
                    } else if (val == 2) {
                        $(".wk-bs").addClass("required-entry");
                        $(".wk-is").removeClass("required-entry");
                    }
                }

                function getBookingDate(element)
                {
                    var date;
                    try {
                        date = $.datepicker.parseDate(dateFormat, element.value);
                    } catch (error) {
                        date = null;
                    }
                    return date;
                }
            }
        }
    );
    return $.bookingsystem.bookingsystem;
});