require.config({"config": {
        "jsbuild":{"Magento_Sales/order/create/scripts.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n define([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    'text!Magento_Sales/templates/order/create/shipping/reload.html',\n    'text!Magento_Sales/templates/order/create/payment/reload.html',\n    'mage/translate',\n    'prototype',\n    'Magento_Catalog/catalog/product/composite/configure',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (jQuery, confirm, alert, template, shippingTemplate, paymentTemplate) {\n\n    window.AdminOrder = new Class.create();\n\n    AdminOrder.prototype = {\n        initialize: function (data) {\n            if (!data) data = {};\n            this.loadBaseUrl = false;\n            this.customerId = data.customer_id ? data.customer_id : false;\n            this.storeId = data.store_id ? data.store_id : false;\n            this.quoteId = data['quote_id'] ? data['quote_id'] : false;\n            this.currencyId = false;\n            this.currencySymbol = data.currency_symbol ? data.currency_symbol : '';\n            this.addresses = data.addresses ? data.addresses : $H({});\n            this.shippingAsBilling = data.shippingAsBilling ? data.shippingAsBilling : false;\n            this.gridProducts = $H({});\n            this.gridProductsGift = $H({});\n            this.billingAddressContainer = '';\n            this.shippingAddressContainer = '';\n            this.isShippingMethodReseted = data.shipping_method_reseted ? data.shipping_method_reseted : false;\n            this.overlayData = $H({});\n            this.giftMessageDataChanged = false;\n            this.productConfigureAddFields = {};\n            this.productPriceBase = {};\n            this.collectElementsValue = true;\n            this.isOnlyVirtualProduct = false;\n            this.excludedPaymentMethods = [];\n            this.summarizePrice = true;\n            this.selectAddressEvent = false;\n            this.shippingTemplate = template(shippingTemplate, {\n                data: {\n                    title: jQuery.mage.__('Shipping Method'),\n                    linkText: jQuery.mage.__('Get shipping methods and rates')\n                }\n            });\n            this.paymentTemplate = template(paymentTemplate, {\n                data: {\n                    title: jQuery.mage.__('Payment Method'),\n                    linkText: jQuery.mage.__('Get available payment methods')\n                }\n            });\n\n            jQuery.async('#order-items', (function () {\n                this.dataArea = new OrderFormArea('data', $(this.getAreaId('data')), this);\n                this.itemsArea = Object.extend(new OrderFormArea('items', $(this.getAreaId('items')), this), {\n                    addControlButton: function (button) {\n                        var controlButtonArea = $(this.node).select('.actions')[0];\n                        if (typeof controlButtonArea != 'undefined') {\n                            var buttons = controlButtonArea.childElements();\n                            for (var i = 0; i < buttons.length; i++) {\n                                if (buttons[i].innerHTML.include(button.getLabel())) {\n                                    return;\n                                }\n                            }\n                            button.insertIn(controlButtonArea, 'top');\n                        }\n                    }\n                });\n\n                var searchButtonId = 'add_products',\n                    searchButton = new ControlButton(jQuery.mage.__('Add Products'), searchButtonId),\n                    searchAreaId = this.getAreaId('search');\n                searchButton.onClick = function () {\n                    $(searchAreaId).show();\n                    var el = this;\n                    window.setTimeout(function () {\n                        el.remove();\n                    }, 10);\n                };\n\n                jQuery.async('#order-items .admin__page-section-title', (function () {\n                    this.dataArea.onLoad = this.dataArea.onLoad.wrap(function (proceed) {\n                        proceed();\n                        this._parent.itemsArea.setNode($(this._parent.getAreaId('items')));\n                        this._parent.itemsArea.onLoad();\n                    });\n\n                    this.itemsArea.onLoad = this.itemsArea.onLoad.wrap(function (proceed) {\n                        proceed();\n                        if ($(searchAreaId) && !jQuery('#' + searchAreaId).is(':visible') && !$(searchButtonId)) {\n                            this.addControlButton(searchButton);\n                        }\n                    });\n                    this.areasLoaded();\n                    this.itemsArea.onLoad();\n\n                }).bind(this));\n\n            }).bind(this));\n\n            jQuery('#edit_form')\n                .on('submitOrder', function () {\n                    jQuery(this).trigger('realOrder');\n                })\n                .on('realOrder', this._realSubmit.bind(this));\n        },\n\n        areasLoaded: function () {\n        },\n\n        itemsLoaded: function () {\n        },\n\n        dataLoaded: function () {\n            this.dataShow();\n        },\n\n        setLoadBaseUrl: function (url) {\n            this.loadBaseUrl = url;\n        },\n\n        setAddresses: function (addresses) {\n            this.addresses = addresses;\n        },\n\n        addExcludedPaymentMethod: function (method) {\n            this.excludedPaymentMethods.push(method);\n        },\n\n        setCustomerId: function (id) {\n            this.customerId = id;\n            this.loadArea('header', true);\n            $(this.getAreaId('header')).callback = 'setCustomerAfter';\n            $('back_order_top_button').hide();\n            $('reset_order_top_button').show();\n        },\n\n        setCustomerAfter: function () {\n            this.customerSelectorHide();\n            if (this.storeId) {\n                $(this.getAreaId('data')).callback = 'dataLoaded';\n                this.loadArea(['data'], true);\n            } else {\n                this.storeSelectorShow();\n            }\n        },\n\n        setStoreId: function (id) {\n            this.storeId = id;\n            this.storeSelectorHide();\n            this.sidebarShow();\n            //this.loadArea(['header', 'sidebar','data'], true);\n            this.dataShow();\n            this.loadArea(['header', 'data'], true);\n            location.reload();\n        },\n\n        setCurrencyId: function (id) {\n            this.currencyId = id;\n            //this.loadArea(['sidebar', 'data'], true);\n            this.loadArea(['data'], true);\n        },\n\n        setCurrencySymbol: function (symbol) {\n            this.currencySymbol = symbol;\n        },\n\n        selectAddress: function (el, container) {\n            var id = el.value;\n            if (id.length == 0) {\n                id = '0';\n            }\n\n            this.selectAddressEvent = true;\n            if (this.addresses[id]) {\n                this.fillAddressFields(container, this.addresses[id]);\n            } else {\n                this.fillAddressFields(container, {});\n            }\n            this.selectAddressEvent = false;\n\n            var data = this.serializeData(container);\n            data[el.name] = id;\n\n            this.resetPaymentMethod();\n            if (this.isShippingField(container) && !this.isShippingMethodReseted) {\n                this.resetShippingMethod(data);\n            } else {\n                this.saveData(data);\n            }\n        },\n\n        /**\n         * Checks if the field belongs to the shipping address.\n         *\n         * @param {String} fieldId\n         * @return {Boolean}\n         */\n        isShippingField: function (fieldId) {\n            if (this.shippingAsBilling) {\n                return fieldId.include('billing');\n            }\n\n            return fieldId.include('shipping');\n        },\n\n        /**\n         * Checks if the field belongs to the billing address.\n         *\n         * @param {String} fieldId\n         * @return {Boolean}\n         */\n        isBillingField: function (fieldId) {\n            return fieldId.include('billing');\n        },\n\n        /**\n         * Binds events on container form fields.\n         *\n         * @param {String} container\n         */\n        bindAddressFields: function (container) {\n            var fields = $(container).select('input', 'select', 'textarea'),\n                i;\n\n            for (i = 0; i < fields.length; i++) {\n                jQuery(fields[i]).change(this.changeAddressField.bind(this));\n            }\n        },\n\n        /**\n         * Triggers on each form's element changes.\n         *\n         * @param {Event} event\n         */\n        changeAddressField: function (event) {\n            var field = Event.element(event),\n                re = /[^\\[]*\\[([^\\]]*)_address\\]\\[([^\\]]*)\\](\\[(\\d)\\])?/,\n                matchRes = field.name.match(re),\n                type,\n                name,\n                data,\n                resetShipping = false;\n\n            if (!matchRes) {\n                return;\n            }\n\n            type = matchRes[1];\n            name = matchRes[2];\n\n            if (this.isBillingField(field.id)) {\n                data = this.serializeData(this.billingAddressContainer);\n            } else {\n                data = this.serializeData(this.shippingAddressContainer);\n            }\n            data = data.toObject();\n\n            if (type === 'billing' && this.shippingAsBilling) {\n                this.syncAddressField(this.shippingAddressContainer, field.name, field);\n                resetShipping = true;\n            }\n\n            if (type === 'shipping' && !this.shippingAsBilling) {\n                resetShipping = true;\n            }\n\n            if (resetShipping) {\n                data['reset_shipping'] = true;\n            }\n\n            if (name !== 'customer_address_id' && this.selectAddressEvent === false) {\n                if (this.shippingAsBilling) {\n                    $('order-shipping_address_customer_address_id').value = '';\n                }\n\n                $('order-' + type + '_address_customer_address_id').value = '';\n            }\n\n            data['order[' + type + '_address][customer_address_id]'] = null;\n            data['shipping_as_billing'] = +this.shippingAsBilling;\n\n            if (name === 'customer_address_id') {\n                data['order[' + type + '_address][customer_address_id]'] =\n                    $('order-' + type + '_address_customer_address_id').value;\n            }\n\n            if (name === 'country_id' && this.selectAddressEvent === false) {\n                $('order-' + type + '_address_customer_address_id').value = '';\n            }\n\n            this.resetPaymentMethod();\n\n            if (data['reset_shipping']) {\n                this.resetShippingMethod();\n            } else {\n                this.saveData(data);\n\n                if (name === 'country_id' || name === 'customer_address_id') {\n                    this.loadArea(['shipping_method', 'billing_method', 'totals', 'items'], true, data);\n                }\n            }\n        },\n\n        /**\n         * Set address container form field value.\n         *\n         * @param {String} container - container ID\n         * @param {String} fieldName - form field name\n         * @param {*} fieldValue - form field value\n         */\n        syncAddressField: function (container, fieldName, fieldValue) {\n            var syncName;\n\n            if (this.isBillingField(fieldName)) {\n                syncName = fieldName.replace('billing', 'shipping');\n            }\n\n            $(container).select('[name=\"' + syncName + '\"]').each(function (element) {\n                if (~['input', 'textarea', 'select'].indexOf(element.tagName.toLowerCase())) {\n                    if (element.type === \"checkbox\") {\n                        element.checked = fieldValue.checked;\n                    } else {\n                        element.value = fieldValue.value;\n                    }\n                }\n            });\n        },\n\n        fillAddressFields: function (container, data) {\n            var regionIdElem = false;\n            var regionIdElemValue = false;\n\n            var fields = $(container).select('input', 'select', 'textarea');\n            var re = /[^\\[]*\\[[^\\]]*\\]\\[([^\\]]*)\\](\\[(\\d)\\])?/;\n            for (var i = 0; i < fields.length; i++) {\n                // skip input type file @Security error code: 1000\n                if (fields[i].tagName.toLowerCase() == 'input' && fields[i].type.toLowerCase() == 'file') {\n                    continue;\n                }\n                var matchRes = fields[i].name.match(re);\n                if (matchRes === null) {\n                    continue;\n                }\n                var name = matchRes[1];\n                var index = matchRes[3];\n\n                if (index) {\n                    // multiply line\n                    if (data[name]) {\n                        var values = data[name].split(\"\\n\");\n                        fields[i].value = values[index] ? values[index] : '';\n                    } else {\n                        fields[i].value = '';\n                    }\n                } else if (fields[i].tagName.toLowerCase() == 'select' && fields[i].multiple) {\n                    // multiselect\n                    if (data[name]) {\n                        values = [''];\n                        if (Object.isString(data[name])) {\n                            values = data[name].split(',');\n                        } else if (Object.isArray(data[name])) {\n                            values = data[name];\n                        }\n                        fields[i].setValue(values);\n                    }\n                } else {\n                    fields[i].setValue(data[name] ? data[name] : '');\n                }\n\n                if (fields[i].changeUpdater) {\n                    fields[i].changeUpdater();\n                }\n\n                if (name == 'region' && data['region_id'] && !data['region']) {\n                    fields[i].value = data['region_id'];\n                }\n\n                jQuery(fields[i]).trigger('change');\n            }\n        },\n\n        disableShippingAddress: function (flag) {\n            this.shippingAsBilling = flag;\n            if ($('order-shipping_address_customer_address_id')) {\n                $('order-shipping_address_customer_address_id').disabled = flag;\n            }\n            if ($(this.shippingAddressContainer)) {\n                var dataFields = $(this.shippingAddressContainer).select('input', 'select', 'textarea');\n                for (var i = 0; i < dataFields.length; i++) {\n                    dataFields[i].disabled = flag;\n\n                    if (this.isOnlyVirtualProduct) {\n                        dataFields[i].setValue('');\n                    }\n                }\n                var buttons = $(this.shippingAddressContainer).select('button');\n                // Add corresponding class to buttons while disabling them\n                for (i = 0; i < buttons.length; i++) {\n                    buttons[i].disabled = flag;\n                    if (flag) {\n                        buttons[i].addClassName('disabled');\n                    } else {\n                        buttons[i].removeClassName('disabled');\n                    }\n                }\n            }\n        },\n\n        /**\n         * Equals shipping and billing addresses.\n         *\n         * @param {Boolean} flag\n         */\n        setShippingAsBilling: function (flag) {\n            var data,\n                areasToLoad = ['billing_method', 'shipping_address', 'shipping_method', 'totals', 'giftmessage'];\n\n            this.disableShippingAddress(flag);\n            data = this.serializeData(flag ? this.billingAddressContainer : this.shippingAddressContainer);\n            data = data.toObject();\n            data['shipping_as_billing'] = flag ? 1 : 0;\n            data['reset_shipping'] = 1;\n            // set customer_address_id to null for shipping address in order to treat it as new from backend\n            // Checkbox(Same As Billing Address) uncheck event\n            data['order[shipping_address][customer_address_id]'] = null;\n            this.loadArea(areasToLoad, true, data);\n        },\n\n        /**\n         * Replace shipping method area.\n         */\n        resetShippingMethod: function () {\n            if (!this.isOnlyVirtualProduct) {\n                $(this.getAreaId('shipping_method')).update(this.shippingTemplate);\n            }\n        },\n\n        /**\n         * Replace payment method area.\n         */\n        resetPaymentMethod: function () {\n            $(this.getAreaId('billing_method')).update(this.paymentTemplate);\n        },\n\n        /**\n         * Loads shipping options according to address data.\n         *\n         * @return {Boolean}\n         */\n        loadShippingRates: function () {\n            var addressContainer = this.shippingAsBilling ?\n                'billingAddressContainer' :\n                'shippingAddressContainer',\n                data = this.serializeData(this[addressContainer]).toObject();\n\n            data['collect_shipping_rates'] = 1;\n            this.isShippingMethodReseted = false;\n            this.loadArea(['shipping_method', 'totals'], true, data);\n\n            return false;\n        },\n\n        setShippingMethod: function (method) {\n            var data = {};\n\n            data['order[shipping_method]'] = method;\n            this.loadArea([\n                'shipping_method',\n                'totals',\n                'billing_method'\n            ], true, data);\n        },\n\n        /**\n         * Updates available payment\n         * methods list according to order data.\n         *\n         * @return boolean\n         */\n        loadPaymentMethods: function () {\n            var data = this.serializeData(this.billingAddressContainer).toObject();\n\n            this.loadArea(['billing_method', 'totals'], true, data);\n\n            return false;\n        },\n\n        switchPaymentMethod: function(method){\n            if (this.paymentMethod !== method) {\n                jQuery('#edit_form')\n                    .off('submitOrder')\n                    .on('submitOrder', function(){\n                        jQuery(this).trigger('realOrder');\n                    });\n            }\n            jQuery('#edit_form').trigger('changePaymentMethod', [method]);\n            this.setPaymentMethod(method);\n            var data = {};\n            data['order[payment_method]'] = method;\n            this.loadArea(['card_validation'], true, data);\n        },\n\n        setPaymentMethod: function (method) {\n            if (this.paymentMethod && $('payment_form_' + this.paymentMethod)) {\n                var form = 'payment_form_' + this.paymentMethod;\n                [form + '_before', form, form + '_after'].each(function (el) {\n                    var block = $(el);\n                    if (block) {\n                        block.hide();\n                        block.select('input', 'select', 'textarea').each(function (field) {\n                            field.disabled = true;\n                        });\n                    }\n                });\n            }\n\n            if (!this.paymentMethod || method) {\n                $('order-billing_method_form').select('input', 'select', 'textarea').each(function (elem) {\n                    if (elem.type != 'radio') elem.disabled = true;\n                })\n            }\n\n            if ($('payment_form_' + method)) {\n                jQuery('#' + this.getAreaId('billing_method')).trigger('contentUpdated');\n                this.paymentMethod = method;\n                var form = 'payment_form_' + method;\n                [form + '_before', form, form + '_after'].each(function (el) {\n                    var block = $(el);\n                    if (block) {\n                        block.show();\n                        block.select('input', 'select', 'textarea').each(function (field) {\n                            field.disabled = false;\n                            if (!el.include('_before') && !el.include('_after') && !field.bindChange) {\n                                field.bindChange = true;\n                                field.paymentContainer = form;\n                                field.method = method;\n                                field.observe('change', this.changePaymentData.bind(this))\n                            }\n                        }, this);\n                    }\n                }, this);\n            }\n        },\n\n        changePaymentData: function (event) {\n            var elem = Event.element(event);\n            if (elem && elem.method) {\n                var data = this.getPaymentData(elem.method);\n                if (data) {\n                    this.loadArea(['card_validation'], true, data);\n                } else {\n                    return;\n                }\n            }\n        },\n\n        getPaymentData: function (currentMethod) {\n            if (typeof (currentMethod) == 'undefined') {\n                if (this.paymentMethod) {\n                    currentMethod = this.paymentMethod;\n                } else {\n                    return false;\n                }\n            }\n            if (this.isPaymentValidationAvailable() == false) {\n                return false;\n            }\n            var data = {};\n            var fields = $('payment_form_' + currentMethod).select('input', 'select');\n            for (var i = 0; i < fields.length; i++) {\n                data[fields[i].name] = fields[i].getValue();\n            }\n            if ((typeof data['payment[cc_type]']) != 'undefined' && (!data['payment[cc_type]'] || !data['payment[cc_number]'])) {\n                return false;\n            }\n            return data;\n        },\n\n        applyCoupon: function (code) {\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true, {\n                'order[coupon][code]': code,\n                reset_shipping: true\n            });\n            this.orderItemChanged = false;\n            jQuery('html, body').animate({\n                scrollTop: 0\n            });\n        },\n\n        addProduct: function (id) {\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true, {\n                add_product: id,\n                reset_shipping: true\n            });\n        },\n\n        removeQuoteItem: function (id) {\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true,\n                {remove_item: id, from: 'quote', reset_shipping: true});\n        },\n\n        moveQuoteItem: function (id, to) {\n            this.loadArea(['sidebar_' + to, 'items', 'shipping_method', 'totals', 'billing_method'], this.getAreaId('items'),\n                {move_item: id, to: to, reset_shipping: true});\n        },\n\n        productGridShow: function (buttonElement) {\n            this.productGridShowButton = buttonElement;\n            Element.hide(buttonElement);\n            this.showArea('search');\n        },\n\n        productGridRowInit: function (grid, row) {\n            var checkbox = $(row).select('.checkbox')[0];\n            var inputs = $(row).select('.input-text');\n            if (checkbox && inputs.length > 0) {\n                checkbox.inputElements = inputs;\n                for (var i = 0; i < inputs.length; i++) {\n                    var input = inputs[i];\n                    input.checkboxElement = checkbox;\n\n                    var product = this.gridProducts.get(checkbox.value);\n                    if (product) {\n                        var defaultValue = product[input.name];\n                        if (defaultValue) {\n                            if (input.name == 'giftmessage') {\n                                input.checked = true;\n                            } else {\n                                input.value = defaultValue;\n                            }\n                        }\n                    }\n\n                    input.disabled = !checkbox.checked || input.hasClassName('input-inactive');\n\n                    Event.observe(input, 'keyup', this.productGridRowInputChange.bind(this));\n                    Event.observe(input, 'change', this.productGridRowInputChange.bind(this));\n                }\n            }\n        },\n\n        productGridRowInputChange: function (event) {\n            var element = Event.element(event);\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                if (element.name != 'giftmessage' || element.checked) {\n                    this.gridProducts.get(element.checkboxElement.value)[element.name] = element.value;\n                } else if (element.name == 'giftmessage' && this.gridProducts.get(element.checkboxElement.value)[element.name]) {\n                    delete (this.gridProducts.get(element.checkboxElement.value)[element.name]);\n                }\n            }\n        },\n\n        productGridRowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr');\n            var qtyElement = trElement.select('input[name=\"qty\"]')[0];\n            var eventElement = Event.element(event);\n\n            if (eventElement.tagName === 'LABEL'\n                && trElement.querySelector('#' + eventElement.htmlFor)\n                && trElement.querySelector('#' + eventElement.htmlFor).type === 'checkbox'\n            ) {\n                event.stopPropagation();\n                trElement.querySelector('#' + eventElement.htmlFor).trigger('click');\n                return;\n            }\n\n            var isInputCheckbox = (eventElement.tagName === 'INPUT' && eventElement.type === 'checkbox');\n            var isInputQty = grid.targetElement && grid.targetElement.tagName === 'INPUT' && grid.targetElement.name === 'qty';\n            if (trElement && !isInputQty) {\n                var checkbox = Element.select(trElement, 'input[type=\"checkbox\"]')[0];\n                var confLink = Element.select(trElement, 'a')[0];\n                var priceColl = Element.select(trElement, '.price')[0];\n                if (checkbox) {\n                    // processing non composite product\n                    if (confLink.readAttribute('disabled')) {\n                        var checked = isInputCheckbox ? checkbox.checked : !checkbox.checked;\n                        grid.setCheckboxChecked(checkbox, checked);\n                        // processing composite product\n                    } else if (isInputCheckbox && !checkbox.checked) {\n                        grid.setCheckboxChecked(checkbox, false);\n                        // processing composite product\n                    } else if (!isInputCheckbox || (isInputCheckbox && checkbox.checked)) {\n                        var listType = confLink.readAttribute('list_type');\n                        var productId = confLink.readAttribute('product_id');\n                        if (typeof this.productPriceBase[productId] == 'undefined') {\n                            var priceBase = priceColl.innerHTML.match(/.*?([\\d,]+\\.?\\d*)/);\n                            if (!priceBase) {\n                                this.productPriceBase[productId] = 0;\n                            } else {\n                                this.productPriceBase[productId] = parseFloat(priceBase[1].replace(/,/g, ''));\n                            }\n                        }\n                        productConfigure.setConfirmCallback(listType, function () {\n                            // sync qty of popup and qty of grid\n                            var confirmedCurrentQty = productConfigure.getCurrentConfirmedQtyElement();\n                            if (qtyElement && confirmedCurrentQty && !isNaN(confirmedCurrentQty.value)) {\n                                qtyElement.value = confirmedCurrentQty.value;\n                            }\n                            // calc and set product price\n                            var productPrice = this._calcProductPrice();\n                            if (this._isSummarizePrice()) {\n                                productPrice += this.productPriceBase[productId];\n                            }\n                            productPrice = parseFloat(Math.round(productPrice + \"e+2\") + \"e-2\");\n                            priceColl.innerHTML = this.currencySymbol + productPrice.toFixed(2);\n                            // and set checkbox checked\n                            grid.setCheckboxChecked(checkbox, true);\n                        }.bind(this));\n                        productConfigure.setCancelCallback(listType, function () {\n                            if (!$(productConfigure.confirmedCurrentId) || !$(productConfigure.confirmedCurrentId).innerHTML) {\n                                grid.setCheckboxChecked(checkbox, false);\n                            }\n                        });\n                        productConfigure.setShowWindowCallback(listType, function () {\n                            // sync qty of grid and qty of popup\n                            var formCurrentQty = productConfigure.getCurrentFormQtyElement();\n                            if (formCurrentQty && qtyElement && !isNaN(qtyElement.value)) {\n                                formCurrentQty.value = qtyElement.value;\n                            }\n                        }.bind(this));\n                        productConfigure.showItemConfiguration(listType, productId);\n                    }\n                }\n            }\n        },\n\n        /**\n         * Is need to summarize price\n         */\n        _isSummarizePrice: function (elm) {\n            if (elm && elm.hasAttribute('summarizePrice')) {\n                this.summarizePrice = parseInt(elm.readAttribute('summarizePrice'));\n            }\n            return this.summarizePrice;\n        },\n        /**\n         * Calc product price through its options\n         */\n        _calcProductPrice: function () {\n            var productPrice = 0;\n            var getPriceFields = function (elms) {\n                var productPrice = 0;\n                var getPrice = function (elm) {\n                    var optQty = 1;\n                    if (elm.hasAttribute('qtyId')) {\n                        if (!$(elm.getAttribute('qtyId')).value) {\n                            return 0;\n                        } else {\n                            optQty = parseFloat($(elm.getAttribute('qtyId')).value);\n                        }\n                    }\n                    if (elm.hasAttribute('price') && !elm.disabled) {\n                        return parseFloat(elm.readAttribute('price')) * optQty;\n                    }\n                    return 0;\n                };\n                for (var i = 0; i < elms.length; i++) {\n                    if (elms[i].type == 'select-one' || elms[i].type == 'select-multiple') {\n                        for (var ii = 0; ii < elms[i].options.length; ii++) {\n                            if (elms[i].options[ii].selected) {\n                                if (this._isSummarizePrice(elms[i].options[ii])) {\n                                    productPrice += getPrice(elms[i].options[ii]);\n                                } else {\n                                    productPrice = getPrice(elms[i].options[ii]);\n                                }\n                            }\n                        }\n                    } else if (((elms[i].type == 'checkbox' || elms[i].type == 'radio') && elms[i].checked)\n                        || ((elms[i].type == 'file' || elms[i].type == 'text' || elms[i].type == 'textarea' || elms[i].type == 'hidden')\n                            && Form.Element.getValue(elms[i]))\n                    ) {\n                        if (this._isSummarizePrice(elms[i])) {\n                            productPrice += getPrice(elms[i]);\n                        } else {\n                            productPrice = getPrice(elms[i]);\n                        }\n                    }\n                }\n                return productPrice;\n            }.bind(this);\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('input'));\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('select'));\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('textarea'));\n            return productPrice;\n        },\n\n        productGridCheckboxCheck: function (grid, element, checked) {\n            if (checked) {\n                if (element.inputElements) {\n                    this.gridProducts.set(element.value, {});\n                    var product = this.gridProducts.get(element.value);\n                    for (var i = 0; i < element.inputElements.length; i++) {\n                        var input = element.inputElements[i];\n                        if (!input.hasClassName('input-inactive')) {\n                            input.disabled = false;\n                            if (input.name == 'qty' && !input.value) {\n                                input.value = 1;\n                            }\n                        }\n\n                        if (input.checked || input.name != 'giftmessage') {\n                            product[input.name] = input.value;\n                        } else if (product[input.name]) {\n                            delete (product[input.name]);\n                        }\n                    }\n                }\n            } else {\n                if (element.inputElements) {\n                    for (var i = 0; i < element.inputElements.length; i++) {\n                        element.inputElements[i].disabled = true;\n                    }\n                }\n                this.gridProducts.unset(element.value);\n            }\n            grid.reloadParams = {'products[]': this.gridProducts.keys()};\n        },\n\n        productGridFilterKeyPress: function (grid, event) {\n            var returnKey = parseInt(Event.KEY_RETURN || 13, 10);\n\n            if (event.keyCode === returnKey) {\n                if (typeof event.stopPropagation === 'function') {\n                    event.stopPropagation();\n                }\n\n                if (typeof event.preventDefault === 'function') {\n                    event.preventDefault();\n                }\n            }\n        },\n\n        /**\n         * Submit configured products to quote\n         */\n        productGridAddSelected: function () {\n            if (this.productGridShowButton) Element.show(this.productGridShowButton);\n            var area = ['search', 'items', 'shipping_method', 'totals', 'giftmessage', 'billing_method'];\n            // prepare additional fields and filtered items of products\n            var fieldsPrepare = {};\n            var itemsFilter = [];\n            var products = this.gridProducts.toObject();\n            for (var productId in products) {\n                itemsFilter.push(productId);\n                var paramKey = 'item[' + productId + ']';\n                for (var productParamKey in products[productId]) {\n                    paramKey += '[' + productParamKey + ']';\n                    fieldsPrepare[paramKey] = products[productId][productParamKey];\n                }\n            }\n            this.productConfigureSubmit('product_to_add', area, fieldsPrepare, itemsFilter);\n            productConfigure.clean('quote_items');\n            this.hideArea('search');\n            this.gridProducts = $H({});\n        },\n\n        selectCustomer: function (grid, event) {\n            var element = Event.findElement(event, 'tr');\n            if (element.title) {\n                this.setCustomerId(element.title);\n            }\n        },\n\n        customerSelectorHide: function () {\n            this.hideArea('customer-selector');\n        },\n\n        customerSelectorShow: function () {\n            this.showArea('customer-selector');\n        },\n\n        storeSelectorHide: function () {\n            this.hideArea('store-selector');\n        },\n\n        storeSelectorShow: function () {\n            this.showArea('store-selector');\n        },\n\n        dataHide: function () {\n            this.hideArea('data');\n        },\n\n        dataShow: function () {\n            if ($('submit_order_top_button')) {\n                $('submit_order_top_button').show();\n            }\n            this.showArea('data');\n        },\n\n        clearShoppingCart: function (confirmMessage) {\n            var self = this;\n\n            confirm({\n                content: confirmMessage,\n                actions: {\n                    confirm: function () {\n                        self.collectElementsValue = false;\n                        order.sidebarApplyChanges({'sidebar[empty_customer_cart]': 1});\n                        self.collectElementsValue = true;\n                    }\n                }\n            });\n        },\n\n        sidebarApplyChanges: function (auxiliaryParams) {\n            if ($(this.getAreaId('sidebar'))) {\n                var data = {};\n                if (this.collectElementsValue) {\n                    var elems = $(this.getAreaId('sidebar')).select('input');\n                    for (var i = 0; i < elems.length; i++) {\n                        if (elems[i].getValue()) {\n                            data[elems[i].name] = elems[i].getValue();\n                        }\n                    }\n                }\n                if (auxiliaryParams instanceof Object) {\n                    for (var paramName in auxiliaryParams) {\n                        data[paramName] = String(auxiliaryParams[paramName]);\n                    }\n                }\n                data.reset_shipping = true;\n                this.loadArea(['sidebar', 'items', 'shipping_method', 'billing_method', 'totals', 'giftmessage'], true, data);\n            }\n        },\n\n        sidebarHide: function () {\n            if (this.storeId === false && $('page:left') && $('page:container')) {\n                $('page:left').hide();\n                $('page:container').removeClassName('container');\n                $('page:container').addClassName('container-collapsed');\n            }\n        },\n\n        sidebarShow: function () {\n            if ($('page:left') && $('page:container')) {\n                $('page:left').show();\n                $('page:container').removeClassName('container-collapsed');\n                $('page:container').addClassName('container');\n            }\n        },\n\n        /**\n         * Show configuration of product and add handlers on submit form\n         *\n         * @param productId\n         */\n        sidebarConfigureProduct: function (listType, productId, itemId) {\n            // create additional fields\n            var params = {},\n                isWishlist = !!itemId;\n            params.reset_shipping = true;\n            params.add_product = productId;\n            this.prepareParams(params);\n            for (var i in params) {\n                if (params[i] === null) {\n                    unset(params[i]);\n                } else if (typeof (params[i]) == 'boolean') {\n                    params[i] = params[i] ? 1 : 0;\n                }\n            }\n            var fields = [];\n            for (var name in params) {\n                fields.push(new Element('input', {type: 'hidden', name: name, value: params[name]}));\n            }\n            // add additional fields before triggered submit\n            productConfigure.setBeforeSubmitCallback(listType, function () {\n                productConfigure.addFields(fields);\n            }.bind(this));\n            // response handler\n            productConfigure.setOnLoadIFrameCallback(listType, function (response) {\n                var areas = ['items', 'shipping_method', 'billing_method', 'totals', 'giftmessage'];\n\n                if (!response.ok) {\n                    return;\n                }\n                if (isWishlist) {\n                    this.removeSidebarItem(itemId, 'wishlist').done(function () {\n                        this.loadArea(areas, true);\n                    }.bind(this));\n                } else {\n                    this.loadArea(areas, true);\n                }\n            }.bind(this));\n            // show item configuration\n            itemId = itemId ? itemId : productId;\n            productConfigure.showItemConfiguration(listType, itemId);\n            return false;\n        },\n\n        removeSidebarItem: function (id, from) {\n            return this.loadArea(['sidebar_' + from], 'sidebar_data_' + from, {\n                remove_item: id,\n                from: from\n            });\n        },\n\n        itemsUpdate: function () {\n            var area = ['sidebar', 'items', 'shipping_method', 'billing_method', 'totals', 'giftmessage'];\n            // prepare additional fields\n            var fieldsPrepare = {update_items: 1};\n            var info = $('order-items_grid').select('input', 'select', 'textarea');\n            for (var i = 0; i < info.length; i++) {\n                if (!info[i].disabled && (info[i].type != 'checkbox' || info[i].checked)) {\n                    fieldsPrepare[info[i].name] = info[i].getValue();\n                }\n            }\n            fieldsPrepare = Object.extend(fieldsPrepare, this.productConfigureAddFields);\n            this.productConfigureSubmit('quote_items', area, fieldsPrepare);\n            this.orderItemChanged = false;\n        },\n\n        itemsOnchangeBind: function () {\n            var elems = $('order-items_grid').select('input', 'select', 'textarea');\n            for (var i = 0; i < elems.length; i++) {\n                if (!elems[i].bindOnchange) {\n                    elems[i].bindOnchange = true;\n                    elems[i].observe('change', this.itemChange.bind(this))\n                }\n            }\n        },\n\n        itemChange: function (event) {\n            this.giftmessageOnItemChange(event);\n            this.orderItemChanged = true;\n        },\n\n        /**\n         * Submit batch of configured products\n         *\n         * @param listType\n         * @param area\n         * @param fieldsPrepare\n         * @param itemsFilter\n         */\n        productConfigureSubmit: function (listType, area, fieldsPrepare, itemsFilter) {\n            // prepare loading areas and build url\n            area = this.prepareArea(area);\n            this.loadingAreas = area;\n            var url = this.loadBaseUrl + 'block/' + area + '?isAjax=true';\n\n            // prepare additional fields\n            fieldsPrepare = this.prepareParams(fieldsPrepare);\n            fieldsPrepare.reset_shipping = 1;\n            fieldsPrepare.json = 1;\n\n            // create fields\n            var fields = [];\n            for (var name in fieldsPrepare) {\n                fields.push(new Element('input', {type: 'hidden', name: name, value: fieldsPrepare[name]}));\n            }\n            productConfigure.addFields(fields);\n\n            // filter items\n            if (itemsFilter) {\n                productConfigure.addItemsFilter(listType, itemsFilter);\n            }\n\n            // prepare and do submit\n            productConfigure.addListType(listType, {urlSubmit: url});\n            productConfigure.setOnLoadIFrameCallback(listType, function (response) {\n                this.loadAreaResponseHandler(response);\n            }.bind(this));\n            productConfigure.submit(listType);\n            // clean\n            this.productConfigureAddFields = {};\n        },\n\n        /**\n         * Show configuration of quote item\n         *\n         * @param itemId\n         */\n        showQuoteItemConfiguration: function (itemId) {\n            var listType = 'quote_items';\n            var qtyElement = $('order-items_grid').select('input[name=\"item\\[' + itemId + '\\]\\[qty\\]\"]')[0];\n            productConfigure.setConfirmCallback(listType, function () {\n                // sync qty of popup and qty of grid\n                var confirmedCurrentQty = productConfigure.getCurrentConfirmedQtyElement();\n                if (qtyElement && confirmedCurrentQty && !isNaN(confirmedCurrentQty.value)) {\n                    qtyElement.value = confirmedCurrentQty.value;\n                }\n                this.productConfigureAddFields['item[' + itemId + '][configured]'] = 1;\n                this.itemsUpdate();\n\n            }.bind(this));\n            productConfigure.setShowWindowCallback(listType, function () {\n                // sync qty of grid and qty of popup\n                var formCurrentQty = productConfigure.getCurrentFormQtyElement();\n                if (formCurrentQty && qtyElement && !isNaN(qtyElement.value)) {\n                    formCurrentQty.value = qtyElement.value;\n                }\n            }.bind(this));\n            productConfigure.showItemConfiguration(listType, itemId);\n        },\n\n        accountFieldsBind: function (container) {\n            if ($(container)) {\n                var fields = $(container).select('input', 'select', 'textarea');\n                for (var i = 0; i < fields.length; i++) {\n                    if (fields[i].id == 'group_id') {\n                        fields[i].observe('change', this.accountGroupChange.bind(this))\n                    } else {\n                        fields[i].observe('change', this.accountFieldChange.bind(this))\n                    }\n                }\n            }\n        },\n\n        accountGroupChange: function () {\n            this.loadArea(['data'], true, this.serializeData('order-form_account').toObject());\n        },\n\n        accountFieldChange: function () {\n            this.saveData(this.serializeData('order-form_account'));\n        },\n\n        commentFieldsBind: function (container) {\n            if ($(container)) {\n                var fields = $(container).select('input', 'textarea');\n                for (var i = 0; i < fields.length; i++)\n                    fields[i].observe('change', this.commentFieldChange.bind(this))\n            }\n        },\n\n        commentFieldChange: function () {\n            this.saveData(this.serializeData('order-comment'));\n        },\n\n        giftmessageFieldsBind: function (container) {\n            if ($(container)) {\n                var fields = $(container).select('input', 'textarea');\n                for (var i = 0; i < fields.length; i++)\n                    fields[i].observe('change', this.giftmessageFieldChange.bind(this))\n            }\n        },\n\n        giftmessageFieldChange: function () {\n            this.giftMessageDataChanged = true;\n        },\n\n        giftmessageOnItemChange: function (event) {\n            var element = Event.element(event);\n            if (element.name.indexOf(\"giftmessage\") != -1 && element.type == \"checkbox\" && !element.checked) {\n                var messages = $(\"order-giftmessage\").select('textarea');\n                var name;\n                for (var i = 0; i < messages.length; i++) {\n                    name = messages[i].id.split(\"_\");\n                    if (name.length < 2) continue;\n                    if (element.name.indexOf(\"[\" + name[1] + \"]\") != -1 && messages[i].value != \"\") {\n                        alert({\n                            content: \"First, clean the Message field in Gift Message form\"\n                        });\n                        element.checked = true;\n                    }\n                }\n            }\n        },\n\n        loadArea: function (area, indicator, params) {\n            var deferred = new jQuery.Deferred();\n            var url = this.loadBaseUrl;\n            if (area) {\n                area = this.prepareArea(area);\n                url += 'block/' + area;\n            }\n            if (indicator === true) indicator = 'html-body';\n            params = this.prepareParams(params);\n            params.json = true;\n            if (!this.loadingAreas) this.loadingAreas = [];\n            if (indicator) {\n                this.loadingAreas = area;\n                new Ajax.Request(url, {\n                    parameters: params,\n                    loaderArea: indicator,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText.evalJSON();\n                        this.loadAreaResponseHandler(response);\n                        deferred.resolve();\n                    }.bind(this)\n                });\n            } else {\n                new Ajax.Request(url, {\n                    parameters: params,\n                    loaderArea: indicator,\n                    onSuccess: function (transport) {\n                        deferred.resolve();\n                    }\n                });\n            }\n            if (typeof productConfigure != 'undefined' && area instanceof Array && area.indexOf('items') != -1) {\n                productConfigure.clean('quote_items');\n            }\n            return deferred.promise();\n        },\n\n        loadAreaResponseHandler: function (response) {\n            if (response.error) {\n                alert({\n                    content: response.message\n                });\n            }\n            if (response.ajaxExpired && response.ajaxRedirect) {\n                setLocation(response.ajaxRedirect);\n            }\n            if (!this.loadingAreas) {\n                this.loadingAreas = [];\n            }\n            if (typeof this.loadingAreas == 'string') {\n                this.loadingAreas = [this.loadingAreas];\n            }\n            if (this.loadingAreas.indexOf('message') == -1) {\n                this.loadingAreas.push('message');\n            }\n            if (response.header) {\n                jQuery('.page-actions-inner').attr('data-title', response.header);\n            }\n\n            for (var i = 0; i < this.loadingAreas.length; i++) {\n                var id = this.loadingAreas[i];\n                if ($(this.getAreaId(id))) {\n                    if ((id in response) && id !== 'message' || response[id]) {\n                        $(this.getAreaId(id)).update(response[id]);\n                    }\n                    if ($(this.getAreaId(id)).callback) {\n                        this[$(this.getAreaId(id)).callback]();\n                    }\n                }\n            }\n        },\n\n        prepareArea: function (area) {\n            if (this.giftMessageDataChanged) {\n                return area.without('giftmessage');\n            }\n            return area;\n        },\n\n        saveData: function (data) {\n            this.loadArea(false, false, data);\n        },\n\n        showArea: function (area) {\n            var id = this.getAreaId(area);\n            if ($(id)) {\n                $(id).show();\n                this.areaOverlay();\n            }\n        },\n\n        hideArea: function (area) {\n            var id = this.getAreaId(area);\n            if ($(id)) {\n                $(id).hide();\n                this.areaOverlay();\n            }\n        },\n\n        areaOverlay: function () {\n            $H(order.overlayData).each(function (e) {\n                e.value.fx();\n            });\n        },\n\n        getAreaId: function (area) {\n            return 'order-' + area;\n        },\n\n        prepareParams: function (params) {\n            if (!params) {\n                params = {};\n            }\n            if (!params.customer_id) {\n                params.customer_id = this.customerId;\n            }\n            if (!params.store_id) {\n                params.store_id = this.storeId;\n            }\n            if (!params.currency_id) {\n                params.currency_id = this.currencyId;\n            }\n            if (!params.form_key) {\n                params.form_key = FORM_KEY;\n            }\n\n            if (this.isPaymentValidationAvailable()) {\n                var data = this.serializeData('order-billing_method');\n                if (data) {\n                    data.each(function (value) {\n                        params[value[0]] = value[1];\n                    });\n                }\n            } else {\n                params['payment[method]'] = this.paymentMethod;\n            }\n            return params;\n        },\n\n        /**\n         * Prevent from sending credit card information to server for some payment methods\n         *\n         * @returns {boolean}\n         */\n        isPaymentValidationAvailable: function () {\n            return ((typeof this.paymentMethod) == 'undefined'\n                || this.excludedPaymentMethods.indexOf(this.paymentMethod) == -1);\n        },\n\n        /**\n         * Serializes container form elements data.\n         *\n         * @param {String} container\n         * @return {Object}\n         */\n        serializeData: function (container) {\n            var fields = $(container).select('input', 'select', 'textarea'),\n                data = Form.serializeElements(fields, true);\n\n            return $H(data);\n        },\n\n        toggleCustomPrice: function (checkbox, elemId, tierBlock) {\n            if (checkbox.checked) {\n                $(elemId).disabled = false;\n                $(elemId).show();\n                if ($(tierBlock)) $(tierBlock).hide();\n            } else {\n                $(elemId).disabled = true;\n                $(elemId).hide();\n                if ($(tierBlock)) $(tierBlock).show();\n            }\n        },\n\n        submit: function () {\n            var $editForm = jQuery('#edit_form'),\n                beforeSubmitOrderEvent;\n\n            if ($editForm.valid()) {\n                $editForm.trigger('processStart');\n                beforeSubmitOrderEvent = jQuery.Event('beforeSubmitOrder');\n                $editForm.trigger(beforeSubmitOrderEvent);\n                if (beforeSubmitOrderEvent.result !== false) {\n                    $editForm.trigger('submitOrder');\n                }\n            }\n        },\n\n        _realSubmit: function () {\n            var disableAndSave = function () {\n                disableElements('save');\n                jQuery('#edit_form').on('invalid-form.validate', function () {\n                    enableElements('save');\n                    jQuery('#edit_form').trigger('processStop');\n                    jQuery('#edit_form').off('invalid-form.validate');\n                });\n                jQuery('#edit_form').triggerHandler('save');\n            }\n            if (this.orderItemChanged) {\n                var self = this;\n\n                jQuery('#edit_form').trigger('processStop');\n\n                confirm({\n                    content: jQuery.mage.__('You have item changes'),\n                    actions: {\n                        confirm: function () {\n                            jQuery('#edit_form').trigger('processStart');\n                            disableAndSave();\n                        },\n                        cancel: function () {\n                            self.itemsUpdate();\n                        }\n                    }\n                });\n            } else {\n                disableAndSave();\n            }\n        },\n\n        overlay: function (elId, show, observe) {\n            if (typeof (show) == 'undefined') {\n                show = true;\n            }\n\n            var orderObj = this;\n            var obj = this.overlayData.get(elId);\n            if (!obj) {\n                obj = {\n                    show: show,\n                    el: elId,\n                    order: orderObj,\n                    fx: function (event) {\n                        this.order.processOverlay(this.el, this.show);\n                    }\n                };\n                obj.bfx = obj.fx.bindAsEventListener(obj);\n                this.overlayData.set(elId, obj);\n            } else {\n                obj.show = show;\n                Event.stopObserving(window, 'resize', obj.bfx);\n            }\n\n            Event.observe(window, 'resize', obj.bfx);\n\n            this.processOverlay(elId, show);\n        },\n\n        processOverlay: function (elId, show) {\n            var el = $(elId);\n\n            if (!el) {\n                return;\n            }\n\n            var parentEl = el.up(1);\n            if (show) {\n                parentEl.removeClassName('ignore-validate');\n            } else {\n                parentEl.addClassName('ignore-validate');\n            }\n\n            if (Prototype.Browser.IE) {\n                parentEl.select('select').each(function (elem) {\n                    if (show) {\n                        elem.needShowOnSuccess = false;\n                        elem.style.visibility = '';\n                    } else {\n                        elem.style.visibility = 'hidden';\n                        elem.needShowOnSuccess = true;\n                    }\n                });\n            }\n\n            parentEl.setStyle({position: 'relative'});\n            el.setStyle({\n                display: show ? 'none' : ''\n            });\n        },\n\n        validateVat: function (parameters) {\n            var params = {\n                country: $(parameters.countryElementId).value,\n                vat: $(parameters.vatElementId).value\n            };\n\n            if (this.storeId !== false) {\n                params.store_id = this.storeId;\n            }\n\n            var currentCustomerGroupId = $(parameters.groupIdHtmlId)\n                ? $(parameters.groupIdHtmlId).value : '';\n\n            new Ajax.Request(parameters.validateUrl, {\n                parameters: params,\n                onSuccess: function (response) {\n                    var message = '';\n                    var groupActionRequired = null;\n                    try {\n                        response = response.responseText.evalJSON();\n\n                        if (null === response.group) {\n                            if (true === response.valid) {\n                                message = parameters.vatValidMessage;\n                            } else if (true === response.success) {\n                                message = parameters.vatInvalidMessage.replace(/%s/, params.vat);\n                            } else {\n                                message = parameters.vatValidationFailedMessage;\n                            }\n                        } else {\n                            if (true === response.valid) {\n                                message = parameters.vatValidAndGroupValidMessage;\n                                if (0 === response.group) {\n                                    message = parameters.vatValidAndGroupInvalidMessage;\n                                    groupActionRequired = 'inform';\n                                } else if (currentCustomerGroupId != response.group) {\n                                    message = parameters.vatValidAndGroupChangeMessage;\n                                    groupActionRequired = 'change';\n                                }\n                            } else if (response.success) {\n                                message = parameters.vatInvalidMessage.replace(/%s/, params.vat);\n                                groupActionRequired = 'inform';\n                            } else {\n                                message = parameters.vatValidationFailedMessage;\n                                groupActionRequired = 'inform';\n                            }\n                        }\n                    } catch (e) {\n                        message = parameters.vatValidationFailedMessage;\n                    }\n                    if (null === groupActionRequired) {\n                        alert({\n                            content: message\n                        });\n                    } else {\n                        this.processCustomerGroupChange(\n                            parameters.groupIdHtmlId,\n                            message,\n                            parameters.vatCustomerGroupMessage,\n                            parameters.vatGroupErrorMessage,\n                            response.group,\n                            groupActionRequired\n                        );\n                    }\n                }.bind(this)\n            });\n        },\n\n        processCustomerGroupChange: function (groupIdHtmlId, message, customerGroupMessage, errorMessage, groupId, action) {\n            var groupMessage = '';\n            try {\n                var currentCustomerGroupId = $(groupIdHtmlId).value;\n                var currentCustomerGroupTitle =\n                    $$('#' + groupIdHtmlId + ' > option[value=' + currentCustomerGroupId + ']')[0].text;\n                var customerGroupOption = $$('#' + groupIdHtmlId + ' > option[value=' + groupId + ']')[0];\n                groupMessage = customerGroupMessage.replace(/%s/, customerGroupOption.text);\n            } catch (e) {\n                groupMessage = errorMessage;\n                if (action === 'change') {\n                    message = '';\n                    action = 'inform';\n                }\n            }\n\n            if (action === 'change') {\n                var confirmText = message.replace(/%s/, customerGroupOption.text);\n                confirmText = confirmText.replace(/%s/, currentCustomerGroupTitle);\n                confirm({\n                    content: confirmText,\n                    actions: {\n                        confirm: function() {\n                            $$('#' + groupIdHtmlId + ' option').each(function (o) {\n                                o.selected = o.readAttribute('value') == groupId;\n                            });\n                            this.accountGroupChange();\n                        }.bind(this)\n                    }\n                })\n            } else if (action === 'inform') {\n                alert({\n                    content: message + '\\n' + groupMessage\n                });\n            }\n        }\n    };\n\n    window.OrderFormArea = Class.create();\n    OrderFormArea.prototype = {\n        _name: null,\n        _node: null,\n        _parent: null,\n        _callbackName: null,\n\n        initialize: function (name, node, parent) {\n            if (!node)\n                return;\n            this._name = name;\n            this._parent = parent;\n            this._callbackName = node.callback;\n            if (typeof this._callbackName == 'undefined') {\n                this._callbackName = name + 'Loaded';\n                node.callback = this._callbackName;\n            }\n            parent[this._callbackName] = parent[this._callbackName].wrap((function (proceed) {\n                proceed();\n                this.onLoad();\n            }).bind(this));\n\n            this.setNode(node);\n        },\n\n        setNode: function (node) {\n            if (!node.callback) {\n                node.callback = this._callbackName;\n            }\n            this.node = node;\n        },\n\n        onLoad: function () {\n        }\n    };\n\n    window.ControlButton = Class.create();\n\n    ControlButton.prototype = {\n        _label: '',\n        _node: null,\n\n        initialize: function (label, id) {\n            this._label = label;\n            this._node = new Element('button', {\n                'class': 'action-secondary action-add',\n                'type': 'button'\n            });\n            if (typeof id !== 'undefined') {\n                this._node.setAttribute('id', id)\n            }\n        },\n\n        onClick: function () {\n        },\n\n        insertIn: function (element, position) {\n            var node = Object.extend(this._node),\n                content = {};\n            node.observe('click', this.onClick);\n            node.update('<span>' + this._label + '</span>');\n            content[position] = node;\n            Element.insert(element, content);\n        },\n\n        getLabel: function () {\n            return this._label;\n        }\n    };\n});\n","Magento_Sales/order/create/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global AdminOrder */\ndefine([\n    'jquery',\n    'Magento_Sales/order/create/scripts'\n], function (jQuery) {\n    'use strict';\n\n    var $el = jQuery('#edit_form'),\n        config,\n        baseUrl,\n        order,\n        payment;\n\n    if (!$el.length || !$el.data('order-config')) {\n        return;\n    }\n\n    config = $el.data('order-config');\n    baseUrl = $el.data('load-base-url');\n\n    order = new AdminOrder(config);\n    order.setLoadBaseUrl(baseUrl);\n\n    payment = {\n        switchMethod: order.switchPaymentMethod.bind(order)\n    };\n\n    window.order = order;\n    window.payment = payment;\n});\n","Magento_Sales/order/edit/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderEditDialog', {\n        options: {\n            url:     null,\n            message: null,\n            modal:  null\n        },\n\n        /**\n         * @protected\n         */\n        _create: function () {\n            this._prepareDialog();\n        },\n\n        /**\n         * Show modal\n         */\n        showDialog: function () {\n            this.options.dialog.html(this.options.message).modal('openModal');\n        },\n\n        /**\n         * Redirect to edit page\n         */\n        redirect: function () {\n            window.location = this.options.url;\n        },\n\n        /**\n         * Prepare modal\n         * @protected\n         */\n        _prepareDialog: function () {\n            var self = this;\n\n            this.options.dialog = $('<div class=\"ui-dialog-content ui-widget-content\"></div>').modal({\n                type: 'popup',\n                modalClass: 'edit-order-popup',\n                title: $.mage.__('Edit Order'),\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    'class': 'action-primary',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        self.redirect();\n                    }\n                }]\n            });\n        }\n    });\n\n    return $.mage.orderEditDialog;\n});\n","Magento_Sales/order/edit/address/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Currently Magento App stores both  region_id and region (as text) values.\n     * To prevent missing region (as text) we need to copy it in hidden field.\n     * @param {Array} config\n     * @param {String} element\n     */\n    return function (config, element) {\n        var form = $(element),\n            regionId = form.find('#region_id'),\n\n            /**\n             * Set region callback\n             */\n            setRegion = function () {\n                form.find('#region').val(regionId.filter(':visible').find(':selected').text());\n            };\n\n        if (regionId.is('visible')) {\n            setRegion();\n        }\n\n        regionId.on('change', setRegion);\n        form.find('#country_id').on('change', setRegion);\n    };\n});\n"}
}});
