define(["jquery", "mage/url"], function ($, urlBuilder) {
    $(document).ready(function () {
        const orderDetailsBlank = `
            <div class= "order-details-content disable">
                <div class="order-details-title">
                    <strong></strong>
                    <p>Reservación ID: </p>
                </div>
                <div class="order-details-body disable">
                    <div class="order-details-left">
                        <p class="detail-text">Fecha de la reservación:</p>
                        <p class="detail-data date"></p>
                        <p class="detail-text">Hora de la reservación:</p>
                        <p class="detail-data time"></p>
                        <p class="detail-text">Comensales:</p>
                        <p class="detail-data guest"></p>
                        <p class="detail-text">Invitar a :</p>
                        <p class="detail-data emailsGuest"></p>
                        <p class="detail-text">Notas:</p>
                        <p class="detail-data instructions"></p>
                    </div>
                    <div class="order-details-right">
                        <p class="detail-text">Status de la reservación:</p>
                        <p class="detail-data status"></p>                    
                        <p class="detail-text">Mesas asignadas:</p>
                        <p class="detail-data option"></p>
                    </div>
                </div> 
            </div>
        `;
        $("#order-details-content").html(orderDetailsBlank);
        $("#order-details-container").show();

        $(".hidden-order").hide();
        $("#order-toolbar").hide();

        $("#view-more-orders").on("click", function () {
            $(".hidden-order").fadeIn();
            $(this).hide();
            $("#order-toolbar").fadeIn();
        });

        $(".toggle-reservation-details").on("click", function () {
            $(".toggle-reservation-details").removeClass("active");
            $(this).addClass("active");
            
            const restaurantName = $(this).data('restaurant-name') || '';
            const orderId = $(this).data('order-id') || '';
            const bookingDate = $(this).data('booking-date') || '';
            const bookingTime = $(this).data('booking-time') || '';
            const guestInfo = $(this).data('guest-info') || '';
            const guestNumber = $(this).data('guest-number');
            const status = $(this).data('status') || '';
            const isDisabled = status.toLowerCase() === 'canceled' ? 'disabled' : '';
            const option = $(this).data('option') || '';
            const notes = $(this).data('notes');
            const tableType = $(this).data('tableType');
            const cancellationReason = $(this).data('cancellation-reason');
            const emailsGuest = $(this).data('emailsGuest') || '';

            const orderDetails = `
                <div class="order-details-title">
                    <strong>${restaurantName}</strong>
                    <p>Reservación ID: ${orderId}</p>
                </div>
                <div class="order-details-body">
                    <div class="order-details-left">
                        <p class="detail-text">Fecha de la reservación:</p>
                        <p class="detail-data date">${bookingDate}</p>
                        <p class="detail-text">Hora de la reservación:</p>
                        <p class="detail-data time">${bookingTime}</p>
                        <p class="detail-text">Comensales:</p>
                        <p class="detail-data guest">${guestInfo}</p>
                        <p class="detail-text">Invitar a:</p>
                       <textarea class="detail-data emailsGuest">${emailsGuest}</textarea>
                        <p class="detail-text">Notas:</p>
                        <textarea class="detail-data instructions" disabled>${notes}</textarea>
                    </div>
                    <div class="order-details-right">
                        <p class="detail-text">Status de la reservación:</p>
                        <p class="detail-data status ${status}">${status}</p>                       
                        <p class="detail-text">Mesas asignadas:</p>
                        <div class="detail-data-options">
                            <p class="table-number">Mesa</p>
                            <p class="guest-number-text">Comensales: </p>
                            <p class="guest-number-data">${guestNumber}</p>
                            <p class="table-type-text">Tipo de mesa: </p>
                            <p class="table-type-data"">${tableType}</p>
                        </div>                        
                       
                    </div>
                    <button type="button" id="update-reservation" class="btn-cancel" order-id="${orderId}" ${isDisabled}>
                        <span>Actualizar Reservación</span>
                    </button>
                    <button type="button" id="cancel-reservation" class="btn-cancel" order-id="${orderId}" ${isDisabled}>
                        <span>Cancelar Reservación</span>
                    </button>
                    <input type="text" id="cancel_reason" placeholder="Motivo de cancelacion" value="${cancellationReason}" ${isDisabled}/>
                </div> 
            `;
            $("#order-details-content").html(orderDetails);
            $("#order-details-container").fadeIn();

            $('#cancel-reservation').on('click', function() {
                const orderId = $(this).attr('order-id');
                const cancelReason = $('#cancel_reason').val();

                if (!confirm('Esta acción no podrá ser cambiada posteriormente, ¿estás seguro que deseas cancelar la reservación?')) {
                    return;
                }
              
                $.ajax({
                    url: urlBuilder.build("accounttypeselector/status/update"),
                    type: "POST",
                    contentType: "application/json",
                    dataType: "json",
                    data: JSON.stringify({
                        order_id: orderId,
                        new_status: 'canceled',
                        cancelled_by: 'customer',
                        cancel_reason: cancelReason
                    }),
                    success: function (response) {
                        if (response.success) {
                            alert("Reservación actualizada correctamente");
                            location.reload();
                        } else {
                            alert(response.message);
                        }
                    },
                });
            });

            $('#update-reservation').on('click', function() {
            const orderId = $(this).attr('order-id');
            const emails = $('.emailsGuest').val();  
            
            $.ajax({
                url: urlBuilder.build("accounttypeselector/status/update"),
                type: "POST",
                contentType: "application/json",
                dataType: "json",
                data: JSON.stringify({
                    order_id: orderId,
                    new_status: 'updated',  
                    emails: emails         
                }),
                success: function(response) {
                    if (response.success) {
                        alert("Reservación y emails actualizados correctamente");
                        location.reload();
                    } else {
                        alert(response.message);
                    }
                },
            });
        });
        });
    });
});
