define([
    'jquery',
    'Magento_Customer/js/customer-data',
    'mage/url',
    'https://js.stripe.com/v3/'
], function ($, customerData, urlBuilder) {
    'use strict';

    return function (config) {
        const stripe   = Stripe(config.publicKey);
        const elements = stripe.elements();

        const cardNumber = elements.create('cardNumber', {
            style: config.style,
            placeholder: '16 dígitos',
        });
        cardNumber.mount('#stripe-card-number');

        const cardExpiry = elements.create('cardExpiry', {
            style: config.style,
            placeholder: 'MM / AA'
        });
        cardExpiry.mount('#stripe-card-expiry');

        const cardCvc = elements.create('cardCvc', {
            style: config.style,
            placeholder: '3 dígitos',
        });
        cardCvc.mount('#stripe-card-cvc');

        $('#stripe-add-card-form').on('submit', function (event) {
            event.preventDefault();
            const cardholderName = $('#cardholder-name').val().trim();
            const postalCode     = $('#billing-zip').val().trim();
            const billingAddress = $('#billing-address').val().trim();
            

            if (!cardholderName) {
                alert($.mage.__('Please enter the cardholder name.'));
                return;
            }
            $('#stripe-add-card-form button')
                .prop('disabled', true)
                .text('Guardando…');

            stripe.createToken(cardNumber, {
                name: cardholderName
            }).then(function (result) {
                if (result.error) {
                    alert(result.error.message);
                    $('#stripe-add-card-form button')
                        .prop('disabled', false)
                        .text('Guardar Tarjeta');
                } else {
                    $.ajax({
                        url: urlBuilder.build('stripecards/cards/savecard'),
                        type: 'POST',
                        data: {
                            token: result.token.id,
                            cardholder_name: cardholderName,
                            postal_code: postalCode,
                            billing_address: billingAddress
                        },
                        showLoader: true,
                        success: function (response) {
                            if (response.success) {
                                alert($.mage.__('Card saved successfully.'));
                                customerData.reload(['customer']);
                                $('#stripe-add-card-form button').text('Guardada');
                                location.reload();
                            } else {
                                alert($.mage.__('Error saving card: ' + (response.message || '')));
                                $('#stripe-add-card-form button')
                                    .prop('disabled', false)
                                    .text('Guardar Tarjeta');
                            }
                        },
                        error: function () {
                            alert($.mage.__('An unexpected error occurred.'));
                            $('#stripe-add-card-form button')
                                .prop('disabled', false)
                                .text('Guardar Tarjeta');
                        }
                    });
                }
            });
        });
    };
});
