require.config({"config": {
        "jsbuild":{"StripeIntegration_Payments/js/view/checkout/summary/prorations.js":"define(\n    [\n        'ko',\n        'mage/translate',\n        'Magento_Checkout/js/view/summary/abstract-total',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Catalog/js/price-utils',\n        'Magento_Checkout/js/model/totals',\n        'StripeIntegration_Payments/js/helper/subscriptions',\n        'StripeIntegration_Payments/js/model/upcomingInvoice'\n    ],\n    function (\n        ko,\n        $t,\n        Component,\n        quote,\n        priceUtils,\n        totals,\n        subscriptions,\n        upcomingInvoice\n    ) {\n        \"use strict\";\n\n        return Component.extend({\n            defaults: {\n                template: 'StripeIntegration_Payments/checkout/summary/prorations'\n            },\n            totals: quote.getTotals(),\n            prorationAdjustment: ko.observable(0),\n            baseProrationAdjustment: ko.observable(0),\n\n            initialize: function()\n            {\n                this._super();\n                upcomingInvoice.initialize();\n                upcomingInvoice.onChange(this.onUpcomingInvoiceChanged.bind(this));\n            },\n\n            isDisplayed: function()\n            {\n                return subscriptions.isSubscriptionUpdate() && this.isFullMode() && this.getPureValue() !== 0;\n            },\n\n            getValue: function()\n            {\n                var price = this.getPureValue();\n                return this.getFormattedPrice(price);\n            },\n\n            getPureValue: function()\n            {\n                var price = 0;\n                if (subscriptions.isSubscriptionUpdate() && this.prorationAdjustment()) {\n                    price = this.prorationAdjustment();\n                }\n                return price;\n            },\n\n            getBasePureValue: function()\n            {\n                var price = 0;\n                if (subscriptions.isSubscriptionUpdate() && this.baseProrationAdjustment()) {\n                    price = this.baseProrationAdjustment();\n                }\n                return price;\n            },\n\n            onUpcomingInvoiceChanged: function(result, outcome, response)\n            {\n                try\n                {\n                    var params = JSON.parse(result);\n\n                    if (params && params.error)\n                    {\n                        return;\n                    }\n\n                    if (!params || !params.upcomingInvoice)\n                        return;\n\n                    if (!isNaN(params.upcomingInvoice.proration_adjustment))\n                    {\n                        this.prorationAdjustment(params.upcomingInvoice.proration_adjustment);\n                    }\n\n                    if (!isNaN(params.upcomingInvoice.base_proration_adjustment))\n                    {\n                        this.baseProrationAdjustment(params.upcomingInvoice.base_proration_adjustment);\n                    }\n                }\n                catch (e)\n                {\n                    console.warn(\"Could not calculate sidebar proration amount\");\n                    console.warn(e);\n                }\n            },\n        });\n    }\n);\n","StripeIntegration_Payments/js/view/checkout/cart/totals/initial_fee.js":"define(\n    [\n        'StripeIntegration_Payments/js/view/checkout/summary/initial_fee'\n    ],\n    function (Component) {\n        'use strict';\n\n        return Component.extend(\n        {\n            isDisplayed: function ()\n            {\n                return this.getPureValue() !== 0;\n            }\n        });\n    }\n);\n","StripeIntegration_Payments/js/helper/subscriptions.js":"define(\n    [\n        'ko'\n    ],\n    function (\n        ko\n    ) {\n        'use strict';\n\n        return {\n            isSubscriptionUpdate: function()\n            {\n                return !!(window.checkoutConfig &&\n                    window.checkoutConfig.payment &&\n                    window.checkoutConfig.payment.stripe_payments &&\n                    window.checkoutConfig.payment.stripe_payments.subscriptionUpdateDetails);\n            },\n\n            getConfig: function(key)\n            {\n                var config = null;\n\n                if (window.checkoutConfig && window.checkoutConfig.payment && window.checkoutConfig.payment.stripe_payments)\n                {\n                    config = window.checkoutConfig.payment.stripe_payments;\n                }\n\n                if (!config || !config.subscriptionUpdateDetails)\n                {\n                    return null;\n                }\n\n                if (!config.subscriptionUpdateDetails[key])\n                {\n                    return \"--\";\n                }\n\n                return config.subscriptionUpdateDetails[key];\n            },\n\n            getSuccessUrl: function()\n            {\n                return this.getConfig(\"success_url\");\n            },\n\n            getCancelUrl: function()\n            {\n                return this.getConfig(\"cancel_url\");\n            },\n\n            displaySidebar: function()\n            {\n                return this.isSubscriptionUpdate();\n                    // && !window.checkoutConfig.payment.stripe_payments.subscriptionUpdateDetails.is_virtual\n                    // && window.location.href.indexOf('#payment') < 0;\n            }\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-checkout-session-id.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage'\n    ],\n    function (urlBuilder, storage) {\n        'use strict';\n\n        return function ()\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/get_checkout_session_id', {});\n\n            return storage.get(serviceUrl);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/delete-payment-method.js":"define(\n    [\n        'mage/url',\n        'mage/storage'\n    ],\n    function (\n        urlBuilder,\n        storage\n    ) {\n        'use strict';\n        return function (paymentMethodId, fingerprint, callback)\n        {\n            var serviceUrl = urlBuilder.build('rest/V1/stripe/payments/delete_payment_method');\n\n            var payload = {\n                paymentMethodId: paymentMethodId\n            };\n\n            if (fingerprint)\n            {\n                payload.fingerprint = fingerprint;\n            }\n\n            return storage.post(serviceUrl, JSON.stringify(payload)).always(callback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-trialing-subscriptions.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (urlBuilder, storage, errorProcessor, fullScreenLoader, quote) {\n        'use strict';\n        return function (quote)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/get_trialing_subscriptions', {});\n\n            var payload = {\n                billingAddress: quote.billingAddress()\n            };\n\n            if (quote.shippingAddress())\n                payload.shippingAddress = quote.shippingAddress();\n\n            if (quote.shippingMethod())\n                payload.shippingMethod = quote.shippingMethod();\n\n            var totals = quote.totals();\n            if (typeof totals.coupon_code != \"undefined\" && totals.coupon_code && totals.coupon_code.length > 0)\n                payload.couponCode = totals.coupon_code;\n\n            return storage.post(serviceUrl, JSON.stringify(payload));\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/finalize-multishipping-order.js":"define(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Customer/js/customer-data',\n        'Magento_Ui/js/modal/alert'\n    ],\n    function ($, urlBuilder, storage, customerData, alert) {\n        'use strict';\n\n        var showError = function(message, e)\n        {\n            alert( { content: message });\n\n            if (typeof e != \"undefined\")\n                console.error(e);\n        };\n\n        return function (error)\n        {\n            customerData.invalidate(['cart']);\n\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/finalize_multishipping_order', {});\n            var payload = { error: error };\n\n            return storage.post(serviceUrl, JSON.stringify(payload))\n            .then(function(result, b, c)\n            {\n                var response = null;\n\n                try\n                {\n                    response = JSON.parse(result);\n                }\n                catch (e)\n                {\n                    return showError(\"Sorry, a server side error has occurred.\", e);\n                }\n\n                if (response.error)\n                    return showError(response.error, response.error);\n\n                if (response.redirect)\n                    return $.mage.redirect(response.redirect);\n\n                return showError(response, response);\n            })\n            .fail(function(result)\n            {\n                return showError(\"Sorry, a server side error has occurred.\", result);\n            });\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-requires-action.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'Magento_Customer/js/customer-data',\n        'mage/storage'\n    ],\n    function (urlBuilder, customerData, storage) {\n        'use strict';\n\n        var promise = null; // If this is set, the promise is not resolved\n\n        return function (callback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/get_requires_action', {});\n\n            customerData.invalidate(['cart']);\n\n            if (!promise)\n                promise = storage.get(serviceUrl);\n            else\n                return promise.always(callback); // Stack multiple callbacks onto the promise\n\n            return promise.always(function(result, outcome, response)\n            {\n                promise = null; // Marks it as resolved\n                callback(result, outcome, response);\n            });\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/post-update-cart.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (urlBuilder, storage, customerData) {\n        'use strict';\n        return function (data, callback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/update_cart', {});\n\n            // This API call may inactivate the customer cart\n            customerData.invalidate(['cart']);\n\n            if (data)\n            {\n                return storage.post(\n                    serviceUrl,\n                    JSON.stringify({ data: data })\n                ).always(callback);\n            }\n            else\n            {\n\n                return storage.post(serviceUrl).always(callback);\n            }\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/list-payment-methods.js":"define(\n    [\n        'mage/url',\n        'mage/storage'\n    ],\n    function (\n        urlBuilder,\n        storage\n    ) {\n        'use strict';\n        return function (callback)\n        {\n            var serviceUrl = urlBuilder.build('rest/V1/stripe/payments/list_payment_methods');\n\n            return storage.get(serviceUrl).always(callback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-upcoming-invoice.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage'\n    ],\n    function (urlBuilder, storage) {\n        'use strict';\n\n        var promise = null; // If this is set, the promise is not resolved\n\n        return function (callback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/get_upcoming_invoice', {});\n\n            if (!promise)\n                promise = storage.get(serviceUrl);\n            else\n                return promise.always(callback); // Stack multiple callbacks onto the promise\n\n            return promise.always(function(result, outcome, response)\n            {\n                promise = null; // Marks it as resolved\n                callback(result, outcome, response);\n            });\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-checkout-methods.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (urlBuilder, storage, errorProcessor, fullScreenLoader, quote) {\n        'use strict';\n\n        var timesRequested = 0;\n\n        return function (quote, onDoneCallback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/get_checkout_payment_methods', {});\n\n            var payload = {\n                billingAddress: quote.billingAddress()\n            };\n\n            if (quote.shippingAddress())\n                payload.shippingAddress = quote.shippingAddress();\n\n            if (quote.shippingMethod())\n                payload.shippingMethod = quote.shippingMethod();\n\n            var totals = quote.totals();\n            if (typeof totals.coupon_code != \"undefined\" && totals.coupon_code && totals.coupon_code.length > 0)\n                payload.couponCode = totals.coupon_code;\n\n            try\n            {\n                if (!payload.billingAddress.countryId.length)\n                    return;\n\n                if (!quote.isVirtual())\n                {\n                    if (!payload.shippingAddress.countryId.length)\n                        return;\n                }\n\n                if (timesRequested > 0)\n                    return;\n            }\n            catch (e)\n            {\n                return;\n            }\n\n            timesRequested++;\n            return storage.post(serviceUrl, JSON.stringify(payload)).done(onDoneCallback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/post-restore-quote.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/quote'\n    ],\n    function (\n        urlBuilder,\n        storage,\n        customerData,\n        quote\n    ) {\n        'use strict';\n        return function (callback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/restore_quote', {});\n\n            customerData.invalidate(['cart']);\n\n            return storage.post(serviceUrl).always(callback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/place-multishipping-order.js":"define(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Customer/js/customer-data',\n        'Magento_Ui/js/modal/alert'\n    ],\n    function ($, urlBuilder, storage, customerData, alert) {\n        'use strict';\n\n        var showError = function(message, e)\n        {\n            alert( { content: message });\n\n            if (typeof e != \"undefined\")\n                console.error(e);\n        };\n\n        return function (callback, onAuthenticationRequired)\n        {\n            customerData.invalidate(['cart']);\n\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/place_multishipping_order', {});\n\n            return storage.post(serviceUrl)\n            .then(function(result, b, c)\n            {\n                var response = null;\n\n                try\n                {\n                    response = JSON.parse(result);\n                }\n                catch (e)\n                {\n                    return showError(\"Sorry, a server side error has occurred.\", e);\n                }\n\n                if (response.error)\n                    return showError(response.error, response.error);\n\n                if (response.redirect)\n                    return $.mage.redirect(response.redirect);\n\n                if (response.authenticate)\n                    return onAuthenticationRequired(response.authenticate);\n\n                return showError(response, response);\n            })\n            .fail(function(result)\n            {\n                return showError(\"Sorry, a server side error has occurred.\", result);\n            })\n            .always(callback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/get-payment-url.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (urlBuilder, storage, errorProcessor, fullScreenLoader) {\n        'use strict';\n        return function (messageContainer) {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/redirect_url', {});\n\n            fullScreenLoader.startLoader();\n\n            return storage.get(\n                serviceUrl\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/post-cancel-order.js":"define(\n    [\n        'Magento_Checkout/js/model/url-builder',\n        'Magento_Customer/js/customer-data',\n        'mage/storage'\n    ],\n    function (urlBuilder, customerData, storage) {\n        'use strict';\n\n        var promise = null; // If this is set, the promise is not resolved\n\n        return function (errorMessage, callback)\n        {\n            var serviceUrl = urlBuilder.createUrl('/stripe/payments/cancel_last_order', {});\n\n            var payload = {\n                errorMessage: errorMessage\n            };\n\n            customerData.invalidate(['cart']);\n\n            if (!promise)\n                promise = storage.post(serviceUrl, JSON.stringify(payload));\n            else\n                return promise.always(callback); // Stack multiple callbacks onto the promise\n\n            return promise.always(function(result, outcome, response)\n            {\n                promise = null; // Marks it as resolved\n                callback(result, outcome, response);\n            });\n        };\n    }\n);\n","StripeIntegration_Payments/js/action/add-payment-method.js":"define(\n    [\n        'mage/url',\n        'mage/storage'\n    ],\n    function (\n        urlBuilder,\n        storage\n    ) {\n        'use strict';\n        return function (paymentMethodId, callback)\n        {\n            var serviceUrl = urlBuilder.build('rest/V1/stripe/payments/add_payment_method');\n\n            var payload = {\n                paymentMethodId: paymentMethodId\n            };\n\n            return storage.post(serviceUrl, JSON.stringify(payload)).always(callback);\n        };\n    }\n);\n","StripeIntegration_Payments/js/model/upcomingInvoice.js":"define(\n    [\n        'ko',\n        'Magento_Checkout/js/model/quote',\n        'StripeIntegration_Payments/js/action/get-upcoming-invoice',\n    ],\n    function (\n        ko,\n        quote,\n        getUpcomingInvoiceAction\n    ) {\n        'use strict';\n\n        return {\n            upcomingInvoiceRequest: null,\n            initialized: false,\n            currentTotals: null,\n            callbacks: [],\n\n            initialize: function()\n            {\n                if (this.initialized)\n                    return;\n\n                this.initialized = true;\n\n                this.watchTotals();\n                getUpcomingInvoiceAction(this.upcomingInvoiceChanged.bind(this));\n            },\n\n            watchTotals: function()\n            {\n                this.currentTotals = quote.totals();\n                var upcomingInvoiceChanged = this.upcomingInvoiceChanged.bind(this);\n                var self = this;\n\n                quote.totals.subscribe(function (totals)\n                {\n                    if (JSON.stringify(totals.total_segments) == JSON.stringify(self.currentTotals.total_segments))\n                        return;\n\n                    self.currentTotals = totals;\n\n                    getUpcomingInvoiceAction(upcomingInvoiceChanged);\n                }, self);\n            },\n\n            upcomingInvoiceChanged: function(result, outcome, response)\n            {\n                this.upcomingInvoiceRequest = {\n                    result: result,\n                    outcome: outcome,\n                    response: response\n                };\n\n                for (var i = 0; i < this.callbacks.length; i++)\n                {\n                    this.callbacks[i](result, outcome, response);\n                }\n            },\n\n            onChange: function(callback)\n            {\n                this.callbacks.push(callback);\n\n                if (this.upcominInvoiceRequest)\n                {\n                    callback(this.upcominInvoiceRequest.result, this.upcominInvoiceRequest.outcome, this.upcominInvoiceRequest.response);\n                }\n            }\n        };\n    }\n);\n","Magento_Checkout/js/discount-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.discountCode', {\n        options: {\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.couponCode = $(this.options.couponCodeSelector);\n            this.removeCoupon = $(this.options.removeCouponSelector);\n\n            $(this.options.applyButton).on('click', $.proxy(function () {\n                this.couponCode.attr('data-validate', '{required:true}');\n                this.removeCoupon.attr('value', '0');\n                $(this.element).validation().trigger('submit');\n            }, this));\n\n            $(this.options.cancelButton).on('click', $.proxy(function () {\n                this.couponCode.removeAttr('data-validate');\n                this.removeCoupon.attr('value', '1');\n                this.element.trigger('submit');\n            }, this));\n        }\n    });\n\n    return $.mage.discountCode;\n});\n","Magento_Checkout/js/checkout-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'checkout-data',\n\n        /**\n         * @param {Object} data\n         */\n        saveData = function (data) {\n            storage.set(cacheKey, data);\n        },\n\n        /**\n         * @return {*}\n         */\n        initData = function () {\n            return {\n                'selectedShippingAddress': null, //Selected shipping address pulled from persistence storage\n                'shippingAddressFromData': null, //Shipping address pulled from persistence storage\n                'newCustomerShippingAddress': null, //Shipping address pulled from persistence storage for customer\n                'selectedShippingRate': null, //Shipping rate pulled from persistence storage\n                'selectedPaymentMethod': null, //Payment method pulled from persistence storage\n                'selectedBillingAddress': null, //Selected billing address pulled from persistence storage\n                'billingAddressFromData': null, //Billing address pulled from persistence storage\n                'newCustomerBillingAddress': null //Billing address pulled from persistence storage for new customer\n            };\n        },\n\n        /**\n         * @return {*}\n         */\n        getData = function () {\n            var data = storage.get(cacheKey)();\n\n            if ($.isEmptyObject(data)) {\n                data = $.initNamespaceStorage('mage-cache-storage').localStorage.get(cacheKey);\n\n                if ($.isEmptyObject(data)) {\n                    data = initData();\n                    saveData(data);\n                }\n            }\n\n            return data;\n        };\n\n    return {\n        /**\n         * Setting the selected shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingAddress: function () {\n            return getData().selectedShippingAddress;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setShippingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.shippingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getShippingAddressFromData: function () {\n            return getData().shippingAddressFromData;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerShippingAddress: function () {\n            return getData().newCustomerShippingAddress;\n        },\n\n        /**\n         * Setting the selected shipping rate pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingRate: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingRate = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping rate from local storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingRate: function () {\n            return getData().selectedShippingRate;\n        },\n\n        /**\n         * Setting the selected payment method pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedPaymentMethod: function (data) {\n            var obj = getData();\n\n            obj.selectedPaymentMethod = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the payment method from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedPaymentMethod: function () {\n            return getData().selectedPaymentMethod;\n        },\n\n        /**\n         * Setting the selected billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedBillingAddress: function () {\n            return getData().selectedBillingAddress;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setBillingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.billingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getBillingAddressFromData: function () {\n            return getData().billingAddressFromData;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerBillingAddress: function () {\n            return getData().newCustomerBillingAddress;\n        },\n\n        /**\n         * Pulling the email address from persistence storage\n         *\n         * @return {*}\n         */\n        getValidatedEmailValue: function () {\n            var obj = getData();\n\n            return obj.validatedEmailValue ? obj.validatedEmailValue : '';\n        },\n\n        /**\n         * Setting the email address pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setValidatedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.validatedEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the email input field value from persistence storage\n         *\n         * @return {*}\n         */\n        getInputFieldEmailValue: function () {\n            var obj = getData();\n\n            return obj.inputFieldEmailValue ? obj.inputFieldEmailValue : '';\n        },\n\n        /**\n         * Setting the email input field value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setInputFieldEmailValue: function (email) {\n            var obj = getData();\n\n            obj.inputFieldEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the checked email value from persistence storage\n         *\n         * @return {*}\n         */\n        getCheckedEmailValue: function () {\n            var obj = getData();\n\n            return obj.checkedEmailValue ? obj.checkedEmailValue : '';\n        },\n\n        /**\n         * Setting the checked email value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setCheckedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.checkedEmailValue = email;\n            saveData(obj);\n        }\n    };\n});\n","Magento_Checkout/js/proceed-to-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data'\n], function ($, authenticationPopup, customerData) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('click', function (event) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            event.preventDefault();\n\n            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                authenticationPopup.showModal();\n\n                return false;\n            }\n            $(element).attr('disabled', true);\n            location.href = config.checkoutUrl;\n        });\n\n    };\n});\n","Magento_Checkout/js/shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.shoppingCart', {\n        /** @inheritdoc */\n        _create: function () {\n            var items, i, reload;\n\n            $(this.options.emptyCartButton).on('click', $.proxy(function () {\n                this._confirmClearCart();\n            }, this));\n            items = $.find('[data-role=\"cart-item-qty\"]');\n\n            for (i = 0; i < items.length; i++) {\n                $(items[i]).on('keypress', $.proxy(function (event) { //eslint-disable-line no-loop-func\n                    var keyCode = event.keyCode ? event.keyCode : event.which;\n\n                    if (keyCode == 13) { //eslint-disable-line eqeqeq\n                        $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                        $(this.options.updateCartActionContainer)\n                            .attr('name', 'update_cart_action').attr('value', 'update_qty');\n\n                    }\n                }, this));\n            }\n            $(this.options.continueShoppingButton).on('click', $.proxy(function () {\n                location.href = this.options.continueShoppingUrl;\n            }, this));\n\n            $(document).on('ajax:removeFromCart', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n            $(document).on('ajax:updateItemQty', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n        },\n\n        /**\n         * Display confirmation modal for clearing the cart\n         * @private\n         */\n        _confirmClearCart: function () {\n            var self = this;\n\n            confirm({\n                content: $.mage.__('Are you sure you want to remove all items from your shopping cart?'),\n                actions: {\n                    /**\n                     * Confirmation modal handler to execute clear cart action\n                     */\n                    confirm: function () {\n                        self.clearCart();\n                    }\n                }\n            });\n        },\n\n        /**\n         * Prepares the form and submit to clear the cart\n         * @public\n         */\n        clearCart: function () {\n            $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n            $(this.options.updateCartActionContainer)\n                .attr('name', 'update_cart_action').attr('value', 'empty_cart');\n\n            if ($(this.options.emptyCartButton).parents('form').length > 0) {\n                $(this.options.emptyCartButton).parents('form').trigger('submit');\n            }\n        }\n    });\n\n    return $.mage.shoppingCart;\n});\n","Magento_Checkout/js/empty-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_Customer/js/customer-data'], function (customerData) {\n    'use strict';\n\n    return function () {\n        var cartData = customerData.get('cart');\n\n        customerData.getInitCustomerData().done(function () {\n            if (cartData().items && cartData().items.length !== 0) {\n                customerData.reload(['cart'], false);\n            }\n        });\n    };\n});\n","Magento_Checkout/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.regionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                    '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    // clear region inputs on country change\n                    $(this.options.regionListId).val('');\n                    $(this.options.regionInputId).val('');\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                    this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('.mage-error').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('.mage-error').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('.mage-error').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                container = regionList.parents('div.field'),\n                regionsEntries,\n                regionId,\n                regionData;\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                regionsEntries = _.pairs(this.options.regionJson[country]);\n                regionsEntries.sort(function (a, b) {\n                    return a[1].name > b[1].name ? 1 : -1;\n                });\n                $.each(regionsEntries, $.proxy(function (key, value) {\n                    regionId = value[0];\n                    regionData = value[1];\n                    this._renderSelectOption(regionList, regionId, regionData);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').prop('disabled', false);\n                    container.addClass('required').show();\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    container.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.hide();\n                        container.hide();\n                    } else {\n                        regionList.prop('disabled', false).show();\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                this._removeSelectOptions(regionList);\n\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').prop('disabled', false);\n                    container.addClass('required').show();\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                        container.hide();\n                    }\n                    container.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n            this.options.form.find('[type=\"submit\"]').prop('disabled', false).show();\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.regionUpdater;\n});\n","Magento_Checkout/js/checkout-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'rjsResolver'\n], function (resolver) {\n    'use strict';\n\n    /**\n     * Removes provided loader element from DOM.\n     *\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function hideLoader($loader) {\n        $loader.parentNode.removeChild($loader);\n    }\n\n    /**\n     * Initializes assets loading process listener.\n     *\n     * @param {Object} config - Optional configuration\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function init(config, $loader) {\n        resolver(hideLoader.bind(null, $loader));\n    }\n\n    return init;\n});\n","Magento_Checkout/js/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/decorate',\n    'mage/collapsible',\n    'mage/cookies',\n    'jquery-ui-modules/effect-fade'\n], function ($, authenticationPopup, customerData, alert, confirm, _) {\n    'use strict';\n\n    $.widget('mage.sidebar', {\n        options: {\n            isRecursive: true,\n            minicart: {\n                maxItemsVisible: 3\n            }\n        },\n        scrollHeight: 0,\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n\n        /**\n         * Create sidebar.\n         * @private\n         */\n        _create: function () {\n            this._initContent();\n        },\n\n        /**\n         * Update sidebar block.\n         */\n        update: function () {\n            $(this.options.targetElement).trigger('contentUpdated');\n            this._calcHeight();\n        },\n\n        /**\n         * @private\n         */\n        _initContent: function () {\n            var self = this,\n                events = {};\n\n            this.element.decorate('list', this.options.isRecursive);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.close] = function (event) {\n                event.stopPropagation();\n                $(self.options.targetElement).dropdownDialog('close');\n            };\n            events['click ' + this.options.button.checkout] = $.proxy(function () {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer'),\n                    element = $(this.options.button.checkout);\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    // set URL for redirect on successful login/registration. It's postprocessed on backend.\n                    $.cookie('login_redirect', this.options.url.checkout);\n\n                    if (this.options.url.isRedirectRequired) {\n                        element.prop('disabled', true);\n                        location.href = this.options.url.loginUrl;\n                    } else {\n                        authenticationPopup.showModal();\n                    }\n\n                    return false;\n                }\n                element.prop('disabled', true);\n                location.href = this.options.url.checkout;\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.remove] =  function (event) {\n                event.stopPropagation();\n                confirm({\n                    content: self.options.confirmMessage,\n                    actions: {\n                        /** @inheritdoc */\n                        confirm: function () {\n                            self._removeItem($(event.currentTarget));\n                        },\n\n                        /** @inheritdoc */\n                        always: function (e) {\n                            e.stopImmediatePropagation();\n                        }\n                    }\n                });\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['keyup ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['change ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.item.button] = function (event) {\n                event.stopPropagation();\n                self._updateItemQty($(event.currentTarget));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['focusout ' + this.options.item.qty] = function (event) {\n                self._validateQty($(event.currentTarget));\n            };\n\n            this._on(this.element, events);\n            this._calcHeight();\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _showItemButton: function (elem) {\n            var itemId = elem.data('cart-item'),\n                itemQty = elem.data('item-qty');\n\n            if (this._isValidQty(itemQty, elem.val())) {\n                $('#update-cart-item-' + itemId).show('fade', 300);\n            } else if (elem.val() == 0) { //eslint-disable-line eqeqeq\n                this._hideItemButton(elem);\n            } else {\n                this._hideItemButton(elem);\n            }\n        },\n\n        /**\n         * @param {*} origin - origin qty. 'data-item-qty' attribute.\n         * @param {*} changed - new qty.\n         * @returns {Boolean}\n         * @private\n         */\n        _isValidQty: function (origin, changed) {\n            return origin != changed && //eslint-disable-line eqeqeq\n                changed.length > 0 &&\n                changed - 0 == changed && //eslint-disable-line eqeqeq\n                changed - 0 > 0;\n        },\n\n        /**\n         * @param {Object} elem\n         * @private\n         */\n        _validateQty: function (elem) {\n            var itemQty = elem.data('item-qty');\n\n            if (!this._isValidQty(itemQty, elem.val())) {\n                elem.val(itemQty);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _hideItemButton: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            $('#update-cart-item-' + itemId).hide('fade', 300);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _updateItemQty: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.update, {\n                'item_id': itemId,\n                'item_qty': $('#cart-item-' + itemId + '-qty').val()\n            }, elem, this._updateItemQtyAfter);\n        },\n\n        /**\n         * Update content after update qty\n         *\n         * @param {HTMLElement} elem\n         */\n        _updateItemQtyAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:updateCartItemQty');\n\n                if (window.location.href === this.shoppingCartUrl) {\n                    window.location.reload(false);\n                }\n            }\n            this._hideItemButton(elem);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _removeItem: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.remove, {\n                'item_id': itemId\n            }, elem, this._removeItemAfter);\n        },\n\n        /**\n         * Update content after item remove\n         *\n         * @param {Object} elem\n         * @private\n         */\n        _removeItemAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:removeFromCart', {\n                    productIds: [productData['product_id']],\n                    productInfo: [\n                        {\n                            'id': productData['product_id']\n                        }\n                    ]\n                });\n\n                if (window.location.href.indexOf(this.shoppingCartUrl) === 0) {\n                    window.location.reload();\n                }\n            }\n        },\n\n        /**\n         * Retrieves product data by Id.\n         *\n         * @param {Number} productId - product Id\n         * @returns {Object|undefined}\n         * @private\n         */\n        _getProductById: function (productId) {\n            return _.find(customerData.get('cart')().items, function (item) {\n                return productId === Number(item['item_id']);\n            });\n        },\n\n        /**\n         * @param {String} url - ajax url\n         * @param {Object} data - post data for ajax call\n         * @param {Object} elem - element that initiated the event\n         * @param {Function} callback - callback method to execute after AJAX success\n         */\n        _ajax: function (url, data, elem, callback) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    elem.attr('disabled', 'disabled');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    elem.attr('disabled', null);\n                }\n            })\n                .done(function (response) {\n                    var msg;\n\n                    if (response.success) {\n                        callback.call(this, elem, response);\n                    } else {\n                        msg = response['error_message'];\n\n                        if (msg) {\n                            alert({\n                                content: msg\n                            });\n                        }\n                    }\n                })\n                .fail(function (error) {\n                    console.log(JSON.stringify(error));\n                });\n        },\n\n        /**\n         * Calculate height of minicart list\n         *\n         * @private\n         */\n        _calcHeight: function () {\n            var self = this,\n                height = 0,\n                counter = this.options.minicart.maxItemsVisible,\n                target = $(this.options.minicart.list),\n                outerHeight;\n\n            self.scrollHeight = 0;\n            target.children().each(function () {\n\n                if ($(this).find('.options').length > 0) {\n                    $(this).collapsible();\n                }\n                outerHeight = $(this).outerHeight(true);\n\n                if (counter-- > 0) {\n                    height += outerHeight;\n                }\n                self.scrollHeight += outerHeight;\n            });\n\n            target.parent().height(height);\n        }\n    });\n\n    return $.mage.sidebar;\n});\n","Magento_Checkout/js/view/authentication.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/model/customer',\n    'mage/validation',\n    'Magento_Checkout/js/model/authentication-messages',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, loginAction, customer, validation, messageContainer, fullScreenLoader) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return Component.extend({\n        isGuestCheckoutAllowed: checkoutConfig.isGuestCheckoutAllowed,\n        isCustomerLoginRequired: checkoutConfig.isCustomerLoginRequired,\n        registerUrl: checkoutConfig.registerUrl,\n        forgotPasswordUrl: checkoutConfig.forgotPasswordUrl,\n        autocomplete: checkoutConfig.autocomplete,\n        defaults: {\n            template: 'Magento_Checkout/authentication'\n        },\n\n        /**\n         * Is login form enabled for current customer.\n         *\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return !customer.isLoggedIn();\n        },\n\n        /**\n         * Provide login action.\n         *\n         * @param {HTMLElement} loginForm\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if ($(loginForm).validation() &&\n                $(loginForm).validation('isValid')\n            ) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData, checkoutConfig.checkoutUrl, undefined, messageContainer).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/billing-address-postcode-validator',\n    'Magento_Checkout/js/model/address-converter'\n],\nfunction (\n    ko,\n    _,\n    Component,\n    customer,\n    addressList,\n    quote,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutData,\n    checkoutDataResolver,\n    customerData,\n    setBillingAddressAction,\n    globalMessageList,\n    $t,\n    billingAddressPostcodeValidator,\n    addressConverter\n) {\n    'use strict';\n\n    var lastSelectedBillingAddress = null,\n        addressUpdated = false,\n        addressEdited = false,\n        countryData = customerData.get('directory-data'),\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() === 'customer-address';\n        });\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address',\n            actionsTemplate: 'Magento_Checkout/billing-address/actions',\n            formTemplate: 'Magento_Checkout/billing-address/form',\n            detailsTemplate: 'Magento_Checkout/billing-address/details',\n            links: {\n                isAddressFormVisible: '${$.billingAddressListProvider}:isNewAddressSelected'\n            }\n        },\n        currentBillingAddress: quote.billingAddress,\n        customerHasAddresses: addressOptions.length > 0,\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            this._super();\n            quote.paymentMethod.subscribe(function () {\n                checkoutDataResolver.resolveBillingAddress();\n            }, this);\n            billingAddressPostcodeValidator.initFields(this.get('name') + '.form-fields');\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    selectedAddress: null,\n                    isAddressDetailsVisible: quote.billingAddress() != null,\n                    isAddressFormVisible: !customer.isLoggedIn() || !addressOptions.length,\n                    isAddressSameAsShipping: false,\n                    saveInAddressBook: 1\n                });\n\n            quote.billingAddress.subscribe(function (newAddress) {\n                if (quote.isVirtual()) {\n                    this.isAddressSameAsShipping(false);\n                } else {\n                    this.isAddressSameAsShipping(\n                        newAddress != null &&\n                        newAddress.getCacheKey() == quote.shippingAddress().getCacheKey() //eslint-disable-line eqeqeq\n                    );\n                }\n\n                if (newAddress != null && newAddress.saveInAddressBook !== undefined) {\n                    this.saveInAddressBook(newAddress.saveInAddressBook);\n                } else {\n                    this.saveInAddressBook(1);\n                }\n                this.isAddressDetailsVisible(true);\n            }, this);\n\n            return this;\n        },\n\n        canUseShippingAddress: ko.computed(function () {\n            return !quote.isVirtual() && quote.shippingAddress() && quote.shippingAddress().canUseForBilling();\n        }),\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        useShippingAddress: function () {\n            if (this.isAddressSameAsShipping()) {\n                selectBillingAddress(quote.shippingAddress());\n                this.updateAddresses(true);\n                this.isAddressDetailsVisible(true);\n            } else {\n                lastSelectedBillingAddress = quote.billingAddress();\n                quote.billingAddress(null);\n                this.isAddressDetailsVisible(false);\n            }\n            checkoutData.setSelectedBillingAddress(null);\n\n            return true;\n        },\n\n        /**\n         * Update address action\n         */\n        updateAddress: function () {\n            var addressData, newBillingAddress;\n\n            addressUpdated = true;\n\n            if (this.selectedAddress() && !this.isAddressFormVisible()) {\n                selectBillingAddress(this.selectedAddress());\n                checkoutData.setSelectedBillingAddress(this.selectedAddress().getKey());\n            } else {\n                this.source.set('params.invalid', false);\n                this.source.trigger(this.dataScopePrefix + '.data.validate');\n\n                if (this.source.get(this.dataScopePrefix + '.custom_attributes')) {\n                    this.source.trigger(this.dataScopePrefix + '.custom_attributes.data.validate');\n                }\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get(this.dataScopePrefix);\n\n                    if (customer.isLoggedIn() && !this.customerHasAddresses) { //eslint-disable-line max-depth\n                        this.saveInAddressBook(1);\n                    }\n                    addressData['save_in_address_book'] = this.saveInAddressBook() ? 1 : 0;\n                    newBillingAddress = createBillingAddress(addressData);\n                    // New address must be selected as a billing address\n                    selectBillingAddress(newBillingAddress);\n                    checkoutData.setSelectedBillingAddress(newBillingAddress.getKey());\n                    checkoutData.setNewCustomerBillingAddress(addressData);\n                }\n            }\n            this.updateAddresses(true);\n        },\n\n        /**\n         * Edit address action\n         */\n        editAddress: function () {\n            addressUpdated = false;\n            addressEdited = true;\n            lastSelectedBillingAddress = quote.billingAddress();\n            quote.billingAddress(null);\n            this.isAddressDetailsVisible(false);\n        },\n\n        /**\n         * Cancel address edit action\n         */\n        cancelAddressEdit: function () {\n            addressUpdated = true;\n            this.restoreBillingAddress();\n\n            if (quote.billingAddress()) {\n                // restore 'Same As Shipping' checkbox state\n                this.isAddressSameAsShipping(\n                    quote.billingAddress() != null &&\n                        quote.billingAddress().getCacheKey() == quote.shippingAddress().getCacheKey() && //eslint-disable-line\n                        !quote.isVirtual()\n                );\n                this.isAddressDetailsVisible(true);\n            }\n        },\n\n        /**\n         * Manage cancel button visibility\n         */\n        canUseCancelBillingAddress: ko.computed(function () {\n            return quote.billingAddress() || lastSelectedBillingAddress;\n        }),\n\n        /**\n         * Check if Billing Address Changes should be canceled\n         */\n        needCancelBillingAddressChanges: function () {\n            if (addressEdited && !addressUpdated) {\n                this.cancelAddressEdit();\n            }\n        },\n\n        /**\n         * Restore billing address\n         */\n        restoreBillingAddress: function () {\n            var lastBillingAddress;\n\n            if (lastSelectedBillingAddress != null) {\n                selectBillingAddress(lastSelectedBillingAddress);\n                lastBillingAddress = addressConverter.quoteAddressToFormAddressData(lastSelectedBillingAddress);\n\n                checkoutData.setNewCustomerBillingAddress(lastBillingAddress);\n            }\n        },\n\n        /**\n         * @param {Number} countryId\n         * @return {*}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Trigger action to update shipping and billing addresses\n         *\n         * @param {Boolean} force\n         */\n        updateAddresses: function (force) {\n            force = !(typeof force === 'undefined' || force !== true);\n\n            if (force\n                || window.checkoutConfig.reloadOnBillingAddress\n                || !window.checkoutConfig.displayBillingOnPaymentMethod) {\n                setBillingAddressAction(globalMessageList);\n            }\n        },\n\n        /**\n         * Get code\n         * @param {Object} parent\n         * @returns {String}\n         */\n        getCode: function (parent) {\n            return _.isFunction(parent.getCode) ? parent.getCode() : 'shared';\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else if (typeof attribute.value === 'object') {\n                label = _.map(Object.values(attribute.value)).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            } else if (value.file !== null) {\n                label = value.file;\n            }\n\n            return label;\n        }\n    });\n});\n","Magento_Checkout/js/view/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    quote,\n    stepNavigator,\n    paymentService,\n    methodConverter,\n    getPaymentInformation,\n    checkoutDataResolver,\n    $t\n) {\n    'use strict';\n\n    /** Set payment methods to collection */\n    paymentService.setPaymentMethods(methodConverter(window.checkoutConfig.paymentMethods));\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment',\n            activeMethod: ''\n        },\n        isVisible: ko.observable(quote.isVirtual()),\n        quoteIsVirtual: quote.isVirtual(),\n        isPaymentMethodsAvailable: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length > 0;\n        }),\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            checkoutDataResolver.resolvePaymentMethod();\n            stepNavigator.registerStep(\n                'payment',\n                null,\n                $t('Review & Payments'),\n                this.isVisible,\n                _.bind(this.navigate, this),\n                this.sortOrder\n            );\n\n            return this;\n        },\n\n        /**\n         * Navigate method.\n         */\n        navigate: function () {\n            var self = this;\n\n            if (!self.hasShippingMethod()) {\n                this.isVisible(false);\n                stepNavigator.setHash('shipping');\n            } else {\n                getPaymentInformation().done(function () {\n                    self.isVisible(true);\n                });\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasShippingMethod: function () {\n            return window.checkoutConfig.selectedShippingMethod !== null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getFormKey: function () {\n            return window.checkoutConfig.formKey;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading\n    });\n});\n","Magento_Checkout/js/view/estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, quote, priceUtils, totals, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading,\n\n        /**\n         * @return {Number}\n         */\n        getQuantity: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.totals()['items_qty']);\n            }\n\n            return 0;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.getSegment('grand_total').value);\n            }\n\n            return 0;\n        },\n\n        /**\n         * Show sidebar.\n         */\n        showSidebar: function () {\n            sidebarModel.show();\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/cart-item-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Prepare the product name value to be rendered as HTML\n         *\n         * @param {String} productName\n         * @return {String}\n         */\n        getProductNameUnsanitizedHtml: function (productName) {\n            // product name has already escaped on backend\n            return productName;\n        },\n\n        /**\n         * Prepare the given option value to be rendered as HTML\n         *\n         * @param {String} optionValue\n         * @return {String}\n         */\n        getOptionValueUnsanitizedHtml: function (optionValue) {\n            // option value has already escaped on backend\n            return optionValue;\n        }\n    });\n});\n","Magento_Checkout/js/view/registration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/model/messageList'\n], function ($, Component, messageList) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/registration',\n            accountCreated: false,\n            creationStarted: false,\n            isFormVisible: true\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('accountCreated')\n                .observe('isFormVisible')\n                .observe('creationStarted');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getEmailAddress: function () {\n            return this.email;\n        },\n\n        /**\n         * @return String\n         */\n        getUrl: function () {\n            return this.registrationUrl;\n        },\n\n        /**\n         * Create new user account.\n         *\n         * @deprecated\n         */\n        createAccount: function () {\n            this.creationStarted(true);\n            $.post(\n                this.registrationUrl\n            ).done(\n                function (response) {\n\n                    if (response.errors == false) { //eslint-disable-line eqeqeq\n                        this.accountCreated(true);\n                    } else {\n                        messageList.addErrorMessage(response);\n                    }\n                    this.isFormVisible(false);\n                }.bind(this)\n            ).fail(\n                function (response) {\n                    this.accountCreated(false);\n                    this.isFormVisible(false);\n                    messageList.addErrorMessage(response);\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/action/set-shipping-information',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Ui/js/modal/modal',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Checkout/js/checkout-data',\n    'uiRegistry',\n    'mage/translate',\n    'Magento_Checkout/js/model/shipping-rate-service'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    customer,\n    addressList,\n    addressConverter,\n    quote,\n    createShippingAddress,\n    selectShippingAddress,\n    shippingRatesValidator,\n    formPopUpState,\n    shippingService,\n    selectShippingMethodAction,\n    rateRegistry,\n    setShippingInformationAction,\n    stepNavigator,\n    modal,\n    checkoutDataResolver,\n    checkoutData,\n    registry,\n    $t\n) {\n    'use strict';\n\n    var popUp = null;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping',\n            shippingFormTemplate: 'Magento_Checkout/shipping-address/form',\n            shippingMethodListTemplate: 'Magento_Checkout/shipping-address/shipping-method-list',\n            shippingMethodItemTemplate: 'Magento_Checkout/shipping-address/shipping-method-item',\n            imports: {\n                countryOptions: '${ $.parentName }.shippingAddress.shipping-address-fieldset.country_id:indexedOptions'\n            }\n        },\n        visible: ko.observable(!quote.isVirtual()),\n        errorValidationMessage: ko.observable(false),\n        isCustomerLoggedIn: customer.isLoggedIn,\n        isFormPopUpVisible: formPopUpState.isVisible,\n        isFormInline: addressList().length === 0,\n        isNewAddressAdded: ko.observable(false),\n        saveInAddressBook: 1,\n        quoteIsVirtual: quote.isVirtual(),\n\n        /**\n         * @return {exports}\n         */\n        initialize: function () {\n            var self = this,\n                hasNewAddress,\n                fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n            this._super();\n\n            if (!quote.isVirtual()) {\n                stepNavigator.registerStep(\n                    'shipping',\n                    '',\n                    $t('Shipping'),\n                    this.visible, _.bind(this.navigate, this),\n                    this.sortOrder\n                );\n            }\n            checkoutDataResolver.resolveShippingAddress();\n\n            hasNewAddress = addressList.some(function (address) {\n                return address.getType() == 'new-customer-address'; //eslint-disable-line eqeqeq\n            });\n\n            this.isNewAddressAdded(hasNewAddress);\n\n            this.isFormPopUpVisible.subscribe(function (value) {\n                if (value) {\n                    self.getPopUp().openModal();\n                }\n            });\n\n            quote.shippingMethod.subscribe(function () {\n                self.errorValidationMessage(false);\n            });\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                if (shippingAddressData) {\n                    checkoutProvider.set(\n                        'shippingAddress',\n                        $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                    );\n                }\n                checkoutProvider.on('shippingAddress', function (shippingAddrsData, changes) {\n                    var isStreetAddressDeleted, isStreetAddressNotEmpty;\n\n                    /**\n                     * In last modifying operation street address was deleted.\n                     * @return {Boolean}\n                     */\n                    isStreetAddressDeleted = function () {\n                        var change;\n\n                        if (!changes || changes.length === 0) {\n                            return false;\n                        }\n\n                        change = changes.pop();\n\n                        if (_.isUndefined(change.value) || _.isUndefined(change.oldValue)) {\n                            return false;\n                        }\n\n                        if (!change.path.startsWith('shippingAddress.street')) {\n                            return false;\n                        }\n\n                        return change.value.length === 0 && change.oldValue.length > 0;\n                    };\n\n                    isStreetAddressNotEmpty = shippingAddrsData.street && !_.isEmpty(shippingAddrsData.street[0]);\n\n                    if (isStreetAddressNotEmpty || isStreetAddressDeleted()) {\n                        checkoutData.setShippingAddressFromData(shippingAddrsData);\n                    }\n                });\n                shippingRatesValidator.initFields(fieldsetName);\n            });\n\n            return this;\n        },\n\n        /**\n         * Navigator change hash handler.\n         *\n         * @param {Object} step - navigation step\n         */\n        navigate: function (step) {\n            step && step.isVisible(true);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPopUp: function () {\n            var self = this,\n                buttons;\n\n            if (!popUp) {\n                buttons = this.popUpForm.options.buttons;\n                this.popUpForm.options.buttons = [\n                    {\n                        text: buttons.save.text ? buttons.save.text : $t('Save Address'),\n                        class: buttons.save.class ? buttons.save.class : 'action primary action-save-address',\n                        click: self.saveNewAddress.bind(self)\n                    },\n                    {\n                        text: buttons.cancel.text ? buttons.cancel.text : $t('Cancel'),\n                        class: buttons.cancel.class ? buttons.cancel.class : 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: this.onClosePopUp.bind(this)\n                    }\n                ];\n\n                /** @inheritdoc */\n                this.popUpForm.options.closed = function () {\n                    self.isFormPopUpVisible(false);\n                };\n\n                this.popUpForm.options.modalCloseBtnHandler = this.onClosePopUp.bind(this);\n                this.popUpForm.options.keyEventHandlers = {\n                    escapeKey: this.onClosePopUp.bind(this)\n                };\n\n                /** @inheritdoc */\n                this.popUpForm.options.opened = function () {\n                    // Store temporary address for revert action in case when user click cancel action\n                    self.temporaryAddress = $.extend(true, {}, checkoutData.getShippingAddressFromData());\n                };\n                popUp = modal(this.popUpForm.options, $(this.popUpForm.element));\n            }\n\n            return popUp;\n        },\n\n        /**\n         * Revert address and close modal.\n         */\n        onClosePopUp: function () {\n            checkoutData.setShippingAddressFromData($.extend(true, {}, this.temporaryAddress));\n            this.getPopUp().closeModal();\n        },\n\n        /**\n         * Show address form popup\n         */\n        showFormPopUp: function () {\n            this.isFormPopUpVisible(true);\n        },\n\n        /**\n         * Save new shipping address\n         */\n        saveNewAddress: function () {\n            var addressData,\n                newShippingAddress;\n\n            this.source.set('params.invalid', false);\n            this.triggerShippingDataValidateEvent();\n\n            if (!this.source.get('params.invalid')) {\n                addressData = this.source.get('shippingAddress');\n                // if user clicked the checkbox, its value is true or false. Need to convert.\n                addressData['save_in_address_book'] = this.saveInAddressBook ? 1 : 0;\n\n                // New address must be selected as a shipping address\n                newShippingAddress = createShippingAddress(addressData);\n                selectShippingAddress(newShippingAddress);\n                checkoutData.setSelectedShippingAddress(newShippingAddress.getKey());\n                checkoutData.setNewCustomerShippingAddress($.extend(true, {}, addressData));\n                this.getPopUp().closeModal();\n                this.isNewAddressAdded(true);\n            }\n        },\n\n        /**\n         * Shipping Method View\n         */\n        rates: shippingService.getShippingRates(),\n        isLoading: shippingService.isLoading,\n        isSelected: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @param {Object} shippingMethod\n         * @return {Boolean}\n         */\n        selectShippingMethod: function (shippingMethod) {\n            selectShippingMethodAction(shippingMethod);\n            checkoutData.setSelectedShippingRate(shippingMethod['carrier_code'] + '_' + shippingMethod['method_code']);\n\n            return true;\n        },\n\n        /**\n         * Set shipping information handler\n         */\n        setShippingInformation: function () {\n            if (this.validateShippingInformation()) {\n                quote.billingAddress(null);\n                checkoutDataResolver.resolveBillingAddress();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                    if (shippingAddressData) {\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                        );\n                    }\n                });\n                setShippingInformationAction().done(\n                    function () {\n                        stepNavigator.next();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validateShippingInformation: function () {\n            var shippingAddress,\n                addressData,\n                loginFormSelector = 'form[data-role=email-with-possible-login]',\n                emailValidationResult = customer.isLoggedIn(),\n                field,\n                option = _.isObject(this.countryOptions) && this.countryOptions[quote.shippingAddress().countryId],\n                messageContainer = registry.get('checkout.errors').messageContainer;\n\n            if (!quote.shippingMethod()) {\n                this.errorValidationMessage(\n                    $t('The shipping method is missing. Select the shipping method and try again.')\n                );\n\n                return false;\n            }\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            if (this.isFormInline) {\n                this.source.set('params.invalid', false);\n                this.triggerShippingDataValidateEvent();\n\n                if (!quote.shippingMethod()['method_code']) {\n                    this.errorValidationMessage(\n                        $t('The shipping method is missing. Select the shipping method and try again.')\n                    );\n                }\n\n                if (emailValidationResult &&\n                    this.source.get('params.invalid') ||\n                    !quote.shippingMethod()['method_code'] ||\n                    !quote.shippingMethod()['carrier_code']\n                ) {\n                    this.focusInvalid();\n\n                    return false;\n                }\n\n                shippingAddress = quote.shippingAddress();\n                addressData = addressConverter.formAddressDataToQuoteAddress(\n                    this.source.get('shippingAddress')\n                );\n\n                //Copy form data to quote shipping address object\n                for (field in addressData) {\n                    if (addressData.hasOwnProperty(field) &&  //eslint-disable-line max-depth\n                        shippingAddress.hasOwnProperty(field) &&\n                        typeof addressData[field] != 'function' &&\n                        _.isEqual(shippingAddress[field], addressData[field])\n                    ) {\n                        shippingAddress[field] = addressData[field];\n                    } else if (typeof addressData[field] != 'function' &&\n                        !_.isEqual(shippingAddress[field], addressData[field])) {\n                        shippingAddress = addressData;\n                        break;\n                    }\n                }\n\n                if (customer.isLoggedIn()) {\n                    shippingAddress['save_in_address_book'] = 1;\n                }\n                selectShippingAddress(shippingAddress);\n            } else if (customer.isLoggedIn() &&\n                option &&\n                option['is_region_required'] &&\n                !quote.shippingAddress().region\n            ) {\n                messageContainer.addErrorMessage({\n                    message: $t('Please specify a regionId in shipping address.')\n                });\n\n                return false;\n            }\n\n            if (!emailValidationResult) {\n                $(loginFormSelector + ' input[name=username]').trigger('focus');\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger Shipping data Validate Event.\n         */\n        triggerShippingDataValidateEvent: function () {\n            this.source.trigger('shippingAddress.data.validate');\n\n            if (this.source.get('shippingAddress.custom_attributes')) {\n                this.source.trigger('shippingAddress.custom_attributes.data.validate');\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    'Magento_Checkout/js/model/authentication-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_Checkout/js/view/progress-bar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/view/billing-address'\n], function ($, _, ko, Component, stepNavigator, billingAddress) {\n    'use strict';\n\n    var steps = stepNavigator.steps;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/progress-bar',\n            visible: true\n        },\n        steps: steps,\n\n        /** @inheritdoc */\n        initialize: function () {\n            var stepsValue;\n\n            this._super();\n            window.addEventListener('hashchange', _.bind(stepNavigator.handleHash, stepNavigator));\n\n            if (!window.location.hash) {\n                stepsValue = stepNavigator.steps();\n\n                if (stepsValue.length) {\n                    stepNavigator.setHash(stepsValue.sort(stepNavigator.sortItems)[0].code);\n                }\n            }\n\n            stepNavigator.handleHash();\n        },\n\n        /**\n         * @param {*} itemOne\n         * @param {*} itemTwo\n         * @return {*|Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return stepNavigator.sortItems(itemOne, itemTwo);\n        },\n\n        /**\n         * @param {Object} step\n         */\n        navigateTo: function (step) {\n            if (step.code === 'shipping') {\n                billingAddress().needCancelBillingAddressChanges();\n            }\n            stepNavigator.navigateTo(step.code);\n        },\n\n        /**\n         * @param {Object} item\n         * @return {*|Boolean}\n         */\n        isProcessed: function (item) {\n            return stepNavigator.isProcessed(item.code);\n        }\n    });\n});\n","Magento_Checkout/js/view/minicart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar',\n    'mage/translate',\n    'mage/dropdown'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        addToCartCalls = 0,\n        miniCart;\n\n    miniCart = $('[data-block=\\'minicart\\']');\n\n    /**\n     * @return {Boolean}\n     */\n    function initSidebar() {\n        if (miniCart.data('mageSidebar')) {\n            miniCart.sidebar('update');\n        }\n\n        if (!$('[data-role=product-item]').length) {\n            return false;\n        }\n        miniCart.trigger('contentUpdated');\n\n        if (sidebarInitialized) {\n            return false;\n        }\n        sidebarInitialized = true;\n        miniCart.sidebar({\n            'targetElement': 'div.block.block-minicart',\n            'url': {\n                'checkout': window.checkout.checkoutUrl,\n                'update': window.checkout.updateItemQtyUrl,\n                'remove': window.checkout.removeItemUrl,\n                'loginUrl': window.checkout.customerLoginUrl,\n                'isRedirectRequired': window.checkout.isRedirectRequired\n            },\n            'button': {\n                'checkout': '#top-cart-btn-checkout',\n                'remove': '#mini-cart a.action.delete',\n                'close': '#btn-minicart-close'\n            },\n            'showcart': {\n                'parent': 'span.counter',\n                'qty': 'span.counter-number',\n                'label': 'span.counter-label'\n            },\n            'minicart': {\n                'list': '#mini-cart',\n                'content': '#minicart-content-wrapper',\n                'qty': 'div.items-total',\n                'subtotal': 'div.subtotal span.price',\n                'maxItemsVisible': window.checkout.minicartMaxItemsVisible\n            },\n            'item': {\n                'qty': ':input.cart-item-qty',\n                'button': ':button.update-cart-item'\n            },\n            'confirmMessage': $.mage.__('Are you sure you would like to remove this item from the shopping cart?')\n        });\n    }\n\n    miniCart.on('dropdowndialogopen', function () {\n        initSidebar();\n    });\n\n    return Component.extend({\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n        maxItemsToDisplay: window.checkout.maxItemsToDisplay,\n        cart: {},\n\n        // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n        /**\n         * @override\n         */\n        initialize: function () {\n            var self = this,\n                cartData = customerData.get('cart');\n\n            this.update(cartData());\n            cartData.subscribe(function (updatedCart) {\n                addToCartCalls--;\n                this.isLoading(addToCartCalls > 0);\n                sidebarInitialized = false;\n                this.update(updatedCart);\n                initSidebar();\n            }, this);\n            $('[data-block=\"minicart\"]').on('contentLoading', function () {\n                addToCartCalls++;\n                self.isLoading(true);\n            });\n\n            if (\n                cartData().website_id !== window.checkout.websiteId && cartData().website_id !== undefined ||\n                cartData().storeId !== window.checkout.storeId && cartData().storeId !== undefined\n            ) {\n                customerData.reload(['cart'], false);\n            }\n\n            return this._super();\n        },\n        //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n        isLoading: ko.observable(false),\n        initSidebar: initSidebar,\n\n        /**\n         * Close mini shopping cart.\n         */\n        closeMinicart: function () {\n            $('[data-block=\"minicart\"]').find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n        },\n\n        /**\n         * @param {String} productType\n         * @return {*|String}\n         */\n        getItemRenderer: function (productType) {\n            return this.itemRenderer[productType] || 'defaultRenderer';\n        },\n\n        /**\n         * Update mini shopping cart content.\n         *\n         * @param {Object} updatedCart\n         * @returns void\n         */\n        update: function (updatedCart) {\n            _.each(updatedCart, function (value, key) {\n                if (!this.cart.hasOwnProperty(key)) {\n                    this.cart[key] = ko.observable();\n                }\n                this.cart[key](value);\n            }, this);\n        },\n\n        /**\n         * Get cart param by name.\n         *\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParamUnsanitizedHtml: function (name) {\n            if (!_.isUndefined(name)) {\n                if (!this.cart.hasOwnProperty(name)) {\n                    this.cart[name] = ko.observable();\n                }\n            }\n\n            return this.cart[name]();\n        },\n\n        /**\n         * @deprecated please use getCartParamUnsanitizedHtml.\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParam: function (name) {\n            return this.getCartParamUnsanitizedHtml(name);\n        },\n\n        /**\n         * Returns array of cart items, limited by 'maxItemsToDisplay' setting\n         * @returns []\n         */\n        getCartItems: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            items = items.slice(parseInt(-this.maxItemsToDisplay, 10));\n\n            return items;\n        },\n\n        /**\n         * Returns count of cart line items\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            return parseInt(items.length, 10);\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/sidebar'\n], function ($, Component, quote, stepNavigator, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVisible: function () {\n            return !quote.isVirtual() && stepNavigator.isProcessed('shipping');\n        },\n\n        /**\n         * @return {String}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod = quote.shippingMethod(),\n                shippingMethodTitle = '';\n\n            if (!shippingMethod) {\n                return '';\n            }\n\n            shippingMethodTitle = shippingMethod['carrier_title'];\n\n            if (typeof shippingMethod['method_title'] !== 'undefined') {\n                shippingMethodTitle += ' - ' + shippingMethod['method_title'];\n            }\n\n            return shippingMethodTitle;\n        },\n\n        /**\n         * Back step.\n         */\n        back: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping');\n        },\n\n        /**\n         * Back to shipping method.\n         */\n        backToShippingMethod: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping', 'opc-shipping_method');\n        }\n    });\n});\n","Magento_Checkout/js/view/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, ko, $, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {HTMLElement} element\n         */\n        setModalElement: function (element) {\n            sidebarModel.setPopup($(element));\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/cart-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/totals',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/quote'\n], function (ko, totals, Component, stepNavigator, quote) {\n    'use strict';\n\n    var useQty = window.checkoutConfig.useQty;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/cart-items'\n        },\n        totals: totals.totals(),\n        items: ko.observable([]),\n        maxCartItemsToDisplay: window.checkoutConfig.maxCartItemsToDisplay,\n        cartUrl: window.checkoutConfig.cartUrl,\n\n        /**\n         * @deprecated Please use observable property (this.items())\n         */\n        getItems: totals.getItems(),\n\n        /**\n         * Returns cart items qty\n         *\n         * @returns {Number}\n         */\n        getItemsQty: function () {\n            return parseFloat(this.totals['items_qty']);\n        },\n\n        /**\n         * Returns count of cart line items\n         *\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            return parseInt(totals.getItems()().length, 10);\n        },\n\n        /**\n         * Returns shopping cart items summary (includes config settings)\n         *\n         * @returns {Number}\n         */\n        getCartSummaryItemsCount: function () {\n            return useQty ? this.getItemsQty() : this.getCartLineItemsCount();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            // Set initial items to observable field\n            this.setItems(totals.getItems()());\n            // Subscribe for items data changes and refresh items in view\n            totals.getItems().subscribe(function (items) {\n                this.setItems(items);\n            }.bind(this));\n        },\n\n        /**\n         * Set items to observable field\n         *\n         * @param {Object} items\n         */\n        setItems: function (items) {\n            if (items && items.length > 0) {\n                items = items.slice(parseInt(-this.maxCartItemsToDisplay, 10));\n            }\n            this.items(items);\n        },\n\n        /**\n         * Returns bool value for items block state (expanded or not)\n         *\n         * @returns {*|Boolean}\n         */\n        isItemsBlockExpanded: function () {\n            return quote.isVirtual() || stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/grand-total'\n        },\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * Get pure value.\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals['grand_total'];\n            }\n\n            return quote['grand_total'];\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/view/summary/discount'\n], function ($, _, Component, quote, discountView) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/shipping'\n        },\n        quoteIsVirtual: quote.isVirtual(),\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod,\n                shippingMethodTitle = '';\n\n            if (!this.isCalculated()) {\n                return '';\n            }\n            shippingMethod = quote.shippingMethod();\n\n            if (!_.isArray(shippingMethod) && !_.isObject(shippingMethod)) {\n                return '';\n            }\n\n            if (typeof shippingMethod['method_title'] !== 'undefined') {\n                shippingMethodTitle = ' - ' + shippingMethod['method_title'];\n            }\n\n            return shippingMethodTitle ?\n                shippingMethod['carrier_title'] + shippingMethodTitle :\n                shippingMethod['carrier_title'];\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price =  this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * If is set coupon code, but there wasn't displayed discount view.\n         *\n         * @return {Boolean}\n         */\n        haveToShowCoupon: function () {\n            var couponCode = this.totals()['coupon_code'];\n\n            if (typeof couponCode === 'undefined') {\n                couponCode = false;\n            }\n\n            return couponCode && !discountView().isDisplayed();\n        },\n\n        /**\n         * Returns coupon code description.\n         *\n         * @return {String}\n         */\n        getCouponDescription: function () {\n            if (!this.haveToShowCoupon()) {\n                return '';\n            }\n\n            return '(' + this.totals()['coupon_code'] + ')';\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/abstract-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/step-navigator'\n], function (Component, quote, priceUtils, totals, stepNavigator) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals.totals();\n        },\n\n        /**\n         * @return {*}\n         */\n        isFullMode: function () {\n            if (!this.getTotals()) {\n                return false;\n            }\n\n            return stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/subtotal'\n        },\n\n        /**\n         * Get pure value.\n         *\n         * @return {*}\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals.subtotal;\n            }\n\n            return quote.subtotal;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n\n    });\n});\n","Magento_Checkout/js/view/summary/item/details.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'escaper'\n], function (Component, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details',\n            allowedTags: ['b', 'strong', 'i', 'em', 'u']\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {String}\n         */\n        getNameUnsanitizedHtml: function (quoteItem) {\n            var txt = document.createElement('textarea');\n\n            txt.innerHTML = quoteItem.name;\n\n            return escaper.escapeHtml(txt.value, this.allowedTags);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {String}Magento_Checkout/js/region-updater\n         */\n        getValue: function (quoteItem) {\n            return quoteItem.name;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    var quoteMessages = window.checkoutConfig.quoteMessages;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details/message'\n        },\n        displayArea: 'item_message',\n        quoteMessages: quoteMessages,\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getMessage: function (item) {\n            if (this.quoteMessages[item['item_id']]) {\n                return this.quoteMessages[item['item_id']];\n            }\n\n            return null;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    var imageData = window.checkoutConfig.imageData;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details/thumbnail'\n        },\n        displayArea: 'before_details',\n        imageData: imageData,\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getImageItem: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']];\n            }\n\n            return [];\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getSrc: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].src;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getWidth: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].width;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getHeight: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].height;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getAlt: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].alt;\n            }\n\n            return null;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (viewModel) {\n    'use strict';\n\n    return viewModel.extend({\n        defaults: {\n            displayArea: 'after_details',\n            template: 'Magento_Checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValue: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super()\n                .initChildren();\n\n            quote.shippingAddress.subscribe(function (address) {\n                self.createRendererComponent(address);\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = {};\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         */\n        createRendererComponent: function (address) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            $.each(this.rendererComponents, function (index, component) {\n                component.visible(false);\n            });\n\n            if (this.rendererComponents[address.getType()]) {\n                this.rendererComponents[address.getType()].address(address);\n                this.rendererComponents[address.getType()].visible(true);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: address.getType()\n                };\n\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(\n                    rendererComponent,\n                    {\n                        address: ko.observable(address),\n                        visible: ko.observable(true)\n                    }\n                );\n                layout([rendererComponent]);\n                this.rendererComponents[address.getType()] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'underscore',\n    'Magento_Customer/js/customer-data'\n], function (Component, _, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/address-renderer/default'\n        },\n\n        /**\n         * @param {*} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else if (typeof attribute.value === 'object') {\n                label = _.map(Object.values(attribute.value)).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            } else if (value.file !== null) {\n                label = value.file;\n            }\n\n            return label;\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/checkout-data'\n], function (ko, _, Component, shippingService, priceUtils, quote, selectShippingMethodAction, checkoutData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/cart/shipping-rates'\n        },\n        isVisible: ko.observable(!quote.isVirtual()),\n        isLoading: shippingService.isLoading,\n        shippingRates: shippingService.getShippingRates(),\n        shippingRateGroups: ko.observableArray([]),\n        selectedShippingMethod: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super();\n\n            this.shippingRates.subscribe(function (rates) {\n                self.shippingRateGroups([]);\n                _.each(rates, function (rate) {\n                    var carrierTitle = rate['carrier_title'];\n\n                    if (self.shippingRateGroups.indexOf(carrierTitle) === -1) {\n                        self.shippingRateGroups.push(carrierTitle);\n                    }\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Get shipping rates for specific group based on title.\n         * @returns Array\n         */\n        getRatesForGroup: function (shippingRateGroupTitle) {\n            return _.filter(this.shippingRates(), function (rate) {\n                return shippingRateGroupTitle === rate['carrier_title'];\n            });\n        },\n\n        /**\n         * Format shipping price.\n         * @returns {String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        },\n\n        /**\n         * Set shipping method.\n         * @param {String} methodData\n         * @returns bool\n         */\n        selectShippingMethod: function (methodData) {\n            selectShippingMethodAction(methodData);\n            checkoutData.setSelectedShippingRate(methodData['carrier_code'] + '_' + methodData['method_code']);\n\n            return true;\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/form/form',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/cart/estimate-service',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'uiRegistry',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'Magento_Checkout/js/model/shipping-service',\n        'mage/validation'\n    ],\n    function (\n        $,\n        Component,\n        selectShippingAddress,\n        addressConverter,\n        estimateService,\n        checkoutData,\n        shippingRatesValidator,\n        registry,\n        quote,\n        checkoutDataResolver,\n        shippingService\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/cart/shipping-estimation'\n            },\n            isVirtual: quote.isVirtual(),\n\n            /**\n             * @override\n             */\n            initialize: function () {\n                this._super();\n\n                // Prevent shipping methods showing none available whilst we resolve\n                shippingService.isLoading(true);\n\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var address, estimatedAddress;\n\n                    shippingService.isLoading(false);\n\n                    checkoutDataResolver.resolveEstimationAddress();\n                    address = quote.isVirtual() ? quote.billingAddress() : quote.shippingAddress();\n\n                    if (!address && quote.isVirtual()) {\n                        address = addressConverter.formAddressDataToQuoteAddress(\n                            checkoutData.getSelectedBillingAddress()\n                        );\n                    }\n\n                    if (address) {\n                        estimatedAddress = address.isEditable() ?\n                            addressConverter.quoteAddressToFormAddressData(address) :\n                            {\n                                // only the following fields must be used by estimation form data provider\n                                'country_id': address.countryId,\n                                region: address.region,\n                                'region_id': address.regionId,\n                                postcode: address.postcode\n                            };\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend({}, checkoutProvider.get('shippingAddress'), estimatedAddress)\n                        );\n                    }\n\n                    if (!quote.isVirtual()) {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                            if (quote.shippingAddress().countryId !== shippingAddressData.country_id ||\n                                (shippingAddressData.postcode || shippingAddressData.region_id)\n                            ) {\n                                checkoutData.setShippingAddressFromData(shippingAddressData);\n                            }\n                            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                        });\n                    } else {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setBillingAddressFromData(shippingAddressData);\n                        });\n                    }\n                });\n\n                return this;\n            },\n\n            /**\n             * @override\n             */\n            initElement: function (element) {\n                this._super();\n\n                if (element.index === 'address-fieldsets') {\n                    shippingRatesValidator.bindChangeHandlers(element.elems(), true, 500);\n                    element.elems.subscribe(function (elems) {\n                        shippingRatesValidator.doElementBinding(elems[elems.length - 1], true, 500);\n                    });\n                }\n\n                return this;\n            },\n\n            /**\n             * Returns shipping rates for address\n             * @returns void\n             */\n            getEstimationInfo: function () {\n                var addressData = null;\n\n                this.source.set('params.invalid', false);\n                this.source.trigger('shippingAddress.data.validate');\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get('shippingAddress');\n                    selectShippingAddress(addressConverter.formAddressDataToQuoteAddress(addressData));\n                }\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/shipping-service'\n], function ($, Component, totalsService, shippingService) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totalsService.isLoading,\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            totalsService.totals.subscribe(function () {\n                $(window).trigger('resize');\n            });\n            shippingService.getShippingRates().subscribe(function () {\n                $(window).trigger('resize');\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        }\n    });\n});\n","Magento_Checkout/js/view/form/element/email.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/action/check-email-availability',\n    'Magento_Customer/js/action/login',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/validation'\n], function ($, Component, ko, customer, checkEmailAvailability, loginAction, quote, checkoutData, fullScreenLoader) {\n    'use strict';\n\n    var validatedEmail;\n\n    if (!checkoutData.getValidatedEmailValue() &&\n        window.checkoutConfig.validatedEmailValue\n    ) {\n        checkoutData.setInputFieldEmailValue(window.checkoutConfig.validatedEmailValue);\n        checkoutData.setValidatedEmailValue(window.checkoutConfig.validatedEmailValue);\n    }\n\n    validatedEmail = checkoutData.getValidatedEmailValue();\n\n    if (validatedEmail && !customer.isLoggedIn()) {\n        quote.guestEmail = validatedEmail;\n    }\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/form/element/email',\n            email: checkoutData.getInputFieldEmailValue(),\n            emailFocused: false,\n            isLoading: false,\n            isPasswordVisible: false,\n            listens: {\n                email: 'emailHasChanged',\n                emailFocused: 'validateEmail'\n            },\n            ignoreTmpls: {\n                email: true\n            }\n        },\n        checkDelay: 2000,\n        checkRequest: null,\n        isEmailCheckComplete: null,\n        isCustomerLoggedIn: customer.isLoggedIn,\n        forgotPasswordUrl: window.checkoutConfig.forgotPasswordUrl,\n        emailCheckTimeout: 0,\n        emailInputId: '#customer-email',\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.isPasswordVisible = this.resolveInitialPasswordVisibility();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['email', 'emailFocused', 'isLoading', 'isPasswordVisible']);\n\n            return this;\n        },\n\n        /**\n         * Callback on changing email property\n         */\n        emailHasChanged: function () {\n            var self = this;\n\n            clearTimeout(this.emailCheckTimeout);\n\n            if (self.validateEmail()) {\n                quote.guestEmail = self.email();\n                checkoutData.setValidatedEmailValue(self.email());\n            }\n            this.emailCheckTimeout = setTimeout(function () {\n                if (self.validateEmail()) {\n                    self.checkEmailAvailability();\n                } else {\n                    self.isPasswordVisible(false);\n                }\n            }, self.checkDelay);\n\n            checkoutData.setInputFieldEmailValue(self.email());\n        },\n\n        /**\n         * Check email existing.\n         */\n        checkEmailAvailability: function () {\n            this.validateRequest();\n            this.isEmailCheckComplete = $.Deferred();\n            // Clean up errors on email\n            $(this.emailInputId).removeClass('mage-error').parent().find('.mage-error').remove();\n            this.isLoading(true);\n            this.checkRequest = checkEmailAvailability(this.isEmailCheckComplete, this.email());\n\n            $.when(this.isEmailCheckComplete).done(function () {\n                this.isPasswordVisible(false);\n                checkoutData.setCheckedEmailValue('');\n            }.bind(this)).fail(function () {\n                this.isPasswordVisible(true);\n                checkoutData.setCheckedEmailValue(this.email());\n            }.bind(this)).always(function () {\n                this.isLoading(false);\n            }.bind(this));\n        },\n\n        /**\n         * If request has been sent -> abort it.\n         * ReadyStates for request aborting:\n         * 1 - The request has been set up\n         * 2 - The request has been sent\n         * 3 - The request is in process\n         */\n        validateRequest: function () {\n            if (this.checkRequest != null && $.inArray(this.checkRequest.readyState, [1, 2, 3])) {\n                this.checkRequest.abort();\n                this.checkRequest = null;\n            }\n        },\n\n        /**\n         * Local email validation.\n         *\n         * @param {Boolean} focused - input focus.\n         * @returns {Boolean} - validation result.\n         */\n        validateEmail: function (focused) {\n            var loginFormSelector = 'form[data-role=email-with-possible-login]',\n                usernameSelector = loginFormSelector + ' input[name=username]',\n                loginForm = $(loginFormSelector),\n                validator,\n                valid;\n\n            loginForm.validation();\n\n            if (focused === false && !!this.email()) {\n                valid = !!$(usernameSelector).valid();\n\n                if (valid) {\n                    $(usernameSelector).removeAttr('aria-invalid aria-describedby');\n                }\n\n                return valid;\n            }\n\n            if (loginForm.is(':visible')) {\n                validator = loginForm.validate();\n\n                return validator.check(usernameSelector);\n            }\n\n            return true;\n        },\n\n        /**\n         * Log in form submitting callback.\n         *\n         * @param {HTMLElement} loginForm - form element.\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (this.isPasswordVisible() && $(loginForm).validation() && $(loginForm).validation('isValid')) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        },\n\n        /**\n         * Resolves an initial state of a login form.\n         *\n         * @returns {Boolean} - initial visibility state.\n         */\n        resolveInitialPasswordVisibility: function () {\n            if (checkoutData.getInputFieldEmailValue() !== '' && checkoutData.getCheckedEmailValue() !== '') {\n                return true;\n            }\n\n            if (checkoutData.getInputFieldEmailValue() !== '') {\n                return checkoutData.getInputFieldEmailValue() === checkoutData.getCheckedEmailValue();\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate',\n    'uiRegistry'\n], function (_, ko, utils, Component, paymentMethods, rendererList, layout, checkoutDataResolver, $t, registry) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment-methods/list',\n            visible: paymentMethods().length > 0,\n            configDefaultGroup: {\n                name: 'methodGroup',\n                component: 'Magento_Checkout/js/model/payment/method-group'\n            },\n            paymentGroupsList: [],\n            defaultGroupTitle: $t('Select a new payment method')\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n            this._super().initDefaulGroup().initChildren();\n            paymentMethods.subscribe(\n                function (changes) {\n                    checkoutDataResolver.resolvePaymentMethod();\n                    //remove renderer for \"deleted\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'deleted') {\n                            this.removeRenderer(change.value.method);\n                        }\n                    }, this);\n                    //add renderer for \"added\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'added') {\n                            this.createRenderer(change.value);\n                        }\n                    }, this);\n                }, this, 'arrayChange');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().\n                observe(['paymentGroupsList']);\n\n            return this;\n        },\n\n        /**\n         * Creates default group\n         *\n         * @returns {Component} Chainable.\n         */\n        initDefaulGroup: function () {\n            layout([\n                this.configDefaultGroup\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Create renders for child payment methods.\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            var self = this;\n\n            _.each(paymentMethods(), function (paymentMethodData) {\n                self.createRenderer(paymentMethodData);\n            });\n\n            return this;\n        },\n\n        /**\n         * @returns\n         */\n        createComponent: function (payment) {\n            var rendererTemplate,\n                rendererComponent,\n                templateData;\n\n            templateData = {\n                parentName: this.name,\n                name: payment.name\n            };\n            rendererTemplate = {\n                parent: '${ $.$data.parentName }',\n                name: '${ $.$data.name }',\n                displayArea: payment.displayArea,\n                component: payment.component\n            };\n            rendererComponent = utils.template(rendererTemplate, templateData);\n            utils.extend(rendererComponent, {\n                item: payment.item,\n                config: payment.config\n            });\n\n            return rendererComponent;\n        },\n\n        /**\n         * Create renderer.\n         *\n         * @param {Object} paymentMethodData\n         */\n        createRenderer: function (paymentMethodData) {\n            var isRendererForMethod = false,\n                currentGroup;\n\n            registry.get(this.configDefaultGroup.name, function (defaultGroup) {\n                _.each(rendererList(), function (renderer) {\n\n                    if (renderer.hasOwnProperty('typeComparatorCallback') &&\n                        typeof renderer.typeComparatorCallback == 'function'\n                    ) {\n                        isRendererForMethod = renderer.typeComparatorCallback(renderer.type, paymentMethodData.method);\n                    } else {\n                        isRendererForMethod = renderer.type === paymentMethodData.method;\n                    }\n\n                    if (isRendererForMethod) {\n                        currentGroup = renderer.group ? renderer.group : defaultGroup;\n\n                        this.collectPaymentGroups(currentGroup);\n\n                        layout([\n                            this.createComponent(\n                                {\n                                    config: renderer.config,\n                                    component: renderer.component,\n                                    name: renderer.type,\n                                    method: paymentMethodData.method,\n                                    item: paymentMethodData,\n                                    displayArea: currentGroup.displayArea\n                                }\n                            )]);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Collects unique groups of available payment methods\n         *\n         * @param {Object} group\n         */\n        collectPaymentGroups: function (group) {\n            var groupsList = this.paymentGroupsList(),\n                isGroupExists = _.some(groupsList, function (existsGroup) {\n                    return existsGroup.alias === group.alias;\n                });\n\n            if (!isGroupExists) {\n                groupsList.push(group);\n                groupsList = _.sortBy(groupsList, function (existsGroup) {\n                    return existsGroup.sortOrder;\n                });\n                this.paymentGroupsList(groupsList);\n            }\n        },\n\n        /**\n         * Returns payment group title\n         *\n         * @param {Object} group\n         * @returns {String}\n         */\n        getGroupTitle: function (group) {\n            var title = group().title;\n\n            if (group().isDefault() && this.paymentGroupsList().length > 1) {\n                title = this.defaultGroupTitle;\n            }\n\n            return title;\n        },\n\n        /**\n         * Checks if at least one payment method available\n         *\n         * @returns {String}\n         */\n        isPaymentMethodsAvailable: function () {\n            return _.some(this.paymentGroupsList(), function (group) {\n                return this.regionHasElements(group.displayArea);\n            }, this);\n        },\n\n        /**\n         * Remove view renderer.\n         *\n         * @param {String} paymentMethodCode\n         */\n        removeRenderer: function (paymentMethodCode) {\n            var items;\n\n            _.each(this.paymentGroupsList(), function (group) {\n                items = this.getRegion(group.displayArea);\n\n                _.find(items(), function (value) {\n                    if (value.item.method.indexOf(paymentMethodCode) === 0) {\n                        value.disposeSubscriptions();\n                        value.destroy();\n                    }\n                });\n            }, this);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/action/place-order',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'uiRegistry',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messages',\n    'uiLayout',\n    'Magento_Checkout/js/action/redirect-on-success'\n], function (\n    ko,\n    $,\n    Component,\n    placeOrderAction,\n    selectPaymentMethodAction,\n    quote,\n    customer,\n    paymentService,\n    checkoutData,\n    checkoutDataResolver,\n    registry,\n    additionalValidators,\n    Messages,\n    layout,\n    redirectOnSuccessAction\n) {\n    'use strict';\n\n    return Component.extend({\n        redirectAfterPlaceOrder: true,\n        isPlaceOrderActionAllowed: ko.observable(quote.billingAddress() != null),\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            // Override this function and put after place order logic here\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            var billingAddressCode,\n                billingAddressData,\n                defaultAddressData;\n\n            this._super().initChildren();\n            quote.billingAddress.subscribe(function (address) {\n                this.isPlaceOrderActionAllowed(address !== null);\n            }, this);\n            checkoutDataResolver.resolveBillingAddress();\n\n            billingAddressCode = 'billingAddress' + this.getCode();\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                defaultAddressData = checkoutProvider.get(billingAddressCode);\n\n                if (defaultAddressData === undefined) {\n                    // Skip if payment does not have a billing address form\n                    return;\n                }\n                billingAddressData = checkoutData.getBillingAddressFromData();\n\n                if (billingAddressData) {\n                    checkoutProvider.set(\n                        billingAddressCode,\n                        $.extend(true, {}, defaultAddressData, billingAddressData)\n                    );\n                }\n                checkoutProvider.on(billingAddressCode, function (providerBillingAddressData) {\n                    checkoutData.setBillingAddressFromData(providerBillingAddressData);\n                }, billingAddressCode);\n            });\n\n            return this;\n        },\n\n        /**\n         * Initialize child elements\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            this.messageContainer = new Messages();\n            this.createMessagesComponent();\n\n            return this;\n        },\n\n        /**\n         * Create child message renderer component\n         *\n         * @returns {Component} Chainable.\n         */\n        createMessagesComponent: function () {\n\n            var messagesComponent = {\n                parent: this.name,\n                name: this.name + '.messages',\n                displayArea: 'messages',\n                component: 'Magento_Ui/js/view/messages',\n                config: {\n                    messageContainer: this.messageContainer\n                }\n            };\n\n            layout([messagesComponent]);\n\n            return this;\n        },\n\n        /**\n         * Place order.\n         */\n        placeOrder: function (data, event) {\n            var self = this;\n\n            if (event) {\n                event.preventDefault();\n            }\n\n            if (this.validate() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                this.isPlaceOrderActionAllowed(false);\n\n                this.getPlaceOrderDeferredObject()\n                    .done(\n                        function () {\n                            self.afterPlaceOrder();\n\n                            if (self.redirectAfterPlaceOrder) {\n                                redirectOnSuccessAction.execute();\n                            }\n                        }\n                    ).always(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                        }\n                    );\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            return $.when(\n                placeOrderAction(this.getData(), this.messageContainer)\n            );\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectPaymentMethod: function () {\n            selectPaymentMethodAction(this.getData());\n            checkoutData.setSelectedPaymentMethod(this.item.method);\n\n            return true;\n        },\n\n        isChecked: ko.computed(function () {\n            return quote.paymentMethod() ? quote.paymentMethod().method : null;\n        }),\n\n        isRadioButtonVisible: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length !== 1;\n        }),\n\n        /**\n         * Get payment method data\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'po_number': null,\n                'additional_data': null\n            };\n        },\n\n        /**\n         * Get payment method type.\n         */\n        getTitle: function () {\n            return this.item.title;\n        },\n\n        /**\n         * Get payment method code.\n         */\n        getCode: function () {\n            return this.item.method;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validate: function () {\n            return true;\n        },\n\n        /**\n         * @return {String}\n         */\n        getBillingAddressFormName: function () {\n            return 'billing-address-form-' + this.item.method;\n        },\n\n        /**\n         * Dispose billing address subscriptions\n         */\n        disposeSubscriptions: function () {\n            // dispose all active subscriptions\n            var billingAddressCode = 'billingAddress' + this.getCode();\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                checkoutProvider.off(billingAddressCode);\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/customer-email-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n\n        additionalValidators.registerValidator(agreementValidator);\n\n        return Component.extend({});\n    }\n);\n","Magento_Checkout/js/view/billing-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/model/address-list',\n    'mage/translate',\n    'Magento_Customer/js/model/customer'\n], function (Component, addressList, $t, customer) {\n    'use strict';\n\n    var newAddressOption = {\n            /**\n             * Get new address label\n             * @returns {String}\n             */\n            getAddressInline: function () {\n                return $t('New Address');\n            },\n            customerAddressId: null\n        },\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() === 'customer-address';\n        }),\n        addressDefaultIndex = addressOptions.findIndex(function (address) {\n            return address.isDefaultBilling();\n        });\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address',\n            selectedAddress: null,\n            isNewAddressSelected: false,\n            addressOptions: addressOptions,\n            exports: {\n                selectedAddress: '${ $.parentName }:selectedAddress'\n            }\n        },\n\n        /**\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this.addressOptions.push(newAddressOption);\n\n            return this;\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('selectedAddress isNewAddressSelected')\n                .observe({\n                    isNewAddressSelected: !customer.isLoggedIn() || !addressOptions.length,\n                    selectedAddress: this.addressOptions[addressDefaultIndex]\n                });\n\n            return this;\n        },\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @param {Object} address\n         */\n        onAddressChange: function (address) {\n            this.isNewAddressSelected(address === newAddressOption);\n        }\n    });\n});\n","Magento_Checkout/js/view/configure/product-customer-data.js":"require([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'domReady!'\n], function ($, customerData, _) {\n    'use strict';\n\n    var selectors = {\n        qtySelector: '#product_addtocart_form [name=\"qty\"]',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]',\n        itemIdSelector: '#product_addtocart_form [name=\"item\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    itemId = $(selectors.itemIdSelector).val(),\n    productQty,\n    productQtyInput,\n\n    /**\n    * Updates product's qty input value according to actual data\n    */\n    updateQty = function () {\n\n        if (productQty || productQty === 0) {\n            productQtyInput = productQtyInput || $(selectors.qtySelector);\n\n            if (productQtyInput && productQty.toString() !== productQtyInput.val()) {\n                productQtyInput.val(productQty);\n            }\n        }\n    },\n\n    /**\n    * Sets productQty according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    */\n    setProductQty = function (data) {\n        var product;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return;\n        }\n        product = _.find(data.items, function (item) {\n            if (item['item_id'] === itemId) {\n                return item['product_id'] === productId ||\n                    item['item_id'] === productId;\n            }\n        });\n\n        if (!product) {\n            return;\n        }\n        productQty = product.qty;\n    };\n\n    cartData.subscribe(function (updateCartData) {\n        setProductQty(updateCartData);\n        updateQty();\n    });\n\n    setProductQty(cartData());\n    updateQty();\n});\n","Magento_Checkout/js/view/shipping-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Customer/js/model/address-list'\n], function (_, ko, utils, Component, layout, addressList) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/list',\n            visible: addressList().length > 0,\n            rendererTemplates: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            addressList.subscribe(function (changes) {\n                    var self = this;\n\n                    changes.forEach(function (change) {\n                        if (change.status === 'added') {\n                            self.createRendererComponent(change.value, change.index);\n                        }\n                    });\n                },\n                this,\n                'arrayChange'\n            );\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = [];\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            _.each(addressList(), this.createRendererComponent, this);\n\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         * @param {*} index\n         */\n        createRendererComponent: function (address, index) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            if (index in this.rendererComponents) {\n                this.rendererComponents[index].address(address);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: index\n                };\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(rendererComponent, {\n                    address: ko.observable(address)\n                });\n                layout([rendererComponent]);\n                this.rendererComponents[index] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'underscore',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Customer/js/customer-data'\n], function ($, ko, Component, _, selectShippingAddressAction, quote, formPopUpState, checkoutData, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/address-renderer/default'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n            this.isSelected = ko.computed(function () {\n                var isSelected = false,\n                    shippingAddress = quote.shippingAddress();\n\n                if (shippingAddress) {\n                    isSelected = shippingAddress.getKey() == this.address().getKey(); //eslint-disable-line eqeqeq\n                }\n\n                return isSelected;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * @param {String} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else if (typeof attribute.value === 'object') {\n                label = _.map(Object.values(attribute.value)).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            } else if (value.file !== null) {\n                label = value.file;\n            }\n\n            return label;\n        },\n\n        /** Set selected customer shipping address  */\n        selectAddress: function () {\n            selectShippingAddressAction(this.address());\n            checkoutData.setSelectedShippingAddress(this.address().getKey());\n        },\n\n        /**\n         * Edit address.\n         */\n        editAddress: function () {\n            formPopUpState.isVisible(true);\n            this.showPopup();\n\n        },\n\n        /**\n         * Show popup.\n         */\n        showPopup: function () {\n            $('[data-open-modal=\"opc-new-shipping-address\"]').trigger('click');\n        }\n    });\n});\n","Magento_Checkout/js/view/checkout/placeOrderCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n],\nfunction (defaultCaptcha, captchaList, _, placeOrderHooks) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this,\n                currentCaptcha;\n\n            this._super();\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n                placeOrderHooks.requestModifiers.push(function (headers) {\n                    if (self.isRequired()) {\n                        headers['X-Captcha'] = self.captchaValue()();\n                    }\n                });\n                if (self.isRequired()) {\n                    placeOrderHooks.afterRequestListeners.push(function () {\n                        self.refresh();\n                    });\n                }\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Checkout/js/action/select-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote'\n], function ($, quote) {\n    'use strict';\n\n    return function (billingAddress) {\n        var address = null;\n\n        if (quote.shippingAddress() && billingAddress.getCacheKey() == //eslint-disable-line eqeqeq\n            quote.shippingAddress().getCacheKey()\n        ) {\n            address = $.extend(true, {}, billingAddress);\n            address.saveInAddressBook = null;\n        } else {\n            address = billingAddress;\n        }\n        quote.billingAddress(address);\n    };\n});\n","Magento_Checkout/js/action/set-payment-information-extended.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n], function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader, _, hooks) {\n    'use strict';\n\n    /**\n     * Filter template data.\n     *\n     * @param {Object|Array} data\n     */\n    var filterTemplateData = function (data) {\n        return _.each(data, function (value, key, list) {\n            if (_.isArray(value) || _.isObject(value)) {\n                list[key] = filterTemplateData(value);\n            }\n\n            if (key === '__disableTmpl' || key === 'title') {\n                delete list[key];\n            }\n        });\n    };\n\n    return function (messageContainer, paymentData, skipBilling) {\n        var serviceUrl,\n            payload,\n            headers = {};\n\n        paymentData = filterTemplateData(paymentData);\n        skipBilling = skipBilling || false;\n        payload = {\n            cartId: quote.getQuoteId(),\n            paymentMethod: paymentData\n        };\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n        }\n\n        if (skipBilling === false) {\n            payload.billingAddress = quote.billingAddress();\n        }\n\n        fullScreenLoader.startLoader();\n\n        _.each(hooks.requestModifiers, function (modifier) {\n            modifier(headers, payload);\n        });\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n        ).fail(\n            function (response) {\n                errorProcessor.process(response, messageContainer);\n            }\n        ).always(\n            function () {\n                fullScreenLoader.stopLoader();\n                _.each(hooks.afterRequestListeners, function (listener) {\n                    listener();\n                });\n            }\n        );\n    };\n});\n","Magento_Checkout/js/action/recollect-shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rate-registry'\n], function (quote, selectShippingAddress, rateRegistry) {\n    'use strict';\n\n    return function () {\n        var shippingAddress = null;\n\n        if (!quote.isVirtual()) {\n            shippingAddress = quote.shippingAddress();\n\n            rateRegistry.set(shippingAddress.getCacheKey(), null);\n            selectShippingAddress(shippingAddress);\n        }\n    };\n});\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals'\n], function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n    'use strict';\n\n    return function (callbacks, deferred) {\n        deferred = deferred || $.Deferred();\n        totals.isLoading(true);\n\n        return storage.get(\n            resourceUrlManager.getUrlForCartTotals(quote),\n            false\n        ).done(function (response) {\n            var proceed = true;\n\n            totals.isLoading(false);\n\n            if (callbacks.length > 0) {\n                $.each(callbacks, function (index, callback) {\n                    proceed = proceed && callback();\n                });\n            }\n\n            if (proceed) {\n                quote.setTotals(response);\n                deferred.resolve();\n            }\n        }).fail(function (response) {\n            totals.isLoading(false);\n            deferred.reject();\n            errorProcessor.process(response);\n        }).always(function () {\n            totals.isLoading(false);\n        });\n    };\n});\n","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/place-order'\n], function (quote, urlBuilder, customer, placeOrderService) {\n    'use strict';\n\n    return function (paymentData, messageContainer) {\n        var serviceUrl, payload;\n\n        payload = {\n            cartId: quote.getQuoteId(),\n            billingAddress: quote.billingAddress(),\n            paymentMethod: paymentData\n        };\n\n        if (customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                quoteId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        }\n\n        return placeOrderService(serviceUrl, payload, messageContainer);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingAddress) {\n        quote.shippingAddress(shippingAddress);\n    };\n});\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (paymentMethod) {\n        if (paymentMethod) {\n            paymentMethod.__disableTmpl = {\n                title: true\n            };\n        }\n        quote.paymentMethod(paymentMethod);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingMethod) {\n        quote.shippingMethod(shippingMethod);\n    };\n});\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter'\n], function (addressList, addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData),\n            isAddressUpdated = addressList().some(function (currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) { //eslint-disable-line eqeqeq\n                    addresses[index] = address;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n        if (!isAddressUpdated) {\n            addressList.push(address);\n        } else {\n            addressList.valueHasMutated();\n        }\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (url, fullScreenLoader) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                fullScreenLoader.startLoader();\n                this.redirectToSuccessPage();\n            },\n\n            /**\n             * Redirect to success page.\n             */\n            redirectToSuccessPage: function () {\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/address-converter'\n], function (addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData);\n\n        /**\n         * Returns new customer billing address type.\n         *\n         * @returns {String}\n         */\n        address.getType = function () {\n            return 'new-customer-billing-address';\n        };\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/update-shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function (alert, confirm, $, $t) {\n    'use strict';\n\n    $.widget('mage.updateShoppingCart', {\n        options: {\n            validationURL: '',\n            eventName: 'updateCartItemQty',\n            updateCartActionContainer: '',\n            isCartHasUpdatedContent: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._on(this.element, {\n                'submit': this.onSubmit\n            });\n            this._on('[data-role=cart-item-qty]', {\n                'change': function () {\n                    this.isCartHasUpdatedContent = true;\n                }\n            });\n            this._on('ul.pages-items', {\n                'click a': function (event) {\n                    if (this.isCartHasUpdatedContent) {\n                        event.preventDefault();\n                        this.changePageConfirm($(event.currentTarget).attr('href'));\n                    }\n                }\n            });\n        },\n\n        /**\n         * Show the confirmation popup\n         * @param nextPageUrl\n         */\n        changePageConfirm: function (nextPageUrl) {\n            confirm({\n                title: $t('Are you sure you want to leave the page?'),\n                content: $t('Changes you made to the cart will not be saved.'),\n                actions: {\n                    confirm: function () {\n                        window.location.href = nextPageUrl;\n                    }\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Leave'),\n                    class: 'action-primary action-accept',\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Prevents default submit action and calls form validator.\n         *\n         * @param {Event} event\n         * @return {Boolean}\n         */\n        onSubmit: function (event) {\n            var action = this.element.find(this.options.updateCartActionContainer).val();\n\n            if (!this.options.validationURL || action === 'empty_cart') {\n                return true;\n            }\n\n            if (this.isValid()) {\n                event.preventDefault();\n                this.validateItems(this.options.validationURL, this.element.serialize());\n            }\n\n            return false;\n        },\n\n        /**\n         * Validates requested form.\n         *\n         * @return {Boolean}\n         */\n        isValid: function () {\n            return this.element.validation() && this.element.validation('isValid');\n        },\n\n        /**\n         * Validates updated shopping cart data.\n         *\n         * @param {String} url - request url\n         * @param {Object} data - post data for ajax call\n         */\n        validateItems: function (url, data) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $(document.body).trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $(document.body).trigger('processStop');\n                }\n            })\n                .done(function (response) {\n                    if (response.success) {\n                        this.onSuccess();\n                    } else {\n                        this.onError(response);\n                    }\n                })\n                .fail(function () {\n                    this.submitForm();\n                });\n        },\n\n        /**\n         * Form validation succeed.\n         */\n        onSuccess: function () {\n            $(document).trigger('ajax:' + this.options.eventName);\n            this.submitForm();\n        },\n\n        /**\n         * Form validation failed.\n         */\n        onError: function (response) {\n            var that = this,\n                elm,\n                responseData = [];\n\n            try {\n                responseData = JSON.parse(response['error_message']);\n            } catch (error) {\n            }\n\n            if (response['error_message']) {\n                try {\n                    $.each(responseData, function (index, data) {\n\n                        if (data.itemId !== undefined) {\n                            elm = $('#cart-' + data.itemId + '-qty');\n                            elm.val(elm.attr('data-item-qty'));\n                        }\n                        response['error_message'] = data.error;\n                    });\n                } catch (e) {}\n                alert({\n                    content: response['error_message'],\n                    actions: {\n                        /** @inheritdoc */\n                        always: function () {\n                            that.submitForm();\n                        }\n                    }\n                });\n            } else {\n                this.submitForm();\n            }\n        },\n\n        /**\n         * Real submit of validated form.\n         */\n        submitForm: function () {\n            this.element\n                .off('submit', this.onSubmit)\n                .on('submit', function () {\n                    $(document.body).trigger('processStart');\n                })\n                .trigger('submit');\n        }\n    });\n\n    return $.mage.updateShoppingCart;\n});\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote',\n    'Magento_Checkout/js/model/shipping-save-processor'\n], function (quote, shippingSaveProcessor) {\n    'use strict';\n\n    return function () {\n        return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n    };\n});\n","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/payment-service'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n    'use strict';\n\n    return function (deferred, messageContainer) {\n        var serviceUrl;\n\n        deferred = deferred || $.Deferred();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                cartId: quote.getQuoteId()\n            });\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        }\n\n        return storage.get(\n            serviceUrl, false\n        ).done(function (response) {\n            quote.setTotals(response.totals);\n            paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n            deferred.resolve();\n        }).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n            deferred.reject();\n        });\n    };\n});\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/action/set-payment-information-extended'\n\n], function (setPaymentInformationExtended) {\n    'use strict';\n\n    return function (messageContainer, paymentData) {\n\n        return setPaymentInformationExtended(messageContainer, paymentData, false);\n    };\n});\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/url',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function (url, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} response\n         * @param {Object} messageContainer\n         */\n        process: function (response, messageContainer) {\n            var error;\n\n            messageContainer = messageContainer || globalMessageList;\n\n            if (response.status == 401) { //eslint-disable-line eqeqeq\n                this.redirectTo(url.build('customer/account/login/'));\n            } else {\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = {\n                        message: $t('Something went wrong with your request. Please try again later.')\n                    };\n                }\n                messageContainer.addErrorMessage(error);\n            }\n        },\n\n        /**\n         * Method to redirect by requested URL.\n         */\n        redirectTo: function (redirectUrl) {\n            window.location.replace(redirectUrl);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './shipping-rates-validation-rules',\n    '../model/address-converter',\n    '../action/select-shipping-address',\n    './postcode-validator',\n    './default-validator',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    ko,\n    shippingRatesValidationRules,\n    addressConverter,\n    selectShippingAddress,\n    postcodeValidator,\n    defaultValidator,\n    $t,\n    uiRegistry,\n    formPopUpState\n) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        validators = [],\n        observedElements = [],\n        postcodeElements = [],\n        postcodeElementName = 'postcode';\n\n    validators.push(defaultValidator);\n\n    return {\n        validateAddressTimeout: 0,\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * @param {String} carrier\n         * @param {Object} validator\n         */\n        registerValidator: function (carrier, validator) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                validators.push(validator);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validateAddressData: function (address) {\n            return validators.some(function (validator) {\n                return validator.validate(address);\n            });\n        },\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this,\n                elements = shippingRatesValidationRules.getObservableFields();\n\n            if ($.inArray(postcodeElementName, elements) === -1) {\n                // Add postcode field to observables if not exist for zip code validation support\n                elements.push(postcodeElementName);\n            }\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n            });\n        },\n\n        /**\n         * Bind shipping rates request to form element\n         *\n         * @param {Object} element\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        doElementBinding: function (element, force, delay) {\n            var observableFields = shippingRatesValidationRules.getObservableFields();\n\n            if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                if (element.index !== postcodeElementName) {\n                    this.bindHandler(element, delay);\n                }\n            }\n\n            if (element.index === postcodeElementName) {\n                this.bindHandler(element, delay);\n                postcodeElements.push(element);\n            }\n        },\n\n        /**\n         * @param {*} elements\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        bindChangeHandlers: function (elements, force, delay) {\n            var self = this;\n\n            $.each(elements, function (index, elem) {\n                self.doElementBinding(elem, force, delay);\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    self.bindHandler(elem);\n                });\n            } else {\n                element.on('value', function () {\n                    clearTimeout(self.validateZipCodeTimeout);\n                    self.validateZipCodeTimeout = setTimeout(function () {\n                        if (element.index === postcodeElementName) {\n                            self.postcodeValidation(element);\n                        } else {\n                            $.each(postcodeElements, function (index, elem) {\n                                self.postcodeValidation(elem);\n                            });\n                        }\n                    }, delay);\n\n                    if (!formPopUpState.isVisible()) {\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            self.validateFields();\n                        }, delay);\n                    }\n                });\n                observedElements.push(element);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        },\n\n        /**\n         * Convert form data to quote address and validate fields for shipping rates\n         */\n        validateFields: function () {\n            var addressFlat = addressConverter.formDataProviderToFlatData(\n                this.collectObservedData(),\n                'shippingAddress'\n                ),\n                address;\n\n            if (this.validateAddressData(addressFlat)) {\n                addressFlat = uiRegistry.get('checkoutProvider').shippingAddress;\n                address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                selectShippingAddress(address);\n            }\n        },\n\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                observedValues[field.dataScope] = field.value();\n            });\n\n            return observedValues;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/shipping-save-processor/default'\n], function (defaultProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors['default'] =  defaultProcessor;\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        },\n\n        /**\n         * @param {String} type\n         * @return {Array}\n         */\n        saveShippingInformation: function (type) {\n            var rates = [];\n\n            if (processors[type]) {\n                rates = processors[type].saveShippingInformation();\n            } else {\n                rates = processors['default'].saveShippingInformation();\n            }\n\n            return rates;\n        }\n    };\n});\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, DefaultPostCodeResolver) {\n    'use strict';\n\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now(),\n            countryId = addressData['country_id'] || addressData.countryId || window.checkoutConfig.defaultCountryId,\n            regionId;\n\n        if (addressData.region && addressData.region['region_id']) {\n            regionId = addressData.region['region_id'];\n        } else if (!addressData['region_id']) {\n            regionId = undefined;\n        } else if (\n            /* eslint-disable */\n            addressData['country_id'] && addressData['country_id'] == window.checkoutConfig.defaultCountryId ||\n            !addressData['country_id'] && countryId == window.checkoutConfig.defaultCountryId\n            /* eslint-enable */\n        ) {\n            regionId = window.checkoutConfig.defaultRegionId || undefined;\n        }\n\n        return {\n            email: addressData.email,\n            countryId: countryId,\n            regionId: regionId || addressData.regionId,\n            regionCode: addressData.region ? addressData.region['region_code'] : null,\n            region: addressData.region ? addressData.region.region : null,\n            customerId: addressData['customer_id'] || addressData.customerId,\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : DefaultPostCodeResolver.resolve(),\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: addressData['custom_attributes'],\n            extensionAttributes: addressData['extension_attributes'],\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'new-customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType();\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return true;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n], function (quote, defaultProcessor, customerAddressProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors.default =  defaultProcessor;\n    processors['customer-address'] = customerAddressProcessor;\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (processors[type]) {\n            processors[type].getRates(quote.shippingAddress());\n        } else {\n            processors.default.getRates(quote.shippingAddress());\n        }\n    });\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './default-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/url-builder',\n    'mageUtils'\n], function (customer, urlBuilder, utils) {\n        'use strict';\n\n        return {\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForTotalsEstimationForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/totals-information',\n                        'customer': '/carts/mine/totals-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                        'customer': '/carts/mine/estimate-shipping-methods'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsByAddressId: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} couponCode\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getApplyCouponUrl: function (couponCode, quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/' + encodeURIComponent(couponCode),\n                        'customer': '/carts/mine/coupons/' + encodeURIComponent(couponCode)\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getCancelCouponUrl: function (quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/',\n                        'customer': '/carts/mine/coupons/'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForCartTotals: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/totals',\n                        'customer': '/carts/mine/totals'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForSetShippingInformation: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/shipping-information',\n                        'customer': '/carts/mine/shipping-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * Get url for service.\n             *\n             * @param {*} urls\n             * @param {*} urlParams\n             * @return {String|*}\n             */\n            getUrl: function (urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            /**\n             * @return {String}\n             */\n            getCheckoutMethod: function () {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (ko, checkoutDataResolver) {\n    'use strict';\n\n    var shippingRates = ko.observableArray([]);\n\n    return {\n        isLoading: ko.observable(false),\n\n        /**\n         * Set shipping rates\n         *\n         * @param {*} ratesData\n         */\n        setShippingRates: function (ratesData) {\n            shippingRates(ratesData);\n            shippingRates.valueHasMutated();\n            checkoutDataResolver.resolveShippingRates(ratesData);\n        },\n\n        /**\n         * Get shipping rates\n         *\n         * @returns {*}\n         */\n        getShippingRates: function () {\n            return shippingRates;\n        }\n    };\n});\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    var steps = ko.observableArray();\n\n    return {\n        steps: steps,\n        stepCodes: [],\n        validCodes: [],\n\n        /**\n         * @return {Boolean}\n         */\n        handleHash: function () {\n            var hashString = window.location.hash.replace('#', ''),\n                isRequestedStepVisible;\n\n            if (hashString === '') {\n                return false;\n            }\n\n            if ($.inArray(hashString, this.validCodes) === -1) {\n                window.location.href = window.checkoutConfig.pageNotFoundUrl;\n\n                return false;\n            }\n\n            isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {\n                return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line\n            });\n\n            //if requested step is visible, then we don't need to load step data from server\n            if (isRequestedStepVisible) {\n                return false;\n            }\n\n            steps().sort(this.sortItems).forEach(function (element) {\n                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq\n                    element.navigate(element);\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n\n            return false;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} alias\n         * @param {*} title\n         * @param {Function} isVisible\n         * @param {*} navigate\n         * @param {*} sortOrder\n         */\n        registerStep: function (code, alias, title, isVisible, navigate, sortOrder) {\n            var hash, active;\n\n            if ($.inArray(code, this.validCodes) !== -1) {\n                throw new DOMException('Step code [' + code + '] already registered in step navigator');\n            }\n\n            if (alias != null) {\n                if ($.inArray(alias, this.validCodes) !== -1) {\n                    throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                }\n                this.validCodes.push(alias);\n            }\n            this.validCodes.push(code);\n            steps.push({\n                code: code,\n                alias: alias != null ? alias : code,\n                title: title,\n                isVisible: isVisible,\n                navigate: navigate,\n                sortOrder: sortOrder\n            });\n            active = this.getActiveItemIndex();\n            steps.each(function (elem, index) {\n                if (active !== index) {\n                    elem.isVisible(false);\n                }\n            });\n            this.stepCodes.push(code);\n            hash = window.location.hash.replace('#', '');\n\n            if (hash != '' && hash != code) { //eslint-disable-line eqeqeq\n                //Force hiding of not active step\n                isVisible(false);\n            }\n        },\n\n        /**\n         * @param {Object} itemOne\n         * @param {Object} itemTwo\n         * @return {Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getActiveItemIndex: function () {\n            var activeIndex = 0;\n\n            steps().sort(this.sortItems).some(function (element, index) {\n                if (element.isVisible()) {\n                    activeIndex = index;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return activeIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @return {Boolean}\n         */\n        isProcessed: function (code) {\n            var activeItemIndex = this.getActiveItemIndex(),\n                sortedItems = steps().sort(this.sortItems),\n                requestedItemIndex = -1;\n\n            sortedItems.forEach(function (element, index) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    requestedItemIndex = index;\n                }\n            });\n\n            return activeItemIndex > requestedItemIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @param {*} scrollToElementId\n         */\n        navigateTo: function (code, scrollToElementId) {\n            var sortedItems = steps().sort(this.sortItems),\n                bodyElem = $('body');\n\n            scrollToElementId = scrollToElementId || null;\n\n            if (!this.isProcessed(code)) {\n                return;\n            }\n            sortedItems.forEach(function (element) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    element.isVisible(true);\n                    bodyElem.animate({\n                        scrollTop: $('#' + code).offset().top\n                    }, 0, function () {\n                        window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                    });\n\n                    if (scrollToElementId && $('#' + scrollToElementId).length) {\n                        bodyElem.animate({\n                            scrollTop: $('#' + scrollToElementId).offset().top\n                        }, 0);\n                    }\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n        },\n\n        /**\n         * Sets window location hash.\n         *\n         * @param {String} hash\n         */\n        setHash: function (hash) {\n            window.location.hash = hash;\n        },\n\n        /**\n         * Next step.\n         */\n        next: function () {\n            var activeIndex = 0,\n                code;\n\n            steps().sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    element.isVisible(false);\n                    activeIndex = index;\n                }\n            });\n\n            if (steps().length > activeIndex + 1) {\n                code = steps()[activeIndex + 1].code;\n                steps()[activeIndex + 1].isVisible(true);\n                this.setHash(code);\n                document.body.scrollTop = document.documentElement.scrollTop = 0;\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/payment/place-order-hooks',\n        'underscore'\n    ],\n    function (storage, errorProcessor, fullScreenLoader, customerData, hooks, _) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            var headers = {}, redirectURL = '';\n\n            fullScreenLoader.startLoader();\n            _.each(hooks.requestModifiers, function (modifier) {\n                modifier(headers, payload);\n            });\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    redirectURL = response.getResponseHeader('errorRedirectAction');\n\n                    if (redirectURL) {\n                        setTimeout(function () {\n                            errorProcessor.redirectTo(redirectURL);\n                        }, 3000);\n                    }\n                }\n            ).done(\n                function (response) {\n                    var clearData = {\n                        'selectedShippingAddress': null,\n                        'shippingAddressFromData': null,\n                        'newCustomerShippingAddress': null,\n                        'selectedShippingRate': null,\n                        'selectedPaymentMethod': null,\n                        'selectedBillingAddress': null,\n                        'billingAddressFromData': null,\n                        'newCustomerBillingAddress': null\n                    };\n\n                    if (response.responseType !== 'error') {\n                        customerData.set('checkout-data', clearData);\n                    }\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                    _.each(hooks.afterRequestListeners, function (listener) {\n                        listener();\n                    });\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var ratesRules = {},\n        checkoutConfig = window.checkoutConfig;\n\n    return {\n        /**\n         * @param {String} carrier\n         * @param {Object} rules\n         */\n        registerRules: function (carrier, rules) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                ratesRules[carrier] = rules.getRules();\n            }\n        },\n\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return ratesRules;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getObservableFields: function () {\n            var self = this,\n                observableFields = [];\n\n            $.each(self.getRules(), function (carrier, fields) {\n                $.each(fields, function (field) {\n                    if (observableFields.indexOf(field) === -1) {\n                        observableFields.push(field);\n                    }\n                });\n            });\n\n            return observableFields;\n        }\n    };\n});\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function (ko, quote, customerData) {\n    'use strict';\n\n    var quoteItems = ko.observable(quote.totals().items),\n        cartData = customerData.get('cart'),\n        quoteSubtotal = parseFloat(quote.totals().subtotal),\n        subtotalAmount = parseFloat(cartData().subtotalAmount);\n\n    quote.totals.subscribe(function (newValue) {\n        quoteItems(newValue.items);\n    });\n\n    if (!isNaN(subtotalAmount) && quoteSubtotal !== subtotalAmount && quoteSubtotal !== 0) {\n        customerData.reload(['cart'], false);\n    }\n\n    return {\n        totals: quote.totals,\n        isLoading: ko.observable(false),\n\n        /**\n         * @return {Function}\n         */\n        getItems: function () {\n            return quoteItems;\n        },\n\n        /**\n         * @param {*} code\n         * @return {*}\n         */\n        getSegment: function (code) {\n            var i, total;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            for (i in this.totals()['total_segments']) { //eslint-disable-line guard-for-in\n                total = this.totals()['total_segments'][i];\n\n                if (total.code == code) { //eslint-disable-line eqeqeq\n                    return total;\n                }\n            }\n\n            return null;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    var containerId = '#checkout';\n\n    return {\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(containerId).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            var $elem = $(containerId),\n                stop = $elem.trigger.bind($elem, 'processStop'); //eslint-disable-line jquery-no-bind-unbind\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/customer',\n    'mage/validation'\n], function ($, customer) {\n    'use strict';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var emailValidationResult = customer.isLoggedIn(),\n                loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            return emailValidationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return {\n        method: 'rest',\n        storeCode: window.checkoutConfig.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] != undefined) { //eslint-disable-line eqeqeq\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/action/create-billing-address',\n    'underscore'\n], function (\n    addressList,\n    quote,\n    checkoutData,\n    createShippingAddress,\n    selectShippingAddress,\n    selectShippingMethodAction,\n    paymentService,\n    selectPaymentMethodAction,\n    addressConverter,\n    selectBillingAddress,\n    createBillingAddress,\n    _\n) {\n    'use strict';\n\n    var isBillingAddressResolvedFromBackend = false;\n\n    return {\n\n        /**\n         * Resolve estimation address. Used local storage\n         */\n        resolveEstimationAddress: function () {\n            var address;\n\n            if (quote.isVirtual()) {\n                if (checkoutData.getBillingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getBillingAddressFromData()\n                    );\n                    selectBillingAddress(address);\n                } else {\n                    this.resolveBillingAddress();\n                }\n            } else if (checkoutData.getShippingAddressFromData()) {\n                address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                selectShippingAddress(address);\n            } else {\n                this.resolveShippingAddress();\n            }\n        },\n\n        /**\n         * Resolve shipping address. Used local storage\n         */\n        resolveShippingAddress: function () {\n            var newCustomerShippingAddress;\n\n            if (!checkoutData.getShippingAddressFromData() &&\n                window.checkoutConfig.shippingAddressFromData\n            ) {\n                checkoutData.setShippingAddressFromData(window.checkoutConfig.shippingAddressFromData);\n            }\n\n            newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n            if (newCustomerShippingAddress) {\n                createShippingAddress(newCustomerShippingAddress);\n            }\n            this.applyShippingAddress();\n        },\n\n        /**\n         * Apply resolved estimated address to quote\n         *\n         * @param {Object} isEstimatedAddress\n         */\n        applyShippingAddress: function (isEstimatedAddress) {\n            var address,\n                shippingAddress,\n                isConvertAddress;\n\n            if (addressList().length === 0) {\n                address = addressConverter.formAddressDataToQuoteAddress(\n                    checkoutData.getShippingAddressFromData()\n                );\n                selectShippingAddress(address);\n            }\n            shippingAddress = quote.shippingAddress();\n            isConvertAddress = isEstimatedAddress || false;\n\n            if (!shippingAddress) {\n                shippingAddress = this.getShippingAddressFromCustomerAddressList();\n\n                if (shippingAddress) {\n                    selectShippingAddress(\n                        isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(shippingAddress)\n                            : shippingAddress\n                    );\n                }\n            }\n        },\n\n        /**\n         * @param {Object} ratesData\n         */\n        resolveShippingRates: function (ratesData) {\n            var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                availableRate = false;\n\n            if (ratesData.length === 1 && !quote.shippingMethod()) {\n                //set shipping rate if we have only one available shipping rate\n                selectShippingMethodAction(ratesData[0]);\n\n                return;\n            }\n\n            if (quote.shippingMethod()) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] == quote.shippingMethod()['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == quote.shippingMethod()['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            if (!availableRate && selectedShippingRate) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] + '_' + rate['method_code'] === selectedShippingRate;\n                });\n            }\n\n            if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                availableRate = _.find(ratesData, function (rate) {\n                    var selectedShippingMethod = window.checkoutConfig.selectedShippingMethod;\n\n                    return rate['carrier_code'] == selectedShippingMethod['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == selectedShippingMethod['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            //Unset selected shipping method if not available\n            if (!availableRate) {\n                selectShippingMethodAction(null);\n            } else {\n                selectShippingMethodAction(availableRate);\n            }\n        },\n\n        /**\n         * Resolve payment method. Used local storage\n         */\n        resolvePaymentMethod: function () {\n            var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n            if (selectedPaymentMethod) {\n                availablePaymentMethods.some(function (payment) {\n                    if (payment.method == selectedPaymentMethod) { //eslint-disable-line eqeqeq\n                        selectPaymentMethodAction(payment);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Resolve billing address. Used local storage\n         */\n        resolveBillingAddress: function () {\n            var selectedBillingAddress,\n                newCustomerBillingAddressData;\n\n            selectedBillingAddress = checkoutData.getSelectedBillingAddress();\n            newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n            if (selectedBillingAddress) {\n                if (selectedBillingAddress === 'new-customer-billing-address' && newCustomerBillingAddressData) {\n                    selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                } else {\n                    addressList.some(function (address) {\n                        if (selectedBillingAddress === address.getKey()) {\n                            selectBillingAddress(address);\n                        }\n                    });\n                }\n            } else {\n                this.applyBillingAddress();\n            }\n\n            if (!isBillingAddressResolvedFromBackend &&\n                !checkoutData.getBillingAddressFromData() &&\n                !_.isEmpty(window.checkoutConfig.billingAddressFromData) &&\n                !quote.billingAddress()\n            ) {\n                if (window.checkoutConfig.isBillingAddressFromDataValid === true) {\n                    selectBillingAddress(createBillingAddress(window.checkoutConfig.billingAddressFromData));\n                } else {\n                    checkoutData.setBillingAddressFromData(window.checkoutConfig.billingAddressFromData);\n                }\n                isBillingAddressResolvedFromBackend = true;\n            }\n        },\n\n        /**\n         * Apply resolved billing address to quote\n         */\n        applyBillingAddress: function () {\n            var shippingAddress,\n                isBillingAddressInitialized;\n\n            if (quote.billingAddress()) {\n                selectBillingAddress(quote.billingAddress());\n\n                return;\n            }\n\n            if (quote.isVirtual() || !quote.billingAddress()) {\n                isBillingAddressInitialized = addressList.some(function (addrs) {\n                    if (addrs.isDefaultBilling()) {\n                        selectBillingAddress(addrs);\n\n                        return true;\n                    }\n\n                    return false;\n                });\n            }\n\n            shippingAddress = quote.shippingAddress();\n\n            if (!isBillingAddressInitialized &&\n                shippingAddress &&\n                shippingAddress.canUseForBilling() &&\n                (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n            ) {\n                //set billing address same as shipping by default if it is not empty\n                selectBillingAddress(quote.shippingAddress());\n            }\n        },\n\n        /**\n         * Get shipping address from address list\n         *\n         * @return {Object|null}\n         */\n        getShippingAddressFromCustomerAddressList: function () {\n            var shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return checkoutData.getSelectedShippingAddress() == address.getKey() //eslint-disable-line\n                    }\n                );\n\n            if (!shippingAddress) {\n                shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return address.isDefaultShipping();\n                    }\n                );\n            }\n\n            if (!shippingAddress && addressList().length === 1) {\n                shippingAddress = addressList()[0];\n            }\n\n            return shippingAddress;\n        }\n    };\n});\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/new-customer-address',\n    'Magento_Customer/js/customer-data',\n    'mage/utils/objects',\n    'underscore'\n], function ($, address, customerData, mageUtils, _) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return {\n        /**\n         * Convert address form data to Address object\n         *\n         * @param {Object} formData\n         * @returns {Object}\n         */\n        formAddressDataToQuoteAddress: function (formData) {\n            // clone address form data to new object\n            var addressData = $.extend(true, {}, formData),\n                region,\n                regionName = addressData.region,\n                customAttributes;\n\n            if (mageUtils.isObject(addressData.street)) {\n                addressData.street = this.objectToArray(addressData.street);\n            }\n\n            addressData.region = {\n                'region_id': addressData['region_id'],\n                'region_code': addressData['region_code'],\n                region: regionName\n            };\n\n            if (addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                region = countryData()[addressData['country_id']].regions[addressData['region_id']];\n\n                if (region) {\n                    addressData.region['region_id'] = addressData['region_id'];\n                    addressData.region['region_code'] = region.code;\n                    addressData.region.region = region.name;\n                }\n            } else if (\n                !addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                addressData.region['region_code'] = '';\n                addressData.region.region = '';\n            }\n            delete addressData['region_id'];\n\n            if (addressData['custom_attributes']) {\n                addressData['custom_attributes'] = _.map(\n                    addressData['custom_attributes'],\n                    function (value, key) {\n                        customAttributes = {\n                            'attribute_code': key,\n                            'value': value\n                        };\n\n                        if (typeof value === 'boolean') {\n                            customAttributes = {\n                                'attribute_code': key,\n                                'value': value,\n                                'label': value === true ? 'Yes' : 'No'\n                            };\n                        }\n\n                        return customAttributes;\n                    }\n                );\n            }\n\n            return address(addressData);\n        },\n\n        /**\n         * Convert Address object to address form data.\n         *\n         * @param {Object} addrs\n         * @returns {Object}\n         */\n        quoteAddressToFormAddressData: function (addrs) {\n            var self = this,\n                output = {},\n                streetObject,\n                customAttributesObject;\n\n            $.each(addrs, function (key) {\n                if (addrs.hasOwnProperty(key) && typeof addrs[key] !== 'function') {\n                    output[self.toUnderscore(key)] = addrs[key];\n                }\n            });\n\n            if (Array.isArray(addrs.street)) {\n                streetObject = {};\n                addrs.street.forEach(function (value, index) {\n                    streetObject[index] = value;\n                });\n                output.street = streetObject;\n            }\n\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (Array.isArray(addrs.customAttributes)) {\n                customAttributesObject = {};\n                addrs.customAttributes.forEach(function (value) {\n                    customAttributesObject[value.attribute_code] = value.value;\n                });\n                output.custom_attributes = customAttributesObject;\n            }\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            return output;\n        },\n\n        /**\n         * @param {String} string\n         */\n        toUnderscore: function (string) {\n            return string.replace(/([A-Z])/g, function ($1) {\n                return '_' + $1.toLowerCase();\n            });\n        },\n\n        /**\n         * @param {Object} formProviderData\n         * @param {String} formIndex\n         * @return {Object}\n         */\n        formDataProviderToFlatData: function (formProviderData, formIndex) {\n            var addressData = {};\n\n            $.each(formProviderData, function (path, value) {\n                var pathComponents = path.split('.'),\n                    dataObject = {};\n\n                pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                pathComponents.reverse();\n                $.each(pathComponents, function (index, pathPart) {\n                    var parent = {};\n\n                    if (index == 0) { //eslint-disable-line eqeqeq\n                        dataObject[pathPart] = value;\n                    } else {\n                        parent[pathPart] = dataObject;\n                        dataObject = parent;\n                    }\n                });\n                $.extend(true, addressData, dataObject);\n            });\n\n            return addressData;\n        },\n\n        /**\n         * Convert object to array\n         * @param {Object} object\n         * @returns {Array}\n         */\n        objectToArray: function (object) {\n            var convertedArray = [];\n\n            $.each(object, function (key) {\n                return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n            });\n\n            return convertedArray.slice(0);\n        },\n\n        /**\n         * @param {Object} addrs\n         * @return {*|Object}\n         */\n        addressToEstimationAddress: function (addrs) {\n            var self = this,\n                estimatedAddressData = {};\n\n            $.each(addrs, function (key) {\n                estimatedAddressData[self.toUnderscore(key)] = addrs[key];\n            });\n\n            return this.formAddressDataToQuoteAddress(estimatedAddressData);\n        }\n    };\n});\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils'\n], function (utils) {\n    'use strict';\n\n    return {\n        validatedPostCodeExample: [],\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @param {Array} postCodesPatterns\n         * @return {Boolean}\n         */\n        validate: function (postCode, countryId, postCodesPatterns) {\n            var pattern, regex,\n                patterns = postCodesPatterns ? postCodesPatterns[countryId] :\n                    window.checkoutConfig.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        }\n    };\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'domReady!'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Get totals data from the extension attributes.\n     * @param {*} data\n     * @returns {*}\n     */\n    var proceedTotalsData = function (data) {\n            if (_.isObject(data) && _.isObject(data['extension_attributes'])) {\n                _.each(data['extension_attributes'], function (element, index) {\n                    data[index] = element;\n                });\n            }\n\n            return data;\n        },\n        billingAddress = ko.observable(null),\n        shippingAddress = ko.observable(null),\n        shippingMethod = ko.observable(null),\n        paymentMethod = ko.observable(null),\n        quoteData = window.checkoutConfig.quoteData,\n        basePriceFormat = window.checkoutConfig.basePriceFormat,\n        priceFormat = window.checkoutConfig.priceFormat,\n        storeCode = window.checkoutConfig.storeCode,\n        totalsData = proceedTotalsData(window.checkoutConfig.totalsData),\n        totals = ko.observable(totalsData),\n        collectedTotals = ko.observable({});\n\n    return {\n        totals: totals,\n        shippingAddress: shippingAddress,\n        shippingMethod: shippingMethod,\n        billingAddress: billingAddress,\n        paymentMethod: paymentMethod,\n        guestEmail: null,\n\n        /**\n         * @return {*}\n         */\n        getQuoteId: function () {\n            return quoteData['entity_id'];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVirtual: function () {\n            return !!Number(quoteData['is_virtual']);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPriceFormat: function () {\n            return priceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBasePriceFormat: function () {\n            return basePriceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getItems: function () {\n            return window.checkoutConfig.quoteItemData;\n        },\n\n        /**\n         *\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals;\n        },\n\n        /**\n         * @param {Object} data\n         */\n        setTotals: function (data) {\n            data = proceedTotalsData(data);\n            totals(data);\n            this.setCollectedTotals('subtotal_with_discount', parseFloat(data['subtotal_with_discount']));\n        },\n\n        /**\n         * @param {*} paymentMethodCode\n         */\n        setPaymentMethod: function (paymentMethodCode) {\n            paymentMethod(paymentMethodCode);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPaymentMethod: function () {\n            return paymentMethod;\n        },\n\n        /**\n         * @return {*}\n         */\n        getStoreCode: function () {\n            return storeCode;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} value\n         */\n        setCollectedTotals: function (code, value) {\n            var colTotals = collectedTotals();\n\n            colTotals[code] = value;\n            collectedTotals(colTotals);\n        },\n\n        /**\n         * @return {Number}\n         */\n        getCalculatedTotal: function () {\n            var total = 0.; //eslint-disable-line no-floating-decimal\n\n            _.each(collectedTotals(), function (value) {\n                total += value;\n            });\n\n            return total;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/action/select-payment-method'\n], function (_, quote, methodList, selectPaymentMethod) {\n    'use strict';\n\n    /**\n    * Free method filter\n    * @param {Object} paymentMethod\n    * @return {Boolean}\n    */\n    var isFreePaymentMethod = function (paymentMethod) {\n            return paymentMethod.method === 'free';\n        },\n\n        /**\n         * Grabs the grand total from quote\n         * @return {Number}\n         */\n        getGrandTotal = function () {\n            return quote.totals()['grand_total'];\n        };\n\n    return {\n        isFreeAvailable: false,\n\n        /**\n         * Populate the list of payment methods\n         * @param {Array} methods\n         */\n        setPaymentMethods: function (methods) {\n            var freeMethod,\n                filteredMethods,\n                methodIsAvailable,\n                methodNames;\n\n            freeMethod = _.find(methods, isFreePaymentMethod);\n            this.isFreeAvailable = !!freeMethod;\n\n            if (freeMethod && getGrandTotal() <= 0) {\n                methods.splice(0, methods.length, freeMethod);\n                selectPaymentMethod(freeMethod);\n            }\n\n            filteredMethods = _.without(methods, freeMethod);\n\n            if (filteredMethods.length === 1) {\n                selectPaymentMethod(filteredMethods[0]);\n            } else if (quote.paymentMethod()) {\n                methodIsAvailable = methods.some(function (item) {\n                    return item.method === quote.paymentMethod().method;\n                });\n                //Unset selected payment method if not available\n                if (!methodIsAvailable) {\n                    selectPaymentMethod(null);\n                }\n            }\n\n            /**\n             * Overwrite methods with existing methods to preserve ko array references.\n             * This prevent ko from re-rendering those methods.\n             */\n            methodNames = _.pluck(methods, 'method');\n            _.map(methodList(), function (existingMethod) {\n                var existingMethodIndex = methodNames.indexOf(existingMethod.method);\n\n                if (existingMethodIndex !== -1) {\n                    methods[existingMethodIndex] = existingMethod;\n                }\n            });\n\n            methodList(methods);\n        },\n\n        /**\n         * Get the list of available payment methods.\n         * @return {Array}\n         */\n        getAvailablePaymentMethods: function () {\n            var allMethods = methodList().slice(),\n                grandTotalOverZero = getGrandTotal() > 0;\n\n            if (!this.isFreeAvailable) {\n                return allMethods;\n            }\n\n            if (grandTotalOverZero) {\n                return _.reject(allMethods, isFreePaymentMethod);\n            }\n\n            return _.filter(allMethods, isFreePaymentMethod);\n        }\n    };\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Checkout/js/model/billing-address-postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n           'jquery',\n           'Magento_Checkout/js/model/postcode-validator',\n           'mage/translate',\n           'uiRegistry'\n       ], function (\n    $,\n    postcodeValidator,\n    $t,\n    uiRegistry\n) {\n    'use strict';\n\n    var postcodeElementName = 'postcode';\n\n    return {\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this;\n\n            uiRegistry.async(formPath + '.' + postcodeElementName)(self.bindHandler.bind(self));\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            element.on('value', function () {\n                clearTimeout(self.validateZipCodeTimeout);\n                self.validateZipCodeTimeout = setTimeout(function () {\n                    self.postcodeValidation(element);\n                }, delay);\n            });\n        },\n\n        /**\n         * @param {Object} postcodeElement\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var cache = [];\n\n    return {\n        /**\n         * @param {String} addressKey\n         * @return {*}\n         */\n        get: function (addressKey) {\n            if (cache[addressKey]) {\n                return cache[addressKey];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} addressKey\n         * @param {*} data\n         */\n        set: function (addressKey, data) {\n            cache[addressKey] = data;\n        }\n    };\n});\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        popUp: false,\n\n        /**\n         * @param {Object} popUp\n         */\n        setPopup: function (popUp) {\n            this.popUp = popUp;\n        },\n\n        /**\n         * Show popup.\n         */\n        show: function () {\n            if (this.popUp) {\n                this.popUp.modal('openModal');\n            }\n        },\n\n        /**\n         * Hide popup.\n         */\n        hide: function () {\n            if (this.popUp) {\n                this.popUp.modal('closeModal');\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (quote, defaultProcessor, totalsDefaultProvider, shippingService, cartCache, customerData) {\n    'use strict';\n\n    var rateProcessors = {},\n        totalsProcessors = {},\n\n        /**\n         * Estimate totals for shipping address and update shipping rates.\n         */\n        estimateTotalsAndUpdateRates = function () {\n            var type = quote.shippingAddress().getType();\n\n            if (\n                quote.isVirtual() ||\n                window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0\n            ) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.shippingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n            } else {\n                // check if user data not changed -> load rates from cache\n                if (!cartCache.isChanged('address', quote.shippingAddress()) &&\n                    !cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                    cartCache.get('rates')\n                ) {\n                    shippingService.setShippingRates(cartCache.get('rates'));\n\n                    return;\n                }\n\n                // update rates list when estimated address was set\n                rateProcessors['default'] = defaultProcessor;\n                rateProcessors[type] ?\n                    rateProcessors[type].getRates(quote.shippingAddress()) :\n                    rateProcessors['default'].getRates(quote.shippingAddress());\n\n                // save rates to cache after load\n                shippingService.getShippingRates().subscribe(function (rates) {\n                    cartCache.set('rates', rates);\n                });\n            }\n        },\n\n        /**\n         * Estimate totals for shipping address.\n         */\n        estimateTotalsShipping = function () {\n            totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n        },\n\n        /**\n         * Estimate totals for billing address.\n         */\n        estimateTotalsBilling = function () {\n            var type = quote.billingAddress().getType();\n\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.billingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.billingAddress());\n            }\n        };\n\n    quote.shippingAddress.subscribe(estimateTotalsAndUpdateRates);\n    quote.shippingMethod.subscribe(estimateTotalsShipping);\n    quote.billingAddress.subscribe(estimateTotalsBilling);\n});\n","Magento_Checkout/js/model/cart/cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Cart adapter for customer data storage.\n * It stores cart data in customer data(localStorage) without saving on server.\n * Adapter is created for shipping rates and totals data caching. It eliminates unneeded calculations requests.\n */\ndefine([\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'mageUtils'\n], function (_, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'cart-data',\n        cartData = {\n            totals: null,\n            address: null,\n            cartVersion: null,\n            shippingMethodCode: null,\n            shippingCarrierCode: null,\n            rates: null\n        },\n\n        /**\n         * Set data to local storage.\n         *\n         * @param {Object} checkoutData\n         */\n        setData = function (checkoutData) {\n            storage.set(cacheKey, checkoutData);\n        },\n\n        /**\n         * Get data from local storage.\n         *\n         * @param {String} [key]\n         * @returns {*}\n         */\n        getData = function (key) {\n            var data = key ? storage.get(cacheKey)()[key] : storage.get(cacheKey)();\n\n            if (_.isEmpty(storage.get(cacheKey)())) {\n                setData(utils.copy(cartData));\n            }\n\n            return data;\n        },\n\n        /**\n         * Build method name base on name, prefix and suffix.\n         *\n         * @param {String} name\n         * @param {String} prefix\n         * @param {String} suffix\n         * @return {String}\n         */\n        getMethodName = function (name, prefix, suffix) {\n            prefix = prefix || '';\n            suffix = suffix || '';\n\n            return prefix + name.charAt(0).toUpperCase() + name.slice(1) + suffix;\n        };\n\n    /**\n     * Provides get/set/isChanged/clear methods for work with cart data.\n     * Can be customized via mixin functionality.\n     */\n    return {\n        cartData: cartData,\n\n        /**\n         * Array of required address fields\n         */\n        requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n        /**\n         * Get data from customer data.\n         * Concatenate provided key with method name and call method if it exist or makes get by key.\n         *\n         * @param {String} key\n         * @return {*}\n         */\n        get: function (key) {\n            var methodName = getMethodName(key, '_get');\n\n            if (key === cacheKey) {\n                return getData();\n            }\n\n            if (this[methodName]) {\n                return this[methodName]();\n            }\n\n            return getData(key);\n        },\n\n        /**\n         * Set data to customer data.\n         * Concatenate provided key with method name and call method if it exist or makes set by key.\n         * @example _setCustomAddress method will be called, if it exists.\n         *  set('address', customAddressValue)\n         * @example Will set value by provided key.\n         *  set('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         */\n        set: function (key, value) {\n            var methodName = getMethodName(key, '_set'),\n                obj;\n\n            if (key === cacheKey) {\n                _.each(value, function (val, k) {\n                    this.set(k, val);\n                }, this);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName](value);\n            } else {\n                obj = getData();\n                obj[key] = value;\n                setData(obj);\n            }\n        },\n\n        /**\n         * Clear data in cache.\n         * Concatenate provided key with method name and call method if it exist or clear by key.\n         * @example _clearCustomAddress method will be called, if it exist.\n         *  clear('customAddress')\n         * @example Will clear data by provided key.\n         *  clear('rates')\n         *\n         * @param {String} key\n         */\n        clear: function (key) {\n            var methodName = getMethodName(key, '_clear');\n\n            if (key === cacheKey) {\n                setData(this.cartData);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName]();\n            } else {\n                this.set(key, null);\n            }\n        },\n\n        /**\n         * Check if provided data has difference with cached data.\n         * Concatenate provided key with method name and call method if it exist or makes strict equality.\n         * @example Will call existing _isAddressChanged.\n         *  isChanged('address', addressToCompare)\n         * @example Will get data by provided key and make strict equality with provided value.\n         *  isChanged('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         * @return {Boolean}\n         */\n        isChanged: function (key, value) {\n            var methodName = getMethodName(key, '_is', 'Changed');\n\n            if (this[methodName]) {\n                return this[methodName](value);\n            }\n\n            return this.get(key) !== value;\n        },\n\n        /**\n         * Compare cached address with provided.\n         * Custom method for check object equality.\n         *\n         * @param {Object} address\n         * @returns {Boolean}\n         */\n        _isAddressChanged: function (address) {\n            return JSON.stringify(_.pick(this.get('address'), this.requiredFields)) !==\n                JSON.stringify(_.pick(address, this.requiredFields));\n        },\n\n        /**\n         * Compare cached subtotal with provided.\n         * Custom method for check object equality.\n         *\n         * @param {float} subtotal\n         * @returns {Boolean}\n         */\n        _isSubtotalChanged: function (subtotal) {\n            var cached = parseFloat(this.get('totals').subtotal);\n\n            return subtotal !== cached;\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor, cartCache, customerData) {\n    'use strict';\n\n    /**\n     * Load data from server.\n     *\n     * @param {Object} address\n     */\n    var loadFromServer = function (address) {\n        var serviceUrl,\n            payload;\n\n        // Start loader for totals block\n        totalsService.isLoading(true);\n        serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);\n        payload = {\n            addressInformation: {\n                address: _.pick(address, cartCache.requiredFields)\n            }\n        };\n\n        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n            payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n            payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n        }\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), false\n        ).done(function (result) {\n            var data = {\n                totals: result,\n                address: address,\n                cartVersion: customerData.get('cart')()['data_id'],\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            quote.setTotals(result);\n            cartCache.set('cart-data', data);\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        }).always(function () {\n            // Stop loader for totals block\n            totalsService.isLoading(false);\n        });\n    };\n\n    return {\n        /**\n         * Array of required address fields.\n         * @property {Array.String} requiredFields\n         * @deprecated Use cart cache.\n         */\n        requiredFields: cartCache.requiredFields,\n\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        estimateTotals: function (address) {\n            return loadFromServer(address);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, serviceUrl, payload;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getCacheKey());\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    serviceUrl, payload, false\n                ).done(function (result) {\n                    rateRegistry.set(address.getCacheKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getKey());\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                    JSON.stringify({\n                        addressId: address.customerAddressId\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(address.getKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    var validators = [];\n\n    return {\n        /**\n         * Register unique validator\n         *\n         * @param {*} validator\n         */\n        registerValidator: function (validator) {\n            validators.push(validator);\n        },\n\n        /**\n         * Returns array of registered validators\n         *\n         * @returns {Array}\n         */\n        getValidators: function () {\n            return validators;\n        },\n\n        /**\n         * Process validators\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var validationResult = true;\n\n            hideError = hideError || false;\n\n            if (validators.length <= 0) {\n                return validationResult;\n            }\n\n            validators.forEach(function (item) {\n                if (item.validate(hideError) == false) { //eslint-disable-line eqeqeq\n                    validationResult = false;\n\n                    return false;\n                }\n            });\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/place-order-hooks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        requestModifiers: [],\n        afterRequestListeners: []\n    };\n});\n","Magento_Checkout/js/model/payment/method-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'uiElement',\n        'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    var DEFAULT_GROUP_ALIAS = 'default';\n\n    return Element.extend({\n        defaults: {\n            alias: DEFAULT_GROUP_ALIAS,\n            title: $t('Payment Method'),\n            sortOrder: 100,\n            displayArea: 'payment-methods-items-${ $.alias }'\n        },\n\n        /**\n         * Checks if group instance is default\n         *\n         * @returns {Boolean}\n         */\n        isDefault: function () {\n            return this.alias === DEFAULT_GROUP_ALIAS;\n        }\n    });\n});\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (methods) {\n        _.each(methods, function (method) {\n            if (method.hasOwnProperty('code')) {\n                method.method = method.code;\n                delete method.code;\n            }\n        });\n\n        return methods;\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'mage/storage',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/shipping-save-processor/payload-extender'\n], function (\n    ko,\n    quote,\n    resourceUrlManager,\n    storage,\n    paymentService,\n    methodConverter,\n    errorProcessor,\n    fullScreenLoader,\n    selectBillingAddressAction,\n    payloadExtender\n) {\n    'use strict';\n\n    return {\n        /**\n         * @return {jQuery.Deferred}\n         */\n        saveShippingInformation: function () {\n            var payload;\n\n            if (!quote.billingAddress() && quote.shippingAddress().canUseForBilling()) {\n                selectBillingAddressAction(quote.shippingAddress());\n            }\n\n            payload = {\n                addressInformation: {\n                    'shipping_address': quote.shippingAddress(),\n                    'billing_address': quote.billingAddress(),\n                    'shipping_method_code': quote.shippingMethod()['method_code'],\n                    'shipping_carrier_code': quote.shippingMethod()['carrier_code']\n                }\n            };\n\n            payloadExtender(payload);\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                resourceUrlManager.getUrlForSetShippingInformation(quote),\n                JSON.stringify(payload)\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n                    fullScreenLoader.stopLoader();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/payload-extender.js":"define([], function () {\n    'use strict';\n\n    return function (payload) {\n        payload.addressInformation['extension_attributes'] = {};\n\n        return payload;\n    };\n});\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return {\n        isVisible: ko.observable(false)\n    };\n});\n","Magento_Sales/js/orders-returns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param {jQuery.Event} e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function (e) {\n            var value = $(e.target).val();\n\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});\n","Magento_Sales/js/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param {jQuery.Event} event - Click event.\n         */\n        _toggleGiftMessage: function (event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n\n            region.toggleClass(options.expandedContentClass, options.duration, function () {\n                if (region.attr('aria-expanded') === 'true') {\n                    region.attr('aria-expanded', 'false');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', 'true');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n\n    return $.mage.giftMessage;\n});\n","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function (Component, customerData, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isShowAddToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n            this.lastOrderedItems.subscribe(this.checkSalableItems.bind(this));\n            this.checkSalableItems();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('isShowAddToCart');\n\n            return this;\n        },\n\n        /**\n         * Check if items is_saleable and change add to cart button visibility.\n         */\n        checkSalableItems: function () {\n            var isShowAddToCart = _.some(this.lastOrderedItems().items, {\n                'is_saleable': true\n            });\n\n            this.isShowAddToCart(isShowAddToCart);\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/offline-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'checkmo',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method'\n        },\n        {\n            type: 'banktransfer',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method'\n        },\n        {\n            type: 'cashondelivery',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method'\n        },\n        {\n            type: 'purchaseorder',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'mage/validation'\n], function (Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/purchaseorder-form',\n            purchaseOrderNumber: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('purchaseOrderNumber');\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                method: this.item.method,\n                'po_number': this.purchaseOrderNumber(),\n                'additional_data': null\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = 'form[data-role=purchaseorder-form]';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/cashondelivery'\n        },\n\n        /**\n         * Returns payment method instructions.\n         *\n         * @return {*}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/payment/default'\n], function (ko, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/banktransfer'\n        },\n\n        /**\n         * Get value of instruction field.\n         * @returns {String}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/checkmo'\n        },\n\n        /**\n         * Returns send check to info.\n         *\n         * @return {*}\n         */\n        getMailingAddress: function () {\n            return window.checkoutConfig.payment.checkmo.mailingAddress;\n        },\n\n        /**\n         * Returns payable to info.\n         *\n         * @return {*}\n         */\n        getPayableTo: function () {\n            return window.checkoutConfig.payment.checkmo.payableTo;\n        }\n    });\n});\n","Magento_PageCache/js/page-cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'domReady',\n    'consoleLogger',\n    'Magento_PageCache/js/form-key-provider',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($, domReady, consoleLogger, formKeyInit) {\n    'use strict';\n\n    /**\n     * Helper. Generate random string\n     * TODO: Merge with mage/utils\n     * @param {String} chars - list of symbols\n     * @param {Number} length - length for need string\n     * @returns {String}\n     */\n    function generateRandomString(chars, length) {\n        var result = '';\n\n        length = length > 0 ? length : 1;\n\n        while (length--) {\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        }\n\n        return result;\n    }\n\n    /**\n     * Nodes tree to flat list converter\n     * @returns {Array}\n     */\n    $.fn.comments = function () {\n        var elements = [],\n            contents,\n            elementContents;\n\n        /**\n         * @param {jQuery} element - Comment holder\n         */\n        (function lookup(element) {\n            var iframeHostName;\n\n            // prevent cross origin iframe content reading\n            if ($(element).prop('tagName') === 'IFRAME') {\n                iframeHostName = $('<a>').prop('href', $(element).prop('src'))\n                    .prop('hostname');\n\n                if (window.location.hostname !== iframeHostName) {\n                    return [];\n                }\n            }\n\n            /**\n             * Rewrite jQuery contents().\n             *\n             * @param {jQuery} elem\n             */\n            contents = function (elem) {\n                return $.map(elem, function (el) {\n                    try {\n                        return el.nodeName.toLowerCase() === 'iframe' ?\n                            el.contentDocument || (el.contentWindow ? el.contentWindow.document : []) :\n                            $.merge([], el.childNodes);\n                    } catch (e) {\n                        consoleLogger.error(e);\n\n                        return [];\n                    }\n                });\n            };\n\n            elementContents = contents($(element));\n\n            $.each(elementContents, function (index, el) {\n                switch (el.nodeType) {\n                    case 1: // ELEMENT_NODE\n                        lookup(el);\n                        break;\n\n                    case 8: // COMMENT_NODE\n                        elements.push(el);\n                        break;\n\n                    case 9: // DOCUMENT_NODE\n                        lookup($(el).find('body'));\n                        break;\n                }\n            });\n        })(this);\n\n        return elements;\n    };\n\n    /**\n     * FormKey Widget - this widget is generating from key, saves it to cookie and\n     * @deprecated see Magento/PageCache/view/frontend/web/js/form-key-provider.js\n     */\n    $.widget('mage.formKey', {\n        options: {\n            inputSelector: 'input[name=\"form_key\"]',\n            allowedCharacters: '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',\n            length: 16\n        },\n\n        /**\n         * Creates widget 'mage.formKey'\n         * @private\n         */\n        _create: function () {\n            var formKey = $.mage.cookies.get('form_key'),\n                options = {\n                    secure: window.cookiesConfig ? window.cookiesConfig.secure : false\n                };\n\n            if (!formKey) {\n                formKey = generateRandomString(this.options.allowedCharacters, this.options.length);\n                $.mage.cookies.set('form_key', formKey, options);\n            }\n            $(this.options.inputSelector).val(formKey);\n        }\n    });\n\n    /**\n     * PageCache Widget\n     * Handles additional ajax request for rendering user private content.\n     */\n    $.widget('mage.pageCache', {\n        options: {\n            url: '/',\n            patternPlaceholderOpen: /^ BLOCK (.+) $/,\n            patternPlaceholderClose: /^ \\/BLOCK (.+) $/,\n            versionCookieName: 'private_content_version',\n            handles: []\n        },\n\n        /**\n         * Creates widget 'mage.pageCache'\n         * @private\n         */\n        _create: function () {\n            var placeholders,\n                version = $.mage.cookies.get(this.options.versionCookieName);\n\n            if (!version) {\n                return;\n            }\n            placeholders = this._searchPlaceholders(this.element.comments());\n\n            if (placeholders && placeholders.length) {\n                this._ajax(placeholders, version);\n            }\n        },\n\n        /**\n         * Parse page for placeholders.\n         * @param {Array} elements\n         * @returns {Array}\n         * @private\n         */\n        _searchPlaceholders: function (elements) {\n            var placeholders = [],\n                tmp = {},\n                ii,\n                len,\n                el, matches, name;\n\n            if (!(elements && elements.length)) {\n                return placeholders;\n            }\n\n            for (ii = 0, len = elements.length; ii < len; ii++) {\n                el = elements[ii];\n                matches = this.options.patternPlaceholderOpen.exec(el.nodeValue);\n                name = null;\n\n                if (matches) {\n                    name = matches[1];\n                    tmp[name] = {\n                        name: name,\n                        openElement: el\n                    };\n                } else {\n                    matches = this.options.patternPlaceholderClose.exec(el.nodeValue);\n\n                    if (matches) { //eslint-disable-line max-depth\n                        name = matches[1];\n\n                        if (tmp[name]) { //eslint-disable-line max-depth\n                            tmp[name].closeElement = el;\n                            placeholders.push(tmp[name]);\n                            delete tmp[name];\n                        }\n                    }\n                }\n            }\n\n            return placeholders;\n        },\n\n        /**\n         * Parse for page and replace placeholders\n         * @param {Object} placeholder\n         * @param {Object} html\n         * @protected\n         */\n        _replacePlaceholder: function (placeholder, html) {\n            var startReplacing = false,\n                prevSibling = null,\n                parent, contents, yy, len, element;\n\n            if (!placeholder || !html) {\n                return;\n            }\n\n            parent = $(placeholder.openElement).parent();\n            contents = parent.contents();\n\n            for (yy = 0, len = contents.length; yy < len; yy++) {\n                element = contents[yy];\n\n                if (element == placeholder.openElement) { //eslint-disable-line eqeqeq\n                    startReplacing = true;\n                }\n\n                if (startReplacing) {\n                    $(element).remove();\n                } else if (element.nodeType != 8) { //eslint-disable-line eqeqeq\n                    //due to comment tag doesn't have siblings we try to find it manually\n                    prevSibling = element;\n                }\n\n                if (element == placeholder.closeElement) { //eslint-disable-line eqeqeq\n                    break;\n                }\n            }\n\n            if (prevSibling) {\n                $(prevSibling).after(html);\n            } else {\n                $(parent).prepend(html);\n            }\n\n            // trigger event to use mage-data-init attribute\n            $(parent).trigger('contentUpdated');\n        },\n\n        /**\n         * AJAX helper\n         * @param {Object} placeholders\n         * @param {String} version\n         * @private\n         */\n        _ajax: function (placeholders, version) {\n            var ii,\n                data = {\n                    blocks: [],\n                    handles: this.options.handles,\n                    originalRequest: this.options.originalRequest,\n                    version: version\n                };\n\n            for (ii = 0; ii < placeholders.length; ii++) {\n                data.blocks.push(placeholders[ii].name);\n            }\n            data.blocks = JSON.stringify(data.blocks.sort());\n            data.handles = JSON.stringify(data.handles);\n            data.originalRequest = JSON.stringify(data.originalRequest);\n            $.ajax({\n                url: this.options.url,\n                data: data,\n                type: 'GET',\n                cache: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * Response handler\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var placeholder, i;\n\n                    for (i = 0; i < placeholders.length; i++) {\n                        placeholder = placeholders[i];\n\n                        if (response.hasOwnProperty(placeholder.name)) {\n                            this._replacePlaceholder(placeholder, response[placeholder.name]);\n                        }\n                    }\n                }\n            });\n        }\n    });\n\n    domReady(function () {\n        formKeyInit();\n    });\n\n    return {\n        'pageCache': $.mage.pageCache,\n        'formKey': $.mage.formKey\n    };\n});\n","Magento_PageCache/js/form-key-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return function (settings) {\n        var formKey,\n            inputElements,\n            inputSelector = 'input[name=\"form_key\"]';\n\n        /**\n         * Set form_key cookie\n         * @private\n         */\n        function setFormKeyCookie(value) {\n            var expires,\n                secure,\n                date = new Date(),\n                cookiesConfig = window.cookiesConfig || {},\n                isSecure = !!cookiesConfig.secure,\n                samesite = cookiesConfig.samesite || 'lax';\n\n            date.setTime(date.getTime() + 86400000);\n            expires = '; expires=' + date.toUTCString();\n            secure = isSecure ? '; secure' : '';\n            samesite = '; samesite=' + samesite;\n\n            document.cookie = 'form_key=' + (value || '') + expires + secure + '; path=/' + samesite;\n        }\n\n        /**\n         * Retrieves form key from cookie\n         * @private\n         */\n        function getFormKeyCookie() {\n            var cookie,\n                i,\n                nameEQ = 'form_key=',\n                cookieArr = document.cookie.split(';');\n\n            for (i = 0; i < cookieArr.length; i++) {\n                cookie = cookieArr[i];\n\n                while (cookie.charAt(0) === ' ') {\n                    cookie = cookie.substring(1, cookie.length);\n                }\n\n                if (cookie.indexOf(nameEQ) === 0) {\n                    return cookie.substring(nameEQ.length, cookie.length);\n                }\n            }\n\n            return null;\n        }\n\n        /**\n         * Get form key from UI input hidden\n         * @private\n         */\n        function getFormKeyFromUI() {\n            return document.querySelector(inputSelector).value;\n        }\n\n        /**\n         * Generate form key string\n         * @private\n         */\n        function generateFormKeyString() {\n            var result = '',\n                length = 16,\n                chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n\n            while (length--) {\n                result += chars[Math.round(Math.random() * (chars.length - 1))];\n            }\n\n            return result;\n        }\n\n        /**\n         * Init form_key inputs with value\n         * @private\n         */\n        function initFormKey() {\n            formKey = getFormKeyCookie();\n\n            if (settings && settings.isPaginationCacheEnabled && !formKey) {\n                formKey = getFormKeyFromUI();\n                setFormKeyCookie(formKey);\n            }\n\n            if (!formKey) {\n                formKey = generateFormKeyString();\n                setFormKeyCookie(formKey);\n            }\n            inputElements = document.querySelectorAll(inputSelector);\n\n            if (inputElements.length) {\n                Array.prototype.forEach.call(inputElements, function (element) {\n                    element.setAttribute('value', formKey);\n                });\n            }\n        }\n\n        initFormKey();\n    };\n});\n","Threedadv_Catalog/js/titledescription.js":"require(['jquery'], function ($) {\n    $(document).ready(function () {\n        const maxLength = 167;\n\n        $('.product.attribute.overview [itemprop=\"description\"]').each(function () {\n            const fullText = $(this).text();\n\n            if (fullText.length > maxLength) {\n                const visibleText = fullText.substring(0, maxLength) + \"...\";\n                $(this).html(`\n                    <span class=\"short-text\">${visibleText}</span>\n                    <span class=\"full-text\" style=\"display: none;\">${fullText}</span>\n                    <a href=\"#\" class=\"toggle-text\">Ver m\u00e1s</a>\n                `);\n            }\n        });\n\n        $(document).on('click', '.toggle-text', function (e) {\n            e.preventDefault();\n            const container = $(this).closest('[itemprop=\"description\"]');\n            container.find('.short-text').toggle();\n            container.find('.full-text').toggle();\n\n            $(this).text($(this).text() === \"Ver m\u00e1s\" ? \"Ver menos\" : \"Ver m\u00e1s\");\n        });\n    });\n});\n","Threedadv_Catalog/js/productdetailscript.js":"require(['jquery'], function ($) {\n    $(document).ready(function () {\n        $('#go-to-address-btn').on('click', function () {\n            const targetCoordinates = $(this).data('coordinates');\n            const [targetLat, targetLng] = targetCoordinates.split(',').map(coord => coord.trim());\n\n            if (navigator.geolocation) {\n                navigator.geolocation.getCurrentPosition(\n                    function (position) {\n                        const userLat = position.coords.latitude;\n                        const userLng = position.coords.longitude;\n                        const googleMapsUrl = `https://www.google.com/maps/dir/${userLat},${userLng}/${targetLat},${targetLng}`;\n                        window.open(googleMapsUrl, '_blank');\n                    },\n                    function (error) {\n                        alert('Error getting your location: ' + error.message);\n                    }\n                );\n            } else {\n                alert('Geolocation is not supported by your browser.');\n            }\n        });\n    });\n});","Mageplaza_Core/js/jquery.ui.touch-punch.min.js":"/*!\r\n * jQuery UI Touch Punch 0.2.3\r\n *\r\n * Copyright 2011\u20132014, Dave Furfero\r\n * Dual licensed under the MIT or GPL Version 2 licenses.\r\n *\r\n * Depends:\r\n *  jquery.ui.widget.js\r\n *  jquery.ui.mouse.js\r\n */\r\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);\r\n","Mageplaza_Core/js/ion.rangeSlider.min.js":"// Ion.RangeSlider | version 2.1.6 | https://github.com/IonDen/ion.rangeSlider\r\n;(function(f){\"function\"===typeof define&&define.amd?define([\"jquery\"],function(p){return f(p,document,window,navigator)}):\"object\"===typeof exports?f(require(\"jquery\"),document,window,navigator):f(jQuery,document,window,navigator)})(function(f,p,h,t,q){var u=0,m=function(){var a=t.userAgent,b=/msie\\s\\d+/i;return 0<a.search(b)&&(a=b.exec(a).toString(),a=a.split(\" \")[1],9>a)?(f(\"html\").addClass(\"lt-ie9\"),!0):!1}();Function.prototype.bind||(Function.prototype.bind=function(a){var b=this,d=[].slice;if(\"function\"!=\r\n    typeof b)throw new TypeError;var c=d.call(arguments,1),e=function(){if(this instanceof e){var g=function(){};g.prototype=b.prototype;var g=new g,l=b.apply(g,c.concat(d.call(arguments)));return Object(l)===l?l:g}return b.apply(a,c.concat(d.call(arguments)))};return e});Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){var d;if(null==this)throw new TypeError('\"this\" is null or not defined');var c=Object(this),e=c.length>>>0;if(0===e)return-1;d=+b||0;Infinity===Math.abs(d)&&(d=0);if(d>=\r\n    e)return-1;for(d=Math.max(0<=d?d:e-Math.abs(d),0);d<e;){if(d in c&&c[d]===a)return d;d++}return-1});var r=function(a,b,d){this.VERSION=\"2.1.6\";this.input=a;this.plugin_count=d;this.old_to=this.old_from=this.update_tm=this.calc_count=this.current_plugin=0;this.raf_id=this.old_min_interval=null;this.is_update=this.is_key=this.no_diapason=this.force_redraw=this.dragging=!1;this.is_start=this.is_first_update=!0;this.is_click=this.is_resize=this.is_active=this.is_finish=!1;b=b||{};this.$cache={win:f(h),\r\n    body:f(p.body),input:f(a),cont:null,rs:null,min:null,max:null,from:null,to:null,single:null,bar:null,line:null,s_single:null,s_from:null,s_to:null,shad_single:null,shad_from:null,shad_to:null,edge:null,grid:null,grid_labels:[]};this.coords={x_gap:0,x_pointer:0,w_rs:0,w_rs_old:0,w_handle:0,p_gap:0,p_gap_left:0,p_gap_right:0,p_step:0,p_pointer:0,p_handle:0,p_single_fake:0,p_single_real:0,p_from_fake:0,p_from_real:0,p_to_fake:0,p_to_real:0,p_bar_x:0,p_bar_w:0,grid_gap:0,big_num:0,big:[],big_w:[],big_p:[],\r\n    big_x:[]};this.labels={w_min:0,w_max:0,w_from:0,w_to:0,w_single:0,p_min:0,p_max:0,p_from_fake:0,p_from_left:0,p_to_fake:0,p_to_left:0,p_single_fake:0,p_single_left:0};var c=this.$cache.input;a=c.prop(\"value\");var e;d={type:\"single\",min:10,max:100,from:null,to:null,step:1,min_interval:0,max_interval:0,drag_interval:!1,values:[],p_values:[],from_fixed:!1,from_min:null,from_max:null,from_shadow:!1,to_fixed:!1,to_min:null,to_max:null,to_shadow:!1,prettify_enabled:!0,prettify_separator:\" \",prettify:null,\r\n    force_edges:!1,keyboard:!1,keyboard_step:5,grid:!1,grid_margin:!0,grid_num:4,grid_snap:!1,hide_min_max:!1,hide_from_to:!1,prefix:\"\",postfix:\"\",max_postfix:\"\",decorate_both:!0,values_separator:\" \\u2014 \",input_values_separator:\";\",disable:!1,onStart:null,onChange:null,onFinish:null,onUpdate:null};\"INPUT\"!==c[0].nodeName&&console&&console.warn&&console.warn(\"Base element should be <input>!\",c[0]);c={type:c.data(\"type\"),min:c.data(\"min\"),max:c.data(\"max\"),from:c.data(\"from\"),to:c.data(\"to\"),step:c.data(\"step\"),\r\n    min_interval:c.data(\"minInterval\"),max_interval:c.data(\"maxInterval\"),drag_interval:c.data(\"dragInterval\"),values:c.data(\"values\"),from_fixed:c.data(\"fromFixed\"),from_min:c.data(\"fromMin\"),from_max:c.data(\"fromMax\"),from_shadow:c.data(\"fromShadow\"),to_fixed:c.data(\"toFixed\"),to_min:c.data(\"toMin\"),to_max:c.data(\"toMax\"),to_shadow:c.data(\"toShadow\"),prettify_enabled:c.data(\"prettifyEnabled\"),prettify_separator:c.data(\"prettifySeparator\"),force_edges:c.data(\"forceEdges\"),keyboard:c.data(\"keyboard\"),\r\n    keyboard_step:c.data(\"keyboardStep\"),grid:c.data(\"grid\"),grid_margin:c.data(\"gridMargin\"),grid_num:c.data(\"gridNum\"),grid_snap:c.data(\"gridSnap\"),hide_min_max:c.data(\"hideMinMax\"),hide_from_to:c.data(\"hideFromTo\"),prefix:c.data(\"prefix\"),postfix:c.data(\"postfix\"),max_postfix:c.data(\"maxPostfix\"),decorate_both:c.data(\"decorateBoth\"),values_separator:c.data(\"valuesSeparator\"),input_values_separator:c.data(\"inputValuesSeparator\"),disable:c.data(\"disable\")};c.values=c.values&&c.values.split(\",\");for(e in c)c.hasOwnProperty(e)&&\r\n(c[e]!==q&&\"\"!==c[e]||delete c[e]);a!==q&&\"\"!==a&&(a=a.split(c.input_values_separator||b.input_values_separator||\";\"),a[0]&&a[0]==+a[0]&&(a[0]=+a[0]),a[1]&&a[1]==+a[1]&&(a[1]=+a[1]),b&&b.values&&b.values.length?(d.from=a[0]&&b.values.indexOf(a[0]),d.to=a[1]&&b.values.indexOf(a[1])):(d.from=a[0]&&+a[0],d.to=a[1]&&+a[1]));f.extend(d,b);f.extend(d,c);this.options=d;this.update_check={};this.validate();this.result={input:this.$cache.input,slider:null,min:this.options.min,max:this.options.max,from:this.options.from,\r\n    from_percent:0,from_value:null,to:this.options.to,to_percent:0,to_value:null};this.init()};r.prototype={init:function(a){this.no_diapason=!1;this.coords.p_step=this.convertToPercent(this.options.step,!0);this.target=\"base\";this.toggleInput();this.append();this.setMinMax();a?(this.force_redraw=!0,this.calc(!0),this.callOnUpdate()):(this.force_redraw=!0,this.calc(!0),this.callOnStart());this.updateScene()},append:function(){this.$cache.input.before('<span class=\"irs js-irs-'+this.plugin_count+'\"></span>');\r\n        this.$cache.input.prop(\"readonly\",!0);this.$cache.cont=this.$cache.input.prev();this.result.slider=this.$cache.cont;this.$cache.cont.html('<span class=\"irs\"><span class=\"irs-line\" tabindex=\"-1\"><span class=\"irs-line-left\"></span><span class=\"irs-line-mid\"></span><span class=\"irs-line-right\"></span></span><span class=\"irs-min\">0</span><span class=\"irs-max\">1</span><span class=\"irs-from\">0</span><span class=\"irs-to\">0</span><span class=\"irs-single\">0</span></span><span class=\"irs-grid\"></span><span class=\"irs-bar\"></span>');\r\n        this.$cache.rs=this.$cache.cont.find(\".irs\");this.$cache.min=this.$cache.cont.find(\".irs-min\");this.$cache.max=this.$cache.cont.find(\".irs-max\");this.$cache.from=this.$cache.cont.find(\".irs-from\");this.$cache.to=this.$cache.cont.find(\".irs-to\");this.$cache.single=this.$cache.cont.find(\".irs-single\");this.$cache.bar=this.$cache.cont.find(\".irs-bar\");this.$cache.line=this.$cache.cont.find(\".irs-line\");this.$cache.grid=this.$cache.cont.find(\".irs-grid\");\"single\"===this.options.type?(this.$cache.cont.append('<span class=\"irs-bar-edge\"></span><span class=\"irs-shadow shadow-single\"></span><span class=\"irs-slider single\"></span>'),\r\n            this.$cache.edge=this.$cache.cont.find(\".irs-bar-edge\"),this.$cache.s_single=this.$cache.cont.find(\".single\"),this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.shad_single=this.$cache.cont.find(\".shadow-single\")):(this.$cache.cont.append('<span class=\"irs-shadow shadow-from\"></span><span class=\"irs-shadow shadow-to\"></span><span class=\"irs-slider from\"></span><span class=\"irs-slider to\"></span>'),this.$cache.s_from=this.$cache.cont.find(\".from\"),\r\n            this.$cache.s_to=this.$cache.cont.find(\".to\"),this.$cache.shad_from=this.$cache.cont.find(\".shadow-from\"),this.$cache.shad_to=this.$cache.cont.find(\".shadow-to\"),this.setTopHandler());this.options.hide_from_to&&(this.$cache.from[0].style.display=\"none\",this.$cache.to[0].style.display=\"none\",this.$cache.single[0].style.display=\"none\");this.appendGrid();this.options.disable?(this.appendDisableMask(),this.$cache.input[0].disabled=!0):(this.$cache.cont.removeClass(\"irs-disabled\"),this.$cache.input[0].disabled=\r\n            !1,this.bindEvents());this.options.drag_interval&&(this.$cache.bar[0].style.cursor=\"ew-resize\")},setTopHandler:function(){var a=this.options.max,b=this.options.to;this.options.from>this.options.min&&b===a?this.$cache.s_from.addClass(\"type_last\"):b<a&&this.$cache.s_to.addClass(\"type_last\")},changeLevel:function(a){switch(a){case \"single\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_single_fake);break;case \"from\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake);\r\n        this.$cache.s_from.addClass(\"state_hover\");this.$cache.s_from.addClass(\"type_last\");this.$cache.s_to.removeClass(\"type_last\");break;case \"to\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_to_fake);this.$cache.s_to.addClass(\"state_hover\");this.$cache.s_to.addClass(\"type_last\");this.$cache.s_from.removeClass(\"type_last\");break;case \"both\":this.coords.p_gap_left=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake),this.coords.p_gap_right=this.toFixed(this.coords.p_to_fake-\r\n        this.coords.p_pointer),this.$cache.s_to.removeClass(\"type_last\"),this.$cache.s_from.removeClass(\"type_last\")}},appendDisableMask:function(){this.$cache.cont.append('<span class=\"irs-disable-mask\"></span>');this.$cache.cont.addClass(\"irs-disabled\")},remove:function(){this.$cache.cont.remove();this.$cache.cont=null;this.$cache.line.off(\"keydown.irs_\"+this.plugin_count);this.$cache.body.off(\"touchmove.irs_\"+this.plugin_count);this.$cache.body.off(\"mousemove.irs_\"+this.plugin_count);this.$cache.win.off(\"touchend.irs_\"+\r\n        this.plugin_count);this.$cache.win.off(\"mouseup.irs_\"+this.plugin_count);m&&(this.$cache.body.off(\"mouseup.irs_\"+this.plugin_count),this.$cache.body.off(\"mouseleave.irs_\"+this.plugin_count));this.$cache.grid_labels=[];this.coords.big=[];this.coords.big_w=[];this.coords.big_p=[];this.coords.big_x=[];cancelAnimationFrame(this.raf_id)},bindEvents:function(){if(!this.no_diapason){this.$cache.body.on(\"touchmove.irs_\"+this.plugin_count,this.pointerMove.bind(this));this.$cache.body.on(\"mousemove.irs_\"+this.plugin_count,\r\n        this.pointerMove.bind(this));this.$cache.win.on(\"touchend.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.win.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.line.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.$cache.line.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.options.drag_interval&&\"double\"===this.options.type?(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\r\n        \"both\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"both\"))):(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));\"single\"===this.options.type?(this.$cache.single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),\r\n        this.$cache.shad_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.edge.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"))):(this.$cache.single.on(\"touchstart.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),\r\n        this.$cache.shad_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"mousedown.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.shad_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));if(this.options.keyboard)this.$cache.line.on(\"keydown.irs_\"+this.plugin_count,this.key.bind(this,\"keyboard\"));m&&(this.$cache.body.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this)),this.$cache.body.on(\"mouseleave.irs_\"+this.plugin_count,this.pointerUp.bind(this)))}},\r\n    pointerMove:function(a){this.dragging&&(this.coords.x_pointer=(a.pageX||a.originalEvent.touches&&a.originalEvent.touches[0].pageX)-this.coords.x_gap,this.calc())},pointerUp:function(a){this.current_plugin===this.plugin_count&&this.is_active&&(this.is_active=!1,this.$cache.cont.find(\".state_hover\").removeClass(\"state_hover\"),this.force_redraw=!0,m&&f(\"*\").prop(\"unselectable\",!1),this.updateScene(),this.restoreOriginalMinInterval(),(f.contains(this.$cache.cont[0],a.target)||this.dragging)&&this.callOnFinish(),\r\n        this.dragging=!1)},pointerDown:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(\"both\"===a&&this.setTempMinInterval(),a||(a=this.target||\"from\"),this.current_plugin=this.plugin_count,this.target=a,this.dragging=this.is_active=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=d-this.coords.x_gap,this.calcPointerPercent(),this.changeLevel(a),m&&f(\"*\").prop(\"unselectable\",!0),this.$cache.line.trigger(\"focus\"),\r\n        this.updateScene())},pointerClick:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(this.current_plugin=this.plugin_count,this.target=a,this.is_click=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=+(d-this.coords.x_gap).toFixed(),this.force_redraw=!0,this.calc(),this.$cache.line.trigger(\"focus\"))},key:function(a,b){if(!(this.current_plugin!==this.plugin_count||b.altKey||b.ctrlKey||b.shiftKey||b.metaKey)){switch(b.which){case 83:case 65:case 40:case 37:b.preventDefault();\r\n        this.moveByKey(!1);break;case 87:case 68:case 38:case 39:b.preventDefault(),this.moveByKey(!0)}return!0}},moveByKey:function(a){var b=this.coords.p_pointer,b=a?b+this.options.keyboard_step:b-this.options.keyboard_step;this.coords.x_pointer=this.toFixed(this.coords.w_rs/100*b);this.is_key=!0;this.calc()},setMinMax:function(){this.options&&(this.options.hide_min_max?(this.$cache.min[0].style.display=\"none\",this.$cache.max[0].style.display=\"none\"):(this.options.values.length?(this.$cache.min.html(this.decorate(this.options.p_values[this.options.min])),\r\n        this.$cache.max.html(this.decorate(this.options.p_values[this.options.max]))):(this.$cache.min.html(this.decorate(this._prettify(this.options.min),this.options.min)),this.$cache.max.html(this.decorate(this._prettify(this.options.max),this.options.max))),this.labels.w_min=this.$cache.min.outerWidth(!1),this.labels.w_max=this.$cache.max.outerWidth(!1)))},setTempMinInterval:function(){var a=this.result.to-this.result.from;null===this.old_min_interval&&(this.old_min_interval=this.options.min_interval);\r\n        this.options.min_interval=a},restoreOriginalMinInterval:function(){null!==this.old_min_interval&&(this.options.min_interval=this.old_min_interval,this.old_min_interval=null)},calc:function(a){if(this.options){this.calc_count++;if(10===this.calc_count||a)this.calc_count=0,this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.calcHandlePercent();if(this.coords.w_rs){this.calcPointerPercent();a=this.getHandleX();\"both\"===this.target&&(this.coords.p_gap=0,a=this.getHandleX());\"click\"===this.target&&(this.coords.p_gap=\r\n        this.coords.p_handle/2,a=this.getHandleX(),this.target=this.options.drag_interval?\"both_one\":this.chooseHandle(a));switch(this.target){case \"base\":var b=(this.options.max-this.options.min)/100;a=(this.result.from-this.options.min)/b;b=(this.result.to-this.options.min)/b;this.coords.p_single_real=this.toFixed(a);this.coords.p_from_real=this.toFixed(a);this.coords.p_to_real=this.toFixed(b);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);\r\n        this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);this.target=null;break;case \"single\":if(this.options.from_fixed)break;\r\n        this.coords.p_single_real=this.convertToRealPercent(a);this.coords.p_single_real=this.calcWithStep(this.coords.p_single_real);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);break;case \"from\":if(this.options.from_fixed)break;this.coords.p_from_real=this.convertToRealPercent(a);this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real>\r\n    this.coords.p_to_real&&(this.coords.p_from_real=this.coords.p_to_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_real=this.checkMaxInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);break;case \"to\":if(this.options.to_fixed)break;\r\n        this.coords.p_to_real=this.convertToRealPercent(a);this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real<this.coords.p_from_real&&(this.coords.p_to_real=this.coords.p_from_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_real=this.checkMaxInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");\r\n        this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);break;case \"both\":if(this.options.from_fixed||this.options.to_fixed)break;a=this.toFixed(a+.001*this.coords.p_handle);this.coords.p_from_real=this.convertToRealPercent(a)-this.coords.p_gap_left;this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,\r\n        this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.convertToRealPercent(a)+this.coords.p_gap_right;this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);\r\n        break;case \"both_one\":if(!this.options.from_fixed&&!this.options.to_fixed){var d=this.convertToRealPercent(a);a=this.result.to_percent-this.result.from_percent;var c=a/2,b=d-c,d=d+c;0>b&&(b=0,d=b+a);100<d&&(d=100,b=d-a);this.coords.p_from_real=this.calcWithStep(b);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.calcWithStep(d);this.coords.p_to_real=\r\n        this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real)}}\"single\"===this.options.type?(this.coords.p_bar_x=this.coords.p_handle/2,this.coords.p_bar_w=this.coords.p_single_fake,this.result.from_percent=this.coords.p_single_real,this.result.from=this.convertToValue(this.coords.p_single_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from])):(this.coords.p_bar_x=\r\n        this.toFixed(this.coords.p_from_fake+this.coords.p_handle/2),this.coords.p_bar_w=this.toFixed(this.coords.p_to_fake-this.coords.p_from_fake),this.result.from_percent=this.coords.p_from_real,this.result.from=this.convertToValue(this.coords.p_from_real),this.result.to_percent=this.coords.p_to_real,this.result.to=this.convertToValue(this.coords.p_to_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from],this.result.to_value=this.options.values[this.result.to]));\r\n        this.calcMinMax();this.calcLabels()}}},calcPointerPercent:function(){this.coords.w_rs?(0>this.coords.x_pointer||isNaN(this.coords.x_pointer)?this.coords.x_pointer=0:this.coords.x_pointer>this.coords.w_rs&&(this.coords.x_pointer=this.coords.w_rs),this.coords.p_pointer=this.toFixed(this.coords.x_pointer/this.coords.w_rs*100)):this.coords.p_pointer=0},convertToRealPercent:function(a){return a/(100-this.coords.p_handle)*100},convertToFakePercent:function(a){return a/100*(100-this.coords.p_handle)},getHandleX:function(){var a=\r\n        100-this.coords.p_handle,b=this.toFixed(this.coords.p_pointer-this.coords.p_gap);0>b?b=0:b>a&&(b=a);return b},calcHandlePercent:function(){this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1);this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100)},chooseHandle:function(a){return\"single\"===this.options.type?\"single\":a>=this.coords.p_from_real+(this.coords.p_to_real-this.coords.p_from_real)/2?this.options.to_fixed?\r\n        \"from\":\"to\":this.options.from_fixed?\"to\":\"from\"},calcMinMax:function(){this.coords.w_rs&&(this.labels.p_min=this.labels.w_min/this.coords.w_rs*100,this.labels.p_max=this.labels.w_max/this.coords.w_rs*100)},calcLabels:function(){this.coords.w_rs&&!this.options.hide_from_to&&(\"single\"===this.options.type?(this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=this.coords.p_single_fake+this.coords.p_handle/\r\n        2-this.labels.p_single_fake/2):(this.labels.w_from=this.$cache.from.outerWidth(!1),this.labels.p_from_fake=this.labels.w_from/this.coords.w_rs*100,this.labels.p_from_left=this.coords.p_from_fake+this.coords.p_handle/2-this.labels.p_from_fake/2,this.labels.p_from_left=this.toFixed(this.labels.p_from_left),this.labels.p_from_left=this.checkEdges(this.labels.p_from_left,this.labels.p_from_fake),this.labels.w_to=this.$cache.to.outerWidth(!1),this.labels.p_to_fake=this.labels.w_to/this.coords.w_rs*100,\r\n        this.labels.p_to_left=this.coords.p_to_fake+this.coords.p_handle/2-this.labels.p_to_fake/2,this.labels.p_to_left=this.toFixed(this.labels.p_to_left),this.labels.p_to_left=this.checkEdges(this.labels.p_to_left,this.labels.p_to_fake),this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=(this.labels.p_from_left+this.labels.p_to_left+this.labels.p_to_fake)/2-this.labels.p_single_fake/2,this.labels.p_single_left=\r\n        this.toFixed(this.labels.p_single_left)),this.labels.p_single_left=this.checkEdges(this.labels.p_single_left,this.labels.p_single_fake))},updateScene:function(){this.raf_id&&(cancelAnimationFrame(this.raf_id),this.raf_id=null);clearTimeout(this.update_tm);this.update_tm=null;this.options&&(this.drawHandles(),this.is_active?this.raf_id=requestAnimationFrame(this.updateScene.bind(this)):this.update_tm=setTimeout(this.updateScene.bind(this),300))},drawHandles:function(){this.coords.w_rs=this.$cache.rs.outerWidth(!1);\r\n        if(this.coords.w_rs){this.coords.w_rs!==this.coords.w_rs_old&&(this.target=\"base\",this.is_resize=!0);if(this.coords.w_rs!==this.coords.w_rs_old||this.force_redraw)this.setMinMax(),this.calc(!0),this.drawLabels(),this.options.grid&&(this.calcGridMargin(),this.calcGridLabels()),this.force_redraw=!0,this.coords.w_rs_old=this.coords.w_rs,this.drawShadow();if(this.coords.w_rs&&(this.dragging||this.force_redraw||this.is_key)){if(this.old_from!==this.result.from||this.old_to!==this.result.to||this.force_redraw||\r\n            this.is_key){this.drawLabels();this.$cache.bar[0].style.left=this.coords.p_bar_x+\"%\";this.$cache.bar[0].style.width=this.coords.p_bar_w+\"%\";if(\"single\"===this.options.type)this.$cache.s_single[0].style.left=this.coords.p_single_fake+\"%\";else{this.$cache.s_from[0].style.left=this.coords.p_from_fake+\"%\";this.$cache.s_to[0].style.left=this.coords.p_to_fake+\"%\";if(this.old_from!==this.result.from||this.force_redraw)this.$cache.from[0].style.left=this.labels.p_from_left+\"%\";if(this.old_to!==this.result.to||\r\n            this.force_redraw)this.$cache.to[0].style.left=this.labels.p_to_left+\"%\"}this.$cache.single[0].style.left=this.labels.p_single_left+\"%\";this.writeToInput();this.old_from===this.result.from&&this.old_to===this.result.to||this.is_start||(this.$cache.input.trigger(\"change\"),this.$cache.input.trigger(\"input\"));this.old_from=this.result.from;this.old_to=this.result.to;this.is_resize||this.is_update||this.is_start||this.is_finish||this.callOnChange();if(this.is_key||this.is_click||this.is_first_update)this.is_first_update=\r\n            this.is_click=this.is_key=!1,this.callOnFinish();this.is_finish=this.is_resize=this.is_update=!1}this.force_redraw=this.is_click=this.is_key=this.is_start=!1}}},drawLabels:function(){if(this.options){var a=this.options.values.length,b=this.options.p_values,d;if(!this.options.hide_from_to)if(\"single\"===this.options.type)a=a?this.decorate(b[this.result.from]):this.decorate(this._prettify(this.result.from),this.result.from),this.$cache.single.html(a),this.calcLabels(),this.$cache.min[0].style.visibility=\r\n        this.labels.p_single_left<this.labels.p_min+1?\"hidden\":\"visible\",this.$cache.max[0].style.visibility=this.labels.p_single_left+this.labels.p_single_fake>100-this.labels.p_max-1?\"hidden\":\"visible\";else{a?(this.options.decorate_both?(a=this.decorate(b[this.result.from]),a+=this.options.values_separator,a+=this.decorate(b[this.result.to])):a=this.decorate(b[this.result.from]+this.options.values_separator+b[this.result.to]),d=this.decorate(b[this.result.from]),b=this.decorate(b[this.result.to])):(this.options.decorate_both?\r\n        (a=this.decorate(this._prettify(this.result.from),this.result.from),a+=this.options.values_separator,a+=this.decorate(this._prettify(this.result.to),this.result.to)):a=this.decorate(this._prettify(this.result.from)+this.options.values_separator+this._prettify(this.result.to),this.result.to),d=this.decorate(this._prettify(this.result.from),this.result.from),b=this.decorate(this._prettify(this.result.to),this.result.to));this.$cache.single.html(a);this.$cache.from.html(d);this.$cache.to.html(b);this.calcLabels();\r\n        b=Math.min(this.labels.p_single_left,this.labels.p_from_left);a=this.labels.p_single_left+this.labels.p_single_fake;d=this.labels.p_to_left+this.labels.p_to_fake;var c=Math.max(a,d);this.labels.p_from_left+this.labels.p_from_fake>=this.labels.p_to_left?(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",this.result.from===this.result.to?(\"from\"===this.target?this.$cache.from[0].style.visibility=\"visible\":\"to\"===\r\n        this.target?this.$cache.to[0].style.visibility=\"visible\":this.target||(this.$cache.from[0].style.visibility=\"visible\"),this.$cache.single[0].style.visibility=\"hidden\",c=d):(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",c=Math.max(a,d))):(this.$cache.from[0].style.visibility=\"visible\",this.$cache.to[0].style.visibility=\"visible\",this.$cache.single[0].style.visibility=\"hidden\");this.$cache.min[0].style.visibility=\r\n            b<this.labels.p_min+1?\"hidden\":\"visible\";this.$cache.max[0].style.visibility=c>100-this.labels.p_max-1?\"hidden\":\"visible\"}}},drawShadow:function(){var a=this.options,b=this.$cache,d=\"number\"===typeof a.from_min&&!isNaN(a.from_min),c=\"number\"===typeof a.from_max&&!isNaN(a.from_max),e=\"number\"===typeof a.to_min&&!isNaN(a.to_min),g=\"number\"===typeof a.to_max&&!isNaN(a.to_max);\"single\"===a.type?a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-\r\n        d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_single[0].style.display=\"block\",b.shad_single[0].style.left=d+\"%\",b.shad_single[0].style.width=c+\"%\"):b.shad_single[0].style.display=\"none\":(a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_from[0].style.display=\r\n        \"block\",b.shad_from[0].style.left=d+\"%\",b.shad_from[0].style.width=c+\"%\"):b.shad_from[0].style.display=\"none\",a.to_shadow&&(e||g)?(e=this.convertToPercent(e?a.to_min:a.min),a=this.convertToPercent(g?a.to_max:a.max)-e,e=this.toFixed(e-this.coords.p_handle/100*e),a=this.toFixed(a-this.coords.p_handle/100*a),e+=this.coords.p_handle/2,b.shad_to[0].style.display=\"block\",b.shad_to[0].style.left=e+\"%\",b.shad_to[0].style.width=a+\"%\"):b.shad_to[0].style.display=\"none\")},writeToInput:function(){\"single\"===\r\n    this.options.type?(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value):this.$cache.input.prop(\"value\",this.result.from),this.$cache.input.data(\"from\",this.result.from)):(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value+this.options.input_values_separator+this.result.to_value):this.$cache.input.prop(\"value\",this.result.from+this.options.input_values_separator+this.result.to),this.$cache.input.data(\"from\",this.result.from),this.$cache.input.data(\"to\",\r\n        this.result.to))},callOnStart:function(){this.writeToInput();if(this.options.onStart&&\"function\"===typeof this.options.onStart)this.options.onStart(this.result)},callOnChange:function(){this.writeToInput();if(this.options.onChange&&\"function\"===typeof this.options.onChange)this.options.onChange(this.result)},callOnFinish:function(){this.writeToInput();if(this.options.onFinish&&\"function\"===typeof this.options.onFinish)this.options.onFinish(this.result)},callOnUpdate:function(){this.writeToInput();\r\n        if(this.options.onUpdate&&\"function\"===typeof this.options.onUpdate)this.options.onUpdate(this.result)},toggleInput:function(){this.$cache.input.toggleClass(\"irs-hidden-input\")},convertToPercent:function(a,b){var d=this.options.max-this.options.min;return d?this.toFixed((b?a:a-this.options.min)/(d/100)):(this.no_diapason=!0,0)},convertToValue:function(a){var b=this.options.min,d=this.options.max,c=b.toString().split(\".\")[1],e=d.toString().split(\".\")[1],g,l,f=0,k=0;if(0===a)return this.options.min;\r\n        if(100===a)return this.options.max;c&&(f=g=c.length);e&&(f=l=e.length);g&&l&&(f=g>=l?g:l);0>b&&(k=Math.abs(b),b=+(b+k).toFixed(f),d=+(d+k).toFixed(f));a=(d-b)/100*a+b;(b=this.options.step.toString().split(\".\")[1])?a=+a.toFixed(b.length):(a/=this.options.step,a*=this.options.step,a=+a.toFixed(0));k&&(a-=k);k=b?+a.toFixed(b.length):this.toFixed(a);k<this.options.min?k=this.options.min:k>this.options.max&&(k=this.options.max);return k},calcWithStep:function(a){var b=Math.round(a/this.coords.p_step)*\r\n        this.coords.p_step;100<b&&(b=100);100===a&&(b=100);return this.toFixed(b)},checkMinInterval:function(a,b,d){var c=this.options;if(!c.min_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a<c.min_interval&&(a=b-c.min_interval):a-b<c.min_interval&&(a=b+c.min_interval);return this.convertToPercent(a)},checkMaxInterval:function(a,b,d){var c=this.options;if(!c.max_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a>c.max_interval&&(a=b-c.max_interval):\r\n        a-b>c.max_interval&&(a=b+c.max_interval);return this.convertToPercent(a)},checkDiapason:function(a,b,d){a=this.convertToValue(a);var c=this.options;\"number\"!==typeof b&&(b=c.min);\"number\"!==typeof d&&(d=c.max);a<b&&(a=b);a>d&&(a=d);return this.convertToPercent(a)},toFixed:function(a){a=a.toFixed(20);return+a},_prettify:function(a){return this.options.prettify_enabled?this.options.prettify&&\"function\"===typeof this.options.prettify?this.options.prettify(a):this.prettify(a):a},prettify:function(a){return a.toString().replace(/(\\d{1,3}(?=(?:\\d\\d\\d)+(?!\\d)))/g,\r\n        \"$1\"+this.options.prettify_separator)},checkEdges:function(a,b){if(!this.options.force_edges)return this.toFixed(a);0>a?a=0:a>100-b&&(a=100-b);return this.toFixed(a)},validate:function(){var a=this.options,b=this.result,d=a.values,c=d.length,e,g;\"string\"===typeof a.min&&(a.min=+a.min);\"string\"===typeof a.max&&(a.max=+a.max);\"string\"===typeof a.from&&(a.from=+a.from);\"string\"===typeof a.to&&(a.to=+a.to);\"string\"===typeof a.step&&(a.step=+a.step);\"string\"===typeof a.from_min&&(a.from_min=+a.from_min);\r\n        \"string\"===typeof a.from_max&&(a.from_max=+a.from_max);\"string\"===typeof a.to_min&&(a.to_min=+a.to_min);\"string\"===typeof a.to_max&&(a.to_max=+a.to_max);\"string\"===typeof a.keyboard_step&&(a.keyboard_step=+a.keyboard_step);\"string\"===typeof a.grid_num&&(a.grid_num=+a.grid_num);a.max<a.min&&(a.max=a.min);if(c)for(a.p_values=[],a.min=0,a.max=c-1,a.step=1,a.grid_num=a.max,a.grid_snap=!0,g=0;g<c;g++)e=+d[g],isNaN(e)?e=d[g]:(d[g]=e,e=this._prettify(e)),a.p_values.push(e);if(\"number\"!==typeof a.from||isNaN(a.from))a.from=\r\n            a.min;if(\"number\"!==typeof a.to||isNaN(a.to))a.to=a.max;\"single\"===a.type?(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max)):(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max),a.to<a.min&&(a.to=a.min),a.to>a.max&&(a.to=a.max),this.update_check.from&&(this.update_check.from!==a.from&&a.from>a.to&&(a.from=a.to),this.update_check.to!==a.to&&a.to<a.from&&(a.to=a.from)),a.from>a.to&&(a.from=a.to),a.to<a.from&&(a.to=a.from));if(\"number\"!==typeof a.step||isNaN(a.step)||!a.step||0>a.step)a.step=\r\n            1;if(\"number\"!==typeof a.keyboard_step||isNaN(a.keyboard_step)||!a.keyboard_step||0>a.keyboard_step)a.keyboard_step=5;\"number\"===typeof a.from_min&&a.from<a.from_min&&(a.from=a.from_min);\"number\"===typeof a.from_max&&a.from>a.from_max&&(a.from=a.from_max);\"number\"===typeof a.to_min&&a.to<a.to_min&&(a.to=a.to_min);\"number\"===typeof a.to_max&&a.from>a.to_max&&(a.to=a.to_max);if(b){b.min!==a.min&&(b.min=a.min);b.max!==a.max&&(b.max=a.max);if(b.from<b.min||b.from>b.max)b.from=a.from;if(b.to<b.min||b.to>\r\n            b.max)b.to=a.to}if(\"number\"!==typeof a.min_interval||isNaN(a.min_interval)||!a.min_interval||0>a.min_interval)a.min_interval=0;if(\"number\"!==typeof a.max_interval||isNaN(a.max_interval)||!a.max_interval||0>a.max_interval)a.max_interval=0;a.min_interval&&a.min_interval>a.max-a.min&&(a.min_interval=a.max-a.min);a.max_interval&&a.max_interval>a.max-a.min&&(a.max_interval=a.max-a.min)},decorate:function(a,b){var d=\"\",c=this.options;c.prefix&&(d+=c.prefix);d+=a;c.max_postfix&&(c.values.length&&a===c.p_values[c.max]?\r\n        (d+=c.max_postfix,c.postfix&&(d+=\" \")):b===c.max&&(d+=c.max_postfix,c.postfix&&(d+=\" \")));c.postfix&&(d+=c.postfix);return d},updateFrom:function(){this.result.from=this.options.from;this.result.from_percent=this.convertToPercent(this.result.from);this.options.values&&(this.result.from_value=this.options.values[this.result.from])},updateTo:function(){this.result.to=this.options.to;this.result.to_percent=this.convertToPercent(this.result.to);this.options.values&&(this.result.to_value=this.options.values[this.result.to])},\r\n    updateResult:function(){this.result.min=this.options.min;this.result.max=this.options.max;this.updateFrom();this.updateTo()},appendGrid:function(){if(this.options.grid){var a=this.options,b,d;b=a.max-a.min;var c=a.grid_num,e,g,f=4,h,k,m,n=\"\";this.calcGridMargin();a.grid_snap?(c=b/a.step,e=this.toFixed(a.step/(b/100))):e=this.toFixed(100/c);4<c&&(f=3);7<c&&(f=2);14<c&&(f=1);28<c&&(f=0);for(b=0;b<c+1;b++){h=f;g=this.toFixed(e*b);100<g&&(g=100,h-=2,0>h&&(h=0));this.coords.big[b]=g;k=(g-e*(b-1))/(h+1);\r\n        for(d=1;d<=h&&0!==g;d++)m=this.toFixed(g-k*d),n+='<span class=\"irs-grid-pol small\" style=\"left: '+m+'%\"></span>';n+='<span class=\"irs-grid-pol\" style=\"left: '+g+'%\"></span>';d=this.convertToValue(g);d=a.values.length?a.p_values[d]:this._prettify(d);n+='<span class=\"irs-grid-text js-grid-text-'+b+'\" style=\"left: '+g+'%\">'+d+\"</span>\"}this.coords.big_num=Math.ceil(c+1);this.$cache.cont.addClass(\"irs-with-grid\");this.$cache.grid.html(n);this.cacheGridLabels()}},cacheGridLabels:function(){var a,b,d=this.coords.big_num;\r\n        for(b=0;b<d;b++)a=this.$cache.grid.find(\".js-grid-text-\"+b),this.$cache.grid_labels.push(a);this.calcGridLabels()},calcGridLabels:function(){var a,b;b=[];var d=[],c=this.coords.big_num;for(a=0;a<c;a++)this.coords.big_w[a]=this.$cache.grid_labels[a].outerWidth(!1),this.coords.big_p[a]=this.toFixed(this.coords.big_w[a]/this.coords.w_rs*100),this.coords.big_x[a]=this.toFixed(this.coords.big_p[a]/2),b[a]=this.toFixed(this.coords.big[a]-this.coords.big_x[a]),d[a]=this.toFixed(b[a]+this.coords.big_p[a]);\r\n        this.options.force_edges&&(b[0]<-this.coords.grid_gap&&(b[0]=-this.coords.grid_gap,d[0]=this.toFixed(b[0]+this.coords.big_p[0]),this.coords.big_x[0]=this.coords.grid_gap),d[c-1]>100+this.coords.grid_gap&&(d[c-1]=100+this.coords.grid_gap,b[c-1]=this.toFixed(d[c-1]-this.coords.big_p[c-1]),this.coords.big_x[c-1]=this.toFixed(this.coords.big_p[c-1]-this.coords.grid_gap)));this.calcGridCollision(2,b,d);this.calcGridCollision(4,b,d);for(a=0;a<c;a++)b=this.$cache.grid_labels[a][0],this.coords.big_x[a]!==\r\n        Number.POSITIVE_INFINITY&&(b.style.marginLeft=-this.coords.big_x[a]+\"%\")},calcGridCollision:function(a,b,d){var c,e,g,f=this.coords.big_num;for(c=0;c<f;c+=a){e=c+a/2;if(e>=f)break;g=this.$cache.grid_labels[e][0];g.style.visibility=d[c]<=b[e]?\"visible\":\"hidden\"}},calcGridMargin:function(){this.options.grid_margin&&(this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.coords.w_rs&&(this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1),\r\n        this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100),this.coords.grid_gap=this.toFixed(this.coords.p_handle/2-.1),this.$cache.grid[0].style.width=this.toFixed(100-this.coords.p_handle)+\"%\",this.$cache.grid[0].style.left=this.coords.grid_gap+\"%\"))},update:function(a){this.input&&(this.is_update=!0,this.options.from=this.result.from,this.options.to=this.result.to,this.update_check.from=this.result.from,this.update_check.to=this.result.to,this.options=f.extend(this.options,a),\r\n        this.validate(),this.updateResult(a),this.toggleInput(),this.remove(),this.init(!0))},reset:function(){this.input&&(this.updateResult(),this.update())},destroy:function(){this.input&&(this.toggleInput(),this.$cache.input.prop(\"readonly\",!1),f.data(this.input,\"ionRangeSlider\",null),this.remove(),this.options=this.input=null)}};f.fn.ionRangeSlider=function(a){return this.each(function(){f.data(this,\"ionRangeSlider\")||f.data(this,\"ionRangeSlider\",new r(this,a,u++))})};(function(){for(var a=0,b=[\"ms\",\r\n    \"moz\",\"webkit\",\"o\"],d=0;d<b.length&&!h.requestAnimationFrame;++d)h.requestAnimationFrame=h[b[d]+\"RequestAnimationFrame\"],h.cancelAnimationFrame=h[b[d]+\"CancelAnimationFrame\"]||h[b[d]+\"CancelRequestAnimationFrame\"];h.requestAnimationFrame||(h.requestAnimationFrame=function(b,d){var c=(new Date).getTime(),e=Math.max(0,16-(c-a)),f=h.setTimeout(function(){b(c+e)},e);a=c+e;return f});h.cancelAnimationFrame||(h.cancelAnimationFrame=function(a){clearTimeout(a)})})()});\r\n","Mageplaza_Core/js/jquery.magnific-popup.min.js":"// Magnific Popup v1.1.0 by Dmitry Semenov\r\n// http://bit.ly/magnific-popup#build=inline+image+ajax+iframe+gallery+retina+imagezoom\r\n(function(a){typeof define==\"function\"&&define.amd?define([\"jquery\"],a):typeof exports==\"object\"?a(require(\"jquery\")):a(window.jQuery||window.Zepto)})(function(a){var b=\"Close\",c=\"BeforeClose\",d=\"AfterClose\",e=\"BeforeAppend\",f=\"MarkupParse\",g=\"Open\",h=\"Change\",i=\"mfp\",j=\".\"+i,k=\"mfp-ready\",l=\"mfp-removing\",m=\"mfp-prevent-close\",n,o=function(){},p=!!window.jQuery,q,r=a(window),s,t,u,v,w=function(a,b){n.ev.on(i+a+j,b)},x=function(b,c,d,e){var f=document.createElement(\"div\");return f.className=\"mfp-\"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(b,c){n.ev.triggerHandler(i+b,c),n.st.callbacks&&(b=b.charAt(0).toLowerCase()+b.slice(1),n.st.callbacks[b]&&n.st.callbacks[b].apply(n,a.isArray(c)?c:[c]))},z=function(b){if(b!==v||!n.currTemplate.closeBtn)n.currTemplate.closeBtn=a(n.st.closeMarkup.replace(\"%title%\",n.st.tClose)),v=b;return n.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(n=new o,n.init(),a.magnificPopup.instance=n)},B=function(){var a=document.createElement(\"p\").style,b=[\"ms\",\"O\",\"Moz\",\"Webkit\"];if(a.transition!==undefined)return!0;while(b.length)if(b.pop()+\"Transition\"in a)return!0;return!1};o.prototype={constructor:o,init:function(){var b=navigator.appVersion;n.isLowIE=n.isIE8=document.all&&!document.addEventListener,n.isAndroid=/android/gi.test(b),n.isIOS=/iphone|ipad|ipod/gi.test(b),n.supportsTransition=B(),n.probablyMobile=n.isAndroid||n.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),s=a(document),n.popupsCache={}},open:function(b){var c;if(b.isObj===!1){n.items=b.items.toArray(),n.index=0;var d=b.items,e;for(c=0;c<d.length;c++){e=d[c],e.parsed&&(e=e.el[0]);if(e===b.el[0]){n.index=c;break}}}else n.items=a.isArray(b.items)?b.items:[b.items],n.index=b.index||0;if(n.isOpen){n.updateItemHTML();return}n.types=[],u=\"\",b.mainEl&&b.mainEl.length?n.ev=b.mainEl.eq(0):n.ev=s,b.key?(n.popupsCache[b.key]||(n.popupsCache[b.key]={}),n.currTemplate=n.popupsCache[b.key]):n.currTemplate={},n.st=a.extend(!0,{},a.magnificPopup.defaults,b),n.fixedContentPos=n.st.fixedContentPos===\"auto\"?!n.probablyMobile:n.st.fixedContentPos,n.st.modal&&(n.st.closeOnContentClick=!1,n.st.closeOnBgClick=!1,n.st.showCloseBtn=!1,n.st.enableEscapeKey=!1),n.bgOverlay||(n.bgOverlay=x(\"bg\").on(\"click\"+j,function(){n.close()}),n.wrap=x(\"wrap\").attr(\"tabindex\",-1).on(\"click\"+j,function(a){n._checkIfClose(a.target)&&n.close()}),n.container=x(\"container\",n.wrap)),n.contentContainer=x(\"content\"),n.st.preloader&&(n.preloader=x(\"preloader\",n.container,n.st.tLoading));var h=a.magnificPopup.modules;for(c=0;c<h.length;c++){var i=h[c];i=i.charAt(0).toUpperCase()+i.slice(1),n[\"init\"+i].call(n)}y(\"BeforeOpen\"),n.st.showCloseBtn&&(n.st.closeBtnInside?(w(f,function(a,b,c,d){c.close_replaceWith=z(d.type)}),u+=\" mfp-close-btn-in\"):n.wrap.append(z())),n.st.alignTop&&(u+=\" mfp-align-top\"),n.fixedContentPos?n.wrap.css({overflow:n.st.overflowY,overflowX:\"hidden\",overflowY:n.st.overflowY}):n.wrap.css({top:r.scrollTop(),position:\"absolute\"}),(n.st.fixedBgPos===!1||n.st.fixedBgPos===\"auto\"&&!n.fixedContentPos)&&n.bgOverlay.css({height:s.height(),position:\"absolute\"}),n.st.enableEscapeKey&&s.on(\"keyup\"+j,function(a){a.keyCode===27&&n.close()}),r.on(\"resize\"+j,function(){n.updateSize()}),n.st.closeOnContentClick||(u+=\" mfp-auto-cursor\"),u&&n.wrap.addClass(u);var l=n.wH=r.height(),m={};if(n.fixedContentPos&&n._hasScrollBar(l)){var o=n._getScrollbarSize();o&&(m.marginRight=o)}n.fixedContentPos&&(n.isIE7?a(\"body, html\").css(\"overflow\",\"hidden\"):m.overflow=\"hidden\");var p=n.st.mainClass;return n.isIE7&&(p+=\" mfp-ie7\"),p&&n._addClassToMFP(p),n.updateItemHTML(),y(\"BuildControls\"),a(\"html\").css(m),n.bgOverlay.add(n.wrap).prependTo(n.st.prependTo||a(document.body)),n._lastFocusedEl=document.activeElement,setTimeout(function(){n.content?(n._addClassToMFP(k),n._setFocus()):n.bgOverlay.addClass(k),s.on(\"focusin\"+j,n._onFocusIn)},16),n.isOpen=!0,n.updateSize(l),y(g),b},close:function(){if(!n.isOpen)return;y(c),n.isOpen=!1,n.st.removalDelay&&!n.isLowIE&&n.supportsTransition?(n._addClassToMFP(l),setTimeout(function(){n._close()},n.st.removalDelay)):n._close()},_close:function(){y(b);var c=l+\" \"+k+\" \";n.bgOverlay.detach(),n.wrap.detach(),n.container.empty(),n.st.mainClass&&(c+=n.st.mainClass+\" \"),n._removeClassFromMFP(c);if(n.fixedContentPos){var e={marginRight:\"\"};n.isIE7?a(\"body, html\").css(\"overflow\",\"\"):e.overflow=\"\",a(\"html\").css(e)}s.off(\"keyup\"+j+\" focusin\"+j),n.ev.off(j),n.wrap.attr(\"class\",\"mfp-wrap\").removeAttr(\"style\"),n.bgOverlay.attr(\"class\",\"mfp-bg\"),n.container.attr(\"class\",\"mfp-container\"),n.st.showCloseBtn&&(!n.st.closeBtnInside||n.currTemplate[n.currItem.type]===!0)&&n.currTemplate.closeBtn&&n.currTemplate.closeBtn.detach(),n.st.autoFocusLast&&n._lastFocusedEl&&a(n._lastFocusedEl).focus(),n.currItem=null,n.content=null,n.currTemplate=null,n.prevHeight=0,y(d)},updateSize:function(a){if(n.isIOS){var b=document.documentElement.clientWidth/window.innerWidth,c=window.innerHeight*b;n.wrap.css(\"height\",c),n.wH=c}else n.wH=a||r.height();n.fixedContentPos||n.wrap.css(\"height\",n.wH),y(\"Resize\")},updateItemHTML:function(){var b=n.items[n.index];n.contentContainer.detach(),n.content&&n.content.detach(),b.parsed||(b=n.parseEl(n.index));var c=b.type;y(\"BeforeChange\",[n.currItem?n.currItem.type:\"\",c]),n.currItem=b;if(!n.currTemplate[c]){var d=n.st[c]?n.st[c].markup:!1;y(\"FirstMarkupParse\",d),d?n.currTemplate[c]=a(d):n.currTemplate[c]=!0}t&&t!==b.type&&n.container.removeClass(\"mfp-\"+t+\"-holder\");var e=n[\"get\"+c.charAt(0).toUpperCase()+c.slice(1)](b,n.currTemplate[c]);n.appendContent(e,c),b.preloaded=!0,y(h,b),t=b.type,n.container.prepend(n.contentContainer),y(\"AfterChange\")},appendContent:function(a,b){n.content=a,a?n.st.showCloseBtn&&n.st.closeBtnInside&&n.currTemplate[b]===!0?n.content.find(\".mfp-close\").length||n.content.append(z()):n.content=a:n.content=\"\",y(e),n.container.addClass(\"mfp-\"+b+\"-holder\"),n.contentContainer.append(n.content)},parseEl:function(b){var c=n.items[b],d;c.tagName?c={el:a(c)}:(d=c.type,c={data:c,src:c.src});if(c.el){var e=n.types;for(var f=0;f<e.length;f++)if(c.el.hasClass(\"mfp-\"+e[f])){d=e[f];break}c.src=c.el.attr(\"data-mfp-src\"),c.src||(c.src=c.el.attr(\"href\"))}return c.type=d||n.st.type||\"inline\",c.index=b,c.parsed=!0,n.items[b]=c,y(\"ElementParse\",c),n.items[b]},addGroup:function(a,b){var c=function(c){c.mfpEl=this,n._openClick(c,a,b)};b||(b={});var d=\"click.magnificPopup\";b.mainEl=a,b.items?(b.isObj=!0,a.off(d).on(d,c)):(b.isObj=!1,b.delegate?a.off(d).on(d,b.delegate,c):(b.items=a,a.off(d).on(d,c)))},_openClick:function(b,c,d){var e=d.midClick!==undefined?d.midClick:a.magnificPopup.defaults.midClick;if(!e&&(b.which===2||b.ctrlKey||b.metaKey||b.altKey||b.shiftKey))return;var f=d.disableOn!==undefined?d.disableOn:a.magnificPopup.defaults.disableOn;if(f)if(a.isFunction(f)){if(!f.call(n))return!0}else if(r.width()<f)return!0;b.type&&(b.preventDefault(),n.isOpen&&b.stopPropagation()),d.el=a(b.mfpEl),d.delegate&&(d.items=c.find(d.delegate)),n.open(d)},updateStatus:function(a,b){if(n.preloader){q!==a&&n.container.removeClass(\"mfp-s-\"+q),!b&&a===\"loading\"&&(b=n.st.tLoading);var c={status:a,text:b};y(\"UpdateStatus\",c),a=c.status,b=c.text,n.preloader.html(b),n.preloader.find(\"a\").on(\"click\",function(a){a.stopImmediatePropagation()}),n.container.addClass(\"mfp-s-\"+a),q=a}},_checkIfClose:function(b){if(a(b).hasClass(m))return;var c=n.st.closeOnContentClick,d=n.st.closeOnBgClick;if(c&&d)return!0;if(!n.content||a(b).hasClass(\"mfp-close\")||n.preloader&&b===n.preloader[0])return!0;if(b!==n.content[0]&&!a.contains(n.content[0],b)){if(d&&a.contains(document,b))return!0}else if(c)return!0;return!1},_addClassToMFP:function(a){n.bgOverlay.addClass(a),n.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),n.wrap.removeClass(a)},_hasScrollBar:function(a){return(n.isIE7?s.height():document.body.scrollHeight)>(a||r.height())},_setFocus:function(){(n.st.focus?n.content.find(n.st.focus).eq(0):n.wrap).focus()},_onFocusIn:function(b){if(b.target!==n.wrap[0]&&!a.contains(n.wrap[0],b.target))return n._setFocus(),!1},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(f,[b,c,d]),a.each(c,function(c,d){if(d===undefined||d===!1)return!0;e=c.split(\"_\");if(e.length>1){var f=b.find(j+\"-\"+e[0]);if(f.length>0){var g=e[1];g===\"replaceWith\"?f[0]!==d[0]&&f.replaceWith(d):g===\"img\"?f.is(\"img\")?f.attr(\"src\",d):f.replaceWith(a(\"<img>\").attr(\"src\",d).attr(\"class\",f.attr(\"class\"))):f.attr(e[1],d)}}else b.find(j+\"-\"+c).html(d)})},_getScrollbarSize:function(){if(n.scrollbarSize===undefined){var a=document.createElement(\"div\");a.style.cssText=\"width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;\",document.body.appendChild(a),n.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return n.scrollbarSize}},a.magnificPopup={instance:null,proto:o.prototype,modules:[],open:function(b,c){return A(),b?b=a.extend(!0,{},b):b={},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:\"\",preloader:!0,focus:\"\",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:\"auto\",fixedBgPos:\"auto\",overflowY:\"auto\",closeMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-close\">&#215;</button>',tClose:\"Close (Esc)\",tLoading:\"Loading...\",autoFocusLast:!0}},a.fn.magnificPopup=function(b){A();var c=a(this);if(typeof b==\"string\")if(b===\"open\"){var d,e=p?c.data(\"magnificPopup\"):c[0].magnificPopup,f=parseInt(arguments[1],10)||0;e.items?d=e.items[f]:(d=c,e.delegate&&(d=d.find(e.delegate)),d=d.eq(f)),n._openClick({mfpEl:d},c,e)}else n.isOpen&&n[b].apply(n,Array.prototype.slice.call(arguments,1));else b=a.extend(!0,{},b),p?c.data(\"magnificPopup\",b):c[0].magnificPopup=b,n.addGroup(c,b);return c};var C=\"inline\",D,E,F,G=function(){F&&(E.after(F.addClass(D)).detach(),F=null)};a.magnificPopup.registerModule(C,{options:{hiddenClass:\"hide\",markup:\"\",tNotFound:\"Content not found\"},proto:{initInline:function(){n.types.push(C),w(b+\".\"+C,function(){G()})},getInline:function(b,c){G();if(b.src){var d=n.st.inline,e=a(b.src);if(e.length){var f=e[0].parentNode;f&&f.tagName&&(E||(D=d.hiddenClass,E=x(D),D=\"mfp-\"+D),F=e.after(E).detach().removeClass(D)),n.updateStatus(\"ready\")}else n.updateStatus(\"error\",d.tNotFound),e=a(\"<div>\");return b.inlineElement=e,e}return n.updateStatus(\"ready\"),n._parseMarkup(c,{},b),c}}});var H=\"ajax\",I,J=function(){I&&a(document.body).removeClass(I)},K=function(){J(),n.req&&n.req.abort()};a.magnificPopup.registerModule(H,{options:{settings:null,cursor:\"mfp-ajax-cur\",tError:'<a href=\"%url%\">The content</a> could not be loaded.'},proto:{initAjax:function(){n.types.push(H),I=n.st.ajax.cursor,w(b+\".\"+H,K),w(\"BeforeChange.\"+H,K)},getAjax:function(b){I&&a(document.body).addClass(I),n.updateStatus(\"loading\");var c=a.extend({url:b.src,success:function(c,d,e){var f={data:c,xhr:e};y(\"ParseAjax\",f),n.appendContent(a(f.data),H),b.finished=!0,J(),n._setFocus(),setTimeout(function(){n.wrap.addClass(k)},16),n.updateStatus(\"ready\"),y(\"AjaxContentAdded\")},error:function(){J(),b.finished=b.loadError=!0,n.updateStatus(\"error\",n.st.ajax.tError.replace(\"%url%\",b.src))}},n.st.ajax.settings);return n.req=a.ajax(c),\"\"}}});var L,M=function(b){if(b.data&&b.data.title!==undefined)return b.data.title;var c=n.st.image.titleSrc;if(c){if(a.isFunction(c))return c.call(n,b);if(b.el)return b.el.attr(c)||\"\"}return\"\"};a.magnificPopup.registerModule(\"image\",{options:{markup:'<div class=\"mfp-figure\"><div class=\"mfp-close\"></div><figure><div class=\"mfp-img\"></div><figcaption><div class=\"mfp-bottom-bar\"><div class=\"mfp-title\"></div><div class=\"mfp-counter\"></div></div></figcaption></figure></div>',cursor:\"mfp-zoom-out-cur\",titleSrc:\"title\",verticalFit:!0,tError:'<a href=\"%url%\">The image</a> could not be loaded.'},proto:{initImage:function(){var c=n.st.image,d=\".image\";n.types.push(\"image\"),w(g+d,function(){n.currItem.type===\"image\"&&c.cursor&&a(document.body).addClass(c.cursor)}),w(b+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),r.off(\"resize\"+j)}),w(\"Resize\"+d,n.resizeImage),n.isLowIE&&w(\"AfterChange\",n.resizeImage)},resizeImage:function(){var a=n.currItem;if(!a||!a.img)return;if(n.st.image.verticalFit){var b=0;n.isLowIE&&(b=parseInt(a.img.css(\"padding-top\"),10)+parseInt(a.img.css(\"padding-bottom\"),10)),a.img.css(\"max-height\",n.wH-b)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y(\"ImageHasSize\",a),a.imgHidden&&(n.content&&n.content.removeClass(\"mfp-loading\"),a.imgHidden=!1))},findImageSize:function(a){var b=0,c=a.img[0],d=function(e){L&&clearInterval(L),L=setInterval(function(){if(c.naturalWidth>0){n._onImageHasSize(a);return}b>200&&clearInterval(L),b++,b===3?d(10):b===40?d(50):b===100&&d(500)},e)};d(1)},getImage:function(b,c){var d=0,e=function(){b&&(b.img[0].complete?(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"ready\")),b.hasSize=!0,b.loaded=!0,y(\"ImageLoadComplete\")):(d++,d<200?setTimeout(e,100):f()))},f=function(){b&&(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))),b.hasSize=!0,b.loaded=!0,b.loadError=!0)},g=n.st.image,h=c.find(\".mfp-img\");if(h.length){var i=document.createElement(\"img\");i.className=\"mfp-img\",b.el&&b.el.find(\"img\").length&&(i.alt=b.el.find(\"img\").attr(\"alt\")),b.img=a(i).on(\"load.mfploader\",e).on(\"error.mfploader\",f),i.src=b.src,h.is(\"img\")&&(b.img=b.img.clone()),i=b.img[0],i.naturalWidth>0?b.hasSize=!0:i.width||(b.hasSize=!1)}return n._parseMarkup(c,{title:M(b),img_replaceWith:b.img},b),n.resizeImage(),b.hasSize?(L&&clearInterval(L),b.loadError?(c.addClass(\"mfp-loading\"),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))):(c.removeClass(\"mfp-loading\"),n.updateStatus(\"ready\")),c):(n.updateStatus(\"loading\"),b.loading=!0,b.hasSize||(b.imgHidden=!0,c.addClass(\"mfp-loading\"),n.findImageSize(b)),c)}}});var N,O=function(){return N===undefined&&(N=document.createElement(\"p\").style.MozTransform!==undefined),N};a.magnificPopup.registerModule(\"zoom\",{options:{enabled:!1,easing:\"ease-in-out\",duration:300,opener:function(a){return a.is(\"img\")?a:a.find(\"img\")}},proto:{initZoom:function(){var a=n.st.zoom,d=\".zoom\",e;if(!a.enabled||!n.supportsTransition)return;var f=a.duration,g=function(b){var c=b.clone().removeAttr(\"style\").removeAttr(\"class\").addClass(\"mfp-animated-image\"),d=\"all \"+a.duration/1e3+\"s \"+a.easing,e={position:\"fixed\",zIndex:9999,left:0,top:0,\"-webkit-backface-visibility\":\"hidden\"},f=\"transition\";return e[\"-webkit-\"+f]=e[\"-moz-\"+f]=e[\"-o-\"+f]=e[f]=d,c.css(e),c},h=function(){n.content.css(\"visibility\",\"visible\")},i,j;w(\"BuildControls\"+d,function(){if(n._allowZoom()){clearTimeout(i),n.content.css(\"visibility\",\"hidden\"),e=n._getItemToZoom();if(!e){h();return}j=g(e),j.css(n._getOffset()),n.wrap.append(j),i=setTimeout(function(){j.css(n._getOffset(!0)),i=setTimeout(function(){h(),setTimeout(function(){j.remove(),e=j=null,y(\"ZoomAnimationEnded\")},16)},f)},16)}}),w(c+d,function(){if(n._allowZoom()){clearTimeout(i),n.st.removalDelay=f;if(!e){e=n._getItemToZoom();if(!e)return;j=g(e)}j.css(n._getOffset(!0)),n.wrap.append(j),n.content.css(\"visibility\",\"hidden\"),setTimeout(function(){j.css(n._getOffset())},16)}}),w(b+d,function(){n._allowZoom()&&(h(),j&&j.remove(),e=null)})},_allowZoom:function(){return n.currItem.type===\"image\"},_getItemToZoom:function(){return n.currItem.hasSize?n.currItem.img:!1},_getOffset:function(b){var c;b?c=n.currItem.img:c=n.st.zoom.opener(n.currItem.el||n.currItem);var d=c.offset(),e=parseInt(c.css(\"padding-top\"),10),f=parseInt(c.css(\"padding-bottom\"),10);d.top-=a(window).scrollTop()-e;var g={width:c.width(),height:(p?c.innerHeight():c[0].offsetHeight)-f-e};return O()?g[\"-moz-transform\"]=g.transform=\"translate(\"+d.left+\"px,\"+d.top+\"px)\":(g.left=d.left,g.top=d.top),g}}});var P=\"iframe\",Q=\"//about:blank\",R=function(a){if(n.currTemplate[P]){var b=n.currTemplate[P].find(\"iframe\");b.length&&(a||(b[0].src=Q),n.isIE8&&b.css(\"display\",a?\"block\":\"none\"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class=\"mfp-iframe-scaler\"><div class=\"mfp-close\"></div><iframe class=\"mfp-iframe\" src=\"//about:blank\" frameborder=\"0\" allowfullscreen></iframe></div>',srcAction:\"iframe_src\",patterns:{youtube:{index:\"youtube.com\",id:\"v=\",src:\"//www.youtube.com/embed/%id%?autoplay=1\"},vimeo:{index:\"vimeo.com/\",id:\"/\",src:\"//player.vimeo.com/video/%id%?autoplay=1\"},gmaps:{index:\"//maps.google.\",src:\"%id%&output=embed\"}}},proto:{initIframe:function(){n.types.push(P),w(\"BeforeChange\",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(b+\".\"+P,function(){R()})},getIframe:function(b,c){var d=b.src,e=n.st.iframe;a.each(e.patterns,function(){if(d.indexOf(this.index)>-1)return this.id&&(typeof this.id==\"string\"?d=d.substr(d.lastIndexOf(this.id)+this.id.length,d.length):d=this.id.call(this,d)),d=this.src.replace(\"%id%\",d),!1});var f={};return e.srcAction&&(f[e.srcAction]=d),n._parseMarkup(c,f,b),n.updateStatus(\"ready\"),c}}});var S=function(a){var b=n.items.length;return a>b-1?a-b:a<0?b+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule(\"gallery\",{options:{enabled:!1,arrowMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-arrow mfp-arrow-%dir%\"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:\"Previous (Left arrow key)\",tNext:\"Next (Right arrow key)\",tCounter:\"%curr% of %total%\"},proto:{initGallery:function(){var c=n.st.gallery,d=\".mfp-gallery\";n.direction=!0;if(!c||!c.enabled)return!1;u+=\" mfp-gallery\",w(g+d,function(){c.navigateByImgClick&&n.wrap.on(\"click\"+d,\".mfp-img\",function(){if(n.items.length>1)return n.next(),!1}),s.on(\"keydown\"+d,function(a){a.keyCode===37?n.prev():a.keyCode===39&&n.next()})}),w(\"UpdateStatus\"+d,function(a,b){b.text&&(b.text=T(b.text,n.currItem.index,n.items.length))}),w(f+d,function(a,b,d,e){var f=n.items.length;d.counter=f>1?T(c.tCounter,e.index,f):\"\"}),w(\"BuildControls\"+d,function(){if(n.items.length>1&&c.arrows&&!n.arrowLeft){var b=c.arrowMarkup,d=n.arrowLeft=a(b.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,\"left\")).addClass(m),e=n.arrowRight=a(b.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,\"right\")).addClass(m);d.click(function(){n.prev()}),e.click(function(){n.next()}),n.container.append(d.add(e))}}),w(h+d,function(){n._preloadTimeout&&clearTimeout(n._preloadTimeout),n._preloadTimeout=setTimeout(function(){n.preloadNearbyImages(),n._preloadTimeout=null},16)}),w(b+d,function(){s.off(d),n.wrap.off(\"click\"+d),n.arrowRight=n.arrowLeft=null})},next:function(){n.direction=!0,n.index=S(n.index+1),n.updateItemHTML()},prev:function(){n.direction=!1,n.index=S(n.index-1),n.updateItemHTML()},goTo:function(a){n.direction=a>=n.index,n.index=a,n.updateItemHTML()},preloadNearbyImages:function(){var a=n.st.gallery.preload,b=Math.min(a[0],n.items.length),c=Math.min(a[1],n.items.length),d;for(d=1;d<=(n.direction?c:b);d++)n._preloadItem(n.index+d);for(d=1;d<=(n.direction?b:c);d++)n._preloadItem(n.index-d)},_preloadItem:function(b){b=S(b);if(n.items[b].preloaded)return;var c=n.items[b];c.parsed||(c=n.parseEl(b)),y(\"LazyLoad\",c),c.type===\"image\"&&(c.img=a('<img class=\"mfp-img\" />').on(\"load.mfploader\",function(){c.hasSize=!0}).on(\"error.mfploader\",function(){c.hasSize=!0,c.loadError=!0,y(\"LazyLoadError\",c)}).attr(\"src\",c.src)),c.preloaded=!0}}});var U=\"retina\";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\\.\\w+$/,function(a){return\"@2x\"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=n.st.retina,b=a.ratio;b=isNaN(b)?b():b,b>1&&(w(\"ImageHasSize.\"+U,function(a,c){c.img.css({\"max-width\":c.img[0].naturalWidth/b,width:\"100%\"})}),w(\"ElementParse.\"+U,function(c,d){d.src=a.replaceSrc(d,b)}))}}}}),A()})","Mageplaza_Core/js/bootstrap.min.js":"/*!\n * Bootstrap v5.0.2 (https://getbootstrap.com/)\n * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n */\n!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e(require(\"@popperjs/core\")):\"function\"==typeof define&&define.amd?define([\"@popperjs/core\"],e):(t=\"undefined\"!=typeof globalThis?globalThis:t||self).bootstrap=e(t.Popper)}(this,(function(t){\"use strict\";function e(t){if(t&&t.__esModule)return t;var e=Object.create(null);return t&&Object.keys(t).forEach((function(s){if(\"default\"!==s){var i=Object.getOwnPropertyDescriptor(t,s);Object.defineProperty(e,s,i.get?i:{enumerable:!0,get:function(){return t[s]}})}})),e.default=t,Object.freeze(e)}var s=e(t);const i={find:(t,e=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(e,t)),findOne:(t,e=document.documentElement)=>Element.prototype.querySelector.call(e,t),children:(t,e)=>[].concat(...t.children).filter(t=>t.matches(e)),parents(t,e){const s=[];let i=t.parentNode;for(;i&&i.nodeType===Node.ELEMENT_NODE&&3!==i.nodeType;)i.matches(e)&&s.push(i),i=i.parentNode;return s},prev(t,e){let s=t.previousElementSibling;for(;s;){if(s.matches(e))return[s];s=s.previousElementSibling}return[]},next(t,e){let s=t.nextElementSibling;for(;s;){if(s.matches(e))return[s];s=s.nextElementSibling}return[]}},n=t=>{do{t+=Math.floor(1e6*Math.random())}while(document.getElementById(t));return t},o=t=>{let e=t.getAttribute(\"data-bs-target\");if(!e||\"#\"===e){let s=t.getAttribute(\"href\");if(!s||!s.includes(\"#\")&&!s.startsWith(\".\"))return null;s.includes(\"#\")&&!s.startsWith(\"#\")&&(s=\"#\"+s.split(\"#\")[1]),e=s&&\"#\"!==s?s.trim():null}return e},r=t=>{const e=o(t);return e&&document.querySelector(e)?e:null},a=t=>{const e=o(t);return e?document.querySelector(e):null},l=t=>{t.dispatchEvent(new Event(\"transitionend\"))},c=t=>!(!t||\"object\"!=typeof t)&&(void 0!==t.jquery&&(t=t[0]),void 0!==t.nodeType),h=t=>c(t)?t.jquery?t[0]:t:\"string\"==typeof t&&t.length>0?i.findOne(t):null,d=(t,e,s)=>{Object.keys(s).forEach(i=>{const n=s[i],o=e[i],r=o&&c(o)?\"element\":null==(a=o)?\"\"+a:{}.toString.call(a).match(/\\s([a-z]+)/i)[1].toLowerCase();var a;if(!new RegExp(n).test(r))throw new TypeError(`${t.toUpperCase()}: Option \"${i}\" provided type \"${r}\" but expected type \"${n}\".`)})},u=t=>!(!c(t)||0===t.getClientRects().length)&&\"visible\"===getComputedStyle(t).getPropertyValue(\"visibility\"),g=t=>!t||t.nodeType!==Node.ELEMENT_NODE||!!t.classList.contains(\"disabled\")||(void 0!==t.disabled?t.disabled:t.hasAttribute(\"disabled\")&&\"false\"!==t.getAttribute(\"disabled\")),p=t=>{if(!document.documentElement.attachShadow)return null;if(\"function\"==typeof t.getRootNode){const e=t.getRootNode();return e instanceof ShadowRoot?e:null}return t instanceof ShadowRoot?t:t.parentNode?p(t.parentNode):null},f=()=>{},m=t=>t.offsetHeight,_=()=>{const{jQuery:t}=window;return t&&!document.body.hasAttribute(\"data-bs-no-jquery\")?t:null},b=[],v=()=>\"rtl\"===document.documentElement.dir,y=t=>{var e;e=()=>{const e=_();if(e){const s=t.NAME,i=e.fn[s];e.fn[s]=t.jQueryInterface,e.fn[s].Constructor=t,e.fn[s].noConflict=()=>(e.fn[s]=i,t.jQueryInterface)}},\"loading\"===document.readyState?(b.length||document.addEventListener(\"DOMContentLoaded\",()=>{b.forEach(t=>t())}),b.push(e)):e()},w=t=>{\"function\"==typeof t&&t()},E=(t,e,s=!0)=>{if(!s)return void w(t);const i=(t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),n=Number.parseFloat(s);return i||n?(e=e.split(\",\")[0],s=s.split(\",\")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0})(e)+5;let n=!1;const o=({target:s})=>{s===e&&(n=!0,e.removeEventListener(\"transitionend\",o),w(t))};e.addEventListener(\"transitionend\",o),setTimeout(()=>{n||l(e)},i)},A=(t,e,s,i)=>{let n=t.indexOf(e);if(-1===n)return t[!s&&i?t.length-1:0];const o=t.length;return n+=s?1:-1,i&&(n=(n+o)%o),t[Math.max(0,Math.min(n,o-1))]},T=/[^.]*(?=\\..*)\\.|.*/,C=/\\..*/,k=/::\\d+$/,L={};let O=1;const D={mouseenter:\"mouseover\",mouseleave:\"mouseout\"},I=/^(mouseenter|mouseleave)/i,N=new Set([\"click\",\"dblclick\",\"mouseup\",\"mousedown\",\"contextmenu\",\"mousewheel\",\"DOMMouseScroll\",\"mouseover\",\"mouseout\",\"mousemove\",\"selectstart\",\"selectend\",\"keydown\",\"keypress\",\"keyup\",\"orientationchange\",\"touchstart\",\"touchmove\",\"touchend\",\"touchcancel\",\"pointerdown\",\"pointermove\",\"pointerup\",\"pointerleave\",\"pointercancel\",\"gesturestart\",\"gesturechange\",\"gestureend\",\"focus\",\"blur\",\"change\",\"reset\",\"select\",\"submit\",\"focusin\",\"focusout\",\"load\",\"unload\",\"beforeunload\",\"resize\",\"move\",\"DOMContentLoaded\",\"readystatechange\",\"error\",\"abort\",\"scroll\"]);function S(t,e){return e&&`${e}::${O++}`||t.uidEvent||O++}function x(t){const e=S(t);return t.uidEvent=e,L[e]=L[e]||{},L[e]}function M(t,e,s=null){const i=Object.keys(t);for(let n=0,o=i.length;n<o;n++){const o=t[i[n]];if(o.originalHandler===e&&o.delegationSelector===s)return o}return null}function P(t,e,s){const i=\"string\"==typeof e,n=i?s:e;let o=R(t);return N.has(o)||(o=t),[i,n,o]}function j(t,e,s,i,n){if(\"string\"!=typeof e||!t)return;if(s||(s=i,i=null),I.test(e)){const t=t=>function(e){if(!e.relatedTarget||e.relatedTarget!==e.delegateTarget&&!e.delegateTarget.contains(e.relatedTarget))return t.call(this,e)};i?i=t(i):s=t(s)}const[o,r,a]=P(e,s,i),l=x(t),c=l[a]||(l[a]={}),h=M(c,r,o?s:null);if(h)return void(h.oneOff=h.oneOff&&n);const d=S(r,e.replace(T,\"\")),u=o?function(t,e,s){return function i(n){const o=t.querySelectorAll(e);for(let{target:r}=n;r&&r!==this;r=r.parentNode)for(let a=o.length;a--;)if(o[a]===r)return n.delegateTarget=r,i.oneOff&&B.off(t,n.type,e,s),s.apply(r,[n]);return null}}(t,s,i):function(t,e){return function s(i){return i.delegateTarget=t,s.oneOff&&B.off(t,i.type,e),e.apply(t,[i])}}(t,s);u.delegationSelector=o?s:null,u.originalHandler=r,u.oneOff=n,u.uidEvent=d,c[d]=u,t.addEventListener(a,u,o)}function H(t,e,s,i,n){const o=M(e[s],i,n);o&&(t.removeEventListener(s,o,Boolean(n)),delete e[s][o.uidEvent])}function R(t){return t=t.replace(C,\"\"),D[t]||t}const B={on(t,e,s,i){j(t,e,s,i,!1)},one(t,e,s,i){j(t,e,s,i,!0)},off(t,e,s,i){if(\"string\"!=typeof e||!t)return;const[n,o,r]=P(e,s,i),a=r!==e,l=x(t),c=e.startsWith(\".\");if(void 0!==o){if(!l||!l[r])return;return void H(t,l,r,o,n?s:null)}c&&Object.keys(l).forEach(s=>{!function(t,e,s,i){const n=e[s]||{};Object.keys(n).forEach(o=>{if(o.includes(i)){const i=n[o];H(t,e,s,i.originalHandler,i.delegationSelector)}})}(t,l,s,e.slice(1))});const h=l[r]||{};Object.keys(h).forEach(s=>{const i=s.replace(k,\"\");if(!a||e.includes(i)){const e=h[s];H(t,l,r,e.originalHandler,e.delegationSelector)}})},trigger(t,e,s){if(\"string\"!=typeof e||!t)return null;const i=_(),n=R(e),o=e!==n,r=N.has(n);let a,l=!0,c=!0,h=!1,d=null;return o&&i&&(a=i.Event(e,s),i(t).trigger(a),l=!a.isPropagationStopped(),c=!a.isImmediatePropagationStopped(),h=a.isDefaultPrevented()),r?(d=document.createEvent(\"HTMLEvents\"),d.initEvent(n,l,!0)):d=new CustomEvent(e,{bubbles:l,cancelable:!0}),void 0!==s&&Object.keys(s).forEach(t=>{Object.defineProperty(d,t,{get:()=>s[t]})}),h&&d.preventDefault(),c&&t.dispatchEvent(d),d.defaultPrevented&&void 0!==a&&a.preventDefault(),d}},$=new Map;var W={set(t,e,s){$.has(t)||$.set(t,new Map);const i=$.get(t);i.has(e)||0===i.size?i.set(e,s):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(i.keys())[0]}.`)},get:(t,e)=>$.has(t)&&$.get(t).get(e)||null,remove(t,e){if(!$.has(t))return;const s=$.get(t);s.delete(e),0===s.size&&$.delete(t)}};class q{constructor(t){(t=h(t))&&(this._element=t,W.set(this._element,this.constructor.DATA_KEY,this))}dispose(){W.remove(this._element,this.constructor.DATA_KEY),B.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach(t=>{this[t]=null})}_queueCallback(t,e,s=!0){E(t,e,s)}static getInstance(t){return W.get(t,this.DATA_KEY)}static getOrCreateInstance(t,e={}){return this.getInstance(t)||new this(t,\"object\"==typeof e?e:null)}static get VERSION(){return\"5.0.2\"}static get NAME(){throw new Error('You have to implement the static method \"NAME\", for each component!')}static get DATA_KEY(){return\"bs.\"+this.NAME}static get EVENT_KEY(){return\".\"+this.DATA_KEY}}class z extends q{static get NAME(){return\"alert\"}close(t){const e=t?this._getRootElement(t):this._element,s=this._triggerCloseEvent(e);null===s||s.defaultPrevented||this._removeElement(e)}_getRootElement(t){return a(t)||t.closest(\".alert\")}_triggerCloseEvent(t){return B.trigger(t,\"close.bs.alert\")}_removeElement(t){t.classList.remove(\"show\");const e=t.classList.contains(\"fade\");this._queueCallback(()=>this._destroyElement(t),t,e)}_destroyElement(t){t.remove(),B.trigger(t,\"closed.bs.alert\")}static jQueryInterface(t){return this.each((function(){const e=z.getOrCreateInstance(this);\"close\"===t&&e[t](this)}))}static handleDismiss(t){return function(e){e&&e.preventDefault(),t.close(this)}}}B.on(document,\"click.bs.alert.data-api\",'[data-bs-dismiss=\"alert\"]',z.handleDismiss(new z)),y(z);class F extends q{static get NAME(){return\"button\"}toggle(){this._element.setAttribute(\"aria-pressed\",this._element.classList.toggle(\"active\"))}static jQueryInterface(t){return this.each((function(){const e=F.getOrCreateInstance(this);\"toggle\"===t&&e[t]()}))}}function U(t){return\"true\"===t||\"false\"!==t&&(t===Number(t).toString()?Number(t):\"\"===t||\"null\"===t?null:t)}function K(t){return t.replace(/[A-Z]/g,t=>\"-\"+t.toLowerCase())}B.on(document,\"click.bs.button.data-api\",'[data-bs-toggle=\"button\"]',t=>{t.preventDefault();const e=t.target.closest('[data-bs-toggle=\"button\"]');F.getOrCreateInstance(e).toggle()}),y(F);const V={setDataAttribute(t,e,s){t.setAttribute(\"data-bs-\"+K(e),s)},removeDataAttribute(t,e){t.removeAttribute(\"data-bs-\"+K(e))},getDataAttributes(t){if(!t)return{};const e={};return Object.keys(t.dataset).filter(t=>t.startsWith(\"bs\")).forEach(s=>{let i=s.replace(/^bs/,\"\");i=i.charAt(0).toLowerCase()+i.slice(1,i.length),e[i]=U(t.dataset[s])}),e},getDataAttribute:(t,e)=>U(t.getAttribute(\"data-bs-\"+K(e))),offset(t){const e=t.getBoundingClientRect();return{top:e.top+document.body.scrollTop,left:e.left+document.body.scrollLeft}},position:t=>({top:t.offsetTop,left:t.offsetLeft})},Q={interval:5e3,keyboard:!0,slide:!1,pause:\"hover\",wrap:!0,touch:!0},X={interval:\"(number|boolean)\",keyboard:\"boolean\",slide:\"(boolean|string)\",pause:\"(string|boolean)\",wrap:\"boolean\",touch:\"boolean\"},Y=\"next\",G=\"prev\",Z=\"left\",J=\"right\",tt={ArrowLeft:J,ArrowRight:Z};class et extends q{constructor(t,e){super(t),this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(e),this._indicatorsElement=i.findOne(\".carousel-indicators\",this._element),this._touchSupported=\"ontouchstart\"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent),this._addEventListeners()}static get Default(){return Q}static get NAME(){return\"carousel\"}next(){this._slide(Y)}nextWhenVisible(){!document.hidden&&u(this._element)&&this.next()}prev(){this._slide(G)}pause(t){t||(this._isPaused=!0),i.findOne(\".carousel-item-next, .carousel-item-prev\",this._element)&&(l(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null}cycle(t){t||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config&&this._config.interval&&!this._isPaused&&(this._updateInterval(),this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval))}to(t){this._activeElement=i.findOne(\".active.carousel-item\",this._element);const e=this._getItemIndex(this._activeElement);if(t>this._items.length-1||t<0)return;if(this._isSliding)return void B.one(this._element,\"slid.bs.carousel\",()=>this.to(t));if(e===t)return this.pause(),void this.cycle();const s=t>e?Y:G;this._slide(s,this._items[t])}_getConfig(t){return t={...Q,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"carousel\",t,X),t}_handleSwipe(){const t=Math.abs(this.touchDeltaX);if(t<=40)return;const e=t/this.touchDeltaX;this.touchDeltaX=0,e&&this._slide(e>0?J:Z)}_addEventListeners(){this._config.keyboard&&B.on(this._element,\"keydown.bs.carousel\",t=>this._keydown(t)),\"hover\"===this._config.pause&&(B.on(this._element,\"mouseenter.bs.carousel\",t=>this.pause(t)),B.on(this._element,\"mouseleave.bs.carousel\",t=>this.cycle(t))),this._config.touch&&this._touchSupported&&this._addTouchEventListeners()}_addTouchEventListeners(){const t=t=>{!this._pointerEvent||\"pen\"!==t.pointerType&&\"touch\"!==t.pointerType?this._pointerEvent||(this.touchStartX=t.touches[0].clientX):this.touchStartX=t.clientX},e=t=>{this.touchDeltaX=t.touches&&t.touches.length>1?0:t.touches[0].clientX-this.touchStartX},s=t=>{!this._pointerEvent||\"pen\"!==t.pointerType&&\"touch\"!==t.pointerType||(this.touchDeltaX=t.clientX-this.touchStartX),this._handleSwipe(),\"hover\"===this._config.pause&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout(t=>this.cycle(t),500+this._config.interval))};i.find(\".carousel-item img\",this._element).forEach(t=>{B.on(t,\"dragstart.bs.carousel\",t=>t.preventDefault())}),this._pointerEvent?(B.on(this._element,\"pointerdown.bs.carousel\",e=>t(e)),B.on(this._element,\"pointerup.bs.carousel\",t=>s(t)),this._element.classList.add(\"pointer-event\")):(B.on(this._element,\"touchstart.bs.carousel\",e=>t(e)),B.on(this._element,\"touchmove.bs.carousel\",t=>e(t)),B.on(this._element,\"touchend.bs.carousel\",t=>s(t)))}_keydown(t){if(/input|textarea/i.test(t.target.tagName))return;const e=tt[t.key];e&&(t.preventDefault(),this._slide(e))}_getItemIndex(t){return this._items=t&&t.parentNode?i.find(\".carousel-item\",t.parentNode):[],this._items.indexOf(t)}_getItemByOrder(t,e){const s=t===Y;return A(this._items,e,s,this._config.wrap)}_triggerSlideEvent(t,e){const s=this._getItemIndex(t),n=this._getItemIndex(i.findOne(\".active.carousel-item\",this._element));return B.trigger(this._element,\"slide.bs.carousel\",{relatedTarget:t,direction:e,from:n,to:s})}_setActiveIndicatorElement(t){if(this._indicatorsElement){const e=i.findOne(\".active\",this._indicatorsElement);e.classList.remove(\"active\"),e.removeAttribute(\"aria-current\");const s=i.find(\"[data-bs-target]\",this._indicatorsElement);for(let e=0;e<s.length;e++)if(Number.parseInt(s[e].getAttribute(\"data-bs-slide-to\"),10)===this._getItemIndex(t)){s[e].classList.add(\"active\"),s[e].setAttribute(\"aria-current\",\"true\");break}}}_updateInterval(){const t=this._activeElement||i.findOne(\".active.carousel-item\",this._element);if(!t)return;const e=Number.parseInt(t.getAttribute(\"data-bs-interval\"),10);e?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=e):this._config.interval=this._config.defaultInterval||this._config.interval}_slide(t,e){const s=this._directionToOrder(t),n=i.findOne(\".active.carousel-item\",this._element),o=this._getItemIndex(n),r=e||this._getItemByOrder(s,n),a=this._getItemIndex(r),l=Boolean(this._interval),c=s===Y,h=c?\"carousel-item-start\":\"carousel-item-end\",d=c?\"carousel-item-next\":\"carousel-item-prev\",u=this._orderToDirection(s);if(r&&r.classList.contains(\"active\"))return void(this._isSliding=!1);if(this._isSliding)return;if(this._triggerSlideEvent(r,u).defaultPrevented)return;if(!n||!r)return;this._isSliding=!0,l&&this.pause(),this._setActiveIndicatorElement(r),this._activeElement=r;const g=()=>{B.trigger(this._element,\"slid.bs.carousel\",{relatedTarget:r,direction:u,from:o,to:a})};if(this._element.classList.contains(\"slide\")){r.classList.add(d),m(r),n.classList.add(h),r.classList.add(h);const t=()=>{r.classList.remove(h,d),r.classList.add(\"active\"),n.classList.remove(\"active\",d,h),this._isSliding=!1,setTimeout(g,0)};this._queueCallback(t,n,!0)}else n.classList.remove(\"active\"),r.classList.add(\"active\"),this._isSliding=!1,g();l&&this.cycle()}_directionToOrder(t){return[J,Z].includes(t)?v()?t===Z?G:Y:t===Z?Y:G:t}_orderToDirection(t){return[Y,G].includes(t)?v()?t===G?Z:J:t===G?J:Z:t}static carouselInterface(t,e){const s=et.getOrCreateInstance(t,e);let{_config:i}=s;\"object\"==typeof e&&(i={...i,...e});const n=\"string\"==typeof e?e:i.slide;if(\"number\"==typeof e)s.to(e);else if(\"string\"==typeof n){if(void 0===s[n])throw new TypeError(`No method named \"${n}\"`);s[n]()}else i.interval&&i.ride&&(s.pause(),s.cycle())}static jQueryInterface(t){return this.each((function(){et.carouselInterface(this,t)}))}static dataApiClickHandler(t){const e=a(this);if(!e||!e.classList.contains(\"carousel\"))return;const s={...V.getDataAttributes(e),...V.getDataAttributes(this)},i=this.getAttribute(\"data-bs-slide-to\");i&&(s.interval=!1),et.carouselInterface(e,s),i&&et.getInstance(e).to(i),t.preventDefault()}}B.on(document,\"click.bs.carousel.data-api\",\"[data-bs-slide], [data-bs-slide-to]\",et.dataApiClickHandler),B.on(window,\"load.bs.carousel.data-api\",()=>{const t=i.find('[data-bs-ride=\"carousel\"]');for(let e=0,s=t.length;e<s;e++)et.carouselInterface(t[e],et.getInstance(t[e]))}),y(et);const st={toggle:!0,parent:\"\"},it={toggle:\"boolean\",parent:\"(string|element)\"};class nt extends q{constructor(t,e){super(t),this._isTransitioning=!1,this._config=this._getConfig(e),this._triggerArray=i.find(`[data-bs-toggle=\"collapse\"][href=\"#${this._element.id}\"],[data-bs-toggle=\"collapse\"][data-bs-target=\"#${this._element.id}\"]`);const s=i.find('[data-bs-toggle=\"collapse\"]');for(let t=0,e=s.length;t<e;t++){const e=s[t],n=r(e),o=i.find(n).filter(t=>t===this._element);null!==n&&o.length&&(this._selector=n,this._triggerArray.push(e))}this._parent=this._config.parent?this._getParent():null,this._config.parent||this._addAriaAndCollapsedClass(this._element,this._triggerArray),this._config.toggle&&this.toggle()}static get Default(){return st}static get NAME(){return\"collapse\"}toggle(){this._element.classList.contains(\"show\")?this.hide():this.show()}show(){if(this._isTransitioning||this._element.classList.contains(\"show\"))return;let t,e;this._parent&&(t=i.find(\".show, .collapsing\",this._parent).filter(t=>\"string\"==typeof this._config.parent?t.getAttribute(\"data-bs-parent\")===this._config.parent:t.classList.contains(\"collapse\")),0===t.length&&(t=null));const s=i.findOne(this._selector);if(t){const i=t.find(t=>s!==t);if(e=i?nt.getInstance(i):null,e&&e._isTransitioning)return}if(B.trigger(this._element,\"show.bs.collapse\").defaultPrevented)return;t&&t.forEach(t=>{s!==t&&nt.collapseInterface(t,\"hide\"),e||W.set(t,\"bs.collapse\",null)});const n=this._getDimension();this._element.classList.remove(\"collapse\"),this._element.classList.add(\"collapsing\"),this._element.style[n]=0,this._triggerArray.length&&this._triggerArray.forEach(t=>{t.classList.remove(\"collapsed\"),t.setAttribute(\"aria-expanded\",!0)}),this.setTransitioning(!0);const o=\"scroll\"+(n[0].toUpperCase()+n.slice(1));this._queueCallback(()=>{this._element.classList.remove(\"collapsing\"),this._element.classList.add(\"collapse\",\"show\"),this._element.style[n]=\"\",this.setTransitioning(!1),B.trigger(this._element,\"shown.bs.collapse\")},this._element,!0),this._element.style[n]=this._element[o]+\"px\"}hide(){if(this._isTransitioning||!this._element.classList.contains(\"show\"))return;if(B.trigger(this._element,\"hide.bs.collapse\").defaultPrevented)return;const t=this._getDimension();this._element.style[t]=this._element.getBoundingClientRect()[t]+\"px\",m(this._element),this._element.classList.add(\"collapsing\"),this._element.classList.remove(\"collapse\",\"show\");const e=this._triggerArray.length;if(e>0)for(let t=0;t<e;t++){const e=this._triggerArray[t],s=a(e);s&&!s.classList.contains(\"show\")&&(e.classList.add(\"collapsed\"),e.setAttribute(\"aria-expanded\",!1))}this.setTransitioning(!0),this._element.style[t]=\"\",this._queueCallback(()=>{this.setTransitioning(!1),this._element.classList.remove(\"collapsing\"),this._element.classList.add(\"collapse\"),B.trigger(this._element,\"hidden.bs.collapse\")},this._element,!0)}setTransitioning(t){this._isTransitioning=t}_getConfig(t){return(t={...st,...t}).toggle=Boolean(t.toggle),d(\"collapse\",t,it),t}_getDimension(){return this._element.classList.contains(\"width\")?\"width\":\"height\"}_getParent(){let{parent:t}=this._config;t=h(t);const e=`[data-bs-toggle=\"collapse\"][data-bs-parent=\"${t}\"]`;return i.find(e,t).forEach(t=>{const e=a(t);this._addAriaAndCollapsedClass(e,[t])}),t}_addAriaAndCollapsedClass(t,e){if(!t||!e.length)return;const s=t.classList.contains(\"show\");e.forEach(t=>{s?t.classList.remove(\"collapsed\"):t.classList.add(\"collapsed\"),t.setAttribute(\"aria-expanded\",s)})}static collapseInterface(t,e){let s=nt.getInstance(t);const i={...st,...V.getDataAttributes(t),...\"object\"==typeof e&&e?e:{}};if(!s&&i.toggle&&\"string\"==typeof e&&/show|hide/.test(e)&&(i.toggle=!1),s||(s=new nt(t,i)),\"string\"==typeof e){if(void 0===s[e])throw new TypeError(`No method named \"${e}\"`);s[e]()}}static jQueryInterface(t){return this.each((function(){nt.collapseInterface(this,t)}))}}B.on(document,\"click.bs.collapse.data-api\",'[data-bs-toggle=\"collapse\"]',(function(t){(\"A\"===t.target.tagName||t.delegateTarget&&\"A\"===t.delegateTarget.tagName)&&t.preventDefault();const e=V.getDataAttributes(this),s=r(this);i.find(s).forEach(t=>{const s=nt.getInstance(t);let i;s?(null===s._parent&&\"string\"==typeof e.parent&&(s._config.parent=e.parent,s._parent=s._getParent()),i=\"toggle\"):i=e,nt.collapseInterface(t,i)})})),y(nt);const ot=new RegExp(\"ArrowUp|ArrowDown|Escape\"),rt=v()?\"top-end\":\"top-start\",at=v()?\"top-start\":\"top-end\",lt=v()?\"bottom-end\":\"bottom-start\",ct=v()?\"bottom-start\":\"bottom-end\",ht=v()?\"left-start\":\"right-start\",dt=v()?\"right-start\":\"left-start\",ut={offset:[0,2],boundary:\"clippingParents\",reference:\"toggle\",display:\"dynamic\",popperConfig:null,autoClose:!0},gt={offset:\"(array|string|function)\",boundary:\"(string|element)\",reference:\"(string|element|object)\",display:\"string\",popperConfig:\"(null|object|function)\",autoClose:\"(boolean|string)\"};class pt extends q{constructor(t,e){super(t),this._popper=null,this._config=this._getConfig(e),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar(),this._addEventListeners()}static get Default(){return ut}static get DefaultType(){return gt}static get NAME(){return\"dropdown\"}toggle(){g(this._element)||(this._element.classList.contains(\"show\")?this.hide():this.show())}show(){if(g(this._element)||this._menu.classList.contains(\"show\"))return;const t=pt.getParentFromElement(this._element),e={relatedTarget:this._element};if(!B.trigger(this._element,\"show.bs.dropdown\",e).defaultPrevented){if(this._inNavbar)V.setDataAttribute(this._menu,\"popper\",\"none\");else{if(void 0===s)throw new TypeError(\"Bootstrap's dropdowns require Popper (https://popper.js.org)\");let e=this._element;\"parent\"===this._config.reference?e=t:c(this._config.reference)?e=h(this._config.reference):\"object\"==typeof this._config.reference&&(e=this._config.reference);const i=this._getPopperConfig(),n=i.modifiers.find(t=>\"applyStyles\"===t.name&&!1===t.enabled);this._popper=s.createPopper(e,this._menu,i),n&&V.setDataAttribute(this._menu,\"popper\",\"static\")}\"ontouchstart\"in document.documentElement&&!t.closest(\".navbar-nav\")&&[].concat(...document.body.children).forEach(t=>B.on(t,\"mouseover\",f)),this._element.focus(),this._element.setAttribute(\"aria-expanded\",!0),this._menu.classList.toggle(\"show\"),this._element.classList.toggle(\"show\"),B.trigger(this._element,\"shown.bs.dropdown\",e)}}hide(){if(g(this._element)||!this._menu.classList.contains(\"show\"))return;const t={relatedTarget:this._element};this._completeHide(t)}dispose(){this._popper&&this._popper.destroy(),super.dispose()}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update()}_addEventListeners(){B.on(this._element,\"click.bs.dropdown\",t=>{t.preventDefault(),this.toggle()})}_completeHide(t){B.trigger(this._element,\"hide.bs.dropdown\",t).defaultPrevented||(\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>B.off(t,\"mouseover\",f)),this._popper&&this._popper.destroy(),this._menu.classList.remove(\"show\"),this._element.classList.remove(\"show\"),this._element.setAttribute(\"aria-expanded\",\"false\"),V.removeDataAttribute(this._menu,\"popper\"),B.trigger(this._element,\"hidden.bs.dropdown\",t))}_getConfig(t){if(t={...this.constructor.Default,...V.getDataAttributes(this._element),...t},d(\"dropdown\",t,this.constructor.DefaultType),\"object\"==typeof t.reference&&!c(t.reference)&&\"function\"!=typeof t.reference.getBoundingClientRect)throw new TypeError(\"dropdown\".toUpperCase()+': Option \"reference\" provided type \"object\" without a required \"getBoundingClientRect\" method.');return t}_getMenuElement(){return i.next(this._element,\".dropdown-menu\")[0]}_getPlacement(){const t=this._element.parentNode;if(t.classList.contains(\"dropend\"))return ht;if(t.classList.contains(\"dropstart\"))return dt;const e=\"end\"===getComputedStyle(this._menu).getPropertyValue(\"--bs-position\").trim();return t.classList.contains(\"dropup\")?e?at:rt:e?ct:lt}_detectNavbar(){return null!==this._element.closest(\".navbar\")}_getOffset(){const{offset:t}=this._config;return\"string\"==typeof t?t.split(\",\").map(t=>Number.parseInt(t,10)):\"function\"==typeof t?e=>t(e,this._element):t}_getPopperConfig(){const t={placement:this._getPlacement(),modifiers:[{name:\"preventOverflow\",options:{boundary:this._config.boundary}},{name:\"offset\",options:{offset:this._getOffset()}}]};return\"static\"===this._config.display&&(t.modifiers=[{name:\"applyStyles\",enabled:!1}]),{...t,...\"function\"==typeof this._config.popperConfig?this._config.popperConfig(t):this._config.popperConfig}}_selectMenuItem({key:t,target:e}){const s=i.find(\".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)\",this._menu).filter(u);s.length&&A(s,e,\"ArrowDown\"===t,!s.includes(e)).focus()}static dropdownInterface(t,e){const s=pt.getOrCreateInstance(t,e);if(\"string\"==typeof e){if(void 0===s[e])throw new TypeError(`No method named \"${e}\"`);s[e]()}}static jQueryInterface(t){return this.each((function(){pt.dropdownInterface(this,t)}))}static clearMenus(t){if(t&&(2===t.button||\"keyup\"===t.type&&\"Tab\"!==t.key))return;const e=i.find('[data-bs-toggle=\"dropdown\"]');for(let s=0,i=e.length;s<i;s++){const i=pt.getInstance(e[s]);if(!i||!1===i._config.autoClose)continue;if(!i._element.classList.contains(\"show\"))continue;const n={relatedTarget:i._element};if(t){const e=t.composedPath(),s=e.includes(i._menu);if(e.includes(i._element)||\"inside\"===i._config.autoClose&&!s||\"outside\"===i._config.autoClose&&s)continue;if(i._menu.contains(t.target)&&(\"keyup\"===t.type&&\"Tab\"===t.key||/input|select|option|textarea|form/i.test(t.target.tagName)))continue;\"click\"===t.type&&(n.clickEvent=t)}i._completeHide(n)}}static getParentFromElement(t){return a(t)||t.parentNode}static dataApiKeydownHandler(t){if(/input|textarea/i.test(t.target.tagName)?\"Space\"===t.key||\"Escape\"!==t.key&&(\"ArrowDown\"!==t.key&&\"ArrowUp\"!==t.key||t.target.closest(\".dropdown-menu\")):!ot.test(t.key))return;const e=this.classList.contains(\"show\");if(!e&&\"Escape\"===t.key)return;if(t.preventDefault(),t.stopPropagation(),g(this))return;const s=()=>this.matches('[data-bs-toggle=\"dropdown\"]')?this:i.prev(this,'[data-bs-toggle=\"dropdown\"]')[0];return\"Escape\"===t.key?(s().focus(),void pt.clearMenus()):\"ArrowUp\"===t.key||\"ArrowDown\"===t.key?(e||s().click(),void pt.getInstance(s())._selectMenuItem(t)):void(e&&\"Space\"!==t.key||pt.clearMenus())}}B.on(document,\"keydown.bs.dropdown.data-api\",'[data-bs-toggle=\"dropdown\"]',pt.dataApiKeydownHandler),B.on(document,\"keydown.bs.dropdown.data-api\",\".dropdown-menu\",pt.dataApiKeydownHandler),B.on(document,\"click.bs.dropdown.data-api\",pt.clearMenus),B.on(document,\"keyup.bs.dropdown.data-api\",pt.clearMenus),B.on(document,\"click.bs.dropdown.data-api\",'[data-bs-toggle=\"dropdown\"]',(function(t){t.preventDefault(),pt.dropdownInterface(this)})),y(pt);class ft{constructor(){this._element=document.body}getWidth(){const t=document.documentElement.clientWidth;return Math.abs(window.innerWidth-t)}hide(){const t=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,\"paddingRight\",e=>e+t),this._setElementAttributes(\".fixed-top, .fixed-bottom, .is-fixed, .sticky-top\",\"paddingRight\",e=>e+t),this._setElementAttributes(\".sticky-top\",\"marginRight\",e=>e-t)}_disableOverFlow(){this._saveInitialAttribute(this._element,\"overflow\"),this._element.style.overflow=\"hidden\"}_setElementAttributes(t,e,s){const i=this.getWidth();this._applyManipulationCallback(t,t=>{if(t!==this._element&&window.innerWidth>t.clientWidth+i)return;this._saveInitialAttribute(t,e);const n=window.getComputedStyle(t)[e];t.style[e]=s(Number.parseFloat(n))+\"px\"})}reset(){this._resetElementAttributes(this._element,\"overflow\"),this._resetElementAttributes(this._element,\"paddingRight\"),this._resetElementAttributes(\".fixed-top, .fixed-bottom, .is-fixed, .sticky-top\",\"paddingRight\"),this._resetElementAttributes(\".sticky-top\",\"marginRight\")}_saveInitialAttribute(t,e){const s=t.style[e];s&&V.setDataAttribute(t,e,s)}_resetElementAttributes(t,e){this._applyManipulationCallback(t,t=>{const s=V.getDataAttribute(t,e);void 0===s?t.style.removeProperty(e):(V.removeDataAttribute(t,e),t.style[e]=s)})}_applyManipulationCallback(t,e){c(t)?e(t):i.find(t,this._element).forEach(e)}isOverflowing(){return this.getWidth()>0}}const mt={isVisible:!0,isAnimated:!1,rootElement:\"body\",clickCallback:null},_t={isVisible:\"boolean\",isAnimated:\"boolean\",rootElement:\"(element|string)\",clickCallback:\"(function|null)\"};class bt{constructor(t){this._config=this._getConfig(t),this._isAppended=!1,this._element=null}show(t){this._config.isVisible?(this._append(),this._config.isAnimated&&m(this._getElement()),this._getElement().classList.add(\"show\"),this._emulateAnimation(()=>{w(t)})):w(t)}hide(t){this._config.isVisible?(this._getElement().classList.remove(\"show\"),this._emulateAnimation(()=>{this.dispose(),w(t)})):w(t)}_getElement(){if(!this._element){const t=document.createElement(\"div\");t.className=\"modal-backdrop\",this._config.isAnimated&&t.classList.add(\"fade\"),this._element=t}return this._element}_getConfig(t){return(t={...mt,...\"object\"==typeof t?t:{}}).rootElement=h(t.rootElement),d(\"backdrop\",t,_t),t}_append(){this._isAppended||(this._config.rootElement.appendChild(this._getElement()),B.on(this._getElement(),\"mousedown.bs.backdrop\",()=>{w(this._config.clickCallback)}),this._isAppended=!0)}dispose(){this._isAppended&&(B.off(this._element,\"mousedown.bs.backdrop\"),this._element.remove(),this._isAppended=!1)}_emulateAnimation(t){E(t,this._getElement(),this._config.isAnimated)}}const vt={backdrop:!0,keyboard:!0,focus:!0},yt={backdrop:\"(boolean|string)\",keyboard:\"boolean\",focus:\"boolean\"};class wt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._dialog=i.findOne(\".modal-dialog\",this._element),this._backdrop=this._initializeBackDrop(),this._isShown=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollBar=new ft}static get Default(){return vt}static get NAME(){return\"modal\"}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){this._isShown||this._isTransitioning||B.trigger(this._element,\"show.bs.modal\",{relatedTarget:t}).defaultPrevented||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._scrollBar.hide(),document.body.classList.add(\"modal-open\"),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),B.on(this._element,\"click.dismiss.bs.modal\",'[data-bs-dismiss=\"modal\"]',t=>this.hide(t)),B.on(this._dialog,\"mousedown.dismiss.bs.modal\",()=>{B.one(this._element,\"mouseup.dismiss.bs.modal\",t=>{t.target===this._element&&(this._ignoreBackdropClick=!0)})}),this._showBackdrop(()=>this._showElement(t)))}hide(t){if(t&&[\"A\",\"AREA\"].includes(t.target.tagName)&&t.preventDefault(),!this._isShown||this._isTransitioning)return;if(B.trigger(this._element,\"hide.bs.modal\").defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),B.off(document,\"focusin.bs.modal\"),this._element.classList.remove(\"show\"),B.off(this._element,\"click.dismiss.bs.modal\"),B.off(this._dialog,\"mousedown.dismiss.bs.modal\"),this._queueCallback(()=>this._hideModal(),this._element,e)}dispose(){[window,this._dialog].forEach(t=>B.off(t,\".bs.modal\")),this._backdrop.dispose(),super.dispose(),B.off(document,\"focusin.bs.modal\")}handleUpdate(){this._adjustDialog()}_initializeBackDrop(){return new bt({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_getConfig(t){return t={...vt,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"modal\",t,yt),t}_showElement(t){const e=this._isAnimated(),s=i.findOne(\".modal-body\",this._dialog);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.appendChild(this._element),this._element.style.display=\"block\",this._element.removeAttribute(\"aria-hidden\"),this._element.setAttribute(\"aria-modal\",!0),this._element.setAttribute(\"role\",\"dialog\"),this._element.scrollTop=0,s&&(s.scrollTop=0),e&&m(this._element),this._element.classList.add(\"show\"),this._config.focus&&this._enforceFocus(),this._queueCallback(()=>{this._config.focus&&this._element.focus(),this._isTransitioning=!1,B.trigger(this._element,\"shown.bs.modal\",{relatedTarget:t})},this._dialog,e)}_enforceFocus(){B.off(document,\"focusin.bs.modal\"),B.on(document,\"focusin.bs.modal\",t=>{document===t.target||this._element===t.target||this._element.contains(t.target)||this._element.focus()})}_setEscapeEvent(){this._isShown?B.on(this._element,\"keydown.dismiss.bs.modal\",t=>{this._config.keyboard&&\"Escape\"===t.key?(t.preventDefault(),this.hide()):this._config.keyboard||\"Escape\"!==t.key||this._triggerBackdropTransition()}):B.off(this._element,\"keydown.dismiss.bs.modal\")}_setResizeEvent(){this._isShown?B.on(window,\"resize.bs.modal\",()=>this._adjustDialog()):B.off(window,\"resize.bs.modal\")}_hideModal(){this._element.style.display=\"none\",this._element.setAttribute(\"aria-hidden\",!0),this._element.removeAttribute(\"aria-modal\"),this._element.removeAttribute(\"role\"),this._isTransitioning=!1,this._backdrop.hide(()=>{document.body.classList.remove(\"modal-open\"),this._resetAdjustments(),this._scrollBar.reset(),B.trigger(this._element,\"hidden.bs.modal\")})}_showBackdrop(t){B.on(this._element,\"click.dismiss.bs.modal\",t=>{this._ignoreBackdropClick?this._ignoreBackdropClick=!1:t.target===t.currentTarget&&(!0===this._config.backdrop?this.hide():\"static\"===this._config.backdrop&&this._triggerBackdropTransition())}),this._backdrop.show(t)}_isAnimated(){return this._element.classList.contains(\"fade\")}_triggerBackdropTransition(){if(B.trigger(this._element,\"hidePrevented.bs.modal\").defaultPrevented)return;const{classList:t,scrollHeight:e,style:s}=this._element,i=e>document.documentElement.clientHeight;!i&&\"hidden\"===s.overflowY||t.contains(\"modal-static\")||(i||(s.overflowY=\"hidden\"),t.add(\"modal-static\"),this._queueCallback(()=>{t.remove(\"modal-static\"),i||this._queueCallback(()=>{s.overflowY=\"\"},this._dialog)},this._dialog),this._element.focus())}_adjustDialog(){const t=this._element.scrollHeight>document.documentElement.clientHeight,e=this._scrollBar.getWidth(),s=e>0;(!s&&t&&!v()||s&&!t&&v())&&(this._element.style.paddingLeft=e+\"px\"),(s&&!t&&!v()||!s&&t&&v())&&(this._element.style.paddingRight=e+\"px\")}_resetAdjustments(){this._element.style.paddingLeft=\"\",this._element.style.paddingRight=\"\"}static jQueryInterface(t,e){return this.each((function(){const s=wt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===s[t])throw new TypeError(`No method named \"${t}\"`);s[t](e)}}))}}B.on(document,\"click.bs.modal.data-api\",'[data-bs-toggle=\"modal\"]',(function(t){const e=a(this);[\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),B.one(e,\"show.bs.modal\",t=>{t.defaultPrevented||B.one(e,\"hidden.bs.modal\",()=>{u(this)&&this.focus()})}),wt.getOrCreateInstance(e).toggle(this)})),y(wt);const Et={backdrop:!0,keyboard:!0,scroll:!1},At={backdrop:\"boolean\",keyboard:\"boolean\",scroll:\"boolean\"};class Tt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._addEventListeners()}static get NAME(){return\"offcanvas\"}static get Default(){return Et}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){this._isShown||B.trigger(this._element,\"show.bs.offcanvas\",{relatedTarget:t}).defaultPrevented||(this._isShown=!0,this._element.style.visibility=\"visible\",this._backdrop.show(),this._config.scroll||((new ft).hide(),this._enforceFocusOnElement(this._element)),this._element.removeAttribute(\"aria-hidden\"),this._element.setAttribute(\"aria-modal\",!0),this._element.setAttribute(\"role\",\"dialog\"),this._element.classList.add(\"show\"),this._queueCallback(()=>{B.trigger(this._element,\"shown.bs.offcanvas\",{relatedTarget:t})},this._element,!0))}hide(){this._isShown&&(B.trigger(this._element,\"hide.bs.offcanvas\").defaultPrevented||(B.off(document,\"focusin.bs.offcanvas\"),this._element.blur(),this._isShown=!1,this._element.classList.remove(\"show\"),this._backdrop.hide(),this._queueCallback(()=>{this._element.setAttribute(\"aria-hidden\",!0),this._element.removeAttribute(\"aria-modal\"),this._element.removeAttribute(\"role\"),this._element.style.visibility=\"hidden\",this._config.scroll||(new ft).reset(),B.trigger(this._element,\"hidden.bs.offcanvas\")},this._element,!0)))}dispose(){this._backdrop.dispose(),super.dispose(),B.off(document,\"focusin.bs.offcanvas\")}_getConfig(t){return t={...Et,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"offcanvas\",t,At),t}_initializeBackDrop(){return new bt({isVisible:this._config.backdrop,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_enforceFocusOnElement(t){B.off(document,\"focusin.bs.offcanvas\"),B.on(document,\"focusin.bs.offcanvas\",e=>{document===e.target||t===e.target||t.contains(e.target)||t.focus()}),t.focus()}_addEventListeners(){B.on(this._element,\"click.dismiss.bs.offcanvas\",'[data-bs-dismiss=\"offcanvas\"]',()=>this.hide()),B.on(this._element,\"keydown.dismiss.bs.offcanvas\",t=>{this._config.keyboard&&\"Escape\"===t.key&&this.hide()})}static jQueryInterface(t){return this.each((function(){const e=Tt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t]||t.startsWith(\"_\")||\"constructor\"===t)throw new TypeError(`No method named \"${t}\"`);e[t](this)}}))}}B.on(document,\"click.bs.offcanvas.data-api\",'[data-bs-toggle=\"offcanvas\"]',(function(t){const e=a(this);if([\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),g(this))return;B.one(e,\"hidden.bs.offcanvas\",()=>{u(this)&&this.focus()});const s=i.findOne(\".offcanvas.show\");s&&s!==e&&Tt.getInstance(s).hide(),Tt.getOrCreateInstance(e).toggle(this)})),B.on(window,\"load.bs.offcanvas.data-api\",()=>i.find(\".offcanvas.show\").forEach(t=>Tt.getOrCreateInstance(t).show())),y(Tt);const Ct=new Set([\"background\",\"cite\",\"href\",\"itemtype\",\"longdesc\",\"poster\",\"src\",\"xlink:href\"]),kt=/^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/i,Lt=/^data:(?:image\\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\\/(?:mpeg|mp4|ogg|webm)|audio\\/(?:mp3|oga|ogg|opus));base64,[\\d+/a-z]+=*$/i,Ot=(t,e)=>{const s=t.nodeName.toLowerCase();if(e.includes(s))return!Ct.has(s)||Boolean(kt.test(t.nodeValue)||Lt.test(t.nodeValue));const i=e.filter(t=>t instanceof RegExp);for(let t=0,e=i.length;t<e;t++)if(i[t].test(s))return!0;return!1};function Dt(t,e,s){if(!t.length)return t;if(s&&\"function\"==typeof s)return s(t);const i=(new window.DOMParser).parseFromString(t,\"text/html\"),n=Object.keys(e),o=[].concat(...i.body.querySelectorAll(\"*\"));for(let t=0,s=o.length;t<s;t++){const s=o[t],i=s.nodeName.toLowerCase();if(!n.includes(i)){s.remove();continue}const r=[].concat(...s.attributes),a=[].concat(e[\"*\"]||[],e[i]||[]);r.forEach(t=>{Ot(t,a)||s.removeAttribute(t.nodeName)})}return i.body.innerHTML}const It=new RegExp(\"(^|\\\\s)bs-tooltip\\\\S+\",\"g\"),Nt=new Set([\"sanitize\",\"allowList\",\"sanitizeFn\"]),St={animation:\"boolean\",template:\"string\",title:\"(string|element|function)\",trigger:\"string\",delay:\"(number|object)\",html:\"boolean\",selector:\"(string|boolean)\",placement:\"(string|function)\",offset:\"(array|string|function)\",container:\"(string|element|boolean)\",fallbackPlacements:\"array\",boundary:\"(string|element)\",customClass:\"(string|function)\",sanitize:\"boolean\",sanitizeFn:\"(null|function)\",allowList:\"object\",popperConfig:\"(null|object|function)\"},xt={AUTO:\"auto\",TOP:\"top\",RIGHT:v()?\"left\":\"right\",BOTTOM:\"bottom\",LEFT:v()?\"right\":\"left\"},Mt={animation:!0,template:'<div class=\"tooltip\" role=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div></div>',trigger:\"hover focus\",title:\"\",delay:0,html:!1,selector:!1,placement:\"top\",offset:[0,0],container:!1,fallbackPlacements:[\"top\",\"right\",\"bottom\",\"left\"],boundary:\"clippingParents\",customClass:\"\",sanitize:!0,sanitizeFn:null,allowList:{\"*\":[\"class\",\"dir\",\"id\",\"lang\",\"role\",/^aria-[\\w-]*$/i],a:[\"target\",\"href\",\"title\",\"rel\"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:[\"src\",\"srcset\",\"alt\",\"title\",\"width\",\"height\"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]},popperConfig:null},Pt={HIDE:\"hide.bs.tooltip\",HIDDEN:\"hidden.bs.tooltip\",SHOW:\"show.bs.tooltip\",SHOWN:\"shown.bs.tooltip\",INSERTED:\"inserted.bs.tooltip\",CLICK:\"click.bs.tooltip\",FOCUSIN:\"focusin.bs.tooltip\",FOCUSOUT:\"focusout.bs.tooltip\",MOUSEENTER:\"mouseenter.bs.tooltip\",MOUSELEAVE:\"mouseleave.bs.tooltip\"};class jt extends q{constructor(t,e){if(void 0===s)throw new TypeError(\"Bootstrap's tooltips require Popper (https://popper.js.org)\");super(t),this._isEnabled=!0,this._timeout=0,this._hoverState=\"\",this._activeTrigger={},this._popper=null,this._config=this._getConfig(e),this.tip=null,this._setListeners()}static get Default(){return Mt}static get NAME(){return\"tooltip\"}static get Event(){return Pt}static get DefaultType(){return St}enable(){this._isEnabled=!0}disable(){this._isEnabled=!1}toggleEnabled(){this._isEnabled=!this._isEnabled}toggle(t){if(this._isEnabled)if(t){const e=this._initializeOnDelegatedTarget(t);e._activeTrigger.click=!e._activeTrigger.click,e._isWithActiveTrigger()?e._enter(null,e):e._leave(null,e)}else{if(this.getTipElement().classList.contains(\"show\"))return void this._leave(null,this);this._enter(null,this)}}dispose(){clearTimeout(this._timeout),B.off(this._element.closest(\".modal\"),\"hide.bs.modal\",this._hideModalHandler),this.tip&&this.tip.remove(),this._popper&&this._popper.destroy(),super.dispose()}show(){if(\"none\"===this._element.style.display)throw new Error(\"Please use show on visible elements\");if(!this.isWithContent()||!this._isEnabled)return;const t=B.trigger(this._element,this.constructor.Event.SHOW),e=p(this._element),i=null===e?this._element.ownerDocument.documentElement.contains(this._element):e.contains(this._element);if(t.defaultPrevented||!i)return;const o=this.getTipElement(),r=n(this.constructor.NAME);o.setAttribute(\"id\",r),this._element.setAttribute(\"aria-describedby\",r),this.setContent(),this._config.animation&&o.classList.add(\"fade\");const a=\"function\"==typeof this._config.placement?this._config.placement.call(this,o,this._element):this._config.placement,l=this._getAttachment(a);this._addAttachmentClass(l);const{container:c}=this._config;W.set(o,this.constructor.DATA_KEY,this),this._element.ownerDocument.documentElement.contains(this.tip)||(c.appendChild(o),B.trigger(this._element,this.constructor.Event.INSERTED)),this._popper?this._popper.update():this._popper=s.createPopper(this._element,o,this._getPopperConfig(l)),o.classList.add(\"show\");const h=\"function\"==typeof this._config.customClass?this._config.customClass():this._config.customClass;h&&o.classList.add(...h.split(\" \")),\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>{B.on(t,\"mouseover\",f)});const d=this.tip.classList.contains(\"fade\");this._queueCallback(()=>{const t=this._hoverState;this._hoverState=null,B.trigger(this._element,this.constructor.Event.SHOWN),\"out\"===t&&this._leave(null,this)},this.tip,d)}hide(){if(!this._popper)return;const t=this.getTipElement();if(B.trigger(this._element,this.constructor.Event.HIDE).defaultPrevented)return;t.classList.remove(\"show\"),\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>B.off(t,\"mouseover\",f)),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1;const e=this.tip.classList.contains(\"fade\");this._queueCallback(()=>{this._isWithActiveTrigger()||(\"show\"!==this._hoverState&&t.remove(),this._cleanTipClass(),this._element.removeAttribute(\"aria-describedby\"),B.trigger(this._element,this.constructor.Event.HIDDEN),this._popper&&(this._popper.destroy(),this._popper=null))},this.tip,e),this._hoverState=\"\"}update(){null!==this._popper&&this._popper.update()}isWithContent(){return Boolean(this.getTitle())}getTipElement(){if(this.tip)return this.tip;const t=document.createElement(\"div\");return t.innerHTML=this._config.template,this.tip=t.children[0],this.tip}setContent(){const t=this.getTipElement();this.setElementContent(i.findOne(\".tooltip-inner\",t),this.getTitle()),t.classList.remove(\"fade\",\"show\")}setElementContent(t,e){if(null!==t)return c(e)?(e=h(e),void(this._config.html?e.parentNode!==t&&(t.innerHTML=\"\",t.appendChild(e)):t.textContent=e.textContent)):void(this._config.html?(this._config.sanitize&&(e=Dt(e,this._config.allowList,this._config.sanitizeFn)),t.innerHTML=e):t.textContent=e)}getTitle(){let t=this._element.getAttribute(\"data-bs-original-title\");return t||(t=\"function\"==typeof this._config.title?this._config.title.call(this._element):this._config.title),t}updateAttachment(t){return\"right\"===t?\"end\":\"left\"===t?\"start\":t}_initializeOnDelegatedTarget(t,e){const s=this.constructor.DATA_KEY;return(e=e||W.get(t.delegateTarget,s))||(e=new this.constructor(t.delegateTarget,this._getDelegateConfig()),W.set(t.delegateTarget,s,e)),e}_getOffset(){const{offset:t}=this._config;return\"string\"==typeof t?t.split(\",\").map(t=>Number.parseInt(t,10)):\"function\"==typeof t?e=>t(e,this._element):t}_getPopperConfig(t){const e={placement:t,modifiers:[{name:\"flip\",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:\"offset\",options:{offset:this._getOffset()}},{name:\"preventOverflow\",options:{boundary:this._config.boundary}},{name:\"arrow\",options:{element:`.${this.constructor.NAME}-arrow`}},{name:\"onChange\",enabled:!0,phase:\"afterWrite\",fn:t=>this._handlePopperPlacementChange(t)}],onFirstUpdate:t=>{t.options.placement!==t.placement&&this._handlePopperPlacementChange(t)}};return{...e,...\"function\"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_addAttachmentClass(t){this.getTipElement().classList.add(\"bs-tooltip-\"+this.updateAttachment(t))}_getAttachment(t){return xt[t.toUpperCase()]}_setListeners(){this._config.trigger.split(\" \").forEach(t=>{if(\"click\"===t)B.on(this._element,this.constructor.Event.CLICK,this._config.selector,t=>this.toggle(t));else if(\"manual\"!==t){const e=\"hover\"===t?this.constructor.Event.MOUSEENTER:this.constructor.Event.FOCUSIN,s=\"hover\"===t?this.constructor.Event.MOUSELEAVE:this.constructor.Event.FOCUSOUT;B.on(this._element,e,this._config.selector,t=>this._enter(t)),B.on(this._element,s,this._config.selector,t=>this._leave(t))}}),this._hideModalHandler=()=>{this._element&&this.hide()},B.on(this._element.closest(\".modal\"),\"hide.bs.modal\",this._hideModalHandler),this._config.selector?this._config={...this._config,trigger:\"manual\",selector:\"\"}:this._fixTitle()}_fixTitle(){const t=this._element.getAttribute(\"title\"),e=typeof this._element.getAttribute(\"data-bs-original-title\");(t||\"string\"!==e)&&(this._element.setAttribute(\"data-bs-original-title\",t||\"\"),!t||this._element.getAttribute(\"aria-label\")||this._element.textContent||this._element.setAttribute(\"aria-label\",t),this._element.setAttribute(\"title\",\"\"))}_enter(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger[\"focusin\"===t.type?\"focus\":\"hover\"]=!0),e.getTipElement().classList.contains(\"show\")||\"show\"===e._hoverState?e._hoverState=\"show\":(clearTimeout(e._timeout),e._hoverState=\"show\",e._config.delay&&e._config.delay.show?e._timeout=setTimeout(()=>{\"show\"===e._hoverState&&e.show()},e._config.delay.show):e.show())}_leave(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger[\"focusout\"===t.type?\"focus\":\"hover\"]=e._element.contains(t.relatedTarget)),e._isWithActiveTrigger()||(clearTimeout(e._timeout),e._hoverState=\"out\",e._config.delay&&e._config.delay.hide?e._timeout=setTimeout(()=>{\"out\"===e._hoverState&&e.hide()},e._config.delay.hide):e.hide())}_isWithActiveTrigger(){for(const t in this._activeTrigger)if(this._activeTrigger[t])return!0;return!1}_getConfig(t){const e=V.getDataAttributes(this._element);return Object.keys(e).forEach(t=>{Nt.has(t)&&delete e[t]}),(t={...this.constructor.Default,...e,...\"object\"==typeof t&&t?t:{}}).container=!1===t.container?document.body:h(t.container),\"number\"==typeof t.delay&&(t.delay={show:t.delay,hide:t.delay}),\"number\"==typeof t.title&&(t.title=t.title.toString()),\"number\"==typeof t.content&&(t.content=t.content.toString()),d(\"tooltip\",t,this.constructor.DefaultType),t.sanitize&&(t.template=Dt(t.template,t.allowList,t.sanitizeFn)),t}_getDelegateConfig(){const t={};if(this._config)for(const e in this._config)this.constructor.Default[e]!==this._config[e]&&(t[e]=this._config[e]);return t}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute(\"class\").match(It);null!==e&&e.length>0&&e.map(t=>t.trim()).forEach(e=>t.classList.remove(e))}_handlePopperPlacementChange(t){const{state:e}=t;e&&(this.tip=e.elements.popper,this._cleanTipClass(),this._addAttachmentClass(this._getAttachment(e.placement)))}static jQueryInterface(t){return this.each((function(){const e=jt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}y(jt);const Ht=new RegExp(\"(^|\\\\s)bs-popover\\\\S+\",\"g\"),Rt={...jt.Default,placement:\"right\",offset:[0,8],trigger:\"click\",content:\"\",template:'<div class=\"popover\" role=\"tooltip\"><div class=\"popover-arrow\"></div><h3 class=\"popover-header\"></h3><div class=\"popover-body\"></div></div>'},Bt={...jt.DefaultType,content:\"(string|element|function)\"},$t={HIDE:\"hide.bs.popover\",HIDDEN:\"hidden.bs.popover\",SHOW:\"show.bs.popover\",SHOWN:\"shown.bs.popover\",INSERTED:\"inserted.bs.popover\",CLICK:\"click.bs.popover\",FOCUSIN:\"focusin.bs.popover\",FOCUSOUT:\"focusout.bs.popover\",MOUSEENTER:\"mouseenter.bs.popover\",MOUSELEAVE:\"mouseleave.bs.popover\"};class Wt extends jt{static get Default(){return Rt}static get NAME(){return\"popover\"}static get Event(){return $t}static get DefaultType(){return Bt}isWithContent(){return this.getTitle()||this._getContent()}getTipElement(){return this.tip||(this.tip=super.getTipElement(),this.getTitle()||i.findOne(\".popover-header\",this.tip).remove(),this._getContent()||i.findOne(\".popover-body\",this.tip).remove()),this.tip}setContent(){const t=this.getTipElement();this.setElementContent(i.findOne(\".popover-header\",t),this.getTitle());let e=this._getContent();\"function\"==typeof e&&(e=e.call(this._element)),this.setElementContent(i.findOne(\".popover-body\",t),e),t.classList.remove(\"fade\",\"show\")}_addAttachmentClass(t){this.getTipElement().classList.add(\"bs-popover-\"+this.updateAttachment(t))}_getContent(){return this._element.getAttribute(\"data-bs-content\")||this._config.content}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute(\"class\").match(Ht);null!==e&&e.length>0&&e.map(t=>t.trim()).forEach(e=>t.classList.remove(e))}static jQueryInterface(t){return this.each((function(){const e=Wt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}y(Wt);const qt={offset:10,method:\"auto\",target:\"\"},zt={offset:\"number\",method:\"string\",target:\"(string|element)\"};class Ft extends q{constructor(t,e){super(t),this._scrollElement=\"BODY\"===this._element.tagName?window:this._element,this._config=this._getConfig(e),this._selector=`${this._config.target} .nav-link, ${this._config.target} .list-group-item, ${this._config.target} .dropdown-item`,this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,B.on(this._scrollElement,\"scroll.bs.scrollspy\",()=>this._process()),this.refresh(),this._process()}static get Default(){return qt}static get NAME(){return\"scrollspy\"}refresh(){const t=this._scrollElement===this._scrollElement.window?\"offset\":\"position\",e=\"auto\"===this._config.method?t:this._config.method,s=\"position\"===e?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight(),i.find(this._selector).map(t=>{const n=r(t),o=n?i.findOne(n):null;if(o){const t=o.getBoundingClientRect();if(t.width||t.height)return[V[e](o).top+s,n]}return null}).filter(t=>t).sort((t,e)=>t[0]-e[0]).forEach(t=>{this._offsets.push(t[0]),this._targets.push(t[1])})}dispose(){B.off(this._scrollElement,\".bs.scrollspy\"),super.dispose()}_getConfig(t){if(\"string\"!=typeof(t={...qt,...V.getDataAttributes(this._element),...\"object\"==typeof t&&t?t:{}}).target&&c(t.target)){let{id:e}=t.target;e||(e=n(\"scrollspy\"),t.target.id=e),t.target=\"#\"+e}return d(\"scrollspy\",t,zt),t}_getScrollTop(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop}_getScrollHeight(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}_getOffsetHeight(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height}_process(){const t=this._getScrollTop()+this._config.offset,e=this._getScrollHeight(),s=this._config.offset+e-this._getOffsetHeight();if(this._scrollHeight!==e&&this.refresh(),t>=s){const t=this._targets[this._targets.length-1];this._activeTarget!==t&&this._activate(t)}else{if(this._activeTarget&&t<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(let e=this._offsets.length;e--;)this._activeTarget!==this._targets[e]&&t>=this._offsets[e]&&(void 0===this._offsets[e+1]||t<this._offsets[e+1])&&this._activate(this._targets[e])}}_activate(t){this._activeTarget=t,this._clear();const e=this._selector.split(\",\").map(e=>`${e}[data-bs-target=\"${t}\"],${e}[href=\"${t}\"]`),s=i.findOne(e.join(\",\"));s.classList.contains(\"dropdown-item\")?(i.findOne(\".dropdown-toggle\",s.closest(\".dropdown\")).classList.add(\"active\"),s.classList.add(\"active\")):(s.classList.add(\"active\"),i.parents(s,\".nav, .list-group\").forEach(t=>{i.prev(t,\".nav-link, .list-group-item\").forEach(t=>t.classList.add(\"active\")),i.prev(t,\".nav-item\").forEach(t=>{i.children(t,\".nav-link\").forEach(t=>t.classList.add(\"active\"))})})),B.trigger(this._scrollElement,\"activate.bs.scrollspy\",{relatedTarget:t})}_clear(){i.find(this._selector).filter(t=>t.classList.contains(\"active\")).forEach(t=>t.classList.remove(\"active\"))}static jQueryInterface(t){return this.each((function(){const e=Ft.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}B.on(window,\"load.bs.scrollspy.data-api\",()=>{i.find('[data-bs-spy=\"scroll\"]').forEach(t=>new Ft(t))}),y(Ft);class Ut extends q{static get NAME(){return\"tab\"}show(){if(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&this._element.classList.contains(\"active\"))return;let t;const e=a(this._element),s=this._element.closest(\".nav, .list-group\");if(s){const e=\"UL\"===s.nodeName||\"OL\"===s.nodeName?\":scope > li > .active\":\".active\";t=i.find(e,s),t=t[t.length-1]}const n=t?B.trigger(t,\"hide.bs.tab\",{relatedTarget:this._element}):null;if(B.trigger(this._element,\"show.bs.tab\",{relatedTarget:t}).defaultPrevented||null!==n&&n.defaultPrevented)return;this._activate(this._element,s);const o=()=>{B.trigger(t,\"hidden.bs.tab\",{relatedTarget:this._element}),B.trigger(this._element,\"shown.bs.tab\",{relatedTarget:t})};e?this._activate(e,e.parentNode,o):o()}_activate(t,e,s){const n=(!e||\"UL\"!==e.nodeName&&\"OL\"!==e.nodeName?i.children(e,\".active\"):i.find(\":scope > li > .active\",e))[0],o=s&&n&&n.classList.contains(\"fade\"),r=()=>this._transitionComplete(t,n,s);n&&o?(n.classList.remove(\"show\"),this._queueCallback(r,t,!0)):r()}_transitionComplete(t,e,s){if(e){e.classList.remove(\"active\");const t=i.findOne(\":scope > .dropdown-menu .active\",e.parentNode);t&&t.classList.remove(\"active\"),\"tab\"===e.getAttribute(\"role\")&&e.setAttribute(\"aria-selected\",!1)}t.classList.add(\"active\"),\"tab\"===t.getAttribute(\"role\")&&t.setAttribute(\"aria-selected\",!0),m(t),t.classList.contains(\"fade\")&&t.classList.add(\"show\");let n=t.parentNode;if(n&&\"LI\"===n.nodeName&&(n=n.parentNode),n&&n.classList.contains(\"dropdown-menu\")){const e=t.closest(\".dropdown\");e&&i.find(\".dropdown-toggle\",e).forEach(t=>t.classList.add(\"active\")),t.setAttribute(\"aria-expanded\",!0)}s&&s()}static jQueryInterface(t){return this.each((function(){const e=Ut.getOrCreateInstance(this);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}B.on(document,\"click.bs.tab.data-api\",'[data-bs-toggle=\"tab\"], [data-bs-toggle=\"pill\"], [data-bs-toggle=\"list\"]',(function(t){[\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),g(this)||Ut.getOrCreateInstance(this).show()})),y(Ut);const Kt={animation:\"boolean\",autohide:\"boolean\",delay:\"number\"},Vt={animation:!0,autohide:!0,delay:5e3};class Qt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners()}static get DefaultType(){return Kt}static get Default(){return Vt}static get NAME(){return\"toast\"}show(){B.trigger(this._element,\"show.bs.toast\").defaultPrevented||(this._clearTimeout(),this._config.animation&&this._element.classList.add(\"fade\"),this._element.classList.remove(\"hide\"),m(this._element),this._element.classList.add(\"showing\"),this._queueCallback(()=>{this._element.classList.remove(\"showing\"),this._element.classList.add(\"show\"),B.trigger(this._element,\"shown.bs.toast\"),this._maybeScheduleHide()},this._element,this._config.animation))}hide(){this._element.classList.contains(\"show\")&&(B.trigger(this._element,\"hide.bs.toast\").defaultPrevented||(this._element.classList.remove(\"show\"),this._queueCallback(()=>{this._element.classList.add(\"hide\"),B.trigger(this._element,\"hidden.bs.toast\")},this._element,this._config.animation)))}dispose(){this._clearTimeout(),this._element.classList.contains(\"show\")&&this._element.classList.remove(\"show\"),super.dispose()}_getConfig(t){return t={...Vt,...V.getDataAttributes(this._element),...\"object\"==typeof t&&t?t:{}},d(\"toast\",t,this.constructor.DefaultType),t}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout(()=>{this.hide()},this._config.delay)))}_onInteraction(t,e){switch(t.type){case\"mouseover\":case\"mouseout\":this._hasMouseInteraction=e;break;case\"focusin\":case\"focusout\":this._hasKeyboardInteraction=e}if(e)return void this._clearTimeout();const s=t.relatedTarget;this._element===s||this._element.contains(s)||this._maybeScheduleHide()}_setListeners(){B.on(this._element,\"click.dismiss.bs.toast\",'[data-bs-dismiss=\"toast\"]',()=>this.hide()),B.on(this._element,\"mouseover.bs.toast\",t=>this._onInteraction(t,!0)),B.on(this._element,\"mouseout.bs.toast\",t=>this._onInteraction(t,!1)),B.on(this._element,\"focusin.bs.toast\",t=>this._onInteraction(t,!0)),B.on(this._element,\"focusout.bs.toast\",t=>this._onInteraction(t,!1))}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null}static jQueryInterface(t){return this.each((function(){const e=Qt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t](this)}}))}}return y(Qt),{Alert:z,Button:F,Carousel:et,Collapse:nt,Dropdown:pt,Modal:wt,Offcanvas:Tt,Popover:Wt,ScrollSpy:Ft,Tab:Ut,Toast:Qt,Tooltip:jt}}));\n//# sourceMappingURL=bootstrap.min.js.map\n","Mageplaza_Core/js/jquery.autocomplete.min.js":"/**\r\n *  Ajax Autocomplete for jQuery, version 1.3.0\r\n *  (c) 2017 Tomas Kirda\r\n *\r\n *  Ajax Autocomplete for jQuery is freely distributable under the terms of an MIT-style license.\r\n *  For details, see the web site: https://github.com/devbridge/jQuery-Autocomplete\r\n */\r\n!function(a){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],a):a(\"object\"==typeof exports&&\"function\"==typeof require?require(\"jquery\"):jQuery)}(function(a){\"use strict\";function b(c,d){var e=a.noop,f=this,g={ajaxSettings:{},autoSelectFirst:!1,appendTo:document.body,serviceUrl:null,lookup:null,onSelect:null,width:\"auto\",minChars:1,maxHeight:300,deferRequestBy:0,params:{},formatResult:b.formatResult,formatGroup:b.formatGroup,delimiter:null,zIndex:9999,type:\"GET\",noCache:!1,onSearchStart:e,onSearchComplete:e,onSearchError:e,preserveInput:!1,containerClass:\"autocomplete-suggestions\",tabDisabled:!1,dataType:\"text\",currentRequest:null,triggerSelectOnValidInput:!0,preventBadQueries:!0,lookupFilter:function(a,b,c){return-1!==a.value.toLowerCase().indexOf(c)},paramName:\"query\",transformResult:function(b){return\"string\"==typeof b?a.parseJSON(b):b},showNoSuggestionNotice:!1,noSuggestionNotice:\"No results\",orientation:\"bottom\",forceFixPosition:!1};f.element=c,f.el=a(c),f.suggestions=[],f.badQueries=[],f.selectedIndex=-1,f.currentValue=f.element.value,f.intervalId=0,f.cachedResponse={},f.onChangeInterval=null,f.onChange=null,f.isLocal=!1,f.suggestionsContainer=null,f.noSuggestionsContainer=null,f.options=a.extend({},g,d),f.classes={selected:\"autocomplete-selected\",suggestion:\"autocomplete-suggestion\"},f.hint=null,f.hintValue=\"\",f.selection=null,f.initialize(),f.setOptions(d)}var c=function(){return{escapeRegExChars:function(a){return a.replace(/[|\\\\{}()[\\]^$+*?.]/g,\"\\\\$&\")},createNode:function(a){var b=document.createElement(\"div\");return b.className=a,b.style.position=\"absolute\",b.style.display=\"none\",b}}}(),d={ESC:27,TAB:9,RETURN:13,LEFT:37,UP:38,RIGHT:39,DOWN:40};b.utils=c,a.Autocomplete=b,b.formatResult=function(a,b){if(!b)return a.value;var d=\"(\"+c.escapeRegExChars(b)+\")\";return a.value.replace(new RegExp(d,\"gi\"),\"<strong>$1</strong>\").replace(/&/g,\"&amp;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\").replace(/\"/g,\"&quot;\").replace(/&lt;(\\/?strong)&gt;/g,\"<$1>\")},b.formatGroup=function(a,b){return'<div class=\"autocomplete-group\"><strong>'+b+\"</strong></div>\"},b.prototype={killerFn:null,initialize:function(){var c,d=this,e=\".\"+d.classes.suggestion,f=d.classes.selected,g=d.options;d.element.setAttribute(\"autocomplete\",\"off\"),d.killerFn=function(b){a(b.target).closest(\".\"+d.options.containerClass).length||(d.killSuggestions(),d.disableKillerFn())},d.noSuggestionsContainer=a('<div class=\"autocomplete-no-suggestion\"></div>').html(this.options.noSuggestionNotice).get(0),d.suggestionsContainer=b.utils.createNode(g.containerClass),c=a(d.suggestionsContainer),c.appendTo(g.appendTo),\"auto\"!==g.width&&c.css(\"width\",g.width),c.on(\"mouseover.autocomplete\",e,function(){d.activate(a(this).data(\"index\"))}),c.on(\"mouseout.autocomplete\",function(){d.selectedIndex=-1,c.children(\".\"+f).removeClass(f)}),c.on(\"click.autocomplete\",e,function(){return d.select(a(this).data(\"index\")),!1}),d.fixPositionCapture=function(){d.visible&&d.fixPosition()},a(window).on(\"resize.autocomplete\",d.fixPositionCapture),d.el.on(\"keydown.autocomplete\",function(a){d.onKeyPress(a)}),d.el.on(\"keyup.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"blur.autocomplete\",function(){d.onBlur()}),d.el.on(\"focus.autocomplete\",function(){d.onFocus()}),d.el.on(\"change.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"input.autocomplete\",function(a){d.onKeyUp(a)})},onFocus:function(){var a=this;a.fixPosition(),a.el.val().length>=a.options.minChars&&a.onValueChange()},onBlur:function(){this.enableKillerFn()},abortAjax:function(){var a=this;a.currentRequest&&(a.currentRequest.abort(),a.currentRequest=null)},setOptions:function(b){var c=this,d=c.options;a.extend(d,b),c.isLocal=a.isArray(d.lookup),c.isLocal&&(d.lookup=c.verifySuggestionsFormat(d.lookup)),d.orientation=c.validateOrientation(d.orientation,\"bottom\"),a(c.suggestionsContainer).css({\"max-height\":d.maxHeight+\"px\",width:d.width+\"px\",\"z-index\":d.zIndex})},clearCache:function(){this.cachedResponse={},this.badQueries=[]},clear:function(){this.clearCache(),this.currentValue=\"\",this.suggestions=[]},disable:function(){var a=this;a.disabled=!0,clearInterval(a.onChangeInterval),a.abortAjax()},enable:function(){this.disabled=!1},fixPosition:function(){var b=this,c=a(b.suggestionsContainer),d=c.parent().get(0);if(d===document.body||b.options.forceFixPosition){var e=b.options.orientation,f=c.outerHeight(),g=b.el.outerHeight(),h=b.el.offset(),i={top:h.top,left:h.left};if(\"auto\"===e){var j=a(window).height(),k=a(window).scrollTop(),l=-k+h.top-f,m=k+j-(h.top+g+f);e=Math.max(l,m)===l?\"top\":\"bottom\"}if(\"top\"===e?i.top+=-f:i.top+=g,d!==document.body){var n,o=c.css(\"opacity\");b.visible||c.css(\"opacity\",0).show(),n=c.offsetParent().offset(),i.top-=n.top,i.left-=n.left,b.visible||c.css(\"opacity\",o).hide()}\"auto\"===b.options.width&&(i.width=b.el.outerWidth()+\"px\"),c.css(i)}},enableKillerFn:function(){var b=this;a(document).on(\"click.autocomplete\",b.killerFn)},disableKillerFn:function(){var b=this;a(document).off(\"click.autocomplete\",b.killerFn)},killSuggestions:function(){var a=this;a.stopKillSuggestions(),a.intervalId=window.setInterval(function(){a.visible&&(a.options.preserveInput||a.el.val(a.currentValue),a.hide()),a.stopKillSuggestions()},50)},stopKillSuggestions:function(){window.clearInterval(this.intervalId)},isCursorAtEnd:function(){var a,b=this,c=b.el.val().length,d=b.element.selectionStart;return\"number\"==typeof d?d===c:document.selection?(a=document.selection.createRange(),a.moveStart(\"character\",-c),c===a.text.length):!0},onKeyPress:function(a){var b=this;if(!b.disabled&&!b.visible&&a.which===d.DOWN&&b.currentValue)return void b.suggest();if(!b.disabled&&b.visible){switch(a.which){case d.ESC:b.el.val(b.currentValue),b.hide();break;case d.RIGHT:if(b.hint&&b.options.onHint&&b.isCursorAtEnd()){b.selectHint();break}return;case d.TAB:if(b.hint&&b.options.onHint)return void b.selectHint();if(-1===b.selectedIndex)return void b.hide();if(b.select(b.selectedIndex),b.options.tabDisabled===!1)return;break;case d.RETURN:if(-1===b.selectedIndex)return void b.hide();b.select(b.selectedIndex);break;case d.UP:b.moveUp();break;case d.DOWN:b.moveDown();break;default:return}a.stopImmediatePropagation(),a.preventDefault()}},onKeyUp:function(a){var b=this;if(!b.disabled){switch(a.which){case d.UP:case d.DOWN:return}clearInterval(b.onChangeInterval),b.currentValue!==b.el.val()&&(b.findBestHint(),b.options.deferRequestBy>0?b.onChangeInterval=setInterval(function(){b.onValueChange()},b.options.deferRequestBy):b.onValueChange())}},onValueChange:function(){var b=this,c=b.options,d=b.el.val(),e=b.getQuery(d);return b.selection&&b.currentValue!==e&&(b.selection=null,(c.onInvalidateSelection||a.noop).call(b.element)),clearInterval(b.onChangeInterval),b.currentValue=d,b.selectedIndex=-1,c.triggerSelectOnValidInput&&b.isExactMatch(e)?void b.select(0):void(e.length<c.minChars?b.hide():b.getSuggestions(e))},isExactMatch:function(a){var b=this.suggestions;return 1===b.length&&b[0].value.toLowerCase()===a.toLowerCase()},getQuery:function(b){var c,d=this.options.delimiter;return d?(c=b.split(d),a.trim(c[c.length-1])):b},getSuggestionsLocal:function(b){var c,d=this,e=d.options,f=b.toLowerCase(),g=e.lookupFilter,h=parseInt(e.lookupLimit,10);return c={suggestions:a.grep(e.lookup,function(a){return g(a,b,f)})},h&&c.suggestions.length>h&&(c.suggestions=c.suggestions.slice(0,h)),c},getSuggestions:function(b){var c,d,e,f,g=this,h=g.options,i=h.serviceUrl;if(h.params[h.paramName]=b,d=h.ignoreParams?null:h.params,h.onSearchStart.call(g.element,h.params)!==!1){if(a.isFunction(h.lookup))return void h.lookup(b,function(a){g.suggestions=a.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,a.suggestions)});g.isLocal?c=g.getSuggestionsLocal(b):(a.isFunction(i)&&(i=i.call(g.element,b)),e=i+\"?\"+a.param(d||{}),c=g.cachedResponse[e]),c&&a.isArray(c.suggestions)?(g.suggestions=c.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,c.suggestions)):g.isBadQuery(b)?h.onSearchComplete.call(g.element,b,[]):(g.abortAjax(),f={url:i,data:d,type:h.type,dataType:h.dataType},a.extend(f,h.ajaxSettings),g.currentRequest=a.ajax(f).done(function(a){var c;g.currentRequest=null,c=h.transformResult(a,b),g.processResponse(c,b,e),h.onSearchComplete.call(g.element,b,c.suggestions)}).fail(function(a,c,d){h.onSearchError.call(g.element,b,a,c,d)}))}},isBadQuery:function(a){if(!this.options.preventBadQueries)return!1;for(var b=this.badQueries,c=b.length;c--;)if(0===a.indexOf(b[c]))return!0;return!1},hide:function(){var b=this,c=a(b.suggestionsContainer);a.isFunction(b.options.onHide)&&b.visible&&b.options.onHide.call(b.element,c),b.visible=!1,b.selectedIndex=-1,clearInterval(b.onChangeInterval),a(b.suggestionsContainer).hide(),b.signalHint(null)},suggest:function(){if(!this.suggestions.length)return void(this.options.showNoSuggestionNotice?this.noSuggestions():this.hide());var b,c=this,d=c.options,e=d.groupBy,f=d.formatResult,g=c.getQuery(c.currentValue),h=c.classes.suggestion,i=c.classes.selected,j=a(c.suggestionsContainer),k=a(c.noSuggestionsContainer),l=d.beforeRender,m=\"\",n=function(a,c){var f=a.data[e];return b===f?\"\":(b=f,d.formatGroup(a,b))};return d.triggerSelectOnValidInput&&c.isExactMatch(g)?void c.select(0):(a.each(c.suggestions,function(a,b){e&&(m+=n(b,g,a)),m+='<div class=\"'+h+'\" data-index=\"'+a+'\">'+f(b,g,a)+\"</div>\"}),this.adjustContainerWidth(),k.detach(),j.html(m),a.isFunction(l)&&l.call(c.element,j,c.suggestions),c.fixPosition(),j.show(),d.autoSelectFirst&&(c.selectedIndex=0,j.scrollTop(0),j.children(\".\"+h).first().addClass(i)),c.visible=!0,void c.findBestHint())},noSuggestions:function(){var b=this,c=a(b.suggestionsContainer),d=a(b.noSuggestionsContainer);this.adjustContainerWidth(),d.detach(),c.empty(),c.append(d),b.fixPosition(),c.show(),b.visible=!0},adjustContainerWidth:function(){var b,c=this,d=c.options,e=a(c.suggestionsContainer);\"auto\"===d.width?(b=c.el.outerWidth(),e.css(\"width\",b>0?b:300)):\"flex\"===d.width&&e.css(\"width\",\"\")},findBestHint:function(){var b=this,c=b.el.val().toLowerCase(),d=null;c&&(a.each(b.suggestions,function(a,b){var e=0===b.value.toLowerCase().indexOf(c);return e&&(d=b),!e}),b.signalHint(d))},signalHint:function(b){var c=\"\",d=this;b&&(c=d.currentValue+b.value.substr(d.currentValue.length)),d.hintValue!==c&&(d.hintValue=c,d.hint=b,(this.options.onHint||a.noop)(c))},verifySuggestionsFormat:function(b){return b.length&&\"string\"==typeof b[0]?a.map(b,function(a){return{value:a,data:null}}):b},validateOrientation:function(b,c){return b=a.trim(b||\"\").toLowerCase(),-1===a.inArray(b,[\"auto\",\"bottom\",\"top\"])&&(b=c),b},processResponse:function(a,b,c){var d=this,e=d.options;a.suggestions=d.verifySuggestionsFormat(a.suggestions),e.noCache||(d.cachedResponse[c]=a,e.preventBadQueries&&!a.suggestions.length&&d.badQueries.push(b)),b===d.getQuery(d.currentValue)&&(d.suggestions=a.suggestions,d.suggest())},activate:function(b){var c,d=this,e=d.classes.selected,f=a(d.suggestionsContainer),g=f.find(\".\"+d.classes.suggestion);return f.find(\".\"+e).removeClass(e),d.selectedIndex=b,-1!==d.selectedIndex&&g.length>d.selectedIndex?(c=g.get(d.selectedIndex),a(c).addClass(e),c):null},selectHint:function(){var b=this,c=a.inArray(b.hint,b.suggestions);b.select(c)},select:function(a){var b=this;b.hide(),b.onSelect(a),b.disableKillerFn()},moveUp:function(){var b=this;if(-1!==b.selectedIndex)return 0===b.selectedIndex?(a(b.suggestionsContainer).children().first().removeClass(b.classes.selected),b.selectedIndex=-1,b.el.val(b.currentValue),void b.findBestHint()):void b.adjustScroll(b.selectedIndex-1)},moveDown:function(){var a=this;a.selectedIndex!==a.suggestions.length-1&&a.adjustScroll(a.selectedIndex+1)},adjustScroll:function(b){var c=this,d=c.activate(b);if(d){var e,f,g,h=a(d).outerHeight();e=d.offsetTop,f=a(c.suggestionsContainer).scrollTop(),g=f+c.options.maxHeight-h,f>e?a(c.suggestionsContainer).scrollTop(e):e>g&&a(c.suggestionsContainer).scrollTop(e-c.options.maxHeight+h),c.options.preserveInput||c.el.val(c.getValue(c.suggestions[b].value)),c.signalHint(null)}},onSelect:function(b){var c=this,d=c.options.onSelect,e=c.suggestions[b];c.currentValue=c.getValue(e.value),c.currentValue===c.el.val()||c.options.preserveInput||c.el.val(c.currentValue),c.signalHint(null),c.suggestions=[],c.selection=e,a.isFunction(d)&&d.call(c.element,e)},getValue:function(a){var b,c,d=this,e=d.options.delimiter;return e?(b=d.currentValue,c=b.split(e),1===c.length?a:b.substr(0,b.length-c[c.length-1].length)+a):a},dispose:function(){var b=this;b.el.off(\".autocomplete\").removeData(\"autocomplete\"),b.disableKillerFn(),a(window).off(\"resize.autocomplete\",b.fixPositionCapture),a(b.suggestionsContainer).remove()}},a.fn.autocomplete=a.fn.devbridgeAutocomplete=function(c,d){var e=\"autocomplete\";return arguments.length?this.each(function(){var f=a(this),g=f.data(e);\"string\"==typeof c?g&&\"function\"==typeof g[c]&&g[c](d):(g&&g.dispose&&g.dispose(),g=new b(this,c),f.data(e,g))}):this.first().data(e)}});","Mageplaza_Core/js/owl.carousel.min.js":"/**\r\n * Owl Carousel v2.3.4\r\n * Copyright 2013-2018 David Deutsch\r\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\r\n */\r\n!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:[\"busy\"],animating:[\"busy\"],dragging:[\"interacting\"]}},a.each([\"onResize\",\"onThrottledResize\"],a.proxy(function(b,c){this._handlers[c]=a.proxy(this[c],this)},this)),a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a.charAt(0).toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Workers,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}e.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,fallbackEasing:\"swing\",slideTransition:\"\",info:!1,nestedItemSelector:!1,itemElement:\"div\",stageElement:\"div\",refreshClass:\"owl-refresh\",loadedClass:\"owl-loaded\",loadingClass:\"owl-loading\",rtlClass:\"owl-rtl\",responsiveClass:\"owl-responsive\",dragClass:\"owl-drag\",itemClass:\"owl-item\",stageClass:\"owl-stage\",stageOuterClass:\"owl-stage-outer\",grabClass:\"owl-grab\"},e.Width={Default:\"default\",Inner:\"inner\",Outer:\"outer\"},e.Type={Event:\"event\",State:\"state\"},e.Plugins={},e.Workers=[{filter:[\"width\",\"settings\"],run:function(){this._width=this.$element.width()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:[\"items\",\"settings\"],run:function(){this.$stage.children(\".cloned\").remove()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this.settings.margin||\"\",c=!this.settings.autoWidth,d=this.settings.rtl,e={width:\"auto\",\"margin-left\":d?b:\"\",\"margin-right\":d?\"\":b};!c&&this.$stage.children().css(e),a.css=e}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,c=null,d=this._items.length,e=!this.settings.autoWidth,f=[];for(a.items={merge:!1,width:b};d--;)c=this._mergers[d],c=this.settings.mergeFit&&Math.min(c,this.settings.items)||c,a.items.merge=c>1||a.items.merge,f[d]=e?b*c:this._items[d].width();this._widths=f}},{filter:[\"items\",\"settings\"],run:function(){var b=[],c=this._items,d=this.settings,e=Math.max(2*d.items,4),f=2*Math.ceil(c.length/2),g=d.loop&&c.length?d.rewind?e:Math.max(e,f):0,h=\"\",i=\"\";for(g/=2;g>0;)b.push(this.normalize(b.length/2,!0)),h+=c[b[b.length-1]][0].outerHTML,b.push(this.normalize(c.length-1-(b.length-1)/2,!0)),i=c[b[b.length-1]][0].outerHTML+i,g-=1;this._clones=b,a(h).addClass(\"cloned\").appendTo(this.$stage),a(i).addClass(\"cloned\").prependTo(this.$stage)}},{filter:[\"width\",\"items\",\"settings\"],run:function(){for(var a=this.settings.rtl?1:-1,b=this._clones.length+this._items.length,c=-1,d=0,e=0,f=[];++c<b;)d=f[c-1]||0,e=this._widths[this.relative(c)]+this.settings.margin,f.push(d+e*a);this._coordinates=f}},{filter:[\"width\",\"items\",\"settings\"],run:function(){var a=this.settings.stagePadding,b=this._coordinates,c={width:Math.ceil(Math.abs(b[b.length-1]))+2*a,\"padding-left\":a||\"\",\"padding-right\":a||\"\"};this.$stage.css(c)}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this._coordinates.length,c=!this.settings.autoWidth,d=this.$stage.children();if(c&&a.items.merge)for(;b--;)a.css.width=this._widths[this.relative(b)],d.eq(b).css(a.css);else c&&(a.css.width=a.items.width,d.css(a.css))}},{filter:[\"items\"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr(\"style\")}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=a.current?this.$stage.children().index(a.current):0,a.current=Math.max(this.minimum(),Math.min(this.maximum(),a.current)),this.reset(a.current)}},{filter:[\"position\"],run:function(){this.animate(this.coordinates(this._current))}},{filter:[\"width\",\"position\",\"items\",\"settings\"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;c<d;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,\"<=\",g)&&this.op(a,\">\",h)||this.op(b,\"<\",g)&&this.op(b,\">\",h))&&i.push(c);this.$stage.children(\".active\").removeClass(\"active\"),this.$stage.children(\":eq(\"+i.join(\"), :eq(\")+\")\").addClass(\"active\"),this.$stage.children(\".center\").removeClass(\"center\"),this.settings.center&&this.$stage.children().eq(this.current()).addClass(\"center\")}}],e.prototype.initializeStage=function(){this.$stage=this.$element.find(\".\"+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=a(\"<\"+this.settings.stageElement+\">\",{class:this.settings.stageClass}).wrap(a(\"<div/>\",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},e.prototype.initializeItems=function(){var b=this.$element.find(\".owl-item\");if(b.length)return this._items=b.get().map(function(b){return a(b)}),this._mergers=this._items.map(function(){return 1}),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate(\"width\"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},e.prototype.initialize=function(){if(this.enter(\"initializing\"),this.trigger(\"initialize\"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is(\"pre-loading\")){var a,b,c;a=this.$element.find(\"img\"),b=this.settings.nestedItemSelector?\".\"+this.settings.nestedItemSelector:d,c=this.$element.children(b).width(),a.length&&c<=0&&this.preloadAutoWidthImages(a)}this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave(\"initializing\"),this.trigger(\"initialized\")},e.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(\":visible\")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){a<=b&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),\"function\"==typeof e.stagePadding&&(e.stagePadding=e.stagePadding()),delete e.responsive,e.responsiveClass&&this.$element.attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(\"(\"+this.options.responsiveClass+\"-)\\\\S+\\\\s\",\"g\"),\"$1\"+d))):e=a.extend({},this.options),this.trigger(\"change\",{property:{name:\"settings\",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate(\"settings\"),this.trigger(\"changed\",{property:{name:\"settings\",value:this.settings}})},e.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger(\"prepare\",{content:b});return c.data||(c.data=a(\"<\"+this.settings.itemElement+\"/>\").addClass(this.options.itemClass).append(b)),this.trigger(\"prepared\",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};b<c;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={},!this.is(\"valid\")&&this.enter(\"valid\")},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){this.enter(\"refreshing\"),this.trigger(\"refresh\"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave(\"refreshing\"),this.trigger(\"refreshed\")},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter(\"resizing\"),this.trigger(\"resize\").isDefaultPrevented()?(this.leave(\"resizing\"),!1):(this.invalidate(\"width\"),this.refresh(),this.leave(\"resizing\"),void this.trigger(\"resized\")))))},e.prototype.registerEventHandlers=function(){a.support.transition&&this.$stage.on(a.support.transition.end+\".owl.core\",a.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(b,\"resize\",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on(\"mousedown.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"dragstart.owl.core selectstart.owl.core\",function(){return!1})),this.settings.touchDrag&&(this.$stage.on(\"touchstart.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"touchcancel.owl.core\",a.proxy(this.onDragEnd,this)))},e.prototype.onDragStart=function(b){var d=null;3!==b.which&&(a.support.transform?(d=this.$stage.css(\"transform\").replace(/.*\\(|\\)| /g,\"\").split(\",\"),d={x:d[16===d.length?12:4],y:d[16===d.length?13:5]}):(d=this.$stage.position(),d={x:this.settings.rtl?d.left+this.$stage.width()-this.width()+this.settings.margin:d.left,y:d.top}),this.is(\"animating\")&&(a.support.transform?this.animate(d.x):this.$stage.stop(),this.invalidate(\"position\")),this.$element.toggleClass(this.options.grabClass,\"mousedown\"===b.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=a(b.target),this._drag.stage.start=d,this._drag.stage.current=d,this._drag.pointer=this.pointer(b),a(c).on(\"mouseup.owl.core touchend.owl.core\",a.proxy(this.onDragEnd,this)),a(c).one(\"mousemove.owl.core touchmove.owl.core\",a.proxy(function(b){var d=this.difference(this._drag.pointer,this.pointer(b));a(c).on(\"mousemove.owl.core touchmove.owl.core\",a.proxy(this.onDragMove,this)),Math.abs(d.x)<Math.abs(d.y)&&this.is(\"valid\")||(b.preventDefault(),this.enter(\"dragging\"),this.trigger(\"drag\"))},this)))},e.prototype.onDragMove=function(a){var b=null,c=null,d=null,e=this.difference(this._drag.pointer,this.pointer(a)),f=this.difference(this._drag.stage.start,e);this.is(\"dragging\")&&(a.preventDefault(),this.settings.loop?(b=this.coordinates(this.minimum()),c=this.coordinates(this.maximum()+1)-b,f.x=((f.x-b)%c+c)%c+b):(b=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),c=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),d=this.settings.pullDrag?-1*e.x/5:0,f.x=Math.max(Math.min(f.x,b+d),c+d)),this._drag.stage.current=f,this.animate(f.x))},e.prototype.onDragEnd=function(b){var d=this.difference(this._drag.pointer,this.pointer(b)),e=this._drag.stage.current,f=d.x>0^this.settings.rtl?\"left\":\"right\";a(c).off(\".owl.core\"),this.$element.removeClass(this.options.grabClass),(0!==d.x&&this.is(\"dragging\")||!this.is(\"valid\"))&&(this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(e.x,0!==d.x?f:this._drag.direction)),this.invalidate(\"position\"),this.update(),this._drag.direction=f,(Math.abs(d.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one(\"click.owl.core\",function(){return!1})),this.is(\"dragging\")&&(this.leave(\"dragging\"),this.trigger(\"dragged\"))},e.prototype.closest=function(b,c){var e=-1,f=30,g=this.width(),h=this.coordinates();return this.settings.freeDrag||a.each(h,a.proxy(function(a,i){return\"left\"===c&&b>i-f&&b<i+f?e=a:\"right\"===c&&b>i-g-f&&b<i-g+f?e=a+1:this.op(b,\"<\",i)&&this.op(b,\">\",h[a+1]!==d?h[a+1]:i-g)&&(e=\"left\"===c?a+1:a),-1===e},this)),this.settings.loop||(this.op(b,\">\",h[this.minimum()])?e=b=this.minimum():this.op(b,\"<\",h[this.maximum()])&&(e=b=this.maximum())),e},e.prototype.animate=function(b){var c=this.speed()>0;this.is(\"animating\")&&this.onTransitionEnd(),c&&(this.enter(\"animating\"),this.trigger(\"translate\")),a.support.transform3d&&a.support.transition?this.$stage.css({transform:\"translate3d(\"+b+\"px,0px,0px)\",transition:this.speed()/1e3+\"s\"+(this.settings.slideTransition?\" \"+this.settings.slideTransition:\"\")}):c?this.$stage.animate({left:b+\"px\"},this.speed(),this.settings.fallbackEasing,a.proxy(this.onTransitionEnd,this)):this.$stage.css({left:b+\"px\"})},e.prototype.is=function(a){return this._states.current[a]&&this._states.current[a]>0},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger(\"change\",{property:{name:\"position\",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate(\"position\"),this.trigger(\"changed\",{property:{name:\"position\",value:this._current}})}return this._current},e.prototype.invalidate=function(b){return\"string\"===a.type(b)&&(this._invalidated[b]=!0,this.is(\"valid\")&&this.leave(\"valid\")),a.map(this._invalidated,function(a,b){return b})},e.prototype.reset=function(a){(a=this.normalize(a))!==d&&(this._speed=0,this._current=a,this.suppress([\"translate\",\"translated\"]),this.animate(this.coordinates(a)),this.release([\"translate\",\"translated\"]))},e.prototype.normalize=function(a,b){var c=this._items.length,e=b?0:this._clones.length;return!this.isNumeric(a)||c<1?a=d:(a<0||a>=c+e)&&(a=((a-e/2)%c+c)%c+e/2),a},e.prototype.relative=function(a){return a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=this.settings,f=this._coordinates.length;if(e.loop)f=this._clones.length/2+this._items.length-1;else if(e.autoWidth||e.merge){if(b=this._items.length)for(c=this._items[--b].width(),d=this.$element.width();b--&&!((c+=this._items[b].width()+this.settings.margin)>d););f=b+1}else f=e.center?this._items.length-1:this._items.length-e.items;return a&&(f-=this._clones.length/2),Math.max(f,0)},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2==0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c,e=1,f=b-1;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(this.settings.rtl&&(e=-1,f=b+1),c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[f]||0))/2*e):c=this._coordinates[f]||0,c=Math.ceil(c))},e.prototype.duration=function(a,b,c){return 0===c?0:Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(a,b){var c=this.current(),d=null,e=a-this.relative(c),f=(e>0)-(e<0),g=this._items.length,h=this.minimum(),i=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(e)>g/2&&(e+=-1*f*g),a=c+e,(d=((a-h)%g+g)%g+h)!==a&&d-e<=i&&d-e>0&&(c=d-e,a=d,this.reset(c))):this.settings.rewind?(i+=1,a=(a%i+i)%i):a=Math.max(h,Math.min(i,a)),this.speed(this.duration(c,a,b)),this.current(a),this.isVisible()&&this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.onTransitionEnd=function(a){if(a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0)))return!1;this.leave(\"animating\"),this.trigger(\"translated\")},e.prototype.viewport=function(){var d;return this.options.responsiveBaseElement!==b?d=a(this.options.responsiveBaseElement).width():b.innerWidth?d=b.innerWidth:c.documentElement&&c.documentElement.clientWidth?d=c.documentElement.clientWidth:console.warn(\"Can not detect viewport width.\"),d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find(\".\"+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)},this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate(\"items\")},e.prototype.add=function(b,c){var e=this.relative(this._current);c=c===d?this._items.length:this.normalize(c,!0),b=b instanceof jQuery?b:a(b),this.trigger(\"add\",{content:b,position:c}),b=this.prepare(b),0===this._items.length||c===this._items.length?(0===this._items.length&&this.$stage.append(b),0!==this._items.length&&this._items[c-1].after(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)):(this._items[c].before(b),this._items.splice(c,0,b),this._mergers.splice(c,0,1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)),this._items[e]&&this.reset(this._items[e].index()),this.invalidate(\"items\"),this.trigger(\"added\",{content:b,position:c})},e.prototype.remove=function(a){(a=this.normalize(a,!0))!==d&&(this.trigger(\"remove\",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate(\"items\"),this.trigger(\"removed\",{content:null,position:a}))},e.prototype.preloadAutoWidthImages=function(b){b.each(a.proxy(function(b,c){this.enter(\"pre-loading\"),c=a(c),a(new Image).one(\"load\",a.proxy(function(a){c.attr(\"src\",a.target.src),c.css(\"opacity\",1),this.leave(\"pre-loading\"),!this.is(\"pre-loading\")&&!this.is(\"initializing\")&&this.refresh()},this)).attr(\"src\",c.attr(\"src\")||c.attr(\"data-src\")||c.attr(\"data-src-retina\"))},this))},e.prototype.destroy=function(){this.$element.off(\".owl.core\"),this.$stage.off(\".owl.core\"),a(c).off(\".owl.core\"),!1!==this.settings.responsive&&(b.clearTimeout(this.resizeTimer),this.off(b,\"resize\",this._handlers.onThrottledResize));for(var d in this._plugins)this._plugins[d].destroy();this.$stage.children(\".cloned\").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(this.options.responsiveClass+\"-\\\\S+\\\\s\",\"g\"),\"\")).removeData(\"owl.carousel\")},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case\"<\":return d?a>c:a<c;case\">\":return d?a<c:a>c;case\">=\":return d?a<=c:a>=c;case\"<=\":return d?a>=c:a<=c}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent(\"on\"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent(\"on\"+b,c)},e.prototype.trigger=function(b,c,d,f,g){var h={item:{count:this._items.length,index:this.current()}},i=a.camelCase(a.grep([\"on\",b,d],function(a){return a}).join(\"-\").toLowerCase()),j=a.Event([b,\"owl\",d||\"carousel\"].join(\".\").toLowerCase(),a.extend({relatedTarget:this},h,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(j)}),this.register({type:e.Type.Event,name:b}),this.$element.trigger(j),this.settings&&\"function\"==typeof this.settings[i]&&this.settings[i].call(this,j)),j},e.prototype.enter=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]===d&&(this._states.current[b]=0),this._states.current[b]++},this))},e.prototype.leave=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]--},this))},e.prototype.register=function(b){if(b.type===e.Type.Event){if(a.event.special[b.name]||(a.event.special[b.name]={}),!a.event.special[b.name].owl){var c=a.event.special[b.name]._default;a.event.special[b.name]._default=function(a){return!c||!c.apply||a.namespace&&-1!==a.namespace.indexOf(\"owl\")?a.namespace&&a.namespace.indexOf(\"owl\")>-1:c.apply(this,arguments)},a.event.special[b.name].owl=!0}}else b.type===e.Type.State&&(this._states.tags[b.name]?this._states.tags[b.name]=this._states.tags[b.name].concat(b.tags):this._states.tags[b.name]=b.tags,this._states.tags[b.name]=a.grep(this._states.tags[b.name],a.proxy(function(c,d){return a.inArray(c,this._states.tags[b.name])===d},this)))},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.pointer=function(a){var c={x:null,y:null};return a=a.originalEvent||a||b.event,a=a.touches&&a.touches.length?a.touches[0]:a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:a,a.pageX?(c.x=a.pageX,c.y=a.pageY):(c.x=a.clientX,c.y=a.clientY),c},e.prototype.isNumeric=function(a){return!isNaN(parseFloat(a))},e.prototype.difference=function(a,b){return{x:a.x-b.x,y:a.y-b.y}},a.fn.owlCarousel=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){var d=a(this),f=d.data(\"owl.carousel\");f||(f=new e(this,\"object\"==typeof b&&b),d.data(\"owl.carousel\",f),a.each([\"next\",\"prev\",\"to\",\"destroy\",\"refresh\",\"replace\",\"add\",\"remove\"],function(b,c){f.register({type:e.Type.Event,name:c}),f.$element.on(c+\".owl.carousel.core\",a.proxy(function(a){a.namespace&&a.relatedTarget!==this&&(this.suppress([c]),f[c].apply(this,[].slice.call(arguments,1)),this.release([c]))},f))})),\"string\"==typeof b&&\"_\"!==b.charAt(0)&&f[b].apply(f,c)})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._interval=null,this._visible=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoRefresh&&this.watch()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={autoRefresh:!0,autoRefreshInterval:500},e.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=b.setInterval(a.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},e.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass(\"owl-hidden\",!this._visible),this._visible&&this._core.invalidate(\"width\")&&this._core.refresh())},e.prototype.destroy=function(){var a,c;b.clearInterval(this._interval);for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoRefresh=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._loaded=[],this._handlers={\"initialized.owl.carousel change.owl.carousel resized.owl.carousel\":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&\"position\"==b.property.name||\"initialized\"==b.type)){var c=this._core.settings,e=c.center&&Math.ceil(c.items/2)||c.items,f=c.center&&-1*e||0,g=(b.property&&b.property.value!==d?b.property.value:this._core.current())+f,h=this._core.clones().length,i=a.proxy(function(a,b){this.load(b)},this);for(c.lazyLoadEager>0&&(e+=c.lazyLoadEager,c.loop&&(g-=c.lazyLoadEager,e++));f++<e;)this.load(h/2+this._core.relative(g)),h&&a.each(this._core.clones(this._core.relative(g)),i),g++}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={lazyLoad:!1,lazyLoadEager:0},e.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(\".owl-lazy\");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr(\"data-src-retina\")||f.attr(\"data-src\")||f.attr(\"data-srcset\");this._core.trigger(\"load\",{element:f,url:g},\"lazy\"),f.is(\"img\")?f.one(\"load.owl.lazy\",a.proxy(function(){f.css(\"opacity\",1),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"src\",g):f.is(\"source\")?f.one(\"load.owl.lazy\",a.proxy(function(){this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"srcset\",g):(e=new Image,e.onload=a.proxy(function(){f.css({\"background-image\":'url(\"'+g+'\")',opacity:\"1\"}),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(c){this._core=c,this._previousHeight=null,this._handlers={\"initialized.owl.carousel refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&this.update()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&\"position\"===a.property.name&&this.update()},this),\"loaded.owl.lazy\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&a.element.closest(\".\"+this._core.settings.itemClass).index()===this._core.current()&&this.update()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var d=this;a(b).on(\"load\",function(){d._core.settings.autoHeight&&d.update()}),a(b).resize(function(){d._core.settings.autoHeight&&(null!=d._intervalId&&clearTimeout(d._intervalId),d._intervalId=setTimeout(function(){d.update()},250))})};e.Defaults={autoHeight:!1,autoHeightClass:\"owl-height\"},e.prototype.update=function(){var b=this._core._current,c=b+this._core.settings.items,d=this._core.settings.lazyLoad,e=this._core.$stage.children().toArray().slice(b,c),f=[],g=0;a.each(e,function(b,c){f.push(a(c).height())}),g=Math.max.apply(null,f),g<=1&&d&&this._previousHeight&&(g=this._previousHeight),this._previousHeight=g,this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass)},e.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._videos={},this._playing=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.register({type:\"state\",name:\"playing\",tags:[\"interacting\"]})},this),\"resize.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.video&&this.isInFullScreen()&&a.preventDefault()},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.is(\"resizing\")&&this._core.$stage.find(\".cloned .owl-video-frame\").remove()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"===a.property.name&&this._playing&&this.stop()},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\".owl-video\");c.length&&(c.css(\"display\",\"none\"),this.fetch(c,a(b.content)))}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on(\"click.owl.video\",\".owl-video-play-icon\",a.proxy(function(a){this.play(a)},this))};e.Defaults={video:!1,videoHeight:!1,videoWidth:!1},e.prototype.fetch=function(a,b){var c=function(){return a.attr(\"data-vimeo-id\")?\"vimeo\":a.attr(\"data-vzaar-id\")?\"vzaar\":\"youtube\"}(),d=a.attr(\"data-vimeo-id\")||a.attr(\"data-youtube-id\")||a.attr(\"data-vzaar-id\"),e=a.attr(\"data-width\")||this._core.settings.videoWidth,f=a.attr(\"data-height\")||this._core.settings.videoHeight,g=a.attr(\"href\");if(!g)throw new Error(\"Missing video URL.\");if(d=g.match(/(http:|https:|)\\/\\/(player.|www.|app.)?(vimeo\\.com|youtu(be\\.com|\\.be|be\\.googleapis\\.com|be\\-nocookie\\.com)|vzaar\\.com)\\/(video\\/|videos\\/|embed\\/|channels\\/.+\\/|groups\\/.+\\/|watch\\?v=|v\\/)?([A-Za-z0-9._%-]*)(\\&\\S+)?/),d[3].indexOf(\"youtu\")>-1)c=\"youtube\";else if(d[3].indexOf(\"vimeo\")>-1)c=\"vimeo\";else{if(!(d[3].indexOf(\"vzaar\")>-1))throw new Error(\"Video URL not supported.\");c=\"vzaar\"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr(\"data-video\",g),this.thumbnail(a,this._videos[g])},e.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?\"width:\"+c.width+\"px;height:\"+c.height+\"px;\":\"\",h=b.find(\"img\"),i=\"src\",j=\"\",k=this._core.settings,l=function(c){e='<div class=\"owl-video-play-icon\"></div>',d=k.lazyLoad?a(\"<div/>\",{class:\"owl-video-tn \"+j,srcType:c}):a(\"<div/>\",{class:\"owl-video-tn\",style:\"opacity:1;background-image:url(\"+c+\")\"}),b.after(d),b.after(e)};if(b.wrap(a(\"<div/>\",{class:\"owl-video-wrapper\",style:g})),this._core.settings.lazyLoad&&(i=\"data-src\",j=\"owl-lazy\"),h.length)return l(h.attr(i)),h.remove(),!1;\"youtube\"===c.type?(f=\"//img.youtube.com/vi/\"+c.id+\"/hqdefault.jpg\",l(f)):\"vimeo\"===c.type?a.ajax({type:\"GET\",url:\"//vimeo.com/api/v2/video/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a[0].thumbnail_large,l(f)}}):\"vzaar\"===c.type&&a.ajax({type:\"GET\",url:\"//vzaar.com/api/videos/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a.framegrab_url,l(f)}})},e.prototype.stop=function(){this._core.trigger(\"stop\",null,\"video\"),this._playing.find(\".owl-video-frame\").remove(),this._playing.removeClass(\"owl-video-playing\"),this._playing=null,this._core.leave(\"playing\"),this._core.trigger(\"stopped\",null,\"video\")},e.prototype.play=function(b){var c,d=a(b.target),e=d.closest(\".\"+this._core.settings.itemClass),f=this._videos[e.attr(\"data-video\")],g=f.width||\"100%\",h=f.height||this._core.$stage.height();this._playing||(this._core.enter(\"playing\"),this._core.trigger(\"play\",null,\"video\"),e=this._core.items(this._core.relative(e.index())),this._core.reset(e.index()),c=a('<iframe frameborder=\"0\" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'),c.attr(\"height\",h),c.attr(\"width\",g),\"youtube\"===f.type?c.attr(\"src\",\"//www.youtube.com/embed/\"+f.id+\"?autoplay=1&rel=0&v=\"+f.id):\"vimeo\"===f.type?c.attr(\"src\",\"//player.vimeo.com/video/\"+f.id+\"?autoplay=1\"):\"vzaar\"===f.type&&c.attr(\"src\",\"//view.vzaar.com/\"+f.id+\"/player?autoplay=true\"),a(c).wrap('<div class=\"owl-video-frame\" />').insertAfter(e.find(\".owl-video\")),this._playing=e.addClass(\"owl-video-playing\"))},e.prototype.isInFullScreen=function(){var b=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return b&&a(b).parent().hasClass(\"owl-video-frame\")},e.prototype.destroy=function(){var a,b;this._core.$element.off(\"click.owl.video\");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={\"change.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),\"drag.owl.carousel dragged.owl.carousel translated.owl.carousel\":a.proxy(function(a){a.namespace&&(this.swapping=\"translated\"==a.type)},this),\"translate.owl.carousel\":a.proxy(function(a){a.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,\r\nanimateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&a.support.animation&&a.support.transition){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.one(a.support.animation.end,c).css({left:b+\"px\"}).addClass(\"animated owl-animated-out\").addClass(g)),f&&e.one(a.support.animation.end,c).addClass(\"animated owl-animated-in\").addClass(f))}},e.prototype.clear=function(b){a(b.target).css({left:\"\"}).removeClass(\"animated owl-animated-out owl-animated-in\").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"settings\"===a.property.name?this._core.settings.autoplay?this.play():this.stop():a.namespace&&\"position\"===a.property.name&&this._paused&&(this._time=0)},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoplay&&this.play()},this),\"play.owl.autoplay\":a.proxy(function(a,b,c){a.namespace&&this.play(b,c)},this),\"stop.owl.autoplay\":a.proxy(function(a){a.namespace&&this.stop()},this),\"mouseover.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"mouseleave.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.play()},this),\"touchstart.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"touchend.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this.play()},this)},this._core.$element.on(this._handlers),this._core.options=a.extend({},e.Defaults,this._core.options)};e.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},e.prototype._next=function(d){this._call=b.setTimeout(a.proxy(this._next,this,d),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is(\"interacting\")||c.hidden||this._core.next(d||this._core.settings.autoplaySpeed)},e.prototype.read=function(){return(new Date).getTime()-this._time},e.prototype.play=function(c,d){var e;this._core.is(\"rotating\")||this._core.enter(\"rotating\"),c=c||this._core.settings.autoplayTimeout,e=Math.min(this._time%(this._timeout||c),c),this._paused?(this._time=this.read(),this._paused=!1):b.clearTimeout(this._call),this._time+=this.read()%c-e,this._timeout=c,this._call=b.setTimeout(a.proxy(this._next,this,d),c-e)},e.prototype.stop=function(){this._core.is(\"rotating\")&&(this._time=0,this._paused=!0,b.clearTimeout(this._call),this._core.leave(\"rotating\"))},e.prototype.pause=function(){this._core.is(\"rotating\")&&!this._paused&&(this._time=this.read(),this._paused=!0,b.clearTimeout(this._call))},e.prototype.destroy=function(){var a,b;this.stop();for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(b){this._core=b,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={\"prepared.owl.carousel\":a.proxy(function(b){b.namespace&&this._core.settings.dotsData&&this._templates.push('<div class=\"'+this._core.settings.dotClass+'\">'+a(b.content).find(\"[data-dot]\").addBack(\"[data-dot]\").attr(\"data-dot\")+\"</div>\")},this),\"added.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,0,this._templates.pop())},this),\"remove.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&this.draw()},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&!this._initialized&&(this._core.trigger(\"initialize\",null,\"navigation\"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger(\"initialized\",null,\"navigation\"))},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._initialized&&(this._core.trigger(\"refresh\",null,\"navigation\"),this.update(),this.draw(),this._core.trigger(\"refreshed\",null,\"navigation\"))},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers)};e.Defaults={nav:!1,navText:['<span aria-label=\"Previous\">&#x2039;</span>','<span aria-label=\"Next\">&#x203a;</span>'],navSpeed:!1,navElement:'button type=\"button\" role=\"presentation\"',navContainer:!1,navContainerClass:\"owl-nav\",navClass:[\"owl-prev\",\"owl-next\"],slideBy:1,dotClass:\"owl-dot\",dotsClass:\"owl-dots\",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},e.prototype.initialize=function(){var b,c=this._core.settings;this._controls.$relative=(c.navContainer?a(c.navContainer):a(\"<div>\").addClass(c.navContainerClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$previous=a(\"<\"+c.navElement+\">\").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.prev(c.navSpeed)},this)),this._controls.$next=a(\"<\"+c.navElement+\">\").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.next(c.navSpeed)},this)),c.dotsData||(this._templates=[a('<button role=\"button\">').addClass(c.dotClass).append(a(\"<span>\")).prop(\"outerHTML\")]),this._controls.$absolute=(c.dotsContainer?a(c.dotsContainer):a(\"<div>\").addClass(c.dotsClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$absolute.on(\"click\",\"button\",a.proxy(function(b){var d=a(b.target).parent().is(this._controls.$absolute)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(d,c.dotsSpeed)},this));for(b in this._overrides)this._core[b]=a.proxy(this[b],this)},e.prototype.destroy=function(){var a,b,c,d,e;e=this._core.settings;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)\"$relative\"===b&&e.navContainer?this._controls[b].html(\"\"):this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},e.prototype.update=function(){var a,b,c,d=this._core.clones().length/2,e=d+this._core.items().length,f=this._core.maximum(!0),g=this._core.settings,h=g.center||g.autoWidth||g.dotsData?1:g.dotsEach||g.items;if(\"page\"!==g.slideBy&&(g.slideBy=Math.min(g.slideBy,g.items)),g.dots||\"page\"==g.slideBy)for(this._pages=[],a=d,b=0,c=0;a<e;a++){if(b>=h||0===b){if(this._pages.push({start:Math.min(f,a-d),end:a-d+h-1}),Math.min(f,a-d)===f)break;b=0,++c}b+=this._core.mergers(this._core.relative(a))}},e.prototype.draw=function(){var b,c=this._core.settings,d=this._core.items().length<=c.items,e=this._core.relative(this._core.current()),f=c.loop||c.rewind;this._controls.$relative.toggleClass(\"disabled\",!c.nav||d),c.nav&&(this._controls.$previous.toggleClass(\"disabled\",!f&&e<=this._core.minimum(!0)),this._controls.$next.toggleClass(\"disabled\",!f&&e>=this._core.maximum(!0))),this._controls.$absolute.toggleClass(\"disabled\",!c.dots||d),c.dots&&(b=this._pages.length-this._controls.$absolute.children().length,c.dotsData&&0!==b?this._controls.$absolute.html(this._templates.join(\"\")):b>0?this._controls.$absolute.append(new Array(b+1).join(this._templates[0])):b<0&&this._controls.$absolute.children().slice(b).remove(),this._controls.$absolute.find(\".active\").removeClass(\"active\"),this._controls.$absolute.children().eq(a.inArray(this.current(),this._pages)).addClass(\"active\"))},e.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotsData?1:c.dotsEach||c.items)}},e.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,a.proxy(function(a,c){return a.start<=b&&a.end>=b},this)).pop()},e.prototype.getPosition=function(b){var c,d,e=this._core.settings;return\"page\"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},e.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},e.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},e.prototype.to=function(b,c,d){var e;!d&&this._pages.length?(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c)):a.proxy(this._overrides.to,this._core)(b,c)},a.fn.owlCarousel.Constructor.Plugins.Navigation=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(c){this._core=c,this._hashes={},this.$element=this._core.$element,this._handlers={\"initialized.owl.carousel\":a.proxy(function(c){c.namespace&&\"URLHash\"===this._core.settings.startPosition&&a(b).trigger(\"hashchange.owl.navigation\")},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\"[data-hash]\").addBack(\"[data-hash]\").attr(\"data-hash\");if(!c)return;this._hashes[c]=b.content}},this),\"changed.owl.carousel\":a.proxy(function(c){if(c.namespace&&\"position\"===c.property.name){var d=this._core.items(this._core.relative(this._core.current())),e=a.map(this._hashes,function(a,b){return a===d?b:null}).join();if(!e||b.location.hash.slice(1)===e)return;b.location.hash=e}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on(\"hashchange.owl.navigation\",a.proxy(function(a){var c=b.location.hash.substring(1),e=this._core.$stage.children(),f=this._hashes[c]&&e.index(this._hashes[c]);f!==d&&f!==this._core.current()&&this._core.to(this._core.relative(f),!1,!0)},this))};e.Defaults={URLhashListener:!1},e.prototype.destroy=function(){var c,d;a(b).off(\"hashchange.owl.navigation\");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))\"function\"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){function e(b,c){var e=!1,f=b.charAt(0).toUpperCase()+b.slice(1);return a.each((b+\" \"+h.join(f+\" \")+f).split(\" \"),function(a,b){if(g[b]!==d)return e=!c||b,!1}),e}function f(a){return e(a,!0)}var g=a(\"<support>\").get(0).style,h=\"Webkit Moz O ms\".split(\" \"),i={transition:{end:{WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd\",transition:\"transitionend\"}},animation:{end:{WebkitAnimation:\"webkitAnimationEnd\",MozAnimation:\"animationend\",OAnimation:\"oAnimationEnd\",animation:\"animationend\"}}},j={csstransforms:function(){return!!e(\"transform\")},csstransforms3d:function(){return!!e(\"perspective\")},csstransitions:function(){return!!e(\"transition\")},cssanimations:function(){return!!e(\"animation\")}};j.csstransitions()&&(a.support.transition=new String(f(\"transition\")),a.support.transition.end=i.transition.end[a.support.transition]),j.cssanimations()&&(a.support.animation=new String(f(\"animation\")),a.support.animation.end=i.animation.end[a.support.animation]),j.csstransforms()&&(a.support.transform=new String(f(\"transform\")),a.support.transform3d=j.csstransforms3d())}(window.Zepto||window.jQuery,window,document);","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         *\n         * @param {Number} timeoutID\n         */\n        clearTimeout: function (timeoutID) {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout(timeoutID);\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var payflowProMethodMixin = {\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            skipRefreshCaptcha.skip(true);\n            this._super();\n        }\n    };\n\n    return function (payflowProMethod) {\n        return payflowProMethod.extend(payflowProMethodMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var defaultCaptchaMixin = {\n        /**\n         * @override\n         */\n        refresh: function () {\n            if (!skipRefreshCaptcha.skip()) {\n                this._super();\n            } else {\n                skipRefreshCaptcha.skip(false);\n            }\n        }\n    };\n\n    return function (defaultCaptcha) {\n        return defaultCaptcha.extend(defaultCaptchaMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","Magento_PaypalCaptcha/js/model/skipRefreshCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        skip: ko.observable(false)\n    };\n});\n","Threedadv_Theme/js/lib/flatpickr.js":"/* flatpickr v4.6.13, @license MIT */\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n  typeof define === 'function' && define.amd ? define(factory) :\n  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.flatpickr = factory());\n}(this, (function () { 'use strict';\n\n  /*! *****************************************************************************\n  Copyright (c) Microsoft Corporation.\n\n  Permission to use, copy, modify, and/or distribute this software for any\n  purpose with or without fee is hereby granted.\n\n  THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\n  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\n  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\n  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\n  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\n  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\n  PERFORMANCE OF THIS SOFTWARE.\n  ***************************************************************************** */\n\n  var __assign = function() {\n      __assign = Object.assign || function __assign(t) {\n          for (var s, i = 1, n = arguments.length; i < n; i++) {\n              s = arguments[i];\n              for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\n          }\n          return t;\n      };\n      return __assign.apply(this, arguments);\n  };\n\n  function __spreadArrays() {\n      for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;\n      for (var r = Array(s), k = 0, i = 0; i < il; i++)\n          for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)\n              r[k] = a[j];\n      return r;\n  }\n\n  var HOOKS = [\n      \"onChange\",\n      \"onClose\",\n      \"onDayCreate\",\n      \"onDestroy\",\n      \"onKeyDown\",\n      \"onMonthChange\",\n      \"onOpen\",\n      \"onParseConfig\",\n      \"onReady\",\n      \"onValueUpdate\",\n      \"onYearChange\",\n      \"onPreCalendarPosition\",\n  ];\n  var defaults = {\n      _disable: [],\n      allowInput: false,\n      allowInvalidPreload: false,\n      altFormat: \"F j, Y\",\n      altInput: false,\n      altInputClass: \"form-control input\",\n      animate: typeof window === \"object\" &&\n          window.navigator.userAgent.indexOf(\"MSIE\") === -1,\n      ariaDateFormat: \"F j, Y\",\n      autoFillDefaultTime: true,\n      clickOpens: true,\n      closeOnSelect: true,\n      conjunction: \", \",\n      dateFormat: \"Y-m-d\",\n      defaultHour: 12,\n      defaultMinute: 0,\n      defaultSeconds: 0,\n      disable: [],\n      disableMobile: false,\n      enableSeconds: false,\n      enableTime: false,\n      errorHandler: function (err) {\n          return typeof console !== \"undefined\" && console.warn(err);\n      },\n      getWeek: function (givenDate) {\n          var date = new Date(givenDate.getTime());\n          date.setHours(0, 0, 0, 0);\n          // Thursday in current week decides the year.\n          date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));\n          // January 4 is always in week 1.\n          var week1 = new Date(date.getFullYear(), 0, 4);\n          // Adjust to Thursday in week 1 and count number of weeks from date to week1.\n          return (1 +\n              Math.round(((date.getTime() - week1.getTime()) / 86400000 -\n                  3 +\n                  ((week1.getDay() + 6) % 7)) /\n                  7));\n      },\n      hourIncrement: 1,\n      ignoredFocusElements: [],\n      inline: false,\n      locale: \"default\",\n      minuteIncrement: 5,\n      mode: \"single\",\n      monthSelectorType: \"dropdown\",\n      nextArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>\",\n      noCalendar: false,\n      now: new Date(),\n      onChange: [],\n      onClose: [],\n      onDayCreate: [],\n      onDestroy: [],\n      onKeyDown: [],\n      onMonthChange: [],\n      onOpen: [],\n      onParseConfig: [],\n      onReady: [],\n      onValueUpdate: [],\n      onYearChange: [],\n      onPreCalendarPosition: [],\n      plugins: [],\n      position: \"auto\",\n      positionElement: undefined,\n      prevArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>\",\n      shorthandCurrentMonth: false,\n      showMonths: 1,\n      static: false,\n      time_24hr: false,\n      weekNumbers: false,\n      wrap: false,\n  };\n\n  var english = {\n      weekdays: {\n          shorthand: [\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\"],\n          longhand: [\n              \"Sunday\",\n              \"Monday\",\n              \"Tuesday\",\n              \"Wednesday\",\n              \"Thursday\",\n              \"Friday\",\n              \"Saturday\",\n          ],\n      },\n      months: {\n          shorthand: [\n              \"Jan\",\n              \"Feb\",\n              \"Mar\",\n              \"Apr\",\n              \"May\",\n              \"Jun\",\n              \"Jul\",\n              \"Aug\",\n              \"Sep\",\n              \"Oct\",\n              \"Nov\",\n              \"Dec\",\n          ],\n          longhand: [\n              \"January\",\n              \"February\",\n              \"March\",\n              \"April\",\n              \"May\",\n              \"June\",\n              \"July\",\n              \"August\",\n              \"September\",\n              \"October\",\n              \"November\",\n              \"December\",\n          ],\n      },\n      daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],\n      firstDayOfWeek: 0,\n      ordinal: function (nth) {\n          var s = nth % 100;\n          if (s > 3 && s < 21)\n              return \"th\";\n          switch (s % 10) {\n              case 1:\n                  return \"st\";\n              case 2:\n                  return \"nd\";\n              case 3:\n                  return \"rd\";\n              default:\n                  return \"th\";\n          }\n      },\n      rangeSeparator: \" to \",\n      weekAbbreviation: \"Wk\",\n      scrollTitle: \"Scroll to increment\",\n      toggleTitle: \"Click to toggle\",\n      amPM: [\"AM\", \"PM\"],\n      yearAriaLabel: \"Year\",\n      monthAriaLabel: \"Month\",\n      hourAriaLabel: \"Hour\",\n      minuteAriaLabel: \"Minute\",\n      time_24hr: false,\n  };\n\n  var pad = function (number, length) {\n      if (length === void 0) { length = 2; }\n      return (\"000\" + number).slice(length * -1);\n  };\n  var int = function (bool) { return (bool === true ? 1 : 0); };\n  /* istanbul ignore next */\n  function debounce(fn, wait) {\n      var t;\n      return function () {\n          var _this = this;\n          var args = arguments;\n          clearTimeout(t);\n          t = setTimeout(function () { return fn.apply(_this, args); }, wait);\n      };\n  }\n  var arrayify = function (obj) {\n      return obj instanceof Array ? obj : [obj];\n  };\n\n  function toggleClass(elem, className, bool) {\n      if (bool === true)\n          return elem.classList.add(className);\n      elem.classList.remove(className);\n  }\n  function createElement(tag, className, content) {\n      var e = window.document.createElement(tag);\n      className = className || \"\";\n      content = content || \"\";\n      e.className = className;\n      if (content !== undefined)\n          e.textContent = content;\n      return e;\n  }\n  function clearNode(node) {\n      while (node.firstChild)\n          node.removeChild(node.firstChild);\n  }\n  function findParent(node, condition) {\n      if (condition(node))\n          return node;\n      else if (node.parentNode)\n          return findParent(node.parentNode, condition);\n      return undefined; // nothing found\n  }\n  function createNumberInput(inputClassName, opts) {\n      var wrapper = createElement(\"div\", \"numInputWrapper\"), numInput = createElement(\"input\", \"numInput \" + inputClassName), arrowUp = createElement(\"span\", \"arrowUp\"), arrowDown = createElement(\"span\", \"arrowDown\");\n      if (navigator.userAgent.indexOf(\"MSIE 9.0\") === -1) {\n          numInput.type = \"number\";\n      }\n      else {\n          numInput.type = \"text\";\n          numInput.pattern = \"\\\\d*\";\n      }\n      if (opts !== undefined)\n          for (var key in opts)\n              numInput.setAttribute(key, opts[key]);\n      wrapper.appendChild(numInput);\n      wrapper.appendChild(arrowUp);\n      wrapper.appendChild(arrowDown);\n      return wrapper;\n  }\n  function getEventTarget(event) {\n      try {\n          if (typeof event.composedPath === \"function\") {\n              var path = event.composedPath();\n              return path[0];\n          }\n          return event.target;\n      }\n      catch (error) {\n          return event.target;\n      }\n  }\n\n  var doNothing = function () { return undefined; };\n  var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? \"shorthand\" : \"longhand\"][monthNumber]; };\n  var revFormat = {\n      D: doNothing,\n      F: function (dateObj, monthName, locale) {\n          dateObj.setMonth(locale.months.longhand.indexOf(monthName));\n      },\n      G: function (dateObj, hour) {\n          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));\n      },\n      H: function (dateObj, hour) {\n          dateObj.setHours(parseFloat(hour));\n      },\n      J: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      K: function (dateObj, amPM, locale) {\n          dateObj.setHours((dateObj.getHours() % 12) +\n              12 * int(new RegExp(locale.amPM[1], \"i\").test(amPM)));\n      },\n      M: function (dateObj, shortMonth, locale) {\n          dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));\n      },\n      S: function (dateObj, seconds) {\n          dateObj.setSeconds(parseFloat(seconds));\n      },\n      U: function (_, unixSeconds) { return new Date(parseFloat(unixSeconds) * 1000); },\n      W: function (dateObj, weekNum, locale) {\n          var weekNumber = parseInt(weekNum);\n          var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);\n          date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);\n          return date;\n      },\n      Y: function (dateObj, year) {\n          dateObj.setFullYear(parseFloat(year));\n      },\n      Z: function (_, ISODate) { return new Date(ISODate); },\n      d: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      h: function (dateObj, hour) {\n          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));\n      },\n      i: function (dateObj, minutes) {\n          dateObj.setMinutes(parseFloat(minutes));\n      },\n      j: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      l: doNothing,\n      m: function (dateObj, month) {\n          dateObj.setMonth(parseFloat(month) - 1);\n      },\n      n: function (dateObj, month) {\n          dateObj.setMonth(parseFloat(month) - 1);\n      },\n      s: function (dateObj, seconds) {\n          dateObj.setSeconds(parseFloat(seconds));\n      },\n      u: function (_, unixMillSeconds) {\n          return new Date(parseFloat(unixMillSeconds));\n      },\n      w: doNothing,\n      y: function (dateObj, year) {\n          dateObj.setFullYear(2000 + parseFloat(year));\n      },\n  };\n  var tokenRegex = {\n      D: \"\",\n      F: \"\",\n      G: \"(\\\\d\\\\d|\\\\d)\",\n      H: \"(\\\\d\\\\d|\\\\d)\",\n      J: \"(\\\\d\\\\d|\\\\d)\\\\w+\",\n      K: \"\",\n      M: \"\",\n      S: \"(\\\\d\\\\d|\\\\d)\",\n      U: \"(.+)\",\n      W: \"(\\\\d\\\\d|\\\\d)\",\n      Y: \"(\\\\d{4})\",\n      Z: \"(.+)\",\n      d: \"(\\\\d\\\\d|\\\\d)\",\n      h: \"(\\\\d\\\\d|\\\\d)\",\n      i: \"(\\\\d\\\\d|\\\\d)\",\n      j: \"(\\\\d\\\\d|\\\\d)\",\n      l: \"\",\n      m: \"(\\\\d\\\\d|\\\\d)\",\n      n: \"(\\\\d\\\\d|\\\\d)\",\n      s: \"(\\\\d\\\\d|\\\\d)\",\n      u: \"(.+)\",\n      w: \"(\\\\d\\\\d|\\\\d)\",\n      y: \"(\\\\d{2})\",\n  };\n  var formats = {\n      // get the date in UTC\n      Z: function (date) { return date.toISOString(); },\n      // weekday name, short, e.g. Thu\n      D: function (date, locale, options) {\n          return locale.weekdays.shorthand[formats.w(date, locale, options)];\n      },\n      // full month name e.g. January\n      F: function (date, locale, options) {\n          return monthToStr(formats.n(date, locale, options) - 1, false, locale);\n      },\n      // padded hour 1-12\n      G: function (date, locale, options) {\n          return pad(formats.h(date, locale, options));\n      },\n      // hours with leading zero e.g. 03\n      H: function (date) { return pad(date.getHours()); },\n      // day (1-30) with ordinal suffix e.g. 1st, 2nd\n      J: function (date, locale) {\n          return locale.ordinal !== undefined\n              ? date.getDate() + locale.ordinal(date.getDate())\n              : date.getDate();\n      },\n      // AM/PM\n      K: function (date, locale) { return locale.amPM[int(date.getHours() > 11)]; },\n      // shorthand month e.g. Jan, Sep, Oct, etc\n      M: function (date, locale) {\n          return monthToStr(date.getMonth(), true, locale);\n      },\n      // seconds 00-59\n      S: function (date) { return pad(date.getSeconds()); },\n      // unix timestamp\n      U: function (date) { return date.getTime() / 1000; },\n      W: function (date, _, options) {\n          return options.getWeek(date);\n      },\n      // full year e.g. 2016, padded (0001-9999)\n      Y: function (date) { return pad(date.getFullYear(), 4); },\n      // day in month, padded (01-30)\n      d: function (date) { return pad(date.getDate()); },\n      // hour from 1-12 (am/pm)\n      h: function (date) { return (date.getHours() % 12 ? date.getHours() % 12 : 12); },\n      // minutes, padded with leading zero e.g. 09\n      i: function (date) { return pad(date.getMinutes()); },\n      // day in month (1-30)\n      j: function (date) { return date.getDate(); },\n      // weekday name, full, e.g. Thursday\n      l: function (date, locale) {\n          return locale.weekdays.longhand[date.getDay()];\n      },\n      // padded month number (01-12)\n      m: function (date) { return pad(date.getMonth() + 1); },\n      // the month number (1-12)\n      n: function (date) { return date.getMonth() + 1; },\n      // seconds 0-59\n      s: function (date) { return date.getSeconds(); },\n      // Unix Milliseconds\n      u: function (date) { return date.getTime(); },\n      // number of the day of the week\n      w: function (date) { return date.getDay(); },\n      // last two digits of year e.g. 16 for 2016\n      y: function (date) { return String(date.getFullYear()).substring(2); },\n  };\n\n  var createDateFormatter = function (_a) {\n      var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c, _d = _a.isMobile, isMobile = _d === void 0 ? false : _d;\n      return function (dateObj, frmt, overrideLocale) {\n          var locale = overrideLocale || l10n;\n          if (config.formatDate !== undefined && !isMobile) {\n              return config.formatDate(dateObj, frmt, locale);\n          }\n          return frmt\n              .split(\"\")\n              .map(function (c, i, arr) {\n              return formats[c] && arr[i - 1] !== \"\\\\\"\n                  ? formats[c](dateObj, locale, config)\n                  : c !== \"\\\\\"\n                      ? c\n                      : \"\";\n          })\n              .join(\"\");\n      };\n  };\n  var createDateParser = function (_a) {\n      var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;\n      return function (date, givenFormat, timeless, customLocale) {\n          if (date !== 0 && !date)\n              return undefined;\n          var locale = customLocale || l10n;\n          var parsedDate;\n          var dateOrig = date;\n          if (date instanceof Date)\n              parsedDate = new Date(date.getTime());\n          else if (typeof date !== \"string\" &&\n              date.toFixed !== undefined // timestamp\n          )\n              // create a copy\n              parsedDate = new Date(date);\n          else if (typeof date === \"string\") {\n              // date string\n              var format = givenFormat || (config || defaults).dateFormat;\n              var datestr = String(date).trim();\n              if (datestr === \"today\") {\n                  parsedDate = new Date();\n                  timeless = true;\n              }\n              else if (config && config.parseDate) {\n                  parsedDate = config.parseDate(date, format);\n              }\n              else if (/Z$/.test(datestr) ||\n                  /GMT$/.test(datestr) // datestrings w/ timezone\n              ) {\n                  parsedDate = new Date(date);\n              }\n              else {\n                  var matched = void 0, ops = [];\n                  for (var i = 0, matchIndex = 0, regexStr = \"\"; i < format.length; i++) {\n                      var token_1 = format[i];\n                      var isBackSlash = token_1 === \"\\\\\";\n                      var escaped = format[i - 1] === \"\\\\\" || isBackSlash;\n                      if (tokenRegex[token_1] && !escaped) {\n                          regexStr += tokenRegex[token_1];\n                          var match = new RegExp(regexStr).exec(date);\n                          if (match && (matched = true)) {\n                              ops[token_1 !== \"Y\" ? \"push\" : \"unshift\"]({\n                                  fn: revFormat[token_1],\n                                  val: match[++matchIndex],\n                              });\n                          }\n                      }\n                      else if (!isBackSlash)\n                          regexStr += \".\"; // don't really care\n                  }\n                  parsedDate =\n                      !config || !config.noCalendar\n                          ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)\n                          : new Date(new Date().setHours(0, 0, 0, 0));\n                  ops.forEach(function (_a) {\n                      var fn = _a.fn, val = _a.val;\n                      return (parsedDate = fn(parsedDate, val, locale) || parsedDate);\n                  });\n                  parsedDate = matched ? parsedDate : undefined;\n              }\n          }\n          /* istanbul ignore next */\n          if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {\n              config.errorHandler(new Error(\"Invalid date provided: \" + dateOrig));\n              return undefined;\n          }\n          if (timeless === true)\n              parsedDate.setHours(0, 0, 0, 0);\n          return parsedDate;\n      };\n  };\n  /**\n   * Compute the difference in dates, measured in ms\n   */\n  function compareDates(date1, date2, timeless) {\n      if (timeless === void 0) { timeless = true; }\n      if (timeless !== false) {\n          return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -\n              new Date(date2.getTime()).setHours(0, 0, 0, 0));\n      }\n      return date1.getTime() - date2.getTime();\n  }\n  var isBetween = function (ts, ts1, ts2) {\n      return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);\n  };\n  var calculateSecondsSinceMidnight = function (hours, minutes, seconds) {\n      return hours * 3600 + minutes * 60 + seconds;\n  };\n  var parseSeconds = function (secondsSinceMidnight) {\n      var hours = Math.floor(secondsSinceMidnight / 3600), minutes = (secondsSinceMidnight - hours * 3600) / 60;\n      return [hours, minutes, secondsSinceMidnight - hours * 3600 - minutes * 60];\n  };\n  var duration = {\n      DAY: 86400000,\n  };\n  function getDefaultHours(config) {\n      var hours = config.defaultHour;\n      var minutes = config.defaultMinute;\n      var seconds = config.defaultSeconds;\n      if (config.minDate !== undefined) {\n          var minHour = config.minDate.getHours();\n          var minMinutes = config.minDate.getMinutes();\n          var minSeconds = config.minDate.getSeconds();\n          if (hours < minHour) {\n              hours = minHour;\n          }\n          if (hours === minHour && minutes < minMinutes) {\n              minutes = minMinutes;\n          }\n          if (hours === minHour && minutes === minMinutes && seconds < minSeconds)\n              seconds = config.minDate.getSeconds();\n      }\n      if (config.maxDate !== undefined) {\n          var maxHr = config.maxDate.getHours();\n          var maxMinutes = config.maxDate.getMinutes();\n          hours = Math.min(hours, maxHr);\n          if (hours === maxHr)\n              minutes = Math.min(maxMinutes, minutes);\n          if (hours === maxHr && minutes === maxMinutes)\n              seconds = config.maxDate.getSeconds();\n      }\n      return { hours: hours, minutes: minutes, seconds: seconds };\n  }\n\n  if (typeof Object.assign !== \"function\") {\n      Object.assign = function (target) {\n          var args = [];\n          for (var _i = 1; _i < arguments.length; _i++) {\n              args[_i - 1] = arguments[_i];\n          }\n          if (!target) {\n              throw TypeError(\"Cannot convert undefined or null to object\");\n          }\n          var _loop_1 = function (source) {\n              if (source) {\n                  Object.keys(source).forEach(function (key) { return (target[key] = source[key]); });\n              }\n          };\n          for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {\n              var source = args_1[_a];\n              _loop_1(source);\n          }\n          return target;\n      };\n  }\n\n  var DEBOUNCED_CHANGE_MS = 300;\n  function FlatpickrInstance(element, instanceConfig) {\n      var self = {\n          config: __assign(__assign({}, defaults), flatpickr.defaultConfig),\n          l10n: english,\n      };\n      self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n      self._handlers = [];\n      self.pluginElements = [];\n      self.loadedPlugins = [];\n      self._bind = bind;\n      self._setHoursFromDate = setHoursFromDate;\n      self._positionCalendar = positionCalendar;\n      self.changeMonth = changeMonth;\n      self.changeYear = changeYear;\n      self.clear = clear;\n      self.close = close;\n      self.onMouseOver = onMouseOver;\n      self._createElement = createElement;\n      self.createDay = createDay;\n      self.destroy = destroy;\n      self.isEnabled = isEnabled;\n      self.jumpToDate = jumpToDate;\n      self.updateValue = updateValue;\n      self.open = open;\n      self.redraw = redraw;\n      self.set = set;\n      self.setDate = setDate;\n      self.toggle = toggle;\n      function setupHelperFunctions() {\n          self.utils = {\n              getDaysInMonth: function (month, yr) {\n                  if (month === void 0) { month = self.currentMonth; }\n                  if (yr === void 0) { yr = self.currentYear; }\n                  if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))\n                      return 29;\n                  return self.l10n.daysInMonth[month];\n              },\n          };\n      }\n      function init() {\n          self.element = self.input = element;\n          self.isOpen = false;\n          parseConfig();\n          setupLocale();\n          setupInputs();\n          setupDates();\n          setupHelperFunctions();\n          if (!self.isMobile)\n              build();\n          bindEvents();\n          if (self.selectedDates.length || self.config.noCalendar) {\n              if (self.config.enableTime) {\n                  setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);\n              }\n              updateValue(false);\n          }\n          setCalendarWidth();\n          var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);\n          /* TODO: investigate this further\n      \n            Currently, there is weird positioning behavior in safari causing pages\n            to scroll up. https://github.com/chmln/flatpickr/issues/563\n      \n            However, most browsers are not Safari and positioning is expensive when used\n            in scale. https://github.com/chmln/flatpickr/issues/1096\n          */\n          if (!self.isMobile && isSafari) {\n              positionCalendar();\n          }\n          triggerEvent(\"onReady\");\n      }\n      function getClosestActiveElement() {\n          var _a;\n          return (((_a = self.calendarContainer) === null || _a === void 0 ? void 0 : _a.getRootNode())\n              .activeElement || document.activeElement);\n      }\n      function bindToInstance(fn) {\n          return fn.bind(self);\n      }\n      function setCalendarWidth() {\n          var config = self.config;\n          if (config.weekNumbers === false && config.showMonths === 1) {\n              return;\n          }\n          else if (config.noCalendar !== true) {\n              window.requestAnimationFrame(function () {\n                  if (self.calendarContainer !== undefined) {\n                      self.calendarContainer.style.visibility = \"hidden\";\n                      self.calendarContainer.style.display = \"block\";\n                  }\n                  if (self.daysContainer !== undefined) {\n                      var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;\n                      self.daysContainer.style.width = daysWidth + \"px\";\n                      self.calendarContainer.style.width =\n                          daysWidth +\n                              (self.weekWrapper !== undefined\n                                  ? self.weekWrapper.offsetWidth\n                                  : 0) +\n                              \"px\";\n                      self.calendarContainer.style.removeProperty(\"visibility\");\n                      self.calendarContainer.style.removeProperty(\"display\");\n                  }\n              });\n          }\n      }\n      /**\n       * The handler for all events targeting the time inputs\n       */\n      function updateTime(e) {\n          if (self.selectedDates.length === 0) {\n              var defaultDate = self.config.minDate === undefined ||\n                  compareDates(new Date(), self.config.minDate) >= 0\n                  ? new Date()\n                  : new Date(self.config.minDate.getTime());\n              var defaults = getDefaultHours(self.config);\n              defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());\n              self.selectedDates = [defaultDate];\n              self.latestSelectedDateObj = defaultDate;\n          }\n          if (e !== undefined && e.type !== \"blur\") {\n              timeWrapper(e);\n          }\n          var prevValue = self._input.value;\n          setHoursFromInputs();\n          updateValue();\n          if (self._input.value !== prevValue) {\n              self._debouncedChange();\n          }\n      }\n      function ampm2military(hour, amPM) {\n          return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);\n      }\n      function military2ampm(hour) {\n          switch (hour % 24) {\n              case 0:\n              case 12:\n                  return 12;\n              default:\n                  return hour % 12;\n          }\n      }\n      /**\n       * Syncs the selected date object time with user's time input\n       */\n      function setHoursFromInputs() {\n          if (self.hourElement === undefined || self.minuteElement === undefined)\n              return;\n          var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined\n              ? (parseInt(self.secondElement.value, 10) || 0) % 60\n              : 0;\n          if (self.amPM !== undefined) {\n              hours = ampm2military(hours, self.amPM.textContent);\n          }\n          var limitMinHours = self.config.minTime !== undefined ||\n              (self.config.minDate &&\n                  self.minDateHasTime &&\n                  self.latestSelectedDateObj &&\n                  compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===\n                      0);\n          var limitMaxHours = self.config.maxTime !== undefined ||\n              (self.config.maxDate &&\n                  self.maxDateHasTime &&\n                  self.latestSelectedDateObj &&\n                  compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===\n                      0);\n          if (self.config.maxTime !== undefined &&\n              self.config.minTime !== undefined &&\n              self.config.minTime > self.config.maxTime) {\n              var minBound = calculateSecondsSinceMidnight(self.config.minTime.getHours(), self.config.minTime.getMinutes(), self.config.minTime.getSeconds());\n              var maxBound = calculateSecondsSinceMidnight(self.config.maxTime.getHours(), self.config.maxTime.getMinutes(), self.config.maxTime.getSeconds());\n              var currentTime = calculateSecondsSinceMidnight(hours, minutes, seconds);\n              if (currentTime > maxBound && currentTime < minBound) {\n                  var result = parseSeconds(minBound);\n                  hours = result[0];\n                  minutes = result[1];\n                  seconds = result[2];\n              }\n          }\n          else {\n              if (limitMaxHours) {\n                  var maxTime = self.config.maxTime !== undefined\n                      ? self.config.maxTime\n                      : self.config.maxDate;\n                  hours = Math.min(hours, maxTime.getHours());\n                  if (hours === maxTime.getHours())\n                      minutes = Math.min(minutes, maxTime.getMinutes());\n                  if (minutes === maxTime.getMinutes())\n                      seconds = Math.min(seconds, maxTime.getSeconds());\n              }\n              if (limitMinHours) {\n                  var minTime = self.config.minTime !== undefined\n                      ? self.config.minTime\n                      : self.config.minDate;\n                  hours = Math.max(hours, minTime.getHours());\n                  if (hours === minTime.getHours() && minutes < minTime.getMinutes())\n                      minutes = minTime.getMinutes();\n                  if (minutes === minTime.getMinutes())\n                      seconds = Math.max(seconds, minTime.getSeconds());\n              }\n          }\n          setHours(hours, minutes, seconds);\n      }\n      /**\n       * Syncs time input values with a date\n       */\n      function setHoursFromDate(dateObj) {\n          var date = dateObj || self.latestSelectedDateObj;\n          if (date && date instanceof Date) {\n              setHours(date.getHours(), date.getMinutes(), date.getSeconds());\n          }\n      }\n      /**\n       * Sets the hours, minutes, and optionally seconds\n       * of the latest selected date object and the\n       * corresponding time inputs\n       * @param {Number} hours the hour. whether its military\n       *                 or am-pm gets inferred from config\n       * @param {Number} minutes the minutes\n       * @param {Number} seconds the seconds (optional)\n       */\n      function setHours(hours, minutes, seconds) {\n          if (self.latestSelectedDateObj !== undefined) {\n              self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);\n          }\n          if (!self.hourElement || !self.minuteElement || self.isMobile)\n              return;\n          self.hourElement.value = pad(!self.config.time_24hr\n              ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)\n              : hours);\n          self.minuteElement.value = pad(minutes);\n          if (self.amPM !== undefined)\n              self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];\n          if (self.secondElement !== undefined)\n              self.secondElement.value = pad(seconds);\n      }\n      /**\n       * Handles the year input and incrementing events\n       * @param {Event} event the keyup or increment event\n       */\n      function onYearInput(event) {\n          var eventTarget = getEventTarget(event);\n          var year = parseInt(eventTarget.value) + (event.delta || 0);\n          if (year / 1000 > 1 ||\n              (event.key === \"Enter\" && !/[^\\d]/.test(year.toString()))) {\n              changeYear(year);\n          }\n      }\n      /**\n       * Essentially addEventListener + tracking\n       * @param {Element} element the element to addEventListener to\n       * @param {String} event the event name\n       * @param {Function} handler the event handler\n       */\n      function bind(element, event, handler, options) {\n          if (event instanceof Array)\n              return event.forEach(function (ev) { return bind(element, ev, handler, options); });\n          if (element instanceof Array)\n              return element.forEach(function (el) { return bind(el, event, handler, options); });\n          element.addEventListener(event, handler, options);\n          self._handlers.push({\n              remove: function () { return element.removeEventListener(event, handler, options); },\n          });\n      }\n      function triggerChange() {\n          triggerEvent(\"onChange\");\n      }\n      /**\n       * Adds all the necessary event listeners\n       */\n      function bindEvents() {\n          if (self.config.wrap) {\n              [\"open\", \"close\", \"toggle\", \"clear\"].forEach(function (evt) {\n                  Array.prototype.forEach.call(self.element.querySelectorAll(\"[data-\" + evt + \"]\"), function (el) {\n                      return bind(el, \"click\", self[evt]);\n                  });\n              });\n          }\n          if (self.isMobile) {\n              setupMobile();\n              return;\n          }\n          var debouncedResize = debounce(onResize, 50);\n          self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);\n          if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))\n              bind(self.daysContainer, \"mouseover\", function (e) {\n                  if (self.config.mode === \"range\")\n                      onMouseOver(getEventTarget(e));\n              });\n          bind(self._input, \"keydown\", onKeyDown);\n          if (self.calendarContainer !== undefined) {\n              bind(self.calendarContainer, \"keydown\", onKeyDown);\n          }\n          if (!self.config.inline && !self.config.static)\n              bind(window, \"resize\", debouncedResize);\n          if (window.ontouchstart !== undefined)\n              bind(window.document, \"touchstart\", documentClick);\n          else\n              bind(window.document, \"mousedown\", documentClick);\n          bind(window.document, \"focus\", documentClick, { capture: true });\n          if (self.config.clickOpens === true) {\n              bind(self._input, \"focus\", self.open);\n              bind(self._input, \"click\", self.open);\n          }\n          if (self.daysContainer !== undefined) {\n              bind(self.monthNav, \"click\", onMonthNavClick);\n              bind(self.monthNav, [\"keyup\", \"increment\"], onYearInput);\n              bind(self.daysContainer, \"click\", selectDate);\n          }\n          if (self.timeContainer !== undefined &&\n              self.minuteElement !== undefined &&\n              self.hourElement !== undefined) {\n              var selText = function (e) {\n                  return getEventTarget(e).select();\n              };\n              bind(self.timeContainer, [\"increment\"], updateTime);\n              bind(self.timeContainer, \"blur\", updateTime, { capture: true });\n              bind(self.timeContainer, \"click\", timeIncrement);\n              bind([self.hourElement, self.minuteElement], [\"focus\", \"click\"], selText);\n              if (self.secondElement !== undefined)\n                  bind(self.secondElement, \"focus\", function () { return self.secondElement && self.secondElement.select(); });\n              if (self.amPM !== undefined) {\n                  bind(self.amPM, \"click\", function (e) {\n                      updateTime(e);\n                  });\n              }\n          }\n          if (self.config.allowInput) {\n              bind(self._input, \"blur\", onBlur);\n          }\n      }\n      /**\n       * Set the calendar view to a particular date.\n       * @param {Date} jumpDate the date to set the view to\n       * @param {boolean} triggerChange if change events should be triggered\n       */\n      function jumpToDate(jumpDate, triggerChange) {\n          var jumpTo = jumpDate !== undefined\n              ? self.parseDate(jumpDate)\n              : self.latestSelectedDateObj ||\n                  (self.config.minDate && self.config.minDate > self.now\n                      ? self.config.minDate\n                      : self.config.maxDate && self.config.maxDate < self.now\n                          ? self.config.maxDate\n                          : self.now);\n          var oldYear = self.currentYear;\n          var oldMonth = self.currentMonth;\n          try {\n              if (jumpTo !== undefined) {\n                  self.currentYear = jumpTo.getFullYear();\n                  self.currentMonth = jumpTo.getMonth();\n              }\n          }\n          catch (e) {\n              /* istanbul ignore next */\n              e.message = \"Invalid date supplied: \" + jumpTo;\n              self.config.errorHandler(e);\n          }\n          if (triggerChange && self.currentYear !== oldYear) {\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n          if (triggerChange &&\n              (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {\n              triggerEvent(\"onMonthChange\");\n          }\n          self.redraw();\n      }\n      /**\n       * The up/down arrow handler for time inputs\n       * @param {Event} e the click event\n       */\n      function timeIncrement(e) {\n          var eventTarget = getEventTarget(e);\n          if (~eventTarget.className.indexOf(\"arrow\"))\n              incrementNumInput(e, eventTarget.classList.contains(\"arrowUp\") ? 1 : -1);\n      }\n      /**\n       * Increments/decrements the value of input associ-\n       * ated with the up/down arrow by dispatching an\n       * \"increment\" event on the input.\n       *\n       * @param {Event} e the click event\n       * @param {Number} delta the diff (usually 1 or -1)\n       * @param {Element} inputElem the input element\n       */\n      function incrementNumInput(e, delta, inputElem) {\n          var target = e && getEventTarget(e);\n          var input = inputElem ||\n              (target && target.parentNode && target.parentNode.firstChild);\n          var event = createEvent(\"increment\");\n          event.delta = delta;\n          input && input.dispatchEvent(event);\n      }\n      function build() {\n          var fragment = window.document.createDocumentFragment();\n          self.calendarContainer = createElement(\"div\", \"flatpickr-calendar\");\n          self.calendarContainer.tabIndex = -1;\n          if (!self.config.noCalendar) {\n              fragment.appendChild(buildMonthNav());\n              self.innerContainer = createElement(\"div\", \"flatpickr-innerContainer\");\n              if (self.config.weekNumbers) {\n                  var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;\n                  self.innerContainer.appendChild(weekWrapper);\n                  self.weekNumbers = weekNumbers;\n                  self.weekWrapper = weekWrapper;\n              }\n              self.rContainer = createElement(\"div\", \"flatpickr-rContainer\");\n              self.rContainer.appendChild(buildWeekdays());\n              if (!self.daysContainer) {\n                  self.daysContainer = createElement(\"div\", \"flatpickr-days\");\n                  self.daysContainer.tabIndex = -1;\n              }\n              buildDays();\n              self.rContainer.appendChild(self.daysContainer);\n              self.innerContainer.appendChild(self.rContainer);\n              fragment.appendChild(self.innerContainer);\n          }\n          if (self.config.enableTime) {\n              fragment.appendChild(buildTime());\n          }\n          toggleClass(self.calendarContainer, \"rangeMode\", self.config.mode === \"range\");\n          toggleClass(self.calendarContainer, \"animate\", self.config.animate === true);\n          toggleClass(self.calendarContainer, \"multiMonth\", self.config.showMonths > 1);\n          self.calendarContainer.appendChild(fragment);\n          var customAppend = self.config.appendTo !== undefined &&\n              self.config.appendTo.nodeType !== undefined;\n          if (self.config.inline || self.config.static) {\n              self.calendarContainer.classList.add(self.config.inline ? \"inline\" : \"static\");\n              if (self.config.inline) {\n                  if (!customAppend && self.element.parentNode)\n                      self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);\n                  else if (self.config.appendTo !== undefined)\n                      self.config.appendTo.appendChild(self.calendarContainer);\n              }\n              if (self.config.static) {\n                  var wrapper = createElement(\"div\", \"flatpickr-wrapper\");\n                  if (self.element.parentNode)\n                      self.element.parentNode.insertBefore(wrapper, self.element);\n                  wrapper.appendChild(self.element);\n                  if (self.altInput)\n                      wrapper.appendChild(self.altInput);\n                  wrapper.appendChild(self.calendarContainer);\n              }\n          }\n          if (!self.config.static && !self.config.inline)\n              (self.config.appendTo !== undefined\n                  ? self.config.appendTo\n                  : window.document.body).appendChild(self.calendarContainer);\n      }\n      function createDay(className, date, _dayNumber, i) {\n          var dateIsEnabled = isEnabled(date, true), dayElement = createElement(\"span\", className, date.getDate().toString());\n          dayElement.dateObj = date;\n          dayElement.$i = i;\n          dayElement.setAttribute(\"aria-label\", self.formatDate(date, self.config.ariaDateFormat));\n          if (className.indexOf(\"hidden\") === -1 &&\n              compareDates(date, self.now) === 0) {\n              self.todayDateElem = dayElement;\n              dayElement.classList.add(\"today\");\n              dayElement.setAttribute(\"aria-current\", \"date\");\n          }\n          if (dateIsEnabled) {\n              dayElement.tabIndex = -1;\n              if (isDateSelected(date)) {\n                  dayElement.classList.add(\"selected\");\n                  self.selectedDateElem = dayElement;\n                  if (self.config.mode === \"range\") {\n                      toggleClass(dayElement, \"startRange\", self.selectedDates[0] &&\n                          compareDates(date, self.selectedDates[0], true) === 0);\n                      toggleClass(dayElement, \"endRange\", self.selectedDates[1] &&\n                          compareDates(date, self.selectedDates[1], true) === 0);\n                      if (className === \"nextMonthDay\")\n                          dayElement.classList.add(\"inRange\");\n                  }\n              }\n          }\n          else {\n              dayElement.classList.add(\"flatpickr-disabled\");\n          }\n          if (self.config.mode === \"range\") {\n              if (isDateInRange(date) && !isDateSelected(date))\n                  dayElement.classList.add(\"inRange\");\n          }\n          if (self.weekNumbers &&\n              self.config.showMonths === 1 &&\n              className !== \"prevMonthDay\" &&\n              i % 7 === 6) {\n              self.weekNumbers.insertAdjacentHTML(\"beforeend\", \"<span class='flatpickr-day'>\" + self.config.getWeek(date) + \"</span>\");\n          }\n          triggerEvent(\"onDayCreate\", dayElement);\n          return dayElement;\n      }\n      function focusOnDayElem(targetNode) {\n          targetNode.focus();\n          if (self.config.mode === \"range\")\n              onMouseOver(targetNode);\n      }\n      function getFirstAvailableDay(delta) {\n          var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;\n          var endMonth = delta > 0 ? self.config.showMonths : -1;\n          for (var m = startMonth; m != endMonth; m += delta) {\n              var month = self.daysContainer.children[m];\n              var startIndex = delta > 0 ? 0 : month.children.length - 1;\n              var endIndex = delta > 0 ? month.children.length : -1;\n              for (var i = startIndex; i != endIndex; i += delta) {\n                  var c = month.children[i];\n                  if (c.className.indexOf(\"hidden\") === -1 && isEnabled(c.dateObj))\n                      return c;\n              }\n          }\n          return undefined;\n      }\n      function getNextAvailableDay(current, delta) {\n          var givenMonth = current.className.indexOf(\"Month\") === -1\n              ? current.dateObj.getMonth()\n              : self.currentMonth;\n          var endMonth = delta > 0 ? self.config.showMonths : -1;\n          var loopDelta = delta > 0 ? 1 : -1;\n          for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {\n              var month = self.daysContainer.children[m];\n              var startIndex = givenMonth - self.currentMonth === m\n                  ? current.$i + delta\n                  : delta < 0\n                      ? month.children.length - 1\n                      : 0;\n              var numMonthDays = month.children.length;\n              for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {\n                  var c = month.children[i];\n                  if (c.className.indexOf(\"hidden\") === -1 &&\n                      isEnabled(c.dateObj) &&\n                      Math.abs(current.$i - i) >= Math.abs(delta))\n                      return focusOnDayElem(c);\n              }\n          }\n          self.changeMonth(loopDelta);\n          focusOnDay(getFirstAvailableDay(loopDelta), 0);\n          return undefined;\n      }\n      function focusOnDay(current, offset) {\n          var activeElement = getClosestActiveElement();\n          var dayFocused = isInView(activeElement || document.body);\n          var startElem = current !== undefined\n              ? current\n              : dayFocused\n                  ? activeElement\n                  : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)\n                      ? self.selectedDateElem\n                      : self.todayDateElem !== undefined && isInView(self.todayDateElem)\n                          ? self.todayDateElem\n                          : getFirstAvailableDay(offset > 0 ? 1 : -1);\n          if (startElem === undefined) {\n              self._input.focus();\n          }\n          else if (!dayFocused) {\n              focusOnDayElem(startElem);\n          }\n          else {\n              getNextAvailableDay(startElem, offset);\n          }\n      }\n      function buildMonthDays(year, month) {\n          var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;\n          var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);\n          var daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? \"prevMonthDay hidden\" : \"prevMonthDay\", nextMonthDayClass = isMultiMonth ? \"nextMonthDay hidden\" : \"nextMonthDay\";\n          var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;\n          // prepend days from the ending of previous month\n          for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day \" + prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));\n          }\n          // Start at 1 since there is no 0th day\n          for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day\", new Date(year, month, dayNumber), dayNumber, dayIndex));\n          }\n          // append days from the next month\n          for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&\n              (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day \" + nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));\n          }\n          //updateNavigationCurrentMonth();\n          var dayContainer = createElement(\"div\", \"dayContainer\");\n          dayContainer.appendChild(days);\n          return dayContainer;\n      }\n      function buildDays() {\n          if (self.daysContainer === undefined) {\n              return;\n          }\n          clearNode(self.daysContainer);\n          // TODO: week numbers for each month\n          if (self.weekNumbers)\n              clearNode(self.weekNumbers);\n          var frag = document.createDocumentFragment();\n          for (var i = 0; i < self.config.showMonths; i++) {\n              var d = new Date(self.currentYear, self.currentMonth, 1);\n              d.setMonth(self.currentMonth + i);\n              frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));\n          }\n          self.daysContainer.appendChild(frag);\n          self.days = self.daysContainer.firstChild;\n          if (self.config.mode === \"range\" && self.selectedDates.length === 1) {\n              onMouseOver();\n          }\n      }\n      function buildMonthSwitch() {\n          if (self.config.showMonths > 1 ||\n              self.config.monthSelectorType !== \"dropdown\")\n              return;\n          var shouldBuildMonth = function (month) {\n              if (self.config.minDate !== undefined &&\n                  self.currentYear === self.config.minDate.getFullYear() &&\n                  month < self.config.minDate.getMonth()) {\n                  return false;\n              }\n              return !(self.config.maxDate !== undefined &&\n                  self.currentYear === self.config.maxDate.getFullYear() &&\n                  month > self.config.maxDate.getMonth());\n          };\n          self.monthsDropdownContainer.tabIndex = -1;\n          self.monthsDropdownContainer.innerHTML = \"\";\n          for (var i = 0; i < 12; i++) {\n              if (!shouldBuildMonth(i))\n                  continue;\n              var month = createElement(\"option\", \"flatpickr-monthDropdown-month\");\n              month.value = new Date(self.currentYear, i).getMonth().toString();\n              month.textContent = monthToStr(i, self.config.shorthandCurrentMonth, self.l10n);\n              month.tabIndex = -1;\n              if (self.currentMonth === i) {\n                  month.selected = true;\n              }\n              self.monthsDropdownContainer.appendChild(month);\n          }\n      }\n      function buildMonth() {\n          var container = createElement(\"div\", \"flatpickr-month\");\n          var monthNavFragment = window.document.createDocumentFragment();\n          var monthElement;\n          if (self.config.showMonths > 1 ||\n              self.config.monthSelectorType === \"static\") {\n              monthElement = createElement(\"span\", \"cur-month\");\n          }\n          else {\n              self.monthsDropdownContainer = createElement(\"select\", \"flatpickr-monthDropdown-months\");\n              self.monthsDropdownContainer.setAttribute(\"aria-label\", self.l10n.monthAriaLabel);\n              bind(self.monthsDropdownContainer, \"change\", function (e) {\n                  var target = getEventTarget(e);\n                  var selectedMonth = parseInt(target.value, 10);\n                  self.changeMonth(selectedMonth - self.currentMonth);\n                  triggerEvent(\"onMonthChange\");\n              });\n              buildMonthSwitch();\n              monthElement = self.monthsDropdownContainer;\n          }\n          var yearInput = createNumberInput(\"cur-year\", { tabindex: \"-1\" });\n          var yearElement = yearInput.getElementsByTagName(\"input\")[0];\n          yearElement.setAttribute(\"aria-label\", self.l10n.yearAriaLabel);\n          if (self.config.minDate) {\n              yearElement.setAttribute(\"min\", self.config.minDate.getFullYear().toString());\n          }\n          if (self.config.maxDate) {\n              yearElement.setAttribute(\"max\", self.config.maxDate.getFullYear().toString());\n              yearElement.disabled =\n                  !!self.config.minDate &&\n                      self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();\n          }\n          var currentMonth = createElement(\"div\", \"flatpickr-current-month\");\n          currentMonth.appendChild(monthElement);\n          currentMonth.appendChild(yearInput);\n          monthNavFragment.appendChild(currentMonth);\n          container.appendChild(monthNavFragment);\n          return {\n              container: container,\n              yearElement: yearElement,\n              monthElement: monthElement,\n          };\n      }\n      function buildMonths() {\n          clearNode(self.monthNav);\n          self.monthNav.appendChild(self.prevMonthNav);\n          if (self.config.showMonths) {\n              self.yearElements = [];\n              self.monthElements = [];\n          }\n          for (var m = self.config.showMonths; m--;) {\n              var month = buildMonth();\n              self.yearElements.push(month.yearElement);\n              self.monthElements.push(month.monthElement);\n              self.monthNav.appendChild(month.container);\n          }\n          self.monthNav.appendChild(self.nextMonthNav);\n      }\n      function buildMonthNav() {\n          self.monthNav = createElement(\"div\", \"flatpickr-months\");\n          self.yearElements = [];\n          self.monthElements = [];\n          self.prevMonthNav = createElement(\"span\", \"flatpickr-prev-month\");\n          self.prevMonthNav.innerHTML = self.config.prevArrow;\n          self.nextMonthNav = createElement(\"span\", \"flatpickr-next-month\");\n          self.nextMonthNav.innerHTML = self.config.nextArrow;\n          buildMonths();\n          Object.defineProperty(self, \"_hidePrevMonthArrow\", {\n              get: function () { return self.__hidePrevMonthArrow; },\n              set: function (bool) {\n                  if (self.__hidePrevMonthArrow !== bool) {\n                      toggleClass(self.prevMonthNav, \"flatpickr-disabled\", bool);\n                      self.__hidePrevMonthArrow = bool;\n                  }\n              },\n          });\n          Object.defineProperty(self, \"_hideNextMonthArrow\", {\n              get: function () { return self.__hideNextMonthArrow; },\n              set: function (bool) {\n                  if (self.__hideNextMonthArrow !== bool) {\n                      toggleClass(self.nextMonthNav, \"flatpickr-disabled\", bool);\n                      self.__hideNextMonthArrow = bool;\n                  }\n              },\n          });\n          self.currentYearElement = self.yearElements[0];\n          updateNavigationCurrentMonth();\n          return self.monthNav;\n      }\n      function buildTime() {\n          self.calendarContainer.classList.add(\"hasTime\");\n          if (self.config.noCalendar)\n              self.calendarContainer.classList.add(\"noCalendar\");\n          var defaults = getDefaultHours(self.config);\n          self.timeContainer = createElement(\"div\", \"flatpickr-time\");\n          self.timeContainer.tabIndex = -1;\n          var separator = createElement(\"span\", \"flatpickr-time-separator\", \":\");\n          var hourInput = createNumberInput(\"flatpickr-hour\", {\n              \"aria-label\": self.l10n.hourAriaLabel,\n          });\n          self.hourElement = hourInput.getElementsByTagName(\"input\")[0];\n          var minuteInput = createNumberInput(\"flatpickr-minute\", {\n              \"aria-label\": self.l10n.minuteAriaLabel,\n          });\n          self.minuteElement = minuteInput.getElementsByTagName(\"input\")[0];\n          self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;\n          self.hourElement.value = pad(self.latestSelectedDateObj\n              ? self.latestSelectedDateObj.getHours()\n              : self.config.time_24hr\n                  ? defaults.hours\n                  : military2ampm(defaults.hours));\n          self.minuteElement.value = pad(self.latestSelectedDateObj\n              ? self.latestSelectedDateObj.getMinutes()\n              : defaults.minutes);\n          self.hourElement.setAttribute(\"step\", self.config.hourIncrement.toString());\n          self.minuteElement.setAttribute(\"step\", self.config.minuteIncrement.toString());\n          self.hourElement.setAttribute(\"min\", self.config.time_24hr ? \"0\" : \"1\");\n          self.hourElement.setAttribute(\"max\", self.config.time_24hr ? \"23\" : \"12\");\n          self.hourElement.setAttribute(\"maxlength\", \"2\");\n          self.minuteElement.setAttribute(\"min\", \"0\");\n          self.minuteElement.setAttribute(\"max\", \"59\");\n          self.minuteElement.setAttribute(\"maxlength\", \"2\");\n          self.timeContainer.appendChild(hourInput);\n          self.timeContainer.appendChild(separator);\n          self.timeContainer.appendChild(minuteInput);\n          if (self.config.time_24hr)\n              self.timeContainer.classList.add(\"time24hr\");\n          if (self.config.enableSeconds) {\n              self.timeContainer.classList.add(\"hasSeconds\");\n              var secondInput = createNumberInput(\"flatpickr-second\");\n              self.secondElement = secondInput.getElementsByTagName(\"input\")[0];\n              self.secondElement.value = pad(self.latestSelectedDateObj\n                  ? self.latestSelectedDateObj.getSeconds()\n                  : defaults.seconds);\n              self.secondElement.setAttribute(\"step\", self.minuteElement.getAttribute(\"step\"));\n              self.secondElement.setAttribute(\"min\", \"0\");\n              self.secondElement.setAttribute(\"max\", \"59\");\n              self.secondElement.setAttribute(\"maxlength\", \"2\");\n              self.timeContainer.appendChild(createElement(\"span\", \"flatpickr-time-separator\", \":\"));\n              self.timeContainer.appendChild(secondInput);\n          }\n          if (!self.config.time_24hr) {\n              // add self.amPM if appropriate\n              self.amPM = createElement(\"span\", \"flatpickr-am-pm\", self.l10n.amPM[int((self.latestSelectedDateObj\n                  ? self.hourElement.value\n                  : self.config.defaultHour) > 11)]);\n              self.amPM.title = self.l10n.toggleTitle;\n              self.amPM.tabIndex = -1;\n              self.timeContainer.appendChild(self.amPM);\n          }\n          return self.timeContainer;\n      }\n      function buildWeekdays() {\n          if (!self.weekdayContainer)\n              self.weekdayContainer = createElement(\"div\", \"flatpickr-weekdays\");\n          else\n              clearNode(self.weekdayContainer);\n          for (var i = self.config.showMonths; i--;) {\n              var container = createElement(\"div\", \"flatpickr-weekdaycontainer\");\n              self.weekdayContainer.appendChild(container);\n          }\n          updateWeekdays();\n          return self.weekdayContainer;\n      }\n      function updateWeekdays() {\n          if (!self.weekdayContainer) {\n              return;\n          }\n          var firstDayOfWeek = self.l10n.firstDayOfWeek;\n          var weekdays = __spreadArrays(self.l10n.weekdays.shorthand);\n          if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {\n              weekdays = __spreadArrays(weekdays.splice(firstDayOfWeek, weekdays.length), weekdays.splice(0, firstDayOfWeek));\n          }\n          for (var i = self.config.showMonths; i--;) {\n              self.weekdayContainer.children[i].innerHTML = \"\\n      <span class='flatpickr-weekday'>\\n        \" + weekdays.join(\"</span><span class='flatpickr-weekday'>\") + \"\\n      </span>\\n      \";\n          }\n      }\n      /* istanbul ignore next */\n      function buildWeeks() {\n          self.calendarContainer.classList.add(\"hasWeeks\");\n          var weekWrapper = createElement(\"div\", \"flatpickr-weekwrapper\");\n          weekWrapper.appendChild(createElement(\"span\", \"flatpickr-weekday\", self.l10n.weekAbbreviation));\n          var weekNumbers = createElement(\"div\", \"flatpickr-weeks\");\n          weekWrapper.appendChild(weekNumbers);\n          return {\n              weekWrapper: weekWrapper,\n              weekNumbers: weekNumbers,\n          };\n      }\n      function changeMonth(value, isOffset) {\n          if (isOffset === void 0) { isOffset = true; }\n          var delta = isOffset ? value : value - self.currentMonth;\n          if ((delta < 0 && self._hidePrevMonthArrow === true) ||\n              (delta > 0 && self._hideNextMonthArrow === true))\n              return;\n          self.currentMonth += delta;\n          if (self.currentMonth < 0 || self.currentMonth > 11) {\n              self.currentYear += self.currentMonth > 11 ? 1 : -1;\n              self.currentMonth = (self.currentMonth + 12) % 12;\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n          buildDays();\n          triggerEvent(\"onMonthChange\");\n          updateNavigationCurrentMonth();\n      }\n      function clear(triggerChangeEvent, toInitial) {\n          if (triggerChangeEvent === void 0) { triggerChangeEvent = true; }\n          if (toInitial === void 0) { toInitial = true; }\n          self.input.value = \"\";\n          if (self.altInput !== undefined)\n              self.altInput.value = \"\";\n          if (self.mobileInput !== undefined)\n              self.mobileInput.value = \"\";\n          self.selectedDates = [];\n          self.latestSelectedDateObj = undefined;\n          if (toInitial === true) {\n              self.currentYear = self._initialDate.getFullYear();\n              self.currentMonth = self._initialDate.getMonth();\n          }\n          if (self.config.enableTime === true) {\n              var _a = getDefaultHours(self.config), hours = _a.hours, minutes = _a.minutes, seconds = _a.seconds;\n              setHours(hours, minutes, seconds);\n          }\n          self.redraw();\n          if (triggerChangeEvent)\n              // triggerChangeEvent is true (default) or an Event\n              triggerEvent(\"onChange\");\n      }\n      function close() {\n          self.isOpen = false;\n          if (!self.isMobile) {\n              if (self.calendarContainer !== undefined) {\n                  self.calendarContainer.classList.remove(\"open\");\n              }\n              if (self._input !== undefined) {\n                  self._input.classList.remove(\"active\");\n              }\n          }\n          triggerEvent(\"onClose\");\n      }\n      function destroy() {\n          if (self.config !== undefined)\n              triggerEvent(\"onDestroy\");\n          for (var i = self._handlers.length; i--;) {\n              self._handlers[i].remove();\n          }\n          self._handlers = [];\n          if (self.mobileInput) {\n              if (self.mobileInput.parentNode)\n                  self.mobileInput.parentNode.removeChild(self.mobileInput);\n              self.mobileInput = undefined;\n          }\n          else if (self.calendarContainer && self.calendarContainer.parentNode) {\n              if (self.config.static && self.calendarContainer.parentNode) {\n                  var wrapper = self.calendarContainer.parentNode;\n                  wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);\n                  if (wrapper.parentNode) {\n                      while (wrapper.firstChild)\n                          wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);\n                      wrapper.parentNode.removeChild(wrapper);\n                  }\n              }\n              else\n                  self.calendarContainer.parentNode.removeChild(self.calendarContainer);\n          }\n          if (self.altInput) {\n              self.input.type = \"text\";\n              if (self.altInput.parentNode)\n                  self.altInput.parentNode.removeChild(self.altInput);\n              delete self.altInput;\n          }\n          if (self.input) {\n              self.input.type = self.input._type;\n              self.input.classList.remove(\"flatpickr-input\");\n              self.input.removeAttribute(\"readonly\");\n          }\n          [\n              \"_showTimeInput\",\n              \"latestSelectedDateObj\",\n              \"_hideNextMonthArrow\",\n              \"_hidePrevMonthArrow\",\n              \"__hideNextMonthArrow\",\n              \"__hidePrevMonthArrow\",\n              \"isMobile\",\n              \"isOpen\",\n              \"selectedDateElem\",\n              \"minDateHasTime\",\n              \"maxDateHasTime\",\n              \"days\",\n              \"daysContainer\",\n              \"_input\",\n              \"_positionElement\",\n              \"innerContainer\",\n              \"rContainer\",\n              \"monthNav\",\n              \"todayDateElem\",\n              \"calendarContainer\",\n              \"weekdayContainer\",\n              \"prevMonthNav\",\n              \"nextMonthNav\",\n              \"monthsDropdownContainer\",\n              \"currentMonthElement\",\n              \"currentYearElement\",\n              \"navigationCurrentMonth\",\n              \"selectedDateElem\",\n              \"config\",\n          ].forEach(function (k) {\n              try {\n                  delete self[k];\n              }\n              catch (_) { }\n          });\n      }\n      function isCalendarElem(elem) {\n          return self.calendarContainer.contains(elem);\n      }\n      function documentClick(e) {\n          if (self.isOpen && !self.config.inline) {\n              var eventTarget_1 = getEventTarget(e);\n              var isCalendarElement = isCalendarElem(eventTarget_1);\n              var isInput = eventTarget_1 === self.input ||\n                  eventTarget_1 === self.altInput ||\n                  self.element.contains(eventTarget_1) ||\n                  // web components\n                  // e.path is not present in all browsers. circumventing typechecks\n                  (e.path &&\n                      e.path.indexOf &&\n                      (~e.path.indexOf(self.input) ||\n                          ~e.path.indexOf(self.altInput)));\n              var lostFocus = !isInput &&\n                  !isCalendarElement &&\n                  !isCalendarElem(e.relatedTarget);\n              var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {\n                  return elem.contains(eventTarget_1);\n              });\n              if (lostFocus && isIgnored) {\n                  if (self.config.allowInput) {\n                      self.setDate(self._input.value, false, self.config.altInput\n                          ? self.config.altFormat\n                          : self.config.dateFormat);\n                  }\n                  if (self.timeContainer !== undefined &&\n                      self.minuteElement !== undefined &&\n                      self.hourElement !== undefined &&\n                      self.input.value !== \"\" &&\n                      self.input.value !== undefined) {\n                      updateTime();\n                  }\n                  self.close();\n                  if (self.config &&\n                      self.config.mode === \"range\" &&\n                      self.selectedDates.length === 1)\n                      self.clear(false);\n              }\n          }\n      }\n      function changeYear(newYear) {\n          if (!newYear ||\n              (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||\n              (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))\n              return;\n          var newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;\n          self.currentYear = newYearNum || self.currentYear;\n          if (self.config.maxDate &&\n              self.currentYear === self.config.maxDate.getFullYear()) {\n              self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);\n          }\n          else if (self.config.minDate &&\n              self.currentYear === self.config.minDate.getFullYear()) {\n              self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);\n          }\n          if (isNewYear) {\n              self.redraw();\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n      }\n      function isEnabled(date, timeless) {\n          var _a;\n          if (timeless === void 0) { timeless = true; }\n          var dateToCheck = self.parseDate(date, undefined, timeless); // timeless\n          if ((self.config.minDate &&\n              dateToCheck &&\n              compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||\n              (self.config.maxDate &&\n                  dateToCheck &&\n                  compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))\n              return false;\n          if (!self.config.enable && self.config.disable.length === 0)\n              return true;\n          if (dateToCheck === undefined)\n              return false;\n          var bool = !!self.config.enable, array = (_a = self.config.enable) !== null && _a !== void 0 ? _a : self.config.disable;\n          for (var i = 0, d = void 0; i < array.length; i++) {\n              d = array[i];\n              if (typeof d === \"function\" &&\n                  d(dateToCheck) // disabled by function\n              )\n                  return bool;\n              else if (d instanceof Date &&\n                  dateToCheck !== undefined &&\n                  d.getTime() === dateToCheck.getTime())\n                  // disabled by date\n                  return bool;\n              else if (typeof d === \"string\") {\n                  // disabled by date string\n                  var parsed = self.parseDate(d, undefined, true);\n                  return parsed && parsed.getTime() === dateToCheck.getTime()\n                      ? bool\n                      : !bool;\n              }\n              else if (\n              // disabled by range\n              typeof d === \"object\" &&\n                  dateToCheck !== undefined &&\n                  d.from &&\n                  d.to &&\n                  dateToCheck.getTime() >= d.from.getTime() &&\n                  dateToCheck.getTime() <= d.to.getTime())\n                  return bool;\n          }\n          return !bool;\n      }\n      function isInView(elem) {\n          if (self.daysContainer !== undefined)\n              return (elem.className.indexOf(\"hidden\") === -1 &&\n                  elem.className.indexOf(\"flatpickr-disabled\") === -1 &&\n                  self.daysContainer.contains(elem));\n          return false;\n      }\n      function onBlur(e) {\n          var isInput = e.target === self._input;\n          var valueChanged = self._input.value.trimEnd() !== getDateStr();\n          if (isInput &&\n              valueChanged &&\n              !(e.relatedTarget && isCalendarElem(e.relatedTarget))) {\n              self.setDate(self._input.value, true, e.target === self.altInput\n                  ? self.config.altFormat\n                  : self.config.dateFormat);\n          }\n      }\n      function onKeyDown(e) {\n          // e.key                      e.keyCode\n          // \"Backspace\"                        8\n          // \"Tab\"                              9\n          // \"Enter\"                           13\n          // \"Escape\"     (IE \"Esc\")           27\n          // \"ArrowLeft\"  (IE \"Left\")          37\n          // \"ArrowUp\"    (IE \"Up\")            38\n          // \"ArrowRight\" (IE \"Right\")         39\n          // \"ArrowDown\"  (IE \"Down\")          40\n          // \"Delete\"     (IE \"Del\")           46\n          var eventTarget = getEventTarget(e);\n          var isInput = self.config.wrap\n              ? element.contains(eventTarget)\n              : eventTarget === self._input;\n          var allowInput = self.config.allowInput;\n          var allowKeydown = self.isOpen && (!allowInput || !isInput);\n          var allowInlineKeydown = self.config.inline && isInput && !allowInput;\n          if (e.keyCode === 13 && isInput) {\n              if (allowInput) {\n                  self.setDate(self._input.value, true, eventTarget === self.altInput\n                      ? self.config.altFormat\n                      : self.config.dateFormat);\n                  self.close();\n                  return eventTarget.blur();\n              }\n              else {\n                  self.open();\n              }\n          }\n          else if (isCalendarElem(eventTarget) ||\n              allowKeydown ||\n              allowInlineKeydown) {\n              var isTimeObj = !!self.timeContainer &&\n                  self.timeContainer.contains(eventTarget);\n              switch (e.keyCode) {\n                  case 13:\n                      if (isTimeObj) {\n                          e.preventDefault();\n                          updateTime();\n                          focusAndClose();\n                      }\n                      else\n                          selectDate(e);\n                      break;\n                  case 27: // escape\n                      e.preventDefault();\n                      focusAndClose();\n                      break;\n                  case 8:\n                  case 46:\n                      if (isInput && !self.config.allowInput) {\n                          e.preventDefault();\n                          self.clear();\n                      }\n                      break;\n                  case 37:\n                  case 39:\n                      if (!isTimeObj && !isInput) {\n                          e.preventDefault();\n                          var activeElement = getClosestActiveElement();\n                          if (self.daysContainer !== undefined &&\n                              (allowInput === false ||\n                                  (activeElement && isInView(activeElement)))) {\n                              var delta_1 = e.keyCode === 39 ? 1 : -1;\n                              if (!e.ctrlKey)\n                                  focusOnDay(undefined, delta_1);\n                              else {\n                                  e.stopPropagation();\n                                  changeMonth(delta_1);\n                                  focusOnDay(getFirstAvailableDay(1), 0);\n                              }\n                          }\n                      }\n                      else if (self.hourElement)\n                          self.hourElement.focus();\n                      break;\n                  case 38:\n                  case 40:\n                      e.preventDefault();\n                      var delta = e.keyCode === 40 ? 1 : -1;\n                      if ((self.daysContainer &&\n                          eventTarget.$i !== undefined) ||\n                          eventTarget === self.input ||\n                          eventTarget === self.altInput) {\n                          if (e.ctrlKey) {\n                              e.stopPropagation();\n                              changeYear(self.currentYear - delta);\n                              focusOnDay(getFirstAvailableDay(1), 0);\n                          }\n                          else if (!isTimeObj)\n                              focusOnDay(undefined, delta * 7);\n                      }\n                      else if (eventTarget === self.currentYearElement) {\n                          changeYear(self.currentYear - delta);\n                      }\n                      else if (self.config.enableTime) {\n                          if (!isTimeObj && self.hourElement)\n                              self.hourElement.focus();\n                          updateTime(e);\n                          self._debouncedChange();\n                      }\n                      break;\n                  case 9:\n                      if (isTimeObj) {\n                          var elems = [\n                              self.hourElement,\n                              self.minuteElement,\n                              self.secondElement,\n                              self.amPM,\n                          ]\n                              .concat(self.pluginElements)\n                              .filter(function (x) { return x; });\n                          var i = elems.indexOf(eventTarget);\n                          if (i !== -1) {\n                              var target = elems[i + (e.shiftKey ? -1 : 1)];\n                              e.preventDefault();\n                              (target || self._input).focus();\n                          }\n                      }\n                      else if (!self.config.noCalendar &&\n                          self.daysContainer &&\n                          self.daysContainer.contains(eventTarget) &&\n                          e.shiftKey) {\n                          e.preventDefault();\n                          self._input.focus();\n                      }\n                      break;\n              }\n          }\n          if (self.amPM !== undefined && eventTarget === self.amPM) {\n              switch (e.key) {\n                  case self.l10n.amPM[0].charAt(0):\n                  case self.l10n.amPM[0].charAt(0).toLowerCase():\n                      self.amPM.textContent = self.l10n.amPM[0];\n                      setHoursFromInputs();\n                      updateValue();\n                      break;\n                  case self.l10n.amPM[1].charAt(0):\n                  case self.l10n.amPM[1].charAt(0).toLowerCase():\n                      self.amPM.textContent = self.l10n.amPM[1];\n                      setHoursFromInputs();\n                      updateValue();\n                      break;\n              }\n          }\n          if (isInput || isCalendarElem(eventTarget)) {\n              triggerEvent(\"onKeyDown\", e);\n          }\n      }\n      function onMouseOver(elem, cellClass) {\n          if (cellClass === void 0) { cellClass = \"flatpickr-day\"; }\n          if (self.selectedDates.length !== 1 ||\n              (elem &&\n                  (!elem.classList.contains(cellClass) ||\n                      elem.classList.contains(\"flatpickr-disabled\"))))\n              return;\n          var hoverDate = elem\n              ? elem.dateObj.getTime()\n              : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());\n          var containsDisabled = false;\n          var minRange = 0, maxRange = 0;\n          for (var t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {\n              if (!isEnabled(new Date(t), true)) {\n                  containsDisabled =\n                      containsDisabled || (t > rangeStartDate && t < rangeEndDate);\n                  if (t < initialDate && (!minRange || t > minRange))\n                      minRange = t;\n                  else if (t > initialDate && (!maxRange || t < maxRange))\n                      maxRange = t;\n              }\n          }\n          var hoverableCells = Array.from(self.rContainer.querySelectorAll(\"*:nth-child(-n+\" + self.config.showMonths + \") > .\" + cellClass));\n          hoverableCells.forEach(function (dayElem) {\n              var date = dayElem.dateObj;\n              var timestamp = date.getTime();\n              var outOfRange = (minRange > 0 && timestamp < minRange) ||\n                  (maxRange > 0 && timestamp > maxRange);\n              if (outOfRange) {\n                  dayElem.classList.add(\"notAllowed\");\n                  [\"inRange\", \"startRange\", \"endRange\"].forEach(function (c) {\n                      dayElem.classList.remove(c);\n                  });\n                  return;\n              }\n              else if (containsDisabled && !outOfRange)\n                  return;\n              [\"startRange\", \"inRange\", \"endRange\", \"notAllowed\"].forEach(function (c) {\n                  dayElem.classList.remove(c);\n              });\n              if (elem !== undefined) {\n                  elem.classList.add(hoverDate <= self.selectedDates[0].getTime()\n                      ? \"startRange\"\n                      : \"endRange\");\n                  if (initialDate < hoverDate && timestamp === initialDate)\n                      dayElem.classList.add(\"startRange\");\n                  else if (initialDate > hoverDate && timestamp === initialDate)\n                      dayElem.classList.add(\"endRange\");\n                  if (timestamp >= minRange &&\n                      (maxRange === 0 || timestamp <= maxRange) &&\n                      isBetween(timestamp, initialDate, hoverDate))\n                      dayElem.classList.add(\"inRange\");\n              }\n          });\n      }\n      function onResize() {\n          if (self.isOpen && !self.config.static && !self.config.inline)\n              positionCalendar();\n      }\n      function open(e, positionElement) {\n          if (positionElement === void 0) { positionElement = self._positionElement; }\n          if (self.isMobile === true) {\n              if (e) {\n                  e.preventDefault();\n                  var eventTarget = getEventTarget(e);\n                  if (eventTarget) {\n                      eventTarget.blur();\n                  }\n              }\n              if (self.mobileInput !== undefined) {\n                  self.mobileInput.focus();\n                  self.mobileInput.click();\n              }\n              triggerEvent(\"onOpen\");\n              return;\n          }\n          else if (self._input.disabled || self.config.inline) {\n              return;\n          }\n          var wasOpen = self.isOpen;\n          self.isOpen = true;\n          if (!wasOpen) {\n              self.calendarContainer.classList.add(\"open\");\n              self._input.classList.add(\"active\");\n              triggerEvent(\"onOpen\");\n              positionCalendar(positionElement);\n          }\n          if (self.config.enableTime === true && self.config.noCalendar === true) {\n              if (self.config.allowInput === false &&\n                  (e === undefined ||\n                      !self.timeContainer.contains(e.relatedTarget))) {\n                  setTimeout(function () { return self.hourElement.select(); }, 50);\n              }\n          }\n      }\n      function minMaxDateSetter(type) {\n          return function (date) {\n              var dateObj = (self.config[\"_\" + type + \"Date\"] = self.parseDate(date, self.config.dateFormat));\n              var inverseDateObj = self.config[\"_\" + (type === \"min\" ? \"max\" : \"min\") + \"Date\"];\n              if (dateObj !== undefined) {\n                  self[type === \"min\" ? \"minDateHasTime\" : \"maxDateHasTime\"] =\n                      dateObj.getHours() > 0 ||\n                          dateObj.getMinutes() > 0 ||\n                          dateObj.getSeconds() > 0;\n              }\n              if (self.selectedDates) {\n                  self.selectedDates = self.selectedDates.filter(function (d) { return isEnabled(d); });\n                  if (!self.selectedDates.length && type === \"min\")\n                      setHoursFromDate(dateObj);\n                  updateValue();\n              }\n              if (self.daysContainer) {\n                  redraw();\n                  if (dateObj !== undefined)\n                      self.currentYearElement[type] = dateObj.getFullYear().toString();\n                  else\n                      self.currentYearElement.removeAttribute(type);\n                  self.currentYearElement.disabled =\n                      !!inverseDateObj &&\n                          dateObj !== undefined &&\n                          inverseDateObj.getFullYear() === dateObj.getFullYear();\n              }\n          };\n      }\n      function parseConfig() {\n          var boolOpts = [\n              \"wrap\",\n              \"weekNumbers\",\n              \"allowInput\",\n              \"allowInvalidPreload\",\n              \"clickOpens\",\n              \"time_24hr\",\n              \"enableTime\",\n              \"noCalendar\",\n              \"altInput\",\n              \"shorthandCurrentMonth\",\n              \"inline\",\n              \"static\",\n              \"enableSeconds\",\n              \"disableMobile\",\n          ];\n          var userConfig = __assign(__assign({}, JSON.parse(JSON.stringify(element.dataset || {}))), instanceConfig);\n          var formats = {};\n          self.config.parseDate = userConfig.parseDate;\n          self.config.formatDate = userConfig.formatDate;\n          Object.defineProperty(self.config, \"enable\", {\n              get: function () { return self.config._enable; },\n              set: function (dates) {\n                  self.config._enable = parseDateRules(dates);\n              },\n          });\n          Object.defineProperty(self.config, \"disable\", {\n              get: function () { return self.config._disable; },\n              set: function (dates) {\n                  self.config._disable = parseDateRules(dates);\n              },\n          });\n          var timeMode = userConfig.mode === \"time\";\n          if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {\n              var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;\n              formats.dateFormat =\n                  userConfig.noCalendar || timeMode\n                      ? \"H:i\" + (userConfig.enableSeconds ? \":S\" : \"\")\n                      : defaultDateFormat + \" H:i\" + (userConfig.enableSeconds ? \":S\" : \"\");\n          }\n          if (userConfig.altInput &&\n              (userConfig.enableTime || timeMode) &&\n              !userConfig.altFormat) {\n              var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;\n              formats.altFormat =\n                  userConfig.noCalendar || timeMode\n                      ? \"h:i\" + (userConfig.enableSeconds ? \":S K\" : \" K\")\n                      : defaultAltFormat + (\" h:i\" + (userConfig.enableSeconds ? \":S\" : \"\") + \" K\");\n          }\n          Object.defineProperty(self.config, \"minDate\", {\n              get: function () { return self.config._minDate; },\n              set: minMaxDateSetter(\"min\"),\n          });\n          Object.defineProperty(self.config, \"maxDate\", {\n              get: function () { return self.config._maxDate; },\n              set: minMaxDateSetter(\"max\"),\n          });\n          var minMaxTimeSetter = function (type) { return function (val) {\n              self.config[type === \"min\" ? \"_minTime\" : \"_maxTime\"] = self.parseDate(val, \"H:i:S\");\n          }; };\n          Object.defineProperty(self.config, \"minTime\", {\n              get: function () { return self.config._minTime; },\n              set: minMaxTimeSetter(\"min\"),\n          });\n          Object.defineProperty(self.config, \"maxTime\", {\n              get: function () { return self.config._maxTime; },\n              set: minMaxTimeSetter(\"max\"),\n          });\n          if (userConfig.mode === \"time\") {\n              self.config.noCalendar = true;\n              self.config.enableTime = true;\n          }\n          Object.assign(self.config, formats, userConfig);\n          for (var i = 0; i < boolOpts.length; i++)\n              // https://github.com/microsoft/TypeScript/issues/31663\n              self.config[boolOpts[i]] =\n                  self.config[boolOpts[i]] === true ||\n                      self.config[boolOpts[i]] === \"true\";\n          HOOKS.filter(function (hook) { return self.config[hook] !== undefined; }).forEach(function (hook) {\n              self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);\n          });\n          self.isMobile =\n              !self.config.disableMobile &&\n                  !self.config.inline &&\n                  self.config.mode === \"single\" &&\n                  !self.config.disable.length &&\n                  !self.config.enable &&\n                  !self.config.weekNumbers &&\n                  /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n          for (var i = 0; i < self.config.plugins.length; i++) {\n              var pluginConf = self.config.plugins[i](self) || {};\n              for (var key in pluginConf) {\n                  if (HOOKS.indexOf(key) > -1) {\n                      self.config[key] = arrayify(pluginConf[key])\n                          .map(bindToInstance)\n                          .concat(self.config[key]);\n                  }\n                  else if (typeof userConfig[key] === \"undefined\")\n                      self.config[key] = pluginConf[key];\n              }\n          }\n          if (!userConfig.altInputClass) {\n              self.config.altInputClass =\n                  getInputElem().className + \" \" + self.config.altInputClass;\n          }\n          triggerEvent(\"onParseConfig\");\n      }\n      function getInputElem() {\n          return self.config.wrap\n              ? element.querySelector(\"[data-input]\")\n              : element;\n      }\n      function setupLocale() {\n          if (typeof self.config.locale !== \"object\" &&\n              typeof flatpickr.l10ns[self.config.locale] === \"undefined\")\n              self.config.errorHandler(new Error(\"flatpickr: invalid locale \" + self.config.locale));\n          self.l10n = __assign(__assign({}, flatpickr.l10ns.default), (typeof self.config.locale === \"object\"\n              ? self.config.locale\n              : self.config.locale !== \"default\"\n                  ? flatpickr.l10ns[self.config.locale]\n                  : undefined));\n          tokenRegex.D = \"(\" + self.l10n.weekdays.shorthand.join(\"|\") + \")\";\n          tokenRegex.l = \"(\" + self.l10n.weekdays.longhand.join(\"|\") + \")\";\n          tokenRegex.M = \"(\" + self.l10n.months.shorthand.join(\"|\") + \")\";\n          tokenRegex.F = \"(\" + self.l10n.months.longhand.join(\"|\") + \")\";\n          tokenRegex.K = \"(\" + self.l10n.amPM[0] + \"|\" + self.l10n.amPM[1] + \"|\" + self.l10n.amPM[0].toLowerCase() + \"|\" + self.l10n.amPM[1].toLowerCase() + \")\";\n          var userConfig = __assign(__assign({}, instanceConfig), JSON.parse(JSON.stringify(element.dataset || {})));\n          if (userConfig.time_24hr === undefined &&\n              flatpickr.defaultConfig.time_24hr === undefined) {\n              self.config.time_24hr = self.l10n.time_24hr;\n          }\n          self.formatDate = createDateFormatter(self);\n          self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n      }\n      function positionCalendar(customPositionElement) {\n          if (typeof self.config.position === \"function\") {\n              return void self.config.position(self, customPositionElement);\n          }\n          if (self.calendarContainer === undefined)\n              return;\n          triggerEvent(\"onPreCalendarPosition\");\n          var positionElement = customPositionElement || self._positionElement;\n          var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, (function (acc, child) { return acc + child.offsetHeight; }), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(\" \"), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === \"above\" ||\n              (configPosVertical !== \"below\" &&\n                  distanceFromBottom < calendarHeight &&\n                  inputBounds.top > calendarHeight);\n          var top = window.pageYOffset +\n              inputBounds.top +\n              (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);\n          toggleClass(self.calendarContainer, \"arrowTop\", !showOnTop);\n          toggleClass(self.calendarContainer, \"arrowBottom\", showOnTop);\n          if (self.config.inline)\n              return;\n          var left = window.pageXOffset + inputBounds.left;\n          var isCenter = false;\n          var isRight = false;\n          if (configPosHorizontal === \"center\") {\n              left -= (calendarWidth - inputBounds.width) / 2;\n              isCenter = true;\n          }\n          else if (configPosHorizontal === \"right\") {\n              left -= calendarWidth - inputBounds.width;\n              isRight = true;\n          }\n          toggleClass(self.calendarContainer, \"arrowLeft\", !isCenter && !isRight);\n          toggleClass(self.calendarContainer, \"arrowCenter\", isCenter);\n          toggleClass(self.calendarContainer, \"arrowRight\", isRight);\n          var right = window.document.body.offsetWidth -\n              (window.pageXOffset + inputBounds.right);\n          var rightMost = left + calendarWidth > window.document.body.offsetWidth;\n          var centerMost = right + calendarWidth > window.document.body.offsetWidth;\n          toggleClass(self.calendarContainer, \"rightMost\", rightMost);\n          if (self.config.static)\n              return;\n          self.calendarContainer.style.top = top + \"px\";\n          if (!rightMost) {\n              self.calendarContainer.style.left = left + \"px\";\n              self.calendarContainer.style.right = \"auto\";\n          }\n          else if (!centerMost) {\n              self.calendarContainer.style.left = \"auto\";\n              self.calendarContainer.style.right = right + \"px\";\n          }\n          else {\n              var doc = getDocumentStyleSheet();\n              // some testing environments don't have css support\n              if (doc === undefined)\n                  return;\n              var bodyWidth = window.document.body.offsetWidth;\n              var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);\n              var centerBefore = \".flatpickr-calendar.centerMost:before\";\n              var centerAfter = \".flatpickr-calendar.centerMost:after\";\n              var centerIndex = doc.cssRules.length;\n              var centerStyle = \"{left:\" + inputBounds.left + \"px;right:auto;}\";\n              toggleClass(self.calendarContainer, \"rightMost\", false);\n              toggleClass(self.calendarContainer, \"centerMost\", true);\n              doc.insertRule(centerBefore + \",\" + centerAfter + centerStyle, centerIndex);\n              self.calendarContainer.style.left = centerLeft + \"px\";\n              self.calendarContainer.style.right = \"auto\";\n          }\n      }\n      function getDocumentStyleSheet() {\n          var editableSheet = null;\n          for (var i = 0; i < document.styleSheets.length; i++) {\n              var sheet = document.styleSheets[i];\n              if (!sheet.cssRules)\n                  continue;\n              try {\n                  sheet.cssRules;\n              }\n              catch (err) {\n                  continue;\n              }\n              editableSheet = sheet;\n              break;\n          }\n          return editableSheet != null ? editableSheet : createStyleSheet();\n      }\n      function createStyleSheet() {\n          var style = document.createElement(\"style\");\n          document.head.appendChild(style);\n          return style.sheet;\n      }\n      function redraw() {\n          if (self.config.noCalendar || self.isMobile)\n              return;\n          buildMonthSwitch();\n          updateNavigationCurrentMonth();\n          buildDays();\n      }\n      function focusAndClose() {\n          self._input.focus();\n          if (window.navigator.userAgent.indexOf(\"MSIE\") !== -1 ||\n              navigator.msMaxTouchPoints !== undefined) {\n              // hack - bugs in the way IE handles focus keeps the calendar open\n              setTimeout(self.close, 0);\n          }\n          else {\n              self.close();\n          }\n      }\n      function selectDate(e) {\n          e.preventDefault();\n          e.stopPropagation();\n          var isSelectable = function (day) {\n              return day.classList &&\n                  day.classList.contains(\"flatpickr-day\") &&\n                  !day.classList.contains(\"flatpickr-disabled\") &&\n                  !day.classList.contains(\"notAllowed\");\n          };\n          var t = findParent(getEventTarget(e), isSelectable);\n          if (t === undefined)\n              return;\n          var target = t;\n          var selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));\n          var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||\n              selectedDate.getMonth() >\n                  self.currentMonth + self.config.showMonths - 1) &&\n              self.config.mode !== \"range\";\n          self.selectedDateElem = target;\n          if (self.config.mode === \"single\")\n              self.selectedDates = [selectedDate];\n          else if (self.config.mode === \"multiple\") {\n              var selectedIndex = isDateSelected(selectedDate);\n              if (selectedIndex)\n                  self.selectedDates.splice(parseInt(selectedIndex), 1);\n              else\n                  self.selectedDates.push(selectedDate);\n          }\n          else if (self.config.mode === \"range\") {\n              if (self.selectedDates.length === 2) {\n                  self.clear(false, false);\n              }\n              self.latestSelectedDateObj = selectedDate;\n              self.selectedDates.push(selectedDate);\n              // unless selecting same date twice, sort ascendingly\n              if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)\n                  self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n          }\n          setHoursFromInputs();\n          if (shouldChangeMonth) {\n              var isNewYear = self.currentYear !== selectedDate.getFullYear();\n              self.currentYear = selectedDate.getFullYear();\n              self.currentMonth = selectedDate.getMonth();\n              if (isNewYear) {\n                  triggerEvent(\"onYearChange\");\n                  buildMonthSwitch();\n              }\n              triggerEvent(\"onMonthChange\");\n          }\n          updateNavigationCurrentMonth();\n          buildDays();\n          updateValue();\n          // maintain focus\n          if (!shouldChangeMonth &&\n              self.config.mode !== \"range\" &&\n              self.config.showMonths === 1)\n              focusOnDayElem(target);\n          else if (self.selectedDateElem !== undefined &&\n              self.hourElement === undefined) {\n              self.selectedDateElem && self.selectedDateElem.focus();\n          }\n          if (self.hourElement !== undefined)\n              self.hourElement !== undefined && self.hourElement.focus();\n          if (self.config.closeOnSelect) {\n              var single = self.config.mode === \"single\" && !self.config.enableTime;\n              var range = self.config.mode === \"range\" &&\n                  self.selectedDates.length === 2 &&\n                  !self.config.enableTime;\n              if (single || range) {\n                  focusAndClose();\n              }\n          }\n          triggerChange();\n      }\n      var CALLBACKS = {\n          locale: [setupLocale, updateWeekdays],\n          showMonths: [buildMonths, setCalendarWidth, buildWeekdays],\n          minDate: [jumpToDate],\n          maxDate: [jumpToDate],\n          positionElement: [updatePositionElement],\n          clickOpens: [\n              function () {\n                  if (self.config.clickOpens === true) {\n                      bind(self._input, \"focus\", self.open);\n                      bind(self._input, \"click\", self.open);\n                  }\n                  else {\n                      self._input.removeEventListener(\"focus\", self.open);\n                      self._input.removeEventListener(\"click\", self.open);\n                  }\n              },\n          ],\n      };\n      function set(option, value) {\n          if (option !== null && typeof option === \"object\") {\n              Object.assign(self.config, option);\n              for (var key in option) {\n                  if (CALLBACKS[key] !== undefined)\n                      CALLBACKS[key].forEach(function (x) { return x(); });\n              }\n          }\n          else {\n              self.config[option] = value;\n              if (CALLBACKS[option] !== undefined)\n                  CALLBACKS[option].forEach(function (x) { return x(); });\n              else if (HOOKS.indexOf(option) > -1)\n                  self.config[option] = arrayify(value);\n          }\n          self.redraw();\n          updateValue(true);\n      }\n      function setSelectedDate(inputDate, format) {\n          var dates = [];\n          if (inputDate instanceof Array)\n              dates = inputDate.map(function (d) { return self.parseDate(d, format); });\n          else if (inputDate instanceof Date || typeof inputDate === \"number\")\n              dates = [self.parseDate(inputDate, format)];\n          else if (typeof inputDate === \"string\") {\n              switch (self.config.mode) {\n                  case \"single\":\n                  case \"time\":\n                      dates = [self.parseDate(inputDate, format)];\n                      break;\n                  case \"multiple\":\n                      dates = inputDate\n                          .split(self.config.conjunction)\n                          .map(function (date) { return self.parseDate(date, format); });\n                      break;\n                  case \"range\":\n                      dates = inputDate\n                          .split(self.l10n.rangeSeparator)\n                          .map(function (date) { return self.parseDate(date, format); });\n                      break;\n              }\n          }\n          else\n              self.config.errorHandler(new Error(\"Invalid date supplied: \" + JSON.stringify(inputDate)));\n          self.selectedDates = (self.config.allowInvalidPreload\n              ? dates\n              : dates.filter(function (d) { return d instanceof Date && isEnabled(d, false); }));\n          if (self.config.mode === \"range\")\n              self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n      }\n      function setDate(date, triggerChange, format) {\n          if (triggerChange === void 0) { triggerChange = false; }\n          if (format === void 0) { format = self.config.dateFormat; }\n          if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))\n              return self.clear(triggerChange);\n          setSelectedDate(date, format);\n          self.latestSelectedDateObj =\n              self.selectedDates[self.selectedDates.length - 1];\n          self.redraw();\n          jumpToDate(undefined, triggerChange);\n          setHoursFromDate();\n          if (self.selectedDates.length === 0) {\n              self.clear(false);\n          }\n          updateValue(triggerChange);\n          if (triggerChange)\n              triggerEvent(\"onChange\");\n      }\n      function parseDateRules(arr) {\n          return arr\n              .slice()\n              .map(function (rule) {\n              if (typeof rule === \"string\" ||\n                  typeof rule === \"number\" ||\n                  rule instanceof Date) {\n                  return self.parseDate(rule, undefined, true);\n              }\n              else if (rule &&\n                  typeof rule === \"object\" &&\n                  rule.from &&\n                  rule.to)\n                  return {\n                      from: self.parseDate(rule.from, undefined),\n                      to: self.parseDate(rule.to, undefined),\n                  };\n              return rule;\n          })\n              .filter(function (x) { return x; }); // remove falsy values\n      }\n      function setupDates() {\n          self.selectedDates = [];\n          self.now = self.parseDate(self.config.now) || new Date();\n          // Workaround IE11 setting placeholder as the input's value\n          var preloadedDate = self.config.defaultDate ||\n              ((self.input.nodeName === \"INPUT\" ||\n                  self.input.nodeName === \"TEXTAREA\") &&\n                  self.input.placeholder &&\n                  self.input.value === self.input.placeholder\n                  ? null\n                  : self.input.value);\n          if (preloadedDate)\n              setSelectedDate(preloadedDate, self.config.dateFormat);\n          self._initialDate =\n              self.selectedDates.length > 0\n                  ? self.selectedDates[0]\n                  : self.config.minDate &&\n                      self.config.minDate.getTime() > self.now.getTime()\n                      ? self.config.minDate\n                      : self.config.maxDate &&\n                          self.config.maxDate.getTime() < self.now.getTime()\n                          ? self.config.maxDate\n                          : self.now;\n          self.currentYear = self._initialDate.getFullYear();\n          self.currentMonth = self._initialDate.getMonth();\n          if (self.selectedDates.length > 0)\n              self.latestSelectedDateObj = self.selectedDates[0];\n          if (self.config.minTime !== undefined)\n              self.config.minTime = self.parseDate(self.config.minTime, \"H:i\");\n          if (self.config.maxTime !== undefined)\n              self.config.maxTime = self.parseDate(self.config.maxTime, \"H:i\");\n          self.minDateHasTime =\n              !!self.config.minDate &&\n                  (self.config.minDate.getHours() > 0 ||\n                      self.config.minDate.getMinutes() > 0 ||\n                      self.config.minDate.getSeconds() > 0);\n          self.maxDateHasTime =\n              !!self.config.maxDate &&\n                  (self.config.maxDate.getHours() > 0 ||\n                      self.config.maxDate.getMinutes() > 0 ||\n                      self.config.maxDate.getSeconds() > 0);\n      }\n      function setupInputs() {\n          self.input = getInputElem();\n          /* istanbul ignore next */\n          if (!self.input) {\n              self.config.errorHandler(new Error(\"Invalid input element specified\"));\n              return;\n          }\n          // hack: store previous type to restore it after destroy()\n          self.input._type = self.input.type;\n          self.input.type = \"text\";\n          self.input.classList.add(\"flatpickr-input\");\n          self._input = self.input;\n          if (self.config.altInput) {\n              // replicate self.element\n              self.altInput = createElement(self.input.nodeName, self.config.altInputClass);\n              self._input = self.altInput;\n              self.altInput.placeholder = self.input.placeholder;\n              self.altInput.disabled = self.input.disabled;\n              self.altInput.required = self.input.required;\n              self.altInput.tabIndex = self.input.tabIndex;\n              self.altInput.type = \"text\";\n              self.input.setAttribute(\"type\", \"hidden\");\n              if (!self.config.static && self.input.parentNode)\n                  self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);\n          }\n          if (!self.config.allowInput)\n              self._input.setAttribute(\"readonly\", \"readonly\");\n          updatePositionElement();\n      }\n      function updatePositionElement() {\n          self._positionElement = self.config.positionElement || self._input;\n      }\n      function setupMobile() {\n          var inputType = self.config.enableTime\n              ? self.config.noCalendar\n                  ? \"time\"\n                  : \"datetime-local\"\n              : \"date\";\n          self.mobileInput = createElement(\"input\", self.input.className + \" flatpickr-mobile\");\n          self.mobileInput.tabIndex = 1;\n          self.mobileInput.type = inputType;\n          self.mobileInput.disabled = self.input.disabled;\n          self.mobileInput.required = self.input.required;\n          self.mobileInput.placeholder = self.input.placeholder;\n          self.mobileFormatStr =\n              inputType === \"datetime-local\"\n                  ? \"Y-m-d\\\\TH:i:S\"\n                  : inputType === \"date\"\n                      ? \"Y-m-d\"\n                      : \"H:i:S\";\n          if (self.selectedDates.length > 0) {\n              self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);\n          }\n          if (self.config.minDate)\n              self.mobileInput.min = self.formatDate(self.config.minDate, \"Y-m-d\");\n          if (self.config.maxDate)\n              self.mobileInput.max = self.formatDate(self.config.maxDate, \"Y-m-d\");\n          if (self.input.getAttribute(\"step\"))\n              self.mobileInput.step = String(self.input.getAttribute(\"step\"));\n          self.input.type = \"hidden\";\n          if (self.altInput !== undefined)\n              self.altInput.type = \"hidden\";\n          try {\n              if (self.input.parentNode)\n                  self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);\n          }\n          catch (_a) { }\n          bind(self.mobileInput, \"change\", function (e) {\n              self.setDate(getEventTarget(e).value, false, self.mobileFormatStr);\n              triggerEvent(\"onChange\");\n              triggerEvent(\"onClose\");\n          });\n      }\n      function toggle(e) {\n          if (self.isOpen === true)\n              return self.close();\n          self.open(e);\n      }\n      function triggerEvent(event, data) {\n          // If the instance has been destroyed already, all hooks have been removed\n          if (self.config === undefined)\n              return;\n          var hooks = self.config[event];\n          if (hooks !== undefined && hooks.length > 0) {\n              for (var i = 0; hooks[i] && i < hooks.length; i++)\n                  hooks[i](self.selectedDates, self.input.value, self, data);\n          }\n          if (event === \"onChange\") {\n              self.input.dispatchEvent(createEvent(\"change\"));\n              // many front-end frameworks bind to the input event\n              self.input.dispatchEvent(createEvent(\"input\"));\n          }\n      }\n      function createEvent(name) {\n          var e = document.createEvent(\"Event\");\n          e.initEvent(name, true, true);\n          return e;\n      }\n      function isDateSelected(date) {\n          for (var i = 0; i < self.selectedDates.length; i++) {\n              var selectedDate = self.selectedDates[i];\n              if (selectedDate instanceof Date &&\n                  compareDates(selectedDate, date) === 0)\n                  return \"\" + i;\n          }\n          return false;\n      }\n      function isDateInRange(date) {\n          if (self.config.mode !== \"range\" || self.selectedDates.length < 2)\n              return false;\n          return (compareDates(date, self.selectedDates[0]) >= 0 &&\n              compareDates(date, self.selectedDates[1]) <= 0);\n      }\n      function updateNavigationCurrentMonth() {\n          if (self.config.noCalendar || self.isMobile || !self.monthNav)\n              return;\n          self.yearElements.forEach(function (yearElement, i) {\n              var d = new Date(self.currentYear, self.currentMonth, 1);\n              d.setMonth(self.currentMonth + i);\n              if (self.config.showMonths > 1 ||\n                  self.config.monthSelectorType === \"static\") {\n                  self.monthElements[i].textContent =\n                      monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + \" \";\n              }\n              else {\n                  self.monthsDropdownContainer.value = d.getMonth().toString();\n              }\n              yearElement.value = d.getFullYear().toString();\n          });\n          self._hidePrevMonthArrow =\n              self.config.minDate !== undefined &&\n                  (self.currentYear === self.config.minDate.getFullYear()\n                      ? self.currentMonth <= self.config.minDate.getMonth()\n                      : self.currentYear < self.config.minDate.getFullYear());\n          self._hideNextMonthArrow =\n              self.config.maxDate !== undefined &&\n                  (self.currentYear === self.config.maxDate.getFullYear()\n                      ? self.currentMonth + 1 > self.config.maxDate.getMonth()\n                      : self.currentYear > self.config.maxDate.getFullYear());\n      }\n      function getDateStr(specificFormat) {\n          var format = specificFormat ||\n              (self.config.altInput ? self.config.altFormat : self.config.dateFormat);\n          return self.selectedDates\n              .map(function (dObj) { return self.formatDate(dObj, format); })\n              .filter(function (d, i, arr) {\n              return self.config.mode !== \"range\" ||\n                  self.config.enableTime ||\n                  arr.indexOf(d) === i;\n          })\n              .join(self.config.mode !== \"range\"\n              ? self.config.conjunction\n              : self.l10n.rangeSeparator);\n      }\n      /**\n       * Updates the values of inputs associated with the calendar\n       */\n      function updateValue(triggerChange) {\n          if (triggerChange === void 0) { triggerChange = true; }\n          if (self.mobileInput !== undefined && self.mobileFormatStr) {\n              self.mobileInput.value =\n                  self.latestSelectedDateObj !== undefined\n                      ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)\n                      : \"\";\n          }\n          self.input.value = getDateStr(self.config.dateFormat);\n          if (self.altInput !== undefined) {\n              self.altInput.value = getDateStr(self.config.altFormat);\n          }\n          if (triggerChange !== false)\n              triggerEvent(\"onValueUpdate\");\n      }\n      function onMonthNavClick(e) {\n          var eventTarget = getEventTarget(e);\n          var isPrevMonth = self.prevMonthNav.contains(eventTarget);\n          var isNextMonth = self.nextMonthNav.contains(eventTarget);\n          if (isPrevMonth || isNextMonth) {\n              changeMonth(isPrevMonth ? -1 : 1);\n          }\n          else if (self.yearElements.indexOf(eventTarget) >= 0) {\n              eventTarget.select();\n          }\n          else if (eventTarget.classList.contains(\"arrowUp\")) {\n              self.changeYear(self.currentYear + 1);\n          }\n          else if (eventTarget.classList.contains(\"arrowDown\")) {\n              self.changeYear(self.currentYear - 1);\n          }\n      }\n      function timeWrapper(e) {\n          e.preventDefault();\n          var isKeyDown = e.type === \"keydown\", eventTarget = getEventTarget(e), input = eventTarget;\n          if (self.amPM !== undefined && eventTarget === self.amPM) {\n              self.amPM.textContent =\n                  self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n          }\n          var min = parseFloat(input.getAttribute(\"min\")), max = parseFloat(input.getAttribute(\"max\")), step = parseFloat(input.getAttribute(\"step\")), curValue = parseInt(input.value, 10), delta = e.delta ||\n              (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);\n          var newValue = curValue + step * delta;\n          if (typeof input.value !== \"undefined\" && input.value.length === 2) {\n              var isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;\n              if (newValue < min) {\n                  newValue =\n                      max +\n                          newValue +\n                          int(!isHourElem) +\n                          (int(isHourElem) && int(!self.amPM));\n                  if (isMinuteElem)\n                      incrementNumInput(undefined, -1, self.hourElement);\n              }\n              else if (newValue > max) {\n                  newValue =\n                      input === self.hourElement ? newValue - max - int(!self.amPM) : min;\n                  if (isMinuteElem)\n                      incrementNumInput(undefined, 1, self.hourElement);\n              }\n              if (self.amPM &&\n                  isHourElem &&\n                  (step === 1\n                      ? newValue + curValue === 23\n                      : Math.abs(newValue - curValue) > step)) {\n                  self.amPM.textContent =\n                      self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n              }\n              input.value = pad(newValue);\n          }\n      }\n      init();\n      return self;\n  }\n  /* istanbul ignore next */\n  function _flatpickr(nodeList, config) {\n      // static list\n      var nodes = Array.prototype.slice\n          .call(nodeList)\n          .filter(function (x) { return x instanceof HTMLElement; });\n      var instances = [];\n      for (var i = 0; i < nodes.length; i++) {\n          var node = nodes[i];\n          try {\n              if (node.getAttribute(\"data-fp-omit\") !== null)\n                  continue;\n              if (node._flatpickr !== undefined) {\n                  node._flatpickr.destroy();\n                  node._flatpickr = undefined;\n              }\n              node._flatpickr = FlatpickrInstance(node, config || {});\n              instances.push(node._flatpickr);\n          }\n          catch (e) {\n              console.error(e);\n          }\n      }\n      return instances.length === 1 ? instances[0] : instances;\n  }\n  /* istanbul ignore next */\n  if (typeof HTMLElement !== \"undefined\" &&\n      typeof HTMLCollection !== \"undefined\" &&\n      typeof NodeList !== \"undefined\") {\n      // browser env\n      HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {\n          return _flatpickr(this, config);\n      };\n      HTMLElement.prototype.flatpickr = function (config) {\n          return _flatpickr([this], config);\n      };\n  }\n  /* istanbul ignore next */\n  var flatpickr = function (selector, config) {\n      if (typeof selector === \"string\") {\n          return _flatpickr(window.document.querySelectorAll(selector), config);\n      }\n      else if (selector instanceof Node) {\n          return _flatpickr([selector], config);\n      }\n      else {\n          return _flatpickr(selector, config);\n      }\n  };\n  /* istanbul ignore next */\n  flatpickr.defaultConfig = {};\n  flatpickr.l10ns = {\n      en: __assign({}, english),\n      default: __assign({}, english),\n  };\n  flatpickr.localize = function (l10n) {\n      flatpickr.l10ns.default = __assign(__assign({}, flatpickr.l10ns.default), l10n);\n  };\n  flatpickr.setDefaults = function (config) {\n      flatpickr.defaultConfig = __assign(__assign({}, flatpickr.defaultConfig), config);\n  };\n  flatpickr.parseDate = createDateParser({});\n  flatpickr.formatDate = createDateFormatter({});\n  flatpickr.compareDates = compareDates;\n  /* istanbul ignore next */\n  if (typeof jQuery !== \"undefined\" && typeof jQuery.fn !== \"undefined\") {\n      jQuery.fn.flatpickr = function (config) {\n          return _flatpickr(this, config);\n      };\n  }\n  Date.prototype.fp_incr = function (days) {\n      return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === \"string\" ? parseInt(days, 10) : days));\n  };\n  if (typeof window !== \"undefined\") {\n      window.flatpickr = flatpickr;\n  }\n\n  return flatpickr;\n\n})));","Webkul_AdvancedBookingSystem/js/tablebooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    'mage/translate',\n    \"mage/calendar\"\n], function ($, alert, mageTemplate, $t) {\n    'use strict';\n    $.widget(\n        'tablebooking.tablebooking',\n        {\n            options: {\n            },\n            _create: function () {\n                var self = this;\n                var monthArr = self.options.monthArr;\n                var todaySlotArr = self.options.todaySlotArr;\n                var options = JSON.parse(self.options.optionsJson);\n                var holidaysData = self.options.holidaysData;\n                var isTodayHoliday = self.options.isTodayHoliday;\n                $(\"#wk-bk-select-date\").datepicker({\n                    'dateFormat':'mm/dd/yy',\n                    'minDate': 'today',\n                    'maxDate': self.options.bookingAvailableTo,\n                    'beforeShowDay': function (date) {\n                        let string = $.datepicker.formatDate('yy-mm-dd', date);\n                        let holiday = holidaysData[string];\n                        if(holiday){\n                            return [false,'',holiday];\n                        }\n                        return [true];\n                    },\n                });\n                todaySlotArr.now = parseInt(Date.now()/1000);\n                console.log(todaySlotArr.now);\n                todaySlotArr.activeFirst = 0;\n                if(!isTodayHoliday){\n                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n                    tmpl;\n                    tmpl = progressTmpl({\n                        data: todaySlotArr\n                    });\n                    $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n                }\n                if (self.options.priceRangeText.length) {\n                    $('#product-price-'+self.options.productId).after(\n                        '<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+self.options.priceRangeText+'</span>'\n                    );\n                }\n\n                var selectedTime = $('.wk-bk-slot-selected').text();\n                $('#wk-bk-booking-time-field').val(selectedTime);\n                $('#wk-bk-booking-time-field').next('.wk-bk-select-time-label').text(selectedTime);\n                if (!selectedTime) {\n                    $('#wk-bk-booking-time-field').next('.wk-bk-select-time-label').text($t('Closed'));\n                }\n                self._setProductOptions($('.wk-bk-slot-selected'), options);\n\n                $(\"body\").on('change', '#wk-bk-select-date', function () {\n                    var selectedDate  = $(this).val();\n\n                    var parsedDate = Date.parse(selectedDate, \"yyyy-MM-dd\");\n                    var str = parsedDate.toString();\n                    parsedDate = str.substr(0, str.length-3);\n\n                    var selectedDateArr  = selectedDate.split('/');\n                    var day = selectedDateArr[1];\n                    var month = selectedDateArr[0];\n                    var year = selectedDateArr[2];\n                    var formatedDate = day+\" \"+monthArr[month]+\", \"+year;\n                    let optionDate = year+\"-\"+month+\"-\"+day;\n                    var d = new Date(selectedDate);\n                    var dayIndex = d.getDay();\n                    if (dayIndex == 0) {\n                        dayIndex = 7;\n                    }\n\n                    var todayDate = new Date();\n                    var tday = todayDate.getDate();\n                    var tmonth = todayDate.getMonth() + 1;\n                    var tyear = todayDate.getFullYear();\n                    // if from selected date is today\n                    if (day == tday && month == tmonth && year == tyear) {\n                        if(!isTodayHoliday){\n                            var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: todaySlotArr\n                            });\n                        }\n                    } else {\n                        var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template'+dayIndex),\n                        tmpl;\n                        tmpl = progressTmpl({\n                            data: {}\n                        });\n                    }\n\n                    $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n\n                    if (parsedDate in self.options.bookedData) {\n                        $.each(self.options.bookedData[parsedDate], function (key, value) {\n                            if ($('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\").length) {\n                                var optTimeHtml = $('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\");\n                                var remainingQty = optTimeHtml.data(\"slot-qty\") - value;\n                                if (remainingQty <= 0) {\n                                    optTimeHtml.removeClass('wk-bk-slot-booked');\n                                    optTimeHtml.removeClass('wk-bk-slot-selected');\n                                    optTimeHtml.addClass('wk-bk-slot-booked');\n                                    $('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\").next().addClass('wk-bk-slot-selected');\n                                }\n                            }\n                        });\n                    }\n                    \n                    $('.wk-bk-select-time-opt-wrapper').removeAttr('style');\n                    var selectedTime = $('.wk-bk-slot-selected').text();\n                    var isTimeClosed = false;\n                    $('#wk-bk-booking-time-field').val(selectedTime);\n                    $('#wk-bk-slot-day-index').val($('.wk-bk-slot-selected').attr('data-day-index'));\n                    $('#wk-bk-parent-slot-id').val($('.wk-bk-slot-selected').attr('data-index'));\n                    $('#wk-bk-slot-id').val($('.wk-bk-slot-selected').attr('data-slot-index'));\n                    if (!tmpl) {\n                        selectedTime = self.options.titleClosed;\n                        isTimeClosed = true;\n                        $('.wk-bk-select-time-opt-wrapper').attr('style', 'display: none;');\n                    }\n                    if (selectedTime.length == 0) {\n                        selectedTime = self.options.titleClosed;\n                        isTimeClosed = true;\n                    }\n                    $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text(selectedTime);\n                    if (!selectedTime) {\n                        $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text($t('Closed'));\n                    }\n\n                    $('.wk-bk-select-date-label').text(formatedDate).attr('data-booking-date', optionDate);\n                    // var bookedDate = $('.wk-bk-select-date-label').text();\n                    var bookedDate = $('.wk-bk-select-date-label').attr('data-booking-date');\n                    $.each(options, function (k, v) {\n                        if (v.title == 'Booking Date') {\n                            if ($('#options_'+v.id+'_text').length) {\n                                $('#options_'+v.id+'_text').val(bookedDate);\n                            } else {\n                                $('#product-options-wrapper').find('.fieldset').append(\n                                    $('<input>')\n                                        .attr('type', 'hidden')\n                                        .attr('name', 'options['+v.id+']')\n                                        .attr('id', 'options_'+v.id+'_text')\n                                        .val(bookedDate)\n                                );\n                            }\n                        }\n                        if (v.title == 'Booking Slot') {\n                            if (isTimeClosed) {\n                                selectedTime = \"\";\n                            }\n                            if ($('#options_'+v.id+'_text').length) {\n                                $('#options_'+v.id+'_text').val(selectedTime);\n                            } else {\n                                $('#product-options-wrapper').find('.fieldset').append(\n                                    $('<input>')\n                                        .attr('type', 'hidden')\n                                        .attr('name', 'options['+v.id+']')\n                                        .attr('id', 'options_'+v.id+'_text')\n                                        .val(selectedTime)\n                                );\n                            }\n                        }\n                    });\n                });\n                $(\"body\").on('click', '.wk-bk-select-time-opt', function () {\n                    if (!$(this).hasClass('wk-bk-slot-booked')) {\n                        self._setProductOptions($(this), options);\n                    }\n                });\n\n                $(document).on(\n                    'click',\n                    '.wk-book-now',\n                    function (e) {\n                        e.stopPropagation();\n                        if ($(\"form#product_addtocart_form\").valid()) {\n                            if (self.options.chargedPerConfig==1) {\n                                var selectedQty = $(\"form#product_addtocart_form\").find(\"input[name='temp_qty']\").val();\n                                var updatedQty = 1;\n                                if (self.options.stepSize > 1) {\n                                    if (selectedQty % self.options.stepSize == 0) {\n                                        updatedQty = selectedQty / self.options.stepSize;\n                                    } else {\n                                        updatedQty = selectedQty / self.options.stepSize;\n                                        if (updatedQty < 1) {\n                                            updatedQty = updatedQty + 1;\n                                        }\n                                    }\n                                } else {\n                                    updatedQty = selectedQty;\n                                }\n                                if (updatedQty > 0) {\n                                    $(\"form#product_addtocart_form\").find(\"input[name='qty']\").val(parseInt(updatedQty));\n                                    return true;\n                                } else {\n                                    return false;\n                                }\n                            } else {\n                                return true;\n                            }\n                        }\n                    }\n                );\n            },\n\n            _setProductOptions: function (element, options) {\n                var thisObj = element;\n                var selectedTime  = thisObj.attr('data-type-time');\n                $(\".wk-bk-select-time-opt\").each(function () {\n                    if ($(this).hasClass('wk-bk-slot-selected')) {\n                        $(this).removeClass('wk-bk-slot-selected');\n                    }\n                });\n                thisObj.parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);\n                thisObj.addClass('wk-bk-slot-selected');\n                $('#wk-bk-booking-time-field').val(selectedTime);\n                $('#wk-bk-slot-day-index').val(thisObj.attr('data-day-index'));\n                $('#wk-bk-parent-slot-id').val(thisObj.attr('data-index'));\n                $('#wk-bk-slot-id').val(thisObj.attr('data-slot-index'));\n                var bookedDate = $('.wk-bk-select-date-label').attr('data-booking-date');\n                $.each(options, function (k, v) {\n                    if (v.title == 'Booking Date') {\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(bookedDate);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(bookedDate)\n                            );\n                        }\n                    }\n                    if (v.title == 'Booking Slot') {\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(selectedTime);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(selectedTime)\n                            );\n                        }\n                    }\n                });\n            }\n        }\n    );\n    return $.tablebooking.tablebooking;\n});\n","Webkul_AdvancedBookingSystem/js/nearby.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"mage/calendar\",\n    'domReady!'\n], function ($, alert, mageTemplate) {\n    'use strict';\n    $.widget('nearby.nearby', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var map;\n            var service;\n            var infowindow;\n            var pyrmont;\n            var origin;\n            var destination = \"\";\n            var places = [];\n            var searchStr1 = self.options.address;\n            \n            pyrmont = getCurrentLocation();\n            \n            setTimeout(function(){\n                initMapTextSearch(pyrmont, searchStr1);\n            },1200);\n\n            $(\"body\").on(\n                \"keypress\",\n                '.search-nearby-area [name=\"search-keyword\"]',\n                function (e) {\n                    if (e.which == 13) {\n                        var searchStr = $(this).val();\n                        initMapTextSearch(pyrmont, searchStr);\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                '.nearby-places .place-detail span.remove',\n                function () {\n                    $(this).parents('.nearby-places').remove()\n                }\n            );\n\n            function getCurrentLocation()\n            {\n                $.ajax(\n                    {\n                        url : self.options.google_map_api,\n                        'method' : 'POST',\n                        success: function (response) {\n                            var latitude = response.results[0].geometry.location.lat;\n                            var longitude = response.results[0].geometry.location.lng;\n                            origin = response.results[0].place_id;\n                            pyrmont = new google.maps.LatLng(latitude,longitude);\n                        }\n                    }\n                );\n            }\n\n            function initMapTextSearch(pyrmont, searchStr)\n            {\n\n                map = new google.maps.Map(\n                    document.getElementById('search-nearby-map'),\n                    {\n                        center: pyrmont,\n                        zoom: 15\n                    }\n                );\n\n                var request = {\n                    location: pyrmont,\n                    radius: '500',\n                    query: searchStr\n                };\n\n                infowindow = new google.maps.InfoWindow();\n                service = new google.maps.places.PlacesService(map);\n                service.textSearch(\n                    request,\n                    function (results, status) {\n                        if (status == google.maps.places.PlacesServiceStatus.OK) {\n                            destination = \"\";\n                            places = [];\n                            for (var i = 0; i < results.length; i++) {\n                                var place = results[i];\n                                places[i] = place.name;\n                                if (i==results.length-1) {\n                                    destination += \"place_id:\"+place.place_id;\n                                } else {\n                                    destination += \"place_id:\"+place.place_id + \"|\";\n                                }\n                                createMarker(place);\n                            }\n                            getDistanceAndTime(destination, places);\n                        }\n                    }\n                );\n            }\n\n            function initMapNearBy(pyrmont)\n            {\n\n                map = new google.maps.Map(\n                    document.getElementById('search-nearby-map'),\n                    {\n                        center: pyrmont,\n                        zoom: 15\n                    }\n                );\n\n                var request = {\n                    location: pyrmont,\n                    radius: '500',\n                    type: ['restaurant']\n                };\n\n                service = new google.maps.places.PlacesService(map);\n                service.nearbySearch(\n                    request,\n                    function (results, status) {\n                        if (status == google.maps.places.PlacesServiceStatus.OK) {\n                            for (var i = 0; i < results.length; i++) {\n                                var place = results[i];\n                                createMarker(results[i]);\n                            }\n                        }\n                    }\n                );\n            }\n\n            function createMarker(place)\n            {\n                var placeLoc = place.geometry.location;\n                var marker = new google.maps.Marker(\n                    {\n                        map: map,\n                        position: place.geometry.location\n                    }\n                );\n\n                google.maps.event.addListener(\n                    marker,\n                    'click',\n                    function () {\n                        infowindow.setContent(place.name);\n                        infowindow.open(map, this);\n                    }\n                );\n            }\n\n            function getDistanceAndTime(destination, places)\n            {\n                $.ajax(\n                    {\n                        url : self.options.distance_url,\n                        method : 'POST',\n                        data : {\n                            origins : \"place_id:\"+origin,\n                            destinations : destination,\n                            key : self.options.google_api_key,\n                            places: places\n                        },\n                        dataType: 'json',\n                        success: function (response) {\n                            if (response.length) {\n                                $('.search-nearby-result').html(\"\");\n                                $.each(\n                                    response,\n                                    function (idx, val) {\n                                        var progressTmpl = mageTemplate('#search-nearby-result-template'),\n                                        tmpl;\n                                        tmpl = progressTmpl(\n                                            {\n                                                data: {\n                                                    name: val.name,\n                                                    distance: val.distance+\"(\"+val.duration+\")\"\n                                                }\n                                            }\n                                        );\n                                        $('.search-nearby-result').append(tmpl);\n                                    }\n                                );\n                            }\n                        },\n                        error: function (response) {\n                        }\n                    }\n                );\n            }\n        }\n    });\n    return $.nearby.nearby;\n});\n","Webkul_AdvancedBookingSystem/js/rentalbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"moment\",\n    \"mage/calendar\"\n], function ($, alert, mageTemplate, moment) {\n    'use strict';\n    $.widget(\n        'rentalbooking.rentalbooking',\n        {\n            options: {\n            },\n            _create: function () {\n                var self = this;\n                var monthArr = self.options.monthArr;\n                var rentTypeArr = self.options.rentTypeArr;\n                var unvailableDates = self.options.hourlyUnavailableDates;\n                var holidaysData = self.options.holidaysData;\n                var dateFormat = \"mm/dd/yy\";\n                $('.wk-bk-rent-type-option').each(function () {\n                    if (this.checked) {\n                        $('#wk-bk-select-slot').html('');\n                        $('#wk-bk-select-time').html('');\n                        if (parseInt($(this).val()) == parseInt(rentTypeArr['d'])) {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-daily'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this));\n                                }),\n                            bookingDateTo = $(\"#wk-bk-select-to-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this));\n                                });\n                        } else {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-hourly'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                            .datepicker({\n                                minDate: self.options.bookingAvailableFrom,\n                                maxDate: self.options.bookingAvailableTo,\n                                beforeShowDay: function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                                    if(isDisabled){\n                                        return [!isDisabled];\n                                    }\n                                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                                    let holiday = holidaysData[string];\n                                    if(holiday){\n                                        return [false,'',holiday];\n                                    }\n                                    return [true];\n                                },\n                                onSelect: function () {\n                                    getBookingDate(this);\n                                }\n                            });\n                        }\n                    }\n                });\n           \n                function getBookingDate(element)\n                {\n                    var date;\n                    try {\n                        date = $.datepicker.parseDate(dateFormat, element.value);\n                        var selectedDate  = $(element).val();\n                        var selectedDateArr  = selectedDate.split('/');\n                        var day = selectedDateArr[1];\n                        var month = selectedDateArr[0];\n                        var year = selectedDateArr[2];\n                        var formatedDate = day+\" \"+monthArr[month]+\", \"+year;\n                        let optionDate = year+\"-\"+month+\"-\"+day;\n                        var d = new Date(selectedDate);\n                        var dayIndex = d.getDay();\n                        if (!dayIndex) {\n                            dayIndex = 7;\n                        }\n\n                        $(element)\n                            .parents('.wk-bk-dates-wrapper')\n                            .find('.wk-bk-select-date-label').text(formatedDate).attr('data-booking-date', optionDate);\n\n                        var rentType = $(\".wk-bk-rent-type-option:input[type='radio']:checked\").val();\n                        if (parseInt(rentTypeArr['d']) == parseInt(rentType)) {\n                            $(element)\n                                .parents('.wk-bk-dates-wrapper')\n                                .find('.wk-bk-date-option').val(optionDate);\n                        } else {\n                            if ($('#wk-bk-select-from-date').val()) {\n                                var fromDate = new Date($('#wk-bk-select-from-date').val());\n                                var fday = fromDate.getDate();\n                                var fmonth = fromDate.getMonth() + 1;\n                                var fyear = fromDate.getFullYear();\n\n                                var todayDate = new Date();\n                                var tday = todayDate.getDate();\n                                var tmonth = todayDate.getMonth() + 1;\n                                var tyear = todayDate.getFullYear();\n                                // if from selected date is today\n                                if (fday == tday && fmonth == tmonth && fyear == tyear) {\n                                    var progressTmpl = mageTemplate('#wk-bk-select-slot-template-today'),\n                                    tmpl;\n                                    tmpl = progressTmpl({\n                                        data: {}\n                                    });\n                                } else {\n                                    var progressTmpl = mageTemplate('#wk-bk-select-slot-template-'+dayIndex),\n                                    tmpl;\n                                    tmpl = progressTmpl({\n                                        data: {}\n                                    });\n                                }\n                                $('#wk-bk-select-slot').html(tmpl);\n                            } else {\n                                $('#wk-bk-select-slot').html('');\n                            }\n                            $('#wk-bk-select-time').html('');\n                        }\n                    } catch (error) {\n                        date = null;\n                    }\n                    return date;\n                }\n                $(\"body\").on('change', '.wk-bk-rent-type-option', function () {\n                    if (this.checked) {\n                        $('#wk-bk-select-slot').html('');\n                        $('#wk-bk-select-time').html('');\n                        if (parseInt($(this).val()) == parseInt(rentTypeArr['d'])) {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-daily'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this));\n                                }),\n                            bookingDateTo = $(\"#wk-bk-select-to-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo,\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this));\n                                });\n                        } else {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-hourly'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                            .datepicker({\n                                minDate: self.options.bookingAvailableFrom,\n                                maxDate: self.options.bookingAvailableTo,\n                                beforeShowDay: function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                                    if(isDisabled){\n                                        return [!isDisabled];\n                                    }\n                                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                                    let holiday = holidaysData[string];\n                                    if(holiday){\n                                        return [false,'',holiday];\n                                    }\n                                    return [true];\n                                },\n                                onSelect: function () {\n                                    getBookingDate(this);\n                                }\n                            });\n                        }\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-parent-slot-id', function () {\n                    $('#wk-bk-from-date-option').val('');\n                    $('#wk-bk-to-date-option').val('');\n                    if ($(this).val()) {\n                        var dayIndex = $('#wk-bk-slot-day-index').val();\n                        var slotIndex = $(this).val();\n                        var progressTmpl = mageTemplate('#wk-bk-select-time-template'),\n                        tmpl;\n                        tmpl = progressTmpl({\n                            data: {}\n                        });\n                        $('#wk-bk-select-time').html(tmpl);\n                        var formattedDate = moment($('#wk-bk-select-from-date').val()).format('YYYY-MM-DD');\n                        var fromDate = new Date(formattedDate);\n                        var fday = fromDate.getDate();\n                        var fmonth = fromDate.getMonth() + 1;\n                        var fyear = fromDate.getFullYear();\n\n                        var todayDate = new Date();\n                        var tday = todayDate.getDate();\n                        var tmonth = todayDate.getMonth() + 1;\n                        var tyear = todayDate.getFullYear();\n                        // if from selected date is today\n                        if (fday == tday && fmonth == tmonth && fyear == tyear) {\n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-from-time-opt-template-today'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-from-time').html(progressTmpl);\n                            let currentTimeString = parseInt(Date.now()/1000);\n                            $('#wk-bk-from-time > option').each(function() {\n                                if ($(this).val() != '' && currentTimeString >= parseInt($(this).data('time'))) {\n                                    $(this).attr('disabled', 'disabled');\n                                }\n                            });\n    \n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-to-time-opt-template-today'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-to-time').html(progressTmpl);\n                        } else {\n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-from-time-opt-template'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-from-time').html(progressTmpl);\n    \n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-to-time-opt-template'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-to-time').html(progressTmpl);\n                        }\n\n                        $('#wk-bk-to-time').attr('disabled', 'disabled');\n                    } else {\n                        $('#wk-bk-select-time').html('');\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-from-time', function () {\n                    var thisObj = $(this);\n                    $('#wk-bk-to-time').removeAttr('disabled');\n                    $(\"#wk-bk-from-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    $(\"#wk-bk-to-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    if (thisObj.val()) {\n                        $('#wk-bk-slot-id').val(thisObj.val());\n                        if (thisObj.val() && $('#wk-bk-to-time').val()) {\n                            if (parseInt(thisObj.val()) >= parseInt($('#wk-bk-to-time').val())) {\n                                thisObj.val('');\n                                $('#wk-bk-from-date-option').val('');\n                            } else {\n                                var currentDate = $('#wk-bk-select-from-date')\n                                .parents('.wk-bk-dates-wrapper')\n                                .find('.wk-bk-select-date-label').attr('data-booking-date');\n                                var currentFromDate = currentDate;\n                                var currentToDate = currentDate;\n                                var currentFromTime = $(\"#wk-bk-from-time option:selected\").text();\n                                if (currentFromTime && currentFromTime!=0) {\n                                    currentFromDate = currentDate+' '+currentFromTime;\n                                }\n                                $('#wk-bk-from-date-option').val(currentFromDate);\n                                var currentToTime = $(\"#wk-bk-to-time option:selected\").text();\n                                if (currentToTime && currentToTime!=0) {\n                                    currentToDate = currentDate+' '+currentToTime;\n                                }\n                                $('#wk-bk-to-date-option').val(currentToDate);\n                            }\n                        }\n                        $(\"#wk-bk-to-time option\").each(function () {\n                            if (parseInt(this.value) <= parseInt(thisObj.val())) {\n                                this.disabled = true;\n                            }\n                        });\n                    } else {\n                        $('#wk-bk-slot-id').val('');\n                        $('#wk-bk-to-time').val('');\n                        $('#wk-bk-to-date-option').val('');\n                        $('#wk-bk-to-time').attr('disabled', 'disabled');\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-to-time', function () {\n                    var thisObj = $(this);\n                    $('#wk-bk-to-time').removeAttr('disabled');\n                    $(\"#wk-bk-from-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    $(\"#wk-bk-to-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    if (thisObj.val() && $('#wk-bk-from-time').val()) {\n                        if (parseInt(thisObj.val()) <= parseInt($('#wk-bk-from-time').val())) {\n                            thisObj.val('');\n                            $('#wk-bk-to-date-option').val('');\n                        } else {\n                            var currentDate = $('#wk-bk-select-from-date')\n                            .parents('.wk-bk-dates-wrapper')\n                            .find('.wk-bk-select-date-label').attr('data-booking-date');\n                            var currentFromDate = currentDate;\n                            var currentToDate = currentDate;\n                            var currentFromTime = $(\"#wk-bk-from-time option:selected\").text();\n                            if (currentFromTime && currentFromTime!=0) {\n                                currentFromDate = currentDate+' '+currentFromTime;\n                            }\n                            $('#wk-bk-from-date-option').val(currentFromDate);\n                            var currentToTime = $(\"#wk-bk-to-time option:selected\").text();\n                            if (currentToTime && currentToTime!=0) {\n                                currentToDate = currentDate+' '+currentToTime;\n                            }\n                            $('#wk-bk-to-date-option').val(currentToDate);\n                        }\n                        $(\"#wk-bk-from-time option\").each(function () {\n                            if (parseInt(this.value) >= parseInt(thisObj.val())) {\n                                this.disabled = true;\n                            }\n                        });\n                    } else {\n                        $('#wk-bk-slot-id').val('');\n                        $('#wk-bk-to-time').val('');\n                        $('#wk-bk-to-date-option').val('');\n                        if (!$('#wk-bk-from-time').val()) {\n                            $('#wk-bk-to-time').attr('disabled', 'disabled');\n                        }\n                    }\n                });\n            }\n        }\n    );\n    return $.rentalbooking.rentalbooking;\n});\n","Webkul_AdvancedBookingSystem/js/bookingsystem.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'mage/translate',\n    'Magento_Ui/js/modal/alert',\n    \"jquery/ui\",\n], function ($, $t, alert) {\n    'use strict';\n    $.widget('bookingsystem.bookingsystem', {\n        options: {},\n        _create: function () {\n            var self = this;\n            var bookingInfoArray = self.options.bookingInfoArray;\n            if (bookingInfoArray !== undefined) {\n                $(\".products .product-items.list > li.product-item, .wishlist ol.product-items > li.product-item, .table-comparison .cell.product\").each(\n                    function () {\n                        if ($(this).find(\".product-item-link\").length) {\n                            var productLink = $(this).find(\".product-item-link\").attr(\"href\");\n                        } else if ($(this).find(\"a.product-item-photo\").length) {\n                            var productLink = $(this).find(\"a.product-item-photo\").attr(\"href\");\n                        } else {\n                            var productLink = \"\";\n                        }\n                        if (bookingInfoArray[productLink] !== undefined && bookingInfoArray[productLink]['booking'] == 1) {\n                            var buttonLabel = \"\";\n                            if (bookingInfoArray[productLink]['booking_type'] == \"event\") {\n                                buttonLabel = $t(\"Buy Tickets\");\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            } else if (bookingInfoArray[productLink]['booking_type'] == \"rental\") {\n                                buttonLabel = $t(\"Rent Now\");\n                                if (bookingInfoArray[productLink]['rent_type_text']) {\n                                    setRentTypeLabel($(this), bookingInfoArray[productLink]['rent_type_text']);\n                                }\n                            }\n                            if (bookingInfoArray[productLink]['booking_type'] == \"appointment\") {\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            }\n                            if (bookingInfoArray[productLink]['booking_type'] == \"default\") {\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            }\n                            setBookingLabel($(this), buttonLabel);\n                        }\n                    }\n                );\n            }\n            $(document).ready(\n                function () {\n                    var slots = self.options.slots;\n                    var parentId = self.options.parentId;\n                    setTimeout(\n                        function () {\n                            if (bookingInfoArray !== undefined) {\n                                $(\".block-wishlist .product-items > li.product-item\").each(\n                                    function () {\n                                        if ($(this).find(\"a.product-item-link\").length) {\n                                            var productLink = $(this).find(\"a.product-item-link\").attr(\"href\");\n                                        } else if ($(this).find(\"a.product-item-photo\").length) {\n                                            var productLink = $(this).find(\"a.product-item-photo\").attr(\"href\");\n                                        } else {\n                                            var productLink = \"\";\n                                        }\n                                        if (bookingInfoArray[productLink] !== undefined && bookingInfoArray[productLink]['booking'] == 1) {\n                                            var buttonLabel = \"\";\n                                            if (bookingInfoArray[productLink]['booking_type'] == \"event\") {\n                                                buttonLabel = $t(\"Buy Tickets\");\n                                            } else if (bookingInfoArray[productLink]['booking_type'] == \"rental\") {\n                                                buttonLabel = $t(\"Rent Now\");\n                                            }\n                                            setBookingLabel($(this), buttonLabel);\n                                        }\n                                    }\n                                );\n                            }\n                        },\n                        1000\n                    );\n\n\n                    $(document).on(\n                        'click',\n                        '.wk-book-now',\n                        function () {\n                            showPanel();\n                            var d = new Date();\n                            var curr_date = d.getDate();\n                            var curr_month = d.getMonth() + 1;\n                            if (curr_month < 10) {\n                                curr_month = '0' + curr_month;\n                            }\n                            if (curr_date < 10) {\n                                curr_date = '0' + curr_date;\n                            }\n                            var curr_year = d.getFullYear();\n                            var todayDate = curr_year + \"-\" + curr_month + \"-\" + curr_date;\n\n                            var todayElemnt = $(\".wk-calendar-container\").find('.wk-calendar-col').find('.wk-calendar-cell[data-date=' + todayDate + ']');\n\n                            if (todayElemnt.length) {\n                                if ($(todayElemnt).hasClass('slot-available')) {\n                                    var date = todayElemnt.attr(\"data-date\");\n                                    $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                    todayElemnt.addClass('active');\n                                    loadSlotsData(date);\n                                } else {\n                                    if ($('.wk-calendar-container .wk-calendar-col .slot-available').first().length) {\n                                        var date = $('.wk-calendar-container .wk-calendar-col .slot-available').first().attr(\"data-date\");\n                                        $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                        $('.wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');\n                                        loadSlotsData(date);\n                                    }\n                                }\n                            } else {\n                                if ($('.wk-calendar-container .wk-calendar-col .slot-available').first().length) {\n                                    var date = $('.wk-calendar-container .wk-calendar-col .slot-available').first().attr(\"data-date\");\n                                    $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                    $('.wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');\n                                    loadSlotsData(date);\n                                }\n                            }\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-close',\n                        function () {\n                            hidePanel();\n                            $(\".wk-calendar-container\").animate(\n                                { 'margin-left': '0px' },\n                                500,\n                                function () {\n                                    if ($(\"body .modal-popup.confirm\").is(\":visible\")) {\n                                        $(\"body .modal-popup.confirm\").find(\".action-close\").trigger(\"click\");\n                                    }\n                                }\n                            );\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-available-day',\n                        function (event) {\n                            if ($(this).hasClass('slot-available')) {\n                                var date = $(this).attr(\"data-date\");\n                                $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                $(this).addClass('active');\n                                loadSlotsData(date);\n                            }\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-next-cal',\n                        function (event) {\n                            var currentCalendar = $(this).parent().parent();\n                            currentCalendar.hide();\n                            currentCalendar.next().show();\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-previous-cal',\n                        function (event) {\n                            var currentCalendar = $(this).parent().parent();\n                            currentCalendar.hide();\n                            currentCalendar.prev().show();\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-book',\n                        function (event) {\n                            var formData;\n                            showLoader();\n                            event.preventDefault();\n                            if (!$('.booked-slot-summary').is(':empty')) {\n                                $.each(\n                                    $('.booked-slot-summary').find('.booked-short-history'),\n                                    function (k, v) {\n                                        $(this).data('booked-slot-id')\n\n                                        var qty = $(this).children('input').val();\n                                        var id = $(this).data('booked-slot-id');\n                                        var info = slots[id];\n                                        var option = {};\n                                        formData = new FormData(jQuery('form#product_addtocart_form')[0]);\n                                        formData.append('slot_id', id);\n                                        formData.append('qty', qty);\n\n                                        $.each(\n                                            self.options.options,\n                                            function (k, v) {\n                                                if (v.title == 'Booking From') {\n                                                    formData.append('options['+v.id+']', info['booking_from']);\n                                                }\n                                                if (v.title == 'Booking Till') {\n                                                    formData.append('options['+v.id+']', info['booking_to']);\n                                                }\n                                            }\n                                        );\n                                        $.ajax(\n                                            {\n                                                url: self.options.cartUrl,\n                                                type: 'POST',\n                                                data: formData,\n                                                dataType: 'json',\n                                                cache: false,\n                                                contentType: false,\n                                                processData: false,\n                                                success: function (data) {\n                                                    if (!$('.booked-slot-summary').is(':empty')) {\n                                                        $('.booked-slot-summary .booked-short-history').remove();\n                                                        $(\"body\").find('.wk-slots-summary-wrapper').hide();\n                                                    }\n                                                    hideLoader();\n                                                    $(\".wk-close\").trigger(\"click\");\n                                                },\n                                                error: function (resp) {\n                                                }\n                                            }\n                                        );\n                                    }\n                                );\n                            }\n                        }\n                    );\n\n                    $(document).on(\n                        'input',\n                        '.wk-qty',\n                        function (event) {\n                            var qtyBox = $(this);\n                            var regex = /^[0-9]*(?:\\.\\d{1,2})?$/; // allow only numbers [0-9]\n                            var qty = qtyBox.val();\n                            var id = qtyBox.attr(\"data-id\");\n                            var info = slots[id];\n                            var option = {};\n                            var cond = true;\n                            var updatedQty = qtyBox.next('.wk-qty-booked-hide').val();\n\n                            if (qty == 0) {\n                                cond = false;\n                                removeSelectedSlot(qtyBox, id);\n                                alert({\n                                    content: $t('Please enter a value greater than 0')\n                                });\n                                return false;\n                            } else if (!regex.test(qty) || qty == \"\") {\n                                cond = false;\n                                alert({\n                                    content: $t('Please enter a numeric value and is greater than 0')\n                                });\n                            } else if (cond && (parseInt(info['qty']) < qty || updatedQty >= parseInt(info['qty']))) {\n                                cond = false;\n                                alert({\n                                    content: $t('Quantity not available for this slot')\n                                });\n                                qtyBox.val(0);\n                            }\n\n                            if (cond && qty > 0) {\n                                $.each(\n                                    self.options.options,\n                                    function (k, v) {\n                                        if (v.title == 'Booking From') {\n                                            option[v.id] = info['booking_from'];\n                                        }\n                                        if (v.title == 'Booking Till') {\n                                            option[v.id] = info['booking_to'];\n                                        }\n                                    }\n                                );\n\n                                qtyBox.prev('.wk-booked-txt').text($t(\"Selected\"));\n                                updatedQty = parseInt(qty);\n                                qtyBox.next('.wk-qty-booked-hide').val(updatedQty);\n\n                                var remainingQty = parseInt(info['qty']);\n                                if (remainingQty >= parseInt(qty)) {\n                                    remainingQty -= parseInt(qty);\n                                    qtyBox.parent().siblings('.wk-col.middle').find('.wk-avl-text').next().text(remainingQty);\n                                }\n\n                                // if (self.options.booking_type == 2) {\n                                var bookingFrom = info['booking_from'];\n                                var bookingTo = info['booking_to'];\n                                // } else {\n                                //     var bookingFrom = info['booking_from'].split(\",\")[1];\n                                //     var bookingTo = info['booking_to'].split(\",\")[1];\n                                // }\n\n                                if ($('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']').length) {\n                                    $('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']')\n                                        .children('span')\n                                        .text($t(updatedQty + \" slot is selected for booking between \" + bookingFrom + \" to \" + bookingTo));\n                                    $('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']')\n                                        .children('input')\n                                        .val(updatedQty);\n                                } else {\n                                    $('.wk-modal-foot').find('.booked-slot-summary')\n                                        .prepend(\n                                            $('<div>')\n                                                .attr('data-booked-slot-id', id)\n                                                .addClass('booked-short-history')\n                                                .append(\n                                                    $('<input>').attr('type', 'hidden').attr('name', 'booked_qty').val(updatedQty),\n                                                    $('<span>').text($t(updatedQty + \" slot is selected for booking between \" + bookingFrom + \" to \" + bookingTo)),\n                                                    $('<a>').addClass('remove-slot')\n                                                )\n                                        );\n                                }\n                                $('.wk-slots-summary-wrapper').show();\n                            } else if (cond && qty == 0 && (event.keyCode == 8 || event.keyCode == 46)) {\n                                removeSelectedSlot(qtyBox, id);\n                            }\n                        }\n                    );\n                    function removeSelectedSlot(quantityBox, id)\n                    {\n                        if ($(\"body\").find(\".booked-slot-summary\").find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")) {\n                            if (quantityBox.length) {\n                                var bookedQty = $(\"body\")\n                                    .find(\".booked-slot-summary\")\n                                    .find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")\n                                    .children('input').val();\n                                quantityBox.val(0);\n                                quantityBox.siblings('.wk-booked-txt').text($t('your need'));\n                                quantityBox.siblings('.wk-qty-booked-hide').val(0);\n                                var availableQty = quantityBox.parent()\n                                    .siblings('.middle')\n                                    .find('.wk-label-avl-qty .wk-avl-text')\n                                    .next().text();\n                                availableQty = parseInt(availableQty) + parseInt(bookedQty);\n                                if (availableQty >= 0) {\n                                    var availableQty = quantityBox.parent()\n                                        .siblings('.middle')\n                                        .find('.wk-label-avl-qty .wk-avl-text')\n                                        .next().text(availableQty);\n                                }\n                            }\n                            $(\"body\")\n                                .find(\".booked-slot-summary\")\n                                .find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")\n                                .remove();\n                            if ($(\"body\").find(\".booked-slot-summary\").is(':empty')) {\n                                $(\"body\").find('.wk-slots-summary-wrapper').hide();\n                            }\n                        }\n                    }\n                    $(document).on(\n                        'click',\n                        '.remove-slot',\n                        function (event) {\n                            var dicisionapp = confirm($t('Are you Sure you Want To remove this slot'));\n                            if (dicisionapp == true) {\n                                var bookedSlotId = $(this).parent().data('booked-slot-id');\n                                var bookedQty = $(this).siblings('input').val();\n                                if ($('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').length) {\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').val(0);\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').siblings('.wk-booked-txt').text($t('your need'));\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').siblings('.wk-qty-booked-hide').val(0);\n                                    var availableQty = $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]')\n                                        .parent()\n                                        .siblings('.middle')\n                                        .find('.wk-label-avl-qty .wk-avl-text')\n                                        .next().text();\n                                    availableQty = parseInt(availableQty) + parseInt(bookedQty);\n                                    if (availableQty >= 0) {\n                                        var availableQty = $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]')\n                                            .parent()\n                                            .siblings('.middle')\n                                            .find('.wk-label-avl-qty .wk-avl-text')\n                                            .next().text(availableQty);\n                                    }\n                                }\n                                $(this).parent().remove();\n                                if ($('.booked-slot-summary').is(':empty')) {\n                                    $('.wk-slots-summary-wrapper').hide();\n                                }\n                            }\n                        }\n                    );\n                }\n            );\n            function setBookingLabel(element, buttonLabel)\n            {\n                if (buttonLabel == \"\") {\n                    buttonLabel = $t('Book Now');\n                }\n                element.find(\".action.tocart.primary\").attr(\"title\", buttonLabel);\n                element.find(\".action.tocart.primary\").find(\"span\").text(buttonLabel);\n            }\n\n            function setExpiredBookingLabel(element)\n            {\n                element.find(\".action.tocart.primary\").hide();\n                element.find(\".actions-primary\").find('label.event-expired').remove();\n                element.find(\".action.tocart.primary\").after(\n                    $('<label>').addClass('event-expired').css(\"color\", \"red\").text($t(\"Expired\"))\n                );\n            }\n\n            function setRentTypeLabel(element, rentLabel)\n            {\n                element.find(\".price-box\").find(\".price-wrapper\").find(\"span.price\").append(\n                    $('<span>').addClass('rent-type-text').text(rentLabel).css({\n                        \"color\": \"#bbb\",\n                        \"display\": \"block\",\n                        \"font-size\": \"80%\"\n                    })\n                );\n            }\n\n            function loadSlotsData(date)\n            {\n                showLoader();\n                $.ajax(\n                    {\n                        url: self.options.slotsUrl,\n                        type: 'POST',\n                        dataType: 'json',\n                        data: { product_id: self.options.productId, date: date },\n                        success: function (data) {\n                            hideLoader();\n\n                            if (data.avl == 1) {\n                                var slotHtml = \"\";\n                                $.each(\n                                    data.slots,\n                                    function (key, item) {\n                                        var day = item.day;\n                                        var id = item.id;\n                                        var qtyInfo = item.qty;\n                                        var dateFormatted = item.date_formatted.split(\",\");\n                                        var dateFrom = item.booking_from.split(\",\");\n                                        var dateTo = item.booking_to.split(\",\");\n                                        var reservedQty = 0;\n                                        if (self.options.booking_type == 2) {\n                                            var rowClass = 'wk-row';\n                                        } else {\n                                            var rowClass = 'wk-row wk-many-row';\n                                        }\n                                        slotHtml += '<div class=\"' + rowClass + '\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div class=\"wk-col first\">' +\n                                                '<span class=\"wk-label-days\">' + item.no_of_days + '</span>' +\n                                                '<span class=\"wk-label-days-text\">' +\n                                                '<div>' + $t('Day') + '</div>' +\n                                                '<div>' + $t('Slot') + '</div>' +\n                                                '</span>' +\n                                                '</div>';\n                                        }\n                                        if (!$('.booked-slot-summary').is(':empty')) {\n                                            if ($('.booked-slot-summary').find('.booked-short-history[data-booked-slot-id=\"' + id + '\"]').length) {\n                                                reservedQty = $('.booked-slot-summary').find('.booked-short-history[data-booked-slot-id=\"' + id + '\"]').children('input').val();\n                                                qtyInfo = parseInt(qtyInfo) - parseInt(reservedQty);\n                                            }\n                                        }\n                                        var textQtyBox = $t('Your Need');\n                                        if (reservedQty > 0) {\n                                            textQtyBox = $t('Selected');\n                                        }\n                                        slotHtml += '<div class=\"wk-col middle\">' +\n                                            '<span class=\"wk-label-dates\">' +\n                                            '<span class=\"wk-span-from\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div>' + dateFrom[0] + '</div>';\n                                        }\n                                        slotHtml += '<div>' + dateFrom[1] + '</div>' +\n                                            '</span>' +\n                                            '<span>to</span>' +\n                                            '<span class=\"wk-span-to\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div>' + dateTo[0] + '</div>';\n                                        }\n                                        slotHtml += '<div>' + dateTo[1] + '</div>' +\n                                            '</span>' +\n                                            '</span>' +\n                                            '<span class=\"wk-label-avl-qty\">' +\n                                            '<span class=\"wk-avl-text\">' + $t('Available :') + '</span>' +\n                                            '<span>' + qtyInfo + '</span>' +\n                                            '</span>' +\n                                            '</div>';\n                                        slotHtml += '<div class=\"wk-col last\">' +\n                                            '<span class=\"wk-booked-txt\">' + textQtyBox + '</span>' +\n                                            '<input type=\"number\" class=\"wk-qty\" value=\"' + reservedQty + '\" data-id=' + id + '>' +\n                                            '<input type=\"hidden\" name=\"wk-qty-booked-hide\" value=\"' + reservedQty + '\" class=\"wk-qty-booked-hide\">' +\n                                            '</div>';\n                                        slotHtml += '</div>';\n\n                                        if (dateFormatted[0] < 10) {\n                                            dateFormatted[0] = '0' + dateFormatted[0];\n                                        }\n                                        $(\".wk-booking-table-head\").find('.wk-selected-date').text(dateFormatted[0]);\n                                        $(\".wk-booking-table-head\").find('.wk-month').text(dateFormatted[1]);\n                                        $(\".wk-booking-table-head\").find('.wk-selected-day').text(day);\n                                    }\n                                );\n                                $(\".wk-booking-table-body\").html(slotHtml);\n                            } else {\n                                var slotHtml = \"\";\n                                slotHtml = '<div class=\"wk-no-booking\">' + data.msg + '</div>';\n                                $(\".wk-booking-table-body\").html(slotHtml);\n                            }\n                        }\n                    }\n                );\n            }\n            function showPanel()\n            {\n                $(\".wk-bg-container\").fadeIn('slow');\n                $(\".wk-box-modal\").animate({ 'margin-top': '125px' }, 500);\n            }\n            function hidePanel()\n            {\n                $(\".wk-bg-container\").fadeOut('slow');\n                $(\".wk-box-modal\").animate({ 'margin-top': '-400px' }, 500);\n            }\n            function showLoader()\n            {\n                $(\".wk-box-modal-bg\").show();\n            }\n            function hideLoader()\n            {\n                $(\".wk-box-modal-bg\").hide();\n            }\n            function validateNumber(currentObject)\n            {\n                var regex = /^[0-9]*(?:\\.\\d{1,2})?$/; // allow only numbers [0-9]\n                if (!regex.test($(currentObject).val())) {\n                    $(currentObject).val(1);\n                }\n            }\n        }\n    });\n    return $.bookingsystem.bookingsystem;\n});\n","Webkul_AdvancedBookingSystem/js/hotelbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"mage/calendar\"\n], function ($, alert, mageTemplate) {\n    'use strict';\n    $.widget('hotelbooking.hotelbooking', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var bookedDatesArr = [];\n            var availableDatesArr = [];\n            var datesArr = [];\n            var dateFormat = \"dd M, yy\";\n\n            if (self.options.bookedDates) {\n                bookedDatesArr = JSON.parse(self.options.bookedDates);\n            }\n            if (self.options.availableDates) {\n                availableDatesArr = JSON.parse(self.options.availableDates);\n            }\n\n            setDefaultDateRange();\n\n            $(\".hotel-number-quantity .quantity-up\").unbind(\"click\");\n            $(\".hotel-number-quantity .quantity-down\").unbind(\"click\");\n            $(\"#product_addtocart_form .wk-book-now\").unbind(\"click\");\n            $(\"button.write-answer\").unbind(\"click\");\n            \n            var errorMgs = \"\";\n            $.validator.addMethod(\n                \"validate-max\",\n                function(value, element) {\n                   var roomQty = $(element).parents('.wk-bk-hotel-options').find('.no-of-rooms').val();\n                   var max = $(element).attr('max');\n                   var isKid = $(element).attr('class').includes('kids');\n                   var fieldType = 'adults';\n                   if (value > max) {\n                       if (isKid) {\n                         fieldType = 'kids';\n                       }\n                     errorMgs = $.mage.__(\"Only \"+max+\" \"+fieldType+\" are allowed for \"+roomQty+\" room.\")\n                     return false;\n                   }\n                  return true\n                },\n                function () {\n                    return errorMgs;\n                }\n                );\n\n            function setDefaultDateRange()\n            {\n                var bookingDateFrom = $(\"#wk-bk-select-date-from\")\n                    .datepicker({\n                        'minDate': 'today',\n                        'dateFormat': 'dd M, yy'\n                    }).on(\"change\", function () {\n                        bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this, +1));\n                    }),\n                    bookingDateTo = $(\"#wk-bk-select-date-to\").datepicker({\n                        'minDate': '+1',\n                        'dateFormat': 'dd M, yy'\n                    });\n            }\n\n            function getBookingDate(element, counter)\n            {\n                var date;\n                try {\n                    date = $.datepicker.parseDate(dateFormat, element.value);\n                    date.setDate(date.getDate() + counter);\n                } catch (error) {\n                    date = null;\n                }\n                return date;\n            }\n\n            $(\"body\").on(\n                'blur',\n                '#wk-bk-select-date-from',\n                function (e) {\n                    setBlurOnDates();\n                }\n            );\n\n            $(\"body\").on(\n                'blur',\n                '#wk-bk-select-date-to',\n                function (e) {\n                    setBlurOnDates();\n                }\n            );\n\n            $(\"body\").on(\n                \"change\",\n                \"#qty.hotel-number-field.no-of-rooms\",\n                function () {\n                    setBlurOnDates();\n                    let rooms = parseFloat($(this).val());\n                    let adultsMaxAllowed = parseFloat($(\".hotel-number-field.adults\").attr('data-max'));\n                    $(\".hotel-number-field.adults\").attr('max', rooms*adultsMaxAllowed);\n                    let kidsMaxAllowed = parseFloat($(\".hotel-number-field.kids\").attr('data-max'));\n                    $(\".hotel-number-field.kids\").attr('max', rooms*kidsMaxAllowed);\n                    \n                }\n            );\n\n            $(document).on(\n                \"submit\",\n                \"form.hotel-booking-product-question-form\",\n                function () {\n                    $('body').loader('show');\n                }\n            );\n\n            function setBlurOnDates()\n            {\n                var selectedDateFrom = $(\"#wk-bk-select-date-from\").val();\n                var selectedDateTo = $(\"#wk-bk-select-date-to\").val();\n                if (selectedDateFrom && selectedDateTo) {\n                    selectedDateFrom = Date.parse(selectedDateFrom);\n                    selectedDateTo = Date.parse(selectedDateTo);\n                    var _array = [];\n                    for (var key in datesArr) {\n                        var booked_dates_str = Date.parse(key);\n                        if (booked_dates_str >= selectedDateFrom && booked_dates_str <= selectedDateTo) {\n                            _array.push(datesArr[key]);\n                        }\n                    }\n                    if (_array.length > 0) {\n                        var maxRoom = Math.min.apply(Math, _array);\n                        $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", maxRoom);\n                        if (maxRoom == 0) {\n                            $(\"input.input-text.hotel-number-field.no-of-rooms\").val(0);\n                        }\n                    } else {\n                        var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                        if (childProduct && availableDatesArr[childProduct]) {\n                            $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", availableDatesArr[childProduct]);\n                        }\n                    }\n                } else {\n                    var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                    if (childProduct && availableDatesArr[childProduct]) {\n                        $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", availableDatesArr[childProduct]);\n                    }\n                }\n            }\n\n            if (self.options.priceRangeText) {\n                $('#product-price-' + self.options.productId).after(\n                    '<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">' + self.options.priceRangeText + '</span>'\n                );\n            }\n\n            $(\"body\").on(\n                'click',\n                '.hotel-super-attribute-select .room-config-types',\n                function () {\n                    $('#wk-bk-select-date-from').datepicker(\"destroy\");\n                    $('#wk-bk-select-date-to').datepicker(\"destroy\");\n                    setDefaultDateRange();\n                    superAttributeSelected($(this));\n                }\n            );\n\n            function superAttributeSelected(element)\n            {\n                var superButton = $(element);\n                var optionId = $(element).attr(\"id\");\n\n                var superAttributeName = superButton.parents(\".hotel-super-attribute-select\").data(\"supername\");\n                var superAttrPosition = superButton.parents(\".hotel-super-attribute-select\").data(\"position\");\n                if ($(\"body .hotel-super-attribute-select\").length > 1 && superAttrPosition == 1) {\n                    $.each(\n                        $(\"body .hotel-super-attribute-select\"),\n                        function () {\n                            if ($(this).data(\"position\") !== 1) {\n                                $(this).find(\".room-config-types\").removeClass(\"hotel-selected\");\n                            }\n                        }\n                    );\n                }\n                superButton.siblings().removeClass(\"hotel-selected\");\n                // superButton.toggleClass(\"hotel-selected\");\n                superButton.removeClass(\"hotel-selected\");\n                superButton.addClass(\"hotel-selected\");\n                $(\"body\").find(\"select[name='\" + superAttributeName + \"']\").val(optionId).change();\n\n                var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                if (childProduct) {\n                    datesArr = [];\n                    var disabledDates = [];\n                    if (bookedDatesArr) {\n                        for (var key in bookedDatesArr) {\n                            if (key == childProduct) {\n                                for (var date in bookedDatesArr[key][\"booked_dates\"]) {\n                                    datesArr = bookedDatesArr[key][\"booked_dates\"];\n                                    if (bookedDatesArr[key][\"booked_dates\"][date] <= 0) {\n                                        disabledDates.push(date);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    if (disabledDates.length > 0) {\n                        $('#wk-bk-select-date-from').datepicker(\"destroy\");\n                        $('#wk-bk-select-date-to').datepicker(\"destroy\");\n                        var bookingDateFrom = $(\"#wk-bk-select-date-from\")\n                            .datepicker({\n                                'minDate': 'today',\n                                'dateFormat': 'dd M, yy',\n                                \"beforeShowDay\": function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, disabledDates) != -1);\n                                    return [!isDisabled];\n                                }\n                            }).on(\"change\", function () {\n                                bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this, +1));\n                            }),\n                            bookingDateTo = $(\"#wk-bk-select-date-to\")\n                                .datepicker({\n                                    'minDate': 'today',\n                                    'dateFormat': 'dd M, yy',\n                                    \"beforeShowDay\": function (date) {\n                                        var string = $.datepicker.formatDate('dd M, yy', date);\n                                        var isDisabled = ($.inArray(string, disabledDates) != -1);\n                                        return [!isDisabled];\n                                    }\n                                }).on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this, -1));\n                                });\n                    }\n\n                    setBlurOnDates();\n                }\n            }\n\n            $(\"#product_addtocart_form .wk-book-now\").on('click', function (e) {\n                    e.preventDefault();\n                    if ($(\"form#product_addtocart_form\").valid()) {\n                        if (self.options.product_type == \"hotelbooking\") {\n                            var selectedOpt = $(\"form#product_addtocart_form\")\n                                .find(\"input[name='selected_configurable_option']\").val();\n                            if (selectedOpt == \"\" || selectedOpt == undefined || selectedOpt == null) {\n                                alert({\n                                    content: self.options.required_config_text\n                                });\n                            } else {\n                                $(\"form#product_addtocart_form\").submit();\n                            }\n                        } else {\n                            $(\"form#product_addtocart_form\").submit();\n                        }\n                    }\n                }\n            );\n\n            $(\".wk-bk-hotel-askquestion-container button.write-answer\").on(\"click\", function (e) {\n                    e.preventDefault();\n\n                    if (!$(this).parents(\"form\").find('div.answer-field').hasClass('active')) {\n                        $(this).parents(\"form\").find('div.answer-field').addClass('active');\n                    } else {\n                        if ($(this).parents(\"form\").valid()) {\n                            $(this).parents(\"form\").submit();\n                        }\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"keypress\",\n                '.wk-bk-hotel-askquestion-container input#search_question',\n                function (e) {\n                    if (e.which == 13) {\n                        $(this).prents('form').submit();\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                \".wk-bk-qna-wrapper .more-answers span\",\n                function () {\n                    $(this).parents('.more-answers').siblings('.hidden-answer').show();\n                    $(this).parents('.more-answers').hide();\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                \".wk-bk-qna-wrapper .answers.no-display  .more-answers span\",\n                function () {\n                    $(this).parents('.answers.no-display').children('.label').show();\n                    $(this).parents('.answers.no-display').find('.write-answer-container').show();\n                    $(this).parents('.more-answers').siblings('.hidden-answer').show();\n                    $(this).parents('.more-answers').hide();\n                    $(this).parents('.answers.no-display').removeClass('no-display');\n                }\n            );\n\n            $('.hotel-number-quantity .quantity-up').on(\"click\", function () {\n                var quantityField = $(this).parents('.hotel-number-quantity');\n                var numberFieldinput = quantityField.find('input.hotel-number-field[type=\"number\"]');\n                var max = parseInt(numberFieldinput.attr('max'));\n                var step = parseInt(numberFieldinput.attr('step'));\n                if (!step) {\n                    step = 1;\n                }\n\n                var numberFieldValue = numberFieldinput.val();\n                if (!numberFieldValue) {\n                    numberFieldValue = 0;\n                }\n\n                var oldValue = parseInt(numberFieldValue);\n                if (!max) {\n                    var newVal = oldValue + step;\n                } else {\n                    if (oldValue >= max) {\n                        var newVal = oldValue;\n                    } else {\n                        var newVal = oldValue + step;\n                    }\n                }\n\n                numberFieldinput.val(newVal);\n                numberFieldinput.trigger(\"change\");\n            });\n\n            $('.hotel-number-quantity .quantity-down').on(\"click\", function () {\n                var quantityField = $(this).parents('.hotel-number-quantity');\n                var numberFieldinput = quantityField.find('input.hotel-number-field[type=\"number\"]');\n                var min = parseInt(numberFieldinput.attr('min'));\n                var step = parseInt(numberFieldinput.attr('step'));\n                if (!step) {\n                    step = 1;\n                }\n\n                var numberFieldValue = numberFieldinput.val();\n                if (!numberFieldValue) {\n                    numberFieldValue = 1;\n                }\n\n                var oldValue = parseInt(numberFieldValue);\n\n                if (oldValue <= min) {\n                    var newVal = oldValue;\n                } else {\n                    var newVal = oldValue - step;\n                }\n\n                numberFieldinput.val(newVal);\n                numberFieldinput.trigger(\"change\");\n            });\n        }\n    });\n    return $.hotelbooking.hotelbooking;\n});\n","Webkul_AdvancedBookingSystem/js/eventBookingPriceOptions.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        eventOptionsSelector: '.wk-event-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig)\n    {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle()\n        {\n            $(this.options.optionsSelector, this.element).trigger('change');\n            $(this.options.eventOptionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions()\n        {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                eventOptions = $(this.options.eventOptionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            options.on('change', this._onOptionChanged.bind(this));\n            eventOptions.on('change', this._onEventOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event)\n        {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n            if (this.options.priceRangeFrom && this.options.priceRangeTo) {\n                var productId = this.options.productId;\n                var format = this.options.priceFormat;\n                var priceText = this.options.priceRangeText;\n                var priceFrom = utils.formatPrice(this.options.priceRangeFrom, format);\n                utils.formatPrice(this.options.priceRangeFrom, format);\n                if (this.options.priceRangeTo == this.options.priceRangeFrom) {\n                    $('#product-price-'+productId).find('.price').text(priceFrom);\n                } else {\n                    var priceTo = utils.formatPrice(this.options.priceRangeTo, format);\n                    $('#product-price-'+productId).find('.price').text(priceFrom+' - '+priceTo);\n                }\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                }\n            }\n        },\n\n        /**\n         * Custom event option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onEventOptionChanged: function onEventOptionChanged(event)\n        {\n            var option = $(event.target);\n            var optId = option.attr('data-option-id');\n            var optValId = option.attr('data-option-val-id');\n            if (option.val()) {\n                if (!$('#select_'+optId+optValId).length) {\n                    $('.wk-bk-options-wrapper').append('<input type=\"hidden\" name=\"options['+optId+'][]\" value=\"'+optValId+'\" id=\"select_'+optId+optValId+'\">');\n                }\n            } else {\n                if ($('#select_'+optId+optValId).length) {\n                    $('#select_'+optId+optValId).remove();\n                }\n            }\n            var totalQty = 0;\n            var totalPrice = 0;\n            var eventOptionPrice = this.options.eventOptionConfig;\n            var basePrice = parseFloat(this.options.productBasePrice);\n            $('.wk-event-custom-option').each(function () {\n                if ($(this).val()) {\n                    totalQty = totalQty + parseFloat($(this).val());\n                    var cOptionId = $(this).attr('data-option-id');\n                    var cOptionValue = $(this).attr('data-option-val-id');\n                    var cOptionPriceArr = eventOptionPrice[cOptionId+'_'+cOptionValue];\n                    totalPrice = totalPrice+((parseFloat(cOptionPriceArr.basePrice)+parseFloat(basePrice))*parseFloat($(this).val()));\n                    var cOptionPriceArr = eventOptionPrice[cOptionId+'_'+cOptionValue];\n                }\n            });\n            $('#wk-bk-event-total-qty').text(totalQty);\n            var productId = this.options.productId;\n            var format = this.options.priceFormat;\n            if (!totalPrice) {\n                totalPrice = basePrice;\n            }\n            $('#product-total-price-'+productId).find('.price').text(\n                utils.formatPrice(totalPrice, format)\n            );\n            if (this.options.priceRangeFrom && this.options.priceRangeTo) {\n                var priceText = this.options.priceRangeText;\n                let formPrice = this.options.priceRangeFrom;\n                let toPrice = this.options.priceRangeTo;\n                if (totalPrice) {\n                    formPrice = parseFloat(formPrice) + basePrice;\n                }\n                var priceFrom = utils.formatPrice(formPrice, format);\n                utils.formatPrice(this.options.priceRangeFrom, format);\n                if (this.options.priceRangeTo == this.options.priceRangeFrom) {\n                    $('#product-price-'+productId).find('.price').text(priceFrom);\n                } else {\n                    if (totalPrice) {\n                        toPrice = parseFloat(toPrice) + basePrice;\n                    }\n                    var priceTo = utils.formatPrice(toPrice, format);\n                    $('#product-price-'+productId).find('.price').text(priceFrom+' - '+priceTo);\n                }\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                }\n            }\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Webkul_AdvancedBookingSystem/js/validate-product.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'Webkul_AdvancedBookingSystem/js/catalog-add-to-cart'\n], function ($) {\n    'use strict';\n\n    $.widget(\n        'mage.productValidate',\n        {\n            options: {\n                bindSubmit: false,\n                radioCheckboxClosest: '.nested',\n                product_type: 'booking'\n            },\n\n            /**\n             * Uses Magento's validation widget for the form object.\n             *\n             * @private\n             */\n            _create: function () {\n                var bindSubmit = this.options.bindSubmit;\n                var product_type = this.options.product_type;\n\n                this.element.validation(\n                    {\n                        radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                        /**\n                         * Uses catalogAddToCart widget as submit handler.\n                         *\n                         * @param   {Object} form\n                         * @returns {Boolean}\n                         */\n                        submitHandler: function (form) {\n                            var jqForm = $(form).catalogAddToCart(\n                                {\n                                    bindSubmit: bindSubmit,\n                                    product_type: product_type\n                                }\n                            );\n\n                            jqForm.catalogAddToCart('submitForm', jqForm);\n\n                            return false;\n                        }\n                    }\n                );\n            }\n        }\n    );\n\n    return $.mage.productValidate;\n});","Webkul_AdvancedBookingSystem/js/rentalBookingPriceOptions.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        controlContainer: 'dd',\n        deafultFlag: 1\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig)\n    {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle()\n        {\n            $(this.options.optionsSelector, this.element).trigger('change');\n            if (this.options.priceChargedPer) {\n                var productId = this.options.productId;\n                var format = this.options.priceFormat;\n                var priceText = this.options.priceChargedPerTxt;\n                var priceChargedPer = utils.formatPrice(this.options.priceChargedPer, format);\n                utils.formatPrice(this.options.priceChargedPer, format);\n                $('#product-price-'+productId).find('.price').text(priceChargedPer);\n                if (this.options.deafultFlag) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                    $('#'+this.options.optionValFieldId).trigger('click');\n                    this.options.deafultFlag = 0;\n                }\n            }\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions()\n        {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event)\n        {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n            if (!this.options.deafultFlag) {\n                var productId = this.options.productId;\n                var priceChargedPerTxtArr = this.options.priceChargedPerTxtArr;\n                var optionValId = event.currentTarget.value;\n                var priceText = priceChargedPerTxtArr[optionValId];\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                } else {\n                    $('#wk-bk-price-range-txt').text(priceText);\n                }\n            }\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Webkul_AdvancedBookingSystem/js/appointmentbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    'mage/translate',\n    \"mage/calendar\"\n], function ($, alert, mageTemplate, $t) {\n    'use strict';\n    $.widget('appointmentbooking.appointmentbooking', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var monthArr = self.options.monthArr;\n            var todaySlotArr = self.options.todaySlotArr;\n            var options = JSON.parse(self.options.optionsJson);\n            var unvailableDates = self.options.appointmentUnavailableDates;\n            var holidaysData = self.options.holidaysData;\n            $(\"#wk-bk-select-date\").datepicker({\n                'dateFormat':'mm/dd/yy',\n                'minDate': 'today',\n                'maxDate': self.options.bookingAvailableTo,\n                'beforeShowDay': function (date) {\n                    var string = $.datepicker.formatDate('dd M, yy', date);\n                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                    if(isDisabled){\n                        return [!isDisabled];\n                    }\n                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                    let holiday = holidaysData[string];\n                    if(holiday){\n                        return [false,'',holiday];\n                    }\n                    return [true];\n                },\n            });\n            todaySlotArr.now = parseInt(Date.now()/1000);\n            todaySlotArr.activeFirst = 0;\n            var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n            tmpl;\n            tmpl = progressTmpl({\n                data: todaySlotArr\n            });\n            $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n            var selectedTime = $('.wk-bk-slot-selected').text();\n            $('#wk-bk-booking-time-field').val(selectedTime);\n            $('#wk-bk-booking-time-field').next('.wk-bk-select-time-label').text(selectedTime);\n            self._setProductOptions($('.wk-bk-slot-selected'), options);\n\n            $(\"body\").on('change', '#wk-bk-select-date', function () {\n                var selectedDate  = $(this).val();\n                var parsedDate = Date.parse(selectedDate, \"yyyy-MM-dd\");\n                let serverTimezoneDate = '';\n                var str = parsedDate.toString();\n                parsedDate = str.substr(0, str.length-3);\n\n                var selectedDateArr  = selectedDate.split('/');\n                var day = selectedDateArr[1];\n                var month = selectedDateArr[0];\n                var year = selectedDateArr[2];\n                var formatedDate = day+\" \"+monthArr[month]+\", \"+year;\n                let optionDate = year+\"-\"+month+\"-\"+day;\n                serverTimezoneDate = year+month+day;\n                var d = new Date(selectedDate);\n                var dayIndex = d.getDay();\n                if (dayIndex == 0) {\n                    dayIndex = 7;\n                }\n\n                var todayDate = new Date();\n                var tday = todayDate.getDate();\n                var tmonth = todayDate.getMonth() + 1;\n                var tyear = todayDate.getFullYear();\n                let holidayDateFormat = $.datepicker.formatDate('yy-mm-dd', d);;\n                var isHoliday = holidaysData[holidayDateFormat];\n                if(isHoliday){\n                    tmpl = null;\n                } else if (day == tday && month == tmonth && year == tyear) {\n                    // if from selected date is today\n                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n                    tmpl;\n                    tmpl = progressTmpl({\n                        data: todaySlotArr\n                    });\n                } else {\n                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template'+dayIndex),\n                    tmpl;\n                    tmpl = progressTmpl({\n                        data: {}\n                    });\n                }\n                $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n                let currentDate = parsedDate;\n                if (serverTimezoneDate) {\n                    currentDate = serverTimezoneDate;\n                }\n                if (currentDate in self.options.bookedData) {\n                    $.each(self.options.bookedData[currentDate], function (key, value) {\n                        if ($('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\").length) {\n                            var optTimeHtml = $('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\");\n                            var remainingQty = optTimeHtml.data(\"slot-qty\") - value;\n                            if (remainingQty <= 0) {\n                                optTimeHtml.removeClass('wk-bk-slot-booked');\n                                optTimeHtml.addClass('wk-bk-slot-booked');\n                            }\n                        }\n                    });\n                }\n\n                $('.wk-bk-select-time-opt-wrapper').removeAttr('style');\n                var selectedTime = $('.wk-bk-slot-selected').text();\n                var isTimeClosed = false;\n                $('#wk-bk-booking-time-field').val(selectedTime);\n                $('#wk-bk-slot-day-index').val($('.wk-bk-slot-selected').attr('data-day-index'));\n                $('#wk-bk-parent-slot-id').val($('.wk-bk-slot-selected').attr('data-index'));\n                $('#wk-bk-slot-id').val($('.wk-bk-slot-selected').attr('data-slot-index'));\n                if (!tmpl) {\n                    selectedTime = self.options.titleClosed;\n                    isTimeClosed = true;\n                    $('.wk-bk-select-time-opt-wrapper').attr('style', 'display: none;');\n                }\n                $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text(selectedTime);\n                if (!selectedTime) {\n                    $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text($t('Closed'));\n                }\n                $('.wk-bk-select-date-label').text(formatedDate);\n                $('.wk-bk-select-date-label').attr('data-booking-date', optionDate);\n                var bookedDate = $('.wk-bk-select-date-label').text();\n                $.each(options, function (k, v) {\n                    if (v.title == 'Booking Date') {\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(optionDate);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(optionDate)\n                            );\n                        }\n                    }\n                    if (v.title == 'Booking Slot') {\n                        if (isTimeClosed) {\n                            selectedTime = \"\";\n                        }\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(selectedTime);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(selectedTime)\n                            );\n                        }\n                    }\n                });\n            });\n            $('#wk-bk-select-date').trigger('change');\n            $(\"body\").on('click', '.wk-bk-select-time-opt', function () {\n                if (!$(this).hasClass('wk-bk-slot-booked')) {\n                    self._setProductOptions($(this), options);\n                }\n            });\n        },\n\n        _setProductOptions: function (element, options) {\n            var thisObj = element;\n            var selectedTime = thisObj.attr('data-type-time');\n            $(\".wk-bk-select-time-opt\").each(function () {\n                if ($(this).hasClass('wk-bk-slot-selected')) {\n                    $(this).removeClass('wk-bk-slot-selected');\n                }\n            });\n            thisObj.parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);\n            thisObj.addClass('wk-bk-slot-selected');\n            $('#wk-bk-booking-time-field').val(selectedTime);\n            $('#wk-bk-slot-day-index').val(thisObj.attr('data-day-index'));\n            $('#wk-bk-parent-slot-id').val(thisObj.attr('data-index'));\n            $('#wk-bk-slot-id').val(thisObj.attr('data-slot-index'));\n            var bookedDate = $('.wk-bk-select-date-label').attr('data-booking-date');\n            $.each(options, function (k, v) {\n                if (v.title == 'Booking Date') {\n                    if ($('#options_'+v.id+'_text').length) {\n                        $('#options_'+v.id+'_text').val(bookedDate);\n                    } else {\n                        $('#product-options-wrapper').find('.fieldset').append(\n                            $('<input>')\n                                .attr('type', 'hidden')\n                                .attr('name', 'options['+v.id+']')\n                                .attr('id', 'options_'+v.id+'_text')\n                                .val(bookedDate)\n                        );\n                    }\n                }\n                if (v.title == 'Booking Slot') {\n                    if ($('#options_'+v.id+'_text').length) {\n                        $('#options_'+v.id+'_text').val(selectedTime);\n                    } else {\n                        $('#product-options-wrapper').find('.fieldset').append(\n                            $('<input>')\n                                .attr('type', 'hidden')\n                                .attr('name', 'options['+v.id+']')\n                                .attr('id', 'options_'+v.id+'_text')\n                                .val(selectedTime)\n                        );\n                    }\n                }\n            });\n        }\n    });\n    return $.appointmentbooking.appointmentbooking;\n});\n","Webkul_AdvancedBookingSystem/js/catalog-add-to-cart.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine(\n    [\n        'jquery',\n        'mage/translate'\n    ],\n    function ($, $t) {\n        'use strict';\n\n        $.widget(\n            'mage.catalogAddToCart',\n            {\n                options: {\n                    processStart: null,\n                    processStop: null,\n                    bindSubmit: true,\n                    minicartSelector: '[data-block=\"minicart\"]',\n                    messagesSelector: '[data-placeholder=\"messages\"]',\n                    productStatusSelector: '.stock.available',\n                    addToCartButtonSelector: '.action.tocart',\n                    addToCartButtonDisabledClass: 'disabled',\n                    addToCartButtonTextWhileAdding: '',\n                    addToCartButtonTextAdded: '',\n                    addToCartButtonTextDefault: '',\n                    product_type: \"booking\"\n                },\n\n                /**\n                 * @inheritdoc\n                 */\n                _create: function () {\n                    if (this.options.bindSubmit) {\n                        this._bindSubmit();\n                    }\n                },\n\n                /**\n                 * @private\n                 */\n                _bindSubmit: function () {\n                    var self = this;\n\n                    this.element.on(\n                        'submit',\n                        function (e) {\n                            e.preventDefault();\n                            self.submitForm($(this));\n                        }\n                    );\n                },\n\n                /**\n                 * @return {Boolean}\n                 */\n                isLoaderEnabled: function () {\n                    return this.options.processStart && this.options.processStop;\n                },\n\n                /**\n                 * Handler for the form 'submit' event\n                 *\n                 * @param {Object} form\n                 */\n                submitForm: function (form) {\n                    var addToCartButton, self = this;\n                    var flag = 1;\n                    if (self.options.product_type !== \"rentalbooking\" && self.options.product_type !== \"tablebooking\") {\n                        form.find('.product-custom-option').each(\n                            function (params) {\n                                var thisObj = $(this);\n                                if (thisObj.val() && flag) {\n                                    var qty = thisObj.val();\n                                    var optionId = $(this).attr('data-option-id');\n                                    var optionValId = $(this).attr('data-option-val-id');\n                                    var dataForm = form.serializeArray();\n                                    if (self.options.product_type == \"hotelbooking\") {\n                                        var hotelQty = self.calculateQty();\n                                        dataForm.push({ name: 'hotel_qty', value: hotelQty });\n                                    } else {\n                                        dataForm.push({ name: 'qty', value: qty });\n                                    }\n                                    $.each(\n                                        dataForm,\n                                        function (i, field) {\n                                            if (field.name.indexOf(\"booking_options[\") >= 0) {\n                                                if (field.name != 'booking_options[' + optionValId + '][qty]') {\n                                                    dataForm[i] = '{}';\n                                                }\n                                            }\n                                            if (field.name == 'options[' + optionId + '][]' && field.value != optionValId) {\n                                                dataForm[i] = '{}';\n                                            }\n                                        }\n                                    );\n                                    var newSubmittedFormData = $.param(dataForm);\n\n                                    if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                                        self.element.off('submit');\n                                        // disable 'Add to Cart' button\n                                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                                        addToCartButton.prop('disabled', true);\n                                        addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                                        self.ajaxSubmit(form);\n                                    } else {\n                                        self.ajaxSubmit(form, newSubmittedFormData);\n                                    }\n                                    flag = 0;\n                                }\n                            }\n                        );\n                        if (flag) {\n                            if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                                self.element.off('submit');\n                                // disable 'Add to Cart' button\n                                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                                addToCartButton.prop('disabled', true);\n                                addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                                self.ajaxSubmit(form);\n                            } else {\n                                self.ajaxSubmit(form);\n                            }\n                        }\n                    } else {\n                        self.ajaxSubmit(form);\n                    }\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                ajaxSubmit: function (form, newSubmittedFormData = '') {\n                    var self = this;\n\n                    $(self.options.minicartSelector).trigger('contentLoading');\n                    self.disableAddToCartButton(form);\n                    if (!newSubmittedFormData) {\n                        newSubmittedFormData = form.serialize();\n                    }\n                    $.ajax(\n                        {\n                            url: form.attr('action'),\n                            data: newSubmittedFormData,\n                            type: 'post',\n                            dataType: 'json',\n\n                            /**\n                             * @inheritdoc\n                             */\n                            beforeSend: function () {\n                                if (self.isLoaderEnabled()) {\n                                    $('body').trigger(self.options.processStart);\n                                }\n                            },\n\n                            /**\n                             * @inheritdoc\n                             */\n                            success: function (res) {\n                                var eventData, parameters;\n\n                                $(document).trigger('ajax:addToCart', form.data().productSku);\n\n                                if (self.isLoaderEnabled()) {\n                                    $('body').trigger(self.options.processStop);\n                                }\n\n                                if (res.backUrl) {\n                                    eventData = {\n                                        'form': form,\n                                        'redirectParameters': []\n                                    };\n                                    // trigger global event, so other modules will be able add parameters to redirect url\n                                    $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                                    if (eventData.redirectParameters.length > 0) {\n                                        parameters = res.backUrl.split('#');\n                                        parameters.push(eventData.redirectParameters.join('&'));\n                                        res.backUrl = parameters.join('#');\n                                    }\n                                    window.location = res.backUrl;\n\n                                    return;\n                                }\n\n                                if (res.messages) {\n                                    $(self.options.messagesSelector).html(res.messages);\n                                }\n\n                                if (res.minicart) {\n                                    $(self.options.minicartSelector).replaceWith(res.minicart);\n                                    $(self.options.minicartSelector).trigger('contentUpdated');\n                                }\n\n                                if (res.product && res.product.statusText) {\n                                    $(self.options.productStatusSelector)\n                                        .removeClass('available')\n                                        .addClass('unavailable')\n                                        .find('span')\n                                        .html(res.product.statusText);\n                                }\n                                self.enableAddToCartButton(form);\n                            }\n                        }\n                    );\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                disableAddToCartButton: function (form) {\n                    var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n                    addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                    addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n                    addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                enableAddToCartButton: function (form) {\n                    var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                        self = this,\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n                    addToCartButton.find('span').text(addToCartButtonTextAdded);\n                    addToCartButton.attr('title', addToCartButtonTextAdded);\n\n                    setTimeout(\n                        function () {\n                            if (self.options.product_type == \"booking\") {\n                                var addToCartButtonTextDefault = $t('Book Now');\n                            } else if (self.options.product_type == \"rentalbooking\") {\n                                var addToCartButtonTextDefault = $t('Rent Now');\n                            } else if (self.options.product_type == \"hotelbooking\") {\n                                var addToCartButtonTextDefault = $t('Book Now');\n                            } else {\n                                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n                            }\n\n                            addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                            addToCartButton.find('span').text(addToCartButtonTextDefault);\n                            addToCartButton.attr('title', addToCartButtonTextDefault);\n                        },\n                        1000\n                    );\n                },\n\n                calculateQty: function () {\n                    var qty = 0;\n                    var bookingFrom = Date.parse($(\"input#wk-bk-select-date-from\").val());\n                    var bookingTo = Date.parse($(\"input#wk-bk-select-date-to\").val());\n\n                    var noOfDays = Math.round((bookingTo - bookingFrom) / (1000 * 60 * 60 * 24));\n                    qty = qty + noOfDays;\n\n                    return qty;\n                }\n            }\n        );\n\n        return $.mage.catalogAddToCart;\n    }\n);\n","Webkul_AdvancedBookingSystem/js/event/validate-product.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'Webkul_AdvancedBookingSystem/js/event/catalog-add-to-cart'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.productValidate', {\n        options: {\n            bindSubmit: false,\n            radioCheckboxClosest: '.nested'\n        },\n\n        /**\n         * Uses Magento's validation widget for the form object.\n         * @private\n         */\n        _create: function () {\n            var bindSubmit = this.options.bindSubmit;\n\n            this.element.validation({\n                radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                /**\n                 * Uses catalogAddToCart widget as submit handler.\n                 * @param {Object} form\n                 * @returns {Boolean}\n                 */\n                submitHandler: function (form) {\n                    var jqForm = $(form).catalogAddToCart({\n                        bindSubmit: bindSubmit\n                    });\n\n                    jqForm.catalogAddToCart('submitForm', jqForm);\n\n                    return false;\n                }\n            });\n        }\n    });\n\n    return $.mage.productValidate;\n});","Webkul_AdvancedBookingSystem/js/event/eventbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\n define([\n    \"jquery\",\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n    $.widget(\n        'eventbooking.eventbooking',\n        {\n            options: {\n            },\n            _create: function () {\n                $('body').trigger('contentUpdated');\n                $(document).ready(function() {\n                    $('#wk-bk-design-others-info').insertAfter('.product-info-price');\n                    $('#wk-bk-design-others-info').show();\n                });\n\n                $(\"#wk-book-now\").click(function(event){\n                    event.preventDefault();\n                    var ctr = 0;\n                    $('.wk-event-custom-option').each(function () {\n                        var cOptionId = $(this).attr('data-option-id');\n                        var cOptionValue = $(this).attr('data-option-val-id');\n                        var selector = '#wk-bk-opt-val-'+cOptionId+cOptionValue;\n                        if ($(selector).val() && $(selector).val() >= 1) {\n                            ctr++;\n                        }\n                    });\n\n                    if (!ctr) {\n                        $('.err').show();\n                        $('.err').text($t('Please enter a valid number in this field'));\n                    } else {\n                        $('#product_addtocart_form').submit();\n                        $('.err').hide();\n                    }\n                });\n            }\n        }\n    );\n    return $.eventbooking.eventbooking;\n});\n","Webkul_AdvancedBookingSystem/js/event/catalog-add-to-cart.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/ui'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: 'Buy Tickets'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {Object} form\n         */\n        submitForm: function (form) {\n            var addToCartButton, self = this;\n            var flag = 1;\n            form.find('.wk-event-custom-option').each(function (index, params) {\n                var thisObj = $(this);\n\n                if (thisObj.val() && parseInt(thisObj.val()) > 0) {\n                    var qty = thisObj.val();\n                    var optionId = $(this).attr('data-option-id');\n                    var optionValId = $(this).attr('data-option-val-id');\n                    var dataForm = form.serializeArray();\n                    dataForm.push({ name: 'qty', value: qty });\n                    $.each(dataForm, function (i, field) {\n                        if (field.name.indexOf(\"booking_options[\") >= 0) {\n                            if (field.name != 'booking_options[' + optionValId + '][qty]') {\n                                dataForm[i] = '{}';\n                            }\n                        }\n                        if (field.name == 'options[' + optionId + '][]' && field.value != optionValId) {\n                            dataForm[i] = '{}';\n                        }\n                    });\n                    var newSubmittedFormData = $.param(dataForm);\n\n                    if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                        self.element.off('submit');\n                        // disable 'Add to Cart' button\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                        addToCartButton.prop('disabled', true);\n                        addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                        form.submit();\n                    } else {\n                        setTimeout(function () {\n                            self.ajaxSubmit(form, newSubmittedFormData);\n                        }, index*1500);\n                    }\n                    flag = 0;\n                }\n            });\n            if (flag) {\n                if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                    self.element.off('submit');\n                    // disable 'Add to Cart' button\n                    addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                    addToCartButton.prop('disabled', true);\n                    addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                    form.submit();\n                } else {\n                    self.ajaxSubmit(form);\n                }\n            }\n        },\n\n        /**\n         * @param {String} form\n         */\n        ajaxSubmit: function (form, newSubmittedFormData = '') {\n            var self = this;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n            if (!newSubmittedFormData) {\n                newSubmittedFormData = form.serialize();\n            }\n            $.ajax({\n                url: form.attr('action'),\n                data: newSubmittedFormData,\n                type: 'post',\n                dataType: 'json',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', form.data().productSku);\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n                        window.location = res.backUrl;\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.attr('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.attr('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});","Webkul_AdvancedBookingSystem/js/grid/columns/column.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            var action = this.fieldAction,\n                callback;\n\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Webkul_AdvancedBookingSystem/js/grid/columns/link.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    './column',\n    'jquery',\n], function (Column, $) {\n    'use strict';\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/html',\n            fieldClass: {\n                'data-grid-html-cell': true\n            }\n        },\n        getFieldHandler: function (row) {\n            return false;\n        }\n    });\n});\n"}
}});
