define([
    'uiComponent',
    'Magento_Customer/js/model/address-list',
    'mage/translate',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/action/select-billing-address',
    'Magento_Checkout/js/checkout-data'
], function (
    Component,
    addressList,
    $t,
    customer,
    selectBillingAddress,
    checkoutData
) {
    'use strict';

    var newAddressOption = {
        getAddressInline: function () {
            return $t('Agregar nueva dirección');
        },
        customerAddressId: null
    };

    var addressOptionsArr = addressList()
        .filter(function (addr) {
            return addr.getType() === 'customer-address';
        })
        .concat(newAddressOption);

    var defaultIndex = addressOptionsArr.findIndex(function (addr) {
        return addr.isDefaultBilling();
    });

    return Component.extend({

        defaults: {
            template: 'Magento_Checkout/billing-address',

            addressOptions: addressOptionsArr,
            selectedAddress: addressOptionsArr[defaultIndex] || newAddressOption,
            isNewAddressSelected: false
        },

        /**
         * Se ejectua al crear la instancia.
         */
        initialize: function () {
            this._super();
            this.newAddressOption = newAddressOption;
        },

        initObservable: function () {
            this._super()
                .observe(['selectedAddress', 'isNewAddressSelected']);

            this.isNewAddressSelected(
                !customer.isLoggedIn() || addressOptionsArr.length === 0
            );
            return this;
        },

        /**
         * Maneja el click sobre una tarjeta de dirección.
         * @param {Object} address
         */
        updateAddress: function (address) {
            this.selectedAddress(address);
            this.isNewAddressSelected(address === newAddressOption);

            selectBillingAddress(address);
            if (address && typeof address.getKey === 'function') {
                checkoutData.setSelectedBillingAddress(address.getKey());
            }
        },


        addressOptionsText: function (address) {
            return address.getAddressInline();
        },


        onAddressChange: function (address) {
            this.isNewAddressSelected(address === newAddressOption);
        },
        cancelAddressEdit: function () {
            this.isNewAddressSelected(false);
        },
        
        canUseCancelBillingAddress: function () {
            return true;
        }
    });
});
