define([
    'jquery',
    'mage/url',
    'Magento_Customer/js/customer-data',
    'Magento_Ui/js/modal/confirm'
], function($, urlBuilder, customerData, confirm) {
    'use strict';
    return function() {
           $(document).on('click', '.btn-trash, .delete-card', function(e) {
            e.preventDefault();
            var $btn    = $(this),
                cardId  = $btn.data('card-id');

            confirm({
                content: $.mage.__('Are you sure you want to delete this card?'),                actions: {
                    confirm: function () {
                        $.ajax({
                            url: urlBuilder.build('stripecards/cards/deletecard'),
                            type: 'POST',
                            data: { card_id: cardId },
                            showLoader: true,
                            success: function(response) {
                                if (response.success) {
                                    alert($.mage.__('Card successfully removed.'));
                                    customerData.reload(['customer']);
                                    location.reload();
                                } else {
                                    alert(response.message);
                                }
                            },
                            error: function() {
                                alert($.mage.__('Ocurrió un error al eliminar la tarjeta.'));
                            }
                        });
                    },
                    cancel: function () {
                    }
                }
            });
        });
    };
});
