define([
    'jquery',
    'Magento_Ui/js/modal/alert',
    'Magento_Ui/js/model/messageList',
    'Magento_Customer/js/customer-data',
    'mage/translate',
    'mage/url'
], function ($, alert, messageList, customerData,$t,urlBuilder) {
    'use strict';

    return function (config, element) {
        $(element).on('click', function (e) {
            e.preventDefault();
            var productId = $(this).data('product-id');

            $.ajax({
                url: config.addToWishlistUrl,
                type: 'POST',
                data: { product_id: productId },
                dataType: 'json',
                showLoader: true,
                success: function (response) {
                    
                    if (response.success) {
                       // Mostrar mensaje de éxito
                       messageList.addSuccessMessage({
                        message: response.message
                    });
                    customerData.set('messages', {
                        messages: [{
                            text: response.message,
                            type: 'success'
                        }]
                    });
                        
                        if (response.action == "add") {
                            $(element).children().attr("src",urlBuilder.build('static/frontend/Sm/multe/es_MX/Threedadv_CarouselView/images/Heart.svg'));
                            $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic="true" role="alert" class="messages wishlist-message">
                                <div class="success-error success message" data-ui-id="message-error" style="width: fit-content;">
                                    <div>`+$t(response.message)+`</div>
                                </div>
                            </div>`);
                            setTimeout(() => {
                                $('.wishlist-message').remove();
                            },3000);
                        }else{
                            $(element).children('img').attr("src",urlBuilder.build('static/frontend/Sm/multe/es_MX/Threedadv_CarouselView/images/Favorite.png'));
                            $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic="true" role="alert" class="messages wishlist-message">
                                <div class="message-success success message" data-ui-id="message-error" style="width: fit-content;">
                                    <div>`+$t(response.message)+`</div>
                                </div>
                            </div>`);
                            setTimeout(() => {
                                $('.wishlist-message').remove();
                            }, 3000);
                        }
                    } else {
                        
                       // Mostrar mensaje de error
                       $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic="true" role="alert" class="messages wishlist-message">
                            <div class="message-success success message" data-ui-id="message-error" style="width: fit-content;">
                                <div>`+$t(response.message)+`</div>
                            </div>
                        </div>`);
                        setTimeout(() => {
                            $('.wishlist-message').remove();
                        }, 3000);
                    }
                },
                error: function () {
                    // Mostrar mensaje de error genérico
                    $(element).parent().parent().parent().parent().parent().before(`<div aria-atomic="true" role="alert" class="messages wishlist-message">
                        <div class="message-error error message" data-ui-id="message-error" style="width: fit-content;">
                            <div>`+$t(response.message)+`</div>
                        </div>
                    </div>`);
                    setTimeout(() => {
                        $('.wishlist-message').remove();
                    }, 3000);
                }
            });
        });
    };
});