/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
 define([
    "jquery",
    'mage/translate'
], function ($, $t) {
    'use strict';
    $.widget(
        'eventbooking.eventbooking',
        {
            options: {
            },
            _create: function () {
                $('body').trigger('contentUpdated');
                $(document).ready(function() {
                    $('#wk-bk-design-others-info').insertAfter('.product-info-price');
                    $('#wk-bk-design-others-info').show();
                });

                $("#wk-book-now").click(function(event){
                    event.preventDefault();
                    var ctr = 0;
                    $('.wk-event-custom-option').each(function () {
                        var cOptionId = $(this).attr('data-option-id');
                        var cOptionValue = $(this).attr('data-option-val-id');
                        var selector = '#wk-bk-opt-val-'+cOptionId+cOptionValue;
                        if ($(selector).val() && $(selector).val() >= 1) {
                            ctr++;
                        }
                    });

                    if (!ctr) {
                        $('.err').show();
                        $('.err').text($t('Please enter a valid number in this field'));
                    } else {
                        $('#product_addtocart_form').submit();
                        $('.err').hide();
                    }
                });
            }
        }
    );
    return $.eventbooking.eventbooking;
});
