require(['jquery'], function($) {
    $(document).ready(function() {
        $(document).on('click', '.action.submit.primary', function(event) {
            var allRatingsFilled = true;

            $('.field-error').remove();

            $('input[type="radio"][name^="ratings"]').each(function() {
                var ratingName = $(this).attr('name');
                var ratingGroup = $(this).closest('.review-field-rating');
                if ($('input[name="' + ratingName + '"]:checked').length === 0) {
                    allRatingsFilled = false;
                    if (ratingGroup.next('.field-error').length === 0) {
                        ratingGroup.after('<div class="field-error">Este campo es obligatorio.</div>');
                    }
                }
            });

            if (!allRatingsFilled) {
                event.preventDefault();
                $('#error-message').show();
            } else {
                $('#error-message').hide();
            }
        });
    });
});
