require.config({"config": {
        "jsbuild":{"Andromeda_MenuDigital/js/menudigital.js":"require(['jquery', 'mage/translate', 'Magento_Ui/js/modal/modal'], function ($, $t, modal) {\n    $(document).ready(function () {\n\n        $('.custom-header-links li').each(function () {\n            var linkText = $(this).find('a').text().trim();\n            if (linkText === 'Menu digital') {\n                $(this).addClass('active');\n            }\n        });\n\n        $('.link-create-menu').on('click', function() {\n            window.location.href = '/menudigital/index/create';\n        });\n\n        $('.link-introduction-menu').on('click', function() {\n            window.location.href = '/menudigital/index/introduction/';\n        });\n\n\n        //Tabs header\n        $('.tabs .tab').on('click', function() {\n\n            var tabId = $(this).data('tab-id');\n\n            // Validar solo si hacen click en las pesta\u00f1as que mencionaste\n            if (tabId === 'select-categories' || tabId === 'select-products' || tabId === 'select-template' || tabId === 'select-custom' || tabId === 'select-preview' ) {\n                var menuId = $('#menu-id').val().trim(); // Tomamos el valor del input y quitamos espacios\n\n                if (menuId === '') {\n                    alert('Debes de completar la secci\u00f3n de \"Informaci\u00f3n men\u00fa\" para continuar.');\n                    return false;\n                }\n            }\n\n\n\n            $('.container-block').hide();\n            var tabId = $(this).data('tab-id');\n            if(tabId == 'select-template'){\n                $('.container-template').show();\n            }else if(tabId == 'select-custom'){\n                $('.container-custom').show();\n            }else if(tabId == 'select-preview'){\n                $('.container-preview').show();\n                reloadPreview();\n            }else if(tabId == 'select-create-menu'){\n                $('.container-information').show();\n            }else if(tabId == 'select-categories'){\n                $('.container-categories').show();\n                reloadCategories();\n                let menuId = $('#menu-id').val();\n                if (menuId && menuId.trim() !== '') {\n                    $('.wrapper-list-categories').show();\n                }\n            }else{\n                $('.container-products').show();\n                $('.contenedor-principal, .template-section').show();\n                $('.container-new-product').hide();\n                reloadTableProducts();\n            }\n            $('.tabs .tab').removeClass('active');\n            $(this).addClass('active');\n\n        });\n\n        //DASHBOARD\n        $(document).on('click', '.menu-options', function (e) {\n            e.stopPropagation();\n            const $menu = $(this).siblings('.dropdown-menu');\n            $('.dropdown-menu').not($menu).hide();\n            $menu.toggle();\n        });\n\n        $(document).on('click', function () {\n            $('.dropdown-menu').hide();\n        });\n\n        $('.menu-list').on('click', '.item-show', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.open('/menudigital/index/view/id/' + id, '_blank');\n        });\n\n        $('.menu-list').on('click', '.item-qr', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.location.href = '/menudigital/index/qr/id/'+id;\n        });\n\n        $('.menu-list').on('click', '.item-edit', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            window.location.href = '/menudigital/index/menu/id/'+id;\n        });\n\n        $('.menu-list').on('click', '.item-delete', function () {\n            const card = $(this).closest('.menu-card');\n            const id = card.data('id');\n            if (!id) return;\n\n            if (!confirm('\u00bfEst\u00e1s seguro de que deseas eliminar este men\u00fa?')) return;\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/deletemenu',\n                method: 'POST',\n                data: { id },\n                success: function (res) {\n                    if (res.success) {\n                        card.fadeOut(300, () => card.remove());\n                    } else {\n                        alert(res.message || 'Error al eliminar', false);\n                    }\n                },\n                error: function () {\n                    alert('Error de red', false);\n                }\n            });\n        });\n\n        // Inicializar cada modal por clase\n        $('.modal-contenido').each(function() {\n            var options = {\n                type: 'popup',\n                responsive: true,\n                innerScroll: true,\n                title: 'Vista previa',\n                buttons: [{\n                    text: $.mage.__('Cerrar'),\n                    class: 'action-secondary',\n                    click: function () {\n                        this.closeModal();\n                    }\n                }]\n            };\n\n            modal(options, $(this));\n        });\n\n        // Abrir el modal correspondiente al hacer clic\n        $('.abrir-modal, .card-actions').on('click', function() {\n            var modalId = $(this).data('modal-id');\n            $('#' + modalId).modal('openModal');\n        });\n\n        //upload image product\n        $('#upload-image').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2 MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n            if (!file) return;\n\n            const reader = new FileReader();\n            reader.onload = function (e) {\n                $('.preview-image').attr('src', e.target.result).show();\n                $('.image-upload-placeholder').hide();\n                $('.image-upload-placeholder-loaded').show();\n\n            };\n            reader.readAsDataURL(file);\n        });\n\n        $('#edit-upload-image').on('change', function (event) {\n            const file = event.target.files[0];\n            if (!file) return;\n\n            const reader = new FileReader();\n            reader.onload = function (e) {\n                $('.edit-preview-image').attr('src', e.target.result).show();\n                $('.edit-image-upload-placeholder').hide();\n                $('.edit-image-upload-placeholder-loaded').show();\n\n            };\n            reader.readAsDataURL(file);\n        });\n\n        $('.remove-image').on('click', function () {\n            $('#upload-image').val('');\n            $('.preview-image').attr('src', '').hide();\n            $('.image-upload-placeholder').show();\n            $('.image-upload-placeholder-loaded').hide();\n\n        });\n\n        $('.edit-remove-image').on('click', function () {\n            $('#edit-upload-image').val('');\n            $('.edit-preview-image').attr('src', '').hide();\n            $('.edit-image-upload-placeholder').show();\n            $('.edit-image-upload-placeholder-loaded').hide();\n\n        });\n\n\n\n        $('.add-image').on('click', function () {\n            $('#upload-image').click();\n        });\n\n        $('.edit-add-image').on('click', function () {\n            $('#edit-upload-image').click();\n        });\n\n        $('.menu-actions.cancel').on('click', function() {\n            window.location.href = '/menudigital/index/dashboard/';\n        });\n\n        //Guardar Informaci\u00f3n MENU\n        $('.container-information .btn-save-info-menu').on('click', function (e) {\n            e.preventDefault(); // Evita el env\u00edo tradicional del formulario\n\n            var form = $('#menu-form')[0]; // obtenemos el DOM puro del form\n            var formData = new FormData(form); // construimos el FormData desde el form\n\n            // Validaciones de campos obligatorios\n            var menuName = formData.get('menu_name');\n            var menuDesc = formData.get('menu_description');\n            var restaurantId = formData.get('restaurant_id');\n            var terms = formData.get('terms');\n            var status = formData.get('status');\n\n\n            let camposFaltantes = [];\n\n            if (!menuName) camposFaltantes.push('Nombre');\n            if (!restaurantId) camposFaltantes.push('Restaurante');\n            if (!menuDesc) camposFaltantes.push('Descripci\u00f3n');\n            if (!terms) camposFaltantes.push('Terminos y condiciones');\n            if (!status) camposFaltantes.push('Status');\n\n            if (camposFaltantes.length > 0) {\n                alert('Por favor, complete los siguientes campos:\\n- ' + camposFaltantes.join('\\n- '));\n                return;\n            }\n\n            if (menuName.length > 30) {\n                alert('El campo \"Nombre\" no puede tener m\u00e1s de 30 caracteres.');\n                return;\n            }\n\n            if (menuDesc.length > 200) {\n                alert('El campo \"Descripci\u00f3n\" no puede tener m\u00e1s de 200 caracteres.');\n                return;\n            }\n\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savemenuinfo',\n                type: 'POST',\n                showLoader: true,\n                data: formData,\n                processData: false,\n                contentType: false,\n                success: function (res) {\n                    if (res.success) {\n                        alert(res.message);\n                        $('#menu-id').val(res.menu_id);\n\n                        $('html, body').animate({\n                            scrollTop: $('.tabs').offset().top - 50\n                        }, 600, function () {\n                            // Aplicar efecto de resaltar al siguiente tab\n                            //$('.tab[data-tab-id=\"select-categories\"]').addClass('highlight-tab');\n\n                            // Opcional: removerlo despu\u00e9s de un tiempo (ej. 4 parpadeos \u2248 4s)\n                            setTimeout(function () {\n                                //$('.tab[data-tab-id=\"select-categories\"]').removeClass('highlight-tab');\n                            }, 2000);\n                        });\n\n\n\n                    } else {\n                        alert(res.message || 'Ocurri\u00f3 un error al guardar');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar el men\u00fa');\n                }\n            });\n        });\n\n        function buildSelect(levelData, level = 1, selectedPath = []) {\n            const select = $('<select>').attr('data-level', level).addClass('category-level');\n            select.addClass('custom-select');\n            select.append($('<option>', { value: '', text: '-- Selecciona --' }));\n\n            levelData.forEach(category => {\n                select.append($('<option>', {\n                    value: category.id,\n                    text: category.name,\n                    'data-json': JSON.stringify(category)\n                }));\n            });\n\n            return select;\n        }\n\n        function renderNextLevel(selectedOption, level) {\n            const selected = $(selectedOption).find(':selected');\n            const data = selected.data('json');\n            const nextData = data?.children || [];\n\n            $(\"#category-selects select\").each(function () {\n                if (parseInt($(this).data('level')) > level) {\n                    $(this).closest('.col-select').remove();\n                }\n            });\n\n            if (nextData.length > 0 && level < 4) {\n                const nextSelect = buildSelect(nextData, level + 1);\n                const container = $(`\n                        <div class=\"col-select form-group\">\n                            <label>Subcategorias</label>\n                        </div>\n                    `);\n\n                container.append(nextSelect);\n                $('#category-selects').append(container);\n            }\n            updateJson();\n        }\n\n        function updateJson() {\n            const path = {};\n            $('#category-selects select').each(function (index) {\n                const selected = $(this).find(':selected');\n                if (selected.val()) {\n                    path['level_' + (index + 1)] = {\n                        id: selected.val()\n                    };\n                }\n            });\n            $('#categories-json').val(JSON.stringify(path));\n        }\n\n        function buildSelectEdit(levelData, level = 1, selectedPath = []) {\n            const select = $('<select>').attr('data-level', level).addClass('category-level');\n            select.addClass('custom-select');\n            select.append($('<option>', { value: '', text: '-- Selecciona --' }));\n\n            levelData.forEach(category => {\n                select.append($('<option>', {\n                    value: category.id,\n                    text: category.name,\n                    'data-json': JSON.stringify(category)\n                }));\n            });\n\n            return select;\n        }\n        function renderNextLevelEdit(selectedOption, level) {\n            const selected = $(selectedOption).find(':selected');\n            const data = selected.data('json');\n            const nextData = data?.children || [];\n\n            $(\"#edit-category-selects select\").each(function () {\n                if (parseInt($(this).data('level')) > level) {\n                    $(this).closest('.col-select').remove();\n                }\n            });\n\n            if (nextData.length > 0 && level < 4) {\n                const nextSelect = buildSelect(nextData, level + 1);\n                const container = $(`\n                        <div class=\"col-select form-group\">\n                            <label>Subcategorias</label>\n                        </div>\n                    `);\n\n                container.append(nextSelect);\n                $('#edit-category-selects').append(container);\n            }\n            updateJsonEdit();\n        }\n\n        function updateJsonEdit() {\n            const path = {};\n            $('#edit-category-selects select').each(function (index) {\n                const selected = $(this).find(':selected');\n                if (selected.val()) {\n                    path['level_' + (index + 1)] = {\n                        id: selected.val(),\n                        name: selected.text()\n                    };\n                }\n            });\n            $('#edit-categories-json').val(JSON.stringify(path));\n        }\n\n\n        /*Ajax Add Product*/\n        $('#add-product').on('click', function () {\n\n            let formData = new FormData();\n            let nombre = $('#nombre').val();\n            let descripcion = $('#descripcion').val();\n            let precio = $('#precio').val();\n            let destacado = $('input[name=\"check-product-destacado\"]:checked').val();\n            let categorias = $('#categories-json').val();\n            let imagen = $('#upload-image')[0].files[0];\n            let categoriaNivel1 = $('select.category-level[data-level=\"1\"]').val();\n\n            let camposFaltantes = [];\n\n            if (!nombre) camposFaltantes.push('Nombre');\n            if (!descripcion) camposFaltantes.push('Descripci\u00f3n');\n            if (!categoriaNivel1) camposFaltantes.push('Categor\u00eda');\n            if (!precio) camposFaltantes.push('Precio');\n            if (!destacado) camposFaltantes.push('Producto destacado');\n            if (!imagen) camposFaltantes.push('Imagen');\n\n            if (camposFaltantes.length > 0) {\n                alert('Por favor, complete los siguientes campos:\\n- ' + camposFaltantes.join('\\n- '));\n                return;\n            }\n\n            if (nombre.length > 30) {\n                alert('El campo \"Nombre\" no puede tener m\u00e1s de 30 caracteres.');\n                return;\n            }\n\n            if (descripcion.length > 200) {\n                alert('El campo \"Descripci\u00f3n\" no puede tener m\u00e1s de 200 caracteres.');\n                return;\n            }\n\n            if (precio.length > 7) {\n                alert('El campo \"Precio\" no puede tener m\u00e1s de 7 caracteres.');\n                return;\n            }\n\n\n            formData.append('nombre', nombre);\n            formData.append('descripcion', descripcion);\n            formData.append('precio', precio);\n            formData.append('destacado', destacado);\n            formData.append('categorias', categorias);\n            if (imagen) {\n                formData.append('imagen', imagen);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/saveproduct',\n                type: 'POST',\n                data: formData,\n                contentType: false,\n                processData: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        reloadTableProducts();\n                    } else {\n                        alert(res.message || 'Error inesperado');\n                    }\n                },\n                error: function () {\n                    alert('Error al procesar el producto');\n                }\n            });\n        });\n\n        $('.container-products').on('click', '.boton-agregar-producto', function () {\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('#category-selects .col-select').remove();\n                    let tempDiv = $('<div>').html(response);\n                    let newContent = tempDiv.find('#data-categories');\n                    let categoryData = newContent[0]['attributes']['value']['value'];\n                    let parsedData = JSON.parse(categoryData);\n                    const firstSelect = buildSelect(parsedData);\n                    const container = $(`\n                            <div class=\"col-select form-group\">\n                                <label>Categorias</label>\n                            </div>\n                        `);\n                    container.append(firstSelect);\n                    $('#category-selects').append(container);\n\n                    $('#category-selects').on('change', 'select', function () {\n                        const level = parseInt($(this).data('level'));\n                        renderNextLevel($(this), level);\n                    });\n                    $('.container-new-product').show();\n                    $('.template-section, .contenedor-principal').hide();\n                    limpiarFormularioProducto();\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n\n        });\n\n        $('#cancel-product').on('click', function () {\n            $('.container-new-product').hide();\n            $('.template-section, .contenedor-principal').show();\n            limpiarFormularioProducto();\n        });\n\n        function limpiarFormularioProducto() {\n            const $form = $('.container-new-product');\n            $form.find('#nombre, #descripcion, #precio').val('');\n            $form.find('select.category-level').val('');\n            $form.find('#upload-image').val('');\n            $form.find('.preview-image').attr('src', '');\n            $form.find('.image-upload-placeholder-loaded').hide();\n            $form.find('.image-upload-placeholder').show();\n        }\n\n\n        function reloadTableProducts(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.product-table');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.product-table').replaceWith(newContent);\n                    $('.container-new-product').hide();\n                    $('input[name=\"check-product-destacado\"][value=\"0\"]').prop('checked', true);\n                    $('.contenedor-principal, .template-section').show();\n\n\n\n                    // Inicializar paginador nuevamente despu\u00e9s de reemplazar la tabla\n                    (function setupPaginator() {\n                        const rowsPerPage = $('#number-paginator').val();\n                        const $rows = $('.product-table tbody tr');\n                        const totalRows = $rows.length;\n                        const totalPages = Math.ceil(totalRows / rowsPerPage);\n                        let currentPage = 1;\n\n                        function showPage(page) {\n                            if (page < 1 || page > totalPages) return;\n                            currentPage = page;\n                            $rows.hide();\n                            const start = (page - 1) * rowsPerPage;\n                            const end = start + rowsPerPage;\n                            $rows.slice(start, end).show();\n\n                            renderPagination();\n                        }\n\n                        function createPageElement(label, page, isActive = false, isEllipsis = false) {\n                            const $el = $('<div class=\"paginator-number\"></div>');\n                            $el.text(label);\n\n                            if (isEllipsis) {\n                                $el.addClass('ellipsis');\n                                return $el;\n                            }\n\n                            if (isActive) $el.addClass('active');\n\n                            $el.attr('data-page', page);\n                            $el.on('click', () => showPage(page));\n\n                            return $el;\n                        }\n\n                        function renderPagination() {\n                            let $pagination = $('.paginator-container');\n                            if ($pagination.length === 0) {\n                                $pagination = $('<div class=\"paginator-container\"></div>');\n                                let $paginatorWrapper = `\n                                <div class=\"paginator-select-wrapper\">\n                                  <div class=\"paginator-select-container\">\n                                    <select id=\"paginator-select\" class=\"paginator-select\">\n                                      <option value=\"10\">Productos por p\u00e1gina: 10</option>\n                                      <option value=\"20\">Productos por p\u00e1gina: 20</option>\n                                      <option value=\"30\">Productos por p\u00e1gina: 30</option>\n                                      <option value=\"40\">Productos por p\u00e1gina: 40</option>\n                                      <option value=\"50\">Productos por p\u00e1gina: 50</option>\n                                      <option value=\"60\">Productos por p\u00e1gina: 60</option>\n                                    </select>\n                                    <div class=\"paginator-arrow\"></div>\n                                  </div>\n                                </div>\n                                `;\n                                $('.wrapper-paginator').append($pagination);\n                                $('.wrapper-paginator').append($paginatorWrapper);\n                            }\n                            $pagination.empty();\n\n                            const $prev = $('<div class=\"paginator-nav-left\"></div>').on('click', () => showPage(currentPage - 1));\n                            const $next = $('<div class=\"paginator-nav-right\"></div>').on('click', () => showPage(currentPage + 1));\n                            $pagination.append($prev);\n\n                            if (totalPages <= 7) {\n                                for (let i = 1; i <= totalPages; i++) {\n                                    $pagination.append(createPageElement(i, i, i === currentPage));\n                                }\n                            } else {\n                                $pagination.append(createPageElement(1, 1, currentPage === 1));\n\n                                if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));\n\n                                const start = Math.max(2, currentPage - 2);\n                                const end = Math.min(totalPages - 1, currentPage + 2);\n                                for (let i = start; i <= end; i++) {\n                                    $pagination.append(createPageElement(i, i, i === currentPage));\n                                }\n\n                                if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));\n\n                                $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));\n                            }\n\n                            $pagination.append($next);\n                        }\n\n                        renderPagination();\n                        showPage(1);\n                    })();\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('change', '#paginator-select', function () {\n            var valorSeleccionado = $(this).val();\n            $('#number-paginator').val(valorSeleccionado);\n            (function setupPaginator() {\n                const rowsPerPage = $('#number-paginator').val();\n                const $rows = $('.product-table tbody tr');\n                const totalRows = $rows.length;\n                const totalPages = Math.ceil(totalRows / rowsPerPage);\n                let currentPage = 1;\n\n                function showPage(page) {\n                    if (page < 1 || page > totalPages) return;\n                    currentPage = page;\n                    $rows.hide();\n                    const start = (page - 1) * rowsPerPage;\n                    const end = start + rowsPerPage;\n                    $rows.slice(start, end).show();\n\n                    renderPagination();\n                }\n\n                function createPageElement(label, page, isActive = false, isEllipsis = false) {\n                    const $el = $('<div class=\"paginator-number\"></div>');\n                    $el.text(label);\n\n                    if (isEllipsis) {\n                        $el.addClass('ellipsis');\n                        return $el;\n                    }\n\n                    if (isActive) $el.addClass('active');\n\n                    $el.attr('data-page', page);\n                    $el.on('click', () => showPage(page));\n\n                    return $el;\n                }\n\n                function renderPagination() {\n                    let $pagination = $('.paginator-container');\n                    if ($pagination.length === 0) {\n                        $pagination = $('<div class=\"paginator-container\"></div>');\n                        let $paginatorWrapper = `\n                                <div class=\"paginator-select-wrapper\">\n                                  <div class=\"paginator-select-container\">\n                                    <select id=\"paginator-select\" class=\"paginator-select\">\n                                      <option value=\"10\">Productos por p\u00e1gina: 10</option>\n                                      <option value=\"20\">Productos por p\u00e1gina: 20</option>\n                                      <option value=\"30\">Productos por p\u00e1gina: 30</option>\n                                      <option value=\"40\">Productos por p\u00e1gina: 40</option>\n                                      <option value=\"50\">Productos por p\u00e1gina: 50</option>\n                                      <option value=\"60\">Productos por p\u00e1gina: 60</option>\n                                    </select>\n                                    <div class=\"paginator-arrow\"></div>\n                                  </div>\n                                </div>\n                                `;\n                        $('.wrapper-paginator').append($pagination);\n                        $('.wrapper-paginator').append($paginatorWrapper);\n                    }\n                    $pagination.empty();\n\n                    const $prev = $('<div class=\"paginator-nav-left\"></div>').on('click', () => showPage(currentPage - 1));\n                    const $next = $('<div class=\"paginator-nav-right\"></div>').on('click', () => showPage(currentPage + 1));\n                    $pagination.append($prev);\n\n                    if (totalPages <= 7) {\n                        for (let i = 1; i <= totalPages; i++) {\n                            $pagination.append(createPageElement(i, i, i === currentPage));\n                        }\n                    } else {\n                        $pagination.append(createPageElement(1, 1, currentPage === 1));\n\n                        if (currentPage > 4) $pagination.append(createPageElement('...', null, false, true));\n\n                        const start = Math.max(2, currentPage - 2);\n                        const end = Math.min(totalPages - 1, currentPage + 2);\n                        for (let i = start; i <= end; i++) {\n                            $pagination.append(createPageElement(i, i, i === currentPage));\n                        }\n\n                        if (currentPage < totalPages - 3) $pagination.append(createPageElement('...', null, false, true));\n\n                        $pagination.append(createPageElement(totalPages, totalPages, currentPage === totalPages));\n                    }\n\n                    $pagination.append($next);\n                }\n\n                renderPagination();\n                showPage(1);\n            })();\n        });\n\n        /*INFORMACION DEL MENU - BOTONES ACTIONS*/\n        $('.menu-option').on('click', function () {\n            // Desactivar todos\n            $('.menu-option').removeClass('active');\n\n            // Activar el clicado\n            $(this).addClass('active');\n\n            // Seleccionar el radio correspondiente\n            $(this).find('input[type=\"radio\"]').prop('checked', true);\n        });\n\n        /* CATEGORIAS */\n        function getGroup(level, namePrefix) {\n            return `\n            <div class=\"category-group level-${level}\" data-level=\"${level}\">\n                <div class=\"form-group\">\n                    <input type=\"text\" class=\"input-text\" name=\"${namePrefix}[name]\" placeholder=\"Categor\u00eda nivel ${level}\" required />\n                    ${level < 4 ? '<div class=\"btn-agregar-subcategoria add-sub\" data-icono=\"true\" data-property-1=\"Positivo\" data-texto=\"true\"><div class=\"icon-add\" data-icons=\"icon-add\"></div><div class=\"btn-text\">Agregar subcategor\u00eda</div></div>' : ''}\n                    <div class=\"btn-agregar-subcategoria-cancel delete-sub\" data-icono=\"true\" data-property-1=\"Positivo\" data-texto=\"true\">\n                        <div class=\"icon-delete\" data-icons=\"icon-delete\"></div>\n                        <div class=\"btn-text\">Eliminar</div>\n                    </div>\n                </div>\n                <div class=\"subcategories\"></div>\n            </div>\n        `;\n        }\n\n        $('#categories-wrapper').on('click', '.add-sub', function () {\n            const parentGroup = $(this).closest('.category-group');\n            const level = parseInt(parentGroup.data('level'), 10);\n            if (level >= 4) return;\n\n            const parentName = parentGroup.find('input').attr('name');\n            const childCount = parentGroup.find('> .subcategories > .category-group').length;\n            const namePrefix = parentName.replace(/\\[name\\]$/, '') + '[children][' + childCount + ']';\n\n            const subGroup = $(getGroup(level + 1, namePrefix));\n            parentGroup.find('> .subcategories').append(subGroup);\n\n            subGroup.find('input').focus();\n        });\n\n        $('#categories-wrapper').on('click', '.delete-sub', function () {\n            const currentGroup = $(this).closest('.category-group');\n            currentGroup.remove();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-edit', function (e) {\n            e.stopPropagation();\n            const $categoryCard = $(this).closest('.category-card');\n            $categoryCard.find('.edit-form').first().slideToggle();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-add-sub', function (e) {\n            e.stopPropagation();\n            const $categoryCard = $(this).closest('.category-card');\n            $categoryCard.find('.add-sub-form').first().slideToggle();\n        });\n\n        $('#categories-wrapper').on('click', '.edit-save', function (e) {\n\n            let hayError = false;\n\n            // Limpiar errores previos\n            $('.wrapper-list-categories .edit-input').removeClass('campo-error-edit');\n            $('.wrapper-list-categories .mensaje-error-edit').remove();\n\n            $('.wrapper-list-categories .edit-input').each(function () {\n                const valor = $(this).val().trim();\n                const maxCaracteres = 30;\n\n                if (valor.length > maxCaracteres) {\n                    hayError = true;\n                    $(this).addClass('campo-error-edit');\n                    $(this).after('<div class=\"mensaje-error-edit\">M\u00e1ximo 30 caracteres permitidos.</div>');\n                }\n            });\n\n            if (hayError) {\n                // Opcional: hacer scroll al primer error\n                $('html, body').animate({\n                    scrollTop: $('.campo-error-edit').first().offset().top - 100\n                }, 500);\n                return;\n            }\n\n            const id = $(this).data('id');\n            const container = $('[data-id=\"' + id + '\"]');\n            const name = container.find('.edit-input').val();\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecategory',\n                type: 'POST',\n                showLoader: true,\n                data: { id: id, name: name },\n                success: function (res) {\n                    if (res.success) {\n                        alert('Actualizado correctamente');\n                        reloadCategories();\n                    } else {\n                        alert(res.message);\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado');\n                }\n            });\n        });\n\n        $('#categories-wrapper').on('click', '.accordion-toggle', function (e) {\n            if (!$(e.target).hasClass('btn-edit')) {\n             //   $(this).siblings('.sub-list').slideToggle();\n            }\n            if (!$(e.target).closest('.btn-edit, .btn-delete').length) {\n                const $toggle = $(this);\n                const $arrow = $toggle.find('.toggle-arrow-categories');\n\n                $toggle.siblings('.sub-list').slideToggle();\n                $arrow.toggleClass('rotated');\n            }\n        });\n\n        $(document).on('click', '.edit-save-sub-cat', function () {\n            const parentId = $(this).data('parent-id');\n            const level = $(this).data('level');\n            const input = $('.add-sub-form[data-parent-id=\"' + parentId + '\"]').find('.new-subcategory-input');\n            const name = input.val().trim();\n            const menuId = $('#menu-id').val();\n\n            if (!name) {\n                alert('El nombre no puede estar vac\u00edo');\n                return;\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/editcategories',\n                type: 'POST',\n                data: {\n                    parent_id: parentId,\n                    name: name,\n                    level: level,\n                    menu_id: menuId\n                },\n                success: function () {\n                    reloadCategories();\n                },\n                error: function () {\n                    alert('Ocurri\u00f3 un error al guardar la subcategor\u00eda');\n                }\n            });\n        });\n\n\n        $('#categories-wrapper').on('click', '.btn-delete', function (e) {\n            const id = $(this).data('id');\n            if (confirm('\u00bfEst\u00e1s seguro que deseas eliminar esta categor\u00eda?')) {\n                $.ajax({\n                    url: window.location.origin + '/menudigital/ajax/deletecategory',\n                    type: 'POST',\n                    showLoader: true,\n                    data: { id: id },\n                    success: function (res) {\n                        if (res.success) {\n                            reloadCategories();\n                        } else {\n                            alert(res.message || 'No se pudo eliminar');\n                        }\n                    },\n                    error: function () {\n                        alert('Error inesperado al eliminar');\n                    }\n                });\n            }\n        });\n\n        $(document).on('submit', '#category-form', function (e) {\n            e.preventDefault();\n        });\n\n        $('#categories-wrapper').on('click', '.btn-save-categories', function (e) {\n            e.preventDefault();\n\n            let hayError = false;\n\n            // Limpiar errores previos\n            $('#category-form .input-text').removeClass('campo-error');\n            $('#category-form .mensaje-error').remove();\n\n            $('#category-form .input-text').each(function () {\n                const valor = $(this).val().trim();\n                const maxCaracteres = 30;\n\n                if (valor.length > maxCaracteres) {\n                    hayError = true;\n                    $(this).addClass('campo-error');\n                    $(this).after('<div class=\"mensaje-error\">M\u00e1ximo 30 caracteres permitidos.</div>');\n                }\n            });\n\n            if (hayError) {\n                // Opcional: hacer scroll al primer error\n                $('html, body').animate({\n                    scrollTop: $('.campo-error').first().offset().top - 100\n                }, 500);\n                return;\n            }\n\n            let menuId = $('#menu-id').val();\n            $('#category-form').append('<input type=\"hidden\" value=\"'+menuId+'\" name=\"menu_id\">');\n            var form = $('#category-form')[0];\n            var formData = new FormData(form);\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecategories',\n                method: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (response) {\n                    if (response.success) {\n                        reloadCategories();\n                    } else {\n                        console.warn('Hubo un problema al guardar:', response.message || response);\n                    }\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error en el guardado AJAX:', error);\n                }\n            });\n        });\n\n        function reloadCategories(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/categories',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.container-categories.container-block');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.container-categories.container-block').replaceWith(newContent);\n                    $('.container-categories.container-block').show();\n                    $('.wrapper-list-categories').show();\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('click', '.category-card .edit-cancel', function () {\n            var $categoryCard = $(this).closest('.category-card');\n            var $btnEdit = $categoryCard.find('.btn-edit').first();\n            $btnEdit.trigger('click');\n        });\n\n        $(document).on('click', '.category-card .edit-cancel-sub-cat', function () {\n            var $categoryCard = $(this).closest('.category-card');\n            var $btnEdit = $categoryCard.find('.btn-add-sub').first();\n            $btnEdit.trigger('click');\n        });\n\n\n        /*ELIMNAR PRODUCTOS DEL GRID*/\n        $(document).on('click', '.action-delete', function (e) {\n            e.preventDefault();\n\n            const row = $(this).closest('tr');\n            const productId = row.data('id') || row.find('[data-id]').data('id');\n\n            if (!productId) {\n                alert('ID de producto no encontrado.');\n                return;\n            }\n\n            if (!confirm('\u00bfEst\u00e1s seguro que deseas eliminar este producto?')) {\n                return;\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/deleteproduct',\n                type: 'POST',\n                showLoader: true,\n                data: { id: productId },\n                success: function (res) {\n                    if (res.success) {\n                        row.fadeOut(300, function () { $(this).remove(); });\n                    } else {\n                        alert(res.message || 'Error al eliminar.');\n                    }\n                },\n                error: function () {\n                    alert('Error de conexi\u00f3n al eliminar producto.');\n                }\n            });\n        });\n\n        /* Editar productos creados */\n        $(document).on('click', '.action-edit', function (e) {\n            e.preventDefault();\n            const row = $(this).closest('tr');\n            console.log(row.find('td'));\n            const id = row.data('id');\n            const name = row.find('td').eq(2).text().trim();\n            const desc = row.find('td').eq(3).text().trim();\n            const priceText = row.find('td').eq(4).text().trim();\n            const price = priceText.replace(/\\$/g, '');\n            const recommended = row.find('td').eq(5).text().trim() === 'S\u00ed' ? '1' : '0';\n            const imageUrl = row.find('img.product-thumb').attr('src');\n            const categoryJson = JSON.parse(row.attr('data-json') || '{}');\n\n            $('#edit-id').val(id);\n            $('#edit-nombre').val(name);\n            $('#edit-descripcion').val(desc);\n            $('#edit-precio').val(price);\n            $(\"#edit-destacado-si\").prop(\"checked\", recommended === '1');\n            $(\"#edit-destacado-no\").prop(\"checked\", recommended === '0');\n\n            if (imageUrl) {\n                $('.edit-preview-image').attr('src', imageUrl);\n                $('.edit-image-upload-placeholder').hide();\n                $('.edit-image-upload-placeholder-loaded').show();\n            }\n\n            $('#edit-category-selects .col-select').remove();\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/create',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('#edit-category-selects .col-select').remove();\n                    let tempDiv = $('<div>').html(response);\n                    let newContent = tempDiv.find('#data-categories');\n                    let categoryData = newContent[0]['attributes']['value']['value'];\n                    let parsedData = JSON.parse(categoryData);\n                    const firstSelect = buildSelectEdit(parsedData);\n                    const container = $(`\n                            <div class=\"col-select form-group\">\n                                <label>Categorias</label>\n                            </div>\n                        `);\n                    container.append(firstSelect);\n                    $('#edit-category-selects').append(container);\n\n                    $('#edit-category-selects').on('change', 'select', function () {\n                        const level = parseInt($(this).data('level'));\n                        renderNextLevelEdit($(this), level);\n                    });\n                    $('.container-edit-product').show();\n                    $('.template-section, .contenedor-principal').hide();\n                    limpiarFormularioProducto();\n                    simulateSelectCascade(categoryJson);\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n\n            $('.container-new-product').hide();\n            $('.container-edit-product').show();\n        });\n\n        function simulateSelectCascade(categoryJson) {\n            const levels = [\"level_1\", \"level_2\", \"level_3\", \"level_4\"];\n\n            levels.forEach(function (level, index) {\n                setTimeout(function () {\n                    const data = categoryJson[level];\n                    if (data && data.id) {\n                        const select = $('#edit-category-selects select[data-level=\"' + (index + 1) + '\"]');\n                        if (select.length) {\n                            select.val(data.id).trigger('change');\n                        }\n                    }\n                }, index * 300);\n            });\n        }\n\n        $('#cancel-edit-product').on('click', function () {\n            $('.container-edit-product').hide();\n            $('.template-section, .contenedor-principal').show();\n        });\n\n        $('#save-edit-product').on('click', function () {\n            const formData = new FormData();\n            formData.append('id', $('#edit-id').val());\n            formData.append('name', $('#edit-nombre').val());\n            formData.append('description', $('#edit-descripcion').val());\n            formData.append('price', $('#edit-precio').val());\n            formData.append('recommended', $('input[name=\"edit-check-product-destacado\"]:checked').val());\n            formData.append('categories', $('#edit-categories-json').val());\n\n            const imageFile = $('#edit-upload-image')[0].files[0];\n            if (imageFile) {\n                formData.append('image', imageFile);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/editproduct',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        $('.container-new-product, .container-edit-product').hide();\n                        $('.template-section, .contenedor-principal').show();\n                        reloadTableProducts();\n                    } else {\n                        alert(res.message || 'Hubo un error al actualizar');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado');\n                }\n            });\n        });\n\n        /* Personalizaci\u00f3n */\n        $(document).on('click', '.custom-content-color-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-color').toggleClass('rotated');\n            $wrapper.find('.custom-content-color').slideToggle();\n        });\n\n        $(document).on('click', '.custom-content-typography-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-typography').toggleClass('rotated');\n            $wrapper.find('.custom-content-typography').slideToggle();\n        });\n\n        $(document).on('click', '.custom-content-image-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-image').toggleClass('rotated');\n            $wrapper.find('.custom-content-image').slideToggle();\n        });\n\n        /* Templates */\n\n        const selectedValue = $('input[name=\"check-template\"]:checked').val();\n        $('.get-check-template-saved').val(selectedValue);\n\n        $('.menu-actions-options-template .template-cancel').on('click', function() {\n            $('input[name=\"check-template\"]').prop('checked', false);\n            const savedValue = $('.get-check-template-saved').val();\n            $('input[name=\"check-template\"][value=\"' + savedValue + '\"]').prop('checked', true);\n        });\n\n        $('.menu-actions-options-template .template-save').on('click', function() {\n\n            var formData = new FormData();\n            const menuId = $('#menu-id').val();\n\n            formData.append('menu_id', menuId);\n            formData.append('template', $('input[name=\"check-template\"]:checked').val());\n            $('.get-check-template-saved').val($('input[name=\"check-template\"]:checked').val());\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savetemplate',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        alert(res.message || 'Plantilla guardada correctamente.');\n                    } else {\n                        alert(res.message || 'Error al guardar el la plantilla.');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar QR.');\n                }\n            });\n\n        });\n\n        /* Personalizaci\u00f3n */\n\n        document.querySelectorAll('.color-picker').forEach(function(colorPicker) {\n            colorPicker.addEventListener('input', function() {\n                const selectedColor = this.value;\n\n\n                const card = this.closest('.color-card');\n\n\n                const colorCode = card.querySelector('.color-code');\n                colorCode.value = selectedColor;\n\n                this.style.backgroundColor = selectedColor;\n            });\n        });\n\n        $('.color-refresh-icon').on('click', function () {\n            const newColor = $(this).data('color-id');\n            const parentCard = $(this).closest('.color-card');\n            const colorInput = parentCard.find('.color-picker');\n            const colorDiv = parentCard.find('.color-code');\n            colorInput.val(newColor).trigger('input');\n            colorDiv.val(newColor);\n        });\n\n\n        $(document).on('click', '.custom-icon-visibility', function () {\n            let $div = $('.custom-image-upload-placeholder-head-loaded');\n            if ($div.find('img').length > 0) {\n                $('.custom-image-upload-placeholder-head-loaded').slideToggle();\n            } else {\n                $('.custom-image-upload-placeholder-head').slideToggle();\n            }\n        });\n\n        $('.banner-button-upload').on('click', function () {\n            $('#custom-banner-upload').trigger('click');\n        });\n\n        $('#custom-banner-upload').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n\n            if (file && file.type.startsWith('image/')) {\n                const reader = new FileReader();\n\n                reader.onload = function (e) {\n                    $('.custom-image-upload-placeholder-head').hide();\n                    $('.custom-image-upload-placeholder-head-loaded').show();\n                    $('.custom-img-banner').remove();\n                    $('.custom-image-upload-placeholder-head-loaded').append(`\n                      <img class=\"custom-img-banner\" src=\"${e.target.result}\" alt=\"Vista previa\"/>\n                    `);\n                };\n\n                reader.readAsDataURL(file);\n            } else {\n                alert('Por favor selecciona una imagen v\u00e1lida.');\n            }\n        });\n\n        $('.banner-button-delete').on('click', function () {\n            let $div = $('.custom-image-upload-placeholder-head-loaded');\n            if ($div.find('img').length > 0) {\n                $('.custom-image-upload-placeholder-head-loaded').find('img').remove();\n                $('.custom-image-upload-placeholder-head-loaded').slideToggle();\n            }\n        });\n\n\n        $('.logo-button-upload').on('click', function () {\n            $('#custom-logo-upload').trigger('click');\n        });\n\n        $('#custom-logo-upload').on('change', function (event) {\n            const file = event.target.files[0];\n            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];\n            const maxSize = 2 * 1024 * 1024; // 2MB\n            if (!allowedTypes.includes(file.type) || file.size > maxSize) {\n                alert(\"Lo sentimos, solo se permiten im\u00e1genes en formato JPG, JPEG y PNG menores a 2 MB\");\n                return;\n            }\n\n            if (file && file.type.startsWith('image/')) {\n                const reader = new FileReader();\n\n                reader.onload = function (e) {\n                    $('.custom-image-upload-placeholder-head').hide();\n                    $('.custom-image-upload-placeholder-head-loaded').show();\n                    $('.custom-img-logo').remove();\n                    $('.custom-image-upload-placeholder-loaded').append(`\n                      <img class=\"custom-img-logo\" src=\"${e.target.result}\" alt=\"Vista previa\"/>\n                    `);\n                };\n\n                reader.readAsDataURL(file);\n            } else {\n                alert('Por favor selecciona una imagen v\u00e1lida.');\n            }\n        });\n\n        $('.logo-button-delete').on('click', function () {\n            $('.custom-img-logo').remove();\n        });\n\n        function getColorSettingsJson() {\n            const colorSettings = {\n                principal: $('.color-principal').val(),\n                texto_principal: $('.color-texto-principal').val(),\n                secundario: $('.color-secundario').val(),\n                texto_secundario: $('.color-texto-secundario').val(),\n                fondo: $('.color-fondo').val(),\n                resalto: $('.color-resalto').val()\n            };\n\n            return JSON.stringify(colorSettings);\n        }\n\n        $('.codeInputColor').on('input', function () {\n            const hex = $(this).val().trim();\n\n            // Validar si es un c\u00f3digo hexadecimal v\u00e1lido (como #fff o #ffffff)\n            const isValidHex = /^#([0-9A-Fa-f]{3}){1,2}$/.test(hex);\n\n            if (isValidHex) {\n                const colorCard = $(this).closest('.color-card');\n                const colorPicker = colorCard.find('.color-picker');\n                colorPicker.val(hex);\n                colorPicker.css('background-color', hex);\n            }\n        });\n\n        function getFontsSettingsJson() {\n            const titleFontValue = $('input[name=\"check-font-title\"]:checked').val();\n            const bodyFontValue = $('input[name=\"check-font-body\"]:checked').val();\n\n            const fontsSettings = {\n                title_font: titleFontValue,\n                body_font: bodyFontValue\n            };\n\n            return JSON.stringify(fontsSettings);\n        }\n\n\n        $('.custom-option-save').on('click', function () {\n            const bannerFile = $('#custom-banner-upload')[0].files[0];\n            const bannerImg = $('.custom-img-banner').length;\n\n            if (!bannerFile && !bannerImg) {\n                alert('Debes seleccionar una imagen para el banner antes de guardar.');\n                return;\n            }\n\n            const formData = new FormData();\n            formData.append('menu_id', $('#menu-id').val());\n            formData.append('color_settings', getColorSettingsJson());\n            formData.append('fonts_settings', getFontsSettingsJson());\n\n            const logoFile = $('#custom-logo-upload')[0].files[0];\n\n            if (bannerFile) {\n                formData.append('banner_header', bannerFile);\n            }\n\n            if (logoFile) {\n                formData.append('logo_header', logoFile);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/savecustomization',\n                type: 'POST',\n                data: formData,\n                contentType: false,\n                processData: false,\n                success: function (res) {\n                    if (res.success) {\n                        alert('\u00a1Guardado exitosamente!');\n                    } else {\n                        alert('Error: ' + res.message);\n                    }\n                }\n            });\n        });\n\n        $('.info-text-color, .info-icon-color').on('click', function () {\n            let color_type = $(this).data('color-type');\n            let color_desc = $(this).data('color-desc');\n            let video_url = $('#path_video').val()+\"/\"+$(this).data('video-url');\n            loadVideo(video_url);\n\n            $('.customization-color-badge-text').html(color_type);\n            $('.customization-color-description').html(color_desc);\n            $('.customization-color-modal-overlay').fadeIn();\n        });\n\n        $('.customization-color-modal-overlay').on('click', function (e) {\n            if ($(e.target).is('.customization-color-modal-overlay')) {\n                $(this).fadeOut();\n            }\n        });\n\n        $('.customization-color-title, .customization-color-icon-box').on('click', function (e) {\n            $('.customization-color-modal-overlay').fadeOut();\n        });\n\n        function loadVideo(videoUrl) {\n            const videoHtml = `\n                <video width=\"100%\" height=\"auto\" controls autoplay>\n                    <source src=\"${videoUrl}\" type=\"video/mp4\">\n                    Tu navegador no soporta el video.\n                </video>\n            `;\n            $('.customization-color-preview-box').html(videoHtml);\n        }\n\n\n        /* QR FORM */\n        $('.btn-save-qr').on('click', function (e) {\n            e.preventDefault();\n\n            var formData = new FormData();\n            const menuId = $('#qr-menu-id').val();\n\n            formData.append('menu_id', menuId);\n            formData.append('qr_title', $('input[name=\"qr_title\"]').val());\n            formData.append('qr_description', $('input[name=\"qr_description\"]').val());\n\n            var logoSelected = $('input[name=\"qr_add_logo\"]:checked').val();\n            formData.append('qr_add_logo', logoSelected ? logoSelected : '0');\n\n            var imageInput = $('#upload-image')[0];\n            if (imageInput && imageInput.files.length > 0) {\n                formData.append('qr_image', imageInput.files[0]);\n            }\n\n            $.ajax({\n                url: window.location.origin + '/menudigital/ajax/saveqr',\n                type: 'POST',\n                data: formData,\n                processData: false,\n                contentType: false,\n                showLoader: true,\n                success: function (res) {\n                    if (res.success) {\n                        reloadQrContent(menuId);\n                        alert(res.message || 'QR guardado correctamente.');\n                    } else {\n                        alert(res.message || 'Error al guardar el QR.');\n                    }\n                },\n                error: function () {\n                    alert('Error inesperado al guardar QR.');\n                }\n            });\n        });\n\n        function reloadQrContent(id){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/qr/id/'+id,\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    const tempDiv = $('<div>').html(response);\n                    const newContent = tempDiv.find('.qr-menu-container');\n                    $('.qr-menu-container').replaceWith(newContent);\n                    $('html, body').animate({ scrollTop: 0 }, 'slow');\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar contenido del QR:', error);\n                }\n            });\n        };\n\n        /* PREVIEW */\n\n        let path = [];\n\n        function reloadPreview(){\n            $.ajax({\n                url: window.location.origin + '/menudigital/index/preview',\n                method: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    // Crea un contenedor temporal para poder manipular el DOM recibido\n                    const tempDiv = $('<div>').html(response);\n\n                    // Encuentra el div espec\u00edfico dentro de ese contenido\n                    const newContent = tempDiv.find('.container-preview.container-block');\n\n                    // Reemplaza el contenido en el DOM actual\n                    $('.container-preview.container-block').replaceWith(newContent);\n                    $('.container-preview.container-block').show();\n                    renderCurrentLevel();\n\n                    if (window.location.pathname.includes('/menudigital/index/view')) {\n                        if( $('#is_menu_enable').val() === '0' ){\n                            $('.container-preview').hide();\n                            $('.content-menu-disabled').show();\n                        }\n                    }\n\n                },\n                error: function (xhr, status, error) {\n                    console.error('Error al recargar categor\u00edas:', error);\n                }\n            });\n        };\n\n        $(document).on('click', '.menu-complete-button', function () {\n            renderCurrentLevel();\n            $('#back-button-text').html(`<strong>Men\u00fa Completo</strong>`);\n            $('.menu-complete-button, .preview-recommendations').hide();\n            $('#category-container, #back-button-container').show();\n        });\n\n        $(document).on('click', '.category-button', function () {\n            const key = $(this).data('name');\n            if(key === 'menu_complete'){\n                return;\n            }\n            path.push(key);\n            renderCurrentLevel();\n        });\n\n        $(document).on('click', '#back-button-container', function () {\n            let level = $('#back-button-text').attr('data-level');\n            if(level === 'start'){\n                $('#category-container, #back-button-container').hide();\n                $('.menu-complete-button, .preview-recommendations').show();\n            }\n            path.pop();\n            renderCurrentLevel();\n        });\n\n        function renderCurrentLevel() {\n            let fullTree = JSON.parse($('#getCategoryTree').val());\n            let $container = $('#category-container');\n            $container.empty();\n\n            let branch = fullTree;\n            for (const level of path) {\n                if (branch && typeof branch === 'object') {\n                    branch = branch[level];\n                }\n            }\n\n            const subcategories = [];\n            const products = [];\n\n            if (branch && typeof branch === 'object') {\n                for (const key in branch) {\n                    const value = branch[key];\n\n                    // Si es un producto individual (como \"0\")\n                    if (typeof value === 'object' && value.hasOwnProperty('item_id')) {\n                        products.push(value);\n                    }\n                    // Si es un array de productos\n                    else if (Array.isArray(value) && value.length > 0 && value[0].hasOwnProperty('item_id')) {\n                        // Guardar el nombre del array como subcategor\u00eda\n                        subcategories.push(key);\n                    }\n                    // Si es un objeto que puede contener m\u00e1s subcategor\u00edas o productos\n                    else if (typeof value === 'object') {\n                        subcategories.push(key);\n                    }\n                }\n            }\n\n            // Mostrar subcategor\u00edas primero\n            const titleFont = $('#menu_title_font').val();\n            const bodyFont = $('#menu_body_font').val();\n            const fondoPrincipal = $('#menu_fondo_principal').val();\n            const fondoSecundario = $('#menu_fondo_secundario').val();\n            const textoPrincipal = $('#menu_texto_principal').val();\n            const textoSecundario = $('#menu_texto_secundario').val();\n            const path_media = $('#path_image').val();\n            const resalto = $('#menu_resalto').val();\n            const borderRadius = $('#get_border_radius').val();\n            subcategories.forEach(key => {\n                const $btn = $(`\n                    <div class=\"category-button\" style=\"background:${fondoSecundario}; border-radius: ${borderRadius}\" data-name=\"${key}\"><span style=\"color:${textoSecundario};font-family: '${titleFont}', sans-serif\">${key}</span></div>\n                `);\n                $container.append($btn);\n            });\n\n            // Mostrar productos directamente en este nivel\n            const template = $('#get_template').val();\n            if(template === 'round_style'){\n                $container.css('width','400px');\n                products.forEach(product => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    const badge = product.recommended === '1' ? `<span class=\"list-preview-badge\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif; background: ${resalto}\">Producto Destacado</span>` : '';\n                    const $card = $(`\n                    <div class=\"list-preview-wrapper\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\">\n                        <div class=\"list-preview-container list-preview-container_round_style\" style=\"background:${fondoPrincipal}\">\n                            ${badge}\n                            <img class=\"list-preview-img\" src=\"${path_media+product.image}\" alt=\"${product.name}\" />\n                            <div class=\"list-preview-content\">\n                                <h3 class=\"list-preview-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                                <p class=\"list-preview-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                                <div class=\"list-preview-price\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                            </div>\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }else if(template === 'vertical_round_style'){\n                let groupContainer = null;\n                let badge = '';\n                products.forEach((product, index) => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    // Crear un nuevo grupo cada 2 elementos\n                    if (index % 2 === 0) {\n                        groupContainer = $('<div class=\"vertical_round_style-container\"></div>');\n                        $container.append(groupContainer); // $container es tu contenedor principal\n                    }\n\n\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"vertical_round_style-badge-wrapper\" style=\"background:${resalto}\">\n                                    <div class=\"vertical_round_style-detail-product-badge-icon\">\n                                        <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                            <g id=\"Star\">\n                                                <g id=\"Group\">\n                                                    <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                </g>\n                                            </g>\n                                        </svg>\n                                    </div>\n                                    <div class=\"vertical_round_style-badge\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</div>\n                                </div>`;\n                    }else{\n                        badge = '';\n                    }\n\n                    const $card = $(`\n                        <div class=\"vertical_round_style-card\"\n                                data-name=\"${product.name}\"\n                                data-price=\"${product.price}\"\n                                data-description=\"${shortDescription}\"\n                                data-image=\"${product.image}\"\n                                data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                            <div class=\"vertical_round_style-image\"><img src=\"${path_media+product.image}\" /></div>\n                            ${badge}\n                            <h3 class=\"vertical_round_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                            <p class=\"vertical_round_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                            <div class=\"vertical_round_style-price\" style=\"background: ${fondoSecundario};color:${titleFont};font-family: '${titleFont}', sans-serif\">\n                                ${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN\n                            </div>\n                        </div>\n                    `);\n\n                    groupContainer.append($card);\n                });\n\n            }else if(template === 'straight_style'){\n                products.forEach(product => {\n                    const maxChars = 96;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    let badge = '';\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"straight_style-highlight\">\n                                        <span class=\"straight_style-star\">\n                                            <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                                <g id=\"Star\">\n                                                    <g id=\"Group\">\n                                                        <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                    </g>\n                                                </g>\n                                            </svg>\n                                        </span>\n                                        <span class=\"straight_style-label\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</span>\n                                    </div>`;\n                    }else{\n                        badge = '';\n                    }\n                    const $card = $(`\n                    <div class=\"straight_style-card\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                        <div class=\"straight_style-header\">\n                            <h3 class=\"straight_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n                            <div class=\"straight_style-image-placeholder\">\n                                <img src=\"${path_media+product.image}\" alt=\"${product.name}\">\n                            </div>\n                        </div>\n                        <div class=\"straight_style-body\">\n                            <div class=\"straight_style-info-wrapper\">\n                                <div class=\"straight_style-left\">\n                                    ${badge}\n                                    <div class=\"straight_style-price\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                                </div>\n                                <div class=\"straight_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</div>\n                            </div>\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }else if(template === 'vertical_straight_style'){\n                products.forEach(product => {\n                    const maxChars = 136;\n                    let description = product.description || '';\n                    let shortDescription = description.length > maxChars\n                        ? description.substring(0, maxChars) + ' ...'\n                        : description;\n                    let badge = '';\n                    if(product.recommended === '1'){\n                        badge = `<div class=\"vertical_straight_style-highlight\">\n                                        <span class=\"vertical_straight_style-star\">\n                                            <svg width=\"15\" height=\"16\" viewBox=\"0 0 15 16\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n                                                <g id=\"Star\">\n                                                    <g id=\"Group\">\n                                                        <path id=\"Vector\" d=\"M11.25 14.4817C11.155 14.4817 11.0594 14.4598 10.9707 14.4161L7.50004 12.6804L4.02941 14.4154C3.80191 14.5298 3.52754 14.4936 3.33629 14.3248C3.14504 14.1561 3.07566 13.8886 3.16067 13.6479L4.33754 10.3129L1.49129 8.10044C1.28692 7.94169 1.20192 7.67294 1.27692 7.42481C1.35192 7.17669 1.57254 7.00169 1.83066 6.98294L5.61629 6.71544L6.90941 3.02481C6.99816 2.77481 7.23441 2.60669 7.49941 2.60669H7.50004C7.76504 2.60669 8.00129 2.77356 8.08941 3.02356L9.39254 6.71606L13.1694 6.98356C13.4275 7.00169 13.6482 7.17794 13.7232 7.42544C13.7988 7.67294 13.7132 7.94169 13.5088 8.10106L10.6625 10.3148L11.8394 13.6498C11.9244 13.8904 11.8544 14.1579 11.6638 14.3267C11.5469 14.4286 11.3994 14.4817 11.25 14.4817ZM7.50004 11.3567C7.59566 11.3567 7.69191 11.3786 7.77941 11.4223L10.1457 12.6054L9.33379 10.3048C9.24379 10.0511 9.32691 9.76856 9.53941 9.60294L11.4532 8.11419L8.89504 7.93294C8.64691 7.91544 8.43254 7.75231 8.35004 7.51731L7.50191 5.11419L6.66004 7.51544C6.57754 7.75106 6.36316 7.91481 6.11379 7.93231L3.54629 8.11356L5.46004 9.60169C5.67254 9.76731 5.75566 10.0492 5.66566 10.3036L4.85379 12.6042L7.22004 11.4211C7.30816 11.3786 7.40441 11.3567 7.50004 11.3567Z\" fill=\"${textoPrincipal}\"/>\n                                                    </g>\n                                                </g>\n                                            </svg>\n                                        </span>\n                                        <span class=\"vertical_straight_style-label\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">Producto Destacado</span>\n                                    </div>`;\n                    }else{\n                        badge = '';\n                    }\n                    const $card = $(`\n                    <div class=\"vertical_straight_style-card\"\n                            data-name=\"${product.name}\"\n                            data-price=\"${product.price}\"\n                            data-description=\"${shortDescription}\"\n                            data-image=\"${product.image}\"\n                            data-recommended=\"${product.recommended}\" style=\"background: ${fondoPrincipal}\">\n                        <h3 class=\"vertical_straight_style-title\" style=\"color: ${textoPrincipal};font-family: '${titleFont}', sans-serif\">${product.name}</h3>\n\n                        <div class=\"vertical_straight_style-image-placeholder\">\n                            <img src=\"${path_media+product.image}\" alt=\"${product.name}\">\n                        </div>\n                        <p class=\"vertical_straight_style-description\" style=\"color: ${textoPrincipal};font-family: '${bodyFont}', sans-serif\">${shortDescription}</p>\n                        <div class=\"vertical_straight_style-footer\">\n                            <div class=\"vertical_straight_style-price\" style=\"color:${textoPrincipal};font-family: '${titleFont}', sans-serif\">${parseFloat(product.price).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' })} MXN</div>\n                            ${badge}\n                        </div>\n                    </div>\n                `);\n                    $container.append($card);\n                });\n            }\n\n\n\n            // Mostrar u ocultar bot\u00f3n regresar\n            if (path.length > 0) {\n                const titleFont = $('#menu_title_font').val();\n                const textPrincipal = $('#menu_texto_principal').val();\n                const prevName = path[path.length - 1];\n                if($('.category-button').length === 1){\n                    $container.prepend(`<div class=\"title-last-level\"><span style=\"font-family: '${titleFont}', sans-serif; color: ${textPrincipal}\">${prevName}</span></div>`);\n                }\n                $('#back-button-text').html(`<strong style=\"font-family: '${titleFont}', sans-serif\">${prevName}</strong>`);\n                $('#back-button-container').show();\n                $('#back-button-text').attr('data-level', prevName);\n            } else {\n\n                $('#back-button-text').html(`<strong style=\"font-family: '${titleFont}', sans-serif\">Men\u00fa Completo</strong>`);\n                $('#back-button-text').attr('data-level', 'start');\n            }\n\n            if ($('.category-button:visible').length === 0) {\n                const colorSecundario = $('#menu_fondo_secundario').val();\n                if(template === 'round_style' || template === 'vertical_round_style'){\n                    $('#category-container').css('background',colorSecundario);\n                }else{\n                    $('#category-container').css('background','none');\n                }\n\n            }else{\n                $('#category-container').css('background','none');\n            }\n        }\n\n        $(document).on('click', '.list-preview-wrapper, .vertical_round_style-card, .straight_style-card, .vertical_straight_style-card', function () {\n            const path_image = $('#path_image').val();\n            const name = $(this).data('name');\n            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });\n            const description = $(this).data('description');\n            const image = path_image+$(this).data('image');\n            const recommended = $(this).data('recommended');\n            const tittle_back_link = $('.text-link-back-page strong').html();\n\n            $('.detail-product-title').html(tittle_back_link);\n            $('.detail-product-image').attr('src',image);\n            $('.detail-product-name').html(name);\n            $('.detail-product-description').html(description);\n            $('.detail-product-price').html(price+' MXN');\n            if(recommended === 1){\n                $('.detail-product-badge').show();\n            }\n            $('.detail-product-wrapper').show();\n            $('.preview-header-section, .preview-footer, #category-container').hide();\n            $('.preview-container').css('background','none');\n\n        });\n\n        $(document).on('click', '.detail-product-icons', function () {\n            const $fondo = $('#menu_fondo').val();\n            $('.preview-container').css('background',$fondo);\n            $('.detail-product-badge, .detail-product-wrapper').hide();\n            $('.preview-header-section, .preview-footer, .preview-recommendations').show();\n            const tittle_back_link = $('.detail-product-title').html();\n            if(tittle_back_link != \"Recomendados\"){\n                $('#category-container').show();\n                $('.preview-recommendations').hide();\n            }\n        });\n\n        $(document).on('click', '.preview-products-recommendations', function () {\n            $('.preview-container').css('background','none');\n            const path_image = $('#path_image').val();\n            const name = $(this).data('name');\n            const price = parseFloat($(this).data('price')).toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });\n            const description = $(this).data('description');\n            const image = path_image+$(this).data('image');\n            const recommended = $(this).data('recommended');\n            const tittle_back_link = \"Recomendados\";\n            $('.detail-product-title').html(tittle_back_link);\n            $('.detail-product-image').attr('src',image);\n            $('.detail-product-name').html(name);\n            $('.detail-product-description').html(description);\n            $('.detail-product-price').html(price+' MXN');\n            if(recommended === 1){\n                $('.detail-product-badge').show();\n            }\n            $('.detail-product-wrapper').show();\n            $('.preview-header-section, .preview-footer, #category-container, .preview-recommendations').hide();\n        });\n\n        $(document).on('click', '.preview-footer-copyright', function () {\n            window.location.href = '/';\n        });\n\n        $(document).on('click', '.preview-footer-link', function () {\n            let menuId = $(this).data('link-terms');\n            window.location.href = '/menudigital/index/terminos/id/' + menuId;\n        });\n\n        /* Introduction */\n        $(document).on('click', '.intro-create-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-qr-menu-digital-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-qr-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-qr-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-create-cat-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-cat-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-cat-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-cat-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-cat-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-cat-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-create-articulo-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-create-articulo-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-create-articulo-menu').slideToggle();\n        });\n\n        $(document).on('click', '.intro-edit-articulo-click', function () {\n            const $wrapper = $(this).closest('.customization-wrapper');\n\n            $wrapper.find('.toggle-arrow-edit-articulo-menu').toggleClass('rotated');\n            $wrapper.find('.custom-content-edit-articulo-menu').slideToggle();\n        });\n\n        $(document).on('input', '.validate-price', function () {\n            const $this = $(this);\n            let inputVal = $this.val();\n\n            // Evitar ceros a la izquierda, excepto si el valor empieza con \"0.\" (decimal v\u00e1lido)\n            if (/^0+[1-9]/.test(inputVal)) {\n                inputVal = inputVal.replace(/^0+/, '');\n                $this.val(inputVal);\n            }\n\n            const value = parseFloat(inputVal);\n\n            if (isNaN(value) || value <= 0) {\n                alert(\"El valor del precio debe ser mayor a 0\");\n                $this.val('');\n            }\n        });\n\n\n    });\n});\n","Magento_Shipping/js/view/checkout/shipping/shipping-policy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Shipping/js/model/config'\n\n], function (Component, config) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Shipping/checkout/shipping/shipping-policy'\n        },\n        config: config()\n    });\n});\n","Magento_Shipping/js/model/config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function () {\n        return window.checkoutConfig.shippingPolicy;\n    };\n});\n","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Multishipping/js/multi-shipping-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/dataPost',\n    'jquery-ui-modules/widget'\n], function ($, dataPost) {\n    'use strict';\n\n    $.widget('mage.multiShippingBalance', {\n        options: {\n            changeUrl: ''\n        },\n\n        /**\n         * Initialize balance checkbox events.\n         *\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function (event) {\n                dataPost().postData({\n                    action: this.options.changeUrl,\n                    data: {\n                        useBalance: +$(event.target).is(':checked')\n                    }\n                });\n            }, this));\n        }\n    });\n\n    return $.mage.multiShippingBalance;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice <= this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked\n                        // checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('dd').addClass('no-display').end()\n                .find('.items').hide()\n                .find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent()\n                .next('dd').removeClass('no-display')\n                .find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice <= this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Returns checked payment method.\n         *\n         * @private\n         */\n        _getSelectedPaymentMethod: function () {\n            return this.element.find('input[name=\\'payment[method]\\']:checked');\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            var currentMethod,\n                submitButton;\n\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                currentMethod = this._getSelectedPaymentMethod();\n                submitButton = currentMethod.parent().next('dd').find('button[type=submit]');\n\n                if (submitButton.length) {\n                    submitButton.first().trigger('click');\n                } else {\n                    this.element.trigger('submit');\n                }\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Multishipping/js/multi-shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget'\n], function ($, customerData) {\n    'use strict';\n\n    $.widget('mage.multiShipping', {\n        options: {\n            itemsQty: 0,\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function () {\n            this._prepareCartData();\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Takes cart items qty from current cart data and compare it with current items qty\n         * Reloads cart data if cart items qty is wrong\n         * @private\n         */\n        _prepareCartData: function () {\n            var cartData = customerData.get('cart');\n\n            if (cartData()['summary_count'] !== this.options.itemsQty) {\n                customerData.reload(['cart'], false);\n            }\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function () {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param {Event} event - Click event on the corresponding button.\n         */\n        _canContinue: function (event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n\n    return $.mage.multiShipping;\n});\n","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '.checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function () {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function () {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_LoginAsCustomerFrontendUi/js/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/section-config'\n], function ($, customerData, sectionConfig) {\n\n    'use strict';\n\n    return function (config) {\n        customerData.reload(sectionConfig.getSectionNames()).done(function () {\n            window.location.href = config.redirectUrl;\n        });\n    };\n});\n","Magento_LoginAsCustomerFrontendUi/js/view/loginAsCustomer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, _, Component, customer) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            isVisible: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var customerData, loggedAsCustomerData;\n\n            this._super();\n\n            customerData = customer.get('customer');\n            loggedAsCustomerData = customer.get('loggedAsCustomer');\n\n            customerData.subscribe(function (data) {\n                this.fullname = data.fullname;\n                this.updateBanner();\n            }.bind(this));\n            loggedAsCustomerData.subscribe(function (data) {\n                this.adminUserId = data.adminUserId;\n                this.websiteName = data.websiteName;\n                this.updateBanner();\n            }.bind(this));\n\n            this.fullname = customerData().fullname;\n            this.adminUserId = loggedAsCustomerData().adminUserId;\n            this.websiteName = loggedAsCustomerData().websiteName;\n\n            this.updateBanner();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe(['isVisible', 'notificationText']);\n\n            return this;\n        },\n\n        /**\n         * Update banner area\n         *\n         * @returns void\n         */\n        updateBanner: function () {\n            if (this.adminUserId !== undefined) {\n                this.isVisible(this.adminUserId);\n            }\n\n            if (this.fullname !== undefined && this.websiteName !== undefined) {\n                this.notificationText($.mage.__('You are connected as <strong>%1</strong> on %2')\n                    .replace('%1', _.escape(this.fullname))\n                    .replace('%2', _.escape(this.websiteName)));\n            }\n        }\n    });\n});\n","Threedadv_Hostess/js/reservation-actions.js":"require(['jquery', 'mage/translate'], function ($, $t) {\n    $(document).ready(function () {\n        $(document).on('click', '#slot_time', function () {\n            $(this).attr('step', '900'); // 900 segundos = 15 minutos\n            });\n        // $(document).on('click', '#slot_time', function () {\n        //     let timeValue = $(this).val();\n        //     let [hours, minutes] = timeValue.split(\":\").map(Number);\n        //\n        //     // Redondear minutos a los valores permitidos (00, 15, 30, 45)\n        //     minutes = Math.floor(minutes / 15) * 15;\n        //\n        //     // Asegurar que la hora no pase de 12 y convertir a formato 12 horas\n        //     let period = hours >= 12 ? \"PM\" : \"AM\";\n        //     hours = hours % 12 || 12; // Convertir 0 a 12 para formato 12 horas\n        //\n        //     // Formatear la hora con ceros a la izquierda si es necesario\n        //     let formattedTime = `${String(hours).padStart(2, \"0\")}:${String(minutes).padStart(2, \"0\")}`;\n        //     $(this).val(formattedTime);\n        // });\n        // Obtener par\u00e1metros de la URL\n        var urlParams = new URLSearchParams(window.location.search);\n\n        // Verificar si el par\u00e1metro 'action' tiene el valor 'newReservation'\n        if (urlParams.get('action') === 'newReservation') {\n            var checkExist = setInterval(function () {\n                if ($('#create_reservation').length) {\n                    clearInterval(checkExist); // Detiene el intervalo una vez encontrado\n                    $('#create_reservation').trigger('click');\n                }\n            }, 500); // Revisa cada 500ms si el bot\u00f3n existe\n        }\n\n        $('.filter_button#filter_by_today').addClass('active');\n\n        function convertTo24Hour(timeStr) {\n            // Usar una expresi\u00f3n regular para detectar el formato am/pm\n            var timeFormat = /(\\d{1,2}):(\\d{2}):(\\d{2}) ([apAP][mM])/;\n            var match = timeStr.match(timeFormat);\n\n            if (match) {\n                var hours = parseInt(match[1], 10);\n                var minutes = match[2];\n                var period = match[3].toLowerCase();\n\n                // Convertir a formato 24 horas\n                if (period === 'pm' && hours !== 12) {\n                    hours += 12;  // Agregar 12 horas si es PM\n                } else if (period === 'am' && hours === 12) {\n                    hours = 0;  // 12 AM es igual a 00\n                }\n\n                // Formatear el tiempo a HH:MM:SS\n                return (\"0\" + hours).slice(-2) + \":\" + minutes + \":00\";\n            }\n\n            return \"Formato inv\u00e1lido\";\n        }\n\n        // Obtener la fecha actual en formato \"YYYY-MM-DD\"\n        function getCurrentDate() {\n            const today = new Date();\n            const year = today.getFullYear();\n            const month = String(today.getMonth() + 1).padStart(2, '0');\n            const day = String(today.getDate()).padStart(2, '0');\n            return `${year}-${month}-${day}`;\n        }\n\n        $('.filter_button').on('click', function () {\n            let filterButton = $(this).attr('id');\n            $('.filter_input').each(function () {\n                $(this).val('');\n            });\n            $('.filter_button').removeClass('active'); // Reemplaza 'active' por el nombre de la clase que quieras quitar\n            $('.filter_button#' + filterButton).addClass('active');\n            switch (filterButton) {\n                case \"filter_by_today\":\n                    filterValue = getCurrentDate();\n                    break;\n                case \"filter_by_confirm_status\":\n                    filterValue = \"complete\";\n                    break;\n                case \"filter_by_cancel_status\":\n                    filterValue = \"cancelled\";\n                    break;\n                default:\n                    filterValue = \"\"; // Valor por defecto en caso de que no coincida ning\u00fan caso\n                    break;\n            }\n            let filterButtonKeysAndValues = {\n                key: filterButton,\n                value: filterValue\n            };\n            let filters = {filtros: [filterButtonKeysAndValues]};\n\n            $.ajax({\n                url: '/hostess/index/filter',\n                type: 'POST',\n                data: filters,\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-list').html(response.html);\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        $('.filter_input').on('change', function () {\n            let filters = [];\n            $('.filter_input').each(function () {\n                let filterInput = $(this).attr('id');\n                if ($(this).val().trim() != '') {\n                    let filterInputKeysAndValues = {\n                        key: filterInput,\n                        value: $(this).val().trim()\n                    };\n                    filters.push(filterInputKeysAndValues);\n                }\n            });\n            if (filters.length <= 0) {\n                return;\n            }\n            $.ajax({\n                url: '/hostess/index/filter',\n                type: 'POST',\n                data: {filtros: filters},\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-list').html(response.html);\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        // Capturar clic en el bot\u00f3n Detalles\n        $(document).on('click', '.action.details', function () {\n            var card = $(this).closest('.reservation-card');\n            let customerName = card.find('[name=\"nombre\"] .name-value');\n            let adultVar = card.find('[name=\"adultos\"]');\n            let childVar = card.find('[name=\"ni\u00f1os\"]');\n            let tableType = card.find('[name=\"table-type\"]');\n            let tableIds = card.find('[name=\"table-ids\"]');\n            let timeStr = card.find('[name=\"slot-time\"]').val().trim();\n            let telephone = card.find('[name=\"telephone\"]');\n            let convertedTime = convertTo24Hour(timeStr);\n            let reservationData = {\n                customerFirstname: customerName[0].value,\n                customerLastname: customerName[1].value,\n                orderId: card.find('[name=\"order_id\"]').val(),\n                slotDate: card.find('[name=\"slot-date\"]').val().trim(),\n                slotTime: convertedTime,\n                guestQty: card.find('[name=\"comensales\"] .item-value').text().trim(),\n                guestQtyAdult: adultVar[0].value,\n                guestQtyChildren: childVar[0].value,\n                tableType: tableType[0].value,\n                tableIds: tableIds[0].value,\n                status: card.find('[name=\"status-order\"]').val().trim(),\n                assignedTables: card.find('[name=\"mesa_asignada\"] .item-value').text().trim(),\n                commentReservation: card.find('[name=\"comentarios\"]').val(),\n                requestedTable: card.find('[name=\"table-request-type\"]').val(),\n                requestedArea: card.find('[name=\"table-request-zone\"]').val(),\n                telephone: telephone[0].value\n            };\n\n            // Hacer una llamada AJAX al controlador\n            $.ajax({\n                url: '/hostess/index/edit',\n                type: 'POST',\n                data: reservationData,\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-edit-form-container-form').html(response.html);\n                    let formContainer = document.querySelector('.reservation-edit-form-container-form');\n                    let formElements = formContainer.querySelectorAll('input[type=\"text\"], input[type=\"date\"], input[type=\"time\"], input[type=\"number\"], select, textarea button');\n                    let status = card.find('[name=\"status-order\"]').val().trim();\n                    $('#save_button').addClass('update-reservation');\n                    $('#save_button').removeClass('create-reservation');\n\n                    let currentIncrementId = $('.current-detail-reservation').val();\n                    let getTimeFormatCurrent = $('#get-time-format-'+currentIncrementId).val();\n                    $('#slot_time').val(getTimeFormatCurrent);\n\n                    if (status != 'complete' && status != 'cancelled') {\n                        formElements.forEach(element => {\n                            element.removeAttribute('disabled');\n                            $('button.assign-table').attr('disabled', false);\n                            $('button.assign-table-delete').attr('disabled', false);\n                        });\n                        $('#slot_date').attr('disabled', 'disabled');\n                        $('#slot_time').attr('disabled', 'disabled');\n                        $('#assignment_wait_time').attr('disabled', 'disabled');\n                        $('#consumption_time_remaining').attr('disabled', 'disabled');\n                        $('#assign-table').attr('disabled', false);\n                    } else {\n                        $('button.assign-table').attr('disabled', 'disabled');\n                        $('button.assign-table-delete').attr('disabled', 'disabled');\n                        formElements.forEach(element => {\n                            element.setAttribute('disabled', 'disabled');\n                        });\n                    }\n                },\n                error: function () {\n                    console.log($t('Error loading the form data.')); // Traducido\n                }\n            });\n        });\n\n        // Guardar cambios del formulario\n        $(document).on('click', '#create_reservation', function () {\n\n            $.ajax({\n                url: '/hostess/index/create',\n                type: 'POST',\n                showLoader: true,\n                success: function (response) {\n                    $('.reservation-edit-form-container-form').html(response.html);\n                    $('#save_button').addClass('create-reservation');\n                    $('#save_button').removeClass('update-reservation');\n                    $('#assign-table').attr('disabled', false);\n                },\n                error: function () {\n                    alert($t('Error guetting form.')); // Traducido\n                }\n            });\n        });\n\n        $('#consumption-form-group').hide();\n        $('#assignment-form-group').show();\n        $(document).on('change', '#initial_reservation', function () {\n            if ($(this).is(':checked')) {\n                $('#status').val('confirmed');\n                $('#assignment-form-group').hide();\n                $('#consumption-form-group').show();\n            } else {\n                $('#status').val('pending');\n                $('#consumption-form-group').hide();\n                $('#assignment-form-group').show();\n            }\n        });\n\n\n        $(document).on('click', '.create-reservation', function (e) {\n            e.preventDefault();\n            if (!$('#reservation-method').val()) {\n                $('#reservation-method').addClass('error-select');\n                alert($t('Select Reservation Method Value'));\n                return false;\n            }\n            // Obtener la fecha actual en formato YYYY-MM-DD\n            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds\n            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);\n            let today = localISOTime.split('T')[0];\n            let reservationDate = $('#slot_date').val();\n            let isInitialReservationChecked = $('#initial_reservation').prop('checked');\n\n            // Validar si el checkbox est\u00e1 marcado y la fecha es distinta a hoy\n            if (isInitialReservationChecked && reservationDate !== today) {\n                alert($t('The reservation date must be today for an initial reservation.'));\n                return false; // Detiene la ejecuci\u00f3n\n            }\n            $('#assigment-table-list').val($('.assigment-table-value-table').text());\n            $('#assigment-table-type').val($('.assigment-table-value-type').text());\n            $('#reservation-method').removeClass('error-select');\n            $.ajax({\n                url: '/hostess/index/save',\n                type: 'POST',\n                data: $(\"#reservation-edit-form\").serialize(),\n                showLoader: true,\n                success: function (response) {\n                    if (response.success == true) {\n                        alert($t('Created Order') + response.order_id);\n                        $('#search_filter_by_word').val(response.order_id);\n                        // Esperar 2 segundos y ejecutar la funci\u00f3n de filtrado\n                        $('#search_filter_by_word').trigger('change');\n                            setTimeout(function () {\n                            $('.action.details').trigger('click');\n                            $('#search_filter_by_word').val('');\n                                var urlParams = new URLSearchParams(window.location.search);\n                                // Verificar si el par\u00e1metro 'action' tiene el valor 'newReservation'\n                                if (urlParams.get('action') === 'newReservation') {\n                                    urlParams.delete('action'); // Eliminar el par\u00e1metro de la URL\n                                    // Reconstruir la URL sin el par\u00e1metro y actualizarla\n                                    var newUrl = window.location.pathname + '?' + urlParams.toString();\n                                    window.history.replaceState(null, '', newUrl);\n                                }\n                        }, 2500);\n\n\n                    } else {\n                        if(response.message.substring(29,32) == \"IV-\"){\n                            alert(response.message.substring(32,response.message.length));\n                        } else {\n                            alert($t('Error to create Reservation.')); // Traducido\n                        }\n                    }\n                    return true;\n                },\n                error: function () {\n                    alert($t('Error to create Reservation.')); // Traducido\n                    return true;\n                }\n            });\n        });\n\n        $(document).on('click', '.update-reservation', function (e) {\n            e.preventDefault();\n// Obtener la fecha actual en formato YYYY-MM-DD\n            let tzoffset = (new Date()).getTimezoneOffset() * 60000; //offset in milliseconds\n            let localISOTime = (new Date(Date.now() - tzoffset)).toISOString().slice(0, -1);\n            let today = localISOTime.split('T')[0];\n            let reservationDate = $('#slot_date').val();\n            let status = $('#status').val();\n\n            // Validar si el checkbox est\u00e1 marcado y la fecha es distinta a hoy\n            if (status === 'confirmed' && reservationDate !== today) {\n                alert($t('The reservation date must be today for an initial reservation.'));\n                return false; // Detiene la ejecuci\u00f3n\n            }\n\n            if (status === 'complete' || status === 'cancelled') {\n                $('#assigment-table-list-id').val('');\n            }\n\n            $('#assigment-table-list').val($('.assigment-table-value-table').text());\n            $('#assigment-table-type').val($('.assigment-table-value-type').text());\n\n\n            $.ajax({\n                url: '/hostess/index/save',\n                type: 'POST',\n                data: $(\"#reservation-edit-form\").serialize(),\n                showLoader: true,\n                success: function (response) {\n                    if (response.success == true) {\n                        alert($t('Update Order: ') + response.order_id);\n                        // $('#search_filter_by_word').val(response.order_id);\n                        $('#filter_by_today').trigger('click');\n                        // $('#search_filter_by_word').trigger('change');\n                        // $('#search_filter_by_word').val('');\n\n                    } else {\n                        alert($t('Error to update Reservation.')); // Traducido\n                    }\n                    return true;\n                },\n                error: function () {\n                    alert($t('Error to update Reservation.')); // Traducido\n                    return true;\n                }\n            });\n        });\n\n        const timers = document.querySelectorAll('[data-time-end]');\n        timers.forEach(timer => {\n            const now = new Date();\n            const [hours, minutes, seconds] = timer.getAttribute('data-time-end').split(':').map(Number);\n            // Tiempo total en segundos\n            let totalSeconds = hours * 3600 + minutes * 60 + seconds;\n            const interval = setInterval(() => {\n                if (totalSeconds <= 0) {\n                    timer.textContent = '00:00:00';\n                    timer.classList.remove('status-serving');\n                    timer.classList.add('status-cancelled');\n                    clearInterval(interval);\n                    return;\n                }\n                totalSeconds--;\n                const h = String(Math.floor(totalSeconds / 3600)).padStart(2, '0');\n                const m = String(Math.floor((totalSeconds % 3600) / 60)).padStart(2, '0');\n                const s = String(totalSeconds % 60).padStart(2, '0');\n                timer.textContent = `${h}:${m}:${s}`;\n            }, 1000);\n        });\n    });\n});\n","Magento_InventorySwatchesFrontendUi/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'configurableVariationQty',\n    'jquery-ui-modules/widget'\n], function ($, configurableVariationQty) {\n    'use strict';\n\n    return function (SwatchRenderer) {\n        $.widget('mage.SwatchRenderer', SwatchRenderer, {\n\n            /** @inheritdoc */\n            _OnClick: function ($this, widget) {\n                var salesChannel = this.options.jsonConfig.channel,\n                    salesChannelCode = this.options.jsonConfig.salesChannelCode,\n                    productVariationsSku = this.options.jsonConfig.sku;\n\n                this._super($this, widget);\n                configurableVariationQty(productVariationsSku[widget.getProductId()], salesChannel, salesChannelCode);\n            }\n        });\n\n        return $.mage.SwatchRenderer;\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/view/product-page.js":"define(\n    ['uiComponent'],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n        });\n    }\n);","PayPal_Braintree/js/view/payment/adapter.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'braintreeDataCollector',\n    'braintreeHostedFields',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, client, dataCollector, hostedFields, fullScreenLoader, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n        deviceData: null,\n        clientInstance: null,\n        hostedFieldsInstance: null,\n        paypalInstance: null,\n        code: 'braintree',\n\n        /**\n         * {Object}\n         */\n        events: {\n            onClick: null,\n            onCancel: null,\n            onError: null\n        },\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            return this.clientInstance;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            if (window.checkoutConfig.payment[this.code]) {\n                return this.code;\n            } else {\n                return 'braintree_paypal';\n            }\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        getCurrentCode: function (paypalType = null) {\n            var code = 'braintree_paypal';\n            if (paypalType !== 'paypal') {\n                code = code + '_' + paypalType;\n            }\n            return code;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getColor: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.color;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getShape: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.shape;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSize: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.size;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLabel: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.label;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getBranding: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getFundingIcons: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDisabledFunding: function () {\n            return window.checkoutConfig.payment[this.getCode()].disabledFunding;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Has PayPal been init'd already\n         */\n        getPayPalInstance: function() {\n            if (typeof this.config.paypalInstance !== 'undefined' && this.config.paypalInstance) {\n                return this.config.paypalInstance;\n            }\n\n            return null;\n        },\n\n        setPayPalInstance: function(val) {\n            this.config.paypalInstance = val;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function (callback) {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.clientInstance) {\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError(\"Sorry, but something went wrong. Please contact the store owner.\");\n                }\n\n                var options = {\n                    client: clientInstance\n                };\n\n                if (typeof this.config.dataCollector === 'object' && typeof this.config.dataCollector.paypal === 'boolean') {\n                    options.paypal = true;\n                }\n\n                dataCollector.create(options, function (err, dataCollectorInstance) {\n                    if (err) {\n                        return console.log(err);\n                    }\n\n                    this.deviceData = dataCollectorInstance.deviceData;\n                    this.config.onDeviceDataRecieved(this.deviceData);\n                }.bind(this));\n\n                this.clientInstance = clientInstance;\n\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === \"function\") {\n                    callback(this.clientInstance);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Setup hosted fields instance\n         */\n        setupHostedFields: function () {\n            var self = this;\n\n            if (this.hostedFieldsInstance) {\n                this.hostedFieldsInstance.teardown(function () {\n                    this.hostedFieldsInstance = null;\n                    this.setupHostedFields();\n                }.bind(this));\n                return;\n            }\n\n            hostedFields.create({\n                client: this.clientInstance,\n                fields: this.config.hostedFields,\n                styles: {\n                    \"input\": {\n                        \"font-size\": \"14pt\",\n                        \"color\": \"#3A3A3A\"\n                    },\n                    \":focus\": {\n                        \"color\": \"black\"\n                    },\n                    \".valid\": {\n                        \"color\": \"green\"\n                    },\n                    \".invalid\": {\n                        \"color\": \"red\"\n                    }\n                }\n            }, function (createErr, hostedFieldsInstance) {\n                if (createErr) {\n                    self.showError($t(\"Braintree hosted fields could not be initialized. Please contact the store owner.\"));\n                    console.error('Braintree hosted fields error', createErr);\n                    return;\n                }\n\n                this.config.onInstanceReady(hostedFieldsInstance);\n                this.hostedFieldsInstance = hostedFieldsInstance;\n            }.bind(this));\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({}, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            console.error('All fields are empty! Please fill out the form.');\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            console.error('This payment method already exists in your vault.');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            console.error('CVV did not pass verification');\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            console.error('Network error occurred when tokenizing.');\n                            break;\n                        default:\n                            console.error('Something bad happened!', tokenizeErr);\n                    }\n                } else {\n                    this.config.onPaymentMethodReceived(payload);\n                }\n            }.bind(this));\n        }\n    };\n});\n\n","PayPal_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate',\n    'braintreeThreeDSecure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, braintree, quote, $t, threeDSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * convert Non-ASCII characters into unicode\n         * @param str\n         * @returns {string}\n         */\n        escapeNonAsciiCharacters: function (str) {\n            return str.split(\"\").map(function (c) { return /[^\\x00-\\x7F]$/.test(c) ? c : c.split(\"\").map(function (a) { return \"\\\\u00\" + a.charCodeAt().toString(16)}).join(\"\")}).join(\"\");\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var clientInstance = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2),\n                billingAddress = quote.billingAddress();\n\n            if (billingAddress.regionCode == null) {\n                billingAddress.regionCode = undefined;\n            }\n\n            if (billingAddress.regionCode !== undefined && billingAddress.regionCode.length > 2) {\n                billingAddress.regionCode = undefined;\n            }\n\n            // No 3d secure if using CVV verification on vaulted cards\n            if (quote.paymentMethod().method.indexOf('braintree_cc_vault_') !== -1) {\n                if (this.config.useCvvVault === true) {\n                    state.resolve();\n                    return state.promise();\n                }\n            }\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n                return state.promise();\n            }\n\n            var firstName = this.escapeNonAsciiCharacters(billingAddress.firstname);\n            var lastName = this.escapeNonAsciiCharacters(billingAddress.lastname);\n\n            let challengeRequested = this.getChallengeRequested();\n\n            fullScreenLoader.startLoader();\n\n            var setup3d = function(clientInstance) {\n                threeDSecure.create({\n                    version: 2,\n                    client: clientInstance\n                }, function (threeDSecureErr, threeDSecureInstance) {\n                    if (threeDSecureErr) {\n                        fullScreenLoader.stopLoader();\n                        return state.reject($t('Please try again with another form of payment.'));\n                    }\n\n                    var threeDSContainer = document.createElement('div'),\n                        tdmask = document.createElement('div'),\n                        tdframe = document.createElement('div'),\n                        tdbody = document.createElement('div');\n\n                    threeDSContainer.id = 'braintree-three-d-modal';\n                    tdmask.className =\"bt-mask\";\n                    tdframe.className =\"bt-modal-frame\";\n                    tdbody.className =\"bt-modal-body\";\n\n                    tdframe.appendChild(tdbody);\n                    threeDSContainer.appendChild(tdmask);\n                    threeDSContainer.appendChild(tdframe);\n\n                    threeDSecureInstance.verifyCard({\n                        amount: totalAmount,\n                        nonce: context.paymentMethodNonce,\n                        challengeRequested: challengeRequested,\n                        billingAddress: {\n                            givenName: firstName,\n                            surname: lastName,\n                            phoneNumber: billingAddress.telephone,\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode,\n                            countryCodeAlpha2: billingAddress.countryId\n                        },\n                        onLookupComplete: function (data, next) {\n                            next();\n                        },\n                        addFrame: function (err, iframe) {\n                            fullScreenLoader.stopLoader();\n\n                            if (err) {\n                                console.log(\"Unable to verify card over 3D Secure\", err);\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n\n                            tdbody.appendChild(iframe);\n                            document.body.appendChild(threeDSContainer);\n                        },\n                        removeFrame: function () {\n                            fullScreenLoader.startLoader();\n                            document.body.removeChild(threeDSContainer);\n                        }\n                    }, function (err, response) {\n                        fullScreenLoader.stopLoader();\n\n                        if (err) {\n                            console.error(\"3DSecure validation failed\", err);\n                            if (err.code === 'THREEDS_LOOKUP_VALIDATION_ERROR') {\n                                let errorMessage = err.details.originalError.details.originalError.error.message;\n                                if (errorMessage === 'Billing line1 format is invalid.' && billingAddress.street[0].length > 50) {\n                                    return state.reject(\n                                      $t('Billing line1 must be string and less than 50 characters. Please update the address and try again.')\n                                    );\n\n                                } else if (errorMessage === 'Billing line2 format is invalid.' && billingAddress.street[1].length > 50) {\n                                    return state.reject(\n                                      $t('Billing line2 must be string and less than 50 characters. Please update the address and try again.')\n                                    );\n                                }\n                                return state.reject($t(errorMessage));\n                            } else {\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n                        }\n\n                        var liability = {\n                            shifted: response.liabilityShifted,\n                            shiftPossible: response.liabilityShiftPossible\n                        };\n\n                        if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                            context.paymentMethodNonce = response.nonce;\n                            state.resolve();\n                        } else {\n                            state.reject($t('Please try again with another form of payment.'));\n                        }\n                    });\n                });\n            };\n\n            if (!clientInstance) {\n                require(['PayPal_Braintree/js/view/payment/method-renderer/cc-form'], function(c) {\n                    var config = c.extend({\n                        defaults: {\n                            clientConfig: {\n                                onReady: function() {}\n                            }\n                        }\n                    });\n                    braintree.setConfig(config.defaults.clientConfig);\n                    braintree.setup(setup3d);\n                });\n            } else {\n                setup3d(clientInstance);\n            }\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        getChallengeRequested: function () {\n            return this.config.challengeRequested;\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/venmo.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_venmo',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/lpm.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_local_payment',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/ach.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_ach_direct_debit',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment,\n        braintreeType = 'braintree',\n        payPalType = 'braintree_paypal',\n        braintreeAchDirectDebit = 'braintree_ach_direct_debit',\n        braintreeVenmo = 'braintree_venmo',\n        braintreeLocalPayment = 'braintree_local_payment';\n\n    if (config[braintreeType] && config[braintreeType].isActive && config[braintreeType].clientToken) {\n        rendererList.push({\n            type: braintreeType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields'\n        });\n    }\n\n    if (config[payPalType] && config[payPalType].isActive) {\n        rendererList.push({\n            type: payPalType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/paypal'\n        });\n    }\n\n    if (config[braintreeVenmo] && config[braintreeVenmo].isAllowed && config[braintreeVenmo].clientToken) {\n        rendererList.push({\n            type: braintreeVenmo,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n        });\n    }\n\n    if (config[braintreeAchDirectDebit] && config[braintreeAchDirectDebit].isActive && config[braintreeAchDirectDebit].clientToken) {\n        rendererList.push({\n            type: braintreeAchDirectDebit,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n        });\n    }\n\n    if (config[braintreeLocalPayment] && config[braintreeLocalPayment].clientToken) {\n        rendererList.push({\n            type: braintreeLocalPayment,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n        });\n    }\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","PayPal_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/3d-secure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, globalMessageList, verify3DSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback, errorCallback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    errorCallback();\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, _, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal/vault',\n            additionalData: {}\n        },\n\n        /**\n         * Get PayPal payer email\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Place order\n         */\n        beforePlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                    self.placeOrder();\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        },\n\n        /**\n         * Get payment method data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/venmo.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeVenmo',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        braintree,\n        dataCollector,\n        venmo,\n        formBuilder,\n        messageList,\n        fullScreenLoader,\n        additionalValidators,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/venmo',\n                venmoInstance: null\n            },\n\n            clickVenmoBtn: function () {\n                var self = this;\n\n                if (!additionalValidators.validate()) {\n                    return false;\n                }\n\n                if (!this.venmoInstance) {\n                    this.setErrorMsg($t('Venmo not initialized, please try reloading.'));\n                    return;\n                }\n\n                this.venmoInstance.tokenize(function (tokenizeErr, payload) {\n                    if (tokenizeErr) {\n                        if (tokenizeErr.code === 'VENMO_CANCELED') {\n                            self.setErrorMsg($t('Venmo app is not available or the payment flow was cancelled.'));\n                        } else if (tokenizeErr.code === 'VENMO_APP_CANCELED') {\n                            self.setErrorMsg($t('Venmo payment flow cancelled.'));\n                        } else {\n                            self.setErrorMsg(tokenizeErr.message);\n                        }\n                    } else {\n                        self.handleVenmoSuccess(payload);\n                    }\n                });\n            },\n\n            collectDeviceData: function (clientInstance, callback) {\n                var self = this;\n                dataCollector.create({\n                    client: clientInstance,\n                    paypal: true\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n                    self.deviceData = dataCollectorInstance.deviceData;\n                    callback();\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function() {\n                return 'braintree_venmo';\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'device_data': this.deviceData\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n            },\n\n            getTitle: function() {\n                return 'Venmo';\n            },\n\n            handleVenmoSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    // Collect device data\n                    self.collectDeviceData(clientInstance, function () {\n                        // callback from collectDeviceData\n                        venmo.create({\n                            client: clientInstance,\n                            allowDesktop: true,\n                            allowNewBrowserTab: false\n                        }, function (venmoErr, venmoInstance) {\n                            if (venmoErr) {\n                                self.setErrorMsg($t('Error initializing Venmo: %1').replace('%1', venmoErr));\n                                return;\n                            }\n\n                            if (!venmoInstance.isBrowserSupported()) {\n                                console.log('Browser does not support Venmo');\n                                return;\n                            }\n\n                            self.setVenmoInstance(venmoInstance);\n                        });\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setVenmoInstance: function (instance) {\n                this.venmoInstance = instance;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/lpm.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeLpm',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/url',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        lpm,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        additionalValidators,\n        url,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                code: 'braintree_local_payment',\n                paymentMethodsAvailable: ko.observable(false),\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/lpm'\n            },\n\n            clickPaymentBtn: function (method) {\n                var self = this;\n\n                if (additionalValidators.validate()) {\n                    fullScreenLoader.startLoader();\n\n                    braintree.create({\n                        authorization: self.getClientToken()\n                    }, function (clientError, clientInstance) {\n                        if (clientError) {\n                            self.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                            fullScreenLoader.stopLoader();\n                            return;\n                        }\n\n                        lpm.create({\n                            client: clientInstance,\n                            merchantAccountId: self.getMerchantAccountId()\n                        }, function (lpmError, lpmInstance) {\n                            if (lpmError) {\n                                self.setErrorMsg(lpmError);\n                                fullScreenLoader.stopLoader();\n                                return;\n                            }\n\n                            lpmInstance.startPayment({\n                                amount: self.getAmount(),\n                                currencyCode: self.getCurrencyCode(),\n                                email: self.getCustomerDetails().email,\n                                phone: self.getCustomerDetails().phone,\n                                givenName: self.getCustomerDetails().firstName,\n                                surname: self.getCustomerDetails().lastName,\n                                shippingAddressRequired: !quote.isVirtual(),\n                                address: self.getAddress(),\n                                paymentType: method,\n                                onPaymentStart: function (data, start) {\n                                    start();\n                                },\n                                // This is a required option, however it will apparently never be used in the current payment flow.\n                                // Therefore, both values are set to allow the payment flow to continute, rather than erroring out.\n                                fallback: {\n                                    url: 'N/A',\n                                    buttonText: 'N/A'\n                                }\n                            }, function (startPaymentError, payload) {\n                                fullScreenLoader.stopLoader();\n                                if (startPaymentError) {\n                                    switch (startPaymentError.code) {\n                                        case 'LOCAL_PAYMENT_POPUP_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed unexpectedly.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_OPEN_FAILED':\n                                            self.setErrorMsg($t('Local Payment popup failed to open.'));\n                                            break;\n                                        case 'LOCAL_PAYMENT_WINDOW_CLOSED':\n                                            self.setErrorMsg($t('Local Payment popup was closed. Payment cancelled.'));\n                                            break;\n                                        default:\n                                            self.setErrorMsg('Error! ' + startPaymentError);\n                                            break;\n                                    }\n                                } else {\n                                    // Send the nonce to your server to create a transaction\n                                    self.setPaymentMethodNonce(payload.nonce);\n                                    self.placeOrder();\n                                }\n                            });\n                        });\n                    });\n                }\n            },\n\n            getAddress: function () {\n                var shippingAddress = quote.shippingAddress();\n\n                if (quote.isVirtual()) {\n                    return {\n                        countryCode: shippingAddress.countryId\n                    }\n                }\n\n                return {\n                    streetAddress: shippingAddress.street[0],\n                    extendedAddress: shippingAddress.street[1],\n                    locality: shippingAddress.city,\n                    postalCode: shippingAddress.postcode,\n                    region: shippingAddress.region,\n                    countryCode: shippingAddress.countryId\n                }\n            },\n\n            getAmount: function () {\n                return quote.totals()['base_grand_total'].toString();\n            },\n\n            getBillingAddress: function () {\n                return quote.billingAddress();\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return this.code;\n            },\n\n            getCurrencyCode: function () {\n                return quote.totals()['base_currency_code'];\n            },\n\n            getCustomerDetails: function () {\n                var billingAddress = quote.billingAddress();\n                return {\n                    firstName: billingAddress.firstname,\n                    lastName: billingAddress.lastname,\n                    phone: billingAddress.telephone,\n                    email: typeof quote.guestEmail === 'string' ? quote.guestEmail : window.checkoutConfig.customerData.email\n                }\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getMerchantAccountId: function () {\n                return window.checkoutConfig.payment[this.getCode()].merchantAccountId;\n            },\n\n            getPaymentMethod: function (method) {\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].method === method) {\n                        return methods[i]\n                    }\n                }\n            },\n\n            getPaymentMethods: function () {\n                return window.checkoutConfig.payment[this.getCode()].allowedMethods;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentIcons;\n            },\n\n            getTitle: function () {\n                return window.checkoutConfig.payment[this.getCode()].title;\n            },\n\n            initialize: function () {\n                this._super();\n                return this;\n            },\n\n            isActive: function () {\n                var address = quote.billingAddress() || quote.shippingAddress();\n                var methods = this.getPaymentMethods();\n\n                for (var i = 0; i < methods.length; i++) {\n                    if (methods[i].countries.includes(address.countryId)) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            isValidCountryAndCurrency: function (method) {\n                var address = quote.billingAddress();\n\n                if (!address) {\n                    this.paymentMethodsAvailable(false);\n                    return false;\n                }\n\n                var countryId = address.countryId;\n                var quoteCurrency = quote.totals()['base_currency_code'];\n                var paymentMethodDetails = this.getPaymentMethod(method);\n\n                if ((countryId !== 'GB' && paymentMethodDetails.countries.includes(countryId) && (quoteCurrency === 'EUR' || quoteCurrency === 'PLN')) || (countryId === 'GB' && paymentMethodDetails.countries.includes(countryId) && quoteCurrency === 'GBP')) {\n                    this.paymentMethodsAvailable(true);\n                    return true;\n                }\n\n                return false;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/cc-form',\n    'PayPal_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, additionalValidators, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false,\n            isValidExpirationDate: false,\n            isValidCvvNumber: false,\n\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n                instance.on('cardTypeChange', this.onCardTypeChange.bind(this));\n            }\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            this.clientConfig.hostedFields = this.getHostedFields();\n            this.clientConfig.onInstanceReady = this.onInstanceReady.bind(this);\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationDate: {\n                        selector: self.getSelector('expirationDate'),\n                        placeholder: $t('MM/YYYY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Triggers on Hosted Field changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onValidityChange: function (event) {\n            // Handle a change in validation or card type\n            if (event.emittedBy === 'number') {\n                this.selectedCardType(null);\n\n                if (event.cards.length === 1) {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.selectedCardType(\n                        validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                    );\n                    this.validateCardType();\n                } else {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.validateCardType();\n                }\n            }\n\n            // Other field validations\n            if (event.emittedBy === 'expirationDate') {\n                this.isValidExpirationDate = event.fields.expirationDate.isValid;\n            }\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvvNumber = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * Triggers on Hosted Field card type changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onCardTypeChange: function (event) {\n            if (event.cards.length === 1) {\n                this.selectedCardType(\n                    validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                );\n            } else {\n                this.selectedCardType(null);\n            }\n        },\n\n        /**\n         * Toggle invalid class on selector\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateField: function (selector, state) {\n            var $selector = $(this.getSelector(selector)),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            return this.validateField(\n                'cc_number',\n                (this.isValidCardNumber)\n            );\n        },\n\n        /**\n         * Validate current expiry date\n         * @returns {boolean}\n         */\n        validateExpirationDate: function () {\n            return this.validateField(\n                'expirationDate',\n                (this.isValidExpirationDate === true)\n            );\n        },\n\n        /**\n         * Validate current CVV field\n         * @returns {boolean}\n         */\n        validateCvvNumber: function () {\n            var self = this;\n\n            if (self.hasVerification() === false) {\n                return true;\n            }\n\n            return this.validateField(\n                'cc_cid',\n                (this.isValidCvvNumber === true)\n            );\n        },\n\n        /**\n         * Validate all fields\n         * @returns {boolean}\n         */\n        validateFormFields: function () {\n            return (this.validateCardType() && this.validateExpirationDate() && this.validateCvvNumber()) === true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateFormFields() && additionalValidators.validate()) {\n                this.placeOrder();\n            }\n        },\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/ach.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeAch',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        dataCollector,\n        ach,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/ach',\n                achInstance: null,\n                routingNumber: ko.observable(\"\"),\n                accountNumber: ko.observable(\"\"),\n                accountType: ko.observable(\"checking\"),\n                ownershipType: ko.observable(\"personal\"),\n                firstName: ko.observable(\"\"),\n                lastName: ko.observable(\"\"),\n                businessName: ko.observable(\"\"),\n                hasAuthorization: ko.observable(false),\n                business: ko.observable(false), // for ownership type\n                personal: ko.observable(true) // for ownership type\n            },\n\n            clickAchBtn: function () {\n                if (!this.validateForm('#' + this.getCode() + '-form')) {\n                    return;\n                }\n\n                fullScreenLoader.startLoader();\n\n                var self = this;\n\n                var billingAddress = quote.billingAddress();\n\n                let regionCode;\n\n                let bankDetails = {\n                    routingNumber: self.routingNumber(),\n                    accountNumber: self.accountNumber(),\n                    accountType: self.accountType(),\n                    ownershipType: self.ownershipType(),\n                    billingAddress: {\n                        streetAddress: billingAddress.street[0],\n                        extendedAddress: billingAddress.street[1],\n                        locality: billingAddress.city,\n                        region: billingAddress.regionCode,\n                        postalCode: billingAddress.postcode,\n                    }\n                };\n\n                if (bankDetails.ownershipType === 'personal') {\n                    bankDetails.firstName = self.firstName();\n                    bankDetails.lastName = self.lastName();\n                } else {\n                    bankDetails.businessName = self.businessName();\n                }\n\n                var mandateText = document.getElementById('braintree-ach-mandate').textContent;\n\n                // if no region code is available, lets find one!\n                if (typeof billingAddress.regionCode === 'undefined') {\n                    $.get('/rest/V1/directory/countries/' + billingAddress.countryId).done(function (data) {\n                        if (typeof data.available_regions !== 'undefined') {\n                            for (var i = 0; i < data.available_regions.length; ++i) {\n                                if (data.available_regions[i].id === billingAddress.regionId) {\n                                    regionCode = data.available_regions[i].code;\n                                    bankDetails.billingAddress.region = regionCode;\n                                    self.tokenizeAch(bankDetails, mandateText);\n                                }\n                            }\n                        } else {\n                            fullScreenLoader.stopLoader();\n                            self.tokenizeAch(bankDetails, mandateText);\n                        }\n                    }).fail(function() {\n                        fullScreenLoader.stopLoader();\n                    });\n                } else {\n                    self.tokenizeAch(bankDetails, mandateText);\n                }\n            },\n\n            tokenizeAch: function (bankDetails, mandateText) {\n                var self = this;\n                this.achInstance.tokenize({\n                    bankDetails: bankDetails,\n                    mandateText: mandateText\n                }, function (tokenizeErr, tokenizedPayload) {\n                    if (tokenizeErr) {\n                        self.setErrorMsg($t('There was an error with the provided bank details. Please check and try again.'));\n                        self.hasAuthorization(false);\n                    } else {\n                        fullScreenLoader.stopLoader();\n                        self.handleAchSuccess(tokenizedPayload);\n                    }\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return 'braintree_ach_direct_debit';\n            },\n\n            getStoreName: function () {\n                return window.checkoutConfig.payment[this.getCode()].storeName;\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getTitle: function() {\n                return 'ACH Direct Debit';\n            },\n\n            handleAchSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    ach.create({\n                        client: clientInstance\n                    }, function (achErr, achInstance) {\n                        if (achErr) {\n                            self.setErrorMsg($t('Error initializing ACH: %1').replace('%1', achErr));\n                            return;\n                        }\n\n                        self.setAchInstance(achInstance);\n                    });\n                });\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            changeOwnershipType: function (data, event) {\n                var self = this;\n                if (event.currentTarget.value === 'business') {\n                    self.business(true);\n                    self.personal(false);\n                } else {\n                    self.business(false);\n                    self.personal(true);\n                }\n            },\n\n            isBusiness: function () {\n                return this.business;\n            },\n\n            isPersonal: function () {\n                return this.personal;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setAchInstance: function (instance) {\n                this.achInstance = instance;\n            },\n\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'braintree',\n    'braintreeHostedFields',\n    'mage/url'\n], function (\n    ko,\n    $,\n    VaultComponent,\n    Braintree,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader,\n    client,\n    hostedFields,\n    url\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            hostedFieldsInstance: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            },\n            template: 'PayPal_Braintree/payment/cc/vault',\n            updatePaymentUrl: url.build('braintree/payment/updatepaymentmethod'),\n            vaultedCVV: ko.observable(\"\"),\n            validatorManager: validatorManager,\n            isValidCvv: false,\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n            }\n        },\n\n        /**\n         * Event fired by Braintree SDK whenever input value length matches the validation length.\n         * In the case of a CVV, this is 3, or 4 for AMEX.\n         * @param event\n         */\n        onValidityChange: function (event) {\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvv = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         * @returns {boolean}\n         */\n        isActive: function () {\n            var active = this.getId() === this.isChecked();\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Fired whenever a payment option is changed.\n         * @param isActive\n         */\n        onActiveChange: function (isActive) {\n            var self = this;\n\n            if (!isActive) {\n                return;\n            }\n\n            if (self.showCvvVerify()) {\n                if (self.hostedFieldsInstance) {\n                    self.hostedFieldsInstance.teardown(function (teardownError) {\n                        if (teardownError) {\n                            globalMessageList.addErrorMessage({\n                                message: teardownError.message\n                            });\n                        }\n                        self.hostedFieldsInstance = null;\n                        self.initHostedCvvField();\n                    });\n                    return;\n                }\n                self.initHostedCvvField();\n            }\n        },\n\n        /**\n         * Initialize the CVV input field with the Braintree Hosted Fields SDK.\n         */\n        initHostedCvvField: function () {\n            var self = this;\n            client.create({\n                authorization: Braintree.getClientToken()\n            }, function (clientError, clientInstance) {\n                if (clientError) {\n                    globalMessageList.addErrorMessage({\n                        message: clientError.message\n                    });\n                }\n                hostedFields.create({\n                    client: clientInstance,\n                    fields: {\n                        cvv: {\n                            selector: '#' + self.getId() + '_cid',\n                            placeholder: '123'\n                        }\n                    }\n                }, function (hostedError, hostedFieldsInstance) {\n                    if (hostedError) {\n                        globalMessageList.addErrorMessage({\n                            message: hostedError.message\n                        });\n                        return;\n                    }\n\n                    self.hostedFieldsInstance = hostedFieldsInstance;\n                    self.onInstanceReady(self.hostedFieldsInstance);\n                });\n            });\n        },\n\n        /**\n         * Return the payment method code.\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_cc_vault';\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get show CVV Field\n         * @returns {Boolean}\n         */\n        showCvvVerify: function () {\n            return window.checkoutConfig.payment[this.code].cvvVerify;\n        },\n\n        /**\n         * Show or hide the error message.\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateCvv: function (selector, state) {\n            var $selector = $(selector),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (self.showCvvVerify()) {\n                if (!self.validateCvv('#' + self.getId() + '_cid', self.isValidCvv) || !additionalValidators.validate()) {\n                    return;\n                }\n            } else {\n                if (!additionalValidators.validate()) {\n                    return;\n                }\n            }\n\n            fullScreenLoader.startLoader();\n\n            if (self.showCvvVerify() && typeof self.hostedFieldsInstance !== 'undefined') {\n                self.hostedFieldsInstance.tokenize({}, function (error, payload) {\n                    if (error) {\n                        fullScreenLoader.stopLoader();\n                        globalMessageList.addErrorMessage({\n                            message: error.message\n                        });\n                        return;\n                    }\n                    $.getJSON(\n                        self.updatePaymentUrl,\n                        {\n                            'nonce': payload.nonce,\n                            'public_hash': self.publicHash\n                        }\n                    ).done(function (response) {\n                        if (response.success === false) {\n                            fullScreenLoader.stopLoader();\n                            globalMessageList.addErrorMessage({\n                                message: 'CVV verification failed.'\n                            });\n                            return;\n                        }\n                        self.getPaymentMethodNonce();\n                    })\n                });\n            } else {\n                self.getPaymentMethodNonce();\n            }\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash,\n                'cvv': self.vaultedCVV()\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.hostedFields(function (formComponent) {\n                    formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                    formComponent.additionalData['public_hash'] = self.publicHash;\n                    formComponent.code = self.code;\n                    if (self.vaultedCVV()) {\n                        formComponent.additionalData['cvv'] = self.vaultedCVV();\n                    }\n\n                    self.validatorManager.validate(formComponent, function () {\n                        fullScreenLoader.stopLoader();\n                        return formComponent.placeOrder('parent');\n                    }, function() {\n                        // No teardown actions required.\n                        fullScreenLoader.stopLoader();\n                        formComponent.setPaymentMethodNonce(null);\n                    });\n\n                });\n            }).fail(function (response) {\n                var error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'braintree',\n    'braintreeCheckoutPayPalAdapter',\n    'braintreePayPalCheckout',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_CheckoutAgreements/js/view/checkout-agreements',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    braintree,\n    Braintree,\n    paypalCheckout,\n    quote,\n    fullScreenLoader,\n    additionalValidators,\n    stepNavigator,\n    VaultEnabler,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutAgreements,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paypalInstance: null,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * {Array}\n             */\n            lineItemsArray: [\n                'name',\n                'kind',\n                'quantity',\n                'unitAmount',\n                'unitTaxAmount',\n                'productCode',\n                'description'\n            ],\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n                offerCredit: false,\n                offerCreditOnly: false,\n                dataCollector: {\n                    paypal: true\n                },\n\n                buttonPayPalId: 'braintree_paypal_placeholder',\n                buttonCreditId: 'braintree_paypal_credit_placeholder',\n                buttonPaylaterId: 'braintree_paypal_paylater_placeholder',\n\n                onDeviceDataRecieved: function (deviceData) {\n                    this.additionalData['device_data'] = deviceData;\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} context\n                 */\n                onReady: function (context) {\n                    this.setupPayPal();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            window.addEventListener('hashchange', function (e) {\n                var methodCode = quote.paymentMethod();\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    if (e.newURL.indexOf('payment') > 0 && self.grandTotalAmount !== null) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            quote.paymentMethod.subscribe(function (value) {\n                var methodCode = value;\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    self.reInitPayPal();\n                }\n            });\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n            this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                self.onVaultPaymentTokenEnablerChange();\n            });\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    var methodCode = quote.paymentMethod();\n\n                    if (methodCode && (methodCode.method === 'braintree_paypal' || methodCode.method === 'braintree_paypal_vault')) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            // for each component initialization need update property\n            this.isReviewRequired(false);\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.line1],\n                city: address.city,\n                postcode: address.postalCode,\n                countryId: address.countryCode,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: typeof customer.phone !== 'undefined' ? customer.phone : '00000000000'\n            };\n\n            billingAddress['region_code'] = typeof address.state === 'string' ? address.state : '';\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n            this.customerEmail(data.details.email);\n            if (quote.isVirtual()) {\n                this.isReviewRequired(true);\n            } else {\n                if (this.isRequiredBillingAddress() === '1' || quote.billingAddress() === null) {\n                    if (typeof data.details.billingAddress !== 'undefined') {\n                        this.setBillingAddress(data.details, data.details.billingAddress);\n                    } else {\n                        this.setBillingAddress(data.details, data.details.shippingAddress);\n                    }\n                } else {\n                    if (quote.shippingAddress() === quote.billingAddress()) {\n                        selectBillingAddress(quote.shippingAddress());\n                    } else {\n                        selectBillingAddress(quote.billingAddress());\n                    }\n                }\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = true;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n                this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n            // Send Line Items\n            this.clientConfig.paypal.lineItems = this.getLineItems();\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Setup PayPal instance\n         */\n        setupPayPal: function () {\n            var self = this;\n\n            if (Braintree.config.paypalInstance) {\n                fullScreenLoader.stopLoader(true);\n                return;\n            }\n\n            paypalCheckout.create({\n                client: Braintree.clientInstance\n            }, function (createErr, paypalCheckoutInstance) {\n                if (createErr) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    console.error('paypalCheckout error', createErr);\n                    return;\n                }\n                let quoteObj = quote.totals();\n\n                var configSDK = {\n                    components: 'buttons,messages,funding-eligibility',\n                    \"enable-funding\": \"paylater\",\n                    currency: quoteObj['base_currency_code']\n                };\n                var merchantCountry = window.checkoutConfig.payment['braintree_paypal'].merchantCountry;\n                if (Braintree.getEnvironment() == 'sandbox' && merchantCountry != null) {\n                    configSDK[\"buyer-country\"] = merchantCountry;\n                }\n                paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                    this.loadPayPalButton(paypalCheckoutInstance, 'paypal');\n                    if (this.isCreditEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'credit');\n                    }\n                    if (this.isPaylaterEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'paylater');\n                    }\n\n                }.bind(this));\n            }.bind(this));\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            var paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived;\n            var style = {\n                color: Braintree.getColor(funding),\n                shape: Braintree.getShape(funding),\n                size: Braintree.getSize(funding),\n                label: Braintree.getLabel(funding)\n            };\n\n            if (Braintree.getBranding()) {\n                style.branding = Braintree.getBranding();\n            }\n            if (Braintree.getFundingIcons()) {\n                style.fundingicons = Braintree.getFundingIcons();\n            }\n\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.clientConfig.buttonCreditId;\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.clientConfig.buttonPaylaterId;\n            } else {\n                Braintree.config.buttonId = this.clientConfig.buttonPayPalId;\n            }\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n            var events = Braintree.events;\n            $('#' + Braintree.config.buttonId).html('');\n\n            var button = paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                onInit: function (data, actions) {\n                    var agreements = checkoutAgreements().agreements,\n                        shouldDisableActions = false;\n\n                    actions.disable();\n\n                    _.each(agreements, function (item, index) {\n                        if (checkoutAgreements().isAgreementRequired(item)) {\n                            var paymentMethodCode = quote.paymentMethod().method,\n                                inputId = '#agreement_' + paymentMethodCode + '_' + item.agreementId,\n                                inputEl = document.querySelector(inputId);\n\n\n                            if (!inputEl.checked) {\n                                shouldDisableActions = true;\n                            }\n\n                            inputEl.addEventListener('change', function (event) {\n                                if (additionalValidators.validate()) {\n                                    actions.enable();\n                                } else {\n                                    actions.disable();\n                                }\n                            });\n                        }\n                    });\n\n                    if (!shouldDisableActions) {\n                        actions.enable();\n                    }\n                },\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment).catch(function (err) {\n                        throw err.details.originalError.details.originalError.paymentResource;\n                    });\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    if (err.errorName === 'VALIDATION_ERROR' && err.errorMessage.indexOf('Value is invalid') !== -1) {\n                        Braintree.showError($t('Address failed validation. Please check and confirm your City, State, and Postal Code'));\n                    } else {\n                        Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    }\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function (data) {\n                    if (!quote.isVirtual()) {\n                        this.clientConfig.paypal.enableShippingAddress = true;\n                        this.clientConfig.paypal.shippingAddressEditable = false;\n                        this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n                    }\n\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data, actions) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n            if (button.isEligible() && $('#' + Braintree.config.buttonId).length) {\n                button.render('#' + Braintree.config.buttonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is Billing Address required from PayPal side\n         * @returns {exports.isRequiredBillingAddress|(function())|boolean}\n         */\n        isRequiredBillingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isRequiredBillingAddress;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (isActiveVaultEnabler) {\n                config.paypal.requestBillingAgreement = true;\n            }\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = true;\n                config.paypal.shippingAddressEditable = false;\n                config.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                line1: address.street[0],\n                line2: typeof address.street[2] === 'undefined' ? address.street[1] : address.street[1] + ' ' + address.street[2],\n                city: address.city,\n                countryCode: address.countryId,\n                postalCode: address.postcode,\n                state: address.regionCode\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        },\n\n        /**\n         * Check if need to skip order review\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return window.checkoutConfig.payment[this.getCode()].skipOrderReview;\n        },\n\n        /**\n         * Checks if vault is active\n         * @returns {Boolean}\n         */\n        isActiveVault: function () {\n            return this.vaultEnabler.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * Re-init PayPal Auth flow to use Vault\n         */\n        onVaultPaymentTokenEnablerChange: function () {\n            this.clientConfig.paypal.singleUse = !this.isActiveVault();\n            this.reInitPayPal();\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPayPalButtonId: function () {\n            return this.clientConfig.buttonPayPalId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getCreditButtonId: function () {\n            return this.clientConfig.buttonCreditId;\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getPaylaterButtonId: function () {\n            return this.clientConfig.buttonPaylaterId;\n        },\n\n        isPaylaterEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isActive'];\n        },\n\n        isPaylaterMessageEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isMessageActive'];\n        },\n\n        getGrandTotalAmount: function () {\n            return parseFloat(this.grandTotalAmount).toFixed(2);\n        },\n\n        isCreditEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_credit']['isActive'];\n        },\n\n        /**\n         * Get Message Layout\n         * @returns {*}\n         */\n        getMessagingLayout: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['layout'];\n        },\n\n        /**\n         * Get Message Logo\n         * @returns {*}\n         */\n        getMessagingLogo: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo'];\n        },\n\n        /**\n         * Get Message Logo position\n         * @returns {*}\n         */\n        getMessagingLogoPosition: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo_position'];\n        },\n\n        /**\n         * Get Message Text Color\n         * @returns {*}\n         */\n        getMessagingTextColor: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['text_color'];\n        },\n\n        /**\n         * Get line items\n         * @returns {Array}\n         */\n        getLineItems: function () {\n            let self = this;\n            let lineItems = [], storeCredit = 0, giftCardAccount = 0;\n            let giftWrappingItems = 0, giftWrappingOrder = 0;\n            $.each(quote.totals()['total_segments'], function(segmentsKey, segmentsItem) {\n                if (segmentsItem['code'] === 'customerbalance') {\n                    storeCredit = parseFloat(Math.abs(segmentsItem['value']).toString()).toFixed(2);\n                }\n                if (segmentsItem['code'] === 'giftcardaccount') {\n                    giftCardAccount = parseFloat(Math.abs(segmentsItem['value']).toString()).toFixed(2);\n                }\n                if (segmentsItem['code'] === 'giftwrapping') {\n                    let extensionAttributes = segmentsItem['extension_attributes'];\n                    giftWrappingOrder = extensionAttributes['gw_base_price'];\n                    giftWrappingItems = extensionAttributes['gw_items_base_price'];\n                }\n            });\n            if (this.canSendLineItems()) {\n                $.each(quote.getItems(), function(quoteItemKey, quoteItem) {\n                    if (quoteItem.parent_item_id !== null || 0.0 === quoteItem.price) {\n                        return true;\n                    }\n\n                    let itemName = self.replaceUnsupportedCharacters(quoteItem.name);\n                    let itemSku = self.replaceUnsupportedCharacters(quoteItem.sku);\n\n                    let description = '';\n                    let itemQty = parseFloat(quoteItem.qty);\n                    let itemUnitAmount = parseFloat(quoteItem.price);\n                    if (itemQty > Math.floor(itemQty) && itemQty < Math.ceil(itemQty)) {\n                        description = 'Item quantity is ' + itemQty.toFixed(2) + ' and per unit amount is ' + itemUnitAmount.toFixed(2);\n                        itemUnitAmount = parseFloat(itemQty * itemUnitAmount);\n                        itemQty = parseFloat('1');\n                    }\n\n                    let lineItemValues = [\n                        itemName,\n                        'debit',\n                        itemQty.toFixed(2),\n                        itemUnitAmount.toFixed(2),\n                        parseFloat(quoteItem.base_tax_amount).toFixed(2),\n                        itemSku,\n                        description\n                    ];\n\n                    let mappedLineItems = $.map(self.lineItemsArray, function(itemElement, itemIndex) {\n                        return [[\n                            self.lineItemsArray[itemIndex],\n                            lineItemValues[itemIndex]\n                        ]]\n                    });\n\n                    lineItems[quoteItemKey] = Object.fromEntries(mappedLineItems);\n                });\n\n                /**\n                 * Adds credit (refund or discount) kind as LineItems for the\n                 * PayPal transaction if discount amount is greater than 0(Zero)\n                 * as discountAmount lineItem field is not being used by PayPal.\n                 *\n                 * https://developer.paypal.com/braintree/docs/reference/response/transaction-line-item/php#discount_amount\n                 */\n                let baseDiscountAmount = parseFloat(Math.abs(quote.totals()['base_discount_amount']).toString()).toFixed(2);\n                if (baseDiscountAmount > 0) {\n                    let discountLineItem = {\n                        'name': 'Discount',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': baseDiscountAmount\n                    };\n\n                    lineItems = $.merge(lineItems, [discountLineItem]);\n                }\n\n                /**\n                 * Adds shipping as LineItems for the PayPal transaction\n                 * if shipping amount is greater than 0(Zero) to manage\n                 * the totals with client-side implementation as there is\n                 * no any field exist in the client-side implementation\n                 * to send the shipping amount to the Braintree.\n                 */\n                if (quote.totals()['base_shipping_amount'] > 0) {\n                    let shippingLineItem = {\n                        'name': 'Shipping',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': quote.totals()['base_shipping_amount']\n                    };\n\n                    lineItems = $.merge(lineItems, [shippingLineItem]);\n                }\n\n                /**\n                 * Adds credit (Store Credit) kind as LineItems for the\n                 * PayPal transaction if store credit is greater than 0(Zero)\n                 * to manage the totals with client-side implementation\n                 */\n                if (storeCredit > 0) {\n                    let storeCreditItem = {\n                        'name': 'Store Credit',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': storeCredit\n                    };\n\n                    lineItems = $.merge(lineItems, [storeCreditItem]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for items as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingItems > 0) {\n                    let gwItems = {\n                        'name': 'Gift Wrapping for Items',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingItems\n                    };\n\n                    lineItems = $.merge(lineItems, [gwItems]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for order as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingOrder > 0) {\n                    let gwOrderItem = {\n                        'name': 'Gift Wrapping for Order',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingOrder\n                    };\n\n                    lineItems = $.merge(lineItems, [gwOrderItem]);\n                }\n\n                /**\n                 * Adds Gift Cards as credit LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftCardAccount > 0) {\n                    let giftCardItem = {\n                        'name': 'Gift Cards',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': giftCardAccount\n                    };\n\n                    lineItems = $.merge(lineItems, [giftCardItem]);\n                }\n\n                if (lineItems.length >= 250) {\n                    lineItems = [];\n                }\n            }\n            return lineItems;\n        },\n\n        /**\n         * Regex to replace all unsupported characters.\n         *\n         * @param str\n         */\n        replaceUnsupportedCharacters: function (str) {\n            str.replace('/[^a-zA-Z0-9\\s\\-.\\']/', '');\n            return str.substr(0, 127);\n        },\n\n        /**\n         * Can send line items\n         *\n         * @returns {Boolean}\n         */\n        canSendLineItems: function () {\n            return window.checkoutConfig.payment[this.getCode()].canSendLineItems;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'PayPal_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'PayPal_Braintree/js/validator',\n        'PayPal_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n                isProcessing: false,\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n                    onReady: function (context) {\n                        context.setupHostedFields();\n                    },\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.handleNonce(response);\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Allow a new nonce to be generated\n                     */\n                    onPaymentMethodError: function() {\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Device data initialization\n                     * @param {String} deviceData\n                     */\n                    onDeviceDataRecieved: function (deviceData) {\n                        this.additionalData['device_data'] = deviceData;\n                    },\n\n                    /**\n                     * After Braintree instance initialization\n                     */\n                    onInstanceReady: function () {},\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        this.isProcessing = false;\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                        this.isProcessing = false;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader(true);\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                    return validator.collectTypes(\n                        availableTypes,\n                        validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'g-recaptcha-response' : $(\"#token-grecaptcha-braintree\").val()\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            handleNonce: function (data) {\n                var self = this;\n\n                this.setPaymentMethodNonce(data.nonce);\n\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                }, function() {\n                    self.isProcessing = false;\n                    self.paymentMethodNonce = null;\n                });\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                if (key) {\n                    return this._super();\n                }\n\n                if (this.isProcessing) {\n                    return false;\n                } else {\n                    this.isProcessing = true;\n                }\n\n                braintree.tokenizeHostedFields();\n                return false;\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.braintree.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.braintree.icons[type]\n                    : false;\n            },\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields',\n    'PayPal_Braintree/js/validator',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'PayPal_Braintree/js/view/payment/adapter'\n], function (\n    $,\n    Component,\n    validator,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    braintree\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/form'\n        },\n\n        /**\n         * Get list of available CC types\n         *\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            var availableTypes = validator.getAvailableCardTypes(),\n                billingCountryId;\n\n            billingCountryId = $('#multishipping_billing_country_id').val();\n\n            if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                return validator.collectTypes(\n                    availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                );\n            }\n\n            return availableTypes;\n        },\n\n        /**\n         * @override\n         */\n        handleNonce: function (data) {\n            var self = this;\n            this.setPaymentMethodNonce(data.nonce);\n\n            // place order on success validation\n            self.validatorManager.validate(self, function () {\n                return self.setPaymentInformation();\n            }, function() {\n                self.isProcessing = false;\n                self.paymentMethodNonce = null;\n            });\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.isProcessing) {\n                return false;\n            } else {\n                this.isProcessing = true;\n            }\n\n            braintree.tokenizeHostedFields();\n            return false;\n        },\n\n        /**\n         * @override\n         */\n        setPaymentInformation: function () {\n            if (additionalValidators.validate()) {\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'braintreeCheckoutPayPalAdapter',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/view/payment/method-renderer/paypal',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Braintree,\n    quote,\n    Component,\n    setPaymentInformationAction,\n    additionalValidators,\n    fullScreenLoader,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/paypal',\n            submitButtonSelector: '[id=\"parent-payment-continue\"]',\n            reviewButtonHtml: ''\n        },\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            this.reviewButtonHtml = $(this.submitButtonSelector).html();\n            return this._super();\n        },\n\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n            this.clientConfig.paypal.enableShippingAddress = false;\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n            this.clientConfig.buttonPayPalId = 'parent-payment-continue';\n\n        },\n\n        /**\n         * @override\n         */\n        onActiveChange: function (isActive) {\n            this.updateSubmitButtonHtml(isActive);\n            this._super(isActive);\n        },\n\n        /**\n         * @override\n         */\n        beforePlaceOrder: function (data) {\n            this._super(data);\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = parseFloat(this.grandTotalAmount).toFixed(2);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = false;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n            }\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                }.bind(this));\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            let paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived;\n            let style = {\n                color: Braintree.getColor(funding),\n                shape: Braintree.getShape(funding),\n                size: Braintree.getSize(funding),\n                label: Braintree.getLabel(funding)\n            };\n\n            if (Braintree.getBranding()) {\n                style.branding = Braintree.getBranding();\n            }\n            if (Braintree.getFundingIcons()) {\n                style.fundingicons = Braintree.getFundingIcons();\n            }\n\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.clientConfig.buttonCreditId;\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.clientConfig.buttonPaylaterId;\n            } else {\n                Braintree.config.buttonId = this.clientConfig.buttonPayPalId;\n            }\n\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n            var events = Braintree.events;\n            $('#' + Braintree.config.buttonId).html('');\n\n            var button = paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment);\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    Braintree.showError($t(\"PayPal Checkout could not be initialized. Please contact the store owner.\"));\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function (data) {\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data, actions) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n            if (button.isEligible() && $('#' + Braintree.config.buttonId).length) {\n\n                button.render('#' + Braintree.config.buttonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: parseFloat(this.grandTotalAmount).toFixed(2),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                requestBillingAgreement: true,\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = false;\n                config.paypal.shippingAddressEditable = false;\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        getShippingAddress: function () {\n\n            return {};\n        },\n\n        /**\n         * @override\n         */\n        getData: function () {\n            var data = this._super();\n\n            data['additional_data']['is_active_payment_token_enabler'] = true;\n\n            return data;\n        },\n\n        /**\n         * @override\n         */\n        isActiveVault: function () {\n            return true;\n        },\n\n        /**\n         * Skipping order review step on checkout with multiple addresses is not allowed.\n         *\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return false;\n        },\n\n        /**\n         * Checks if payment method nonce is already received.\n         *\n         * @returns {Boolean}\n         */\n        isPaymentMethodNonceReceived: function () {\n            return this.paymentMethodNonce !== null;\n        },\n\n        /**\n         * Update submit button on multi-addresses checkout billing form.\n         *\n         * @param {Boolean} isActive\n         */\n        updateSubmitButtonHtml: function (isActive) {\n            $(this.submitButtonSelector).removeClass(\"primary\");\n            if (this.isPaymentMethodNonceReceived() || !isActive) {\n                $(this.submitButtonSelector).addClass(\"primary\");\n                $(this.submitButtonSelector).html(this.reviewButtonHtml);\n            }\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (!this.isPaymentMethodNonceReceived()) {\n                this.payWithPayPal();\n            } else {\n                fullScreenLoader.startLoader();\n\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').submit();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/applepay/api.js":"/**\n * Braintree Apple Pay button API\n *\n **/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'uiComponent',\n        'mage/translate',\n        'mage/storage',\n        'Magento_Customer/js/customer-data'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        $t,\n        storage,\n        customerData\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\",\n                shippingAddress: {},\n                countryDirectory: null,\n                shippingMethods: {}\n            },\n\n            initialize: function () {\n                this._super();\n                if (!this.countryDirectory) {\n                    storage.get(\"rest/V1/directory/countries\").done(function (result) {\n                        this.countryDirectory = {};\n                        let i, data, x, region;\n                        for (i = 0; i < result.length; ++i) {\n                            data = result[i];\n                            this.countryDirectory[data.two_letter_abbreviation] = {};\n                            if (typeof data.available_regions !== 'undefined') {\n                                for (x = 0; x < data.available_regions.length; ++x) {\n                                    region = data.available_regions[x];\n                                    this.countryDirectory[data.two_letter_abbreviation][region.name.toLowerCase().replace(/[^A-Z0-9]/ig, '')] = region.id;\n                                }\n                            }\n                        }\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get region ID\n             */\n            getRegionId: function (countryCode, regionName) {\n                if (typeof regionName !== 'string') {\n                    return null;\n                }\n\n                regionName = regionName.toLowerCase().replace(/[^A-Z0-9]/ig, '');\n\n                if (typeof this.countryDirectory[countryCode] !== 'undefined' && typeof this.countryDirectory[countryCode][regionName] !== 'undefined') {\n                    return this.countryDirectory[countryCode][regionName];\n                }\n\n                return 0;\n            },\n\n            /**\n             * Set & get api token\n             */\n            setClientToken: function (value) {\n                this.clientToken = value;\n            },\n            getClientToken: function () {\n                return this.clientToken;\n            },\n\n            /**\n             * Set and get quote id\n             */\n            setQuoteId: function (value) {\n                this.quoteId = value;\n            },\n            getQuoteId: function () {\n                return this.quoteId;\n            },\n\n            /**\n             * Set and get display name\n             */\n            setDisplayName: function (value) {\n                this.displayName = value;\n            },\n            getDisplayName: function () {\n                return this.displayName;\n            },\n\n            /**\n             * Set and get success redirection url\n             */\n            setActionSuccess: function (value) {\n                this.actionSuccess = value;\n            },\n            getActionSuccess: function () {\n                return this.actionSuccess;\n            },\n\n            /**\n             * Set and get grand total\n             */\n            setGrandTotalAmount: function (value) {\n                this.grandTotalAmount = parseFloat(value).toFixed(2);\n            },\n            getGrandTotalAmount: function () {\n                return parseFloat(this.grandTotalAmount);\n            },\n\n            /**\n             * Set and get is logged in\n             */\n            setIsLoggedIn: function (value) {\n                this.isLoggedIn = value;\n            },\n            getIsLoggedIn: function () {\n                return this.isLoggedIn;\n            },\n\n            /**\n             * Set and get store code\n             */\n            setStoreCode: function (value) {\n                this.storeCode = value;\n            },\n            getStoreCode: function () {\n                return this.storeCode;\n            },\n\n            /**\n             * API Urls for logged in / guest\n             */\n            getApiUrl: function (uri) {\n                if (this.getIsLoggedIn() === true) {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/carts/mine/\" + uri;\n                } else {\n                    return \"rest/\" + this.getStoreCode() + \"/V1/guest-carts/\" + this.getQuoteId() + \"/\" + uri;\n                }\n            },\n\n            /**\n             * Payment request info\n             */\n            getPaymentRequest: function () {\n                return {\n                    total: {\n                        label: this.getDisplayName(),\n                        amount: this.getGrandTotalAmount()\n                    },\n                    requiredShippingContactFields: ['postalAddress', 'name', 'email', 'phone'],\n                    requiredBillingContactFields: ['postalAddress', 'name']\n                };\n            },\n\n            /**\n             * Retrieve shipping methods based on address\n             */\n            onShippingContactSelect: function (event, session) {\n                // Get the address.\n                let address = event.shippingContact;\n\n                // Create a payload.\n                let payload = {\n                    address: {\n                        city: address.locality,\n                        region: address.administrativeArea,\n                        country_id: address.countryCode.toUpperCase(),\n                        postcode: address.postalCode,\n                        save_in_address_book: 0\n                    }\n                };\n\n                this.shippingAddress = payload.address;\n\n                // POST to endpoint for shipping methods.\n                storage.post(\n                    this.getApiUrl(\"estimate-shipping-methods\"),\n                    JSON.stringify(payload)\n                ).done(function (result) {\n                    // Stop if no shipping methods.\n                    let virtualFlag = false;\n                    if (result.length === 0) {\n                        let productItems = customerData.get('cart')().items;\n                        _.each(productItems,\n                            function (item) {\n                                if (item.is_virtual || item.product_type == 'bundle') {\n                                    virtualFlag = true;\n                                } else {\n                                    virtualFlag = false;\n                                }\n                            }\n                        );\n                        if (!virtualFlag) {\n                            session.abort();\n                            alert($t(\"There are no shipping methods available for you right now. Please try again or use an alternative payment method.\"));\n                            return false;\n                        }\n                    }\n\n                    let shippingMethods = [];\n                    this.shippingMethods = {};\n\n                    // Format shipping methods array.\n                    for (let i = 0; i < result.length; i++) {\n                        if (typeof result[i].method_code !== 'string') {\n                            continue;\n                        }\n\n                        let method = {\n                            identifier: result[i].method_code,\n                            label: result[i].method_title,\n                            detail: result[i].carrier_title ? result[i].carrier_title : \"\",\n                            amount: parseFloat(result[i].amount).toFixed(2)\n                        };\n\n                        // Add method object to array.\n                        shippingMethods.push(method);\n\n                        this.shippingMethods[result[i].method_code] = result[i];\n\n                        if (!this.shippingMethod) {\n                            this.shippingMethod = result[i].method_code;\n                        }\n                    }\n\n                    // Create payload to get totals\n                    let totalsPayload = {\n                        \"addressInformation\": {\n                            \"address\": {\n                                \"countryId\": this.shippingAddress.country_id,\n                                \"region\": this.shippingAddress.region,\n                                \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                                \"postcode\": this.shippingAddress.postcode\n                            },\n                            \"shipping_method_code\": virtualFlag ? null : this.shippingMethods[shippingMethods[0].identifier].method_code,\n                            \"shipping_carrier_code\": virtualFlag ? null : this.shippingMethods[shippingMethods[0].identifier].carrier_code\n                        }\n                    };\n\n                    // POST to endpoint to get totals, using 1st shipping method\n                    storage.post(\n                        this.getApiUrl(\"totals-information\"),\n                        JSON.stringify(totalsPayload)\n                    ).done(function (result) {\n                        // Set total\n                        this.setGrandTotalAmount(result.base_grand_total);\n\n                        // Pass shipping methods back\n                        session.completeShippingContactSelection(\n                            ApplePaySession.STATUS_SUCCESS,\n                            shippingMethods,\n                            {\n                                label: this.getDisplayName(),\n                                amount: this.getGrandTotalAmount()\n                            },\n                            [{\n                                type: 'final',\n                                label: $t('Shipping'),\n                                amount: virtualFlag ? 0 : shippingMethods[0].amount\n                            }]\n                        );\n                    }.bind(this)).fail(function (result) {\n                        session.abort();\n                        alert($t(\"We're unable to fetch the cart totals for you. Please try an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay: Unable to get totals\", result);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (result) {\n                    session.abort();\n                    alert($t(\"We're unable to find any shipping methods for you. Please try an alternative payment method.\"));\n                    console.error(\"Braintree ApplePay: Unable to find shipping methods for estimate-shipping-methods\", result);\n                    return false;\n                });\n            },\n\n            /**\n             * Record which shipping method has been selected & Updated totals\n             */\n            onShippingMethodSelect: function (event, session) {\n                let shippingMethod = event.shippingMethod;\n                this.shippingMethod = shippingMethod.identifier;\n\n                let payload = {\n                    \"addressInformation\": {\n                        \"address\": {\n                            \"countryId\": this.shippingAddress.country_id,\n                            \"region\": this.shippingAddress.region,\n                            \"regionId\": this.getRegionId(this.shippingAddress.country_id, this.shippingAddress.region),\n                            \"postcode\": this.shippingAddress.postcode\n                        },\n                        \"shipping_method_code\": this.shippingMethods[this.shippingMethod].method_code,\n                        \"shipping_carrier_code\": this.shippingMethods[this.shippingMethod].carrier_code\n                    }\n                };\n\n                storage.post(\n                    this.getApiUrl(\"totals-information\"),\n                    JSON.stringify(payload)\n                ).done(function (r) {\n                    this.setGrandTotalAmount(r.base_grand_total);\n\n                    session.completeShippingMethodSelection(\n                        ApplePaySession.STATUS_SUCCESS,\n                        {\n                            label: this.getDisplayName(),\n                            amount: this.getGrandTotalAmount()\n                        },\n                        [{\n                            type: 'final',\n                            label: $t('Shipping'),\n                            amount: shippingMethod.amount\n                        }]\n                    );\n                }.bind(this));\n            },\n\n            /**\n             * Place the order\n             */\n            startPlaceOrder: function (nonce, event, session, device_data) {\n                let shippingContact = event.payment.shippingContact,\n                    billingContact = event.payment.billingContact,\n                    payload = {\n                        \"addressInformation\": {\n                            \"shipping_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": shippingContact.phoneNumber,\n                                \"firstname\": shippingContact.givenName,\n                                \"lastname\": shippingContact.familyName,\n                                \"street\": shippingContact.addressLines,\n                                \"city\": shippingContact.locality,\n                                \"region\": shippingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(shippingContact.countryCode.toUpperCase(), shippingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": shippingContact.countryCode.toUpperCase(),\n                                \"postcode\": shippingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"billing_address\": {\n                                \"email\": shippingContact.emailAddress,\n                                \"telephone\": shippingContact.phoneNumber,\n                                \"firstname\": billingContact.givenName,\n                                \"lastname\": billingContact.familyName,\n                                \"street\": billingContact.addressLines,\n                                \"city\": billingContact.locality,\n                                \"region\": billingContact.administrativeArea,\n                                \"region_id\": this.getRegionId(billingContact.countryCode.toUpperCase(), billingContact.administrativeArea),\n                                \"region_code\": null,\n                                \"country_id\": billingContact.countryCode.toUpperCase(),\n                                \"postcode\": billingContact.postalCode,\n                                \"same_as_billing\": 0,\n                                \"customer_address_id\": 0,\n                                \"save_in_address_book\": 0\n                            },\n                            \"shipping_method_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].method_code : '' ,\n                            \"shipping_carrier_code\": this.shippingMethod ? this.shippingMethods[this.shippingMethod].carrier_code : ''\n                        }\n                    };\n\n                // Set addresses\n                storage.post(\n                    this.getApiUrl(\"shipping-information\"),\n                    JSON.stringify(payload)\n                ).done(function () {\n                    // Submit payment information\n                    let paymentInformation = {\n                            \"email\": shippingContact.emailAddress,\n                            \"paymentMethod\": {\n                                \"method\": \"braintree_applepay\",\n                                \"additional_data\": {\n                                    \"payment_method_nonce\": nonce,\n                                    \"device_data\": device_data\n                                }\n                            }\n                        };\n                    if (window.checkout && window.checkout.agreementIds) {\n                        paymentInformation.paymentMethod.extension_attributes = {\n                            \"agreement_ids\": window.checkout.agreementIds\n                        };\n                    }\n                    storage.post(\n                        this.getApiUrl(\"payment-information\"),\n                        JSON.stringify(paymentInformation)\n                    ).done(function (r) {\n                        document.location = this.getActionSuccess();\n                        session.completePayment(ApplePaySession.STATUS_SUCCESS);\n                    }.bind(this)).fail(function (r) {\n                        session.completePayment(ApplePaySession.STATUS_FAILURE);\n                        session.abort();\n                        alert($t(\"We're unable to take your payment through Apple Pay. Please try an again or use an alternative payment method.\"));\n                        console.error(\"Braintree ApplePay Unable to take payment\", r);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (r) {\n                    console.error(\"Braintree ApplePay Unable to set shipping information\", r);\n                    session.completePayment(ApplePaySession.STATUS_INVALID_BILLING_POSTAL_ADDRESS);\n                });\n            }\n        });\n    });\n","PayPal_Braintree/js/applepay/button.js":"/**\n * Braintree Apple Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeApplePay',\n        'mage/translate',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        braintree,\n        dataCollector,\n        applePay,\n        $t,\n        additionalValidators\n    ) {\n        'use strict';\n\n        var that;\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree ApplePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                if (this.deviceSupported() === false) {\n                    return;\n                }\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n\n                        dataCollector.create({\n                            client: clientInstance\n                        }, function (dataCollectorErr, dataCollectorInstance) {\n                            if (dataCollectorErr) {\n                                return;\n                            }\n\n                            applePay.create({\n                                client: clientInstance\n                            }, function (applePayErr, applePayInstance) {\n                                // No instance\n                                if (applePayErr) {\n                                    console.error('Braintree ApplePay Error creating applePayInstance:', applePayErr);\n                                    return;\n                                }\n\n                                // Create a button within the KO element, as apple pay can only be instantiated through\n                                // a valid on click event (ko onclick bind interferes with this).\n                                var el = document.createElement('div');\n                                el.className = \"braintree-apple-pay-button\";\n                                el.title = $t(\"Pay with Apple Pay\");\n                                el.alt = $t(\"Pay with Apple Pay\");\n                                el.addEventListener('click', function (e) {\n                                    e.preventDefault();\n\n                                    if (!additionalValidators.validate()) {\n                                        return false;\n                                    }\n                                    // Payment request object\n                                    var paymentRequest = applePayInstance.createPaymentRequest(context.getPaymentRequest());\n                                    if (!paymentRequest) {\n                                        alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                        console.error('Braintree ApplePay Unable to create paymentRequest', paymentRequest);\n                                        return;\n                                    }\n\n                                    // Show the loader\n                                    jQuery(\"body\").loader('show');\n\n                                    // Init apple pay session\n                                    try {\n                                        var session = new ApplePaySession(1, paymentRequest);\n                                    } catch (err) {\n                                        jQuery(\"body\").loader('hide');\n                                        console.error('Braintree ApplePay Unable to create ApplePaySession', err);\n                                        alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                        return false;\n                                    }\n\n                                    // Handle invalid merchant\n                                    session.onvalidatemerchant = function (event) {\n                                        applePayInstance.performValidation({\n                                            validationURL: event.validationURL,\n                                            displayName: context.getDisplayName()\n                                        }, function (validationErr, merchantSession) {\n                                            if (validationErr) {\n                                                session.abort();\n                                                console.error('Braintree ApplePay Error validating merchant:', validationErr);\n                                                alert($t(\"We're unable to take payments through Apple Pay at the moment. Please try an alternative payment method.\"));\n                                                return;\n                                            }\n\n                                            session.completeMerchantValidation(merchantSession);\n                                        });\n                                    };\n\n                                    // Attach payment auth event\n                                    session.onpaymentauthorized = function (event) {\n                                        applePayInstance.tokenize({\n                                            token: event.payment.token\n                                        }, function (tokenizeErr, payload) {\n                                            if (tokenizeErr) {\n                                                console.error('Error tokenizing Apple Pay:', tokenizeErr);\n                                                session.completePayment(ApplePaySession.STATUS_FAILURE);\n                                                return;\n                                            }\n\n                                            // Pass the nonce back to the payment method\n                                            context.startPlaceOrder(payload.nonce, event, session, dataCollectorInstance.deviceData);\n                                        });\n                                    };\n\n                                    // Attach onShippingContactSelect method\n                                    if (typeof context.onShippingContactSelect === 'function') {\n                                        session.onshippingcontactselected = function (event) {\n                                            return context.onShippingContactSelect(event, session);\n                                        };\n                                    }\n\n                                    // Attach onShippingMethodSelect method\n                                    if (typeof context.onShippingMethodSelect === 'function') {\n                                        session.onshippingmethodselected = function (event) {\n                                            return context.onShippingMethodSelect(event, session);\n                                        };\n                                    }\n\n                                    // Hook\n                                    if (typeof context.onButtonClick === 'function') {\n                                        context.onButtonClick(session, this, e);\n                                    } else {\n                                        jQuery(\"body\").loader('hide');\n                                        session.begin();\n                                    }\n                                });\n                                element.appendChild(el);\n                            });\n                        });\n\n                });\n            },\n\n            /**\n             * Check the site is using HTTPS & apple pay is supported on this device.\n             * @return boolean\n             */\n            deviceSupported: function () {\n                if (location.protocol != 'https:') {\n                    console.warn(\"Braintree Apple Pay requires your checkout be served over HTTPS\");\n                    return false;\n                }\n\n                if ((window.ApplePaySession && ApplePaySession.canMakePayments()) !== true) {\n                    console.warn(\"Braintree Apple Pay is not supported on this device/browser\");\n                    return false;\n                }\n\n                return true;\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/shortcut.js":"/**\n * Braintree Apple Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/applepay/button',\n        'PayPal_Braintree/js/applepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: \"default\"\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                if (!this.displayName) {\n                    this.displayName = $t('Store');\n                }\n\n                var api = new buttonApi();\n                api.setGrandTotalAmount(parseFloat(this.grandTotalAmount).toFixed(2));\n                api.setClientToken(this.clientToken);\n                api.setDisplayName(this.displayName);\n                api.setQuoteId(this.quoteId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setIsLoggedIn(this.isLoggedIn);\n                api.setStoreCode(this.storeCode);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-applepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_applepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_applepay',\n            component: 'PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay.js":"/**\n * Braintree Apple Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/applepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/applepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceData: null,\n            grandTotalAmount: 0,\n            deviceSupported: button.deviceSupported()\n        },\n\n        /**\n         * Inject the apple pay button into the target element\n         */\n        getApplePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apple pay place order method\n         */\n        startPlaceOrder: function (nonce, event, session, device_data) {\n            this.setPaymentMethodNonce(nonce);\n            this.setDeviceData(device_data);\n            this.placeOrder();\n\n            session.completePayment(ApplePaySession.STATUS_SUCCESS);\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Save nonce\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request data\n         */\n        getPaymentRequest: function () {\n            return {\n                total: {\n                    label: this.getDisplayName(),\n                    amount: this.grandTotalAmount\n                }\n            };\n        },\n\n        /**\n         * Merchant display name\n         */\n        getDisplayName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData\n                }\n            };\n            return data;\n        },\n\n        /**\n         * Return image url for the apple pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});\n","PayPal_Braintree/js/paypal/product-page.js":"define(\n    ['PayPal_Braintree/js/paypal/button', 'jquery'],\n    function (button, $) {\n        'use strict';\n\n        return button.extend({\n\n            defaults: {\n                label: 'buynow',\n                branding: true,\n            },\n\n            /**\n             * The validation on the add-to-cart form is done after the PayPal window has opened.\n             * This is because the validate method exposed by the PP Button requires an event to disable/enable the button.\n             * We can't fire an event due to the way the mage.validation widget works and we can't do something gross like\n             * an interval because the validation() method shows the error messages and focuses the user's input on the\n             * first erroring input field.\n             * @param payload\n             * @returns {*}\n             */\n            beforeSubmit: function (payload) {\n                var form = $(\"#product_addtocart_form\");\n\n                if (!(form.validation() && form.validation('isValid'))) {\n                    return false;\n                }\n\n                payload.additionalData = form.serialize();\n\n                return payload;\n            }\n        });\n    }\n);","PayPal_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypal/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'Magento_Customer/js/customer-data',\n        'mage/translate',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreePayPalCheckout',\n        'PayPal_Braintree/js/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        customerData,\n        $t,\n        braintree,\n        dataCollector,\n        paypalCheckout,\n        formBuilder\n    ) {\n        'use strict';\n        let buttonIds = [];\n\n        return {\n            events: {\n                onClick: null,\n                onCancel: null,\n                onError: null\n            },\n\n            /**\n             * @param token\n             * @param currency\n             * @param env\n             * @param local\n             * @param lineItems\n             */\n            init: function (token, currency, env, local, lineItems) {\n                if ($('.action-braintree-paypal-message').length) {\n                    $('.product-add-form form').on('keyup change paste', 'input, select, textarea', function () {\n                        var currentPrice, currencySymbol;\n                        currentPrice = $(\".product-info-main span\").find(\"[data-price-type='finalPrice']\").text();\n                        currencySymbol = $('.action-braintree-paypal-message[data-pp-type=\"product\"]').data('currency-symbol');\n                        $('.action-braintree-paypal-message[data-pp-type=\"product\"]').attr('data-pp-amount', currentPrice.replace(currencySymbol,''));\n                    });\n                }\n\n                buttonIds = [];\n                $('.action-braintree-paypal-logo').each(function () {\n                    if (!$(this).hasClass(\"button-loaded\")) {\n                        $(this).addClass('button-loaded');\n                        buttonIds.push($(this).attr('id'));\n                    }\n                });\n\n                if (buttonIds.length > 0) {\n                    this.loadSDK(token, currency, env, local, lineItems);\n                }\n            },\n\n            /**\n             * Load Braintree PayPal SDK\n             * @param token\n             * @param currency\n             * @param env\n             * @param local\n             * @param lineItems\n             */\n            loadSDK: function (token, currency, env, local, lineItems) {\n                braintree.create({\n                    authorization: token\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('paypalCheckout error', clientErr);\n                        return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                    }\n                    dataCollector.create({\n                        client: clientInstance,\n                        paypal: true\n                    }, function (err, dataCollectorInstance) {\n                        if (err) {\n                            return console.log(err);\n                        }\n                    });\n                    paypalCheckout.create({\n                        client: clientInstance\n                    }, function (err, paypalCheckoutInstance) {\n                        if (typeof paypal !== 'undefined' ) {\n                            this.renderPayPalButtons(buttonIds, paypalCheckoutInstance, lineItems);\n                            this.renderPayPalMessages();\n                        } else {\n                            var configSDK = {\n                                components: 'buttons,messages,funding-eligibility',\n                                \"enable-funding\": \"paylater\",\n                                currency: currency\n                            };\n                            if (env === 'sandbox' && local !== '') {\n                                configSDK[\"buyer-country\"] = local;\n                            }\n                            paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                                this.renderPayPalButtons(buttonIds, paypalCheckoutInstance, lineItems);\n                                this.renderPayPalMessages();\n                            }.bind(this));\n                        }\n                    }.bind(this));\n                }.bind(this));\n            },\n\n            /**\n             * Render PayPal buttons\n             *\n             * @param ids\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            renderPayPalButtons: function (ids, paypalCheckoutInstance, lineItems) {\n                _.each(ids, function (id) {\n                    this.payPalButton(id, paypalCheckoutInstance, lineItems);\n                }.bind(this));\n            },\n\n            /**\n             * Render PayPal messages\n             */\n            renderPayPalMessages: function () {\n                $('.action-braintree-paypal-message').each(function () {\n                    paypal.Messages({\n                        amount: $(this).data('pp-amount'),\n                        pageType: $(this).data('pp-type'),\n                        style: {\n                            layout: $(this).data('messaging-layout'),\n                            text: {\n                              color:   $(this).data('messaging-text-color')\n                            },\n                            logo: {\n                                type: $(this).data('messaging-logo'),\n                                position: $(this).data('messaging-logo-position')\n                            }\n                        }\n                    }).render('#' + $(this).attr('id'));\n\n\n                });\n            },\n\n            /**\n             * @param id\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            payPalButton: function (id, paypalCheckoutInstance, lineItems) {\n                let data = $('#' + id);\n                let style = {\n                    color: data.data('color'),\n                    shape: data.data('shape'),\n                    size: data.data('size'),\n                    label: data.data('label')\n                };\n\n                if (data.data('fundingicons')) {\n                    style.fundingicons = data.data('fundingicons');\n                }\n\n                // Render\n                var paypalActions;\n                var button = paypal.Buttons({\n                    fundingSource: data.data('funding'),\n                    style: style,\n                    createOrder: function () {\n                        return paypalCheckoutInstance.createPayment({\n                            amount: data.data('amount'),\n                            locale: data.data('locale'),\n                            currency: data.data('currency'),\n                            flow: 'checkout',\n                            enableShippingAddress: true,\n                            displayName: data.data('displayname'),\n                            lineItems: $.parseJSON(lineItems)\n                        });\n                    },\n                    validate: function (actions) {\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed;\n                        if (declinePayment) {\n                            actions.disable();\n                        }\n                        paypalActions = actions;\n                    },\n\n                    onCancel: function (data) {\n                        jQuery(\"#maincontent\").trigger('processStop');\n                    },\n\n                    onError: function (err) {\n                        console.error('paypalCheckout button render error', err);\n                        jQuery(\"#maincontent\").trigger('processStop');\n                    },\n\n                    onClick: function (data) {\n                        var cart = customerData.get('cart'),\n                            customer = customerData.get('customer'),\n                            declinePayment = false,\n                            isGuestCheckoutAllowed;\n\n                        isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                        declinePayment = !customer().firstname && !isGuestCheckoutAllowed && (typeof isGuestCheckoutAllowed !== 'undefined');\n                        if (declinePayment) {\n                            alert($t('To check out, please sign in with your email address.'));\n                        }\n                    },\n\n                    onApprove: function (data1) {\n                        return paypalCheckoutInstance.tokenizePayment(data1, function (err, payload) {\n                            jQuery(\"#maincontent\").trigger('processStart');\n\n                            // Map the shipping address correctly\n                            var address = payload.details.shippingAddress;\n                            var recipientFirstName, recipientLastName;\n                            if (typeof address.recipientName !== 'undefined') {\n                                var recipientName = address.recipientName.split(\" \");\n                                recipientFirstName = recipientName[0].replace(/'/g, \"&apos;\");\n                                recipientLastName = recipientName[1].replace(/'/g, \"&apos;\");\n                            } else {\n                                recipientFirstName = payload.details.firstName.replace(/'/g, \"&apos;\");\n                                recipientLastName = payload.details.lastName.replace(/'/g, \"&apos;\");\n                            }\n                            payload.details.shippingAddress = {\n                                streetAddress: typeof address.line2 !== 'undefined' ? address.line1.replace(/'/g, \"&apos;\") + \" \" + address.line2.replace(/'/g, \"&apos;\") : address.line1.replace(/'/g, \"&apos;\"),\n                                locality: address.city.replace(/'/g, \"&apos;\"),\n                                postalCode: address.postalCode,\n                                countryCodeAlpha2: address.countryCode,\n                                email: payload.details.email.replace(/'/g, \"&apos;\"),\n                                recipientFirstName: recipientFirstName,\n                                recipientLastName: recipientLastName,\n                                telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                region: typeof address.state !== 'undefined' ? address.state.replace(/'/g, \"&apos;\") : ''\n                            };\n\n                            payload.details.email = payload.details.email.replace(/'/g, \"&apos;\");\n                            payload.details.firstName = payload.details.firstName.replace(/'/g, \"&apos;\");\n                            payload.details.lastName = payload.details.lastName.replace(/'/g, \"&apos;\");\n                            if (typeof payload.details.businessName !== 'undefined') {\n                                payload.details.businessName = payload.details.businessName.replace(/'/g, \"&apos;\");\n                            }\n\n                            // Map the billing address correctly\n                            let isRequiredBillingAddress = data.data('requiredbillingaddress');\n                            if ((isRequiredBillingAddress === 1) && (typeof payload.details.billingAddress !== 'undefined')) {\n                                var billingAddress = payload.details.billingAddress;\n                                payload.details.billingAddress = {\n                                    streetAddress: typeof billingAddress.line2 !== 'undefined' ? billingAddress.line1.replace(/'/g, \"&apos;\") + \" \" + billingAddress.line2.replace(/'/g, \"&apos;\") : billingAddress.line1.replace(/'/g, \"&apos;\"),\n                                    locality: billingAddress.city.replace(/'/g, \"&apos;\"),\n                                    postalCode: billingAddress.postalCode,\n                                    countryCodeAlpha2: billingAddress.countryCode,\n                                    telephone: typeof payload.details.phone !== 'undefined' ? payload.details.phone : '',\n                                    region: typeof billingAddress.state !== 'undefined' ? billingAddress.state.replace(/'/g, \"&apos;\") : ''\n                                };\n                            }\n\n                            if (data.data('location') == 'productpage') {\n                                var form = $(\"#product_addtocart_form\");\n                                if (!(form.validation() && form.validation('isValid'))) {\n                                    return false;\n                                }\n                                payload.additionalData = form.serialize();\n                            }\n\n                            var actionSuccess = data.data('actionsuccess');\n                            formBuilder.build(\n                                {\n                                    action: actionSuccess,\n                                    fields: {\n                                        result: JSON.stringify(payload)\n                                    }\n                                }\n                            ).submit();\n                        });\n                    }\n                });\n                if (!button.isEligible()) {\n                    console.log('PayPal button is not elligible')\n                    data.parent().remove();\n                    return;\n                }\n                if ($('#' + data.attr('id')).length) {\n                    button.render('#' + data.attr('id'));\n                }\n            },\n        }\n    }\n);\n","PayPal_Braintree/js/paypal/credit/calculator.js":"define([\n    'underscore',\n    'uiComponent',\n    'jquery'\n], function (_, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: \"PayPal_Braintree/credit/calculator\",\n            displaySummary: true, // \"From X per month\"\n            displayInterestDetails: false, // Display the more in-depth summary of interest rates\n            instalmentsFrom: 0,\n            currentInstalment: {\n                term: 0,\n                monthlyPayment: 0,\n                apr: 0,\n                cost: 0,\n                costIncInterest: 0\n            },\n            endpoint: null,\n            instalments: [],\n            visible: false,\n            merchantName: ''\n        },\n\n        initObservable: function () {\n            this._super();\n            if (this.instalments.length > 0) {\n                this.currentInstalment = this.instalments[0];\n                this.instalmentsFrom = this.instalments[this.instalments.length-1].monthlyPayment;\n                this.visible = true;\n            } else {\n                this.loadInstalments();\n            }\n\n            this.observe(['instalments', 'currentInstalment', 'instalmentsFrom', 'visible']);\n            return this;\n        },\n\n        isCurrentInstalment: function (term) {\n            return (this.currentInstalment().term === term);\n        },\n\n        setCurrentInstalment: function (instalment) {\n            this.currentInstalment(instalment);\n        },\n\n        loadInstalments: function () {\n            if (!this.endpoint) {\n                return false;\n            }\n\n            var self = this;\n            require(['Magento_Checkout/js/model/quote', 'jquery'], function (quote, $) {\n                if (typeof quote.totals().base_grand_total === 'undefined') {\n                    return false;\n                }\n\n                $.getJSON(self.endpoint, {amount: quote.totals().base_grand_total}, function (response) {\n                    self.instalments(response);\n                    self.setCurrentInstalment(response[0]);\n                    self.visible(true);\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/api.js":"/**\n * Braintree Google Pay button api\n **/\ndefine([\n    'uiComponent',\n    'mage/translate',\n    'mage/storage',\n    'jquery',\n    'PayPal_Braintree/js/form-builder'\n], function (Component, $t, storage, jQuery, formBuilder) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            clientToken: null,\n            merchantId: null,\n            currencyCode: null,\n            actionSuccess: null,\n            amount: null,\n            cardTypes: [],\n            btnColor: 0\n        },\n\n        /**\n         * Set & get environment\n         * \"PRODUCTION\" or \"TEST\"\n         */\n        setEnvironment: function (value) {\n            this.environment = value;\n        },\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * Set & get api token\n         */\n        setClientToken: function (value) {\n            this.clientToken = value;\n        },\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Set and get display name\n         */\n        setMerchantId: function (value) {\n            this.merchantId = value;\n        },\n        getMerchantId: function () {\n            return this.merchantId;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setAmount: function (value) {\n            this.amount = parseFloat(value).toFixed(2);\n        },\n        getAmount: function () {\n            return this.amount;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setCurrencyCode: function (value) {\n            this.currencyCode = value;\n        },\n        getCurrencyCode: function () {\n            return this.currencyCode;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setActionSuccess: function (value) {\n            this.actionSuccess = value;\n        },\n        getActionSuccess: function () {\n            return this.actionSuccess;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setCardTypes: function (value) {\n            this.cardTypes = value;\n        },\n        getCardTypes: function () {\n            return this.cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        setBtnColor: function (value) {\n            this.btnColor = value;\n        },\n        getBtnColor: function () {\n            return this.btnColor;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            var result = {\n                transactionInfo: {\n                    totalPriceStatus: 'ESTIMATED',\n                    totalPrice: this.getAmount(),\n                    currencyCode: this.getCurrencyCode()\n                },\n                allowedPaymentMethods: [\n                    {\n                        \"type\": \"CARD\",\n                        \"parameters\": {\n                            \"allowedCardNetworks\": this.getCardTypes(),\n                            \"billingAddressRequired\": true,\n                            \"billingAddressParameters\": {\n                                format: 'FULL',\n                                phoneNumberRequired: true\n                            },\n                        },\n\n                    }\n                ],\n                shippingAddressRequired: true,\n                emailRequired: true,\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n            return result;\n        },\n\n        /**\n         * Place the order\n         */\n        startPlaceOrder: function (nonce, paymentData, deviceData) {\n            var payload = {\n                details: {\n                    shippingAddress: {\n                        streetAddress: paymentData.shippingAddress.address1 + \"\\n\"\n                            + paymentData.shippingAddress.address2,\n                        locality: paymentData.shippingAddress.locality,\n                        postalCode: paymentData.shippingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.shippingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.shippingAddress.name,\n                        telephone: typeof paymentData.shippingAddress.phoneNumber !== 'undefined' ? paymentData.shippingAddress.phoneNumber : '',\n                        region: typeof paymentData.shippingAddress.administrativeArea !== 'undefined' ? paymentData.shippingAddress.administrativeArea : ''\n                    },\n                    billingAddress: {\n                        streetAddress: paymentData.paymentMethodData.info.billingAddress.address1 + \"\\n\"\n                            + paymentData.paymentMethodData.info.billingAddress.address2,\n                        locality: paymentData.paymentMethodData.info.billingAddress.locality,\n                        postalCode: paymentData.paymentMethodData.info.billingAddress.postalCode,\n                        countryCodeAlpha2: paymentData.paymentMethodData.info.billingAddress.countryCode,\n                        email: paymentData.email,\n                        name: paymentData.paymentMethodData.info.billingAddress.name,\n                        telephone: typeof paymentData.paymentMethodData.info.billingAddress.phoneNumber !== 'undefined' ? paymentData.paymentMethodData.info.billingAddress.phoneNumber : '',\n                        region: typeof paymentData.paymentMethodData.info.billingAddress.administrativeArea !== 'undefined' ? paymentData.paymentMethodData.info.billingAddress.administrativeArea : ''\n                    }\n                },\n                nonce: nonce,\n                deviceData: deviceData,\n            };\n\n            formBuilder.build({\n                action: this.getActionSuccess(),\n                fields: {\n                    result: JSON.stringify(payload)\n                }\n            }).submit();\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/button.js":"/**\n * Braintree Google Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        \"knockout\",\n        \"jquery\",\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_CheckoutAgreements/js/view/checkout-agreements',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeGooglePay',\n        'mage/translate',\n        'googlePayLibrary'\n    ],\n    function (\n        Component,\n        ko,\n        jQuery,\n        additionalValidators,\n        checkoutAgreements,\n        braintree,\n        dataCollector,\n        googlePay,\n        $t\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n\n                // No element or context\n                if (!element || !context ) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getClientToken method\", context);\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a getPaymentRequest method\", context);\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\"Braintree GooglePay Context passed does not provide a startPlaceOrder method\", context);\n                    return;\n                }\n\n                // init google pay object\n                var paymentsClient = new google.payments.api.PaymentsClient({\n                    environment: context.getEnvironment()\n                });\n\n                // Create a button within the KO element, as google pay can only be instantiated through\n                // a valid on click event (ko onclick bind interferes with this).\n                var deviceData;\n                var button = document.createElement('button');\n                button.className = \"braintree-googlepay-button long \" + (context.getBtnColor() == 1 ? 'black' : 'white');\n                button.title = $t(\"Buy with Google Pay\");\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error creating client:', clientErr);\n                        return;\n                    }\n                    dataCollector.create({\n                        client: clientInstance\n                    }, function (dataCollectorErr, dataCollectorInstance) {\n                        if (dataCollectorErr) {\n                            return;\n                        }\n                        googlePay.create({\n                            client: clientInstance,\n                            googlePayVersion: 2\n                        }, function (googlePayErr, googlePaymentInstance) {\n                            // No instance\n                            if (googlePayErr) {\n                                console.error('Braintree GooglePay Error creating googlePayInstance:', googlePayErr);\n                                return;\n                            }\n\n                            paymentsClient.isReadyToPay({\n                                apiVersion: 2,\n                                apiVersionMinor: 0,\n                                allowedPaymentMethods: googlePaymentInstance.createPaymentDataRequest().allowedPaymentMethods\n                            }).then(function(response) {\n                                if (response.result) {\n                                    button.addEventListener('click', function (event) {\n\n                                        var agreements = checkoutAgreements().agreements,\n                                            shouldDisableActions = false;\n\n\n                                        _.each(agreements, function (item, index) {\n                                            if (checkoutAgreements().isAgreementRequired(item)) {\n                                                var inputId = '#agreement_braintree_googlepay_' + item.agreementId,\n                                                    inputEl = document.querySelector(inputId);\n\n                                                if (inputEl !== null && !inputEl.checked) {\n                                                    shouldDisableActions = true;\n                                                }\n\n                                            }\n                                        });\n\n                                        if (!additionalValidators.validate()) {\n                                            event.preventDefault();\n                                            return false;\n                                        }\n\n                                        if (!shouldDisableActions) {\n                                            event.preventDefault();\n                                            jQuery(\"body\").loader('show');\n                                            var responseData;\n\n                                            var paymentDataRequest = googlePaymentInstance.createPaymentDataRequest(context.getPaymentRequest());\n                                            paymentsClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {\n                                                // Persist the paymentData (shipping address etc)\n                                                responseData = paymentData;\n                                                // Return the braintree nonce promise\n                                                return googlePaymentInstance.parseResponse(paymentData);\n                                            }).then(function (result) {\n                                                context.startPlaceOrder(result.nonce, responseData, dataCollectorInstance.deviceData);\n                                            }).catch(function (err) {\n                                                // Handle errors\n                                                // err = {statusCode: \"CANCELED\"}\n                                                console.error(err);\n                                                jQuery(\"body\").loader('hide');\n                                            });\n                                        }\n                                    });\n\n                                    element.appendChild(button);\n                                }\n                            }).catch(function (err) {\n                                console.error(err);\n                                jQuery(\"body\").loader('hide');\n                            });\n                        });\n                    });\n                });\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/shortcut.js":"/**\n * Braintree Google Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/googlepay/button',\n        'PayPal_Braintree/js/googlepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                merchantId: null,\n                currencyCode: null,\n                actionSuccess: null,\n                amount: null,\n                environment: \"TEST\",\n                cardType: [],\n                btnColor: 0\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                var api = new buttonApi();\n                api.setEnvironment(this.environment);\n                api.setCurrencyCode(this.currencyCode);\n                api.setClientToken(this.clientToken);\n                api.setMerchantId(this.merchantId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setAmount(this.amount);\n                api.setCardTypes(this.cardTypes)\n                api.setBtnColor(this.btnColor);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-googlepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_googlepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_googlepay',\n            component: 'PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay.js":"/**\n * Braintree Google Pay payment method integration.\n **/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/googlepay/button'\n], function (\n    Component,\n    quote,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/googlepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceData: null,\n            grandTotalAmount: 0\n        },\n\n        /**\n         * Inject the google pay button into the target element\n         */\n        getGooglePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n            this.currencyCode = quote.totals()['base_currency_code'];\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Google pay place order method\n         */\n        startPlaceOrder: function (nonce, paymentData, device_data) {\n            this.setPaymentMethodNonce(nonce);\n            this.setDeviceData(device_data);\n            this.placeOrder();\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Save device_data\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n           var result = {\n               transactionInfo: {\n                   totalPriceStatus: 'FINAL',\n                   totalPrice: this.grandTotalAmount,\n                   currencyCode: this.currencyCode\n               },\n               allowedPaymentMethods: [\n                   {\n                       \"type\": \"CARD\",\n                       \"parameters\": {\n                           \"allowedCardNetworks\": this.getCardTypes(),\n                           \"billingAddressRequired\": false,\n                       },\n\n                   }\n               ],\n               shippingAddressRequired: false,\n               emailRequired: false,\n            };\n\n            if (this.getEnvironment() !== \"TEST\") {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n           return result;\n        },\n\n        /**\n         * Merchant display name\n         */\n        getMerchantId: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantId;\n        },\n\n        /**\n         * Environment\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        /**\n         * Card Types\n         */\n        getCardTypes: function () {\n            return window.checkoutConfig.payment[this.getCode()].cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        getBtnColor: function () {\n            return window.checkoutConfig.payment[this.getCode()].btnColor;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData\n                }\n            };\n        },\n\n        /**\n         * Return image url for the google pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        }\n    });\n});\n","PayPal_Braintree/js/reCaptcha/webapiReCaptchaRegistry-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (originalFunction) {\n        /**\n         * {@inheritDoc}\n         */\n       originalFunction.addListener = function (id , func) {\n            this._listeners[id] = func;\n       };\n\n       return originalFunction;\n    };\n});\n","PayPal_Braintree/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable max-nested-callbacks */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n], function ($, wrapper, recaptchaRegistry) {\n    'use strict';\n\n    return function (placeOrder) {\n        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {\n            var recaptchaDeferred;\n\n            if (recaptchaRegistry.triggers.hasOwnProperty('recaptcha-checkout-braintree')) {\n                //ReCaptcha is present for checkout\n                recaptchaDeferred = $.Deferred();\n                recaptchaRegistry.addListener('recaptcha-checkout-braintree', function (token) {\n                    //Add reCaptcha value to place-order request and resolve deferred with the API call results\n                    payload.xReCaptchaValue = token;\n                    originalAction(serviceUrl, payload, messageContainer).done(function () {\n                        recaptchaDeferred.resolve.apply(recaptchaDeferred, arguments);\n                    }).fail(function () {\n                        recaptchaDeferred.reject.apply(recaptchaDeferred, arguments);\n                    });\n                });\n                //Trigger ReCaptcha validation\n                recaptchaRegistry.triggers['recaptcha-checkout-braintree']();\n                //remove listener so that place order action is only triggered by the 'Place Order' button\n                recaptchaRegistry.removeListener('recaptcha-checkout-braintree');\n                return recaptchaDeferred;\n            }\n\n            //No ReCaptcha, just sending the request\n            return originalAction(serviceUrl, payload, messageContainer);\n        });\n    };\n});\n","PayPal_Braintree/js/model/step-navigator-mixin.js":"define([\n    'mage/utils/wrapper',\n    'jquery'\n], function (wrapper, $) {\n    'use strict';\n\n    let mixin = {\n        handleHash: function (originalFn) {\n            var hashString = window.location.hash.replace('#', '');\n            if (hashString.indexOf('venmo') > -1) {\n                return false;\n            }\n\n            return originalFn();\n        }\n    };\n\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.compareList', {\n\n        /** @inheritdoc */\n        _create: function () {\n            var elem = this.element,\n                products = $('thead td', elem),\n                headings;\n\n            if (products.length > this.options.productsInRow) {\n                headings = $('<table></table>')\n                    .addClass('comparison headings data table')\n                    .insertBefore(elem.closest('.container'));\n\n                elem.addClass('scroll');\n\n                $('th', elem).each(function () {\n                    var th = $(this),\n                        thCopy = th.clone();\n\n                    th.animate({\n                        top: '+=0'\n                    }, 50, function () {\n                        var height = th.height();\n\n                        thCopy.css('height', height)\n                            .appendTo(headings)\n                            .wrap('<tr></tr>');\n                    });\n                });\n            }\n\n            $(this.options.windowPrintSelector).on('click', function (e) {\n                e.preventDefault();\n                window.print();\n            });\n        }\n    });\n\n    return $.mage.compareList;\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/related-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.relatedProducts', {\n        options: {\n            relatedCheckbox: '.related-checkbox', // Class name for a related product's input checkbox.\n            relatedProductsCheckFlag: false, // Related products checkboxes are initially unchecked.\n            relatedProductsField: '#related-products-field', // Hidden input field that stores related products.\n            selectAllMessage: $.mage.__('select all'),\n            unselectAllMessage: $.mage.__('unselect all'),\n            selectAllLink: '[data-role=\"select-all\"]',\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            $(this.options.selectAllLink, this.element).on('click', $.proxy(this._selectAllRelated, this));\n            $(this.options.relatedCheckbox, this.element).on('click', $.proxy(this._addRelatedToProduct, this));\n\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showRelatedProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /**\n         * This method either checks all checkboxes for a product's set of related products (select all)\n         * or unchecks them (unselect all).\n         * @private\n         * @param {jQuery.Event} e - Click event on either the \"select all\" link or the \"unselect all\" link.\n         * @return {Boolean} - Prevent default event action and event propagation.\n         */\n        _selectAllRelated: function (e) {\n            var innerHTML = this.options.relatedProductsCheckFlag ?\n                this.options.selectAllMessage : this.options.unselectAllMessage;\n\n            $(e.target).html(innerHTML);\n            $(this.options.relatedCheckbox + ':visible').attr(\n                'checked',\n                this.options.relatedProductsCheckFlag = !this.options.relatedProductsCheckFlag\n            );\n            this._addRelatedToProduct();\n\n            return false;\n        },\n\n        /**\n         * This method iterates through each checkbox for all related products and collects only those products\n         * whose checkbox has been checked. The selected related products are stored in a hidden input field.\n         * @private\n         */\n        _addRelatedToProduct: function () {\n            $(this.options.relatedProductsField).val(\n                $(this.options.relatedCheckbox + ':checked').map(function () {\n                    return this.value;\n                }).get().join(',')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show related products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {*} limit\n         * @param weightedRandom\n         * @private\n         */\n        _showRelatedProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param {Array} elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements) {\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.relatedProducts;\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPriceLocale(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return new Array(times + 1).join(string);\n    }\n\n    /**\n     * Format the price with the compliance to the specified locale\n     *\n     * @param {Number} amount\n     * @param {Object} format\n     * @param  {Boolean} isShowSign\n     */\n    function formatPriceLocale(amount, format, isShowSign)\n    {\n        var s = '',\n            precision, pattern, locale, r;\n\n        format = _.extend(globalPriceFormat, format);\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        pattern = format.pattern || '%s';\n        locale = window.LOCALE || 'en-US';\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n        amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision));\n        r = amount.toLocaleString(locale, {minimumFractionDigits: precision});\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     * @deprecated\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPriceLocale: formatPriceLocale,\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/validate-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'catalogAddToCart'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.productValidate', {\n        options: {\n            bindSubmit: false,\n            radioCheckboxClosest: '.nested',\n            addToCartButtonSelector: '.action.tocart'\n        },\n\n        /**\n         * Uses Magento's validation widget for the form object.\n         * @private\n         */\n        _create: function () {\n            var bindSubmit = this.options.bindSubmit;\n\n            this.element.validation({\n                radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                /**\n                 * Uses catalogAddToCart widget as submit handler.\n                 * @param {Object} form\n                 * @returns {Boolean}\n                 */\n                submitHandler: function (form) {\n                    var jqForm = $(form).catalogAddToCart({\n                        bindSubmit: bindSubmit\n                    });\n\n                    jqForm.catalogAddToCart('submitForm', jqForm);\n\n                    return false;\n                }\n            });\n            $(this.options.addToCartButtonSelector).attr('disabled', false);\n        }\n    });\n\n    return $.mage.productValidate;\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPriceLocale(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final and base price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var originalPrice,\n                prices = {'prices': {}};\n\n            if (this.options.prices.finalPrice) {\n                originalPrice = this.options.prices.finalPrice.amount;\n                prices.prices.finalPrice = {'amount': this.getPrice('price') - originalPrice};\n            }\n\n            if (this.options.prices.basePrice) {\n                originalPrice = this.options.prices.basePrice.amount;\n                prices.prices.basePrice = {'amount': this.getPrice('basePrice') - originalPrice};\n            }\n\n            this.updatePrice(prices);\n        },\n\n        /**\n         * Returns price.\n         *\n         * @param {String} priceKey\n         * @returns {Number}\n         */\n        getPrice: function (priceKey) {\n            var productQty = $(this.qtyInfo).val(),\n                result,\n                tierPriceItem,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                tierPriceItem = this.options.priceConfig.tierPrices[i];\n                if (productQty >= tierPriceItem.qty && tierPriceItem[priceKey]) {\n                    result = tierPriceItem[priceKey];\n                }\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.gallery', {\n        options: {\n            minWidth: 300, // Minimum width of the gallery image.\n            widthOffset: 90, // Offset added to the width of the gallery image.\n            heightOffset: 210, // Offset added to the height of the gallery image.\n            closeWindow: 'div.buttons-set a[role=\"close-window\"]' // Selector for closing the gallery popup window.\n        },\n\n        /**\n         * Bind click handler for closing the popup window and resize the popup based on the image size.\n         * @private\n         */\n        _create: function () {\n            $(this.options.closeWindow).on('click', function () {\n                window.close();\n            });\n            this._resizeWindow();\n        },\n\n        /**\n         * Resize the gallery image popup window based on the image's dimensions.\n         * @private\n         */\n        _resizeWindow: function () {\n            var img = this.element,\n                width = img.width() < this.options.minWidth ? this.options.minWidth : img.width();\n\n            window.resizeTo(width + this.options.widthOffset, img.height() + this.options.heightOffset);\n        }\n    });\n\n    return $.mage.gallery;\n});\n","Magento_Catalog/js/upsell-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.upsellProducts', {\n        options: {\n            elementsSelector: '.item.product'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            if (this.element.data('shuffle')) {\n                this._shuffle(this.element.find(this.options.elementsSelector));\n            }\n            this._showUpsellProducts(\n                this.element.find(this.options.elementsSelector),\n                this.element.data('limit'),\n                this.element.data('shuffle-weighted')\n            );\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Show upsell products according to limit. Shuffle if needed.\n         * @param {*} elements\n         * @param {Number} limit\n         * @param {Boolean} weightedRandom\n         * @private\n         */\n        _showUpsellProducts: function (elements, limit, weightedRandom) {\n            var index, weights = [], random = [], weight = 2, shown = 0, $element, currentGroup, prevGroup;\n\n            if (limit === 0) {\n                limit = elements.length;\n            }\n\n            if (weightedRandom && limit > 0 && limit < elements.length) {\n                for (index = 0; index < limit; index++) {\n                    $element = $(elements[index]);\n                    if ($element.data('shuffle-group') !== '') {\n                        break;\n                    }\n                    $element.show();\n                    shown++;\n                }\n                limit -= shown;\n                for (index = elements.length - 1; index >= 0; index--) {\n                    $element = $(elements[index]);\n                    currentGroup = $element.data('shuffle-group');\n                    if (currentGroup !== '') {\n                        weights.push([index, Math.log(weight)]);\n                        if (typeof prevGroup !== 'undefined' && prevGroup !== currentGroup) {\n                            weight += 2;\n                        }\n                        prevGroup = currentGroup;\n                    }\n                }\n\n                if (weights.length === 0) {\n                    return;\n                }\n\n                for (index = 0; index < weights.length; index++) {\n                    random.push([weights[index][0], Math.pow(Math.random(), 1 / weights[index][1])]);\n                }\n\n                random.sort(function(a, b) {\n                    a = a[1];\n                    b = b[1];\n                    return a < b ? 1 : (a > b ? -1 : 0);\n                });\n                index = 0;\n                while (limit) {\n                    $(elements[random[index][0]]).show();\n                    limit--;\n                    index++\n                }\n                return;\n            }\n\n            for (index = 0; index < limit; index++) {\n                $(elements[index]).show();\n            }\n        },\n\n        /* jscs:disable */\n        /* eslint-disable */\n        /**\n         * Shuffle an array\n         * @param elements\n         * @returns {*}\n         */\n        _shuffle: function shuffle(elements){ //v1.0\n            var parent, child, lastSibling;\n            if (elements.length) {\n                parent = $(elements[0]).parent();\n            }\n            while (elements.length) {\n                child = elements.splice(Math.floor(Math.random() *  elements.length), 1)[0];\n                lastSibling = parent.find('[data-shuffle-group=\"' + $(child).data('shuffle-group') + '\"]').last();\n                lastSibling.after(child);\n            }\n        }\n\n        /* jscs:disable */\n        /* eslint:disable */\n    });\n\n    return $.mage.upsellProducts;\n});\n","Magento_Catalog/js/storage-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'mageUtils',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/section-config',\n    'jquery'\n], function (_, Element, utils, storage, sectionConfig, $) {\n    'use strict';\n\n    /**\n     * Flush events, that are clones of the same customer data sections\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections && window.localStorage) {\n                _.each(sections, function (section) {\n                    window.localStorage.removeItem(section);\n                });\n            }\n        }\n    });\n\n    return Element.extend({\n        defaults: {\n            defaultNamespace: {\n                lifetime: 1000\n            },\n            storagesConfiguration: {\n                'recently_viewed_product': {\n                    namespace: 'recently_viewed_product',\n                    className: 'IdsStorage',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_viewed_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_viewed_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_viewed_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'recently_compared_product': {\n                    namespace: 'recently_compared_product',\n                    className: 'IdsStorageCompare',\n                    provider: 'compare-products',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_compared_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_compared_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_compared_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'product_data_storage': {\n                    namespace: 'product_data_storage',\n                    className: 'DataStorage',\n                    allowToSendRequest: 0,\n                    updateRequestConfig: {\n                        url: '',\n                        method: 'GET',\n                        dataType: 'json'\n                    }\n                }\n            },\n            requestConfig: {\n                method: 'POST',\n                dataType: 'json',\n                ajaxSaveType: 'default',\n                ignoreProcessEvents: true\n            },\n            requestSent: 0\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .prepareStoragesConfig()\n                .initStorages()\n                .initStartData()\n                .initUpdateStorageDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes storages.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStorages: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this[name] = storage.createStorage(this.storagesConfiguration[name]);\n\n                if (this.storagesConfiguration[name].savePrevious) {\n                    this[name].previous = storage.createStorage(this.storagesConfiguration[name].savePrevious);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes start data.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStartData: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this.updateDataHandler(name, this[name].get());\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare storages congfig.\n         *\n         * @returns {Object} Chainable.\n         */\n        prepareStoragesConfig: function () {\n            this.storagesNamespace = _.keys(this.storagesConfiguration);\n\n            _.each(this.storagesNamespace, function (name) {\n                this.storagesConfiguration[name].requestConfig = _.extend(\n                    utils.copy(this.requestConfig),\n                    this.storagesConfiguration[name].requestConfig\n                );\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare date in UTC format (in GMT), and calculate unix timestamp based in seconds\n         *\n         * @returns {Number}\n         * @private\n         */\n        getUtcTime: function () {\n            return new Date().getTime() / 1000;\n        },\n\n        /**\n         * Initializes listeners to storages \"data\" property.\n         */\n        initUpdateStorageDataListener: function () {\n            _.each(this.storagesNamespace, function (name) {\n                if (this[name].data) {\n                    this[name].data.subscribe(this.updateDataHandler.bind(this, name));\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Handlers for storages \"data\" property\n         */\n        updateDataHandler: function (name, data) {\n            var previousData = this[name].previous ? this[name].previous.get() : false;\n\n            if (!_.isEmpty(previousData) &&\n                !_.isEmpty(data) &&\n                !utils.compare(data, previousData).equal) {\n                this[name].set(data);\n                this[name].previous.set(data);\n                this.sendRequest(name, data);\n            } else if (\n                _.isEmpty(previousData) &&\n                !_.isEmpty(data)\n            ) {\n                this[name].set(data);\n                this.sendRequest(name, data);\n            }\n        },\n\n        /**\n         * Gets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        getLastUpdate: function (name) {\n            return window.localStorage.getItem(this[name].namespace + '_last_update');\n        },\n\n        /**\n         * Sets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        setLastUpdate: function (name) {\n            window.localStorage.setItem(this[name].namespace + '_last_update', this.getUtcTime());\n        },\n\n        /**\n         * Request handler\n         *\n         * @param {String} name - storage name\n         */\n        requestHandler: function (name) {\n            this.setLastUpdate(name);\n            this.requestSent = 1;\n        },\n\n        /**\n         * Sends request to server to gets data\n         *\n         * @param {String} name - storage name\n         * @param {Object} data - ids\n         */\n        sendRequest: function (name, data) {\n            var params  = utils.copy(this.storagesConfiguration[name].requestConfig),\n                url = params.syncUrl,\n                typeId = params.typeId;\n\n            if (this.requestSent || !~~this.storagesConfiguration[name].allowToSendRequest) {\n                return;\n            }\n\n            delete params.typeId;\n            delete params.url;\n            this.requestSent = 1;\n\n            return utils.ajaxSubmit({\n                url: url,\n                data: {\n                    ids: data,\n                    'type_id': typeId\n                }\n            }, params).done(this.requestHandler.bind(this, name));\n        }\n    });\n});\n","Magento_Catalog/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids-resolver',\n    'Magento_Catalog/js/product/view/product-info-resolver',\n    'jquery-ui-modules/widget'\n], function ($, $t, _, idsResolver, productInfoResolver) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: '',\n            productInfoResolver: productInfoResolver\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n            $(this.options.addToCartButtonSelector).prop('disabled', false);\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            if (this.element.data('catalog-addtocart-initialized')) {\n                return;\n            }\n\n            this.element.data('catalog-addtocart-initialized', 1);\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @private\n         */\n        _redirect: function (url) {\n            var urlParts, locationParts, forceReload;\n\n            urlParts = url.split('#');\n            locationParts = window.location.href.split('#');\n            forceReload = urlParts[0] === locationParts[0];\n\n            window.location.assign(url);\n\n            if (forceReload) {\n                window.location.reload();\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {jQuery} form\n         */\n        submitForm: function (form) {\n            this.ajaxSubmit(form);\n        },\n\n        /**\n         * @param {jQuery} form\n         */\n        ajaxSubmit: function (form) {\n            var self = this,\n                productIds = idsResolver(form),\n                productInfo = self.options.productInfoResolver(form),\n                formData;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n            formData = new FormData(form[0]);\n\n            $.ajax({\n                url: form.prop('action'),\n                data: formData,\n                type: 'post',\n                dataType: 'json',\n                cache: false,\n                contentType: false,\n                processData: false,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0 &&\n                            window.location.href.split(/[?#]/)[0] === res.backUrl\n                        ) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n\n                        self._redirect(res.backUrl);\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                },\n\n                /** @inheritdoc */\n                error: function (res) {\n                    $(document).trigger('ajax:addToCart:error', {\n                        'sku': form.data().productSku,\n                        'productIds': productIds,\n                        'productInfo': productInfo,\n                        'form': form,\n                        'response': res\n                    });\n                },\n\n                /** @inheritdoc */\n                complete: function (res) {\n                    if (res.state() === 'rejected') {\n                        location.reload();\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.prop('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.prop('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.prop('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});\n","Magento_Catalog/js/view/compare-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'underscore',\n    'mage/mage',\n    'mage/decorate'\n], function (Component, customerData, $, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        compareProductsReloaded = false;\n\n    /**\n     * Initialize sidebar\n     */\n    function initSidebar() {\n        if (sidebarInitialized) {\n            return;\n        }\n\n        sidebarInitialized = true;\n        $('[data-role=compare-products-sidebar]').decorate('list', true);\n    }\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.compareProducts = customerData.get('compare-products');\n            if (!compareProductsReloaded\n                && !_.isEmpty(this.compareProducts())\n                //Expired section names are reloaded on page load\n                && _.indexOf(customerData.getExpiredSectionNames(), 'compare-products') === -1\n                && window.checkout\n                && window.checkout.websiteId\n                && window.checkout.websiteId !== this.compareProducts().websiteId\n            ) {\n                //set count to 0 to prevent \"compared products\" blocks and count to show with wrong count and items\n                this.compareProducts().count = 0;\n                customerData.reload(['compare-products'], false);\n                compareProductsReloaded = true;\n            }\n            initSidebar();\n        }\n    });\n});\n","Magento_Catalog/js/view/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.template = window.checkout.imageTemplate || this.template;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/view/product-ids-resolver'\n], function (_, $, utils, Element, storage, customerData, productResolver) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: ''\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                customerDataProvider: 'product_data_storage',\n                updateRequestConfig: {\n                    url: '',\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            },\n            ids: {},\n            listens: {\n                ids: 'idsHandler'\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('ids');\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage handler.\n         *\n         * @param {Object} idsStorage\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.productStorage = storage.createStorage(this.productStorageConfig);\n            this.productStorage.data.subscribe(this.dataCollectionHandler.bind(this));\n\n            if (~~this.idsStorage.allowToSendRequest) {\n                customerData.reload([idsStorage.namespace]).done(this._resolveDataByIds.bind(this));\n            } else {\n                this._resolveDataByIds();\n            }\n        },\n\n        /**\n         * Callback, which load by ids from ids-storage product data\n         *\n         * @private\n         */\n        _resolveDataByIds: function () {\n            if (!window.checkout || !window.checkout.baseUrl) {\n                // We need data that the minicart provdes to determine storeId/websiteId\n                return;\n            }\n\n            this.initIdsListener();\n            this.idsMerger(\n                this.idsStorage.get(),\n                this.prepareDataFromCustomerData(customerData.get(this.identifiersConfig.namespace)())\n            );\n\n            if (!_.isEmpty(this.productStorage.data())) {\n                this.dataCollectionHandler(this.productStorage.data());\n            } else {\n                this.productStorage.setIds(this.data.currency, this.data.store, this.ids());\n            }\n        },\n\n        /**\n         * Init ids storage listener.\n         */\n        initIdsListener: function () {\n            customerData.get(this.identifiersConfig.namespace).subscribe(function (data) {\n                this.idsMerger(this.prepareDataFromCustomerData(data));\n            }.bind(this));\n            this.idsStorage.data.subscribe(this.idsMerger.bind(this));\n        },\n\n        /**\n         * Prepare data from customerData.\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        prepareDataFromCustomerData: function (data) {\n            data = data.items ? data.items : data;\n\n            return data;\n        },\n\n        /**\n         * Filter ids by their lifetime in order to show only hot ids :)\n         *\n         * @param {Object} ids\n         * @returns {Array}\n         */\n        filterIds: function (ids) {\n            var _ids = {},\n                currentTime = new Date().getTime() / 1000,\n                currentProductIds = productResolver($('#product_addtocart_form')),\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                    window.checkout.websiteId;\n\n            _.each(ids, function (id, key) {\n                if (\n                    currentTime - ids[key]['added_at'] < ~~this.idsStorage.lifetime &&\n                    !_.contains(currentProductIds, ids[key]['product_id']) &&\n                    (!id.hasOwnProperty('scope_id') || ids[key]['scope_id'] === scopeId)\n                ) {\n                    _ids[id['product_id']] = id;\n\n                }\n            }, this);\n\n            return _ids;\n        },\n\n        /**\n         * Merges id from storage and customer data\n         *\n         * @param {Object} data\n         * @param {Object} optionalData\n         */\n        idsMerger: function (data, optionalData) {\n            if (data && optionalData) {\n                data = _.extend(data, optionalData);\n            }\n\n            if (!_.isEmpty(data)) {\n                this.ids(\n                    this.filterIds(_.extend(this.ids(), data))\n                );\n            }\n        },\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, data);\n        },\n\n        /**\n         * Process data\n         *\n         * @param {Object} data\n         */\n        processData: function (data) {\n            var curData = utils.copy(this.data),\n                ids = this.ids();\n\n            delete data['data_id'];\n            data = _.values(data);\n\n            _.each(data, function (record, index) {\n                record._rowIndex = index;\n                record['added_at'] = ids[record.id]['added_at'];\n            }, this);\n\n            curData.items = data;\n            this.set('data', curData);\n        },\n\n        /**\n         * Product storage data handler\n         *\n         * @param {Object} data\n         */\n        dataCollectionHandler: function (data) {\n            data = this.filterData(data);\n            this.processData(data);\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.ids()),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider-compared.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './provider',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, Provider, storage, customerData) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, this.dataFilter(data));\n        },\n\n        /**\n         * Filters data by provider\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        dataFilter: function (data) {\n            var providerData = this.idsStorage.prepareData(customerData.get(this.identifiersConfig.provider)().items),\n                result = {},\n                productCurrentScope,\n                scopeId;\n\n            if (typeof this.data.productCurrentScope !== 'undefined' && window.checkout && window.checkout.baseUrl) {\n                productCurrentScope = this.data.productCurrentScope;\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n                _.each(data, function (value, key) {\n                    if (!providerData[productCurrentScope + '-' + scopeId + '-' + key]) {\n                        result[key] = value;\n                    }\n                });\n            } else {\n                _.each(data, function (value, key) {\n                    if (!providerData[key]) {\n                        result[key] = value;\n                    }\n                });\n            }\n\n            return result;\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.dataFilter(this.ids())),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/remaining-characters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.remainingCharacters', {\n        options: {\n            remainingText: $t('remaining'),\n            tooManyText: $t('too many'),\n            errorClass: 'mage-error',\n            noDisplayClass: 'no-display'\n        },\n\n        /**\n         * Initializes custom option component\n         *\n         * @private\n         */\n        _create: function () {\n            this.note = $(this.options.noteSelector);\n            this.counter = $(this.options.counterSelector);\n\n            this.updateCharacterCount();\n            this.element.on('change keyup paste', this.updateCharacterCount.bind(this));\n        },\n\n        /**\n         * Updates counter message\n         */\n        updateCharacterCount: function () {\n            var length = this.element.val().length,\n                diff = this.options.maxLength - length;\n\n            this.counter.text(this._formatMessage(diff));\n            this.counter.toggleClass(this.options.noDisplayClass, length === 0);\n            this.note.toggleClass(this.options.errorClass, diff < 0);\n        },\n\n        /**\n         * Format remaining characters message\n         *\n         * @param {int} diff\n         * @returns {String}\n         * @private\n         */\n        _formatMessage: function (diff) {\n            var count = Math.abs(diff),\n                qualifier = diff < 0 ? this.options.tooManyText : this.options.remainingText;\n\n            return '(' + count + ' ' + qualifier + ')';\n        }\n    });\n\n    return $.mage.remainingCharacters;\n});\n","Magento_Catalog/js/product/query-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'underscore'\n    ], function (_) {\n        'use strict';\n\n        return {\n\n            /**\n             * Build query to get id\n             *\n             * @param {Object} data\n             */\n            buildQuery: function (data) {\n                var filters = [];\n\n                _.each(data, function (value, key) {\n                    filters.push({\n                        field: key,\n                        value: value,\n                        'condition_type': 'in'\n                    });\n                });\n\n                return {\n                    searchCriteria: {\n                        filterGroups: [\n                            {\n                                filters: filters\n                            }\n                        ]\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Catalog/js/product/uenc-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n        'use strict';\n\n        /**\n         * Check data to JSON.\n         *\n         * @returns {Boolean}\n         */\n        function _isJSON(data) {\n            try {\n                JSON.parse(data);\n            } catch (e) {\n                return false;\n            }\n\n            return true;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _stringProcessor(data, placeholder, uenc) {\n            if (data && ~data.indexOf(placeholder)) {\n                return data.replace(placeholder, uenc);\n            }\n\n            return data;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _objectProcessor(data, placeholder, uenc) {\n            data = JSON.parse(data);\n\n            if (data.hasOwnProperty('action')) {\n                data.action = _stringProcessor(data.action, placeholder, uenc);\n            }\n\n            if (data.hasOwnProperty('data') && data.data.hasOwnProperty('uenc')) {\n                data.data.uenc = uenc;\n            }\n\n            return JSON.stringify(data);\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         *\n         * @returns {String}\n         */\n        return function (data, placeholder) {\n            var uenc = btoa(window.location.href).replace('+/=', '-_,');\n\n            placeholder = placeholder || encodeURI('%uenc%');\n\n            return _isJSON(data) ?\n                _objectProcessor(data, placeholder, uenc) :\n                _stringProcessor(data, placeholder, uenc);\n\n        };\n    }\n);\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.breadcrumbs', widget, {\n            options: {\n                categoryUrlSuffix: '',\n                useCategoryPathInUrl: false,\n                product: '',\n                categoryItemSelector: '.category-item',\n                menuContainer: '[data-action=\"navigation\"] > ul'\n            },\n\n            /** @inheritdoc */\n            _render: function () {\n                this._appendCatalogCrumbs();\n                this._super();\n            },\n\n            /**\n             * Append category and product crumbs.\n             *\n             * @private\n             */\n            _appendCatalogCrumbs: function () {\n                var categoryCrumbs = this._resolveCategoryCrumbs();\n\n                categoryCrumbs.forEach(function (crumbInfo) {\n                    breadcrumbList.push(crumbInfo);\n                });\n\n                if (this.options.product) {\n                    breadcrumbList.push(this._getProductCrumb());\n                }\n            },\n\n            /**\n             * Resolve categories crumbs.\n             *\n             * @return Array\n             * @private\n             */\n            _resolveCategoryCrumbs: function () {\n                var menuItem = this._resolveCategoryMenuItem(),\n                    categoryCrumbs = [];\n\n                if (menuItem !== null && menuItem.length) {\n                    categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n\n                    while ((menuItem = this._getParentMenuItem(menuItem)) !== null) {\n                        categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n                    }\n                }\n\n                return categoryCrumbs;\n            },\n\n            /**\n             * Returns crumb data.\n             *\n             * @param {Object} menuItem\n             * @return {Object}\n             * @private\n             */\n            _getCategoryCrumb: function (menuItem) {\n                return {\n                    'name': 'category',\n                    'label': menuItem.text(),\n                    'link': menuItem.attr('href'),\n                    'title': ''\n                };\n            },\n\n            /**\n             * Returns product crumb.\n             *\n             * @return {Object}\n             * @private\n             */\n            _getProductCrumb: function () {\n                return {\n                    'name': 'product',\n                    'label': this.options.product,\n                    'link': '',\n                    'title': ''\n                };\n            },\n\n            /**\n             * Find parent menu item for current.\n             *\n             * @param {Object} menuItem\n             * @return {Object|null}\n             * @private\n             */\n            _getParentMenuItem: function (menuItem) {\n                var classes,\n                    classNav,\n                    parentClass,\n                    parentMenuItem = null;\n\n                if (!menuItem) {\n                    return null;\n                }\n\n                classes = menuItem.parent().attr('class');\n                classNav = classes.match(/(nav\\-)[0-9]+(\\-[0-9]+)+/gi);\n\n                if (classNav) {\n                    classNav = classNav[0];\n                    parentClass = classNav.substr(0, classNav.lastIndexOf('-'));\n\n                    if (parentClass.lastIndexOf('-') !== -1) {\n                        parentMenuItem = $(this.options.menuContainer).find('.' + parentClass + ' > a');\n                        parentMenuItem = parentMenuItem.length ? parentMenuItem : null;\n                    }\n                }\n\n                return parentMenuItem;\n            },\n\n            /**\n             * Returns category menu item.\n             *\n             * Tries to resolve category from url or from referrer as fallback and\n             * find menu item from navigation menu by category url.\n             *\n             * @return {Object|null}\n             * @private\n             */\n            _resolveCategoryMenuItem: function () {\n                var categoryUrl = this._resolveCategoryUrl(),\n                    menu = $(this.options.menuContainer),\n                    categoryMenuItem = null;\n\n                if (categoryUrl && menu.length) {\n                    categoryMenuItem = menu.find(\n                        this.options.categoryItemSelector +\n                        ' > a[href=\"' + categoryUrl + '\"]'\n                    );\n                }\n\n                return categoryMenuItem;\n            },\n\n            /**\n             * Returns category url.\n             *\n             * @return {String}\n             * @private\n             */\n            _resolveCategoryUrl: function () {\n                var categoryUrl;\n\n                if (this.options.useCategoryPathInUrl) {\n                    // In case category path is used in product url - resolve category url from current url.\n                    categoryUrl = window.location.href.split('?')[0];\n                    categoryUrl = categoryUrl.substring(0, categoryUrl.lastIndexOf('/')) +\n                        this.options.categoryUrlSuffix;\n                } else {\n                    // In other case - try to resolve it from referrer (without parameters).\n                    categoryUrl = document.referrer;\n\n                    if (categoryUrl.indexOf('?') > 0) {\n                        categoryUrl = categoryUrl.substr(0, categoryUrl.indexOf('?'));\n                    }\n                }\n\n                return categoryUrl;\n            }\n        });\n\n        return $.mage.breadcrumbs;\n    };\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/ids-storage-compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/storage/ids-storage'\n], function (_, ko, utils, customerData, idsStorage) {\n    'use strict';\n\n    return _.extend(utils.copy(idsStorage), {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorageCompare',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            if (this.provider && window.checkout && window.checkout.baseUrl) {\n                this.providerDataHandler(customerData.get(this.provider)());\n                this.initProviderListener();\n            }\n\n            this.initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes listener for external data provider\n         */\n        initProviderListener: function () {\n            customerData.get(this.provider).subscribe(this.providerDataHandler.bind(this));\n        },\n\n        /**\n         * Initializes handler for external data provider update\n         *\n         * @param {Object} data\n         */\n        providerDataHandler: function (data) {\n            data = data.items || data;\n            data = this.prepareData(data);\n\n            this.add(data);\n        },\n\n        /**\n         * Prepares data to correct interface\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} data\n         */\n        prepareData: function (data) {\n            var result = {},\n                scopeId;\n\n            _.each(data, function (item) {\n                if (typeof item.productScope !== 'undefined') {\n                    scopeId = item.productScope === 'store' ? window.checkout.storeId :\n                        item.productScope === 'group' ? window.checkout.storeGroupId :\n                            window.checkout.websiteId;\n\n                    result[item.productScope + '-' + scopeId + '-' + item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id,\n                        'scope_id': scopeId\n                    };\n                } else {\n                    result[item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id\n                    };\n                }\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/storage-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Catalog/js/product/storage/ids-storage',\n    'Magento_Catalog/js/product/storage/data-storage',\n    'Magento_Catalog/js/product/storage/ids-storage-compare'\n], function ($, _, utils, $t, IdsStorage, DataStore, IdsStorageCompare) {\n    'use strict';\n\n    return (function () {\n\n        var /**\n             * {Object} storages - list of storages\n             */\n            storages = {},\n\n            /**\n             * {Object} classes - list of classes\n             */\n            classes = {},\n\n            /**\n             * {Object} prototype - methods that will be added to all storage classes to prototype property.\n             */\n            prototype = {\n\n                /**\n                 * Sets data to storage\n                 *\n                 * @param {*} data\n                 */\n                set: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(data);\n                    }\n                },\n\n                /**\n                 * Adds some data to current storage data\n                 *\n                 * @param {*} data\n                 */\n                add: function (data) {\n                    if (!_.isEmpty(data)) {\n                        this.data(_.extend(utils.copy(this.data()), data));\n                    }\n                },\n\n                /**\n                 * Gets current storage data\n                 *\n                 * @returns {*} data\n                 */\n                get: function () {\n                    return this.data();\n                }\n            },\n\n            /**\n             * Required properties to storage\n             */\n            storagesInterface =  {\n                data: 'function',\n                initialize: 'function',\n                namespace: 'string'\n            },\n\n            /**\n             * Private service methods\n             */\n            _private = {\n\n                /**\n                 * Overrides class method and add ability use _super to call parent method\n                 *\n                 * @param {Object} extensionMethods\n                 * @param {Object} originInstance\n                 */\n                overrideClassMethods: function (extensionMethods, originInstance) {\n                    var methodsName = _.keys(extensionMethods),\n                        i = 0,\n                        length = methodsName.length;\n\n                    for (i; i < length; i++) {\n                        if (_.isFunction(originInstance[methodsName[i]])) {\n                            originInstance[methodsName[i]] = extensionMethods[methodsName[i]];\n                        }\n                    }\n\n                    return originInstance;\n                },\n\n                /**\n                 * Checks is storage implement interface\n                 *\n                 * @param {Object} classInstance\n                 *\n                 * @returns {Boolean}\n                 */\n                isImplementInterface: function (classInstance) {\n                    _.each(storagesInterface, function (key, value) {\n                        if (typeof classInstance[key] !== value) {\n                            return false;\n                        }\n                    });\n\n                    return true;\n                }\n            },\n\n            /**\n             * Subscribers list\n             */\n            subsctibers = {};\n\n        (function () {\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorage.name] = function (config) {\n                _.extend(this, IdsStorage, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorageCompare.name] = function (config) {\n                _.extend(this, IdsStorageCompare, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[DataStore.name] = function (config) {\n                _.extend(this, DataStore, config);\n            };\n\n            _.each(classes, function (classItem) {\n                classItem.prototype = prototype;\n            });\n        })();\n\n        return {\n\n            /**\n             * Creates new storage or returns if storage with declared namespace exist\n             *\n             * @param {Object} config - storage config\n             * @throws {Error}\n             * @returns {Object} storage instance\n             */\n            createStorage: function (config) {\n                var instance,\n                    initialized;\n\n                if (storages[config.namespace]) {\n                    return storages[config.namespace];\n                }\n\n                instance = new classes[config.className](config);\n\n                if (_private.isImplementInterface(instance)) {\n                    initialized = storages[config.namespace] = instance.initialize();\n                    this.processSubscribers(initialized, config);\n\n                    return initialized;\n                }\n\n                throw new Error('Class ' + config.className + $t('does not implement Storage Interface'));\n            },\n\n            /**\n             * Process subscribers\n             *\n             * Differentiate subscribers by their namespaces: recently_viewed or recently_compared\n             * and process callbacks. Callbacks can be add through onStorageInit function\n             *\n             * @param {Object} initialized\n             * @param {Object} config\n             * @return void\n             */\n            processSubscribers: function (initialized, config) {\n                if (subsctibers[config.namespace]) {\n                    _.each(subsctibers[config.namespace], function (callback) {\n                        callback(initialized);\n                    });\n\n                    delete subsctibers[config.namespace];\n                }\n            },\n\n            /**\n             * Listens storage creating by namespace\n             *\n             * @param {String} namespace\n             * @param {Function} callback\n             * @return void\n             */\n            onStorageInit: function (namespace, callback) {\n                if (storages[namespace]) {\n                    callback(storages[namespace]);\n                } else {\n                    subsctibers[namespace] ?\n                        subsctibers[namespace].push(callback) :\n                        subsctibers[namespace] = [callback];\n                }\n            },\n\n            /**\n             * Gets storage by namespace\n             *\n             * @param {String} namespace\n             *\n             * @returns {Object} storage insance\n             */\n            getStorage: function (namespace) {\n                return storages[namespace];\n            }\n        };\n    })();\n});\n\n","Magento_Catalog/js/product/storage/ids-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils) {\n    'use strict';\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorage',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initCustomerDataReloadListener()\n                .initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        },\n\n        /**\n         * Initializes listener to \"data\" property\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.internalDataHandler.bind(this));\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-reload', function (event, sections) {\n                if ((_.isEmpty(sections) || _.contains(sections, this.namespace)) && ~~this.allowToSendRequest) {\n                    this.localStorage.removeAll();\n                    this.data();\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes handler to \"data\" property update\n         */\n        internalDataHandler: function (data) {\n            setLocalStorageItem(this.namespace, data);\n        },\n\n        /**\n         * Initializes handler to storage update\n         */\n        externalDataHandler: function (data) {\n            data = data.items ? data.items : data;\n\n            this.set(_.extend(utils.copy(this.data()), data));\n        }\n    };\n});\n\n","Magento_Catalog/js/product/storage/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Catalog/js/product/query-builder',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils, queryBuilder, customerData) {\n    'use strict';\n\n    /**\n     * Process data from API request\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function getParsedDataFromServer(data) {\n        var result = {};\n\n        _.each(data.items, function (item) {\n                if (item.id) {\n                    result[item.id] = item;\n                }\n            }\n        );\n\n        return {\n            items: result\n        };\n    }\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'DataStorage',\n        request: {},\n        customerDataProvider: 'product_data_storage',\n\n        /**\n         * Initialize class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initLocalStorage()\n                .initCustomerDataReloadListener()\n                .cachesDataFromLocalStorage()\n                .initDataListener()\n                .initProvideStorage()\n                .initProviderListener();\n\n            return this;\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-invalidate', this._flushProductStorage.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Flush product storage\n         *\n         * @private\n         * @return void\n         */\n        _flushProductStorage: function (event, sections) {\n            if (_.isEmpty(sections) || _.contains(sections, 'product_data_storage')) {\n                this.localStorage.removeAll();\n            }\n        },\n\n        /**\n         * Initialize listener to data property\n         *\n         * @return Chainable.\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.dataHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize provider storage\n         *\n         * @return Chainable.\n         */\n        initProvideStorage: function () {\n            this.providerHandler(customerData.get(this.customerDataProvider)());\n\n            return this;\n        },\n\n        /**\n         * Handler to update \"data\" property.\n         * Sets data to localStorage\n         *\n         * @param {Object} data\n         */\n        dataHandler: function (data) {\n            if (_.isEmpty(data)) {\n                this.localStorage.removeAll();\n            } else {\n                setLocalStorageItem(this.namespace, data);\n            }\n        },\n\n        /**\n         * Handler to update data in provider.\n         *\n         * @param {Object} data\n         */\n        providerHandler: function (data) {\n            var currentData = utils.copy(this.data()),\n                ids = _.keys(data.items);\n\n            if (data.items && ids.length) {\n                //we can extend only items\n                data = data.items;\n                this.data(_.extend(data, currentData));\n            }\n        },\n\n        /**\n         * Sets data ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         */\n        setIds: function (currency, store, ids) {\n            if (!this.hasInCache(currency, store, ids)) {\n                this.loadDataFromServer(currency, store, ids);\n            } else {\n                this.data.valueHasMutated();\n            }\n        },\n\n        /**\n         * Gets data from \"data\" property by identifiers\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} productIdentifiers\n         *\n         * @return {Object} data.\n         */\n        getDataByIdentifiers: function (currency, store, productIdentifiers) {\n            var data = {},\n                dataCollection = this.data(),\n                id;\n\n            for (id in productIdentifiers) {\n                if (productIdentifiers.hasOwnProperty(id)) {\n                    data[id] = dataCollection[id];\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Checks has cached data or not\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return {Boolean}\n         */\n        hasInCache: function (currency, store, ids) {\n            var data = this.data(),\n                id;\n\n            for (id in ids) {\n                if (!data.hasOwnProperty(id) ||\n                    data[id]['currency_code'] !== currency ||\n                    ~~data[id]['store_id'] !== ~~store\n                ) {\n                    return false;\n                }\n            }\n\n            return true;\n        },\n\n        /**\n         * Load data from server by ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return void\n         */\n        loadDataFromServer: function (currency, store, ids) {\n            var idsArray = _.keys(ids),\n                prepareAjaxParams = {\n                    'entity_id': idsArray.join(',')\n                };\n\n            if (this.request.sent && this.hasIdsInSentRequest(ids)) {\n                return;\n            }\n\n            this.request = {\n                sent: true,\n                data: ids\n            };\n\n            this.updateRequestConfig.data = queryBuilder.buildQuery(prepareAjaxParams);\n            this.updateRequestConfig.data['store_id'] = store;\n            this.updateRequestConfig.data['currency_code'] = currency;\n            $.ajax(this.updateRequestConfig).done(function (data) {\n                this.request = {};\n                this.providerHandler(getParsedDataFromServer(data));\n            }.bind(this));\n        },\n\n        /**\n         * Each product page consist product cache data,\n         * this function prepare those data to appropriate view, and save it\n         *\n         * @param {Object} data\n         */\n        addDataFromPageCache: function (data) {\n            this.providerHandler(getParsedDataFromServer(data));\n        },\n\n        /**\n         * @param {Object} ids\n         * @returns {Boolean}\n         */\n        hasIdsInSentRequest: function (ids) {\n            var sentDataIds,\n                currentDataIds;\n\n            if (this.request.data) {\n                sentDataIds = _.keys(this.request.data);\n                currentDataIds = _.keys(ids);\n\n                _.each(currentDataIds, function (id) {\n                    if (_.lastIndexOf(sentDataIds, id) === -1) {\n                        return false;\n                    }\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Initialize provider listener\n         *\n         * @return Chainable.\n         */\n        initProviderListener: function () {\n            customerData.get(this.customerDataProvider).subscribe(this.providerHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        }\n    };\n});\n","Magento_Catalog/js/product/view/product-info.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/view/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service'\n], function (_, Element, storage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: 'recently_viewed_product'\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                updateRequestConfig: {\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            }\n        },\n\n        /**\n         * Initializes\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (window.checkout && window.checkout.baseUrl) {\n                this.initIdsStorage();\n            }\n\n            this.initDataStorage();\n\n            return this;\n        },\n\n        /**\n         * Init ids storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initDataStorage: function () {\n            storage.onStorageInit(this.productStorageConfig.namespace, this.dataStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage handler\n         *\n         * @param {Object} dataStorage - storage instance\n         */\n        dataStorageHandler: function (dataStorage) {\n            this.productStorage = dataStorage;\n            this.productStorage.add(this.data.items);\n        },\n\n        /**\n         * Init ids storage handler\n         *\n         * @param {Object} idsStorage - storage instance\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.idsStorage.add(this.getIdentifiers());\n        },\n\n        /**\n         * Gets ids from items\n         *\n         * @returns {Object}\n         */\n        getIdentifiers: function () {\n            var result = {},\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n\n            _.each(this.data.items, function (item, key) {\n                result[productCurrentScope + '-' + scopeId + '-' + key] = {\n                    'added_at': new Date().getTime() / 1000,\n                    'product_id': key,\n                    'scope_id': scopeId\n                };\n            }, this);\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/view/product-info-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-info'\n], function (_, productInfo) {\n    'use strict';\n\n    /**\n     * Returns info about products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var product = _.findWhere($form.serializeArray(), {\n                name: 'product'\n            });\n\n        if (!_.isUndefined(product)) {\n            productInfo().push(\n                {\n                    'id': product.value\n                }\n            );\n        }\n\n        return _.uniq(productInfo(), function (item) {\n            return item.id;\n        });\n    };\n});\n\n","Magento_Catalog/js/product/view/product-ids-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids'\n], function (_, productIds) {\n    'use strict';\n\n    /**\n     * Returns id's of products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var idSet = productIds(),\n            product = _.findWhere($form.serializeArray(), {\n            name: 'product'\n        });\n\n        if (!_.isUndefined(product)) {\n            idSet.push(product.value);\n        }\n\n        return _.uniq(idSet);\n    };\n});\n","Magento_Catalog/js/product/view/product-ids.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    /**\n     * ProductListToolbarForm Widget - this widget is setting cookie and submitting form according to toolbar controls\n     */\n    $.widget('mage.productListToolbarForm', {\n\n        options: {\n            modeControl: '[data-role=\"mode-switcher\"]',\n            directionControl: '[data-role=\"direction-switcher\"]',\n            orderControl: '[data-role=\"sorter\"]',\n            limitControl: '[data-role=\"limiter\"]',\n            mode: 'product_list_mode',\n            direction: 'product_list_dir',\n            order: 'product_list_order',\n            limit: 'product_list_limit',\n            page: 'p',\n            modeDefault: 'grid',\n            directionDefault: 'asc',\n            orderDefault: 'position',\n            limitDefault: '9',\n            url: '',\n            formKey: '',\n            post: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind(\n                $(this.options.modeControl, this.element),\n                this.options.mode,\n                this.options.modeDefault\n            );\n            this._bind(\n                $(this.options.directionControl, this.element),\n                this.options.direction,\n                this.options.directionDefault\n            );\n            this._bind(\n                $(this.options.orderControl, this.element),\n                this.options.order,\n                this.options.orderDefault\n            );\n            this._bind(\n                $(this.options.limitControl, this.element),\n                this.options.limit,\n                this.options.limitDefault\n            );\n        },\n\n        /** @inheritdoc */\n        _bind: function (element, paramName, defaultValue) {\n            if (element.is('select')) {\n                element.on('change', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processSelect, this));\n            } else {\n                element.on('click', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processLink, this));\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processLink: function (event) {\n            event.preventDefault();\n            this.changeUrl(\n                event.data.paramName,\n                $(event.currentTarget).data('value'),\n                event.data.default\n            );\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processSelect: function (event) {\n            this.changeUrl(\n                event.data.paramName,\n                event.currentTarget.options[event.currentTarget.selectedIndex].value,\n                event.data.default\n            );\n        },\n\n        /**\n         * @private\n         */\n        getUrlParams: function () {\n            var decode = window.decodeURIComponent,\n                urlPaths = this.options.url.split('?'),\n                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                params = {},\n                parameters, i;\n\n            for (i = 0; i < urlParams.length; i++) {\n                parameters = urlParams[i].split('=');\n                params[decode(parameters[0])] = parameters[1] !== undefined ?\n                    decode(parameters[1].replace(/\\+/g, '%20')) :\n                    '';\n            }\n\n            return params;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentLimit: function () {\n            return this.getUrlParams()[this.options.limit] || this.options.limitDefault;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentPage: function () {\n            return this.getUrlParams()[this.options.page] || 1;\n        },\n\n        /**\n         * @param {String} paramName\n         * @param {*} paramValue\n         * @param {*} defaultValue\n         */\n        changeUrl: function (paramName, paramValue, defaultValue) {\n            var urlPaths = this.options.url.split('?'),\n                baseUrl = urlPaths[0],\n                paramData = this.getUrlParams(),\n                currentPage = this.getCurrentPage(),\n                form, params, key, input, formKey, newPage;\n\n            if (currentPage > 1 && paramName === this.options.mode) {\n                delete paramData[this.options.page];\n            }\n\n            if (currentPage > 1 && paramName === this.options.limit) {\n                newPage = Math.floor(this.getCurrentLimit() * (currentPage - 1) / paramValue) + 1;\n\n                if (newPage > 1) {\n                    paramData[this.options.page] = newPage;\n                } else {\n                    delete paramData[this.options.page];\n                }\n            }\n\n            paramData[paramName] = paramValue;\n\n            if (this.options.post) {\n                form = document.createElement('form');\n                params = [this.options.mode, this.options.direction, this.options.order, this.options.limit];\n\n                for (key in paramData) {\n                    if (params.indexOf(key) !== -1) { //eslint-disable-line max-depth\n                        input = document.createElement('input');\n                        input.name = key;\n                        input.value = paramData[key];\n                        form.appendChild(input);\n                        delete paramData[key];\n                    }\n                }\n                formKey = document.createElement('input');\n                formKey.name = 'form_key';\n                formKey.value = this.options.formKey;\n                form.appendChild(formKey);\n\n                paramData = $.param(paramData);\n                baseUrl += paramData.length ? '?' + paramData : '';\n\n                form.action = baseUrl;\n                form.method = 'POST';\n                document.body.appendChild(form);\n                form.submit();\n            } else {\n                if (paramValue == defaultValue) { //eslint-disable-line eqeqeq\n                    delete paramData[paramName];\n                }\n\n                paramData = $.param(paramData);\n                location.href = baseUrl + (paramData.length ? '?' + paramData : '');\n            }\n        }\n    });\n\n    return $.mage.productListToolbarForm;\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPriceUnsanitizedHtml: function (row) {\n            return this.getPrice(row);\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPriceUnsanitizedHtml: function (row) {\n            return this.getRegularPrice(row);\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPriceUnsanitizedHtml: function (row) {\n            return this.getMinimalPrice(row);\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPriceUnsanitizedHtml: function (row) {\n            return this.getMaxPrice(row);\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMaxRegularPrice(row);\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMinRegularPrice(row);\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPriceAmount\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmountUnsanitizedHtml: function (row) {\n            return this.getMinimalPriceAmount(row);\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/product/view/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            radioCheckboxClosest: 'ul, ol',\n\n            /**\n             * @param {*} error\n             * @param {HTMLElement} element\n             */\n            errorPlacement: function (error, element) {\n                var messageBox,\n                    dataValidate;\n\n                if ($(element).hasClass('datetime-picker')) {\n                    element = $(element).parent();\n\n                    if (element.parent().find('.mage-error').length) {\n                        return;\n                    }\n                }\n\n                if (element.attr('data-errors-message-box')) {\n                    messageBox = $(element.attr('data-errors-message-box'));\n                    messageBox.html(error);\n\n                    return;\n                }\n\n                dataValidate = element.attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-one-checkbox-required-by-name') > 0) {\n                    error.appendTo('#links-advice-container');\n                } else if (element.is(':radio, :checkbox')) {\n                    element.closest(this.radioCheckboxClosest).after(error);\n                } else {\n                    element.after(error);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            highlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').each(function () {\n                        $(this).removeClass(errorClass);\n\n                        if ($(this).val().length === 0) {\n                            $(this).addClass(errorClass);\n                        }\n                    });\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).addClass(errorClass);\n                } else {\n                    $(element).addClass(errorClass);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            unhighlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').removeClass(errorClass);\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).removeClass(errorClass);\n                } else {\n                    $(element).removeClass(errorClass);\n                }\n            }\n        }\n    });\n\n    return $.mage.validation;\n});\n"}
}});
