require.config({"config": {
        "jsbuild":{"Magento_Checkout/js/action/set-payment-information-extended.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n], function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader, _, hooks) {\n    'use strict';\n\n    /**\n     * Filter template data.\n     *\n     * @param {Object|Array} data\n     */\n    var filterTemplateData = function (data) {\n        return _.each(data, function (value, key, list) {\n            if (_.isArray(value) || _.isObject(value)) {\n                list[key] = filterTemplateData(value);\n            }\n\n            if (key === '__disableTmpl' || key === 'title') {\n                delete list[key];\n            }\n        });\n    };\n\n    return function (messageContainer, paymentData, skipBilling) {\n        var serviceUrl,\n            payload,\n            headers = {};\n\n        paymentData = filterTemplateData(paymentData);\n        skipBilling = skipBilling || false;\n        payload = {\n            cartId: quote.getQuoteId(),\n            paymentMethod: paymentData\n        };\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n        }\n\n        if (skipBilling === false) {\n            payload.billingAddress = quote.billingAddress();\n        }\n\n        fullScreenLoader.startLoader();\n\n        _.each(hooks.requestModifiers, function (modifier) {\n            modifier(headers, payload);\n        });\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n        ).fail(\n            function (response) {\n                errorProcessor.process(response, messageContainer);\n            }\n        ).always(\n            function () {\n                fullScreenLoader.stopLoader();\n                _.each(hooks.afterRequestListeners, function (listener) {\n                    listener();\n                });\n            }\n        );\n    };\n});\n","Magento_Checkout/js/action/recollect-shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rate-registry'\n], function (quote, selectShippingAddress, rateRegistry) {\n    'use strict';\n\n    return function () {\n        var shippingAddress = null;\n\n        if (!quote.isVirtual()) {\n            shippingAddress = quote.shippingAddress();\n\n            rateRegistry.set(shippingAddress.getCacheKey(), null);\n            selectShippingAddress(shippingAddress);\n        }\n    };\n});\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals'\n], function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n    'use strict';\n\n    return function (callbacks, deferred) {\n        deferred = deferred || $.Deferred();\n        totals.isLoading(true);\n\n        return storage.get(\n            resourceUrlManager.getUrlForCartTotals(quote),\n            false\n        ).done(function (response) {\n            var proceed = true;\n\n            totals.isLoading(false);\n\n            if (callbacks.length > 0) {\n                $.each(callbacks, function (index, callback) {\n                    proceed = proceed && callback();\n                });\n            }\n\n            if (proceed) {\n                quote.setTotals(response);\n                deferred.resolve();\n            }\n        }).fail(function (response) {\n            totals.isLoading(false);\n            deferred.reject();\n            errorProcessor.process(response);\n        }).always(function () {\n            totals.isLoading(false);\n        });\n    };\n});\n","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/place-order'\n], function (quote, urlBuilder, customer, placeOrderService) {\n    'use strict';\n\n    return function (paymentData, messageContainer) {\n        var serviceUrl, payload;\n\n        payload = {\n            cartId: quote.getQuoteId(),\n            billingAddress: quote.billingAddress(),\n            paymentMethod: paymentData\n        };\n\n        if (customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                quoteId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        }\n\n        return placeOrderService(serviceUrl, payload, messageContainer);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingAddress) {\n        quote.shippingAddress(shippingAddress);\n    };\n});\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (paymentMethod) {\n        if (paymentMethod) {\n            paymentMethod.__disableTmpl = {\n                title: true\n            };\n        }\n        quote.paymentMethod(paymentMethod);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingMethod) {\n        quote.shippingMethod(shippingMethod);\n    };\n});\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter'\n], function (addressList, addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData),\n            isAddressUpdated = addressList().some(function (currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) { //eslint-disable-line eqeqeq\n                    addresses[index] = address;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n        if (!isAddressUpdated) {\n            addressList.push(address);\n        } else {\n            addressList.valueHasMutated();\n        }\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (url, fullScreenLoader) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                fullScreenLoader.startLoader();\n                this.redirectToSuccessPage();\n            },\n\n            /**\n             * Redirect to success page.\n             */\n            redirectToSuccessPage: function () {\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/address-converter'\n], function (addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData);\n\n        /**\n         * Returns new customer billing address type.\n         *\n         * @returns {String}\n         */\n        address.getType = function () {\n            return 'new-customer-billing-address';\n        };\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/update-shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function (alert, confirm, $, $t) {\n    'use strict';\n\n    $.widget('mage.updateShoppingCart', {\n        options: {\n            validationURL: '',\n            eventName: 'updateCartItemQty',\n            updateCartActionContainer: '',\n            isCartHasUpdatedContent: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._on(this.element, {\n                'submit': this.onSubmit\n            });\n            this._on('[data-role=cart-item-qty]', {\n                'change': function () {\n                    this.isCartHasUpdatedContent = true;\n                }\n            });\n            this._on('ul.pages-items', {\n                'click a': function (event) {\n                    if (this.isCartHasUpdatedContent) {\n                        event.preventDefault();\n                        this.changePageConfirm($(event.currentTarget).attr('href'));\n                    }\n                }\n            });\n        },\n\n        /**\n         * Show the confirmation popup\n         * @param nextPageUrl\n         */\n        changePageConfirm: function (nextPageUrl) {\n            confirm({\n                title: $t('Are you sure you want to leave the page?'),\n                content: $t('Changes you made to the cart will not be saved.'),\n                actions: {\n                    confirm: function () {\n                        window.location.href = nextPageUrl;\n                    }\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Leave'),\n                    class: 'action-primary action-accept',\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Prevents default submit action and calls form validator.\n         *\n         * @param {Event} event\n         * @return {Boolean}\n         */\n        onSubmit: function (event) {\n            var action = this.element.find(this.options.updateCartActionContainer).val();\n\n            if (!this.options.validationURL || action === 'empty_cart') {\n                return true;\n            }\n\n            if (this.isValid()) {\n                event.preventDefault();\n                this.validateItems(this.options.validationURL, this.element.serialize());\n            }\n\n            return false;\n        },\n\n        /**\n         * Validates requested form.\n         *\n         * @return {Boolean}\n         */\n        isValid: function () {\n            return this.element.validation() && this.element.validation('isValid');\n        },\n\n        /**\n         * Validates updated shopping cart data.\n         *\n         * @param {String} url - request url\n         * @param {Object} data - post data for ajax call\n         */\n        validateItems: function (url, data) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $(document.body).trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $(document.body).trigger('processStop');\n                }\n            })\n                .done(function (response) {\n                    if (response.success) {\n                        this.onSuccess();\n                    } else {\n                        this.onError(response);\n                    }\n                })\n                .fail(function () {\n                    this.submitForm();\n                });\n        },\n\n        /**\n         * Form validation succeed.\n         */\n        onSuccess: function () {\n            $(document).trigger('ajax:' + this.options.eventName);\n            this.submitForm();\n        },\n\n        /**\n         * Form validation failed.\n         */\n        onError: function (response) {\n            var that = this,\n                elm,\n                responseData = [];\n\n            try {\n                responseData = JSON.parse(response['error_message']);\n            } catch (error) {\n            }\n\n            if (response['error_message']) {\n                try {\n                    $.each(responseData, function (index, data) {\n\n                        if (data.itemId !== undefined) {\n                            elm = $('#cart-' + data.itemId + '-qty');\n                            elm.val(elm.attr('data-item-qty'));\n                        }\n                        response['error_message'] = data.error;\n                    });\n                } catch (e) {}\n                alert({\n                    content: response['error_message'],\n                    actions: {\n                        /** @inheritdoc */\n                        always: function () {\n                            that.submitForm();\n                        }\n                    }\n                });\n            } else {\n                this.submitForm();\n            }\n        },\n\n        /**\n         * Real submit of validated form.\n         */\n        submitForm: function () {\n            this.element\n                .off('submit', this.onSubmit)\n                .on('submit', function () {\n                    $(document.body).trigger('processStart');\n                })\n                .trigger('submit');\n        }\n    });\n\n    return $.mage.updateShoppingCart;\n});\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote',\n    'Magento_Checkout/js/model/shipping-save-processor'\n], function (quote, shippingSaveProcessor) {\n    'use strict';\n\n    return function () {\n        return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n    };\n});\n","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/payment-service'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n    'use strict';\n\n    return function (deferred, messageContainer) {\n        var serviceUrl;\n\n        deferred = deferred || $.Deferred();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                cartId: quote.getQuoteId()\n            });\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        }\n\n        return storage.get(\n            serviceUrl, false\n        ).done(function (response) {\n            quote.setTotals(response.totals);\n            paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n            deferred.resolve();\n        }).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n            deferred.reject();\n        });\n    };\n});\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/action/set-payment-information-extended'\n\n], function (setPaymentInformationExtended) {\n    'use strict';\n\n    return function (messageContainer, paymentData) {\n\n        return setPaymentInformationExtended(messageContainer, paymentData, false);\n    };\n});\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/url',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function (url, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} response\n         * @param {Object} messageContainer\n         */\n        process: function (response, messageContainer) {\n            var error;\n\n            messageContainer = messageContainer || globalMessageList;\n\n            if (response.status == 401) { //eslint-disable-line eqeqeq\n                this.redirectTo(url.build('customer/account/login/'));\n            } else {\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = {\n                        message: $t('Something went wrong with your request. Please try again later.')\n                    };\n                }\n                messageContainer.addErrorMessage(error);\n            }\n        },\n\n        /**\n         * Method to redirect by requested URL.\n         */\n        redirectTo: function (redirectUrl) {\n            window.location.replace(redirectUrl);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './shipping-rates-validation-rules',\n    '../model/address-converter',\n    '../action/select-shipping-address',\n    './postcode-validator',\n    './default-validator',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    ko,\n    shippingRatesValidationRules,\n    addressConverter,\n    selectShippingAddress,\n    postcodeValidator,\n    defaultValidator,\n    $t,\n    uiRegistry,\n    formPopUpState\n) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        validators = [],\n        observedElements = [],\n        postcodeElements = [],\n        postcodeElementName = 'postcode';\n\n    validators.push(defaultValidator);\n\n    return {\n        validateAddressTimeout: 0,\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * @param {String} carrier\n         * @param {Object} validator\n         */\n        registerValidator: function (carrier, validator) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                validators.push(validator);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validateAddressData: function (address) {\n            return validators.some(function (validator) {\n                return validator.validate(address);\n            });\n        },\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this,\n                elements = shippingRatesValidationRules.getObservableFields();\n\n            if ($.inArray(postcodeElementName, elements) === -1) {\n                // Add postcode field to observables if not exist for zip code validation support\n                elements.push(postcodeElementName);\n            }\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n            });\n        },\n\n        /**\n         * Bind shipping rates request to form element\n         *\n         * @param {Object} element\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        doElementBinding: function (element, force, delay) {\n            var observableFields = shippingRatesValidationRules.getObservableFields();\n\n            if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                if (element.index !== postcodeElementName) {\n                    this.bindHandler(element, delay);\n                }\n            }\n\n            if (element.index === postcodeElementName) {\n                this.bindHandler(element, delay);\n                postcodeElements.push(element);\n            }\n        },\n\n        /**\n         * @param {*} elements\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        bindChangeHandlers: function (elements, force, delay) {\n            var self = this;\n\n            $.each(elements, function (index, elem) {\n                self.doElementBinding(elem, force, delay);\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    self.bindHandler(elem);\n                });\n            } else {\n                element.on('value', function () {\n                    clearTimeout(self.validateZipCodeTimeout);\n                    self.validateZipCodeTimeout = setTimeout(function () {\n                        if (element.index === postcodeElementName) {\n                            self.postcodeValidation(element);\n                        } else {\n                            $.each(postcodeElements, function (index, elem) {\n                                self.postcodeValidation(elem);\n                            });\n                        }\n                    }, delay);\n\n                    if (!formPopUpState.isVisible()) {\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            self.validateFields();\n                        }, delay);\n                    }\n                });\n                observedElements.push(element);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        },\n\n        /**\n         * Convert form data to quote address and validate fields for shipping rates\n         */\n        validateFields: function () {\n            var addressFlat = addressConverter.formDataProviderToFlatData(\n                this.collectObservedData(),\n                'shippingAddress'\n                ),\n                address;\n\n            if (this.validateAddressData(addressFlat)) {\n                addressFlat = uiRegistry.get('checkoutProvider').shippingAddress;\n                address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                selectShippingAddress(address);\n            }\n        },\n\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                observedValues[field.dataScope] = field.value();\n            });\n\n            return observedValues;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/shipping-save-processor/default'\n], function (defaultProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors['default'] =  defaultProcessor;\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        },\n\n        /**\n         * @param {String} type\n         * @return {Array}\n         */\n        saveShippingInformation: function (type) {\n            var rates = [];\n\n            if (processors[type]) {\n                rates = processors[type].saveShippingInformation();\n            } else {\n                rates = processors['default'].saveShippingInformation();\n            }\n\n            return rates;\n        }\n    };\n});\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, DefaultPostCodeResolver) {\n    'use strict';\n\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now(),\n            countryId = addressData['country_id'] || addressData.countryId || window.checkoutConfig.defaultCountryId,\n            regionId;\n\n        if (addressData.region && addressData.region['region_id']) {\n            regionId = addressData.region['region_id'];\n        } else if (!addressData['region_id']) {\n            regionId = undefined;\n        } else if (\n            /* eslint-disable */\n            addressData['country_id'] && addressData['country_id'] == window.checkoutConfig.defaultCountryId ||\n            !addressData['country_id'] && countryId == window.checkoutConfig.defaultCountryId\n            /* eslint-enable */\n        ) {\n            regionId = window.checkoutConfig.defaultRegionId || undefined;\n        }\n\n        return {\n            email: addressData.email,\n            countryId: countryId,\n            regionId: regionId || addressData.regionId,\n            regionCode: addressData.region ? addressData.region['region_code'] : null,\n            region: addressData.region ? addressData.region.region : null,\n            customerId: addressData['customer_id'] || addressData.customerId,\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : DefaultPostCodeResolver.resolve(),\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: addressData['custom_attributes'],\n            extensionAttributes: addressData['extension_attributes'],\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'new-customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType();\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return true;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n], function (quote, defaultProcessor, customerAddressProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors.default =  defaultProcessor;\n    processors['customer-address'] = customerAddressProcessor;\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (processors[type]) {\n            processors[type].getRates(quote.shippingAddress());\n        } else {\n            processors.default.getRates(quote.shippingAddress());\n        }\n    });\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './default-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/url-builder',\n    'mageUtils'\n], function (customer, urlBuilder, utils) {\n        'use strict';\n\n        return {\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForTotalsEstimationForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/totals-information',\n                        'customer': '/carts/mine/totals-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                        'customer': '/carts/mine/estimate-shipping-methods'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsByAddressId: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} couponCode\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getApplyCouponUrl: function (couponCode, quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/' + encodeURIComponent(couponCode),\n                        'customer': '/carts/mine/coupons/' + encodeURIComponent(couponCode)\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getCancelCouponUrl: function (quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/',\n                        'customer': '/carts/mine/coupons/'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForCartTotals: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/totals',\n                        'customer': '/carts/mine/totals'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForSetShippingInformation: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/shipping-information',\n                        'customer': '/carts/mine/shipping-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * Get url for service.\n             *\n             * @param {*} urls\n             * @param {*} urlParams\n             * @return {String|*}\n             */\n            getUrl: function (urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            /**\n             * @return {String}\n             */\n            getCheckoutMethod: function () {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (ko, checkoutDataResolver) {\n    'use strict';\n\n    var shippingRates = ko.observableArray([]);\n\n    return {\n        isLoading: ko.observable(false),\n\n        /**\n         * Set shipping rates\n         *\n         * @param {*} ratesData\n         */\n        setShippingRates: function (ratesData) {\n            shippingRates(ratesData);\n            shippingRates.valueHasMutated();\n            checkoutDataResolver.resolveShippingRates(ratesData);\n        },\n\n        /**\n         * Get shipping rates\n         *\n         * @returns {*}\n         */\n        getShippingRates: function () {\n            return shippingRates;\n        }\n    };\n});\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    var steps = ko.observableArray();\n\n    return {\n        steps: steps,\n        stepCodes: [],\n        validCodes: [],\n\n        /**\n         * @return {Boolean}\n         */\n        handleHash: function () {\n            var hashString = window.location.hash.replace('#', ''),\n                isRequestedStepVisible;\n\n            if (hashString === '') {\n                return false;\n            }\n\n            if ($.inArray(hashString, this.validCodes) === -1) {\n                window.location.href = window.checkoutConfig.pageNotFoundUrl;\n\n                return false;\n            }\n\n            isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {\n                return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line\n            });\n\n            //if requested step is visible, then we don't need to load step data from server\n            if (isRequestedStepVisible) {\n                return false;\n            }\n\n            steps().sort(this.sortItems).forEach(function (element) {\n                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq\n                    element.navigate(element);\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n\n            return false;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} alias\n         * @param {*} title\n         * @param {Function} isVisible\n         * @param {*} navigate\n         * @param {*} sortOrder\n         */\n        registerStep: function (code, alias, title, isVisible, navigate, sortOrder) {\n            var hash, active;\n\n            if ($.inArray(code, this.validCodes) !== -1) {\n                throw new DOMException('Step code [' + code + '] already registered in step navigator');\n            }\n\n            if (alias != null) {\n                if ($.inArray(alias, this.validCodes) !== -1) {\n                    throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                }\n                this.validCodes.push(alias);\n            }\n            this.validCodes.push(code);\n            steps.push({\n                code: code,\n                alias: alias != null ? alias : code,\n                title: title,\n                isVisible: isVisible,\n                navigate: navigate,\n                sortOrder: sortOrder\n            });\n            active = this.getActiveItemIndex();\n            steps.each(function (elem, index) {\n                if (active !== index) {\n                    elem.isVisible(false);\n                }\n            });\n            this.stepCodes.push(code);\n            hash = window.location.hash.replace('#', '');\n\n            if (hash != '' && hash != code) { //eslint-disable-line eqeqeq\n                //Force hiding of not active step\n                isVisible(false);\n            }\n        },\n\n        /**\n         * @param {Object} itemOne\n         * @param {Object} itemTwo\n         * @return {Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getActiveItemIndex: function () {\n            var activeIndex = 0;\n\n            steps().sort(this.sortItems).some(function (element, index) {\n                if (element.isVisible()) {\n                    activeIndex = index;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return activeIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @return {Boolean}\n         */\n        isProcessed: function (code) {\n            var activeItemIndex = this.getActiveItemIndex(),\n                sortedItems = steps().sort(this.sortItems),\n                requestedItemIndex = -1;\n\n            sortedItems.forEach(function (element, index) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    requestedItemIndex = index;\n                }\n            });\n\n            return activeItemIndex > requestedItemIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @param {*} scrollToElementId\n         */\n        navigateTo: function (code, scrollToElementId) {\n            var sortedItems = steps().sort(this.sortItems),\n                bodyElem = $('body');\n\n            scrollToElementId = scrollToElementId || null;\n\n            if (!this.isProcessed(code)) {\n                return;\n            }\n            sortedItems.forEach(function (element) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    element.isVisible(true);\n                    bodyElem.animate({\n                        scrollTop: $('#' + code).offset().top\n                    }, 0, function () {\n                        window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                    });\n\n                    if (scrollToElementId && $('#' + scrollToElementId).length) {\n                        bodyElem.animate({\n                            scrollTop: $('#' + scrollToElementId).offset().top\n                        }, 0);\n                    }\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n        },\n\n        /**\n         * Sets window location hash.\n         *\n         * @param {String} hash\n         */\n        setHash: function (hash) {\n            window.location.hash = hash;\n        },\n\n        /**\n         * Next step.\n         */\n        next: function () {\n            var activeIndex = 0,\n                code;\n\n            steps().sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    element.isVisible(false);\n                    activeIndex = index;\n                }\n            });\n\n            if (steps().length > activeIndex + 1) {\n                code = steps()[activeIndex + 1].code;\n                steps()[activeIndex + 1].isVisible(true);\n                this.setHash(code);\n                document.body.scrollTop = document.documentElement.scrollTop = 0;\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/payment/place-order-hooks',\n        'underscore'\n    ],\n    function (storage, errorProcessor, fullScreenLoader, customerData, hooks, _) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            var headers = {}, redirectURL = '';\n\n            fullScreenLoader.startLoader();\n            _.each(hooks.requestModifiers, function (modifier) {\n                modifier(headers, payload);\n            });\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    redirectURL = response.getResponseHeader('errorRedirectAction');\n\n                    if (redirectURL) {\n                        setTimeout(function () {\n                            errorProcessor.redirectTo(redirectURL);\n                        }, 3000);\n                    }\n                }\n            ).done(\n                function (response) {\n                    var clearData = {\n                        'selectedShippingAddress': null,\n                        'shippingAddressFromData': null,\n                        'newCustomerShippingAddress': null,\n                        'selectedShippingRate': null,\n                        'selectedPaymentMethod': null,\n                        'selectedBillingAddress': null,\n                        'billingAddressFromData': null,\n                        'newCustomerBillingAddress': null\n                    };\n\n                    if (response.responseType !== 'error') {\n                        customerData.set('checkout-data', clearData);\n                    }\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                    _.each(hooks.afterRequestListeners, function (listener) {\n                        listener();\n                    });\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var ratesRules = {},\n        checkoutConfig = window.checkoutConfig;\n\n    return {\n        /**\n         * @param {String} carrier\n         * @param {Object} rules\n         */\n        registerRules: function (carrier, rules) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                ratesRules[carrier] = rules.getRules();\n            }\n        },\n\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return ratesRules;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getObservableFields: function () {\n            var self = this,\n                observableFields = [];\n\n            $.each(self.getRules(), function (carrier, fields) {\n                $.each(fields, function (field) {\n                    if (observableFields.indexOf(field) === -1) {\n                        observableFields.push(field);\n                    }\n                });\n            });\n\n            return observableFields;\n        }\n    };\n});\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function (ko, quote, customerData) {\n    'use strict';\n\n    var quoteItems = ko.observable(quote.totals().items),\n        cartData = customerData.get('cart'),\n        quoteSubtotal = parseFloat(quote.totals().subtotal),\n        subtotalAmount = parseFloat(cartData().subtotalAmount);\n\n    quote.totals.subscribe(function (newValue) {\n        quoteItems(newValue.items);\n    });\n\n    if (!isNaN(subtotalAmount) && quoteSubtotal !== subtotalAmount && quoteSubtotal !== 0) {\n        customerData.reload(['cart'], false);\n    }\n\n    return {\n        totals: quote.totals,\n        isLoading: ko.observable(false),\n\n        /**\n         * @return {Function}\n         */\n        getItems: function () {\n            return quoteItems;\n        },\n\n        /**\n         * @param {*} code\n         * @return {*}\n         */\n        getSegment: function (code) {\n            var i, total;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            for (i in this.totals()['total_segments']) { //eslint-disable-line guard-for-in\n                total = this.totals()['total_segments'][i];\n\n                if (total.code == code) { //eslint-disable-line eqeqeq\n                    return total;\n                }\n            }\n\n            return null;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    var containerId = '#checkout';\n\n    return {\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(containerId).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            var $elem = $(containerId),\n                stop = $elem.trigger.bind($elem, 'processStop'); //eslint-disable-line jquery-no-bind-unbind\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/customer',\n    'mage/validation'\n], function ($, customer) {\n    'use strict';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var emailValidationResult = customer.isLoggedIn(),\n                loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            return emailValidationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return {\n        method: 'rest',\n        storeCode: window.checkoutConfig.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] != undefined) { //eslint-disable-line eqeqeq\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/action/create-billing-address',\n    'underscore'\n], function (\n    addressList,\n    quote,\n    checkoutData,\n    createShippingAddress,\n    selectShippingAddress,\n    selectShippingMethodAction,\n    paymentService,\n    selectPaymentMethodAction,\n    addressConverter,\n    selectBillingAddress,\n    createBillingAddress,\n    _\n) {\n    'use strict';\n\n    var isBillingAddressResolvedFromBackend = false;\n\n    return {\n\n        /**\n         * Resolve estimation address. Used local storage\n         */\n        resolveEstimationAddress: function () {\n            var address;\n\n            if (quote.isVirtual()) {\n                if (checkoutData.getBillingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getBillingAddressFromData()\n                    );\n                    selectBillingAddress(address);\n                } else {\n                    this.resolveBillingAddress();\n                }\n            } else if (checkoutData.getShippingAddressFromData()) {\n                address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                selectShippingAddress(address);\n            } else {\n                this.resolveShippingAddress();\n            }\n        },\n\n        /**\n         * Resolve shipping address. Used local storage\n         */\n        resolveShippingAddress: function () {\n            var newCustomerShippingAddress;\n\n            if (!checkoutData.getShippingAddressFromData() &&\n                window.checkoutConfig.shippingAddressFromData\n            ) {\n                checkoutData.setShippingAddressFromData(window.checkoutConfig.shippingAddressFromData);\n            }\n\n            newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n            if (newCustomerShippingAddress) {\n                createShippingAddress(newCustomerShippingAddress);\n            }\n            this.applyShippingAddress();\n        },\n\n        /**\n         * Apply resolved estimated address to quote\n         *\n         * @param {Object} isEstimatedAddress\n         */\n        applyShippingAddress: function (isEstimatedAddress) {\n            var address,\n                shippingAddress,\n                isConvertAddress;\n\n            if (addressList().length === 0) {\n                address = addressConverter.formAddressDataToQuoteAddress(\n                    checkoutData.getShippingAddressFromData()\n                );\n                selectShippingAddress(address);\n            }\n            shippingAddress = quote.shippingAddress();\n            isConvertAddress = isEstimatedAddress || false;\n\n            if (!shippingAddress) {\n                shippingAddress = this.getShippingAddressFromCustomerAddressList();\n\n                if (shippingAddress) {\n                    selectShippingAddress(\n                        isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(shippingAddress)\n                            : shippingAddress\n                    );\n                }\n            }\n        },\n\n        /**\n         * @param {Object} ratesData\n         */\n        resolveShippingRates: function (ratesData) {\n            var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                availableRate = false;\n\n            if (ratesData.length === 1 && !quote.shippingMethod()) {\n                //set shipping rate if we have only one available shipping rate\n                selectShippingMethodAction(ratesData[0]);\n\n                return;\n            }\n\n            if (quote.shippingMethod()) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] == quote.shippingMethod()['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == quote.shippingMethod()['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            if (!availableRate && selectedShippingRate) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] + '_' + rate['method_code'] === selectedShippingRate;\n                });\n            }\n\n            if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                availableRate = _.find(ratesData, function (rate) {\n                    var selectedShippingMethod = window.checkoutConfig.selectedShippingMethod;\n\n                    return rate['carrier_code'] == selectedShippingMethod['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == selectedShippingMethod['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            //Unset selected shipping method if not available\n            if (!availableRate) {\n                selectShippingMethodAction(null);\n            } else {\n                selectShippingMethodAction(availableRate);\n            }\n        },\n\n        /**\n         * Resolve payment method. Used local storage\n         */\n        resolvePaymentMethod: function () {\n            var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n            if (selectedPaymentMethod) {\n                availablePaymentMethods.some(function (payment) {\n                    if (payment.method == selectedPaymentMethod) { //eslint-disable-line eqeqeq\n                        selectPaymentMethodAction(payment);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Resolve billing address. Used local storage\n         */\n        resolveBillingAddress: function () {\n            var selectedBillingAddress,\n                newCustomerBillingAddressData;\n\n            selectedBillingAddress = checkoutData.getSelectedBillingAddress();\n            newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n            if (selectedBillingAddress) {\n                if (selectedBillingAddress === 'new-customer-billing-address' && newCustomerBillingAddressData) {\n                    selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                } else {\n                    addressList.some(function (address) {\n                        if (selectedBillingAddress === address.getKey()) {\n                            selectBillingAddress(address);\n                        }\n                    });\n                }\n            } else {\n                this.applyBillingAddress();\n            }\n\n            if (!isBillingAddressResolvedFromBackend &&\n                !checkoutData.getBillingAddressFromData() &&\n                !_.isEmpty(window.checkoutConfig.billingAddressFromData) &&\n                !quote.billingAddress()\n            ) {\n                if (window.checkoutConfig.isBillingAddressFromDataValid === true) {\n                    selectBillingAddress(createBillingAddress(window.checkoutConfig.billingAddressFromData));\n                } else {\n                    checkoutData.setBillingAddressFromData(window.checkoutConfig.billingAddressFromData);\n                }\n                isBillingAddressResolvedFromBackend = true;\n            }\n        },\n\n        /**\n         * Apply resolved billing address to quote\n         */\n        applyBillingAddress: function () {\n            var shippingAddress,\n                isBillingAddressInitialized;\n\n            if (quote.billingAddress()) {\n                selectBillingAddress(quote.billingAddress());\n\n                return;\n            }\n\n            if (quote.isVirtual() || !quote.billingAddress()) {\n                isBillingAddressInitialized = addressList.some(function (addrs) {\n                    if (addrs.isDefaultBilling()) {\n                        selectBillingAddress(addrs);\n\n                        return true;\n                    }\n\n                    return false;\n                });\n            }\n\n            shippingAddress = quote.shippingAddress();\n\n            if (!isBillingAddressInitialized &&\n                shippingAddress &&\n                shippingAddress.canUseForBilling() &&\n                (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n            ) {\n                //set billing address same as shipping by default if it is not empty\n                selectBillingAddress(quote.shippingAddress());\n            }\n        },\n\n        /**\n         * Get shipping address from address list\n         *\n         * @return {Object|null}\n         */\n        getShippingAddressFromCustomerAddressList: function () {\n            var shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return checkoutData.getSelectedShippingAddress() == address.getKey() //eslint-disable-line\n                    }\n                );\n\n            if (!shippingAddress) {\n                shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return address.isDefaultShipping();\n                    }\n                );\n            }\n\n            if (!shippingAddress && addressList().length === 1) {\n                shippingAddress = addressList()[0];\n            }\n\n            return shippingAddress;\n        }\n    };\n});\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/new-customer-address',\n    'Magento_Customer/js/customer-data',\n    'mage/utils/objects',\n    'underscore'\n], function ($, address, customerData, mageUtils, _) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return {\n        /**\n         * Convert address form data to Address object\n         *\n         * @param {Object} formData\n         * @returns {Object}\n         */\n        formAddressDataToQuoteAddress: function (formData) {\n            // clone address form data to new object\n            var addressData = $.extend(true, {}, formData),\n                region,\n                regionName = addressData.region,\n                customAttributes;\n\n            if (mageUtils.isObject(addressData.street)) {\n                addressData.street = this.objectToArray(addressData.street);\n            }\n\n            addressData.region = {\n                'region_id': addressData['region_id'],\n                'region_code': addressData['region_code'],\n                region: regionName\n            };\n\n            if (addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                region = countryData()[addressData['country_id']].regions[addressData['region_id']];\n\n                if (region) {\n                    addressData.region['region_id'] = addressData['region_id'];\n                    addressData.region['region_code'] = region.code;\n                    addressData.region.region = region.name;\n                }\n            } else if (\n                !addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                addressData.region['region_code'] = '';\n                addressData.region.region = '';\n            }\n            delete addressData['region_id'];\n\n            if (addressData['custom_attributes']) {\n                addressData['custom_attributes'] = _.map(\n                    addressData['custom_attributes'],\n                    function (value, key) {\n                        customAttributes = {\n                            'attribute_code': key,\n                            'value': value\n                        };\n\n                        if (typeof value === 'boolean') {\n                            customAttributes = {\n                                'attribute_code': key,\n                                'value': value,\n                                'label': value === true ? 'Yes' : 'No'\n                            };\n                        }\n\n                        return customAttributes;\n                    }\n                );\n            }\n\n            return address(addressData);\n        },\n\n        /**\n         * Convert Address object to address form data.\n         *\n         * @param {Object} addrs\n         * @returns {Object}\n         */\n        quoteAddressToFormAddressData: function (addrs) {\n            var self = this,\n                output = {},\n                streetObject,\n                customAttributesObject;\n\n            $.each(addrs, function (key) {\n                if (addrs.hasOwnProperty(key) && typeof addrs[key] !== 'function') {\n                    output[self.toUnderscore(key)] = addrs[key];\n                }\n            });\n\n            if (Array.isArray(addrs.street)) {\n                streetObject = {};\n                addrs.street.forEach(function (value, index) {\n                    streetObject[index] = value;\n                });\n                output.street = streetObject;\n            }\n\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (Array.isArray(addrs.customAttributes)) {\n                customAttributesObject = {};\n                addrs.customAttributes.forEach(function (value) {\n                    customAttributesObject[value.attribute_code] = value.value;\n                });\n                output.custom_attributes = customAttributesObject;\n            }\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            return output;\n        },\n\n        /**\n         * @param {String} string\n         */\n        toUnderscore: function (string) {\n            return string.replace(/([A-Z])/g, function ($1) {\n                return '_' + $1.toLowerCase();\n            });\n        },\n\n        /**\n         * @param {Object} formProviderData\n         * @param {String} formIndex\n         * @return {Object}\n         */\n        formDataProviderToFlatData: function (formProviderData, formIndex) {\n            var addressData = {};\n\n            $.each(formProviderData, function (path, value) {\n                var pathComponents = path.split('.'),\n                    dataObject = {};\n\n                pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                pathComponents.reverse();\n                $.each(pathComponents, function (index, pathPart) {\n                    var parent = {};\n\n                    if (index == 0) { //eslint-disable-line eqeqeq\n                        dataObject[pathPart] = value;\n                    } else {\n                        parent[pathPart] = dataObject;\n                        dataObject = parent;\n                    }\n                });\n                $.extend(true, addressData, dataObject);\n            });\n\n            return addressData;\n        },\n\n        /**\n         * Convert object to array\n         * @param {Object} object\n         * @returns {Array}\n         */\n        objectToArray: function (object) {\n            var convertedArray = [];\n\n            $.each(object, function (key) {\n                return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n            });\n\n            return convertedArray.slice(0);\n        },\n\n        /**\n         * @param {Object} addrs\n         * @return {*|Object}\n         */\n        addressToEstimationAddress: function (addrs) {\n            var self = this,\n                estimatedAddressData = {};\n\n            $.each(addrs, function (key) {\n                estimatedAddressData[self.toUnderscore(key)] = addrs[key];\n            });\n\n            return this.formAddressDataToQuoteAddress(estimatedAddressData);\n        }\n    };\n});\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils'\n], function (utils) {\n    'use strict';\n\n    return {\n        validatedPostCodeExample: [],\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @param {Array} postCodesPatterns\n         * @return {Boolean}\n         */\n        validate: function (postCode, countryId, postCodesPatterns) {\n            var pattern, regex,\n                patterns = postCodesPatterns ? postCodesPatterns[countryId] :\n                    window.checkoutConfig.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        }\n    };\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'domReady!'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Get totals data from the extension attributes.\n     * @param {*} data\n     * @returns {*}\n     */\n    var proceedTotalsData = function (data) {\n            if (_.isObject(data) && _.isObject(data['extension_attributes'])) {\n                _.each(data['extension_attributes'], function (element, index) {\n                    data[index] = element;\n                });\n            }\n\n            return data;\n        },\n        billingAddress = ko.observable(null),\n        shippingAddress = ko.observable(null),\n        shippingMethod = ko.observable(null),\n        paymentMethod = ko.observable(null),\n        quoteData = window.checkoutConfig.quoteData,\n        basePriceFormat = window.checkoutConfig.basePriceFormat,\n        priceFormat = window.checkoutConfig.priceFormat,\n        storeCode = window.checkoutConfig.storeCode,\n        totalsData = proceedTotalsData(window.checkoutConfig.totalsData),\n        totals = ko.observable(totalsData),\n        collectedTotals = ko.observable({});\n\n    return {\n        totals: totals,\n        shippingAddress: shippingAddress,\n        shippingMethod: shippingMethod,\n        billingAddress: billingAddress,\n        paymentMethod: paymentMethod,\n        guestEmail: null,\n\n        /**\n         * @return {*}\n         */\n        getQuoteId: function () {\n            return quoteData['entity_id'];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVirtual: function () {\n            return !!Number(quoteData['is_virtual']);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPriceFormat: function () {\n            return priceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBasePriceFormat: function () {\n            return basePriceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getItems: function () {\n            return window.checkoutConfig.quoteItemData;\n        },\n\n        /**\n         *\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals;\n        },\n\n        /**\n         * @param {Object} data\n         */\n        setTotals: function (data) {\n            data = proceedTotalsData(data);\n            totals(data);\n            this.setCollectedTotals('subtotal_with_discount', parseFloat(data['subtotal_with_discount']));\n        },\n\n        /**\n         * @param {*} paymentMethodCode\n         */\n        setPaymentMethod: function (paymentMethodCode) {\n            paymentMethod(paymentMethodCode);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPaymentMethod: function () {\n            return paymentMethod;\n        },\n\n        /**\n         * @return {*}\n         */\n        getStoreCode: function () {\n            return storeCode;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} value\n         */\n        setCollectedTotals: function (code, value) {\n            var colTotals = collectedTotals();\n\n            colTotals[code] = value;\n            collectedTotals(colTotals);\n        },\n\n        /**\n         * @return {Number}\n         */\n        getCalculatedTotal: function () {\n            var total = 0.; //eslint-disable-line no-floating-decimal\n\n            _.each(collectedTotals(), function (value) {\n                total += value;\n            });\n\n            return total;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/action/select-payment-method'\n], function (_, quote, methodList, selectPaymentMethod) {\n    'use strict';\n\n    /**\n    * Free method filter\n    * @param {Object} paymentMethod\n    * @return {Boolean}\n    */\n    var isFreePaymentMethod = function (paymentMethod) {\n            return paymentMethod.method === 'free';\n        },\n\n        /**\n         * Grabs the grand total from quote\n         * @return {Number}\n         */\n        getGrandTotal = function () {\n            return quote.totals()['grand_total'];\n        };\n\n    return {\n        isFreeAvailable: false,\n\n        /**\n         * Populate the list of payment methods\n         * @param {Array} methods\n         */\n        setPaymentMethods: function (methods) {\n            var freeMethod,\n                filteredMethods,\n                methodIsAvailable,\n                methodNames;\n\n            freeMethod = _.find(methods, isFreePaymentMethod);\n            this.isFreeAvailable = !!freeMethod;\n\n            if (freeMethod && getGrandTotal() <= 0) {\n                methods.splice(0, methods.length, freeMethod);\n                selectPaymentMethod(freeMethod);\n            }\n\n            filteredMethods = _.without(methods, freeMethod);\n\n            if (filteredMethods.length === 1) {\n                selectPaymentMethod(filteredMethods[0]);\n            } else if (quote.paymentMethod()) {\n                methodIsAvailable = methods.some(function (item) {\n                    return item.method === quote.paymentMethod().method;\n                });\n                //Unset selected payment method if not available\n                if (!methodIsAvailable) {\n                    selectPaymentMethod(null);\n                }\n            }\n\n            /**\n             * Overwrite methods with existing methods to preserve ko array references.\n             * This prevent ko from re-rendering those methods.\n             */\n            methodNames = _.pluck(methods, 'method');\n            _.map(methodList(), function (existingMethod) {\n                var existingMethodIndex = methodNames.indexOf(existingMethod.method);\n\n                if (existingMethodIndex !== -1) {\n                    methods[existingMethodIndex] = existingMethod;\n                }\n            });\n\n            methodList(methods);\n        },\n\n        /**\n         * Get the list of available payment methods.\n         * @return {Array}\n         */\n        getAvailablePaymentMethods: function () {\n            var allMethods = methodList().slice(),\n                grandTotalOverZero = getGrandTotal() > 0;\n\n            if (!this.isFreeAvailable) {\n                return allMethods;\n            }\n\n            if (grandTotalOverZero) {\n                return _.reject(allMethods, isFreePaymentMethod);\n            }\n\n            return _.filter(allMethods, isFreePaymentMethod);\n        }\n    };\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Checkout/js/model/billing-address-postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n           'jquery',\n           'Magento_Checkout/js/model/postcode-validator',\n           'mage/translate',\n           'uiRegistry'\n       ], function (\n    $,\n    postcodeValidator,\n    $t,\n    uiRegistry\n) {\n    'use strict';\n\n    var postcodeElementName = 'postcode';\n\n    return {\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this;\n\n            uiRegistry.async(formPath + '.' + postcodeElementName)(self.bindHandler.bind(self));\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            element.on('value', function () {\n                clearTimeout(self.validateZipCodeTimeout);\n                self.validateZipCodeTimeout = setTimeout(function () {\n                    self.postcodeValidation(element);\n                }, delay);\n            });\n        },\n\n        /**\n         * @param {Object} postcodeElement\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var cache = [];\n\n    return {\n        /**\n         * @param {String} addressKey\n         * @return {*}\n         */\n        get: function (addressKey) {\n            if (cache[addressKey]) {\n                return cache[addressKey];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} addressKey\n         * @param {*} data\n         */\n        set: function (addressKey, data) {\n            cache[addressKey] = data;\n        }\n    };\n});\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        popUp: false,\n\n        /**\n         * @param {Object} popUp\n         */\n        setPopup: function (popUp) {\n            this.popUp = popUp;\n        },\n\n        /**\n         * Show popup.\n         */\n        show: function () {\n            if (this.popUp) {\n                this.popUp.modal('openModal');\n            }\n        },\n\n        /**\n         * Hide popup.\n         */\n        hide: function () {\n            if (this.popUp) {\n                this.popUp.modal('closeModal');\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (quote, defaultProcessor, totalsDefaultProvider, shippingService, cartCache, customerData) {\n    'use strict';\n\n    var rateProcessors = {},\n        totalsProcessors = {},\n\n        /**\n         * Estimate totals for shipping address and update shipping rates.\n         */\n        estimateTotalsAndUpdateRates = function () {\n            var type = quote.shippingAddress().getType();\n\n            if (\n                quote.isVirtual() ||\n                window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0\n            ) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.shippingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n            } else {\n                // check if user data not changed -> load rates from cache\n                if (!cartCache.isChanged('address', quote.shippingAddress()) &&\n                    !cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                    cartCache.get('rates')\n                ) {\n                    shippingService.setShippingRates(cartCache.get('rates'));\n\n                    return;\n                }\n\n                // update rates list when estimated address was set\n                rateProcessors['default'] = defaultProcessor;\n                rateProcessors[type] ?\n                    rateProcessors[type].getRates(quote.shippingAddress()) :\n                    rateProcessors['default'].getRates(quote.shippingAddress());\n\n                // save rates to cache after load\n                shippingService.getShippingRates().subscribe(function (rates) {\n                    cartCache.set('rates', rates);\n                });\n            }\n        },\n\n        /**\n         * Estimate totals for shipping address.\n         */\n        estimateTotalsShipping = function () {\n            totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n        },\n\n        /**\n         * Estimate totals for billing address.\n         */\n        estimateTotalsBilling = function () {\n            var type = quote.billingAddress().getType();\n\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.billingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.billingAddress());\n            }\n        };\n\n    quote.shippingAddress.subscribe(estimateTotalsAndUpdateRates);\n    quote.shippingMethod.subscribe(estimateTotalsShipping);\n    quote.billingAddress.subscribe(estimateTotalsBilling);\n});\n","Magento_Checkout/js/model/cart/cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Cart adapter for customer data storage.\n * It stores cart data in customer data(localStorage) without saving on server.\n * Adapter is created for shipping rates and totals data caching. It eliminates unneeded calculations requests.\n */\ndefine([\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'mageUtils'\n], function (_, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'cart-data',\n        cartData = {\n            totals: null,\n            address: null,\n            cartVersion: null,\n            shippingMethodCode: null,\n            shippingCarrierCode: null,\n            rates: null\n        },\n\n        /**\n         * Set data to local storage.\n         *\n         * @param {Object} checkoutData\n         */\n        setData = function (checkoutData) {\n            storage.set(cacheKey, checkoutData);\n        },\n\n        /**\n         * Get data from local storage.\n         *\n         * @param {String} [key]\n         * @returns {*}\n         */\n        getData = function (key) {\n            var data = key ? storage.get(cacheKey)()[key] : storage.get(cacheKey)();\n\n            if (_.isEmpty(storage.get(cacheKey)())) {\n                setData(utils.copy(cartData));\n            }\n\n            return data;\n        },\n\n        /**\n         * Build method name base on name, prefix and suffix.\n         *\n         * @param {String} name\n         * @param {String} prefix\n         * @param {String} suffix\n         * @return {String}\n         */\n        getMethodName = function (name, prefix, suffix) {\n            prefix = prefix || '';\n            suffix = suffix || '';\n\n            return prefix + name.charAt(0).toUpperCase() + name.slice(1) + suffix;\n        };\n\n    /**\n     * Provides get/set/isChanged/clear methods for work with cart data.\n     * Can be customized via mixin functionality.\n     */\n    return {\n        cartData: cartData,\n\n        /**\n         * Array of required address fields\n         */\n        requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n        /**\n         * Get data from customer data.\n         * Concatenate provided key with method name and call method if it exist or makes get by key.\n         *\n         * @param {String} key\n         * @return {*}\n         */\n        get: function (key) {\n            var methodName = getMethodName(key, '_get');\n\n            if (key === cacheKey) {\n                return getData();\n            }\n\n            if (this[methodName]) {\n                return this[methodName]();\n            }\n\n            return getData(key);\n        },\n\n        /**\n         * Set data to customer data.\n         * Concatenate provided key with method name and call method if it exist or makes set by key.\n         * @example _setCustomAddress method will be called, if it exists.\n         *  set('address', customAddressValue)\n         * @example Will set value by provided key.\n         *  set('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         */\n        set: function (key, value) {\n            var methodName = getMethodName(key, '_set'),\n                obj;\n\n            if (key === cacheKey) {\n                _.each(value, function (val, k) {\n                    this.set(k, val);\n                }, this);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName](value);\n            } else {\n                obj = getData();\n                obj[key] = value;\n                setData(obj);\n            }\n        },\n\n        /**\n         * Clear data in cache.\n         * Concatenate provided key with method name and call method if it exist or clear by key.\n         * @example _clearCustomAddress method will be called, if it exist.\n         *  clear('customAddress')\n         * @example Will clear data by provided key.\n         *  clear('rates')\n         *\n         * @param {String} key\n         */\n        clear: function (key) {\n            var methodName = getMethodName(key, '_clear');\n\n            if (key === cacheKey) {\n                setData(this.cartData);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName]();\n            } else {\n                this.set(key, null);\n            }\n        },\n\n        /**\n         * Check if provided data has difference with cached data.\n         * Concatenate provided key with method name and call method if it exist or makes strict equality.\n         * @example Will call existing _isAddressChanged.\n         *  isChanged('address', addressToCompare)\n         * @example Will get data by provided key and make strict equality with provided value.\n         *  isChanged('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         * @return {Boolean}\n         */\n        isChanged: function (key, value) {\n            var methodName = getMethodName(key, '_is', 'Changed');\n\n            if (this[methodName]) {\n                return this[methodName](value);\n            }\n\n            return this.get(key) !== value;\n        },\n\n        /**\n         * Compare cached address with provided.\n         * Custom method for check object equality.\n         *\n         * @param {Object} address\n         * @returns {Boolean}\n         */\n        _isAddressChanged: function (address) {\n            return JSON.stringify(_.pick(this.get('address'), this.requiredFields)) !==\n                JSON.stringify(_.pick(address, this.requiredFields));\n        },\n\n        /**\n         * Compare cached subtotal with provided.\n         * Custom method for check object equality.\n         *\n         * @param {float} subtotal\n         * @returns {Boolean}\n         */\n        _isSubtotalChanged: function (subtotal) {\n            var cached = parseFloat(this.get('totals').subtotal);\n\n            return subtotal !== cached;\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor, cartCache, customerData) {\n    'use strict';\n\n    /**\n     * Load data from server.\n     *\n     * @param {Object} address\n     */\n    var loadFromServer = function (address) {\n        var serviceUrl,\n            payload;\n\n        // Start loader for totals block\n        totalsService.isLoading(true);\n        serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);\n        payload = {\n            addressInformation: {\n                address: _.pick(address, cartCache.requiredFields)\n            }\n        };\n\n        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n            payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n            payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n        }\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), false\n        ).done(function (result) {\n            var data = {\n                totals: result,\n                address: address,\n                cartVersion: customerData.get('cart')()['data_id'],\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            quote.setTotals(result);\n            cartCache.set('cart-data', data);\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        }).always(function () {\n            // Stop loader for totals block\n            totalsService.isLoading(false);\n        });\n    };\n\n    return {\n        /**\n         * Array of required address fields.\n         * @property {Array.String} requiredFields\n         * @deprecated Use cart cache.\n         */\n        requiredFields: cartCache.requiredFields,\n\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        estimateTotals: function (address) {\n            return loadFromServer(address);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, serviceUrl, payload;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getCacheKey());\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    serviceUrl, payload, false\n                ).done(function (result) {\n                    rateRegistry.set(address.getCacheKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getKey());\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                    JSON.stringify({\n                        addressId: address.customerAddressId\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(address.getKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    var validators = [];\n\n    return {\n        /**\n         * Register unique validator\n         *\n         * @param {*} validator\n         */\n        registerValidator: function (validator) {\n            validators.push(validator);\n        },\n\n        /**\n         * Returns array of registered validators\n         *\n         * @returns {Array}\n         */\n        getValidators: function () {\n            return validators;\n        },\n\n        /**\n         * Process validators\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var validationResult = true;\n\n            hideError = hideError || false;\n\n            if (validators.length <= 0) {\n                return validationResult;\n            }\n\n            validators.forEach(function (item) {\n                if (item.validate(hideError) == false) { //eslint-disable-line eqeqeq\n                    validationResult = false;\n\n                    return false;\n                }\n            });\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/place-order-hooks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        requestModifiers: [],\n        afterRequestListeners: []\n    };\n});\n","Magento_Checkout/js/model/payment/method-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'uiElement',\n        'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    var DEFAULT_GROUP_ALIAS = 'default';\n\n    return Element.extend({\n        defaults: {\n            alias: DEFAULT_GROUP_ALIAS,\n            title: $t('Payment Method'),\n            sortOrder: 100,\n            displayArea: 'payment-methods-items-${ $.alias }'\n        },\n\n        /**\n         * Checks if group instance is default\n         *\n         * @returns {Boolean}\n         */\n        isDefault: function () {\n            return this.alias === DEFAULT_GROUP_ALIAS;\n        }\n    });\n});\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (methods) {\n        _.each(methods, function (method) {\n            if (method.hasOwnProperty('code')) {\n                method.method = method.code;\n                delete method.code;\n            }\n        });\n\n        return methods;\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'mage/storage',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/shipping-save-processor/payload-extender'\n], function (\n    ko,\n    quote,\n    resourceUrlManager,\n    storage,\n    paymentService,\n    methodConverter,\n    errorProcessor,\n    fullScreenLoader,\n    selectBillingAddressAction,\n    payloadExtender\n) {\n    'use strict';\n\n    return {\n        /**\n         * @return {jQuery.Deferred}\n         */\n        saveShippingInformation: function () {\n            var payload;\n\n            if (!quote.billingAddress() && quote.shippingAddress().canUseForBilling()) {\n                selectBillingAddressAction(quote.shippingAddress());\n            }\n\n            payload = {\n                addressInformation: {\n                    'shipping_address': quote.shippingAddress(),\n                    'billing_address': quote.billingAddress(),\n                    'shipping_method_code': quote.shippingMethod()['method_code'],\n                    'shipping_carrier_code': quote.shippingMethod()['carrier_code']\n                }\n            };\n\n            payloadExtender(payload);\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                resourceUrlManager.getUrlForSetShippingInformation(quote),\n                JSON.stringify(payload)\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n                    fullScreenLoader.stopLoader();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/payload-extender.js":"define([], function () {\n    'use strict';\n\n    return function (payload) {\n        payload.addressInformation['extension_attributes'] = {};\n\n        return payload;\n    };\n});\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return {\n        isVisible: ko.observable(false)\n    };\n});\n","Magento_Sales/js/orders-returns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param {jQuery.Event} e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function (e) {\n            var value = $(e.target).val();\n\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});\n","Magento_Sales/js/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param {jQuery.Event} event - Click event.\n         */\n        _toggleGiftMessage: function (event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n\n            region.toggleClass(options.expandedContentClass, options.duration, function () {\n                if (region.attr('aria-expanded') === 'true') {\n                    region.attr('aria-expanded', 'false');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', 'true');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n\n    return $.mage.giftMessage;\n});\n","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function (Component, customerData, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isShowAddToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n            this.lastOrderedItems.subscribe(this.checkSalableItems.bind(this));\n            this.checkSalableItems();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('isShowAddToCart');\n\n            return this;\n        },\n\n        /**\n         * Check if items is_saleable and change add to cart button visibility.\n         */\n        checkSalableItems: function () {\n            var isShowAddToCart = _.some(this.lastOrderedItems().items, {\n                'is_saleable': true\n            });\n\n            this.isShowAddToCart(isShowAddToCart);\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/offline-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'checkmo',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method'\n        },\n        {\n            type: 'banktransfer',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method'\n        },\n        {\n            type: 'cashondelivery',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method'\n        },\n        {\n            type: 'purchaseorder',\n            component: 'Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/purchaseorder-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'mage/validation'\n], function (Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/purchaseorder-form',\n            purchaseOrderNumber: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('purchaseOrderNumber');\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                method: this.item.method,\n                'po_number': this.purchaseOrderNumber(),\n                'additional_data': null\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = 'form[data-role=purchaseorder-form]';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/cashondelivery-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/cashondelivery'\n        },\n\n        /**\n         * Returns payment method instructions.\n         *\n         * @return {*}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/banktransfer-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/payment/default'\n], function (ko, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/banktransfer'\n        },\n\n        /**\n         * Get value of instruction field.\n         * @returns {String}\n         */\n        getInstructions: function () {\n            return window.checkoutConfig.payment.instructions[this.item.method];\n        }\n    });\n});\n","Magento_OfflinePayments/js/view/payment/method-renderer/checkmo-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_OfflinePayments/payment/checkmo'\n        },\n\n        /**\n         * Returns send check to info.\n         *\n         * @return {*}\n         */\n        getMailingAddress: function () {\n            return window.checkoutConfig.payment.checkmo.mailingAddress;\n        },\n\n        /**\n         * Returns payable to info.\n         *\n         * @return {*}\n         */\n        getPayableTo: function () {\n            return window.checkoutConfig.payment.checkmo.payableTo;\n        }\n    });\n});\n","Magento_PageCache/js/page-cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'domReady',\n    'consoleLogger',\n    'Magento_PageCache/js/form-key-provider',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($, domReady, consoleLogger, formKeyInit) {\n    'use strict';\n\n    /**\n     * Helper. Generate random string\n     * TODO: Merge with mage/utils\n     * @param {String} chars - list of symbols\n     * @param {Number} length - length for need string\n     * @returns {String}\n     */\n    function generateRandomString(chars, length) {\n        var result = '';\n\n        length = length > 0 ? length : 1;\n\n        while (length--) {\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        }\n\n        return result;\n    }\n\n    /**\n     * Nodes tree to flat list converter\n     * @returns {Array}\n     */\n    $.fn.comments = function () {\n        var elements = [],\n            contents,\n            elementContents;\n\n        /**\n         * @param {jQuery} element - Comment holder\n         */\n        (function lookup(element) {\n            var iframeHostName;\n\n            // prevent cross origin iframe content reading\n            if ($(element).prop('tagName') === 'IFRAME') {\n                iframeHostName = $('<a>').prop('href', $(element).prop('src'))\n                    .prop('hostname');\n\n                if (window.location.hostname !== iframeHostName) {\n                    return [];\n                }\n            }\n\n            /**\n             * Rewrite jQuery contents().\n             *\n             * @param {jQuery} elem\n             */\n            contents = function (elem) {\n                return $.map(elem, function (el) {\n                    try {\n                        return el.nodeName.toLowerCase() === 'iframe' ?\n                            el.contentDocument || (el.contentWindow ? el.contentWindow.document : []) :\n                            $.merge([], el.childNodes);\n                    } catch (e) {\n                        consoleLogger.error(e);\n\n                        return [];\n                    }\n                });\n            };\n\n            elementContents = contents($(element));\n\n            $.each(elementContents, function (index, el) {\n                switch (el.nodeType) {\n                    case 1: // ELEMENT_NODE\n                        lookup(el);\n                        break;\n\n                    case 8: // COMMENT_NODE\n                        elements.push(el);\n                        break;\n\n                    case 9: // DOCUMENT_NODE\n                        lookup($(el).find('body'));\n                        break;\n                }\n            });\n        })(this);\n\n        return elements;\n    };\n\n    /**\n     * FormKey Widget - this widget is generating from key, saves it to cookie and\n     * @deprecated see Magento/PageCache/view/frontend/web/js/form-key-provider.js\n     */\n    $.widget('mage.formKey', {\n        options: {\n            inputSelector: 'input[name=\"form_key\"]',\n            allowedCharacters: '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',\n            length: 16\n        },\n\n        /**\n         * Creates widget 'mage.formKey'\n         * @private\n         */\n        _create: function () {\n            var formKey = $.mage.cookies.get('form_key'),\n                options = {\n                    secure: window.cookiesConfig ? window.cookiesConfig.secure : false\n                };\n\n            if (!formKey) {\n                formKey = generateRandomString(this.options.allowedCharacters, this.options.length);\n                $.mage.cookies.set('form_key', formKey, options);\n            }\n            $(this.options.inputSelector).val(formKey);\n        }\n    });\n\n    /**\n     * PageCache Widget\n     * Handles additional ajax request for rendering user private content.\n     */\n    $.widget('mage.pageCache', {\n        options: {\n            url: '/',\n            patternPlaceholderOpen: /^ BLOCK (.+) $/,\n            patternPlaceholderClose: /^ \\/BLOCK (.+) $/,\n            versionCookieName: 'private_content_version',\n            handles: []\n        },\n\n        /**\n         * Creates widget 'mage.pageCache'\n         * @private\n         */\n        _create: function () {\n            var placeholders,\n                version = $.mage.cookies.get(this.options.versionCookieName);\n\n            if (!version) {\n                return;\n            }\n            placeholders = this._searchPlaceholders(this.element.comments());\n\n            if (placeholders && placeholders.length) {\n                this._ajax(placeholders, version);\n            }\n        },\n\n        /**\n         * Parse page for placeholders.\n         * @param {Array} elements\n         * @returns {Array}\n         * @private\n         */\n        _searchPlaceholders: function (elements) {\n            var placeholders = [],\n                tmp = {},\n                ii,\n                len,\n                el, matches, name;\n\n            if (!(elements && elements.length)) {\n                return placeholders;\n            }\n\n            for (ii = 0, len = elements.length; ii < len; ii++) {\n                el = elements[ii];\n                matches = this.options.patternPlaceholderOpen.exec(el.nodeValue);\n                name = null;\n\n                if (matches) {\n                    name = matches[1];\n                    tmp[name] = {\n                        name: name,\n                        openElement: el\n                    };\n                } else {\n                    matches = this.options.patternPlaceholderClose.exec(el.nodeValue);\n\n                    if (matches) { //eslint-disable-line max-depth\n                        name = matches[1];\n\n                        if (tmp[name]) { //eslint-disable-line max-depth\n                            tmp[name].closeElement = el;\n                            placeholders.push(tmp[name]);\n                            delete tmp[name];\n                        }\n                    }\n                }\n            }\n\n            return placeholders;\n        },\n\n        /**\n         * Parse for page and replace placeholders\n         * @param {Object} placeholder\n         * @param {Object} html\n         * @protected\n         */\n        _replacePlaceholder: function (placeholder, html) {\n            var startReplacing = false,\n                prevSibling = null,\n                parent, contents, yy, len, element;\n\n            if (!placeholder || !html) {\n                return;\n            }\n\n            parent = $(placeholder.openElement).parent();\n            contents = parent.contents();\n\n            for (yy = 0, len = contents.length; yy < len; yy++) {\n                element = contents[yy];\n\n                if (element == placeholder.openElement) { //eslint-disable-line eqeqeq\n                    startReplacing = true;\n                }\n\n                if (startReplacing) {\n                    $(element).remove();\n                } else if (element.nodeType != 8) { //eslint-disable-line eqeqeq\n                    //due to comment tag doesn't have siblings we try to find it manually\n                    prevSibling = element;\n                }\n\n                if (element == placeholder.closeElement) { //eslint-disable-line eqeqeq\n                    break;\n                }\n            }\n\n            if (prevSibling) {\n                $(prevSibling).after(html);\n            } else {\n                $(parent).prepend(html);\n            }\n\n            // trigger event to use mage-data-init attribute\n            $(parent).trigger('contentUpdated');\n        },\n\n        /**\n         * AJAX helper\n         * @param {Object} placeholders\n         * @param {String} version\n         * @private\n         */\n        _ajax: function (placeholders, version) {\n            var ii,\n                data = {\n                    blocks: [],\n                    handles: this.options.handles,\n                    originalRequest: this.options.originalRequest,\n                    version: version\n                };\n\n            for (ii = 0; ii < placeholders.length; ii++) {\n                data.blocks.push(placeholders[ii].name);\n            }\n            data.blocks = JSON.stringify(data.blocks.sort());\n            data.handles = JSON.stringify(data.handles);\n            data.originalRequest = JSON.stringify(data.originalRequest);\n            $.ajax({\n                url: this.options.url,\n                data: data,\n                type: 'GET',\n                cache: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * Response handler\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var placeholder, i;\n\n                    for (i = 0; i < placeholders.length; i++) {\n                        placeholder = placeholders[i];\n\n                        if (response.hasOwnProperty(placeholder.name)) {\n                            this._replacePlaceholder(placeholder, response[placeholder.name]);\n                        }\n                    }\n                }\n            });\n        }\n    });\n\n    domReady(function () {\n        formKeyInit();\n    });\n\n    return {\n        'pageCache': $.mage.pageCache,\n        'formKey': $.mage.formKey\n    };\n});\n","Magento_PageCache/js/form-key-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return function (settings) {\n        var formKey,\n            inputElements,\n            inputSelector = 'input[name=\"form_key\"]';\n\n        /**\n         * Set form_key cookie\n         * @private\n         */\n        function setFormKeyCookie(value) {\n            var expires,\n                secure,\n                date = new Date(),\n                cookiesConfig = window.cookiesConfig || {},\n                isSecure = !!cookiesConfig.secure,\n                samesite = cookiesConfig.samesite || 'lax';\n\n            date.setTime(date.getTime() + 86400000);\n            expires = '; expires=' + date.toUTCString();\n            secure = isSecure ? '; secure' : '';\n            samesite = '; samesite=' + samesite;\n\n            document.cookie = 'form_key=' + (value || '') + expires + secure + '; path=/' + samesite;\n        }\n\n        /**\n         * Retrieves form key from cookie\n         * @private\n         */\n        function getFormKeyCookie() {\n            var cookie,\n                i,\n                nameEQ = 'form_key=',\n                cookieArr = document.cookie.split(';');\n\n            for (i = 0; i < cookieArr.length; i++) {\n                cookie = cookieArr[i];\n\n                while (cookie.charAt(0) === ' ') {\n                    cookie = cookie.substring(1, cookie.length);\n                }\n\n                if (cookie.indexOf(nameEQ) === 0) {\n                    return cookie.substring(nameEQ.length, cookie.length);\n                }\n            }\n\n            return null;\n        }\n\n        /**\n         * Get form key from UI input hidden\n         * @private\n         */\n        function getFormKeyFromUI() {\n            return document.querySelector(inputSelector).value;\n        }\n\n        /**\n         * Generate form key string\n         * @private\n         */\n        function generateFormKeyString() {\n            var result = '',\n                length = 16,\n                chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n\n            while (length--) {\n                result += chars[Math.round(Math.random() * (chars.length - 1))];\n            }\n\n            return result;\n        }\n\n        /**\n         * Init form_key inputs with value\n         * @private\n         */\n        function initFormKey() {\n            formKey = getFormKeyCookie();\n\n            if (settings && settings.isPaginationCacheEnabled && !formKey) {\n                formKey = getFormKeyFromUI();\n                setFormKeyCookie(formKey);\n            }\n\n            if (!formKey) {\n                formKey = generateFormKeyString();\n                setFormKeyCookie(formKey);\n            }\n            inputElements = document.querySelectorAll(inputSelector);\n\n            if (inputElements.length) {\n                Array.prototype.forEach.call(inputElements, function (element) {\n                    element.setAttribute('value', formKey);\n                });\n            }\n        }\n\n        initFormKey();\n    };\n});\n","Threedadv_Catalog/js/titledescription.js":"require(['jquery'], function ($) {\n    $(document).ready(function () {\n        const maxLength = 167;\n\n        $('.product.attribute.overview [itemprop=\"description\"]').each(function () {\n            const fullText = $(this).text();\n\n            if (fullText.length > maxLength) {\n                const visibleText = fullText.substring(0, maxLength) + \"...\";\n                $(this).html(`\n                    <span class=\"short-text\">${visibleText}</span>\n                    <span class=\"full-text\" style=\"display: none;\">${fullText}</span>\n                    <a href=\"#\" class=\"toggle-text\">Ver m\u00e1s</a>\n                `);\n            }\n        });\n\n        $(document).on('click', '.toggle-text', function (e) {\n            e.preventDefault();\n            const container = $(this).closest('[itemprop=\"description\"]');\n            container.find('.short-text').toggle();\n            container.find('.full-text').toggle();\n\n            $(this).text($(this).text() === \"Ver m\u00e1s\" ? \"Ver menos\" : \"Ver m\u00e1s\");\n        });\n    });\n});\n","Threedadv_Catalog/js/productdetailscript.js":"require(['jquery'], function ($) {\n    $(document).ready(function () {\n        $('#go-to-address-btn').on('click', function () {\n            const targetCoordinates = $(this).data('coordinates');\n            const [targetLat, targetLng] = targetCoordinates.split(',').map(coord => coord.trim());\n\n            if (navigator.geolocation) {\n                navigator.geolocation.getCurrentPosition(\n                    function (position) {\n                        const userLat = position.coords.latitude;\n                        const userLng = position.coords.longitude;\n                        const googleMapsUrl = `https://www.google.com/maps/dir/${userLat},${userLng}/${targetLat},${targetLng}`;\n                        window.open(googleMapsUrl, '_blank');\n                    },\n                    function (error) {\n                        alert('Error getting your location: ' + error.message);\n                    }\n                );\n            } else {\n                alert('Geolocation is not supported by your browser.');\n            }\n        });\n    });\n});","Mageplaza_Core/js/jquery.ui.touch-punch.min.js":"/*!\r\n * jQuery UI Touch Punch 0.2.3\r\n *\r\n * Copyright 2011\u20132014, Dave Furfero\r\n * Dual licensed under the MIT or GPL Version 2 licenses.\r\n *\r\n * Depends:\r\n *  jquery.ui.widget.js\r\n *  jquery.ui.mouse.js\r\n */\r\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);\r\n","Mageplaza_Core/js/ion.rangeSlider.min.js":"// Ion.RangeSlider | version 2.1.6 | https://github.com/IonDen/ion.rangeSlider\r\n;(function(f){\"function\"===typeof define&&define.amd?define([\"jquery\"],function(p){return f(p,document,window,navigator)}):\"object\"===typeof exports?f(require(\"jquery\"),document,window,navigator):f(jQuery,document,window,navigator)})(function(f,p,h,t,q){var u=0,m=function(){var a=t.userAgent,b=/msie\\s\\d+/i;return 0<a.search(b)&&(a=b.exec(a).toString(),a=a.split(\" \")[1],9>a)?(f(\"html\").addClass(\"lt-ie9\"),!0):!1}();Function.prototype.bind||(Function.prototype.bind=function(a){var b=this,d=[].slice;if(\"function\"!=\r\n    typeof b)throw new TypeError;var c=d.call(arguments,1),e=function(){if(this instanceof e){var g=function(){};g.prototype=b.prototype;var g=new g,l=b.apply(g,c.concat(d.call(arguments)));return Object(l)===l?l:g}return b.apply(a,c.concat(d.call(arguments)))};return e});Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){var d;if(null==this)throw new TypeError('\"this\" is null or not defined');var c=Object(this),e=c.length>>>0;if(0===e)return-1;d=+b||0;Infinity===Math.abs(d)&&(d=0);if(d>=\r\n    e)return-1;for(d=Math.max(0<=d?d:e-Math.abs(d),0);d<e;){if(d in c&&c[d]===a)return d;d++}return-1});var r=function(a,b,d){this.VERSION=\"2.1.6\";this.input=a;this.plugin_count=d;this.old_to=this.old_from=this.update_tm=this.calc_count=this.current_plugin=0;this.raf_id=this.old_min_interval=null;this.is_update=this.is_key=this.no_diapason=this.force_redraw=this.dragging=!1;this.is_start=this.is_first_update=!0;this.is_click=this.is_resize=this.is_active=this.is_finish=!1;b=b||{};this.$cache={win:f(h),\r\n    body:f(p.body),input:f(a),cont:null,rs:null,min:null,max:null,from:null,to:null,single:null,bar:null,line:null,s_single:null,s_from:null,s_to:null,shad_single:null,shad_from:null,shad_to:null,edge:null,grid:null,grid_labels:[]};this.coords={x_gap:0,x_pointer:0,w_rs:0,w_rs_old:0,w_handle:0,p_gap:0,p_gap_left:0,p_gap_right:0,p_step:0,p_pointer:0,p_handle:0,p_single_fake:0,p_single_real:0,p_from_fake:0,p_from_real:0,p_to_fake:0,p_to_real:0,p_bar_x:0,p_bar_w:0,grid_gap:0,big_num:0,big:[],big_w:[],big_p:[],\r\n    big_x:[]};this.labels={w_min:0,w_max:0,w_from:0,w_to:0,w_single:0,p_min:0,p_max:0,p_from_fake:0,p_from_left:0,p_to_fake:0,p_to_left:0,p_single_fake:0,p_single_left:0};var c=this.$cache.input;a=c.prop(\"value\");var e;d={type:\"single\",min:10,max:100,from:null,to:null,step:1,min_interval:0,max_interval:0,drag_interval:!1,values:[],p_values:[],from_fixed:!1,from_min:null,from_max:null,from_shadow:!1,to_fixed:!1,to_min:null,to_max:null,to_shadow:!1,prettify_enabled:!0,prettify_separator:\" \",prettify:null,\r\n    force_edges:!1,keyboard:!1,keyboard_step:5,grid:!1,grid_margin:!0,grid_num:4,grid_snap:!1,hide_min_max:!1,hide_from_to:!1,prefix:\"\",postfix:\"\",max_postfix:\"\",decorate_both:!0,values_separator:\" \\u2014 \",input_values_separator:\";\",disable:!1,onStart:null,onChange:null,onFinish:null,onUpdate:null};\"INPUT\"!==c[0].nodeName&&console&&console.warn&&console.warn(\"Base element should be <input>!\",c[0]);c={type:c.data(\"type\"),min:c.data(\"min\"),max:c.data(\"max\"),from:c.data(\"from\"),to:c.data(\"to\"),step:c.data(\"step\"),\r\n    min_interval:c.data(\"minInterval\"),max_interval:c.data(\"maxInterval\"),drag_interval:c.data(\"dragInterval\"),values:c.data(\"values\"),from_fixed:c.data(\"fromFixed\"),from_min:c.data(\"fromMin\"),from_max:c.data(\"fromMax\"),from_shadow:c.data(\"fromShadow\"),to_fixed:c.data(\"toFixed\"),to_min:c.data(\"toMin\"),to_max:c.data(\"toMax\"),to_shadow:c.data(\"toShadow\"),prettify_enabled:c.data(\"prettifyEnabled\"),prettify_separator:c.data(\"prettifySeparator\"),force_edges:c.data(\"forceEdges\"),keyboard:c.data(\"keyboard\"),\r\n    keyboard_step:c.data(\"keyboardStep\"),grid:c.data(\"grid\"),grid_margin:c.data(\"gridMargin\"),grid_num:c.data(\"gridNum\"),grid_snap:c.data(\"gridSnap\"),hide_min_max:c.data(\"hideMinMax\"),hide_from_to:c.data(\"hideFromTo\"),prefix:c.data(\"prefix\"),postfix:c.data(\"postfix\"),max_postfix:c.data(\"maxPostfix\"),decorate_both:c.data(\"decorateBoth\"),values_separator:c.data(\"valuesSeparator\"),input_values_separator:c.data(\"inputValuesSeparator\"),disable:c.data(\"disable\")};c.values=c.values&&c.values.split(\",\");for(e in c)c.hasOwnProperty(e)&&\r\n(c[e]!==q&&\"\"!==c[e]||delete c[e]);a!==q&&\"\"!==a&&(a=a.split(c.input_values_separator||b.input_values_separator||\";\"),a[0]&&a[0]==+a[0]&&(a[0]=+a[0]),a[1]&&a[1]==+a[1]&&(a[1]=+a[1]),b&&b.values&&b.values.length?(d.from=a[0]&&b.values.indexOf(a[0]),d.to=a[1]&&b.values.indexOf(a[1])):(d.from=a[0]&&+a[0],d.to=a[1]&&+a[1]));f.extend(d,b);f.extend(d,c);this.options=d;this.update_check={};this.validate();this.result={input:this.$cache.input,slider:null,min:this.options.min,max:this.options.max,from:this.options.from,\r\n    from_percent:0,from_value:null,to:this.options.to,to_percent:0,to_value:null};this.init()};r.prototype={init:function(a){this.no_diapason=!1;this.coords.p_step=this.convertToPercent(this.options.step,!0);this.target=\"base\";this.toggleInput();this.append();this.setMinMax();a?(this.force_redraw=!0,this.calc(!0),this.callOnUpdate()):(this.force_redraw=!0,this.calc(!0),this.callOnStart());this.updateScene()},append:function(){this.$cache.input.before('<span class=\"irs js-irs-'+this.plugin_count+'\"></span>');\r\n        this.$cache.input.prop(\"readonly\",!0);this.$cache.cont=this.$cache.input.prev();this.result.slider=this.$cache.cont;this.$cache.cont.html('<span class=\"irs\"><span class=\"irs-line\" tabindex=\"-1\"><span class=\"irs-line-left\"></span><span class=\"irs-line-mid\"></span><span class=\"irs-line-right\"></span></span><span class=\"irs-min\">0</span><span class=\"irs-max\">1</span><span class=\"irs-from\">0</span><span class=\"irs-to\">0</span><span class=\"irs-single\">0</span></span><span class=\"irs-grid\"></span><span class=\"irs-bar\"></span>');\r\n        this.$cache.rs=this.$cache.cont.find(\".irs\");this.$cache.min=this.$cache.cont.find(\".irs-min\");this.$cache.max=this.$cache.cont.find(\".irs-max\");this.$cache.from=this.$cache.cont.find(\".irs-from\");this.$cache.to=this.$cache.cont.find(\".irs-to\");this.$cache.single=this.$cache.cont.find(\".irs-single\");this.$cache.bar=this.$cache.cont.find(\".irs-bar\");this.$cache.line=this.$cache.cont.find(\".irs-line\");this.$cache.grid=this.$cache.cont.find(\".irs-grid\");\"single\"===this.options.type?(this.$cache.cont.append('<span class=\"irs-bar-edge\"></span><span class=\"irs-shadow shadow-single\"></span><span class=\"irs-slider single\"></span>'),\r\n            this.$cache.edge=this.$cache.cont.find(\".irs-bar-edge\"),this.$cache.s_single=this.$cache.cont.find(\".single\"),this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.shad_single=this.$cache.cont.find(\".shadow-single\")):(this.$cache.cont.append('<span class=\"irs-shadow shadow-from\"></span><span class=\"irs-shadow shadow-to\"></span><span class=\"irs-slider from\"></span><span class=\"irs-slider to\"></span>'),this.$cache.s_from=this.$cache.cont.find(\".from\"),\r\n            this.$cache.s_to=this.$cache.cont.find(\".to\"),this.$cache.shad_from=this.$cache.cont.find(\".shadow-from\"),this.$cache.shad_to=this.$cache.cont.find(\".shadow-to\"),this.setTopHandler());this.options.hide_from_to&&(this.$cache.from[0].style.display=\"none\",this.$cache.to[0].style.display=\"none\",this.$cache.single[0].style.display=\"none\");this.appendGrid();this.options.disable?(this.appendDisableMask(),this.$cache.input[0].disabled=!0):(this.$cache.cont.removeClass(\"irs-disabled\"),this.$cache.input[0].disabled=\r\n            !1,this.bindEvents());this.options.drag_interval&&(this.$cache.bar[0].style.cursor=\"ew-resize\")},setTopHandler:function(){var a=this.options.max,b=this.options.to;this.options.from>this.options.min&&b===a?this.$cache.s_from.addClass(\"type_last\"):b<a&&this.$cache.s_to.addClass(\"type_last\")},changeLevel:function(a){switch(a){case \"single\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_single_fake);break;case \"from\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake);\r\n        this.$cache.s_from.addClass(\"state_hover\");this.$cache.s_from.addClass(\"type_last\");this.$cache.s_to.removeClass(\"type_last\");break;case \"to\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_to_fake);this.$cache.s_to.addClass(\"state_hover\");this.$cache.s_to.addClass(\"type_last\");this.$cache.s_from.removeClass(\"type_last\");break;case \"both\":this.coords.p_gap_left=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake),this.coords.p_gap_right=this.toFixed(this.coords.p_to_fake-\r\n        this.coords.p_pointer),this.$cache.s_to.removeClass(\"type_last\"),this.$cache.s_from.removeClass(\"type_last\")}},appendDisableMask:function(){this.$cache.cont.append('<span class=\"irs-disable-mask\"></span>');this.$cache.cont.addClass(\"irs-disabled\")},remove:function(){this.$cache.cont.remove();this.$cache.cont=null;this.$cache.line.off(\"keydown.irs_\"+this.plugin_count);this.$cache.body.off(\"touchmove.irs_\"+this.plugin_count);this.$cache.body.off(\"mousemove.irs_\"+this.plugin_count);this.$cache.win.off(\"touchend.irs_\"+\r\n        this.plugin_count);this.$cache.win.off(\"mouseup.irs_\"+this.plugin_count);m&&(this.$cache.body.off(\"mouseup.irs_\"+this.plugin_count),this.$cache.body.off(\"mouseleave.irs_\"+this.plugin_count));this.$cache.grid_labels=[];this.coords.big=[];this.coords.big_w=[];this.coords.big_p=[];this.coords.big_x=[];cancelAnimationFrame(this.raf_id)},bindEvents:function(){if(!this.no_diapason){this.$cache.body.on(\"touchmove.irs_\"+this.plugin_count,this.pointerMove.bind(this));this.$cache.body.on(\"mousemove.irs_\"+this.plugin_count,\r\n        this.pointerMove.bind(this));this.$cache.win.on(\"touchend.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.win.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.line.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.$cache.line.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.options.drag_interval&&\"double\"===this.options.type?(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\r\n        \"both\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"both\"))):(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));\"single\"===this.options.type?(this.$cache.single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),\r\n        this.$cache.shad_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.edge.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"))):(this.$cache.single.on(\"touchstart.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),\r\n        this.$cache.shad_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"mousedown.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.shad_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));if(this.options.keyboard)this.$cache.line.on(\"keydown.irs_\"+this.plugin_count,this.key.bind(this,\"keyboard\"));m&&(this.$cache.body.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this)),this.$cache.body.on(\"mouseleave.irs_\"+this.plugin_count,this.pointerUp.bind(this)))}},\r\n    pointerMove:function(a){this.dragging&&(this.coords.x_pointer=(a.pageX||a.originalEvent.touches&&a.originalEvent.touches[0].pageX)-this.coords.x_gap,this.calc())},pointerUp:function(a){this.current_plugin===this.plugin_count&&this.is_active&&(this.is_active=!1,this.$cache.cont.find(\".state_hover\").removeClass(\"state_hover\"),this.force_redraw=!0,m&&f(\"*\").prop(\"unselectable\",!1),this.updateScene(),this.restoreOriginalMinInterval(),(f.contains(this.$cache.cont[0],a.target)||this.dragging)&&this.callOnFinish(),\r\n        this.dragging=!1)},pointerDown:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(\"both\"===a&&this.setTempMinInterval(),a||(a=this.target||\"from\"),this.current_plugin=this.plugin_count,this.target=a,this.dragging=this.is_active=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=d-this.coords.x_gap,this.calcPointerPercent(),this.changeLevel(a),m&&f(\"*\").prop(\"unselectable\",!0),this.$cache.line.trigger(\"focus\"),\r\n        this.updateScene())},pointerClick:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(this.current_plugin=this.plugin_count,this.target=a,this.is_click=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=+(d-this.coords.x_gap).toFixed(),this.force_redraw=!0,this.calc(),this.$cache.line.trigger(\"focus\"))},key:function(a,b){if(!(this.current_plugin!==this.plugin_count||b.altKey||b.ctrlKey||b.shiftKey||b.metaKey)){switch(b.which){case 83:case 65:case 40:case 37:b.preventDefault();\r\n        this.moveByKey(!1);break;case 87:case 68:case 38:case 39:b.preventDefault(),this.moveByKey(!0)}return!0}},moveByKey:function(a){var b=this.coords.p_pointer,b=a?b+this.options.keyboard_step:b-this.options.keyboard_step;this.coords.x_pointer=this.toFixed(this.coords.w_rs/100*b);this.is_key=!0;this.calc()},setMinMax:function(){this.options&&(this.options.hide_min_max?(this.$cache.min[0].style.display=\"none\",this.$cache.max[0].style.display=\"none\"):(this.options.values.length?(this.$cache.min.html(this.decorate(this.options.p_values[this.options.min])),\r\n        this.$cache.max.html(this.decorate(this.options.p_values[this.options.max]))):(this.$cache.min.html(this.decorate(this._prettify(this.options.min),this.options.min)),this.$cache.max.html(this.decorate(this._prettify(this.options.max),this.options.max))),this.labels.w_min=this.$cache.min.outerWidth(!1),this.labels.w_max=this.$cache.max.outerWidth(!1)))},setTempMinInterval:function(){var a=this.result.to-this.result.from;null===this.old_min_interval&&(this.old_min_interval=this.options.min_interval);\r\n        this.options.min_interval=a},restoreOriginalMinInterval:function(){null!==this.old_min_interval&&(this.options.min_interval=this.old_min_interval,this.old_min_interval=null)},calc:function(a){if(this.options){this.calc_count++;if(10===this.calc_count||a)this.calc_count=0,this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.calcHandlePercent();if(this.coords.w_rs){this.calcPointerPercent();a=this.getHandleX();\"both\"===this.target&&(this.coords.p_gap=0,a=this.getHandleX());\"click\"===this.target&&(this.coords.p_gap=\r\n        this.coords.p_handle/2,a=this.getHandleX(),this.target=this.options.drag_interval?\"both_one\":this.chooseHandle(a));switch(this.target){case \"base\":var b=(this.options.max-this.options.min)/100;a=(this.result.from-this.options.min)/b;b=(this.result.to-this.options.min)/b;this.coords.p_single_real=this.toFixed(a);this.coords.p_from_real=this.toFixed(a);this.coords.p_to_real=this.toFixed(b);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);\r\n        this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);this.target=null;break;case \"single\":if(this.options.from_fixed)break;\r\n        this.coords.p_single_real=this.convertToRealPercent(a);this.coords.p_single_real=this.calcWithStep(this.coords.p_single_real);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);break;case \"from\":if(this.options.from_fixed)break;this.coords.p_from_real=this.convertToRealPercent(a);this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real>\r\n    this.coords.p_to_real&&(this.coords.p_from_real=this.coords.p_to_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_real=this.checkMaxInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);break;case \"to\":if(this.options.to_fixed)break;\r\n        this.coords.p_to_real=this.convertToRealPercent(a);this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real<this.coords.p_from_real&&(this.coords.p_to_real=this.coords.p_from_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_real=this.checkMaxInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");\r\n        this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);break;case \"both\":if(this.options.from_fixed||this.options.to_fixed)break;a=this.toFixed(a+.001*this.coords.p_handle);this.coords.p_from_real=this.convertToRealPercent(a)-this.coords.p_gap_left;this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,\r\n        this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.convertToRealPercent(a)+this.coords.p_gap_right;this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);\r\n        break;case \"both_one\":if(!this.options.from_fixed&&!this.options.to_fixed){var d=this.convertToRealPercent(a);a=this.result.to_percent-this.result.from_percent;var c=a/2,b=d-c,d=d+c;0>b&&(b=0,d=b+a);100<d&&(d=100,b=d-a);this.coords.p_from_real=this.calcWithStep(b);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.calcWithStep(d);this.coords.p_to_real=\r\n        this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real)}}\"single\"===this.options.type?(this.coords.p_bar_x=this.coords.p_handle/2,this.coords.p_bar_w=this.coords.p_single_fake,this.result.from_percent=this.coords.p_single_real,this.result.from=this.convertToValue(this.coords.p_single_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from])):(this.coords.p_bar_x=\r\n        this.toFixed(this.coords.p_from_fake+this.coords.p_handle/2),this.coords.p_bar_w=this.toFixed(this.coords.p_to_fake-this.coords.p_from_fake),this.result.from_percent=this.coords.p_from_real,this.result.from=this.convertToValue(this.coords.p_from_real),this.result.to_percent=this.coords.p_to_real,this.result.to=this.convertToValue(this.coords.p_to_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from],this.result.to_value=this.options.values[this.result.to]));\r\n        this.calcMinMax();this.calcLabels()}}},calcPointerPercent:function(){this.coords.w_rs?(0>this.coords.x_pointer||isNaN(this.coords.x_pointer)?this.coords.x_pointer=0:this.coords.x_pointer>this.coords.w_rs&&(this.coords.x_pointer=this.coords.w_rs),this.coords.p_pointer=this.toFixed(this.coords.x_pointer/this.coords.w_rs*100)):this.coords.p_pointer=0},convertToRealPercent:function(a){return a/(100-this.coords.p_handle)*100},convertToFakePercent:function(a){return a/100*(100-this.coords.p_handle)},getHandleX:function(){var a=\r\n        100-this.coords.p_handle,b=this.toFixed(this.coords.p_pointer-this.coords.p_gap);0>b?b=0:b>a&&(b=a);return b},calcHandlePercent:function(){this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1);this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100)},chooseHandle:function(a){return\"single\"===this.options.type?\"single\":a>=this.coords.p_from_real+(this.coords.p_to_real-this.coords.p_from_real)/2?this.options.to_fixed?\r\n        \"from\":\"to\":this.options.from_fixed?\"to\":\"from\"},calcMinMax:function(){this.coords.w_rs&&(this.labels.p_min=this.labels.w_min/this.coords.w_rs*100,this.labels.p_max=this.labels.w_max/this.coords.w_rs*100)},calcLabels:function(){this.coords.w_rs&&!this.options.hide_from_to&&(\"single\"===this.options.type?(this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=this.coords.p_single_fake+this.coords.p_handle/\r\n        2-this.labels.p_single_fake/2):(this.labels.w_from=this.$cache.from.outerWidth(!1),this.labels.p_from_fake=this.labels.w_from/this.coords.w_rs*100,this.labels.p_from_left=this.coords.p_from_fake+this.coords.p_handle/2-this.labels.p_from_fake/2,this.labels.p_from_left=this.toFixed(this.labels.p_from_left),this.labels.p_from_left=this.checkEdges(this.labels.p_from_left,this.labels.p_from_fake),this.labels.w_to=this.$cache.to.outerWidth(!1),this.labels.p_to_fake=this.labels.w_to/this.coords.w_rs*100,\r\n        this.labels.p_to_left=this.coords.p_to_fake+this.coords.p_handle/2-this.labels.p_to_fake/2,this.labels.p_to_left=this.toFixed(this.labels.p_to_left),this.labels.p_to_left=this.checkEdges(this.labels.p_to_left,this.labels.p_to_fake),this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=(this.labels.p_from_left+this.labels.p_to_left+this.labels.p_to_fake)/2-this.labels.p_single_fake/2,this.labels.p_single_left=\r\n        this.toFixed(this.labels.p_single_left)),this.labels.p_single_left=this.checkEdges(this.labels.p_single_left,this.labels.p_single_fake))},updateScene:function(){this.raf_id&&(cancelAnimationFrame(this.raf_id),this.raf_id=null);clearTimeout(this.update_tm);this.update_tm=null;this.options&&(this.drawHandles(),this.is_active?this.raf_id=requestAnimationFrame(this.updateScene.bind(this)):this.update_tm=setTimeout(this.updateScene.bind(this),300))},drawHandles:function(){this.coords.w_rs=this.$cache.rs.outerWidth(!1);\r\n        if(this.coords.w_rs){this.coords.w_rs!==this.coords.w_rs_old&&(this.target=\"base\",this.is_resize=!0);if(this.coords.w_rs!==this.coords.w_rs_old||this.force_redraw)this.setMinMax(),this.calc(!0),this.drawLabels(),this.options.grid&&(this.calcGridMargin(),this.calcGridLabels()),this.force_redraw=!0,this.coords.w_rs_old=this.coords.w_rs,this.drawShadow();if(this.coords.w_rs&&(this.dragging||this.force_redraw||this.is_key)){if(this.old_from!==this.result.from||this.old_to!==this.result.to||this.force_redraw||\r\n            this.is_key){this.drawLabels();this.$cache.bar[0].style.left=this.coords.p_bar_x+\"%\";this.$cache.bar[0].style.width=this.coords.p_bar_w+\"%\";if(\"single\"===this.options.type)this.$cache.s_single[0].style.left=this.coords.p_single_fake+\"%\";else{this.$cache.s_from[0].style.left=this.coords.p_from_fake+\"%\";this.$cache.s_to[0].style.left=this.coords.p_to_fake+\"%\";if(this.old_from!==this.result.from||this.force_redraw)this.$cache.from[0].style.left=this.labels.p_from_left+\"%\";if(this.old_to!==this.result.to||\r\n            this.force_redraw)this.$cache.to[0].style.left=this.labels.p_to_left+\"%\"}this.$cache.single[0].style.left=this.labels.p_single_left+\"%\";this.writeToInput();this.old_from===this.result.from&&this.old_to===this.result.to||this.is_start||(this.$cache.input.trigger(\"change\"),this.$cache.input.trigger(\"input\"));this.old_from=this.result.from;this.old_to=this.result.to;this.is_resize||this.is_update||this.is_start||this.is_finish||this.callOnChange();if(this.is_key||this.is_click||this.is_first_update)this.is_first_update=\r\n            this.is_click=this.is_key=!1,this.callOnFinish();this.is_finish=this.is_resize=this.is_update=!1}this.force_redraw=this.is_click=this.is_key=this.is_start=!1}}},drawLabels:function(){if(this.options){var a=this.options.values.length,b=this.options.p_values,d;if(!this.options.hide_from_to)if(\"single\"===this.options.type)a=a?this.decorate(b[this.result.from]):this.decorate(this._prettify(this.result.from),this.result.from),this.$cache.single.html(a),this.calcLabels(),this.$cache.min[0].style.visibility=\r\n        this.labels.p_single_left<this.labels.p_min+1?\"hidden\":\"visible\",this.$cache.max[0].style.visibility=this.labels.p_single_left+this.labels.p_single_fake>100-this.labels.p_max-1?\"hidden\":\"visible\";else{a?(this.options.decorate_both?(a=this.decorate(b[this.result.from]),a+=this.options.values_separator,a+=this.decorate(b[this.result.to])):a=this.decorate(b[this.result.from]+this.options.values_separator+b[this.result.to]),d=this.decorate(b[this.result.from]),b=this.decorate(b[this.result.to])):(this.options.decorate_both?\r\n        (a=this.decorate(this._prettify(this.result.from),this.result.from),a+=this.options.values_separator,a+=this.decorate(this._prettify(this.result.to),this.result.to)):a=this.decorate(this._prettify(this.result.from)+this.options.values_separator+this._prettify(this.result.to),this.result.to),d=this.decorate(this._prettify(this.result.from),this.result.from),b=this.decorate(this._prettify(this.result.to),this.result.to));this.$cache.single.html(a);this.$cache.from.html(d);this.$cache.to.html(b);this.calcLabels();\r\n        b=Math.min(this.labels.p_single_left,this.labels.p_from_left);a=this.labels.p_single_left+this.labels.p_single_fake;d=this.labels.p_to_left+this.labels.p_to_fake;var c=Math.max(a,d);this.labels.p_from_left+this.labels.p_from_fake>=this.labels.p_to_left?(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",this.result.from===this.result.to?(\"from\"===this.target?this.$cache.from[0].style.visibility=\"visible\":\"to\"===\r\n        this.target?this.$cache.to[0].style.visibility=\"visible\":this.target||(this.$cache.from[0].style.visibility=\"visible\"),this.$cache.single[0].style.visibility=\"hidden\",c=d):(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",c=Math.max(a,d))):(this.$cache.from[0].style.visibility=\"visible\",this.$cache.to[0].style.visibility=\"visible\",this.$cache.single[0].style.visibility=\"hidden\");this.$cache.min[0].style.visibility=\r\n            b<this.labels.p_min+1?\"hidden\":\"visible\";this.$cache.max[0].style.visibility=c>100-this.labels.p_max-1?\"hidden\":\"visible\"}}},drawShadow:function(){var a=this.options,b=this.$cache,d=\"number\"===typeof a.from_min&&!isNaN(a.from_min),c=\"number\"===typeof a.from_max&&!isNaN(a.from_max),e=\"number\"===typeof a.to_min&&!isNaN(a.to_min),g=\"number\"===typeof a.to_max&&!isNaN(a.to_max);\"single\"===a.type?a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-\r\n        d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_single[0].style.display=\"block\",b.shad_single[0].style.left=d+\"%\",b.shad_single[0].style.width=c+\"%\"):b.shad_single[0].style.display=\"none\":(a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_from[0].style.display=\r\n        \"block\",b.shad_from[0].style.left=d+\"%\",b.shad_from[0].style.width=c+\"%\"):b.shad_from[0].style.display=\"none\",a.to_shadow&&(e||g)?(e=this.convertToPercent(e?a.to_min:a.min),a=this.convertToPercent(g?a.to_max:a.max)-e,e=this.toFixed(e-this.coords.p_handle/100*e),a=this.toFixed(a-this.coords.p_handle/100*a),e+=this.coords.p_handle/2,b.shad_to[0].style.display=\"block\",b.shad_to[0].style.left=e+\"%\",b.shad_to[0].style.width=a+\"%\"):b.shad_to[0].style.display=\"none\")},writeToInput:function(){\"single\"===\r\n    this.options.type?(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value):this.$cache.input.prop(\"value\",this.result.from),this.$cache.input.data(\"from\",this.result.from)):(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value+this.options.input_values_separator+this.result.to_value):this.$cache.input.prop(\"value\",this.result.from+this.options.input_values_separator+this.result.to),this.$cache.input.data(\"from\",this.result.from),this.$cache.input.data(\"to\",\r\n        this.result.to))},callOnStart:function(){this.writeToInput();if(this.options.onStart&&\"function\"===typeof this.options.onStart)this.options.onStart(this.result)},callOnChange:function(){this.writeToInput();if(this.options.onChange&&\"function\"===typeof this.options.onChange)this.options.onChange(this.result)},callOnFinish:function(){this.writeToInput();if(this.options.onFinish&&\"function\"===typeof this.options.onFinish)this.options.onFinish(this.result)},callOnUpdate:function(){this.writeToInput();\r\n        if(this.options.onUpdate&&\"function\"===typeof this.options.onUpdate)this.options.onUpdate(this.result)},toggleInput:function(){this.$cache.input.toggleClass(\"irs-hidden-input\")},convertToPercent:function(a,b){var d=this.options.max-this.options.min;return d?this.toFixed((b?a:a-this.options.min)/(d/100)):(this.no_diapason=!0,0)},convertToValue:function(a){var b=this.options.min,d=this.options.max,c=b.toString().split(\".\")[1],e=d.toString().split(\".\")[1],g,l,f=0,k=0;if(0===a)return this.options.min;\r\n        if(100===a)return this.options.max;c&&(f=g=c.length);e&&(f=l=e.length);g&&l&&(f=g>=l?g:l);0>b&&(k=Math.abs(b),b=+(b+k).toFixed(f),d=+(d+k).toFixed(f));a=(d-b)/100*a+b;(b=this.options.step.toString().split(\".\")[1])?a=+a.toFixed(b.length):(a/=this.options.step,a*=this.options.step,a=+a.toFixed(0));k&&(a-=k);k=b?+a.toFixed(b.length):this.toFixed(a);k<this.options.min?k=this.options.min:k>this.options.max&&(k=this.options.max);return k},calcWithStep:function(a){var b=Math.round(a/this.coords.p_step)*\r\n        this.coords.p_step;100<b&&(b=100);100===a&&(b=100);return this.toFixed(b)},checkMinInterval:function(a,b,d){var c=this.options;if(!c.min_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a<c.min_interval&&(a=b-c.min_interval):a-b<c.min_interval&&(a=b+c.min_interval);return this.convertToPercent(a)},checkMaxInterval:function(a,b,d){var c=this.options;if(!c.max_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a>c.max_interval&&(a=b-c.max_interval):\r\n        a-b>c.max_interval&&(a=b+c.max_interval);return this.convertToPercent(a)},checkDiapason:function(a,b,d){a=this.convertToValue(a);var c=this.options;\"number\"!==typeof b&&(b=c.min);\"number\"!==typeof d&&(d=c.max);a<b&&(a=b);a>d&&(a=d);return this.convertToPercent(a)},toFixed:function(a){a=a.toFixed(20);return+a},_prettify:function(a){return this.options.prettify_enabled?this.options.prettify&&\"function\"===typeof this.options.prettify?this.options.prettify(a):this.prettify(a):a},prettify:function(a){return a.toString().replace(/(\\d{1,3}(?=(?:\\d\\d\\d)+(?!\\d)))/g,\r\n        \"$1\"+this.options.prettify_separator)},checkEdges:function(a,b){if(!this.options.force_edges)return this.toFixed(a);0>a?a=0:a>100-b&&(a=100-b);return this.toFixed(a)},validate:function(){var a=this.options,b=this.result,d=a.values,c=d.length,e,g;\"string\"===typeof a.min&&(a.min=+a.min);\"string\"===typeof a.max&&(a.max=+a.max);\"string\"===typeof a.from&&(a.from=+a.from);\"string\"===typeof a.to&&(a.to=+a.to);\"string\"===typeof a.step&&(a.step=+a.step);\"string\"===typeof a.from_min&&(a.from_min=+a.from_min);\r\n        \"string\"===typeof a.from_max&&(a.from_max=+a.from_max);\"string\"===typeof a.to_min&&(a.to_min=+a.to_min);\"string\"===typeof a.to_max&&(a.to_max=+a.to_max);\"string\"===typeof a.keyboard_step&&(a.keyboard_step=+a.keyboard_step);\"string\"===typeof a.grid_num&&(a.grid_num=+a.grid_num);a.max<a.min&&(a.max=a.min);if(c)for(a.p_values=[],a.min=0,a.max=c-1,a.step=1,a.grid_num=a.max,a.grid_snap=!0,g=0;g<c;g++)e=+d[g],isNaN(e)?e=d[g]:(d[g]=e,e=this._prettify(e)),a.p_values.push(e);if(\"number\"!==typeof a.from||isNaN(a.from))a.from=\r\n            a.min;if(\"number\"!==typeof a.to||isNaN(a.to))a.to=a.max;\"single\"===a.type?(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max)):(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max),a.to<a.min&&(a.to=a.min),a.to>a.max&&(a.to=a.max),this.update_check.from&&(this.update_check.from!==a.from&&a.from>a.to&&(a.from=a.to),this.update_check.to!==a.to&&a.to<a.from&&(a.to=a.from)),a.from>a.to&&(a.from=a.to),a.to<a.from&&(a.to=a.from));if(\"number\"!==typeof a.step||isNaN(a.step)||!a.step||0>a.step)a.step=\r\n            1;if(\"number\"!==typeof a.keyboard_step||isNaN(a.keyboard_step)||!a.keyboard_step||0>a.keyboard_step)a.keyboard_step=5;\"number\"===typeof a.from_min&&a.from<a.from_min&&(a.from=a.from_min);\"number\"===typeof a.from_max&&a.from>a.from_max&&(a.from=a.from_max);\"number\"===typeof a.to_min&&a.to<a.to_min&&(a.to=a.to_min);\"number\"===typeof a.to_max&&a.from>a.to_max&&(a.to=a.to_max);if(b){b.min!==a.min&&(b.min=a.min);b.max!==a.max&&(b.max=a.max);if(b.from<b.min||b.from>b.max)b.from=a.from;if(b.to<b.min||b.to>\r\n            b.max)b.to=a.to}if(\"number\"!==typeof a.min_interval||isNaN(a.min_interval)||!a.min_interval||0>a.min_interval)a.min_interval=0;if(\"number\"!==typeof a.max_interval||isNaN(a.max_interval)||!a.max_interval||0>a.max_interval)a.max_interval=0;a.min_interval&&a.min_interval>a.max-a.min&&(a.min_interval=a.max-a.min);a.max_interval&&a.max_interval>a.max-a.min&&(a.max_interval=a.max-a.min)},decorate:function(a,b){var d=\"\",c=this.options;c.prefix&&(d+=c.prefix);d+=a;c.max_postfix&&(c.values.length&&a===c.p_values[c.max]?\r\n        (d+=c.max_postfix,c.postfix&&(d+=\" \")):b===c.max&&(d+=c.max_postfix,c.postfix&&(d+=\" \")));c.postfix&&(d+=c.postfix);return d},updateFrom:function(){this.result.from=this.options.from;this.result.from_percent=this.convertToPercent(this.result.from);this.options.values&&(this.result.from_value=this.options.values[this.result.from])},updateTo:function(){this.result.to=this.options.to;this.result.to_percent=this.convertToPercent(this.result.to);this.options.values&&(this.result.to_value=this.options.values[this.result.to])},\r\n    updateResult:function(){this.result.min=this.options.min;this.result.max=this.options.max;this.updateFrom();this.updateTo()},appendGrid:function(){if(this.options.grid){var a=this.options,b,d;b=a.max-a.min;var c=a.grid_num,e,g,f=4,h,k,m,n=\"\";this.calcGridMargin();a.grid_snap?(c=b/a.step,e=this.toFixed(a.step/(b/100))):e=this.toFixed(100/c);4<c&&(f=3);7<c&&(f=2);14<c&&(f=1);28<c&&(f=0);for(b=0;b<c+1;b++){h=f;g=this.toFixed(e*b);100<g&&(g=100,h-=2,0>h&&(h=0));this.coords.big[b]=g;k=(g-e*(b-1))/(h+1);\r\n        for(d=1;d<=h&&0!==g;d++)m=this.toFixed(g-k*d),n+='<span class=\"irs-grid-pol small\" style=\"left: '+m+'%\"></span>';n+='<span class=\"irs-grid-pol\" style=\"left: '+g+'%\"></span>';d=this.convertToValue(g);d=a.values.length?a.p_values[d]:this._prettify(d);n+='<span class=\"irs-grid-text js-grid-text-'+b+'\" style=\"left: '+g+'%\">'+d+\"</span>\"}this.coords.big_num=Math.ceil(c+1);this.$cache.cont.addClass(\"irs-with-grid\");this.$cache.grid.html(n);this.cacheGridLabels()}},cacheGridLabels:function(){var a,b,d=this.coords.big_num;\r\n        for(b=0;b<d;b++)a=this.$cache.grid.find(\".js-grid-text-\"+b),this.$cache.grid_labels.push(a);this.calcGridLabels()},calcGridLabels:function(){var a,b;b=[];var d=[],c=this.coords.big_num;for(a=0;a<c;a++)this.coords.big_w[a]=this.$cache.grid_labels[a].outerWidth(!1),this.coords.big_p[a]=this.toFixed(this.coords.big_w[a]/this.coords.w_rs*100),this.coords.big_x[a]=this.toFixed(this.coords.big_p[a]/2),b[a]=this.toFixed(this.coords.big[a]-this.coords.big_x[a]),d[a]=this.toFixed(b[a]+this.coords.big_p[a]);\r\n        this.options.force_edges&&(b[0]<-this.coords.grid_gap&&(b[0]=-this.coords.grid_gap,d[0]=this.toFixed(b[0]+this.coords.big_p[0]),this.coords.big_x[0]=this.coords.grid_gap),d[c-1]>100+this.coords.grid_gap&&(d[c-1]=100+this.coords.grid_gap,b[c-1]=this.toFixed(d[c-1]-this.coords.big_p[c-1]),this.coords.big_x[c-1]=this.toFixed(this.coords.big_p[c-1]-this.coords.grid_gap)));this.calcGridCollision(2,b,d);this.calcGridCollision(4,b,d);for(a=0;a<c;a++)b=this.$cache.grid_labels[a][0],this.coords.big_x[a]!==\r\n        Number.POSITIVE_INFINITY&&(b.style.marginLeft=-this.coords.big_x[a]+\"%\")},calcGridCollision:function(a,b,d){var c,e,g,f=this.coords.big_num;for(c=0;c<f;c+=a){e=c+a/2;if(e>=f)break;g=this.$cache.grid_labels[e][0];g.style.visibility=d[c]<=b[e]?\"visible\":\"hidden\"}},calcGridMargin:function(){this.options.grid_margin&&(this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.coords.w_rs&&(this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1),\r\n        this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100),this.coords.grid_gap=this.toFixed(this.coords.p_handle/2-.1),this.$cache.grid[0].style.width=this.toFixed(100-this.coords.p_handle)+\"%\",this.$cache.grid[0].style.left=this.coords.grid_gap+\"%\"))},update:function(a){this.input&&(this.is_update=!0,this.options.from=this.result.from,this.options.to=this.result.to,this.update_check.from=this.result.from,this.update_check.to=this.result.to,this.options=f.extend(this.options,a),\r\n        this.validate(),this.updateResult(a),this.toggleInput(),this.remove(),this.init(!0))},reset:function(){this.input&&(this.updateResult(),this.update())},destroy:function(){this.input&&(this.toggleInput(),this.$cache.input.prop(\"readonly\",!1),f.data(this.input,\"ionRangeSlider\",null),this.remove(),this.options=this.input=null)}};f.fn.ionRangeSlider=function(a){return this.each(function(){f.data(this,\"ionRangeSlider\")||f.data(this,\"ionRangeSlider\",new r(this,a,u++))})};(function(){for(var a=0,b=[\"ms\",\r\n    \"moz\",\"webkit\",\"o\"],d=0;d<b.length&&!h.requestAnimationFrame;++d)h.requestAnimationFrame=h[b[d]+\"RequestAnimationFrame\"],h.cancelAnimationFrame=h[b[d]+\"CancelAnimationFrame\"]||h[b[d]+\"CancelRequestAnimationFrame\"];h.requestAnimationFrame||(h.requestAnimationFrame=function(b,d){var c=(new Date).getTime(),e=Math.max(0,16-(c-a)),f=h.setTimeout(function(){b(c+e)},e);a=c+e;return f});h.cancelAnimationFrame||(h.cancelAnimationFrame=function(a){clearTimeout(a)})})()});\r\n","Mageplaza_Core/js/jquery.magnific-popup.min.js":"// Magnific Popup v1.1.0 by Dmitry Semenov\r\n// http://bit.ly/magnific-popup#build=inline+image+ajax+iframe+gallery+retina+imagezoom\r\n(function(a){typeof define==\"function\"&&define.amd?define([\"jquery\"],a):typeof exports==\"object\"?a(require(\"jquery\")):a(window.jQuery||window.Zepto)})(function(a){var b=\"Close\",c=\"BeforeClose\",d=\"AfterClose\",e=\"BeforeAppend\",f=\"MarkupParse\",g=\"Open\",h=\"Change\",i=\"mfp\",j=\".\"+i,k=\"mfp-ready\",l=\"mfp-removing\",m=\"mfp-prevent-close\",n,o=function(){},p=!!window.jQuery,q,r=a(window),s,t,u,v,w=function(a,b){n.ev.on(i+a+j,b)},x=function(b,c,d,e){var f=document.createElement(\"div\");return f.className=\"mfp-\"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(b,c){n.ev.triggerHandler(i+b,c),n.st.callbacks&&(b=b.charAt(0).toLowerCase()+b.slice(1),n.st.callbacks[b]&&n.st.callbacks[b].apply(n,a.isArray(c)?c:[c]))},z=function(b){if(b!==v||!n.currTemplate.closeBtn)n.currTemplate.closeBtn=a(n.st.closeMarkup.replace(\"%title%\",n.st.tClose)),v=b;return n.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(n=new o,n.init(),a.magnificPopup.instance=n)},B=function(){var a=document.createElement(\"p\").style,b=[\"ms\",\"O\",\"Moz\",\"Webkit\"];if(a.transition!==undefined)return!0;while(b.length)if(b.pop()+\"Transition\"in a)return!0;return!1};o.prototype={constructor:o,init:function(){var b=navigator.appVersion;n.isLowIE=n.isIE8=document.all&&!document.addEventListener,n.isAndroid=/android/gi.test(b),n.isIOS=/iphone|ipad|ipod/gi.test(b),n.supportsTransition=B(),n.probablyMobile=n.isAndroid||n.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),s=a(document),n.popupsCache={}},open:function(b){var c;if(b.isObj===!1){n.items=b.items.toArray(),n.index=0;var d=b.items,e;for(c=0;c<d.length;c++){e=d[c],e.parsed&&(e=e.el[0]);if(e===b.el[0]){n.index=c;break}}}else n.items=a.isArray(b.items)?b.items:[b.items],n.index=b.index||0;if(n.isOpen){n.updateItemHTML();return}n.types=[],u=\"\",b.mainEl&&b.mainEl.length?n.ev=b.mainEl.eq(0):n.ev=s,b.key?(n.popupsCache[b.key]||(n.popupsCache[b.key]={}),n.currTemplate=n.popupsCache[b.key]):n.currTemplate={},n.st=a.extend(!0,{},a.magnificPopup.defaults,b),n.fixedContentPos=n.st.fixedContentPos===\"auto\"?!n.probablyMobile:n.st.fixedContentPos,n.st.modal&&(n.st.closeOnContentClick=!1,n.st.closeOnBgClick=!1,n.st.showCloseBtn=!1,n.st.enableEscapeKey=!1),n.bgOverlay||(n.bgOverlay=x(\"bg\").on(\"click\"+j,function(){n.close()}),n.wrap=x(\"wrap\").attr(\"tabindex\",-1).on(\"click\"+j,function(a){n._checkIfClose(a.target)&&n.close()}),n.container=x(\"container\",n.wrap)),n.contentContainer=x(\"content\"),n.st.preloader&&(n.preloader=x(\"preloader\",n.container,n.st.tLoading));var h=a.magnificPopup.modules;for(c=0;c<h.length;c++){var i=h[c];i=i.charAt(0).toUpperCase()+i.slice(1),n[\"init\"+i].call(n)}y(\"BeforeOpen\"),n.st.showCloseBtn&&(n.st.closeBtnInside?(w(f,function(a,b,c,d){c.close_replaceWith=z(d.type)}),u+=\" mfp-close-btn-in\"):n.wrap.append(z())),n.st.alignTop&&(u+=\" mfp-align-top\"),n.fixedContentPos?n.wrap.css({overflow:n.st.overflowY,overflowX:\"hidden\",overflowY:n.st.overflowY}):n.wrap.css({top:r.scrollTop(),position:\"absolute\"}),(n.st.fixedBgPos===!1||n.st.fixedBgPos===\"auto\"&&!n.fixedContentPos)&&n.bgOverlay.css({height:s.height(),position:\"absolute\"}),n.st.enableEscapeKey&&s.on(\"keyup\"+j,function(a){a.keyCode===27&&n.close()}),r.on(\"resize\"+j,function(){n.updateSize()}),n.st.closeOnContentClick||(u+=\" mfp-auto-cursor\"),u&&n.wrap.addClass(u);var l=n.wH=r.height(),m={};if(n.fixedContentPos&&n._hasScrollBar(l)){var o=n._getScrollbarSize();o&&(m.marginRight=o)}n.fixedContentPos&&(n.isIE7?a(\"body, html\").css(\"overflow\",\"hidden\"):m.overflow=\"hidden\");var p=n.st.mainClass;return n.isIE7&&(p+=\" mfp-ie7\"),p&&n._addClassToMFP(p),n.updateItemHTML(),y(\"BuildControls\"),a(\"html\").css(m),n.bgOverlay.add(n.wrap).prependTo(n.st.prependTo||a(document.body)),n._lastFocusedEl=document.activeElement,setTimeout(function(){n.content?(n._addClassToMFP(k),n._setFocus()):n.bgOverlay.addClass(k),s.on(\"focusin\"+j,n._onFocusIn)},16),n.isOpen=!0,n.updateSize(l),y(g),b},close:function(){if(!n.isOpen)return;y(c),n.isOpen=!1,n.st.removalDelay&&!n.isLowIE&&n.supportsTransition?(n._addClassToMFP(l),setTimeout(function(){n._close()},n.st.removalDelay)):n._close()},_close:function(){y(b);var c=l+\" \"+k+\" \";n.bgOverlay.detach(),n.wrap.detach(),n.container.empty(),n.st.mainClass&&(c+=n.st.mainClass+\" \"),n._removeClassFromMFP(c);if(n.fixedContentPos){var e={marginRight:\"\"};n.isIE7?a(\"body, html\").css(\"overflow\",\"\"):e.overflow=\"\",a(\"html\").css(e)}s.off(\"keyup\"+j+\" focusin\"+j),n.ev.off(j),n.wrap.attr(\"class\",\"mfp-wrap\").removeAttr(\"style\"),n.bgOverlay.attr(\"class\",\"mfp-bg\"),n.container.attr(\"class\",\"mfp-container\"),n.st.showCloseBtn&&(!n.st.closeBtnInside||n.currTemplate[n.currItem.type]===!0)&&n.currTemplate.closeBtn&&n.currTemplate.closeBtn.detach(),n.st.autoFocusLast&&n._lastFocusedEl&&a(n._lastFocusedEl).focus(),n.currItem=null,n.content=null,n.currTemplate=null,n.prevHeight=0,y(d)},updateSize:function(a){if(n.isIOS){var b=document.documentElement.clientWidth/window.innerWidth,c=window.innerHeight*b;n.wrap.css(\"height\",c),n.wH=c}else n.wH=a||r.height();n.fixedContentPos||n.wrap.css(\"height\",n.wH),y(\"Resize\")},updateItemHTML:function(){var b=n.items[n.index];n.contentContainer.detach(),n.content&&n.content.detach(),b.parsed||(b=n.parseEl(n.index));var c=b.type;y(\"BeforeChange\",[n.currItem?n.currItem.type:\"\",c]),n.currItem=b;if(!n.currTemplate[c]){var d=n.st[c]?n.st[c].markup:!1;y(\"FirstMarkupParse\",d),d?n.currTemplate[c]=a(d):n.currTemplate[c]=!0}t&&t!==b.type&&n.container.removeClass(\"mfp-\"+t+\"-holder\");var e=n[\"get\"+c.charAt(0).toUpperCase()+c.slice(1)](b,n.currTemplate[c]);n.appendContent(e,c),b.preloaded=!0,y(h,b),t=b.type,n.container.prepend(n.contentContainer),y(\"AfterChange\")},appendContent:function(a,b){n.content=a,a?n.st.showCloseBtn&&n.st.closeBtnInside&&n.currTemplate[b]===!0?n.content.find(\".mfp-close\").length||n.content.append(z()):n.content=a:n.content=\"\",y(e),n.container.addClass(\"mfp-\"+b+\"-holder\"),n.contentContainer.append(n.content)},parseEl:function(b){var c=n.items[b],d;c.tagName?c={el:a(c)}:(d=c.type,c={data:c,src:c.src});if(c.el){var e=n.types;for(var f=0;f<e.length;f++)if(c.el.hasClass(\"mfp-\"+e[f])){d=e[f];break}c.src=c.el.attr(\"data-mfp-src\"),c.src||(c.src=c.el.attr(\"href\"))}return c.type=d||n.st.type||\"inline\",c.index=b,c.parsed=!0,n.items[b]=c,y(\"ElementParse\",c),n.items[b]},addGroup:function(a,b){var c=function(c){c.mfpEl=this,n._openClick(c,a,b)};b||(b={});var d=\"click.magnificPopup\";b.mainEl=a,b.items?(b.isObj=!0,a.off(d).on(d,c)):(b.isObj=!1,b.delegate?a.off(d).on(d,b.delegate,c):(b.items=a,a.off(d).on(d,c)))},_openClick:function(b,c,d){var e=d.midClick!==undefined?d.midClick:a.magnificPopup.defaults.midClick;if(!e&&(b.which===2||b.ctrlKey||b.metaKey||b.altKey||b.shiftKey))return;var f=d.disableOn!==undefined?d.disableOn:a.magnificPopup.defaults.disableOn;if(f)if(a.isFunction(f)){if(!f.call(n))return!0}else if(r.width()<f)return!0;b.type&&(b.preventDefault(),n.isOpen&&b.stopPropagation()),d.el=a(b.mfpEl),d.delegate&&(d.items=c.find(d.delegate)),n.open(d)},updateStatus:function(a,b){if(n.preloader){q!==a&&n.container.removeClass(\"mfp-s-\"+q),!b&&a===\"loading\"&&(b=n.st.tLoading);var c={status:a,text:b};y(\"UpdateStatus\",c),a=c.status,b=c.text,n.preloader.html(b),n.preloader.find(\"a\").on(\"click\",function(a){a.stopImmediatePropagation()}),n.container.addClass(\"mfp-s-\"+a),q=a}},_checkIfClose:function(b){if(a(b).hasClass(m))return;var c=n.st.closeOnContentClick,d=n.st.closeOnBgClick;if(c&&d)return!0;if(!n.content||a(b).hasClass(\"mfp-close\")||n.preloader&&b===n.preloader[0])return!0;if(b!==n.content[0]&&!a.contains(n.content[0],b)){if(d&&a.contains(document,b))return!0}else if(c)return!0;return!1},_addClassToMFP:function(a){n.bgOverlay.addClass(a),n.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),n.wrap.removeClass(a)},_hasScrollBar:function(a){return(n.isIE7?s.height():document.body.scrollHeight)>(a||r.height())},_setFocus:function(){(n.st.focus?n.content.find(n.st.focus).eq(0):n.wrap).focus()},_onFocusIn:function(b){if(b.target!==n.wrap[0]&&!a.contains(n.wrap[0],b.target))return n._setFocus(),!1},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(f,[b,c,d]),a.each(c,function(c,d){if(d===undefined||d===!1)return!0;e=c.split(\"_\");if(e.length>1){var f=b.find(j+\"-\"+e[0]);if(f.length>0){var g=e[1];g===\"replaceWith\"?f[0]!==d[0]&&f.replaceWith(d):g===\"img\"?f.is(\"img\")?f.attr(\"src\",d):f.replaceWith(a(\"<img>\").attr(\"src\",d).attr(\"class\",f.attr(\"class\"))):f.attr(e[1],d)}}else b.find(j+\"-\"+c).html(d)})},_getScrollbarSize:function(){if(n.scrollbarSize===undefined){var a=document.createElement(\"div\");a.style.cssText=\"width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;\",document.body.appendChild(a),n.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return n.scrollbarSize}},a.magnificPopup={instance:null,proto:o.prototype,modules:[],open:function(b,c){return A(),b?b=a.extend(!0,{},b):b={},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:\"\",preloader:!0,focus:\"\",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:\"auto\",fixedBgPos:\"auto\",overflowY:\"auto\",closeMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-close\">&#215;</button>',tClose:\"Close (Esc)\",tLoading:\"Loading...\",autoFocusLast:!0}},a.fn.magnificPopup=function(b){A();var c=a(this);if(typeof b==\"string\")if(b===\"open\"){var d,e=p?c.data(\"magnificPopup\"):c[0].magnificPopup,f=parseInt(arguments[1],10)||0;e.items?d=e.items[f]:(d=c,e.delegate&&(d=d.find(e.delegate)),d=d.eq(f)),n._openClick({mfpEl:d},c,e)}else n.isOpen&&n[b].apply(n,Array.prototype.slice.call(arguments,1));else b=a.extend(!0,{},b),p?c.data(\"magnificPopup\",b):c[0].magnificPopup=b,n.addGroup(c,b);return c};var C=\"inline\",D,E,F,G=function(){F&&(E.after(F.addClass(D)).detach(),F=null)};a.magnificPopup.registerModule(C,{options:{hiddenClass:\"hide\",markup:\"\",tNotFound:\"Content not found\"},proto:{initInline:function(){n.types.push(C),w(b+\".\"+C,function(){G()})},getInline:function(b,c){G();if(b.src){var d=n.st.inline,e=a(b.src);if(e.length){var f=e[0].parentNode;f&&f.tagName&&(E||(D=d.hiddenClass,E=x(D),D=\"mfp-\"+D),F=e.after(E).detach().removeClass(D)),n.updateStatus(\"ready\")}else n.updateStatus(\"error\",d.tNotFound),e=a(\"<div>\");return b.inlineElement=e,e}return n.updateStatus(\"ready\"),n._parseMarkup(c,{},b),c}}});var H=\"ajax\",I,J=function(){I&&a(document.body).removeClass(I)},K=function(){J(),n.req&&n.req.abort()};a.magnificPopup.registerModule(H,{options:{settings:null,cursor:\"mfp-ajax-cur\",tError:'<a href=\"%url%\">The content</a> could not be loaded.'},proto:{initAjax:function(){n.types.push(H),I=n.st.ajax.cursor,w(b+\".\"+H,K),w(\"BeforeChange.\"+H,K)},getAjax:function(b){I&&a(document.body).addClass(I),n.updateStatus(\"loading\");var c=a.extend({url:b.src,success:function(c,d,e){var f={data:c,xhr:e};y(\"ParseAjax\",f),n.appendContent(a(f.data),H),b.finished=!0,J(),n._setFocus(),setTimeout(function(){n.wrap.addClass(k)},16),n.updateStatus(\"ready\"),y(\"AjaxContentAdded\")},error:function(){J(),b.finished=b.loadError=!0,n.updateStatus(\"error\",n.st.ajax.tError.replace(\"%url%\",b.src))}},n.st.ajax.settings);return n.req=a.ajax(c),\"\"}}});var L,M=function(b){if(b.data&&b.data.title!==undefined)return b.data.title;var c=n.st.image.titleSrc;if(c){if(a.isFunction(c))return c.call(n,b);if(b.el)return b.el.attr(c)||\"\"}return\"\"};a.magnificPopup.registerModule(\"image\",{options:{markup:'<div class=\"mfp-figure\"><div class=\"mfp-close\"></div><figure><div class=\"mfp-img\"></div><figcaption><div class=\"mfp-bottom-bar\"><div class=\"mfp-title\"></div><div class=\"mfp-counter\"></div></div></figcaption></figure></div>',cursor:\"mfp-zoom-out-cur\",titleSrc:\"title\",verticalFit:!0,tError:'<a href=\"%url%\">The image</a> could not be loaded.'},proto:{initImage:function(){var c=n.st.image,d=\".image\";n.types.push(\"image\"),w(g+d,function(){n.currItem.type===\"image\"&&c.cursor&&a(document.body).addClass(c.cursor)}),w(b+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),r.off(\"resize\"+j)}),w(\"Resize\"+d,n.resizeImage),n.isLowIE&&w(\"AfterChange\",n.resizeImage)},resizeImage:function(){var a=n.currItem;if(!a||!a.img)return;if(n.st.image.verticalFit){var b=0;n.isLowIE&&(b=parseInt(a.img.css(\"padding-top\"),10)+parseInt(a.img.css(\"padding-bottom\"),10)),a.img.css(\"max-height\",n.wH-b)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y(\"ImageHasSize\",a),a.imgHidden&&(n.content&&n.content.removeClass(\"mfp-loading\"),a.imgHidden=!1))},findImageSize:function(a){var b=0,c=a.img[0],d=function(e){L&&clearInterval(L),L=setInterval(function(){if(c.naturalWidth>0){n._onImageHasSize(a);return}b>200&&clearInterval(L),b++,b===3?d(10):b===40?d(50):b===100&&d(500)},e)};d(1)},getImage:function(b,c){var d=0,e=function(){b&&(b.img[0].complete?(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"ready\")),b.hasSize=!0,b.loaded=!0,y(\"ImageLoadComplete\")):(d++,d<200?setTimeout(e,100):f()))},f=function(){b&&(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))),b.hasSize=!0,b.loaded=!0,b.loadError=!0)},g=n.st.image,h=c.find(\".mfp-img\");if(h.length){var i=document.createElement(\"img\");i.className=\"mfp-img\",b.el&&b.el.find(\"img\").length&&(i.alt=b.el.find(\"img\").attr(\"alt\")),b.img=a(i).on(\"load.mfploader\",e).on(\"error.mfploader\",f),i.src=b.src,h.is(\"img\")&&(b.img=b.img.clone()),i=b.img[0],i.naturalWidth>0?b.hasSize=!0:i.width||(b.hasSize=!1)}return n._parseMarkup(c,{title:M(b),img_replaceWith:b.img},b),n.resizeImage(),b.hasSize?(L&&clearInterval(L),b.loadError?(c.addClass(\"mfp-loading\"),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))):(c.removeClass(\"mfp-loading\"),n.updateStatus(\"ready\")),c):(n.updateStatus(\"loading\"),b.loading=!0,b.hasSize||(b.imgHidden=!0,c.addClass(\"mfp-loading\"),n.findImageSize(b)),c)}}});var N,O=function(){return N===undefined&&(N=document.createElement(\"p\").style.MozTransform!==undefined),N};a.magnificPopup.registerModule(\"zoom\",{options:{enabled:!1,easing:\"ease-in-out\",duration:300,opener:function(a){return a.is(\"img\")?a:a.find(\"img\")}},proto:{initZoom:function(){var a=n.st.zoom,d=\".zoom\",e;if(!a.enabled||!n.supportsTransition)return;var f=a.duration,g=function(b){var c=b.clone().removeAttr(\"style\").removeAttr(\"class\").addClass(\"mfp-animated-image\"),d=\"all \"+a.duration/1e3+\"s \"+a.easing,e={position:\"fixed\",zIndex:9999,left:0,top:0,\"-webkit-backface-visibility\":\"hidden\"},f=\"transition\";return e[\"-webkit-\"+f]=e[\"-moz-\"+f]=e[\"-o-\"+f]=e[f]=d,c.css(e),c},h=function(){n.content.css(\"visibility\",\"visible\")},i,j;w(\"BuildControls\"+d,function(){if(n._allowZoom()){clearTimeout(i),n.content.css(\"visibility\",\"hidden\"),e=n._getItemToZoom();if(!e){h();return}j=g(e),j.css(n._getOffset()),n.wrap.append(j),i=setTimeout(function(){j.css(n._getOffset(!0)),i=setTimeout(function(){h(),setTimeout(function(){j.remove(),e=j=null,y(\"ZoomAnimationEnded\")},16)},f)},16)}}),w(c+d,function(){if(n._allowZoom()){clearTimeout(i),n.st.removalDelay=f;if(!e){e=n._getItemToZoom();if(!e)return;j=g(e)}j.css(n._getOffset(!0)),n.wrap.append(j),n.content.css(\"visibility\",\"hidden\"),setTimeout(function(){j.css(n._getOffset())},16)}}),w(b+d,function(){n._allowZoom()&&(h(),j&&j.remove(),e=null)})},_allowZoom:function(){return n.currItem.type===\"image\"},_getItemToZoom:function(){return n.currItem.hasSize?n.currItem.img:!1},_getOffset:function(b){var c;b?c=n.currItem.img:c=n.st.zoom.opener(n.currItem.el||n.currItem);var d=c.offset(),e=parseInt(c.css(\"padding-top\"),10),f=parseInt(c.css(\"padding-bottom\"),10);d.top-=a(window).scrollTop()-e;var g={width:c.width(),height:(p?c.innerHeight():c[0].offsetHeight)-f-e};return O()?g[\"-moz-transform\"]=g.transform=\"translate(\"+d.left+\"px,\"+d.top+\"px)\":(g.left=d.left,g.top=d.top),g}}});var P=\"iframe\",Q=\"//about:blank\",R=function(a){if(n.currTemplate[P]){var b=n.currTemplate[P].find(\"iframe\");b.length&&(a||(b[0].src=Q),n.isIE8&&b.css(\"display\",a?\"block\":\"none\"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class=\"mfp-iframe-scaler\"><div class=\"mfp-close\"></div><iframe class=\"mfp-iframe\" src=\"//about:blank\" frameborder=\"0\" allowfullscreen></iframe></div>',srcAction:\"iframe_src\",patterns:{youtube:{index:\"youtube.com\",id:\"v=\",src:\"//www.youtube.com/embed/%id%?autoplay=1\"},vimeo:{index:\"vimeo.com/\",id:\"/\",src:\"//player.vimeo.com/video/%id%?autoplay=1\"},gmaps:{index:\"//maps.google.\",src:\"%id%&output=embed\"}}},proto:{initIframe:function(){n.types.push(P),w(\"BeforeChange\",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(b+\".\"+P,function(){R()})},getIframe:function(b,c){var d=b.src,e=n.st.iframe;a.each(e.patterns,function(){if(d.indexOf(this.index)>-1)return this.id&&(typeof this.id==\"string\"?d=d.substr(d.lastIndexOf(this.id)+this.id.length,d.length):d=this.id.call(this,d)),d=this.src.replace(\"%id%\",d),!1});var f={};return e.srcAction&&(f[e.srcAction]=d),n._parseMarkup(c,f,b),n.updateStatus(\"ready\"),c}}});var S=function(a){var b=n.items.length;return a>b-1?a-b:a<0?b+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule(\"gallery\",{options:{enabled:!1,arrowMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-arrow mfp-arrow-%dir%\"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:\"Previous (Left arrow key)\",tNext:\"Next (Right arrow key)\",tCounter:\"%curr% of %total%\"},proto:{initGallery:function(){var c=n.st.gallery,d=\".mfp-gallery\";n.direction=!0;if(!c||!c.enabled)return!1;u+=\" mfp-gallery\",w(g+d,function(){c.navigateByImgClick&&n.wrap.on(\"click\"+d,\".mfp-img\",function(){if(n.items.length>1)return n.next(),!1}),s.on(\"keydown\"+d,function(a){a.keyCode===37?n.prev():a.keyCode===39&&n.next()})}),w(\"UpdateStatus\"+d,function(a,b){b.text&&(b.text=T(b.text,n.currItem.index,n.items.length))}),w(f+d,function(a,b,d,e){var f=n.items.length;d.counter=f>1?T(c.tCounter,e.index,f):\"\"}),w(\"BuildControls\"+d,function(){if(n.items.length>1&&c.arrows&&!n.arrowLeft){var b=c.arrowMarkup,d=n.arrowLeft=a(b.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,\"left\")).addClass(m),e=n.arrowRight=a(b.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,\"right\")).addClass(m);d.click(function(){n.prev()}),e.click(function(){n.next()}),n.container.append(d.add(e))}}),w(h+d,function(){n._preloadTimeout&&clearTimeout(n._preloadTimeout),n._preloadTimeout=setTimeout(function(){n.preloadNearbyImages(),n._preloadTimeout=null},16)}),w(b+d,function(){s.off(d),n.wrap.off(\"click\"+d),n.arrowRight=n.arrowLeft=null})},next:function(){n.direction=!0,n.index=S(n.index+1),n.updateItemHTML()},prev:function(){n.direction=!1,n.index=S(n.index-1),n.updateItemHTML()},goTo:function(a){n.direction=a>=n.index,n.index=a,n.updateItemHTML()},preloadNearbyImages:function(){var a=n.st.gallery.preload,b=Math.min(a[0],n.items.length),c=Math.min(a[1],n.items.length),d;for(d=1;d<=(n.direction?c:b);d++)n._preloadItem(n.index+d);for(d=1;d<=(n.direction?b:c);d++)n._preloadItem(n.index-d)},_preloadItem:function(b){b=S(b);if(n.items[b].preloaded)return;var c=n.items[b];c.parsed||(c=n.parseEl(b)),y(\"LazyLoad\",c),c.type===\"image\"&&(c.img=a('<img class=\"mfp-img\" />').on(\"load.mfploader\",function(){c.hasSize=!0}).on(\"error.mfploader\",function(){c.hasSize=!0,c.loadError=!0,y(\"LazyLoadError\",c)}).attr(\"src\",c.src)),c.preloaded=!0}}});var U=\"retina\";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\\.\\w+$/,function(a){return\"@2x\"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=n.st.retina,b=a.ratio;b=isNaN(b)?b():b,b>1&&(w(\"ImageHasSize.\"+U,function(a,c){c.img.css({\"max-width\":c.img[0].naturalWidth/b,width:\"100%\"})}),w(\"ElementParse.\"+U,function(c,d){d.src=a.replaceSrc(d,b)}))}}}}),A()})","Mageplaza_Core/js/bootstrap.min.js":"/*!\n * Bootstrap v5.0.2 (https://getbootstrap.com/)\n * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n */\n!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e(require(\"@popperjs/core\")):\"function\"==typeof define&&define.amd?define([\"@popperjs/core\"],e):(t=\"undefined\"!=typeof globalThis?globalThis:t||self).bootstrap=e(t.Popper)}(this,(function(t){\"use strict\";function e(t){if(t&&t.__esModule)return t;var e=Object.create(null);return t&&Object.keys(t).forEach((function(s){if(\"default\"!==s){var i=Object.getOwnPropertyDescriptor(t,s);Object.defineProperty(e,s,i.get?i:{enumerable:!0,get:function(){return t[s]}})}})),e.default=t,Object.freeze(e)}var s=e(t);const i={find:(t,e=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(e,t)),findOne:(t,e=document.documentElement)=>Element.prototype.querySelector.call(e,t),children:(t,e)=>[].concat(...t.children).filter(t=>t.matches(e)),parents(t,e){const s=[];let i=t.parentNode;for(;i&&i.nodeType===Node.ELEMENT_NODE&&3!==i.nodeType;)i.matches(e)&&s.push(i),i=i.parentNode;return s},prev(t,e){let s=t.previousElementSibling;for(;s;){if(s.matches(e))return[s];s=s.previousElementSibling}return[]},next(t,e){let s=t.nextElementSibling;for(;s;){if(s.matches(e))return[s];s=s.nextElementSibling}return[]}},n=t=>{do{t+=Math.floor(1e6*Math.random())}while(document.getElementById(t));return t},o=t=>{let e=t.getAttribute(\"data-bs-target\");if(!e||\"#\"===e){let s=t.getAttribute(\"href\");if(!s||!s.includes(\"#\")&&!s.startsWith(\".\"))return null;s.includes(\"#\")&&!s.startsWith(\"#\")&&(s=\"#\"+s.split(\"#\")[1]),e=s&&\"#\"!==s?s.trim():null}return e},r=t=>{const e=o(t);return e&&document.querySelector(e)?e:null},a=t=>{const e=o(t);return e?document.querySelector(e):null},l=t=>{t.dispatchEvent(new Event(\"transitionend\"))},c=t=>!(!t||\"object\"!=typeof t)&&(void 0!==t.jquery&&(t=t[0]),void 0!==t.nodeType),h=t=>c(t)?t.jquery?t[0]:t:\"string\"==typeof t&&t.length>0?i.findOne(t):null,d=(t,e,s)=>{Object.keys(s).forEach(i=>{const n=s[i],o=e[i],r=o&&c(o)?\"element\":null==(a=o)?\"\"+a:{}.toString.call(a).match(/\\s([a-z]+)/i)[1].toLowerCase();var a;if(!new RegExp(n).test(r))throw new TypeError(`${t.toUpperCase()}: Option \"${i}\" provided type \"${r}\" but expected type \"${n}\".`)})},u=t=>!(!c(t)||0===t.getClientRects().length)&&\"visible\"===getComputedStyle(t).getPropertyValue(\"visibility\"),g=t=>!t||t.nodeType!==Node.ELEMENT_NODE||!!t.classList.contains(\"disabled\")||(void 0!==t.disabled?t.disabled:t.hasAttribute(\"disabled\")&&\"false\"!==t.getAttribute(\"disabled\")),p=t=>{if(!document.documentElement.attachShadow)return null;if(\"function\"==typeof t.getRootNode){const e=t.getRootNode();return e instanceof ShadowRoot?e:null}return t instanceof ShadowRoot?t:t.parentNode?p(t.parentNode):null},f=()=>{},m=t=>t.offsetHeight,_=()=>{const{jQuery:t}=window;return t&&!document.body.hasAttribute(\"data-bs-no-jquery\")?t:null},b=[],v=()=>\"rtl\"===document.documentElement.dir,y=t=>{var e;e=()=>{const e=_();if(e){const s=t.NAME,i=e.fn[s];e.fn[s]=t.jQueryInterface,e.fn[s].Constructor=t,e.fn[s].noConflict=()=>(e.fn[s]=i,t.jQueryInterface)}},\"loading\"===document.readyState?(b.length||document.addEventListener(\"DOMContentLoaded\",()=>{b.forEach(t=>t())}),b.push(e)):e()},w=t=>{\"function\"==typeof t&&t()},E=(t,e,s=!0)=>{if(!s)return void w(t);const i=(t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),n=Number.parseFloat(s);return i||n?(e=e.split(\",\")[0],s=s.split(\",\")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0})(e)+5;let n=!1;const o=({target:s})=>{s===e&&(n=!0,e.removeEventListener(\"transitionend\",o),w(t))};e.addEventListener(\"transitionend\",o),setTimeout(()=>{n||l(e)},i)},A=(t,e,s,i)=>{let n=t.indexOf(e);if(-1===n)return t[!s&&i?t.length-1:0];const o=t.length;return n+=s?1:-1,i&&(n=(n+o)%o),t[Math.max(0,Math.min(n,o-1))]},T=/[^.]*(?=\\..*)\\.|.*/,C=/\\..*/,k=/::\\d+$/,L={};let O=1;const D={mouseenter:\"mouseover\",mouseleave:\"mouseout\"},I=/^(mouseenter|mouseleave)/i,N=new Set([\"click\",\"dblclick\",\"mouseup\",\"mousedown\",\"contextmenu\",\"mousewheel\",\"DOMMouseScroll\",\"mouseover\",\"mouseout\",\"mousemove\",\"selectstart\",\"selectend\",\"keydown\",\"keypress\",\"keyup\",\"orientationchange\",\"touchstart\",\"touchmove\",\"touchend\",\"touchcancel\",\"pointerdown\",\"pointermove\",\"pointerup\",\"pointerleave\",\"pointercancel\",\"gesturestart\",\"gesturechange\",\"gestureend\",\"focus\",\"blur\",\"change\",\"reset\",\"select\",\"submit\",\"focusin\",\"focusout\",\"load\",\"unload\",\"beforeunload\",\"resize\",\"move\",\"DOMContentLoaded\",\"readystatechange\",\"error\",\"abort\",\"scroll\"]);function S(t,e){return e&&`${e}::${O++}`||t.uidEvent||O++}function x(t){const e=S(t);return t.uidEvent=e,L[e]=L[e]||{},L[e]}function M(t,e,s=null){const i=Object.keys(t);for(let n=0,o=i.length;n<o;n++){const o=t[i[n]];if(o.originalHandler===e&&o.delegationSelector===s)return o}return null}function P(t,e,s){const i=\"string\"==typeof e,n=i?s:e;let o=R(t);return N.has(o)||(o=t),[i,n,o]}function j(t,e,s,i,n){if(\"string\"!=typeof e||!t)return;if(s||(s=i,i=null),I.test(e)){const t=t=>function(e){if(!e.relatedTarget||e.relatedTarget!==e.delegateTarget&&!e.delegateTarget.contains(e.relatedTarget))return t.call(this,e)};i?i=t(i):s=t(s)}const[o,r,a]=P(e,s,i),l=x(t),c=l[a]||(l[a]={}),h=M(c,r,o?s:null);if(h)return void(h.oneOff=h.oneOff&&n);const d=S(r,e.replace(T,\"\")),u=o?function(t,e,s){return function i(n){const o=t.querySelectorAll(e);for(let{target:r}=n;r&&r!==this;r=r.parentNode)for(let a=o.length;a--;)if(o[a]===r)return n.delegateTarget=r,i.oneOff&&B.off(t,n.type,e,s),s.apply(r,[n]);return null}}(t,s,i):function(t,e){return function s(i){return i.delegateTarget=t,s.oneOff&&B.off(t,i.type,e),e.apply(t,[i])}}(t,s);u.delegationSelector=o?s:null,u.originalHandler=r,u.oneOff=n,u.uidEvent=d,c[d]=u,t.addEventListener(a,u,o)}function H(t,e,s,i,n){const o=M(e[s],i,n);o&&(t.removeEventListener(s,o,Boolean(n)),delete e[s][o.uidEvent])}function R(t){return t=t.replace(C,\"\"),D[t]||t}const B={on(t,e,s,i){j(t,e,s,i,!1)},one(t,e,s,i){j(t,e,s,i,!0)},off(t,e,s,i){if(\"string\"!=typeof e||!t)return;const[n,o,r]=P(e,s,i),a=r!==e,l=x(t),c=e.startsWith(\".\");if(void 0!==o){if(!l||!l[r])return;return void H(t,l,r,o,n?s:null)}c&&Object.keys(l).forEach(s=>{!function(t,e,s,i){const n=e[s]||{};Object.keys(n).forEach(o=>{if(o.includes(i)){const i=n[o];H(t,e,s,i.originalHandler,i.delegationSelector)}})}(t,l,s,e.slice(1))});const h=l[r]||{};Object.keys(h).forEach(s=>{const i=s.replace(k,\"\");if(!a||e.includes(i)){const e=h[s];H(t,l,r,e.originalHandler,e.delegationSelector)}})},trigger(t,e,s){if(\"string\"!=typeof e||!t)return null;const i=_(),n=R(e),o=e!==n,r=N.has(n);let a,l=!0,c=!0,h=!1,d=null;return o&&i&&(a=i.Event(e,s),i(t).trigger(a),l=!a.isPropagationStopped(),c=!a.isImmediatePropagationStopped(),h=a.isDefaultPrevented()),r?(d=document.createEvent(\"HTMLEvents\"),d.initEvent(n,l,!0)):d=new CustomEvent(e,{bubbles:l,cancelable:!0}),void 0!==s&&Object.keys(s).forEach(t=>{Object.defineProperty(d,t,{get:()=>s[t]})}),h&&d.preventDefault(),c&&t.dispatchEvent(d),d.defaultPrevented&&void 0!==a&&a.preventDefault(),d}},$=new Map;var W={set(t,e,s){$.has(t)||$.set(t,new Map);const i=$.get(t);i.has(e)||0===i.size?i.set(e,s):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(i.keys())[0]}.`)},get:(t,e)=>$.has(t)&&$.get(t).get(e)||null,remove(t,e){if(!$.has(t))return;const s=$.get(t);s.delete(e),0===s.size&&$.delete(t)}};class q{constructor(t){(t=h(t))&&(this._element=t,W.set(this._element,this.constructor.DATA_KEY,this))}dispose(){W.remove(this._element,this.constructor.DATA_KEY),B.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach(t=>{this[t]=null})}_queueCallback(t,e,s=!0){E(t,e,s)}static getInstance(t){return W.get(t,this.DATA_KEY)}static getOrCreateInstance(t,e={}){return this.getInstance(t)||new this(t,\"object\"==typeof e?e:null)}static get VERSION(){return\"5.0.2\"}static get NAME(){throw new Error('You have to implement the static method \"NAME\", for each component!')}static get DATA_KEY(){return\"bs.\"+this.NAME}static get EVENT_KEY(){return\".\"+this.DATA_KEY}}class z extends q{static get NAME(){return\"alert\"}close(t){const e=t?this._getRootElement(t):this._element,s=this._triggerCloseEvent(e);null===s||s.defaultPrevented||this._removeElement(e)}_getRootElement(t){return a(t)||t.closest(\".alert\")}_triggerCloseEvent(t){return B.trigger(t,\"close.bs.alert\")}_removeElement(t){t.classList.remove(\"show\");const e=t.classList.contains(\"fade\");this._queueCallback(()=>this._destroyElement(t),t,e)}_destroyElement(t){t.remove(),B.trigger(t,\"closed.bs.alert\")}static jQueryInterface(t){return this.each((function(){const e=z.getOrCreateInstance(this);\"close\"===t&&e[t](this)}))}static handleDismiss(t){return function(e){e&&e.preventDefault(),t.close(this)}}}B.on(document,\"click.bs.alert.data-api\",'[data-bs-dismiss=\"alert\"]',z.handleDismiss(new z)),y(z);class F extends q{static get NAME(){return\"button\"}toggle(){this._element.setAttribute(\"aria-pressed\",this._element.classList.toggle(\"active\"))}static jQueryInterface(t){return this.each((function(){const e=F.getOrCreateInstance(this);\"toggle\"===t&&e[t]()}))}}function U(t){return\"true\"===t||\"false\"!==t&&(t===Number(t).toString()?Number(t):\"\"===t||\"null\"===t?null:t)}function K(t){return t.replace(/[A-Z]/g,t=>\"-\"+t.toLowerCase())}B.on(document,\"click.bs.button.data-api\",'[data-bs-toggle=\"button\"]',t=>{t.preventDefault();const e=t.target.closest('[data-bs-toggle=\"button\"]');F.getOrCreateInstance(e).toggle()}),y(F);const V={setDataAttribute(t,e,s){t.setAttribute(\"data-bs-\"+K(e),s)},removeDataAttribute(t,e){t.removeAttribute(\"data-bs-\"+K(e))},getDataAttributes(t){if(!t)return{};const e={};return Object.keys(t.dataset).filter(t=>t.startsWith(\"bs\")).forEach(s=>{let i=s.replace(/^bs/,\"\");i=i.charAt(0).toLowerCase()+i.slice(1,i.length),e[i]=U(t.dataset[s])}),e},getDataAttribute:(t,e)=>U(t.getAttribute(\"data-bs-\"+K(e))),offset(t){const e=t.getBoundingClientRect();return{top:e.top+document.body.scrollTop,left:e.left+document.body.scrollLeft}},position:t=>({top:t.offsetTop,left:t.offsetLeft})},Q={interval:5e3,keyboard:!0,slide:!1,pause:\"hover\",wrap:!0,touch:!0},X={interval:\"(number|boolean)\",keyboard:\"boolean\",slide:\"(boolean|string)\",pause:\"(string|boolean)\",wrap:\"boolean\",touch:\"boolean\"},Y=\"next\",G=\"prev\",Z=\"left\",J=\"right\",tt={ArrowLeft:J,ArrowRight:Z};class et extends q{constructor(t,e){super(t),this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(e),this._indicatorsElement=i.findOne(\".carousel-indicators\",this._element),this._touchSupported=\"ontouchstart\"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent),this._addEventListeners()}static get Default(){return Q}static get NAME(){return\"carousel\"}next(){this._slide(Y)}nextWhenVisible(){!document.hidden&&u(this._element)&&this.next()}prev(){this._slide(G)}pause(t){t||(this._isPaused=!0),i.findOne(\".carousel-item-next, .carousel-item-prev\",this._element)&&(l(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null}cycle(t){t||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config&&this._config.interval&&!this._isPaused&&(this._updateInterval(),this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval))}to(t){this._activeElement=i.findOne(\".active.carousel-item\",this._element);const e=this._getItemIndex(this._activeElement);if(t>this._items.length-1||t<0)return;if(this._isSliding)return void B.one(this._element,\"slid.bs.carousel\",()=>this.to(t));if(e===t)return this.pause(),void this.cycle();const s=t>e?Y:G;this._slide(s,this._items[t])}_getConfig(t){return t={...Q,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"carousel\",t,X),t}_handleSwipe(){const t=Math.abs(this.touchDeltaX);if(t<=40)return;const e=t/this.touchDeltaX;this.touchDeltaX=0,e&&this._slide(e>0?J:Z)}_addEventListeners(){this._config.keyboard&&B.on(this._element,\"keydown.bs.carousel\",t=>this._keydown(t)),\"hover\"===this._config.pause&&(B.on(this._element,\"mouseenter.bs.carousel\",t=>this.pause(t)),B.on(this._element,\"mouseleave.bs.carousel\",t=>this.cycle(t))),this._config.touch&&this._touchSupported&&this._addTouchEventListeners()}_addTouchEventListeners(){const t=t=>{!this._pointerEvent||\"pen\"!==t.pointerType&&\"touch\"!==t.pointerType?this._pointerEvent||(this.touchStartX=t.touches[0].clientX):this.touchStartX=t.clientX},e=t=>{this.touchDeltaX=t.touches&&t.touches.length>1?0:t.touches[0].clientX-this.touchStartX},s=t=>{!this._pointerEvent||\"pen\"!==t.pointerType&&\"touch\"!==t.pointerType||(this.touchDeltaX=t.clientX-this.touchStartX),this._handleSwipe(),\"hover\"===this._config.pause&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout(t=>this.cycle(t),500+this._config.interval))};i.find(\".carousel-item img\",this._element).forEach(t=>{B.on(t,\"dragstart.bs.carousel\",t=>t.preventDefault())}),this._pointerEvent?(B.on(this._element,\"pointerdown.bs.carousel\",e=>t(e)),B.on(this._element,\"pointerup.bs.carousel\",t=>s(t)),this._element.classList.add(\"pointer-event\")):(B.on(this._element,\"touchstart.bs.carousel\",e=>t(e)),B.on(this._element,\"touchmove.bs.carousel\",t=>e(t)),B.on(this._element,\"touchend.bs.carousel\",t=>s(t)))}_keydown(t){if(/input|textarea/i.test(t.target.tagName))return;const e=tt[t.key];e&&(t.preventDefault(),this._slide(e))}_getItemIndex(t){return this._items=t&&t.parentNode?i.find(\".carousel-item\",t.parentNode):[],this._items.indexOf(t)}_getItemByOrder(t,e){const s=t===Y;return A(this._items,e,s,this._config.wrap)}_triggerSlideEvent(t,e){const s=this._getItemIndex(t),n=this._getItemIndex(i.findOne(\".active.carousel-item\",this._element));return B.trigger(this._element,\"slide.bs.carousel\",{relatedTarget:t,direction:e,from:n,to:s})}_setActiveIndicatorElement(t){if(this._indicatorsElement){const e=i.findOne(\".active\",this._indicatorsElement);e.classList.remove(\"active\"),e.removeAttribute(\"aria-current\");const s=i.find(\"[data-bs-target]\",this._indicatorsElement);for(let e=0;e<s.length;e++)if(Number.parseInt(s[e].getAttribute(\"data-bs-slide-to\"),10)===this._getItemIndex(t)){s[e].classList.add(\"active\"),s[e].setAttribute(\"aria-current\",\"true\");break}}}_updateInterval(){const t=this._activeElement||i.findOne(\".active.carousel-item\",this._element);if(!t)return;const e=Number.parseInt(t.getAttribute(\"data-bs-interval\"),10);e?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=e):this._config.interval=this._config.defaultInterval||this._config.interval}_slide(t,e){const s=this._directionToOrder(t),n=i.findOne(\".active.carousel-item\",this._element),o=this._getItemIndex(n),r=e||this._getItemByOrder(s,n),a=this._getItemIndex(r),l=Boolean(this._interval),c=s===Y,h=c?\"carousel-item-start\":\"carousel-item-end\",d=c?\"carousel-item-next\":\"carousel-item-prev\",u=this._orderToDirection(s);if(r&&r.classList.contains(\"active\"))return void(this._isSliding=!1);if(this._isSliding)return;if(this._triggerSlideEvent(r,u).defaultPrevented)return;if(!n||!r)return;this._isSliding=!0,l&&this.pause(),this._setActiveIndicatorElement(r),this._activeElement=r;const g=()=>{B.trigger(this._element,\"slid.bs.carousel\",{relatedTarget:r,direction:u,from:o,to:a})};if(this._element.classList.contains(\"slide\")){r.classList.add(d),m(r),n.classList.add(h),r.classList.add(h);const t=()=>{r.classList.remove(h,d),r.classList.add(\"active\"),n.classList.remove(\"active\",d,h),this._isSliding=!1,setTimeout(g,0)};this._queueCallback(t,n,!0)}else n.classList.remove(\"active\"),r.classList.add(\"active\"),this._isSliding=!1,g();l&&this.cycle()}_directionToOrder(t){return[J,Z].includes(t)?v()?t===Z?G:Y:t===Z?Y:G:t}_orderToDirection(t){return[Y,G].includes(t)?v()?t===G?Z:J:t===G?J:Z:t}static carouselInterface(t,e){const s=et.getOrCreateInstance(t,e);let{_config:i}=s;\"object\"==typeof e&&(i={...i,...e});const n=\"string\"==typeof e?e:i.slide;if(\"number\"==typeof e)s.to(e);else if(\"string\"==typeof n){if(void 0===s[n])throw new TypeError(`No method named \"${n}\"`);s[n]()}else i.interval&&i.ride&&(s.pause(),s.cycle())}static jQueryInterface(t){return this.each((function(){et.carouselInterface(this,t)}))}static dataApiClickHandler(t){const e=a(this);if(!e||!e.classList.contains(\"carousel\"))return;const s={...V.getDataAttributes(e),...V.getDataAttributes(this)},i=this.getAttribute(\"data-bs-slide-to\");i&&(s.interval=!1),et.carouselInterface(e,s),i&&et.getInstance(e).to(i),t.preventDefault()}}B.on(document,\"click.bs.carousel.data-api\",\"[data-bs-slide], [data-bs-slide-to]\",et.dataApiClickHandler),B.on(window,\"load.bs.carousel.data-api\",()=>{const t=i.find('[data-bs-ride=\"carousel\"]');for(let e=0,s=t.length;e<s;e++)et.carouselInterface(t[e],et.getInstance(t[e]))}),y(et);const st={toggle:!0,parent:\"\"},it={toggle:\"boolean\",parent:\"(string|element)\"};class nt extends q{constructor(t,e){super(t),this._isTransitioning=!1,this._config=this._getConfig(e),this._triggerArray=i.find(`[data-bs-toggle=\"collapse\"][href=\"#${this._element.id}\"],[data-bs-toggle=\"collapse\"][data-bs-target=\"#${this._element.id}\"]`);const s=i.find('[data-bs-toggle=\"collapse\"]');for(let t=0,e=s.length;t<e;t++){const e=s[t],n=r(e),o=i.find(n).filter(t=>t===this._element);null!==n&&o.length&&(this._selector=n,this._triggerArray.push(e))}this._parent=this._config.parent?this._getParent():null,this._config.parent||this._addAriaAndCollapsedClass(this._element,this._triggerArray),this._config.toggle&&this.toggle()}static get Default(){return st}static get NAME(){return\"collapse\"}toggle(){this._element.classList.contains(\"show\")?this.hide():this.show()}show(){if(this._isTransitioning||this._element.classList.contains(\"show\"))return;let t,e;this._parent&&(t=i.find(\".show, .collapsing\",this._parent).filter(t=>\"string\"==typeof this._config.parent?t.getAttribute(\"data-bs-parent\")===this._config.parent:t.classList.contains(\"collapse\")),0===t.length&&(t=null));const s=i.findOne(this._selector);if(t){const i=t.find(t=>s!==t);if(e=i?nt.getInstance(i):null,e&&e._isTransitioning)return}if(B.trigger(this._element,\"show.bs.collapse\").defaultPrevented)return;t&&t.forEach(t=>{s!==t&&nt.collapseInterface(t,\"hide\"),e||W.set(t,\"bs.collapse\",null)});const n=this._getDimension();this._element.classList.remove(\"collapse\"),this._element.classList.add(\"collapsing\"),this._element.style[n]=0,this._triggerArray.length&&this._triggerArray.forEach(t=>{t.classList.remove(\"collapsed\"),t.setAttribute(\"aria-expanded\",!0)}),this.setTransitioning(!0);const o=\"scroll\"+(n[0].toUpperCase()+n.slice(1));this._queueCallback(()=>{this._element.classList.remove(\"collapsing\"),this._element.classList.add(\"collapse\",\"show\"),this._element.style[n]=\"\",this.setTransitioning(!1),B.trigger(this._element,\"shown.bs.collapse\")},this._element,!0),this._element.style[n]=this._element[o]+\"px\"}hide(){if(this._isTransitioning||!this._element.classList.contains(\"show\"))return;if(B.trigger(this._element,\"hide.bs.collapse\").defaultPrevented)return;const t=this._getDimension();this._element.style[t]=this._element.getBoundingClientRect()[t]+\"px\",m(this._element),this._element.classList.add(\"collapsing\"),this._element.classList.remove(\"collapse\",\"show\");const e=this._triggerArray.length;if(e>0)for(let t=0;t<e;t++){const e=this._triggerArray[t],s=a(e);s&&!s.classList.contains(\"show\")&&(e.classList.add(\"collapsed\"),e.setAttribute(\"aria-expanded\",!1))}this.setTransitioning(!0),this._element.style[t]=\"\",this._queueCallback(()=>{this.setTransitioning(!1),this._element.classList.remove(\"collapsing\"),this._element.classList.add(\"collapse\"),B.trigger(this._element,\"hidden.bs.collapse\")},this._element,!0)}setTransitioning(t){this._isTransitioning=t}_getConfig(t){return(t={...st,...t}).toggle=Boolean(t.toggle),d(\"collapse\",t,it),t}_getDimension(){return this._element.classList.contains(\"width\")?\"width\":\"height\"}_getParent(){let{parent:t}=this._config;t=h(t);const e=`[data-bs-toggle=\"collapse\"][data-bs-parent=\"${t}\"]`;return i.find(e,t).forEach(t=>{const e=a(t);this._addAriaAndCollapsedClass(e,[t])}),t}_addAriaAndCollapsedClass(t,e){if(!t||!e.length)return;const s=t.classList.contains(\"show\");e.forEach(t=>{s?t.classList.remove(\"collapsed\"):t.classList.add(\"collapsed\"),t.setAttribute(\"aria-expanded\",s)})}static collapseInterface(t,e){let s=nt.getInstance(t);const i={...st,...V.getDataAttributes(t),...\"object\"==typeof e&&e?e:{}};if(!s&&i.toggle&&\"string\"==typeof e&&/show|hide/.test(e)&&(i.toggle=!1),s||(s=new nt(t,i)),\"string\"==typeof e){if(void 0===s[e])throw new TypeError(`No method named \"${e}\"`);s[e]()}}static jQueryInterface(t){return this.each((function(){nt.collapseInterface(this,t)}))}}B.on(document,\"click.bs.collapse.data-api\",'[data-bs-toggle=\"collapse\"]',(function(t){(\"A\"===t.target.tagName||t.delegateTarget&&\"A\"===t.delegateTarget.tagName)&&t.preventDefault();const e=V.getDataAttributes(this),s=r(this);i.find(s).forEach(t=>{const s=nt.getInstance(t);let i;s?(null===s._parent&&\"string\"==typeof e.parent&&(s._config.parent=e.parent,s._parent=s._getParent()),i=\"toggle\"):i=e,nt.collapseInterface(t,i)})})),y(nt);const ot=new RegExp(\"ArrowUp|ArrowDown|Escape\"),rt=v()?\"top-end\":\"top-start\",at=v()?\"top-start\":\"top-end\",lt=v()?\"bottom-end\":\"bottom-start\",ct=v()?\"bottom-start\":\"bottom-end\",ht=v()?\"left-start\":\"right-start\",dt=v()?\"right-start\":\"left-start\",ut={offset:[0,2],boundary:\"clippingParents\",reference:\"toggle\",display:\"dynamic\",popperConfig:null,autoClose:!0},gt={offset:\"(array|string|function)\",boundary:\"(string|element)\",reference:\"(string|element|object)\",display:\"string\",popperConfig:\"(null|object|function)\",autoClose:\"(boolean|string)\"};class pt extends q{constructor(t,e){super(t),this._popper=null,this._config=this._getConfig(e),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar(),this._addEventListeners()}static get Default(){return ut}static get DefaultType(){return gt}static get NAME(){return\"dropdown\"}toggle(){g(this._element)||(this._element.classList.contains(\"show\")?this.hide():this.show())}show(){if(g(this._element)||this._menu.classList.contains(\"show\"))return;const t=pt.getParentFromElement(this._element),e={relatedTarget:this._element};if(!B.trigger(this._element,\"show.bs.dropdown\",e).defaultPrevented){if(this._inNavbar)V.setDataAttribute(this._menu,\"popper\",\"none\");else{if(void 0===s)throw new TypeError(\"Bootstrap's dropdowns require Popper (https://popper.js.org)\");let e=this._element;\"parent\"===this._config.reference?e=t:c(this._config.reference)?e=h(this._config.reference):\"object\"==typeof this._config.reference&&(e=this._config.reference);const i=this._getPopperConfig(),n=i.modifiers.find(t=>\"applyStyles\"===t.name&&!1===t.enabled);this._popper=s.createPopper(e,this._menu,i),n&&V.setDataAttribute(this._menu,\"popper\",\"static\")}\"ontouchstart\"in document.documentElement&&!t.closest(\".navbar-nav\")&&[].concat(...document.body.children).forEach(t=>B.on(t,\"mouseover\",f)),this._element.focus(),this._element.setAttribute(\"aria-expanded\",!0),this._menu.classList.toggle(\"show\"),this._element.classList.toggle(\"show\"),B.trigger(this._element,\"shown.bs.dropdown\",e)}}hide(){if(g(this._element)||!this._menu.classList.contains(\"show\"))return;const t={relatedTarget:this._element};this._completeHide(t)}dispose(){this._popper&&this._popper.destroy(),super.dispose()}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update()}_addEventListeners(){B.on(this._element,\"click.bs.dropdown\",t=>{t.preventDefault(),this.toggle()})}_completeHide(t){B.trigger(this._element,\"hide.bs.dropdown\",t).defaultPrevented||(\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>B.off(t,\"mouseover\",f)),this._popper&&this._popper.destroy(),this._menu.classList.remove(\"show\"),this._element.classList.remove(\"show\"),this._element.setAttribute(\"aria-expanded\",\"false\"),V.removeDataAttribute(this._menu,\"popper\"),B.trigger(this._element,\"hidden.bs.dropdown\",t))}_getConfig(t){if(t={...this.constructor.Default,...V.getDataAttributes(this._element),...t},d(\"dropdown\",t,this.constructor.DefaultType),\"object\"==typeof t.reference&&!c(t.reference)&&\"function\"!=typeof t.reference.getBoundingClientRect)throw new TypeError(\"dropdown\".toUpperCase()+': Option \"reference\" provided type \"object\" without a required \"getBoundingClientRect\" method.');return t}_getMenuElement(){return i.next(this._element,\".dropdown-menu\")[0]}_getPlacement(){const t=this._element.parentNode;if(t.classList.contains(\"dropend\"))return ht;if(t.classList.contains(\"dropstart\"))return dt;const e=\"end\"===getComputedStyle(this._menu).getPropertyValue(\"--bs-position\").trim();return t.classList.contains(\"dropup\")?e?at:rt:e?ct:lt}_detectNavbar(){return null!==this._element.closest(\".navbar\")}_getOffset(){const{offset:t}=this._config;return\"string\"==typeof t?t.split(\",\").map(t=>Number.parseInt(t,10)):\"function\"==typeof t?e=>t(e,this._element):t}_getPopperConfig(){const t={placement:this._getPlacement(),modifiers:[{name:\"preventOverflow\",options:{boundary:this._config.boundary}},{name:\"offset\",options:{offset:this._getOffset()}}]};return\"static\"===this._config.display&&(t.modifiers=[{name:\"applyStyles\",enabled:!1}]),{...t,...\"function\"==typeof this._config.popperConfig?this._config.popperConfig(t):this._config.popperConfig}}_selectMenuItem({key:t,target:e}){const s=i.find(\".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)\",this._menu).filter(u);s.length&&A(s,e,\"ArrowDown\"===t,!s.includes(e)).focus()}static dropdownInterface(t,e){const s=pt.getOrCreateInstance(t,e);if(\"string\"==typeof e){if(void 0===s[e])throw new TypeError(`No method named \"${e}\"`);s[e]()}}static jQueryInterface(t){return this.each((function(){pt.dropdownInterface(this,t)}))}static clearMenus(t){if(t&&(2===t.button||\"keyup\"===t.type&&\"Tab\"!==t.key))return;const e=i.find('[data-bs-toggle=\"dropdown\"]');for(let s=0,i=e.length;s<i;s++){const i=pt.getInstance(e[s]);if(!i||!1===i._config.autoClose)continue;if(!i._element.classList.contains(\"show\"))continue;const n={relatedTarget:i._element};if(t){const e=t.composedPath(),s=e.includes(i._menu);if(e.includes(i._element)||\"inside\"===i._config.autoClose&&!s||\"outside\"===i._config.autoClose&&s)continue;if(i._menu.contains(t.target)&&(\"keyup\"===t.type&&\"Tab\"===t.key||/input|select|option|textarea|form/i.test(t.target.tagName)))continue;\"click\"===t.type&&(n.clickEvent=t)}i._completeHide(n)}}static getParentFromElement(t){return a(t)||t.parentNode}static dataApiKeydownHandler(t){if(/input|textarea/i.test(t.target.tagName)?\"Space\"===t.key||\"Escape\"!==t.key&&(\"ArrowDown\"!==t.key&&\"ArrowUp\"!==t.key||t.target.closest(\".dropdown-menu\")):!ot.test(t.key))return;const e=this.classList.contains(\"show\");if(!e&&\"Escape\"===t.key)return;if(t.preventDefault(),t.stopPropagation(),g(this))return;const s=()=>this.matches('[data-bs-toggle=\"dropdown\"]')?this:i.prev(this,'[data-bs-toggle=\"dropdown\"]')[0];return\"Escape\"===t.key?(s().focus(),void pt.clearMenus()):\"ArrowUp\"===t.key||\"ArrowDown\"===t.key?(e||s().click(),void pt.getInstance(s())._selectMenuItem(t)):void(e&&\"Space\"!==t.key||pt.clearMenus())}}B.on(document,\"keydown.bs.dropdown.data-api\",'[data-bs-toggle=\"dropdown\"]',pt.dataApiKeydownHandler),B.on(document,\"keydown.bs.dropdown.data-api\",\".dropdown-menu\",pt.dataApiKeydownHandler),B.on(document,\"click.bs.dropdown.data-api\",pt.clearMenus),B.on(document,\"keyup.bs.dropdown.data-api\",pt.clearMenus),B.on(document,\"click.bs.dropdown.data-api\",'[data-bs-toggle=\"dropdown\"]',(function(t){t.preventDefault(),pt.dropdownInterface(this)})),y(pt);class ft{constructor(){this._element=document.body}getWidth(){const t=document.documentElement.clientWidth;return Math.abs(window.innerWidth-t)}hide(){const t=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,\"paddingRight\",e=>e+t),this._setElementAttributes(\".fixed-top, .fixed-bottom, .is-fixed, .sticky-top\",\"paddingRight\",e=>e+t),this._setElementAttributes(\".sticky-top\",\"marginRight\",e=>e-t)}_disableOverFlow(){this._saveInitialAttribute(this._element,\"overflow\"),this._element.style.overflow=\"hidden\"}_setElementAttributes(t,e,s){const i=this.getWidth();this._applyManipulationCallback(t,t=>{if(t!==this._element&&window.innerWidth>t.clientWidth+i)return;this._saveInitialAttribute(t,e);const n=window.getComputedStyle(t)[e];t.style[e]=s(Number.parseFloat(n))+\"px\"})}reset(){this._resetElementAttributes(this._element,\"overflow\"),this._resetElementAttributes(this._element,\"paddingRight\"),this._resetElementAttributes(\".fixed-top, .fixed-bottom, .is-fixed, .sticky-top\",\"paddingRight\"),this._resetElementAttributes(\".sticky-top\",\"marginRight\")}_saveInitialAttribute(t,e){const s=t.style[e];s&&V.setDataAttribute(t,e,s)}_resetElementAttributes(t,e){this._applyManipulationCallback(t,t=>{const s=V.getDataAttribute(t,e);void 0===s?t.style.removeProperty(e):(V.removeDataAttribute(t,e),t.style[e]=s)})}_applyManipulationCallback(t,e){c(t)?e(t):i.find(t,this._element).forEach(e)}isOverflowing(){return this.getWidth()>0}}const mt={isVisible:!0,isAnimated:!1,rootElement:\"body\",clickCallback:null},_t={isVisible:\"boolean\",isAnimated:\"boolean\",rootElement:\"(element|string)\",clickCallback:\"(function|null)\"};class bt{constructor(t){this._config=this._getConfig(t),this._isAppended=!1,this._element=null}show(t){this._config.isVisible?(this._append(),this._config.isAnimated&&m(this._getElement()),this._getElement().classList.add(\"show\"),this._emulateAnimation(()=>{w(t)})):w(t)}hide(t){this._config.isVisible?(this._getElement().classList.remove(\"show\"),this._emulateAnimation(()=>{this.dispose(),w(t)})):w(t)}_getElement(){if(!this._element){const t=document.createElement(\"div\");t.className=\"modal-backdrop\",this._config.isAnimated&&t.classList.add(\"fade\"),this._element=t}return this._element}_getConfig(t){return(t={...mt,...\"object\"==typeof t?t:{}}).rootElement=h(t.rootElement),d(\"backdrop\",t,_t),t}_append(){this._isAppended||(this._config.rootElement.appendChild(this._getElement()),B.on(this._getElement(),\"mousedown.bs.backdrop\",()=>{w(this._config.clickCallback)}),this._isAppended=!0)}dispose(){this._isAppended&&(B.off(this._element,\"mousedown.bs.backdrop\"),this._element.remove(),this._isAppended=!1)}_emulateAnimation(t){E(t,this._getElement(),this._config.isAnimated)}}const vt={backdrop:!0,keyboard:!0,focus:!0},yt={backdrop:\"(boolean|string)\",keyboard:\"boolean\",focus:\"boolean\"};class wt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._dialog=i.findOne(\".modal-dialog\",this._element),this._backdrop=this._initializeBackDrop(),this._isShown=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollBar=new ft}static get Default(){return vt}static get NAME(){return\"modal\"}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){this._isShown||this._isTransitioning||B.trigger(this._element,\"show.bs.modal\",{relatedTarget:t}).defaultPrevented||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._scrollBar.hide(),document.body.classList.add(\"modal-open\"),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),B.on(this._element,\"click.dismiss.bs.modal\",'[data-bs-dismiss=\"modal\"]',t=>this.hide(t)),B.on(this._dialog,\"mousedown.dismiss.bs.modal\",()=>{B.one(this._element,\"mouseup.dismiss.bs.modal\",t=>{t.target===this._element&&(this._ignoreBackdropClick=!0)})}),this._showBackdrop(()=>this._showElement(t)))}hide(t){if(t&&[\"A\",\"AREA\"].includes(t.target.tagName)&&t.preventDefault(),!this._isShown||this._isTransitioning)return;if(B.trigger(this._element,\"hide.bs.modal\").defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),B.off(document,\"focusin.bs.modal\"),this._element.classList.remove(\"show\"),B.off(this._element,\"click.dismiss.bs.modal\"),B.off(this._dialog,\"mousedown.dismiss.bs.modal\"),this._queueCallback(()=>this._hideModal(),this._element,e)}dispose(){[window,this._dialog].forEach(t=>B.off(t,\".bs.modal\")),this._backdrop.dispose(),super.dispose(),B.off(document,\"focusin.bs.modal\")}handleUpdate(){this._adjustDialog()}_initializeBackDrop(){return new bt({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_getConfig(t){return t={...vt,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"modal\",t,yt),t}_showElement(t){const e=this._isAnimated(),s=i.findOne(\".modal-body\",this._dialog);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.appendChild(this._element),this._element.style.display=\"block\",this._element.removeAttribute(\"aria-hidden\"),this._element.setAttribute(\"aria-modal\",!0),this._element.setAttribute(\"role\",\"dialog\"),this._element.scrollTop=0,s&&(s.scrollTop=0),e&&m(this._element),this._element.classList.add(\"show\"),this._config.focus&&this._enforceFocus(),this._queueCallback(()=>{this._config.focus&&this._element.focus(),this._isTransitioning=!1,B.trigger(this._element,\"shown.bs.modal\",{relatedTarget:t})},this._dialog,e)}_enforceFocus(){B.off(document,\"focusin.bs.modal\"),B.on(document,\"focusin.bs.modal\",t=>{document===t.target||this._element===t.target||this._element.contains(t.target)||this._element.focus()})}_setEscapeEvent(){this._isShown?B.on(this._element,\"keydown.dismiss.bs.modal\",t=>{this._config.keyboard&&\"Escape\"===t.key?(t.preventDefault(),this.hide()):this._config.keyboard||\"Escape\"!==t.key||this._triggerBackdropTransition()}):B.off(this._element,\"keydown.dismiss.bs.modal\")}_setResizeEvent(){this._isShown?B.on(window,\"resize.bs.modal\",()=>this._adjustDialog()):B.off(window,\"resize.bs.modal\")}_hideModal(){this._element.style.display=\"none\",this._element.setAttribute(\"aria-hidden\",!0),this._element.removeAttribute(\"aria-modal\"),this._element.removeAttribute(\"role\"),this._isTransitioning=!1,this._backdrop.hide(()=>{document.body.classList.remove(\"modal-open\"),this._resetAdjustments(),this._scrollBar.reset(),B.trigger(this._element,\"hidden.bs.modal\")})}_showBackdrop(t){B.on(this._element,\"click.dismiss.bs.modal\",t=>{this._ignoreBackdropClick?this._ignoreBackdropClick=!1:t.target===t.currentTarget&&(!0===this._config.backdrop?this.hide():\"static\"===this._config.backdrop&&this._triggerBackdropTransition())}),this._backdrop.show(t)}_isAnimated(){return this._element.classList.contains(\"fade\")}_triggerBackdropTransition(){if(B.trigger(this._element,\"hidePrevented.bs.modal\").defaultPrevented)return;const{classList:t,scrollHeight:e,style:s}=this._element,i=e>document.documentElement.clientHeight;!i&&\"hidden\"===s.overflowY||t.contains(\"modal-static\")||(i||(s.overflowY=\"hidden\"),t.add(\"modal-static\"),this._queueCallback(()=>{t.remove(\"modal-static\"),i||this._queueCallback(()=>{s.overflowY=\"\"},this._dialog)},this._dialog),this._element.focus())}_adjustDialog(){const t=this._element.scrollHeight>document.documentElement.clientHeight,e=this._scrollBar.getWidth(),s=e>0;(!s&&t&&!v()||s&&!t&&v())&&(this._element.style.paddingLeft=e+\"px\"),(s&&!t&&!v()||!s&&t&&v())&&(this._element.style.paddingRight=e+\"px\")}_resetAdjustments(){this._element.style.paddingLeft=\"\",this._element.style.paddingRight=\"\"}static jQueryInterface(t,e){return this.each((function(){const s=wt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===s[t])throw new TypeError(`No method named \"${t}\"`);s[t](e)}}))}}B.on(document,\"click.bs.modal.data-api\",'[data-bs-toggle=\"modal\"]',(function(t){const e=a(this);[\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),B.one(e,\"show.bs.modal\",t=>{t.defaultPrevented||B.one(e,\"hidden.bs.modal\",()=>{u(this)&&this.focus()})}),wt.getOrCreateInstance(e).toggle(this)})),y(wt);const Et={backdrop:!0,keyboard:!0,scroll:!1},At={backdrop:\"boolean\",keyboard:\"boolean\",scroll:\"boolean\"};class Tt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._addEventListeners()}static get NAME(){return\"offcanvas\"}static get Default(){return Et}toggle(t){return this._isShown?this.hide():this.show(t)}show(t){this._isShown||B.trigger(this._element,\"show.bs.offcanvas\",{relatedTarget:t}).defaultPrevented||(this._isShown=!0,this._element.style.visibility=\"visible\",this._backdrop.show(),this._config.scroll||((new ft).hide(),this._enforceFocusOnElement(this._element)),this._element.removeAttribute(\"aria-hidden\"),this._element.setAttribute(\"aria-modal\",!0),this._element.setAttribute(\"role\",\"dialog\"),this._element.classList.add(\"show\"),this._queueCallback(()=>{B.trigger(this._element,\"shown.bs.offcanvas\",{relatedTarget:t})},this._element,!0))}hide(){this._isShown&&(B.trigger(this._element,\"hide.bs.offcanvas\").defaultPrevented||(B.off(document,\"focusin.bs.offcanvas\"),this._element.blur(),this._isShown=!1,this._element.classList.remove(\"show\"),this._backdrop.hide(),this._queueCallback(()=>{this._element.setAttribute(\"aria-hidden\",!0),this._element.removeAttribute(\"aria-modal\"),this._element.removeAttribute(\"role\"),this._element.style.visibility=\"hidden\",this._config.scroll||(new ft).reset(),B.trigger(this._element,\"hidden.bs.offcanvas\")},this._element,!0)))}dispose(){this._backdrop.dispose(),super.dispose(),B.off(document,\"focusin.bs.offcanvas\")}_getConfig(t){return t={...Et,...V.getDataAttributes(this._element),...\"object\"==typeof t?t:{}},d(\"offcanvas\",t,At),t}_initializeBackDrop(){return new bt({isVisible:this._config.backdrop,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_enforceFocusOnElement(t){B.off(document,\"focusin.bs.offcanvas\"),B.on(document,\"focusin.bs.offcanvas\",e=>{document===e.target||t===e.target||t.contains(e.target)||t.focus()}),t.focus()}_addEventListeners(){B.on(this._element,\"click.dismiss.bs.offcanvas\",'[data-bs-dismiss=\"offcanvas\"]',()=>this.hide()),B.on(this._element,\"keydown.dismiss.bs.offcanvas\",t=>{this._config.keyboard&&\"Escape\"===t.key&&this.hide()})}static jQueryInterface(t){return this.each((function(){const e=Tt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t]||t.startsWith(\"_\")||\"constructor\"===t)throw new TypeError(`No method named \"${t}\"`);e[t](this)}}))}}B.on(document,\"click.bs.offcanvas.data-api\",'[data-bs-toggle=\"offcanvas\"]',(function(t){const e=a(this);if([\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),g(this))return;B.one(e,\"hidden.bs.offcanvas\",()=>{u(this)&&this.focus()});const s=i.findOne(\".offcanvas.show\");s&&s!==e&&Tt.getInstance(s).hide(),Tt.getOrCreateInstance(e).toggle(this)})),B.on(window,\"load.bs.offcanvas.data-api\",()=>i.find(\".offcanvas.show\").forEach(t=>Tt.getOrCreateInstance(t).show())),y(Tt);const Ct=new Set([\"background\",\"cite\",\"href\",\"itemtype\",\"longdesc\",\"poster\",\"src\",\"xlink:href\"]),kt=/^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/i,Lt=/^data:(?:image\\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\\/(?:mpeg|mp4|ogg|webm)|audio\\/(?:mp3|oga|ogg|opus));base64,[\\d+/a-z]+=*$/i,Ot=(t,e)=>{const s=t.nodeName.toLowerCase();if(e.includes(s))return!Ct.has(s)||Boolean(kt.test(t.nodeValue)||Lt.test(t.nodeValue));const i=e.filter(t=>t instanceof RegExp);for(let t=0,e=i.length;t<e;t++)if(i[t].test(s))return!0;return!1};function Dt(t,e,s){if(!t.length)return t;if(s&&\"function\"==typeof s)return s(t);const i=(new window.DOMParser).parseFromString(t,\"text/html\"),n=Object.keys(e),o=[].concat(...i.body.querySelectorAll(\"*\"));for(let t=0,s=o.length;t<s;t++){const s=o[t],i=s.nodeName.toLowerCase();if(!n.includes(i)){s.remove();continue}const r=[].concat(...s.attributes),a=[].concat(e[\"*\"]||[],e[i]||[]);r.forEach(t=>{Ot(t,a)||s.removeAttribute(t.nodeName)})}return i.body.innerHTML}const It=new RegExp(\"(^|\\\\s)bs-tooltip\\\\S+\",\"g\"),Nt=new Set([\"sanitize\",\"allowList\",\"sanitizeFn\"]),St={animation:\"boolean\",template:\"string\",title:\"(string|element|function)\",trigger:\"string\",delay:\"(number|object)\",html:\"boolean\",selector:\"(string|boolean)\",placement:\"(string|function)\",offset:\"(array|string|function)\",container:\"(string|element|boolean)\",fallbackPlacements:\"array\",boundary:\"(string|element)\",customClass:\"(string|function)\",sanitize:\"boolean\",sanitizeFn:\"(null|function)\",allowList:\"object\",popperConfig:\"(null|object|function)\"},xt={AUTO:\"auto\",TOP:\"top\",RIGHT:v()?\"left\":\"right\",BOTTOM:\"bottom\",LEFT:v()?\"right\":\"left\"},Mt={animation:!0,template:'<div class=\"tooltip\" role=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div></div>',trigger:\"hover focus\",title:\"\",delay:0,html:!1,selector:!1,placement:\"top\",offset:[0,0],container:!1,fallbackPlacements:[\"top\",\"right\",\"bottom\",\"left\"],boundary:\"clippingParents\",customClass:\"\",sanitize:!0,sanitizeFn:null,allowList:{\"*\":[\"class\",\"dir\",\"id\",\"lang\",\"role\",/^aria-[\\w-]*$/i],a:[\"target\",\"href\",\"title\",\"rel\"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:[\"src\",\"srcset\",\"alt\",\"title\",\"width\",\"height\"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]},popperConfig:null},Pt={HIDE:\"hide.bs.tooltip\",HIDDEN:\"hidden.bs.tooltip\",SHOW:\"show.bs.tooltip\",SHOWN:\"shown.bs.tooltip\",INSERTED:\"inserted.bs.tooltip\",CLICK:\"click.bs.tooltip\",FOCUSIN:\"focusin.bs.tooltip\",FOCUSOUT:\"focusout.bs.tooltip\",MOUSEENTER:\"mouseenter.bs.tooltip\",MOUSELEAVE:\"mouseleave.bs.tooltip\"};class jt extends q{constructor(t,e){if(void 0===s)throw new TypeError(\"Bootstrap's tooltips require Popper (https://popper.js.org)\");super(t),this._isEnabled=!0,this._timeout=0,this._hoverState=\"\",this._activeTrigger={},this._popper=null,this._config=this._getConfig(e),this.tip=null,this._setListeners()}static get Default(){return Mt}static get NAME(){return\"tooltip\"}static get Event(){return Pt}static get DefaultType(){return St}enable(){this._isEnabled=!0}disable(){this._isEnabled=!1}toggleEnabled(){this._isEnabled=!this._isEnabled}toggle(t){if(this._isEnabled)if(t){const e=this._initializeOnDelegatedTarget(t);e._activeTrigger.click=!e._activeTrigger.click,e._isWithActiveTrigger()?e._enter(null,e):e._leave(null,e)}else{if(this.getTipElement().classList.contains(\"show\"))return void this._leave(null,this);this._enter(null,this)}}dispose(){clearTimeout(this._timeout),B.off(this._element.closest(\".modal\"),\"hide.bs.modal\",this._hideModalHandler),this.tip&&this.tip.remove(),this._popper&&this._popper.destroy(),super.dispose()}show(){if(\"none\"===this._element.style.display)throw new Error(\"Please use show on visible elements\");if(!this.isWithContent()||!this._isEnabled)return;const t=B.trigger(this._element,this.constructor.Event.SHOW),e=p(this._element),i=null===e?this._element.ownerDocument.documentElement.contains(this._element):e.contains(this._element);if(t.defaultPrevented||!i)return;const o=this.getTipElement(),r=n(this.constructor.NAME);o.setAttribute(\"id\",r),this._element.setAttribute(\"aria-describedby\",r),this.setContent(),this._config.animation&&o.classList.add(\"fade\");const a=\"function\"==typeof this._config.placement?this._config.placement.call(this,o,this._element):this._config.placement,l=this._getAttachment(a);this._addAttachmentClass(l);const{container:c}=this._config;W.set(o,this.constructor.DATA_KEY,this),this._element.ownerDocument.documentElement.contains(this.tip)||(c.appendChild(o),B.trigger(this._element,this.constructor.Event.INSERTED)),this._popper?this._popper.update():this._popper=s.createPopper(this._element,o,this._getPopperConfig(l)),o.classList.add(\"show\");const h=\"function\"==typeof this._config.customClass?this._config.customClass():this._config.customClass;h&&o.classList.add(...h.split(\" \")),\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>{B.on(t,\"mouseover\",f)});const d=this.tip.classList.contains(\"fade\");this._queueCallback(()=>{const t=this._hoverState;this._hoverState=null,B.trigger(this._element,this.constructor.Event.SHOWN),\"out\"===t&&this._leave(null,this)},this.tip,d)}hide(){if(!this._popper)return;const t=this.getTipElement();if(B.trigger(this._element,this.constructor.Event.HIDE).defaultPrevented)return;t.classList.remove(\"show\"),\"ontouchstart\"in document.documentElement&&[].concat(...document.body.children).forEach(t=>B.off(t,\"mouseover\",f)),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1;const e=this.tip.classList.contains(\"fade\");this._queueCallback(()=>{this._isWithActiveTrigger()||(\"show\"!==this._hoverState&&t.remove(),this._cleanTipClass(),this._element.removeAttribute(\"aria-describedby\"),B.trigger(this._element,this.constructor.Event.HIDDEN),this._popper&&(this._popper.destroy(),this._popper=null))},this.tip,e),this._hoverState=\"\"}update(){null!==this._popper&&this._popper.update()}isWithContent(){return Boolean(this.getTitle())}getTipElement(){if(this.tip)return this.tip;const t=document.createElement(\"div\");return t.innerHTML=this._config.template,this.tip=t.children[0],this.tip}setContent(){const t=this.getTipElement();this.setElementContent(i.findOne(\".tooltip-inner\",t),this.getTitle()),t.classList.remove(\"fade\",\"show\")}setElementContent(t,e){if(null!==t)return c(e)?(e=h(e),void(this._config.html?e.parentNode!==t&&(t.innerHTML=\"\",t.appendChild(e)):t.textContent=e.textContent)):void(this._config.html?(this._config.sanitize&&(e=Dt(e,this._config.allowList,this._config.sanitizeFn)),t.innerHTML=e):t.textContent=e)}getTitle(){let t=this._element.getAttribute(\"data-bs-original-title\");return t||(t=\"function\"==typeof this._config.title?this._config.title.call(this._element):this._config.title),t}updateAttachment(t){return\"right\"===t?\"end\":\"left\"===t?\"start\":t}_initializeOnDelegatedTarget(t,e){const s=this.constructor.DATA_KEY;return(e=e||W.get(t.delegateTarget,s))||(e=new this.constructor(t.delegateTarget,this._getDelegateConfig()),W.set(t.delegateTarget,s,e)),e}_getOffset(){const{offset:t}=this._config;return\"string\"==typeof t?t.split(\",\").map(t=>Number.parseInt(t,10)):\"function\"==typeof t?e=>t(e,this._element):t}_getPopperConfig(t){const e={placement:t,modifiers:[{name:\"flip\",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:\"offset\",options:{offset:this._getOffset()}},{name:\"preventOverflow\",options:{boundary:this._config.boundary}},{name:\"arrow\",options:{element:`.${this.constructor.NAME}-arrow`}},{name:\"onChange\",enabled:!0,phase:\"afterWrite\",fn:t=>this._handlePopperPlacementChange(t)}],onFirstUpdate:t=>{t.options.placement!==t.placement&&this._handlePopperPlacementChange(t)}};return{...e,...\"function\"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_addAttachmentClass(t){this.getTipElement().classList.add(\"bs-tooltip-\"+this.updateAttachment(t))}_getAttachment(t){return xt[t.toUpperCase()]}_setListeners(){this._config.trigger.split(\" \").forEach(t=>{if(\"click\"===t)B.on(this._element,this.constructor.Event.CLICK,this._config.selector,t=>this.toggle(t));else if(\"manual\"!==t){const e=\"hover\"===t?this.constructor.Event.MOUSEENTER:this.constructor.Event.FOCUSIN,s=\"hover\"===t?this.constructor.Event.MOUSELEAVE:this.constructor.Event.FOCUSOUT;B.on(this._element,e,this._config.selector,t=>this._enter(t)),B.on(this._element,s,this._config.selector,t=>this._leave(t))}}),this._hideModalHandler=()=>{this._element&&this.hide()},B.on(this._element.closest(\".modal\"),\"hide.bs.modal\",this._hideModalHandler),this._config.selector?this._config={...this._config,trigger:\"manual\",selector:\"\"}:this._fixTitle()}_fixTitle(){const t=this._element.getAttribute(\"title\"),e=typeof this._element.getAttribute(\"data-bs-original-title\");(t||\"string\"!==e)&&(this._element.setAttribute(\"data-bs-original-title\",t||\"\"),!t||this._element.getAttribute(\"aria-label\")||this._element.textContent||this._element.setAttribute(\"aria-label\",t),this._element.setAttribute(\"title\",\"\"))}_enter(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger[\"focusin\"===t.type?\"focus\":\"hover\"]=!0),e.getTipElement().classList.contains(\"show\")||\"show\"===e._hoverState?e._hoverState=\"show\":(clearTimeout(e._timeout),e._hoverState=\"show\",e._config.delay&&e._config.delay.show?e._timeout=setTimeout(()=>{\"show\"===e._hoverState&&e.show()},e._config.delay.show):e.show())}_leave(t,e){e=this._initializeOnDelegatedTarget(t,e),t&&(e._activeTrigger[\"focusout\"===t.type?\"focus\":\"hover\"]=e._element.contains(t.relatedTarget)),e._isWithActiveTrigger()||(clearTimeout(e._timeout),e._hoverState=\"out\",e._config.delay&&e._config.delay.hide?e._timeout=setTimeout(()=>{\"out\"===e._hoverState&&e.hide()},e._config.delay.hide):e.hide())}_isWithActiveTrigger(){for(const t in this._activeTrigger)if(this._activeTrigger[t])return!0;return!1}_getConfig(t){const e=V.getDataAttributes(this._element);return Object.keys(e).forEach(t=>{Nt.has(t)&&delete e[t]}),(t={...this.constructor.Default,...e,...\"object\"==typeof t&&t?t:{}}).container=!1===t.container?document.body:h(t.container),\"number\"==typeof t.delay&&(t.delay={show:t.delay,hide:t.delay}),\"number\"==typeof t.title&&(t.title=t.title.toString()),\"number\"==typeof t.content&&(t.content=t.content.toString()),d(\"tooltip\",t,this.constructor.DefaultType),t.sanitize&&(t.template=Dt(t.template,t.allowList,t.sanitizeFn)),t}_getDelegateConfig(){const t={};if(this._config)for(const e in this._config)this.constructor.Default[e]!==this._config[e]&&(t[e]=this._config[e]);return t}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute(\"class\").match(It);null!==e&&e.length>0&&e.map(t=>t.trim()).forEach(e=>t.classList.remove(e))}_handlePopperPlacementChange(t){const{state:e}=t;e&&(this.tip=e.elements.popper,this._cleanTipClass(),this._addAttachmentClass(this._getAttachment(e.placement)))}static jQueryInterface(t){return this.each((function(){const e=jt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}y(jt);const Ht=new RegExp(\"(^|\\\\s)bs-popover\\\\S+\",\"g\"),Rt={...jt.Default,placement:\"right\",offset:[0,8],trigger:\"click\",content:\"\",template:'<div class=\"popover\" role=\"tooltip\"><div class=\"popover-arrow\"></div><h3 class=\"popover-header\"></h3><div class=\"popover-body\"></div></div>'},Bt={...jt.DefaultType,content:\"(string|element|function)\"},$t={HIDE:\"hide.bs.popover\",HIDDEN:\"hidden.bs.popover\",SHOW:\"show.bs.popover\",SHOWN:\"shown.bs.popover\",INSERTED:\"inserted.bs.popover\",CLICK:\"click.bs.popover\",FOCUSIN:\"focusin.bs.popover\",FOCUSOUT:\"focusout.bs.popover\",MOUSEENTER:\"mouseenter.bs.popover\",MOUSELEAVE:\"mouseleave.bs.popover\"};class Wt extends jt{static get Default(){return Rt}static get NAME(){return\"popover\"}static get Event(){return $t}static get DefaultType(){return Bt}isWithContent(){return this.getTitle()||this._getContent()}getTipElement(){return this.tip||(this.tip=super.getTipElement(),this.getTitle()||i.findOne(\".popover-header\",this.tip).remove(),this._getContent()||i.findOne(\".popover-body\",this.tip).remove()),this.tip}setContent(){const t=this.getTipElement();this.setElementContent(i.findOne(\".popover-header\",t),this.getTitle());let e=this._getContent();\"function\"==typeof e&&(e=e.call(this._element)),this.setElementContent(i.findOne(\".popover-body\",t),e),t.classList.remove(\"fade\",\"show\")}_addAttachmentClass(t){this.getTipElement().classList.add(\"bs-popover-\"+this.updateAttachment(t))}_getContent(){return this._element.getAttribute(\"data-bs-content\")||this._config.content}_cleanTipClass(){const t=this.getTipElement(),e=t.getAttribute(\"class\").match(Ht);null!==e&&e.length>0&&e.map(t=>t.trim()).forEach(e=>t.classList.remove(e))}static jQueryInterface(t){return this.each((function(){const e=Wt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}y(Wt);const qt={offset:10,method:\"auto\",target:\"\"},zt={offset:\"number\",method:\"string\",target:\"(string|element)\"};class Ft extends q{constructor(t,e){super(t),this._scrollElement=\"BODY\"===this._element.tagName?window:this._element,this._config=this._getConfig(e),this._selector=`${this._config.target} .nav-link, ${this._config.target} .list-group-item, ${this._config.target} .dropdown-item`,this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,B.on(this._scrollElement,\"scroll.bs.scrollspy\",()=>this._process()),this.refresh(),this._process()}static get Default(){return qt}static get NAME(){return\"scrollspy\"}refresh(){const t=this._scrollElement===this._scrollElement.window?\"offset\":\"position\",e=\"auto\"===this._config.method?t:this._config.method,s=\"position\"===e?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight(),i.find(this._selector).map(t=>{const n=r(t),o=n?i.findOne(n):null;if(o){const t=o.getBoundingClientRect();if(t.width||t.height)return[V[e](o).top+s,n]}return null}).filter(t=>t).sort((t,e)=>t[0]-e[0]).forEach(t=>{this._offsets.push(t[0]),this._targets.push(t[1])})}dispose(){B.off(this._scrollElement,\".bs.scrollspy\"),super.dispose()}_getConfig(t){if(\"string\"!=typeof(t={...qt,...V.getDataAttributes(this._element),...\"object\"==typeof t&&t?t:{}}).target&&c(t.target)){let{id:e}=t.target;e||(e=n(\"scrollspy\"),t.target.id=e),t.target=\"#\"+e}return d(\"scrollspy\",t,zt),t}_getScrollTop(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop}_getScrollHeight(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}_getOffsetHeight(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height}_process(){const t=this._getScrollTop()+this._config.offset,e=this._getScrollHeight(),s=this._config.offset+e-this._getOffsetHeight();if(this._scrollHeight!==e&&this.refresh(),t>=s){const t=this._targets[this._targets.length-1];this._activeTarget!==t&&this._activate(t)}else{if(this._activeTarget&&t<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(let e=this._offsets.length;e--;)this._activeTarget!==this._targets[e]&&t>=this._offsets[e]&&(void 0===this._offsets[e+1]||t<this._offsets[e+1])&&this._activate(this._targets[e])}}_activate(t){this._activeTarget=t,this._clear();const e=this._selector.split(\",\").map(e=>`${e}[data-bs-target=\"${t}\"],${e}[href=\"${t}\"]`),s=i.findOne(e.join(\",\"));s.classList.contains(\"dropdown-item\")?(i.findOne(\".dropdown-toggle\",s.closest(\".dropdown\")).classList.add(\"active\"),s.classList.add(\"active\")):(s.classList.add(\"active\"),i.parents(s,\".nav, .list-group\").forEach(t=>{i.prev(t,\".nav-link, .list-group-item\").forEach(t=>t.classList.add(\"active\")),i.prev(t,\".nav-item\").forEach(t=>{i.children(t,\".nav-link\").forEach(t=>t.classList.add(\"active\"))})})),B.trigger(this._scrollElement,\"activate.bs.scrollspy\",{relatedTarget:t})}_clear(){i.find(this._selector).filter(t=>t.classList.contains(\"active\")).forEach(t=>t.classList.remove(\"active\"))}static jQueryInterface(t){return this.each((function(){const e=Ft.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}B.on(window,\"load.bs.scrollspy.data-api\",()=>{i.find('[data-bs-spy=\"scroll\"]').forEach(t=>new Ft(t))}),y(Ft);class Ut extends q{static get NAME(){return\"tab\"}show(){if(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&this._element.classList.contains(\"active\"))return;let t;const e=a(this._element),s=this._element.closest(\".nav, .list-group\");if(s){const e=\"UL\"===s.nodeName||\"OL\"===s.nodeName?\":scope > li > .active\":\".active\";t=i.find(e,s),t=t[t.length-1]}const n=t?B.trigger(t,\"hide.bs.tab\",{relatedTarget:this._element}):null;if(B.trigger(this._element,\"show.bs.tab\",{relatedTarget:t}).defaultPrevented||null!==n&&n.defaultPrevented)return;this._activate(this._element,s);const o=()=>{B.trigger(t,\"hidden.bs.tab\",{relatedTarget:this._element}),B.trigger(this._element,\"shown.bs.tab\",{relatedTarget:t})};e?this._activate(e,e.parentNode,o):o()}_activate(t,e,s){const n=(!e||\"UL\"!==e.nodeName&&\"OL\"!==e.nodeName?i.children(e,\".active\"):i.find(\":scope > li > .active\",e))[0],o=s&&n&&n.classList.contains(\"fade\"),r=()=>this._transitionComplete(t,n,s);n&&o?(n.classList.remove(\"show\"),this._queueCallback(r,t,!0)):r()}_transitionComplete(t,e,s){if(e){e.classList.remove(\"active\");const t=i.findOne(\":scope > .dropdown-menu .active\",e.parentNode);t&&t.classList.remove(\"active\"),\"tab\"===e.getAttribute(\"role\")&&e.setAttribute(\"aria-selected\",!1)}t.classList.add(\"active\"),\"tab\"===t.getAttribute(\"role\")&&t.setAttribute(\"aria-selected\",!0),m(t),t.classList.contains(\"fade\")&&t.classList.add(\"show\");let n=t.parentNode;if(n&&\"LI\"===n.nodeName&&(n=n.parentNode),n&&n.classList.contains(\"dropdown-menu\")){const e=t.closest(\".dropdown\");e&&i.find(\".dropdown-toggle\",e).forEach(t=>t.classList.add(\"active\")),t.setAttribute(\"aria-expanded\",!0)}s&&s()}static jQueryInterface(t){return this.each((function(){const e=Ut.getOrCreateInstance(this);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t]()}}))}}B.on(document,\"click.bs.tab.data-api\",'[data-bs-toggle=\"tab\"], [data-bs-toggle=\"pill\"], [data-bs-toggle=\"list\"]',(function(t){[\"A\",\"AREA\"].includes(this.tagName)&&t.preventDefault(),g(this)||Ut.getOrCreateInstance(this).show()})),y(Ut);const Kt={animation:\"boolean\",autohide:\"boolean\",delay:\"number\"},Vt={animation:!0,autohide:!0,delay:5e3};class Qt extends q{constructor(t,e){super(t),this._config=this._getConfig(e),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners()}static get DefaultType(){return Kt}static get Default(){return Vt}static get NAME(){return\"toast\"}show(){B.trigger(this._element,\"show.bs.toast\").defaultPrevented||(this._clearTimeout(),this._config.animation&&this._element.classList.add(\"fade\"),this._element.classList.remove(\"hide\"),m(this._element),this._element.classList.add(\"showing\"),this._queueCallback(()=>{this._element.classList.remove(\"showing\"),this._element.classList.add(\"show\"),B.trigger(this._element,\"shown.bs.toast\"),this._maybeScheduleHide()},this._element,this._config.animation))}hide(){this._element.classList.contains(\"show\")&&(B.trigger(this._element,\"hide.bs.toast\").defaultPrevented||(this._element.classList.remove(\"show\"),this._queueCallback(()=>{this._element.classList.add(\"hide\"),B.trigger(this._element,\"hidden.bs.toast\")},this._element,this._config.animation)))}dispose(){this._clearTimeout(),this._element.classList.contains(\"show\")&&this._element.classList.remove(\"show\"),super.dispose()}_getConfig(t){return t={...Vt,...V.getDataAttributes(this._element),...\"object\"==typeof t&&t?t:{}},d(\"toast\",t,this.constructor.DefaultType),t}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout(()=>{this.hide()},this._config.delay)))}_onInteraction(t,e){switch(t.type){case\"mouseover\":case\"mouseout\":this._hasMouseInteraction=e;break;case\"focusin\":case\"focusout\":this._hasKeyboardInteraction=e}if(e)return void this._clearTimeout();const s=t.relatedTarget;this._element===s||this._element.contains(s)||this._maybeScheduleHide()}_setListeners(){B.on(this._element,\"click.dismiss.bs.toast\",'[data-bs-dismiss=\"toast\"]',()=>this.hide()),B.on(this._element,\"mouseover.bs.toast\",t=>this._onInteraction(t,!0)),B.on(this._element,\"mouseout.bs.toast\",t=>this._onInteraction(t,!1)),B.on(this._element,\"focusin.bs.toast\",t=>this._onInteraction(t,!0)),B.on(this._element,\"focusout.bs.toast\",t=>this._onInteraction(t,!1))}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null}static jQueryInterface(t){return this.each((function(){const e=Qt.getOrCreateInstance(this,t);if(\"string\"==typeof t){if(void 0===e[t])throw new TypeError(`No method named \"${t}\"`);e[t](this)}}))}}return y(Qt),{Alert:z,Button:F,Carousel:et,Collapse:nt,Dropdown:pt,Modal:wt,Offcanvas:Tt,Popover:Wt,ScrollSpy:Ft,Tab:Ut,Toast:Qt,Tooltip:jt}}));\n//# sourceMappingURL=bootstrap.min.js.map\n","Mageplaza_Core/js/jquery.autocomplete.min.js":"/**\r\n *  Ajax Autocomplete for jQuery, version 1.3.0\r\n *  (c) 2017 Tomas Kirda\r\n *\r\n *  Ajax Autocomplete for jQuery is freely distributable under the terms of an MIT-style license.\r\n *  For details, see the web site: https://github.com/devbridge/jQuery-Autocomplete\r\n */\r\n!function(a){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],a):a(\"object\"==typeof exports&&\"function\"==typeof require?require(\"jquery\"):jQuery)}(function(a){\"use strict\";function b(c,d){var e=a.noop,f=this,g={ajaxSettings:{},autoSelectFirst:!1,appendTo:document.body,serviceUrl:null,lookup:null,onSelect:null,width:\"auto\",minChars:1,maxHeight:300,deferRequestBy:0,params:{},formatResult:b.formatResult,formatGroup:b.formatGroup,delimiter:null,zIndex:9999,type:\"GET\",noCache:!1,onSearchStart:e,onSearchComplete:e,onSearchError:e,preserveInput:!1,containerClass:\"autocomplete-suggestions\",tabDisabled:!1,dataType:\"text\",currentRequest:null,triggerSelectOnValidInput:!0,preventBadQueries:!0,lookupFilter:function(a,b,c){return-1!==a.value.toLowerCase().indexOf(c)},paramName:\"query\",transformResult:function(b){return\"string\"==typeof b?a.parseJSON(b):b},showNoSuggestionNotice:!1,noSuggestionNotice:\"No results\",orientation:\"bottom\",forceFixPosition:!1};f.element=c,f.el=a(c),f.suggestions=[],f.badQueries=[],f.selectedIndex=-1,f.currentValue=f.element.value,f.intervalId=0,f.cachedResponse={},f.onChangeInterval=null,f.onChange=null,f.isLocal=!1,f.suggestionsContainer=null,f.noSuggestionsContainer=null,f.options=a.extend({},g,d),f.classes={selected:\"autocomplete-selected\",suggestion:\"autocomplete-suggestion\"},f.hint=null,f.hintValue=\"\",f.selection=null,f.initialize(),f.setOptions(d)}var c=function(){return{escapeRegExChars:function(a){return a.replace(/[|\\\\{}()[\\]^$+*?.]/g,\"\\\\$&\")},createNode:function(a){var b=document.createElement(\"div\");return b.className=a,b.style.position=\"absolute\",b.style.display=\"none\",b}}}(),d={ESC:27,TAB:9,RETURN:13,LEFT:37,UP:38,RIGHT:39,DOWN:40};b.utils=c,a.Autocomplete=b,b.formatResult=function(a,b){if(!b)return a.value;var d=\"(\"+c.escapeRegExChars(b)+\")\";return a.value.replace(new RegExp(d,\"gi\"),\"<strong>$1</strong>\").replace(/&/g,\"&amp;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\").replace(/\"/g,\"&quot;\").replace(/&lt;(\\/?strong)&gt;/g,\"<$1>\")},b.formatGroup=function(a,b){return'<div class=\"autocomplete-group\"><strong>'+b+\"</strong></div>\"},b.prototype={killerFn:null,initialize:function(){var c,d=this,e=\".\"+d.classes.suggestion,f=d.classes.selected,g=d.options;d.element.setAttribute(\"autocomplete\",\"off\"),d.killerFn=function(b){a(b.target).closest(\".\"+d.options.containerClass).length||(d.killSuggestions(),d.disableKillerFn())},d.noSuggestionsContainer=a('<div class=\"autocomplete-no-suggestion\"></div>').html(this.options.noSuggestionNotice).get(0),d.suggestionsContainer=b.utils.createNode(g.containerClass),c=a(d.suggestionsContainer),c.appendTo(g.appendTo),\"auto\"!==g.width&&c.css(\"width\",g.width),c.on(\"mouseover.autocomplete\",e,function(){d.activate(a(this).data(\"index\"))}),c.on(\"mouseout.autocomplete\",function(){d.selectedIndex=-1,c.children(\".\"+f).removeClass(f)}),c.on(\"click.autocomplete\",e,function(){return d.select(a(this).data(\"index\")),!1}),d.fixPositionCapture=function(){d.visible&&d.fixPosition()},a(window).on(\"resize.autocomplete\",d.fixPositionCapture),d.el.on(\"keydown.autocomplete\",function(a){d.onKeyPress(a)}),d.el.on(\"keyup.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"blur.autocomplete\",function(){d.onBlur()}),d.el.on(\"focus.autocomplete\",function(){d.onFocus()}),d.el.on(\"change.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"input.autocomplete\",function(a){d.onKeyUp(a)})},onFocus:function(){var a=this;a.fixPosition(),a.el.val().length>=a.options.minChars&&a.onValueChange()},onBlur:function(){this.enableKillerFn()},abortAjax:function(){var a=this;a.currentRequest&&(a.currentRequest.abort(),a.currentRequest=null)},setOptions:function(b){var c=this,d=c.options;a.extend(d,b),c.isLocal=a.isArray(d.lookup),c.isLocal&&(d.lookup=c.verifySuggestionsFormat(d.lookup)),d.orientation=c.validateOrientation(d.orientation,\"bottom\"),a(c.suggestionsContainer).css({\"max-height\":d.maxHeight+\"px\",width:d.width+\"px\",\"z-index\":d.zIndex})},clearCache:function(){this.cachedResponse={},this.badQueries=[]},clear:function(){this.clearCache(),this.currentValue=\"\",this.suggestions=[]},disable:function(){var a=this;a.disabled=!0,clearInterval(a.onChangeInterval),a.abortAjax()},enable:function(){this.disabled=!1},fixPosition:function(){var b=this,c=a(b.suggestionsContainer),d=c.parent().get(0);if(d===document.body||b.options.forceFixPosition){var e=b.options.orientation,f=c.outerHeight(),g=b.el.outerHeight(),h=b.el.offset(),i={top:h.top,left:h.left};if(\"auto\"===e){var j=a(window).height(),k=a(window).scrollTop(),l=-k+h.top-f,m=k+j-(h.top+g+f);e=Math.max(l,m)===l?\"top\":\"bottom\"}if(\"top\"===e?i.top+=-f:i.top+=g,d!==document.body){var n,o=c.css(\"opacity\");b.visible||c.css(\"opacity\",0).show(),n=c.offsetParent().offset(),i.top-=n.top,i.left-=n.left,b.visible||c.css(\"opacity\",o).hide()}\"auto\"===b.options.width&&(i.width=b.el.outerWidth()+\"px\"),c.css(i)}},enableKillerFn:function(){var b=this;a(document).on(\"click.autocomplete\",b.killerFn)},disableKillerFn:function(){var b=this;a(document).off(\"click.autocomplete\",b.killerFn)},killSuggestions:function(){var a=this;a.stopKillSuggestions(),a.intervalId=window.setInterval(function(){a.visible&&(a.options.preserveInput||a.el.val(a.currentValue),a.hide()),a.stopKillSuggestions()},50)},stopKillSuggestions:function(){window.clearInterval(this.intervalId)},isCursorAtEnd:function(){var a,b=this,c=b.el.val().length,d=b.element.selectionStart;return\"number\"==typeof d?d===c:document.selection?(a=document.selection.createRange(),a.moveStart(\"character\",-c),c===a.text.length):!0},onKeyPress:function(a){var b=this;if(!b.disabled&&!b.visible&&a.which===d.DOWN&&b.currentValue)return void b.suggest();if(!b.disabled&&b.visible){switch(a.which){case d.ESC:b.el.val(b.currentValue),b.hide();break;case d.RIGHT:if(b.hint&&b.options.onHint&&b.isCursorAtEnd()){b.selectHint();break}return;case d.TAB:if(b.hint&&b.options.onHint)return void b.selectHint();if(-1===b.selectedIndex)return void b.hide();if(b.select(b.selectedIndex),b.options.tabDisabled===!1)return;break;case d.RETURN:if(-1===b.selectedIndex)return void b.hide();b.select(b.selectedIndex);break;case d.UP:b.moveUp();break;case d.DOWN:b.moveDown();break;default:return}a.stopImmediatePropagation(),a.preventDefault()}},onKeyUp:function(a){var b=this;if(!b.disabled){switch(a.which){case d.UP:case d.DOWN:return}clearInterval(b.onChangeInterval),b.currentValue!==b.el.val()&&(b.findBestHint(),b.options.deferRequestBy>0?b.onChangeInterval=setInterval(function(){b.onValueChange()},b.options.deferRequestBy):b.onValueChange())}},onValueChange:function(){var b=this,c=b.options,d=b.el.val(),e=b.getQuery(d);return b.selection&&b.currentValue!==e&&(b.selection=null,(c.onInvalidateSelection||a.noop).call(b.element)),clearInterval(b.onChangeInterval),b.currentValue=d,b.selectedIndex=-1,c.triggerSelectOnValidInput&&b.isExactMatch(e)?void b.select(0):void(e.length<c.minChars?b.hide():b.getSuggestions(e))},isExactMatch:function(a){var b=this.suggestions;return 1===b.length&&b[0].value.toLowerCase()===a.toLowerCase()},getQuery:function(b){var c,d=this.options.delimiter;return d?(c=b.split(d),a.trim(c[c.length-1])):b},getSuggestionsLocal:function(b){var c,d=this,e=d.options,f=b.toLowerCase(),g=e.lookupFilter,h=parseInt(e.lookupLimit,10);return c={suggestions:a.grep(e.lookup,function(a){return g(a,b,f)})},h&&c.suggestions.length>h&&(c.suggestions=c.suggestions.slice(0,h)),c},getSuggestions:function(b){var c,d,e,f,g=this,h=g.options,i=h.serviceUrl;if(h.params[h.paramName]=b,d=h.ignoreParams?null:h.params,h.onSearchStart.call(g.element,h.params)!==!1){if(a.isFunction(h.lookup))return void h.lookup(b,function(a){g.suggestions=a.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,a.suggestions)});g.isLocal?c=g.getSuggestionsLocal(b):(a.isFunction(i)&&(i=i.call(g.element,b)),e=i+\"?\"+a.param(d||{}),c=g.cachedResponse[e]),c&&a.isArray(c.suggestions)?(g.suggestions=c.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,c.suggestions)):g.isBadQuery(b)?h.onSearchComplete.call(g.element,b,[]):(g.abortAjax(),f={url:i,data:d,type:h.type,dataType:h.dataType},a.extend(f,h.ajaxSettings),g.currentRequest=a.ajax(f).done(function(a){var c;g.currentRequest=null,c=h.transformResult(a,b),g.processResponse(c,b,e),h.onSearchComplete.call(g.element,b,c.suggestions)}).fail(function(a,c,d){h.onSearchError.call(g.element,b,a,c,d)}))}},isBadQuery:function(a){if(!this.options.preventBadQueries)return!1;for(var b=this.badQueries,c=b.length;c--;)if(0===a.indexOf(b[c]))return!0;return!1},hide:function(){var b=this,c=a(b.suggestionsContainer);a.isFunction(b.options.onHide)&&b.visible&&b.options.onHide.call(b.element,c),b.visible=!1,b.selectedIndex=-1,clearInterval(b.onChangeInterval),a(b.suggestionsContainer).hide(),b.signalHint(null)},suggest:function(){if(!this.suggestions.length)return void(this.options.showNoSuggestionNotice?this.noSuggestions():this.hide());var b,c=this,d=c.options,e=d.groupBy,f=d.formatResult,g=c.getQuery(c.currentValue),h=c.classes.suggestion,i=c.classes.selected,j=a(c.suggestionsContainer),k=a(c.noSuggestionsContainer),l=d.beforeRender,m=\"\",n=function(a,c){var f=a.data[e];return b===f?\"\":(b=f,d.formatGroup(a,b))};return d.triggerSelectOnValidInput&&c.isExactMatch(g)?void c.select(0):(a.each(c.suggestions,function(a,b){e&&(m+=n(b,g,a)),m+='<div class=\"'+h+'\" data-index=\"'+a+'\">'+f(b,g,a)+\"</div>\"}),this.adjustContainerWidth(),k.detach(),j.html(m),a.isFunction(l)&&l.call(c.element,j,c.suggestions),c.fixPosition(),j.show(),d.autoSelectFirst&&(c.selectedIndex=0,j.scrollTop(0),j.children(\".\"+h).first().addClass(i)),c.visible=!0,void c.findBestHint())},noSuggestions:function(){var b=this,c=a(b.suggestionsContainer),d=a(b.noSuggestionsContainer);this.adjustContainerWidth(),d.detach(),c.empty(),c.append(d),b.fixPosition(),c.show(),b.visible=!0},adjustContainerWidth:function(){var b,c=this,d=c.options,e=a(c.suggestionsContainer);\"auto\"===d.width?(b=c.el.outerWidth(),e.css(\"width\",b>0?b:300)):\"flex\"===d.width&&e.css(\"width\",\"\")},findBestHint:function(){var b=this,c=b.el.val().toLowerCase(),d=null;c&&(a.each(b.suggestions,function(a,b){var e=0===b.value.toLowerCase().indexOf(c);return e&&(d=b),!e}),b.signalHint(d))},signalHint:function(b){var c=\"\",d=this;b&&(c=d.currentValue+b.value.substr(d.currentValue.length)),d.hintValue!==c&&(d.hintValue=c,d.hint=b,(this.options.onHint||a.noop)(c))},verifySuggestionsFormat:function(b){return b.length&&\"string\"==typeof b[0]?a.map(b,function(a){return{value:a,data:null}}):b},validateOrientation:function(b,c){return b=a.trim(b||\"\").toLowerCase(),-1===a.inArray(b,[\"auto\",\"bottom\",\"top\"])&&(b=c),b},processResponse:function(a,b,c){var d=this,e=d.options;a.suggestions=d.verifySuggestionsFormat(a.suggestions),e.noCache||(d.cachedResponse[c]=a,e.preventBadQueries&&!a.suggestions.length&&d.badQueries.push(b)),b===d.getQuery(d.currentValue)&&(d.suggestions=a.suggestions,d.suggest())},activate:function(b){var c,d=this,e=d.classes.selected,f=a(d.suggestionsContainer),g=f.find(\".\"+d.classes.suggestion);return f.find(\".\"+e).removeClass(e),d.selectedIndex=b,-1!==d.selectedIndex&&g.length>d.selectedIndex?(c=g.get(d.selectedIndex),a(c).addClass(e),c):null},selectHint:function(){var b=this,c=a.inArray(b.hint,b.suggestions);b.select(c)},select:function(a){var b=this;b.hide(),b.onSelect(a),b.disableKillerFn()},moveUp:function(){var b=this;if(-1!==b.selectedIndex)return 0===b.selectedIndex?(a(b.suggestionsContainer).children().first().removeClass(b.classes.selected),b.selectedIndex=-1,b.el.val(b.currentValue),void b.findBestHint()):void b.adjustScroll(b.selectedIndex-1)},moveDown:function(){var a=this;a.selectedIndex!==a.suggestions.length-1&&a.adjustScroll(a.selectedIndex+1)},adjustScroll:function(b){var c=this,d=c.activate(b);if(d){var e,f,g,h=a(d).outerHeight();e=d.offsetTop,f=a(c.suggestionsContainer).scrollTop(),g=f+c.options.maxHeight-h,f>e?a(c.suggestionsContainer).scrollTop(e):e>g&&a(c.suggestionsContainer).scrollTop(e-c.options.maxHeight+h),c.options.preserveInput||c.el.val(c.getValue(c.suggestions[b].value)),c.signalHint(null)}},onSelect:function(b){var c=this,d=c.options.onSelect,e=c.suggestions[b];c.currentValue=c.getValue(e.value),c.currentValue===c.el.val()||c.options.preserveInput||c.el.val(c.currentValue),c.signalHint(null),c.suggestions=[],c.selection=e,a.isFunction(d)&&d.call(c.element,e)},getValue:function(a){var b,c,d=this,e=d.options.delimiter;return e?(b=d.currentValue,c=b.split(e),1===c.length?a:b.substr(0,b.length-c[c.length-1].length)+a):a},dispose:function(){var b=this;b.el.off(\".autocomplete\").removeData(\"autocomplete\"),b.disableKillerFn(),a(window).off(\"resize.autocomplete\",b.fixPositionCapture),a(b.suggestionsContainer).remove()}},a.fn.autocomplete=a.fn.devbridgeAutocomplete=function(c,d){var e=\"autocomplete\";return arguments.length?this.each(function(){var f=a(this),g=f.data(e);\"string\"==typeof c?g&&\"function\"==typeof g[c]&&g[c](d):(g&&g.dispose&&g.dispose(),g=new b(this,c),f.data(e,g))}):this.first().data(e)}});","Mageplaza_Core/js/owl.carousel.min.js":"/**\r\n * Owl Carousel v2.3.4\r\n * Copyright 2013-2018 David Deutsch\r\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\r\n */\r\n!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:[\"busy\"],animating:[\"busy\"],dragging:[\"interacting\"]}},a.each([\"onResize\",\"onThrottledResize\"],a.proxy(function(b,c){this._handlers[c]=a.proxy(this[c],this)},this)),a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a.charAt(0).toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Workers,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}e.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,fallbackEasing:\"swing\",slideTransition:\"\",info:!1,nestedItemSelector:!1,itemElement:\"div\",stageElement:\"div\",refreshClass:\"owl-refresh\",loadedClass:\"owl-loaded\",loadingClass:\"owl-loading\",rtlClass:\"owl-rtl\",responsiveClass:\"owl-responsive\",dragClass:\"owl-drag\",itemClass:\"owl-item\",stageClass:\"owl-stage\",stageOuterClass:\"owl-stage-outer\",grabClass:\"owl-grab\"},e.Width={Default:\"default\",Inner:\"inner\",Outer:\"outer\"},e.Type={Event:\"event\",State:\"state\"},e.Plugins={},e.Workers=[{filter:[\"width\",\"settings\"],run:function(){this._width=this.$element.width()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:[\"items\",\"settings\"],run:function(){this.$stage.children(\".cloned\").remove()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this.settings.margin||\"\",c=!this.settings.autoWidth,d=this.settings.rtl,e={width:\"auto\",\"margin-left\":d?b:\"\",\"margin-right\":d?\"\":b};!c&&this.$stage.children().css(e),a.css=e}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,c=null,d=this._items.length,e=!this.settings.autoWidth,f=[];for(a.items={merge:!1,width:b};d--;)c=this._mergers[d],c=this.settings.mergeFit&&Math.min(c,this.settings.items)||c,a.items.merge=c>1||a.items.merge,f[d]=e?b*c:this._items[d].width();this._widths=f}},{filter:[\"items\",\"settings\"],run:function(){var b=[],c=this._items,d=this.settings,e=Math.max(2*d.items,4),f=2*Math.ceil(c.length/2),g=d.loop&&c.length?d.rewind?e:Math.max(e,f):0,h=\"\",i=\"\";for(g/=2;g>0;)b.push(this.normalize(b.length/2,!0)),h+=c[b[b.length-1]][0].outerHTML,b.push(this.normalize(c.length-1-(b.length-1)/2,!0)),i=c[b[b.length-1]][0].outerHTML+i,g-=1;this._clones=b,a(h).addClass(\"cloned\").appendTo(this.$stage),a(i).addClass(\"cloned\").prependTo(this.$stage)}},{filter:[\"width\",\"items\",\"settings\"],run:function(){for(var a=this.settings.rtl?1:-1,b=this._clones.length+this._items.length,c=-1,d=0,e=0,f=[];++c<b;)d=f[c-1]||0,e=this._widths[this.relative(c)]+this.settings.margin,f.push(d+e*a);this._coordinates=f}},{filter:[\"width\",\"items\",\"settings\"],run:function(){var a=this.settings.stagePadding,b=this._coordinates,c={width:Math.ceil(Math.abs(b[b.length-1]))+2*a,\"padding-left\":a||\"\",\"padding-right\":a||\"\"};this.$stage.css(c)}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this._coordinates.length,c=!this.settings.autoWidth,d=this.$stage.children();if(c&&a.items.merge)for(;b--;)a.css.width=this._widths[this.relative(b)],d.eq(b).css(a.css);else c&&(a.css.width=a.items.width,d.css(a.css))}},{filter:[\"items\"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr(\"style\")}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=a.current?this.$stage.children().index(a.current):0,a.current=Math.max(this.minimum(),Math.min(this.maximum(),a.current)),this.reset(a.current)}},{filter:[\"position\"],run:function(){this.animate(this.coordinates(this._current))}},{filter:[\"width\",\"position\",\"items\",\"settings\"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;c<d;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,\"<=\",g)&&this.op(a,\">\",h)||this.op(b,\"<\",g)&&this.op(b,\">\",h))&&i.push(c);this.$stage.children(\".active\").removeClass(\"active\"),this.$stage.children(\":eq(\"+i.join(\"), :eq(\")+\")\").addClass(\"active\"),this.$stage.children(\".center\").removeClass(\"center\"),this.settings.center&&this.$stage.children().eq(this.current()).addClass(\"center\")}}],e.prototype.initializeStage=function(){this.$stage=this.$element.find(\".\"+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=a(\"<\"+this.settings.stageElement+\">\",{class:this.settings.stageClass}).wrap(a(\"<div/>\",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},e.prototype.initializeItems=function(){var b=this.$element.find(\".owl-item\");if(b.length)return this._items=b.get().map(function(b){return a(b)}),this._mergers=this._items.map(function(){return 1}),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate(\"width\"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},e.prototype.initialize=function(){if(this.enter(\"initializing\"),this.trigger(\"initialize\"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is(\"pre-loading\")){var a,b,c;a=this.$element.find(\"img\"),b=this.settings.nestedItemSelector?\".\"+this.settings.nestedItemSelector:d,c=this.$element.children(b).width(),a.length&&c<=0&&this.preloadAutoWidthImages(a)}this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave(\"initializing\"),this.trigger(\"initialized\")},e.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(\":visible\")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){a<=b&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),\"function\"==typeof e.stagePadding&&(e.stagePadding=e.stagePadding()),delete e.responsive,e.responsiveClass&&this.$element.attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(\"(\"+this.options.responsiveClass+\"-)\\\\S+\\\\s\",\"g\"),\"$1\"+d))):e=a.extend({},this.options),this.trigger(\"change\",{property:{name:\"settings\",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate(\"settings\"),this.trigger(\"changed\",{property:{name:\"settings\",value:this.settings}})},e.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger(\"prepare\",{content:b});return c.data||(c.data=a(\"<\"+this.settings.itemElement+\"/>\").addClass(this.options.itemClass).append(b)),this.trigger(\"prepared\",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};b<c;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={},!this.is(\"valid\")&&this.enter(\"valid\")},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){this.enter(\"refreshing\"),this.trigger(\"refresh\"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave(\"refreshing\"),this.trigger(\"refreshed\")},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter(\"resizing\"),this.trigger(\"resize\").isDefaultPrevented()?(this.leave(\"resizing\"),!1):(this.invalidate(\"width\"),this.refresh(),this.leave(\"resizing\"),void this.trigger(\"resized\")))))},e.prototype.registerEventHandlers=function(){a.support.transition&&this.$stage.on(a.support.transition.end+\".owl.core\",a.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(b,\"resize\",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on(\"mousedown.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"dragstart.owl.core selectstart.owl.core\",function(){return!1})),this.settings.touchDrag&&(this.$stage.on(\"touchstart.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"touchcancel.owl.core\",a.proxy(this.onDragEnd,this)))},e.prototype.onDragStart=function(b){var d=null;3!==b.which&&(a.support.transform?(d=this.$stage.css(\"transform\").replace(/.*\\(|\\)| /g,\"\").split(\",\"),d={x:d[16===d.length?12:4],y:d[16===d.length?13:5]}):(d=this.$stage.position(),d={x:this.settings.rtl?d.left+this.$stage.width()-this.width()+this.settings.margin:d.left,y:d.top}),this.is(\"animating\")&&(a.support.transform?this.animate(d.x):this.$stage.stop(),this.invalidate(\"position\")),this.$element.toggleClass(this.options.grabClass,\"mousedown\"===b.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=a(b.target),this._drag.stage.start=d,this._drag.stage.current=d,this._drag.pointer=this.pointer(b),a(c).on(\"mouseup.owl.core touchend.owl.core\",a.proxy(this.onDragEnd,this)),a(c).one(\"mousemove.owl.core touchmove.owl.core\",a.proxy(function(b){var d=this.difference(this._drag.pointer,this.pointer(b));a(c).on(\"mousemove.owl.core touchmove.owl.core\",a.proxy(this.onDragMove,this)),Math.abs(d.x)<Math.abs(d.y)&&this.is(\"valid\")||(b.preventDefault(),this.enter(\"dragging\"),this.trigger(\"drag\"))},this)))},e.prototype.onDragMove=function(a){var b=null,c=null,d=null,e=this.difference(this._drag.pointer,this.pointer(a)),f=this.difference(this._drag.stage.start,e);this.is(\"dragging\")&&(a.preventDefault(),this.settings.loop?(b=this.coordinates(this.minimum()),c=this.coordinates(this.maximum()+1)-b,f.x=((f.x-b)%c+c)%c+b):(b=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),c=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),d=this.settings.pullDrag?-1*e.x/5:0,f.x=Math.max(Math.min(f.x,b+d),c+d)),this._drag.stage.current=f,this.animate(f.x))},e.prototype.onDragEnd=function(b){var d=this.difference(this._drag.pointer,this.pointer(b)),e=this._drag.stage.current,f=d.x>0^this.settings.rtl?\"left\":\"right\";a(c).off(\".owl.core\"),this.$element.removeClass(this.options.grabClass),(0!==d.x&&this.is(\"dragging\")||!this.is(\"valid\"))&&(this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(e.x,0!==d.x?f:this._drag.direction)),this.invalidate(\"position\"),this.update(),this._drag.direction=f,(Math.abs(d.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one(\"click.owl.core\",function(){return!1})),this.is(\"dragging\")&&(this.leave(\"dragging\"),this.trigger(\"dragged\"))},e.prototype.closest=function(b,c){var e=-1,f=30,g=this.width(),h=this.coordinates();return this.settings.freeDrag||a.each(h,a.proxy(function(a,i){return\"left\"===c&&b>i-f&&b<i+f?e=a:\"right\"===c&&b>i-g-f&&b<i-g+f?e=a+1:this.op(b,\"<\",i)&&this.op(b,\">\",h[a+1]!==d?h[a+1]:i-g)&&(e=\"left\"===c?a+1:a),-1===e},this)),this.settings.loop||(this.op(b,\">\",h[this.minimum()])?e=b=this.minimum():this.op(b,\"<\",h[this.maximum()])&&(e=b=this.maximum())),e},e.prototype.animate=function(b){var c=this.speed()>0;this.is(\"animating\")&&this.onTransitionEnd(),c&&(this.enter(\"animating\"),this.trigger(\"translate\")),a.support.transform3d&&a.support.transition?this.$stage.css({transform:\"translate3d(\"+b+\"px,0px,0px)\",transition:this.speed()/1e3+\"s\"+(this.settings.slideTransition?\" \"+this.settings.slideTransition:\"\")}):c?this.$stage.animate({left:b+\"px\"},this.speed(),this.settings.fallbackEasing,a.proxy(this.onTransitionEnd,this)):this.$stage.css({left:b+\"px\"})},e.prototype.is=function(a){return this._states.current[a]&&this._states.current[a]>0},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger(\"change\",{property:{name:\"position\",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate(\"position\"),this.trigger(\"changed\",{property:{name:\"position\",value:this._current}})}return this._current},e.prototype.invalidate=function(b){return\"string\"===a.type(b)&&(this._invalidated[b]=!0,this.is(\"valid\")&&this.leave(\"valid\")),a.map(this._invalidated,function(a,b){return b})},e.prototype.reset=function(a){(a=this.normalize(a))!==d&&(this._speed=0,this._current=a,this.suppress([\"translate\",\"translated\"]),this.animate(this.coordinates(a)),this.release([\"translate\",\"translated\"]))},e.prototype.normalize=function(a,b){var c=this._items.length,e=b?0:this._clones.length;return!this.isNumeric(a)||c<1?a=d:(a<0||a>=c+e)&&(a=((a-e/2)%c+c)%c+e/2),a},e.prototype.relative=function(a){return a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=this.settings,f=this._coordinates.length;if(e.loop)f=this._clones.length/2+this._items.length-1;else if(e.autoWidth||e.merge){if(b=this._items.length)for(c=this._items[--b].width(),d=this.$element.width();b--&&!((c+=this._items[b].width()+this.settings.margin)>d););f=b+1}else f=e.center?this._items.length-1:this._items.length-e.items;return a&&(f-=this._clones.length/2),Math.max(f,0)},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2==0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c,e=1,f=b-1;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(this.settings.rtl&&(e=-1,f=b+1),c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[f]||0))/2*e):c=this._coordinates[f]||0,c=Math.ceil(c))},e.prototype.duration=function(a,b,c){return 0===c?0:Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(a,b){var c=this.current(),d=null,e=a-this.relative(c),f=(e>0)-(e<0),g=this._items.length,h=this.minimum(),i=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(e)>g/2&&(e+=-1*f*g),a=c+e,(d=((a-h)%g+g)%g+h)!==a&&d-e<=i&&d-e>0&&(c=d-e,a=d,this.reset(c))):this.settings.rewind?(i+=1,a=(a%i+i)%i):a=Math.max(h,Math.min(i,a)),this.speed(this.duration(c,a,b)),this.current(a),this.isVisible()&&this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.onTransitionEnd=function(a){if(a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0)))return!1;this.leave(\"animating\"),this.trigger(\"translated\")},e.prototype.viewport=function(){var d;return this.options.responsiveBaseElement!==b?d=a(this.options.responsiveBaseElement).width():b.innerWidth?d=b.innerWidth:c.documentElement&&c.documentElement.clientWidth?d=c.documentElement.clientWidth:console.warn(\"Can not detect viewport width.\"),d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find(\".\"+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)},this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate(\"items\")},e.prototype.add=function(b,c){var e=this.relative(this._current);c=c===d?this._items.length:this.normalize(c,!0),b=b instanceof jQuery?b:a(b),this.trigger(\"add\",{content:b,position:c}),b=this.prepare(b),0===this._items.length||c===this._items.length?(0===this._items.length&&this.$stage.append(b),0!==this._items.length&&this._items[c-1].after(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)):(this._items[c].before(b),this._items.splice(c,0,b),this._mergers.splice(c,0,1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)),this._items[e]&&this.reset(this._items[e].index()),this.invalidate(\"items\"),this.trigger(\"added\",{content:b,position:c})},e.prototype.remove=function(a){(a=this.normalize(a,!0))!==d&&(this.trigger(\"remove\",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate(\"items\"),this.trigger(\"removed\",{content:null,position:a}))},e.prototype.preloadAutoWidthImages=function(b){b.each(a.proxy(function(b,c){this.enter(\"pre-loading\"),c=a(c),a(new Image).one(\"load\",a.proxy(function(a){c.attr(\"src\",a.target.src),c.css(\"opacity\",1),this.leave(\"pre-loading\"),!this.is(\"pre-loading\")&&!this.is(\"initializing\")&&this.refresh()},this)).attr(\"src\",c.attr(\"src\")||c.attr(\"data-src\")||c.attr(\"data-src-retina\"))},this))},e.prototype.destroy=function(){this.$element.off(\".owl.core\"),this.$stage.off(\".owl.core\"),a(c).off(\".owl.core\"),!1!==this.settings.responsive&&(b.clearTimeout(this.resizeTimer),this.off(b,\"resize\",this._handlers.onThrottledResize));for(var d in this._plugins)this._plugins[d].destroy();this.$stage.children(\".cloned\").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(this.options.responsiveClass+\"-\\\\S+\\\\s\",\"g\"),\"\")).removeData(\"owl.carousel\")},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case\"<\":return d?a>c:a<c;case\">\":return d?a<c:a>c;case\">=\":return d?a<=c:a>=c;case\"<=\":return d?a>=c:a<=c}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent(\"on\"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent(\"on\"+b,c)},e.prototype.trigger=function(b,c,d,f,g){var h={item:{count:this._items.length,index:this.current()}},i=a.camelCase(a.grep([\"on\",b,d],function(a){return a}).join(\"-\").toLowerCase()),j=a.Event([b,\"owl\",d||\"carousel\"].join(\".\").toLowerCase(),a.extend({relatedTarget:this},h,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(j)}),this.register({type:e.Type.Event,name:b}),this.$element.trigger(j),this.settings&&\"function\"==typeof this.settings[i]&&this.settings[i].call(this,j)),j},e.prototype.enter=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]===d&&(this._states.current[b]=0),this._states.current[b]++},this))},e.prototype.leave=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]--},this))},e.prototype.register=function(b){if(b.type===e.Type.Event){if(a.event.special[b.name]||(a.event.special[b.name]={}),!a.event.special[b.name].owl){var c=a.event.special[b.name]._default;a.event.special[b.name]._default=function(a){return!c||!c.apply||a.namespace&&-1!==a.namespace.indexOf(\"owl\")?a.namespace&&a.namespace.indexOf(\"owl\")>-1:c.apply(this,arguments)},a.event.special[b.name].owl=!0}}else b.type===e.Type.State&&(this._states.tags[b.name]?this._states.tags[b.name]=this._states.tags[b.name].concat(b.tags):this._states.tags[b.name]=b.tags,this._states.tags[b.name]=a.grep(this._states.tags[b.name],a.proxy(function(c,d){return a.inArray(c,this._states.tags[b.name])===d},this)))},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.pointer=function(a){var c={x:null,y:null};return a=a.originalEvent||a||b.event,a=a.touches&&a.touches.length?a.touches[0]:a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:a,a.pageX?(c.x=a.pageX,c.y=a.pageY):(c.x=a.clientX,c.y=a.clientY),c},e.prototype.isNumeric=function(a){return!isNaN(parseFloat(a))},e.prototype.difference=function(a,b){return{x:a.x-b.x,y:a.y-b.y}},a.fn.owlCarousel=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){var d=a(this),f=d.data(\"owl.carousel\");f||(f=new e(this,\"object\"==typeof b&&b),d.data(\"owl.carousel\",f),a.each([\"next\",\"prev\",\"to\",\"destroy\",\"refresh\",\"replace\",\"add\",\"remove\"],function(b,c){f.register({type:e.Type.Event,name:c}),f.$element.on(c+\".owl.carousel.core\",a.proxy(function(a){a.namespace&&a.relatedTarget!==this&&(this.suppress([c]),f[c].apply(this,[].slice.call(arguments,1)),this.release([c]))},f))})),\"string\"==typeof b&&\"_\"!==b.charAt(0)&&f[b].apply(f,c)})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._interval=null,this._visible=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoRefresh&&this.watch()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={autoRefresh:!0,autoRefreshInterval:500},e.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=b.setInterval(a.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},e.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass(\"owl-hidden\",!this._visible),this._visible&&this._core.invalidate(\"width\")&&this._core.refresh())},e.prototype.destroy=function(){var a,c;b.clearInterval(this._interval);for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoRefresh=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._loaded=[],this._handlers={\"initialized.owl.carousel change.owl.carousel resized.owl.carousel\":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&\"position\"==b.property.name||\"initialized\"==b.type)){var c=this._core.settings,e=c.center&&Math.ceil(c.items/2)||c.items,f=c.center&&-1*e||0,g=(b.property&&b.property.value!==d?b.property.value:this._core.current())+f,h=this._core.clones().length,i=a.proxy(function(a,b){this.load(b)},this);for(c.lazyLoadEager>0&&(e+=c.lazyLoadEager,c.loop&&(g-=c.lazyLoadEager,e++));f++<e;)this.load(h/2+this._core.relative(g)),h&&a.each(this._core.clones(this._core.relative(g)),i),g++}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={lazyLoad:!1,lazyLoadEager:0},e.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(\".owl-lazy\");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr(\"data-src-retina\")||f.attr(\"data-src\")||f.attr(\"data-srcset\");this._core.trigger(\"load\",{element:f,url:g},\"lazy\"),f.is(\"img\")?f.one(\"load.owl.lazy\",a.proxy(function(){f.css(\"opacity\",1),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"src\",g):f.is(\"source\")?f.one(\"load.owl.lazy\",a.proxy(function(){this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"srcset\",g):(e=new Image,e.onload=a.proxy(function(){f.css({\"background-image\":'url(\"'+g+'\")',opacity:\"1\"}),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(c){this._core=c,this._previousHeight=null,this._handlers={\"initialized.owl.carousel refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&this.update()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&\"position\"===a.property.name&&this.update()},this),\"loaded.owl.lazy\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&a.element.closest(\".\"+this._core.settings.itemClass).index()===this._core.current()&&this.update()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var d=this;a(b).on(\"load\",function(){d._core.settings.autoHeight&&d.update()}),a(b).resize(function(){d._core.settings.autoHeight&&(null!=d._intervalId&&clearTimeout(d._intervalId),d._intervalId=setTimeout(function(){d.update()},250))})};e.Defaults={autoHeight:!1,autoHeightClass:\"owl-height\"},e.prototype.update=function(){var b=this._core._current,c=b+this._core.settings.items,d=this._core.settings.lazyLoad,e=this._core.$stage.children().toArray().slice(b,c),f=[],g=0;a.each(e,function(b,c){f.push(a(c).height())}),g=Math.max.apply(null,f),g<=1&&d&&this._previousHeight&&(g=this._previousHeight),this._previousHeight=g,this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass)},e.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._videos={},this._playing=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.register({type:\"state\",name:\"playing\",tags:[\"interacting\"]})},this),\"resize.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.video&&this.isInFullScreen()&&a.preventDefault()},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.is(\"resizing\")&&this._core.$stage.find(\".cloned .owl-video-frame\").remove()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"===a.property.name&&this._playing&&this.stop()},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\".owl-video\");c.length&&(c.css(\"display\",\"none\"),this.fetch(c,a(b.content)))}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on(\"click.owl.video\",\".owl-video-play-icon\",a.proxy(function(a){this.play(a)},this))};e.Defaults={video:!1,videoHeight:!1,videoWidth:!1},e.prototype.fetch=function(a,b){var c=function(){return a.attr(\"data-vimeo-id\")?\"vimeo\":a.attr(\"data-vzaar-id\")?\"vzaar\":\"youtube\"}(),d=a.attr(\"data-vimeo-id\")||a.attr(\"data-youtube-id\")||a.attr(\"data-vzaar-id\"),e=a.attr(\"data-width\")||this._core.settings.videoWidth,f=a.attr(\"data-height\")||this._core.settings.videoHeight,g=a.attr(\"href\");if(!g)throw new Error(\"Missing video URL.\");if(d=g.match(/(http:|https:|)\\/\\/(player.|www.|app.)?(vimeo\\.com|youtu(be\\.com|\\.be|be\\.googleapis\\.com|be\\-nocookie\\.com)|vzaar\\.com)\\/(video\\/|videos\\/|embed\\/|channels\\/.+\\/|groups\\/.+\\/|watch\\?v=|v\\/)?([A-Za-z0-9._%-]*)(\\&\\S+)?/),d[3].indexOf(\"youtu\")>-1)c=\"youtube\";else if(d[3].indexOf(\"vimeo\")>-1)c=\"vimeo\";else{if(!(d[3].indexOf(\"vzaar\")>-1))throw new Error(\"Video URL not supported.\");c=\"vzaar\"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr(\"data-video\",g),this.thumbnail(a,this._videos[g])},e.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?\"width:\"+c.width+\"px;height:\"+c.height+\"px;\":\"\",h=b.find(\"img\"),i=\"src\",j=\"\",k=this._core.settings,l=function(c){e='<div class=\"owl-video-play-icon\"></div>',d=k.lazyLoad?a(\"<div/>\",{class:\"owl-video-tn \"+j,srcType:c}):a(\"<div/>\",{class:\"owl-video-tn\",style:\"opacity:1;background-image:url(\"+c+\")\"}),b.after(d),b.after(e)};if(b.wrap(a(\"<div/>\",{class:\"owl-video-wrapper\",style:g})),this._core.settings.lazyLoad&&(i=\"data-src\",j=\"owl-lazy\"),h.length)return l(h.attr(i)),h.remove(),!1;\"youtube\"===c.type?(f=\"//img.youtube.com/vi/\"+c.id+\"/hqdefault.jpg\",l(f)):\"vimeo\"===c.type?a.ajax({type:\"GET\",url:\"//vimeo.com/api/v2/video/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a[0].thumbnail_large,l(f)}}):\"vzaar\"===c.type&&a.ajax({type:\"GET\",url:\"//vzaar.com/api/videos/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a.framegrab_url,l(f)}})},e.prototype.stop=function(){this._core.trigger(\"stop\",null,\"video\"),this._playing.find(\".owl-video-frame\").remove(),this._playing.removeClass(\"owl-video-playing\"),this._playing=null,this._core.leave(\"playing\"),this._core.trigger(\"stopped\",null,\"video\")},e.prototype.play=function(b){var c,d=a(b.target),e=d.closest(\".\"+this._core.settings.itemClass),f=this._videos[e.attr(\"data-video\")],g=f.width||\"100%\",h=f.height||this._core.$stage.height();this._playing||(this._core.enter(\"playing\"),this._core.trigger(\"play\",null,\"video\"),e=this._core.items(this._core.relative(e.index())),this._core.reset(e.index()),c=a('<iframe frameborder=\"0\" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'),c.attr(\"height\",h),c.attr(\"width\",g),\"youtube\"===f.type?c.attr(\"src\",\"//www.youtube.com/embed/\"+f.id+\"?autoplay=1&rel=0&v=\"+f.id):\"vimeo\"===f.type?c.attr(\"src\",\"//player.vimeo.com/video/\"+f.id+\"?autoplay=1\"):\"vzaar\"===f.type&&c.attr(\"src\",\"//view.vzaar.com/\"+f.id+\"/player?autoplay=true\"),a(c).wrap('<div class=\"owl-video-frame\" />').insertAfter(e.find(\".owl-video\")),this._playing=e.addClass(\"owl-video-playing\"))},e.prototype.isInFullScreen=function(){var b=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return b&&a(b).parent().hasClass(\"owl-video-frame\")},e.prototype.destroy=function(){var a,b;this._core.$element.off(\"click.owl.video\");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={\"change.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),\"drag.owl.carousel dragged.owl.carousel translated.owl.carousel\":a.proxy(function(a){a.namespace&&(this.swapping=\"translated\"==a.type)},this),\"translate.owl.carousel\":a.proxy(function(a){a.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,\r\nanimateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&a.support.animation&&a.support.transition){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.one(a.support.animation.end,c).css({left:b+\"px\"}).addClass(\"animated owl-animated-out\").addClass(g)),f&&e.one(a.support.animation.end,c).addClass(\"animated owl-animated-in\").addClass(f))}},e.prototype.clear=function(b){a(b.target).css({left:\"\"}).removeClass(\"animated owl-animated-out owl-animated-in\").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"settings\"===a.property.name?this._core.settings.autoplay?this.play():this.stop():a.namespace&&\"position\"===a.property.name&&this._paused&&(this._time=0)},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoplay&&this.play()},this),\"play.owl.autoplay\":a.proxy(function(a,b,c){a.namespace&&this.play(b,c)},this),\"stop.owl.autoplay\":a.proxy(function(a){a.namespace&&this.stop()},this),\"mouseover.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"mouseleave.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.play()},this),\"touchstart.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"touchend.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this.play()},this)},this._core.$element.on(this._handlers),this._core.options=a.extend({},e.Defaults,this._core.options)};e.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},e.prototype._next=function(d){this._call=b.setTimeout(a.proxy(this._next,this,d),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is(\"interacting\")||c.hidden||this._core.next(d||this._core.settings.autoplaySpeed)},e.prototype.read=function(){return(new Date).getTime()-this._time},e.prototype.play=function(c,d){var e;this._core.is(\"rotating\")||this._core.enter(\"rotating\"),c=c||this._core.settings.autoplayTimeout,e=Math.min(this._time%(this._timeout||c),c),this._paused?(this._time=this.read(),this._paused=!1):b.clearTimeout(this._call),this._time+=this.read()%c-e,this._timeout=c,this._call=b.setTimeout(a.proxy(this._next,this,d),c-e)},e.prototype.stop=function(){this._core.is(\"rotating\")&&(this._time=0,this._paused=!0,b.clearTimeout(this._call),this._core.leave(\"rotating\"))},e.prototype.pause=function(){this._core.is(\"rotating\")&&!this._paused&&(this._time=this.read(),this._paused=!0,b.clearTimeout(this._call))},e.prototype.destroy=function(){var a,b;this.stop();for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(b){this._core=b,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={\"prepared.owl.carousel\":a.proxy(function(b){b.namespace&&this._core.settings.dotsData&&this._templates.push('<div class=\"'+this._core.settings.dotClass+'\">'+a(b.content).find(\"[data-dot]\").addBack(\"[data-dot]\").attr(\"data-dot\")+\"</div>\")},this),\"added.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,0,this._templates.pop())},this),\"remove.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&this.draw()},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&!this._initialized&&(this._core.trigger(\"initialize\",null,\"navigation\"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger(\"initialized\",null,\"navigation\"))},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._initialized&&(this._core.trigger(\"refresh\",null,\"navigation\"),this.update(),this.draw(),this._core.trigger(\"refreshed\",null,\"navigation\"))},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers)};e.Defaults={nav:!1,navText:['<span aria-label=\"Previous\">&#x2039;</span>','<span aria-label=\"Next\">&#x203a;</span>'],navSpeed:!1,navElement:'button type=\"button\" role=\"presentation\"',navContainer:!1,navContainerClass:\"owl-nav\",navClass:[\"owl-prev\",\"owl-next\"],slideBy:1,dotClass:\"owl-dot\",dotsClass:\"owl-dots\",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},e.prototype.initialize=function(){var b,c=this._core.settings;this._controls.$relative=(c.navContainer?a(c.navContainer):a(\"<div>\").addClass(c.navContainerClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$previous=a(\"<\"+c.navElement+\">\").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.prev(c.navSpeed)},this)),this._controls.$next=a(\"<\"+c.navElement+\">\").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.next(c.navSpeed)},this)),c.dotsData||(this._templates=[a('<button role=\"button\">').addClass(c.dotClass).append(a(\"<span>\")).prop(\"outerHTML\")]),this._controls.$absolute=(c.dotsContainer?a(c.dotsContainer):a(\"<div>\").addClass(c.dotsClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$absolute.on(\"click\",\"button\",a.proxy(function(b){var d=a(b.target).parent().is(this._controls.$absolute)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(d,c.dotsSpeed)},this));for(b in this._overrides)this._core[b]=a.proxy(this[b],this)},e.prototype.destroy=function(){var a,b,c,d,e;e=this._core.settings;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)\"$relative\"===b&&e.navContainer?this._controls[b].html(\"\"):this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},e.prototype.update=function(){var a,b,c,d=this._core.clones().length/2,e=d+this._core.items().length,f=this._core.maximum(!0),g=this._core.settings,h=g.center||g.autoWidth||g.dotsData?1:g.dotsEach||g.items;if(\"page\"!==g.slideBy&&(g.slideBy=Math.min(g.slideBy,g.items)),g.dots||\"page\"==g.slideBy)for(this._pages=[],a=d,b=0,c=0;a<e;a++){if(b>=h||0===b){if(this._pages.push({start:Math.min(f,a-d),end:a-d+h-1}),Math.min(f,a-d)===f)break;b=0,++c}b+=this._core.mergers(this._core.relative(a))}},e.prototype.draw=function(){var b,c=this._core.settings,d=this._core.items().length<=c.items,e=this._core.relative(this._core.current()),f=c.loop||c.rewind;this._controls.$relative.toggleClass(\"disabled\",!c.nav||d),c.nav&&(this._controls.$previous.toggleClass(\"disabled\",!f&&e<=this._core.minimum(!0)),this._controls.$next.toggleClass(\"disabled\",!f&&e>=this._core.maximum(!0))),this._controls.$absolute.toggleClass(\"disabled\",!c.dots||d),c.dots&&(b=this._pages.length-this._controls.$absolute.children().length,c.dotsData&&0!==b?this._controls.$absolute.html(this._templates.join(\"\")):b>0?this._controls.$absolute.append(new Array(b+1).join(this._templates[0])):b<0&&this._controls.$absolute.children().slice(b).remove(),this._controls.$absolute.find(\".active\").removeClass(\"active\"),this._controls.$absolute.children().eq(a.inArray(this.current(),this._pages)).addClass(\"active\"))},e.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotsData?1:c.dotsEach||c.items)}},e.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,a.proxy(function(a,c){return a.start<=b&&a.end>=b},this)).pop()},e.prototype.getPosition=function(b){var c,d,e=this._core.settings;return\"page\"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},e.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},e.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},e.prototype.to=function(b,c,d){var e;!d&&this._pages.length?(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c)):a.proxy(this._overrides.to,this._core)(b,c)},a.fn.owlCarousel.Constructor.Plugins.Navigation=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(c){this._core=c,this._hashes={},this.$element=this._core.$element,this._handlers={\"initialized.owl.carousel\":a.proxy(function(c){c.namespace&&\"URLHash\"===this._core.settings.startPosition&&a(b).trigger(\"hashchange.owl.navigation\")},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\"[data-hash]\").addBack(\"[data-hash]\").attr(\"data-hash\");if(!c)return;this._hashes[c]=b.content}},this),\"changed.owl.carousel\":a.proxy(function(c){if(c.namespace&&\"position\"===c.property.name){var d=this._core.items(this._core.relative(this._core.current())),e=a.map(this._hashes,function(a,b){return a===d?b:null}).join();if(!e||b.location.hash.slice(1)===e)return;b.location.hash=e}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on(\"hashchange.owl.navigation\",a.proxy(function(a){var c=b.location.hash.substring(1),e=this._core.$stage.children(),f=this._hashes[c]&&e.index(this._hashes[c]);f!==d&&f!==this._core.current()&&this._core.to(this._core.relative(f),!1,!0)},this))};e.Defaults={URLhashListener:!1},e.prototype.destroy=function(){var c,d;a(b).off(\"hashchange.owl.navigation\");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))\"function\"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){function e(b,c){var e=!1,f=b.charAt(0).toUpperCase()+b.slice(1);return a.each((b+\" \"+h.join(f+\" \")+f).split(\" \"),function(a,b){if(g[b]!==d)return e=!c||b,!1}),e}function f(a){return e(a,!0)}var g=a(\"<support>\").get(0).style,h=\"Webkit Moz O ms\".split(\" \"),i={transition:{end:{WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd\",transition:\"transitionend\"}},animation:{end:{WebkitAnimation:\"webkitAnimationEnd\",MozAnimation:\"animationend\",OAnimation:\"oAnimationEnd\",animation:\"animationend\"}}},j={csstransforms:function(){return!!e(\"transform\")},csstransforms3d:function(){return!!e(\"perspective\")},csstransitions:function(){return!!e(\"transition\")},cssanimations:function(){return!!e(\"animation\")}};j.csstransitions()&&(a.support.transition=new String(f(\"transition\")),a.support.transition.end=i.transition.end[a.support.transition]),j.cssanimations()&&(a.support.animation=new String(f(\"animation\")),a.support.animation.end=i.animation.end[a.support.animation]),j.csstransforms()&&(a.support.transform=new String(f(\"transform\")),a.support.transform3d=j.csstransforms3d())}(window.Zepto||window.jQuery,window,document);","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         *\n         * @param {Number} timeoutID\n         */\n        clearTimeout: function (timeoutID) {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout(timeoutID);\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var payflowProMethodMixin = {\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            skipRefreshCaptcha.skip(true);\n            this._super();\n        }\n    };\n\n    return function (payflowProMethod) {\n        return payflowProMethod.extend(payflowProMethodMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var defaultCaptchaMixin = {\n        /**\n         * @override\n         */\n        refresh: function () {\n            if (!skipRefreshCaptcha.skip()) {\n                this._super();\n            } else {\n                skipRefreshCaptcha.skip(false);\n            }\n        }\n    };\n\n    return function (defaultCaptcha) {\n        return defaultCaptcha.extend(defaultCaptchaMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","Magento_PaypalCaptcha/js/model/skipRefreshCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        skip: ko.observable(false)\n    };\n});\n","Threedadv_Theme/js/lib/flatpickr.js":"/* flatpickr v4.6.13, @license MIT */\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n  typeof define === 'function' && define.amd ? define(factory) :\n  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.flatpickr = factory());\n}(this, (function () { 'use strict';\n\n  /*! *****************************************************************************\n  Copyright (c) Microsoft Corporation.\n\n  Permission to use, copy, modify, and/or distribute this software for any\n  purpose with or without fee is hereby granted.\n\n  THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\n  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\n  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\n  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\n  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\n  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\n  PERFORMANCE OF THIS SOFTWARE.\n  ***************************************************************************** */\n\n  var __assign = function() {\n      __assign = Object.assign || function __assign(t) {\n          for (var s, i = 1, n = arguments.length; i < n; i++) {\n              s = arguments[i];\n              for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\n          }\n          return t;\n      };\n      return __assign.apply(this, arguments);\n  };\n\n  function __spreadArrays() {\n      for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;\n      for (var r = Array(s), k = 0, i = 0; i < il; i++)\n          for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)\n              r[k] = a[j];\n      return r;\n  }\n\n  var HOOKS = [\n      \"onChange\",\n      \"onClose\",\n      \"onDayCreate\",\n      \"onDestroy\",\n      \"onKeyDown\",\n      \"onMonthChange\",\n      \"onOpen\",\n      \"onParseConfig\",\n      \"onReady\",\n      \"onValueUpdate\",\n      \"onYearChange\",\n      \"onPreCalendarPosition\",\n  ];\n  var defaults = {\n      _disable: [],\n      allowInput: false,\n      allowInvalidPreload: false,\n      altFormat: \"F j, Y\",\n      altInput: false,\n      altInputClass: \"form-control input\",\n      animate: typeof window === \"object\" &&\n          window.navigator.userAgent.indexOf(\"MSIE\") === -1,\n      ariaDateFormat: \"F j, Y\",\n      autoFillDefaultTime: true,\n      clickOpens: true,\n      closeOnSelect: true,\n      conjunction: \", \",\n      dateFormat: \"Y-m-d\",\n      defaultHour: 12,\n      defaultMinute: 0,\n      defaultSeconds: 0,\n      disable: [],\n      disableMobile: false,\n      enableSeconds: false,\n      enableTime: false,\n      errorHandler: function (err) {\n          return typeof console !== \"undefined\" && console.warn(err);\n      },\n      getWeek: function (givenDate) {\n          var date = new Date(givenDate.getTime());\n          date.setHours(0, 0, 0, 0);\n          // Thursday in current week decides the year.\n          date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));\n          // January 4 is always in week 1.\n          var week1 = new Date(date.getFullYear(), 0, 4);\n          // Adjust to Thursday in week 1 and count number of weeks from date to week1.\n          return (1 +\n              Math.round(((date.getTime() - week1.getTime()) / 86400000 -\n                  3 +\n                  ((week1.getDay() + 6) % 7)) /\n                  7));\n      },\n      hourIncrement: 1,\n      ignoredFocusElements: [],\n      inline: false,\n      locale: \"default\",\n      minuteIncrement: 5,\n      mode: \"single\",\n      monthSelectorType: \"dropdown\",\n      nextArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>\",\n      noCalendar: false,\n      now: new Date(),\n      onChange: [],\n      onClose: [],\n      onDayCreate: [],\n      onDestroy: [],\n      onKeyDown: [],\n      onMonthChange: [],\n      onOpen: [],\n      onParseConfig: [],\n      onReady: [],\n      onValueUpdate: [],\n      onYearChange: [],\n      onPreCalendarPosition: [],\n      plugins: [],\n      position: \"auto\",\n      positionElement: undefined,\n      prevArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>\",\n      shorthandCurrentMonth: false,\n      showMonths: 1,\n      static: false,\n      time_24hr: false,\n      weekNumbers: false,\n      wrap: false,\n  };\n\n  var english = {\n      weekdays: {\n          shorthand: [\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\"],\n          longhand: [\n              \"Sunday\",\n              \"Monday\",\n              \"Tuesday\",\n              \"Wednesday\",\n              \"Thursday\",\n              \"Friday\",\n              \"Saturday\",\n          ],\n      },\n      months: {\n          shorthand: [\n              \"Jan\",\n              \"Feb\",\n              \"Mar\",\n              \"Apr\",\n              \"May\",\n              \"Jun\",\n              \"Jul\",\n              \"Aug\",\n              \"Sep\",\n              \"Oct\",\n              \"Nov\",\n              \"Dec\",\n          ],\n          longhand: [\n              \"January\",\n              \"February\",\n              \"March\",\n              \"April\",\n              \"May\",\n              \"June\",\n              \"July\",\n              \"August\",\n              \"September\",\n              \"October\",\n              \"November\",\n              \"December\",\n          ],\n      },\n      daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],\n      firstDayOfWeek: 0,\n      ordinal: function (nth) {\n          var s = nth % 100;\n          if (s > 3 && s < 21)\n              return \"th\";\n          switch (s % 10) {\n              case 1:\n                  return \"st\";\n              case 2:\n                  return \"nd\";\n              case 3:\n                  return \"rd\";\n              default:\n                  return \"th\";\n          }\n      },\n      rangeSeparator: \" to \",\n      weekAbbreviation: \"Wk\",\n      scrollTitle: \"Scroll to increment\",\n      toggleTitle: \"Click to toggle\",\n      amPM: [\"AM\", \"PM\"],\n      yearAriaLabel: \"Year\",\n      monthAriaLabel: \"Month\",\n      hourAriaLabel: \"Hour\",\n      minuteAriaLabel: \"Minute\",\n      time_24hr: false,\n  };\n\n  var pad = function (number, length) {\n      if (length === void 0) { length = 2; }\n      return (\"000\" + number).slice(length * -1);\n  };\n  var int = function (bool) { return (bool === true ? 1 : 0); };\n  /* istanbul ignore next */\n  function debounce(fn, wait) {\n      var t;\n      return function () {\n          var _this = this;\n          var args = arguments;\n          clearTimeout(t);\n          t = setTimeout(function () { return fn.apply(_this, args); }, wait);\n      };\n  }\n  var arrayify = function (obj) {\n      return obj instanceof Array ? obj : [obj];\n  };\n\n  function toggleClass(elem, className, bool) {\n      if (bool === true)\n          return elem.classList.add(className);\n      elem.classList.remove(className);\n  }\n  function createElement(tag, className, content) {\n      var e = window.document.createElement(tag);\n      className = className || \"\";\n      content = content || \"\";\n      e.className = className;\n      if (content !== undefined)\n          e.textContent = content;\n      return e;\n  }\n  function clearNode(node) {\n      while (node.firstChild)\n          node.removeChild(node.firstChild);\n  }\n  function findParent(node, condition) {\n      if (condition(node))\n          return node;\n      else if (node.parentNode)\n          return findParent(node.parentNode, condition);\n      return undefined; // nothing found\n  }\n  function createNumberInput(inputClassName, opts) {\n      var wrapper = createElement(\"div\", \"numInputWrapper\"), numInput = createElement(\"input\", \"numInput \" + inputClassName), arrowUp = createElement(\"span\", \"arrowUp\"), arrowDown = createElement(\"span\", \"arrowDown\");\n      if (navigator.userAgent.indexOf(\"MSIE 9.0\") === -1) {\n          numInput.type = \"number\";\n      }\n      else {\n          numInput.type = \"text\";\n          numInput.pattern = \"\\\\d*\";\n      }\n      if (opts !== undefined)\n          for (var key in opts)\n              numInput.setAttribute(key, opts[key]);\n      wrapper.appendChild(numInput);\n      wrapper.appendChild(arrowUp);\n      wrapper.appendChild(arrowDown);\n      return wrapper;\n  }\n  function getEventTarget(event) {\n      try {\n          if (typeof event.composedPath === \"function\") {\n              var path = event.composedPath();\n              return path[0];\n          }\n          return event.target;\n      }\n      catch (error) {\n          return event.target;\n      }\n  }\n\n  var doNothing = function () { return undefined; };\n  var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? \"shorthand\" : \"longhand\"][monthNumber]; };\n  var revFormat = {\n      D: doNothing,\n      F: function (dateObj, monthName, locale) {\n          dateObj.setMonth(locale.months.longhand.indexOf(monthName));\n      },\n      G: function (dateObj, hour) {\n          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));\n      },\n      H: function (dateObj, hour) {\n          dateObj.setHours(parseFloat(hour));\n      },\n      J: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      K: function (dateObj, amPM, locale) {\n          dateObj.setHours((dateObj.getHours() % 12) +\n              12 * int(new RegExp(locale.amPM[1], \"i\").test(amPM)));\n      },\n      M: function (dateObj, shortMonth, locale) {\n          dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));\n      },\n      S: function (dateObj, seconds) {\n          dateObj.setSeconds(parseFloat(seconds));\n      },\n      U: function (_, unixSeconds) { return new Date(parseFloat(unixSeconds) * 1000); },\n      W: function (dateObj, weekNum, locale) {\n          var weekNumber = parseInt(weekNum);\n          var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);\n          date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);\n          return date;\n      },\n      Y: function (dateObj, year) {\n          dateObj.setFullYear(parseFloat(year));\n      },\n      Z: function (_, ISODate) { return new Date(ISODate); },\n      d: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      h: function (dateObj, hour) {\n          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));\n      },\n      i: function (dateObj, minutes) {\n          dateObj.setMinutes(parseFloat(minutes));\n      },\n      j: function (dateObj, day) {\n          dateObj.setDate(parseFloat(day));\n      },\n      l: doNothing,\n      m: function (dateObj, month) {\n          dateObj.setMonth(parseFloat(month) - 1);\n      },\n      n: function (dateObj, month) {\n          dateObj.setMonth(parseFloat(month) - 1);\n      },\n      s: function (dateObj, seconds) {\n          dateObj.setSeconds(parseFloat(seconds));\n      },\n      u: function (_, unixMillSeconds) {\n          return new Date(parseFloat(unixMillSeconds));\n      },\n      w: doNothing,\n      y: function (dateObj, year) {\n          dateObj.setFullYear(2000 + parseFloat(year));\n      },\n  };\n  var tokenRegex = {\n      D: \"\",\n      F: \"\",\n      G: \"(\\\\d\\\\d|\\\\d)\",\n      H: \"(\\\\d\\\\d|\\\\d)\",\n      J: \"(\\\\d\\\\d|\\\\d)\\\\w+\",\n      K: \"\",\n      M: \"\",\n      S: \"(\\\\d\\\\d|\\\\d)\",\n      U: \"(.+)\",\n      W: \"(\\\\d\\\\d|\\\\d)\",\n      Y: \"(\\\\d{4})\",\n      Z: \"(.+)\",\n      d: \"(\\\\d\\\\d|\\\\d)\",\n      h: \"(\\\\d\\\\d|\\\\d)\",\n      i: \"(\\\\d\\\\d|\\\\d)\",\n      j: \"(\\\\d\\\\d|\\\\d)\",\n      l: \"\",\n      m: \"(\\\\d\\\\d|\\\\d)\",\n      n: \"(\\\\d\\\\d|\\\\d)\",\n      s: \"(\\\\d\\\\d|\\\\d)\",\n      u: \"(.+)\",\n      w: \"(\\\\d\\\\d|\\\\d)\",\n      y: \"(\\\\d{2})\",\n  };\n  var formats = {\n      // get the date in UTC\n      Z: function (date) { return date.toISOString(); },\n      // weekday name, short, e.g. Thu\n      D: function (date, locale, options) {\n          return locale.weekdays.shorthand[formats.w(date, locale, options)];\n      },\n      // full month name e.g. January\n      F: function (date, locale, options) {\n          return monthToStr(formats.n(date, locale, options) - 1, false, locale);\n      },\n      // padded hour 1-12\n      G: function (date, locale, options) {\n          return pad(formats.h(date, locale, options));\n      },\n      // hours with leading zero e.g. 03\n      H: function (date) { return pad(date.getHours()); },\n      // day (1-30) with ordinal suffix e.g. 1st, 2nd\n      J: function (date, locale) {\n          return locale.ordinal !== undefined\n              ? date.getDate() + locale.ordinal(date.getDate())\n              : date.getDate();\n      },\n      // AM/PM\n      K: function (date, locale) { return locale.amPM[int(date.getHours() > 11)]; },\n      // shorthand month e.g. Jan, Sep, Oct, etc\n      M: function (date, locale) {\n          return monthToStr(date.getMonth(), true, locale);\n      },\n      // seconds 00-59\n      S: function (date) { return pad(date.getSeconds()); },\n      // unix timestamp\n      U: function (date) { return date.getTime() / 1000; },\n      W: function (date, _, options) {\n          return options.getWeek(date);\n      },\n      // full year e.g. 2016, padded (0001-9999)\n      Y: function (date) { return pad(date.getFullYear(), 4); },\n      // day in month, padded (01-30)\n      d: function (date) { return pad(date.getDate()); },\n      // hour from 1-12 (am/pm)\n      h: function (date) { return (date.getHours() % 12 ? date.getHours() % 12 : 12); },\n      // minutes, padded with leading zero e.g. 09\n      i: function (date) { return pad(date.getMinutes()); },\n      // day in month (1-30)\n      j: function (date) { return date.getDate(); },\n      // weekday name, full, e.g. Thursday\n      l: function (date, locale) {\n          return locale.weekdays.longhand[date.getDay()];\n      },\n      // padded month number (01-12)\n      m: function (date) { return pad(date.getMonth() + 1); },\n      // the month number (1-12)\n      n: function (date) { return date.getMonth() + 1; },\n      // seconds 0-59\n      s: function (date) { return date.getSeconds(); },\n      // Unix Milliseconds\n      u: function (date) { return date.getTime(); },\n      // number of the day of the week\n      w: function (date) { return date.getDay(); },\n      // last two digits of year e.g. 16 for 2016\n      y: function (date) { return String(date.getFullYear()).substring(2); },\n  };\n\n  var createDateFormatter = function (_a) {\n      var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c, _d = _a.isMobile, isMobile = _d === void 0 ? false : _d;\n      return function (dateObj, frmt, overrideLocale) {\n          var locale = overrideLocale || l10n;\n          if (config.formatDate !== undefined && !isMobile) {\n              return config.formatDate(dateObj, frmt, locale);\n          }\n          return frmt\n              .split(\"\")\n              .map(function (c, i, arr) {\n              return formats[c] && arr[i - 1] !== \"\\\\\"\n                  ? formats[c](dateObj, locale, config)\n                  : c !== \"\\\\\"\n                      ? c\n                      : \"\";\n          })\n              .join(\"\");\n      };\n  };\n  var createDateParser = function (_a) {\n      var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;\n      return function (date, givenFormat, timeless, customLocale) {\n          if (date !== 0 && !date)\n              return undefined;\n          var locale = customLocale || l10n;\n          var parsedDate;\n          var dateOrig = date;\n          if (date instanceof Date)\n              parsedDate = new Date(date.getTime());\n          else if (typeof date !== \"string\" &&\n              date.toFixed !== undefined // timestamp\n          )\n              // create a copy\n              parsedDate = new Date(date);\n          else if (typeof date === \"string\") {\n              // date string\n              var format = givenFormat || (config || defaults).dateFormat;\n              var datestr = String(date).trim();\n              if (datestr === \"today\") {\n                  parsedDate = new Date();\n                  timeless = true;\n              }\n              else if (config && config.parseDate) {\n                  parsedDate = config.parseDate(date, format);\n              }\n              else if (/Z$/.test(datestr) ||\n                  /GMT$/.test(datestr) // datestrings w/ timezone\n              ) {\n                  parsedDate = new Date(date);\n              }\n              else {\n                  var matched = void 0, ops = [];\n                  for (var i = 0, matchIndex = 0, regexStr = \"\"; i < format.length; i++) {\n                      var token_1 = format[i];\n                      var isBackSlash = token_1 === \"\\\\\";\n                      var escaped = format[i - 1] === \"\\\\\" || isBackSlash;\n                      if (tokenRegex[token_1] && !escaped) {\n                          regexStr += tokenRegex[token_1];\n                          var match = new RegExp(regexStr).exec(date);\n                          if (match && (matched = true)) {\n                              ops[token_1 !== \"Y\" ? \"push\" : \"unshift\"]({\n                                  fn: revFormat[token_1],\n                                  val: match[++matchIndex],\n                              });\n                          }\n                      }\n                      else if (!isBackSlash)\n                          regexStr += \".\"; // don't really care\n                  }\n                  parsedDate =\n                      !config || !config.noCalendar\n                          ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)\n                          : new Date(new Date().setHours(0, 0, 0, 0));\n                  ops.forEach(function (_a) {\n                      var fn = _a.fn, val = _a.val;\n                      return (parsedDate = fn(parsedDate, val, locale) || parsedDate);\n                  });\n                  parsedDate = matched ? parsedDate : undefined;\n              }\n          }\n          /* istanbul ignore next */\n          if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {\n              config.errorHandler(new Error(\"Invalid date provided: \" + dateOrig));\n              return undefined;\n          }\n          if (timeless === true)\n              parsedDate.setHours(0, 0, 0, 0);\n          return parsedDate;\n      };\n  };\n  /**\n   * Compute the difference in dates, measured in ms\n   */\n  function compareDates(date1, date2, timeless) {\n      if (timeless === void 0) { timeless = true; }\n      if (timeless !== false) {\n          return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -\n              new Date(date2.getTime()).setHours(0, 0, 0, 0));\n      }\n      return date1.getTime() - date2.getTime();\n  }\n  var isBetween = function (ts, ts1, ts2) {\n      return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);\n  };\n  var calculateSecondsSinceMidnight = function (hours, minutes, seconds) {\n      return hours * 3600 + minutes * 60 + seconds;\n  };\n  var parseSeconds = function (secondsSinceMidnight) {\n      var hours = Math.floor(secondsSinceMidnight / 3600), minutes = (secondsSinceMidnight - hours * 3600) / 60;\n      return [hours, minutes, secondsSinceMidnight - hours * 3600 - minutes * 60];\n  };\n  var duration = {\n      DAY: 86400000,\n  };\n  function getDefaultHours(config) {\n      var hours = config.defaultHour;\n      var minutes = config.defaultMinute;\n      var seconds = config.defaultSeconds;\n      if (config.minDate !== undefined) {\n          var minHour = config.minDate.getHours();\n          var minMinutes = config.minDate.getMinutes();\n          var minSeconds = config.minDate.getSeconds();\n          if (hours < minHour) {\n              hours = minHour;\n          }\n          if (hours === minHour && minutes < minMinutes) {\n              minutes = minMinutes;\n          }\n          if (hours === minHour && minutes === minMinutes && seconds < minSeconds)\n              seconds = config.minDate.getSeconds();\n      }\n      if (config.maxDate !== undefined) {\n          var maxHr = config.maxDate.getHours();\n          var maxMinutes = config.maxDate.getMinutes();\n          hours = Math.min(hours, maxHr);\n          if (hours === maxHr)\n              minutes = Math.min(maxMinutes, minutes);\n          if (hours === maxHr && minutes === maxMinutes)\n              seconds = config.maxDate.getSeconds();\n      }\n      return { hours: hours, minutes: minutes, seconds: seconds };\n  }\n\n  if (typeof Object.assign !== \"function\") {\n      Object.assign = function (target) {\n          var args = [];\n          for (var _i = 1; _i < arguments.length; _i++) {\n              args[_i - 1] = arguments[_i];\n          }\n          if (!target) {\n              throw TypeError(\"Cannot convert undefined or null to object\");\n          }\n          var _loop_1 = function (source) {\n              if (source) {\n                  Object.keys(source).forEach(function (key) { return (target[key] = source[key]); });\n              }\n          };\n          for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {\n              var source = args_1[_a];\n              _loop_1(source);\n          }\n          return target;\n      };\n  }\n\n  var DEBOUNCED_CHANGE_MS = 300;\n  function FlatpickrInstance(element, instanceConfig) {\n      var self = {\n          config: __assign(__assign({}, defaults), flatpickr.defaultConfig),\n          l10n: english,\n      };\n      self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n      self._handlers = [];\n      self.pluginElements = [];\n      self.loadedPlugins = [];\n      self._bind = bind;\n      self._setHoursFromDate = setHoursFromDate;\n      self._positionCalendar = positionCalendar;\n      self.changeMonth = changeMonth;\n      self.changeYear = changeYear;\n      self.clear = clear;\n      self.close = close;\n      self.onMouseOver = onMouseOver;\n      self._createElement = createElement;\n      self.createDay = createDay;\n      self.destroy = destroy;\n      self.isEnabled = isEnabled;\n      self.jumpToDate = jumpToDate;\n      self.updateValue = updateValue;\n      self.open = open;\n      self.redraw = redraw;\n      self.set = set;\n      self.setDate = setDate;\n      self.toggle = toggle;\n      function setupHelperFunctions() {\n          self.utils = {\n              getDaysInMonth: function (month, yr) {\n                  if (month === void 0) { month = self.currentMonth; }\n                  if (yr === void 0) { yr = self.currentYear; }\n                  if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))\n                      return 29;\n                  return self.l10n.daysInMonth[month];\n              },\n          };\n      }\n      function init() {\n          self.element = self.input = element;\n          self.isOpen = false;\n          parseConfig();\n          setupLocale();\n          setupInputs();\n          setupDates();\n          setupHelperFunctions();\n          if (!self.isMobile)\n              build();\n          bindEvents();\n          if (self.selectedDates.length || self.config.noCalendar) {\n              if (self.config.enableTime) {\n                  setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);\n              }\n              updateValue(false);\n          }\n          setCalendarWidth();\n          var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);\n          /* TODO: investigate this further\n      \n            Currently, there is weird positioning behavior in safari causing pages\n            to scroll up. https://github.com/chmln/flatpickr/issues/563\n      \n            However, most browsers are not Safari and positioning is expensive when used\n            in scale. https://github.com/chmln/flatpickr/issues/1096\n          */\n          if (!self.isMobile && isSafari) {\n              positionCalendar();\n          }\n          triggerEvent(\"onReady\");\n      }\n      function getClosestActiveElement() {\n          var _a;\n          return (((_a = self.calendarContainer) === null || _a === void 0 ? void 0 : _a.getRootNode())\n              .activeElement || document.activeElement);\n      }\n      function bindToInstance(fn) {\n          return fn.bind(self);\n      }\n      function setCalendarWidth() {\n          var config = self.config;\n          if (config.weekNumbers === false && config.showMonths === 1) {\n              return;\n          }\n          else if (config.noCalendar !== true) {\n              window.requestAnimationFrame(function () {\n                  if (self.calendarContainer !== undefined) {\n                      self.calendarContainer.style.visibility = \"hidden\";\n                      self.calendarContainer.style.display = \"block\";\n                  }\n                  if (self.daysContainer !== undefined) {\n                      var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;\n                      self.daysContainer.style.width = daysWidth + \"px\";\n                      self.calendarContainer.style.width =\n                          daysWidth +\n                              (self.weekWrapper !== undefined\n                                  ? self.weekWrapper.offsetWidth\n                                  : 0) +\n                              \"px\";\n                      self.calendarContainer.style.removeProperty(\"visibility\");\n                      self.calendarContainer.style.removeProperty(\"display\");\n                  }\n              });\n          }\n      }\n      /**\n       * The handler for all events targeting the time inputs\n       */\n      function updateTime(e) {\n          if (self.selectedDates.length === 0) {\n              var defaultDate = self.config.minDate === undefined ||\n                  compareDates(new Date(), self.config.minDate) >= 0\n                  ? new Date()\n                  : new Date(self.config.minDate.getTime());\n              var defaults = getDefaultHours(self.config);\n              defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());\n              self.selectedDates = [defaultDate];\n              self.latestSelectedDateObj = defaultDate;\n          }\n          if (e !== undefined && e.type !== \"blur\") {\n              timeWrapper(e);\n          }\n          var prevValue = self._input.value;\n          setHoursFromInputs();\n          updateValue();\n          if (self._input.value !== prevValue) {\n              self._debouncedChange();\n          }\n      }\n      function ampm2military(hour, amPM) {\n          return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);\n      }\n      function military2ampm(hour) {\n          switch (hour % 24) {\n              case 0:\n              case 12:\n                  return 12;\n              default:\n                  return hour % 12;\n          }\n      }\n      /**\n       * Syncs the selected date object time with user's time input\n       */\n      function setHoursFromInputs() {\n          if (self.hourElement === undefined || self.minuteElement === undefined)\n              return;\n          var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined\n              ? (parseInt(self.secondElement.value, 10) || 0) % 60\n              : 0;\n          if (self.amPM !== undefined) {\n              hours = ampm2military(hours, self.amPM.textContent);\n          }\n          var limitMinHours = self.config.minTime !== undefined ||\n              (self.config.minDate &&\n                  self.minDateHasTime &&\n                  self.latestSelectedDateObj &&\n                  compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===\n                      0);\n          var limitMaxHours = self.config.maxTime !== undefined ||\n              (self.config.maxDate &&\n                  self.maxDateHasTime &&\n                  self.latestSelectedDateObj &&\n                  compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===\n                      0);\n          if (self.config.maxTime !== undefined &&\n              self.config.minTime !== undefined &&\n              self.config.minTime > self.config.maxTime) {\n              var minBound = calculateSecondsSinceMidnight(self.config.minTime.getHours(), self.config.minTime.getMinutes(), self.config.minTime.getSeconds());\n              var maxBound = calculateSecondsSinceMidnight(self.config.maxTime.getHours(), self.config.maxTime.getMinutes(), self.config.maxTime.getSeconds());\n              var currentTime = calculateSecondsSinceMidnight(hours, minutes, seconds);\n              if (currentTime > maxBound && currentTime < minBound) {\n                  var result = parseSeconds(minBound);\n                  hours = result[0];\n                  minutes = result[1];\n                  seconds = result[2];\n              }\n          }\n          else {\n              if (limitMaxHours) {\n                  var maxTime = self.config.maxTime !== undefined\n                      ? self.config.maxTime\n                      : self.config.maxDate;\n                  hours = Math.min(hours, maxTime.getHours());\n                  if (hours === maxTime.getHours())\n                      minutes = Math.min(minutes, maxTime.getMinutes());\n                  if (minutes === maxTime.getMinutes())\n                      seconds = Math.min(seconds, maxTime.getSeconds());\n              }\n              if (limitMinHours) {\n                  var minTime = self.config.minTime !== undefined\n                      ? self.config.minTime\n                      : self.config.minDate;\n                  hours = Math.max(hours, minTime.getHours());\n                  if (hours === minTime.getHours() && minutes < minTime.getMinutes())\n                      minutes = minTime.getMinutes();\n                  if (minutes === minTime.getMinutes())\n                      seconds = Math.max(seconds, minTime.getSeconds());\n              }\n          }\n          setHours(hours, minutes, seconds);\n      }\n      /**\n       * Syncs time input values with a date\n       */\n      function setHoursFromDate(dateObj) {\n          var date = dateObj || self.latestSelectedDateObj;\n          if (date && date instanceof Date) {\n              setHours(date.getHours(), date.getMinutes(), date.getSeconds());\n          }\n      }\n      /**\n       * Sets the hours, minutes, and optionally seconds\n       * of the latest selected date object and the\n       * corresponding time inputs\n       * @param {Number} hours the hour. whether its military\n       *                 or am-pm gets inferred from config\n       * @param {Number} minutes the minutes\n       * @param {Number} seconds the seconds (optional)\n       */\n      function setHours(hours, minutes, seconds) {\n          if (self.latestSelectedDateObj !== undefined) {\n              self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);\n          }\n          if (!self.hourElement || !self.minuteElement || self.isMobile)\n              return;\n          self.hourElement.value = pad(!self.config.time_24hr\n              ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)\n              : hours);\n          self.minuteElement.value = pad(minutes);\n          if (self.amPM !== undefined)\n              self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];\n          if (self.secondElement !== undefined)\n              self.secondElement.value = pad(seconds);\n      }\n      /**\n       * Handles the year input and incrementing events\n       * @param {Event} event the keyup or increment event\n       */\n      function onYearInput(event) {\n          var eventTarget = getEventTarget(event);\n          var year = parseInt(eventTarget.value) + (event.delta || 0);\n          if (year / 1000 > 1 ||\n              (event.key === \"Enter\" && !/[^\\d]/.test(year.toString()))) {\n              changeYear(year);\n          }\n      }\n      /**\n       * Essentially addEventListener + tracking\n       * @param {Element} element the element to addEventListener to\n       * @param {String} event the event name\n       * @param {Function} handler the event handler\n       */\n      function bind(element, event, handler, options) {\n          if (event instanceof Array)\n              return event.forEach(function (ev) { return bind(element, ev, handler, options); });\n          if (element instanceof Array)\n              return element.forEach(function (el) { return bind(el, event, handler, options); });\n          element.addEventListener(event, handler, options);\n          self._handlers.push({\n              remove: function () { return element.removeEventListener(event, handler, options); },\n          });\n      }\n      function triggerChange() {\n          triggerEvent(\"onChange\");\n      }\n      /**\n       * Adds all the necessary event listeners\n       */\n      function bindEvents() {\n          if (self.config.wrap) {\n              [\"open\", \"close\", \"toggle\", \"clear\"].forEach(function (evt) {\n                  Array.prototype.forEach.call(self.element.querySelectorAll(\"[data-\" + evt + \"]\"), function (el) {\n                      return bind(el, \"click\", self[evt]);\n                  });\n              });\n          }\n          if (self.isMobile) {\n              setupMobile();\n              return;\n          }\n          var debouncedResize = debounce(onResize, 50);\n          self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);\n          if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))\n              bind(self.daysContainer, \"mouseover\", function (e) {\n                  if (self.config.mode === \"range\")\n                      onMouseOver(getEventTarget(e));\n              });\n          bind(self._input, \"keydown\", onKeyDown);\n          if (self.calendarContainer !== undefined) {\n              bind(self.calendarContainer, \"keydown\", onKeyDown);\n          }\n          if (!self.config.inline && !self.config.static)\n              bind(window, \"resize\", debouncedResize);\n          if (window.ontouchstart !== undefined)\n              bind(window.document, \"touchstart\", documentClick);\n          else\n              bind(window.document, \"mousedown\", documentClick);\n          bind(window.document, \"focus\", documentClick, { capture: true });\n          if (self.config.clickOpens === true) {\n              bind(self._input, \"focus\", self.open);\n              bind(self._input, \"click\", self.open);\n          }\n          if (self.daysContainer !== undefined) {\n              bind(self.monthNav, \"click\", onMonthNavClick);\n              bind(self.monthNav, [\"keyup\", \"increment\"], onYearInput);\n              bind(self.daysContainer, \"click\", selectDate);\n          }\n          if (self.timeContainer !== undefined &&\n              self.minuteElement !== undefined &&\n              self.hourElement !== undefined) {\n              var selText = function (e) {\n                  return getEventTarget(e).select();\n              };\n              bind(self.timeContainer, [\"increment\"], updateTime);\n              bind(self.timeContainer, \"blur\", updateTime, { capture: true });\n              bind(self.timeContainer, \"click\", timeIncrement);\n              bind([self.hourElement, self.minuteElement], [\"focus\", \"click\"], selText);\n              if (self.secondElement !== undefined)\n                  bind(self.secondElement, \"focus\", function () { return self.secondElement && self.secondElement.select(); });\n              if (self.amPM !== undefined) {\n                  bind(self.amPM, \"click\", function (e) {\n                      updateTime(e);\n                  });\n              }\n          }\n          if (self.config.allowInput) {\n              bind(self._input, \"blur\", onBlur);\n          }\n      }\n      /**\n       * Set the calendar view to a particular date.\n       * @param {Date} jumpDate the date to set the view to\n       * @param {boolean} triggerChange if change events should be triggered\n       */\n      function jumpToDate(jumpDate, triggerChange) {\n          var jumpTo = jumpDate !== undefined\n              ? self.parseDate(jumpDate)\n              : self.latestSelectedDateObj ||\n                  (self.config.minDate && self.config.minDate > self.now\n                      ? self.config.minDate\n                      : self.config.maxDate && self.config.maxDate < self.now\n                          ? self.config.maxDate\n                          : self.now);\n          var oldYear = self.currentYear;\n          var oldMonth = self.currentMonth;\n          try {\n              if (jumpTo !== undefined) {\n                  self.currentYear = jumpTo.getFullYear();\n                  self.currentMonth = jumpTo.getMonth();\n              }\n          }\n          catch (e) {\n              /* istanbul ignore next */\n              e.message = \"Invalid date supplied: \" + jumpTo;\n              self.config.errorHandler(e);\n          }\n          if (triggerChange && self.currentYear !== oldYear) {\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n          if (triggerChange &&\n              (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {\n              triggerEvent(\"onMonthChange\");\n          }\n          self.redraw();\n      }\n      /**\n       * The up/down arrow handler for time inputs\n       * @param {Event} e the click event\n       */\n      function timeIncrement(e) {\n          var eventTarget = getEventTarget(e);\n          if (~eventTarget.className.indexOf(\"arrow\"))\n              incrementNumInput(e, eventTarget.classList.contains(\"arrowUp\") ? 1 : -1);\n      }\n      /**\n       * Increments/decrements the value of input associ-\n       * ated with the up/down arrow by dispatching an\n       * \"increment\" event on the input.\n       *\n       * @param {Event} e the click event\n       * @param {Number} delta the diff (usually 1 or -1)\n       * @param {Element} inputElem the input element\n       */\n      function incrementNumInput(e, delta, inputElem) {\n          var target = e && getEventTarget(e);\n          var input = inputElem ||\n              (target && target.parentNode && target.parentNode.firstChild);\n          var event = createEvent(\"increment\");\n          event.delta = delta;\n          input && input.dispatchEvent(event);\n      }\n      function build() {\n          var fragment = window.document.createDocumentFragment();\n          self.calendarContainer = createElement(\"div\", \"flatpickr-calendar\");\n          self.calendarContainer.tabIndex = -1;\n          if (!self.config.noCalendar) {\n              fragment.appendChild(buildMonthNav());\n              self.innerContainer = createElement(\"div\", \"flatpickr-innerContainer\");\n              if (self.config.weekNumbers) {\n                  var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;\n                  self.innerContainer.appendChild(weekWrapper);\n                  self.weekNumbers = weekNumbers;\n                  self.weekWrapper = weekWrapper;\n              }\n              self.rContainer = createElement(\"div\", \"flatpickr-rContainer\");\n              self.rContainer.appendChild(buildWeekdays());\n              if (!self.daysContainer) {\n                  self.daysContainer = createElement(\"div\", \"flatpickr-days\");\n                  self.daysContainer.tabIndex = -1;\n              }\n              buildDays();\n              self.rContainer.appendChild(self.daysContainer);\n              self.innerContainer.appendChild(self.rContainer);\n              fragment.appendChild(self.innerContainer);\n          }\n          if (self.config.enableTime) {\n              fragment.appendChild(buildTime());\n          }\n          toggleClass(self.calendarContainer, \"rangeMode\", self.config.mode === \"range\");\n          toggleClass(self.calendarContainer, \"animate\", self.config.animate === true);\n          toggleClass(self.calendarContainer, \"multiMonth\", self.config.showMonths > 1);\n          self.calendarContainer.appendChild(fragment);\n          var customAppend = self.config.appendTo !== undefined &&\n              self.config.appendTo.nodeType !== undefined;\n          if (self.config.inline || self.config.static) {\n              self.calendarContainer.classList.add(self.config.inline ? \"inline\" : \"static\");\n              if (self.config.inline) {\n                  if (!customAppend && self.element.parentNode)\n                      self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);\n                  else if (self.config.appendTo !== undefined)\n                      self.config.appendTo.appendChild(self.calendarContainer);\n              }\n              if (self.config.static) {\n                  var wrapper = createElement(\"div\", \"flatpickr-wrapper\");\n                  if (self.element.parentNode)\n                      self.element.parentNode.insertBefore(wrapper, self.element);\n                  wrapper.appendChild(self.element);\n                  if (self.altInput)\n                      wrapper.appendChild(self.altInput);\n                  wrapper.appendChild(self.calendarContainer);\n              }\n          }\n          if (!self.config.static && !self.config.inline)\n              (self.config.appendTo !== undefined\n                  ? self.config.appendTo\n                  : window.document.body).appendChild(self.calendarContainer);\n      }\n      function createDay(className, date, _dayNumber, i) {\n          var dateIsEnabled = isEnabled(date, true), dayElement = createElement(\"span\", className, date.getDate().toString());\n          dayElement.dateObj = date;\n          dayElement.$i = i;\n          dayElement.setAttribute(\"aria-label\", self.formatDate(date, self.config.ariaDateFormat));\n          if (className.indexOf(\"hidden\") === -1 &&\n              compareDates(date, self.now) === 0) {\n              self.todayDateElem = dayElement;\n              dayElement.classList.add(\"today\");\n              dayElement.setAttribute(\"aria-current\", \"date\");\n          }\n          if (dateIsEnabled) {\n              dayElement.tabIndex = -1;\n              if (isDateSelected(date)) {\n                  dayElement.classList.add(\"selected\");\n                  self.selectedDateElem = dayElement;\n                  if (self.config.mode === \"range\") {\n                      toggleClass(dayElement, \"startRange\", self.selectedDates[0] &&\n                          compareDates(date, self.selectedDates[0], true) === 0);\n                      toggleClass(dayElement, \"endRange\", self.selectedDates[1] &&\n                          compareDates(date, self.selectedDates[1], true) === 0);\n                      if (className === \"nextMonthDay\")\n                          dayElement.classList.add(\"inRange\");\n                  }\n              }\n          }\n          else {\n              dayElement.classList.add(\"flatpickr-disabled\");\n          }\n          if (self.config.mode === \"range\") {\n              if (isDateInRange(date) && !isDateSelected(date))\n                  dayElement.classList.add(\"inRange\");\n          }\n          if (self.weekNumbers &&\n              self.config.showMonths === 1 &&\n              className !== \"prevMonthDay\" &&\n              i % 7 === 6) {\n              self.weekNumbers.insertAdjacentHTML(\"beforeend\", \"<span class='flatpickr-day'>\" + self.config.getWeek(date) + \"</span>\");\n          }\n          triggerEvent(\"onDayCreate\", dayElement);\n          return dayElement;\n      }\n      function focusOnDayElem(targetNode) {\n          targetNode.focus();\n          if (self.config.mode === \"range\")\n              onMouseOver(targetNode);\n      }\n      function getFirstAvailableDay(delta) {\n          var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;\n          var endMonth = delta > 0 ? self.config.showMonths : -1;\n          for (var m = startMonth; m != endMonth; m += delta) {\n              var month = self.daysContainer.children[m];\n              var startIndex = delta > 0 ? 0 : month.children.length - 1;\n              var endIndex = delta > 0 ? month.children.length : -1;\n              for (var i = startIndex; i != endIndex; i += delta) {\n                  var c = month.children[i];\n                  if (c.className.indexOf(\"hidden\") === -1 && isEnabled(c.dateObj))\n                      return c;\n              }\n          }\n          return undefined;\n      }\n      function getNextAvailableDay(current, delta) {\n          var givenMonth = current.className.indexOf(\"Month\") === -1\n              ? current.dateObj.getMonth()\n              : self.currentMonth;\n          var endMonth = delta > 0 ? self.config.showMonths : -1;\n          var loopDelta = delta > 0 ? 1 : -1;\n          for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {\n              var month = self.daysContainer.children[m];\n              var startIndex = givenMonth - self.currentMonth === m\n                  ? current.$i + delta\n                  : delta < 0\n                      ? month.children.length - 1\n                      : 0;\n              var numMonthDays = month.children.length;\n              for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {\n                  var c = month.children[i];\n                  if (c.className.indexOf(\"hidden\") === -1 &&\n                      isEnabled(c.dateObj) &&\n                      Math.abs(current.$i - i) >= Math.abs(delta))\n                      return focusOnDayElem(c);\n              }\n          }\n          self.changeMonth(loopDelta);\n          focusOnDay(getFirstAvailableDay(loopDelta), 0);\n          return undefined;\n      }\n      function focusOnDay(current, offset) {\n          var activeElement = getClosestActiveElement();\n          var dayFocused = isInView(activeElement || document.body);\n          var startElem = current !== undefined\n              ? current\n              : dayFocused\n                  ? activeElement\n                  : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)\n                      ? self.selectedDateElem\n                      : self.todayDateElem !== undefined && isInView(self.todayDateElem)\n                          ? self.todayDateElem\n                          : getFirstAvailableDay(offset > 0 ? 1 : -1);\n          if (startElem === undefined) {\n              self._input.focus();\n          }\n          else if (!dayFocused) {\n              focusOnDayElem(startElem);\n          }\n          else {\n              getNextAvailableDay(startElem, offset);\n          }\n      }\n      function buildMonthDays(year, month) {\n          var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;\n          var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);\n          var daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? \"prevMonthDay hidden\" : \"prevMonthDay\", nextMonthDayClass = isMultiMonth ? \"nextMonthDay hidden\" : \"nextMonthDay\";\n          var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;\n          // prepend days from the ending of previous month\n          for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day \" + prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));\n          }\n          // Start at 1 since there is no 0th day\n          for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day\", new Date(year, month, dayNumber), dayNumber, dayIndex));\n          }\n          // append days from the next month\n          for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&\n              (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {\n              days.appendChild(createDay(\"flatpickr-day \" + nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));\n          }\n          //updateNavigationCurrentMonth();\n          var dayContainer = createElement(\"div\", \"dayContainer\");\n          dayContainer.appendChild(days);\n          return dayContainer;\n      }\n      function buildDays() {\n          if (self.daysContainer === undefined) {\n              return;\n          }\n          clearNode(self.daysContainer);\n          // TODO: week numbers for each month\n          if (self.weekNumbers)\n              clearNode(self.weekNumbers);\n          var frag = document.createDocumentFragment();\n          for (var i = 0; i < self.config.showMonths; i++) {\n              var d = new Date(self.currentYear, self.currentMonth, 1);\n              d.setMonth(self.currentMonth + i);\n              frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));\n          }\n          self.daysContainer.appendChild(frag);\n          self.days = self.daysContainer.firstChild;\n          if (self.config.mode === \"range\" && self.selectedDates.length === 1) {\n              onMouseOver();\n          }\n      }\n      function buildMonthSwitch() {\n          if (self.config.showMonths > 1 ||\n              self.config.monthSelectorType !== \"dropdown\")\n              return;\n          var shouldBuildMonth = function (month) {\n              if (self.config.minDate !== undefined &&\n                  self.currentYear === self.config.minDate.getFullYear() &&\n                  month < self.config.minDate.getMonth()) {\n                  return false;\n              }\n              return !(self.config.maxDate !== undefined &&\n                  self.currentYear === self.config.maxDate.getFullYear() &&\n                  month > self.config.maxDate.getMonth());\n          };\n          self.monthsDropdownContainer.tabIndex = -1;\n          self.monthsDropdownContainer.innerHTML = \"\";\n          for (var i = 0; i < 12; i++) {\n              if (!shouldBuildMonth(i))\n                  continue;\n              var month = createElement(\"option\", \"flatpickr-monthDropdown-month\");\n              month.value = new Date(self.currentYear, i).getMonth().toString();\n              month.textContent = monthToStr(i, self.config.shorthandCurrentMonth, self.l10n);\n              month.tabIndex = -1;\n              if (self.currentMonth === i) {\n                  month.selected = true;\n              }\n              self.monthsDropdownContainer.appendChild(month);\n          }\n      }\n      function buildMonth() {\n          var container = createElement(\"div\", \"flatpickr-month\");\n          var monthNavFragment = window.document.createDocumentFragment();\n          var monthElement;\n          if (self.config.showMonths > 1 ||\n              self.config.monthSelectorType === \"static\") {\n              monthElement = createElement(\"span\", \"cur-month\");\n          }\n          else {\n              self.monthsDropdownContainer = createElement(\"select\", \"flatpickr-monthDropdown-months\");\n              self.monthsDropdownContainer.setAttribute(\"aria-label\", self.l10n.monthAriaLabel);\n              bind(self.monthsDropdownContainer, \"change\", function (e) {\n                  var target = getEventTarget(e);\n                  var selectedMonth = parseInt(target.value, 10);\n                  self.changeMonth(selectedMonth - self.currentMonth);\n                  triggerEvent(\"onMonthChange\");\n              });\n              buildMonthSwitch();\n              monthElement = self.monthsDropdownContainer;\n          }\n          var yearInput = createNumberInput(\"cur-year\", { tabindex: \"-1\" });\n          var yearElement = yearInput.getElementsByTagName(\"input\")[0];\n          yearElement.setAttribute(\"aria-label\", self.l10n.yearAriaLabel);\n          if (self.config.minDate) {\n              yearElement.setAttribute(\"min\", self.config.minDate.getFullYear().toString());\n          }\n          if (self.config.maxDate) {\n              yearElement.setAttribute(\"max\", self.config.maxDate.getFullYear().toString());\n              yearElement.disabled =\n                  !!self.config.minDate &&\n                      self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();\n          }\n          var currentMonth = createElement(\"div\", \"flatpickr-current-month\");\n          currentMonth.appendChild(monthElement);\n          currentMonth.appendChild(yearInput);\n          monthNavFragment.appendChild(currentMonth);\n          container.appendChild(monthNavFragment);\n          return {\n              container: container,\n              yearElement: yearElement,\n              monthElement: monthElement,\n          };\n      }\n      function buildMonths() {\n          clearNode(self.monthNav);\n          self.monthNav.appendChild(self.prevMonthNav);\n          if (self.config.showMonths) {\n              self.yearElements = [];\n              self.monthElements = [];\n          }\n          for (var m = self.config.showMonths; m--;) {\n              var month = buildMonth();\n              self.yearElements.push(month.yearElement);\n              self.monthElements.push(month.monthElement);\n              self.monthNav.appendChild(month.container);\n          }\n          self.monthNav.appendChild(self.nextMonthNav);\n      }\n      function buildMonthNav() {\n          self.monthNav = createElement(\"div\", \"flatpickr-months\");\n          self.yearElements = [];\n          self.monthElements = [];\n          self.prevMonthNav = createElement(\"span\", \"flatpickr-prev-month\");\n          self.prevMonthNav.innerHTML = self.config.prevArrow;\n          self.nextMonthNav = createElement(\"span\", \"flatpickr-next-month\");\n          self.nextMonthNav.innerHTML = self.config.nextArrow;\n          buildMonths();\n          Object.defineProperty(self, \"_hidePrevMonthArrow\", {\n              get: function () { return self.__hidePrevMonthArrow; },\n              set: function (bool) {\n                  if (self.__hidePrevMonthArrow !== bool) {\n                      toggleClass(self.prevMonthNav, \"flatpickr-disabled\", bool);\n                      self.__hidePrevMonthArrow = bool;\n                  }\n              },\n          });\n          Object.defineProperty(self, \"_hideNextMonthArrow\", {\n              get: function () { return self.__hideNextMonthArrow; },\n              set: function (bool) {\n                  if (self.__hideNextMonthArrow !== bool) {\n                      toggleClass(self.nextMonthNav, \"flatpickr-disabled\", bool);\n                      self.__hideNextMonthArrow = bool;\n                  }\n              },\n          });\n          self.currentYearElement = self.yearElements[0];\n          updateNavigationCurrentMonth();\n          return self.monthNav;\n      }\n      function buildTime() {\n          self.calendarContainer.classList.add(\"hasTime\");\n          if (self.config.noCalendar)\n              self.calendarContainer.classList.add(\"noCalendar\");\n          var defaults = getDefaultHours(self.config);\n          self.timeContainer = createElement(\"div\", \"flatpickr-time\");\n          self.timeContainer.tabIndex = -1;\n          var separator = createElement(\"span\", \"flatpickr-time-separator\", \":\");\n          var hourInput = createNumberInput(\"flatpickr-hour\", {\n              \"aria-label\": self.l10n.hourAriaLabel,\n          });\n          self.hourElement = hourInput.getElementsByTagName(\"input\")[0];\n          var minuteInput = createNumberInput(\"flatpickr-minute\", {\n              \"aria-label\": self.l10n.minuteAriaLabel,\n          });\n          self.minuteElement = minuteInput.getElementsByTagName(\"input\")[0];\n          self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;\n          self.hourElement.value = pad(self.latestSelectedDateObj\n              ? self.latestSelectedDateObj.getHours()\n              : self.config.time_24hr\n                  ? defaults.hours\n                  : military2ampm(defaults.hours));\n          self.minuteElement.value = pad(self.latestSelectedDateObj\n              ? self.latestSelectedDateObj.getMinutes()\n              : defaults.minutes);\n          self.hourElement.setAttribute(\"step\", self.config.hourIncrement.toString());\n          self.minuteElement.setAttribute(\"step\", self.config.minuteIncrement.toString());\n          self.hourElement.setAttribute(\"min\", self.config.time_24hr ? \"0\" : \"1\");\n          self.hourElement.setAttribute(\"max\", self.config.time_24hr ? \"23\" : \"12\");\n          self.hourElement.setAttribute(\"maxlength\", \"2\");\n          self.minuteElement.setAttribute(\"min\", \"0\");\n          self.minuteElement.setAttribute(\"max\", \"59\");\n          self.minuteElement.setAttribute(\"maxlength\", \"2\");\n          self.timeContainer.appendChild(hourInput);\n          self.timeContainer.appendChild(separator);\n          self.timeContainer.appendChild(minuteInput);\n          if (self.config.time_24hr)\n              self.timeContainer.classList.add(\"time24hr\");\n          if (self.config.enableSeconds) {\n              self.timeContainer.classList.add(\"hasSeconds\");\n              var secondInput = createNumberInput(\"flatpickr-second\");\n              self.secondElement = secondInput.getElementsByTagName(\"input\")[0];\n              self.secondElement.value = pad(self.latestSelectedDateObj\n                  ? self.latestSelectedDateObj.getSeconds()\n                  : defaults.seconds);\n              self.secondElement.setAttribute(\"step\", self.minuteElement.getAttribute(\"step\"));\n              self.secondElement.setAttribute(\"min\", \"0\");\n              self.secondElement.setAttribute(\"max\", \"59\");\n              self.secondElement.setAttribute(\"maxlength\", \"2\");\n              self.timeContainer.appendChild(createElement(\"span\", \"flatpickr-time-separator\", \":\"));\n              self.timeContainer.appendChild(secondInput);\n          }\n          if (!self.config.time_24hr) {\n              // add self.amPM if appropriate\n              self.amPM = createElement(\"span\", \"flatpickr-am-pm\", self.l10n.amPM[int((self.latestSelectedDateObj\n                  ? self.hourElement.value\n                  : self.config.defaultHour) > 11)]);\n              self.amPM.title = self.l10n.toggleTitle;\n              self.amPM.tabIndex = -1;\n              self.timeContainer.appendChild(self.amPM);\n          }\n          return self.timeContainer;\n      }\n      function buildWeekdays() {\n          if (!self.weekdayContainer)\n              self.weekdayContainer = createElement(\"div\", \"flatpickr-weekdays\");\n          else\n              clearNode(self.weekdayContainer);\n          for (var i = self.config.showMonths; i--;) {\n              var container = createElement(\"div\", \"flatpickr-weekdaycontainer\");\n              self.weekdayContainer.appendChild(container);\n          }\n          updateWeekdays();\n          return self.weekdayContainer;\n      }\n      function updateWeekdays() {\n          if (!self.weekdayContainer) {\n              return;\n          }\n          var firstDayOfWeek = self.l10n.firstDayOfWeek;\n          var weekdays = __spreadArrays(self.l10n.weekdays.shorthand);\n          if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {\n              weekdays = __spreadArrays(weekdays.splice(firstDayOfWeek, weekdays.length), weekdays.splice(0, firstDayOfWeek));\n          }\n          for (var i = self.config.showMonths; i--;) {\n              self.weekdayContainer.children[i].innerHTML = \"\\n      <span class='flatpickr-weekday'>\\n        \" + weekdays.join(\"</span><span class='flatpickr-weekday'>\") + \"\\n      </span>\\n      \";\n          }\n      }\n      /* istanbul ignore next */\n      function buildWeeks() {\n          self.calendarContainer.classList.add(\"hasWeeks\");\n          var weekWrapper = createElement(\"div\", \"flatpickr-weekwrapper\");\n          weekWrapper.appendChild(createElement(\"span\", \"flatpickr-weekday\", self.l10n.weekAbbreviation));\n          var weekNumbers = createElement(\"div\", \"flatpickr-weeks\");\n          weekWrapper.appendChild(weekNumbers);\n          return {\n              weekWrapper: weekWrapper,\n              weekNumbers: weekNumbers,\n          };\n      }\n      function changeMonth(value, isOffset) {\n          if (isOffset === void 0) { isOffset = true; }\n          var delta = isOffset ? value : value - self.currentMonth;\n          if ((delta < 0 && self._hidePrevMonthArrow === true) ||\n              (delta > 0 && self._hideNextMonthArrow === true))\n              return;\n          self.currentMonth += delta;\n          if (self.currentMonth < 0 || self.currentMonth > 11) {\n              self.currentYear += self.currentMonth > 11 ? 1 : -1;\n              self.currentMonth = (self.currentMonth + 12) % 12;\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n          buildDays();\n          triggerEvent(\"onMonthChange\");\n          updateNavigationCurrentMonth();\n      }\n      function clear(triggerChangeEvent, toInitial) {\n          if (triggerChangeEvent === void 0) { triggerChangeEvent = true; }\n          if (toInitial === void 0) { toInitial = true; }\n          self.input.value = \"\";\n          if (self.altInput !== undefined)\n              self.altInput.value = \"\";\n          if (self.mobileInput !== undefined)\n              self.mobileInput.value = \"\";\n          self.selectedDates = [];\n          self.latestSelectedDateObj = undefined;\n          if (toInitial === true) {\n              self.currentYear = self._initialDate.getFullYear();\n              self.currentMonth = self._initialDate.getMonth();\n          }\n          if (self.config.enableTime === true) {\n              var _a = getDefaultHours(self.config), hours = _a.hours, minutes = _a.minutes, seconds = _a.seconds;\n              setHours(hours, minutes, seconds);\n          }\n          self.redraw();\n          if (triggerChangeEvent)\n              // triggerChangeEvent is true (default) or an Event\n              triggerEvent(\"onChange\");\n      }\n      function close() {\n          self.isOpen = false;\n          if (!self.isMobile) {\n              if (self.calendarContainer !== undefined) {\n                  self.calendarContainer.classList.remove(\"open\");\n              }\n              if (self._input !== undefined) {\n                  self._input.classList.remove(\"active\");\n              }\n          }\n          triggerEvent(\"onClose\");\n      }\n      function destroy() {\n          if (self.config !== undefined)\n              triggerEvent(\"onDestroy\");\n          for (var i = self._handlers.length; i--;) {\n              self._handlers[i].remove();\n          }\n          self._handlers = [];\n          if (self.mobileInput) {\n              if (self.mobileInput.parentNode)\n                  self.mobileInput.parentNode.removeChild(self.mobileInput);\n              self.mobileInput = undefined;\n          }\n          else if (self.calendarContainer && self.calendarContainer.parentNode) {\n              if (self.config.static && self.calendarContainer.parentNode) {\n                  var wrapper = self.calendarContainer.parentNode;\n                  wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);\n                  if (wrapper.parentNode) {\n                      while (wrapper.firstChild)\n                          wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);\n                      wrapper.parentNode.removeChild(wrapper);\n                  }\n              }\n              else\n                  self.calendarContainer.parentNode.removeChild(self.calendarContainer);\n          }\n          if (self.altInput) {\n              self.input.type = \"text\";\n              if (self.altInput.parentNode)\n                  self.altInput.parentNode.removeChild(self.altInput);\n              delete self.altInput;\n          }\n          if (self.input) {\n              self.input.type = self.input._type;\n              self.input.classList.remove(\"flatpickr-input\");\n              self.input.removeAttribute(\"readonly\");\n          }\n          [\n              \"_showTimeInput\",\n              \"latestSelectedDateObj\",\n              \"_hideNextMonthArrow\",\n              \"_hidePrevMonthArrow\",\n              \"__hideNextMonthArrow\",\n              \"__hidePrevMonthArrow\",\n              \"isMobile\",\n              \"isOpen\",\n              \"selectedDateElem\",\n              \"minDateHasTime\",\n              \"maxDateHasTime\",\n              \"days\",\n              \"daysContainer\",\n              \"_input\",\n              \"_positionElement\",\n              \"innerContainer\",\n              \"rContainer\",\n              \"monthNav\",\n              \"todayDateElem\",\n              \"calendarContainer\",\n              \"weekdayContainer\",\n              \"prevMonthNav\",\n              \"nextMonthNav\",\n              \"monthsDropdownContainer\",\n              \"currentMonthElement\",\n              \"currentYearElement\",\n              \"navigationCurrentMonth\",\n              \"selectedDateElem\",\n              \"config\",\n          ].forEach(function (k) {\n              try {\n                  delete self[k];\n              }\n              catch (_) { }\n          });\n      }\n      function isCalendarElem(elem) {\n          return self.calendarContainer.contains(elem);\n      }\n      function documentClick(e) {\n          if (self.isOpen && !self.config.inline) {\n              var eventTarget_1 = getEventTarget(e);\n              var isCalendarElement = isCalendarElem(eventTarget_1);\n              var isInput = eventTarget_1 === self.input ||\n                  eventTarget_1 === self.altInput ||\n                  self.element.contains(eventTarget_1) ||\n                  // web components\n                  // e.path is not present in all browsers. circumventing typechecks\n                  (e.path &&\n                      e.path.indexOf &&\n                      (~e.path.indexOf(self.input) ||\n                          ~e.path.indexOf(self.altInput)));\n              var lostFocus = !isInput &&\n                  !isCalendarElement &&\n                  !isCalendarElem(e.relatedTarget);\n              var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {\n                  return elem.contains(eventTarget_1);\n              });\n              if (lostFocus && isIgnored) {\n                  if (self.config.allowInput) {\n                      self.setDate(self._input.value, false, self.config.altInput\n                          ? self.config.altFormat\n                          : self.config.dateFormat);\n                  }\n                  if (self.timeContainer !== undefined &&\n                      self.minuteElement !== undefined &&\n                      self.hourElement !== undefined &&\n                      self.input.value !== \"\" &&\n                      self.input.value !== undefined) {\n                      updateTime();\n                  }\n                  self.close();\n                  if (self.config &&\n                      self.config.mode === \"range\" &&\n                      self.selectedDates.length === 1)\n                      self.clear(false);\n              }\n          }\n      }\n      function changeYear(newYear) {\n          if (!newYear ||\n              (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||\n              (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))\n              return;\n          var newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;\n          self.currentYear = newYearNum || self.currentYear;\n          if (self.config.maxDate &&\n              self.currentYear === self.config.maxDate.getFullYear()) {\n              self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);\n          }\n          else if (self.config.minDate &&\n              self.currentYear === self.config.minDate.getFullYear()) {\n              self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);\n          }\n          if (isNewYear) {\n              self.redraw();\n              triggerEvent(\"onYearChange\");\n              buildMonthSwitch();\n          }\n      }\n      function isEnabled(date, timeless) {\n          var _a;\n          if (timeless === void 0) { timeless = true; }\n          var dateToCheck = self.parseDate(date, undefined, timeless); // timeless\n          if ((self.config.minDate &&\n              dateToCheck &&\n              compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||\n              (self.config.maxDate &&\n                  dateToCheck &&\n                  compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))\n              return false;\n          if (!self.config.enable && self.config.disable.length === 0)\n              return true;\n          if (dateToCheck === undefined)\n              return false;\n          var bool = !!self.config.enable, array = (_a = self.config.enable) !== null && _a !== void 0 ? _a : self.config.disable;\n          for (var i = 0, d = void 0; i < array.length; i++) {\n              d = array[i];\n              if (typeof d === \"function\" &&\n                  d(dateToCheck) // disabled by function\n              )\n                  return bool;\n              else if (d instanceof Date &&\n                  dateToCheck !== undefined &&\n                  d.getTime() === dateToCheck.getTime())\n                  // disabled by date\n                  return bool;\n              else if (typeof d === \"string\") {\n                  // disabled by date string\n                  var parsed = self.parseDate(d, undefined, true);\n                  return parsed && parsed.getTime() === dateToCheck.getTime()\n                      ? bool\n                      : !bool;\n              }\n              else if (\n              // disabled by range\n              typeof d === \"object\" &&\n                  dateToCheck !== undefined &&\n                  d.from &&\n                  d.to &&\n                  dateToCheck.getTime() >= d.from.getTime() &&\n                  dateToCheck.getTime() <= d.to.getTime())\n                  return bool;\n          }\n          return !bool;\n      }\n      function isInView(elem) {\n          if (self.daysContainer !== undefined)\n              return (elem.className.indexOf(\"hidden\") === -1 &&\n                  elem.className.indexOf(\"flatpickr-disabled\") === -1 &&\n                  self.daysContainer.contains(elem));\n          return false;\n      }\n      function onBlur(e) {\n          var isInput = e.target === self._input;\n          var valueChanged = self._input.value.trimEnd() !== getDateStr();\n          if (isInput &&\n              valueChanged &&\n              !(e.relatedTarget && isCalendarElem(e.relatedTarget))) {\n              self.setDate(self._input.value, true, e.target === self.altInput\n                  ? self.config.altFormat\n                  : self.config.dateFormat);\n          }\n      }\n      function onKeyDown(e) {\n          // e.key                      e.keyCode\n          // \"Backspace\"                        8\n          // \"Tab\"                              9\n          // \"Enter\"                           13\n          // \"Escape\"     (IE \"Esc\")           27\n          // \"ArrowLeft\"  (IE \"Left\")          37\n          // \"ArrowUp\"    (IE \"Up\")            38\n          // \"ArrowRight\" (IE \"Right\")         39\n          // \"ArrowDown\"  (IE \"Down\")          40\n          // \"Delete\"     (IE \"Del\")           46\n          var eventTarget = getEventTarget(e);\n          var isInput = self.config.wrap\n              ? element.contains(eventTarget)\n              : eventTarget === self._input;\n          var allowInput = self.config.allowInput;\n          var allowKeydown = self.isOpen && (!allowInput || !isInput);\n          var allowInlineKeydown = self.config.inline && isInput && !allowInput;\n          if (e.keyCode === 13 && isInput) {\n              if (allowInput) {\n                  self.setDate(self._input.value, true, eventTarget === self.altInput\n                      ? self.config.altFormat\n                      : self.config.dateFormat);\n                  self.close();\n                  return eventTarget.blur();\n              }\n              else {\n                  self.open();\n              }\n          }\n          else if (isCalendarElem(eventTarget) ||\n              allowKeydown ||\n              allowInlineKeydown) {\n              var isTimeObj = !!self.timeContainer &&\n                  self.timeContainer.contains(eventTarget);\n              switch (e.keyCode) {\n                  case 13:\n                      if (isTimeObj) {\n                          e.preventDefault();\n                          updateTime();\n                          focusAndClose();\n                      }\n                      else\n                          selectDate(e);\n                      break;\n                  case 27: // escape\n                      e.preventDefault();\n                      focusAndClose();\n                      break;\n                  case 8:\n                  case 46:\n                      if (isInput && !self.config.allowInput) {\n                          e.preventDefault();\n                          self.clear();\n                      }\n                      break;\n                  case 37:\n                  case 39:\n                      if (!isTimeObj && !isInput) {\n                          e.preventDefault();\n                          var activeElement = getClosestActiveElement();\n                          if (self.daysContainer !== undefined &&\n                              (allowInput === false ||\n                                  (activeElement && isInView(activeElement)))) {\n                              var delta_1 = e.keyCode === 39 ? 1 : -1;\n                              if (!e.ctrlKey)\n                                  focusOnDay(undefined, delta_1);\n                              else {\n                                  e.stopPropagation();\n                                  changeMonth(delta_1);\n                                  focusOnDay(getFirstAvailableDay(1), 0);\n                              }\n                          }\n                      }\n                      else if (self.hourElement)\n                          self.hourElement.focus();\n                      break;\n                  case 38:\n                  case 40:\n                      e.preventDefault();\n                      var delta = e.keyCode === 40 ? 1 : -1;\n                      if ((self.daysContainer &&\n                          eventTarget.$i !== undefined) ||\n                          eventTarget === self.input ||\n                          eventTarget === self.altInput) {\n                          if (e.ctrlKey) {\n                              e.stopPropagation();\n                              changeYear(self.currentYear - delta);\n                              focusOnDay(getFirstAvailableDay(1), 0);\n                          }\n                          else if (!isTimeObj)\n                              focusOnDay(undefined, delta * 7);\n                      }\n                      else if (eventTarget === self.currentYearElement) {\n                          changeYear(self.currentYear - delta);\n                      }\n                      else if (self.config.enableTime) {\n                          if (!isTimeObj && self.hourElement)\n                              self.hourElement.focus();\n                          updateTime(e);\n                          self._debouncedChange();\n                      }\n                      break;\n                  case 9:\n                      if (isTimeObj) {\n                          var elems = [\n                              self.hourElement,\n                              self.minuteElement,\n                              self.secondElement,\n                              self.amPM,\n                          ]\n                              .concat(self.pluginElements)\n                              .filter(function (x) { return x; });\n                          var i = elems.indexOf(eventTarget);\n                          if (i !== -1) {\n                              var target = elems[i + (e.shiftKey ? -1 : 1)];\n                              e.preventDefault();\n                              (target || self._input).focus();\n                          }\n                      }\n                      else if (!self.config.noCalendar &&\n                          self.daysContainer &&\n                          self.daysContainer.contains(eventTarget) &&\n                          e.shiftKey) {\n                          e.preventDefault();\n                          self._input.focus();\n                      }\n                      break;\n              }\n          }\n          if (self.amPM !== undefined && eventTarget === self.amPM) {\n              switch (e.key) {\n                  case self.l10n.amPM[0].charAt(0):\n                  case self.l10n.amPM[0].charAt(0).toLowerCase():\n                      self.amPM.textContent = self.l10n.amPM[0];\n                      setHoursFromInputs();\n                      updateValue();\n                      break;\n                  case self.l10n.amPM[1].charAt(0):\n                  case self.l10n.amPM[1].charAt(0).toLowerCase():\n                      self.amPM.textContent = self.l10n.amPM[1];\n                      setHoursFromInputs();\n                      updateValue();\n                      break;\n              }\n          }\n          if (isInput || isCalendarElem(eventTarget)) {\n              triggerEvent(\"onKeyDown\", e);\n          }\n      }\n      function onMouseOver(elem, cellClass) {\n          if (cellClass === void 0) { cellClass = \"flatpickr-day\"; }\n          if (self.selectedDates.length !== 1 ||\n              (elem &&\n                  (!elem.classList.contains(cellClass) ||\n                      elem.classList.contains(\"flatpickr-disabled\"))))\n              return;\n          var hoverDate = elem\n              ? elem.dateObj.getTime()\n              : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());\n          var containsDisabled = false;\n          var minRange = 0, maxRange = 0;\n          for (var t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {\n              if (!isEnabled(new Date(t), true)) {\n                  containsDisabled =\n                      containsDisabled || (t > rangeStartDate && t < rangeEndDate);\n                  if (t < initialDate && (!minRange || t > minRange))\n                      minRange = t;\n                  else if (t > initialDate && (!maxRange || t < maxRange))\n                      maxRange = t;\n              }\n          }\n          var hoverableCells = Array.from(self.rContainer.querySelectorAll(\"*:nth-child(-n+\" + self.config.showMonths + \") > .\" + cellClass));\n          hoverableCells.forEach(function (dayElem) {\n              var date = dayElem.dateObj;\n              var timestamp = date.getTime();\n              var outOfRange = (minRange > 0 && timestamp < minRange) ||\n                  (maxRange > 0 && timestamp > maxRange);\n              if (outOfRange) {\n                  dayElem.classList.add(\"notAllowed\");\n                  [\"inRange\", \"startRange\", \"endRange\"].forEach(function (c) {\n                      dayElem.classList.remove(c);\n                  });\n                  return;\n              }\n              else if (containsDisabled && !outOfRange)\n                  return;\n              [\"startRange\", \"inRange\", \"endRange\", \"notAllowed\"].forEach(function (c) {\n                  dayElem.classList.remove(c);\n              });\n              if (elem !== undefined) {\n                  elem.classList.add(hoverDate <= self.selectedDates[0].getTime()\n                      ? \"startRange\"\n                      : \"endRange\");\n                  if (initialDate < hoverDate && timestamp === initialDate)\n                      dayElem.classList.add(\"startRange\");\n                  else if (initialDate > hoverDate && timestamp === initialDate)\n                      dayElem.classList.add(\"endRange\");\n                  if (timestamp >= minRange &&\n                      (maxRange === 0 || timestamp <= maxRange) &&\n                      isBetween(timestamp, initialDate, hoverDate))\n                      dayElem.classList.add(\"inRange\");\n              }\n          });\n      }\n      function onResize() {\n          if (self.isOpen && !self.config.static && !self.config.inline)\n              positionCalendar();\n      }\n      function open(e, positionElement) {\n          if (positionElement === void 0) { positionElement = self._positionElement; }\n          if (self.isMobile === true) {\n              if (e) {\n                  e.preventDefault();\n                  var eventTarget = getEventTarget(e);\n                  if (eventTarget) {\n                      eventTarget.blur();\n                  }\n              }\n              if (self.mobileInput !== undefined) {\n                  self.mobileInput.focus();\n                  self.mobileInput.click();\n              }\n              triggerEvent(\"onOpen\");\n              return;\n          }\n          else if (self._input.disabled || self.config.inline) {\n              return;\n          }\n          var wasOpen = self.isOpen;\n          self.isOpen = true;\n          if (!wasOpen) {\n              self.calendarContainer.classList.add(\"open\");\n              self._input.classList.add(\"active\");\n              triggerEvent(\"onOpen\");\n              positionCalendar(positionElement);\n          }\n          if (self.config.enableTime === true && self.config.noCalendar === true) {\n              if (self.config.allowInput === false &&\n                  (e === undefined ||\n                      !self.timeContainer.contains(e.relatedTarget))) {\n                  setTimeout(function () { return self.hourElement.select(); }, 50);\n              }\n          }\n      }\n      function minMaxDateSetter(type) {\n          return function (date) {\n              var dateObj = (self.config[\"_\" + type + \"Date\"] = self.parseDate(date, self.config.dateFormat));\n              var inverseDateObj = self.config[\"_\" + (type === \"min\" ? \"max\" : \"min\") + \"Date\"];\n              if (dateObj !== undefined) {\n                  self[type === \"min\" ? \"minDateHasTime\" : \"maxDateHasTime\"] =\n                      dateObj.getHours() > 0 ||\n                          dateObj.getMinutes() > 0 ||\n                          dateObj.getSeconds() > 0;\n              }\n              if (self.selectedDates) {\n                  self.selectedDates = self.selectedDates.filter(function (d) { return isEnabled(d); });\n                  if (!self.selectedDates.length && type === \"min\")\n                      setHoursFromDate(dateObj);\n                  updateValue();\n              }\n              if (self.daysContainer) {\n                  redraw();\n                  if (dateObj !== undefined)\n                      self.currentYearElement[type] = dateObj.getFullYear().toString();\n                  else\n                      self.currentYearElement.removeAttribute(type);\n                  self.currentYearElement.disabled =\n                      !!inverseDateObj &&\n                          dateObj !== undefined &&\n                          inverseDateObj.getFullYear() === dateObj.getFullYear();\n              }\n          };\n      }\n      function parseConfig() {\n          var boolOpts = [\n              \"wrap\",\n              \"weekNumbers\",\n              \"allowInput\",\n              \"allowInvalidPreload\",\n              \"clickOpens\",\n              \"time_24hr\",\n              \"enableTime\",\n              \"noCalendar\",\n              \"altInput\",\n              \"shorthandCurrentMonth\",\n              \"inline\",\n              \"static\",\n              \"enableSeconds\",\n              \"disableMobile\",\n          ];\n          var userConfig = __assign(__assign({}, JSON.parse(JSON.stringify(element.dataset || {}))), instanceConfig);\n          var formats = {};\n          self.config.parseDate = userConfig.parseDate;\n          self.config.formatDate = userConfig.formatDate;\n          Object.defineProperty(self.config, \"enable\", {\n              get: function () { return self.config._enable; },\n              set: function (dates) {\n                  self.config._enable = parseDateRules(dates);\n              },\n          });\n          Object.defineProperty(self.config, \"disable\", {\n              get: function () { return self.config._disable; },\n              set: function (dates) {\n                  self.config._disable = parseDateRules(dates);\n              },\n          });\n          var timeMode = userConfig.mode === \"time\";\n          if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {\n              var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;\n              formats.dateFormat =\n                  userConfig.noCalendar || timeMode\n                      ? \"H:i\" + (userConfig.enableSeconds ? \":S\" : \"\")\n                      : defaultDateFormat + \" H:i\" + (userConfig.enableSeconds ? \":S\" : \"\");\n          }\n          if (userConfig.altInput &&\n              (userConfig.enableTime || timeMode) &&\n              !userConfig.altFormat) {\n              var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;\n              formats.altFormat =\n                  userConfig.noCalendar || timeMode\n                      ? \"h:i\" + (userConfig.enableSeconds ? \":S K\" : \" K\")\n                      : defaultAltFormat + (\" h:i\" + (userConfig.enableSeconds ? \":S\" : \"\") + \" K\");\n          }\n          Object.defineProperty(self.config, \"minDate\", {\n              get: function () { return self.config._minDate; },\n              set: minMaxDateSetter(\"min\"),\n          });\n          Object.defineProperty(self.config, \"maxDate\", {\n              get: function () { return self.config._maxDate; },\n              set: minMaxDateSetter(\"max\"),\n          });\n          var minMaxTimeSetter = function (type) { return function (val) {\n              self.config[type === \"min\" ? \"_minTime\" : \"_maxTime\"] = self.parseDate(val, \"H:i:S\");\n          }; };\n          Object.defineProperty(self.config, \"minTime\", {\n              get: function () { return self.config._minTime; },\n              set: minMaxTimeSetter(\"min\"),\n          });\n          Object.defineProperty(self.config, \"maxTime\", {\n              get: function () { return self.config._maxTime; },\n              set: minMaxTimeSetter(\"max\"),\n          });\n          if (userConfig.mode === \"time\") {\n              self.config.noCalendar = true;\n              self.config.enableTime = true;\n          }\n          Object.assign(self.config, formats, userConfig);\n          for (var i = 0; i < boolOpts.length; i++)\n              // https://github.com/microsoft/TypeScript/issues/31663\n              self.config[boolOpts[i]] =\n                  self.config[boolOpts[i]] === true ||\n                      self.config[boolOpts[i]] === \"true\";\n          HOOKS.filter(function (hook) { return self.config[hook] !== undefined; }).forEach(function (hook) {\n              self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);\n          });\n          self.isMobile =\n              !self.config.disableMobile &&\n                  !self.config.inline &&\n                  self.config.mode === \"single\" &&\n                  !self.config.disable.length &&\n                  !self.config.enable &&\n                  !self.config.weekNumbers &&\n                  /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n          for (var i = 0; i < self.config.plugins.length; i++) {\n              var pluginConf = self.config.plugins[i](self) || {};\n              for (var key in pluginConf) {\n                  if (HOOKS.indexOf(key) > -1) {\n                      self.config[key] = arrayify(pluginConf[key])\n                          .map(bindToInstance)\n                          .concat(self.config[key]);\n                  }\n                  else if (typeof userConfig[key] === \"undefined\")\n                      self.config[key] = pluginConf[key];\n              }\n          }\n          if (!userConfig.altInputClass) {\n              self.config.altInputClass =\n                  getInputElem().className + \" \" + self.config.altInputClass;\n          }\n          triggerEvent(\"onParseConfig\");\n      }\n      function getInputElem() {\n          return self.config.wrap\n              ? element.querySelector(\"[data-input]\")\n              : element;\n      }\n      function setupLocale() {\n          if (typeof self.config.locale !== \"object\" &&\n              typeof flatpickr.l10ns[self.config.locale] === \"undefined\")\n              self.config.errorHandler(new Error(\"flatpickr: invalid locale \" + self.config.locale));\n          self.l10n = __assign(__assign({}, flatpickr.l10ns.default), (typeof self.config.locale === \"object\"\n              ? self.config.locale\n              : self.config.locale !== \"default\"\n                  ? flatpickr.l10ns[self.config.locale]\n                  : undefined));\n          tokenRegex.D = \"(\" + self.l10n.weekdays.shorthand.join(\"|\") + \")\";\n          tokenRegex.l = \"(\" + self.l10n.weekdays.longhand.join(\"|\") + \")\";\n          tokenRegex.M = \"(\" + self.l10n.months.shorthand.join(\"|\") + \")\";\n          tokenRegex.F = \"(\" + self.l10n.months.longhand.join(\"|\") + \")\";\n          tokenRegex.K = \"(\" + self.l10n.amPM[0] + \"|\" + self.l10n.amPM[1] + \"|\" + self.l10n.amPM[0].toLowerCase() + \"|\" + self.l10n.amPM[1].toLowerCase() + \")\";\n          var userConfig = __assign(__assign({}, instanceConfig), JSON.parse(JSON.stringify(element.dataset || {})));\n          if (userConfig.time_24hr === undefined &&\n              flatpickr.defaultConfig.time_24hr === undefined) {\n              self.config.time_24hr = self.l10n.time_24hr;\n          }\n          self.formatDate = createDateFormatter(self);\n          self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n      }\n      function positionCalendar(customPositionElement) {\n          if (typeof self.config.position === \"function\") {\n              return void self.config.position(self, customPositionElement);\n          }\n          if (self.calendarContainer === undefined)\n              return;\n          triggerEvent(\"onPreCalendarPosition\");\n          var positionElement = customPositionElement || self._positionElement;\n          var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, (function (acc, child) { return acc + child.offsetHeight; }), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(\" \"), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === \"above\" ||\n              (configPosVertical !== \"below\" &&\n                  distanceFromBottom < calendarHeight &&\n                  inputBounds.top > calendarHeight);\n          var top = window.pageYOffset +\n              inputBounds.top +\n              (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);\n          toggleClass(self.calendarContainer, \"arrowTop\", !showOnTop);\n          toggleClass(self.calendarContainer, \"arrowBottom\", showOnTop);\n          if (self.config.inline)\n              return;\n          var left = window.pageXOffset + inputBounds.left;\n          var isCenter = false;\n          var isRight = false;\n          if (configPosHorizontal === \"center\") {\n              left -= (calendarWidth - inputBounds.width) / 2;\n              isCenter = true;\n          }\n          else if (configPosHorizontal === \"right\") {\n              left -= calendarWidth - inputBounds.width;\n              isRight = true;\n          }\n          toggleClass(self.calendarContainer, \"arrowLeft\", !isCenter && !isRight);\n          toggleClass(self.calendarContainer, \"arrowCenter\", isCenter);\n          toggleClass(self.calendarContainer, \"arrowRight\", isRight);\n          var right = window.document.body.offsetWidth -\n              (window.pageXOffset + inputBounds.right);\n          var rightMost = left + calendarWidth > window.document.body.offsetWidth;\n          var centerMost = right + calendarWidth > window.document.body.offsetWidth;\n          toggleClass(self.calendarContainer, \"rightMost\", rightMost);\n          if (self.config.static)\n              return;\n          self.calendarContainer.style.top = top + \"px\";\n          if (!rightMost) {\n              self.calendarContainer.style.left = left + \"px\";\n              self.calendarContainer.style.right = \"auto\";\n          }\n          else if (!centerMost) {\n              self.calendarContainer.style.left = \"auto\";\n              self.calendarContainer.style.right = right + \"px\";\n          }\n          else {\n              var doc = getDocumentStyleSheet();\n              // some testing environments don't have css support\n              if (doc === undefined)\n                  return;\n              var bodyWidth = window.document.body.offsetWidth;\n              var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);\n              var centerBefore = \".flatpickr-calendar.centerMost:before\";\n              var centerAfter = \".flatpickr-calendar.centerMost:after\";\n              var centerIndex = doc.cssRules.length;\n              var centerStyle = \"{left:\" + inputBounds.left + \"px;right:auto;}\";\n              toggleClass(self.calendarContainer, \"rightMost\", false);\n              toggleClass(self.calendarContainer, \"centerMost\", true);\n              doc.insertRule(centerBefore + \",\" + centerAfter + centerStyle, centerIndex);\n              self.calendarContainer.style.left = centerLeft + \"px\";\n              self.calendarContainer.style.right = \"auto\";\n          }\n      }\n      function getDocumentStyleSheet() {\n          var editableSheet = null;\n          for (var i = 0; i < document.styleSheets.length; i++) {\n              var sheet = document.styleSheets[i];\n              if (!sheet.cssRules)\n                  continue;\n              try {\n                  sheet.cssRules;\n              }\n              catch (err) {\n                  continue;\n              }\n              editableSheet = sheet;\n              break;\n          }\n          return editableSheet != null ? editableSheet : createStyleSheet();\n      }\n      function createStyleSheet() {\n          var style = document.createElement(\"style\");\n          document.head.appendChild(style);\n          return style.sheet;\n      }\n      function redraw() {\n          if (self.config.noCalendar || self.isMobile)\n              return;\n          buildMonthSwitch();\n          updateNavigationCurrentMonth();\n          buildDays();\n      }\n      function focusAndClose() {\n          self._input.focus();\n          if (window.navigator.userAgent.indexOf(\"MSIE\") !== -1 ||\n              navigator.msMaxTouchPoints !== undefined) {\n              // hack - bugs in the way IE handles focus keeps the calendar open\n              setTimeout(self.close, 0);\n          }\n          else {\n              self.close();\n          }\n      }\n      function selectDate(e) {\n          e.preventDefault();\n          e.stopPropagation();\n          var isSelectable = function (day) {\n              return day.classList &&\n                  day.classList.contains(\"flatpickr-day\") &&\n                  !day.classList.contains(\"flatpickr-disabled\") &&\n                  !day.classList.contains(\"notAllowed\");\n          };\n          var t = findParent(getEventTarget(e), isSelectable);\n          if (t === undefined)\n              return;\n          var target = t;\n          var selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));\n          var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||\n              selectedDate.getMonth() >\n                  self.currentMonth + self.config.showMonths - 1) &&\n              self.config.mode !== \"range\";\n          self.selectedDateElem = target;\n          if (self.config.mode === \"single\")\n              self.selectedDates = [selectedDate];\n          else if (self.config.mode === \"multiple\") {\n              var selectedIndex = isDateSelected(selectedDate);\n              if (selectedIndex)\n                  self.selectedDates.splice(parseInt(selectedIndex), 1);\n              else\n                  self.selectedDates.push(selectedDate);\n          }\n          else if (self.config.mode === \"range\") {\n              if (self.selectedDates.length === 2) {\n                  self.clear(false, false);\n              }\n              self.latestSelectedDateObj = selectedDate;\n              self.selectedDates.push(selectedDate);\n              // unless selecting same date twice, sort ascendingly\n              if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)\n                  self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n          }\n          setHoursFromInputs();\n          if (shouldChangeMonth) {\n              var isNewYear = self.currentYear !== selectedDate.getFullYear();\n              self.currentYear = selectedDate.getFullYear();\n              self.currentMonth = selectedDate.getMonth();\n              if (isNewYear) {\n                  triggerEvent(\"onYearChange\");\n                  buildMonthSwitch();\n              }\n              triggerEvent(\"onMonthChange\");\n          }\n          updateNavigationCurrentMonth();\n          buildDays();\n          updateValue();\n          // maintain focus\n          if (!shouldChangeMonth &&\n              self.config.mode !== \"range\" &&\n              self.config.showMonths === 1)\n              focusOnDayElem(target);\n          else if (self.selectedDateElem !== undefined &&\n              self.hourElement === undefined) {\n              self.selectedDateElem && self.selectedDateElem.focus();\n          }\n          if (self.hourElement !== undefined)\n              self.hourElement !== undefined && self.hourElement.focus();\n          if (self.config.closeOnSelect) {\n              var single = self.config.mode === \"single\" && !self.config.enableTime;\n              var range = self.config.mode === \"range\" &&\n                  self.selectedDates.length === 2 &&\n                  !self.config.enableTime;\n              if (single || range) {\n                  focusAndClose();\n              }\n          }\n          triggerChange();\n      }\n      var CALLBACKS = {\n          locale: [setupLocale, updateWeekdays],\n          showMonths: [buildMonths, setCalendarWidth, buildWeekdays],\n          minDate: [jumpToDate],\n          maxDate: [jumpToDate],\n          positionElement: [updatePositionElement],\n          clickOpens: [\n              function () {\n                  if (self.config.clickOpens === true) {\n                      bind(self._input, \"focus\", self.open);\n                      bind(self._input, \"click\", self.open);\n                  }\n                  else {\n                      self._input.removeEventListener(\"focus\", self.open);\n                      self._input.removeEventListener(\"click\", self.open);\n                  }\n              },\n          ],\n      };\n      function set(option, value) {\n          if (option !== null && typeof option === \"object\") {\n              Object.assign(self.config, option);\n              for (var key in option) {\n                  if (CALLBACKS[key] !== undefined)\n                      CALLBACKS[key].forEach(function (x) { return x(); });\n              }\n          }\n          else {\n              self.config[option] = value;\n              if (CALLBACKS[option] !== undefined)\n                  CALLBACKS[option].forEach(function (x) { return x(); });\n              else if (HOOKS.indexOf(option) > -1)\n                  self.config[option] = arrayify(value);\n          }\n          self.redraw();\n          updateValue(true);\n      }\n      function setSelectedDate(inputDate, format) {\n          var dates = [];\n          if (inputDate instanceof Array)\n              dates = inputDate.map(function (d) { return self.parseDate(d, format); });\n          else if (inputDate instanceof Date || typeof inputDate === \"number\")\n              dates = [self.parseDate(inputDate, format)];\n          else if (typeof inputDate === \"string\") {\n              switch (self.config.mode) {\n                  case \"single\":\n                  case \"time\":\n                      dates = [self.parseDate(inputDate, format)];\n                      break;\n                  case \"multiple\":\n                      dates = inputDate\n                          .split(self.config.conjunction)\n                          .map(function (date) { return self.parseDate(date, format); });\n                      break;\n                  case \"range\":\n                      dates = inputDate\n                          .split(self.l10n.rangeSeparator)\n                          .map(function (date) { return self.parseDate(date, format); });\n                      break;\n              }\n          }\n          else\n              self.config.errorHandler(new Error(\"Invalid date supplied: \" + JSON.stringify(inputDate)));\n          self.selectedDates = (self.config.allowInvalidPreload\n              ? dates\n              : dates.filter(function (d) { return d instanceof Date && isEnabled(d, false); }));\n          if (self.config.mode === \"range\")\n              self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n      }\n      function setDate(date, triggerChange, format) {\n          if (triggerChange === void 0) { triggerChange = false; }\n          if (format === void 0) { format = self.config.dateFormat; }\n          if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))\n              return self.clear(triggerChange);\n          setSelectedDate(date, format);\n          self.latestSelectedDateObj =\n              self.selectedDates[self.selectedDates.length - 1];\n          self.redraw();\n          jumpToDate(undefined, triggerChange);\n          setHoursFromDate();\n          if (self.selectedDates.length === 0) {\n              self.clear(false);\n          }\n          updateValue(triggerChange);\n          if (triggerChange)\n              triggerEvent(\"onChange\");\n      }\n      function parseDateRules(arr) {\n          return arr\n              .slice()\n              .map(function (rule) {\n              if (typeof rule === \"string\" ||\n                  typeof rule === \"number\" ||\n                  rule instanceof Date) {\n                  return self.parseDate(rule, undefined, true);\n              }\n              else if (rule &&\n                  typeof rule === \"object\" &&\n                  rule.from &&\n                  rule.to)\n                  return {\n                      from: self.parseDate(rule.from, undefined),\n                      to: self.parseDate(rule.to, undefined),\n                  };\n              return rule;\n          })\n              .filter(function (x) { return x; }); // remove falsy values\n      }\n      function setupDates() {\n          self.selectedDates = [];\n          self.now = self.parseDate(self.config.now) || new Date();\n          // Workaround IE11 setting placeholder as the input's value\n          var preloadedDate = self.config.defaultDate ||\n              ((self.input.nodeName === \"INPUT\" ||\n                  self.input.nodeName === \"TEXTAREA\") &&\n                  self.input.placeholder &&\n                  self.input.value === self.input.placeholder\n                  ? null\n                  : self.input.value);\n          if (preloadedDate)\n              setSelectedDate(preloadedDate, self.config.dateFormat);\n          self._initialDate =\n              self.selectedDates.length > 0\n                  ? self.selectedDates[0]\n                  : self.config.minDate &&\n                      self.config.minDate.getTime() > self.now.getTime()\n                      ? self.config.minDate\n                      : self.config.maxDate &&\n                          self.config.maxDate.getTime() < self.now.getTime()\n                          ? self.config.maxDate\n                          : self.now;\n          self.currentYear = self._initialDate.getFullYear();\n          self.currentMonth = self._initialDate.getMonth();\n          if (self.selectedDates.length > 0)\n              self.latestSelectedDateObj = self.selectedDates[0];\n          if (self.config.minTime !== undefined)\n              self.config.minTime = self.parseDate(self.config.minTime, \"H:i\");\n          if (self.config.maxTime !== undefined)\n              self.config.maxTime = self.parseDate(self.config.maxTime, \"H:i\");\n          self.minDateHasTime =\n              !!self.config.minDate &&\n                  (self.config.minDate.getHours() > 0 ||\n                      self.config.minDate.getMinutes() > 0 ||\n                      self.config.minDate.getSeconds() > 0);\n          self.maxDateHasTime =\n              !!self.config.maxDate &&\n                  (self.config.maxDate.getHours() > 0 ||\n                      self.config.maxDate.getMinutes() > 0 ||\n                      self.config.maxDate.getSeconds() > 0);\n      }\n      function setupInputs() {\n          self.input = getInputElem();\n          /* istanbul ignore next */\n          if (!self.input) {\n              self.config.errorHandler(new Error(\"Invalid input element specified\"));\n              return;\n          }\n          // hack: store previous type to restore it after destroy()\n          self.input._type = self.input.type;\n          self.input.type = \"text\";\n          self.input.classList.add(\"flatpickr-input\");\n          self._input = self.input;\n          if (self.config.altInput) {\n              // replicate self.element\n              self.altInput = createElement(self.input.nodeName, self.config.altInputClass);\n              self._input = self.altInput;\n              self.altInput.placeholder = self.input.placeholder;\n              self.altInput.disabled = self.input.disabled;\n              self.altInput.required = self.input.required;\n              self.altInput.tabIndex = self.input.tabIndex;\n              self.altInput.type = \"text\";\n              self.input.setAttribute(\"type\", \"hidden\");\n              if (!self.config.static && self.input.parentNode)\n                  self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);\n          }\n          if (!self.config.allowInput)\n              self._input.setAttribute(\"readonly\", \"readonly\");\n          updatePositionElement();\n      }\n      function updatePositionElement() {\n          self._positionElement = self.config.positionElement || self._input;\n      }\n      function setupMobile() {\n          var inputType = self.config.enableTime\n              ? self.config.noCalendar\n                  ? \"time\"\n                  : \"datetime-local\"\n              : \"date\";\n          self.mobileInput = createElement(\"input\", self.input.className + \" flatpickr-mobile\");\n          self.mobileInput.tabIndex = 1;\n          self.mobileInput.type = inputType;\n          self.mobileInput.disabled = self.input.disabled;\n          self.mobileInput.required = self.input.required;\n          self.mobileInput.placeholder = self.input.placeholder;\n          self.mobileFormatStr =\n              inputType === \"datetime-local\"\n                  ? \"Y-m-d\\\\TH:i:S\"\n                  : inputType === \"date\"\n                      ? \"Y-m-d\"\n                      : \"H:i:S\";\n          if (self.selectedDates.length > 0) {\n              self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);\n          }\n          if (self.config.minDate)\n              self.mobileInput.min = self.formatDate(self.config.minDate, \"Y-m-d\");\n          if (self.config.maxDate)\n              self.mobileInput.max = self.formatDate(self.config.maxDate, \"Y-m-d\");\n          if (self.input.getAttribute(\"step\"))\n              self.mobileInput.step = String(self.input.getAttribute(\"step\"));\n          self.input.type = \"hidden\";\n          if (self.altInput !== undefined)\n              self.altInput.type = \"hidden\";\n          try {\n              if (self.input.parentNode)\n                  self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);\n          }\n          catch (_a) { }\n          bind(self.mobileInput, \"change\", function (e) {\n              self.setDate(getEventTarget(e).value, false, self.mobileFormatStr);\n              triggerEvent(\"onChange\");\n              triggerEvent(\"onClose\");\n          });\n      }\n      function toggle(e) {\n          if (self.isOpen === true)\n              return self.close();\n          self.open(e);\n      }\n      function triggerEvent(event, data) {\n          // If the instance has been destroyed already, all hooks have been removed\n          if (self.config === undefined)\n              return;\n          var hooks = self.config[event];\n          if (hooks !== undefined && hooks.length > 0) {\n              for (var i = 0; hooks[i] && i < hooks.length; i++)\n                  hooks[i](self.selectedDates, self.input.value, self, data);\n          }\n          if (event === \"onChange\") {\n              self.input.dispatchEvent(createEvent(\"change\"));\n              // many front-end frameworks bind to the input event\n              self.input.dispatchEvent(createEvent(\"input\"));\n          }\n      }\n      function createEvent(name) {\n          var e = document.createEvent(\"Event\");\n          e.initEvent(name, true, true);\n          return e;\n      }\n      function isDateSelected(date) {\n          for (var i = 0; i < self.selectedDates.length; i++) {\n              var selectedDate = self.selectedDates[i];\n              if (selectedDate instanceof Date &&\n                  compareDates(selectedDate, date) === 0)\n                  return \"\" + i;\n          }\n          return false;\n      }\n      function isDateInRange(date) {\n          if (self.config.mode !== \"range\" || self.selectedDates.length < 2)\n              return false;\n          return (compareDates(date, self.selectedDates[0]) >= 0 &&\n              compareDates(date, self.selectedDates[1]) <= 0);\n      }\n      function updateNavigationCurrentMonth() {\n          if (self.config.noCalendar || self.isMobile || !self.monthNav)\n              return;\n          self.yearElements.forEach(function (yearElement, i) {\n              var d = new Date(self.currentYear, self.currentMonth, 1);\n              d.setMonth(self.currentMonth + i);\n              if (self.config.showMonths > 1 ||\n                  self.config.monthSelectorType === \"static\") {\n                  self.monthElements[i].textContent =\n                      monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + \" \";\n              }\n              else {\n                  self.monthsDropdownContainer.value = d.getMonth().toString();\n              }\n              yearElement.value = d.getFullYear().toString();\n          });\n          self._hidePrevMonthArrow =\n              self.config.minDate !== undefined &&\n                  (self.currentYear === self.config.minDate.getFullYear()\n                      ? self.currentMonth <= self.config.minDate.getMonth()\n                      : self.currentYear < self.config.minDate.getFullYear());\n          self._hideNextMonthArrow =\n              self.config.maxDate !== undefined &&\n                  (self.currentYear === self.config.maxDate.getFullYear()\n                      ? self.currentMonth + 1 > self.config.maxDate.getMonth()\n                      : self.currentYear > self.config.maxDate.getFullYear());\n      }\n      function getDateStr(specificFormat) {\n          var format = specificFormat ||\n              (self.config.altInput ? self.config.altFormat : self.config.dateFormat);\n          return self.selectedDates\n              .map(function (dObj) { return self.formatDate(dObj, format); })\n              .filter(function (d, i, arr) {\n              return self.config.mode !== \"range\" ||\n                  self.config.enableTime ||\n                  arr.indexOf(d) === i;\n          })\n              .join(self.config.mode !== \"range\"\n              ? self.config.conjunction\n              : self.l10n.rangeSeparator);\n      }\n      /**\n       * Updates the values of inputs associated with the calendar\n       */\n      function updateValue(triggerChange) {\n          if (triggerChange === void 0) { triggerChange = true; }\n          if (self.mobileInput !== undefined && self.mobileFormatStr) {\n              self.mobileInput.value =\n                  self.latestSelectedDateObj !== undefined\n                      ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)\n                      : \"\";\n          }\n          self.input.value = getDateStr(self.config.dateFormat);\n          if (self.altInput !== undefined) {\n              self.altInput.value = getDateStr(self.config.altFormat);\n          }\n          if (triggerChange !== false)\n              triggerEvent(\"onValueUpdate\");\n      }\n      function onMonthNavClick(e) {\n          var eventTarget = getEventTarget(e);\n          var isPrevMonth = self.prevMonthNav.contains(eventTarget);\n          var isNextMonth = self.nextMonthNav.contains(eventTarget);\n          if (isPrevMonth || isNextMonth) {\n              changeMonth(isPrevMonth ? -1 : 1);\n          }\n          else if (self.yearElements.indexOf(eventTarget) >= 0) {\n              eventTarget.select();\n          }\n          else if (eventTarget.classList.contains(\"arrowUp\")) {\n              self.changeYear(self.currentYear + 1);\n          }\n          else if (eventTarget.classList.contains(\"arrowDown\")) {\n              self.changeYear(self.currentYear - 1);\n          }\n      }\n      function timeWrapper(e) {\n          e.preventDefault();\n          var isKeyDown = e.type === \"keydown\", eventTarget = getEventTarget(e), input = eventTarget;\n          if (self.amPM !== undefined && eventTarget === self.amPM) {\n              self.amPM.textContent =\n                  self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n          }\n          var min = parseFloat(input.getAttribute(\"min\")), max = parseFloat(input.getAttribute(\"max\")), step = parseFloat(input.getAttribute(\"step\")), curValue = parseInt(input.value, 10), delta = e.delta ||\n              (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);\n          var newValue = curValue + step * delta;\n          if (typeof input.value !== \"undefined\" && input.value.length === 2) {\n              var isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;\n              if (newValue < min) {\n                  newValue =\n                      max +\n                          newValue +\n                          int(!isHourElem) +\n                          (int(isHourElem) && int(!self.amPM));\n                  if (isMinuteElem)\n                      incrementNumInput(undefined, -1, self.hourElement);\n              }\n              else if (newValue > max) {\n                  newValue =\n                      input === self.hourElement ? newValue - max - int(!self.amPM) : min;\n                  if (isMinuteElem)\n                      incrementNumInput(undefined, 1, self.hourElement);\n              }\n              if (self.amPM &&\n                  isHourElem &&\n                  (step === 1\n                      ? newValue + curValue === 23\n                      : Math.abs(newValue - curValue) > step)) {\n                  self.amPM.textContent =\n                      self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n              }\n              input.value = pad(newValue);\n          }\n      }\n      init();\n      return self;\n  }\n  /* istanbul ignore next */\n  function _flatpickr(nodeList, config) {\n      // static list\n      var nodes = Array.prototype.slice\n          .call(nodeList)\n          .filter(function (x) { return x instanceof HTMLElement; });\n      var instances = [];\n      for (var i = 0; i < nodes.length; i++) {\n          var node = nodes[i];\n          try {\n              if (node.getAttribute(\"data-fp-omit\") !== null)\n                  continue;\n              if (node._flatpickr !== undefined) {\n                  node._flatpickr.destroy();\n                  node._flatpickr = undefined;\n              }\n              node._flatpickr = FlatpickrInstance(node, config || {});\n              instances.push(node._flatpickr);\n          }\n          catch (e) {\n              console.error(e);\n          }\n      }\n      return instances.length === 1 ? instances[0] : instances;\n  }\n  /* istanbul ignore next */\n  if (typeof HTMLElement !== \"undefined\" &&\n      typeof HTMLCollection !== \"undefined\" &&\n      typeof NodeList !== \"undefined\") {\n      // browser env\n      HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {\n          return _flatpickr(this, config);\n      };\n      HTMLElement.prototype.flatpickr = function (config) {\n          return _flatpickr([this], config);\n      };\n  }\n  /* istanbul ignore next */\n  var flatpickr = function (selector, config) {\n      if (typeof selector === \"string\") {\n          return _flatpickr(window.document.querySelectorAll(selector), config);\n      }\n      else if (selector instanceof Node) {\n          return _flatpickr([selector], config);\n      }\n      else {\n          return _flatpickr(selector, config);\n      }\n  };\n  /* istanbul ignore next */\n  flatpickr.defaultConfig = {};\n  flatpickr.l10ns = {\n      en: __assign({}, english),\n      default: __assign({}, english),\n  };\n  flatpickr.localize = function (l10n) {\n      flatpickr.l10ns.default = __assign(__assign({}, flatpickr.l10ns.default), l10n);\n  };\n  flatpickr.setDefaults = function (config) {\n      flatpickr.defaultConfig = __assign(__assign({}, flatpickr.defaultConfig), config);\n  };\n  flatpickr.parseDate = createDateParser({});\n  flatpickr.formatDate = createDateFormatter({});\n  flatpickr.compareDates = compareDates;\n  /* istanbul ignore next */\n  if (typeof jQuery !== \"undefined\" && typeof jQuery.fn !== \"undefined\") {\n      jQuery.fn.flatpickr = function (config) {\n          return _flatpickr(this, config);\n      };\n  }\n  Date.prototype.fp_incr = function (days) {\n      return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === \"string\" ? parseInt(days, 10) : days));\n  };\n  if (typeof window !== \"undefined\") {\n      window.flatpickr = flatpickr;\n  }\n\n  return flatpickr;\n\n})));","Webkul_AdvancedBookingSystem/js/tablebooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    \"Magento_Ui/js/modal/alert\",\n    \"mage/template\",\n    \"mage/translate\",\n    \"mage/calendar\",\n], function ($, alert, mageTemplate, $t) {\n    \"use strict\";\n\n\n    $(document).ready(function() {\n        $('.wk-bk-select-time-opt-wrapper').each(function() {\n            var $wrapper = $(this);\n            var isDown = false;\n            var startX;\n            var scrollLeft;\n\n            $wrapper.on('mousedown', function(e) {\n                isDown = true;\n                startX = e.pageX - $wrapper.offset().left;\n                scrollLeft = $wrapper.scrollLeft();\n                $wrapper.css('cursor', 'grabbing');\n            });\n\n            $wrapper.on('mouseleave mouseup', function() {\n                isDown = false;\n                $wrapper.css('cursor', 'grab');\n            });\n\n            $wrapper.on('mousemove', function(e) {\n                if (!isDown) return;\n                e.preventDefault();\n                var x = e.pageX - $wrapper.offset().left;\n                var walk = (x - startX) * 2;\n                $wrapper.scrollLeft(scrollLeft - walk);\n            });\n        });\n    });\n\n    const getDayNumberFromString = (dateString) => {\n        const date = new Date(dateString);\n        const day = date.getDay();\n        return day === 0 ? 7 : day;\n    };\n\n    const formatTimeWithSpace = (time) => {\n        if (!time) return \"\";\n        return time.replace(/(\\d{1,2}:\\d{2})([ap]m)/i, \"$1 $2\");\n    };\n\n    $.widget(\"tablebooking.tablebooking\", {\n        options: {},\n        _create: function () {\n            var self = this;\n            var monthArr = self.options.monthArr;\n            var todaySlotArr = self.options.todaySlotArr;\n            var options = JSON.parse(self.options.optionsJson);\n            var holidaysData = self.options.holidaysData;\n            var isTodayHoliday = self.options.isTodayHoliday;\n            const bookingSlotData = self.options.bookingSlotData;\n            $(\"#wk-bk-select-date\").datepicker({\n                dateFormat: \"mm/dd/yy\",\n                minDate: \"today\",\n                maxDate: self.options.bookingAvailableTo,\n                beforeShowDay: function (date) {\n                    let string = $.datepicker.formatDate(\"yy-mm-dd\", date);\n                    const day = getDayNumberFromString(date);\n                    let holiday = holidaysData[string];\n                    if (holiday || bookingSlotData[day] == \"\") {\n                        return [false, \"\", holiday];\n                    }\n                    return [true];\n                },\n            });\n            todaySlotArr.now = parseInt(Date.now() / 1000);\n            todaySlotArr.activeFirst = 0;\n            if (!isTodayHoliday) {\n                var progressTmpl = mageTemplate(\n                        \"#wk-bk-select-time-opt-template-today\"\n                    ),\n                    tmpl;\n                tmpl = progressTmpl({\n                    data: todaySlotArr,\n                });\n                $(\".wk-bk-select-time-opt-wrapper\").html(tmpl);\n            }\n            if (self.options.priceRangeText.length) {\n                $(\"#product-price-\" + self.options.productId).after(\n                    '<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">' +\n                        self.options.priceRangeText +\n                        \"</span>\"\n                );\n            }\n\n            // Establecer el tiempo seleccionado desde la URL\n            var urlParams = new URLSearchParams(window.location.search);\n            var selectedTimeFromURL = formatTimeWithSpace(urlParams.get('selected_time'));\n            var dayIndexFromURL = urlParams.get('day_index');\n            var slotIndexFromURL = urlParams.get('slot_index');\n\n            if (selectedTimeFromURL) {\n                $(\"#wk-bk-booking-time-field\").val(selectedTimeFromURL);\n                $(\".wk-bk-select-time-label\").text(selectedTimeFromURL);\n                $(\".wk-bk-slot-selected\").text(selectedTimeFromURL);\n            }\n\n            if (slotIndexFromURL) {\n                $(\".wk-bk-select-time-opt\").each(function() {\n                    if ($(this).data('slot-index') == slotIndexFromURL) {\n                        self._setProductOptions($(this), options);\n                    }\n                });\n            }\n\n            var initialSelectedTime = selectedTimeFromURL || $t(\"Closed\");\n            $(\"#wk-bk-booking-time-field\").val(initialSelectedTime);\n            $(\"#wk-bk-booking-time-field\")\n                .next(\".wk-bk-select-time-label\")\n                .text(initialSelectedTime);\n\n            // Aqu\u00ed verificamos si ya hay un tiempo seleccionado y evitamos sobrescribirlo\n            if (!selectedTimeFromURL) {\n                self._setProductOptions($(\".wk-bk-slot-selected\"), options);\n            }\n\n            $(\"body\").on(\"change\", \"#wk-bk-select-date\", function () {\n                var selectedDate = $(this).val();\n\n                var parsedDate = Date.parse(selectedDate, \"yyyy-MM-dd\");\n                var str = parsedDate.toString();\n                parsedDate = str.substr(0, str.length - 3);\n\n                var selectedDateArr = selectedDate.split(\"/\");\n                var day = selectedDateArr[1];\n                var month = selectedDateArr[0];\n                var year = selectedDateArr[2];\n                var formatedDate = day + \" \" + monthArr[month] + \", \" + year;\n                let optionDate = year + \"-\" + month + \"-\" + day;\n                var d = new Date(selectedDate);\n                var dayIndex = d.getDay();\n                if (dayIndex == 0) {\n                    dayIndex = 7;\n                }\n\n                var todayDate = new Date();\n                var tday = todayDate.getDate();\n                var tmonth = todayDate.getMonth() + 1;\n                var tyear = todayDate.getFullYear();\n                // if from selected date is today\n                if (day == tday && month == tmonth && year == tyear) {\n                    if (!isTodayHoliday) {\n                        var progressTmpl = mageTemplate(\n                                \"#wk-bk-select-time-opt-template-today\"\n                            ),\n                            tmpl;\n                        tmpl = progressTmpl({\n                            data: todaySlotArr,\n                        });\n                    }\n                } else {\n                    var progressTmpl = mageTemplate(\n                            \"#wk-bk-select-time-opt-template\" + dayIndex\n                        ),\n                        tmpl;\n                    tmpl = progressTmpl({\n                        data: {},\n                    });\n                }\n\n                $(\".wk-bk-select-time-opt-wrapper\").html(tmpl);\n\n                if (parsedDate in self.options.bookedData) {\n                    $.each(\n                        self.options.bookedData[parsedDate],\n                        function (key, value) {\n                            if (\n                                $(\".wk-bk-select-time-opt-wrapper\").find(\n                                    \".wk-bk-select-time-opt[data-type-time='\" +\n                                        key +\n                                        \"']\"\n                                ).length\n                            ) {\n                                var optTimeHtml = $(\n                                    \".wk-bk-select-time-opt-wrapper\"\n                                ).find(\n                                    \".wk-bk-select-time-opt[data-type-time='\" +\n                                        key +\n                                        \"']\"\n                                );\n                                var remainingQty =\n                                    optTimeHtml.data(\"slot-qty\") - value;\n                                if (remainingQty <= 0) {\n                                    optTimeHtml.removeClass(\n                                        \"wk-bk-slot-booked\"\n                                    );\n                                    optTimeHtml.removeClass(\n                                        \"wk-bk-slot-selected\"\n                                    );\n                                    optTimeHtml.addClass(\"wk-bk-slot-booked\");\n                                    $(\".wk-bk-select-time-opt-wrapper\")\n                                        .find(\n                                            \".wk-bk-select-time-opt[data-type-time='\" +\n                                                key +\n                                                \"']\"\n                                        )\n                                        .next()\n                                        .addClass(\"wk-bk-slot-selected\");\n                                }\n                            }\n                        }\n                    );\n                }\n\n                $(\".wk-bk-select-time-opt-wrapper\").removeAttr(\"style\");\n                var selectedTime = $(\".wk-bk-slot-selected\").text();\n                var isTimeClosed = false;\n                $(\"#wk-bk-booking-time-field\").val(selectedTime);\n                $(\"#wk-bk-slot-day-index\").val(\n                    $(\".wk-bk-slot-selected\").attr(\"data-day-index\")\n                );\n                $(\"#wk-bk-parent-slot-id\").val(\n                    $(\".wk-bk-slot-selected\").attr(\"data-index\")\n                );\n                $(\"#wk-bk-slot-id\").val(\n                    $(\".wk-bk-slot-selected\").attr(\"data-slot-index\")\n                );\n                if (!tmpl) {\n                    selectedTime = self.options.titleClosed;\n                    isTimeClosed = true;\n                    $(\".wk-bk-select-time-opt-wrapper\").attr(\n                        \"style\",\n                        \"display: none;\"\n                    );\n                }\n                if (selectedTime.length == 0) {\n                    selectedTime = self.options.titleClosed;\n                    isTimeClosed = true;\n                }\n                $(this).parents(\".wk-bk-dates-container\")\n                .find(\".wk-bk-select-time-label\")\n                .text(selectedTime);\n        \n                if (selectedTime) {\n                    $(this).parents(\".wk-bk-dates-container\")\n                        .find(\".wk-bk-select-time-label\").hide();\n                } else {\n                    $(this).parents(\".wk-bk-dates-container\")\n                        .find(\".wk-bk-select-time-label\")\n                        .show().text($t(\"Closed\"));\n                }\n\n                $(\".wk-bk-select-date-label\")\n                    .text(formatedDate)\n                    .attr(\"data-booking-date\", optionDate);\n                // var bookedDate = $('.wk-bk-select-date-label').text();\n                var bookedDate = $(\".wk-bk-select-date-label\").attr(\n                    \"data-booking-date\"\n                );\n                $.each(options, function (k, v) {\n                    if (v.title == \"Booking Date\") {\n                        if ($(\"#options_\" + v.id + \"_text\").length) {\n                            $(\"#options_\" + v.id + \"_text\").val(bookedDate);\n                        } else {\n                            $(\"#product-options-wrapper\")\n                                .find(\".fieldset\")\n                                .append(\n                                    $(\"<input>\")\n                                        .attr(\"type\", \"hidden\")\n                                        .attr(\"name\", \"options[\" + v.id + \"]\")\n                                        .attr(\"id\", \"options_\" + v.id + \"_text\")\n                                        .val(bookedDate)\n                                );\n                        }\n                    }\n                    if (v.title == \"Booking Slot\") {\n                        if (isTimeClosed) {\n                            selectedTime = \"\";\n                        }\n                        if ($(\"#options_\" + v.id + \"_text\").length) {\n                            $(\"#options_\" + v.id + \"_text\").val(selectedTime);\n                        } else {\n                            $(\"#product-options-wrapper\")\n                                .find(\".fieldset\")\n                                .append(\n                                    $(\"<input>\")\n                                        .attr(\"type\", \"hidden\")\n                                        .attr(\"name\", \"options[\" + v.id + \"]\")\n                                        .attr(\"id\", \"options_\" + v.id + \"_text\")\n                                        .val(selectedTime)\n                                );\n                        }\n                    }\n                });\n            });\n            $(\"body\").on(\"click\", \".wk-bk-select-time-opt\", function () {\n                if (!$(this).hasClass(\"wk-bk-slot-booked\")) {\n                    self._setProductOptions($(this), options);\n                }\n            });\n\n            $(document).on(\"click\", \".wk-book-now\", function (e) {\n                e.stopPropagation();\n                if ($(\"form#product_addtocart_form\").valid()) {\n                    if (self.options.chargedPerConfig == 1) {\n                        var selectedQty = $(\"form#product_addtocart_form\")\n                            .find(\"input[name='temp_qty']\")\n                            .val();\n                        var updatedQty = 1;\n                        if (self.options.stepSize > 1) {\n                            if (selectedQty % self.options.stepSize == 0) {\n                                updatedQty =\n                                    selectedQty / self.options.stepSize;\n                            } else {\n                                updatedQty =\n                                    selectedQty / self.options.stepSize;\n                                if (updatedQty < 1) {\n                                    updatedQty = updatedQty + 1;\n                                }\n                            }\n                        } else {\n                            updatedQty = selectedQty;\n                        }\n                        if (updatedQty > 0) {\n                            $(\"form#product_addtocart_form\")\n                                .find(\"input[name='qty']\")\n                                .val(parseInt(updatedQty));\n                            return true;\n                        } else {\n                            return false;\n                        }\n                    } else {\n                        return true;\n                    }\n                }\n            });\n        },\n\n        _setProductOptions: function (element, options) {\n            var thisObj = element;\n            var selectedTime = thisObj.attr(\"data-type-time\");\n            $(\".wk-bk-select-time-opt\").each(function () {\n                if ($(this).hasClass(\"wk-bk-slot-selected\")) {\n                    $(this).removeClass(\"wk-bk-slot-selected\");\n                }\n            });\n            thisObj\n                .parents(\".wk-bk-dates-right-container\")\n                .find(\".wk-bk-select-time-label\")\n                .text(selectedTime);\n            thisObj.addClass(\"wk-bk-slot-selected\");\n            $(\"#wk-bk-booking-time-field\").val(selectedTime);\n            $(\"#wk-bk-slot-day-index\").val(thisObj.attr(\"data-day-index\"));\n            $(\"#wk-bk-parent-slot-id\").val(thisObj.attr(\"data-index\"));\n            $(\"#wk-bk-slot-id\").val(thisObj.attr(\"data-slot-index\"));\n            var bookedDate = $(\".wk-bk-select-date-label\").attr(\n                \"data-booking-date\"\n            );\n            $.each(options, function (k, v) {\n                if (v.title == \"Booking Date\") {\n                    if ($(\"#options_\" + v.id + \"_text\").length) {\n                        $(\"#options_\" + v.id + \"_text\").val(bookedDate);\n                    } else {\n                        $(\"#product-options-wrapper\")\n                            .find(\".fieldset\")\n                            .append(\n                                $(\"<input>\")\n                                    .attr(\"type\", \"hidden\")\n                                    .attr(\"name\", \"options[\" + v.id + \"]\")\n                                    .attr(\"id\", \"options_\" + v.id + \"_text\")\n                                    .val(bookedDate)\n                            );\n                    }\n                }\n                if (v.title == \"Booking Slot\") {\n                    if ($(\"#options_\" + v.id + \"_text\").length) {\n                        $(\"#options_\" + v.id + \"_text\").val(selectedTime);\n                    } else {\n                        $(\"#product-options-wrapper\")\n                            .find(\".fieldset\")\n                            .append(\n                                $(\"<input>\")\n                                    .attr(\"type\", \"hidden\")\n                                    .attr(\"name\", \"options[\" + v.id + \"]\")\n                                    .attr(\"id\", \"options_\" + v.id + \"_text\")\n                                    .val(selectedTime)\n                            );\n                    }\n                }\n            });\n        },\n    });\n    return $.tablebooking.tablebooking;\n});\n","Webkul_AdvancedBookingSystem/js/nearby.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"mage/calendar\",\n    'domReady!'\n], function ($, alert, mageTemplate) {\n    'use strict';\n    $.widget('nearby.nearby', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var map;\n            var service;\n            var infowindow;\n            var pyrmont;\n            var origin;\n            var destination = \"\";\n            var places = [];\n            var searchStr1 = self.options.address;\n            \n            pyrmont = getCurrentLocation();\n            \n            setTimeout(function(){\n                initMapTextSearch(pyrmont, searchStr1);\n            },1200);\n\n            $(\"body\").on(\n                \"keypress\",\n                '.search-nearby-area [name=\"search-keyword\"]',\n                function (e) {\n                    if (e.which == 13) {\n                        var searchStr = $(this).val();\n                        initMapTextSearch(pyrmont, searchStr);\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                '.nearby-places .place-detail span.remove',\n                function () {\n                    $(this).parents('.nearby-places').remove()\n                }\n            );\n\n            function getCurrentLocation()\n            {\n                $.ajax(\n                    {\n                        url : self.options.google_map_api,\n                        'method' : 'POST',\n                        success: function (response) {\n                            var latitude = response.results[0].geometry.location.lat;\n                            var longitude = response.results[0].geometry.location.lng;\n                            origin = response.results[0].place_id;\n                            pyrmont = new google.maps.LatLng(latitude,longitude);\n                        }\n                    }\n                );\n            }\n\n            function initMapTextSearch(pyrmont, searchStr)\n            {\n\n                map = new google.maps.Map(\n                    document.getElementById('search-nearby-map'),\n                    {\n                        center: pyrmont,\n                        zoom: 15\n                    }\n                );\n\n                var request = {\n                    location: pyrmont,\n                    radius: '500',\n                    query: searchStr\n                };\n\n                infowindow = new google.maps.InfoWindow();\n                service = new google.maps.places.PlacesService(map);\n                service.textSearch(\n                    request,\n                    function (results, status) {\n                        if (status == google.maps.places.PlacesServiceStatus.OK) {\n                            destination = \"\";\n                            places = [];\n                            for (var i = 0; i < results.length; i++) {\n                                var place = results[i];\n                                places[i] = place.name;\n                                if (i==results.length-1) {\n                                    destination += \"place_id:\"+place.place_id;\n                                } else {\n                                    destination += \"place_id:\"+place.place_id + \"|\";\n                                }\n                                createMarker(place);\n                            }\n                            getDistanceAndTime(destination, places);\n                        }\n                    }\n                );\n            }\n\n            function initMapNearBy(pyrmont)\n            {\n\n                map = new google.maps.Map(\n                    document.getElementById('search-nearby-map'),\n                    {\n                        center: pyrmont,\n                        zoom: 15\n                    }\n                );\n\n                var request = {\n                    location: pyrmont,\n                    radius: '500',\n                    type: ['restaurant']\n                };\n\n                service = new google.maps.places.PlacesService(map);\n                service.nearbySearch(\n                    request,\n                    function (results, status) {\n                        if (status == google.maps.places.PlacesServiceStatus.OK) {\n                            for (var i = 0; i < results.length; i++) {\n                                var place = results[i];\n                                createMarker(results[i]);\n                            }\n                        }\n                    }\n                );\n            }\n\n            function createMarker(place)\n            {\n                var placeLoc = place.geometry.location;\n                var marker = new google.maps.Marker(\n                    {\n                        map: map,\n                        position: place.geometry.location\n                    }\n                );\n\n                google.maps.event.addListener(\n                    marker,\n                    'click',\n                    function () {\n                        infowindow.setContent(place.name);\n                        infowindow.open(map, this);\n                    }\n                );\n            }\n\n            function getDistanceAndTime(destination, places)\n            {\n                $.ajax(\n                    {\n                        url : self.options.distance_url,\n                        method : 'POST',\n                        data : {\n                            origins : \"place_id:\"+origin,\n                            destinations : destination,\n                            key : self.options.google_api_key,\n                            places: places\n                        },\n                        dataType: 'json',\n                        success: function (response) {\n                            if (response.length) {\n                                $('.search-nearby-result').html(\"\");\n                                $.each(\n                                    response,\n                                    function (idx, val) {\n                                        var progressTmpl = mageTemplate('#search-nearby-result-template'),\n                                        tmpl;\n                                        tmpl = progressTmpl(\n                                            {\n                                                data: {\n                                                    name: val.name,\n                                                    distance: val.distance+\"(\"+val.duration+\")\"\n                                                }\n                                            }\n                                        );\n                                        $('.search-nearby-result').append(tmpl);\n                                    }\n                                );\n                            }\n                        },\n                        error: function (response) {\n                        }\n                    }\n                );\n            }\n        }\n    });\n    return $.nearby.nearby;\n});\n","Webkul_AdvancedBookingSystem/js/rentalbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"moment\",\n    \"mage/calendar\"\n], function ($, alert, mageTemplate, moment) {\n    'use strict';\n    $.widget(\n        'rentalbooking.rentalbooking',\n        {\n            options: {\n            },\n            _create: function () {\n                var self = this;\n                var monthArr = self.options.monthArr;\n                var rentTypeArr = self.options.rentTypeArr;\n                var unvailableDates = self.options.hourlyUnavailableDates;\n                var holidaysData = self.options.holidaysData;\n                var dateFormat = \"mm/dd/yy\";\n                $('.wk-bk-rent-type-option').each(function () {\n                    if (this.checked) {\n                        $('#wk-bk-select-slot').html('');\n                        $('#wk-bk-select-time').html('');\n                        if (parseInt($(this).val()) == parseInt(rentTypeArr['d'])) {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-daily'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this));\n                                }),\n                            bookingDateTo = $(\"#wk-bk-select-to-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this));\n                                });\n                        } else {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-hourly'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                            .datepicker({\n                                minDate: self.options.bookingAvailableFrom,\n                                maxDate: self.options.bookingAvailableTo,\n                                beforeShowDay: function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                                    if(isDisabled){\n                                        return [!isDisabled];\n                                    }\n                                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                                    let holiday = holidaysData[string];\n                                    if(holiday){\n                                        return [false,'',holiday];\n                                    }\n                                    return [true];\n                                },\n                                onSelect: function () {\n                                    getBookingDate(this);\n                                }\n                            });\n                        }\n                    }\n                });\n           \n                function getBookingDate(element)\n                {\n                    var date;\n                    try {\n                        date = $.datepicker.parseDate(dateFormat, element.value);\n                        var selectedDate  = $(element).val();\n                        var selectedDateArr  = selectedDate.split('/');\n                        var day = selectedDateArr[1];\n                        var month = selectedDateArr[0];\n                        var year = selectedDateArr[2];\n                        var formatedDate = day+\" \"+monthArr[month]+\", \"+year;\n                        let optionDate = year+\"-\"+month+\"-\"+day;\n                        var d = new Date(selectedDate);\n                        var dayIndex = d.getDay();\n                        if (!dayIndex) {\n                            dayIndex = 7;\n                        }\n\n                        $(element)\n                            .parents('.wk-bk-dates-wrapper')\n                            .find('.wk-bk-select-date-label').text(formatedDate).attr('data-booking-date', optionDate);\n\n                        var rentType = $(\".wk-bk-rent-type-option:input[type='radio']:checked\").val();\n                        if (parseInt(rentTypeArr['d']) == parseInt(rentType)) {\n                            $(element)\n                                .parents('.wk-bk-dates-wrapper')\n                                .find('.wk-bk-date-option').val(optionDate);\n                        } else {\n                            if ($('#wk-bk-select-from-date').val()) {\n                                var fromDate = new Date($('#wk-bk-select-from-date').val());\n                                var fday = fromDate.getDate();\n                                var fmonth = fromDate.getMonth() + 1;\n                                var fyear = fromDate.getFullYear();\n\n                                var todayDate = new Date();\n                                var tday = todayDate.getDate();\n                                var tmonth = todayDate.getMonth() + 1;\n                                var tyear = todayDate.getFullYear();\n                                // if from selected date is today\n                                if (fday == tday && fmonth == tmonth && fyear == tyear) {\n                                    var progressTmpl = mageTemplate('#wk-bk-select-slot-template-today'),\n                                    tmpl;\n                                    tmpl = progressTmpl({\n                                        data: {}\n                                    });\n                                } else {\n                                    var progressTmpl = mageTemplate('#wk-bk-select-slot-template-'+dayIndex),\n                                    tmpl;\n                                    tmpl = progressTmpl({\n                                        data: {}\n                                    });\n                                }\n                                $('#wk-bk-select-slot').html(tmpl);\n                            } else {\n                                $('#wk-bk-select-slot').html('');\n                            }\n                            $('#wk-bk-select-time').html('');\n                        }\n                    } catch (error) {\n                        date = null;\n                    }\n                    return date;\n                }\n                $(\"body\").on('change', '.wk-bk-rent-type-option', function () {\n                    if (this.checked) {\n                        $('#wk-bk-select-slot').html('');\n                        $('#wk-bk-select-time').html('');\n                        if (parseInt($(this).val()) == parseInt(rentTypeArr['d'])) {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-daily'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this));\n                                }),\n                            bookingDateTo = $(\"#wk-bk-select-to-date\")\n                                .datepicker({\n                                    minDate: self.options.bookingAvailableFrom,\n                                    maxDate: self.options.bookingAvailableTo,\n                                })\n                                .on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this));\n                                });\n                        } else {\n                            var progressTmpl = mageTemplate('#wk-bk-select-date-template-hourly'),\n                            tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-select-date').html(tmpl);\n                            var bookingDateFrom = $(\"#wk-bk-select-from-date\")\n                            .datepicker({\n                                minDate: self.options.bookingAvailableFrom,\n                                maxDate: self.options.bookingAvailableTo,\n                                beforeShowDay: function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                                    if(isDisabled){\n                                        return [!isDisabled];\n                                    }\n                                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                                    let holiday = holidaysData[string];\n                                    if(holiday){\n                                        return [false,'',holiday];\n                                    }\n                                    return [true];\n                                },\n                                onSelect: function () {\n                                    getBookingDate(this);\n                                }\n                            });\n                        }\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-parent-slot-id', function () {\n                    $('#wk-bk-from-date-option').val('');\n                    $('#wk-bk-to-date-option').val('');\n                    if ($(this).val()) {\n                        var dayIndex = $('#wk-bk-slot-day-index').val();\n                        var slotIndex = $(this).val();\n                        var progressTmpl = mageTemplate('#wk-bk-select-time-template'),\n                        tmpl;\n                        tmpl = progressTmpl({\n                            data: {}\n                        });\n                        $('#wk-bk-select-time').html(tmpl);\n                        var formattedDate = moment($('#wk-bk-select-from-date').val()).format('YYYY-MM-DD');\n                        var fromDate = new Date(formattedDate);\n                        var fday = fromDate.getDate();\n                        var fmonth = fromDate.getMonth() + 1;\n                        var fyear = fromDate.getFullYear();\n\n                        var todayDate = new Date();\n                        var tday = todayDate.getDate();\n                        var tmonth = todayDate.getMonth() + 1;\n                        var tyear = todayDate.getFullYear();\n                        // if from selected date is today\n                        if (fday == tday && fmonth == tmonth && fyear == tyear) {\n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-from-time-opt-template-today'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-from-time').html(progressTmpl);\n                            let currentTimeString = parseInt(Date.now()/1000);\n                            $('#wk-bk-from-time > option').each(function() {\n                                if ($(this).val() != '' && currentTimeString >= parseInt($(this).data('time'))) {\n                                    $(this).attr('disabled', 'disabled');\n                                }\n                            });\n    \n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-to-time-opt-template-today'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-to-time').html(progressTmpl);\n                        } else {\n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-from-time-opt-template'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-from-time').html(progressTmpl);\n    \n                            var progressTmpl = mageTemplate(\n                                '#wk-bk-select-to-time-opt-template'+dayIndex+slotIndex\n                            ), tmpl;\n                            tmpl = progressTmpl({\n                                data: {}\n                            });\n                            $('#wk-bk-to-time').html(progressTmpl);\n                        }\n\n                        $('#wk-bk-to-time').attr('disabled', 'disabled');\n                    } else {\n                        $('#wk-bk-select-time').html('');\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-from-time', function () {\n                    var thisObj = $(this);\n                    $('#wk-bk-to-time').removeAttr('disabled');\n                    $(\"#wk-bk-from-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    $(\"#wk-bk-to-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    if (thisObj.val()) {\n                        $('#wk-bk-slot-id').val(thisObj.val());\n                        if (thisObj.val() && $('#wk-bk-to-time').val()) {\n                            if (parseInt(thisObj.val()) >= parseInt($('#wk-bk-to-time').val())) {\n                                thisObj.val('');\n                                $('#wk-bk-from-date-option').val('');\n                            } else {\n                                var currentDate = $('#wk-bk-select-from-date')\n                                .parents('.wk-bk-dates-wrapper')\n                                .find('.wk-bk-select-date-label').attr('data-booking-date');\n                                var currentFromDate = currentDate;\n                                var currentToDate = currentDate;\n                                var currentFromTime = $(\"#wk-bk-from-time option:selected\").text();\n                                if (currentFromTime && currentFromTime!=0) {\n                                    currentFromDate = currentDate+' '+currentFromTime;\n                                }\n                                $('#wk-bk-from-date-option').val(currentFromDate);\n                                var currentToTime = $(\"#wk-bk-to-time option:selected\").text();\n                                if (currentToTime && currentToTime!=0) {\n                                    currentToDate = currentDate+' '+currentToTime;\n                                }\n                                $('#wk-bk-to-date-option').val(currentToDate);\n                            }\n                        }\n                        $(\"#wk-bk-to-time option\").each(function () {\n                            if (parseInt(this.value) <= parseInt(thisObj.val())) {\n                                this.disabled = true;\n                            }\n                        });\n                    } else {\n                        $('#wk-bk-slot-id').val('');\n                        $('#wk-bk-to-time').val('');\n                        $('#wk-bk-to-date-option').val('');\n                        $('#wk-bk-to-time').attr('disabled', 'disabled');\n                    }\n                });\n                $(\"body\").on('change', '#wk-bk-to-time', function () {\n                    var thisObj = $(this);\n                    $('#wk-bk-to-time').removeAttr('disabled');\n                    $(\"#wk-bk-from-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    $(\"#wk-bk-to-time option\").each(function () {\n                        this.disabled = false;\n                    });\n                    if (thisObj.val() && $('#wk-bk-from-time').val()) {\n                        if (parseInt(thisObj.val()) <= parseInt($('#wk-bk-from-time').val())) {\n                            thisObj.val('');\n                            $('#wk-bk-to-date-option').val('');\n                        } else {\n                            var currentDate = $('#wk-bk-select-from-date')\n                            .parents('.wk-bk-dates-wrapper')\n                            .find('.wk-bk-select-date-label').attr('data-booking-date');\n                            var currentFromDate = currentDate;\n                            var currentToDate = currentDate;\n                            var currentFromTime = $(\"#wk-bk-from-time option:selected\").text();\n                            if (currentFromTime && currentFromTime!=0) {\n                                currentFromDate = currentDate+' '+currentFromTime;\n                            }\n                            $('#wk-bk-from-date-option').val(currentFromDate);\n                            var currentToTime = $(\"#wk-bk-to-time option:selected\").text();\n                            if (currentToTime && currentToTime!=0) {\n                                currentToDate = currentDate+' '+currentToTime;\n                            }\n                            $('#wk-bk-to-date-option').val(currentToDate);\n                        }\n                        $(\"#wk-bk-from-time option\").each(function () {\n                            if (parseInt(this.value) >= parseInt(thisObj.val())) {\n                                this.disabled = true;\n                            }\n                        });\n                    } else {\n                        $('#wk-bk-slot-id').val('');\n                        $('#wk-bk-to-time').val('');\n                        $('#wk-bk-to-date-option').val('');\n                        if (!$('#wk-bk-from-time').val()) {\n                            $('#wk-bk-to-time').attr('disabled', 'disabled');\n                        }\n                    }\n                });\n            }\n        }\n    );\n    return $.rentalbooking.rentalbooking;\n});\n","Webkul_AdvancedBookingSystem/js/bookingsystem.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'mage/translate',\n    'Magento_Ui/js/modal/alert',\n    \"jquery/ui\",\n], function ($, $t, alert) {\n    'use strict';\n    $.widget('bookingsystem.bookingsystem', {\n        options: {},\n        _create: function () {\n            var self = this;\n            var bookingInfoArray = self.options.bookingInfoArray;\n            if (bookingInfoArray !== undefined) {\n                $(\".products .product-items.list > li.product-item, .wishlist ol.product-items > li.product-item, .table-comparison .cell.product\").each(\n                    function () {\n                        if ($(this).find(\".product-item-link\").length) {\n                            var productLink = $(this).find(\".product-item-link\").attr(\"href\");\n                        } else if ($(this).find(\"a.product-item-photo\").length) {\n                            var productLink = $(this).find(\"a.product-item-photo\").attr(\"href\");\n                        } else {\n                            var productLink = \"\";\n                        }\n                        if (bookingInfoArray[productLink] !== undefined && bookingInfoArray[productLink]['booking'] == 1) {\n                            var buttonLabel = \"\";\n                            if (bookingInfoArray[productLink]['booking_type'] == \"event\") {\n                                buttonLabel = $t(\"Buy Tickets\");\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            } else if (bookingInfoArray[productLink]['booking_type'] == \"rental\") {\n                                buttonLabel = $t(\"Rent Now\");\n                                if (bookingInfoArray[productLink]['rent_type_text']) {\n                                    setRentTypeLabel($(this), bookingInfoArray[productLink]['rent_type_text']);\n                                }\n                            }\n                            if (bookingInfoArray[productLink]['booking_type'] == \"appointment\") {\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            }\n                            if (bookingInfoArray[productLink]['booking_type'] == \"default\") {\n                                if (bookingInfoArray[productLink]['expired']) {\n                                    setExpiredBookingLabel($(this));\n                                }\n                            }\n                            setBookingLabel($(this), buttonLabel);\n                        }\n                    }\n                );\n            }\n            $(document).ready(\n                function () {\n                    var slots = self.options.slots;\n                    var parentId = self.options.parentId;\n                    setTimeout(\n                        function () {\n                            if (bookingInfoArray !== undefined) {\n                                $(\".block-wishlist .product-items > li.product-item\").each(\n                                    function () {\n                                        if ($(this).find(\"a.product-item-link\").length) {\n                                            var productLink = $(this).find(\"a.product-item-link\").attr(\"href\");\n                                        } else if ($(this).find(\"a.product-item-photo\").length) {\n                                            var productLink = $(this).find(\"a.product-item-photo\").attr(\"href\");\n                                        } else {\n                                            var productLink = \"\";\n                                        }\n                                        if (bookingInfoArray[productLink] !== undefined && bookingInfoArray[productLink]['booking'] == 1) {\n                                            var buttonLabel = \"\";\n                                            if (bookingInfoArray[productLink]['booking_type'] == \"event\") {\n                                                buttonLabel = $t(\"Buy Tickets\");\n                                            } else if (bookingInfoArray[productLink]['booking_type'] == \"rental\") {\n                                                buttonLabel = $t(\"Rent Now\");\n                                            }\n                                            setBookingLabel($(this), buttonLabel);\n                                        }\n                                    }\n                                );\n                            }\n                        },\n                        1000\n                    );\n\n\n                    $(document).on(\n                        'click',\n                        '.wk-book-now',\n                        function () {\n                            showPanel();\n                            var d = new Date();\n                            var curr_date = d.getDate();\n                            var curr_month = d.getMonth() + 1;\n                            if (curr_month < 10) {\n                                curr_month = '0' + curr_month;\n                            }\n                            if (curr_date < 10) {\n                                curr_date = '0' + curr_date;\n                            }\n                            var curr_year = d.getFullYear();\n                            var todayDate = curr_year + \"-\" + curr_month + \"-\" + curr_date;\n\n                            var todayElemnt = $(\".wk-calendar-container\").find('.wk-calendar-col').find('.wk-calendar-cell[data-date=' + todayDate + ']');\n\n                            if (todayElemnt.length) {\n                                if ($(todayElemnt).hasClass('slot-available')) {\n                                    var date = todayElemnt.attr(\"data-date\");\n                                    $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                    todayElemnt.addClass('active');\n                                    loadSlotsData(date);\n                                } else {\n                                    if ($('.wk-calendar-container .wk-calendar-col .slot-available').first().length) {\n                                        var date = $('.wk-calendar-container .wk-calendar-col .slot-available').first().attr(\"data-date\");\n                                        $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                        $('.wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');\n                                        loadSlotsData(date);\n                                    }\n                                }\n                            } else {\n                                if ($('.wk-calendar-container .wk-calendar-col .slot-available').first().length) {\n                                    var date = $('.wk-calendar-container .wk-calendar-col .slot-available').first().attr(\"data-date\");\n                                    $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                    $('.wk-calendar-container .wk-calendar-col .slot-available').first().addClass('active');\n                                    loadSlotsData(date);\n                                }\n                            }\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-close',\n                        function () {\n                            hidePanel();\n                            $(\".wk-calendar-container\").animate(\n                                { 'margin-left': '0px' },\n                                500,\n                                function () {\n                                    if ($(\"body .modal-popup.confirm\").is(\":visible\")) {\n                                        $(\"body .modal-popup.confirm\").find(\".action-close\").trigger(\"click\");\n                                    }\n                                }\n                            );\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-available-day',\n                        function (event) {\n                            if ($(this).hasClass('slot-available')) {\n                                var date = $(this).attr(\"data-date\");\n                                $('.wk-calendar-container .wk-calendar-col .wk-available-day.active').removeClass('active');\n                                $(this).addClass('active');\n                                loadSlotsData(date);\n                            }\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-next-cal',\n                        function (event) {\n                            var currentCalendar = $(this).parent().parent();\n                            currentCalendar.hide();\n                            currentCalendar.next().show();\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-previous-cal',\n                        function (event) {\n                            var currentCalendar = $(this).parent().parent();\n                            currentCalendar.hide();\n                            currentCalendar.prev().show();\n                        }\n                    );\n                    $(document).on(\n                        'click',\n                        '.wk-book',\n                        function (event) {\n                            var formData;\n                            showLoader();\n                            event.preventDefault();\n                            if (!$('.booked-slot-summary').is(':empty')) {\n                                $.each(\n                                    $('.booked-slot-summary').find('.booked-short-history'),\n                                    function (k, v) {\n                                        $(this).data('booked-slot-id')\n\n                                        var qty = $(this).children('input').val();\n                                        var id = $(this).data('booked-slot-id');\n                                        var info = slots[id];\n                                        var option = {};\n                                        formData = new FormData(jQuery('form#product_addtocart_form')[0]);\n                                        formData.append('slot_id', id);\n                                        formData.append('qty', qty);\n\n                                        $.each(\n                                            self.options.options,\n                                            function (k, v) {\n                                                if (v.title == 'Booking From') {\n                                                    formData.append('options['+v.id+']', info['booking_from']);\n                                                }\n                                                if (v.title == 'Booking Till') {\n                                                    formData.append('options['+v.id+']', info['booking_to']);\n                                                }\n                                            }\n                                        );\n                                        $.ajax(\n                                            {\n                                                url: self.options.cartUrl,\n                                                type: 'POST',\n                                                data: formData,\n                                                dataType: 'json',\n                                                cache: false,\n                                                contentType: false,\n                                                processData: false,\n                                                success: function (data) {\n                                                    if (!$('.booked-slot-summary').is(':empty')) {\n                                                        $('.booked-slot-summary .booked-short-history').remove();\n                                                        $(\"body\").find('.wk-slots-summary-wrapper').hide();\n                                                    }\n                                                    hideLoader();\n                                                    $(\".wk-close\").trigger(\"click\");\n                                                },\n                                                error: function (resp) {\n                                                }\n                                            }\n                                        );\n                                    }\n                                );\n                            }\n                        }\n                    );\n\n                    $(document).on(\n                        'input',\n                        '.wk-qty',\n                        function (event) {\n                            var qtyBox = $(this);\n                            var regex = /^[0-9]*(?:\\.\\d{1,2})?$/; // allow only numbers [0-9]\n                            var qty = qtyBox.val();\n                            var id = qtyBox.attr(\"data-id\");\n                            var info = slots[id];\n                            var option = {};\n                            var cond = true;\n                            var updatedQty = qtyBox.next('.wk-qty-booked-hide').val();\n\n                            if (qty == 0) {\n                                cond = false;\n                                removeSelectedSlot(qtyBox, id);\n                                alert({\n                                    content: $t('Please enter a value greater than 0')\n                                });\n                                return false;\n                            } else if (!regex.test(qty) || qty == \"\") {\n                                cond = false;\n                                alert({\n                                    content: $t('Please enter a numeric value and is greater than 0')\n                                });\n                            } else if (cond && (parseInt(info['qty']) < qty || updatedQty >= parseInt(info['qty']))) {\n                                cond = false;\n                                alert({\n                                    content: $t('Quantity not available for this slot')\n                                });\n                                qtyBox.val(0);\n                            }\n\n                            if (cond && qty > 0) {\n                                $.each(\n                                    self.options.options,\n                                    function (k, v) {\n                                        if (v.title == 'Booking From') {\n                                            option[v.id] = info['booking_from'];\n                                        }\n                                        if (v.title == 'Booking Till') {\n                                            option[v.id] = info['booking_to'];\n                                        }\n                                    }\n                                );\n\n                                qtyBox.prev('.wk-booked-txt').text($t(\"Selected\"));\n                                updatedQty = parseInt(qty);\n                                qtyBox.next('.wk-qty-booked-hide').val(updatedQty);\n\n                                var remainingQty = parseInt(info['qty']);\n                                if (remainingQty >= parseInt(qty)) {\n                                    remainingQty -= parseInt(qty);\n                                    qtyBox.parent().siblings('.wk-col.middle').find('.wk-avl-text').next().text(remainingQty);\n                                }\n\n                                // if (self.options.booking_type == 2) {\n                                var bookingFrom = info['booking_from'];\n                                var bookingTo = info['booking_to'];\n                                // } else {\n                                //     var bookingFrom = info['booking_from'].split(\",\")[1];\n                                //     var bookingTo = info['booking_to'].split(\",\")[1];\n                                // }\n\n                                if ($('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']').length) {\n                                    $('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']')\n                                        .children('span')\n                                        .text($t(updatedQty + \" slot is selected for booking between \" + bookingFrom + \" to \" + bookingTo));\n                                    $('.wk-modal-foot').find('.booked-slot-summary').find('div[data-booked-slot-id=' + id + ']')\n                                        .children('input')\n                                        .val(updatedQty);\n                                } else {\n                                    $('.wk-modal-foot').find('.booked-slot-summary')\n                                        .prepend(\n                                            $('<div>')\n                                                .attr('data-booked-slot-id', id)\n                                                .addClass('booked-short-history')\n                                                .append(\n                                                    $('<input>').attr('type', 'hidden').attr('name', 'booked_qty').val(updatedQty),\n                                                    $('<span>').text($t(updatedQty + \" slot is selected for booking between \" + bookingFrom + \" to \" + bookingTo)),\n                                                    $('<a>').addClass('remove-slot')\n                                                )\n                                        );\n                                }\n                                $('.wk-slots-summary-wrapper').show();\n                            } else if (cond && qty == 0 && (event.keyCode == 8 || event.keyCode == 46)) {\n                                removeSelectedSlot(qtyBox, id);\n                            }\n                        }\n                    );\n                    function removeSelectedSlot(quantityBox, id)\n                    {\n                        if ($(\"body\").find(\".booked-slot-summary\").find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")) {\n                            if (quantityBox.length) {\n                                var bookedQty = $(\"body\")\n                                    .find(\".booked-slot-summary\")\n                                    .find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")\n                                    .children('input').val();\n                                quantityBox.val(0);\n                                quantityBox.siblings('.wk-booked-txt').text($t('your need'));\n                                quantityBox.siblings('.wk-qty-booked-hide').val(0);\n                                var availableQty = quantityBox.parent()\n                                    .siblings('.middle')\n                                    .find('.wk-label-avl-qty .wk-avl-text')\n                                    .next().text();\n                                availableQty = parseInt(availableQty) + parseInt(bookedQty);\n                                if (availableQty >= 0) {\n                                    var availableQty = quantityBox.parent()\n                                        .siblings('.middle')\n                                        .find('.wk-label-avl-qty .wk-avl-text')\n                                        .next().text(availableQty);\n                                }\n                            }\n                            $(\"body\")\n                                .find(\".booked-slot-summary\")\n                                .find(\".booked-short-history[data-booked-slot-id=\" + id + \"]\")\n                                .remove();\n                            if ($(\"body\").find(\".booked-slot-summary\").is(':empty')) {\n                                $(\"body\").find('.wk-slots-summary-wrapper').hide();\n                            }\n                        }\n                    }\n                    $(document).on(\n                        'click',\n                        '.remove-slot',\n                        function (event) {\n                            var dicisionapp = confirm($t('Are you Sure you Want To remove this slot'));\n                            if (dicisionapp == true) {\n                                var bookedSlotId = $(this).parent().data('booked-slot-id');\n                                var bookedQty = $(this).siblings('input').val();\n                                if ($('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').length) {\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').val(0);\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').siblings('.wk-booked-txt').text($t('your need'));\n                                    $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]').siblings('.wk-qty-booked-hide').val(0);\n                                    var availableQty = $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]')\n                                        .parent()\n                                        .siblings('.middle')\n                                        .find('.wk-label-avl-qty .wk-avl-text')\n                                        .next().text();\n                                    availableQty = parseInt(availableQty) + parseInt(bookedQty);\n                                    if (availableQty >= 0) {\n                                        var availableQty = $('.wk-day-container').find('.wk-qty[data-id=\"' + bookedSlotId + '\"]')\n                                            .parent()\n                                            .siblings('.middle')\n                                            .find('.wk-label-avl-qty .wk-avl-text')\n                                            .next().text(availableQty);\n                                    }\n                                }\n                                $(this).parent().remove();\n                                if ($('.booked-slot-summary').is(':empty')) {\n                                    $('.wk-slots-summary-wrapper').hide();\n                                }\n                            }\n                        }\n                    );\n                }\n            );\n            function setBookingLabel(element, buttonLabel)\n            {\n                if (buttonLabel == \"\") {\n                    buttonLabel = $t('Book Now');\n                }\n                element.find(\".action.tocart.primary\").attr(\"title\", buttonLabel);\n                element.find(\".action.tocart.primary\").find(\"span\").text(buttonLabel);\n            }\n\n            function setExpiredBookingLabel(element)\n            {\n                element.find(\".action.tocart.primary\").hide();\n                element.find(\".actions-primary\").find('label.event-expired').remove();\n                element.find(\".action.tocart.primary\").after(\n                    $('<label>').addClass('event-expired').css(\"color\", \"red\").text($t(\"Expired\"))\n                );\n            }\n\n            function setRentTypeLabel(element, rentLabel)\n            {\n                element.find(\".price-box\").find(\".price-wrapper\").find(\"span.price\").append(\n                    $('<span>').addClass('rent-type-text').text(rentLabel).css({\n                        \"color\": \"#bbb\",\n                        \"display\": \"block\",\n                        \"font-size\": \"80%\"\n                    })\n                );\n            }\n\n            function loadSlotsData(date)\n            {\n                showLoader();\n                $.ajax(\n                    {\n                        url: self.options.slotsUrl,\n                        type: 'POST',\n                        dataType: 'json',\n                        data: { product_id: self.options.productId, date: date },\n                        success: function (data) {\n                            hideLoader();\n\n                            if (data.avl == 1) {\n                                var slotHtml = \"\";\n                                $.each(\n                                    data.slots,\n                                    function (key, item) {\n                                        var day = item.day;\n                                        var id = item.id;\n                                        var qtyInfo = item.qty;\n                                        var dateFormatted = item.date_formatted.split(\",\");\n                                        var dateFrom = item.booking_from.split(\",\");\n                                        var dateTo = item.booking_to.split(\",\");\n                                        var reservedQty = 0;\n                                        if (self.options.booking_type == 2) {\n                                            var rowClass = 'wk-row';\n                                        } else {\n                                            var rowClass = 'wk-row wk-many-row';\n                                        }\n                                        slotHtml += '<div class=\"' + rowClass + '\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div class=\"wk-col first\">' +\n                                                '<span class=\"wk-label-days\">' + item.no_of_days + '</span>' +\n                                                '<span class=\"wk-label-days-text\">' +\n                                                '<div>' + $t('Day') + '</div>' +\n                                                '<div>' + $t('Slot') + '</div>' +\n                                                '</span>' +\n                                                '</div>';\n                                        }\n                                        if (!$('.booked-slot-summary').is(':empty')) {\n                                            if ($('.booked-slot-summary').find('.booked-short-history[data-booked-slot-id=\"' + id + '\"]').length) {\n                                                reservedQty = $('.booked-slot-summary').find('.booked-short-history[data-booked-slot-id=\"' + id + '\"]').children('input').val();\n                                                qtyInfo = parseInt(qtyInfo) - parseInt(reservedQty);\n                                            }\n                                        }\n                                        var textQtyBox = $t('Your Need');\n                                        if (reservedQty > 0) {\n                                            textQtyBox = $t('Selected');\n                                        }\n                                        slotHtml += '<div class=\"wk-col middle\">' +\n                                            '<span class=\"wk-label-dates\">' +\n                                            '<span class=\"wk-span-from\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div>' + dateFrom[0] + '</div>';\n                                        }\n                                        slotHtml += '<div>' + dateFrom[1] + '</div>' +\n                                            '</span>' +\n                                            '<span>to</span>' +\n                                            '<span class=\"wk-span-to\">';\n                                        if (self.options.booking_type == 2) {\n                                            slotHtml += '<div>' + dateTo[0] + '</div>';\n                                        }\n                                        slotHtml += '<div>' + dateTo[1] + '</div>' +\n                                            '</span>' +\n                                            '</span>' +\n                                            '<span class=\"wk-label-avl-qty\">' +\n                                            '<span class=\"wk-avl-text\">' + $t('Available :') + '</span>' +\n                                            '<span>' + qtyInfo + '</span>' +\n                                            '</span>' +\n                                            '</div>';\n                                        slotHtml += '<div class=\"wk-col last\">' +\n                                            '<span class=\"wk-booked-txt\">' + textQtyBox + '</span>' +\n                                            '<input type=\"number\" class=\"wk-qty\" value=\"' + reservedQty + '\" data-id=' + id + '>' +\n                                            '<input type=\"hidden\" name=\"wk-qty-booked-hide\" value=\"' + reservedQty + '\" class=\"wk-qty-booked-hide\">' +\n                                            '</div>';\n                                        slotHtml += '</div>';\n\n                                        if (dateFormatted[0] < 10) {\n                                            dateFormatted[0] = '0' + dateFormatted[0];\n                                        }\n                                        $(\".wk-booking-table-head\").find('.wk-selected-date').text(dateFormatted[0]);\n                                        $(\".wk-booking-table-head\").find('.wk-month').text(dateFormatted[1]);\n                                        $(\".wk-booking-table-head\").find('.wk-selected-day').text(day);\n                                    }\n                                );\n                                $(\".wk-booking-table-body\").html(slotHtml);\n                            } else {\n                                var slotHtml = \"\";\n                                slotHtml = '<div class=\"wk-no-booking\">' + data.msg + '</div>';\n                                $(\".wk-booking-table-body\").html(slotHtml);\n                            }\n                        }\n                    }\n                );\n            }\n            function showPanel()\n            {\n                $(\".wk-bg-container\").fadeIn('slow');\n                $(\".wk-box-modal\").animate({ 'margin-top': '125px' }, 500);\n            }\n            function hidePanel()\n            {\n                $(\".wk-bg-container\").fadeOut('slow');\n                $(\".wk-box-modal\").animate({ 'margin-top': '-400px' }, 500);\n            }\n            function showLoader()\n            {\n                $(\".wk-box-modal-bg\").show();\n            }\n            function hideLoader()\n            {\n                $(\".wk-box-modal-bg\").hide();\n            }\n            function validateNumber(currentObject)\n            {\n                var regex = /^[0-9]*(?:\\.\\d{1,2})?$/; // allow only numbers [0-9]\n                if (!regex.test($(currentObject).val())) {\n                    $(currentObject).val(1);\n                }\n            }\n        }\n    });\n    return $.bookingsystem.bookingsystem;\n});\n","Webkul_AdvancedBookingSystem/js/hotelbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    \"mage/calendar\"\n], function ($, alert, mageTemplate) {\n    'use strict';\n    $.widget('hotelbooking.hotelbooking', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var bookedDatesArr = [];\n            var availableDatesArr = [];\n            var datesArr = [];\n            var dateFormat = \"dd M, yy\";\n\n            if (self.options.bookedDates) {\n                bookedDatesArr = JSON.parse(self.options.bookedDates);\n            }\n            if (self.options.availableDates) {\n                availableDatesArr = JSON.parse(self.options.availableDates);\n            }\n\n            setDefaultDateRange();\n\n            $(\".hotel-number-quantity .quantity-up\").unbind(\"click\");\n            $(\".hotel-number-quantity .quantity-down\").unbind(\"click\");\n            $(\"#product_addtocart_form .wk-book-now\").unbind(\"click\");\n            $(\"button.write-answer\").unbind(\"click\");\n            \n            var errorMgs = \"\";\n            $.validator.addMethod(\n                \"validate-max\",\n                function(value, element) {\n                   var roomQty = $(element).parents('.wk-bk-hotel-options').find('.no-of-rooms').val();\n                   var max = $(element).attr('max');\n                   var isKid = $(element).attr('class').includes('kids');\n                   var fieldType = 'adults';\n                   if (value > max) {\n                       if (isKid) {\n                         fieldType = 'kids';\n                       }\n                     errorMgs = $.mage.__(\"Only \"+max+\" \"+fieldType+\" are allowed for \"+roomQty+\" room.\")\n                     return false;\n                   }\n                  return true\n                },\n                function () {\n                    return errorMgs;\n                }\n                );\n\n            function setDefaultDateRange()\n            {\n                var bookingDateFrom = $(\"#wk-bk-select-date-from\")\n                    .datepicker({\n                        'minDate': 'today',\n                        'dateFormat': 'dd M, yy'\n                    }).on(\"change\", function () {\n                        bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this, +1));\n                    }),\n                    bookingDateTo = $(\"#wk-bk-select-date-to\").datepicker({\n                        'minDate': '+1',\n                        'dateFormat': 'dd M, yy'\n                    });\n            }\n\n            function getBookingDate(element, counter)\n            {\n                var date;\n                try {\n                    date = $.datepicker.parseDate(dateFormat, element.value);\n                    date.setDate(date.getDate() + counter);\n                } catch (error) {\n                    date = null;\n                }\n                return date;\n            }\n\n            $(\"body\").on(\n                'blur',\n                '#wk-bk-select-date-from',\n                function (e) {\n                    setBlurOnDates();\n                }\n            );\n\n            $(\"body\").on(\n                'blur',\n                '#wk-bk-select-date-to',\n                function (e) {\n                    setBlurOnDates();\n                }\n            );\n\n            $(\"body\").on(\n                \"change\",\n                \"#qty.hotel-number-field.no-of-rooms\",\n                function () {\n                    setBlurOnDates();\n                    let rooms = parseFloat($(this).val());\n                    let adultsMaxAllowed = parseFloat($(\".hotel-number-field.adults\").attr('data-max'));\n                    $(\".hotel-number-field.adults\").attr('max', rooms*adultsMaxAllowed);\n                    let kidsMaxAllowed = parseFloat($(\".hotel-number-field.kids\").attr('data-max'));\n                    $(\".hotel-number-field.kids\").attr('max', rooms*kidsMaxAllowed);\n                    \n                }\n            );\n\n            $(document).on(\n                \"submit\",\n                \"form.hotel-booking-product-question-form\",\n                function () {\n                    $('body').loader('show');\n                }\n            );\n\n            function setBlurOnDates()\n            {\n                var selectedDateFrom = $(\"#wk-bk-select-date-from\").val();\n                var selectedDateTo = $(\"#wk-bk-select-date-to\").val();\n                if (selectedDateFrom && selectedDateTo) {\n                    selectedDateFrom = Date.parse(selectedDateFrom);\n                    selectedDateTo = Date.parse(selectedDateTo);\n                    var _array = [];\n                    for (var key in datesArr) {\n                        var booked_dates_str = Date.parse(key);\n                        if (booked_dates_str >= selectedDateFrom && booked_dates_str <= selectedDateTo) {\n                            _array.push(datesArr[key]);\n                        }\n                    }\n                    if (_array.length > 0) {\n                        var maxRoom = Math.min.apply(Math, _array);\n                        $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", maxRoom);\n                        if (maxRoom == 0) {\n                            $(\"input.input-text.hotel-number-field.no-of-rooms\").val(0);\n                        }\n                    } else {\n                        var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                        if (childProduct && availableDatesArr[childProduct]) {\n                            $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", availableDatesArr[childProduct]);\n                        }\n                    }\n                } else {\n                    var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                    if (childProduct && availableDatesArr[childProduct]) {\n                        $(\"input.input-text.hotel-number-field.no-of-rooms\").attr(\"max\", availableDatesArr[childProduct]);\n                    }\n                }\n            }\n\n            if (self.options.priceRangeText) {\n                $('#product-price-' + self.options.productId).after(\n                    '<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">' + self.options.priceRangeText + '</span>'\n                );\n            }\n\n            $(\"body\").on(\n                'click',\n                '.hotel-super-attribute-select .room-config-types',\n                function () {\n                    $('#wk-bk-select-date-from').datepicker(\"destroy\");\n                    $('#wk-bk-select-date-to').datepicker(\"destroy\");\n                    setDefaultDateRange();\n                    superAttributeSelected($(this));\n                }\n            );\n\n            function superAttributeSelected(element)\n            {\n                var superButton = $(element);\n                var optionId = $(element).attr(\"id\");\n\n                var superAttributeName = superButton.parents(\".hotel-super-attribute-select\").data(\"supername\");\n                var superAttrPosition = superButton.parents(\".hotel-super-attribute-select\").data(\"position\");\n                if ($(\"body .hotel-super-attribute-select\").length > 1 && superAttrPosition == 1) {\n                    $.each(\n                        $(\"body .hotel-super-attribute-select\"),\n                        function () {\n                            if ($(this).data(\"position\") !== 1) {\n                                $(this).find(\".room-config-types\").removeClass(\"hotel-selected\");\n                            }\n                        }\n                    );\n                }\n                superButton.siblings().removeClass(\"hotel-selected\");\n                // superButton.toggleClass(\"hotel-selected\");\n                superButton.removeClass(\"hotel-selected\");\n                superButton.addClass(\"hotel-selected\");\n                $(\"body\").find(\"select[name='\" + superAttributeName + \"']\").val(optionId).change();\n\n                var childProduct = $(\"input[name='selected_configurable_option']\").val();\n                if (childProduct) {\n                    datesArr = [];\n                    var disabledDates = [];\n                    if (bookedDatesArr) {\n                        for (var key in bookedDatesArr) {\n                            if (key == childProduct) {\n                                for (var date in bookedDatesArr[key][\"booked_dates\"]) {\n                                    datesArr = bookedDatesArr[key][\"booked_dates\"];\n                                    if (bookedDatesArr[key][\"booked_dates\"][date] <= 0) {\n                                        disabledDates.push(date);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    if (disabledDates.length > 0) {\n                        $('#wk-bk-select-date-from').datepicker(\"destroy\");\n                        $('#wk-bk-select-date-to').datepicker(\"destroy\");\n                        var bookingDateFrom = $(\"#wk-bk-select-date-from\")\n                            .datepicker({\n                                'minDate': 'today',\n                                'dateFormat': 'dd M, yy',\n                                \"beforeShowDay\": function (date) {\n                                    var string = $.datepicker.formatDate('dd M, yy', date);\n                                    var isDisabled = ($.inArray(string, disabledDates) != -1);\n                                    return [!isDisabled];\n                                }\n                            }).on(\"change\", function () {\n                                bookingDateTo.datepicker(\"option\", \"minDate\", getBookingDate(this, +1));\n                            }),\n                            bookingDateTo = $(\"#wk-bk-select-date-to\")\n                                .datepicker({\n                                    'minDate': 'today',\n                                    'dateFormat': 'dd M, yy',\n                                    \"beforeShowDay\": function (date) {\n                                        var string = $.datepicker.formatDate('dd M, yy', date);\n                                        var isDisabled = ($.inArray(string, disabledDates) != -1);\n                                        return [!isDisabled];\n                                    }\n                                }).on(\"change\", function () {\n                                    bookingDateFrom.datepicker(\"option\", \"maxDate\", getBookingDate(this, -1));\n                                });\n                    }\n\n                    setBlurOnDates();\n                }\n            }\n\n            $(\"#product_addtocart_form .wk-book-now\").on('click', function (e) {\n                    e.preventDefault();\n                    if ($(\"form#product_addtocart_form\").valid()) {\n                        if (self.options.product_type == \"hotelbooking\") {\n                            var selectedOpt = $(\"form#product_addtocart_form\")\n                                .find(\"input[name='selected_configurable_option']\").val();\n                            if (selectedOpt == \"\" || selectedOpt == undefined || selectedOpt == null) {\n                                alert({\n                                    content: self.options.required_config_text\n                                });\n                            } else {\n                                $(\"form#product_addtocart_form\").submit();\n                            }\n                        } else {\n                            $(\"form#product_addtocart_form\").submit();\n                        }\n                    }\n                }\n            );\n\n            $(\".wk-bk-hotel-askquestion-container button.write-answer\").on(\"click\", function (e) {\n                    e.preventDefault();\n\n                    if (!$(this).parents(\"form\").find('div.answer-field').hasClass('active')) {\n                        $(this).parents(\"form\").find('div.answer-field').addClass('active');\n                    } else {\n                        if ($(this).parents(\"form\").valid()) {\n                            $(this).parents(\"form\").submit();\n                        }\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"keypress\",\n                '.wk-bk-hotel-askquestion-container input#search_question',\n                function (e) {\n                    if (e.which == 13) {\n                        $(this).prents('form').submit();\n                    }\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                \".wk-bk-qna-wrapper .more-answers span\",\n                function () {\n                    $(this).parents('.more-answers').siblings('.hidden-answer').show();\n                    $(this).parents('.more-answers').hide();\n                }\n            );\n\n            $(\"body\").on(\n                \"click\",\n                \".wk-bk-qna-wrapper .answers.no-display  .more-answers span\",\n                function () {\n                    $(this).parents('.answers.no-display').children('.label').show();\n                    $(this).parents('.answers.no-display').find('.write-answer-container').show();\n                    $(this).parents('.more-answers').siblings('.hidden-answer').show();\n                    $(this).parents('.more-answers').hide();\n                    $(this).parents('.answers.no-display').removeClass('no-display');\n                }\n            );\n\n            $('.hotel-number-quantity .quantity-up').on(\"click\", function () {\n                var quantityField = $(this).parents('.hotel-number-quantity');\n                var numberFieldinput = quantityField.find('input.hotel-number-field[type=\"number\"]');\n                var max = parseInt(numberFieldinput.attr('max'));\n                var step = parseInt(numberFieldinput.attr('step'));\n                if (!step) {\n                    step = 1;\n                }\n\n                var numberFieldValue = numberFieldinput.val();\n                if (!numberFieldValue) {\n                    numberFieldValue = 0;\n                }\n\n                var oldValue = parseInt(numberFieldValue);\n                if (!max) {\n                    var newVal = oldValue + step;\n                } else {\n                    if (oldValue >= max) {\n                        var newVal = oldValue;\n                    } else {\n                        var newVal = oldValue + step;\n                    }\n                }\n\n                numberFieldinput.val(newVal);\n                numberFieldinput.trigger(\"change\");\n            });\n\n            $('.hotel-number-quantity .quantity-down').on(\"click\", function () {\n                var quantityField = $(this).parents('.hotel-number-quantity');\n                var numberFieldinput = quantityField.find('input.hotel-number-field[type=\"number\"]');\n                var min = parseInt(numberFieldinput.attr('min'));\n                var step = parseInt(numberFieldinput.attr('step'));\n                if (!step) {\n                    step = 1;\n                }\n\n                var numberFieldValue = numberFieldinput.val();\n                if (!numberFieldValue) {\n                    numberFieldValue = 1;\n                }\n\n                var oldValue = parseInt(numberFieldValue);\n\n                if (oldValue <= min) {\n                    var newVal = oldValue;\n                } else {\n                    var newVal = oldValue - step;\n                }\n\n                numberFieldinput.val(newVal);\n                numberFieldinput.trigger(\"change\");\n            });\n        }\n    });\n    return $.hotelbooking.hotelbooking;\n});\n","Webkul_AdvancedBookingSystem/js/eventBookingPriceOptions.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        eventOptionsSelector: '.wk-event-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig)\n    {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle()\n        {\n            $(this.options.optionsSelector, this.element).trigger('change');\n            $(this.options.eventOptionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions()\n        {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                eventOptions = $(this.options.eventOptionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            options.on('change', this._onOptionChanged.bind(this));\n            eventOptions.on('change', this._onEventOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event)\n        {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n            if (this.options.priceRangeFrom && this.options.priceRangeTo) {\n                var productId = this.options.productId;\n                var format = this.options.priceFormat;\n                var priceText = this.options.priceRangeText;\n                var priceFrom = utils.formatPrice(this.options.priceRangeFrom, format);\n                utils.formatPrice(this.options.priceRangeFrom, format);\n                if (this.options.priceRangeTo == this.options.priceRangeFrom) {\n                    $('#product-price-'+productId).find('.price').text(priceFrom);\n                } else {\n                    var priceTo = utils.formatPrice(this.options.priceRangeTo, format);\n                    $('#product-price-'+productId).find('.price').text(priceFrom+' - '+priceTo);\n                }\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                }\n            }\n        },\n\n        /**\n         * Custom event option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onEventOptionChanged: function onEventOptionChanged(event)\n        {\n            var option = $(event.target);\n            var optId = option.attr('data-option-id');\n            var optValId = option.attr('data-option-val-id');\n            if (option.val()) {\n                if (!$('#select_'+optId+optValId).length) {\n                    $('.wk-bk-options-wrapper').append('<input type=\"hidden\" name=\"options['+optId+'][]\" value=\"'+optValId+'\" id=\"select_'+optId+optValId+'\">');\n                }\n            } else {\n                if ($('#select_'+optId+optValId).length) {\n                    $('#select_'+optId+optValId).remove();\n                }\n            }\n            var totalQty = 0;\n            var totalPrice = 0;\n            var eventOptionPrice = this.options.eventOptionConfig;\n            var basePrice = parseFloat(this.options.productBasePrice);\n            $('.wk-event-custom-option').each(function () {\n                if ($(this).val()) {\n                    totalQty = totalQty + parseFloat($(this).val());\n                    var cOptionId = $(this).attr('data-option-id');\n                    var cOptionValue = $(this).attr('data-option-val-id');\n                    var cOptionPriceArr = eventOptionPrice[cOptionId+'_'+cOptionValue];\n                    totalPrice = totalPrice+((parseFloat(cOptionPriceArr.basePrice)+parseFloat(basePrice))*parseFloat($(this).val()));\n                    var cOptionPriceArr = eventOptionPrice[cOptionId+'_'+cOptionValue];\n                }\n            });\n            $('#wk-bk-event-total-qty').text(totalQty);\n            var productId = this.options.productId;\n            var format = this.options.priceFormat;\n            if (!totalPrice) {\n                totalPrice = basePrice;\n            }\n            $('#product-total-price-'+productId).find('.price').text(\n                utils.formatPrice(totalPrice, format)\n            );\n            if (this.options.priceRangeFrom && this.options.priceRangeTo) {\n                var priceText = this.options.priceRangeText;\n                let formPrice = this.options.priceRangeFrom;\n                let toPrice = this.options.priceRangeTo;\n                if (totalPrice) {\n                    formPrice = parseFloat(formPrice) + basePrice;\n                }\n                var priceFrom = utils.formatPrice(formPrice, format);\n                utils.formatPrice(this.options.priceRangeFrom, format);\n                if (this.options.priceRangeTo == this.options.priceRangeFrom) {\n                    $('#product-price-'+productId).find('.price').text(priceFrom);\n                } else {\n                    if (totalPrice) {\n                        toPrice = parseFloat(toPrice) + basePrice;\n                    }\n                    var priceTo = utils.formatPrice(toPrice, format);\n                    $('#product-price-'+productId).find('.price').text(priceFrom+' - '+priceTo);\n                }\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                }\n            }\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Webkul_AdvancedBookingSystem/js/validate-product.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'Webkul_AdvancedBookingSystem/js/catalog-add-to-cart'\n], function ($) {\n    'use strict';\n\n    $.widget(\n        'mage.productValidate',\n        {\n            options: {\n                bindSubmit: false,\n                radioCheckboxClosest: '.nested',\n                product_type: 'booking'\n            },\n\n            /**\n             * Uses Magento's validation widget for the form object.\n             *\n             * @private\n             */\n            _create: function () {\n                var bindSubmit = this.options.bindSubmit;\n                var product_type = this.options.product_type;\n\n                this.element.validation(\n                    {\n                        radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                        /**\n                         * Uses catalogAddToCart widget as submit handler.\n                         *\n                         * @param   {Object} form\n                         * @returns {Boolean}\n                         */\n                        submitHandler: function (form) {\n                            var jqForm = $(form).catalogAddToCart(\n                                {\n                                    bindSubmit: bindSubmit,\n                                    product_type: product_type\n                                }\n                            );\n\n                            jqForm.catalogAddToCart('submitForm', jqForm);\n\n                            return false;\n                        }\n                    }\n                );\n            }\n        }\n    );\n\n    return $.mage.productValidate;\n});","Webkul_AdvancedBookingSystem/js/relocateMediaCard.js":"document.addEventListener('DOMContentLoaded', function () {\n    function relocateMediaCard() {\n        const mediaCard = document.querySelector('.left-pdp.product-media-restaurant-card');\n        const productMedia = document.querySelector('.product-media');\n        const productInfoPrice = document.querySelector('.product-info-price');\n        const reservation = document.querySelector('.costo-la');\n\n        if (window.innerWidth < 769) {\n            if (mediaCard && productMedia && productInfoPrice && !productMedia.contains(mediaCard)) {\n                productInfoPrice.insertAdjacentElement('afterend', mediaCard);\n            }\n        } else {\n            if (reservation && mediaCard) {\n                if (mediaCard.parentNode && mediaCard.parentNode !== reservation) {\n                    mediaCard.parentNode.insertBefore(reservation, mediaCard);\n                }\n                if (!reservation.contains(mediaCard)) {\n                    reservation.appendChild(mediaCard);\n                }\n            }\n        }\n    }\n\n    relocateMediaCard();\n    window.addEventListener('resize', relocateMediaCard);\n\n    const removeSelectedSlot = () => {\n        const interval = setInterval(() => {  \n            let selectedSlots = Array.from(document.getElementsByClassName(\"wk-bk-slot-selected\")); \n        \n            if (selectedSlots.length > 1) {  \n                let lastSlot = selectedSlots[selectedSlots.length - 1];\n                if (lastSlot.classList.contains(\"wk-bk-slot-selected\")) { \n                    lastSlot.classList.remove(\"wk-bk-slot-selected\");\n                    clearInterval(interval); \n                }\n            } \n        }, 500);\n    };\n\n    removeSelectedSlot();\n    \n    function hiddeLabel() {\n        const interval = setInterval(() => {\n            const timeLabel = document.getElementById('default-time-label');\n            const selectTimeLabel = document.getElementById('select-time-label');\n            const reservationButton = document.getElementById('wk-book-now'); \n\n            if (timeLabel) {\n                if (timeLabel.textContent.trim() === 'Cerrado') {\n                    selectTimeLabel.style.display = 'none';\n                    timeLabel.style.height = '60px';\n    \n                    if (reservationButton) { \n                        reservationButton.disabled = true;\n                        reservationButton.classList.add('disabled');\n                    }\n                } else {   \n                    timeLabel.style.display = 'none';                 \n                    if (reservationButton) {\n                        reservationButton.disabled = false;\n                        reservationButton.classList.remove('disabled');\n                    }\n                }\n                clearInterval(interval);\n            }\n        }, 500); \n    }\n    hiddeLabel();\n});\n","Webkul_AdvancedBookingSystem/js/rentalBookingPriceOptions.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        controlContainer: 'dd',\n        deafultFlag: 1\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig)\n    {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle()\n        {\n            $(this.options.optionsSelector, this.element).trigger('change');\n            if (this.options.priceChargedPer) {\n                var productId = this.options.productId;\n                var format = this.options.priceFormat;\n                var priceText = this.options.priceChargedPerTxt;\n                var priceChargedPer = utils.formatPrice(this.options.priceChargedPer, format);\n                utils.formatPrice(this.options.priceChargedPer, format);\n                $('#product-price-'+productId).find('.price').text(priceChargedPer);\n                if (this.options.deafultFlag) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                    $('#'+this.options.optionValFieldId).trigger('click');\n                    this.options.deafultFlag = 0;\n                }\n            }\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions()\n        {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event)\n        {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n            if (!this.options.deafultFlag) {\n                var productId = this.options.productId;\n                var priceChargedPerTxtArr = this.options.priceChargedPerTxtArr;\n                var optionValId = event.currentTarget.value;\n                var priceText = priceChargedPerTxtArr[optionValId];\n                if (!$('#wk-bk-price-range-txt').length) {\n                    $('#product-price-'+productId).after('<span class=\"wk-bk-event-price-range-content\" id=\"wk-bk-price-range-txt\">'+priceText+'</span>');\n                } else {\n                    $('#wk-bk-price-range-txt').text(priceText);\n                }\n            }\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Webkul_AdvancedBookingSystem/js/appointmentbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    \"jquery\",\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    'mage/translate',\n    \"mage/calendar\"\n], function ($, alert, mageTemplate, $t) {\n    'use strict';\n    $.widget('appointmentbooking.appointmentbooking', {\n        options: {\n        },\n        _create: function () {\n            var self = this;\n            var monthArr = self.options.monthArr;\n            var todaySlotArr = self.options.todaySlotArr;\n            var options = JSON.parse(self.options.optionsJson);\n            var unvailableDates = self.options.appointmentUnavailableDates;\n            var holidaysData = self.options.holidaysData;\n            $(\"#wk-bk-select-date\").datepicker({\n                'dateFormat':'mm/dd/yy',\n                'minDate': 'today',\n                'maxDate': self.options.bookingAvailableTo,\n                'beforeShowDay': function (date) {\n                    var string = $.datepicker.formatDate('dd M, yy', date);\n                    var isDisabled = ($.inArray(string, unvailableDates) != -1);\n                    if(isDisabled){\n                        return [!isDisabled];\n                    }\n                    string = $.datepicker.formatDate('yy-mm-dd', date);\n                    let holiday = holidaysData[string];\n                    if(holiday){\n                        return [false,'',holiday];\n                    }\n                    return [true];\n                },\n            });\n            todaySlotArr.now = parseInt(Date.now()/1000);\n            todaySlotArr.activeFirst = 0;\n            var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n            tmpl;\n            tmpl = progressTmpl({\n                data: todaySlotArr\n            });\n            $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n            var selectedTime = $('.wk-bk-slot-selected').text();\n            $('#wk-bk-booking-time-field').val(selectedTime);\n            $('#wk-bk-booking-time-field').next('.wk-bk-select-time-label').text(selectedTime);\n            self._setProductOptions($('.wk-bk-slot-selected'), options);\n\n            $(\"body\").on('change', '#wk-bk-select-date', function () {\n                var selectedDate  = $(this).val();\n                var parsedDate = Date.parse(selectedDate, \"yyyy-MM-dd\");\n                let serverTimezoneDate = '';\n                var str = parsedDate.toString();\n                parsedDate = str.substr(0, str.length-3);\n\n                var selectedDateArr  = selectedDate.split('/');\n                var day = selectedDateArr[1];\n                var month = selectedDateArr[0];\n                var year = selectedDateArr[2];\n                var formatedDate = day+\" \"+monthArr[month]+\", \"+year;\n                let optionDate = year+\"-\"+month+\"-\"+day;\n                serverTimezoneDate = year+month+day;\n                var d = new Date(selectedDate);\n                var dayIndex = d.getDay();\n                if (dayIndex == 0) {\n                    dayIndex = 7;\n                }\n\n                var todayDate = new Date();\n                var tday = todayDate.getDate();\n                var tmonth = todayDate.getMonth() + 1;\n                var tyear = todayDate.getFullYear();\n                let holidayDateFormat = $.datepicker.formatDate('yy-mm-dd', d);;\n                var isHoliday = holidaysData[holidayDateFormat];\n                if(isHoliday){\n                    tmpl = null;\n                } else if (day == tday && month == tmonth && year == tyear) {\n                    // if from selected date is today\n                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template-today'),\n                    tmpl;\n                    tmpl = progressTmpl({\n                        data: todaySlotArr\n                    });\n                } else {\n                    var progressTmpl = mageTemplate('#wk-bk-select-time-opt-template'+dayIndex),\n                    tmpl;\n                    tmpl = progressTmpl({\n                        data: {}\n                    });\n                }\n                $('.wk-bk-select-time-opt-wrapper').html(tmpl);\n                let currentDate = parsedDate;\n                if (serverTimezoneDate) {\n                    currentDate = serverTimezoneDate;\n                }\n                if (currentDate in self.options.bookedData) {\n                    $.each(self.options.bookedData[currentDate], function (key, value) {\n                        if ($('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\").length) {\n                            var optTimeHtml = $('.wk-bk-select-time-opt-wrapper').find(\".wk-bk-select-time-opt[data-type-time='\"+key+\"']\");\n                            var remainingQty = optTimeHtml.data(\"slot-qty\") - value;\n                            if (remainingQty <= 0) {\n                                optTimeHtml.removeClass('wk-bk-slot-booked');\n                                optTimeHtml.addClass('wk-bk-slot-booked');\n                            }\n                        }\n                    });\n                }\n\n                $('.wk-bk-select-time-opt-wrapper').removeAttr('style');\n                var selectedTime = $('.wk-bk-slot-selected').text();\n                var isTimeClosed = false;\n                $('#wk-bk-booking-time-field').val(selectedTime);\n                $('#wk-bk-slot-day-index').val($('.wk-bk-slot-selected').attr('data-day-index'));\n                $('#wk-bk-parent-slot-id').val($('.wk-bk-slot-selected').attr('data-index'));\n                $('#wk-bk-slot-id').val($('.wk-bk-slot-selected').attr('data-slot-index'));\n                if (!tmpl) {\n                    selectedTime = self.options.titleClosed;\n                    isTimeClosed = true;\n                    $('.wk-bk-select-time-opt-wrapper').attr('style', 'display: none;');\n                }\n                $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text(selectedTime);\n                if (!selectedTime) {\n                    $(this).parents('.wk-bk-dates-container').find('.wk-bk-select-time-label').text($t('Closed'));\n                }\n                $('.wk-bk-select-date-label').text(formatedDate);\n                $('.wk-bk-select-date-label').attr('data-booking-date', optionDate);\n                var bookedDate = $('.wk-bk-select-date-label').text();\n                $.each(options, function (k, v) {\n                    if (v.title == 'Booking Date') {\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(optionDate);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(optionDate)\n                            );\n                        }\n                    }\n                    if (v.title == 'Booking Slot') {\n                        if (isTimeClosed) {\n                            selectedTime = \"\";\n                        }\n                        if ($('#options_'+v.id+'_text').length) {\n                            $('#options_'+v.id+'_text').val(selectedTime);\n                        } else {\n                            $('#product-options-wrapper').find('.fieldset').append(\n                                $('<input>')\n                                    .attr('type', 'hidden')\n                                    .attr('name', 'options['+v.id+']')\n                                    .attr('id', 'options_'+v.id+'_text')\n                                    .val(selectedTime)\n                            );\n                        }\n                    }\n                });\n            });\n            $('#wk-bk-select-date').trigger('change');\n            $(\"body\").on('click', '.wk-bk-select-time-opt', function () {\n                if (!$(this).hasClass('wk-bk-slot-booked')) {\n                    self._setProductOptions($(this), options);\n                }\n            });\n        },\n\n        _setProductOptions: function (element, options) {\n            var thisObj = element;\n            var selectedTime = thisObj.attr('data-type-time');\n            $(\".wk-bk-select-time-opt\").each(function () {\n                if ($(this).hasClass('wk-bk-slot-selected')) {\n                    $(this).removeClass('wk-bk-slot-selected');\n                }\n            });\n            thisObj.parents('.wk-bk-dates-right-container').find('.wk-bk-select-time-label').text(selectedTime);\n            thisObj.addClass('wk-bk-slot-selected');\n            $('#wk-bk-booking-time-field').val(selectedTime);\n            $('#wk-bk-slot-day-index').val(thisObj.attr('data-day-index'));\n            $('#wk-bk-parent-slot-id').val(thisObj.attr('data-index'));\n            $('#wk-bk-slot-id').val(thisObj.attr('data-slot-index'));\n            var bookedDate = $('.wk-bk-select-date-label').attr('data-booking-date');\n            $.each(options, function (k, v) {\n                if (v.title == 'Booking Date') {\n                    if ($('#options_'+v.id+'_text').length) {\n                        $('#options_'+v.id+'_text').val(bookedDate);\n                    } else {\n                        $('#product-options-wrapper').find('.fieldset').append(\n                            $('<input>')\n                                .attr('type', 'hidden')\n                                .attr('name', 'options['+v.id+']')\n                                .attr('id', 'options_'+v.id+'_text')\n                                .val(bookedDate)\n                        );\n                    }\n                }\n                if (v.title == 'Booking Slot') {\n                    if ($('#options_'+v.id+'_text').length) {\n                        $('#options_'+v.id+'_text').val(selectedTime);\n                    } else {\n                        $('#product-options-wrapper').find('.fieldset').append(\n                            $('<input>')\n                                .attr('type', 'hidden')\n                                .attr('name', 'options['+v.id+']')\n                                .attr('id', 'options_'+v.id+'_text')\n                                .val(selectedTime)\n                        );\n                    }\n                }\n            });\n        }\n    });\n    return $.appointmentbooking.appointmentbooking;\n});\n","Webkul_AdvancedBookingSystem/js/catalog-add-to-cart.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine(\n    [\n        'jquery',\n        'mage/translate'\n    ],\n    function ($, $t) {\n        'use strict';\n\n        $.widget(\n            'mage.catalogAddToCart',\n            {\n                options: {\n                    processStart: null,\n                    processStop: null,\n                    bindSubmit: true,\n                    minicartSelector: '[data-block=\"minicart\"]',\n                    messagesSelector: '[data-placeholder=\"messages\"]',\n                    productStatusSelector: '.stock.available',\n                    addToCartButtonSelector: '.action.tocart',\n                    addToCartButtonDisabledClass: 'disabled',\n                    addToCartButtonTextWhileAdding: '',\n                    addToCartButtonTextAdded: '',\n                    addToCartButtonTextDefault: '',\n                    product_type: \"booking\"\n                },\n\n                /**\n                 * @inheritdoc\n                 */\n                _create: function () {\n                    if (this.options.bindSubmit) {\n                        this._bindSubmit();\n                    }\n                },\n\n                /**\n                 * @private\n                 */\n                _bindSubmit: function () {\n                    var self = this;\n\n                    this.element.on(\n                        'submit',\n                        function (e) {\n                            e.preventDefault();\n                            self.submitForm($(this));\n                        }\n                    );\n                },\n\n                /**\n                 * @return {Boolean}\n                 */\n                isLoaderEnabled: function () {\n                    return this.options.processStart && this.options.processStop;\n                },\n\n                /**\n                 * Handler for the form 'submit' event\n                 *\n                 * @param {Object} form\n                 */\n                submitForm: function (form) {\n                    var addToCartButton, self = this;\n                    var flag = 1;\n                    if (self.options.product_type !== \"rentalbooking\" && self.options.product_type !== \"tablebooking\") {\n                        form.find('.product-custom-option').each(\n                            function (params) {\n                                var thisObj = $(this);\n                                if (thisObj.val() && flag) {\n                                    var qty = thisObj.val();\n                                    var optionId = $(this).attr('data-option-id');\n                                    var optionValId = $(this).attr('data-option-val-id');\n                                    var dataForm = form.serializeArray();\n                                    if (self.options.product_type == \"hotelbooking\") {\n                                        var hotelQty = self.calculateQty();\n                                        dataForm.push({ name: 'hotel_qty', value: hotelQty });\n                                    } else {\n                                        dataForm.push({ name: 'qty', value: qty });\n                                    }\n                                    $.each(\n                                        dataForm,\n                                        function (i, field) {\n                                            if (field.name.indexOf(\"booking_options[\") >= 0) {\n                                                if (field.name != 'booking_options[' + optionValId + '][qty]') {\n                                                    dataForm[i] = '{}';\n                                                }\n                                            }\n                                            if (field.name == 'options[' + optionId + '][]' && field.value != optionValId) {\n                                                dataForm[i] = '{}';\n                                            }\n                                        }\n                                    );\n                                    var newSubmittedFormData = $.param(dataForm);\n\n                                    if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                                        self.element.off('submit');\n                                        // disable 'Add to Cart' button\n                                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                                        addToCartButton.prop('disabled', true);\n                                        addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                                        self.ajaxSubmit(form);\n                                    } else {\n                                        self.ajaxSubmit(form, newSubmittedFormData);\n                                    }\n                                    flag = 0;\n                                }\n                            }\n                        );\n                        if (flag) {\n                            if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                                self.element.off('submit');\n                                // disable 'Add to Cart' button\n                                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                                addToCartButton.prop('disabled', true);\n                                addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                                self.ajaxSubmit(form);\n                            } else {\n                                self.ajaxSubmit(form);\n                            }\n                        }\n                    } else {\n                        self.ajaxSubmit(form);\n                    }\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                ajaxSubmit: function (form, newSubmittedFormData = '') {\n                    var self = this;\n\n                    $(self.options.minicartSelector).trigger('contentLoading');\n                    self.disableAddToCartButton(form);\n                    if (!newSubmittedFormData) {\n                        newSubmittedFormData = form.serialize();\n                    }\n                    $.ajax(\n                        {\n                            url: form.attr('action'),\n                            data: newSubmittedFormData,\n                            type: 'post',\n                            dataType: 'json',\n\n                            /**\n                             * @inheritdoc\n                             */\n                            beforeSend: function () {\n                                if (self.isLoaderEnabled()) {\n                                    $('body').trigger(self.options.processStart);\n                                }\n                            },\n\n                            /**\n                             * @inheritdoc\n                             */\n                            success: function (res) {\n                                var eventData, parameters;\n\n                                $(document).trigger('ajax:addToCart', form.data().productSku);\n\n                                if (self.isLoaderEnabled()) {\n                                    $('body').trigger(self.options.processStop);\n                                }\n\n                                if (res.backUrl) {\n                                    eventData = {\n                                        'form': form,\n                                        'redirectParameters': []\n                                    };\n                                    // trigger global event, so other modules will be able add parameters to redirect url\n                                    $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                                    if (eventData.redirectParameters.length > 0) {\n                                        parameters = res.backUrl.split('#');\n                                        parameters.push(eventData.redirectParameters.join('&'));\n                                        res.backUrl = parameters.join('#');\n                                    }\n                                    window.location = res.backUrl;\n\n                                    return;\n                                }\n\n                                if (res.messages) {\n                                    $(self.options.messagesSelector).html(res.messages);\n                                }\n\n                                if (res.minicart) {\n                                    $(self.options.minicartSelector).replaceWith(res.minicart);\n                                    $(self.options.minicartSelector).trigger('contentUpdated');\n                                }\n\n                                if (res.product && res.product.statusText) {\n                                    $(self.options.productStatusSelector)\n                                        .removeClass('available')\n                                        .addClass('unavailable')\n                                        .find('span')\n                                        .html(res.product.statusText);\n                                }\n                                self.enableAddToCartButton(form);\n                            }\n                        }\n                    );\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                disableAddToCartButton: function (form) {\n                    var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n                    addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                    addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n                    addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n                },\n\n                /**\n                 * @param {String} form\n                 */\n                enableAddToCartButton: function (form) {\n                    var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                        self = this,\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n                    addToCartButton.find('span').text(addToCartButtonTextAdded);\n                    addToCartButton.attr('title', addToCartButtonTextAdded);\n\n                    setTimeout(\n                        function () {\n                            if (self.options.product_type == \"booking\") {\n                                var addToCartButtonTextDefault = $t('Book Now');\n                            } else if (self.options.product_type == \"rentalbooking\") {\n                                var addToCartButtonTextDefault = $t('Rent Now');\n                            } else if (self.options.product_type == \"hotelbooking\") {\n                                var addToCartButtonTextDefault = $t('Book Now');\n                            } else {\n                                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n                            }\n\n                            addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                            addToCartButton.find('span').text(addToCartButtonTextDefault);\n                            addToCartButton.attr('title', addToCartButtonTextDefault);\n                        },\n                        1000\n                    );\n                },\n\n                calculateQty: function () {\n                    var qty = 0;\n                    var bookingFrom = Date.parse($(\"input#wk-bk-select-date-from\").val());\n                    var bookingTo = Date.parse($(\"input#wk-bk-select-date-to\").val());\n\n                    var noOfDays = Math.round((bookingTo - bookingFrom) / (1000 * 60 * 60 * 24));\n                    qty = qty + noOfDays;\n\n                    return qty;\n                }\n            }\n        );\n\n        return $.mage.catalogAddToCart;\n    }\n);\n","Webkul_AdvancedBookingSystem/js/event/validate-product.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/mage',\n    'Magento_Catalog/product/view/validation',\n    'Webkul_AdvancedBookingSystem/js/event/catalog-add-to-cart'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.productValidate', {\n        options: {\n            bindSubmit: false,\n            radioCheckboxClosest: '.nested'\n        },\n\n        /**\n         * Uses Magento's validation widget for the form object.\n         * @private\n         */\n        _create: function () {\n            var bindSubmit = this.options.bindSubmit;\n\n            this.element.validation({\n                radioCheckboxClosest: this.options.radioCheckboxClosest,\n\n                /**\n                 * Uses catalogAddToCart widget as submit handler.\n                 * @param {Object} form\n                 * @returns {Boolean}\n                 */\n                submitHandler: function (form) {\n                    var jqForm = $(form).catalogAddToCart({\n                        bindSubmit: bindSubmit\n                    });\n\n                    jqForm.catalogAddToCart('submitForm', jqForm);\n\n                    return false;\n                }\n            });\n        }\n    });\n\n    return $.mage.productValidate;\n});","Webkul_AdvancedBookingSystem/js/event/eventbooking.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\n define([\n    \"jquery\",\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n    $.widget(\n        'eventbooking.eventbooking',\n        {\n            options: {\n            },\n            _create: function () {\n                $('body').trigger('contentUpdated');\n                $(document).ready(function() {\n                    $('#wk-bk-design-others-info').insertAfter('.product-info-price');\n                    $('#wk-bk-design-others-info').show();\n                });\n\n                $(\"#wk-book-now\").click(function(event){\n                    event.preventDefault();\n                    var ctr = 0;\n                    $('.wk-event-custom-option').each(function () {\n                        var cOptionId = $(this).attr('data-option-id');\n                        var cOptionValue = $(this).attr('data-option-val-id');\n                        var selector = '#wk-bk-opt-val-'+cOptionId+cOptionValue;\n                        if ($(selector).val() && $(selector).val() >= 1) {\n                            ctr++;\n                        }\n                    });\n\n                    if (!ctr) {\n                        $('.err').show();\n                        $('.err').text($t('Please enter a valid number in this field'));\n                    } else {\n                        $('#product_addtocart_form').submit();\n                        $('.err').hide();\n                    }\n                });\n            }\n        }\n    );\n    return $.eventbooking.eventbooking;\n});\n","Webkul_AdvancedBookingSystem/js/event/catalog-add-to-cart.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/ui'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: 'Buy Tickets'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {Object} form\n         */\n        submitForm: function (form) {\n            var addToCartButton, self = this;\n            var flag = 1;\n            form.find('.wk-event-custom-option').each(function (index, params) {\n                var thisObj = $(this);\n\n                if (thisObj.val() && parseInt(thisObj.val()) > 0) {\n                    var qty = thisObj.val();\n                    var optionId = $(this).attr('data-option-id');\n                    var optionValId = $(this).attr('data-option-val-id');\n                    var dataForm = form.serializeArray();\n                    dataForm.push({ name: 'qty', value: qty });\n                    $.each(dataForm, function (i, field) {\n                        if (field.name.indexOf(\"booking_options[\") >= 0) {\n                            if (field.name != 'booking_options[' + optionValId + '][qty]') {\n                                dataForm[i] = '{}';\n                            }\n                        }\n                        if (field.name == 'options[' + optionId + '][]' && field.value != optionValId) {\n                            dataForm[i] = '{}';\n                        }\n                    });\n                    var newSubmittedFormData = $.param(dataForm);\n\n                    if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                        self.element.off('submit');\n                        // disable 'Add to Cart' button\n                        addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                        addToCartButton.prop('disabled', true);\n                        addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                        form.submit();\n                    } else {\n                        setTimeout(function () {\n                            self.ajaxSubmit(form, newSubmittedFormData);\n                        }, index*1500);\n                    }\n                    flag = 0;\n                }\n            });\n            if (flag) {\n                if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                    self.element.off('submit');\n                    // disable 'Add to Cart' button\n                    addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                    addToCartButton.prop('disabled', true);\n                    addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                    form.submit();\n                } else {\n                    self.ajaxSubmit(form);\n                }\n            }\n        },\n\n        /**\n         * @param {String} form\n         */\n        ajaxSubmit: function (form, newSubmittedFormData = '') {\n            var self = this;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n            if (!newSubmittedFormData) {\n                newSubmittedFormData = form.serialize();\n            }\n            $.ajax({\n                url: form.attr('action'),\n                data: newSubmittedFormData,\n                type: 'post',\n                dataType: 'json',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', form.data().productSku);\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n                        window.location = res.backUrl;\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.attr('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.attr('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});","Webkul_AdvancedBookingSystem/js/grid/columns/column.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            var action = this.fieldAction,\n                callback;\n\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Webkul_AdvancedBookingSystem/js/grid/columns/link.js":"/**\n * Webkul Software.\n *\n * @category  Webkul\n * @package   Webkul_AdvancedBookingSystem\n * @author    Webkul Software Private Limited\n * @copyright Webkul Software Private Limited (https://webkul.com)\n * @license   https://store.webkul.com/license.html\n */\ndefine([\n    './column',\n    'jquery',\n], function (Column, $) {\n    'use strict';\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/html',\n            fieldClass: {\n                'data-grid-html-cell': true\n            }\n        },\n        getFieldHandler: function (row) {\n            return false;\n        }\n    });\n});\n","Threedadv_Subscription/js/jspdf.min.js":"/** @license\n *\n * jsPDF - PDF Document creation from JavaScript\n * Version 3.0.1 Built on 2025-03-17T14:19:36.870Z\n *                      CommitID 00000000\n *\n * Copyright (c) 2010-2021 James Hall <james@parall.ax>, https://github.com/MrRio/jsPDF\n *               2015-2021 yWorks GmbH, http://www.yworks.com\n *               2015-2021 Lukas Holl\u00e4nder <lukas.hollaender@yworks.com>, https://github.com/HackbrettXXX\n *               2016-2018 Aras Abbasi <aras.abbasi@gmail.com>\n *               2010 Aaron Spike, https://github.com/acspike\n *               2012 Willow Systems Corporation, https://github.com/willowsystems\n *               2012 Pablo Hess, https://github.com/pablohess\n *               2012 Florian Jenett, https://github.com/fjenett\n *               2013 Warren Weckesser, https://github.com/warrenweckesser\n *               2013 Youssef Beddad, https://github.com/lifof\n *               2013 Lee Driscoll, https://github.com/lsdriscoll\n *               2013 Stefan Slonevskiy, https://github.com/stefslon\n *               2013 Jeremy Morel, https://github.com/jmorel\n *               2013 Christoph Hartmann, https://github.com/chris-rock\n *               2014 Juan Pablo Gaviria, https://github.com/juanpgaviria\n *               2014 James Makes, https://github.com/dollaruw\n *               2014 Diego Casorran, https://github.com/diegocr\n *               2014 Steven Spungin, https://github.com/Flamenco\n *               2014 Kenneth Glassey, https://github.com/Gavvers\n *\n * Permission is hereby granted, free of charge, to any person obtaining\n * a copy of this software and associated documentation files (the\n * \"Software\"), to deal in the Software without restriction, including\n * without limitation the rights to use, copy, modify, merge, publish,\n * distribute, sublicense, and/or sell copies of the Software, and to\n * permit persons to whom the Software is furnished to do so, subject to\n * the following conditions:\n *\n * The above copyright notice and this permission notice shall be\n * included in all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n *\n * Contributor(s):\n *    siefkenj, ahwolf, rickygu, Midnith, saintclair, eaparango,\n *    kim3er, mfo, alnorth, Flamenco\n */\n\n!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?e(exports):\"function\"==typeof define&&define.amd?define([\"exports\"],e):e((t=\"undefined\"!=typeof globalThis?globalThis:t||self).jspdf={})}(this,(function(t){\"use strict\";function e(t){return(e=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&\"function\"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?\"symbol\":typeof t})(t)}var r=function(){return\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:this}();function n(){r.console&&\"function\"==typeof r.console.log&&r.console.log.apply(r.console,arguments)}var i={log:n,warn:function(t){r.console&&(\"function\"==typeof r.console.warn?r.console.warn.apply(r.console,arguments):n.call(null,arguments))},error:function(t){r.console&&(\"function\"==typeof r.console.error?r.console.error.apply(r.console,arguments):n(t))}};function a(t,e,r){var n=new XMLHttpRequest;n.open(\"GET\",t),n.responseType=\"blob\",n.onload=function(){l(n.response,e,r)},n.onerror=function(){i.error(\"could not download file\")},n.send()}function o(t){var e=new XMLHttpRequest;e.open(\"HEAD\",t,!1);try{e.send()}catch(t){}return e.status>=200&&e.status<=299}function s(t){try{t.dispatchEvent(new MouseEvent(\"click\"))}catch(r){var e=document.createEvent(\"MouseEvents\");e.initMouseEvent(\"click\",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),t.dispatchEvent(e)}}var c,u,l=r.saveAs||(\"object\"!==(\"undefined\"==typeof window?\"undefined\":e(window))||window!==r?function(){}:\"undefined\"!=typeof HTMLAnchorElement&&\"download\"in HTMLAnchorElement.prototype?function(t,e,n){var i=r.URL||r.webkitURL,c=document.createElement(\"a\");e=e||t.name||\"download\",c.download=e,c.rel=\"noopener\",\"string\"==typeof t?(c.href=t,c.origin!==location.origin?o(c.href)?a(t,e,n):s(c,c.target=\"_blank\"):s(c)):(c.href=i.createObjectURL(t),setTimeout((function(){i.revokeObjectURL(c.href)}),4e4),setTimeout((function(){s(c)}),0))}:\"msSaveOrOpenBlob\"in navigator?function(t,r,n){if(r=r||t.name||\"download\",\"string\"==typeof t)if(o(t))a(t,r,n);else{var c=document.createElement(\"a\");c.href=t,c.target=\"_blank\",setTimeout((function(){s(c)}))}else navigator.msSaveOrOpenBlob(function(t,r){return void 0===r?r={autoBom:!1}:\"object\"!==e(r)&&(i.warn(\"Deprecated: Expected third argument to be a object\"),r={autoBom:!r}),r.autoBom&&/^\\s*(?:text\\/\\S*|application\\/xml|\\S*\\/\\S*\\+xml)\\s*;.*charset\\s*=\\s*utf-8/i.test(t.type)?new Blob([String.fromCharCode(65279),t],{type:t.type}):t}(t,n),r)}:function(t,n,i,o){if((o=o||open(\"\",\"_blank\"))&&(o.document.title=o.document.body.innerText=\"downloading...\"),\"string\"==typeof t)return a(t,n,i);var s=\"application/octet-stream\"===t.type,c=/constructor/i.test(r.HTMLElement)||r.safari,u=/CriOS\\/[\\d]+/.test(navigator.userAgent);if((u||s&&c)&&\"object\"===(\"undefined\"==typeof FileReader?\"undefined\":e(FileReader))){var l=new FileReader;l.onloadend=function(){var t=l.result;t=u?t:t.replace(/^data:[^;]*;/,\"data:attachment/file;\"),o?o.location.href=t:location=t,o=null},l.readAsDataURL(t)}else{var h=r.URL||r.webkitURL,f=h.createObjectURL(t);o?o.location=f:location.href=f,o=null,setTimeout((function(){h.revokeObjectURL(f)}),4e4)}});\n/**\n   * A class to parse color values\n   * @author Stoyan Stefanov <sstoo@gmail.com>\n   * {@link   http://www.phpied.com/rgb-color-parser-in-javascript/}\n   * @license Use it if you like it\n   */function h(t){var e;t=t||\"\",this.ok=!1,\"#\"==t.charAt(0)&&(t=t.substr(1,6));t={aliceblue:\"f0f8ff\",antiquewhite:\"faebd7\",aqua:\"00ffff\",aquamarine:\"7fffd4\",azure:\"f0ffff\",beige:\"f5f5dc\",bisque:\"ffe4c4\",black:\"000000\",blanchedalmond:\"ffebcd\",blue:\"0000ff\",blueviolet:\"8a2be2\",brown:\"a52a2a\",burlywood:\"deb887\",cadetblue:\"5f9ea0\",chartreuse:\"7fff00\",chocolate:\"d2691e\",coral:\"ff7f50\",cornflowerblue:\"6495ed\",cornsilk:\"fff8dc\",crimson:\"dc143c\",cyan:\"00ffff\",darkblue:\"00008b\",darkcyan:\"008b8b\",darkgoldenrod:\"b8860b\",darkgray:\"a9a9a9\",darkgreen:\"006400\",darkkhaki:\"bdb76b\",darkmagenta:\"8b008b\",darkolivegreen:\"556b2f\",darkorange:\"ff8c00\",darkorchid:\"9932cc\",darkred:\"8b0000\",darksalmon:\"e9967a\",darkseagreen:\"8fbc8f\",darkslateblue:\"483d8b\",darkslategray:\"2f4f4f\",darkturquoise:\"00ced1\",darkviolet:\"9400d3\",deeppink:\"ff1493\",deepskyblue:\"00bfff\",dimgray:\"696969\",dodgerblue:\"1e90ff\",feldspar:\"d19275\",firebrick:\"b22222\",floralwhite:\"fffaf0\",forestgreen:\"228b22\",fuchsia:\"ff00ff\",gainsboro:\"dcdcdc\",ghostwhite:\"f8f8ff\",gold:\"ffd700\",goldenrod:\"daa520\",gray:\"808080\",green:\"008000\",greenyellow:\"adff2f\",honeydew:\"f0fff0\",hotpink:\"ff69b4\",indianred:\"cd5c5c\",indigo:\"4b0082\",ivory:\"fffff0\",khaki:\"f0e68c\",lavender:\"e6e6fa\",lavenderblush:\"fff0f5\",lawngreen:\"7cfc00\",lemonchiffon:\"fffacd\",lightblue:\"add8e6\",lightcoral:\"f08080\",lightcyan:\"e0ffff\",lightgoldenrodyellow:\"fafad2\",lightgrey:\"d3d3d3\",lightgreen:\"90ee90\",lightpink:\"ffb6c1\",lightsalmon:\"ffa07a\",lightseagreen:\"20b2aa\",lightskyblue:\"87cefa\",lightslateblue:\"8470ff\",lightslategray:\"778899\",lightsteelblue:\"b0c4de\",lightyellow:\"ffffe0\",lime:\"00ff00\",limegreen:\"32cd32\",linen:\"faf0e6\",magenta:\"ff00ff\",maroon:\"800000\",mediumaquamarine:\"66cdaa\",mediumblue:\"0000cd\",mediumorchid:\"ba55d3\",mediumpurple:\"9370d8\",mediumseagreen:\"3cb371\",mediumslateblue:\"7b68ee\",mediumspringgreen:\"00fa9a\",mediumturquoise:\"48d1cc\",mediumvioletred:\"c71585\",midnightblue:\"191970\",mintcream:\"f5fffa\",mistyrose:\"ffe4e1\",moccasin:\"ffe4b5\",navajowhite:\"ffdead\",navy:\"000080\",oldlace:\"fdf5e6\",olive:\"808000\",olivedrab:\"6b8e23\",orange:\"ffa500\",orangered:\"ff4500\",orchid:\"da70d6\",palegoldenrod:\"eee8aa\",palegreen:\"98fb98\",paleturquoise:\"afeeee\",palevioletred:\"d87093\",papayawhip:\"ffefd5\",peachpuff:\"ffdab9\",peru:\"cd853f\",pink:\"ffc0cb\",plum:\"dda0dd\",powderblue:\"b0e0e6\",purple:\"800080\",red:\"ff0000\",rosybrown:\"bc8f8f\",royalblue:\"4169e1\",saddlebrown:\"8b4513\",salmon:\"fa8072\",sandybrown:\"f4a460\",seagreen:\"2e8b57\",seashell:\"fff5ee\",sienna:\"a0522d\",silver:\"c0c0c0\",skyblue:\"87ceeb\",slateblue:\"6a5acd\",slategray:\"708090\",snow:\"fffafa\",springgreen:\"00ff7f\",steelblue:\"4682b4\",tan:\"d2b48c\",teal:\"008080\",thistle:\"d8bfd8\",tomato:\"ff6347\",turquoise:\"40e0d0\",violet:\"ee82ee\",violetred:\"d02090\",wheat:\"f5deb3\",white:\"ffffff\",whitesmoke:\"f5f5f5\",yellow:\"ffff00\",yellowgreen:\"9acd32\"}[t=(t=t.replace(/ /g,\"\")).toLowerCase()]||t;for(var r=[{re:/^rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)$/,example:[\"rgb(123, 234, 45)\",\"rgb(255,234,245)\"],process:function(t){return[parseInt(t[1]),parseInt(t[2]),parseInt(t[3])]}},{re:/^(\\w{2})(\\w{2})(\\w{2})$/,example:[\"#00ff00\",\"336699\"],process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\\w{1})(\\w{1})(\\w{1})$/,example:[\"#fb0\",\"f0f\"],process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}],n=0;n<r.length;n++){var i=r[n].re,a=r[n].process,o=i.exec(t);o&&(e=a(o),this.r=e[0],this.g=e[1],this.b=e[2],this.ok=!0)}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.toRGB=function(){return\"rgb(\"+this.r+\", \"+this.g+\", \"+this.b+\")\"},this.toHex=function(){var t=this.r.toString(16),e=this.g.toString(16),r=this.b.toString(16);return 1==t.length&&(t=\"0\"+t),1==e.length&&(e=\"0\"+e),1==r.length&&(r=\"0\"+r),\"#\"+t+e+r}}\n/**\n   * @license\n   * Joseph Myers does not specify a particular license for his work.\n   *\n   * Author: Joseph Myers\n   * Accessed from: http://www.myersdaily.org/joseph/javascript/md5.js\n   *\n   * Modified by: Owen Leong\n   */\nfunction f(t,e){var r=t[0],n=t[1],i=t[2],a=t[3];r=p(r,n,i,a,e[0],7,-680876936),a=p(a,r,n,i,e[1],12,-389564586),i=p(i,a,r,n,e[2],17,606105819),n=p(n,i,a,r,e[3],22,-1044525330),r=p(r,n,i,a,e[4],7,-176418897),a=p(a,r,n,i,e[5],12,1200080426),i=p(i,a,r,n,e[6],17,-1473231341),n=p(n,i,a,r,e[7],22,-45705983),r=p(r,n,i,a,e[8],7,1770035416),a=p(a,r,n,i,e[9],12,-1958414417),i=p(i,a,r,n,e[10],17,-42063),n=p(n,i,a,r,e[11],22,-1990404162),r=p(r,n,i,a,e[12],7,1804603682),a=p(a,r,n,i,e[13],12,-40341101),i=p(i,a,r,n,e[14],17,-1502002290),r=g(r,n=p(n,i,a,r,e[15],22,1236535329),i,a,e[1],5,-165796510),a=g(a,r,n,i,e[6],9,-1069501632),i=g(i,a,r,n,e[11],14,643717713),n=g(n,i,a,r,e[0],20,-373897302),r=g(r,n,i,a,e[5],5,-701558691),a=g(a,r,n,i,e[10],9,38016083),i=g(i,a,r,n,e[15],14,-660478335),n=g(n,i,a,r,e[4],20,-405537848),r=g(r,n,i,a,e[9],5,568446438),a=g(a,r,n,i,e[14],9,-1019803690),i=g(i,a,r,n,e[3],14,-187363961),n=g(n,i,a,r,e[8],20,1163531501),r=g(r,n,i,a,e[13],5,-1444681467),a=g(a,r,n,i,e[2],9,-51403784),i=g(i,a,r,n,e[7],14,1735328473),r=m(r,n=g(n,i,a,r,e[12],20,-1926607734),i,a,e[5],4,-378558),a=m(a,r,n,i,e[8],11,-2022574463),i=m(i,a,r,n,e[11],16,1839030562),n=m(n,i,a,r,e[14],23,-35309556),r=m(r,n,i,a,e[1],4,-1530992060),a=m(a,r,n,i,e[4],11,1272893353),i=m(i,a,r,n,e[7],16,-155497632),n=m(n,i,a,r,e[10],23,-1094730640),r=m(r,n,i,a,e[13],4,681279174),a=m(a,r,n,i,e[0],11,-358537222),i=m(i,a,r,n,e[3],16,-722521979),n=m(n,i,a,r,e[6],23,76029189),r=m(r,n,i,a,e[9],4,-640364487),a=m(a,r,n,i,e[12],11,-421815835),i=m(i,a,r,n,e[15],16,530742520),r=v(r,n=m(n,i,a,r,e[2],23,-995338651),i,a,e[0],6,-198630844),a=v(a,r,n,i,e[7],10,1126891415),i=v(i,a,r,n,e[14],15,-1416354905),n=v(n,i,a,r,e[5],21,-57434055),r=v(r,n,i,a,e[12],6,1700485571),a=v(a,r,n,i,e[3],10,-1894986606),i=v(i,a,r,n,e[10],15,-1051523),n=v(n,i,a,r,e[1],21,-2054922799),r=v(r,n,i,a,e[8],6,1873313359),a=v(a,r,n,i,e[15],10,-30611744),i=v(i,a,r,n,e[6],15,-1560198380),n=v(n,i,a,r,e[13],21,1309151649),r=v(r,n,i,a,e[4],6,-145523070),a=v(a,r,n,i,e[11],10,-1120210379),i=v(i,a,r,n,e[2],15,718787259),n=v(n,i,a,r,e[9],21,-343485551),t[0]=S(r,t[0]),t[1]=S(n,t[1]),t[2]=S(i,t[2]),t[3]=S(a,t[3])}function d(t,e,r,n,i,a){return e=S(S(e,t),S(n,a)),S(e<<i|e>>>32-i,r)}function p(t,e,r,n,i,a,o){return d(e&r|~e&n,t,e,i,a,o)}function g(t,e,r,n,i,a,o){return d(e&n|r&~n,t,e,i,a,o)}function m(t,e,r,n,i,a,o){return d(e^r^n,t,e,i,a,o)}function v(t,e,r,n,i,a,o){return d(r^(e|~n),t,e,i,a,o)}function b(t){var e,r=t.length,n=[1732584193,-271733879,-1732584194,271733878];for(e=64;e<=t.length;e+=64)f(n,y(t.substring(e-64,e)));t=t.substring(e-64);var i=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(e=0;e<t.length;e++)i[e>>2]|=t.charCodeAt(e)<<(e%4<<3);if(i[e>>2]|=128<<(e%4<<3),e>55)for(f(n,i),e=0;e<16;e++)i[e]=0;return i[14]=8*r,f(n,i),n}function y(t){var e,r=[];for(e=0;e<64;e+=4)r[e>>2]=t.charCodeAt(e)+(t.charCodeAt(e+1)<<8)+(t.charCodeAt(e+2)<<16)+(t.charCodeAt(e+3)<<24);return r}c=r.atob.bind(r),u=r.btoa.bind(r);var w=\"0123456789abcdef\".split(\"\");function N(t){for(var e=\"\",r=0;r<4;r++)e+=w[t>>8*r+4&15]+w[t>>8*r&15];return e}function L(t){return String.fromCharCode((255&t)>>0,(65280&t)>>8,(16711680&t)>>16,(4278190080&t)>>24)}function A(t){return function(t){return t.map(L).join(\"\")}(b(t))}var x=\"5d41402abc4b2a76b9719d911017c592\"!=function(t){for(var e=0;e<t.length;e++)t[e]=N(t[e]);return t.join(\"\")}(b(\"hello\"));function S(t,e){if(x){var r=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(r>>16)<<16|65535&r}return t+e&4294967295}\n/**\n   * @license\n   * FPDF is released under a permissive license: there is no usage restriction.\n   * You may embed it freely in your application (commercial or not), with or\n   * without modifications.\n   *\n   * Reference: http://www.fpdf.org/en/script/script37.php\n   */function _(t,e){var r,n,i,a;if(t!==r){for(var o=(i=t,a=1+(256/t.length>>0),new Array(a+1).join(i)),s=[],c=0;c<256;c++)s[c]=c;var u=0;for(c=0;c<256;c++){var l=s[c];u=(u+l+o.charCodeAt(c))%256,s[c]=s[u],s[u]=l}r=t,n=s}else s=n;var h=e.length,f=0,d=0,p=\"\";for(c=0;c<h;c++)d=(d+(l=s[f=(f+1)%256]))%256,s[f]=s[d],s[d]=l,o=s[(s[f]+s[d])%256],p+=String.fromCharCode(e.charCodeAt(c)^o);return p}\n/**\n   * @license\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   * Author: Owen Leong (@owenl131)\n   * Date: 15 Oct 2020\n   * References:\n   * https://www.cs.cmu.edu/~dst/Adobe/Gallery/anon21jul01-pdf-encryption.txt\n   * https://github.com/foliojs/pdfkit/blob/master/lib/security.js\n   * http://www.fpdf.org/en/script/script37.php\n   */var P={print:4,modify:8,copy:16,\"annot-forms\":32};function k(t,e,r,n){this.v=1,this.r=2;var i=192;t.forEach((function(t){if(void 0!==P.perm)throw new Error(\"Invalid permission: \"+t);i+=P[t]})),this.padding=\"(\u00bfN^Nu\u008aAd\\0NV\u00ff\u00fa\u0001\\b..\\0\u00b6\u00d0h>\u0080/\\f\u00a9\u00fedSiz\";var a=(e+this.padding).substr(0,32),o=(r+this.padding).substr(0,32);this.O=this.processOwnerPassword(a,o),this.P=-(1+(255^i)),this.encryptionKey=A(a+this.O+this.lsbFirstWord(this.P)+this.hexToBytes(n)).substr(0,5),this.U=_(this.encryptionKey,this.padding)}function F(t){if(/[^\\u0000-\\u00ff]/.test(t))throw new Error(\"Invalid PDF Name Object: \"+t+\", Only accept ASCII characters.\");for(var e=\"\",r=t.length,n=0;n<r;n++){var i=t.charCodeAt(n);if(i<33||35===i||37===i||40===i||41===i||47===i||60===i||62===i||91===i||93===i||123===i||125===i||i>126)e+=\"#\"+(\"0\"+i.toString(16)).slice(-2);else e+=t[n]}return e}function I(t){if(\"object\"!==e(t))throw new Error(\"Invalid Context passed to initialize PubSub (jsPDF-module)\");var n={};this.subscribe=function(t,e,r){if(r=r||!1,\"string\"!=typeof t||\"function\"!=typeof e||\"boolean\"!=typeof r)throw new Error(\"Invalid arguments passed to PubSub.subscribe (jsPDF-module)\");n.hasOwnProperty(t)||(n[t]={});var i=Math.random().toString(35);return n[t][i]=[e,!!r],i},this.unsubscribe=function(t){for(var e in n)if(n[e][t])return delete n[e][t],0===Object.keys(n[e]).length&&delete n[e],!0;return!1},this.publish=function(e){if(n.hasOwnProperty(e)){var a=Array.prototype.slice.call(arguments,1),o=[];for(var s in n[e]){var c=n[e][s];try{c[0].apply(t,a)}catch(t){r.console&&i.error(\"jsPDF PubSub Error\",t.message,t)}c[1]&&o.push(s)}o.length&&o.forEach(this.unsubscribe)}},this.getTopics=function(){return n}}function C(t){if(!(this instanceof C))return new C(t);var e=\"opacity,stroke-opacity\".split(\",\");for(var r in t)t.hasOwnProperty(r)&&e.indexOf(r)>=0&&(this[r]=t[r]);this.id=\"\",this.objectNumber=-1}function j(t,e){this.gState=t,this.matrix=e,this.id=\"\",this.objectNumber=-1}function O(t,e,r,n,i){if(!(this instanceof O))return new O(t,e,r,n,i);this.type=\"axial\"===t?2:3,this.coords=e,this.colors=r,j.call(this,n,i)}function B(t,e,r,n,i){if(!(this instanceof B))return new B(t,e,r,n,i);this.boundingBox=t,this.xStep=e,this.yStep=r,this.stream=\"\",this.cloneIndex=0,j.call(this,n,i)}function M(t){var n,a=\"string\"==typeof arguments[0]?arguments[0]:\"p\",o=arguments[1],s=arguments[2],c=arguments[3],f=[],d=1,p=16,g=\"S\",m=null;\"object\"===e(t=t||{})&&(a=t.orientation,o=t.unit||o,s=t.format||s,c=t.compress||t.compressPdf||c,null!==(m=t.encryption||null)&&(m.userPassword=m.userPassword||\"\",m.ownerPassword=m.ownerPassword||\"\",m.userPermissions=m.userPermissions||[]),d=\"number\"==typeof t.userUnit?Math.abs(t.userUnit):1,void 0!==t.precision&&(n=t.precision),void 0!==t.floatPrecision&&(p=t.floatPrecision),g=t.defaultPathOperation||\"S\"),f=t.filters||(!0===c?[\"FlateEncode\"]:f),o=o||\"mm\",a=(\"\"+(a||\"P\")).toLowerCase();var v=t.putOnlyUsedFonts||!1,b={},y={internal:{},__private__:{}};y.__private__.PubSub=I;var w=\"1.3\",N=y.__private__.getPdfVersion=function(){return w};y.__private__.setPdfVersion=function(t){w=t};var L={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],\"government-letter\":[576,756],legal:[612,1008],\"junior-legal\":[576,360],ledger:[1224,792],tabloid:[792,1224],\"credit-card\":[153,243]};y.__private__.getPageFormats=function(){return L};var A=y.__private__.getPageFormat=function(t){return L[t]};s=s||\"a4\";var x={COMPAT:\"compat\",ADVANCED:\"advanced\"},S=x.COMPAT;function _(){this.saveGraphicsState(),ht(new Vt(_t,0,0,-_t,0,Rr()*_t).toString()+\" cm\"),this.setFontSize(this.getFontSize()/_t),g=\"n\",S=x.ADVANCED}function P(){this.restoreGraphicsState(),g=\"S\",S=x.COMPAT}var j=y.__private__.combineFontStyleAndFontWeight=function(t,e){if(\"bold\"==t&&\"normal\"==e||\"bold\"==t&&400==e||\"normal\"==t&&\"italic\"==e||\"bold\"==t&&\"italic\"==e)throw new Error(\"Invalid Combination of fontweight and fontstyle\");return e&&(t=400==e||\"normal\"===e?\"italic\"===t?\"italic\":\"normal\":700!=e&&\"bold\"!==e||\"normal\"!==t?(700==e?\"bold\":e)+\"\"+t:\"bold\"),t};y.advancedAPI=function(t){var e=S===x.COMPAT;return e&&_.call(this),\"function\"!=typeof t||(t(this),e&&P.call(this)),this},y.compatAPI=function(t){var e=S===x.ADVANCED;return e&&P.call(this),\"function\"!=typeof t||(t(this),e&&_.call(this)),this},y.isAdvancedAPI=function(){return S===x.ADVANCED};var E,q=function(t){if(S!==x.ADVANCED)throw new Error(t+\" is only available in 'advanced' API mode. You need to call advancedAPI() first.\")},D=y.roundToPrecision=y.__private__.roundToPrecision=function(t,e){var r=n||e;if(isNaN(t)||isNaN(r))throw new Error(\"Invalid argument passed to jsPDF.roundToPrecision\");return t.toFixed(r).replace(/0+$/,\"\")};E=y.hpf=y.__private__.hpf=\"number\"==typeof p?function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.hpf\");return D(t,p)}:\"smart\"===p?function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.hpf\");return D(t,t>-1&&t<1?16:5)}:function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.hpf\");return D(t,16)};var R=y.f2=y.__private__.f2=function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.f2\");return D(t,2)},T=y.__private__.f3=function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.f3\");return D(t,3)},U=y.scale=y.__private__.scale=function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.scale\");return S===x.COMPAT?t*_t:S===x.ADVANCED?t:void 0},z=function(t){return S===x.COMPAT?Rr()-t:S===x.ADVANCED?t:void 0},H=function(t){return U(z(t))};y.__private__.setPrecision=y.setPrecision=function(t){\"number\"==typeof parseInt(t,10)&&(n=parseInt(t,10))};var W,V=\"00000000000000000000000000000000\",G=y.__private__.getFileId=function(){return V},Y=y.__private__.setFileId=function(t){return V=void 0!==t&&/^[a-fA-F0-9]{32}$/.test(t)?t.toUpperCase():V.split(\"\").map((function(){return\"ABCDEF0123456789\".charAt(Math.floor(16*Math.random()))})).join(\"\"),null!==m&&(Ye=new k(m.userPermissions,m.userPassword,m.ownerPassword,V)),V};y.setFileId=function(t){return Y(t),this},y.getFileId=function(){return G()};var J=y.__private__.convertDateToPDFDate=function(t){var e=t.getTimezoneOffset(),r=e<0?\"+\":\"-\",n=Math.floor(Math.abs(e/60)),i=Math.abs(e%60),a=[r,Q(n),\"'\",Q(i),\"'\"].join(\"\");return[\"D:\",t.getFullYear(),Q(t.getMonth()+1),Q(t.getDate()),Q(t.getHours()),Q(t.getMinutes()),Q(t.getSeconds()),a].join(\"\")},X=y.__private__.convertPDFDateToDate=function(t){var e=parseInt(t.substr(2,4),10),r=parseInt(t.substr(6,2),10)-1,n=parseInt(t.substr(8,2),10),i=parseInt(t.substr(10,2),10),a=parseInt(t.substr(12,2),10),o=parseInt(t.substr(14,2),10);return new Date(e,r,n,i,a,o,0)},K=y.__private__.setCreationDate=function(t){var e;if(void 0===t&&(t=new Date),t instanceof Date)e=J(t);else{if(!/^D:(20[0-2][0-9]|203[0-7]|19[7-9][0-9])(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])(0[0-9]|1[0-9]|2[0-3])(0[0-9]|[1-5][0-9])(0[0-9]|[1-5][0-9])(\\+0[0-9]|\\+1[0-4]|-0[0-9]|-1[0-1])'(0[0-9]|[1-5][0-9])'?$/.test(t))throw new Error(\"Invalid argument passed to jsPDF.setCreationDate\");e=t}return W=e},Z=y.__private__.getCreationDate=function(t){var e=W;return\"jsDate\"===t&&(e=X(W)),e};y.setCreationDate=function(t){return K(t),this},y.getCreationDate=function(t){return Z(t)};var $,Q=y.__private__.padd2=function(t){return(\"0\"+parseInt(t)).slice(-2)},tt=y.__private__.padd2Hex=function(t){return(\"00\"+(t=t.toString())).substr(t.length)},et=0,rt=[],nt=[],it=0,at=[],ot=[],st=!1,ct=nt,ut=function(){et=0,it=0,nt=[],rt=[],at=[],Qt=Kt(),te=Kt()};y.__private__.setCustomOutputDestination=function(t){st=!0,ct=t};var lt=function(t){st||(ct=t)};y.__private__.resetCustomOutputDestination=function(){st=!1,ct=nt};var ht=y.__private__.out=function(t){return t=t.toString(),it+=t.length+1,ct.push(t),ct},ft=y.__private__.write=function(t){return ht(1===arguments.length?t.toString():Array.prototype.join.call(arguments,\" \"))},dt=y.__private__.getArrayBuffer=function(t){for(var e=t.length,r=new ArrayBuffer(e),n=new Uint8Array(r);e--;)n[e]=t.charCodeAt(e);return r},pt=[[\"Helvetica\",\"helvetica\",\"normal\",\"WinAnsiEncoding\"],[\"Helvetica-Bold\",\"helvetica\",\"bold\",\"WinAnsiEncoding\"],[\"Helvetica-Oblique\",\"helvetica\",\"italic\",\"WinAnsiEncoding\"],[\"Helvetica-BoldOblique\",\"helvetica\",\"bolditalic\",\"WinAnsiEncoding\"],[\"Courier\",\"courier\",\"normal\",\"WinAnsiEncoding\"],[\"Courier-Bold\",\"courier\",\"bold\",\"WinAnsiEncoding\"],[\"Courier-Oblique\",\"courier\",\"italic\",\"WinAnsiEncoding\"],[\"Courier-BoldOblique\",\"courier\",\"bolditalic\",\"WinAnsiEncoding\"],[\"Times-Roman\",\"times\",\"normal\",\"WinAnsiEncoding\"],[\"Times-Bold\",\"times\",\"bold\",\"WinAnsiEncoding\"],[\"Times-Italic\",\"times\",\"italic\",\"WinAnsiEncoding\"],[\"Times-BoldItalic\",\"times\",\"bolditalic\",\"WinAnsiEncoding\"],[\"ZapfDingbats\",\"zapfdingbats\",\"normal\",null],[\"Symbol\",\"symbol\",\"normal\",null]];y.__private__.getStandardFonts=function(){return pt};var gt=t.fontSize||16;y.__private__.setFontSize=y.setFontSize=function(t){return gt=S===x.ADVANCED?t/_t:t,this};var mt,vt=y.__private__.getFontSize=y.getFontSize=function(){return S===x.COMPAT?gt:gt*_t},bt=t.R2L||!1;y.__private__.setR2L=y.setR2L=function(t){return bt=t,this},y.__private__.getR2L=y.getR2L=function(){return bt};var yt,wt=y.__private__.setZoomMode=function(t){var e=[void 0,null,\"fullwidth\",\"fullheight\",\"fullpage\",\"original\"];if(/^(?:\\d+\\.\\d*|\\d*\\.\\d+|\\d+)%$/.test(t))mt=t;else if(isNaN(t)){if(-1===e.indexOf(t))throw new Error('zoom must be Integer (e.g. 2), a percentage Value (e.g. 300%) or fullwidth, fullheight, fullpage, original. \"'+t+'\" is not recognized.');mt=t}else mt=parseInt(t,10)};y.__private__.getZoomMode=function(){return mt};var Nt,Lt=y.__private__.setPageMode=function(t){if(-1==[void 0,null,\"UseNone\",\"UseOutlines\",\"UseThumbs\",\"FullScreen\"].indexOf(t))throw new Error('Page mode must be one of UseNone, UseOutlines, UseThumbs, or FullScreen. \"'+t+'\" is not recognized.');yt=t};y.__private__.getPageMode=function(){return yt};var At=y.__private__.setLayoutMode=function(t){if(-1==[void 0,null,\"continuous\",\"single\",\"twoleft\",\"tworight\",\"two\"].indexOf(t))throw new Error('Layout mode must be one of continuous, single, twoleft, tworight. \"'+t+'\" is not recognized.');Nt=t};y.__private__.getLayoutMode=function(){return Nt},y.__private__.setDisplayMode=y.setDisplayMode=function(t,e,r){return wt(t),At(e),Lt(r),this};var xt={title:\"\",subject:\"\",author:\"\",keywords:\"\",creator:\"\"};y.__private__.getDocumentProperty=function(t){if(-1===Object.keys(xt).indexOf(t))throw new Error(\"Invalid argument passed to jsPDF.getDocumentProperty\");return xt[t]},y.__private__.getDocumentProperties=function(){return xt},y.__private__.setDocumentProperties=y.setProperties=y.setDocumentProperties=function(t){for(var e in xt)xt.hasOwnProperty(e)&&t[e]&&(xt[e]=t[e]);return this},y.__private__.setDocumentProperty=function(t,e){if(-1===Object.keys(xt).indexOf(t))throw new Error(\"Invalid arguments passed to jsPDF.setDocumentProperty\");return xt[t]=e};var St,_t,Pt,kt,Ft,It={},Ct={},jt=[],Ot={},Bt={},Mt={},Et={},qt=null,Dt=0,Rt=[],Tt=new I(y),Ut=t.hotfixes||[],zt={},Ht={},Wt=[],Vt=function t(e,r,n,i,a,o){if(!(this instanceof t))return new t(e,r,n,i,a,o);isNaN(e)&&(e=1),isNaN(r)&&(r=0),isNaN(n)&&(n=0),isNaN(i)&&(i=1),isNaN(a)&&(a=0),isNaN(o)&&(o=0),this._matrix=[e,r,n,i,a,o]};Object.defineProperty(Vt.prototype,\"sx\",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Vt.prototype,\"shy\",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Vt.prototype,\"shx\",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Vt.prototype,\"sy\",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Vt.prototype,\"tx\",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Vt.prototype,\"ty\",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Vt.prototype,\"a\",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Vt.prototype,\"b\",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Vt.prototype,\"c\",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Vt.prototype,\"d\",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Vt.prototype,\"e\",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Vt.prototype,\"f\",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Vt.prototype,\"rotation\",{get:function(){return Math.atan2(this.shx,this.sx)}}),Object.defineProperty(Vt.prototype,\"scaleX\",{get:function(){return this.decompose().scale.sx}}),Object.defineProperty(Vt.prototype,\"scaleY\",{get:function(){return this.decompose().scale.sy}}),Object.defineProperty(Vt.prototype,\"isIdentity\",{get:function(){return 1===this.sx&&(0===this.shy&&(0===this.shx&&(1===this.sy&&(0===this.tx&&0===this.ty))))}}),Vt.prototype.join=function(t){return[this.sx,this.shy,this.shx,this.sy,this.tx,this.ty].map(E).join(t)},Vt.prototype.multiply=function(t){var e=t.sx*this.sx+t.shy*this.shx,r=t.sx*this.shy+t.shy*this.sy,n=t.shx*this.sx+t.sy*this.shx,i=t.shx*this.shy+t.sy*this.sy,a=t.tx*this.sx+t.ty*this.shx+this.tx,o=t.tx*this.shy+t.ty*this.sy+this.ty;return new Vt(e,r,n,i,a,o)},Vt.prototype.decompose=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,o=Math.sqrt(t*t+e*e),s=(t/=o)*r+(e/=o)*n;r-=t*s,n-=e*s;var c=Math.sqrt(r*r+n*n);return s/=c,t*(n/=c)<e*(r/=c)&&(t=-t,e=-e,s=-s,o=-o),{scale:new Vt(o,0,0,c,0,0),translate:new Vt(1,0,0,1,i,a),rotate:new Vt(t,e,-e,t,0,0),skew:new Vt(1,0,s,1,0,0)}},Vt.prototype.toString=function(t){return this.join(\" \")},Vt.prototype.inversed=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,o=1/(t*n-e*r),s=n*o,c=-e*o,u=-r*o,l=t*o;return new Vt(s,c,u,l,-s*i-u*a,-c*i-l*a)},Vt.prototype.applyToPoint=function(t){var e=t.x*this.sx+t.y*this.shx+this.tx,r=t.x*this.shy+t.y*this.sy+this.ty;return new Cr(e,r)},Vt.prototype.applyToRectangle=function(t){var e=this.applyToPoint(t),r=this.applyToPoint(new Cr(t.x+t.w,t.y+t.h));return new jr(e.x,e.y,r.x-e.x,r.y-e.y)},Vt.prototype.clone=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty;return new Vt(t,e,r,n,i,a)},y.Matrix=Vt;var Gt=y.matrixMult=function(t,e){return e.multiply(t)},Yt=new Vt(1,0,0,1,0,0);y.unitMatrix=y.identityMatrix=Yt;var Jt=function(t,e){if(!Bt[t]){var r=(e instanceof O?\"Sh\":\"P\")+(Object.keys(Ot).length+1).toString(10);e.id=r,Bt[t]=r,Ot[r]=e,Tt.publish(\"addPattern\",e)}};y.ShadingPattern=O,y.TilingPattern=B,y.addShadingPattern=function(t,e){return q(\"addShadingPattern()\"),Jt(t,e),this},y.beginTilingPattern=function(t){q(\"beginTilingPattern()\"),Br(t.boundingBox[0],t.boundingBox[1],t.boundingBox[2]-t.boundingBox[0],t.boundingBox[3]-t.boundingBox[1],t.matrix)},y.endTilingPattern=function(t,e){q(\"endTilingPattern()\"),e.stream=ot[$].join(\"\\n\"),Jt(t,e),Tt.publish(\"endTilingPattern\",e),Wt.pop().restore()};var Xt=y.__private__.newObject=function(){var t=Kt();return Zt(t,!0),t},Kt=y.__private__.newObjectDeferred=function(){return et++,rt[et]=function(){return it},et},Zt=function(t,e){return e=\"boolean\"==typeof e&&e,rt[t]=it,e&&ht(t+\" 0 obj\"),t},$t=y.__private__.newAdditionalObject=function(){var t={objId:Kt(),content:\"\"};return at.push(t),t},Qt=Kt(),te=Kt(),ee=y.__private__.decodeColorString=function(t){var e=t.split(\" \");if(2!==e.length||\"g\"!==e[1]&&\"G\"!==e[1]){if(5===e.length&&(\"k\"===e[4]||\"K\"===e[4])){e=[(1-e[0])*(1-e[3]),(1-e[1])*(1-e[3]),(1-e[2])*(1-e[3]),\"r\"]}}else{var r=parseFloat(e[0]);e=[r,r,r,\"r\"]}for(var n=\"#\",i=0;i<3;i++)n+=(\"0\"+Math.floor(255*parseFloat(e[i])).toString(16)).slice(-2);return n},re=y.__private__.encodeColorString=function(t){var r;\"string\"==typeof t&&(t={ch1:t});var n=t.ch1,i=t.ch2,a=t.ch3,o=t.ch4,s=\"draw\"===t.pdfColorType?[\"G\",\"RG\",\"K\"]:[\"g\",\"rg\",\"k\"];if(\"string\"==typeof n&&\"#\"!==n.charAt(0)){var c=new h(n);if(c.ok)n=c.toHex();else if(!/^\\d*\\.?\\d*$/.test(n))throw new Error('Invalid color \"'+n+'\" passed to jsPDF.encodeColorString.')}if(\"string\"==typeof n&&/^#[0-9A-Fa-f]{3}$/.test(n)&&(n=\"#\"+n[1]+n[1]+n[2]+n[2]+n[3]+n[3]),\"string\"==typeof n&&/^#[0-9A-Fa-f]{6}$/.test(n)){var u=parseInt(n.substr(1),16);n=u>>16&255,i=u>>8&255,a=255&u}if(void 0===i||void 0===o&&n===i&&i===a)if(\"string\"==typeof n)r=n+\" \"+s[0];else switch(t.precision){case 2:r=R(n/255)+\" \"+s[0];break;case 3:default:r=T(n/255)+\" \"+s[0]}else if(void 0===o||\"object\"===e(o)){if(o&&!isNaN(o.a)&&0===o.a)return r=[\"1.\",\"1.\",\"1.\",s[1]].join(\" \");if(\"string\"==typeof n)r=[n,i,a,s[1]].join(\" \");else switch(t.precision){case 2:r=[R(n/255),R(i/255),R(a/255),s[1]].join(\" \");break;default:case 3:r=[T(n/255),T(i/255),T(a/255),s[1]].join(\" \")}}else if(\"string\"==typeof n)r=[n,i,a,o,s[2]].join(\" \");else switch(t.precision){case 2:r=[R(n),R(i),R(a),R(o),s[2]].join(\" \");break;case 3:default:r=[T(n),T(i),T(a),T(o),s[2]].join(\" \")}return r},ne=y.__private__.getFilters=function(){return f},ie=y.__private__.putStream=function(t){var e=(t=t||{}).data||\"\",r=t.filters||ne(),n=t.alreadyAppliedFilters||[],i=t.addLength1||!1,a=e.length,o=t.objectId,s=function(t){return t};if(null!==m&&void 0===o)throw new Error(\"ObjectId must be passed to putStream for file encryption\");null!==m&&(s=Ye.encryptor(o,0));var c={};!0===r&&(r=[\"FlateEncode\"]);var u=t.additionalKeyValues||[],l=(c=void 0!==M.API.processDataByFilters?M.API.processDataByFilters(e,r):{data:e,reverseChain:[]}).reverseChain+(Array.isArray(n)?n.join(\" \"):n.toString());if(0!==c.data.length&&(u.push({key:\"Length\",value:c.data.length}),!0===i&&u.push({key:\"Length1\",value:a})),0!=l.length)if(l.split(\"/\").length-1==1)u.push({key:\"Filter\",value:l});else{u.push({key:\"Filter\",value:\"[\"+l+\"]\"});for(var h=0;h<u.length;h+=1)if(\"DecodeParms\"===u[h].key){for(var f=[],d=0;d<c.reverseChain.split(\"/\").length-1;d+=1)f.push(\"null\");f.push(u[h].value),u[h].value=\"[\"+f.join(\" \")+\"]\"}}ht(\"<<\");for(var p=0;p<u.length;p++)ht(\"/\"+u[p].key+\" \"+u[p].value);ht(\">>\"),0!==c.data.length&&(ht(\"stream\"),ht(s(c.data)),ht(\"endstream\"))},ae=y.__private__.putPage=function(t){var e=t.number,r=t.data,n=t.objId,i=t.contentsObjId;Zt(n,!0),ht(\"<</Type /Page\"),ht(\"/Parent \"+t.rootDictionaryObjId+\" 0 R\"),ht(\"/Resources \"+t.resourceDictionaryObjId+\" 0 R\"),ht(\"/MediaBox [\"+parseFloat(E(t.mediaBox.bottomLeftX))+\" \"+parseFloat(E(t.mediaBox.bottomLeftY))+\" \"+E(t.mediaBox.topRightX)+\" \"+E(t.mediaBox.topRightY)+\"]\"),null!==t.cropBox&&ht(\"/CropBox [\"+E(t.cropBox.bottomLeftX)+\" \"+E(t.cropBox.bottomLeftY)+\" \"+E(t.cropBox.topRightX)+\" \"+E(t.cropBox.topRightY)+\"]\"),null!==t.bleedBox&&ht(\"/BleedBox [\"+E(t.bleedBox.bottomLeftX)+\" \"+E(t.bleedBox.bottomLeftY)+\" \"+E(t.bleedBox.topRightX)+\" \"+E(t.bleedBox.topRightY)+\"]\"),null!==t.trimBox&&ht(\"/TrimBox [\"+E(t.trimBox.bottomLeftX)+\" \"+E(t.trimBox.bottomLeftY)+\" \"+E(t.trimBox.topRightX)+\" \"+E(t.trimBox.topRightY)+\"]\"),null!==t.artBox&&ht(\"/ArtBox [\"+E(t.artBox.bottomLeftX)+\" \"+E(t.artBox.bottomLeftY)+\" \"+E(t.artBox.topRightX)+\" \"+E(t.artBox.topRightY)+\"]\"),\"number\"==typeof t.userUnit&&1!==t.userUnit&&ht(\"/UserUnit \"+t.userUnit),Tt.publish(\"putPage\",{objId:n,pageContext:Rt[e],pageNumber:e,page:r}),ht(\"/Contents \"+i+\" 0 R\"),ht(\">>\"),ht(\"endobj\");var a=r.join(\"\\n\");return S===x.ADVANCED&&(a+=\"\\nQ\"),Zt(i,!0),ie({data:a,filters:ne(),objectId:i}),ht(\"endobj\"),n},oe=y.__private__.putPages=function(){var t,e,r=[];for(t=1;t<=Dt;t++)Rt[t].objId=Kt(),Rt[t].contentsObjId=Kt();for(t=1;t<=Dt;t++)r.push(ae({number:t,data:ot[t],objId:Rt[t].objId,contentsObjId:Rt[t].contentsObjId,mediaBox:Rt[t].mediaBox,cropBox:Rt[t].cropBox,bleedBox:Rt[t].bleedBox,trimBox:Rt[t].trimBox,artBox:Rt[t].artBox,userUnit:Rt[t].userUnit,rootDictionaryObjId:Qt,resourceDictionaryObjId:te}));Zt(Qt,!0),ht(\"<</Type /Pages\");var n=\"/Kids [\";for(e=0;e<Dt;e++)n+=r[e]+\" 0 R \";ht(n+\"]\"),ht(\"/Count \"+Dt),ht(\">>\"),ht(\"endobj\"),Tt.publish(\"postPutPages\")},se=function(t){Tt.publish(\"putFont\",{font:t,out:ht,newObject:Xt,putStream:ie}),!0!==t.isAlreadyPutted&&(t.objectNumber=Xt(),ht(\"<<\"),ht(\"/Type /Font\"),ht(\"/BaseFont /\"+F(t.postScriptName)),ht(\"/Subtype /Type1\"),\"string\"==typeof t.encoding&&ht(\"/Encoding /\"+t.encoding),ht(\"/FirstChar 32\"),ht(\"/LastChar 255\"),ht(\">>\"),ht(\"endobj\"))},ce=function(){for(var t in It)It.hasOwnProperty(t)&&(!1===v||!0===v&&b.hasOwnProperty(t))&&se(It[t])},ue=function(t){t.objectNumber=Xt();var e=[];e.push({key:\"Type\",value:\"/XObject\"}),e.push({key:\"Subtype\",value:\"/Form\"}),e.push({key:\"BBox\",value:\"[\"+[E(t.x),E(t.y),E(t.x+t.width),E(t.y+t.height)].join(\" \")+\"]\"}),e.push({key:\"Matrix\",value:\"[\"+t.matrix.toString()+\"]\"});var r=t.pages[1].join(\"\\n\");ie({data:r,additionalKeyValues:e,objectId:t.objectNumber}),ht(\"endobj\")},le=function(){for(var t in zt)zt.hasOwnProperty(t)&&ue(zt[t])},he=function(t,e){var r,n=[],i=1/(e-1);for(r=0;r<1;r+=i)n.push(r);if(n.push(1),0!=t[0].offset){var a={offset:0,color:t[0].color};t.unshift(a)}if(1!=t[t.length-1].offset){var o={offset:1,color:t[t.length-1].color};t.push(o)}for(var s=\"\",c=0,u=0;u<n.length;u++){for(r=n[u];r>t[c+1].offset;)c++;var l=t[c].offset,h=(r-l)/(t[c+1].offset-l),f=t[c].color,d=t[c+1].color;s+=tt(Math.round((1-h)*f[0]+h*d[0]).toString(16))+tt(Math.round((1-h)*f[1]+h*d[1]).toString(16))+tt(Math.round((1-h)*f[2]+h*d[2]).toString(16))}return s.trim()},fe=function(t,e){e||(e=21);var r=Xt(),n=he(t.colors,e),i=[];i.push({key:\"FunctionType\",value:\"0\"}),i.push({key:\"Domain\",value:\"[0.0 1.0]\"}),i.push({key:\"Size\",value:\"[\"+e+\"]\"}),i.push({key:\"BitsPerSample\",value:\"8\"}),i.push({key:\"Range\",value:\"[0.0 1.0 0.0 1.0 0.0 1.0]\"}),i.push({key:\"Decode\",value:\"[0.0 1.0 0.0 1.0 0.0 1.0]\"}),ie({data:n,additionalKeyValues:i,alreadyAppliedFilters:[\"/ASCIIHexDecode\"],objectId:r}),ht(\"endobj\"),t.objectNumber=Xt(),ht(\"<< /ShadingType \"+t.type),ht(\"/ColorSpace /DeviceRGB\");var a=\"/Coords [\"+E(parseFloat(t.coords[0]))+\" \"+E(parseFloat(t.coords[1]))+\" \";2===t.type?a+=E(parseFloat(t.coords[2]))+\" \"+E(parseFloat(t.coords[3])):a+=E(parseFloat(t.coords[2]))+\" \"+E(parseFloat(t.coords[3]))+\" \"+E(parseFloat(t.coords[4]))+\" \"+E(parseFloat(t.coords[5])),ht(a+=\"]\"),t.matrix&&ht(\"/Matrix [\"+t.matrix.toString()+\"]\"),ht(\"/Function \"+r+\" 0 R\"),ht(\"/Extend [true true]\"),ht(\">>\"),ht(\"endobj\")},de=function(t,e){var r=Kt(),n=Xt();e.push({resourcesOid:r,objectOid:n}),t.objectNumber=n;var i=[];i.push({key:\"Type\",value:\"/Pattern\"}),i.push({key:\"PatternType\",value:\"1\"}),i.push({key:\"PaintType\",value:\"1\"}),i.push({key:\"TilingType\",value:\"1\"}),i.push({key:\"BBox\",value:\"[\"+t.boundingBox.map(E).join(\" \")+\"]\"}),i.push({key:\"XStep\",value:E(t.xStep)}),i.push({key:\"YStep\",value:E(t.yStep)}),i.push({key:\"Resources\",value:r+\" 0 R\"}),t.matrix&&i.push({key:\"Matrix\",value:\"[\"+t.matrix.toString()+\"]\"}),ie({data:t.stream,additionalKeyValues:i,objectId:t.objectNumber}),ht(\"endobj\")},pe=function(t){var e;for(e in Ot)Ot.hasOwnProperty(e)&&(Ot[e]instanceof O?fe(Ot[e]):Ot[e]instanceof B&&de(Ot[e],t))},ge=function(t){for(var e in t.objectNumber=Xt(),ht(\"<<\"),t)switch(e){case\"opacity\":ht(\"/ca \"+R(t[e]));break;case\"stroke-opacity\":ht(\"/CA \"+R(t[e]))}ht(\">>\"),ht(\"endobj\")},me=function(){var t;for(t in Mt)Mt.hasOwnProperty(t)&&ge(Mt[t])},ve=function(){for(var t in ht(\"/XObject <<\"),zt)zt.hasOwnProperty(t)&&zt[t].objectNumber>=0&&ht(\"/\"+t+\" \"+zt[t].objectNumber+\" 0 R\");Tt.publish(\"putXobjectDict\"),ht(\">>\")},be=function(){Ye.oid=Xt(),ht(\"<<\"),ht(\"/Filter /Standard\"),ht(\"/V \"+Ye.v),ht(\"/R \"+Ye.r),ht(\"/U <\"+Ye.toHexString(Ye.U)+\">\"),ht(\"/O <\"+Ye.toHexString(Ye.O)+\">\"),ht(\"/P \"+Ye.P),ht(\">>\"),ht(\"endobj\")},ye=function(){for(var t in ht(\"/Font <<\"),It)It.hasOwnProperty(t)&&(!1===v||!0===v&&b.hasOwnProperty(t))&&ht(\"/\"+t+\" \"+It[t].objectNumber+\" 0 R\");ht(\">>\")},we=function(){if(Object.keys(Ot).length>0){for(var t in ht(\"/Shading <<\"),Ot)Ot.hasOwnProperty(t)&&Ot[t]instanceof O&&Ot[t].objectNumber>=0&&ht(\"/\"+t+\" \"+Ot[t].objectNumber+\" 0 R\");Tt.publish(\"putShadingPatternDict\"),ht(\">>\")}},Ne=function(t){if(Object.keys(Ot).length>0){for(var e in ht(\"/Pattern <<\"),Ot)Ot.hasOwnProperty(e)&&Ot[e]instanceof y.TilingPattern&&Ot[e].objectNumber>=0&&Ot[e].objectNumber<t&&ht(\"/\"+e+\" \"+Ot[e].objectNumber+\" 0 R\");Tt.publish(\"putTilingPatternDict\"),ht(\">>\")}},Le=function(){if(Object.keys(Mt).length>0){var t;for(t in ht(\"/ExtGState <<\"),Mt)Mt.hasOwnProperty(t)&&Mt[t].objectNumber>=0&&ht(\"/\"+t+\" \"+Mt[t].objectNumber+\" 0 R\");Tt.publish(\"putGStateDict\"),ht(\">>\")}},Ae=function(t){Zt(t.resourcesOid,!0),ht(\"<<\"),ht(\"/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\"),ye(),we(),Ne(t.objectOid),Le(),ve(),ht(\">>\"),ht(\"endobj\")},xe=function(){var t=[];ce(),me(),le(),pe(t),Tt.publish(\"putResources\"),t.forEach(Ae),Ae({resourcesOid:te,objectOid:Number.MAX_SAFE_INTEGER}),Tt.publish(\"postPutResources\")},Se=function(){Tt.publish(\"putAdditionalObjects\");for(var t=0;t<at.length;t++){var e=at[t];Zt(e.objId,!0),ht(e.content),ht(\"endobj\")}Tt.publish(\"postPutAdditionalObjects\")},_e=function(t){Ct[t.fontName]=Ct[t.fontName]||{},Ct[t.fontName][t.fontStyle]=t.id},Pe=function(t,e,r,n,i){var a={id:\"F\"+(Object.keys(It).length+1).toString(10),postScriptName:t,fontName:e,fontStyle:r,encoding:n,isStandardFont:i||!1,metadata:{}};return Tt.publish(\"addFont\",{font:a,instance:this}),It[a.id]=a,_e(a),a.id},ke=function(t){for(var e=0,r=pt.length;e<r;e++){var n=Pe.call(this,t[e][0],t[e][1],t[e][2],pt[e][3],!0);!1===v&&(b[n]=!0);var i=t[e][0].split(\"-\");_e({id:n,fontName:i[0],fontStyle:i[1]||\"\"})}Tt.publish(\"addFonts\",{fonts:It,dictionary:Ct})},Fe=function(t){return t.foo=function(){try{return t.apply(this,arguments)}catch(t){var e=t.stack||\"\";~e.indexOf(\" at \")&&(e=e.split(\" at \")[1]);var n=\"Error in function \"+e.split(\"\\n\")[0].split(\"<\")[0]+\": \"+t.message;if(!r.console)throw new Error(n);r.console.error(n,t),r.alert&&alert(n)}},t.foo.bar=t,t.foo},Ie=function(t,e){var r,n,i,a,o,s,c,u,l;if(i=(e=e||{}).sourceEncoding||\"Unicode\",o=e.outputEncoding,(e.autoencode||o)&&It[St].metadata&&It[St].metadata[i]&&It[St].metadata[i].encoding&&(a=It[St].metadata[i].encoding,!o&&It[St].encoding&&(o=It[St].encoding),!o&&a.codePages&&(o=a.codePages[0]),\"string\"==typeof o&&(o=a[o]),o)){for(c=!1,s=[],r=0,n=t.length;r<n;r++)(u=o[t.charCodeAt(r)])?s.push(String.fromCharCode(u)):s.push(t[r]),s[r].charCodeAt(0)>>8&&(c=!0);t=s.join(\"\")}for(r=t.length;void 0===c&&0!==r;)t.charCodeAt(r-1)>>8&&(c=!0),r--;if(!c)return t;for(s=e.noBOM?[]:[254,255],r=0,n=t.length;r<n;r++){if((l=(u=t.charCodeAt(r))>>8)>>8)throw new Error(\"Character at position \"+r+\" of string '\"+t+\"' exceeds 16bits. Cannot be encoded into UCS-2 BE\");s.push(l),s.push(u-(l<<8))}return String.fromCharCode.apply(void 0,s)},Ce=y.__private__.pdfEscape=y.pdfEscape=function(t,e){return Ie(t,e).replace(/\\\\/g,\"\\\\\\\\\").replace(/\\(/g,\"\\\\(\").replace(/\\)/g,\"\\\\)\")},je=y.__private__.beginPage=function(t){ot[++Dt]=[],Rt[Dt]={objId:0,contentsObjId:0,userUnit:Number(d),artBox:null,bleedBox:null,cropBox:null,trimBox:null,mediaBox:{bottomLeftX:0,bottomLeftY:0,topRightX:Number(t[0]),topRightY:Number(t[1])}},Me(Dt),lt(ot[$])},Oe=function(t,e){var r,n,o;switch(a=e||a,\"string\"==typeof t&&(r=A(t.toLowerCase()),Array.isArray(r)&&(n=r[0],o=r[1])),Array.isArray(t)&&(n=t[0]*_t,o=t[1]*_t),isNaN(n)&&(n=s[0],o=s[1]),(n>14400||o>14400)&&(i.warn(\"A page in a PDF can not be wider or taller than 14400 userUnit. jsPDF limits the width/height to 14400\"),n=Math.min(14400,n),o=Math.min(14400,o)),s=[n,o],a.substr(0,1)){case\"l\":o>n&&(s=[o,n]);break;case\"p\":n>o&&(s=[o,n])}je(s),pr(fr),ht(Lr),0!==kr&&ht(kr+\" J\"),0!==Fr&&ht(Fr+\" j\"),Tt.publish(\"addPage\",{pageNumber:Dt})},Be=function(t){t>0&&t<=Dt&&(ot.splice(t,1),Rt.splice(t,1),Dt--,$>Dt&&($=Dt),this.setPage($))},Me=function(t){t>0&&t<=Dt&&($=t)},Ee=y.__private__.getNumberOfPages=y.getNumberOfPages=function(){return ot.length-1},qe=function(t,e,r){var n,a=void 0;return r=r||{},t=void 0!==t?t:It[St].fontName,e=void 0!==e?e:It[St].fontStyle,n=t.toLowerCase(),void 0!==Ct[n]&&void 0!==Ct[n][e]?a=Ct[n][e]:void 0!==Ct[t]&&void 0!==Ct[t][e]?a=Ct[t][e]:!1===r.disableWarning&&i.warn(\"Unable to look up font label for font '\"+t+\"', '\"+e+\"'. Refer to getFontList() for available fonts.\"),a||r.noFallback||null==(a=Ct.times[e])&&(a=Ct.times.normal),a},De=y.__private__.putInfo=function(){var t=Xt(),e=function(t){return t};for(var r in null!==m&&(e=Ye.encryptor(t,0)),ht(\"<<\"),ht(\"/Producer (\"+Ce(e(\"jsPDF \"+M.version))+\")\"),xt)xt.hasOwnProperty(r)&&xt[r]&&ht(\"/\"+r.substr(0,1).toUpperCase()+r.substr(1)+\" (\"+Ce(e(xt[r]))+\")\");ht(\"/CreationDate (\"+Ce(e(W))+\")\"),ht(\">>\"),ht(\"endobj\")},Re=y.__private__.putCatalog=function(t){var e=(t=t||{}).rootDictionaryObjId||Qt;switch(Xt(),ht(\"<<\"),ht(\"/Type /Catalog\"),ht(\"/Pages \"+e+\" 0 R\"),mt||(mt=\"fullwidth\"),mt){case\"fullwidth\":ht(\"/OpenAction [3 0 R /FitH null]\");break;case\"fullheight\":ht(\"/OpenAction [3 0 R /FitV null]\");break;case\"fullpage\":ht(\"/OpenAction [3 0 R /Fit]\");break;case\"original\":ht(\"/OpenAction [3 0 R /XYZ null null 1]\");break;default:var r=\"\"+mt;\"%\"===r.substr(r.length-1)&&(mt=parseInt(mt)/100),\"number\"==typeof mt&&ht(\"/OpenAction [3 0 R /XYZ null null \"+R(mt)+\"]\")}switch(Nt||(Nt=\"continuous\"),Nt){case\"continuous\":ht(\"/PageLayout /OneColumn\");break;case\"single\":ht(\"/PageLayout /SinglePage\");break;case\"two\":case\"twoleft\":ht(\"/PageLayout /TwoColumnLeft\");break;case\"tworight\":ht(\"/PageLayout /TwoColumnRight\")}yt&&ht(\"/PageMode /\"+yt),Tt.publish(\"putCatalog\"),ht(\">>\"),ht(\"endobj\")},Te=y.__private__.putTrailer=function(){ht(\"trailer\"),ht(\"<<\"),ht(\"/Size \"+(et+1)),ht(\"/Root \"+et+\" 0 R\"),ht(\"/Info \"+(et-1)+\" 0 R\"),null!==m&&ht(\"/Encrypt \"+Ye.oid+\" 0 R\"),ht(\"/ID [ <\"+V+\"> <\"+V+\"> ]\"),ht(\">>\")},Ue=y.__private__.putHeader=function(){ht(\"%PDF-\"+w),ht(\"%\u00ba\u00df\u00ac\u00e0\")},ze=y.__private__.putXRef=function(){var t=\"0000000000\";ht(\"xref\"),ht(\"0 \"+(et+1)),ht(\"0000000000 65535 f \");for(var e=1;e<=et;e++){\"function\"==typeof rt[e]?ht((t+rt[e]()).slice(-10)+\" 00000 n \"):void 0!==rt[e]?ht((t+rt[e]).slice(-10)+\" 00000 n \"):ht(\"0000000000 00000 n \")}},He=y.__private__.buildDocument=function(){ut(),lt(nt),Tt.publish(\"buildDocument\"),Ue(),oe(),Se(),xe(),null!==m&&be(),De(),Re();var t=it;return ze(),Te(),ht(\"startxref\"),ht(\"\"+t),ht(\"%%EOF\"),lt(ot[$]),nt.join(\"\\n\")},We=y.__private__.getBlob=function(t){return new Blob([dt(t)],{type:\"application/pdf\"})},Ve=y.output=y.__private__.output=Fe((function(t,e){switch(\"string\"==typeof(e=e||{})?e={filename:e}:e.filename=e.filename||\"generated.pdf\",t){case void 0:return He();case\"save\":y.save(e.filename);break;case\"arraybuffer\":return dt(He());case\"blob\":return We(He());case\"bloburi\":case\"bloburl\":if(void 0!==r.URL&&\"function\"==typeof r.URL.createObjectURL)return r.URL&&r.URL.createObjectURL(We(He()))||void 0;i.warn(\"bloburl is not supported by your system, because URL.createObjectURL is not supported by your browser.\");break;case\"datauristring\":case\"dataurlstring\":var n=\"\",a=He();try{n=u(a)}catch(t){n=u(unescape(encodeURIComponent(a)))}return\"data:application/pdf;filename=\"+e.filename+\";base64,\"+n;case\"pdfobjectnewwindow\":if(\"[object Window]\"===Object.prototype.toString.call(r)){var o=\"https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js\",s=' integrity=\"sha512-4ze/a9/4jqu+tX9dfOqJYSvyYd5M6qum/3HpCLr+/Jqf0whc37VUbkpNGHR7/8pSnCFw47T1fmIpwBV7UySh3g==\" crossorigin=\"anonymous\"';e.pdfObjectUrl&&(o=e.pdfObjectUrl,s=\"\");var c='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><script src=\"'+o+'\"'+s+'><\\/script><script >PDFObject.embed(\"'+this.output(\"dataurlstring\")+'\", '+JSON.stringify(e)+\");<\\/script></body></html>\",l=r.open();return null!==l&&l.document.write(c),l}throw new Error(\"The option pdfobjectnewwindow just works in a browser-environment.\");case\"pdfjsnewwindow\":if(\"[object Window]\"===Object.prototype.toString.call(r)){var h='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe id=\"pdfViewer\" src=\"'+(e.pdfJsUrl||\"examples/PDF.js/web/viewer.html\")+\"?file=&downloadName=\"+e.filename+'\" width=\"500px\" height=\"400px\" /></body></html>',f=r.open();if(null!==f){f.document.write(h);var d=this;f.document.documentElement.querySelector(\"#pdfViewer\").onload=function(){f.document.title=e.filename,f.document.documentElement.querySelector(\"#pdfViewer\").contentWindow.PDFViewerApplication.open(d.output(\"bloburl\"))}}return f}throw new Error(\"The option pdfjsnewwindow just works in a browser-environment.\");case\"dataurlnewwindow\":if(\"[object Window]\"!==Object.prototype.toString.call(r))throw new Error(\"The option dataurlnewwindow just works in a browser-environment.\");var p='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe src=\"'+this.output(\"datauristring\",e)+'\"></iframe></body></html>',g=r.open();if(null!==g&&(g.document.write(p),g.document.title=e.filename),g||\"undefined\"==typeof safari)return g;break;case\"datauri\":case\"dataurl\":return r.document.location.href=this.output(\"datauristring\",e);default:return null}})),Ge=function(t){return!0===Array.isArray(Ut)&&Ut.indexOf(t)>-1};switch(o){case\"pt\":_t=1;break;case\"mm\":_t=72/25.4;break;case\"cm\":_t=72/2.54;break;case\"in\":_t=72;break;case\"px\":_t=1==Ge(\"px_scaling\")?.75:96/72;break;case\"pc\":case\"em\":_t=12;break;case\"ex\":_t=6;break;default:if(\"number\"!=typeof o)throw new Error(\"Invalid unit: \"+o);_t=o}var Ye=null;K(),Y();var Je=function(t){return null!==m?Ye.encryptor(t,0):function(t){return t}},Xe=y.__private__.getPageInfo=y.getPageInfo=function(t){if(isNaN(t)||t%1!=0)throw new Error(\"Invalid argument passed to jsPDF.getPageInfo\");return{objId:Rt[t].objId,pageNumber:t,pageContext:Rt[t]}},Ke=y.__private__.getPageInfoByObjId=function(t){if(isNaN(t)||t%1!=0)throw new Error(\"Invalid argument passed to jsPDF.getPageInfoByObjId\");for(var e in Rt)if(Rt[e].objId===t)break;return Xe(e)},Ze=y.__private__.getCurrentPageInfo=y.getCurrentPageInfo=function(){return{objId:Rt[$].objId,pageNumber:$,pageContext:Rt[$]}};y.addPage=function(){return Oe.apply(this,arguments),this},y.setPage=function(){return Me.apply(this,arguments),lt.call(this,ot[$]),this},y.insertPage=function(t){return this.addPage(),this.movePage($,t),this},y.movePage=function(t,e){var r,n;if(t>e){r=ot[t],n=Rt[t];for(var i=t;i>e;i--)ot[i]=ot[i-1],Rt[i]=Rt[i-1];ot[e]=r,Rt[e]=n,this.setPage(e)}else if(t<e){r=ot[t],n=Rt[t];for(var a=t;a<e;a++)ot[a]=ot[a+1],Rt[a]=Rt[a+1];ot[e]=r,Rt[e]=n,this.setPage(e)}return this},y.deletePage=function(){return Be.apply(this,arguments),this},y.__private__.text=y.text=function(t,r,n,i,a){var o,s,c,u,l,h,f,d,p,g=(i=i||{}).scope||this;if(\"number\"==typeof t&&\"number\"==typeof r&&(\"string\"==typeof n||Array.isArray(n))){var m=n;n=r,r=t,t=m}if(arguments[3]instanceof Vt==!1?(c=arguments[4],u=arguments[5],\"object\"===e(f=arguments[3])&&null!==f||(\"string\"==typeof c&&(u=c,c=null),\"string\"==typeof f&&(u=f,f=null),\"number\"==typeof f&&(c=f,f=null),i={flags:f,angle:c,align:u})):(q(\"The transform parameter of text() with a Matrix value\"),p=a),isNaN(r)||isNaN(n)||null==t)throw new Error(\"Invalid arguments passed to jsPDF.text\");if(0===t.length)return g;var v=\"\",y=!1,w=\"number\"==typeof i.lineHeightFactor?i.lineHeightFactor:hr,N=g.internal.scaleFactor;function L(t){return t=t.split(\"\\t\").join(Array(i.TabLen||9).join(\" \")),Ce(t,f)}function A(t){for(var e,r=t.concat(),n=[],i=r.length;i--;)\"string\"==typeof(e=r.shift())?n.push(e):Array.isArray(t)&&(1===e.length||void 0===e[1]&&void 0===e[2])?n.push(e[0]):n.push([e[0],e[1],e[2]]);return n}function _(t,e){var r;if(\"string\"==typeof t)r=e(t)[0];else if(Array.isArray(t)){for(var n,i,a=t.concat(),o=[],s=a.length;s--;)\"string\"==typeof(n=a.shift())?o.push(e(n)[0]):Array.isArray(n)&&\"string\"==typeof n[0]&&(i=e(n[0],n[1],n[2]),o.push([i[0],i[1],i[2]]));r=o}return r}var P=!1,k=!0;if(\"string\"==typeof t)P=!0;else if(Array.isArray(t)){var F=t.concat();s=[];for(var I,C=F.length;C--;)(\"string\"!=typeof(I=F.shift())||Array.isArray(I)&&\"string\"!=typeof I[0])&&(k=!1);P=k}if(!1===P)throw new Error('Type of text must be string or Array. \"'+t+'\" is not recognized.');\"string\"==typeof t&&(t=t.match(/[\\r?\\n]/)?t.split(/\\r\\n|\\r|\\n/g):[t]);var j=gt/g.internal.scaleFactor,O=j*(w-1);switch(i.baseline){case\"bottom\":n-=O;break;case\"top\":n+=j-O;break;case\"hanging\":n+=j-2*O;break;case\"middle\":n+=j/2-O}if((h=i.maxWidth||0)>0&&(\"string\"==typeof t?t=g.splitTextToSize(t,h):\"[object Array]\"===Object.prototype.toString.call(t)&&(t=t.reduce((function(t,e){return t.concat(g.splitTextToSize(e,h))}),[]))),o={text:t,x:r,y:n,options:i,mutex:{pdfEscape:Ce,activeFontKey:St,fonts:It,activeFontSize:gt}},Tt.publish(\"preProcessText\",o),t=o.text,c=(i=o.options).angle,p instanceof Vt==!1&&c&&\"number\"==typeof c){c*=Math.PI/180,0===i.rotationDirection&&(c=-c),S===x.ADVANCED&&(c=-c);var B=Math.cos(c),M=Math.sin(c);p=new Vt(B,M,-M,B,0,0)}else c&&c instanceof Vt&&(p=c);S!==x.ADVANCED||p||(p=Yt),void 0!==(l=i.charSpace||_r)&&(v+=E(U(l))+\" Tc\\n\",this.setCharSpace(this.getCharSpace()||0)),void 0!==(d=i.horizontalScale)&&(v+=E(100*d)+\" Tz\\n\"),i.lang;var D=-1,R=void 0!==i.renderingMode?i.renderingMode:i.stroke,T=g.internal.getCurrentPageInfo().pageContext;switch(R){case 0:case!1:case\"fill\":D=0;break;case 1:case!0:case\"stroke\":D=1;break;case 2:case\"fillThenStroke\":D=2;break;case 3:case\"invisible\":D=3;break;case 4:case\"fillAndAddForClipping\":D=4;break;case 5:case\"strokeAndAddPathForClipping\":D=5;break;case 6:case\"fillThenStrokeAndAddToPathForClipping\":D=6;break;case 7:case\"addToPathForClipping\":D=7}var z=void 0!==T.usedRenderingMode?T.usedRenderingMode:-1;-1!==D?v+=D+\" Tr\\n\":-1!==z&&(v+=\"0 Tr\\n\"),-1!==D&&(T.usedRenderingMode=D),u=i.align||\"left\";var H,W=gt*w,V=g.internal.pageSize.getWidth(),G=It[St];l=i.charSpace||_r,h=i.maxWidth||0,f=Object.assign({autoencode:!0,noBOM:!0},i.flags);var Y=[],J=function(t){return g.getStringUnitWidth(t,{font:G,charSpace:l,fontSize:gt,doKerning:!1})*gt/N};if(\"[object Array]\"===Object.prototype.toString.call(t)){var X;s=A(t),\"left\"!==u&&(H=s.map(J));var K,Z=0;if(\"right\"===u){r-=H[0],t=[],C=s.length;for(var $=0;$<C;$++)0===$?(K=br(r),X=yr(n)):(K=U(Z-H[$]),X=-W),t.push([s[$],K,X]),Z=H[$]}else if(\"center\"===u){r-=H[0]/2,t=[],C=s.length;for(var Q=0;Q<C;Q++)0===Q?(K=br(r),X=yr(n)):(K=U((Z-H[Q])/2),X=-W),t.push([s[Q],K,X]),Z=H[Q]}else if(\"left\"===u){t=[],C=s.length;for(var tt=0;tt<C;tt++)t.push(s[tt])}else if(\"justify\"===u&&\"Identity-H\"===G.encoding){t=[],C=s.length,h=0!==h?h:V;for(var et=0,rt=0;rt<C;rt++)if(X=0===rt?yr(n):-W,K=0===rt?br(r):et,rt<C-1){var nt=U((h-H[rt])/(s[rt].split(\" \").length-1)),it=s[rt].split(\" \");t.push([it[0]+\" \",K,X]),et=0;for(var at=1;at<it.length;at++){var ot=(J(it[at-1]+\" \"+it[at])-J(it[at]))*N+nt;at==it.length-1?t.push([it[at],ot,0]):t.push([it[at]+\" \",ot,0]),et-=ot}}else t.push([s[rt],K,X]);t.push([\"\",et,0])}else{if(\"justify\"!==u)throw new Error('Unrecognized alignment option, use \"left\", \"center\", \"right\" or \"justify\".');t=[],C=s.length,h=0!==h?h:V;for(rt=0;rt<C;rt++)X=0===rt?yr(n):-W,K=0===rt?br(r):0,rt<C-1?Y.push(E(U((h-H[rt])/(s[rt].split(\" \").length-1)))):Y.push(0),t.push([s[rt],K,X])}}var st=\"boolean\"==typeof i.R2L?i.R2L:bt;!0===st&&(t=_(t,(function(t,e,r){return[t.split(\"\").reverse().join(\"\"),e,r]}))),o={text:t,x:r,y:n,options:i,mutex:{pdfEscape:Ce,activeFontKey:St,fonts:It,activeFontSize:gt}},Tt.publish(\"postProcessText\",o),t=o.text,y=o.mutex.isHex||!1;var ct=It[St].encoding;\"WinAnsiEncoding\"!==ct&&\"StandardEncoding\"!==ct||(t=_(t,(function(t,e,r){return[L(t),e,r]}))),s=A(t),t=[];for(var ut,lt,ft,dt=0,pt=1,mt=Array.isArray(s[0])?pt:dt,vt=\"\",yt=function(t,e,r){var n=\"\";return r instanceof Vt?(r=\"number\"==typeof i.angle?Gt(r,new Vt(1,0,0,1,t,e)):Gt(new Vt(1,0,0,1,t,e),r),S===x.ADVANCED&&(r=Gt(new Vt(1,0,0,-1,0,0),r)),n=r.join(\" \")+\" Tm\\n\"):n=E(t)+\" \"+E(e)+\" Td\\n\",n},wt=0;wt<s.length;wt++){switch(vt=\"\",mt){case pt:ft=(y?\"<\":\"(\")+s[wt][0]+(y?\">\":\")\"),ut=parseFloat(s[wt][1]),lt=parseFloat(s[wt][2]);break;case dt:ft=(y?\"<\":\"(\")+s[wt]+(y?\">\":\")\"),ut=br(r),lt=yr(n)}void 0!==Y&&void 0!==Y[wt]&&(vt=Y[wt]+\" Tw\\n\"),0===wt?t.push(vt+yt(ut,lt,p)+ft):mt===dt?t.push(vt+ft):mt===pt&&t.push(vt+yt(ut,lt,p)+ft)}t=mt===dt?t.join(\" Tj\\nT* \"):t.join(\" Tj\\n\"),t+=\" Tj\\n\";var Nt=\"BT\\n/\";return Nt+=St+\" \"+gt+\" Tf\\n\",Nt+=E(gt*w)+\" TL\\n\",Nt+=xr+\"\\n\",Nt+=v,Nt+=t,ht(Nt+=\"ET\"),b[St]=!0,g};var $e=y.__private__.clip=y.clip=function(t){return ht(\"evenodd\"===t?\"W*\":\"W\"),this};y.clipEvenOdd=function(){return $e(\"evenodd\")},y.__private__.discardPath=y.discardPath=function(){return ht(\"n\"),this};var Qe=y.__private__.isValidStyle=function(t){var e=!1;return-1!==[void 0,null,\"S\",\"D\",\"F\",\"DF\",\"FD\",\"f\",\"f*\",\"B\",\"B*\",\"n\"].indexOf(t)&&(e=!0),e};y.__private__.setDefaultPathOperation=y.setDefaultPathOperation=function(t){return Qe(t)&&(g=t),this};var tr=y.__private__.getStyle=y.getStyle=function(t){var e=g;switch(t){case\"D\":case\"S\":e=\"S\";break;case\"F\":e=\"f\";break;case\"FD\":case\"DF\":e=\"B\";break;case\"f\":case\"f*\":case\"B\":case\"B*\":e=t}return e},er=y.close=function(){return ht(\"h\"),this};y.stroke=function(){return ht(\"S\"),this},y.fill=function(t){return rr(\"f\",t),this},y.fillEvenOdd=function(t){return rr(\"f*\",t),this},y.fillStroke=function(t){return rr(\"B\",t),this},y.fillStrokeEvenOdd=function(t){return rr(\"B*\",t),this};var rr=function(t,r){\"object\"===e(r)?ar(r,t):ht(t)},nr=function(t){null===t||S===x.ADVANCED&&void 0===t||(t=tr(t),ht(t))};function ir(t,e,r,n,i){var a=new B(e||this.boundingBox,r||this.xStep,n||this.yStep,this.gState,i||this.matrix);a.stream=this.stream;var o=t+\"$$\"+this.cloneIndex+++\"$$\";return Jt(o,a),a}var ar=function(t,e){var r=Bt[t.key],n=Ot[r];if(n instanceof O)ht(\"q\"),ht(or(e)),n.gState&&y.setGState(n.gState),ht(t.matrix.toString()+\" cm\"),ht(\"/\"+r+\" sh\"),ht(\"Q\");else if(n instanceof B){var i=new Vt(1,0,0,-1,0,Rr());t.matrix&&(i=i.multiply(t.matrix||Yt),r=ir.call(n,t.key,t.boundingBox,t.xStep,t.yStep,i).id),ht(\"q\"),ht(\"/Pattern cs\"),ht(\"/\"+r+\" scn\"),n.gState&&y.setGState(n.gState),ht(e),ht(\"Q\")}},or=function(t){switch(t){case\"f\":case\"F\":return\"W n\";case\"f*\":return\"W* n\";case\"B\":return\"W S\";case\"B*\":return\"W* S\";case\"S\":return\"W S\";case\"n\":return\"W n\"}},sr=y.moveTo=function(t,e){return ht(E(U(t))+\" \"+E(H(e))+\" m\"),this},cr=y.lineTo=function(t,e){return ht(E(U(t))+\" \"+E(H(e))+\" l\"),this},ur=y.curveTo=function(t,e,r,n,i,a){return ht([E(U(t)),E(H(e)),E(U(r)),E(H(n)),E(U(i)),E(H(a)),\"c\"].join(\" \")),this};y.__private__.line=y.line=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Qe(i))throw new Error(\"Invalid arguments passed to jsPDF.line\");return S===x.COMPAT?this.lines([[r-t,n-e]],t,e,[1,1],i||\"S\"):this.lines([[r-t,n-e]],t,e,[1,1]).stroke()},y.__private__.lines=y.lines=function(t,e,r,n,i,a){var o,s,c,u,l,h,f,d,p,g,m,v;if(\"number\"==typeof t&&(v=r,r=e,e=t,t=v),n=n||[1,1],a=a||!1,isNaN(e)||isNaN(r)||!Array.isArray(t)||!Array.isArray(n)||!Qe(i)||\"boolean\"!=typeof a)throw new Error(\"Invalid arguments passed to jsPDF.lines\");for(sr(e,r),o=n[0],s=n[1],u=t.length,g=e,m=r,c=0;c<u;c++)2===(l=t[c]).length?(g=l[0]*o+g,m=l[1]*s+m,cr(g,m)):(h=l[0]*o+g,f=l[1]*s+m,d=l[2]*o+g,p=l[3]*s+m,g=l[4]*o+g,m=l[5]*s+m,ur(h,f,d,p,g,m));return a&&er(),nr(i),this},y.path=function(t){for(var e=0;e<t.length;e++){var r=t[e],n=r.c;switch(r.op){case\"m\":sr(n[0],n[1]);break;case\"l\":cr(n[0],n[1]);break;case\"c\":ur.apply(this,n);break;case\"h\":er()}}return this},y.__private__.rect=y.rect=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Qe(i))throw new Error(\"Invalid arguments passed to jsPDF.rect\");return S===x.COMPAT&&(n=-n),ht([E(U(t)),E(H(e)),E(U(r)),E(U(n)),\"re\"].join(\" \")),nr(i),this},y.__private__.triangle=y.triangle=function(t,e,r,n,i,a,o){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i)||isNaN(a)||!Qe(o))throw new Error(\"Invalid arguments passed to jsPDF.triangle\");return this.lines([[r-t,n-e],[i-r,a-n],[t-i,e-a]],t,e,[1,1],o,!0),this},y.__private__.roundedRect=y.roundedRect=function(t,e,r,n,i,a,o){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i)||isNaN(a)||!Qe(o))throw new Error(\"Invalid arguments passed to jsPDF.roundedRect\");var s=4/3*(Math.SQRT2-1);return i=Math.min(i,.5*r),a=Math.min(a,.5*n),this.lines([[r-2*i,0],[i*s,0,i,a-a*s,i,a],[0,n-2*a],[0,a*s,-i*s,a,-i,a],[2*i-r,0],[-i*s,0,-i,-a*s,-i,-a],[0,2*a-n],[0,-a*s,i*s,-a,i,-a]],t+i,e,[1,1],o,!0),this},y.__private__.ellipse=y.ellipse=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Qe(i))throw new Error(\"Invalid arguments passed to jsPDF.ellipse\");var a=4/3*(Math.SQRT2-1)*r,o=4/3*(Math.SQRT2-1)*n;return sr(t+r,e),ur(t+r,e-o,t+a,e-n,t,e-n),ur(t-a,e-n,t-r,e-o,t-r,e),ur(t-r,e+o,t-a,e+n,t,e+n),ur(t+a,e+n,t+r,e+o,t+r,e),nr(i),this},y.__private__.circle=y.circle=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||!Qe(n))throw new Error(\"Invalid arguments passed to jsPDF.circle\");return this.ellipse(t,e,r,r,n)},y.setFont=function(t,e,r){return r&&(e=j(e,r)),St=qe(t,e,{disableWarning:!1}),this};var lr=y.__private__.getFont=y.getFont=function(){return It[qe.apply(y,arguments)]};y.__private__.getFontList=y.getFontList=function(){var t,e,r={};for(t in Ct)if(Ct.hasOwnProperty(t))for(e in r[t]=[],Ct[t])Ct[t].hasOwnProperty(e)&&r[t].push(e);return r},y.addFont=function(t,e,r,n,i){var a=[\"StandardEncoding\",\"MacRomanEncoding\",\"Identity-H\",\"WinAnsiEncoding\"];return arguments[3]&&-1!==a.indexOf(arguments[3])?i=arguments[3]:arguments[3]&&-1==a.indexOf(arguments[3])&&(r=j(r,n)),i=i||\"Identity-H\",Pe.call(this,t,e,r,i)};var hr,fr=t.lineWidth||.200025,dr=y.__private__.getLineWidth=y.getLineWidth=function(){return fr},pr=y.__private__.setLineWidth=y.setLineWidth=function(t){return fr=t,ht(E(U(t))+\" w\"),this};y.__private__.setLineDash=M.API.setLineDash=M.API.setLineDashPattern=function(t,e){if(t=t||[],e=e||0,isNaN(e)||!Array.isArray(t))throw new Error(\"Invalid arguments passed to jsPDF.setLineDash\");return t=t.map((function(t){return E(U(t))})).join(\" \"),e=E(U(e)),ht(\"[\"+t+\"] \"+e+\" d\"),this};var gr=y.__private__.getLineHeight=y.getLineHeight=function(){return gt*hr};y.__private__.getLineHeight=y.getLineHeight=function(){return gt*hr};var mr=y.__private__.setLineHeightFactor=y.setLineHeightFactor=function(t){return\"number\"==typeof(t=t||1.15)&&(hr=t),this},vr=y.__private__.getLineHeightFactor=y.getLineHeightFactor=function(){return hr};mr(t.lineHeight);var br=y.__private__.getHorizontalCoordinate=function(t){return U(t)},yr=y.__private__.getVerticalCoordinate=function(t){return S===x.ADVANCED?t:Rt[$].mediaBox.topRightY-Rt[$].mediaBox.bottomLeftY-U(t)},wr=y.__private__.getHorizontalCoordinateString=y.getHorizontalCoordinateString=function(t){return E(br(t))},Nr=y.__private__.getVerticalCoordinateString=y.getVerticalCoordinateString=function(t){return E(yr(t))},Lr=t.strokeColor||\"0 G\";y.__private__.getStrokeColor=y.getDrawColor=function(){return ee(Lr)},y.__private__.setStrokeColor=y.setDrawColor=function(t,e,r,n){return Lr=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:\"draw\",precision:2}),ht(Lr),this};var Ar=t.fillColor||\"0 g\";y.__private__.getFillColor=y.getFillColor=function(){return ee(Ar)},y.__private__.setFillColor=y.setFillColor=function(t,e,r,n){return Ar=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:\"fill\",precision:2}),ht(Ar),this};var xr=t.textColor||\"0 g\",Sr=y.__private__.getTextColor=y.getTextColor=function(){return ee(xr)};y.__private__.setTextColor=y.setTextColor=function(t,e,r,n){return xr=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:\"text\",precision:3}),this};var _r=t.charSpace,Pr=y.__private__.getCharSpace=y.getCharSpace=function(){return parseFloat(_r||0)};y.__private__.setCharSpace=y.setCharSpace=function(t){if(isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.setCharSpace\");return _r=t,this};var kr=0;y.CapJoinStyles={0:0,butt:0,but:0,miter:0,1:1,round:1,rounded:1,circle:1,2:2,projecting:2,project:2,square:2,bevel:2},y.__private__.setLineCap=y.setLineCap=function(t){var e=y.CapJoinStyles[t];if(void 0===e)throw new Error(\"Line cap style of '\"+t+\"' is not recognized. See or extend .CapJoinStyles property for valid styles\");return kr=e,ht(e+\" J\"),this};var Fr=0;y.__private__.setLineJoin=y.setLineJoin=function(t){var e=y.CapJoinStyles[t];if(void 0===e)throw new Error(\"Line join style of '\"+t+\"' is not recognized. See or extend .CapJoinStyles property for valid styles\");return Fr=e,ht(e+\" j\"),this},y.__private__.setLineMiterLimit=y.__private__.setMiterLimit=y.setLineMiterLimit=y.setMiterLimit=function(t){if(t=t||0,isNaN(t))throw new Error(\"Invalid argument passed to jsPDF.setLineMiterLimit\");return ht(E(U(t))+\" M\"),this},y.GState=C,y.setGState=function(t){(t=\"string\"==typeof t?Mt[Et[t]]:Ir(null,t)).equals(qt)||(ht(\"/\"+t.id+\" gs\"),qt=t)};var Ir=function(t,e){if(!t||!Et[t]){var r=!1;for(var n in Mt)if(Mt.hasOwnProperty(n)&&Mt[n].equals(e)){r=!0;break}if(r)e=Mt[n];else{var i=\"GS\"+(Object.keys(Mt).length+1).toString(10);Mt[i]=e,e.id=i}return t&&(Et[t]=e.id),Tt.publish(\"addGState\",e),e}};y.addGState=function(t,e){return Ir(t,e),this},y.saveGraphicsState=function(){return ht(\"q\"),jt.push({key:St,size:gt,color:xr}),this},y.restoreGraphicsState=function(){ht(\"Q\");var t=jt.pop();return St=t.key,gt=t.size,xr=t.color,qt=null,this},y.setCurrentTransformationMatrix=function(t){return ht(t.toString()+\" cm\"),this},y.comment=function(t){return ht(\"#\"+t),this};var Cr=function(t,e){var r=t||0;Object.defineProperty(this,\"x\",{enumerable:!0,get:function(){return r},set:function(t){isNaN(t)||(r=parseFloat(t))}});var n=e||0;Object.defineProperty(this,\"y\",{enumerable:!0,get:function(){return n},set:function(t){isNaN(t)||(n=parseFloat(t))}});var i=\"pt\";return Object.defineProperty(this,\"type\",{enumerable:!0,get:function(){return i},set:function(t){i=t.toString()}}),this},jr=function(t,e,r,n){Cr.call(this,t,e),this.type=\"rect\";var i=r||0;Object.defineProperty(this,\"w\",{enumerable:!0,get:function(){return i},set:function(t){isNaN(t)||(i=parseFloat(t))}});var a=n||0;return Object.defineProperty(this,\"h\",{enumerable:!0,get:function(){return a},set:function(t){isNaN(t)||(a=parseFloat(t))}}),this},Or=function(){this.page=Dt,this.currentPage=$,this.pages=ot.slice(0),this.pagesContext=Rt.slice(0),this.x=Pt,this.y=kt,this.matrix=Ft,this.width=qr($),this.height=Rr($),this.outputDestination=ct,this.id=\"\",this.objectNumber=-1};Or.prototype.restore=function(){Dt=this.page,$=this.currentPage,Rt=this.pagesContext,ot=this.pages,Pt=this.x,kt=this.y,Ft=this.matrix,Dr($,this.width),Tr($,this.height),ct=this.outputDestination};var Br=function(t,e,r,n,i){Wt.push(new Or),Dt=$=0,ot=[],Pt=t,kt=e,Ft=i,je([r,n])},Mr=function(t){if(Ht[t])Wt.pop().restore();else{var e=new Or,r=\"Xo\"+(Object.keys(zt).length+1).toString(10);e.id=r,Ht[t]=r,zt[r]=e,Tt.publish(\"addFormObject\",e),Wt.pop().restore()}};for(var Er in y.beginFormObject=function(t,e,r,n,i){return Br(t,e,r,n,i),this},y.endFormObject=function(t){return Mr(t),this},y.doFormObject=function(t,e){var r=zt[Ht[t]];return ht(\"q\"),ht(e.toString()+\" cm\"),ht(\"/\"+r.id+\" Do\"),ht(\"Q\"),this},y.getFormObject=function(t){var e=zt[Ht[t]];return{x:e.x,y:e.y,width:e.width,height:e.height,matrix:e.matrix}},y.save=function(t,e){return t=t||\"generated.pdf\",(e=e||{}).returnPromise=e.returnPromise||!1,!1===e.returnPromise?(l(We(He()),t),\"function\"==typeof l.unload&&r.setTimeout&&setTimeout(l.unload,911),this):new Promise((function(e,n){try{var i=l(We(He()),t);\"function\"==typeof l.unload&&r.setTimeout&&setTimeout(l.unload,911),e(i)}catch(t){n(t.message)}}))},M.API)M.API.hasOwnProperty(Er)&&(\"events\"===Er&&M.API.events.length?function(t,e){var r,n,i;for(i=e.length-1;-1!==i;i--)r=e[i][0],n=e[i][1],t.subscribe.apply(t,[r].concat(\"function\"==typeof n?[n]:n))}(Tt,M.API.events):y[Er]=M.API[Er]);var qr=y.getPageWidth=function(t){return(Rt[t=t||$].mediaBox.topRightX-Rt[t].mediaBox.bottomLeftX)/_t},Dr=y.setPageWidth=function(t,e){Rt[t].mediaBox.topRightX=e*_t+Rt[t].mediaBox.bottomLeftX},Rr=y.getPageHeight=function(t){return(Rt[t=t||$].mediaBox.topRightY-Rt[t].mediaBox.bottomLeftY)/_t},Tr=y.setPageHeight=function(t,e){Rt[t].mediaBox.topRightY=e*_t+Rt[t].mediaBox.bottomLeftY};return y.internal={pdfEscape:Ce,getStyle:tr,getFont:lr,getFontSize:vt,getCharSpace:Pr,getTextColor:Sr,getLineHeight:gr,getLineHeightFactor:vr,getLineWidth:dr,write:ft,getHorizontalCoordinate:br,getVerticalCoordinate:yr,getCoordinateString:wr,getVerticalCoordinateString:Nr,collections:{},newObject:Xt,newAdditionalObject:$t,newObjectDeferred:Kt,newObjectDeferredBegin:Zt,getFilters:ne,putStream:ie,events:Tt,scaleFactor:_t,pageSize:{getWidth:function(){return qr($)},setWidth:function(t){Dr($,t)},getHeight:function(){return Rr($)},setHeight:function(t){Tr($,t)}},encryptionOptions:m,encryption:Ye,getEncryptor:Je,output:Ve,getNumberOfPages:Ee,pages:ot,out:ht,f2:R,f3:T,getPageInfo:Xe,getPageInfoByObjId:Ke,getCurrentPageInfo:Ze,getPDFVersion:N,Point:Cr,Rectangle:jr,Matrix:Vt,hasHotfix:Ge},Object.defineProperty(y.internal.pageSize,\"width\",{get:function(){return qr($)},set:function(t){Dr($,t)},enumerable:!0,configurable:!0}),Object.defineProperty(y.internal.pageSize,\"height\",{get:function(){return Rr($)},set:function(t){Tr($,t)},enumerable:!0,configurable:!0}),ke.call(y,pt),St=\"F1\",Oe(s,a),Tt.publish(\"initialized\"),y}k.prototype.lsbFirstWord=function(t){return String.fromCharCode(t>>0&255,t>>8&255,t>>16&255,t>>24&255)},k.prototype.toHexString=function(t){return t.split(\"\").map((function(t){return(\"0\"+(255&t.charCodeAt(0)).toString(16)).slice(-2)})).join(\"\")},k.prototype.hexToBytes=function(t){for(var e=[],r=0;r<t.length;r+=2)e.push(String.fromCharCode(parseInt(t.substr(r,2),16)));return e.join(\"\")},k.prototype.processOwnerPassword=function(t,e){return _(A(e).substr(0,5),t)},k.prototype.encryptor=function(t,e){var r=A(this.encryptionKey+String.fromCharCode(255&t,t>>8&255,t>>16&255,255&e,e>>8&255)).substr(0,10);return function(t){return _(r,t)}},C.prototype.equals=function(t){var r,n=\"id,objectNumber,equals\";if(!t||e(t)!==e(this))return!1;var i=0;for(r in this)if(!(n.indexOf(r)>=0)){if(this.hasOwnProperty(r)&&!t.hasOwnProperty(r))return!1;if(this[r]!==t[r])return!1;i++}for(r in t)t.hasOwnProperty(r)&&n.indexOf(r)<0&&i--;return 0===i},M.API={events:[]},M.version=\"3.0.1\";var E=M.API,q=1,D=function(t){return t.replace(/\\\\/g,\"\\\\\\\\\").replace(/\\(/g,\"\\\\(\").replace(/\\)/g,\"\\\\)\")},R=function(t){return t.replace(/\\\\\\\\/g,\"\\\\\").replace(/\\\\\\(/g,\"(\").replace(/\\\\\\)/g,\")\")},T=function(t){return t.toFixed(2)},U=function(t){return t.toFixed(5)};E.__acroform__={};var z=function(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t},H=function(t){return t*q},W=function(t){var e=new ct,r=Lt.internal.getHeight(t)||0,n=Lt.internal.getWidth(t)||0;return e.BBox=[0,0,Number(T(n)),Number(T(r))],e},V=E.__acroform__.setBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.setBit\");return t|=1<<e},G=E.__acroform__.clearBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.clearBit\");return t&=~(1<<e)},Y=E.__acroform__.getBit=function(t,e){if(isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.getBit\");return 0==(t&1<<e)?0:1},J=E.__acroform__.getBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.getBitForPdf\");return Y(t,e-1)},X=E.__acroform__.setBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.setBitForPdf\");return V(t,e-1)},K=E.__acroform__.clearBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error(\"Invalid arguments passed to jsPDF.API.__acroform__.clearBitForPdf\");return G(t,e-1)},Z=E.__acroform__.calculateCoordinates=function(t,e){var r=e.internal.getHorizontalCoordinate,n=e.internal.getVerticalCoordinate,i=t[0],a=t[1],o=t[2],s=t[3],c={};return c.lowerLeft_X=r(i)||0,c.lowerLeft_Y=n(a+s)||0,c.upperRight_X=r(i+o)||0,c.upperRight_Y=n(a)||0,[Number(T(c.lowerLeft_X)),Number(T(c.lowerLeft_Y)),Number(T(c.upperRight_X)),Number(T(c.upperRight_Y))]},$=function(t){if(t.appearanceStreamContent)return t.appearanceStreamContent;if(t.V||t.DV){var e=[],r=t._V||t.DV,n=Q(t,r),i=t.scope.internal.getFont(t.fontName,t.fontStyle).id;e.push(\"/Tx BMC\"),e.push(\"q\"),e.push(\"BT\"),e.push(t.scope.__private__.encodeColorString(t.color)),e.push(\"/\"+i+\" \"+T(n.fontSize)+\" Tf\"),e.push(\"1 0 0 1 0 0 Tm\"),e.push(n.text),e.push(\"ET\"),e.push(\"Q\"),e.push(\"EMC\");var a=W(t);return a.scope=t.scope,a.stream=e.join(\"\\n\"),a}},Q=function(t,e){var r=0===t.fontSize?t.maxFontSize:t.fontSize,n={text:\"\",fontSize:\"\"},i=(e=\")\"==(e=\"(\"==e.substr(0,1)?e.substr(1):e).substr(e.length-1)?e.substr(0,e.length-1):e).split(\" \");i=t.multiline?i.map((function(t){return t.split(\"\\n\")})):i.map((function(t){return[t]}));var a=r,o=Lt.internal.getHeight(t)||0;o=o<0?-o:o;var s=Lt.internal.getWidth(t)||0;s=s<0?-s:s;var c=function(e,r,n){if(e+1<i.length){var a=r+\" \"+i[e+1][0];return tt(a,t,n).width<=s-4}return!1};a++;t:for(;a>0;){e=\"\",a--;var u,l,h=tt(\"3\",t,a).height,f=t.multiline?o-a:(o-h)/2,d=f+=2,p=0,g=0,m=0;if(a<=0){e=\"(...) Tj\\n\",e+=\"% Width of Text: \"+tt(e,t,a=12).width+\", FieldWidth:\"+s+\"\\n\";break}for(var v=\"\",b=0,y=0;y<i.length;y++)if(i.hasOwnProperty(y)){var w=!1;if(1!==i[y].length&&m!==i[y].length-1){if((h+2)*(b+2)+2>o)continue t;v+=i[y][m],w=!0,g=y,y--}else{v=\" \"==(v+=i[y][m]+\" \").substr(v.length-1)?v.substr(0,v.length-1):v;var N=parseInt(y),L=c(N,v,a),A=y>=i.length-1;if(L&&!A){v+=\" \",m=0;continue}if(L||A){if(A)g=N;else if(t.multiline&&(h+2)*(b+2)+2>o)continue t}else{if(!t.multiline)continue t;if((h+2)*(b+2)+2>o)continue t;g=N}}for(var x=\"\",S=p;S<=g;S++){var _=i[S];if(t.multiline){if(S===g){x+=_[m]+\" \",m=(m+1)%_.length;continue}if(S===p){x+=_[_.length-1]+\" \";continue}}x+=_[0]+\" \"}switch(x=\" \"==x.substr(x.length-1)?x.substr(0,x.length-1):x,l=tt(x,t,a).width,t.textAlign){case\"right\":u=s-l-2;break;case\"center\":u=(s-l)/2;break;case\"left\":default:u=2}e+=T(u)+\" \"+T(d)+\" Td\\n\",e+=\"(\"+D(x)+\") Tj\\n\",e+=-T(u)+\" 0 Td\\n\",d=-(a+2),l=0,p=w?g:g+1,b++,v=\"\"}else;break}return n.text=e,n.fontSize=a,n},tt=function(t,e,r){var n=e.scope.internal.getFont(e.fontName,e.fontStyle),i=e.scope.getStringUnitWidth(t,{font:n,fontSize:parseFloat(r),charSpace:0})*parseFloat(r);return{height:e.scope.getStringUnitWidth(\"3\",{font:n,fontSize:parseFloat(r),charSpace:0})*parseFloat(r)*1.5,width:i}},et={fields:[],xForms:[],acroFormDictionaryRoot:null,printedOut:!1,internal:null,isInitialized:!1},rt=function(t,e){var r={type:\"reference\",object:t};void 0===e.internal.getPageInfo(t.page).pageContext.annotations.find((function(t){return t.type===r.type&&t.object===r.object}))&&e.internal.getPageInfo(t.page).pageContext.annotations.push(r)},nt=function(t,r){for(var n in t)if(t.hasOwnProperty(n)){var i=n,a=t[n];r.internal.newObjectDeferredBegin(a.objId,!0),\"object\"===e(a)&&\"function\"==typeof a.putStream&&a.putStream(),delete t[i]}},it=function(t,r){if(r.scope=t,void 0!==t.internal&&(void 0===t.internal.acroformPlugin||!1===t.internal.acroformPlugin.isInitialized)){if(lt.FieldNum=0,t.internal.acroformPlugin=JSON.parse(JSON.stringify(et)),t.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error(\"Exception while creating AcroformDictionary\");q=t.internal.scaleFactor,t.internal.acroformPlugin.acroFormDictionaryRoot=new ut,t.internal.acroformPlugin.acroFormDictionaryRoot.scope=t,t.internal.acroformPlugin.acroFormDictionaryRoot._eventID=t.internal.events.subscribe(\"postPutResources\",(function(){!function(t){t.internal.events.unsubscribe(t.internal.acroformPlugin.acroFormDictionaryRoot._eventID),delete t.internal.acroformPlugin.acroFormDictionaryRoot._eventID,t.internal.acroformPlugin.printedOut=!0}(t)})),t.internal.events.subscribe(\"buildDocument\",(function(){!function(t){t.internal.acroformPlugin.acroFormDictionaryRoot.objId=void 0;var e=t.internal.acroformPlugin.acroFormDictionaryRoot.Fields;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];n.objId=void 0,n.hasAnnotation&&rt(n,t)}}(t)})),t.internal.events.subscribe(\"putCatalog\",(function(){!function(t){if(void 0===t.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error(\"putCatalogCallback: Root missing.\");t.internal.write(\"/AcroForm \"+t.internal.acroformPlugin.acroFormDictionaryRoot.objId+\" 0 R\")}(t)})),t.internal.events.subscribe(\"postPutPages\",(function(r){!function(t,r){var n=!t;for(var i in t||(r.internal.newObjectDeferredBegin(r.internal.acroformPlugin.acroFormDictionaryRoot.objId,!0),r.internal.acroformPlugin.acroFormDictionaryRoot.putStream()),t=t||r.internal.acroformPlugin.acroFormDictionaryRoot.Kids)if(t.hasOwnProperty(i)){var a=t[i],o=[],s=a.Rect;if(a.Rect&&(a.Rect=Z(a.Rect,r)),r.internal.newObjectDeferredBegin(a.objId,!0),a.DA=Lt.createDefaultAppearanceStream(a),\"object\"===e(a)&&\"function\"==typeof a.getKeyValueListForStream&&(o=a.getKeyValueListForStream()),a.Rect=s,a.hasAppearanceStream&&!a.appearanceStreamContent){var c=$(a);o.push({key:\"AP\",value:\"<</N \"+c+\">>\"}),r.internal.acroformPlugin.xForms.push(c)}if(a.appearanceStreamContent){var u=\"\";for(var l in a.appearanceStreamContent)if(a.appearanceStreamContent.hasOwnProperty(l)){var h=a.appearanceStreamContent[l];if(u+=\"/\"+l+\" \",u+=\"<<\",Object.keys(h).length>=1||Array.isArray(h)){for(var i in h)if(h.hasOwnProperty(i)){var f=h[i];\"function\"==typeof f&&(f=f.call(r,a)),u+=\"/\"+i+\" \"+f+\" \",r.internal.acroformPlugin.xForms.indexOf(f)>=0||r.internal.acroformPlugin.xForms.push(f)}}else\"function\"==typeof(f=h)&&(f=f.call(r,a)),u+=\"/\"+i+\" \"+f,r.internal.acroformPlugin.xForms.indexOf(f)>=0||r.internal.acroformPlugin.xForms.push(f);u+=\">>\"}o.push({key:\"AP\",value:\"<<\\n\"+u+\">>\"})}r.internal.putStream({additionalKeyValues:o,objectId:a.objId}),r.internal.out(\"endobj\")}n&&nt(r.internal.acroformPlugin.xForms,r)}(r,t)})),t.internal.acroformPlugin.isInitialized=!0}},at=E.__acroform__.arrayToPdfArray=function(t,r,n){var i=function(t){return t};if(Array.isArray(t)){for(var a=\"[\",o=0;o<t.length;o++)switch(0!==o&&(a+=\" \"),e(t[o])){case\"boolean\":case\"number\":case\"object\":a+=t[o].toString();break;case\"string\":\"/\"!==t[o].substr(0,1)?(void 0!==r&&n&&(i=n.internal.getEncryptor(r)),a+=\"(\"+D(i(t[o].toString()))+\")\"):a+=t[o].toString()}return a+=\"]\"}throw new Error(\"Invalid argument passed to jsPDF.__acroform__.arrayToPdfArray\")};var ot=function(t,e,r){var n=function(t){return t};return void 0!==e&&r&&(n=r.internal.getEncryptor(e)),(t=t||\"\").toString(),t=\"(\"+D(n(t))+\")\"},st=function(){this._objId=void 0,this._scope=void 0,Object.defineProperty(this,\"objId\",{get:function(){if(void 0===this._objId){if(void 0===this.scope)return;this._objId=this.scope.internal.newObjectDeferred()}return this._objId},set:function(t){this._objId=t}}),Object.defineProperty(this,\"scope\",{value:this._scope,writable:!0})};st.prototype.toString=function(){return this.objId+\" 0 R\"},st.prototype.putStream=function(){var t=this.getKeyValueListForStream();this.scope.internal.putStream({data:this.stream,additionalKeyValues:t,objectId:this.objId}),this.scope.internal.out(\"endobj\")},st.prototype.getKeyValueListForStream=function(){var t=[],e=Object.getOwnPropertyNames(this).filter((function(t){return\"content\"!=t&&\"appearanceStreamContent\"!=t&&\"scope\"!=t&&\"objId\"!=t&&\"_\"!=t.substring(0,1)}));for(var r in e)if(!1===Object.getOwnPropertyDescriptor(this,e[r]).configurable){var n=e[r],i=this[n];i&&(Array.isArray(i)?t.push({key:n,value:at(i,this.objId,this.scope)}):i instanceof st?(i.scope=this.scope,t.push({key:n,value:i.objId+\" 0 R\"})):\"function\"!=typeof i&&t.push({key:n,value:i}))}return t};var ct=function(){st.call(this),Object.defineProperty(this,\"Type\",{value:\"/XObject\",configurable:!1,writable:!0}),Object.defineProperty(this,\"Subtype\",{value:\"/Form\",configurable:!1,writable:!0}),Object.defineProperty(this,\"FormType\",{value:1,configurable:!1,writable:!0});var t,e=[];Object.defineProperty(this,\"BBox\",{configurable:!1,get:function(){return e},set:function(t){e=t}}),Object.defineProperty(this,\"Resources\",{value:\"2 0 R\",configurable:!1,writable:!0}),Object.defineProperty(this,\"stream\",{enumerable:!1,configurable:!0,set:function(e){t=e.trim()},get:function(){return t||null}})};z(ct,st);var ut=function(){st.call(this);var t,e=[];Object.defineProperty(this,\"Kids\",{enumerable:!1,configurable:!0,get:function(){return e.length>0?e:void 0}}),Object.defineProperty(this,\"Fields\",{enumerable:!1,configurable:!1,get:function(){return e}}),Object.defineProperty(this,\"DA\",{enumerable:!1,configurable:!1,get:function(){if(t){var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),\"(\"+D(e(t))+\")\"}},set:function(e){t=e}})};z(ut,st);var lt=function t(){st.call(this);var e=4;Object.defineProperty(this,\"F\",{enumerable:!1,configurable:!1,get:function(){return e},set:function(t){if(isNaN(t))throw new Error('Invalid value \"'+t+'\" for attribute F supplied.');e=t}}),Object.defineProperty(this,\"showWhenPrinted\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(e,3))},set:function(t){!0===Boolean(t)?this.F=X(e,3):this.F=K(e,3)}});var r=0;Object.defineProperty(this,\"Ff\",{enumerable:!1,configurable:!1,get:function(){return r},set:function(t){if(isNaN(t))throw new Error('Invalid value \"'+t+'\" for attribute Ff supplied.');r=t}});var n=[];Object.defineProperty(this,\"Rect\",{enumerable:!1,configurable:!1,get:function(){if(0!==n.length)return n},set:function(t){n=void 0!==t?t:[]}}),Object.defineProperty(this,\"x\",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[0])?0:n[0]},set:function(t){n[0]=t}}),Object.defineProperty(this,\"y\",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[1])?0:n[1]},set:function(t){n[1]=t}}),Object.defineProperty(this,\"width\",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[2])?0:n[2]},set:function(t){n[2]=t}}),Object.defineProperty(this,\"height\",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[3])?0:n[3]},set:function(t){n[3]=t}});var i=\"\";Object.defineProperty(this,\"FT\",{enumerable:!0,configurable:!1,get:function(){return i},set:function(t){switch(t){case\"/Btn\":case\"/Tx\":case\"/Ch\":case\"/Sig\":i=t;break;default:throw new Error('Invalid value \"'+t+'\" for attribute FT supplied.')}}});var a=null;Object.defineProperty(this,\"T\",{enumerable:!0,configurable:!1,get:function(){if(!a||a.length<1){if(this instanceof bt)return;a=\"FieldObject\"+t.FieldNum++}var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),\"(\"+D(e(a))+\")\"},set:function(t){a=t.toString()}}),Object.defineProperty(this,\"fieldName\",{configurable:!0,enumerable:!0,get:function(){return a},set:function(t){a=t}});var o=\"helvetica\";Object.defineProperty(this,\"fontName\",{enumerable:!0,configurable:!0,get:function(){return o},set:function(t){o=t}});var s=\"normal\";Object.defineProperty(this,\"fontStyle\",{enumerable:!0,configurable:!0,get:function(){return s},set:function(t){s=t}});var c=0;Object.defineProperty(this,\"fontSize\",{enumerable:!0,configurable:!0,get:function(){return c},set:function(t){c=t}});var u=void 0;Object.defineProperty(this,\"maxFontSize\",{enumerable:!0,configurable:!0,get:function(){return void 0===u?50/q:u},set:function(t){u=t}});var l=\"black\";Object.defineProperty(this,\"color\",{enumerable:!0,configurable:!0,get:function(){return l},set:function(t){l=t}});var h=\"/F1 0 Tf 0 g\";Object.defineProperty(this,\"DA\",{enumerable:!0,configurable:!1,get:function(){if(!(!h||this instanceof bt||this instanceof wt))return ot(h,this.objId,this.scope)},set:function(t){t=t.toString(),h=t}});var f=null;Object.defineProperty(this,\"DV\",{enumerable:!1,configurable:!1,get:function(){if(f)return this instanceof gt==!1?ot(f,this.objId,this.scope):f},set:function(t){t=t.toString(),f=this instanceof gt==!1?\"(\"===t.substr(0,1)?R(t.substr(1,t.length-2)):R(t):t}}),Object.defineProperty(this,\"defaultValue\",{enumerable:!0,configurable:!0,get:function(){return this instanceof gt==!0?R(f.substr(1,f.length-1)):f},set:function(t){t=t.toString(),f=this instanceof gt==!0?\"/\"+t:t}});var d=null;Object.defineProperty(this,\"_V\",{enumerable:!1,configurable:!1,get:function(){if(d)return d},set:function(t){this.V=t}}),Object.defineProperty(this,\"V\",{enumerable:!1,configurable:!1,get:function(){if(d)return this instanceof gt==!1?ot(d,this.objId,this.scope):d},set:function(t){t=t.toString(),d=this instanceof gt==!1?\"(\"===t.substr(0,1)?R(t.substr(1,t.length-2)):R(t):t}}),Object.defineProperty(this,\"value\",{enumerable:!0,configurable:!0,get:function(){return this instanceof gt==!0?R(d.substr(1,d.length-1)):d},set:function(t){t=t.toString(),d=this instanceof gt==!0?\"/\"+t:t}}),Object.defineProperty(this,\"hasAnnotation\",{enumerable:!0,configurable:!0,get:function(){return this.Rect}}),Object.defineProperty(this,\"Type\",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?\"/Annot\":null}}),Object.defineProperty(this,\"Subtype\",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?\"/Widget\":null}});var p,g=!1;Object.defineProperty(this,\"hasAppearanceStream\",{enumerable:!0,configurable:!0,get:function(){return g},set:function(t){t=Boolean(t),g=t}}),Object.defineProperty(this,\"page\",{enumerable:!0,configurable:!0,get:function(){if(p)return p},set:function(t){p=t}}),Object.defineProperty(this,\"readOnly\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,1))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,1):this.Ff=K(this.Ff,1)}}),Object.defineProperty(this,\"required\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,2))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,2):this.Ff=K(this.Ff,2)}}),Object.defineProperty(this,\"noExport\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,3))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,3):this.Ff=K(this.Ff,3)}});var m=null;Object.defineProperty(this,\"Q\",{enumerable:!0,configurable:!1,get:function(){if(null!==m)return m},set:function(t){if(-1===[0,1,2].indexOf(t))throw new Error('Invalid value \"'+t+'\" for attribute Q supplied.');m=t}}),Object.defineProperty(this,\"textAlign\",{get:function(){var t;switch(m){case 0:default:t=\"left\";break;case 1:t=\"center\";break;case 2:t=\"right\"}return t},configurable:!0,enumerable:!0,set:function(t){switch(t){case\"right\":case 2:m=2;break;case\"center\":case 1:m=1;break;case\"left\":case 0:default:m=0}}})};z(lt,st);var ht=function(){lt.call(this),this.FT=\"/Ch\",this.V=\"()\",this.fontName=\"zapfdingbats\";var t=0;Object.defineProperty(this,\"TI\",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,\"topIndex\",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){t=e}});var e=[];Object.defineProperty(this,\"Opt\",{enumerable:!0,configurable:!1,get:function(){return at(e,this.objId,this.scope)},set:function(t){var r,n;n=[],\"string\"==typeof(r=t)&&(n=function(t,e,r){r||(r=1);for(var n,i=[];n=e.exec(t);)i.push(n[r]);return i}(r,/\\((.*?)\\)/g)),e=n}}),this.getOptions=function(){return e},this.setOptions=function(t){e=t,this.sort&&e.sort()},this.addOption=function(t){t=(t=t||\"\").toString(),e.push(t),this.sort&&e.sort()},this.removeOption=function(t,r){for(r=r||!1,t=(t=t||\"\").toString();-1!==e.indexOf(t)&&(e.splice(e.indexOf(t),1),!1!==r););},Object.defineProperty(this,\"combo\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,18))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,18):this.Ff=K(this.Ff,18)}}),Object.defineProperty(this,\"edit\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,19))},set:function(t){!0===this.combo&&(!0===Boolean(t)?this.Ff=X(this.Ff,19):this.Ff=K(this.Ff,19))}}),Object.defineProperty(this,\"sort\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,20))},set:function(t){!0===Boolean(t)?(this.Ff=X(this.Ff,20),e.sort()):this.Ff=K(this.Ff,20)}}),Object.defineProperty(this,\"multiSelect\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,22))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,22):this.Ff=K(this.Ff,22)}}),Object.defineProperty(this,\"doNotSpellCheck\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,23):this.Ff=K(this.Ff,23)}}),Object.defineProperty(this,\"commitOnSelChange\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,27))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,27):this.Ff=K(this.Ff,27)}}),this.hasAppearanceStream=!1};z(ht,lt);var ft=function(){ht.call(this),this.fontName=\"helvetica\",this.combo=!1};z(ft,ht);var dt=function(){ft.call(this),this.combo=!0};z(dt,ft);var pt=function(){dt.call(this),this.edit=!0};z(pt,dt);var gt=function(){lt.call(this),this.FT=\"/Btn\",Object.defineProperty(this,\"noToggleToOff\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,15))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,15):this.Ff=K(this.Ff,15)}}),Object.defineProperty(this,\"radio\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,16))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,16):this.Ff=K(this.Ff,16)}}),Object.defineProperty(this,\"pushButton\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,17))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,17):this.Ff=K(this.Ff,17)}}),Object.defineProperty(this,\"radioIsUnison\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,26):this.Ff=K(this.Ff,26)}});var t,r={};Object.defineProperty(this,\"MK\",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};if(this.scope&&(t=this.scope.internal.getEncryptor(this.objId)),0!==Object.keys(r).length){var e,n=[];for(e in n.push(\"<<\"),r)n.push(\"/\"+e+\" (\"+D(t(r[e]))+\")\");return n.push(\">>\"),n.join(\"\\n\")}},set:function(t){\"object\"===e(t)&&(r=t)}}),Object.defineProperty(this,\"caption\",{enumerable:!0,configurable:!0,get:function(){return r.CA||\"\"},set:function(t){\"string\"==typeof t&&(r.CA=t)}}),Object.defineProperty(this,\"AS\",{enumerable:!1,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,\"appearanceState\",{enumerable:!0,configurable:!0,get:function(){return t.substr(1,t.length-1)},set:function(e){t=\"/\"+e}})};z(gt,lt);var mt=function(){gt.call(this),this.pushButton=!0};z(mt,gt);var vt=function(){gt.call(this),this.radio=!0,this.pushButton=!1;var t=[];Object.defineProperty(this,\"Kids\",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=void 0!==e?e:[]}})};z(vt,gt);var bt=function(){var t,r;lt.call(this),Object.defineProperty(this,\"Parent\",{enumerable:!1,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,\"optionName\",{enumerable:!1,configurable:!0,get:function(){return r},set:function(t){r=t}});var n,i={};Object.defineProperty(this,\"MK\",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};this.scope&&(t=this.scope.internal.getEncryptor(this.objId));var e,r=[];for(e in r.push(\"<<\"),i)r.push(\"/\"+e+\" (\"+D(t(i[e]))+\")\");return r.push(\">>\"),r.join(\"\\n\")},set:function(t){\"object\"===e(t)&&(i=t)}}),Object.defineProperty(this,\"caption\",{enumerable:!0,configurable:!0,get:function(){return i.CA||\"\"},set:function(t){\"string\"==typeof t&&(i.CA=t)}}),Object.defineProperty(this,\"AS\",{enumerable:!1,configurable:!1,get:function(){return n},set:function(t){n=t}}),Object.defineProperty(this,\"appearanceState\",{enumerable:!0,configurable:!0,get:function(){return n.substr(1,n.length-1)},set:function(t){n=\"/\"+t}}),this.caption=\"l\",this.appearanceState=\"Off\",this._AppearanceType=Lt.RadioButton.Circle,this.appearanceStreamContent=this._AppearanceType.createAppearanceStream(this.optionName)};z(bt,lt),vt.prototype.setAppearance=function(t){if(!(\"createAppearanceStream\"in t)||!(\"getCA\"in t))throw new Error(\"Couldn't assign Appearance to RadioButton. Appearance was Invalid!\");for(var e in this.Kids)if(this.Kids.hasOwnProperty(e)){var r=this.Kids[e];r.appearanceStreamContent=t.createAppearanceStream(r.optionName),r.caption=t.getCA()}},vt.prototype.createOption=function(t){var e=new bt;return e.Parent=this,e.optionName=t,this.Kids.push(e),At.call(this.scope,e),e};var yt=function(){gt.call(this),this.fontName=\"zapfdingbats\",this.caption=\"3\",this.appearanceState=\"On\",this.value=\"On\",this.textAlign=\"center\",this.appearanceStreamContent=Lt.CheckBox.createAppearanceStream()};z(yt,gt);var wt=function(){lt.call(this),this.FT=\"/Tx\",Object.defineProperty(this,\"multiline\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,13))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,13):this.Ff=K(this.Ff,13)}}),Object.defineProperty(this,\"fileSelect\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,21))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,21):this.Ff=K(this.Ff,21)}}),Object.defineProperty(this,\"doNotSpellCheck\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,23):this.Ff=K(this.Ff,23)}}),Object.defineProperty(this,\"doNotScroll\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,24))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,24):this.Ff=K(this.Ff,24)}}),Object.defineProperty(this,\"comb\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,25))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,25):this.Ff=K(this.Ff,25)}}),Object.defineProperty(this,\"richText\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,26):this.Ff=K(this.Ff,26)}});var t=null;Object.defineProperty(this,\"MaxLen\",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,\"maxLength\",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){Number.isInteger(e)&&(t=e)}}),Object.defineProperty(this,\"hasAppearanceStream\",{enumerable:!0,configurable:!0,get:function(){return this.V||this.DV}})};z(wt,lt);var Nt=function(){wt.call(this),Object.defineProperty(this,\"password\",{enumerable:!0,configurable:!0,get:function(){return Boolean(J(this.Ff,14))},set:function(t){!0===Boolean(t)?this.Ff=X(this.Ff,14):this.Ff=K(this.Ff,14)}}),this.password=!0};z(Nt,wt);var Lt={CheckBox:{createAppearanceStream:function(){return{N:{On:Lt.CheckBox.YesNormal},D:{On:Lt.CheckBox.YesPushDown,Off:Lt.CheckBox.OffPushDown}}},YesPushDown:function(t){var e=W(t);e.scope=t.scope;var r=[],n=t.scope.internal.getFont(t.fontName,t.fontStyle).id,i=t.scope.__private__.encodeColorString(t.color),a=Q(t,t.caption);return r.push(\"0.749023 g\"),r.push(\"0 0 \"+T(Lt.internal.getWidth(t))+\" \"+T(Lt.internal.getHeight(t))+\" re\"),r.push(\"f\"),r.push(\"BMC\"),r.push(\"q\"),r.push(\"0 0 1 rg\"),r.push(\"/\"+n+\" \"+T(a.fontSize)+\" Tf \"+i),r.push(\"BT\"),r.push(a.text),r.push(\"ET\"),r.push(\"Q\"),r.push(\"EMC\"),e.stream=r.join(\"\\n\"),e},YesNormal:function(t){var e=W(t);e.scope=t.scope;var r=t.scope.internal.getFont(t.fontName,t.fontStyle).id,n=t.scope.__private__.encodeColorString(t.color),i=[],a=Lt.internal.getHeight(t),o=Lt.internal.getWidth(t),s=Q(t,t.caption);return i.push(\"1 g\"),i.push(\"0 0 \"+T(o)+\" \"+T(a)+\" re\"),i.push(\"f\"),i.push(\"q\"),i.push(\"0 0 1 rg\"),i.push(\"0 0 \"+T(o-1)+\" \"+T(a-1)+\" re\"),i.push(\"W\"),i.push(\"n\"),i.push(\"0 g\"),i.push(\"BT\"),i.push(\"/\"+r+\" \"+T(s.fontSize)+\" Tf \"+n),i.push(s.text),i.push(\"ET\"),i.push(\"Q\"),e.stream=i.join(\"\\n\"),e},OffPushDown:function(t){var e=W(t);e.scope=t.scope;var r=[];return r.push(\"0.749023 g\"),r.push(\"0 0 \"+T(Lt.internal.getWidth(t))+\" \"+T(Lt.internal.getHeight(t))+\" re\"),r.push(\"f\"),e.stream=r.join(\"\\n\"),e}},RadioButton:{Circle:{createAppearanceStream:function(t){var e={D:{Off:Lt.RadioButton.Circle.OffPushDown},N:{}};return e.N[t]=Lt.RadioButton.Circle.YesNormal,e.D[t]=Lt.RadioButton.Circle.YesPushDown,e},getCA:function(){return\"l\"},YesNormal:function(t){var e=W(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Lt.internal.Bezier_C,a=Number((n*i).toFixed(5));return r.push(\"q\"),r.push(\"1 0 0 1 \"+U(Lt.internal.getWidth(t)/2)+\" \"+U(Lt.internal.getHeight(t)/2)+\" cm\"),r.push(n+\" 0 m\"),r.push(n+\" \"+a+\" \"+a+\" \"+n+\" 0 \"+n+\" c\"),r.push(\"-\"+a+\" \"+n+\" -\"+n+\" \"+a+\" -\"+n+\" 0 c\"),r.push(\"-\"+n+\" -\"+a+\" -\"+a+\" -\"+n+\" 0 -\"+n+\" c\"),r.push(a+\" -\"+n+\" \"+n+\" -\"+a+\" \"+n+\" 0 c\"),r.push(\"f\"),r.push(\"Q\"),e.stream=r.join(\"\\n\"),e},YesPushDown:function(t){var e=W(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Number((2*n).toFixed(5)),a=Number((i*Lt.internal.Bezier_C).toFixed(5)),o=Number((n*Lt.internal.Bezier_C).toFixed(5));return r.push(\"0.749023 g\"),r.push(\"q\"),r.push(\"1 0 0 1 \"+U(Lt.internal.getWidth(t)/2)+\" \"+U(Lt.internal.getHeight(t)/2)+\" cm\"),r.push(i+\" 0 m\"),r.push(i+\" \"+a+\" \"+a+\" \"+i+\" 0 \"+i+\" c\"),r.push(\"-\"+a+\" \"+i+\" -\"+i+\" \"+a+\" -\"+i+\" 0 c\"),r.push(\"-\"+i+\" -\"+a+\" -\"+a+\" -\"+i+\" 0 -\"+i+\" c\"),r.push(a+\" -\"+i+\" \"+i+\" -\"+a+\" \"+i+\" 0 c\"),r.push(\"f\"),r.push(\"Q\"),r.push(\"0 g\"),r.push(\"q\"),r.push(\"1 0 0 1 \"+U(Lt.internal.getWidth(t)/2)+\" \"+U(Lt.internal.getHeight(t)/2)+\" cm\"),r.push(n+\" 0 m\"),r.push(n+\" \"+o+\" \"+o+\" \"+n+\" 0 \"+n+\" c\"),r.push(\"-\"+o+\" \"+n+\" -\"+n+\" \"+o+\" -\"+n+\" 0 c\"),r.push(\"-\"+n+\" -\"+o+\" -\"+o+\" -\"+n+\" 0 -\"+n+\" c\"),r.push(o+\" -\"+n+\" \"+n+\" -\"+o+\" \"+n+\" 0 c\"),r.push(\"f\"),r.push(\"Q\"),e.stream=r.join(\"\\n\"),e},OffPushDown:function(t){var e=W(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Number((2*n).toFixed(5)),a=Number((i*Lt.internal.Bezier_C).toFixed(5));return r.push(\"0.749023 g\"),r.push(\"q\"),r.push(\"1 0 0 1 \"+U(Lt.internal.getWidth(t)/2)+\" \"+U(Lt.internal.getHeight(t)/2)+\" cm\"),r.push(i+\" 0 m\"),r.push(i+\" \"+a+\" \"+a+\" \"+i+\" 0 \"+i+\" c\"),r.push(\"-\"+a+\" \"+i+\" -\"+i+\" \"+a+\" -\"+i+\" 0 c\"),r.push(\"-\"+i+\" -\"+a+\" -\"+a+\" -\"+i+\" 0 -\"+i+\" c\"),r.push(a+\" -\"+i+\" \"+i+\" -\"+a+\" \"+i+\" 0 c\"),r.push(\"f\"),r.push(\"Q\"),e.stream=r.join(\"\\n\"),e}},Cross:{createAppearanceStream:function(t){var e={D:{Off:Lt.RadioButton.Cross.OffPushDown},N:{}};return e.N[t]=Lt.RadioButton.Cross.YesNormal,e.D[t]=Lt.RadioButton.Cross.YesPushDown,e},getCA:function(){return\"8\"},YesNormal:function(t){var e=W(t);e.scope=t.scope;var r=[],n=Lt.internal.calculateCross(t);return r.push(\"q\"),r.push(\"1 1 \"+T(Lt.internal.getWidth(t)-2)+\" \"+T(Lt.internal.getHeight(t)-2)+\" re\"),r.push(\"W\"),r.push(\"n\"),r.push(T(n.x1.x)+\" \"+T(n.x1.y)+\" m\"),r.push(T(n.x2.x)+\" \"+T(n.x2.y)+\" l\"),r.push(T(n.x4.x)+\" \"+T(n.x4.y)+\" m\"),r.push(T(n.x3.x)+\" \"+T(n.x3.y)+\" l\"),r.push(\"s\"),r.push(\"Q\"),e.stream=r.join(\"\\n\"),e},YesPushDown:function(t){var e=W(t);e.scope=t.scope;var r=Lt.internal.calculateCross(t),n=[];return n.push(\"0.749023 g\"),n.push(\"0 0 \"+T(Lt.internal.getWidth(t))+\" \"+T(Lt.internal.getHeight(t))+\" re\"),n.push(\"f\"),n.push(\"q\"),n.push(\"1 1 \"+T(Lt.internal.getWidth(t)-2)+\" \"+T(Lt.internal.getHeight(t)-2)+\" re\"),n.push(\"W\"),n.push(\"n\"),n.push(T(r.x1.x)+\" \"+T(r.x1.y)+\" m\"),n.push(T(r.x2.x)+\" \"+T(r.x2.y)+\" l\"),n.push(T(r.x4.x)+\" \"+T(r.x4.y)+\" m\"),n.push(T(r.x3.x)+\" \"+T(r.x3.y)+\" l\"),n.push(\"s\"),n.push(\"Q\"),e.stream=n.join(\"\\n\"),e},OffPushDown:function(t){var e=W(t);e.scope=t.scope;var r=[];return r.push(\"0.749023 g\"),r.push(\"0 0 \"+T(Lt.internal.getWidth(t))+\" \"+T(Lt.internal.getHeight(t))+\" re\"),r.push(\"f\"),e.stream=r.join(\"\\n\"),e}}},createDefaultAppearanceStream:function(t){var e=t.scope.internal.getFont(t.fontName,t.fontStyle).id,r=t.scope.__private__.encodeColorString(t.color);return\"/\"+e+\" \"+t.fontSize+\" Tf \"+r}};Lt.internal={Bezier_C:.551915024494,calculateCross:function(t){var e=Lt.internal.getWidth(t),r=Lt.internal.getHeight(t),n=Math.min(e,r);return{x1:{x:(e-n)/2,y:(r-n)/2+n},x2:{x:(e-n)/2+n,y:(r-n)/2},x3:{x:(e-n)/2,y:(r-n)/2},x4:{x:(e-n)/2+n,y:(r-n)/2+n}}}},Lt.internal.getWidth=function(t){var r=0;return\"object\"===e(t)&&(r=H(t.Rect[2])),r},Lt.internal.getHeight=function(t){var r=0;return\"object\"===e(t)&&(r=H(t.Rect[3])),r};var At=E.addField=function(t){if(it(this,t),!(t instanceof lt))throw new Error(\"Invalid argument passed to jsPDF.addField.\");var e;return(e=t).scope.internal.acroformPlugin.printedOut&&(e.scope.internal.acroformPlugin.printedOut=!1,e.scope.internal.acroformPlugin.acroFormDictionaryRoot=null),e.scope.internal.acroformPlugin.acroFormDictionaryRoot.Fields.push(e),t.page=t.scope.internal.getCurrentPageInfo().pageNumber,this};E.AcroFormChoiceField=ht,E.AcroFormListBox=ft,E.AcroFormComboBox=dt,E.AcroFormEditBox=pt,E.AcroFormButton=gt,E.AcroFormPushButton=mt,E.AcroFormRadioButton=vt,E.AcroFormCheckBox=yt,E.AcroFormTextField=wt,E.AcroFormPasswordField=Nt,E.AcroFormAppearance=Lt,E.AcroForm={ChoiceField:ht,ListBox:ft,ComboBox:dt,EditBox:pt,Button:gt,PushButton:mt,RadioButton:vt,CheckBox:yt,TextField:wt,PasswordField:Nt,Appearance:Lt},M.AcroForm={ChoiceField:ht,ListBox:ft,ComboBox:dt,EditBox:pt,Button:gt,PushButton:mt,RadioButton:vt,CheckBox:yt,TextField:wt,PasswordField:Nt,Appearance:Lt};var xt=M.AcroForm;function St(t){return t.reduce((function(t,e,r){return t[e]=r,t}),{})}!function(t){t.__addimage__={};var r=\"UNKNOWN\",n={PNG:[[137,80,78,71]],TIFF:[[77,77,0,42],[73,73,42,0]],JPEG:[[255,216,255,224,void 0,void 0,74,70,73,70,0],[255,216,255,225,void 0,void 0,69,120,105,102,0,0],[255,216,255,219],[255,216,255,238]],JPEG2000:[[0,0,0,12,106,80,32,32]],GIF87a:[[71,73,70,56,55,97]],GIF89a:[[71,73,70,56,57,97]],WEBP:[[82,73,70,70,void 0,void 0,void 0,void 0,87,69,66,80]],BMP:[[66,77],[66,65],[67,73],[67,80],[73,67],[80,84]]},i=t.__addimage__.getImageFileTypeByImageData=function(t,e){var i,a,o,s,c,u=r;if(\"RGBA\"===(e=e||r)||void 0!==t.data&&t.data instanceof Uint8ClampedArray&&\"height\"in t&&\"width\"in t)return\"RGBA\";if(x(t))for(c in n)for(o=n[c],i=0;i<o.length;i+=1){for(s=!0,a=0;a<o[i].length;a+=1)if(void 0!==o[i][a]&&o[i][a]!==t[a]){s=!1;break}if(!0===s){u=c;break}}else for(c in n)for(o=n[c],i=0;i<o.length;i+=1){for(s=!0,a=0;a<o[i].length;a+=1)if(void 0!==o[i][a]&&o[i][a]!==t.charCodeAt(a)){s=!1;break}if(!0===s){u=c;break}}return u===r&&e!==r&&(u=e),u},a=function t(e){for(var r=this.internal.write,n=this.internal.putStream,i=(0,this.internal.getFilters)();-1!==i.indexOf(\"FlateEncode\");)i.splice(i.indexOf(\"FlateEncode\"),1);e.objectId=this.internal.newObject();var a=[];if(a.push({key:\"Type\",value:\"/XObject\"}),a.push({key:\"Subtype\",value:\"/Image\"}),a.push({key:\"Width\",value:e.width}),a.push({key:\"Height\",value:e.height}),e.colorSpace===b.INDEXED?a.push({key:\"ColorSpace\",value:\"[/Indexed /DeviceRGB \"+(e.palette.length/3-1)+\" \"+(\"sMask\"in e&&void 0!==e.sMask?e.objectId+2:e.objectId+1)+\" 0 R]\"}):(a.push({key:\"ColorSpace\",value:\"/\"+e.colorSpace}),e.colorSpace===b.DEVICE_CMYK&&a.push({key:\"Decode\",value:\"[1 0 1 0 1 0 1 0]\"})),a.push({key:\"BitsPerComponent\",value:e.bitsPerComponent}),\"decodeParameters\"in e&&void 0!==e.decodeParameters&&a.push({key:\"DecodeParms\",value:\"<<\"+e.decodeParameters+\">>\"}),\"transparency\"in e&&Array.isArray(e.transparency)){for(var o=\"\",s=0,c=e.transparency.length;s<c;s++)o+=e.transparency[s]+\" \"+e.transparency[s]+\" \";a.push({key:\"Mask\",value:\"[\"+o+\"]\"})}void 0!==e.sMask&&a.push({key:\"SMask\",value:e.objectId+1+\" 0 R\"});var u=void 0!==e.filter?[\"/\"+e.filter]:void 0;if(n({data:e.data,additionalKeyValues:a,alreadyAppliedFilters:u,objectId:e.objectId}),r(\"endobj\"),\"sMask\"in e&&void 0!==e.sMask){var l=\"/Predictor \"+e.predictor+\" /Colors 1 /BitsPerComponent \"+e.bitsPerComponent+\" /Columns \"+e.width,h={width:e.width,height:e.height,colorSpace:\"DeviceGray\",bitsPerComponent:e.bitsPerComponent,decodeParameters:l,data:e.sMask};\"filter\"in e&&(h.filter=e.filter),t.call(this,h)}if(e.colorSpace===b.INDEXED){var f=this.internal.newObject();n({data:_(new Uint8Array(e.palette)),objectId:f}),r(\"endobj\")}},o=function(){var t=this.internal.collections.addImage_images;for(var e in t)a.call(this,t[e])},s=function(){var t,e=this.internal.collections.addImage_images,r=this.internal.write;for(var n in e)r(\"/I\"+(t=e[n]).index,t.objectId,\"0\",\"R\")},u=function(){this.internal.collections.addImage_images||(this.internal.collections.addImage_images={},this.internal.events.subscribe(\"putResources\",o),this.internal.events.subscribe(\"putXobjectDict\",s))},l=function(){var t=this.internal.collections.addImage_images;return u.call(this),t},h=function(){return Object.keys(this.internal.collections.addImage_images).length},f=function(e){return\"function\"==typeof t[\"process\"+e.toUpperCase()]},d=function(t){return\"object\"===e(t)&&1===t.nodeType},p=function(e,r){if(\"IMG\"===e.nodeName&&e.hasAttribute(\"src\")){var n=\"\"+e.getAttribute(\"src\");if(0===n.indexOf(\"data:image/\"))return c(unescape(n).split(\"base64,\").pop());var i=t.loadFile(n,!0);if(void 0!==i)return i}if(\"CANVAS\"===e.nodeName){if(0===e.width||0===e.height)throw new Error(\"Given canvas must have data. Canvas width: \"+e.width+\", height: \"+e.height);var a;switch(r){case\"PNG\":a=\"image/png\";break;case\"WEBP\":a=\"image/webp\";break;case\"JPEG\":case\"JPG\":default:a=\"image/jpeg\"}return c(e.toDataURL(a,1).split(\"base64,\").pop())}},g=function(t){var e=this.internal.collections.addImage_images;if(e)for(var r in e)if(t===e[r].alias)return e[r]},m=function(t,e,r){return t||e||(t=-96,e=-96),t<0&&(t=-1*r.width*72/t/this.internal.scaleFactor),e<0&&(e=-1*r.height*72/e/this.internal.scaleFactor),0===t&&(t=e*r.width/r.height),0===e&&(e=t*r.height/r.width),[t,e]},v=function(t,e,r,n,i,a){var o=m.call(this,r,n,i),s=this.internal.getCoordinateString,c=this.internal.getVerticalCoordinateString,u=l.call(this);if(r=o[0],n=o[1],u[i.index]=i,a){a*=Math.PI/180;var h=Math.cos(a),f=Math.sin(a),d=function(t){return t.toFixed(4)},p=[d(h),d(f),d(-1*f),d(h),0,0,\"cm\"]}this.internal.write(\"q\"),a?(this.internal.write([1,\"0\",\"0\",1,s(t),c(e+n),\"cm\"].join(\" \")),this.internal.write(p.join(\" \")),this.internal.write([s(r),\"0\",\"0\",s(n),\"0\",\"0\",\"cm\"].join(\" \"))):this.internal.write([s(r),\"0\",\"0\",s(n),s(t),c(e+n),\"cm\"].join(\" \")),this.isAdvancedAPI()&&this.internal.write([1,0,0,-1,0,0,\"cm\"].join(\" \")),this.internal.write(\"/I\"+i.index+\" Do\"),this.internal.write(\"Q\")},b=t.color_spaces={DEVICE_RGB:\"DeviceRGB\",DEVICE_GRAY:\"DeviceGray\",DEVICE_CMYK:\"DeviceCMYK\",CAL_GREY:\"CalGray\",CAL_RGB:\"CalRGB\",LAB:\"Lab\",ICC_BASED:\"ICCBased\",INDEXED:\"Indexed\",PATTERN:\"Pattern\",SEPARATION:\"Separation\",DEVICE_N:\"DeviceN\"};t.decode={DCT_DECODE:\"DCTDecode\",FLATE_DECODE:\"FlateDecode\",LZW_DECODE:\"LZWDecode\",JPX_DECODE:\"JPXDecode\",JBIG2_DECODE:\"JBIG2Decode\",ASCII85_DECODE:\"ASCII85Decode\",ASCII_HEX_DECODE:\"ASCIIHexDecode\",RUN_LENGTH_DECODE:\"RunLengthDecode\",CCITT_FAX_DECODE:\"CCITTFaxDecode\"};var y=t.image_compression={NONE:\"NONE\",FAST:\"FAST\",MEDIUM:\"MEDIUM\",SLOW:\"SLOW\"},w=t.__addimage__.sHashCode=function(t){var e,r,n=0;if(\"string\"==typeof t)for(r=t.length,e=0;e<r;e++)n=(n<<5)-n+t.charCodeAt(e),n|=0;else if(x(t))for(r=t.byteLength/2,e=0;e<r;e++)n=(n<<5)-n+t[e],n|=0;return n},N=t.__addimage__.validateStringAsBase64=function(t){(t=t||\"\").toString().trim();var e=!0;return 0===t.length&&(e=!1),t.length%4!=0&&(e=!1),!1===/^[A-Za-z0-9+/]+$/.test(t.substr(0,t.length-2))&&(e=!1),!1===/^[A-Za-z0-9/][A-Za-z0-9+/]|[A-Za-z0-9+/]=|==$/.test(t.substr(-2))&&(e=!1),e},L=t.__addimage__.extractImageFromDataUrl=function(t){if(null==t)return null;if(!(t=t.trim()).startsWith(\"data:\"))return null;var e=t.indexOf(\",\");return e<0?null:t.substring(0,e).trim().endsWith(\"base64\")?t.substring(e+1):null},A=t.__addimage__.supportsArrayBuffer=function(){return\"undefined\"!=typeof ArrayBuffer&&\"undefined\"!=typeof Uint8Array};t.__addimage__.isArrayBuffer=function(t){return A()&&t instanceof ArrayBuffer};var x=t.__addimage__.isArrayBufferView=function(t){return A()&&\"undefined\"!=typeof Uint32Array&&(t instanceof Int8Array||t instanceof Uint8Array||\"undefined\"!=typeof Uint8ClampedArray&&t instanceof Uint8ClampedArray||t instanceof Int16Array||t instanceof Uint16Array||t instanceof Int32Array||t instanceof Uint32Array||t instanceof Float32Array||t instanceof Float64Array)},S=t.__addimage__.binaryStringToUint8Array=function(t){for(var e=t.length,r=new Uint8Array(e),n=0;n<e;n++)r[n]=t.charCodeAt(n);return r},_=t.__addimage__.arrayBufferToBinaryString=function(t){for(var e=\"\",r=x(t)?t:new Uint8Array(t),n=0;n<r.length;n+=8192)e+=String.fromCharCode.apply(null,r.subarray(n,n+8192));return e};t.addImage=function(){var t,n,i,a,o,s,c,l,h;if(\"number\"==typeof arguments[1]?(n=r,i=arguments[1],a=arguments[2],o=arguments[3],s=arguments[4],c=arguments[5],l=arguments[6],h=arguments[7]):(n=arguments[1],i=arguments[2],a=arguments[3],o=arguments[4],s=arguments[5],c=arguments[6],l=arguments[7],h=arguments[8]),\"object\"===e(t=arguments[0])&&!d(t)&&\"imageData\"in t){var f=t;t=f.imageData,n=f.format||n||r,i=f.x||i||0,a=f.y||a||0,o=f.w||f.width||o,s=f.h||f.height||s,c=f.alias||c,l=f.compression||l,h=f.rotation||f.angle||h}var p=this.internal.getFilters();if(void 0===l&&-1!==p.indexOf(\"FlateEncode\")&&(l=\"SLOW\"),isNaN(i)||isNaN(a))throw new Error(\"Invalid coordinates passed to jsPDF.addImage\");u.call(this);var g=P.call(this,t,n,c,l);return v.call(this,i,a,o,s,g,h),this};var P=function(e,n,a,o){var s,c,u;if(\"string\"==typeof e&&i(e)===r){e=unescape(e);var l=k(e,!1);(\"\"!==l||void 0!==(l=t.loadFile(e,!0)))&&(e=l)}if(d(e)&&(e=p(e,n)),n=i(e,n),!f(n))throw new Error(\"addImage does not support files of type '\"+n+\"', please ensure that a plugin for '\"+n+\"' support is added.\");if((null==(u=a)||0===u.length)&&(a=function(t){return\"string\"==typeof t||x(t)?w(t):x(t.data)?w(t.data):null}(e)),(s=g.call(this,a))||(A()&&(e instanceof Uint8Array||\"RGBA\"===n||(c=e,e=S(e))),s=this[\"process\"+n.toUpperCase()](e,h.call(this),a,function(e){return e&&\"string\"==typeof e&&(e=e.toUpperCase()),e in t.image_compression?e:y.NONE}(o),c)),!s)throw new Error(\"An unknown error occurred whilst processing the image.\");return s},k=t.__addimage__.convertBase64ToBinaryString=function(t,e){e=\"boolean\"!=typeof e||e;var r,n=\"\";if(\"string\"==typeof t){var i;r=null!==(i=L(t))&&void 0!==i?i:t;try{n=c(r)}catch(t){if(e)throw N(r)?new Error(\"atob-Error in jsPDF.convertBase64ToBinaryString \"+t.message):new Error(\"Supplied Data is not a valid base64-String jsPDF.convertBase64ToBinaryString \")}}return n};t.getImageProperties=function(e){var n,a,o=\"\";if(d(e)&&(e=p(e)),\"string\"==typeof e&&i(e)===r&&(\"\"===(o=k(e,!1))&&(o=t.loadFile(e)||\"\"),e=o),a=i(e),!f(a))throw new Error(\"addImage does not support files of type '\"+a+\"', please ensure that a plugin for '\"+a+\"' support is added.\");if(!A()||e instanceof Uint8Array||(e=S(e)),!(n=this[\"process\"+a.toUpperCase()](e)))throw new Error(\"An unknown error occurred whilst processing the image\");return n.fileType=a,n}}(M.API),\n/**\n   * @license\n   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e=function(t){if(void 0!==t&&\"\"!=t)return!0};M.API.events.push([\"addPage\",function(t){this.internal.getPageInfo(t.pageNumber).pageContext.annotations=[]}]),t.events.push([\"putPage\",function(t){for(var r,n,i,a=this.internal.getCoordinateString,o=this.internal.getVerticalCoordinateString,s=this.internal.getPageInfoByObjId(t.objId),c=t.pageContext.annotations,u=!1,l=0;l<c.length&&!u;l++)switch((r=c[l]).type){case\"link\":(e(r.options.url)||e(r.options.pageNumber))&&(u=!0);break;case\"reference\":case\"text\":case\"freetext\":u=!0}if(0!=u){this.internal.write(\"/Annots [\");for(var h=0;h<c.length;h++){r=c[h];var f=this.internal.pdfEscape,d=this.internal.getEncryptor(t.objId);switch(r.type){case\"reference\":this.internal.write(\" \"+r.object.objId+\" 0 R \");break;case\"text\":var p=this.internal.newAdditionalObject(),g=this.internal.newAdditionalObject(),m=this.internal.getEncryptor(p.objId),v=r.title||\"Note\";i=\"<</Type /Annot /Subtype /Text \"+(n=\"/Rect [\"+a(r.bounds.x)+\" \"+o(r.bounds.y+r.bounds.h)+\" \"+a(r.bounds.x+r.bounds.w)+\" \"+o(r.bounds.y)+\"] \")+\"/Contents (\"+f(m(r.contents))+\")\",i+=\" /Popup \"+g.objId+\" 0 R\",i+=\" /P \"+s.objId+\" 0 R\",i+=\" /T (\"+f(m(v))+\") >>\",p.content=i;var b=p.objId+\" 0 R\";i=\"<</Type /Annot /Subtype /Popup \"+(n=\"/Rect [\"+a(r.bounds.x+30)+\" \"+o(r.bounds.y+r.bounds.h)+\" \"+a(r.bounds.x+r.bounds.w+30)+\" \"+o(r.bounds.y)+\"] \")+\" /Parent \"+b,r.open&&(i+=\" /Open true\"),i+=\" >>\",g.content=i,this.internal.write(p.objId,\"0 R\",g.objId,\"0 R\");break;case\"freetext\":n=\"/Rect [\"+a(r.bounds.x)+\" \"+o(r.bounds.y)+\" \"+a(r.bounds.x+r.bounds.w)+\" \"+o(r.bounds.y+r.bounds.h)+\"] \";var y=r.color||\"#000000\";i=\"<</Type /Annot /Subtype /FreeText \"+n+\"/Contents (\"+f(d(r.contents))+\")\",i+=\" /DS(font: Helvetica,sans-serif 12.0pt; text-align:left; color:#\"+y+\")\",i+=\" /Border [0 0 0]\",i+=\" >>\",this.internal.write(i);break;case\"link\":if(r.options.name){var w=this.annotations._nameMap[r.options.name];r.options.pageNumber=w.page,r.options.top=w.y}else r.options.top||(r.options.top=0);if(n=\"/Rect [\"+r.finalBounds.x+\" \"+r.finalBounds.y+\" \"+r.finalBounds.w+\" \"+r.finalBounds.h+\"] \",i=\"\",r.options.url)i=\"<</Type /Annot /Subtype /Link \"+n+\"/Border [0 0 0] /A <</S /URI /URI (\"+f(d(r.options.url))+\") >>\";else if(r.options.pageNumber){switch(i=\"<</Type /Annot /Subtype /Link \"+n+\"/Border [0 0 0] /Dest [\"+this.internal.getPageInfo(r.options.pageNumber).objId+\" 0 R\",r.options.magFactor=r.options.magFactor||\"XYZ\",r.options.magFactor){case\"Fit\":i+=\" /Fit]\";break;case\"FitH\":i+=\" /FitH \"+r.options.top+\"]\";break;case\"FitV\":r.options.left=r.options.left||0,i+=\" /FitV \"+r.options.left+\"]\";break;case\"XYZ\":default:var N=o(r.options.top);r.options.left=r.options.left||0,void 0===r.options.zoom&&(r.options.zoom=0),i+=\" /XYZ \"+r.options.left+\" \"+N+\" \"+r.options.zoom+\"]\"}}\"\"!=i&&(i+=\" >>\",this.internal.write(i))}}this.internal.write(\"]\")}}]),t.createAnnotation=function(t){var e=this.internal.getCurrentPageInfo();switch(t.type){case\"link\":this.link(t.bounds.x,t.bounds.y,t.bounds.w,t.bounds.h,t);break;case\"text\":case\"freetext\":e.pageContext.annotations.push(t)}},t.link=function(t,e,r,n,i){var a=this.internal.getCurrentPageInfo(),o=this.internal.getCoordinateString,s=this.internal.getVerticalCoordinateString;a.pageContext.annotations.push({finalBounds:{x:o(t),y:s(e),w:o(t+r),h:s(e+n)},options:i,type:\"link\"})},t.textWithLink=function(t,e,r,n){var i,a,o=this.getTextWidth(t),s=this.internal.getLineHeight()/this.internal.scaleFactor;if(void 0!==n.maxWidth){a=n.maxWidth;var c=this.splitTextToSize(t,a).length;i=Math.ceil(s*c)}else a=o,i=s;return this.text(t,e,r,n),r+=.2*s,\"center\"===n.align&&(e-=o/2),\"right\"===n.align&&(e-=o),this.link(e,r-s,a,i,n),o},t.getTextWidth=function(t){var e=this.internal.getFontSize();return this.getStringUnitWidth(t)*e/this.internal.scaleFactor}}(M.API),\n/**\n   * @license\n   * Copyright (c) 2017 Aras Abbasi\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e={1569:[65152],1570:[65153,65154],1571:[65155,65156],1572:[65157,65158],1573:[65159,65160],1574:[65161,65162,65163,65164],1575:[65165,65166],1576:[65167,65168,65169,65170],1577:[65171,65172],1578:[65173,65174,65175,65176],1579:[65177,65178,65179,65180],1580:[65181,65182,65183,65184],1581:[65185,65186,65187,65188],1582:[65189,65190,65191,65192],1583:[65193,65194],1584:[65195,65196],1585:[65197,65198],1586:[65199,65200],1587:[65201,65202,65203,65204],1588:[65205,65206,65207,65208],1589:[65209,65210,65211,65212],1590:[65213,65214,65215,65216],1591:[65217,65218,65219,65220],1592:[65221,65222,65223,65224],1593:[65225,65226,65227,65228],1594:[65229,65230,65231,65232],1601:[65233,65234,65235,65236],1602:[65237,65238,65239,65240],1603:[65241,65242,65243,65244],1604:[65245,65246,65247,65248],1605:[65249,65250,65251,65252],1606:[65253,65254,65255,65256],1607:[65257,65258,65259,65260],1608:[65261,65262],1609:[65263,65264,64488,64489],1610:[65265,65266,65267,65268],1649:[64336,64337],1655:[64477],1657:[64358,64359,64360,64361],1658:[64350,64351,64352,64353],1659:[64338,64339,64340,64341],1662:[64342,64343,64344,64345],1663:[64354,64355,64356,64357],1664:[64346,64347,64348,64349],1667:[64374,64375,64376,64377],1668:[64370,64371,64372,64373],1670:[64378,64379,64380,64381],1671:[64382,64383,64384,64385],1672:[64392,64393],1676:[64388,64389],1677:[64386,64387],1678:[64390,64391],1681:[64396,64397],1688:[64394,64395],1700:[64362,64363,64364,64365],1702:[64366,64367,64368,64369],1705:[64398,64399,64400,64401],1709:[64467,64468,64469,64470],1711:[64402,64403,64404,64405],1713:[64410,64411,64412,64413],1715:[64406,64407,64408,64409],1722:[64414,64415],1723:[64416,64417,64418,64419],1726:[64426,64427,64428,64429],1728:[64420,64421],1729:[64422,64423,64424,64425],1733:[64480,64481],1734:[64473,64474],1735:[64471,64472],1736:[64475,64476],1737:[64482,64483],1739:[64478,64479],1740:[64508,64509,64510,64511],1744:[64484,64485,64486,64487],1746:[64430,64431],1747:[64432,64433]},r={65247:{65154:65269,65156:65271,65160:65273,65166:65275},65248:{65154:65270,65156:65272,65160:65274,65166:65276},65165:{65247:{65248:{65258:65010}}},1617:{1612:64606,1613:64607,1614:64608,1615:64609,1616:64610}},n={1612:64606,1613:64607,1614:64608,1615:64609,1616:64610},i=[1570,1571,1573,1575];t.__arabicParser__={};var a=t.__arabicParser__.isInArabicSubstitutionA=function(t){return void 0!==e[t.charCodeAt(0)]},o=t.__arabicParser__.isArabicLetter=function(t){return\"string\"==typeof t&&/^[\\u0600-\\u06FF\\u0750-\\u077F\\u08A0-\\u08FF\\uFB50-\\uFDFF\\uFE70-\\uFEFF]+$/.test(t)},s=t.__arabicParser__.isArabicEndLetter=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length<=2},c=t.__arabicParser__.isArabicAlfLetter=function(t){return o(t)&&i.indexOf(t.charCodeAt(0))>=0};t.__arabicParser__.arabicLetterHasIsolatedForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=1};var u=t.__arabicParser__.arabicLetterHasFinalForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=2};t.__arabicParser__.arabicLetterHasInitialForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=3};var l=t.__arabicParser__.arabicLetterHasMedialForm=function(t){return o(t)&&a(t)&&4==e[t.charCodeAt(0)].length},h=t.__arabicParser__.resolveLigatures=function(t){var e=0,n=r,i=\"\",a=0;for(e=0;e<t.length;e+=1)void 0!==n[t.charCodeAt(e)]?(a++,\"number\"==typeof(n=n[t.charCodeAt(e)])&&(i+=String.fromCharCode(n),n=r,a=0),e===t.length-1&&(n=r,i+=t.charAt(e-(a-1)),e-=a-1,a=0)):(n=r,i+=t.charAt(e-a),e-=a,a=0);return i};t.__arabicParser__.isArabicDiacritic=function(t){return void 0!==t&&void 0!==n[t.charCodeAt(0)]};var f=t.__arabicParser__.getCorrectForm=function(t,e,r){return o(t)?!1===a(t)?-1:!u(t)||!o(e)&&!o(r)||!o(r)&&s(e)||s(t)&&!o(e)||s(t)&&c(e)||s(t)&&s(e)?0:l(t)&&o(e)&&!s(e)&&o(r)&&u(r)?3:s(t)||!o(r)?1:2:-1},d=function(t){var r=0,n=0,i=0,a=\"\",s=\"\",c=\"\",u=(t=t||\"\").split(\"\\\\s+\"),l=[];for(r=0;r<u.length;r+=1){for(l.push(\"\"),n=0;n<u[r].length;n+=1)a=u[r][n],s=u[r][n-1],c=u[r][n+1],o(a)?(i=f(a,s,c),l[r]+=-1!==i?String.fromCharCode(e[a.charCodeAt(0)][i]):a):l[r]+=a;l[r]=h(l[r])}return l.join(\" \")},p=t.__arabicParser__.processArabic=t.processArabic=function(){var t,e=\"string\"==typeof arguments[0]?arguments[0]:arguments[0].text,r=[];if(Array.isArray(e)){var n=0;for(r=[],n=0;n<e.length;n+=1)Array.isArray(e[n])?r.push([d(e[n][0]),e[n][1],e[n][2]]):r.push([d(e[n])]);t=r}else t=d(e);return\"string\"==typeof arguments[0]?t:(arguments[0].text=t,arguments[0])};t.events.push([\"preProcessText\",p])}(M.API),\n/** @license\n   * jsPDF Autoprint Plugin\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){t.autoPrint=function(t){var e;switch((t=t||{}).variant=t.variant||\"non-conform\",t.variant){case\"javascript\":this.addJS(\"print({});\");break;case\"non-conform\":default:this.internal.events.subscribe(\"postPutResources\",(function(){e=this.internal.newObject(),this.internal.out(\"<<\"),this.internal.out(\"/S /Named\"),this.internal.out(\"/Type /Action\"),this.internal.out(\"/N /Print\"),this.internal.out(\">>\"),this.internal.out(\"endobj\")})),this.internal.events.subscribe(\"putCatalog\",(function(){this.internal.out(\"/OpenAction \"+e+\" 0 R\")}))}return this}}(M.API),\n/**\n   * @license\n   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e=function(){var t=void 0;Object.defineProperty(this,\"pdf\",{get:function(){return t},set:function(e){t=e}});var e=150;Object.defineProperty(this,\"width\",{get:function(){return e},set:function(t){e=isNaN(t)||!1===Number.isInteger(t)||t<0?150:t,this.getContext(\"2d\").pageWrapXEnabled&&(this.getContext(\"2d\").pageWrapX=e+1)}});var r=300;Object.defineProperty(this,\"height\",{get:function(){return r},set:function(t){r=isNaN(t)||!1===Number.isInteger(t)||t<0?300:t,this.getContext(\"2d\").pageWrapYEnabled&&(this.getContext(\"2d\").pageWrapY=r+1)}});var n=[];Object.defineProperty(this,\"childNodes\",{get:function(){return n},set:function(t){n=t}});var i={};Object.defineProperty(this,\"style\",{get:function(){return i},set:function(t){i=t}}),Object.defineProperty(this,\"parentNode\",{})};e.prototype.getContext=function(t,e){var r;if(\"2d\"!==(t=t||\"2d\"))return null;for(r in e)this.pdf.context2d.hasOwnProperty(r)&&(this.pdf.context2d[r]=e[r]);return this.pdf.context2d._canvas=this,this.pdf.context2d},e.prototype.toDataURL=function(){throw new Error(\"toDataURL is not implemented.\")},t.events.push([\"initialized\",function(){this.canvas=new e,this.canvas.pdf=this}])}(M.API),function(t){var r={left:0,top:0,bottom:0,right:0},n=!1,i=function(){void 0===this.internal.__cell__&&(this.internal.__cell__={},this.internal.__cell__.padding=3,this.internal.__cell__.headerFunction=void 0,this.internal.__cell__.margins=Object.assign({},r),this.internal.__cell__.margins.width=this.getPageWidth(),a.call(this))},a=function(){this.internal.__cell__.lastCell=new o,this.internal.__cell__.pages=1},o=function(){var t=arguments[0];Object.defineProperty(this,\"x\",{enumerable:!0,get:function(){return t},set:function(e){t=e}});var e=arguments[1];Object.defineProperty(this,\"y\",{enumerable:!0,get:function(){return e},set:function(t){e=t}});var r=arguments[2];Object.defineProperty(this,\"width\",{enumerable:!0,get:function(){return r},set:function(t){r=t}});var n=arguments[3];Object.defineProperty(this,\"height\",{enumerable:!0,get:function(){return n},set:function(t){n=t}});var i=arguments[4];Object.defineProperty(this,\"text\",{enumerable:!0,get:function(){return i},set:function(t){i=t}});var a=arguments[5];Object.defineProperty(this,\"lineNumber\",{enumerable:!0,get:function(){return a},set:function(t){a=t}});var o=arguments[6];return Object.defineProperty(this,\"align\",{enumerable:!0,get:function(){return o},set:function(t){o=t}}),this};o.prototype.clone=function(){return new o(this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align)},o.prototype.toArray=function(){return[this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align]},t.setHeaderFunction=function(t){return i.call(this),this.internal.__cell__.headerFunction=\"function\"==typeof t?t:void 0,this},t.getTextDimensions=function(t,e){i.call(this);var r=(e=e||{}).fontSize||this.getFontSize(),n=e.font||this.getFont(),a=e.scaleFactor||this.internal.scaleFactor,o=0,s=0,c=0,u=this;if(!Array.isArray(t)&&\"string\"!=typeof t){if(\"number\"!=typeof t)throw new Error(\"getTextDimensions expects text-parameter to be of type String or type Number or an Array of Strings.\");t=String(t)}var l=e.maxWidth;l>0?\"string\"==typeof t?t=this.splitTextToSize(t,l):\"[object Array]\"===Object.prototype.toString.call(t)&&(t=t.reduce((function(t,e){return t.concat(u.splitTextToSize(e,l))}),[])):t=Array.isArray(t)?t:[t];for(var h=0;h<t.length;h++)o<(c=this.getStringUnitWidth(t[h],{font:n})*r)&&(o=c);return 0!==o&&(s=t.length),{w:o/=a,h:Math.max((s*r*this.getLineHeightFactor()-r*(this.getLineHeightFactor()-1))/a,0)}},t.cellAddPage=function(){i.call(this),this.addPage();var t=this.internal.__cell__.margins||r;return this.internal.__cell__.lastCell=new o(t.left,t.top,void 0,void 0),this.internal.__cell__.pages+=1,this};var s=t.cell=function(){var t;t=arguments[0]instanceof o?arguments[0]:new o(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]),i.call(this);var e=this.internal.__cell__.lastCell,a=this.internal.__cell__.padding,s=this.internal.__cell__.margins||r,c=this.internal.__cell__.tableHeaderRow,u=this.internal.__cell__.printHeaders;return void 0!==e.lineNumber&&(e.lineNumber===t.lineNumber?(t.x=(e.x||0)+(e.width||0),t.y=e.y||0):e.y+e.height+t.height+s.bottom>this.getPageHeight()?(this.cellAddPage(),t.y=s.top,u&&c&&(this.printHeaderRow(t.lineNumber,!0),t.y+=c[0].height)):t.y=e.y+e.height||t.y),void 0!==t.text[0]&&(this.rect(t.x,t.y,t.width,t.height,!0===n?\"FD\":void 0),\"right\"===t.align?this.text(t.text,t.x+t.width-a,t.y+a,{align:\"right\",baseline:\"top\"}):\"center\"===t.align?this.text(t.text,t.x+t.width/2,t.y+a,{align:\"center\",baseline:\"top\",maxWidth:t.width-a-a}):this.text(t.text,t.x+a,t.y+a,{align:\"left\",baseline:\"top\",maxWidth:t.width-a-a})),this.internal.__cell__.lastCell=t,this};t.table=function(t,n,u,l,h){if(i.call(this),!u)throw new Error(\"No data for PDF table.\");var f,d,p,g,m=[],v=[],b=[],y={},w={},N=[],L=[],A=(h=h||{}).autoSize||!1,x=!1!==h.printHeaders,S=h.css&&void 0!==h.css[\"font-size\"]?16*h.css[\"font-size\"]:h.fontSize||12,_=h.margins||Object.assign({width:this.getPageWidth()},r),P=\"number\"==typeof h.padding?h.padding:3,k=h.headerBackgroundColor||\"#c8c8c8\",F=h.headerTextColor||\"#000\";if(a.call(this),this.internal.__cell__.printHeaders=x,this.internal.__cell__.margins=_,this.internal.__cell__.table_font_size=S,this.internal.__cell__.padding=P,this.internal.__cell__.headerBackgroundColor=k,this.internal.__cell__.headerTextColor=F,this.setFontSize(S),null==l)v=m=Object.keys(u[0]),b=m.map((function(){return\"left\"}));else if(Array.isArray(l)&&\"object\"===e(l[0]))for(m=l.map((function(t){return t.name})),v=l.map((function(t){return t.prompt||t.name||\"\"})),b=l.map((function(t){return t.align||\"left\"})),f=0;f<l.length;f+=1)w[l[f].name]=l[f].width*(19.049976/25.4);else Array.isArray(l)&&\"string\"==typeof l[0]&&(v=m=l,b=m.map((function(){return\"left\"})));if(A||Array.isArray(l)&&\"string\"==typeof l[0])for(f=0;f<m.length;f+=1){for(y[g=m[f]]=u.map((function(t){return t[g]})),this.setFont(void 0,\"bold\"),N.push(this.getTextDimensions(v[f],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w),d=y[g],this.setFont(void 0,\"normal\"),p=0;p<d.length;p+=1)N.push(this.getTextDimensions(d[p],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w);w[g]=Math.max.apply(null,N)+P+P,N=[]}if(x){var I={};for(f=0;f<m.length;f+=1)I[m[f]]={},I[m[f]].text=v[f],I[m[f]].align=b[f];var C=c.call(this,I,w);L=m.map((function(e){return new o(t,n,w[e],C,I[e].text,void 0,I[e].align)})),this.setTableHeaderRow(L),this.printHeaderRow(1,!1)}var j=l.reduce((function(t,e){return t[e.name]=e.align,t}),{});for(f=0;f<u.length;f+=1){\"rowStart\"in h&&h.rowStart instanceof Function&&h.rowStart({row:f,data:u[f]},this);var O=c.call(this,u[f],w);for(p=0;p<m.length;p+=1){var B=u[f][m[p]];\"cellStart\"in h&&h.cellStart instanceof Function&&h.cellStart({row:f,col:p,data:B},this),s.call(this,new o(t,n,w[m[p]],O,B,f+2,j[m[p]]))}}return this.internal.__cell__.table_x=t,this.internal.__cell__.table_y=n,this};var c=function(t,e){var r=this.internal.__cell__.padding,n=this.internal.__cell__.table_font_size,i=this.internal.scaleFactor;return Object.keys(t).map((function(n){var i=t[n];return this.splitTextToSize(i.hasOwnProperty(\"text\")?i.text:i,e[n]-r-r)}),this).map((function(t){return this.getLineHeightFactor()*t.length*n/i+r+r}),this).reduce((function(t,e){return Math.max(t,e)}),0)};t.setTableHeaderRow=function(t){i.call(this),this.internal.__cell__.tableHeaderRow=t},t.printHeaderRow=function(t,e){if(i.call(this),!this.internal.__cell__.tableHeaderRow)throw new Error(\"Property tableHeaderRow does not exist.\");var r;if(n=!0,\"function\"==typeof this.internal.__cell__.headerFunction){var a=this.internal.__cell__.headerFunction(this,this.internal.__cell__.pages);this.internal.__cell__.lastCell=new o(a[0],a[1],a[2],a[3],void 0,-1)}this.setFont(void 0,\"bold\");for(var c=[],u=0;u<this.internal.__cell__.tableHeaderRow.length;u+=1){r=this.internal.__cell__.tableHeaderRow[u].clone(),e&&(r.y=this.internal.__cell__.margins.top||0,c.push(r)),r.lineNumber=t;var l=this.getTextColor();this.setTextColor(this.internal.__cell__.headerTextColor),this.setFillColor(this.internal.__cell__.headerBackgroundColor),s.call(this,r),this.setTextColor(l)}c.length>0&&this.setTableHeaderRow(c),this.setFont(void 0,\"normal\"),n=!1}}(M.API);var _t={italic:[\"italic\",\"oblique\",\"normal\"],oblique:[\"oblique\",\"italic\",\"normal\"],normal:[\"normal\",\"oblique\",\"italic\"]},Pt=[\"ultra-condensed\",\"extra-condensed\",\"condensed\",\"semi-condensed\",\"normal\",\"semi-expanded\",\"expanded\",\"extra-expanded\",\"ultra-expanded\"],kt=St(Pt),Ft=[100,200,300,400,500,600,700,800,900],It=St(Ft);function Ct(t){var e=t.family.replace(/\"|'/g,\"\").toLowerCase(),r=function(t){return _t[t=t||\"normal\"]?t:\"normal\"}(t.style),n=function(t){if(!t)return 400;if(\"number\"==typeof t)return t>=100&&t<=900&&t%100==0?t:400;if(/^\\d00$/.test(t))return parseInt(t);switch(t){case\"bold\":return 700;case\"normal\":default:return 400}}(t.weight),i=function(t){return\"number\"==typeof kt[t=t||\"normal\"]?t:\"normal\"}(t.stretch);return{family:e,style:r,weight:n,stretch:i,src:t.src||[],ref:t.ref||{name:e,style:[i,r,n].join(\" \")}}}function jt(t,e,r,n){var i;for(i=r;i>=0&&i<e.length;i+=n)if(t[e[i]])return t[e[i]];for(i=r;i>=0&&i<e.length;i-=n)if(t[e[i]])return t[e[i]]}var Ot={\"sans-serif\":\"helvetica\",fixed:\"courier\",monospace:\"courier\",terminal:\"courier\",cursive:\"times\",fantasy:\"times\",serif:\"times\"},Bt={caption:\"times\",icon:\"times\",menu:\"times\",\"message-box\":\"times\",\"small-caption\":\"times\",\"status-bar\":\"times\"};function Mt(t){return[t.stretch,t.style,t.weight,t.family].join(\" \")}function Et(t,e,r){for(var n=(r=r||{}).defaultFontFamily||\"times\",i=Object.assign({},Ot,r.genericFontFamilies||{}),a=null,o=null,s=0;s<e.length;++s)if(i[(a=Ct(e[s])).family]&&(a.family=i[a.family]),t.hasOwnProperty(a.family)){o=t[a.family];break}if(!(o=o||t[n]))throw new Error(\"Could not find a font-family for the rule '\"+Mt(a)+\"' and default family '\"+n+\"'.\");if(o=function(t,e){if(e[t])return e[t];var r=kt[t],n=r<=kt.normal?-1:1,i=jt(e,Pt,r,n);if(!i)throw new Error(\"Could not find a matching font-stretch value for \"+t);return i}(a.stretch,o),o=function(t,e){if(e[t])return e[t];for(var r=_t[t],n=0;n<r.length;++n)if(e[r[n]])return e[r[n]];throw new Error(\"Could not find a matching font-style for \"+t)}(a.style,o),!(o=function(t,e){if(e[t])return e[t];if(400===t&&e[500])return e[500];if(500===t&&e[400])return e[400];var r=It[t],n=jt(e,Ft,r,t<400?-1:1);if(!n)throw new Error(\"Could not find a matching font-weight for value \"+t);return n}(a.weight,o)))throw new Error(\"Failed to resolve a font for the rule '\"+Mt(a)+\"'.\");return o}function qt(t){return t.trimLeft()}function Dt(t,e){for(var r=0;r<t.length;){if(t.charAt(r)===e)return[t.substring(0,r),t.substring(r+1)];r+=1}return null}function Rt(t){var e=t.match(/^(-[a-z_]|[a-z_])[a-z0-9_-]*/i);return null===e?null:[e[0],t.substring(e[0].length)]}var Tt=[\"times\"];!function(t){var r,n,a,o,s,c,u,l,f,d=function(t){return t=t||{},this.isStrokeTransparent=t.isStrokeTransparent||!1,this.strokeOpacity=t.strokeOpacity||1,this.strokeStyle=t.strokeStyle||\"#000000\",this.fillStyle=t.fillStyle||\"#000000\",this.isFillTransparent=t.isFillTransparent||!1,this.fillOpacity=t.fillOpacity||1,this.font=t.font||\"10px sans-serif\",this.textBaseline=t.textBaseline||\"alphabetic\",this.textAlign=t.textAlign||\"left\",this.lineWidth=t.lineWidth||1,this.lineJoin=t.lineJoin||\"miter\",this.lineCap=t.lineCap||\"butt\",this.path=t.path||[],this.transform=void 0!==t.transform?t.transform.clone():new l,this.globalCompositeOperation=t.globalCompositeOperation||\"normal\",this.globalAlpha=t.globalAlpha||1,this.clip_path=t.clip_path||[],this.currentPoint=t.currentPoint||new c,this.miterLimit=t.miterLimit||10,this.lastPoint=t.lastPoint||new c,this.lineDashOffset=t.lineDashOffset||0,this.lineDash=t.lineDash||[],this.margin=t.margin||[0,0,0,0],this.prevPageLastElemOffset=t.prevPageLastElemOffset||0,this.ignoreClearRect=\"boolean\"!=typeof t.ignoreClearRect||t.ignoreClearRect,this};t.events.push([\"initialized\",function(){this.context2d=new p(this),r=this.internal.f2,n=this.internal.getCoordinateString,a=this.internal.getVerticalCoordinateString,o=this.internal.getHorizontalCoordinate,s=this.internal.getVerticalCoordinate,c=this.internal.Point,u=this.internal.Rectangle,l=this.internal.Matrix,f=new d}]);var p=function(t){Object.defineProperty(this,\"canvas\",{get:function(){return{parentNode:!1,style:!1}}});var e=t;Object.defineProperty(this,\"pdf\",{get:function(){return e}});var r=!1;Object.defineProperty(this,\"pageWrapXEnabled\",{get:function(){return r},set:function(t){r=Boolean(t)}});var n=!1;Object.defineProperty(this,\"pageWrapYEnabled\",{get:function(){return n},set:function(t){n=Boolean(t)}});var i=0;Object.defineProperty(this,\"posX\",{get:function(){return i},set:function(t){isNaN(t)||(i=t)}});var a=0;Object.defineProperty(this,\"posY\",{get:function(){return a},set:function(t){isNaN(t)||(a=t)}}),Object.defineProperty(this,\"margin\",{get:function(){return f.margin},set:function(t){var e;\"number\"==typeof t?e=[t,t,t,t]:((e=new Array(4))[0]=t[0],e[1]=t.length>=2?t[1]:e[0],e[2]=t.length>=3?t[2]:e[0],e[3]=t.length>=4?t[3]:e[1]),f.margin=e}});var o=!1;Object.defineProperty(this,\"autoPaging\",{get:function(){return o},set:function(t){o=t}});var s=0;Object.defineProperty(this,\"lastBreak\",{get:function(){return s},set:function(t){s=t}});var c=[];Object.defineProperty(this,\"pageBreaks\",{get:function(){return c},set:function(t){c=t}}),Object.defineProperty(this,\"ctx\",{get:function(){return f},set:function(t){t instanceof d&&(f=t)}}),Object.defineProperty(this,\"path\",{get:function(){return f.path},set:function(t){f.path=t}});var u=[];Object.defineProperty(this,\"ctxStack\",{get:function(){return u},set:function(t){u=t}}),Object.defineProperty(this,\"fillStyle\",{get:function(){return this.ctx.fillStyle},set:function(t){var e;e=g(t),this.ctx.fillStyle=e.style,this.ctx.isFillTransparent=0===e.a,this.ctx.fillOpacity=e.a,this.pdf.setFillColor(e.r,e.g,e.b,{a:e.a}),this.pdf.setTextColor(e.r,e.g,e.b,{a:e.a})}}),Object.defineProperty(this,\"strokeStyle\",{get:function(){return this.ctx.strokeStyle},set:function(t){var e=g(t);this.ctx.strokeStyle=e.style,this.ctx.isStrokeTransparent=0===e.a,this.ctx.strokeOpacity=e.a,0===e.a?this.pdf.setDrawColor(255,255,255):(e.a,this.pdf.setDrawColor(e.r,e.g,e.b))}}),Object.defineProperty(this,\"lineCap\",{get:function(){return this.ctx.lineCap},set:function(t){-1!==[\"butt\",\"round\",\"square\"].indexOf(t)&&(this.ctx.lineCap=t,this.pdf.setLineCap(t))}}),Object.defineProperty(this,\"lineWidth\",{get:function(){return this.ctx.lineWidth},set:function(t){isNaN(t)||(this.ctx.lineWidth=t,this.pdf.setLineWidth(t))}}),Object.defineProperty(this,\"lineJoin\",{get:function(){return this.ctx.lineJoin},set:function(t){-1!==[\"bevel\",\"round\",\"miter\"].indexOf(t)&&(this.ctx.lineJoin=t,this.pdf.setLineJoin(t))}}),Object.defineProperty(this,\"miterLimit\",{get:function(){return this.ctx.miterLimit},set:function(t){isNaN(t)||(this.ctx.miterLimit=t,this.pdf.setMiterLimit(t))}}),Object.defineProperty(this,\"textBaseline\",{get:function(){return this.ctx.textBaseline},set:function(t){this.ctx.textBaseline=t}}),Object.defineProperty(this,\"textAlign\",{get:function(){return this.ctx.textAlign},set:function(t){-1!==[\"right\",\"end\",\"center\",\"left\",\"start\"].indexOf(t)&&(this.ctx.textAlign=t)}});var l=null;function h(t,e){if(null===l){var r=function(t){var e=[];return Object.keys(t).forEach((function(r){t[r].forEach((function(t){var n=null;switch(t){case\"bold\":n={family:r,weight:\"bold\"};break;case\"italic\":n={family:r,style:\"italic\"};break;case\"bolditalic\":n={family:r,weight:\"bold\",style:\"italic\"};break;case\"\":case\"normal\":n={family:r}}null!==n&&(n.ref={name:r,style:t},e.push(n))}))})),e}(t.getFontList());l=function(t){for(var e={},r=0;r<t.length;++r){var n=Ct(t[r]),i=n.family,a=n.stretch,o=n.style,s=n.weight;e[i]=e[i]||{},e[i][a]=e[i][a]||{},e[i][a][o]=e[i][a][o]||{},e[i][a][o][s]=n}return e}(r.concat(e))}return l}var p=null;Object.defineProperty(this,\"fontFaces\",{get:function(){return p},set:function(t){l=null,p=t}}),Object.defineProperty(this,\"font\",{get:function(){return this.ctx.font},set:function(t){var e;if(this.ctx.font=t,null!==(e=/^\\s*(?=(?:(?:[-a-z]+\\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\\1|\\2|\\3)\\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\\d]+(?:\\%|in|[cem]m|ex|p[ctx]))(?:\\s*\\/\\s*(normal|[.\\d]+(?:\\%|in|[cem]m|ex|p[ctx])))?\\s*([-_,\\\"\\'\\sa-z]+?)\\s*$/i.exec(t))){var r=e[1];e[2];var n=e[3],i=e[4];e[5];var a=e[6],o=/^([.\\d]+)((?:%|in|[cem]m|ex|p[ctx]))$/i.exec(i)[2];i=\"px\"===o?Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor):\"em\"===o?Math.floor(parseFloat(i)*this.pdf.getFontSize()):Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor),this.pdf.setFontSize(i);var s=function(t){var e,r,n=[],i=t.trim();if(\"\"===i)return Tt;if(i in Bt)return[Bt[i]];for(;\"\"!==i;){switch(r=null,e=(i=qt(i)).charAt(0)){case'\"':case\"'\":r=Dt(i.substring(1),e);break;default:r=Rt(i)}if(null===r)return Tt;if(n.push(r[0]),\"\"!==(i=qt(r[1]))&&\",\"!==i.charAt(0))return Tt;i=i.replace(/^,/,\"\")}return n}(a);if(this.fontFaces){var c=Et(h(this.pdf,this.fontFaces),s.map((function(t){return{family:t,stretch:\"normal\",weight:n,style:r}})));this.pdf.setFont(c.ref.name,c.ref.style)}else{var u=\"\";(\"bold\"===n||parseInt(n,10)>=700||\"bold\"===r)&&(u=\"bold\"),\"italic\"===r&&(u+=\"italic\"),0===u.length&&(u=\"normal\");for(var l=\"\",f={arial:\"Helvetica\",Arial:\"Helvetica\",verdana:\"Helvetica\",Verdana:\"Helvetica\",helvetica:\"Helvetica\",Helvetica:\"Helvetica\",\"sans-serif\":\"Helvetica\",fixed:\"Courier\",monospace:\"Courier\",terminal:\"Courier\",cursive:\"Times\",fantasy:\"Times\",serif:\"Times\"},d=0;d<s.length;d++){if(void 0!==this.pdf.internal.getFont(s[d],u,{noFallback:!0,disableWarning:!0})){l=s[d];break}if(\"bolditalic\"===u&&void 0!==this.pdf.internal.getFont(s[d],\"bold\",{noFallback:!0,disableWarning:!0}))l=s[d],u=\"bold\";else if(void 0!==this.pdf.internal.getFont(s[d],\"normal\",{noFallback:!0,disableWarning:!0})){l=s[d],u=\"normal\";break}}if(\"\"===l)for(var p=0;p<s.length;p++)if(f[s[p]]){l=f[s[p]];break}l=\"\"===l?\"Times\":l,this.pdf.setFont(l,u)}}}}),Object.defineProperty(this,\"globalCompositeOperation\",{get:function(){return this.ctx.globalCompositeOperation},set:function(t){this.ctx.globalCompositeOperation=t}}),Object.defineProperty(this,\"globalAlpha\",{get:function(){return this.ctx.globalAlpha},set:function(t){this.ctx.globalAlpha=t}}),Object.defineProperty(this,\"lineDashOffset\",{get:function(){return this.ctx.lineDashOffset},set:function(t){this.ctx.lineDashOffset=t,T.call(this)}}),Object.defineProperty(this,\"lineDash\",{get:function(){return this.ctx.lineDash},set:function(t){this.ctx.lineDash=t,T.call(this)}}),Object.defineProperty(this,\"ignoreClearRect\",{get:function(){return this.ctx.ignoreClearRect},set:function(t){this.ctx.ignoreClearRect=Boolean(t)}})};p.prototype.setLineDash=function(t){this.lineDash=t},p.prototype.getLineDash=function(){return this.lineDash.length%2?this.lineDash.concat(this.lineDash):this.lineDash.slice()},p.prototype.fill=function(){A.call(this,\"fill\",!1)},p.prototype.stroke=function(){A.call(this,\"stroke\",!1)},p.prototype.beginPath=function(){this.path=[{type:\"begin\"}]},p.prototype.moveTo=function(t,e){if(isNaN(t)||isNaN(e))throw i.error(\"jsPDF.context2d.moveTo: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.moveTo\");var r=this.ctx.transform.applyToPoint(new c(t,e));this.path.push({type:\"mt\",x:r.x,y:r.y}),this.ctx.lastPoint=new c(t,e)},p.prototype.closePath=function(){var t=new c(0,0),r=0;for(r=this.path.length-1;-1!==r;r--)if(\"begin\"===this.path[r].type&&\"object\"===e(this.path[r+1])&&\"number\"==typeof this.path[r+1].x){t=new c(this.path[r+1].x,this.path[r+1].y);break}this.path.push({type:\"close\"}),this.ctx.lastPoint=new c(t.x,t.y)},p.prototype.lineTo=function(t,e){if(isNaN(t)||isNaN(e))throw i.error(\"jsPDF.context2d.lineTo: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.lineTo\");var r=this.ctx.transform.applyToPoint(new c(t,e));this.path.push({type:\"lt\",x:r.x,y:r.y}),this.ctx.lastPoint=new c(r.x,r.y)},p.prototype.clip=function(){this.ctx.clip_path=JSON.parse(JSON.stringify(this.path)),A.call(this,null,!0)},p.prototype.quadraticCurveTo=function(t,e,r,n){if(isNaN(r)||isNaN(n)||isNaN(t)||isNaN(e))throw i.error(\"jsPDF.context2d.quadraticCurveTo: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.quadraticCurveTo\");var a=this.ctx.transform.applyToPoint(new c(r,n)),o=this.ctx.transform.applyToPoint(new c(t,e));this.path.push({type:\"qct\",x1:o.x,y1:o.y,x:a.x,y:a.y}),this.ctx.lastPoint=new c(a.x,a.y)},p.prototype.bezierCurveTo=function(t,e,r,n,a,o){if(isNaN(a)||isNaN(o)||isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw i.error(\"jsPDF.context2d.bezierCurveTo: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.bezierCurveTo\");var s=this.ctx.transform.applyToPoint(new c(a,o)),u=this.ctx.transform.applyToPoint(new c(t,e)),l=this.ctx.transform.applyToPoint(new c(r,n));this.path.push({type:\"bct\",x1:u.x,y1:u.y,x2:l.x,y2:l.y,x:s.x,y:s.y}),this.ctx.lastPoint=new c(s.x,s.y)},p.prototype.arc=function(t,e,r,n,a,o){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(a))throw i.error(\"jsPDF.context2d.arc: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.arc\");if(o=Boolean(o),!this.ctx.transform.isIdentity){var s=this.ctx.transform.applyToPoint(new c(t,e));t=s.x,e=s.y;var u=this.ctx.transform.applyToPoint(new c(0,r)),l=this.ctx.transform.applyToPoint(new c(0,0));r=Math.sqrt(Math.pow(u.x-l.x,2)+Math.pow(u.y-l.y,2))}Math.abs(a-n)>=2*Math.PI&&(n=0,a=2*Math.PI),this.path.push({type:\"arc\",x:t,y:e,radius:r,startAngle:n,endAngle:a,counterclockwise:o})},p.prototype.arcTo=function(t,e,r,n,i){throw new Error(\"arcTo not implemented.\")},p.prototype.rect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw i.error(\"jsPDF.context2d.rect: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.rect\");this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+n),this.lineTo(t,e+n),this.lineTo(t,e),this.lineTo(t+r,e),this.lineTo(t,e)},p.prototype.fillRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw i.error(\"jsPDF.context2d.fillRect: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.fillRect\");if(!m.call(this)){var a={};\"butt\"!==this.lineCap&&(a.lineCap=this.lineCap,this.lineCap=\"butt\"),\"miter\"!==this.lineJoin&&(a.lineJoin=this.lineJoin,this.lineJoin=\"miter\"),this.beginPath(),this.rect(t,e,r,n),this.fill(),a.hasOwnProperty(\"lineCap\")&&(this.lineCap=a.lineCap),a.hasOwnProperty(\"lineJoin\")&&(this.lineJoin=a.lineJoin)}},p.prototype.strokeRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw i.error(\"jsPDF.context2d.strokeRect: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.strokeRect\");v.call(this)||(this.beginPath(),this.rect(t,e,r,n),this.stroke())},p.prototype.clearRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw i.error(\"jsPDF.context2d.clearRect: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.clearRect\");this.ignoreClearRect||(this.fillStyle=\"#ffffff\",this.fillRect(t,e,r,n))},p.prototype.save=function(t){t=\"boolean\"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,r=0;r<this.pdf.internal.getNumberOfPages();r++)this.pdf.setPage(r+1),this.pdf.internal.out(\"q\");if(this.pdf.setPage(e),t){this.ctx.fontSize=this.pdf.internal.getFontSize();var n=new d(this.ctx);this.ctxStack.push(this.ctx),this.ctx=n}},p.prototype.restore=function(t){t=\"boolean\"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,r=0;r<this.pdf.internal.getNumberOfPages();r++)this.pdf.setPage(r+1),this.pdf.internal.out(\"Q\");this.pdf.setPage(e),t&&0!==this.ctxStack.length&&(this.ctx=this.ctxStack.pop(),this.fillStyle=this.ctx.fillStyle,this.strokeStyle=this.ctx.strokeStyle,this.font=this.ctx.font,this.lineCap=this.ctx.lineCap,this.lineWidth=this.ctx.lineWidth,this.lineJoin=this.ctx.lineJoin,this.lineDash=this.ctx.lineDash,this.lineDashOffset=this.ctx.lineDashOffset)},p.prototype.toDataURL=function(){throw new Error(\"toDataUrl not implemented.\")};var g=function(t){var e,r,n,i;if(!0===t.isCanvasGradient&&(t=t.getColor()),!t)return{r:0,g:0,b:0,a:0,style:t};if(/transparent|rgba\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*0+\\s*\\)/.test(t))e=0,r=0,n=0,i=0;else{var a=/rgb\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)/.exec(t);if(null!==a)e=parseInt(a[1]),r=parseInt(a[2]),n=parseInt(a[3]),i=1;else if(null!==(a=/rgba\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*([\\d.]+)\\s*\\)/.exec(t)))e=parseInt(a[1]),r=parseInt(a[2]),n=parseInt(a[3]),i=parseFloat(a[4]);else{if(i=1,\"string\"==typeof t&&\"#\"!==t.charAt(0)){var o=new h(t);t=o.ok?o.toHex():\"#000000\"}4===t.length?(e=t.substring(1,2),e+=e,r=t.substring(2,3),r+=r,n=t.substring(3,4),n+=n):(e=t.substring(1,3),r=t.substring(3,5),n=t.substring(5,7)),e=parseInt(e,16),r=parseInt(r,16),n=parseInt(n,16)}}return{r:e,g:r,b:n,a:i,style:t}},m=function(){return this.ctx.isFillTransparent||0==this.globalAlpha},v=function(){return Boolean(this.ctx.isStrokeTransparent||0==this.globalAlpha)};p.prototype.fillText=function(t,e,r,n){if(isNaN(e)||isNaN(r)||\"string\"!=typeof t)throw i.error(\"jsPDF.context2d.fillText: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.fillText\");if(n=isNaN(n)?void 0:n,!m.call(this)){var a=q(this.ctx.transform.rotation),o=this.ctx.transform.scaleX;C.call(this,{text:t,x:e,y:r,scale:o,angle:a,align:this.textAlign,maxWidth:n})}},p.prototype.strokeText=function(t,e,r,n){if(isNaN(e)||isNaN(r)||\"string\"!=typeof t)throw i.error(\"jsPDF.context2d.strokeText: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.strokeText\");if(!v.call(this)){n=isNaN(n)?void 0:n;var a=q(this.ctx.transform.rotation),o=this.ctx.transform.scaleX;C.call(this,{text:t,x:e,y:r,scale:o,renderingMode:\"stroke\",angle:a,align:this.textAlign,maxWidth:n})}},p.prototype.measureText=function(t){if(\"string\"!=typeof t)throw i.error(\"jsPDF.context2d.measureText: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.measureText\");var e=this.pdf,r=this.pdf.internal.scaleFactor,n=e.internal.getFontSize(),a=e.getStringUnitWidth(t)*n/e.internal.scaleFactor,o=function(t){var e=(t=t||{}).width||0;return Object.defineProperty(this,\"width\",{get:function(){return e}}),this};return new o({width:a*=Math.round(96*r/72*1e4)/1e4})},p.prototype.scale=function(t,e){if(isNaN(t)||isNaN(e))throw i.error(\"jsPDF.context2d.scale: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.scale\");var r=new l(t,0,0,e,0,0);this.ctx.transform=this.ctx.transform.multiply(r)},p.prototype.rotate=function(t){if(isNaN(t))throw i.error(\"jsPDF.context2d.rotate: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.rotate\");var e=new l(Math.cos(t),Math.sin(t),-Math.sin(t),Math.cos(t),0,0);this.ctx.transform=this.ctx.transform.multiply(e)},p.prototype.translate=function(t,e){if(isNaN(t)||isNaN(e))throw i.error(\"jsPDF.context2d.translate: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.translate\");var r=new l(1,0,0,1,t,e);this.ctx.transform=this.ctx.transform.multiply(r)},p.prototype.transform=function(t,e,r,n,a,o){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(a)||isNaN(o))throw i.error(\"jsPDF.context2d.transform: Invalid arguments\",arguments),new Error(\"Invalid arguments passed to jsPDF.context2d.transform\");var s=new l(t,e,r,n,a,o);this.ctx.transform=this.ctx.transform.multiply(s)},p.prototype.setTransform=function(t,e,r,n,i,a){t=isNaN(t)?1:t,e=isNaN(e)?0:e,r=isNaN(r)?0:r,n=isNaN(n)?1:n,i=isNaN(i)?0:i,a=isNaN(a)?0:a,this.ctx.transform=new l(t,e,r,n,i,a)};var b=function(){return this.margin[0]>0||this.margin[1]>0||this.margin[2]>0||this.margin[3]>0};p.prototype.drawImage=function(t,e,r,n,i,a,o,s,c){var h=this.pdf.getImageProperties(t),f=1,d=1,p=1,g=1;void 0!==n&&void 0!==s&&(p=s/n,g=c/i,f=h.width/n*s/n,d=h.height/i*c/i),void 0===a&&(a=e,o=r,e=0,r=0),void 0!==n&&void 0===s&&(s=n,c=i),void 0===n&&void 0===s&&(s=h.width,c=h.height);for(var m,v=this.ctx.transform.decompose(),w=q(v.rotate.shx),A=new l,S=(A=(A=(A=A.multiply(v.translate)).multiply(v.skew)).multiply(v.scale)).applyToRectangle(new u(a-e*p,o-r*g,n*f,i*d)),_=y.call(this,S),P=[],k=0;k<_.length;k+=1)-1===P.indexOf(_[k])&&P.push(_[k]);if(L(P),this.autoPaging)for(var F=P[0],I=P[P.length-1],C=F;C<I+1;C++){this.pdf.setPage(C);var j=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],O=1===C?this.posY+this.margin[0]:this.margin[0],B=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],M=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],E=1===C?0:B+(C-2)*M;if(0!==this.ctx.clip_path.length){var D=this.path;m=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(m,this.posX+this.margin[3],-E+O+this.ctx.prevPageLastElemOffset),x.call(this,\"fill\",!0),this.path=D}var R=JSON.parse(JSON.stringify(S));R=N([R],this.posX+this.margin[3],-E+O+this.ctx.prevPageLastElemOffset)[0];var T=(C>F||C<I)&&b.call(this);T&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],j,M,null).clip().discardPath()),this.pdf.addImage(t,\"JPEG\",R.x,R.y,R.w,R.h,null,null,w),T&&this.pdf.restoreGraphicsState()}else this.pdf.addImage(t,\"JPEG\",S.x,S.y,S.w,S.h,null,null,w)};var y=function(t,e,r){var n=[];e=e||this.pdf.internal.pageSize.width,r=r||this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2];var i=this.posY+this.ctx.prevPageLastElemOffset;switch(t.type){default:case\"mt\":case\"lt\":n.push(Math.floor((t.y+i)/r)+1);break;case\"arc\":n.push(Math.floor((t.y+i-t.radius)/r)+1),n.push(Math.floor((t.y+i+t.radius)/r)+1);break;case\"qct\":var a=D(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x,t.y);n.push(Math.floor((a.y+i)/r)+1),n.push(Math.floor((a.y+a.h+i)/r)+1);break;case\"bct\":var o=R(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x2,t.y2,t.x,t.y);n.push(Math.floor((o.y+i)/r)+1),n.push(Math.floor((o.y+o.h+i)/r)+1);break;case\"rect\":n.push(Math.floor((t.y+i)/r)+1),n.push(Math.floor((t.y+t.h+i)/r)+1)}for(var s=0;s<n.length;s+=1)for(;this.pdf.internal.getNumberOfPages()<n[s];)w.call(this);return n},w=function(){var t=this.fillStyle,e=this.strokeStyle,r=this.font,n=this.lineCap,i=this.lineWidth,a=this.lineJoin;this.pdf.addPage(),this.fillStyle=t,this.strokeStyle=e,this.font=r,this.lineCap=n,this.lineWidth=i,this.lineJoin=a},N=function(t,e,r){for(var n=0;n<t.length;n++)switch(t[n].type){case\"bct\":t[n].x2+=e,t[n].y2+=r;case\"qct\":t[n].x1+=e,t[n].y1+=r;case\"mt\":case\"lt\":case\"arc\":default:t[n].x+=e,t[n].y+=r}return t},L=function(t){return t.sort((function(t,e){return t-e}))},A=function(t,e){for(var r,n,i=this.fillStyle,a=this.strokeStyle,o=this.lineCap,s=this.lineWidth,c=Math.abs(s*this.ctx.transform.scaleX),u=this.lineJoin,l=JSON.parse(JSON.stringify(this.path)),h=JSON.parse(JSON.stringify(this.path)),f=[],d=0;d<h.length;d++)if(void 0!==h[d].x)for(var p=y.call(this,h[d]),g=0;g<p.length;g+=1)-1===f.indexOf(p[g])&&f.push(p[g]);for(var m=0;m<f.length;m++)for(;this.pdf.internal.getNumberOfPages()<f[m];)w.call(this);if(L(f),this.autoPaging)for(var v=f[0],A=f[f.length-1],S=v;S<A+1;S++){this.pdf.setPage(S),this.fillStyle=i,this.strokeStyle=a,this.lineCap=o,this.lineWidth=c,this.lineJoin=u;var _=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],P=1===S?this.posY+this.margin[0]:this.margin[0],k=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],F=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],I=1===S?0:k+(S-2)*F;if(0!==this.ctx.clip_path.length){var C=this.path;r=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(r,this.posX+this.margin[3],-I+P+this.ctx.prevPageLastElemOffset),x.call(this,t,!0),this.path=C}if(n=JSON.parse(JSON.stringify(l)),this.path=N(n,this.posX+this.margin[3],-I+P+this.ctx.prevPageLastElemOffset),!1===e||0===S){var j=(S>v||S<A)&&b.call(this);j&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],_,F,null).clip().discardPath()),x.call(this,t,e),j&&this.pdf.restoreGraphicsState()}this.lineWidth=s}else this.lineWidth=c,x.call(this,t,e),this.lineWidth=s;this.path=l},x=function(t,e){if((\"stroke\"!==t||e||!v.call(this))&&(\"stroke\"===t||e||!m.call(this))){for(var r,n,i=[],a=this.path,o=0;o<a.length;o++){var s=a[o];switch(s.type){case\"begin\":i.push({begin:!0});break;case\"close\":i.push({close:!0});break;case\"mt\":i.push({start:s,deltas:[],abs:[]});break;case\"lt\":var c=i.length;if(a[o-1]&&!isNaN(a[o-1].x)&&(r=[s.x-a[o-1].x,s.y-a[o-1].y],c>0))for(;c>=0;c--)if(!0!==i[c-1].close&&!0!==i[c-1].begin){i[c-1].deltas.push(r),i[c-1].abs.push(s);break}break;case\"bct\":r=[s.x1-a[o-1].x,s.y1-a[o-1].y,s.x2-a[o-1].x,s.y2-a[o-1].y,s.x-a[o-1].x,s.y-a[o-1].y],i[i.length-1].deltas.push(r);break;case\"qct\":var u=a[o-1].x+2/3*(s.x1-a[o-1].x),l=a[o-1].y+2/3*(s.y1-a[o-1].y),h=s.x+2/3*(s.x1-s.x),f=s.y+2/3*(s.y1-s.y),d=s.x,p=s.y;r=[u-a[o-1].x,l-a[o-1].y,h-a[o-1].x,f-a[o-1].y,d-a[o-1].x,p-a[o-1].y],i[i.length-1].deltas.push(r);break;case\"arc\":i.push({deltas:[],abs:[],arc:!0}),Array.isArray(i[i.length-1].abs)&&i[i.length-1].abs.push(s)}}n=e?null:\"stroke\"===t?\"stroke\":\"fill\";for(var g=!1,b=0;b<i.length;b++)if(i[b].arc)for(var y=i[b].abs,w=0;w<y.length;w++){var N=y[w];\"arc\"===N.type?P.call(this,N.x,N.y,N.radius,N.startAngle,N.endAngle,N.counterclockwise,void 0,e,!g):j.call(this,N.x,N.y),g=!0}else if(!0===i[b].close)this.pdf.internal.out(\"h\"),g=!1;else if(!0!==i[b].begin){var L=i[b].start.x,A=i[b].start.y;O.call(this,i[b].deltas,L,A),g=!0}n&&k.call(this,n),e&&F.call(this)}},S=function(t){var e=this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor,r=e*(this.pdf.internal.getLineHeightFactor()-1);switch(this.ctx.textBaseline){case\"bottom\":return t-r;case\"top\":return t+e-r;case\"hanging\":return t+e-2*r;case\"middle\":return t+e/2-r;case\"ideographic\":return t;case\"alphabetic\":default:return t}},_=function(t){return t+this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor*(this.pdf.internal.getLineHeightFactor()-1)};p.prototype.createLinearGradient=function(){var t=function(){};return t.colorStops=[],t.addColorStop=function(t,e){this.colorStops.push([t,e])},t.getColor=function(){return 0===this.colorStops.length?\"#000000\":this.colorStops[0][1]},t.isCanvasGradient=!0,t},p.prototype.createPattern=function(){return this.createLinearGradient()},p.prototype.createRadialGradient=function(){return this.createLinearGradient()};var P=function(t,e,r,n,i,a,o,s,c){for(var u=M.call(this,r,n,i,a),l=0;l<u.length;l++){var h=u[l];0===l&&(c?I.call(this,h.x1+t,h.y1+e):j.call(this,h.x1+t,h.y1+e)),B.call(this,t,e,h.x2,h.y2,h.x3,h.y3,h.x4,h.y4)}s?F.call(this):k.call(this,o)},k=function(t){switch(t){case\"stroke\":this.pdf.internal.out(\"S\");break;case\"fill\":this.pdf.internal.out(\"f\")}},F=function(){this.pdf.clip(),this.pdf.discardPath()},I=function(t,e){this.pdf.internal.out(n(t)+\" \"+a(e)+\" m\")},C=function(t){var e;switch(t.align){case\"right\":case\"end\":e=\"right\";break;case\"center\":e=\"center\";break;case\"left\":case\"start\":default:e=\"left\"}var r=this.pdf.getTextDimensions(t.text),n=S.call(this,t.y),i=_.call(this,n)-r.h,a=this.ctx.transform.applyToPoint(new c(t.x,n)),o=this.ctx.transform.decompose(),s=new l;s=(s=(s=s.multiply(o.translate)).multiply(o.skew)).multiply(o.scale);for(var h,f,d,p=this.ctx.transform.applyToRectangle(new u(t.x,n,r.w,r.h)),g=s.applyToRectangle(new u(t.x,i,r.w,r.h)),m=y.call(this,g),v=[],w=0;w<m.length;w+=1)-1===v.indexOf(m[w])&&v.push(m[w]);if(L(v),this.autoPaging)for(var A=v[0],P=v[v.length-1],k=A;k<P+1;k++){this.pdf.setPage(k);var F=1===k?this.posY+this.margin[0]:this.margin[0],I=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],C=this.pdf.internal.pageSize.height-this.margin[2],j=C-this.margin[0],O=this.pdf.internal.pageSize.width-this.margin[1],B=O-this.margin[3],M=1===k?0:I+(k-2)*j;if(0!==this.ctx.clip_path.length){var E=this.path;h=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(h,this.posX+this.margin[3],-1*M+F),x.call(this,\"fill\",!0),this.path=E}var q=N([JSON.parse(JSON.stringify(g))],this.posX+this.margin[3],-M+F+this.ctx.prevPageLastElemOffset)[0];t.scale>=.01&&(f=this.pdf.internal.getFontSize(),this.pdf.setFontSize(f*t.scale),d=this.lineWidth,this.lineWidth=d*t.scale);var D=\"text\"!==this.autoPaging;if(D||q.y+q.h<=C){if(D||q.y>=F&&q.x<=O){var R=D?t.text:this.pdf.splitTextToSize(t.text,t.maxWidth||O-q.x)[0],T=N([JSON.parse(JSON.stringify(p))],this.posX+this.margin[3],-M+F+this.ctx.prevPageLastElemOffset)[0],U=D&&(k>A||k<P)&&b.call(this);U&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],B,j,null).clip().discardPath()),this.pdf.text(R,T.x,T.y,{angle:t.angle,align:e,renderingMode:t.renderingMode}),U&&this.pdf.restoreGraphicsState()}}else q.y<C&&(this.ctx.prevPageLastElemOffset+=C-q.y);t.scale>=.01&&(this.pdf.setFontSize(f),this.lineWidth=d)}else t.scale>=.01&&(f=this.pdf.internal.getFontSize(),this.pdf.setFontSize(f*t.scale),d=this.lineWidth,this.lineWidth=d*t.scale),this.pdf.text(t.text,a.x+this.posX,a.y+this.posY,{angle:t.angle,align:e,renderingMode:t.renderingMode,maxWidth:t.maxWidth}),t.scale>=.01&&(this.pdf.setFontSize(f),this.lineWidth=d)},j=function(t,e,r,i){r=r||0,i=i||0,this.pdf.internal.out(n(t+r)+\" \"+a(e+i)+\" l\")},O=function(t,e,r){return this.pdf.lines(t,e,r,null,null)},B=function(t,e,n,i,a,c,u,l){this.pdf.internal.out([r(o(n+t)),r(s(i+e)),r(o(a+t)),r(s(c+e)),r(o(u+t)),r(s(l+e)),\"c\"].join(\" \"))},M=function(t,e,r,n){for(var i=2*Math.PI,a=Math.PI/2;e>r;)e-=i;var o=Math.abs(r-e);o<i&&n&&(o=i-o);for(var s=[],c=n?-1:1,u=e;o>1e-5;){var l=u+c*Math.min(o,a);s.push(E.call(this,t,u,l)),o-=Math.abs(l-u),u=l}return s},E=function(t,e,r){var n=(r-e)/2,i=t*Math.cos(n),a=t*Math.sin(n),o=i,s=-a,c=o*o+s*s,u=c+o*i+s*a,l=4/3*(Math.sqrt(2*c*u)-u)/(o*a-s*i),h=o-l*s,f=s+l*o,d=h,p=-f,g=n+e,m=Math.cos(g),v=Math.sin(g);return{x1:t*Math.cos(e),y1:t*Math.sin(e),x2:h*m-f*v,y2:h*v+f*m,x3:d*m-p*v,y3:d*v+p*m,x4:t*Math.cos(r),y4:t*Math.sin(r)}},q=function(t){return 180*t/Math.PI},D=function(t,e,r,n,i,a){var o=t+.5*(r-t),s=e+.5*(n-e),c=i+.5*(r-i),l=a+.5*(n-a),h=Math.min(t,i,o,c),f=Math.max(t,i,o,c),d=Math.min(e,a,s,l),p=Math.max(e,a,s,l);return new u(h,d,f-h,p-d)},R=function(t,e,r,n,i,a,o,s){var c,l,h,f,d,p,g,m,v,b,y,w,N,L,A=r-t,x=n-e,S=i-r,_=a-n,P=o-i,k=s-a;for(l=0;l<41;l++)v=(g=(h=t+(c=l/40)*A)+c*((d=r+c*S)-h))+c*(d+c*(i+c*P-d)-g),b=(m=(f=e+c*x)+c*((p=n+c*_)-f))+c*(p+c*(a+c*k-p)-m),0==l?(y=v,w=b,N=v,L=b):(y=Math.min(y,v),w=Math.min(w,b),N=Math.max(N,v),L=Math.max(L,b));return new u(Math.round(y),Math.round(w),Math.round(N-y),Math.round(L-w))},T=function(){if(this.prevLineDash||this.ctx.lineDash.length||this.ctx.lineDashOffset){var t,e,r=(t=this.ctx.lineDash,e=this.ctx.lineDashOffset,JSON.stringify({lineDash:t,lineDashOffset:e}));this.prevLineDash!==r&&(this.pdf.setLineDash(this.ctx.lineDash,this.ctx.lineDashOffset),this.prevLineDash=r)}}}(M.API);var Ut=Uint8Array,zt=Uint16Array,Ht=Int32Array,Wt=new Ut([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),Vt=new Ut([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),Gt=new Ut([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),Yt=function(t,e){for(var r=new zt(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new Ht(r[30]);for(n=1;n<30;++n)for(var a=r[n];a<r[n+1];++a)i[a]=a-r[n]<<5|n;return{b:r,r:i}},Jt=Yt(Wt,2),Xt=Jt.b,Kt=Jt.r;Xt[28]=258,Kt[258]=28;for(var Zt=Yt(Vt,0),$t=Zt.b,Qt=Zt.r,te=new zt(32768),ee=0;ee<32768;++ee){var re=(43690&ee)>>1|(21845&ee)<<1;re=(61680&(re=(52428&re)>>2|(13107&re)<<2))>>4|(3855&re)<<4,te[ee]=((65280&re)>>8|(255&re)<<8)>>1}var ne=function(t,e,r){for(var n=t.length,i=0,a=new zt(e);i<n;++i)t[i]&&++a[t[i]-1];var o,s=new zt(e);for(i=1;i<e;++i)s[i]=s[i-1]+a[i-1]<<1;if(r){o=new zt(1<<e);var c=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],l=e-t[i],h=s[t[i]-1]++<<l,f=h|(1<<l)-1;h<=f;++h)o[te[h]>>c]=u}else for(o=new zt(n),i=0;i<n;++i)t[i]&&(o[i]=te[s[t[i]-1]++]>>15-t[i]);return o},ie=new Ut(288);for(ee=0;ee<144;++ee)ie[ee]=8;for(ee=144;ee<256;++ee)ie[ee]=9;for(ee=256;ee<280;++ee)ie[ee]=7;for(ee=280;ee<288;++ee)ie[ee]=8;var ae=new Ut(32);for(ee=0;ee<32;++ee)ae[ee]=5;var oe=ne(ie,9,0),se=ne(ie,9,1),ce=ne(ae,5,0),ue=ne(ae,5,1),le=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},he=function(t,e,r){var n=e/8|0;return(t[n]|t[n+1]<<8)>>(7&e)&r},fe=function(t,e){var r=e/8|0;return(t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},de=function(t){return(t+7)/8|0},pe=function(t,e,r){return(null==e||e<0)&&(e=0),(null==r||r>t.length)&&(r=t.length),new Ut(t.subarray(e,r))},ge=[\"unexpected EOF\",\"invalid block type\",\"invalid length/literal\",\"invalid distance\",\"stream finished\",\"no stream handler\",,\"no callback\",\"invalid UTF-8 data\",\"extra field too long\",\"date not in range 1980-2099\",\"filename too long\",\"stream finishing\",\"invalid zip data\"],me=function(t,e,r){var n=new Error(e||ge[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,me),!r)throw n;return n},ve=function(t,e,r){r<<=7&e;var n=e/8|0;t[n]|=r,t[n+1]|=r>>8},be=function(t,e,r){r<<=7&e;var n=e/8|0;t[n]|=r,t[n+1]|=r>>8,t[n+2]|=r>>16},ye=function(t,e){for(var r=[],n=0;n<t.length;++n)t[n]&&r.push({s:n,f:t[n]});var i=r.length,a=r.slice();if(!i)return{t:_e,l:0};if(1==i){var o=new Ut(r[0].s+1);return o[r[0].s]=1,{t:o,l:1}}r.sort((function(t,e){return t.f-e.f})),r.push({s:-1,f:25001});var s=r[0],c=r[1],u=0,l=1,h=2;for(r[0]={s:-1,f:s.f+c.f,l:s,r:c};l!=i-1;)s=r[r[u].f<r[h].f?u++:h++],c=r[u!=l&&r[u].f<r[h].f?u++:h++],r[l++]={s:-1,f:s.f+c.f,l:s,r:c};var f=a[0].s;for(n=1;n<i;++n)a[n].s>f&&(f=a[n].s);var d=new zt(f+1),p=we(r[l-1],d,0);if(p>e){n=0;var g=0,m=p-e,v=1<<m;for(a.sort((function(t,e){return d[e.s]-d[t.s]||t.f-e.f}));n<i;++n){var b=a[n].s;if(!(d[b]>e))break;g+=v-(1<<p-d[b]),d[b]=e}for(g>>=m;g>0;){var y=a[n].s;d[y]<e?g-=1<<e-d[y]++-1:++n}for(;n>=0&&g;--n){var w=a[n].s;d[w]==e&&(--d[w],++g)}p=e}return{t:new Ut(d),l:p}},we=function(t,e,r){return-1==t.s?Math.max(we(t.l,e,r+1),we(t.r,e,r+1)):e[t.s]=r},Ne=function(t){for(var e=t.length;e&&!t[--e];);for(var r=new zt(++e),n=0,i=t[0],a=1,o=function(t){r[n++]=t},s=1;s<=e;++s)if(t[s]==i&&s!=e)++a;else{if(!i&&a>2){for(;a>138;a-=138)o(32754);a>2&&(o(a>10?a-11<<5|28690:a-3<<5|12305),a=0)}else if(a>3){for(o(i),--a;a>6;a-=6)o(8304);a>2&&(o(a-3<<5|8208),a=0)}for(;a--;)o(i);a=1,i=t[s]}return{c:r.subarray(0,n),n:e}},Le=function(t,e){for(var r=0,n=0;n<e.length;++n)r+=t[n]*e[n];return r},Ae=function(t,e,r){var n=r.length,i=de(e+2);t[i]=255&n,t[i+1]=n>>8,t[i+2]=255^t[i],t[i+3]=255^t[i+1];for(var a=0;a<n;++a)t[i+a+4]=r[a];return 8*(i+4+n)},xe=function(t,e,r,n,i,a,o,s,c,u,l){ve(e,l++,r),++i[256];for(var h=ye(i,15),f=h.t,d=h.l,p=ye(a,15),g=p.t,m=p.l,v=Ne(f),b=v.c,y=v.n,w=Ne(g),N=w.c,L=w.n,A=new zt(19),x=0;x<b.length;++x)++A[31&b[x]];for(x=0;x<N.length;++x)++A[31&N[x]];for(var S=ye(A,7),_=S.t,P=S.l,k=19;k>4&&!_[Gt[k-1]];--k);var F,I,C,j,O=u+5<<3,B=Le(i,ie)+Le(a,ae)+o,M=Le(i,f)+Le(a,g)+o+14+3*k+Le(A,_)+2*A[16]+3*A[17]+7*A[18];if(c>=0&&O<=B&&O<=M)return Ae(e,l,t.subarray(c,c+u));if(ve(e,l,1+(M<B)),l+=2,M<B){F=ne(f,d,0),I=f,C=ne(g,m,0),j=g;var E=ne(_,P,0);ve(e,l,y-257),ve(e,l+5,L-1),ve(e,l+10,k-4),l+=14;for(x=0;x<k;++x)ve(e,l+3*x,_[Gt[x]]);l+=3*k;for(var q=[b,N],D=0;D<2;++D){var R=q[D];for(x=0;x<R.length;++x){var T=31&R[x];ve(e,l,E[T]),l+=_[T],T>15&&(ve(e,l,R[x]>>5&127),l+=R[x]>>12)}}}else F=oe,I=ie,C=ce,j=ae;for(x=0;x<s;++x){var U=n[x];if(U>255){be(e,l,F[(T=U>>18&31)+257]),l+=I[T+257],T>7&&(ve(e,l,U>>23&31),l+=Wt[T]);var z=31&U;be(e,l,C[z]),l+=j[z],z>3&&(be(e,l,U>>5&8191),l+=Vt[z])}else be(e,l,F[U]),l+=I[U]}return be(e,l,F[256]),l+I[256]},Se=new Ht([65540,131080,131088,131104,262176,1048704,1048832,2114560,2117632]),_e=new Ut(0),Pe=function(){var t=1,e=0;return{p:function(r){for(var n=t,i=e,a=0|r.length,o=0;o!=a;){for(var s=Math.min(o+2655,a);o<s;++o)i+=n+=r[o];n=(65535&n)+15*(n>>16),i=(65535&i)+15*(i>>16)}t=n,e=i},d:function(){return(255&(t%=65521))<<24|(65280&t)<<8|(255&(e%=65521))<<8|e>>8}}},ke=function(t,e,r,n,i){if(!i&&(i={l:1},e.dictionary)){var a=e.dictionary.subarray(-32768),o=new Ut(a.length+t.length);o.set(a),o.set(t,a.length),t=o,i.w=a.length}return function(t,e,r,n,i,a){var o=a.z||t.length,s=new Ut(n+o+5*(1+Math.ceil(o/7e3))+i),c=s.subarray(n,s.length-i),u=a.l,l=7&(a.r||0);if(e){l&&(c[0]=a.r>>3);for(var h=Se[e-1],f=h>>13,d=8191&h,p=(1<<r)-1,g=a.p||new zt(32768),m=a.h||new zt(p+1),v=Math.ceil(r/3),b=2*v,y=function(e){return(t[e]^t[e+1]<<v^t[e+2]<<b)&p},w=new Ht(25e3),N=new zt(288),L=new zt(32),A=0,x=0,S=a.i||0,_=0,P=a.w||0,k=0;S+2<o;++S){var F=y(S),I=32767&S,C=m[F];if(g[I]=C,m[F]=I,P<=S){var j=o-S;if((A>7e3||_>24576)&&(j>423||!u)){l=xe(t,c,0,w,N,L,x,_,k,S-k,l),_=A=x=0,k=S;for(var O=0;O<286;++O)N[O]=0;for(O=0;O<30;++O)L[O]=0}var B=2,M=0,E=d,q=I-C&32767;if(j>2&&F==y(S-q))for(var D=Math.min(f,j)-1,R=Math.min(32767,S),T=Math.min(258,j);q<=R&&--E&&I!=C;){if(t[S+B]==t[S+B-q]){for(var U=0;U<T&&t[S+U]==t[S+U-q];++U);if(U>B){if(B=U,M=q,U>D)break;var z=Math.min(q,U-2),H=0;for(O=0;O<z;++O){var W=S-q+O&32767,V=W-g[W]&32767;V>H&&(H=V,C=W)}}}q+=(I=C)-(C=g[I])&32767}if(M){w[_++]=268435456|Kt[B]<<18|Qt[M];var G=31&Kt[B],Y=31&Qt[M];x+=Wt[G]+Vt[Y],++N[257+G],++L[Y],P=S+B,++A}else w[_++]=t[S],++N[t[S]]}}for(S=Math.max(S,P);S<o;++S)w[_++]=t[S],++N[t[S]];l=xe(t,c,u,w,N,L,x,_,k,S-k,l),u||(a.r=7&l|c[l/8|0]<<3,l-=7,a.h=m,a.p=g,a.i=S,a.w=P)}else{for(S=a.w||0;S<o+u;S+=65535){var J=S+65535;J>=o&&(c[l/8|0]=u,J=o),l=Ae(c,l+1,t.subarray(S,J))}a.i=o}return pe(s,0,n+de(l)+i)}(t,null==e.level?6:e.level,null==e.mem?Math.ceil(1.5*Math.max(8,Math.min(13,Math.log(t.length)))):12+e.mem,r,n,i)},Fe=function(t,e,r){for(;r;++e)t[e]=r,r>>>=8};function Ie(t,e){e||(e={});var r=Pe();r.p(t);var n=ke(t,e,e.dictionary?6:2,4);return function(t,e){var r=e.level,n=0==r?0:r<6?1:9==r?3:2;if(t[0]=120,t[1]=n<<6|(e.dictionary&&32),t[1]|=31-(t[0]<<8|t[1])%31,e.dictionary){var i=Pe();i.p(e.dictionary),Fe(t,2,i.d())}}(n,e),Fe(n,n.length-4,r.d()),n}function Ce(t,e){return function(t,e,r,n){var i=t.length,a=n?n.length:0;if(!i||e.f&&!e.l)return r||new Ut(0);var o=!r,s=o||2!=e.i,c=e.i;o&&(r=new Ut(3*i));var u=function(t){var e=r.length;if(t>e){var n=new Ut(Math.max(2*e,t));n.set(r),r=n}},l=e.f||0,h=e.p||0,f=e.b||0,d=e.l,p=e.d,g=e.m,m=e.n,v=8*i;do{if(!d){l=he(t,h,1);var b=he(t,h+1,3);if(h+=3,!b){var y=t[(I=de(h)+4)-4]|t[I-3]<<8,w=I+y;if(w>i){c&&me(0);break}s&&u(f+y),r.set(t.subarray(I,w),f),e.b=f+=y,e.p=h=8*w,e.f=l;continue}if(1==b)d=se,p=ue,g=9,m=5;else if(2==b){var N=he(t,h,31)+257,L=he(t,h+10,15)+4,A=N+he(t,h+5,31)+1;h+=14;for(var x=new Ut(A),S=new Ut(19),_=0;_<L;++_)S[Gt[_]]=he(t,h+3*_,7);h+=3*L;var P=le(S),k=(1<<P)-1,F=ne(S,P,1);for(_=0;_<A;){var I,C=F[he(t,h,k)];if(h+=15&C,(I=C>>4)<16)x[_++]=I;else{var j=0,O=0;for(16==I?(O=3+he(t,h,3),h+=2,j=x[_-1]):17==I?(O=3+he(t,h,7),h+=3):18==I&&(O=11+he(t,h,127),h+=7);O--;)x[_++]=j}}var B=x.subarray(0,N),M=x.subarray(N);g=le(B),m=le(M),d=ne(B,g,1),p=ne(M,m,1)}else me(1);if(h>v){c&&me(0);break}}s&&u(f+131072);for(var E=(1<<g)-1,q=(1<<m)-1,D=h;;D=h){var R=(j=d[fe(t,h)&E])>>4;if((h+=15&j)>v){c&&me(0);break}if(j||me(2),R<256)r[f++]=R;else{if(256==R){D=h,d=null;break}var T=R-254;if(R>264){var U=Wt[_=R-257];T=he(t,h,(1<<U)-1)+Xt[_],h+=U}var z=p[fe(t,h)&q],H=z>>4;z||me(3),h+=15&z;M=$t[H];if(H>3){U=Vt[H];M+=fe(t,h)&(1<<U)-1,h+=U}if(h>v){c&&me(0);break}s&&u(f+131072);var W=f+T;if(f<M){var V=a-M,G=Math.min(M,W);for(V+f<0&&me(3);f<G;++f)r[f]=n[V+f]}for(;f<W;++f)r[f]=r[f-M]}}e.l=d,e.p=D,e.b=f,e.f=l,d&&(l=1,e.m=g,e.d=p,e.n=m)}while(!l);return f!=r.length&&o?pe(r,0,f):r.subarray(0,f)}(t.subarray((r=t,n=e&&e.dictionary,(8!=(15&r[0])||r[0]>>4>7||(r[0]<<8|r[1])%31)&&me(6,\"invalid zlib data\"),(r[1]>>5&1)==+!n&&me(6,\"invalid zlib data: \"+(32&r[1]?\"need\":\"unexpected\")+\" dictionary\"),2+(r[1]>>3&4)),-4),{i:2},e&&e.out,e&&e.dictionary);var r,n}var je=\"undefined\"!=typeof TextDecoder&&new TextDecoder;try{je.decode(_e,{stream:!0}),1}catch(t){}\n/**\n   * @license\n   * jsPDF filters PlugIn\n   * Copyright (c) 2014 Aras Abbasi\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */!function(t){var e=function(t){var e,r,n,i,a,o,s,c,u,l;for(/[^\\x00-\\xFF]/.test(t),r=[],n=0,i=(t+=e=\"\\0\\0\\0\\0\".slice(t.length%4||4)).length;i>n;n+=4)0!==(a=(t.charCodeAt(n)<<24)+(t.charCodeAt(n+1)<<16)+(t.charCodeAt(n+2)<<8)+t.charCodeAt(n+3))?(o=(a=((a=((a=((a=(a-(l=a%85))/85)-(u=a%85))/85)-(c=a%85))/85)-(s=a%85))/85)%85,r.push(o+33,s+33,c+33,u+33,l+33)):r.push(122);return function(t,e){for(var r=e;r>0;r--)t.pop()}(r,e.length),String.fromCharCode.apply(String,r)+\"~>\"},r=function(t){var e,r,n,i,a,o=String,s=\"length\",c=255,u=\"charCodeAt\",l=\"slice\",h=\"replace\";for(t[l](-2),t=t[l](0,-2)[h](/\\s/g,\"\")[h](\"z\",\"!!!!!\"),n=[],i=0,a=(t+=e=\"uuuuu\"[l](t[s]%5||5))[s];a>i;i+=5)r=52200625*(t[u](i)-33)+614125*(t[u](i+1)-33)+7225*(t[u](i+2)-33)+85*(t[u](i+3)-33)+(t[u](i+4)-33),n.push(c&r>>24,c&r>>16,c&r>>8,c&r);return function(t,e){for(var r=e;r>0;r--)t.pop()}(n,e[s]),o.fromCharCode.apply(o,n)},n=function(t){var e=new RegExp(/^([0-9A-Fa-f]{2})+$/);if(-1!==(t=t.replace(/\\s/g,\"\")).indexOf(\">\")&&(t=t.substr(0,t.indexOf(\">\"))),t.length%2&&(t+=\"0\"),!1===e.test(t))return\"\";for(var r=\"\",n=0;n<t.length;n+=2)r+=String.fromCharCode(\"0x\"+(t[n]+t[n+1]));return r},i=function(t){for(var e=new Uint8Array(t.length),r=t.length;r--;)e[r]=t.charCodeAt(r);return t=(e=Ie(e)).reduce((function(t,e){return t+String.fromCharCode(e)}),\"\")};t.processDataByFilters=function(t,a){var o=0,s=t||\"\",c=[];for(\"string\"==typeof(a=a||[])&&(a=[a]),o=0;o<a.length;o+=1)switch(a[o]){case\"ASCII85Decode\":case\"/ASCII85Decode\":s=r(s),c.push(\"/ASCII85Encode\");break;case\"ASCII85Encode\":case\"/ASCII85Encode\":s=e(s),c.push(\"/ASCII85Decode\");break;case\"ASCIIHexDecode\":case\"/ASCIIHexDecode\":s=n(s),c.push(\"/ASCIIHexEncode\");break;case\"ASCIIHexEncode\":case\"/ASCIIHexEncode\":s=s.split(\"\").map((function(t){return(\"0\"+t.charCodeAt().toString(16)).slice(-2)})).join(\"\")+\">\",c.push(\"/ASCIIHexDecode\");break;case\"FlateEncode\":case\"/FlateEncode\":s=i(s),c.push(\"/FlateDecode\");break;default:throw new Error('The filter: \"'+a[o]+'\" is not implemented')}return{data:s,reverseChain:c.reverse().join(\" \")}}}(M.API),\n/**\n   * @license\n   * jsPDF fileloading PlugIn\n   * Copyright (c) 2018 Aras Abbasi (aras.abbasi@gmail.com)\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){t.loadFile=function(t,e,r){return function(t,e,r){e=!1!==e,r=\"function\"==typeof r?r:function(){};var n=void 0;try{n=function(t,e,r){var n=new XMLHttpRequest,i=0,a=function(t){var e=t.length,r=[],n=String.fromCharCode;for(i=0;i<e;i+=1)r.push(n(255&t.charCodeAt(i)));return r.join(\"\")};if(n.open(\"GET\",t,!e),n.overrideMimeType(\"text/plain; charset=x-user-defined\"),!1===e&&(n.onload=function(){200===n.status?r(a(this.responseText)):r(void 0)}),n.send(null),e&&200===n.status)return a(n.responseText)}(t,e,r)}catch(t){}return n}(t,e,r)},t.loadImageFile=t.loadFile}(M.API),function(n){function i(){return(r.html2canvas?Promise.resolve(r.html2canvas):\"object\"===(void 0===t?\"undefined\":e(t))&&\"undefined\"!=typeof module?new Promise((function(t,e){try{t(require(\"html2canvas\"))}catch(t){e(t)}})):\"function\"==typeof define&&define.amd?new Promise((function(t,e){try{require([\"html2canvas\"],t)}catch(t){e(t)}})):Promise.reject(new Error(\"Could not load html2canvas\"))).catch((function(t){return Promise.reject(new Error(\"Could not load html2canvas: \"+t))})).then((function(t){return t.default?t.default:t}))}function a(){return(r.DOMPurify?Promise.resolve(r.DOMPurify):\"object\"===(void 0===t?\"undefined\":e(t))&&\"undefined\"!=typeof module?new Promise((function(t,e){try{t(require(\"dompurify\"))}catch(t){e(t)}})):\"function\"==typeof define&&define.amd?new Promise((function(t,e){try{require([\"dompurify\"],t)}catch(t){e(t)}})):Promise.reject(new Error(\"Could not load dompurify\"))).catch((function(t){return Promise.reject(new Error(\"Could not load dompurify: \"+t))})).then((function(t){return t.default?t.default:t}))}var o=function(t){var r=e(t);return\"undefined\"===r?\"undefined\":\"string\"===r||t instanceof String?\"string\":\"number\"===r||t instanceof Number?\"number\":\"function\"===r||t instanceof Function?\"function\":t&&t.constructor===Array?\"array\":t&&1===t.nodeType?\"element\":\"object\"===r?\"object\":\"unknown\"},s=function(t,e){var r=document.createElement(t);for(var n in e.className&&(r.className=e.className),e.innerHTML&&e.dompurify&&(r.innerHTML=e.dompurify.sanitize(e.innerHTML)),e.style)r.style[n]=e.style[n];return r},c=function t(e){var r=Object.assign(t.convert(Promise.resolve()),JSON.parse(JSON.stringify(t.template))),n=t.convert(Promise.resolve(),r);return n=(n=n.setProgress(1,t,1,[t])).set(e)};(c.prototype=Object.create(Promise.prototype)).constructor=c,c.convert=function(t,e){return t.__proto__=e||c.prototype,t},c.template={prop:{src:null,container:null,overlay:null,canvas:null,img:null,pdf:null,pageSize:null,callback:function(){}},progress:{val:0,state:null,n:0,stack:[]},opt:{filename:\"file.pdf\",margin:[0,0,0,0],enableLinks:!0,x:0,y:0,html2canvas:{},jsPDF:{},backgroundColor:\"transparent\"}},c.prototype.from=function(t,e){return this.then((function(){switch(e=e||function(t){switch(o(t)){case\"string\":return\"string\";case\"element\":return\"canvas\"===t.nodeName.toLowerCase()?\"canvas\":\"element\";default:return\"unknown\"}}(t)){case\"string\":return this.then(a).then((function(e){return this.set({src:s(\"div\",{innerHTML:t,dompurify:e})})}));case\"element\":return this.set({src:t});case\"canvas\":return this.set({canvas:t});case\"img\":return this.set({img:t});default:return this.error(\"Unknown source type.\")}}))},c.prototype.to=function(t){switch(t){case\"container\":return this.toContainer();case\"canvas\":return this.toCanvas();case\"img\":return this.toImg();case\"pdf\":return this.toPdf();default:return this.error(\"Invalid target.\")}},c.prototype.toContainer=function(){return this.thenList([function(){return this.prop.src||this.error(\"Cannot duplicate - no source HTML.\")},function(){return this.prop.pageSize||this.setPageSize()}]).then((function(){var t={position:\"relative\",display:\"inline-block\",width:(\"number\"!=typeof this.opt.width||isNaN(this.opt.width)||\"number\"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?Math.max(this.prop.src.clientWidth,this.prop.src.scrollWidth,this.prop.src.offsetWidth):this.opt.windowWidth)+\"px\",left:0,right:0,top:0,margin:\"auto\",backgroundColor:this.opt.backgroundColor},e=function t(e,r){for(var n=3===e.nodeType?document.createTextNode(e.nodeValue):e.cloneNode(!1),i=e.firstChild;i;i=i.nextSibling)!0!==r&&1===i.nodeType&&\"SCRIPT\"===i.nodeName||n.appendChild(t(i,r));return 1===e.nodeType&&(\"CANVAS\"===e.nodeName?(n.width=e.width,n.height=e.height,n.getContext(\"2d\").drawImage(e,0,0)):\"TEXTAREA\"!==e.nodeName&&\"SELECT\"!==e.nodeName||(n.value=e.value),n.addEventListener(\"load\",(function(){n.scrollTop=e.scrollTop,n.scrollLeft=e.scrollLeft}),!0)),n}(this.prop.src,this.opt.html2canvas.javascriptEnabled);\"BODY\"===e.tagName&&(t.height=Math.max(document.body.scrollHeight,document.body.offsetHeight,document.documentElement.clientHeight,document.documentElement.scrollHeight,document.documentElement.offsetHeight)+\"px\"),this.prop.overlay=s(\"div\",{className:\"html2pdf__overlay\",style:{position:\"fixed\",overflow:\"hidden\",zIndex:1e3,left:\"-100000px\",right:0,bottom:0,top:0}}),this.prop.container=s(\"div\",{className:\"html2pdf__container\",style:t}),this.prop.container.appendChild(e),this.prop.container.firstChild.appendChild(s(\"div\",{style:{clear:\"both\",border:\"0 none transparent\",margin:0,padding:0,height:0}})),this.prop.container.style.float=\"none\",this.prop.overlay.appendChild(this.prop.container),document.body.appendChild(this.prop.overlay),this.prop.container.firstChild.style.position=\"relative\",this.prop.container.height=Math.max(this.prop.container.firstChild.clientHeight,this.prop.container.firstChild.scrollHeight,this.prop.container.firstChild.offsetHeight)+\"px\"}))},c.prototype.toCanvas=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(i).then((function(t){var e=Object.assign({},this.opt.html2canvas);return delete e.onrendered,t(this.prop.container,e)})).then((function(t){(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)}))},c.prototype.toContext2d=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(i).then((function(t){var e=this.opt.jsPDF,r=this.opt.fontFaces,n=\"number\"!=typeof this.opt.width||isNaN(this.opt.width)||\"number\"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?1:this.opt.width/this.opt.windowWidth,i=Object.assign({async:!0,allowTaint:!0,scale:n,scrollX:this.opt.scrollX||0,scrollY:this.opt.scrollY||0,backgroundColor:\"#ffffff\",imageTimeout:15e3,logging:!0,proxy:null,removeContainer:!0,foreignObjectRendering:!1,useCORS:!1},this.opt.html2canvas);if(delete i.onrendered,e.context2d.autoPaging=void 0===this.opt.autoPaging||this.opt.autoPaging,e.context2d.posX=this.opt.x,e.context2d.posY=this.opt.y,e.context2d.margin=this.opt.margin,e.context2d.fontFaces=r,r)for(var a=0;a<r.length;++a){var o=r[a],s=o.src.find((function(t){return\"truetype\"===t.format}));s&&e.addFont(s.url,o.ref.name,o.ref.style)}return i.windowHeight=i.windowHeight||0,i.windowHeight=0==i.windowHeight?Math.max(this.prop.container.clientHeight,this.prop.container.scrollHeight,this.prop.container.offsetHeight):i.windowHeight,e.context2d.save(!0),t(this.prop.container,i)})).then((function(t){this.opt.jsPDF.context2d.restore(!0),(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)}))},c.prototype.toImg=function(){return this.thenList([function(){return this.prop.canvas||this.toCanvas()}]).then((function(){var t=this.prop.canvas.toDataURL(\"image/\"+this.opt.image.type,this.opt.image.quality);this.prop.img=document.createElement(\"img\"),this.prop.img.src=t}))},c.prototype.toPdf=function(){return this.thenList([function(){return this.toContext2d()}]).then((function(){this.prop.pdf=this.prop.pdf||this.opt.jsPDF}))},c.prototype.output=function(t,e,r){return\"img\"===(r=r||\"pdf\").toLowerCase()||\"image\"===r.toLowerCase()?this.outputImg(t,e):this.outputPdf(t,e)},c.prototype.outputPdf=function(t,e){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then((function(){return this.prop.pdf.output(t,e)}))},c.prototype.outputImg=function(t){return this.thenList([function(){return this.prop.img||this.toImg()}]).then((function(){switch(t){case void 0:case\"img\":return this.prop.img;case\"datauristring\":case\"dataurlstring\":return this.prop.img.src;case\"datauri\":case\"dataurl\":return document.location.href=this.prop.img.src;default:throw'Image output type \"'+t+'\" is not supported.'}}))},c.prototype.save=function(t){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).set(t?{filename:t}:null).then((function(){this.prop.pdf.save(this.opt.filename)}))},c.prototype.doCallback=function(){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then((function(){this.prop.callback(this.prop.pdf)}))},c.prototype.set=function(t){if(\"object\"!==o(t))return this;var e=Object.keys(t||{}).map((function(e){if(e in c.template.prop)return function(){this.prop[e]=t[e]};switch(e){case\"margin\":return this.setMargin.bind(this,t.margin);case\"jsPDF\":return function(){return this.opt.jsPDF=t.jsPDF,this.setPageSize()};case\"pageSize\":return this.setPageSize.bind(this,t.pageSize);default:return function(){this.opt[e]=t[e]}}}),this);return this.then((function(){return this.thenList(e)}))},c.prototype.get=function(t,e){return this.then((function(){var r=t in c.template.prop?this.prop[t]:this.opt[t];return e?e(r):r}))},c.prototype.setMargin=function(t){return this.then((function(){switch(o(t)){case\"number\":t=[t,t,t,t];case\"array\":if(2===t.length&&(t=[t[0],t[1],t[0],t[1]]),4===t.length)break;default:return this.error(\"Invalid margin array.\")}this.opt.margin=t})).then(this.setPageSize)},c.prototype.setPageSize=function(t){function e(t,e){return Math.floor(t*e/72*96)}return this.then((function(){(t=t||M.getPageSize(this.opt.jsPDF)).hasOwnProperty(\"inner\")||(t.inner={width:t.width-this.opt.margin[1]-this.opt.margin[3],height:t.height-this.opt.margin[0]-this.opt.margin[2]},t.inner.px={width:e(t.inner.width,t.k),height:e(t.inner.height,t.k)},t.inner.ratio=t.inner.height/t.inner.width),this.prop.pageSize=t}))},c.prototype.setProgress=function(t,e,r,n){return null!=t&&(this.progress.val=t),null!=e&&(this.progress.state=e),null!=r&&(this.progress.n=r),null!=n&&(this.progress.stack=n),this.progress.ratio=this.progress.val/this.progress.state,this},c.prototype.updateProgress=function(t,e,r,n){return this.setProgress(t?this.progress.val+t:null,e||null,r?this.progress.n+r:null,n?this.progress.stack.concat(n):null)},c.prototype.then=function(t,e){var r=this;return this.thenCore(t,e,(function(t,e){return r.updateProgress(null,null,1,[t]),Promise.prototype.then.call(this,(function(e){return r.updateProgress(null,t),e})).then(t,e).then((function(t){return r.updateProgress(1),t}))}))},c.prototype.thenCore=function(t,e,r){r=r||Promise.prototype.then;t&&(t=t.bind(this)),e&&(e=e.bind(this));var n=-1!==Promise.toString().indexOf(\"[native code]\")&&\"Promise\"===Promise.name?this:c.convert(Object.assign({},this),Promise.prototype),i=r.call(n,t,e);return c.convert(i,this.__proto__)},c.prototype.thenExternal=function(t,e){return Promise.prototype.then.call(this,t,e)},c.prototype.thenList=function(t){var e=this;return t.forEach((function(t){e=e.thenCore(t)})),e},c.prototype.catch=function(t){t&&(t=t.bind(this));var e=Promise.prototype.catch.call(this,t);return c.convert(e,this)},c.prototype.catchExternal=function(t){return Promise.prototype.catch.call(this,t)},c.prototype.error=function(t){return this.then((function(){throw new Error(t)}))},c.prototype.using=c.prototype.set,c.prototype.saveAs=c.prototype.save,c.prototype.export=c.prototype.output,c.prototype.run=c.prototype.then,M.getPageSize=function(t,r,n){if(\"object\"===e(t)){var i=t;t=i.orientation,r=i.unit||r,n=i.format||n}r=r||\"mm\",n=n||\"a4\",t=(\"\"+(t||\"P\")).toLowerCase();var a,o=(\"\"+n).toLowerCase(),s={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],\"government-letter\":[576,756],legal:[612,1008],\"junior-legal\":[576,360],ledger:[1224,792],tabloid:[792,1224],\"credit-card\":[153,243]};switch(r){case\"pt\":a=1;break;case\"mm\":a=72/25.4;break;case\"cm\":a=72/2.54;break;case\"in\":a=72;break;case\"px\":a=.75;break;case\"pc\":case\"em\":a=12;break;case\"ex\":a=6;break;default:throw\"Invalid unit: \"+r}var c,u=0,l=0;if(s.hasOwnProperty(o))u=s[o][1]/a,l=s[o][0]/a;else try{u=n[1],l=n[0]}catch(t){throw new Error(\"Invalid format: \"+n)}if(\"p\"===t||\"portrait\"===t)t=\"p\",l>u&&(c=l,l=u,u=c);else{if(\"l\"!==t&&\"landscape\"!==t)throw\"Invalid orientation: \"+t;t=\"l\",u>l&&(c=l,l=u,u=c)}return{width:l,height:u,unit:r,k:a,orientation:t}},n.html=function(t,e){(e=e||{}).callback=e.callback||function(){},e.html2canvas=e.html2canvas||{},e.html2canvas.canvas=e.html2canvas.canvas||this.canvas,e.jsPDF=e.jsPDF||this,e.fontFaces=e.fontFaces?e.fontFaces.map(Ct):null;var r=new c(e);return e.worker?r:r.from(t).doCallback()}}(M.API),\n/**\n   * @license\n   * ====================================================================\n   * Copyright (c) 2013 Youssef Beddad, youssef.beddad@gmail.com\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining\n   * a copy of this software and associated documentation files (the\n   * \"Software\"), to deal in the Software without restriction, including\n   * without limitation the rights to use, copy, modify, merge, publish,\n   * distribute, sublicense, and/or sell copies of the Software, and to\n   * permit persons to whom the Software is furnished to do so, subject to\n   * the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be\n   * included in all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n   * ====================================================================\n   */\nfunction(t){var e,r,n;t.addJS=function(t){return n=t,this.internal.events.subscribe(\"postPutResources\",(function(){e=this.internal.newObject(),this.internal.out(\"<<\"),this.internal.out(\"/Names [(EmbeddedJS) \"+(e+1)+\" 0 R]\"),this.internal.out(\">>\"),this.internal.out(\"endobj\"),r=this.internal.newObject(),this.internal.out(\"<<\"),this.internal.out(\"/S /JavaScript\"),this.internal.out(\"/JS (\"+n+\")\"),this.internal.out(\">>\"),this.internal.out(\"endobj\")})),this.internal.events.subscribe(\"putCatalog\",(function(){void 0!==e&&void 0!==r&&this.internal.out(\"/Names <</JavaScript \"+e+\" 0 R>>\")})),this}}(M.API),\n/**\n   * @license\n   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e;t.events.push([\"postPutResources\",function(){var t=this,r=/^(\\d+) 0 obj$/;if(this.outline.root.children.length>0)for(var n=t.outline.render().split(/\\r\\n/),i=0;i<n.length;i++){var a=n[i],o=r.exec(a);if(null!=o){var s=o[1];t.internal.newObjectDeferredBegin(s,!1)}t.internal.write(a)}if(this.outline.createNamedDestinations){var c=this.internal.pages.length,u=[];for(i=0;i<c;i++){var l=t.internal.newObject();u.push(l);var h=t.internal.getPageInfo(i+1);t.internal.write(\"<< /D[\"+h.objId+\" 0 R /XYZ null null null]>> endobj\")}var f=t.internal.newObject();t.internal.write(\"<< /Names [ \");for(i=0;i<u.length;i++)t.internal.write(\"(page_\"+(i+1)+\")\"+u[i]+\" 0 R\");t.internal.write(\" ] >>\",\"endobj\"),e=t.internal.newObject(),t.internal.write(\"<< /Dests \"+f+\" 0 R\"),t.internal.write(\">>\",\"endobj\")}}]),t.events.push([\"putCatalog\",function(){this.outline.root.children.length>0&&(this.internal.write(\"/Outlines\",this.outline.makeRef(this.outline.root)),this.outline.createNamedDestinations&&this.internal.write(\"/Names \"+e+\" 0 R\"))}]),t.events.push([\"initialized\",function(){var t=this;t.outline={createNamedDestinations:!1,root:{children:[]}},t.outline.add=function(t,e,r){var n={title:e,options:r,children:[]};return null==t&&(t=this.root),t.children.push(n),n},t.outline.render=function(){return this.ctx={},this.ctx.val=\"\",this.ctx.pdf=t,this.genIds_r(this.root),this.renderRoot(this.root),this.renderItems(this.root),this.ctx.val},t.outline.genIds_r=function(e){e.id=t.internal.newObjectDeferred();for(var r=0;r<e.children.length;r++)this.genIds_r(e.children[r])},t.outline.renderRoot=function(t){this.objStart(t),this.line(\"/Type /Outlines\"),t.children.length>0&&(this.line(\"/First \"+this.makeRef(t.children[0])),this.line(\"/Last \"+this.makeRef(t.children[t.children.length-1]))),this.line(\"/Count \"+this.count_r({count:0},t)),this.objEnd()},t.outline.renderItems=function(e){for(var r=this.ctx.pdf.internal.getVerticalCoordinateString,n=0;n<e.children.length;n++){var i=e.children[n];this.objStart(i),this.line(\"/Title \"+this.makeString(i.title)),this.line(\"/Parent \"+this.makeRef(e)),n>0&&this.line(\"/Prev \"+this.makeRef(e.children[n-1])),n<e.children.length-1&&this.line(\"/Next \"+this.makeRef(e.children[n+1])),i.children.length>0&&(this.line(\"/First \"+this.makeRef(i.children[0])),this.line(\"/Last \"+this.makeRef(i.children[i.children.length-1])));var a=this.count=this.count_r({count:0},i);if(a>0&&this.line(\"/Count \"+a),i.options&&i.options.pageNumber){var o=t.internal.getPageInfo(i.options.pageNumber);this.line(\"/Dest [\"+o.objId+\" 0 R /XYZ 0 \"+r(0)+\" 0]\")}this.objEnd()}for(var s=0;s<e.children.length;s++)this.renderItems(e.children[s])},t.outline.line=function(t){this.ctx.val+=t+\"\\r\\n\"},t.outline.makeRef=function(t){return t.id+\" 0 R\"},t.outline.makeString=function(e){return\"(\"+t.internal.pdfEscape(e)+\")\"},t.outline.objStart=function(t){this.ctx.val+=\"\\r\\n\"+t.id+\" 0 obj\\r\\n<<\\r\\n\"},t.outline.objEnd=function(){this.ctx.val+=\">> \\r\\nendobj\\r\\n\"},t.outline.count_r=function(t,e){for(var r=0;r<e.children.length;r++)t.count++,this.count_r(t,e.children[r]);return t.count}}])}(M.API),\n/**\n   * @license\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e=[192,193,194,195,196,197,198,199];t.processJPEG=function(t,r,n,i,a,o){var s,c=this.decode.DCT_DECODE,u=null;if(\"string\"==typeof t||this.__addimage__.isArrayBuffer(t)||this.__addimage__.isArrayBufferView(t)){switch(t=a||t,t=this.__addimage__.isArrayBuffer(t)?new Uint8Array(t):t,(s=function(t){for(var r,n=256*t.charCodeAt(4)+t.charCodeAt(5),i=t.length,a={width:0,height:0,numcomponents:1},o=4;o<i;o+=2){if(o+=n,-1!==e.indexOf(t.charCodeAt(o+1))){r=256*t.charCodeAt(o+5)+t.charCodeAt(o+6),a={width:256*t.charCodeAt(o+7)+t.charCodeAt(o+8),height:r,numcomponents:t.charCodeAt(o+9)};break}n=256*t.charCodeAt(o+2)+t.charCodeAt(o+3)}return a}(t=this.__addimage__.isArrayBufferView(t)?this.__addimage__.arrayBufferToBinaryString(t):t)).numcomponents){case 1:o=this.color_spaces.DEVICE_GRAY;break;case 4:o=this.color_spaces.DEVICE_CMYK;break;case 3:o=this.color_spaces.DEVICE_RGB}u={data:t,width:s.width,height:s.height,colorSpace:o,bitsPerComponent:8,filter:c,index:r,alias:n}}return u}}(M.API);var Oe,Be,Me,Ee,qe,De=function(){var t,e,n;function i(t){var e,r,n,i,a,o,s,c,u,l,h,f,d,p;for(this.data=t,this.pos=8,this.palette=[],this.imgData=[],this.transparency={},this.animation=null,this.text={},o=null;;){switch(e=this.readUInt32(),u=function(){var t,e;for(e=[],t=0;t<4;++t)e.push(String.fromCharCode(this.data[this.pos++]));return e}.call(this).join(\"\")){case\"IHDR\":this.width=this.readUInt32(),this.height=this.readUInt32(),this.bits=this.data[this.pos++],this.colorType=this.data[this.pos++],this.compressionMethod=this.data[this.pos++],this.filterMethod=this.data[this.pos++],this.interlaceMethod=this.data[this.pos++];break;case\"acTL\":this.animation={numFrames:this.readUInt32(),numPlays:this.readUInt32()||1/0,frames:[]};break;case\"PLTE\":this.palette=this.read(e);break;case\"fcTL\":o&&this.animation.frames.push(o),this.pos+=4,o={width:this.readUInt32(),height:this.readUInt32(),xOffset:this.readUInt32(),yOffset:this.readUInt32()},a=this.readUInt16(),i=this.readUInt16()||100,o.delay=1e3*a/i,o.disposeOp=this.data[this.pos++],o.blendOp=this.data[this.pos++],o.data=[];break;case\"IDAT\":case\"fdAT\":for(\"fdAT\"===u&&(this.pos+=4,e-=4),t=(null!=o?o.data:void 0)||this.imgData,f=0;0<=e?f<e:f>e;0<=e?++f:--f)t.push(this.data[this.pos++]);break;case\"tRNS\":switch(this.transparency={},this.colorType){case 3:if(n=this.palette.length/3,this.transparency.indexed=this.read(e),this.transparency.indexed.length>n)throw new Error(\"More transparent colors than palette size\");if((l=n-this.transparency.indexed.length)>0)for(d=0;0<=l?d<l:d>l;0<=l?++d:--d)this.transparency.indexed.push(255);break;case 0:this.transparency.grayscale=this.read(e)[0];break;case 2:this.transparency.rgb=this.read(e)}break;case\"tEXt\":s=(h=this.read(e)).indexOf(0),c=String.fromCharCode.apply(String,h.slice(0,s)),this.text[c]=String.fromCharCode.apply(String,h.slice(s+1));break;case\"IEND\":return o&&this.animation.frames.push(o),this.colors=function(){switch(this.colorType){case 0:case 3:case 4:return 1;case 2:case 6:return 3}}.call(this),this.hasAlphaChannel=4===(p=this.colorType)||6===p,r=this.colors+(this.hasAlphaChannel?1:0),this.pixelBitlength=this.bits*r,this.colorSpace=function(){switch(this.colors){case 1:return\"DeviceGray\";case 3:return\"DeviceRGB\"}}.call(this),void(this.imgData=new Uint8Array(this.imgData));default:this.pos+=e}if(this.pos+=4,this.pos>this.data.length)throw new Error(\"Incomplete or corrupt PNG file\")}}i.prototype.read=function(t){var e,r;for(r=[],e=0;0<=t?e<t:e>t;0<=t?++e:--e)r.push(this.data[this.pos++]);return r},i.prototype.readUInt32=function(){return this.data[this.pos++]<<24|this.data[this.pos++]<<16|this.data[this.pos++]<<8|this.data[this.pos++]},i.prototype.readUInt16=function(){return this.data[this.pos++]<<8|this.data[this.pos++]},i.prototype.decodePixels=function(t){var e=this.pixelBitlength/8,r=new Uint8Array(this.width*this.height*e),n=0,i=this;if(null==t&&(t=this.imgData),0===t.length)return new Uint8Array(0);function a(a,o,s,c){var u,l,h,f,d,p,g,m,v,b,y,w,N,L,A,x,S,_,P,k,F,I=Math.ceil((i.width-a)/s),C=Math.ceil((i.height-o)/c),j=i.width==I&&i.height==C;for(L=e*I,w=j?r:new Uint8Array(L*C),p=t.length,N=0,l=0;N<C&&n<p;){switch(t[n++]){case 0:for(f=S=0;S<L;f=S+=1)w[l++]=t[n++];break;case 1:for(f=_=0;_<L;f=_+=1)u=t[n++],d=f<e?0:w[l-e],w[l++]=(u+d)%256;break;case 2:for(f=P=0;P<L;f=P+=1)u=t[n++],h=(f-f%e)/e,A=N&&w[(N-1)*L+h*e+f%e],w[l++]=(A+u)%256;break;case 3:for(f=k=0;k<L;f=k+=1)u=t[n++],h=(f-f%e)/e,d=f<e?0:w[l-e],A=N&&w[(N-1)*L+h*e+f%e],w[l++]=(u+Math.floor((d+A)/2))%256;break;case 4:for(f=F=0;F<L;f=F+=1)u=t[n++],h=(f-f%e)/e,d=f<e?0:w[l-e],0===N?A=x=0:(A=w[(N-1)*L+h*e+f%e],x=h&&w[(N-1)*L+(h-1)*e+f%e]),g=d+A-x,m=Math.abs(g-d),b=Math.abs(g-A),y=Math.abs(g-x),v=m<=b&&m<=y?d:b<=y?A:x,w[l++]=(u+v)%256;break;default:throw new Error(\"Invalid filter algorithm: \"+t[n-1])}if(!j){var O=((o+N*c)*i.width+a)*e,B=N*L;for(f=0;f<I;f+=1){for(var M=0;M<e;M+=1)r[O++]=w[B++];O+=(s-1)*e}}N++}}return t=Ce(t),1==i.interlaceMethod?(a(0,0,8,8),a(4,0,8,8),a(0,4,4,8),a(2,0,4,4),a(0,2,2,4),a(1,0,2,2),a(0,1,1,2)):a(0,0,1,1),r},i.prototype.decodePalette=function(){var t,e,r,n,i,a,o,s,c;for(r=this.palette,a=this.transparency.indexed||[],i=new Uint8Array((a.length||0)+r.length),n=0,t=0,e=o=0,s=r.length;o<s;e=o+=3)i[n++]=r[e],i[n++]=r[e+1],i[n++]=r[e+2],i[n++]=null!=(c=a[t++])?c:255;return i},i.prototype.copyToImageData=function(t,e){var r,n,i,a,o,s,c,u,l,h,f;if(n=this.colors,l=null,r=this.hasAlphaChannel,this.palette.length&&(l=null!=(f=this._decodedPalette)?f:this._decodedPalette=this.decodePalette(),n=4,r=!0),u=(i=t.data||t).length,o=l||e,a=s=0,1===n)for(;a<u;)c=l?4*e[a/4]:s,h=o[c++],i[a++]=h,i[a++]=h,i[a++]=h,i[a++]=r?o[c++]:255,s=c;else for(;a<u;)c=l?4*e[a/4]:s,i[a++]=o[c++],i[a++]=o[c++],i[a++]=o[c++],i[a++]=r?o[c++]:255,s=c},i.prototype.decode=function(){var t;return t=new Uint8Array(this.width*this.height*4),this.copyToImageData(t,this.decodePixels()),t};var a=function(){if(\"[object Window]\"===Object.prototype.toString.call(r)){try{e=r.document.createElement(\"canvas\"),n=e.getContext(\"2d\")}catch(t){return!1}return!0}return!1};return a(),t=function(t){var r;if(!0===a())return n.width=t.width,n.height=t.height,n.clearRect(0,0,t.width,t.height),n.putImageData(t,0,0),(r=new Image).src=e.toDataURL(),r;throw new Error(\"This method requires a Browser with Canvas-capability.\")},i.prototype.decodeFrames=function(e){var r,n,i,a,o,s,c,u;if(this.animation){for(u=[],n=o=0,s=(c=this.animation.frames).length;o<s;n=++o)r=c[n],i=e.createImageData(r.width,r.height),a=this.decodePixels(new Uint8Array(r.data)),this.copyToImageData(i,a),r.imageData=i,u.push(r.image=t(i));return u}},i.prototype.renderFrame=function(t,e){var r,n,i;return r=(n=this.animation.frames)[e],i=n[e-1],0===e&&t.clearRect(0,0,this.width,this.height),1===(null!=i?i.disposeOp:void 0)?t.clearRect(i.xOffset,i.yOffset,i.width,i.height):2===(null!=i?i.disposeOp:void 0)&&t.putImageData(i.imageData,i.xOffset,i.yOffset),0===r.blendOp&&t.clearRect(r.xOffset,r.yOffset,r.width,r.height),t.drawImage(r.image,r.xOffset,r.yOffset)},i.prototype.animate=function(t){var e,r,n,i,a,o,s=this;return r=0,o=this.animation,i=o.numFrames,n=o.frames,a=o.numPlays,(e=function(){var o,c;if(o=r++%i,c=n[o],s.renderFrame(t,o),i>1&&r/i<a)return s.animation._timeout=setTimeout(e,c.delay)})()},i.prototype.stopAnimation=function(){var t;return clearTimeout(null!=(t=this.animation)?t._timeout:void 0)},i.prototype.render=function(t){var e,r;return t._png&&t._png.stopAnimation(),t._png=this,t.width=this.width,t.height=this.height,e=t.getContext(\"2d\"),this.animation?(this.decodeFrames(e),this.animate(e)):(r=e.createImageData(this.width,this.height),this.copyToImageData(r,this.decodePixels()),e.putImageData(r,0,0))},i}();\n/**\n   * @license\n   *\n   * Copyright (c) 2014 James Robb, https://github.com/jamesbrobb\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining\n   * a copy of this software and associated documentation files (the\n   * \"Software\"), to deal in the Software without restriction, including\n   * without limitation the rights to use, copy, modify, merge, publish,\n   * distribute, sublicense, and/or sell copies of the Software, and to\n   * permit persons to whom the Software is furnished to do so, subject to\n   * the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be\n   * included in all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n   * ====================================================================\n   */\n/**\n   * @license\n   * (c) Dean McNamee <dean@gmail.com>, 2013.\n   *\n   * https://github.com/deanm/omggif\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining a copy\n   * of this software and associated documentation files (the \"Software\"), to\n   * deal in the Software without restriction, including without limitation the\n   * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or\n   * sell copies of the Software, and to permit persons to whom the Software is\n   * furnished to do so, subject to the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be included in\n   * all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n   * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS\n   * IN THE SOFTWARE.\n   *\n   * omggif is a JavaScript implementation of a GIF 89a encoder and decoder,\n   * including animation and compression.  It does not rely on any specific\n   * underlying system, so should run in the browser, Node, or Plask.\n   */\nfunction Re(t){var e=0;if(71!==t[e++]||73!==t[e++]||70!==t[e++]||56!==t[e++]||56!=(t[e++]+1&253)||97!==t[e++])throw new Error(\"Invalid GIF 87a/89a header.\");var r=t[e++]|t[e++]<<8,n=t[e++]|t[e++]<<8,i=t[e++],a=i>>7,o=1<<(7&i)+1;t[e++],t[e++];var s=null,c=null;a&&(s=e,c=o,e+=3*o);var u=!0,l=[],h=0,f=null,d=0,p=null;for(this.width=r,this.height=n;u&&e<t.length;)switch(t[e++]){case 33:switch(t[e++]){case 255:if(11!==t[e]||78==t[e+1]&&69==t[e+2]&&84==t[e+3]&&83==t[e+4]&&67==t[e+5]&&65==t[e+6]&&80==t[e+7]&&69==t[e+8]&&50==t[e+9]&&46==t[e+10]&&48==t[e+11]&&3==t[e+12]&&1==t[e+13]&&0==t[e+16])e+=14,p=t[e++]|t[e++]<<8,e++;else for(e+=12;;){if(!((P=t[e++])>=0))throw Error(\"Invalid block size\");if(0===P)break;e+=P}break;case 249:if(4!==t[e++]||0!==t[e+4])throw new Error(\"Invalid graphics extension block.\");var g=t[e++];h=t[e++]|t[e++]<<8,f=t[e++],0==(1&g)&&(f=null),d=g>>2&7,e++;break;case 254:for(;;){if(!((P=t[e++])>=0))throw Error(\"Invalid block size\");if(0===P)break;e+=P}break;default:throw new Error(\"Unknown graphic control label: 0x\"+t[e-1].toString(16))}break;case 44:var m=t[e++]|t[e++]<<8,v=t[e++]|t[e++]<<8,b=t[e++]|t[e++]<<8,y=t[e++]|t[e++]<<8,w=t[e++],N=w>>6&1,L=1<<(7&w)+1,A=s,x=c,S=!1;if(w>>7){S=!0;A=e,x=L,e+=3*L}var _=e;for(e++;;){var P;if(!((P=t[e++])>=0))throw Error(\"Invalid block size\");if(0===P)break;e+=P}l.push({x:m,y:v,width:b,height:y,has_local_palette:S,palette_offset:A,palette_size:x,data_offset:_,data_length:e-_,transparent_index:f,interlaced:!!N,delay:h,disposal:d});break;case 59:u=!1;break;default:throw new Error(\"Unknown gif block: 0x\"+t[e-1].toString(16))}this.numFrames=function(){return l.length},this.loopCount=function(){return p},this.frameInfo=function(t){if(t<0||t>=l.length)throw new Error(\"Frame index out of range.\");return l[t]},this.decodeAndBlitFrameBGRA=function(e,n){var i=this.frameInfo(e),a=i.width*i.height,o=new Uint8Array(a);Te(t,i.data_offset,o,a);var s=i.palette_offset,c=i.transparent_index;null===c&&(c=256);var u=i.width,l=r-u,h=u,f=4*(i.y*r+i.x),d=4*((i.y+i.height)*r+i.x),p=f,g=4*l;!0===i.interlaced&&(g+=4*r*7);for(var m=8,v=0,b=o.length;v<b;++v){var y=o[v];if(0===h&&(h=u,(p+=g)>=d&&(g=4*l+4*r*(m-1),p=f+(u+l)*(m<<1),m>>=1)),y===c)p+=4;else{var w=t[s+3*y],N=t[s+3*y+1],L=t[s+3*y+2];n[p++]=L,n[p++]=N,n[p++]=w,n[p++]=255}--h}},this.decodeAndBlitFrameRGBA=function(e,n){var i=this.frameInfo(e),a=i.width*i.height,o=new Uint8Array(a);Te(t,i.data_offset,o,a);var s=i.palette_offset,c=i.transparent_index;null===c&&(c=256);var u=i.width,l=r-u,h=u,f=4*(i.y*r+i.x),d=4*((i.y+i.height)*r+i.x),p=f,g=4*l;!0===i.interlaced&&(g+=4*r*7);for(var m=8,v=0,b=o.length;v<b;++v){var y=o[v];if(0===h&&(h=u,(p+=g)>=d&&(g=4*l+4*r*(m-1),p=f+(u+l)*(m<<1),m>>=1)),y===c)p+=4;else{var w=t[s+3*y],N=t[s+3*y+1],L=t[s+3*y+2];n[p++]=w,n[p++]=N,n[p++]=L,n[p++]=255}--h}}}function Te(t,e,r,n){for(var a=t[e++],o=1<<a,s=o+1,c=s+1,u=a+1,l=(1<<u)-1,h=0,f=0,d=0,p=t[e++],g=new Int32Array(4096),m=null;;){for(;h<16&&0!==p;)f|=t[e++]<<h,h+=8,1===p?p=t[e++]:--p;if(h<u)break;var v=f&l;if(f>>=u,h-=u,v!==o){if(v===s)break;for(var b=v<c?v:m,y=0,w=b;w>o;)w=g[w]>>8,++y;var N=w;if(d+y+(b!==v?1:0)>n)return void i.log(\"Warning, gif stream longer than expected.\");r[d++]=N;var L=d+=y;for(b!==v&&(r[d++]=N),w=b;y--;)w=g[w],r[--L]=255&w,w>>=8;null!==m&&c<4096&&(g[c++]=m<<8|N,c>=l+1&&u<12&&(++u,l=l<<1|1)),m=v}else c=s+1,l=(1<<(u=a+1))-1,m=null}return d!==n&&i.log(\"Warning, gif stream shorter than expected.\"),r}\n/**\n   * @license\n    Copyright (c) 2008, Adobe Systems Incorporated\n    All rights reserved.\n\n    Redistribution and use in source and binary forms, with or without \n    modification, are permitted provided that the following conditions are\n    met:\n\n    * Redistributions of source code must retain the above copyright notice, \n      this list of conditions and the following disclaimer.\n    \n    * Redistributions in binary form must reproduce the above copyright\n      notice, this list of conditions and the following disclaimer in the \n      documentation and/or other materials provided with the distribution.\n    \n    * Neither the name of Adobe Systems Incorporated nor the names of its \n      contributors may be used to endorse or promote products derived from \n      this software without specific prior written permission.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS\n    IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,\n    THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR \n    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n    EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n    NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n  */function Ue(t){var e,r,n,i,a,o=Math.floor,s=new Array(64),c=new Array(64),u=new Array(64),l=new Array(64),h=new Array(65535),f=new Array(65535),d=new Array(64),p=new Array(64),g=[],m=0,v=7,b=new Array(64),y=new Array(64),w=new Array(64),N=new Array(256),L=new Array(2048),A=[0,1,5,6,14,15,27,28,2,4,7,13,16,26,29,42,3,8,12,17,25,30,41,43,9,11,18,24,31,40,44,53,10,19,23,32,39,45,52,54,20,22,33,38,46,51,55,60,21,34,37,47,50,56,59,61,35,36,48,49,57,58,62,63],x=[0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0],S=[0,1,2,3,4,5,6,7,8,9,10,11],_=[0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125],P=[1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250],k=[0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0],F=[0,1,2,3,4,5,6,7,8,9,10,11],I=[0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119],C=[0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250];function j(t,e){for(var r=0,n=0,i=new Array,a=1;a<=16;a++){for(var o=1;o<=t[a];o++)i[e[n]]=[],i[e[n]][0]=r,i[e[n]][1]=a,n++,r++;r*=2}return i}function O(t){for(var e=t[0],r=t[1]-1;r>=0;)e&1<<r&&(m|=1<<v),r--,--v<0&&(255==m?(B(255),B(0)):B(m),v=7,m=0)}function B(t){g.push(t)}function M(t){B(t>>8&255),B(255&t)}function E(t,e,r,n,i){for(var a,o=i[0],s=i[240],c=function(t,e){var r,n,i,a,o,s,c,u,l,h,f=0;for(l=0;l<8;++l){r=t[f],n=t[f+1],i=t[f+2],a=t[f+3],o=t[f+4],s=t[f+5],c=t[f+6];var p=r+(u=t[f+7]),g=r-u,m=n+c,v=n-c,b=i+s,y=i-s,w=a+o,N=a-o,L=p+w,A=p-w,x=m+b,S=m-b;t[f]=L+x,t[f+4]=L-x;var _=.707106781*(S+A);t[f+2]=A+_,t[f+6]=A-_;var P=.382683433*((L=N+y)-(S=v+g)),k=.5411961*L+P,F=1.306562965*S+P,I=.707106781*(x=y+v),C=g+I,j=g-I;t[f+5]=j+k,t[f+3]=j-k,t[f+1]=C+F,t[f+7]=C-F,f+=8}for(f=0,l=0;l<8;++l){r=t[f],n=t[f+8],i=t[f+16],a=t[f+24],o=t[f+32],s=t[f+40],c=t[f+48];var O=r+(u=t[f+56]),B=r-u,M=n+c,E=n-c,q=i+s,D=i-s,R=a+o,T=a-o,U=O+R,z=O-R,H=M+q,W=M-q;t[f]=U+H,t[f+32]=U-H;var V=.707106781*(W+z);t[f+16]=z+V,t[f+48]=z-V;var G=.382683433*((U=T+D)-(W=E+B)),Y=.5411961*U+G,J=1.306562965*W+G,X=.707106781*(H=D+E),K=B+X,Z=B-X;t[f+40]=Z+Y,t[f+24]=Z-Y,t[f+8]=K+J,t[f+56]=K-J,f++}for(l=0;l<64;++l)h=t[l]*e[l],d[l]=h>0?h+.5|0:h-.5|0;return d}(t,e),u=0;u<64;++u)p[A[u]]=c[u];var l=p[0]-r;r=p[0],0==l?O(n[0]):(O(n[f[a=32767+l]]),O(h[a]));for(var g=63;g>0&&0==p[g];)g--;if(0==g)return O(o),r;for(var m,v=1;v<=g;){for(var b=v;0==p[v]&&v<=g;)++v;var y=v-b;if(y>=16){m=y>>4;for(var w=1;w<=m;++w)O(s);y&=15}a=32767+p[v],O(i[(y<<4)+f[a]]),O(h[a]),v++}return 63!=g&&O(o),r}function q(t){(t=Math.min(Math.max(t,1),100),a!=t)&&(!function(t){for(var e=[16,11,10,16,24,40,51,61,12,12,14,19,26,58,60,55,14,13,16,24,40,57,69,56,14,17,22,29,51,87,80,62,18,22,37,56,68,109,103,77,24,35,55,64,81,104,113,92,49,64,78,87,103,121,120,101,72,92,95,98,112,100,103,99],r=0;r<64;r++){var n=o((e[r]*t+50)/100);n=Math.min(Math.max(n,1),255),s[A[r]]=n}for(var i=[17,18,24,47,99,99,99,99,18,21,26,66,99,99,99,99,24,26,56,99,99,99,99,99,47,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99],a=0;a<64;a++){var h=o((i[a]*t+50)/100);h=Math.min(Math.max(h,1),255),c[A[a]]=h}for(var f=[1,1.387039845,1.306562965,1.175875602,1,.785694958,.5411961,.275899379],d=0,p=0;p<8;p++)for(var g=0;g<8;g++)u[d]=1/(s[A[d]]*f[p]*f[g]*8),l[d]=1/(c[A[d]]*f[p]*f[g]*8),d++}(t<50?Math.floor(5e3/t):Math.floor(200-2*t)),a=t)}this.encode=function(t,a){a&&q(a),g=new Array,m=0,v=7,M(65496),M(65504),M(16),B(74),B(70),B(73),B(70),B(0),B(1),B(1),B(0),M(1),M(1),B(0),B(0),function(){M(65499),M(132),B(0);for(var t=0;t<64;t++)B(s[t]);B(1);for(var e=0;e<64;e++)B(c[e])}(),function(t,e){M(65472),M(17),B(8),M(e),M(t),B(3),B(1),B(17),B(0),B(2),B(17),B(1),B(3),B(17),B(1)}(t.width,t.height),function(){M(65476),M(418),B(0);for(var t=0;t<16;t++)B(x[t+1]);for(var e=0;e<=11;e++)B(S[e]);B(16);for(var r=0;r<16;r++)B(_[r+1]);for(var n=0;n<=161;n++)B(P[n]);B(1);for(var i=0;i<16;i++)B(k[i+1]);for(var a=0;a<=11;a++)B(F[a]);B(17);for(var o=0;o<16;o++)B(I[o+1]);for(var s=0;s<=161;s++)B(C[s])}(),M(65498),M(12),B(3),B(1),B(0),B(2),B(17),B(3),B(17),B(0),B(63),B(0);var o=0,h=0,f=0;m=0,v=7,this.encode.displayName=\"_encode_\";for(var d,p,N,A,j,D,R,T,U,z=t.data,H=t.width,W=t.height,V=4*H,G=0;G<W;){for(d=0;d<V;){for(j=V*G+d,R=-1,T=0,U=0;U<64;U++)D=j+(T=U>>3)*V+(R=4*(7&U)),G+T>=W&&(D-=V*(G+1+T-W)),d+R>=V&&(D-=d+R-V+4),p=z[D++],N=z[D++],A=z[D++],b[U]=(L[p]+L[N+256>>0]+L[A+512>>0]>>16)-128,y[U]=(L[p+768>>0]+L[N+1024>>0]+L[A+1280>>0]>>16)-128,w[U]=(L[p+1280>>0]+L[N+1536>>0]+L[A+1792>>0]>>16)-128;o=E(b,u,o,e,n),h=E(y,l,h,r,i),f=E(w,l,f,r,i),d+=32}G+=8}if(v>=0){var Y=[];Y[1]=v+1,Y[0]=(1<<v+1)-1,O(Y)}return M(65497),new Uint8Array(g)},t=t||50,function(){for(var t=String.fromCharCode,e=0;e<256;e++)N[e]=t(e)}(),e=j(x,S),r=j(k,F),n=j(_,P),i=j(I,C),function(){for(var t=1,e=2,r=1;r<=15;r++){for(var n=t;n<e;n++)f[32767+n]=r,h[32767+n]=[],h[32767+n][1]=r,h[32767+n][0]=n;for(var i=-(e-1);i<=-t;i++)f[32767+i]=r,h[32767+i]=[],h[32767+i][1]=r,h[32767+i][0]=e-1+i;t<<=1,e<<=1}}(),function(){for(var t=0;t<256;t++)L[t]=19595*t,L[t+256>>0]=38470*t,L[t+512>>0]=7471*t+32768,L[t+768>>0]=-11059*t,L[t+1024>>0]=-21709*t,L[t+1280>>0]=32768*t+8421375,L[t+1536>>0]=-27439*t,L[t+1792>>0]=-5329*t}(),q(t)}\n/**\n   * @license\n   * Copyright (c) 2017 Aras Abbasi\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */function ze(t,e){if(this.pos=0,this.buffer=t,this.datav=new DataView(t.buffer),this.is_with_alpha=!!e,this.bottom_up=!0,this.flag=String.fromCharCode(this.buffer[0])+String.fromCharCode(this.buffer[1]),this.pos+=2,-1===[\"BM\",\"BA\",\"CI\",\"CP\",\"IC\",\"PT\"].indexOf(this.flag))throw new Error(\"Invalid BMP File\");this.parseHeader(),this.parseBGR()}function He(t){function e(t){if(!t)throw Error(\"assert :P\")}function r(t,e,r){for(var n=0;4>n;n++)if(t[e+n]!=r.charCodeAt(n))return!0;return!1}function n(t,e,r,n,i){for(var a=0;a<i;a++)t[e+a]=r[n+a]}function i(t,e,r,n){for(var i=0;i<n;i++)t[e+i]=r}function a(t){return new Int32Array(t)}function o(t,e){for(var r=[],n=0;n<t;n++)r.push(new e);return r}function s(t,e){var r=[];return function t(r,n,i){for(var a=i[n],o=0;o<a&&(r.push(i.length>n+1?[]:new e),!(i.length<n+1));o++)t(r[o],n+1,i)}(r,0,t),r}var c=function(){var t=this;function c(t,e){for(var r=1<<e-1>>>0;t&r;)r>>>=1;return r?(t&r-1)+r:t}function u(t,r,n,i,a){e(!(i%n));do{t[r+(i-=n)]=a}while(0<i)}function l(t,r,n,i,o){if(e(2328>=o),512>=o)var s=a(512);else if(null==(s=a(o)))return 0;return function(t,r,n,i,o,s){var l,f,d=r,p=1<<n,g=a(16),m=a(16);for(e(0!=o),e(null!=i),e(null!=t),e(0<n),f=0;f<o;++f){if(15<i[f])return 0;++g[i[f]]}if(g[0]==o)return 0;for(m[1]=0,l=1;15>l;++l){if(g[l]>1<<l)return 0;m[l+1]=m[l]+g[l]}for(f=0;f<o;++f)l=i[f],0<i[f]&&(s[m[l]++]=f);if(1==m[15])return(i=new h).g=0,i.value=s[0],u(t,d,1,p,i),p;var v,b=-1,y=p-1,w=0,N=1,L=1,A=1<<n;for(f=0,l=1,o=2;l<=n;++l,o<<=1){if(N+=L<<=1,0>(L-=g[l]))return 0;for(;0<g[l];--g[l])(i=new h).g=l,i.value=s[f++],u(t,d+w,o,A,i),w=c(w,l)}for(l=n+1,o=2;15>=l;++l,o<<=1){if(N+=L<<=1,0>(L-=g[l]))return 0;for(;0<g[l];--g[l]){if(i=new h,(w&y)!=b){for(d+=A,v=1<<(b=l)-n;15>b&&!(0>=(v-=g[b]));)++b,v<<=1;p+=A=1<<(v=b-n),t[r+(b=w&y)].g=v+n,t[r+b].value=d-r-b}i.g=l-n,i.value=s[f++],u(t,d+(w>>n),o,A,i),w=c(w,l)}}return N!=2*m[15]-1?0:p}(t,r,n,i,o,s)}function h(){this.value=this.g=0}function f(){this.value=this.g=0}function d(){this.G=o(5,h),this.H=a(5),this.jc=this.Qb=this.qb=this.nd=0,this.pd=o(Dr,f)}function p(t,r,n,i){e(null!=t),e(null!=r),e(2147483648>i),t.Ca=254,t.I=0,t.b=-8,t.Ka=0,t.oa=r,t.pa=n,t.Jd=r,t.Yc=n+i,t.Zc=4<=i?n+i-4+1:n,_(t)}function g(t,e){for(var r=0;0<e--;)r|=k(t,128)<<e;return r}function m(t,e){var r=g(t,e);return P(t)?-r:r}function v(t,r,n,i){var a,o=0;for(e(null!=t),e(null!=r),e(4294967288>i),t.Sb=i,t.Ra=0,t.u=0,t.h=0,4<i&&(i=4),a=0;a<i;++a)o+=r[n+a]<<8*a;t.Ra=o,t.bb=i,t.oa=r,t.pa=n}function b(t){for(;8<=t.u&&t.bb<t.Sb;)t.Ra>>>=8,t.Ra+=t.oa[t.pa+t.bb]<<Ur-8>>>0,++t.bb,t.u-=8;A(t)&&(t.h=1,t.u=0)}function y(t,r){if(e(0<=r),!t.h&&r<=Tr){var n=L(t)&Rr[r];return t.u+=r,b(t),n}return t.h=1,t.u=0}function w(){this.b=this.Ca=this.I=0,this.oa=[],this.pa=0,this.Jd=[],this.Yc=0,this.Zc=[],this.Ka=0}function N(){this.Ra=0,this.oa=[],this.h=this.u=this.bb=this.Sb=this.pa=0}function L(t){return t.Ra>>>(t.u&Ur-1)>>>0}function A(t){return e(t.bb<=t.Sb),t.h||t.bb==t.Sb&&t.u>Ur}function x(t,e){t.u=e,t.h=A(t)}function S(t){t.u>=zr&&(e(t.u>=zr),b(t))}function _(t){e(null!=t&&null!=t.oa),t.pa<t.Zc?(t.I=(t.oa[t.pa++]|t.I<<8)>>>0,t.b+=8):(e(null!=t&&null!=t.oa),t.pa<t.Yc?(t.b+=8,t.I=t.oa[t.pa++]|t.I<<8):t.Ka?t.b=0:(t.I<<=8,t.b+=8,t.Ka=1))}function P(t){return g(t,1)}function k(t,e){var r=t.Ca;0>t.b&&_(t);var n=t.b,i=r*e>>>8,a=(t.I>>>n>i)+0;for(a?(r-=i,t.I-=i+1<<n>>>0):r=i+1,n=r,i=0;256<=n;)i+=8,n>>=8;return n=7^i+Hr[n],t.b-=n,t.Ca=(r<<n)-1,a}function F(t,e,r){t[e+0]=r>>24&255,t[e+1]=r>>16&255,t[e+2]=r>>8&255,t[e+3]=r>>0&255}function I(t,e){return t[e+0]<<0|t[e+1]<<8}function C(t,e){return I(t,e)|t[e+2]<<16}function j(t,e){return I(t,e)|I(t,e+2)<<16}function O(t,r){var n=1<<r;return e(null!=t),e(0<r),t.X=a(n),null==t.X?0:(t.Mb=32-r,t.Xa=r,1)}function B(t,r){e(null!=t),e(null!=r),e(t.Xa==r.Xa),n(r.X,0,t.X,0,1<<r.Xa)}function M(){this.X=[],this.Xa=this.Mb=0}function E(t,r,n,i){e(null!=n),e(null!=i);var a=n[0],o=i[0];return 0==a&&(a=(t*o+r/2)/r),0==o&&(o=(r*a+t/2)/t),0>=a||0>=o?0:(n[0]=a,i[0]=o,1)}function q(t,e){return t+(1<<e)-1>>>e}function D(t,e){return((4278255360&t)+(4278255360&e)>>>0&4278255360)+((16711935&t)+(16711935&e)>>>0&16711935)>>>0}function R(e,r){t[r]=function(r,n,i,a,o,s,c){var u;for(u=0;u<o;++u){var l=t[e](s[c+u-1],i,a+u);s[c+u]=D(r[n+u],l)}}}function T(){this.ud=this.hd=this.jd=0}function U(t,e){return((4278124286&(t^e))>>>1)+(t&e)>>>0}function z(t){return 0<=t&&256>t?t:0>t?0:255<t?255:void 0}function H(t,e){return z(t+(t-e+.5>>1))}function W(t,e,r){return Math.abs(e-r)-Math.abs(t-r)}function V(t,e,r,n,i,a,o){for(n=a[o-1],r=0;r<i;++r)a[o+r]=n=D(t[e+r],n)}function G(t,e,r,n,i){var a;for(a=0;a<r;++a){var o=t[e+a],s=o>>8&255,c=16711935&(c=(c=16711935&o)+((s<<16)+s));n[i+a]=(4278255360&o)+c>>>0}}function Y(t,e){e.jd=t>>0&255,e.hd=t>>8&255,e.ud=t>>16&255}function J(t,e,r,n,i,a){var o;for(o=0;o<n;++o){var s=e[r+o],c=s>>>8,u=s,l=255&(l=(l=s>>>16)+((t.jd<<24>>24)*(c<<24>>24)>>>5));u=255&(u=(u=u+((t.hd<<24>>24)*(c<<24>>24)>>>5))+((t.ud<<24>>24)*(l<<24>>24)>>>5));i[a+o]=(4278255360&s)+(l<<16)+u}}function X(e,r,n,i,a){t[r]=function(t,e,r,n,o,s,c,u,l){for(n=c;n<u;++n)for(c=0;c<l;++c)o[s++]=a(r[i(t[e++])])},t[e]=function(e,r,o,s,c,u,l){var h=8>>e.b,f=e.Ea,d=e.K[0],p=e.w;if(8>h)for(e=(1<<e.b)-1,p=(1<<h)-1;r<o;++r){var g,m=0;for(g=0;g<f;++g)g&e||(m=i(s[c++])),u[l++]=a(d[m&p]),m>>=h}else t[\"VP8LMapColor\"+n](s,c,d,p,u,l,r,o,f)}}function K(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=a>>16&255,n[i++]=a>>8&255,n[i++]=a>>0&255}}function Z(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=a>>16&255,n[i++]=a>>8&255,n[i++]=a>>0&255,n[i++]=a>>24&255}}function $(t,e,r,n,i){for(r=e+r;e<r;){var a=(o=t[e++])>>16&240|o>>12&15,o=o>>0&240|o>>28&15;n[i++]=a,n[i++]=o}}function Q(t,e,r,n,i){for(r=e+r;e<r;){var a=(o=t[e++])>>16&248|o>>13&7,o=o>>5&224|o>>3&31;n[i++]=a,n[i++]=o}}function tt(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=a>>0&255,n[i++]=a>>8&255,n[i++]=a>>16&255}}function et(t,e,r,i,a,o){if(0==o)for(r=e+r;e<r;)F(i,((o=t[e++])[0]>>24|o[1]>>8&65280|o[2]<<8&16711680|o[3]<<24)>>>0),a+=32;else n(i,a,t,e,r)}function rt(e,r){t[r][0]=t[e+\"0\"],t[r][1]=t[e+\"1\"],t[r][2]=t[e+\"2\"],t[r][3]=t[e+\"3\"],t[r][4]=t[e+\"4\"],t[r][5]=t[e+\"5\"],t[r][6]=t[e+\"6\"],t[r][7]=t[e+\"7\"],t[r][8]=t[e+\"8\"],t[r][9]=t[e+\"9\"],t[r][10]=t[e+\"10\"],t[r][11]=t[e+\"11\"],t[r][12]=t[e+\"12\"],t[r][13]=t[e+\"13\"],t[r][14]=t[e+\"0\"],t[r][15]=t[e+\"0\"]}function nt(t){return t==Hn||t==Wn||t==Vn||t==Gn}function it(){this.eb=[],this.size=this.A=this.fb=0}function at(){this.y=[],this.f=[],this.ea=[],this.F=[],this.Tc=this.Ed=this.Cd=this.Fd=this.lb=this.Db=this.Ab=this.fa=this.J=this.W=this.N=this.O=0}function ot(){this.Rd=this.height=this.width=this.S=0,this.f={},this.f.RGBA=new it,this.f.kb=new at,this.sd=null}function st(){this.width=[0],this.height=[0],this.Pd=[0],this.Qd=[0],this.format=[0]}function ct(){this.Id=this.fd=this.Md=this.hb=this.ib=this.da=this.bd=this.cd=this.j=this.v=this.Da=this.Sd=this.ob=0}function ut(t){return alert(\"todo:WebPSamplerProcessPlane\"),t.T}function lt(t,e){var r=t.T,i=e.ba.f.RGBA,a=i.eb,o=i.fb+t.ka*i.A,s=vi[e.ba.S],c=t.y,u=t.O,l=t.f,h=t.N,f=t.ea,d=t.W,p=e.cc,g=e.dc,m=e.Mc,v=e.Nc,b=t.ka,y=t.ka+t.T,w=t.U,N=w+1>>1;for(0==b?s(c,u,null,null,l,h,f,d,l,h,f,d,a,o,null,null,w):(s(e.ec,e.fc,c,u,p,g,m,v,l,h,f,d,a,o-i.A,a,o,w),++r);b+2<y;b+=2)p=l,g=h,m=f,v=d,h+=t.Rc,d+=t.Rc,o+=2*i.A,s(c,(u+=2*t.fa)-t.fa,c,u,p,g,m,v,l,h,f,d,a,o-i.A,a,o,w);return u+=t.fa,t.j+y<t.o?(n(e.ec,e.fc,c,u,w),n(e.cc,e.dc,l,h,N),n(e.Mc,e.Nc,f,d,N),r--):1&y||s(c,u,null,null,l,h,f,d,l,h,f,d,a,o+i.A,null,null,w),r}function ht(t,r,n){var i=t.F,a=[t.J];if(null!=i){var o=t.U,s=r.ba.S,c=s==Tn||s==Vn;r=r.ba.f.RGBA;var u=[0],l=t.ka;u[0]=t.T,t.Kb&&(0==l?--u[0]:(--l,a[0]-=t.width),t.j+t.ka+t.T==t.o&&(u[0]=t.o-t.j-l));var h=r.eb;l=r.fb+l*r.A;t=Sn(i,a[0],t.width,o,u,h,l+(c?0:3),r.A),e(n==u),t&&nt(s)&&An(h,l,c,o,u,r.A)}return 0}function ft(t){var e=t.ma,r=e.ba.S,n=11>r,i=r==qn||r==Rn||r==Tn||r==Un||12==r||nt(r);if(e.memory=null,e.Ib=null,e.Jb=null,e.Nd=null,!Mr(e.Oa,t,i?11:12))return 0;if(i&&nt(r)&&br(),t.da)alert(\"todo:use_scaling\");else{if(n){if(e.Ib=ut,t.Kb){if(r=t.U+1>>1,e.memory=a(t.U+2*r),null==e.memory)return 0;e.ec=e.memory,e.fc=0,e.cc=e.ec,e.dc=e.fc+t.U,e.Mc=e.cc,e.Nc=e.dc+r,e.Ib=lt,br()}}else alert(\"todo:EmitYUV\");i&&(e.Jb=ht,n&&mr())}if(n&&!Ci){for(t=0;256>t;++t)ji[t]=89858*(t-128)+_i>>Si,Mi[t]=-22014*(t-128)+_i,Bi[t]=-45773*(t-128),Oi[t]=113618*(t-128)+_i>>Si;for(t=Pi;t<ki;++t)e=76283*(t-16)+_i>>Si,Ei[t-Pi]=Vt(e,255),qi[t-Pi]=Vt(e+8>>4,15);Ci=1}return 1}function dt(t){var r=t.ma,n=t.U,i=t.T;return e(!(1&t.ka)),0>=n||0>=i?0:(n=r.Ib(t,r),null!=r.Jb&&r.Jb(t,r,n),r.Dc+=n,1)}function pt(t){t.ma.memory=null}function gt(t,e,r,n){return 47!=y(t,8)?0:(e[0]=y(t,14)+1,r[0]=y(t,14)+1,n[0]=y(t,1),0!=y(t,3)?0:!t.h)}function mt(t,e){if(4>t)return t+1;var r=t-2>>1;return(2+(1&t)<<r)+y(e,r)+1}function vt(t,e){return 120<e?e-120:1<=(r=((r=$n[e-1])>>4)*t+(8-(15&r)))?r:1;var r}function bt(t,e,r){var n=L(r),i=t[e+=255&n].g-8;return 0<i&&(x(r,r.u+8),n=L(r),e+=t[e].value,e+=n&(1<<i)-1),x(r,r.u+t[e].g),t[e].value}function yt(t,r,n){return n.g+=t.g,n.value+=t.value<<r>>>0,e(8>=n.g),t.g}function wt(t,r,n){var i=t.xc;return e((r=0==i?0:t.vc[t.md*(n>>i)+(r>>i)])<t.Wb),t.Ya[r]}function Nt(t,r,i,a){var o=t.ab,s=t.c*r,c=t.C;r=c+r;var u=i,l=a;for(a=t.Ta,i=t.Ua;0<o--;){var h=t.gc[o],f=c,d=r,p=u,g=l,m=(l=a,u=i,h.Ea);switch(e(f<d),e(d<=h.nc),h.hc){case 2:Gr(p,g,(d-f)*m,l,u);break;case 0:var v=f,b=d,y=l,w=u,N=(_=h).Ea;0==v&&(Wr(p,g,null,null,1,y,w),V(p,g+1,0,0,N-1,y,w+1),g+=N,w+=N,++v);for(var L=1<<_.b,A=L-1,x=q(N,_.b),S=_.K,_=_.w+(v>>_.b)*x;v<b;){var P=S,k=_,F=1;for(Vr(p,g,y,w-N,1,y,w);F<N;){var I=(F&~A)+L;I>N&&(I=N),(0,Zr[P[k++]>>8&15])(p,g+ +F,y,w+F-N,I-F,y,w+F),F=I}g+=N,w+=N,++v&A||(_+=x)}d!=h.nc&&n(l,u-m,l,u+(d-f-1)*m,m);break;case 1:for(m=p,b=g,N=(p=h.Ea)-(w=p&~(y=(g=1<<h.b)-1)),v=q(p,h.b),L=h.K,h=h.w+(f>>h.b)*v;f<d;){for(A=L,x=h,S=new T,_=b+w,P=b+p;b<_;)Y(A[x++],S),$r(S,m,b,g,l,u),b+=g,u+=g;b<P&&(Y(A[x++],S),$r(S,m,b,N,l,u),b+=N,u+=N),++f&y||(h+=v)}break;case 3:if(p==l&&g==u&&0<h.b){for(b=l,p=m=u+(d-f)*m-(w=(d-f)*q(h.Ea,h.b)),g=l,y=u,v=[],w=(N=w)-1;0<=w;--w)v[w]=g[y+w];for(w=N-1;0<=w;--w)b[p+w]=v[w];Yr(h,f,d,l,m,l,u)}else Yr(h,f,d,p,g,l,u)}u=a,l=i}l!=i&&n(a,i,u,l,s)}function Lt(t,r){var n=t.V,i=t.Ba+t.c*t.C,a=r-t.C;if(e(r<=t.l.o),e(16>=a),0<a){var o=t.l,s=t.Ta,c=t.Ua,u=o.width;if(Nt(t,a,n,i),a=c=[c],e((n=t.C)<(i=r)),e(o.v<o.va),i>o.o&&(i=o.o),n<o.j){var l=o.j-n;n=o.j;a[0]+=l*u}if(n>=i?n=0:(a[0]+=4*o.v,o.ka=n-o.j,o.U=o.va-o.v,o.T=i-n,n=1),n){if(c=c[0],11>(n=t.ca).S){var h=n.f.RGBA,f=(i=n.S,a=o.U,o=o.T,l=h.eb,h.A),d=o;for(h=h.fb+t.Ma*h.A;0<d--;){var p=s,g=c,m=a,v=l,b=h;switch(i){case En:Qr(p,g,m,v,b);break;case qn:tn(p,g,m,v,b);break;case Hn:tn(p,g,m,v,b),An(v,b,0,m,1,0);break;case Dn:nn(p,g,m,v,b);break;case Rn:et(p,g,m,v,b,1);break;case Wn:et(p,g,m,v,b,1),An(v,b,0,m,1,0);break;case Tn:et(p,g,m,v,b,0);break;case Vn:et(p,g,m,v,b,0),An(v,b,1,m,1,0);break;case Un:en(p,g,m,v,b);break;case Gn:en(p,g,m,v,b),xn(v,b,m,1,0);break;case zn:rn(p,g,m,v,b);break;default:e(0)}c+=u,h+=f}t.Ma+=o}else alert(\"todo:EmitRescaledRowsYUVA\");e(t.Ma<=n.height)}}t.C=r,e(t.C<=t.i)}function At(t){var e;if(0<t.ua)return 0;for(e=0;e<t.Wb;++e){var r=t.Ya[e].G,n=t.Ya[e].H;if(0<r[1][n[1]+0].g||0<r[2][n[2]+0].g||0<r[3][n[3]+0].g)return 0}return 1}function xt(t,r,n,i,a,o){if(0!=t.Z){var s=t.qd,c=t.rd;for(e(null!=mi[t.Z]);r<n;++r)mi[t.Z](s,c,i,a,i,a,o),s=i,c=a,a+=o;t.qd=s,t.rd=c}}function St(t,r){var n=t.l.ma,i=0==n.Z||1==n.Z?t.l.j:t.C;i=t.C<i?i:t.C;if(e(r<=t.l.o),r>i){var a=t.l.width,o=n.ca,s=n.tb+a*i,c=t.V,u=t.Ba+t.c*i,l=t.gc;e(1==t.ab),e(3==l[0].hc),Xr(l[0],i,r,c,u,o,s),xt(n,i,r,o,s,a)}t.C=t.Ma=r}function _t(t,r,n,i,a,o,s){var c=t.$/i,u=t.$%i,l=t.m,h=t.s,f=n+t.$,d=f;a=n+i*a;var p=n+i*o,g=280+h.ua,m=t.Pb?c:16777216,v=0<h.ua?h.Wa:null,b=h.wc,y=f<p?wt(h,u,c):null;e(t.C<o),e(p<=a);var w=!1;t:for(;;){for(;w||f<p;){var N=0;if(c>=m){var _=f-n;e((m=t).Pb),m.wd=m.m,m.xd=_,0<m.s.ua&&B(m.s.Wa,m.s.vb),m=c+ti}if(u&b||(y=wt(h,u,c)),e(null!=y),y.Qb&&(r[f]=y.qb,w=!0),!w)if(S(l),y.jc){N=l,_=r;var P=f,k=y.pd[L(N)&Dr-1];e(y.jc),256>k.g?(x(N,N.u+k.g),_[P]=k.value,N=0):(x(N,N.u+k.g-256),e(256<=k.value),N=k.value),0==N&&(w=!0)}else N=bt(y.G[0],y.H[0],l);if(l.h)break;if(w||256>N){if(!w)if(y.nd)r[f]=(y.qb|N<<8)>>>0;else{if(S(l),w=bt(y.G[1],y.H[1],l),S(l),_=bt(y.G[2],y.H[2],l),P=bt(y.G[3],y.H[3],l),l.h)break;r[f]=(P<<24|w<<16|N<<8|_)>>>0}if(w=!1,++f,++u>=i&&(u=0,++c,null!=s&&c<=o&&!(c%16)&&s(t,c),null!=v))for(;d<f;)N=r[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N}else if(280>N){if(N=mt(N-256,l),_=bt(y.G[4],y.H[4],l),S(l),_=vt(i,_=mt(_,l)),l.h)break;if(f-n<_||a-f<N)break t;for(P=0;P<N;++P)r[f+P]=r[f+P-_];for(f+=N,u+=N;u>=i;)u-=i,++c,null!=s&&c<=o&&!(c%16)&&s(t,c);if(e(f<=a),u&b&&(y=wt(h,u,c)),null!=v)for(;d<f;)N=r[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N}else{if(!(N<g))break t;for(w=N-280,e(null!=v);d<f;)N=r[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N;N=f,e(!(w>>>(_=v).Xa)),r[N]=_.X[w],w=!0}w||e(l.h==A(l))}if(t.Pb&&l.h&&f<a)e(t.m.h),t.a=5,t.m=t.wd,t.$=t.xd,0<t.s.ua&&B(t.s.vb,t.s.Wa);else{if(l.h)break t;null!=s&&s(t,c>o?o:c),t.a=0,t.$=f-n}return 1}return t.a=3,0}function Pt(t){e(null!=t),t.vc=null,t.yc=null,t.Ya=null;var r=t.Wa;null!=r&&(r.X=null),t.vb=null,e(null!=t)}function kt(){var e=new or;return null==e?null:(e.a=0,e.xb=gi,rt(\"Predictor\",\"VP8LPredictors\"),rt(\"Predictor\",\"VP8LPredictors_C\"),rt(\"PredictorAdd\",\"VP8LPredictorsAdd\"),rt(\"PredictorAdd\",\"VP8LPredictorsAdd_C\"),Gr=G,$r=J,Qr=K,tn=Z,en=$,rn=Q,nn=tt,t.VP8LMapColor32b=Jr,t.VP8LMapColor8b=Kr,e)}function Ft(t,r,n,s,c){var u=1,f=[t],p=[r],g=s.m,m=s.s,v=null,b=0;t:for(;;){if(n)for(;u&&y(g,1);){var w=f,N=p,A=s,_=1,P=A.m,k=A.gc[A.ab],F=y(P,2);if(A.Oc&1<<F)u=0;else{switch(A.Oc|=1<<F,k.hc=F,k.Ea=w[0],k.nc=N[0],k.K=[null],++A.ab,e(4>=A.ab),F){case 0:case 1:k.b=y(P,3)+2,_=Ft(q(k.Ea,k.b),q(k.nc,k.b),0,A,k.K),k.K=k.K[0];break;case 3:var I,C=y(P,8)+1,j=16<C?0:4<C?1:2<C?2:3;if(w[0]=q(k.Ea,j),k.b=j,I=_=Ft(C,1,0,A,k.K)){var B,M=C,E=k,R=1<<(8>>E.b),T=a(R);if(null==T)I=0;else{var U=E.K[0],z=E.w;for(T[0]=E.K[0][0],B=1;B<1*M;++B)T[B]=D(U[z+B],T[B-1]);for(;B<4*R;++B)T[B]=0;E.K[0]=null,E.K[0]=T,I=1}}_=I;break;case 2:break;default:e(0)}u=_}}if(f=f[0],p=p[0],u&&y(g,1)&&!(u=1<=(b=y(g,4))&&11>=b)){s.a=3;break t}var H;if(H=u)e:{var W,V,G,Y=s,J=f,X=p,K=b,Z=n,$=Y.m,Q=Y.s,tt=[null],et=1,rt=0,nt=Qn[K];r:for(;;){if(Z&&y($,1)){var it=y($,3)+2,at=q(J,it),ot=q(X,it),st=at*ot;if(!Ft(at,ot,0,Y,tt))break r;for(tt=tt[0],Q.xc=it,W=0;W<st;++W){var ct=tt[W]>>8&65535;tt[W]=ct,ct>=et&&(et=ct+1)}}if($.h)break r;for(V=0;5>V;++V){var ut=Xn[V];!V&&0<K&&(ut+=1<<K),rt<ut&&(rt=ut)}var lt=o(et*nt,h),ht=et,ft=o(ht,d);if(null==ft)var dt=null;else e(65536>=ht),dt=ft;var pt=a(rt);if(null==dt||null==pt||null==lt){Y.a=1;break r}var gt=lt;for(W=G=0;W<et;++W){var mt=dt[W],vt=mt.G,bt=mt.H,wt=0,Nt=1,Lt=0;for(V=0;5>V;++V){ut=Xn[V],vt[V]=gt,bt[V]=G,!V&&0<K&&(ut+=1<<K);n:{var At,xt=ut,St=Y,kt=pt,It=gt,Ct=G,jt=0,Ot=St.m,Bt=y(Ot,1);if(i(kt,0,0,xt),Bt){var Mt=y(Ot,1)+1,Et=y(Ot,1),qt=y(Ot,0==Et?1:8);kt[qt]=1,2==Mt&&(kt[qt=y(Ot,8)]=1);var Dt=1}else{var Rt=a(19),Tt=y(Ot,4)+4;if(19<Tt){St.a=3;var Ut=0;break n}for(At=0;At<Tt;++At)Rt[Zn[At]]=y(Ot,3);var zt=void 0,Ht=void 0,Wt=St,Vt=Rt,Gt=xt,Yt=kt,Jt=0,Xt=Wt.m,Kt=8,Zt=o(128,h);i:for(;l(Zt,0,7,Vt,19);){if(y(Xt,1)){var $t=2+2*y(Xt,3);if((zt=2+y(Xt,$t))>Gt)break i}else zt=Gt;for(Ht=0;Ht<Gt&&zt--;){S(Xt);var Qt=Zt[0+(127&L(Xt))];x(Xt,Xt.u+Qt.g);var te=Qt.value;if(16>te)Yt[Ht++]=te,0!=te&&(Kt=te);else{var ee=16==te,re=te-16,ne=Jn[re],ie=y(Xt,Yn[re])+ne;if(Ht+ie>Gt)break i;for(var ae=ee?Kt:0;0<ie--;)Yt[Ht++]=ae}}Jt=1;break i}Jt||(Wt.a=3),Dt=Jt}(Dt=Dt&&!Ot.h)&&(jt=l(It,Ct,8,kt,xt)),Dt&&0!=jt?Ut=jt:(St.a=3,Ut=0)}if(0==Ut)break r;if(Nt&&1==Kn[V]&&(Nt=0==gt[G].g),wt+=gt[G].g,G+=Ut,3>=V){var oe,se=pt[0];for(oe=1;oe<ut;++oe)pt[oe]>se&&(se=pt[oe]);Lt+=se}}if(mt.nd=Nt,mt.Qb=0,Nt&&(mt.qb=(vt[3][bt[3]+0].value<<24|vt[1][bt[1]+0].value<<16|vt[2][bt[2]+0].value)>>>0,0==wt&&256>vt[0][bt[0]+0].value&&(mt.Qb=1,mt.qb+=vt[0][bt[0]+0].value<<8)),mt.jc=!mt.Qb&&6>Lt,mt.jc){var ce,ue=mt;for(ce=0;ce<Dr;++ce){var le=ce,he=ue.pd[le],fe=ue.G[0][ue.H[0]+le];256<=fe.value?(he.g=fe.g+256,he.value=fe.value):(he.g=0,he.value=0,le>>=yt(fe,8,he),le>>=yt(ue.G[1][ue.H[1]+le],16,he),le>>=yt(ue.G[2][ue.H[2]+le],0,he),yt(ue.G[3][ue.H[3]+le],24,he))}}}Q.vc=tt,Q.Wb=et,Q.Ya=dt,Q.yc=lt,H=1;break e}H=0}if(!(u=H)){s.a=3;break t}if(0<b){if(m.ua=1<<b,!O(m.Wa,b)){s.a=1,u=0;break t}}else m.ua=0;var de=s,pe=f,ge=p,me=de.s,ve=me.xc;if(de.c=pe,de.i=ge,me.md=q(pe,ve),me.wc=0==ve?-1:(1<<ve)-1,n){s.xb=pi;break t}if(null==(v=a(f*p))){s.a=1,u=0;break t}u=(u=_t(s,v,0,f,p,p,null))&&!g.h;break t}return u?(null!=c?c[0]=v:(e(null==v),e(n)),s.$=0,n||Pt(m)):Pt(m),u}function It(t,r){var n=t.c*t.i,i=n+r+16*r;return e(t.c<=r),t.V=a(i),null==t.V?(t.Ta=null,t.Ua=0,t.a=1,0):(t.Ta=t.V,t.Ua=t.Ba+n+r,1)}function Ct(t,r){var n=t.C,i=r-n,a=t.V,o=t.Ba+t.c*n;for(e(r<=t.l.o);0<i;){var s=16<i?16:i,c=t.l.ma,u=t.l.width,l=u*s,h=c.ca,f=c.tb+u*n,d=t.Ta,p=t.Ua;Nt(t,s,a,o),_n(d,p,h,f,l),xt(c,n,n+s,h,f,u),i-=s,a+=s*t.c,n+=s}e(n==r),t.C=t.Ma=r}function jt(){this.ub=this.yd=this.td=this.Rb=0}function Ot(){this.Kd=this.Ld=this.Ud=this.Td=this.i=this.c=0}function Bt(){this.Fb=this.Bb=this.Cb=0,this.Zb=a(4),this.Lb=a(4)}function Mt(){this.Yb=function(){var t=[];return function t(e,r,n){for(var i=n[r],a=0;a<i&&(e.push(n.length>r+1?[]:0),!(n.length<r+1));a++)t(e[a],r+1,n)}(t,0,[3,11]),t}()}function Et(){this.jb=a(3),this.Wc=s([4,8],Mt),this.Xc=s([4,17],Mt)}function qt(){this.Pc=this.wb=this.Tb=this.zd=0,this.vd=new a(4),this.od=new a(4)}function Dt(){this.ld=this.La=this.dd=this.tc=0}function Rt(){this.Na=this.la=0}function Tt(){this.Sc=[0,0],this.Eb=[0,0],this.Qc=[0,0],this.ia=this.lc=0}function Ut(){this.ad=a(384),this.Za=0,this.Ob=a(16),this.$b=this.Ad=this.ia=this.Gc=this.Hc=this.Dd=0}function zt(){this.uc=this.M=this.Nb=0,this.wa=Array(new Dt),this.Y=0,this.ya=Array(new Ut),this.aa=0,this.l=new Gt}function Ht(){this.y=a(16),this.f=a(8),this.ea=a(8)}function Wt(){this.cb=this.a=0,this.sc=\"\",this.m=new w,this.Od=new jt,this.Kc=new Ot,this.ed=new qt,this.Qa=new Bt,this.Ic=this.$c=this.Aa=0,this.D=new zt,this.Xb=this.Va=this.Hb=this.zb=this.yb=this.Ub=this.za=0,this.Jc=o(8,w),this.ia=0,this.pb=o(4,Tt),this.Pa=new Et,this.Bd=this.kc=0,this.Ac=[],this.Bc=0,this.zc=[0,0,0,0],this.Gd=Array(new Ht),this.Hd=0,this.rb=Array(new Rt),this.sb=0,this.wa=Array(new Dt),this.Y=0,this.oc=[],this.pc=0,this.sa=[],this.ta=0,this.qa=[],this.ra=0,this.Ha=[],this.B=this.R=this.Ia=0,this.Ec=[],this.M=this.ja=this.Vb=this.Fc=0,this.ya=Array(new Ut),this.L=this.aa=0,this.gd=s([4,2],Dt),this.ga=null,this.Fa=[],this.Cc=this.qc=this.P=0,this.Gb=[],this.Uc=0,this.mb=[],this.nb=0,this.rc=[],this.Ga=this.Vc=0}function Vt(t,e){return 0>t?0:t>e?e:t}function Gt(){this.T=this.U=this.ka=this.height=this.width=0,this.y=[],this.f=[],this.ea=[],this.Rc=this.fa=this.W=this.N=this.O=0,this.ma=\"void\",this.put=\"VP8IoPutHook\",this.ac=\"VP8IoSetupHook\",this.bc=\"VP8IoTeardownHook\",this.ha=this.Kb=0,this.data=[],this.hb=this.ib=this.da=this.o=this.j=this.va=this.v=this.Da=this.ob=this.w=0,this.F=[],this.J=0}function Yt(){var t=new Wt;return null!=t&&(t.a=0,t.sc=\"OK\",t.cb=0,t.Xb=0,ni||(ni=Zt)),t}function Jt(t,e,r){return 0==t.a&&(t.a=e,t.sc=r,t.cb=0),0}function Xt(t,e,r){return 3<=r&&157==t[e+0]&&1==t[e+1]&&42==t[e+2]}function Kt(t,r){if(null==t)return 0;if(t.a=0,t.sc=\"OK\",null==r)return Jt(t,2,\"null VP8Io passed to VP8GetHeaders()\");var n=r.data,a=r.w,o=r.ha;if(4>o)return Jt(t,7,\"Truncated header.\");var s=n[a+0]|n[a+1]<<8|n[a+2]<<16,c=t.Od;if(c.Rb=!(1&s),c.td=s>>1&7,c.yd=s>>4&1,c.ub=s>>5,3<c.td)return Jt(t,3,\"Incorrect keyframe parameters.\");if(!c.yd)return Jt(t,4,\"Frame not displayable.\");a+=3,o-=3;var u=t.Kc;if(c.Rb){if(7>o)return Jt(t,7,\"cannot parse picture header\");if(!Xt(n,a,o))return Jt(t,3,\"Bad code word\");u.c=16383&(n[a+4]<<8|n[a+3]),u.Td=n[a+4]>>6,u.i=16383&(n[a+6]<<8|n[a+5]),u.Ud=n[a+6]>>6,a+=7,o-=7,t.za=u.c+15>>4,t.Ub=u.i+15>>4,r.width=u.c,r.height=u.i,r.Da=0,r.j=0,r.v=0,r.va=r.width,r.o=r.height,r.da=0,r.ib=r.width,r.hb=r.height,r.U=r.width,r.T=r.height,i((s=t.Pa).jb,0,255,s.jb.length),e(null!=(s=t.Qa)),s.Cb=0,s.Bb=0,s.Fb=1,i(s.Zb,0,0,s.Zb.length),i(s.Lb,0,0,s.Lb)}if(c.ub>o)return Jt(t,7,\"bad partition length\");p(s=t.m,n,a,c.ub),a+=c.ub,o-=c.ub,c.Rb&&(u.Ld=P(s),u.Kd=P(s)),u=t.Qa;var l,h=t.Pa;if(e(null!=s),e(null!=u),u.Cb=P(s),u.Cb){if(u.Bb=P(s),P(s)){for(u.Fb=P(s),l=0;4>l;++l)u.Zb[l]=P(s)?m(s,7):0;for(l=0;4>l;++l)u.Lb[l]=P(s)?m(s,6):0}if(u.Bb)for(l=0;3>l;++l)h.jb[l]=P(s)?g(s,8):255}else u.Bb=0;if(s.Ka)return Jt(t,3,\"cannot parse segment header\");if((u=t.ed).zd=P(s),u.Tb=g(s,6),u.wb=g(s,3),u.Pc=P(s),u.Pc&&P(s)){for(h=0;4>h;++h)P(s)&&(u.vd[h]=m(s,6));for(h=0;4>h;++h)P(s)&&(u.od[h]=m(s,6))}if(t.L=0==u.Tb?0:u.zd?1:2,s.Ka)return Jt(t,3,\"cannot parse filter header\");var f=o;if(o=l=a,a=l+f,u=f,t.Xb=(1<<g(t.m,2))-1,f<3*(h=t.Xb))n=7;else{for(l+=3*h,u-=3*h,f=0;f<h;++f){var d=n[o+0]|n[o+1]<<8|n[o+2]<<16;d>u&&(d=u),p(t.Jc[+f],n,l,d),l+=d,u-=d,o+=3}p(t.Jc[+h],n,l,u),n=l<a?0:5}if(0!=n)return Jt(t,n,\"cannot parse partitions\");for(n=g(l=t.m,7),o=P(l)?m(l,4):0,a=P(l)?m(l,4):0,u=P(l)?m(l,4):0,h=P(l)?m(l,4):0,l=P(l)?m(l,4):0,f=t.Qa,d=0;4>d;++d){if(f.Cb){var v=f.Zb[d];f.Fb||(v+=n)}else{if(0<d){t.pb[d]=t.pb[0];continue}v=n}var b=t.pb[d];b.Sc[0]=ei[Vt(v+o,127)],b.Sc[1]=ri[Vt(v+0,127)],b.Eb[0]=2*ei[Vt(v+a,127)],b.Eb[1]=101581*ri[Vt(v+u,127)]>>16,8>b.Eb[1]&&(b.Eb[1]=8),b.Qc[0]=ei[Vt(v+h,117)],b.Qc[1]=ri[Vt(v+l,127)],b.lc=v+l}if(!c.Rb)return Jt(t,4,\"Not a key frame.\");for(P(s),c=t.Pa,n=0;4>n;++n){for(o=0;8>o;++o)for(a=0;3>a;++a)for(u=0;11>u;++u)h=k(s,ui[n][o][a][u])?g(s,8):si[n][o][a][u],c.Wc[n][o].Yb[a][u]=h;for(o=0;17>o;++o)c.Xc[n][o]=c.Wc[n][li[o]]}return t.kc=P(s),t.kc&&(t.Bd=g(s,8)),t.cb=1}function Zt(t,e,r,n,i,a,o){var s=e[i].Yb[r];for(r=0;16>i;++i){if(!k(t,s[r+0]))return i;for(;!k(t,s[r+1]);)if(s=e[++i].Yb[0],r=0,16==i)return 16;var c=e[i+1].Yb;if(k(t,s[r+2])){var u=t,l=0;if(k(u,(f=s)[(h=r)+3]))if(k(u,f[h+6])){for(s=0,h=2*(l=k(u,f[h+8]))+(f=k(u,f[h+9+l])),l=0,f=ii[h];f[s];++s)l+=l+k(u,f[s]);l+=3+(8<<h)}else k(u,f[h+7])?(l=7+2*k(u,165),l+=k(u,145)):l=5+k(u,159);else l=k(u,f[h+4])?3+k(u,f[h+5]):2;s=c[2]}else l=1,s=c[1];c=o+ai[i],0>(u=t).b&&_(u);var h,f=u.b,d=(h=u.Ca>>1)-(u.I>>f)>>31;--u.b,u.Ca+=d,u.Ca|=1,u.I-=(h+1&d)<<f,a[c]=((l^d)-d)*n[(0<i)+0]}return 16}function $t(t){var e=t.rb[t.sb-1];e.la=0,e.Na=0,i(t.zc,0,0,t.zc.length),t.ja=0}function Qt(t,r){if(null==t)return 0;if(null==r)return Jt(t,2,\"NULL VP8Io parameter in VP8Decode().\");if(!t.cb&&!Kt(t,r))return 0;if(e(t.cb),null==r.ac||r.ac(r)){r.ob&&(t.L=0);var s=Ri[t.L];if(2==t.L?(t.yb=0,t.zb=0):(t.yb=r.v-s>>4,t.zb=r.j-s>>4,0>t.yb&&(t.yb=0),0>t.zb&&(t.zb=0)),t.Va=r.o+15+s>>4,t.Hb=r.va+15+s>>4,t.Hb>t.za&&(t.Hb=t.za),t.Va>t.Ub&&(t.Va=t.Ub),0<t.L){var c=t.ed;for(s=0;4>s;++s){var u;if(t.Qa.Cb){var l=t.Qa.Lb[s];t.Qa.Fb||(l+=c.Tb)}else l=c.Tb;for(u=0;1>=u;++u){var h=t.gd[s][u],f=l;if(c.Pc&&(f+=c.vd[0],u&&(f+=c.od[0])),0<(f=0>f?0:63<f?63:f)){var d=f;0<c.wb&&((d=4<c.wb?d>>2:d>>1)>9-c.wb&&(d=9-c.wb)),1>d&&(d=1),h.dd=d,h.tc=2*f+d,h.ld=40<=f?2:15<=f?1:0}else h.tc=0;h.La=u}}}s=0}else Jt(t,6,\"Frame setup failed\"),s=t.a;if(s=0==s){if(s){t.$c=0,0<t.Aa||(t.Ic=Ui);t:{s=t.Ic;c=4*(d=t.za);var p=32*d,g=d+1,m=0<t.L?d*(0<t.Aa?2:1):0,v=(2==t.Aa?2:1)*d;if((h=c+832+(u=3*(16*s+Ri[t.L])/2*p)+(l=null!=t.Fa&&0<t.Fa.length?t.Kc.c*t.Kc.i:0))!=h)s=0;else{if(h>t.Vb){if(t.Vb=0,t.Ec=a(h),t.Fc=0,null==t.Ec){s=Jt(t,1,\"no memory during frame initialization.\");break t}t.Vb=h}h=t.Ec,f=t.Fc,t.Ac=h,t.Bc=f,f+=c,t.Gd=o(p,Ht),t.Hd=0,t.rb=o(g+1,Rt),t.sb=1,t.wa=m?o(m,Dt):null,t.Y=0,t.D.Nb=0,t.D.wa=t.wa,t.D.Y=t.Y,0<t.Aa&&(t.D.Y+=d),e(!0),t.oc=h,t.pc=f,f+=832,t.ya=o(v,Ut),t.aa=0,t.D.ya=t.ya,t.D.aa=t.aa,2==t.Aa&&(t.D.aa+=d),t.R=16*d,t.B=8*d,d=(p=Ri[t.L])*t.R,p=p/2*t.B,t.sa=h,t.ta=f+d,t.qa=t.sa,t.ra=t.ta+16*s*t.R+p,t.Ha=t.qa,t.Ia=t.ra+8*s*t.B+p,t.$c=0,f+=u,t.mb=l?h:null,t.nb=l?f:null,e(f+l<=t.Fc+t.Vb),$t(t),i(t.Ac,t.Bc,0,c),s=1}}if(s){if(r.ka=0,r.y=t.sa,r.O=t.ta,r.f=t.qa,r.N=t.ra,r.ea=t.Ha,r.Vd=t.Ia,r.fa=t.R,r.Rc=t.B,r.F=null,r.J=0,!Cn){for(s=-255;255>=s;++s)Pn[255+s]=0>s?-s:s;for(s=-1020;1020>=s;++s)kn[1020+s]=-128>s?-128:127<s?127:s;for(s=-112;112>=s;++s)Fn[112+s]=-16>s?-16:15<s?15:s;for(s=-255;510>=s;++s)In[255+s]=0>s?0:255<s?255:s;Cn=1}an=ue,on=ae,cn=oe,un=se,ln=ce,sn=ie,hn=Je,fn=Xe,dn=$e,pn=Qe,gn=Ke,mn=Ze,vn=tr,bn=er,yn=ze,wn=He,Nn=We,Ln=Ve,fi[0]=xe,fi[1]=he,fi[2]=Le,fi[3]=Ae,fi[4]=Se,fi[5]=Pe,fi[6]=_e,fi[7]=ke,fi[8]=Ie,fi[9]=Fe,hi[0]=ve,hi[1]=de,hi[2]=pe,hi[3]=ge,hi[4]=be,hi[5]=ye,hi[6]=we,di[0]=Be,di[1]=fe,di[2]=Ce,di[3]=je,di[4]=Ee,di[5]=Me,di[6]=qe,s=1}else s=0}s&&(s=function(t,r){for(t.M=0;t.M<t.Va;++t.M){var o,s=t.Jc[t.M&t.Xb],c=t.m,u=t;for(o=0;o<u.za;++o){var l=c,h=u,f=h.Ac,d=h.Bc+4*o,p=h.zc,g=h.ya[h.aa+o];if(h.Qa.Bb?g.$b=k(l,h.Pa.jb[0])?2+k(l,h.Pa.jb[2]):k(l,h.Pa.jb[1]):g.$b=0,h.kc&&(g.Ad=k(l,h.Bd)),g.Za=!k(l,145)+0,g.Za){var m=g.Ob,v=0;for(h=0;4>h;++h){var b,y=p[0+h];for(b=0;4>b;++b){y=ci[f[d+b]][y];for(var w=oi[k(l,y[0])];0<w;)w=oi[2*w+k(l,y[w])];y=-w,f[d+b]=y}n(m,v,f,d,4),v+=4,p[0+h]=y}}else y=k(l,156)?k(l,128)?1:3:k(l,163)?2:0,g.Ob[0]=y,i(f,d,y,4),i(p,0,y,4);g.Dd=k(l,142)?k(l,114)?k(l,183)?1:3:2:0}if(u.m.Ka)return Jt(t,7,\"Premature end-of-partition0 encountered.\");for(;t.ja<t.za;++t.ja){if(u=s,l=(c=t).rb[c.sb-1],f=c.rb[c.sb+c.ja],o=c.ya[c.aa+c.ja],d=c.kc?o.Ad:0)l.la=f.la=0,o.Za||(l.Na=f.Na=0),o.Hc=0,o.Gc=0,o.ia=0;else{var N,L;l=f,f=u,d=c.Pa.Xc,p=c.ya[c.aa+c.ja],g=c.pb[p.$b];if(h=p.ad,m=0,v=c.rb[c.sb-1],y=b=0,i(h,m,0,384),p.Za)var A=0,x=d[3];else{w=a(16);var S=l.Na+v.Na;if(S=ni(f,d[1],S,g.Eb,0,w,0),l.Na=v.Na=(0<S)+0,1<S)an(w,0,h,m);else{var _=w[0]+3>>3;for(w=0;256>w;w+=16)h[m+w]=_}A=1,x=d[0]}var P=15&l.la,F=15&v.la;for(w=0;4>w;++w){var I=1&F;for(_=L=0;4>_;++_)P=P>>1|(I=(S=ni(f,x,S=I+(1&P),g.Sc,A,h,m))>A)<<7,L=L<<2|(3<S?3:1<S?2:0!=h[m+0]),m+=16;P>>=4,F=F>>1|I<<7,b=(b<<8|L)>>>0}for(x=P,A=F>>4,N=0;4>N;N+=2){for(L=0,P=l.la>>4+N,F=v.la>>4+N,w=0;2>w;++w){for(I=1&F,_=0;2>_;++_)S=I+(1&P),P=P>>1|(I=0<(S=ni(f,d[2],S,g.Qc,0,h,m)))<<3,L=L<<2|(3<S?3:1<S?2:0!=h[m+0]),m+=16;P>>=2,F=F>>1|I<<5}y|=L<<4*N,x|=P<<4<<N,A|=(240&F)<<N}l.la=x,v.la=A,p.Hc=b,p.Gc=y,p.ia=43690&y?0:g.ia,d=!(b|y)}if(0<c.L&&(c.wa[c.Y+c.ja]=c.gd[o.$b][o.Za],c.wa[c.Y+c.ja].La|=!d),u.Ka)return Jt(t,7,\"Premature end-of-file encountered.\")}if($t(t),c=r,u=1,o=(s=t).D,l=0<s.L&&s.M>=s.zb&&s.M<=s.Va,0==s.Aa)t:{if(o.M=s.M,o.uc=l,Or(s,o),u=1,o=(L=s.D).Nb,l=(y=Ri[s.L])*s.R,f=y/2*s.B,w=16*o*s.R,_=8*o*s.B,d=s.sa,p=s.ta-l+w,g=s.qa,h=s.ra-f+_,m=s.Ha,v=s.Ia-f+_,F=0==(P=L.M),b=P>=s.Va-1,2==s.Aa&&Or(s,L),L.uc)for(I=(S=s).D.M,e(S.D.uc),L=S.yb;L<S.Hb;++L){A=L,x=I;var C=(j=(U=S).D).Nb;N=U.R;var j=j.wa[j.Y+A],O=U.sa,B=U.ta+16*C*N+16*A,M=j.dd,E=j.tc;if(0!=E)if(e(3<=E),1==U.L)0<A&&wn(O,B,N,E+4),j.La&&Ln(O,B,N,E),0<x&&yn(O,B,N,E+4),j.La&&Nn(O,B,N,E);else{var q=U.B,D=U.qa,R=U.ra+8*C*q+8*A,T=U.Ha,U=U.Ia+8*C*q+8*A;C=j.ld;0<A&&(fn(O,B,N,E+4,M,C),pn(D,R,T,U,q,E+4,M,C)),j.La&&(mn(O,B,N,E,M,C),bn(D,R,T,U,q,E,M,C)),0<x&&(hn(O,B,N,E+4,M,C),dn(D,R,T,U,q,E+4,M,C)),j.La&&(gn(O,B,N,E,M,C),vn(D,R,T,U,q,E,M,C))}}if(s.ia&&alert(\"todo:DitherRow\"),null!=c.put){if(L=16*P,P=16*(P+1),F?(c.y=s.sa,c.O=s.ta+w,c.f=s.qa,c.N=s.ra+_,c.ea=s.Ha,c.W=s.Ia+_):(L-=y,c.y=d,c.O=p,c.f=g,c.N=h,c.ea=m,c.W=v),b||(P-=y),P>c.o&&(P=c.o),c.F=null,c.J=null,null!=s.Fa&&0<s.Fa.length&&L<P&&(c.J=hr(s,c,L,P-L),c.F=s.mb,null==c.F&&0==c.F.length)){u=Jt(s,3,\"Could not decode alpha data.\");break t}L<c.j&&(y=c.j-L,L=c.j,e(!(1&y)),c.O+=s.R*y,c.N+=s.B*(y>>1),c.W+=s.B*(y>>1),null!=c.F&&(c.J+=c.width*y)),L<P&&(c.O+=c.v,c.N+=c.v>>1,c.W+=c.v>>1,null!=c.F&&(c.J+=c.v),c.ka=L-c.j,c.U=c.va-c.v,c.T=P-L,u=c.put(c))}o+1!=s.Ic||b||(n(s.sa,s.ta-l,d,p+16*s.R,l),n(s.qa,s.ra-f,g,h+8*s.B,f),n(s.Ha,s.Ia-f,m,v+8*s.B,f))}if(!u)return Jt(t,6,\"Output aborted.\")}return 1}(t,r)),null!=r.bc&&r.bc(r),s&=1}return s?(t.cb=0,s):0}function te(t,e,r,n,i){i=t[e+r+32*n]+(i>>3),t[e+r+32*n]=-256&i?0>i?0:255:i}function ee(t,e,r,n,i,a){te(t,e,0,r,n+i),te(t,e,1,r,n+a),te(t,e,2,r,n-a),te(t,e,3,r,n-i)}function re(t){return(20091*t>>16)+t}function ne(t,e,r,n){var i,o=0,s=a(16);for(i=0;4>i;++i){var c=t[e+0]+t[e+8],u=t[e+0]-t[e+8],l=(35468*t[e+4]>>16)-re(t[e+12]),h=re(t[e+4])+(35468*t[e+12]>>16);s[o+0]=c+h,s[o+1]=u+l,s[o+2]=u-l,s[o+3]=c-h,o+=4,e++}for(i=o=0;4>i;++i)c=(t=s[o+0]+4)+s[o+8],u=t-s[o+8],l=(35468*s[o+4]>>16)-re(s[o+12]),te(r,n,0,0,c+(h=re(s[o+4])+(35468*s[o+12]>>16))),te(r,n,1,0,u+l),te(r,n,2,0,u-l),te(r,n,3,0,c-h),o++,n+=32}function ie(t,e,r,n){var i=t[e+0]+4,a=35468*t[e+4]>>16,o=re(t[e+4]),s=35468*t[e+1]>>16;ee(r,n,0,i+o,t=re(t[e+1]),s),ee(r,n,1,i+a,t,s),ee(r,n,2,i-a,t,s),ee(r,n,3,i-o,t,s)}function ae(t,e,r,n,i){ne(t,e,r,n),i&&ne(t,e+16,r,n+4)}function oe(t,e,r,n){on(t,e+0,r,n,1),on(t,e+32,r,n+128,1)}function se(t,e,r,n){var i;for(t=t[e+0]+4,i=0;4>i;++i)for(e=0;4>e;++e)te(r,n,e,i,t)}function ce(t,e,r,n){t[e+0]&&un(t,e+0,r,n),t[e+16]&&un(t,e+16,r,n+4),t[e+32]&&un(t,e+32,r,n+128),t[e+48]&&un(t,e+48,r,n+128+4)}function ue(t,e,r,n){var i,o=a(16);for(i=0;4>i;++i){var s=t[e+0+i]+t[e+12+i],c=t[e+4+i]+t[e+8+i],u=t[e+4+i]-t[e+8+i],l=t[e+0+i]-t[e+12+i];o[0+i]=s+c,o[8+i]=s-c,o[4+i]=l+u,o[12+i]=l-u}for(i=0;4>i;++i)s=(t=o[0+4*i]+3)+o[3+4*i],c=o[1+4*i]+o[2+4*i],u=o[1+4*i]-o[2+4*i],l=t-o[3+4*i],r[n+0]=s+c>>3,r[n+16]=l+u>>3,r[n+32]=s-c>>3,r[n+48]=l-u>>3,n+=64}function le(t,e,r){var n,i=e-32,a=Bn,o=255-t[i-1];for(n=0;n<r;++n){var s,c=a,u=o+t[e-1];for(s=0;s<r;++s)t[e+s]=c[u+t[i+s]];e+=32}}function he(t,e){le(t,e,4)}function fe(t,e){le(t,e,8)}function de(t,e){le(t,e,16)}function pe(t,e){var r;for(r=0;16>r;++r)n(t,e+32*r,t,e-32,16)}function ge(t,e){var r;for(r=16;0<r;--r)i(t,e,t[e-1],16),e+=32}function me(t,e,r){var n;for(n=0;16>n;++n)i(e,r+32*n,t,16)}function ve(t,e){var r,n=16;for(r=0;16>r;++r)n+=t[e-1+32*r]+t[e+r-32];me(n>>5,t,e)}function be(t,e){var r,n=8;for(r=0;16>r;++r)n+=t[e-1+32*r];me(n>>4,t,e)}function ye(t,e){var r,n=8;for(r=0;16>r;++r)n+=t[e+r-32];me(n>>4,t,e)}function we(t,e){me(128,t,e)}function Ne(t,e,r){return t+2*e+r+2>>2}function Le(t,e){var r,i=e-32;i=new Uint8Array([Ne(t[i-1],t[i+0],t[i+1]),Ne(t[i+0],t[i+1],t[i+2]),Ne(t[i+1],t[i+2],t[i+3]),Ne(t[i+2],t[i+3],t[i+4])]);for(r=0;4>r;++r)n(t,e+32*r,i,0,i.length)}function Ae(t,e){var r=t[e-1],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96];F(t,e+0,16843009*Ne(t[e-1-32],r,n)),F(t,e+32,16843009*Ne(r,n,i)),F(t,e+64,16843009*Ne(n,i,a)),F(t,e+96,16843009*Ne(i,a,a))}function xe(t,e){var r,n=4;for(r=0;4>r;++r)n+=t[e+r-32]+t[e-1+32*r];for(n>>=3,r=0;4>r;++r)i(t,e+32*r,n,4)}function Se(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1-32],o=t[e+0-32],s=t[e+1-32],c=t[e+2-32],u=t[e+3-32];t[e+0+96]=Ne(n,i,t[e-1+96]),t[e+1+96]=t[e+0+64]=Ne(r,n,i),t[e+2+96]=t[e+1+64]=t[e+0+32]=Ne(a,r,n),t[e+3+96]=t[e+2+64]=t[e+1+32]=t[e+0+0]=Ne(o,a,r),t[e+3+64]=t[e+2+32]=t[e+1+0]=Ne(s,o,a),t[e+3+32]=t[e+2+0]=Ne(c,s,o),t[e+3+0]=Ne(u,c,s)}function _e(t,e){var r=t[e+1-32],n=t[e+2-32],i=t[e+3-32],a=t[e+4-32],o=t[e+5-32],s=t[e+6-32],c=t[e+7-32];t[e+0+0]=Ne(t[e+0-32],r,n),t[e+1+0]=t[e+0+32]=Ne(r,n,i),t[e+2+0]=t[e+1+32]=t[e+0+64]=Ne(n,i,a),t[e+3+0]=t[e+2+32]=t[e+1+64]=t[e+0+96]=Ne(i,a,o),t[e+3+32]=t[e+2+64]=t[e+1+96]=Ne(a,o,s),t[e+3+64]=t[e+2+96]=Ne(o,s,c),t[e+3+96]=Ne(s,c,c)}function Pe(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1-32],o=t[e+0-32],s=t[e+1-32],c=t[e+2-32],u=t[e+3-32];t[e+0+0]=t[e+1+64]=a+o+1>>1,t[e+1+0]=t[e+2+64]=o+s+1>>1,t[e+2+0]=t[e+3+64]=s+c+1>>1,t[e+3+0]=c+u+1>>1,t[e+0+96]=Ne(i,n,r),t[e+0+64]=Ne(n,r,a),t[e+0+32]=t[e+1+96]=Ne(r,a,o),t[e+1+32]=t[e+2+96]=Ne(a,o,s),t[e+2+32]=t[e+3+96]=Ne(o,s,c),t[e+3+32]=Ne(s,c,u)}function ke(t,e){var r=t[e+0-32],n=t[e+1-32],i=t[e+2-32],a=t[e+3-32],o=t[e+4-32],s=t[e+5-32],c=t[e+6-32],u=t[e+7-32];t[e+0+0]=r+n+1>>1,t[e+1+0]=t[e+0+64]=n+i+1>>1,t[e+2+0]=t[e+1+64]=i+a+1>>1,t[e+3+0]=t[e+2+64]=a+o+1>>1,t[e+0+32]=Ne(r,n,i),t[e+1+32]=t[e+0+96]=Ne(n,i,a),t[e+2+32]=t[e+1+96]=Ne(i,a,o),t[e+3+32]=t[e+2+96]=Ne(a,o,s),t[e+3+64]=Ne(o,s,c),t[e+3+96]=Ne(s,c,u)}function Fe(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96];t[e+0+0]=r+n+1>>1,t[e+2+0]=t[e+0+32]=n+i+1>>1,t[e+2+32]=t[e+0+64]=i+a+1>>1,t[e+1+0]=Ne(r,n,i),t[e+3+0]=t[e+1+32]=Ne(n,i,a),t[e+3+32]=t[e+1+64]=Ne(i,a,a),t[e+3+64]=t[e+2+64]=t[e+0+96]=t[e+1+96]=t[e+2+96]=t[e+3+96]=a}function Ie(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96],o=t[e-1-32],s=t[e+0-32],c=t[e+1-32],u=t[e+2-32];t[e+0+0]=t[e+2+32]=r+o+1>>1,t[e+0+32]=t[e+2+64]=n+r+1>>1,t[e+0+64]=t[e+2+96]=i+n+1>>1,t[e+0+96]=a+i+1>>1,t[e+3+0]=Ne(s,c,u),t[e+2+0]=Ne(o,s,c),t[e+1+0]=t[e+3+32]=Ne(r,o,s),t[e+1+32]=t[e+3+64]=Ne(n,r,o),t[e+1+64]=t[e+3+96]=Ne(i,n,r),t[e+1+96]=Ne(a,i,n)}function Ce(t,e){var r;for(r=0;8>r;++r)n(t,e+32*r,t,e-32,8)}function je(t,e){var r;for(r=0;8>r;++r)i(t,e,t[e-1],8),e+=32}function Oe(t,e,r){var n;for(n=0;8>n;++n)i(e,r+32*n,t,8)}function Be(t,e){var r,n=8;for(r=0;8>r;++r)n+=t[e+r-32]+t[e-1+32*r];Oe(n>>4,t,e)}function Me(t,e){var r,n=4;for(r=0;8>r;++r)n+=t[e+r-32];Oe(n>>3,t,e)}function Ee(t,e){var r,n=4;for(r=0;8>r;++r)n+=t[e-1+32*r];Oe(n>>3,t,e)}function qe(t,e){Oe(128,t,e)}function De(t,e,r){var n=t[e-r],i=t[e+0],a=3*(i-n)+jn[1020+t[e-2*r]-t[e+r]],o=On[112+(a+4>>3)];t[e-r]=Bn[255+n+On[112+(a+3>>3)]],t[e+0]=Bn[255+i-o]}function Re(t,e,r,n){var i=t[e+0],a=t[e+r];return Mn[255+t[e-2*r]-t[e-r]]>n||Mn[255+a-i]>n}function Te(t,e,r,n){return 4*Mn[255+t[e-r]-t[e+0]]+Mn[255+t[e-2*r]-t[e+r]]<=n}function Ue(t,e,r,n,i){var a=t[e-3*r],o=t[e-2*r],s=t[e-r],c=t[e+0],u=t[e+r],l=t[e+2*r],h=t[e+3*r];return 4*Mn[255+s-c]+Mn[255+o-u]>n?0:Mn[255+t[e-4*r]-a]<=i&&Mn[255+a-o]<=i&&Mn[255+o-s]<=i&&Mn[255+h-l]<=i&&Mn[255+l-u]<=i&&Mn[255+u-c]<=i}function ze(t,e,r,n){var i=2*n+1;for(n=0;16>n;++n)Te(t,e+n,r,i)&&De(t,e+n,r)}function He(t,e,r,n){var i=2*n+1;for(n=0;16>n;++n)Te(t,e+n*r,1,i)&&De(t,e+n*r,1)}function We(t,e,r,n){var i;for(i=3;0<i;--i)ze(t,e+=4*r,r,n)}function Ve(t,e,r,n){var i;for(i=3;0<i;--i)He(t,e+=4,r,n)}function Ge(t,e,r,n,i,a,o,s){for(a=2*a+1;0<i--;){if(Ue(t,e,r,a,o))if(Re(t,e,r,s))De(t,e,r);else{var c=t,u=e,l=r,h=c[u-2*l],f=c[u-l],d=c[u+0],p=c[u+l],g=c[u+2*l],m=27*(b=jn[1020+3*(d-f)+jn[1020+h-p]])+63>>7,v=18*b+63>>7,b=9*b+63>>7;c[u-3*l]=Bn[255+c[u-3*l]+b],c[u-2*l]=Bn[255+h+v],c[u-l]=Bn[255+f+m],c[u+0]=Bn[255+d-m],c[u+l]=Bn[255+p-v],c[u+2*l]=Bn[255+g-b]}e+=n}}function Ye(t,e,r,n,i,a,o,s){for(a=2*a+1;0<i--;){if(Ue(t,e,r,a,o))if(Re(t,e,r,s))De(t,e,r);else{var c=t,u=e,l=r,h=c[u-l],f=c[u+0],d=c[u+l],p=On[112+((g=3*(f-h))+4>>3)],g=On[112+(g+3>>3)],m=p+1>>1;c[u-2*l]=Bn[255+c[u-2*l]+m],c[u-l]=Bn[255+h+g],c[u+0]=Bn[255+f-p],c[u+l]=Bn[255+d-m]}e+=n}}function Je(t,e,r,n,i,a){Ge(t,e,r,1,16,n,i,a)}function Xe(t,e,r,n,i,a){Ge(t,e,1,r,16,n,i,a)}function Ke(t,e,r,n,i,a){var o;for(o=3;0<o;--o)Ye(t,e+=4*r,r,1,16,n,i,a)}function Ze(t,e,r,n,i,a){var o;for(o=3;0<o;--o)Ye(t,e+=4,1,r,16,n,i,a)}function $e(t,e,r,n,i,a,o,s){Ge(t,e,i,1,8,a,o,s),Ge(r,n,i,1,8,a,o,s)}function Qe(t,e,r,n,i,a,o,s){Ge(t,e,1,i,8,a,o,s),Ge(r,n,1,i,8,a,o,s)}function tr(t,e,r,n,i,a,o,s){Ye(t,e+4*i,i,1,8,a,o,s),Ye(r,n+4*i,i,1,8,a,o,s)}function er(t,e,r,n,i,a,o,s){Ye(t,e+4,1,i,8,a,o,s),Ye(r,n+4,1,i,8,a,o,s)}function rr(){this.ba=new ot,this.ec=[],this.cc=[],this.Mc=[],this.Dc=this.Nc=this.dc=this.fc=0,this.Oa=new ct,this.memory=0,this.Ib=\"OutputFunc\",this.Jb=\"OutputAlphaFunc\",this.Nd=\"OutputRowFunc\"}function nr(){this.data=[],this.offset=this.kd=this.ha=this.w=0,this.na=[],this.xa=this.gb=this.Ja=this.Sa=this.P=0}function ir(){this.nc=this.Ea=this.b=this.hc=0,this.K=[],this.w=0}function ar(){this.ua=0,this.Wa=new M,this.vb=new M,this.md=this.xc=this.wc=0,this.vc=[],this.Wb=0,this.Ya=new d,this.yc=new h}function or(){this.xb=this.a=0,this.l=new Gt,this.ca=new ot,this.V=[],this.Ba=0,this.Ta=[],this.Ua=0,this.m=new N,this.Pb=0,this.wd=new N,this.Ma=this.$=this.C=this.i=this.c=this.xd=0,this.s=new ar,this.ab=0,this.gc=o(4,ir),this.Oc=0}function sr(){this.Lc=this.Z=this.$a=this.i=this.c=0,this.l=new Gt,this.ic=0,this.ca=[],this.tb=0,this.qd=null,this.rd=0}function cr(t,e,r,n,i,a,o){for(t=null==t?0:t[e+0],e=0;e<o;++e)i[a+e]=t+r[n+e]&255,t=i[a+e]}function ur(t,e,r,n,i,a,o){var s;if(null==t)cr(null,null,r,n,i,a,o);else for(s=0;s<o;++s)i[a+s]=t[e+s]+r[n+s]&255}function lr(t,e,r,n,i,a,o){if(null==t)cr(null,null,r,n,i,a,o);else{var s,c=t[e+0],u=c,l=c;for(s=0;s<o;++s)u=l+(c=t[e+s])-u,l=r[n+s]+(-256&u?0>u?0:255:u)&255,u=c,i[a+s]=l}}function hr(t,r,i,o){var s=r.width,c=r.o;if(e(null!=t&&null!=r),0>i||0>=o||i+o>c)return null;if(!t.Cc){if(null==t.ga){var u;if(t.ga=new sr,(u=null==t.ga)||(u=r.width*r.o,e(0==t.Gb.length),t.Gb=a(u),t.Uc=0,null==t.Gb?u=0:(t.mb=t.Gb,t.nb=t.Uc,t.rc=null,u=1),u=!u),!u){u=t.ga;var l=t.Fa,h=t.P,f=t.qc,d=t.mb,p=t.nb,g=h+1,m=f-1,b=u.l;if(e(null!=l&&null!=d&&null!=r),mi[0]=null,mi[1]=cr,mi[2]=ur,mi[3]=lr,u.ca=d,u.tb=p,u.c=r.width,u.i=r.height,e(0<u.c&&0<u.i),1>=f)r=0;else if(u.$a=l[h+0]>>0&3,u.Z=l[h+0]>>2&3,u.Lc=l[h+0]>>4&3,h=l[h+0]>>6&3,0>u.$a||1<u.$a||4<=u.Z||1<u.Lc||h)r=0;else if(b.put=dt,b.ac=ft,b.bc=pt,b.ma=u,b.width=r.width,b.height=r.height,b.Da=r.Da,b.v=r.v,b.va=r.va,b.j=r.j,b.o=r.o,u.$a)t:{e(1==u.$a),r=kt();e:for(;;){if(null==r){r=0;break t}if(e(null!=u),u.mc=r,r.c=u.c,r.i=u.i,r.l=u.l,r.l.ma=u,r.l.width=u.c,r.l.height=u.i,r.a=0,v(r.m,l,g,m),!Ft(u.c,u.i,1,r,null))break e;if(1==r.ab&&3==r.gc[0].hc&&At(r.s)?(u.ic=1,l=r.c*r.i,r.Ta=null,r.Ua=0,r.V=a(l),r.Ba=0,null==r.V?(r.a=1,r=0):r=1):(u.ic=0,r=It(r,u.c)),!r)break e;r=1;break t}u.mc=null,r=0}else r=m>=u.c*u.i;u=!r}if(u)return null;1!=t.ga.Lc?t.Ga=0:o=c-i}e(null!=t.ga),e(i+o<=c);t:{if(r=(l=t.ga).c,c=l.l.o,0==l.$a){if(g=t.rc,m=t.Vc,b=t.Fa,h=t.P+1+i*r,f=t.mb,d=t.nb+i*r,e(h<=t.P+t.qc),0!=l.Z)for(e(null!=mi[l.Z]),u=0;u<o;++u)mi[l.Z](g,m,b,h,f,d,r),g=f,m=d,d+=r,h+=r;else for(u=0;u<o;++u)n(f,d,b,h,r),g=f,m=d,d+=r,h+=r;t.rc=g,t.Vc=m}else{if(e(null!=l.mc),r=i+o,e(null!=(u=l.mc)),e(r<=u.i),u.C>=r)r=1;else if(l.ic||mr(),l.ic){l=u.V,g=u.Ba,m=u.c;var y=u.i,w=(b=1,h=u.$/m,f=u.$%m,d=u.m,p=u.s,u.$),N=m*y,L=m*r,x=p.wc,_=w<L?wt(p,f,h):null;e(w<=N),e(r<=y),e(At(p));e:for(;;){for(;!d.h&&w<L;){if(f&x||(_=wt(p,f,h)),e(null!=_),S(d),256>(y=bt(_.G[0],_.H[0],d)))l[g+w]=y,++w,++f>=m&&(f=0,++h<=r&&!(h%16)&&St(u,h));else{if(!(280>y)){b=0;break e}y=mt(y-256,d);var P,k=bt(_.G[4],_.H[4],d);if(S(d),!(w>=(k=vt(m,k=mt(k,d)))&&N-w>=y)){b=0;break e}for(P=0;P<y;++P)l[g+w+P]=l[g+w+P-k];for(w+=y,f+=y;f>=m;)f-=m,++h<=r&&!(h%16)&&St(u,h);w<L&&f&x&&(_=wt(p,f,h))}e(d.h==A(d))}St(u,h>r?r:h);break e}!b||d.h&&w<N?(b=0,u.a=d.h?5:3):u.$=w,r=b}else r=_t(u,u.V,u.Ba,u.c,u.i,r,Ct);if(!r){o=0;break t}}i+o>=c&&(t.Cc=1),o=1}if(!o)return null;if(t.Cc&&(null!=(o=t.ga)&&(o.mc=null),t.ga=null,0<t.Ga))return alert(\"todo:WebPDequantizeLevels\"),null}return t.nb+i*s}function fr(t,e,r,n,i,a){for(;0<i--;){var o,s=t,c=e+(r?1:0),u=t,l=e+(r?0:3);for(o=0;o<n;++o){var h=u[l+4*o];255!=h&&(h*=32897,s[c+4*o+0]=s[c+4*o+0]*h>>23,s[c+4*o+1]=s[c+4*o+1]*h>>23,s[c+4*o+2]=s[c+4*o+2]*h>>23)}e+=a}}function dr(t,e,r,n,i){for(;0<n--;){var a;for(a=0;a<r;++a){var o=t[e+2*a+0],s=15&(u=t[e+2*a+1]),c=4369*s,u=(240&u|u>>4)*c>>16;t[e+2*a+0]=(240&o|o>>4)*c>>16&240|(15&o|o<<4)*c>>16>>4&15,t[e+2*a+1]=240&u|s}e+=i}}function pr(t,e,r,n,i,a,o,s){var c,u,l=255;for(u=0;u<i;++u){for(c=0;c<n;++c){var h=t[e+c];a[o+4*c]=h,l&=h}e+=r,o+=s}return 255!=l}function gr(t,e,r,n,i){var a;for(a=0;a<i;++a)r[n+a]=t[e+a]>>8}function mr(){An=fr,xn=dr,Sn=pr,_n=gr}function vr(r,n,i){t[r]=function(t,r,a,o,s,c,u,l,h,f,d,p,g,m,v,b,y){var w,N=y-1>>1,L=s[c+0]|u[l+0]<<16,A=h[f+0]|d[p+0]<<16;e(null!=t);var x=3*L+A+131074>>2;for(n(t[r+0],255&x,x>>16,g,m),null!=a&&(x=3*A+L+131074>>2,n(a[o+0],255&x,x>>16,v,b)),w=1;w<=N;++w){var S=s[c+w]|u[l+w]<<16,_=h[f+w]|d[p+w]<<16,P=L+S+A+_+524296,k=P+2*(S+A)>>3;x=k+L>>1,L=(P=P+2*(L+_)>>3)+S>>1,n(t[r+2*w-1],255&x,x>>16,g,m+(2*w-1)*i),n(t[r+2*w-0],255&L,L>>16,g,m+(2*w-0)*i),null!=a&&(x=P+A>>1,L=k+_>>1,n(a[o+2*w-1],255&x,x>>16,v,b+(2*w-1)*i),n(a[o+2*w+0],255&L,L>>16,v,b+(2*w+0)*i)),L=S,A=_}1&y||(x=3*L+A+131074>>2,n(t[r+y-1],255&x,x>>16,g,m+(y-1)*i),null!=a&&(x=3*A+L+131074>>2,n(a[o+y-1],255&x,x>>16,v,b+(y-1)*i)))}}function br(){vi[En]=bi,vi[qn]=wi,vi[Dn]=yi,vi[Rn]=Ni,vi[Tn]=Li,vi[Un]=Ai,vi[zn]=xi,vi[Hn]=wi,vi[Wn]=Ni,vi[Vn]=Li,vi[Gn]=Ai}function yr(t){return t&~Ii?0>t?0:255:t>>Fi}function wr(t,e){return yr((19077*t>>8)+(26149*e>>8)-14234)}function Nr(t,e,r){return yr((19077*t>>8)-(6419*e>>8)-(13320*r>>8)+8708)}function Lr(t,e){return yr((19077*t>>8)+(33050*e>>8)-17685)}function Ar(t,e,r,n,i){n[i+0]=wr(t,r),n[i+1]=Nr(t,e,r),n[i+2]=Lr(t,e)}function xr(t,e,r,n,i){n[i+0]=Lr(t,e),n[i+1]=Nr(t,e,r),n[i+2]=wr(t,r)}function Sr(t,e,r,n,i){var a=Nr(t,e,r);e=a<<3&224|Lr(t,e)>>3,n[i+0]=248&wr(t,r)|a>>5,n[i+1]=e}function _r(t,e,r,n,i){var a=240&Lr(t,e)|15;n[i+0]=240&wr(t,r)|Nr(t,e,r)>>4,n[i+1]=a}function Pr(t,e,r,n,i){n[i+0]=255,Ar(t,e,r,n,i+1)}function kr(t,e,r,n,i){xr(t,e,r,n,i),n[i+3]=255}function Fr(t,e,r,n,i){Ar(t,e,r,n,i),n[i+3]=255}function Vt(t,e){return 0>t?0:t>e?e:t}function Ir(e,r,n){t[e]=function(t,e,i,a,o,s,c,u,l){for(var h=u+(-2&l)*n;u!=h;)r(t[e+0],i[a+0],o[s+0],c,u),r(t[e+1],i[a+0],o[s+0],c,u+n),e+=2,++a,++s,u+=2*n;1&l&&r(t[e+0],i[a+0],o[s+0],c,u)}}function Cr(t,e,r){return 0==r?0==t?0==e?6:5:0==e?4:0:r}function jr(t,e,r,n,i){switch(t>>>30){case 3:on(e,r,n,i,0);break;case 2:sn(e,r,n,i);break;case 1:un(e,r,n,i)}}function Or(t,e){var r,a,o=e.M,s=e.Nb,c=t.oc,u=t.pc+40,l=t.oc,h=t.pc+584,f=t.oc,d=t.pc+600;for(r=0;16>r;++r)c[u+32*r-1]=129;for(r=0;8>r;++r)l[h+32*r-1]=129,f[d+32*r-1]=129;for(0<o?c[u-1-32]=l[h-1-32]=f[d-1-32]=129:(i(c,u-32-1,127,21),i(l,h-32-1,127,9),i(f,d-32-1,127,9)),a=0;a<t.za;++a){var p=e.ya[e.aa+a];if(0<a){for(r=-1;16>r;++r)n(c,u+32*r-4,c,u+32*r+12,4);for(r=-1;8>r;++r)n(l,h+32*r-4,l,h+32*r+4,4),n(f,d+32*r-4,f,d+32*r+4,4)}var g=t.Gd,m=t.Hd+a,v=p.ad,b=p.Hc;if(0<o&&(n(c,u-32,g[m].y,0,16),n(l,h-32,g[m].f,0,8),n(f,d-32,g[m].ea,0,8)),p.Za){var y=c,w=u-32+16;for(0<o&&(a>=t.za-1?i(y,w,g[m].y[15],4):n(y,w,g[m+1].y,0,4)),r=0;4>r;r++)y[w+128+r]=y[w+256+r]=y[w+384+r]=y[w+0+r];for(r=0;16>r;++r,b<<=2)y=c,w=u+Di[r],fi[p.Ob[r]](y,w),jr(b,v,16*+r,y,w)}else if(y=Cr(a,o,p.Ob[0]),hi[y](c,u),0!=b)for(r=0;16>r;++r,b<<=2)jr(b,v,16*+r,c,u+Di[r]);for(r=p.Gc,y=Cr(a,o,p.Dd),di[y](l,h),di[y](f,d),b=v,y=l,w=h,255&(p=r>>0)&&(170&p?cn(b,256,y,w):ln(b,256,y,w)),p=f,b=d,255&(r>>=8)&&(170&r?cn(v,320,p,b):ln(v,320,p,b)),o<t.Ub-1&&(n(g[m].y,0,c,u+480,16),n(g[m].f,0,l,h+224,8),n(g[m].ea,0,f,d+224,8)),r=8*s*t.B,g=t.sa,m=t.ta+16*a+16*s*t.R,v=t.qa,p=t.ra+8*a+r,b=t.Ha,y=t.Ia+8*a+r,r=0;16>r;++r)n(g,m+r*t.R,c,u+32*r,16);for(r=0;8>r;++r)n(v,p+r*t.B,l,h+32*r,8),n(b,y+r*t.B,f,d+32*r,8)}}function Br(t,n,i,a,o,s,c,u,l){var h=[0],f=[0],d=0,p=null!=l?l.kd:0,g=null!=l?l:new nr;if(null==t||12>i)return 7;g.data=t,g.w=n,g.ha=i,n=[n],i=[i],g.gb=[g.gb];t:{var m=n,b=i,y=g.gb;if(e(null!=t),e(null!=b),e(null!=y),y[0]=0,12<=b[0]&&!r(t,m[0],\"RIFF\")){if(r(t,m[0]+8,\"WEBP\")){y=3;break t}var w=j(t,m[0]+4);if(12>w||4294967286<w){y=3;break t}if(p&&w>b[0]-8){y=7;break t}y[0]=w,m[0]+=12,b[0]-=12}y=0}if(0!=y)return y;for(w=0<g.gb[0],i=i[0];;){t:{var L=t;b=n,y=i;var A=h,x=f,S=m=[0];if((k=d=[d])[0]=0,8>y[0])y=7;else{if(!r(L,b[0],\"VP8X\")){if(10!=j(L,b[0]+4)){y=3;break t}if(18>y[0]){y=7;break t}var _=j(L,b[0]+8),P=1+C(L,b[0]+12);if(2147483648<=P*(L=1+C(L,b[0]+15))){y=3;break t}null!=S&&(S[0]=_),null!=A&&(A[0]=P),null!=x&&(x[0]=L),b[0]+=18,y[0]-=18,k[0]=1}y=0}}if(d=d[0],m=m[0],0!=y)return y;if(b=!!(2&m),!w&&d)return 3;if(null!=s&&(s[0]=!!(16&m)),null!=c&&(c[0]=b),null!=u&&(u[0]=0),c=h[0],m=f[0],d&&b&&null==l){y=0;break}if(4>i){y=7;break}if(w&&d||!w&&!d&&!r(t,n[0],\"ALPH\")){i=[i],g.na=[g.na],g.P=[g.P],g.Sa=[g.Sa];t:{_=t,y=n,w=i;var k=g.gb;A=g.na,x=g.P,S=g.Sa;P=22,e(null!=_),e(null!=w),L=y[0];var F=w[0];for(e(null!=A),e(null!=S),A[0]=null,x[0]=null,S[0]=0;;){if(y[0]=L,w[0]=F,8>F){y=7;break t}var I=j(_,L+4);if(4294967286<I){y=3;break t}var O=8+I+1&-2;if(P+=O,0<k&&P>k){y=3;break t}if(!r(_,L,\"VP8 \")||!r(_,L,\"VP8L\")){y=0;break t}if(F[0]<O){y=7;break t}r(_,L,\"ALPH\")||(A[0]=_,x[0]=L+8,S[0]=I),L+=O,F-=O}}if(i=i[0],g.na=g.na[0],g.P=g.P[0],g.Sa=g.Sa[0],0!=y)break}i=[i],g.Ja=[g.Ja],g.xa=[g.xa];t:if(k=t,y=n,w=i,A=g.gb[0],x=g.Ja,S=g.xa,_=y[0],L=!r(k,_,\"VP8 \"),P=!r(k,_,\"VP8L\"),e(null!=k),e(null!=w),e(null!=x),e(null!=S),8>w[0])y=7;else{if(L||P){if(k=j(k,_+4),12<=A&&k>A-12){y=3;break t}if(p&&k>w[0]-8){y=7;break t}x[0]=k,y[0]+=8,w[0]-=8,S[0]=P}else S[0]=5<=w[0]&&47==k[_+0]&&!(k[_+4]>>5),x[0]=w[0];y=0}if(i=i[0],g.Ja=g.Ja[0],g.xa=g.xa[0],n=n[0],0!=y)break;if(4294967286<g.Ja)return 3;if(null==u||b||(u[0]=g.xa?2:1),c=[c],m=[m],g.xa){if(5>i){y=7;break}u=c,p=m,b=s,null==t||5>i?t=0:5<=i&&47==t[n+0]&&!(t[n+4]>>5)?(w=[0],k=[0],A=[0],v(x=new N,t,n,i),gt(x,w,k,A)?(null!=u&&(u[0]=w[0]),null!=p&&(p[0]=k[0]),null!=b&&(b[0]=A[0]),t=1):t=0):t=0}else{if(10>i){y=7;break}u=m,null==t||10>i||!Xt(t,n+3,i-3)?t=0:(p=t[n+0]|t[n+1]<<8|t[n+2]<<16,b=16383&(t[n+7]<<8|t[n+6]),t=16383&(t[n+9]<<8|t[n+8]),1&p||3<(p>>1&7)||!(p>>4&1)||p>>5>=g.Ja||!b||!t?t=0:(c&&(c[0]=b),u&&(u[0]=t),t=1))}if(!t)return 3;if(c=c[0],m=m[0],d&&(h[0]!=c||f[0]!=m))return 3;null!=l&&(l[0]=g,l.offset=n-l.w,e(4294967286>n-l.w),e(l.offset==l.ha-i));break}return 0==y||7==y&&d&&null==l?(null!=s&&(s[0]|=null!=g.na&&0<g.na.length),null!=a&&(a[0]=c),null!=o&&(o[0]=m),0):y}function Mr(t,e,r){var n=e.width,i=e.height,a=0,o=0,s=n,c=i;if(e.Da=null!=t&&0<t.Da,e.Da&&(s=t.cd,c=t.bd,a=t.v,o=t.j,11>r||(a&=-2,o&=-2),0>a||0>o||0>=s||0>=c||a+s>n||o+c>i))return 0;if(e.v=a,e.j=o,e.va=a+s,e.o=o+c,e.U=s,e.T=c,e.da=null!=t&&0<t.da,e.da){if(!E(s,c,r=[t.ib],a=[t.hb]))return 0;e.ib=r[0],e.hb=a[0]}return e.ob=null!=t&&t.ob,e.Kb=null==t||!t.Sd,e.da&&(e.ob=e.ib<3*n/4&&e.hb<3*i/4,e.Kb=0),1}function Er(t){if(null==t)return 2;if(11>t.S){var e=t.f.RGBA;e.fb+=(t.height-1)*e.A,e.A=-e.A}else e=t.f.kb,t=t.height,e.O+=(t-1)*e.fa,e.fa=-e.fa,e.N+=(t-1>>1)*e.Ab,e.Ab=-e.Ab,e.W+=(t-1>>1)*e.Db,e.Db=-e.Db,null!=e.F&&(e.J+=(t-1)*e.lb,e.lb=-e.lb);return 0}function qr(t,e,r,n){if(null==n||0>=t||0>=e)return 2;if(null!=r){if(r.Da){var i=r.cd,o=r.bd,s=-2&r.v,c=-2&r.j;if(0>s||0>c||0>=i||0>=o||s+i>t||c+o>e)return 2;t=i,e=o}if(r.da){if(!E(t,e,i=[r.ib],o=[r.hb]))return 2;t=i[0],e=o[0]}}n.width=t,n.height=e;t:{var u=n.width,l=n.height;if(t=n.S,0>=u||0>=l||!(t>=En&&13>t))t=2;else{if(0>=n.Rd&&null==n.sd){s=o=i=e=0;var h=(c=u*zi[t])*l;if(11>t||(o=(l+1)/2*(e=(u+1)/2),12==t&&(s=(i=u)*l)),null==(l=a(h+2*o+s))){t=1;break t}n.sd=l,11>t?((u=n.f.RGBA).eb=l,u.fb=0,u.A=c,u.size=h):((u=n.f.kb).y=l,u.O=0,u.fa=c,u.Fd=h,u.f=l,u.N=0+h,u.Ab=e,u.Cd=o,u.ea=l,u.W=0+h+o,u.Db=e,u.Ed=o,12==t&&(u.F=l,u.J=0+h+2*o),u.Tc=s,u.lb=i)}if(e=1,i=n.S,o=n.width,s=n.height,i>=En&&13>i)if(11>i)t=n.f.RGBA,e&=(c=Math.abs(t.A))*(s-1)+o<=t.size,e&=c>=o*zi[i],e&=null!=t.eb;else{t=n.f.kb,c=(o+1)/2,h=(s+1)/2,u=Math.abs(t.fa);l=Math.abs(t.Ab);var f=Math.abs(t.Db),d=Math.abs(t.lb),p=d*(s-1)+o;e&=u*(s-1)+o<=t.Fd,e&=l*(h-1)+c<=t.Cd,e=(e&=f*(h-1)+c<=t.Ed)&u>=o&l>=c&f>=c,e&=null!=t.y,e&=null!=t.f,e&=null!=t.ea,12==i&&(e&=d>=o,e&=p<=t.Tc,e&=null!=t.F)}else e=0;t=e?0:2}}return 0!=t||null!=r&&r.fd&&(t=Er(n)),t}var Dr=64,Rr=[0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,32767,65535,131071,262143,524287,1048575,2097151,4194303,8388607,16777215],Tr=24,Ur=32,zr=8,Hr=[0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7];R(\"Predictor0\",\"PredictorAdd0\"),t.Predictor0=function(){return 4278190080},t.Predictor1=function(t){return t},t.Predictor2=function(t,e,r){return e[r+0]},t.Predictor3=function(t,e,r){return e[r+1]},t.Predictor4=function(t,e,r){return e[r-1]},t.Predictor5=function(t,e,r){return U(U(t,e[r+1]),e[r+0])},t.Predictor6=function(t,e,r){return U(t,e[r-1])},t.Predictor7=function(t,e,r){return U(t,e[r+0])},t.Predictor8=function(t,e,r){return U(e[r-1],e[r+0])},t.Predictor9=function(t,e,r){return U(e[r+0],e[r+1])},t.Predictor10=function(t,e,r){return U(U(t,e[r-1]),U(e[r+0],e[r+1]))},t.Predictor11=function(t,e,r){var n=e[r+0];return 0>=W(n>>24&255,t>>24&255,(e=e[r-1])>>24&255)+W(n>>16&255,t>>16&255,e>>16&255)+W(n>>8&255,t>>8&255,e>>8&255)+W(255&n,255&t,255&e)?n:t},t.Predictor12=function(t,e,r){var n=e[r+0];return(z((t>>24&255)+(n>>24&255)-((e=e[r-1])>>24&255))<<24|z((t>>16&255)+(n>>16&255)-(e>>16&255))<<16|z((t>>8&255)+(n>>8&255)-(e>>8&255))<<8|z((255&t)+(255&n)-(255&e)))>>>0},t.Predictor13=function(t,e,r){var n=e[r-1];return(H((t=U(t,e[r+0]))>>24&255,n>>24&255)<<24|H(t>>16&255,n>>16&255)<<16|H(t>>8&255,n>>8&255)<<8|H(t>>0&255,n>>0&255))>>>0};var Wr=t.PredictorAdd0;t.PredictorAdd1=V,R(\"Predictor2\",\"PredictorAdd2\"),R(\"Predictor3\",\"PredictorAdd3\"),R(\"Predictor4\",\"PredictorAdd4\"),R(\"Predictor5\",\"PredictorAdd5\"),R(\"Predictor6\",\"PredictorAdd6\"),R(\"Predictor7\",\"PredictorAdd7\"),R(\"Predictor8\",\"PredictorAdd8\"),R(\"Predictor9\",\"PredictorAdd9\"),R(\"Predictor10\",\"PredictorAdd10\"),R(\"Predictor11\",\"PredictorAdd11\"),R(\"Predictor12\",\"PredictorAdd12\"),R(\"Predictor13\",\"PredictorAdd13\");var Vr=t.PredictorAdd2;X(\"ColorIndexInverseTransform\",\"MapARGB\",\"32b\",(function(t){return t>>8&255}),(function(t){return t})),X(\"VP8LColorIndexInverseTransformAlpha\",\"MapAlpha\",\"8b\",(function(t){return t}),(function(t){return t>>8&255}));var Gr,Yr=t.ColorIndexInverseTransform,Jr=t.MapARGB,Xr=t.VP8LColorIndexInverseTransformAlpha,Kr=t.MapAlpha,Zr=t.VP8LPredictorsAdd=[];Zr.length=16,(t.VP8LPredictors=[]).length=16,(t.VP8LPredictorsAdd_C=[]).length=16,(t.VP8LPredictors_C=[]).length=16;var $r,Qr,tn,en,rn,nn,an,on,sn,cn,un,ln,hn,fn,dn,pn,gn,mn,vn,bn,yn,wn,Nn,Ln,An,xn,Sn,_n,Pn=a(511),kn=a(2041),Fn=a(225),In=a(767),Cn=0,jn=kn,On=Fn,Bn=In,Mn=Pn,En=0,qn=1,Dn=2,Rn=3,Tn=4,Un=5,zn=6,Hn=7,Wn=8,Vn=9,Gn=10,Yn=[2,3,7],Jn=[3,3,11],Xn=[280,256,256,256,40],Kn=[0,1,1,1,0],Zn=[17,18,0,1,2,3,4,5,16,6,7,8,9,10,11,12,13,14,15],$n=[24,7,23,25,40,6,39,41,22,26,38,42,56,5,55,57,21,27,54,58,37,43,72,4,71,73,20,28,53,59,70,74,36,44,88,69,75,52,60,3,87,89,19,29,86,90,35,45,68,76,85,91,51,61,104,2,103,105,18,30,102,106,34,46,84,92,67,77,101,107,50,62,120,1,119,121,83,93,17,31,100,108,66,78,118,122,33,47,117,123,49,63,99,109,82,94,0,116,124,65,79,16,32,98,110,48,115,125,81,95,64,114,126,97,111,80,113,127,96,112],Qn=[2954,2956,2958,2962,2970,2986,3018,3082,3212,3468,3980,5004],ti=8,ei=[4,5,6,7,8,9,10,10,11,12,13,14,15,16,17,17,18,19,20,20,21,21,22,22,23,23,24,25,25,26,27,28,29,30,31,32,33,34,35,36,37,37,38,39,40,41,42,43,44,45,46,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,76,77,78,79,80,81,82,83,84,85,86,87,88,89,91,93,95,96,98,100,101,102,104,106,108,110,112,114,116,118,122,124,126,128,130,132,134,136,138,140,143,145,148,151,154,157],ri=[4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,119,122,125,128,131,134,137,140,143,146,149,152,155,158,161,164,167,170,173,177,181,185,189,193,197,201,205,209,213,217,221,225,229,234,239,245,249,254,259,264,269,274,279,284],ni=null,ii=[[173,148,140,0],[176,155,140,135,0],[180,157,141,134,130,0],[254,254,243,230,196,177,153,140,133,130,129,0]],ai=[0,1,4,8,5,2,3,6,9,12,13,10,7,11,14,15],oi=[-0,1,-1,2,-2,3,4,6,-3,5,-4,-5,-6,7,-7,8,-8,-9],si=[[[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]],[[253,136,254,255,228,219,128,128,128,128,128],[189,129,242,255,227,213,255,219,128,128,128],[106,126,227,252,214,209,255,255,128,128,128]],[[1,98,248,255,236,226,255,255,128,128,128],[181,133,238,254,221,234,255,154,128,128,128],[78,134,202,247,198,180,255,219,128,128,128]],[[1,185,249,255,243,255,128,128,128,128,128],[184,150,247,255,236,224,128,128,128,128,128],[77,110,216,255,236,230,128,128,128,128,128]],[[1,101,251,255,241,255,128,128,128,128,128],[170,139,241,252,236,209,255,255,128,128,128],[37,116,196,243,228,255,255,255,128,128,128]],[[1,204,254,255,245,255,128,128,128,128,128],[207,160,250,255,238,128,128,128,128,128,128],[102,103,231,255,211,171,128,128,128,128,128]],[[1,152,252,255,240,255,128,128,128,128,128],[177,135,243,255,234,225,128,128,128,128,128],[80,129,211,255,194,224,128,128,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[246,1,255,128,128,128,128,128,128,128,128],[255,128,128,128,128,128,128,128,128,128,128]]],[[[198,35,237,223,193,187,162,160,145,155,62],[131,45,198,221,172,176,220,157,252,221,1],[68,47,146,208,149,167,221,162,255,223,128]],[[1,149,241,255,221,224,255,255,128,128,128],[184,141,234,253,222,220,255,199,128,128,128],[81,99,181,242,176,190,249,202,255,255,128]],[[1,129,232,253,214,197,242,196,255,255,128],[99,121,210,250,201,198,255,202,128,128,128],[23,91,163,242,170,187,247,210,255,255,128]],[[1,200,246,255,234,255,128,128,128,128,128],[109,178,241,255,231,245,255,255,128,128,128],[44,130,201,253,205,192,255,255,128,128,128]],[[1,132,239,251,219,209,255,165,128,128,128],[94,136,225,251,218,190,255,255,128,128,128],[22,100,174,245,186,161,255,199,128,128,128]],[[1,182,249,255,232,235,128,128,128,128,128],[124,143,241,255,227,234,128,128,128,128,128],[35,77,181,251,193,211,255,205,128,128,128]],[[1,157,247,255,236,231,255,255,128,128,128],[121,141,235,255,225,227,255,255,128,128,128],[45,99,188,251,195,217,255,224,128,128,128]],[[1,1,251,255,213,255,128,128,128,128,128],[203,1,248,255,255,128,128,128,128,128,128],[137,1,177,255,224,255,128,128,128,128,128]]],[[[253,9,248,251,207,208,255,192,128,128,128],[175,13,224,243,193,185,249,198,255,255,128],[73,17,171,221,161,179,236,167,255,234,128]],[[1,95,247,253,212,183,255,255,128,128,128],[239,90,244,250,211,209,255,255,128,128,128],[155,77,195,248,188,195,255,255,128,128,128]],[[1,24,239,251,218,219,255,205,128,128,128],[201,51,219,255,196,186,128,128,128,128,128],[69,46,190,239,201,218,255,228,128,128,128]],[[1,191,251,255,255,128,128,128,128,128,128],[223,165,249,255,213,255,128,128,128,128,128],[141,124,248,255,255,128,128,128,128,128,128]],[[1,16,248,255,255,128,128,128,128,128,128],[190,36,230,255,236,255,128,128,128,128,128],[149,1,255,128,128,128,128,128,128,128,128]],[[1,226,255,128,128,128,128,128,128,128,128],[247,192,255,128,128,128,128,128,128,128,128],[240,128,255,128,128,128,128,128,128,128,128]],[[1,134,252,255,255,128,128,128,128,128,128],[213,62,250,255,255,128,128,128,128,128,128],[55,93,255,128,128,128,128,128,128,128,128]],[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]]],[[[202,24,213,235,186,191,220,160,240,175,255],[126,38,182,232,169,184,228,174,255,187,128],[61,46,138,219,151,178,240,170,255,216,128]],[[1,112,230,250,199,191,247,159,255,255,128],[166,109,228,252,211,215,255,174,128,128,128],[39,77,162,232,172,180,245,178,255,255,128]],[[1,52,220,246,198,199,249,220,255,255,128],[124,74,191,243,183,193,250,221,255,255,128],[24,71,130,219,154,170,243,182,255,255,128]],[[1,182,225,249,219,240,255,224,128,128,128],[149,150,226,252,216,205,255,171,128,128,128],[28,108,170,242,183,194,254,223,255,255,128]],[[1,81,230,252,204,203,255,192,128,128,128],[123,102,209,247,188,196,255,233,128,128,128],[20,95,153,243,164,173,255,203,128,128,128]],[[1,222,248,255,216,213,128,128,128,128,128],[168,175,246,252,235,205,255,255,128,128,128],[47,116,215,255,211,212,255,255,128,128,128]],[[1,121,236,253,212,214,255,255,128,128,128],[141,84,213,252,201,202,255,219,128,128,128],[42,80,160,240,162,185,255,205,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[244,1,255,128,128,128,128,128,128,128,128],[238,1,255,128,128,128,128,128,128,128,128]]]],ci=[[[231,120,48,89,115,113,120,152,112],[152,179,64,126,170,118,46,70,95],[175,69,143,80,85,82,72,155,103],[56,58,10,171,218,189,17,13,152],[114,26,17,163,44,195,21,10,173],[121,24,80,195,26,62,44,64,85],[144,71,10,38,171,213,144,34,26],[170,46,55,19,136,160,33,206,71],[63,20,8,114,114,208,12,9,226],[81,40,11,96,182,84,29,16,36]],[[134,183,89,137,98,101,106,165,148],[72,187,100,130,157,111,32,75,80],[66,102,167,99,74,62,40,234,128],[41,53,9,178,241,141,26,8,107],[74,43,26,146,73,166,49,23,157],[65,38,105,160,51,52,31,115,128],[104,79,12,27,217,255,87,17,7],[87,68,71,44,114,51,15,186,23],[47,41,14,110,182,183,21,17,194],[66,45,25,102,197,189,23,18,22]],[[88,88,147,150,42,46,45,196,205],[43,97,183,117,85,38,35,179,61],[39,53,200,87,26,21,43,232,171],[56,34,51,104,114,102,29,93,77],[39,28,85,171,58,165,90,98,64],[34,22,116,206,23,34,43,166,73],[107,54,32,26,51,1,81,43,31],[68,25,106,22,64,171,36,225,114],[34,19,21,102,132,188,16,76,124],[62,18,78,95,85,57,50,48,51]],[[193,101,35,159,215,111,89,46,111],[60,148,31,172,219,228,21,18,111],[112,113,77,85,179,255,38,120,114],[40,42,1,196,245,209,10,25,109],[88,43,29,140,166,213,37,43,154],[61,63,30,155,67,45,68,1,209],[100,80,8,43,154,1,51,26,71],[142,78,78,16,255,128,34,197,171],[41,40,5,102,211,183,4,1,221],[51,50,17,168,209,192,23,25,82]],[[138,31,36,171,27,166,38,44,229],[67,87,58,169,82,115,26,59,179],[63,59,90,180,59,166,93,73,154],[40,40,21,116,143,209,34,39,175],[47,15,16,183,34,223,49,45,183],[46,17,33,183,6,98,15,32,183],[57,46,22,24,128,1,54,17,37],[65,32,73,115,28,128,23,128,205],[40,3,9,115,51,192,18,6,223],[87,37,9,115,59,77,64,21,47]],[[104,55,44,218,9,54,53,130,226],[64,90,70,205,40,41,23,26,57],[54,57,112,184,5,41,38,166,213],[30,34,26,133,152,116,10,32,134],[39,19,53,221,26,114,32,73,255],[31,9,65,234,2,15,1,118,73],[75,32,12,51,192,255,160,43,51],[88,31,35,67,102,85,55,186,85],[56,21,23,111,59,205,45,37,192],[55,38,70,124,73,102,1,34,98]],[[125,98,42,88,104,85,117,175,82],[95,84,53,89,128,100,113,101,45],[75,79,123,47,51,128,81,171,1],[57,17,5,71,102,57,53,41,49],[38,33,13,121,57,73,26,1,85],[41,10,67,138,77,110,90,47,114],[115,21,2,10,102,255,166,23,6],[101,29,16,10,85,128,101,196,26],[57,18,10,102,102,213,34,20,43],[117,20,15,36,163,128,68,1,26]],[[102,61,71,37,34,53,31,243,192],[69,60,71,38,73,119,28,222,37],[68,45,128,34,1,47,11,245,171],[62,17,19,70,146,85,55,62,70],[37,43,37,154,100,163,85,160,1],[63,9,92,136,28,64,32,201,85],[75,15,9,9,64,255,184,119,16],[86,6,28,5,64,255,25,248,1],[56,8,17,132,137,255,55,116,128],[58,15,20,82,135,57,26,121,40]],[[164,50,31,137,154,133,25,35,218],[51,103,44,131,131,123,31,6,158],[86,40,64,135,148,224,45,183,128],[22,26,17,131,240,154,14,1,209],[45,16,21,91,64,222,7,1,197],[56,21,39,155,60,138,23,102,213],[83,12,13,54,192,255,68,47,28],[85,26,85,85,128,128,32,146,171],[18,11,7,63,144,171,4,4,246],[35,27,10,146,174,171,12,26,128]],[[190,80,35,99,180,80,126,54,45],[85,126,47,87,176,51,41,20,32],[101,75,128,139,118,146,116,128,85],[56,41,15,176,236,85,37,9,62],[71,30,17,119,118,255,17,18,138],[101,38,60,138,55,70,43,26,142],[146,36,19,30,171,255,97,27,20],[138,45,61,62,219,1,81,188,64],[32,41,20,117,151,142,20,21,163],[112,19,12,61,195,128,48,4,24]]],ui=[[[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[176,246,255,255,255,255,255,255,255,255,255],[223,241,252,255,255,255,255,255,255,255,255],[249,253,253,255,255,255,255,255,255,255,255]],[[255,244,252,255,255,255,255,255,255,255,255],[234,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255]],[[255,246,254,255,255,255,255,255,255,255,255],[239,253,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[251,255,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[251,254,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,254,253,255,254,255,255,255,255,255,255],[250,255,254,255,254,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[217,255,255,255,255,255,255,255,255,255,255],[225,252,241,253,255,255,254,255,255,255,255],[234,250,241,250,253,255,253,254,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[223,254,254,255,255,255,255,255,255,255,255],[238,253,254,254,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[249,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,255,255,255,255,255,255,255,255,255],[247,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[252,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[186,251,250,255,255,255,255,255,255,255,255],[234,251,244,254,255,255,255,255,255,255,255],[251,251,243,253,254,255,254,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[236,253,254,255,255,255,255,255,255,255,255],[251,253,253,254,254,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[254,254,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[254,254,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[248,255,255,255,255,255,255,255,255,255,255],[250,254,252,254,255,255,255,255,255,255,255],[248,254,249,253,255,255,255,255,255,255,255]],[[255,253,253,255,255,255,255,255,255,255,255],[246,253,253,255,255,255,255,255,255,255,255],[252,254,251,254,254,255,255,255,255,255,255]],[[255,254,252,255,255,255,255,255,255,255,255],[248,254,253,255,255,255,255,255,255,255,255],[253,255,254,254,255,255,255,255,255,255,255]],[[255,251,254,255,255,255,255,255,255,255,255],[245,251,254,255,255,255,255,255,255,255,255],[253,253,254,255,255,255,255,255,255,255,255]],[[255,251,253,255,255,255,255,255,255,255,255],[252,253,254,255,255,255,255,255,255,255,255],[255,254,255,255,255,255,255,255,255,255,255]],[[255,252,255,255,255,255,255,255,255,255,255],[249,255,254,255,255,255,255,255,255,255,255],[255,255,254,255,255,255,255,255,255,255,255]],[[255,255,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]]],li=[0,1,2,3,6,4,5,6,6,6,6,6,6,6,6,7,0],hi=[],fi=[],di=[],pi=1,gi=2,mi=[],vi=[];vr(\"UpsampleRgbLinePair\",Ar,3),vr(\"UpsampleBgrLinePair\",xr,3),vr(\"UpsampleRgbaLinePair\",Fr,4),vr(\"UpsampleBgraLinePair\",kr,4),vr(\"UpsampleArgbLinePair\",Pr,4),vr(\"UpsampleRgba4444LinePair\",_r,2),vr(\"UpsampleRgb565LinePair\",Sr,2);var bi=t.UpsampleRgbLinePair,yi=t.UpsampleBgrLinePair,wi=t.UpsampleRgbaLinePair,Ni=t.UpsampleBgraLinePair,Li=t.UpsampleArgbLinePair,Ai=t.UpsampleRgba4444LinePair,xi=t.UpsampleRgb565LinePair,Si=16,_i=1<<Si-1,Pi=-227,ki=482,Fi=6,Ii=(256<<Fi)-1,Ci=0,ji=a(256),Oi=a(256),Bi=a(256),Mi=a(256),Ei=a(ki-Pi),qi=a(ki-Pi);Ir(\"YuvToRgbRow\",Ar,3),Ir(\"YuvToBgrRow\",xr,3),Ir(\"YuvToRgbaRow\",Fr,4),Ir(\"YuvToBgraRow\",kr,4),Ir(\"YuvToArgbRow\",Pr,4),Ir(\"YuvToRgba4444Row\",_r,2),Ir(\"YuvToRgb565Row\",Sr,2);var Di=[0,4,8,12,128,132,136,140,256,260,264,268,384,388,392,396],Ri=[0,2,8],Ti=[8,7,6,4,4,2,2,2,1,1,1,1],Ui=1;this.WebPDecodeRGBA=function(t,r,n,i,a){var o=qn,s=new rr,c=new ot;s.ba=c,c.S=o,c.width=[c.width],c.height=[c.height];var u=c.width,l=c.height,h=new st;if(null==h||null==t)var f=2;else e(null!=h),f=Br(t,r,n,h.width,h.height,h.Pd,h.Qd,h.format,null);if(0!=f?u=0:(null!=u&&(u[0]=h.width[0]),null!=l&&(l[0]=h.height[0]),u=1),u){c.width=c.width[0],c.height=c.height[0],null!=i&&(i[0]=c.width),null!=a&&(a[0]=c.height);t:{if(i=new Gt,(a=new nr).data=t,a.w=r,a.ha=n,a.kd=1,r=[0],e(null!=a),(0==(t=Br(a.data,a.w,a.ha,null,null,null,r,null,a))||7==t)&&r[0]&&(t=4),0==(r=t)){if(e(null!=s),i.data=a.data,i.w=a.w+a.offset,i.ha=a.ha-a.offset,i.put=dt,i.ac=ft,i.bc=pt,i.ma=s,a.xa){if(null==(t=kt())){s=1;break t}if(function(t,r){var n=[0],i=[0],a=[0];e:for(;;){if(null==t)return 0;if(null==r)return t.a=2,0;if(t.l=r,t.a=0,v(t.m,r.data,r.w,r.ha),!gt(t.m,n,i,a)){t.a=3;break e}if(t.xb=gi,r.width=n[0],r.height=i[0],!Ft(n[0],i[0],1,t,null))break e;return 1}return e(0!=t.a),0}(t,i)){if(i=0==(r=qr(i.width,i.height,s.Oa,s.ba))){e:{i=t;r:for(;;){if(null==i){i=0;break e}if(e(null!=i.s.yc),e(null!=i.s.Ya),e(0<i.s.Wb),e(null!=(n=i.l)),e(null!=(a=n.ma)),0!=i.xb){if(i.ca=a.ba,i.tb=a.tb,e(null!=i.ca),!Mr(a.Oa,n,Rn)){i.a=2;break r}if(!It(i,n.width))break r;if(n.da)break r;if((n.da||nt(i.ca.S))&&mr(),11>i.ca.S||(alert(\"todo:WebPInitConvertARGBToYUV\"),null!=i.ca.f.kb.F&&mr()),i.Pb&&0<i.s.ua&&null==i.s.vb.X&&!O(i.s.vb,i.s.Wa.Xa)){i.a=1;break r}i.xb=0}if(!_t(i,i.V,i.Ba,i.c,i.i,n.o,Lt))break r;a.Dc=i.Ma,i=1;break e}e(0!=i.a),i=0}i=!i}i&&(r=t.a)}else r=t.a}else{if(null==(t=new Yt)){s=1;break t}if(t.Fa=a.na,t.P=a.P,t.qc=a.Sa,Kt(t,i)){if(0==(r=qr(i.width,i.height,s.Oa,s.ba))){if(t.Aa=0,n=s.Oa,e(null!=(a=t)),null!=n){if(0<(u=0>(u=n.Md)?0:100<u?255:255*u/100)){for(l=h=0;4>l;++l)12>(f=a.pb[l]).lc&&(f.ia=u*Ti[0>f.lc?0:f.lc]>>3),h|=f.ia;h&&(alert(\"todo:VP8InitRandom\"),a.ia=1)}a.Ga=n.Id,100<a.Ga?a.Ga=100:0>a.Ga&&(a.Ga=0)}Qt(t,i)||(r=t.a)}}else r=t.a}0==r&&null!=s.Oa&&s.Oa.fd&&(r=Er(s.ba))}s=r}o=0!=s?null:11>o?c.f.RGBA.eb:c.f.kb.y}else o=null;return o};var zi=[3,4,3,4,4,2,2,4,4,4,2,1,1]};function u(t,e){for(var r=\"\",n=0;n<4;n++)r+=String.fromCharCode(t[e++]);return r}function l(t,e){return(t[e+0]<<0|t[e+1]<<8|t[e+2]<<16)>>>0}function h(t,e){return(t[e+0]<<0|t[e+1]<<8|t[e+2]<<16|t[e+3]<<24)>>>0}new c;var f=[0],d=[0],p=[],g=new c,m=t,v=function(t,e){var r={},n=0,i=!1,a=0,o=0;if(r.frames=[],!\n/** @license\n     * Copyright (c) 2017 Dominik Homberger\n    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n    https://webpjs.appspot.com\n    WebPRiffParser dominikhlbg@gmail.com\n    */\nfunction(t,e,r,n){for(var i=0;i<n;i++)if(t[e+i]!=r.charCodeAt(i))return!0;return!1}(t,e,\"RIFF\",4)){for(h(t,e+=4),e+=8;e<t.length;){var s=u(t,e),c=h(t,e+=4);e+=4;var f=c+(1&c);switch(s){case\"VP8 \":case\"VP8L\":void 0===r.frames[n]&&(r.frames[n]={}),(g=r.frames[n]).src_off=i?o:e-8,g.src_size=a+c+8,n++,i&&(i=!1,a=0,o=0);break;case\"VP8X\":(g=r.header={}).feature_flags=t[e];var d=e+4;g.canvas_width=1+l(t,d),d+=3,g.canvas_height=1+l(t,d),d+=3;break;case\"ALPH\":i=!0,a=f+8,o=e-8;break;case\"ANIM\":(g=r.header).bgcolor=h(t,e),d=e+4,g.loop_count=(m=t)[(v=d)+0]<<0|m[v+1]<<8,d+=2;break;case\"ANMF\":var p,g;(g=r.frames[n]={}).offset_x=2*l(t,e),e+=3,g.offset_y=2*l(t,e),e+=3,g.width=1+l(t,e),e+=3,g.height=1+l(t,e),e+=3,g.duration=l(t,e),e+=3,p=t[e++],g.dispose=1&p,g.blend=p>>1&1}\"ANMF\"!=s&&(e+=f)}var m,v;return r}}(m,0);v.response=m,v.rgbaoutput=!0,v.dataurl=!1;var b=v.header?v.header:null,y=v.frames?v.frames:null;if(b){b.loop_counter=b.loop_count,f=[b.canvas_height],d=[b.canvas_width];for(var w=0;w<y.length&&0!=y[w].blend;w++);}var N=y[0],L=g.WebPDecodeRGBA(m,N.src_off,N.src_size,d,f);N.rgba=L,N.imgwidth=d[0],N.imgheight=f[0];for(var A=0;A<d[0]*f[0]*4;A++)p[A]=L[A];return this.width=d,this.height=f,this.data=p,this}!function(t){var e=function(){return!0},r=function(e,r,i,u){var l=4,h=o;switch(u){case t.image_compression.FAST:l=1,h=a;break;case t.image_compression.MEDIUM:l=6,h=s;break;case t.image_compression.SLOW:l=9,h=c}var f=Ie(e=n(e,r,i,h),{level:l});return t.__addimage__.arrayBufferToBinaryString(f)},n=function(t,e,r,n){for(var i,a,o,s=t.length/e,c=new Uint8Array(t.length+s),u=l(),f=0;f<s;f+=1){if(o=f*e,i=t.subarray(o,o+e),n)c.set(n(i,r,a),o+f);else{for(var d,p=u.length,g=[];d<p;d+=1)g[d]=u[d](i,r,a);var m=h(g.concat());c.set(g[m],o+f)}a=i}return c},i=function(t){var e=Array.apply([],t);return e.unshift(0),e},a=function(t,e){var r,n=[],i=t.length;n[0]=1;for(var a=0;a<i;a+=1)r=t[a-e]||0,n[a+1]=t[a]-r+256&255;return n},o=function(t,e,r){var n,i=[],a=t.length;i[0]=2;for(var o=0;o<a;o+=1)n=r&&r[o]||0,i[o+1]=t[o]-n+256&255;return i},s=function(t,e,r){var n,i,a=[],o=t.length;a[0]=3;for(var s=0;s<o;s+=1)n=t[s-e]||0,i=r&&r[s]||0,a[s+1]=t[s]+256-(n+i>>>1)&255;return a},c=function(t,e,r){var n,i,a,o,s=[],c=t.length;s[0]=4;for(var l=0;l<c;l+=1)n=t[l-e]||0,i=r&&r[l]||0,a=r&&r[l-e]||0,o=u(n,i,a),s[l+1]=t[l]-o+256&255;return s},u=function(t,e,r){if(t===e&&e===r)return t;var n=Math.abs(e-r),i=Math.abs(t-r),a=Math.abs(t+e-r-r);return n<=i&&n<=a?t:i<=a?e:r},l=function(){return[i,a,o,s,c]},h=function(t){var e=t.map((function(t){return t.reduce((function(t,e){return t+Math.abs(e)}),0)}));return e.indexOf(Math.min.apply(null,e))};t.processPNG=function(n,i,a,o){var s,c,u,l,h,f,d,p,g,m,v,b,y,w,N,L=this.decode.FLATE_DECODE,A=\"\";if(this.__addimage__.isArrayBuffer(n)&&(n=new Uint8Array(n)),this.__addimage__.isArrayBufferView(n)){if(n=(u=new De(n)).imgData,c=u.bits,s=u.colorSpace,h=u.colors,-1!==[4,6].indexOf(u.colorType)){if(8===u.bits){g=(p=32==u.pixelBitlength?new Uint32Array(u.decodePixels().buffer):16==u.pixelBitlength?new Uint16Array(u.decodePixels().buffer):new Uint8Array(u.decodePixels().buffer)).length,v=new Uint8Array(g*u.colors),m=new Uint8Array(g);var x,S=u.pixelBitlength-u.bits;for(w=0,N=0;w<g;w++){for(y=p[w],x=0;x<S;)v[N++]=y>>>x&255,x+=u.bits;m[w]=y>>>x&255}}if(16===u.bits){g=(p=new Uint32Array(u.decodePixels().buffer)).length,v=new Uint8Array(g*(32/u.pixelBitlength)*u.colors),m=new Uint8Array(g*(32/u.pixelBitlength)),b=u.colors>1,w=0,N=0;for(var _=0;w<g;)y=p[w++],v[N++]=y>>>0&255,b&&(v[N++]=y>>>16&255,y=p[w++],v[N++]=y>>>0&255),m[_++]=y>>>16&255;c=8}o!==t.image_compression.NONE&&e()?(n=r(v,u.width*u.colors,u.colors,o),d=r(m,u.width,1,o)):(n=v,d=m,L=void 0)}if(3===u.colorType&&(s=this.color_spaces.INDEXED,f=u.palette,u.transparency.indexed)){var P=u.transparency.indexed,k=0;for(w=0,g=P.length;w<g;++w)k+=P[w];if((k/=255)===g-1&&-1!==P.indexOf(0))l=[P.indexOf(0)];else if(k!==g){for(p=u.decodePixels(),m=new Uint8Array(p.length),w=0,g=p.length;w<g;w++)m[w]=P[p[w]];d=r(m,u.width,1)}}var F=function(e){var r;switch(e){case t.image_compression.FAST:r=11;break;case t.image_compression.MEDIUM:r=13;break;case t.image_compression.SLOW:r=14;break;default:r=12}return r}(o);return L===this.decode.FLATE_DECODE&&(A=\"/Predictor \"+F+\" \"),A+=\"/Colors \"+h+\" /BitsPerComponent \"+c+\" /Columns \"+u.width,(this.__addimage__.isArrayBuffer(n)||this.__addimage__.isArrayBufferView(n))&&(n=this.__addimage__.arrayBufferToBinaryString(n)),(d&&this.__addimage__.isArrayBuffer(d)||this.__addimage__.isArrayBufferView(d))&&(d=this.__addimage__.arrayBufferToBinaryString(d)),{alias:a,data:n,index:i,filter:L,decodeParameters:A,transparency:l,palette:f,sMask:d,predictor:F,width:u.width,height:u.height,bitsPerComponent:c,colorSpace:s}}}}(M.API),function(t){t.processGIF89A=function(e,r,n,i){var a=new Re(e),o=a.width,s=a.height,c=[];a.decodeAndBlitFrameRGBA(0,c);var u={data:c,width:o,height:s},l=new Ue(100).encode(u,100);return t.processJPEG.call(this,l,r,n,i)},t.processGIF87A=t.processGIF89A}(M.API),ze.prototype.parseHeader=function(){if(this.fileSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.reserved=this.datav.getUint32(this.pos,!0),this.pos+=4,this.offset=this.datav.getUint32(this.pos,!0),this.pos+=4,this.headerSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.width=this.datav.getUint32(this.pos,!0),this.pos+=4,this.height=this.datav.getInt32(this.pos,!0),this.pos+=4,this.planes=this.datav.getUint16(this.pos,!0),this.pos+=2,this.bitPP=this.datav.getUint16(this.pos,!0),this.pos+=2,this.compress=this.datav.getUint32(this.pos,!0),this.pos+=4,this.rawSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.hr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.vr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.colors=this.datav.getUint32(this.pos,!0),this.pos+=4,this.importantColors=this.datav.getUint32(this.pos,!0),this.pos+=4,16===this.bitPP&&this.is_with_alpha&&(this.bitPP=15),this.bitPP<15){var t=0===this.colors?1<<this.bitPP:this.colors;this.palette=new Array(t);for(var e=0;e<t;e++){var r=this.datav.getUint8(this.pos++,!0),n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0);this.palette[e]={red:i,green:n,blue:r,quad:a}}}this.height<0&&(this.height*=-1,this.bottom_up=!1)},ze.prototype.parseBGR=function(){this.pos=this.offset;try{var t=\"bit\"+this.bitPP,e=this.width*this.height*4;this.data=new Uint8Array(e),this[t]()}catch(t){i.log(\"bit decode error:\"+t)}},ze.prototype.bit1=function(){var t,e=Math.ceil(this.width/8),r=e%4;for(t=this.height-1;t>=0;t--){for(var n=this.bottom_up?t:this.height-1-t,i=0;i<e;i++)for(var a=this.datav.getUint8(this.pos++,!0),o=n*this.width*4+8*i*4,s=0;s<8&&8*i+s<this.width;s++){var c=this.palette[a>>7-s&1];this.data[o+4*s]=c.blue,this.data[o+4*s+1]=c.green,this.data[o+4*s+2]=c.red,this.data[o+4*s+3]=255}0!==r&&(this.pos+=4-r)}},ze.prototype.bit4=function(){for(var t=Math.ceil(this.width/2),e=t%4,r=this.height-1;r>=0;r--){for(var n=this.bottom_up?r:this.height-1-r,i=0;i<t;i++){var a=this.datav.getUint8(this.pos++,!0),o=n*this.width*4+2*i*4,s=a>>4,c=15&a,u=this.palette[s];if(this.data[o]=u.blue,this.data[o+1]=u.green,this.data[o+2]=u.red,this.data[o+3]=255,2*i+1>=this.width)break;u=this.palette[c],this.data[o+4]=u.blue,this.data[o+4+1]=u.green,this.data[o+4+2]=u.red,this.data[o+4+3]=255}0!==e&&(this.pos+=4-e)}},ze.prototype.bit8=function(){for(var t=this.width%4,e=this.height-1;e>=0;e--){for(var r=this.bottom_up?e:this.height-1-e,n=0;n<this.width;n++){var i=this.datav.getUint8(this.pos++,!0),a=r*this.width*4+4*n;if(i<this.palette.length){var o=this.palette[i];this.data[a]=o.red,this.data[a+1]=o.green,this.data[a+2]=o.blue,this.data[a+3]=255}else this.data[a]=255,this.data[a+1]=255,this.data[a+2]=255,this.data[a+3]=255}0!==t&&(this.pos+=4-t)}},ze.prototype.bit15=function(){for(var t=this.width%3,e=parseInt(\"11111\",2),r=this.height-1;r>=0;r--){for(var n=this.bottom_up?r:this.height-1-r,i=0;i<this.width;i++){var a=this.datav.getUint16(this.pos,!0);this.pos+=2;var o=(a&e)/e*255|0,s=(a>>5&e)/e*255|0,c=(a>>10&e)/e*255|0,u=a>>15?255:0,l=n*this.width*4+4*i;this.data[l]=c,this.data[l+1]=s,this.data[l+2]=o,this.data[l+3]=u}this.pos+=t}},ze.prototype.bit16=function(){for(var t=this.width%3,e=parseInt(\"11111\",2),r=parseInt(\"111111\",2),n=this.height-1;n>=0;n--){for(var i=this.bottom_up?n:this.height-1-n,a=0;a<this.width;a++){var o=this.datav.getUint16(this.pos,!0);this.pos+=2;var s=(o&e)/e*255|0,c=(o>>5&r)/r*255|0,u=(o>>11)/e*255|0,l=i*this.width*4+4*a;this.data[l]=u,this.data[l+1]=c,this.data[l+2]=s,this.data[l+3]=255}this.pos+=t}},ze.prototype.bit24=function(){for(var t=this.height-1;t>=0;t--){for(var e=this.bottom_up?t:this.height-1-t,r=0;r<this.width;r++){var n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),o=e*this.width*4+4*r;this.data[o]=a,this.data[o+1]=i,this.data[o+2]=n,this.data[o+3]=255}this.pos+=this.width%4}},ze.prototype.bit32=function(){for(var t=this.height-1;t>=0;t--)for(var e=this.bottom_up?t:this.height-1-t,r=0;r<this.width;r++){var n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),o=this.datav.getUint8(this.pos++,!0),s=e*this.width*4+4*r;this.data[s]=a,this.data[s+1]=i,this.data[s+2]=n,this.data[s+3]=o}},ze.prototype.getData=function(){return this.data},\n/**\n   * @license\n   * Copyright (c) 2018 Aras Abbasi\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){t.processBMP=function(e,r,n,i){var a=new ze(e,!1),o=a.width,s=a.height,c={data:a.getData(),width:o,height:s},u=new Ue(100).encode(c,100);return t.processJPEG.call(this,u,r,n,i)}}(M.API),He.prototype.getData=function(){return this.data},\n/**\n   * @license\n   * Copyright (c) 2019 Aras Abbasi\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){t.processWEBP=function(e,r,n,i){var a=new He(e),o=a.width,s=a.height,c={data:a.getData(),width:o,height:s},u=new Ue(100).encode(c,100);return t.processJPEG.call(this,u,r,n,i)}}(M.API),\n/**\n   * @license\n   *\n   * Copyright (c) 2021 Antti Palola, https://github.com/Pantura\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining\n   * a copy of this software and associated documentation files (the\n   * \"Software\"), to deal in the Software without restriction, including\n   * without limitation the rights to use, copy, modify, merge, publish,\n   * distribute, sublicense, and/or sell copies of the Software, and to\n   * permit persons to whom the Software is furnished to do so, subject to\n   * the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be\n   * included in all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n   * ====================================================================\n   */\nfunction(t){t.processRGBA=function(t,e,r){for(var n=t.data,i=n.length,a=new Uint8Array(i/4*3),o=new Uint8Array(i/4),s=0,c=0,u=0;u<i;u+=4){var l=n[u],h=n[u+1],f=n[u+2],d=n[u+3];a[s++]=l,a[s++]=h,a[s++]=f,o[c++]=d}var p=this.__addimage__.arrayBufferToBinaryString(a);return{alpha:this.__addimage__.arrayBufferToBinaryString(o),data:p,index:e,alias:r,colorSpace:\"DeviceRGB\",bitsPerComponent:8,width:t.width,height:t.height}}}(M.API),\n/**\n   * @license\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){t.setLanguage=function(t){return void 0===this.internal.languageSettings&&(this.internal.languageSettings={},this.internal.languageSettings.isSubscribed=!1),void 0!=={af:\"Afrikaans\",sq:\"Albanian\",ar:\"Arabic (Standard)\",\"ar-DZ\":\"Arabic (Algeria)\",\"ar-BH\":\"Arabic (Bahrain)\",\"ar-EG\":\"Arabic (Egypt)\",\"ar-IQ\":\"Arabic (Iraq)\",\"ar-JO\":\"Arabic (Jordan)\",\"ar-KW\":\"Arabic (Kuwait)\",\"ar-LB\":\"Arabic (Lebanon)\",\"ar-LY\":\"Arabic (Libya)\",\"ar-MA\":\"Arabic (Morocco)\",\"ar-OM\":\"Arabic (Oman)\",\"ar-QA\":\"Arabic (Qatar)\",\"ar-SA\":\"Arabic (Saudi Arabia)\",\"ar-SY\":\"Arabic (Syria)\",\"ar-TN\":\"Arabic (Tunisia)\",\"ar-AE\":\"Arabic (U.A.E.)\",\"ar-YE\":\"Arabic (Yemen)\",an:\"Aragonese\",hy:\"Armenian\",as:\"Assamese\",ast:\"Asturian\",az:\"Azerbaijani\",eu:\"Basque\",be:\"Belarusian\",bn:\"Bengali\",bs:\"Bosnian\",br:\"Breton\",bg:\"Bulgarian\",my:\"Burmese\",ca:\"Catalan\",ch:\"Chamorro\",ce:\"Chechen\",zh:\"Chinese\",\"zh-HK\":\"Chinese (Hong Kong)\",\"zh-CN\":\"Chinese (PRC)\",\"zh-SG\":\"Chinese (Singapore)\",\"zh-TW\":\"Chinese (Taiwan)\",cv:\"Chuvash\",co:\"Corsican\",cr:\"Cree\",hr:\"Croatian\",cs:\"Czech\",da:\"Danish\",nl:\"Dutch (Standard)\",\"nl-BE\":\"Dutch (Belgian)\",en:\"English\",\"en-AU\":\"English (Australia)\",\"en-BZ\":\"English (Belize)\",\"en-CA\":\"English (Canada)\",\"en-IE\":\"English (Ireland)\",\"en-JM\":\"English (Jamaica)\",\"en-NZ\":\"English (New Zealand)\",\"en-PH\":\"English (Philippines)\",\"en-ZA\":\"English (South Africa)\",\"en-TT\":\"English (Trinidad & Tobago)\",\"en-GB\":\"English (United Kingdom)\",\"en-US\":\"English (United States)\",\"en-ZW\":\"English (Zimbabwe)\",eo:\"Esperanto\",et:\"Estonian\",fo:\"Faeroese\",fj:\"Fijian\",fi:\"Finnish\",fr:\"French (Standard)\",\"fr-BE\":\"French (Belgium)\",\"fr-CA\":\"French (Canada)\",\"fr-FR\":\"French (France)\",\"fr-LU\":\"French (Luxembourg)\",\"fr-MC\":\"French (Monaco)\",\"fr-CH\":\"French (Switzerland)\",fy:\"Frisian\",fur:\"Friulian\",gd:\"Gaelic (Scots)\",\"gd-IE\":\"Gaelic (Irish)\",gl:\"Galacian\",ka:\"Georgian\",de:\"German (Standard)\",\"de-AT\":\"German (Austria)\",\"de-DE\":\"German (Germany)\",\"de-LI\":\"German (Liechtenstein)\",\"de-LU\":\"German (Luxembourg)\",\"de-CH\":\"German (Switzerland)\",el:\"Greek\",gu:\"Gujurati\",ht:\"Haitian\",he:\"Hebrew\",hi:\"Hindi\",hu:\"Hungarian\",is:\"Icelandic\",id:\"Indonesian\",iu:\"Inuktitut\",ga:\"Irish\",it:\"Italian (Standard)\",\"it-CH\":\"Italian (Switzerland)\",ja:\"Japanese\",kn:\"Kannada\",ks:\"Kashmiri\",kk:\"Kazakh\",km:\"Khmer\",ky:\"Kirghiz\",tlh:\"Klingon\",ko:\"Korean\",\"ko-KP\":\"Korean (North Korea)\",\"ko-KR\":\"Korean (South Korea)\",la:\"Latin\",lv:\"Latvian\",lt:\"Lithuanian\",lb:\"Luxembourgish\",mk:\"North Macedonia\",ms:\"Malay\",ml:\"Malayalam\",mt:\"Maltese\",mi:\"Maori\",mr:\"Marathi\",mo:\"Moldavian\",nv:\"Navajo\",ng:\"Ndonga\",ne:\"Nepali\",no:\"Norwegian\",nb:\"Norwegian (Bokmal)\",nn:\"Norwegian (Nynorsk)\",oc:\"Occitan\",or:\"Oriya\",om:\"Oromo\",fa:\"Persian\",\"fa-IR\":\"Persian/Iran\",pl:\"Polish\",pt:\"Portuguese\",\"pt-BR\":\"Portuguese (Brazil)\",pa:\"Punjabi\",\"pa-IN\":\"Punjabi (India)\",\"pa-PK\":\"Punjabi (Pakistan)\",qu:\"Quechua\",rm:\"Rhaeto-Romanic\",ro:\"Romanian\",\"ro-MO\":\"Romanian (Moldavia)\",ru:\"Russian\",\"ru-MO\":\"Russian (Moldavia)\",sz:\"Sami (Lappish)\",sg:\"Sango\",sa:\"Sanskrit\",sc:\"Sardinian\",sd:\"Sindhi\",si:\"Singhalese\",sr:\"Serbian\",sk:\"Slovak\",sl:\"Slovenian\",so:\"Somani\",sb:\"Sorbian\",es:\"Spanish\",\"es-AR\":\"Spanish (Argentina)\",\"es-BO\":\"Spanish (Bolivia)\",\"es-CL\":\"Spanish (Chile)\",\"es-CO\":\"Spanish (Colombia)\",\"es-CR\":\"Spanish (Costa Rica)\",\"es-DO\":\"Spanish (Dominican Republic)\",\"es-EC\":\"Spanish (Ecuador)\",\"es-SV\":\"Spanish (El Salvador)\",\"es-GT\":\"Spanish (Guatemala)\",\"es-HN\":\"Spanish (Honduras)\",\"es-MX\":\"Spanish (Mexico)\",\"es-NI\":\"Spanish (Nicaragua)\",\"es-PA\":\"Spanish (Panama)\",\"es-PY\":\"Spanish (Paraguay)\",\"es-PE\":\"Spanish (Peru)\",\"es-PR\":\"Spanish (Puerto Rico)\",\"es-ES\":\"Spanish (Spain)\",\"es-UY\":\"Spanish (Uruguay)\",\"es-VE\":\"Spanish (Venezuela)\",sx:\"Sutu\",sw:\"Swahili\",sv:\"Swedish\",\"sv-FI\":\"Swedish (Finland)\",\"sv-SV\":\"Swedish (Sweden)\",ta:\"Tamil\",tt:\"Tatar\",te:\"Teluga\",th:\"Thai\",tig:\"Tigre\",ts:\"Tsonga\",tn:\"Tswana\",tr:\"Turkish\",tk:\"Turkmen\",uk:\"Ukrainian\",hsb:\"Upper Sorbian\",ur:\"Urdu\",ve:\"Venda\",vi:\"Vietnamese\",vo:\"Volapuk\",wa:\"Walloon\",cy:\"Welsh\",xh:\"Xhosa\",ji:\"Yiddish\",zu:\"Zulu\"}[t]&&(this.internal.languageSettings.languageCode=t,!1===this.internal.languageSettings.isSubscribed&&(this.internal.events.subscribe(\"putCatalog\",(function(){this.internal.write(\"/Lang (\"+this.internal.languageSettings.languageCode+\")\")})),this.internal.languageSettings.isSubscribed=!0)),this}}(M.API),Oe=M.API,Be=Oe.getCharWidthsArray=function(t,r){var n,i,a=(r=r||{}).font||this.internal.getFont(),o=r.fontSize||this.internal.getFontSize(),s=r.charSpace||this.internal.getCharSpace(),c=r.widths?r.widths:a.metadata.Unicode.widths,u=c.fof?c.fof:1,l=r.kerning?r.kerning:a.metadata.Unicode.kerning,h=l.fof?l.fof:1,f=!1!==r.doKerning,d=0,p=t.length,g=0,m=c[0]||u,v=[];for(n=0;n<p;n++)i=t.charCodeAt(n),\"function\"==typeof a.metadata.widthOfString?v.push((a.metadata.widthOfGlyph(a.metadata.characterToGlyph(i))+s*(1e3/o)||0)/1e3):(d=f&&\"object\"===e(l[i])&&!isNaN(parseInt(l[i][g],10))?l[i][g]/h:0,v.push((c[i]||m)/u+d)),g=i;return v},Me=Oe.getStringUnitWidth=function(t,e){var r=(e=e||{}).fontSize||this.internal.getFontSize(),n=e.font||this.internal.getFont(),i=e.charSpace||this.internal.getCharSpace();return Oe.processArabic&&(t=Oe.processArabic(t)),\"function\"==typeof n.metadata.widthOfString?n.metadata.widthOfString(t,r,i)/r:Be.apply(this,arguments).reduce((function(t,e){return t+e}),0)},Ee=function(t,e,r,n){for(var i=[],a=0,o=t.length,s=0;a!==o&&s+e[a]<r;)s+=e[a],a++;i.push(t.slice(0,a));var c=a;for(s=0;a!==o;)s+e[a]>n&&(i.push(t.slice(c,a)),s=0,c=a),s+=e[a],a++;return c!==a&&i.push(t.slice(c,a)),i},qe=function(t,e,r){r||(r={});var n,i,a,o,s,c,u,l=[],h=[l],f=r.textIndent||0,d=0,p=0,g=t.split(\" \"),m=Be.apply(this,[\" \",r])[0];if(c=-1===r.lineIndent?g[0].length+2:r.lineIndent||0){var v=Array(c).join(\" \"),b=[];g.map((function(t){(t=t.split(/\\s*\\n/)).length>1?b=b.concat(t.map((function(t,e){return(e&&t.length?\"\\n\":\"\")+t}))):b.push(t[0])})),g=b,c=Me.apply(this,[v,r])}for(a=0,o=g.length;a<o;a++){var y=0;if(n=g[a],c&&\"\\n\"==n[0]&&(n=n.substr(1),y=1),f+d+(p=(i=Be.apply(this,[n,r])).reduce((function(t,e){return t+e}),0))>e||y){if(p>e){for(s=Ee.apply(this,[n,i,e-(f+d),e]),l.push(s.shift()),l=[s.pop()];s.length;)h.push([s.shift()]);p=i.slice(n.length-(l[0]?l[0].length:0)).reduce((function(t,e){return t+e}),0)}else l=[n];h.push(l),f=p+c,d=m}else l.push(n),f+=d+p,d=m}return u=c?function(t,e){return(e?v:\"\")+t.join(\" \")}:function(t){return t.join(\" \")},h.map(u)},Oe.splitTextToSize=function(t,e,r){var n,i=(r=r||{}).fontSize||this.internal.getFontSize(),a=function(t){if(t.widths&&t.kerning)return{widths:t.widths,kerning:t.kerning};var e=this.internal.getFont(t.fontName,t.fontStyle);return e.metadata.Unicode?{widths:e.metadata.Unicode.widths||{0:1},kerning:e.metadata.Unicode.kerning||{}}:{font:e.metadata,fontSize:this.internal.getFontSize(),charSpace:this.internal.getCharSpace()}}.call(this,r);n=Array.isArray(t)?t:String(t).split(/\\r?\\n/);var o=1*this.internal.scaleFactor*e/i;a.textIndent=r.textIndent?1*r.textIndent*this.internal.scaleFactor/i:0,a.lineIndent=r.lineIndent;var s,c,u=[];for(s=0,c=n.length;s<c;s++)u=u.concat(qe.apply(this,[n[s],o,a]));return u},function(t){t.__fontmetrics__=t.__fontmetrics__||{};for(var r=\"klmnopqrstuvwxyz\",n={},i={},a=0;a<r.length;a++)n[r[a]]=\"0123456789abcdef\"[a],i[\"0123456789abcdef\"[a]]=r[a];var o=function(t){return\"0x\"+parseInt(t,10).toString(16)},s=t.__fontmetrics__.compress=function(t){var r,n,a,c,u=[\"{\"];for(var l in t){if(r=t[l],isNaN(parseInt(l,10))?n=\"'\"+l+\"'\":(l=parseInt(l,10),n=(n=o(l).slice(2)).slice(0,-1)+i[n.slice(-1)]),\"number\"==typeof r)r<0?(a=o(r).slice(3),c=\"-\"):(a=o(r).slice(2),c=\"\"),a=c+a.slice(0,-1)+i[a.slice(-1)];else{if(\"object\"!==e(r))throw new Error(\"Don't know what to do with value type \"+e(r)+\".\");a=s(r)}u.push(n+a)}return u.push(\"}\"),u.join(\"\")},c=t.__fontmetrics__.uncompress=function(t){if(\"string\"!=typeof t)throw new Error(\"Invalid argument passed to uncompress.\");for(var e,r,i,a,o={},s=1,c=o,u=[],l=\"\",h=\"\",f=t.length-1,d=1;d<f;d+=1)\"'\"==(a=t[d])?e?(i=e.join(\"\"),e=void 0):e=[]:e?e.push(a):\"{\"==a?(u.push([c,i]),c={},i=void 0):\"}\"==a?((r=u.pop())[0][r[1]]=c,i=void 0,c=r[0]):\"-\"==a?s=-1:void 0===i?n.hasOwnProperty(a)?(l+=n[a],i=parseInt(l,16)*s,s=1,l=\"\"):l+=a:n.hasOwnProperty(a)?(h+=n[a],c[i]=parseInt(h,16)*s,s=1,i=void 0,h=\"\"):h+=a;return o},u={codePages:[\"WinAnsiEncoding\"],WinAnsiEncoding:c(\"{19m8n201n9q201o9r201s9l201t9m201u8m201w9n201x9o201y8o202k8q202l8r202m9p202q8p20aw8k203k8t203t8v203u9v2cq8s212m9t15m8w15n9w2dw9s16k8u16l9u17s9z17x8y17y9y}\")},l={Unicode:{Courier:u,\"Courier-Bold\":u,\"Courier-BoldOblique\":u,\"Courier-Oblique\":u,Helvetica:u,\"Helvetica-Bold\":u,\"Helvetica-BoldOblique\":u,\"Helvetica-Oblique\":u,\"Times-Roman\":u,\"Times-Bold\":u,\"Times-BoldItalic\":u,\"Times-Italic\":u}},h={Unicode:{\"Courier-Oblique\":c(\"{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}\"),\"Times-BoldItalic\":c(\"{'widths'{k3o2q4ycx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2r202m2n2n3m2o3m2p5n202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5n4l4m4m4m4n4m4o4s4p4m4q4m4r4s4s4y4t2r4u3m4v4m4w3x4x5t4y4s4z4s5k3x5l4s5m4m5n3r5o3x5p4s5q4m5r5t5s4m5t3x5u3x5v2l5w1w5x2l5y3t5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q2l6r3m6s3r6t1w6u1w6v3m6w1w6x4y6y3r6z3m7k3m7l3m7m2r7n2r7o1w7p3r7q2w7r4m7s3m7t2w7u2r7v2n7w1q7x2n7y3t202l3mcl4mal2ram3man3mao3map3mar3mas2lat4uau1uav3maw3way4uaz2lbk2sbl3t'fof'6obo2lbp3tbq3mbr1tbs2lbu1ybv3mbz3mck4m202k3mcm4mcn4mco4mcp4mcq5ycr4mcs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz2w203k6o212m6o2dw2l2cq2l3t3m3u2l17s3x19m3m}'kerning'{cl{4qu5kt5qt5rs17ss5ts}201s{201ss}201t{cks4lscmscnscoscpscls2wu2yu201ts}201x{2wu2yu}2k{201ts}2w{4qx5kx5ou5qx5rs17su5tu}2x{17su5tu5ou}2y{4qx5kx5ou5qx5rs17ss5ts}'fof'-6ofn{17sw5tw5ou5qw5rs}7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qs}3v{17su5tu5os5qs}7p{17su5tu}ck{4qu5kt5qt5rs17ss5ts}4l{4qu5kt5qt5rs17ss5ts}cm{4qu5kt5qt5rs17ss5ts}cn{4qu5kt5qt5rs17ss5ts}co{4qu5kt5qt5rs17ss5ts}cp{4qu5kt5qt5rs17ss5ts}6l{4qu5ou5qw5rt17su5tu}5q{ckuclucmucnucoucpu4lu}5r{ckuclucmucnucoucpu4lu}7q{cksclscmscnscoscps4ls}6p{4qu5ou5qw5rt17sw5tw}ek{4qu5ou5qw5rt17su5tu}el{4qu5ou5qw5rt17su5tu}em{4qu5ou5qw5rt17su5tu}en{4qu5ou5qw5rt17su5tu}eo{4qu5ou5qw5rt17su5tu}ep{4qu5ou5qw5rt17su5tu}es{17ss5ts5qs4qu}et{4qu5ou5qw5rt17sw5tw}eu{4qu5ou5qw5rt17ss5ts}ev{17ss5ts5qs4qu}6z{17sw5tw5ou5qw5rs}fm{17sw5tw5ou5qw5rs}7n{201ts}fo{17sw5tw5ou5qw5rs}fp{17sw5tw5ou5qw5rs}fq{17sw5tw5ou5qw5rs}7r{cksclscmscnscoscps4ls}fs{17sw5tw5ou5qw5rs}ft{17su5tu}fu{17su5tu}fv{17su5tu}fw{17su5tu}fz{cksclscmscnscoscps4ls}}}\"),\"Helvetica-Bold\":c(\"{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}\"),Courier:c(\"{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}\"),\"Courier-BoldOblique\":c(\"{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}\"),\"Times-Bold\":c(\"{'widths'{k3q2q5ncx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2l202m2n2n3m2o3m2p6o202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5x4l4s4m4m4n4s4o4s4p4m4q3x4r4y4s4y4t2r4u3m4v4y4w4m4x5y4y4s4z4y5k3x5l4y5m4s5n3r5o4m5p4s5q4s5r6o5s4s5t4s5u4m5v2l5w1w5x2l5y3u5z3m6k2l6l3m6m3r6n2w6o3r6p2w6q2l6r3m6s3r6t1w6u2l6v3r6w1w6x5n6y3r6z3m7k3r7l3r7m2w7n2r7o2l7p3r7q3m7r4s7s3m7t3m7u2w7v2r7w1q7x2r7y3o202l3mcl4sal2lam3man3mao3map3mar3mas2lat4uau1yav3maw3tay4uaz2lbk2sbl3t'fof'6obo2lbp3rbr1tbs2lbu2lbv3mbz3mck4s202k3mcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3rek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3m3u2l17s4s19m3m}'kerning'{cl{4qt5ks5ot5qy5rw17sv5tv}201t{cks4lscmscnscoscpscls4wv}2k{201ts}2w{4qu5ku7mu5os5qx5ru17su5tu}2x{17su5tu5ou5qs}2y{4qv5kv7mu5ot5qz5ru17su5tu}'fof'-6o7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qu}3v{17su5tu5os5qu}fu{17su5tu5ou5qu}7p{17su5tu5ou5qu}ck{4qt5ks5ot5qy5rw17sv5tv}4l{4qt5ks5ot5qy5rw17sv5tv}cm{4qt5ks5ot5qy5rw17sv5tv}cn{4qt5ks5ot5qy5rw17sv5tv}co{4qt5ks5ot5qy5rw17sv5tv}cp{4qt5ks5ot5qy5rw17sv5tv}6l{17st5tt5ou5qu}17s{ckuclucmucnucoucpu4lu4wu}5o{ckuclucmucnucoucpu4lu4wu}5q{ckzclzcmzcnzcozcpz4lz4wu}5r{ckxclxcmxcnxcoxcpx4lx4wu}5t{ckuclucmucnucoucpu4lu4wu}7q{ckuclucmucnucoucpu4lu}6p{17sw5tw5ou5qu}ek{17st5tt5qu}el{17st5tt5ou5qu}em{17st5tt5qu}en{17st5tt5qu}eo{17st5tt5qu}ep{17st5tt5ou5qu}es{17ss5ts5qu}et{17sw5tw5ou5qu}eu{17sw5tw5ou5qu}ev{17ss5ts5qu}6z{17sw5tw5ou5qu5rs}fm{17sw5tw5ou5qu5rs}fn{17sw5tw5ou5qu5rs}fo{17sw5tw5ou5qu5rs}fp{17sw5tw5ou5qu5rs}fq{17sw5tw5ou5qu5rs}7r{cktcltcmtcntcotcpt4lt5os}fs{17sw5tw5ou5qu5rs}ft{17su5tu5ou5qu}7m{5os}fv{17su5tu5ou5qu}fw{17su5tu5ou5qu}fz{cksclscmscnscoscps4ls}}}\"),Symbol:c(\"{'widths'{k3uaw4r19m3m2k1t2l2l202m2y2n3m2p5n202q6o3k3m2s2l2t2l2v3r2w1t3m3m2y1t2z1wbk2sbl3r'fof'6o3n3m3o3m3p3m3q3m3r3m3s3m3t3m3u1w3v1w3w3r3x3r3y3r3z2wbp3t3l3m5v2l5x2l5z3m2q4yfr3r7v3k7w1o7x3k}'kerning'{'fof'-6o}}\"),Helvetica:c(\"{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}\"),\"Helvetica-BoldOblique\":c(\"{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}\"),ZapfDingbats:c(\"{'widths'{k4u2k1w'fof'6o}'kerning'{'fof'-6o}}\"),\"Courier-Bold\":c(\"{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}\"),\"Times-Italic\":c(\"{'widths'{k3n2q4ycx2l201n3m201o5t201s2l201t2l201u2l201w3r201x3r201y3r2k1t2l2l202m2n2n3m2o3m2p5n202q5t2r1p2s2l2t2l2u3m2v4n2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w4n3x4n3y4n3z3m4k5w4l3x4m3x4n4m4o4s4p3x4q3x4r4s4s4s4t2l4u2w4v4m4w3r4x5n4y4m4z4s5k3x5l4s5m3x5n3m5o3r5p4s5q3x5r5n5s3x5t3r5u3r5v2r5w1w5x2r5y2u5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q1w6r3m6s3m6t1w6u1w6v2w6w1w6x4s6y3m6z3m7k3m7l3m7m2r7n2r7o1w7p3m7q2w7r4m7s2w7t2w7u2r7v2s7w1v7x2s7y3q202l3mcl3xal2ram3man3mao3map3mar3mas2lat4wau1vav3maw4nay4waz2lbk2sbl4n'fof'6obo2lbp3mbq3obr1tbs2lbu1zbv3mbz3mck3x202k3mcm3xcn3xco3xcp3xcq5tcr4mcs3xct3xcu3xcv3xcw2l2m2ucy2lcz2ldl4mdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr4nfs3mft3mfu3mfv3mfw3mfz2w203k6o212m6m2dw2l2cq2l3t3m3u2l17s3r19m3m}'kerning'{cl{5kt4qw}201s{201sw}201t{201tw2wy2yy6q-t}201x{2wy2yy}2k{201tw}2w{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}2x{17ss5ts5os}2y{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}'fof'-6o6t{17ss5ts5qs}7t{5os}3v{5qs}7p{17su5tu5qs}ck{5kt4qw}4l{5kt4qw}cm{5kt4qw}cn{5kt4qw}co{5kt4qw}cp{5kt4qw}6l{4qs5ks5ou5qw5ru17su5tu}17s{2ks}5q{ckvclvcmvcnvcovcpv4lv}5r{ckuclucmucnucoucpu4lu}5t{2ks}6p{4qs5ks5ou5qw5ru17su5tu}ek{4qs5ks5ou5qw5ru17su5tu}el{4qs5ks5ou5qw5ru17su5tu}em{4qs5ks5ou5qw5ru17su5tu}en{4qs5ks5ou5qw5ru17su5tu}eo{4qs5ks5ou5qw5ru17su5tu}ep{4qs5ks5ou5qw5ru17su5tu}es{5ks5qs4qs}et{4qs5ks5ou5qw5ru17su5tu}eu{4qs5ks5qw5ru17su5tu}ev{5ks5qs4qs}ex{17ss5ts5qs}6z{4qv5ks5ou5qw5ru17su5tu}fm{4qv5ks5ou5qw5ru17su5tu}fn{4qv5ks5ou5qw5ru17su5tu}fo{4qv5ks5ou5qw5ru17su5tu}fp{4qv5ks5ou5qw5ru17su5tu}fq{4qv5ks5ou5qw5ru17su5tu}7r{5os}fs{4qv5ks5ou5qw5ru17su5tu}ft{17su5tu5qs}fu{17su5tu5qs}fv{17su5tu5qs}fw{17su5tu5qs}}}\"),\"Times-Roman\":c(\"{'widths'{k3n2q4ycx2l201n3m201o6o201s2l201t2l201u2l201w2w201x2w201y2w2k1t2l2l202m2n2n3m2o3m2p5n202q6o2r1m2s2l2t2l2u3m2v3s2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v1w3w3s3x3s3y3s3z2w4k5w4l4s4m4m4n4m4o4s4p3x4q3r4r4s4s4s4t2l4u2r4v4s4w3x4x5t4y4s4z4s5k3r5l4s5m4m5n3r5o3x5p4s5q4s5r5y5s4s5t4s5u3x5v2l5w1w5x2l5y2z5z3m6k2l6l2w6m3m6n2w6o3m6p2w6q2l6r3m6s3m6t1w6u1w6v3m6w1w6x4y6y3m6z3m7k3m7l3m7m2l7n2r7o1w7p3m7q3m7r4s7s3m7t3m7u2w7v3k7w1o7x3k7y3q202l3mcl4sal2lam3man3mao3map3mar3mas2lat4wau1vav3maw3say4waz2lbk2sbl3s'fof'6obo2lbp3mbq2xbr1tbs2lbu1zbv3mbz2wck4s202k3mcm4scn4sco4scp4scq5tcr4mcs3xct3xcu3xcv3xcw2l2m2tcy2lcz2ldl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek2wel2wem2wen2weo2wep2weq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr3sfs3mft3mfu3mfv3mfw3mfz3m203k6o212m6m2dw2l2cq2l3t3m3u1w17s4s19m3m}'kerning'{cl{4qs5ku17sw5ou5qy5rw201ss5tw201ws}201s{201ss}201t{ckw4lwcmwcnwcowcpwclw4wu201ts}2k{201ts}2w{4qs5kw5os5qx5ru17sx5tx}2x{17sw5tw5ou5qu}2y{4qs5kw5os5qx5ru17sx5tx}'fof'-6o7t{ckuclucmucnucoucpu4lu5os5rs}3u{17su5tu5qs}3v{17su5tu5qs}7p{17sw5tw5qs}ck{4qs5ku17sw5ou5qy5rw201ss5tw201ws}4l{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cm{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cn{4qs5ku17sw5ou5qy5rw201ss5tw201ws}co{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cp{4qs5ku17sw5ou5qy5rw201ss5tw201ws}6l{17su5tu5os5qw5rs}17s{2ktclvcmvcnvcovcpv4lv4wuckv}5o{ckwclwcmwcnwcowcpw4lw4wu}5q{ckyclycmycnycoycpy4ly4wu5ms}5r{cktcltcmtcntcotcpt4lt4ws}5t{2ktclvcmvcnvcovcpv4lv4wuckv}7q{cksclscmscnscoscps4ls}6p{17su5tu5qw5rs}ek{5qs5rs}el{17su5tu5os5qw5rs}em{17su5tu5os5qs5rs}en{17su5qs5rs}eo{5qs5rs}ep{17su5tu5os5qw5rs}es{5qs}et{17su5tu5qw5rs}eu{17su5tu5qs5rs}ev{5qs}6z{17sv5tv5os5qx5rs}fm{5os5qt5rs}fn{17sv5tv5os5qx5rs}fo{17sv5tv5os5qx5rs}fp{5os5qt5rs}fq{5os5qt5rs}7r{ckuclucmucnucoucpu4lu5os}fs{17sv5tv5os5qx5rs}ft{17ss5ts5qs}fu{17sw5tw5qs}fv{17sw5tw5qs}fw{17ss5ts5qs}fz{ckuclucmucnucoucpu4lu5os5rs}}}\"),\"Helvetica-Oblique\":c(\"{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}\")}};t.events.push([\"addFont\",function(t){var e=t.font,r=h.Unicode[e.postScriptName];r&&(e.metadata.Unicode={},e.metadata.Unicode.widths=r.widths,e.metadata.Unicode.kerning=r.kerning);var n=l.Unicode[e.postScriptName];n&&(e.metadata.Unicode.encoding=n,e.encoding=n.codePages[0])}])}(M.API),\n/**\n   * @license\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e=function(t){for(var e=t.length,r=new Uint8Array(e),n=0;n<e;n++)r[n]=t.charCodeAt(n);return r};t.API.events.push([\"addFont\",function(r){var n=void 0,i=r.font,a=r.instance;if(!i.isStandardFont){if(void 0===a)throw new Error(\"Font does not exist in vFS, import fonts or remove declaration doc.addFont('\"+i.postScriptName+\"').\");if(\"string\"!=typeof(n=!1===a.existsFileInVFS(i.postScriptName)?a.loadFile(i.postScriptName):a.getFileFromVFS(i.postScriptName)))throw new Error(\"Font is not stored as string-data in vFS, import fonts or remove declaration doc.addFont('\"+i.postScriptName+\"').\");!function(r,n){n=/^\\x00\\x01\\x00\\x00/.test(n)?e(n):e(c(n)),r.metadata=t.API.TTFFont.open(n),r.metadata.Unicode=r.metadata.Unicode||{encoding:{},kerning:{},widths:[]},r.metadata.glyIdsUsed=[0]}(i,n)}}])}(M),function(n){function a(){return(r.canvg?Promise.resolve(r.canvg):\"object\"===(void 0===t?\"undefined\":e(t))&&\"undefined\"!=typeof module?new Promise((function(t,e){try{t(require(\"canvg\"))}catch(t){e(t)}})):\"function\"==typeof define&&define.amd?new Promise((function(t,e){try{require([\"canvg\"],t)}catch(t){e(t)}})):Promise.reject(new Error(\"Could not load canvg\"))).catch((function(t){return Promise.reject(new Error(\"Could not load canvg: \"+t))})).then((function(t){return t.default?t.default:t}))}n.addSvgAsImage=function(t,e,r,n,o,s,c,u){if(isNaN(e)||isNaN(r))throw i.error(\"jsPDF.addSvgAsImage: Invalid coordinates\",arguments),new Error(\"Invalid coordinates passed to jsPDF.addSvgAsImage\");if(isNaN(n)||isNaN(o))throw i.error(\"jsPDF.addSvgAsImage: Invalid measurements\",arguments),new Error(\"Invalid measurements (width and/or height) passed to jsPDF.addSvgAsImage\");var l=document.createElement(\"canvas\");l.width=n,l.height=o;var h=l.getContext(\"2d\");h.fillStyle=\"#fff\",h.fillRect(0,0,l.width,l.height);var f={ignoreMouse:!0,ignoreAnimation:!0,ignoreDimensions:!0},d=this;return a().then((function(e){return e.fromString(h,t,f)}),(function(){return Promise.reject(new Error(\"Could not load canvg.\"))})).then((function(t){return t.render(f)})).then((function(){d.addImage(l.toDataURL(\"image/jpeg\",1),e,r,n,o,c,u)}))}}(M.API),\n/**\n   * @license\n   * ====================================================================\n   * Copyright (c) 2013 Eduardo Menezes de Morais, eduardo.morais@usp.br\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining\n   * a copy of this software and associated documentation files (the\n   * \"Software\"), to deal in the Software without restriction, including\n   * without limitation the rights to use, copy, modify, merge, publish,\n   * distribute, sublicense, and/or sell copies of the Software, and to\n   * permit persons to whom the Software is furnished to do so, subject to\n   * the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be\n   * included in all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n   * ====================================================================\n   */\nfunction(t){t.putTotalPages=function(t){var e,r=0;parseInt(this.internal.getFont().id.substr(1),10)<15?(e=new RegExp(t,\"g\"),r=this.internal.getNumberOfPages()):(e=new RegExp(this.pdfEscape16(t,this.internal.getFont()),\"g\"),r=this.pdfEscape16(this.internal.getNumberOfPages()+\"\",this.internal.getFont()));for(var n=1;n<=this.internal.getNumberOfPages();n++)for(var i=0;i<this.internal.pages[n].length;i++)this.internal.pages[n][i]=this.internal.pages[n][i].replace(e,r);return this}}(M.API),function(t){t.viewerPreferences=function(t,r){var n;t=t||{},r=r||!1;var i,a,o,s={HideToolbar:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideMenubar:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideWindowUI:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},FitWindow:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},CenterWindow:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},DisplayDocTitle:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.4},NonFullScreenPageMode:{defaultValue:\"UseNone\",value:\"UseNone\",type:\"name\",explicitSet:!1,valueSet:[\"UseNone\",\"UseOutlines\",\"UseThumbs\",\"UseOC\"],pdfVersion:1.3},Direction:{defaultValue:\"L2R\",value:\"L2R\",type:\"name\",explicitSet:!1,valueSet:[\"L2R\",\"R2L\"],pdfVersion:1.3},ViewArea:{defaultValue:\"CropBox\",value:\"CropBox\",type:\"name\",explicitSet:!1,valueSet:[\"MediaBox\",\"CropBox\",\"TrimBox\",\"BleedBox\",\"ArtBox\"],pdfVersion:1.4},ViewClip:{defaultValue:\"CropBox\",value:\"CropBox\",type:\"name\",explicitSet:!1,valueSet:[\"MediaBox\",\"CropBox\",\"TrimBox\",\"BleedBox\",\"ArtBox\"],pdfVersion:1.4},PrintArea:{defaultValue:\"CropBox\",value:\"CropBox\",type:\"name\",explicitSet:!1,valueSet:[\"MediaBox\",\"CropBox\",\"TrimBox\",\"BleedBox\",\"ArtBox\"],pdfVersion:1.4},PrintClip:{defaultValue:\"CropBox\",value:\"CropBox\",type:\"name\",explicitSet:!1,valueSet:[\"MediaBox\",\"CropBox\",\"TrimBox\",\"BleedBox\",\"ArtBox\"],pdfVersion:1.4},PrintScaling:{defaultValue:\"AppDefault\",value:\"AppDefault\",type:\"name\",explicitSet:!1,valueSet:[\"AppDefault\",\"None\"],pdfVersion:1.6},Duplex:{defaultValue:\"\",value:\"none\",type:\"name\",explicitSet:!1,valueSet:[\"Simplex\",\"DuplexFlipShortEdge\",\"DuplexFlipLongEdge\",\"none\"],pdfVersion:1.7},PickTrayByPDFSize:{defaultValue:!1,value:!1,type:\"boolean\",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.7},PrintPageRange:{defaultValue:\"\",value:\"\",type:\"array\",explicitSet:!1,valueSet:null,pdfVersion:1.7},NumCopies:{defaultValue:1,value:1,type:\"integer\",explicitSet:!1,valueSet:null,pdfVersion:1.7}},c=Object.keys(s),u=[],l=0,h=0,f=0;function d(t,e){var r,n=!1;for(r=0;r<t.length;r+=1)t[r]===e&&(n=!0);return n}if(void 0===this.internal.viewerpreferences&&(this.internal.viewerpreferences={},this.internal.viewerpreferences.configuration=JSON.parse(JSON.stringify(s)),this.internal.viewerpreferences.isSubscribed=!1),n=this.internal.viewerpreferences.configuration,\"reset\"===t||!0===r){var p=c.length;for(f=0;f<p;f+=1)n[c[f]].value=n[c[f]].defaultValue,n[c[f]].explicitSet=!1}if(\"object\"===e(t))for(a in t)if(o=t[a],d(c,a)&&void 0!==o){if(\"boolean\"===n[a].type&&\"boolean\"==typeof o)n[a].value=o;else if(\"name\"===n[a].type&&d(n[a].valueSet,o))n[a].value=o;else if(\"integer\"===n[a].type&&Number.isInteger(o))n[a].value=o;else if(\"array\"===n[a].type){for(l=0;l<o.length;l+=1)if(i=!0,1===o[l].length&&\"number\"==typeof o[l][0])u.push(String(o[l]-1));else if(o[l].length>1){for(h=0;h<o[l].length;h+=1)\"number\"!=typeof o[l][h]&&(i=!1);!0===i&&u.push([o[l][0]-1,o[l][1]-1].join(\" \"))}n[a].value=\"[\"+u.join(\" \")+\"]\"}else n[a].value=n[a].defaultValue;n[a].explicitSet=!0}return!1===this.internal.viewerpreferences.isSubscribed&&(this.internal.events.subscribe(\"putCatalog\",(function(){var t,e=[];for(t in n)!0===n[t].explicitSet&&(\"name\"===n[t].type?e.push(\"/\"+t+\" /\"+n[t].value):e.push(\"/\"+t+\" \"+n[t].value));0!==e.length&&this.internal.write(\"/ViewerPreferences\\n<<\\n\"+e.join(\"\\n\")+\"\\n>>\")})),this.internal.viewerpreferences.isSubscribed=!0),this.internal.viewerpreferences.configuration=n,this}}(M.API),\n/** ====================================================================\n   * @license\n   * jsPDF XMP metadata plugin\n   * Copyright (c) 2016 Jussi Utunen, u-jussi@suomi24.fi\n   *\n   * Permission is hereby granted, free of charge, to any person obtaining\n   * a copy of this software and associated documentation files (the\n   * \"Software\"), to deal in the Software without restriction, including\n   * without limitation the rights to use, copy, modify, merge, publish,\n   * distribute, sublicense, and/or sell copies of the Software, and to\n   * permit persons to whom the Software is furnished to do so, subject to\n   * the following conditions:\n   *\n   * The above copyright notice and this permission notice shall be\n   * included in all copies or substantial portions of the Software.\n   *\n   * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n   * ====================================================================\n   */\nfunction(t){var e=function(){var t='<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><rdf:Description rdf:about=\"\" xmlns:jspdf=\"'+this.internal.__metadata__.namespaceuri+'\"><jspdf:metadata>',e=unescape(encodeURIComponent('<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">')),r=unescape(encodeURIComponent(t)),n=unescape(encodeURIComponent(this.internal.__metadata__.metadata)),i=unescape(encodeURIComponent(\"</jspdf:metadata></rdf:Description></rdf:RDF>\")),a=unescape(encodeURIComponent(\"</x:xmpmeta>\")),o=r.length+n.length+i.length+e.length+a.length;this.internal.__metadata__.metadata_object_number=this.internal.newObject(),this.internal.write(\"<< /Type /Metadata /Subtype /XML /Length \"+o+\" >>\"),this.internal.write(\"stream\"),this.internal.write(e+r+n+i+a),this.internal.write(\"endstream\"),this.internal.write(\"endobj\")},r=function(){this.internal.__metadata__.metadata_object_number&&this.internal.write(\"/Metadata \"+this.internal.__metadata__.metadata_object_number+\" 0 R\")};t.addMetadata=function(t,n){return void 0===this.internal.__metadata__&&(this.internal.__metadata__={metadata:t,namespaceuri:n||\"http://jspdf.default.namespaceuri/\"},this.internal.events.subscribe(\"putCatalog\",r),this.internal.events.subscribe(\"postPutResources\",e)),this}}(M.API),function(t){var e=t.API,r=e.pdfEscape16=function(t,e){for(var r,n=e.metadata.Unicode.widths,i=[\"\",\"0\",\"00\",\"000\",\"0000\"],a=[\"\"],o=0,s=t.length;o<s;++o){if(r=e.metadata.characterToGlyph(t.charCodeAt(o)),e.metadata.glyIdsUsed.push(r),e.metadata.toUnicode[r]=t.charCodeAt(o),-1==n.indexOf(r)&&(n.push(r),n.push([parseInt(e.metadata.widthOfGlyph(r),10)])),\"0\"==r)return a.join(\"\");r=r.toString(16),a.push(i[4-r.length],r)}return a.join(\"\")},n=function(t){var e,r,n,i,a,o,s;for(a=\"/CIDInit /ProcSet findresource begin\\n12 dict begin\\nbegincmap\\n/CIDSystemInfo <<\\n  /Registry (Adobe)\\n  /Ordering (UCS)\\n  /Supplement 0\\n>> def\\n/CMapName /Adobe-Identity-UCS def\\n/CMapType 2 def\\n1 begincodespacerange\\n<0000><ffff>\\nendcodespacerange\",n=[],o=0,s=(r=Object.keys(t).sort((function(t,e){return t-e}))).length;o<s;o++)e=r[o],n.length>=100&&(a+=\"\\n\"+n.length+\" beginbfchar\\n\"+n.join(\"\\n\")+\"\\nendbfchar\",n=[]),void 0!==t[e]&&null!==t[e]&&\"function\"==typeof t[e].toString&&(i=(\"0000\"+t[e].toString(16)).slice(-4),e=(\"0000\"+(+e).toString(16)).slice(-4),n.push(\"<\"+e+\"><\"+i+\">\"));return n.length&&(a+=\"\\n\"+n.length+\" beginbfchar\\n\"+n.join(\"\\n\")+\"\\nendbfchar\\n\"),a+=\"endcmap\\nCMapName currentdict /CMap defineresource pop\\nend\\nend\"};e.events.push([\"putFont\",function(e){!function(e){var r=e.font,i=e.out,a=e.newObject,o=e.putStream;if(r.metadata instanceof t.API.TTFFont&&\"Identity-H\"===r.encoding){for(var s=r.metadata.Unicode.widths,c=r.metadata.subset.encode(r.metadata.glyIdsUsed,1),u=\"\",l=0;l<c.length;l++)u+=String.fromCharCode(c[l]);var h=a();o({data:u,addLength1:!0,objectId:h}),i(\"endobj\");var f=a();o({data:n(r.metadata.toUnicode),addLength1:!0,objectId:f}),i(\"endobj\");var d=a();i(\"<<\"),i(\"/Type /FontDescriptor\"),i(\"/FontName /\"+F(r.fontName)),i(\"/FontFile2 \"+h+\" 0 R\"),i(\"/FontBBox \"+t.API.PDFObject.convert(r.metadata.bbox)),i(\"/Flags \"+r.metadata.flags),i(\"/StemV \"+r.metadata.stemV),i(\"/ItalicAngle \"+r.metadata.italicAngle),i(\"/Ascent \"+r.metadata.ascender),i(\"/Descent \"+r.metadata.decender),i(\"/CapHeight \"+r.metadata.capHeight),i(\">>\"),i(\"endobj\");var p=a();i(\"<<\"),i(\"/Type /Font\"),i(\"/BaseFont /\"+F(r.fontName)),i(\"/FontDescriptor \"+d+\" 0 R\"),i(\"/W \"+t.API.PDFObject.convert(s)),i(\"/CIDToGIDMap /Identity\"),i(\"/DW 1000\"),i(\"/Subtype /CIDFontType2\"),i(\"/CIDSystemInfo\"),i(\"<<\"),i(\"/Supplement 0\"),i(\"/Registry (Adobe)\"),i(\"/Ordering (\"+r.encoding+\")\"),i(\">>\"),i(\">>\"),i(\"endobj\"),r.objectNumber=a(),i(\"<<\"),i(\"/Type /Font\"),i(\"/Subtype /Type0\"),i(\"/ToUnicode \"+f+\" 0 R\"),i(\"/BaseFont /\"+F(r.fontName)),i(\"/Encoding /\"+r.encoding),i(\"/DescendantFonts [\"+p+\" 0 R]\"),i(\">>\"),i(\"endobj\"),r.isAlreadyPutted=!0}}(e)}]);e.events.push([\"putFont\",function(e){!function(e){var r=e.font,i=e.out,a=e.newObject,o=e.putStream;if(r.metadata instanceof t.API.TTFFont&&\"WinAnsiEncoding\"===r.encoding){for(var s=r.metadata.rawData,c=\"\",u=0;u<s.length;u++)c+=String.fromCharCode(s[u]);var l=a();o({data:c,addLength1:!0,objectId:l}),i(\"endobj\");var h=a();o({data:n(r.metadata.toUnicode),addLength1:!0,objectId:h}),i(\"endobj\");var f=a();i(\"<<\"),i(\"/Descent \"+r.metadata.decender),i(\"/CapHeight \"+r.metadata.capHeight),i(\"/StemV \"+r.metadata.stemV),i(\"/Type /FontDescriptor\"),i(\"/FontFile2 \"+l+\" 0 R\"),i(\"/Flags 96\"),i(\"/FontBBox \"+t.API.PDFObject.convert(r.metadata.bbox)),i(\"/FontName /\"+F(r.fontName)),i(\"/ItalicAngle \"+r.metadata.italicAngle),i(\"/Ascent \"+r.metadata.ascender),i(\">>\"),i(\"endobj\"),r.objectNumber=a();for(var d=0;d<r.metadata.hmtx.widths.length;d++)r.metadata.hmtx.widths[d]=parseInt(r.metadata.hmtx.widths[d]*(1e3/r.metadata.head.unitsPerEm));i(\"<</Subtype/TrueType/Type/Font/ToUnicode \"+h+\" 0 R/BaseFont/\"+F(r.fontName)+\"/FontDescriptor \"+f+\" 0 R/Encoding/\"+r.encoding+\" /FirstChar 29 /LastChar 255 /Widths \"+t.API.PDFObject.convert(r.metadata.hmtx.widths)+\">>\"),i(\"endobj\"),r.isAlreadyPutted=!0}}(e)}]);var i=function(t){var e,n=t.text||\"\",i=t.x,a=t.y,o=t.options||{},s=t.mutex||{},c=s.pdfEscape,u=s.activeFontKey,l=s.fonts,h=u,f=\"\",d=0,p=\"\",g=l[h].encoding;if(\"Identity-H\"!==l[h].encoding)return{text:n,x:i,y:a,options:o,mutex:s};for(p=n,h=u,Array.isArray(n)&&(p=n[0]),d=0;d<p.length;d+=1)l[h].metadata.hasOwnProperty(\"cmap\")&&(e=l[h].metadata.cmap.unicode.codeMap[p[d].charCodeAt(0)]),e||p[d].charCodeAt(0)<256&&l[h].metadata.hasOwnProperty(\"Unicode\")?f+=p[d]:f+=\"\";var m=\"\";return parseInt(h.slice(1))<14||\"WinAnsiEncoding\"===g?m=c(f,h).split(\"\").map((function(t){return t.charCodeAt(0).toString(16)})).join(\"\"):\"Identity-H\"===g&&(m=r(f,l[h])),s.isHex=!0,{text:m,x:i,y:a,options:o,mutex:s}};e.events.push([\"postProcessText\",function(t){var e=t.text||\"\",r=[],n={text:e,x:t.x,y:t.y,options:t.options,mutex:t.mutex};if(Array.isArray(e)){var a=0;for(a=0;a<e.length;a+=1)Array.isArray(e[a])&&3===e[a].length?r.push([i(Object.assign({},n,{text:e[a][0]})).text,e[a][1],e[a][2]]):r.push(i(Object.assign({},n,{text:e[a]})).text);t.text=r}else t.text=i(Object.assign({},n,{text:e})).text}])}(M),\n/**\n   * @license\n   * jsPDF virtual FileSystem functionality\n   *\n   * Licensed under the MIT License.\n   * http://opensource.org/licenses/mit-license\n   */\nfunction(t){var e=function(){return void 0===this.internal.vFS&&(this.internal.vFS={}),!0};t.existsFileInVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]},t.addFileToVFS=function(t,r){return e.call(this),this.internal.vFS[t]=r,this},t.getFileFromVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]?this.internal.vFS[t]:null}}(M.API),\n/**\n   * @license\n   * Unicode Bidi Engine based on the work of Alex Shensis (@asthensis)\n   * MIT License\n   */\nfunction(t){t.__bidiEngine__=t.prototype.__bidiEngine__=function(t){var r,n,i,a,o,s,c,u=e,l=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],h=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],f={L:0,R:1,EN:2,AN:3,N:4,B:5,S:6},d={0:0,5:1,6:2,7:3,32:4,251:5,254:6,255:7},p=[\"(\",\")\",\"(\",\"<\",\">\",\"<\",\"[\",\"]\",\"[\",\"{\",\"}\",\"{\",\"\u00ab\",\"\u00bb\",\"\u00ab\",\"\u2039\",\"\u203a\",\"\u2039\",\"\u2045\",\"\u2046\",\"\u2045\",\"\u207d\",\"\u207e\",\"\u207d\",\"\u208d\",\"\u208e\",\"\u208d\",\"\u2264\",\"\u2265\",\"\u2264\",\"\u2329\",\"\u232a\",\"\u2329\",\"\ufe59\",\"\ufe5a\",\"\ufe59\",\"\ufe5b\",\"\ufe5c\",\"\ufe5b\",\"\ufe5d\",\"\ufe5e\",\"\ufe5d\",\"\ufe64\",\"\ufe65\",\"\ufe64\"],g=new RegExp(/^([1-4|9]|1[0-9]|2[0-9]|3[0168]|4[04589]|5[012]|7[78]|159|16[0-9]|17[0-2]|21[569]|22[03489]|250)$/),m=!1,v=0;this.__bidiEngine__={};var b=function(t){var e=t.charCodeAt(),r=e>>8,n=d[r];return void 0!==n?u[256*n+(255&e)]:252===r||253===r?\"AL\":g.test(r)?\"L\":8===r?\"R\":\"N\"},y=function(t){for(var e,r=0;r<t.length;r++){if(\"L\"===(e=b(t.charAt(r))))return!1;if(\"R\"===e)return!0}return!1},w=function(t,e,o,s){var c,u,l,h,f=e[s];switch(f){case\"L\":case\"R\":m=!1;break;case\"N\":case\"AN\":break;case\"EN\":m&&(f=\"AN\");break;case\"AL\":m=!0,f=\"R\";break;case\"WS\":f=\"N\";break;case\"CS\":s<1||s+1>=e.length||\"EN\"!==(c=o[s-1])&&\"AN\"!==c||\"EN\"!==(u=e[s+1])&&\"AN\"!==u?f=\"N\":m&&(u=\"AN\"),f=u===c?u:\"N\";break;case\"ES\":f=\"EN\"===(c=s>0?o[s-1]:\"B\")&&s+1<e.length&&\"EN\"===e[s+1]?\"EN\":\"N\";break;case\"ET\":if(s>0&&\"EN\"===o[s-1]){f=\"EN\";break}if(m){f=\"N\";break}for(l=s+1,h=e.length;l<h&&\"ET\"===e[l];)l++;f=l<h&&\"EN\"===e[l]?\"EN\":\"N\";break;case\"NSM\":if(i&&!a){for(h=e.length,l=s+1;l<h&&\"NSM\"===e[l];)l++;if(l<h){var d=t[s],p=d>=1425&&d<=2303||64286===d;if(c=e[l],p&&(\"R\"===c||\"AL\"===c)){f=\"R\";break}}}f=s<1||\"B\"===(c=e[s-1])?\"N\":o[s-1];break;case\"B\":m=!1,r=!0,f=v;break;case\"S\":n=!0,f=\"N\";break;case\"LRE\":case\"RLE\":case\"LRO\":case\"RLO\":case\"PDF\":m=!1;break;case\"BN\":f=\"N\"}return f},N=function(t,e,r){var n=t.split(\"\");return r&&L(n,r,{hiLevel:v}),n.reverse(),e&&e.reverse(),n.join(\"\")},L=function(t,e,i){var a,o,s,c,u,d=-1,p=t.length,g=0,y=[],N=v?h:l,L=[];for(m=!1,r=!1,n=!1,o=0;o<p;o++)L[o]=b(t[o]);for(s=0;s<p;s++){if(u=g,y[s]=w(t,L,y,s),a=240&(g=N[u][f[y[s]]]),g&=15,e[s]=c=N[g][5],a>0)if(16===a){for(o=d;o<s;o++)e[o]=1;d=-1}else d=-1;if(N[g][6])-1===d&&(d=s);else if(d>-1){for(o=d;o<s;o++)e[o]=c;d=-1}\"B\"===L[s]&&(e[s]=0),i.hiLevel|=c}n&&function(t,e,r){for(var n=0;n<r;n++)if(\"S\"===t[n]){e[n]=v;for(var i=n-1;i>=0&&\"WS\"===t[i];i--)e[i]=v}}(L,e,p)},A=function(t,e,n,i,a){if(!(a.hiLevel<t)){if(1===t&&1===v&&!r)return e.reverse(),void(n&&n.reverse());for(var o,s,c,u,l=e.length,h=0;h<l;){if(i[h]>=t){for(c=h+1;c<l&&i[c]>=t;)c++;for(u=h,s=c-1;u<s;u++,s--)o=e[u],e[u]=e[s],e[s]=o,n&&(o=n[u],n[u]=n[s],n[s]=o);h=c}h++}}},x=function(t,e,r){var n=t.split(\"\"),i={hiLevel:v};return r||(r=[]),L(n,r,i),function(t,e,r){if(0!==r.hiLevel&&c)for(var n,i=0;i<t.length;i++)1===e[i]&&(n=p.indexOf(t[i]))>=0&&(t[i]=p[n+1])}(n,r,i),A(2,n,e,r,i),A(1,n,e,r,i),n.join(\"\")};return this.__bidiEngine__.doBidiReorder=function(t,e,r){if(function(t,e){if(e)for(var r=0;r<t.length;r++)e[r]=r;void 0===a&&(a=y(t)),void 0===s&&(s=y(t))}(t,e),i||!o||s)if(i&&o&&a^s)v=a?1:0,t=N(t,e,r);else if(!i&&o&&s)v=a?1:0,t=x(t,e,r),t=N(t,e);else if(!i||a||o||s){if(i&&!o&&a^s)t=N(t,e),a?(v=0,t=x(t,e,r)):(v=1,t=x(t,e,r),t=N(t,e));else if(i&&a&&!o&&s)v=1,t=x(t,e,r),t=N(t,e);else if(!i&&!o&&a^s){var n=c;a?(v=1,t=x(t,e,r),v=0,c=!1,t=x(t,e,r),c=n):(v=0,t=x(t,e,r),t=N(t,e),v=1,c=!1,t=x(t,e,r),c=n,t=N(t,e))}}else v=0,t=x(t,e,r);else v=a?1:0,t=x(t,e,r);return t},this.__bidiEngine__.setOptions=function(t){t&&(i=t.isInputVisual,o=t.isOutputVisual,a=t.isInputRtl,s=t.isOutputRtl,c=t.isSymmetricSwapping)},this.__bidiEngine__.setOptions(t),this.__bidiEngine__};var e=[\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"S\",\"B\",\"S\",\"WS\",\"B\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"B\",\"B\",\"B\",\"S\",\"WS\",\"N\",\"N\",\"ET\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"ES\",\"CS\",\"ES\",\"CS\",\"CS\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"CS\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"B\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"CS\",\"N\",\"ET\",\"ET\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"L\",\"N\",\"N\",\"BN\",\"N\",\"N\",\"ET\",\"ET\",\"EN\",\"EN\",\"N\",\"L\",\"N\",\"N\",\"N\",\"EN\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"ET\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"R\",\"NSM\",\"R\",\"NSM\",\"NSM\",\"R\",\"NSM\",\"NSM\",\"R\",\"NSM\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"N\",\"N\",\"N\",\"N\",\"N\",\"R\",\"R\",\"R\",\"R\",\"R\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"N\",\"N\",\"AL\",\"ET\",\"ET\",\"AL\",\"CS\",\"AL\",\"N\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AL\",\"AL\",\"N\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"AN\",\"ET\",\"AN\",\"AN\",\"AL\",\"AL\",\"AL\",\"NSM\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AN\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AL\",\"AL\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"N\",\"AL\",\"AL\",\"NSM\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"N\",\"N\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"AL\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"R\",\"R\",\"N\",\"N\",\"N\",\"N\",\"R\",\"N\",\"N\",\"N\",\"N\",\"N\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"WS\",\"BN\",\"BN\",\"BN\",\"L\",\"R\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"WS\",\"B\",\"LRE\",\"RLE\",\"PDF\",\"LRO\",\"RLO\",\"CS\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"CS\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"WS\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"N\",\"LRI\",\"RLI\",\"FSI\",\"PDI\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"BN\",\"EN\",\"L\",\"N\",\"N\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"ES\",\"ES\",\"N\",\"N\",\"N\",\"L\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"ES\",\"ES\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"R\",\"NSM\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"ES\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"N\",\"R\",\"R\",\"R\",\"R\",\"R\",\"N\",\"R\",\"N\",\"R\",\"R\",\"N\",\"R\",\"R\",\"N\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"R\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"NSM\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"CS\",\"N\",\"CS\",\"N\",\"N\",\"CS\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"ET\",\"N\",\"N\",\"ES\",\"ES\",\"N\",\"N\",\"N\",\"N\",\"N\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"N\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"AL\",\"N\",\"N\",\"BN\",\"N\",\"N\",\"N\",\"ET\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"ES\",\"CS\",\"ES\",\"CS\",\"CS\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"EN\",\"CS\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"L\",\"L\",\"L\",\"L\",\"L\",\"L\",\"N\",\"N\",\"L\",\"L\",\"L\",\"N\",\"N\",\"N\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"ET\",\"ET\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\",\"N\"],r=new t.__bidiEngine__({isInputVisual:!0});t.API.events.push([\"postProcessText\",function(t){var e=t.text;t.x,t.y;var n=t.options||{};t.mutex,n.lang;var i=[];if(n.isInputVisual=\"boolean\"!=typeof n.isInputVisual||n.isInputVisual,r.setOptions(n),\"[object Array]\"===Object.prototype.toString.call(e)){var a=0;for(i=[],a=0;a<e.length;a+=1)\"[object Array]\"===Object.prototype.toString.call(e[a])?i.push([r.doBidiReorder(e[a][0]),e[a][1],e[a][2]]):i.push([r.doBidiReorder(e[a])]);t.text=i}else t.text=r.doBidiReorder(e);r.setOptions({isInputVisual:!0})}])}(M),M.API.TTFFont=function(){function t(t){var e;if(this.rawData=t,e=this.contents=new Ve(t),this.contents.pos=4,\"ttcf\"===e.readString(4))throw new Error(\"TTCF not supported.\");e.pos=0,this.parse(),this.subset=new lr(this),this.registerTTF()}return t.open=function(e){return new t(e)},t.prototype.parse=function(){return this.directory=new Ge(this.contents),this.head=new Xe(this),this.name=new rr(this),this.cmap=new Ze(this),this.toUnicode={},this.hhea=new $e(this),this.maxp=new nr(this),this.hmtx=new ir(this),this.post=new tr(this),this.os2=new Qe(this),this.loca=new ur(this),this.glyf=new or(this),this.ascender=this.os2.exists&&this.os2.ascender||this.hhea.ascender,this.decender=this.os2.exists&&this.os2.decender||this.hhea.decender,this.lineGap=this.os2.exists&&this.os2.lineGap||this.hhea.lineGap,this.bbox=[this.head.xMin,this.head.yMin,this.head.xMax,this.head.yMax]},t.prototype.registerTTF=function(){var t,e,r,n,i;if(this.scaleFactor=1e3/this.head.unitsPerEm,this.bbox=function(){var e,r,n,i;for(i=[],e=0,r=(n=this.bbox).length;e<r;e++)t=n[e],i.push(Math.round(t*this.scaleFactor));return i}.call(this),this.stemV=0,this.post.exists?(r=255&(n=this.post.italic_angle),0!=(32768&(e=n>>16))&&(e=-(1+(65535^e))),this.italicAngle=+(e+\".\"+r)):this.italicAngle=0,this.ascender=Math.round(this.ascender*this.scaleFactor),this.decender=Math.round(this.decender*this.scaleFactor),this.lineGap=Math.round(this.lineGap*this.scaleFactor),this.capHeight=this.os2.exists&&this.os2.capHeight||this.ascender,this.xHeight=this.os2.exists&&this.os2.xHeight||0,this.familyClass=(this.os2.exists&&this.os2.familyClass||0)>>8,this.isSerif=1===(i=this.familyClass)||2===i||3===i||4===i||5===i||7===i,this.isScript=10===this.familyClass,this.flags=0,this.post.isFixedPitch&&(this.flags|=1),this.isSerif&&(this.flags|=2),this.isScript&&(this.flags|=8),0!==this.italicAngle&&(this.flags|=64),this.flags|=32,!this.cmap.unicode)throw new Error(\"No unicode cmap for font\")},t.prototype.characterToGlyph=function(t){var e;return(null!=(e=this.cmap.unicode)?e.codeMap[t]:void 0)||0},t.prototype.widthOfGlyph=function(t){var e;return e=1e3/this.head.unitsPerEm,this.hmtx.forGlyph(t).advance*e},t.prototype.widthOfString=function(t,e,r){var n,i,a,o;for(a=0,i=0,o=(t=\"\"+t).length;0<=o?i<o:i>o;i=0<=o?++i:--i)n=t.charCodeAt(i),a+=this.widthOfGlyph(this.characterToGlyph(n))+r*(1e3/e)||0;return a*(e/1e3)},t.prototype.lineHeight=function(t,e){var r;return null==e&&(e=!1),r=e?this.lineGap:0,(this.ascender+r-this.decender)/1e3*t},t}();var We,Ve=function(){function t(t){this.data=null!=t?t:[],this.pos=0,this.length=this.data.length}return t.prototype.readByte=function(){return this.data[this.pos++]},t.prototype.writeByte=function(t){return this.data[this.pos++]=t},t.prototype.readUInt32=function(){return 16777216*this.readByte()+(this.readByte()<<16)+(this.readByte()<<8)+this.readByte()},t.prototype.writeUInt32=function(t){return this.writeByte(t>>>24&255),this.writeByte(t>>16&255),this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt32=function(){var t;return(t=this.readUInt32())>=2147483648?t-4294967296:t},t.prototype.writeInt32=function(t){return t<0&&(t+=4294967296),this.writeUInt32(t)},t.prototype.readUInt16=function(){return this.readByte()<<8|this.readByte()},t.prototype.writeUInt16=function(t){return this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt16=function(){var t;return(t=this.readUInt16())>=32768?t-65536:t},t.prototype.writeInt16=function(t){return t<0&&(t+=65536),this.writeUInt16(t)},t.prototype.readString=function(t){var e,r;for(r=[],e=0;0<=t?e<t:e>t;e=0<=t?++e:--e)r[e]=String.fromCharCode(this.readByte());return r.join(\"\")},t.prototype.writeString=function(t){var e,r,n;for(n=[],e=0,r=t.length;0<=r?e<r:e>r;e=0<=r?++e:--e)n.push(this.writeByte(t.charCodeAt(e)));return n},t.prototype.readShort=function(){return this.readInt16()},t.prototype.writeShort=function(t){return this.writeInt16(t)},t.prototype.readLongLong=function(){var t,e,r,n,i,a,o,s;return t=this.readByte(),e=this.readByte(),r=this.readByte(),n=this.readByte(),i=this.readByte(),a=this.readByte(),o=this.readByte(),s=this.readByte(),128&t?-1*(72057594037927940*(255^t)+281474976710656*(255^e)+1099511627776*(255^r)+4294967296*(255^n)+16777216*(255^i)+65536*(255^a)+256*(255^o)+(255^s)+1):72057594037927940*t+281474976710656*e+1099511627776*r+4294967296*n+16777216*i+65536*a+256*o+s},t.prototype.writeLongLong=function(t){var e,r;return e=Math.floor(t/4294967296),r=4294967295&t,this.writeByte(e>>24&255),this.writeByte(e>>16&255),this.writeByte(e>>8&255),this.writeByte(255&e),this.writeByte(r>>24&255),this.writeByte(r>>16&255),this.writeByte(r>>8&255),this.writeByte(255&r)},t.prototype.readInt=function(){return this.readInt32()},t.prototype.writeInt=function(t){return this.writeInt32(t)},t.prototype.read=function(t){var e,r;for(e=[],r=0;0<=t?r<t:r>t;r=0<=t?++r:--r)e.push(this.readByte());return e},t.prototype.write=function(t){var e,r,n,i;for(i=[],r=0,n=t.length;r<n;r++)e=t[r],i.push(this.writeByte(e));return i},t}(),Ge=function(){var t;function e(t){var e,r,n;for(this.scalarType=t.readInt(),this.tableCount=t.readShort(),this.searchRange=t.readShort(),this.entrySelector=t.readShort(),this.rangeShift=t.readShort(),this.tables={},r=0,n=this.tableCount;0<=n?r<n:r>n;r=0<=n?++r:--r)e={tag:t.readString(4),checksum:t.readInt(),offset:t.readInt(),length:t.readInt()},this.tables[e.tag]=e}return e.prototype.encode=function(e){var r,n,i,a,o,s,c,u,l,h,f,d,p;for(p in f=Object.keys(e).length,s=Math.log(2),l=16*Math.floor(Math.log(f)/s),a=Math.floor(l/s),u=16*f-l,(n=new Ve).writeInt(this.scalarType),n.writeShort(f),n.writeShort(l),n.writeShort(a),n.writeShort(u),i=16*f,c=n.pos+i,o=null,d=[],e)for(h=e[p],n.writeString(p),n.writeInt(t(h)),n.writeInt(c),n.writeInt(h.length),d=d.concat(h),\"head\"===p&&(o=c),c+=h.length;c%4;)d.push(0),c++;return n.write(d),r=2981146554-t(n.data),n.pos=o+8,n.writeUInt32(r),n.data},t=function(t){var e,r,n,i;for(t=ar.call(t);t.length%4;)t.push(0);for(n=new Ve(t),r=0,e=0,i=t.length;e<i;e=e+=4)r+=n.readUInt32();return 4294967295&r},e}(),Ye={}.hasOwnProperty,Je=function(t,e){for(var r in e)Ye.call(e,r)&&(t[r]=e[r]);function n(){this.constructor=t}return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},Xe=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"head\",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.revision=t.readInt(),this.checkSumAdjustment=t.readInt(),this.magicNumber=t.readInt(),this.flags=t.readShort(),this.unitsPerEm=t.readShort(),this.created=t.readLongLong(),this.modified=t.readLongLong(),this.xMin=t.readShort(),this.yMin=t.readShort(),this.xMax=t.readShort(),this.yMax=t.readShort(),this.macStyle=t.readShort(),this.lowestRecPPEM=t.readShort(),this.fontDirectionHint=t.readShort(),this.indexToLocFormat=t.readShort(),this.glyphDataFormat=t.readShort()},e.prototype.encode=function(t){var e;return(e=new Ve).writeInt(this.version),e.writeInt(this.revision),e.writeInt(this.checkSumAdjustment),e.writeInt(this.magicNumber),e.writeShort(this.flags),e.writeShort(this.unitsPerEm),e.writeLongLong(this.created),e.writeLongLong(this.modified),e.writeShort(this.xMin),e.writeShort(this.yMin),e.writeShort(this.xMax),e.writeShort(this.yMax),e.writeShort(this.macStyle),e.writeShort(this.lowestRecPPEM),e.writeShort(this.fontDirectionHint),e.writeShort(t),e.writeShort(this.glyphDataFormat),e.data},e}(We=function(){function t(t){var e;this.file=t,e=this.file.directory.tables[this.tag],this.exists=!!e,e&&(this.offset=e.offset,this.length=e.length,this.parse(this.file.contents))}return t.prototype.parse=function(){},t.prototype.encode=function(){},t.prototype.raw=function(){return this.exists?(this.file.contents.pos=this.offset,this.file.contents.read(this.length)):null},t}()),Ke=function(){function t(t,e){var r,n,i,a,o,s,c,u,l,h,f,d,p,g,m,v,b;switch(this.platformID=t.readUInt16(),this.encodingID=t.readShort(),this.offset=e+t.readInt(),l=t.pos,t.pos=this.offset,this.format=t.readUInt16(),this.length=t.readUInt16(),this.language=t.readUInt16(),this.isUnicode=3===this.platformID&&1===this.encodingID&&4===this.format||0===this.platformID&&4===this.format,this.codeMap={},this.format){case 0:for(s=0;s<256;++s)this.codeMap[s]=t.readByte();break;case 4:for(f=t.readUInt16(),h=f/2,t.pos+=6,i=function(){var e,r;for(r=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)r.push(t.readUInt16());return r}(),t.pos+=2,p=function(){var e,r;for(r=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)r.push(t.readUInt16());return r}(),c=function(){var e,r;for(r=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)r.push(t.readUInt16());return r}(),u=function(){var e,r;for(r=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)r.push(t.readUInt16());return r}(),n=(this.length-t.pos+this.offset)/2,o=function(){var e,r;for(r=[],s=e=0;0<=n?e<n:e>n;s=0<=n?++e:--e)r.push(t.readUInt16());return r}(),s=m=0,b=i.length;m<b;s=++m)for(g=i[s],r=v=d=p[s];d<=g?v<=g:v>=g;r=d<=g?++v:--v)0===u[s]?a=r+c[s]:0!==(a=o[u[s]/2+(r-d)-(h-s)]||0)&&(a+=c[s]),this.codeMap[r]=65535&a}t.pos=l}return t.encode=function(t,e){var r,n,i,a,o,s,c,u,l,h,f,d,p,g,m,v,b,y,w,N,L,A,x,S,_,P,k,F,I,C,j,O,B,M,E,q,D,R,T,U,z,H,W,V,G,Y;switch(F=new Ve,a=Object.keys(t).sort((function(t,e){return t-e})),e){case\"macroman\":for(p=0,g=function(){var t=[];for(d=0;d<256;++d)t.push(0);return t}(),v={0:0},i={},I=0,B=a.length;I<B;I++)null==v[W=t[n=a[I]]]&&(v[W]=++p),i[n]={old:t[n],new:v[t[n]]},g[n]=v[t[n]];return F.writeUInt16(1),F.writeUInt16(0),F.writeUInt32(12),F.writeUInt16(0),F.writeUInt16(262),F.writeUInt16(0),F.write(g),{charMap:i,subtable:F.data,maxGlyphID:p+1};case\"unicode\":for(P=[],l=[],b=0,v={},r={},m=c=null,C=0,M=a.length;C<M;C++)null==v[w=t[n=a[C]]]&&(v[w]=++b),r[n]={old:w,new:v[w]},o=v[w]-n,null!=m&&o===c||(m&&l.push(m),P.push(n),c=o),m=n;for(m&&l.push(m),l.push(65535),P.push(65535),S=2*(x=P.length),A=2*Math.pow(Math.log(x)/Math.LN2,2),h=Math.log(A/2)/Math.LN2,L=2*x-A,s=[],N=[],f=[],d=j=0,E=P.length;j<E;d=++j){if(_=P[d],u=l[d],65535===_){s.push(0),N.push(0);break}if(_-(k=r[_].new)>=32768)for(s.push(0),N.push(2*(f.length+x-d)),n=O=_;_<=u?O<=u:O>=u;n=_<=u?++O:--O)f.push(r[n].new);else s.push(k-_),N.push(0)}for(F.writeUInt16(3),F.writeUInt16(1),F.writeUInt32(12),F.writeUInt16(4),F.writeUInt16(16+8*x+2*f.length),F.writeUInt16(0),F.writeUInt16(S),F.writeUInt16(A),F.writeUInt16(h),F.writeUInt16(L),z=0,q=l.length;z<q;z++)n=l[z],F.writeUInt16(n);for(F.writeUInt16(0),H=0,D=P.length;H<D;H++)n=P[H],F.writeUInt16(n);for(V=0,R=s.length;V<R;V++)o=s[V],F.writeUInt16(o);for(G=0,T=N.length;G<T;G++)y=N[G],F.writeUInt16(y);for(Y=0,U=f.length;Y<U;Y++)p=f[Y],F.writeUInt16(p);return{charMap:r,subtable:F.data,maxGlyphID:b+1}}},t}(),Ze=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"cmap\",e.prototype.parse=function(t){var e,r,n;for(t.pos=this.offset,this.version=t.readUInt16(),n=t.readUInt16(),this.tables=[],this.unicode=null,r=0;0<=n?r<n:r>n;r=0<=n?++r:--r)e=new Ke(t,this.offset),this.tables.push(e),e.isUnicode&&null==this.unicode&&(this.unicode=e);return!0},e.encode=function(t,e){var r,n;return null==e&&(e=\"macroman\"),r=Ke.encode(t,e),(n=new Ve).writeUInt16(0),n.writeUInt16(1),r.table=n.data.concat(r.subtable),r},e}(We),$e=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"hhea\",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.ascender=t.readShort(),this.decender=t.readShort(),this.lineGap=t.readShort(),this.advanceWidthMax=t.readShort(),this.minLeftSideBearing=t.readShort(),this.minRightSideBearing=t.readShort(),this.xMaxExtent=t.readShort(),this.caretSlopeRise=t.readShort(),this.caretSlopeRun=t.readShort(),this.caretOffset=t.readShort(),t.pos+=8,this.metricDataFormat=t.readShort(),this.numberOfMetrics=t.readUInt16()},e}(We),Qe=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"OS/2\",e.prototype.parse=function(t){if(t.pos=this.offset,this.version=t.readUInt16(),this.averageCharWidth=t.readShort(),this.weightClass=t.readUInt16(),this.widthClass=t.readUInt16(),this.type=t.readShort(),this.ySubscriptXSize=t.readShort(),this.ySubscriptYSize=t.readShort(),this.ySubscriptXOffset=t.readShort(),this.ySubscriptYOffset=t.readShort(),this.ySuperscriptXSize=t.readShort(),this.ySuperscriptYSize=t.readShort(),this.ySuperscriptXOffset=t.readShort(),this.ySuperscriptYOffset=t.readShort(),this.yStrikeoutSize=t.readShort(),this.yStrikeoutPosition=t.readShort(),this.familyClass=t.readShort(),this.panose=function(){var e,r;for(r=[],e=0;e<10;++e)r.push(t.readByte());return r}(),this.charRange=function(){var e,r;for(r=[],e=0;e<4;++e)r.push(t.readInt());return r}(),this.vendorID=t.readString(4),this.selection=t.readShort(),this.firstCharIndex=t.readShort(),this.lastCharIndex=t.readShort(),this.version>0&&(this.ascent=t.readShort(),this.descent=t.readShort(),this.lineGap=t.readShort(),this.winAscent=t.readShort(),this.winDescent=t.readShort(),this.codePageRange=function(){var e,r;for(r=[],e=0;e<2;e=++e)r.push(t.readInt());return r}(),this.version>1))return this.xHeight=t.readShort(),this.capHeight=t.readShort(),this.defaultChar=t.readShort(),this.breakChar=t.readShort(),this.maxContext=t.readShort()},e}(We),tr=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"post\",e.prototype.parse=function(t){var e,r,n;switch(t.pos=this.offset,this.format=t.readInt(),this.italicAngle=t.readInt(),this.underlinePosition=t.readShort(),this.underlineThickness=t.readShort(),this.isFixedPitch=t.readInt(),this.minMemType42=t.readInt(),this.maxMemType42=t.readInt(),this.minMemType1=t.readInt(),this.maxMemType1=t.readInt(),this.format){case 65536:break;case 131072:var i;for(r=t.readUInt16(),this.glyphNameIndex=[],i=0;0<=r?i<r:i>r;i=0<=r?++i:--i)this.glyphNameIndex.push(t.readUInt16());for(this.names=[],n=[];t.pos<this.offset+this.length;)e=t.readByte(),n.push(this.names.push(t.readString(e)));return n;case 151552:return r=t.readUInt16(),this.offsets=t.read(r);case 196608:break;case 262144:return this.map=function(){var e,r,n;for(n=[],i=e=0,r=this.file.maxp.numGlyphs;0<=r?e<r:e>r;i=0<=r?++e:--e)n.push(t.readUInt32());return n}.call(this)}},e}(We),er=function(t,e){this.raw=t,this.length=t.length,this.platformID=e.platformID,this.encodingID=e.encodingID,this.languageID=e.languageID},rr=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"name\",e.prototype.parse=function(t){var e,r,n,i,a,o,s,c,u,l,h;for(t.pos=this.offset,t.readShort(),e=t.readShort(),o=t.readShort(),r=[],i=0;0<=e?i<e:i>e;i=0<=e?++i:--i)r.push({platformID:t.readShort(),encodingID:t.readShort(),languageID:t.readShort(),nameID:t.readShort(),length:t.readShort(),offset:this.offset+o+t.readShort()});for(s={},i=u=0,l=r.length;u<l;i=++u)n=r[i],t.pos=n.offset,c=t.readString(n.length),a=new er(c,n),null==s[h=n.nameID]&&(s[h]=[]),s[n.nameID].push(a);this.strings=s,this.copyright=s[0],this.fontFamily=s[1],this.fontSubfamily=s[2],this.uniqueSubfamily=s[3],this.fontName=s[4],this.version=s[5];try{this.postscriptName=s[6][0].raw.replace(/[\\x00-\\x19\\x80-\\xff]/g,\"\")}catch(t){this.postscriptName=s[4][0].raw.replace(/[\\x00-\\x19\\x80-\\xff]/g,\"\")}return this.trademark=s[7],this.manufacturer=s[8],this.designer=s[9],this.description=s[10],this.vendorUrl=s[11],this.designerUrl=s[12],this.license=s[13],this.licenseUrl=s[14],this.preferredFamily=s[15],this.preferredSubfamily=s[17],this.compatibleFull=s[18],this.sampleText=s[19]},e}(We),nr=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"maxp\",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.numGlyphs=t.readUInt16(),this.maxPoints=t.readUInt16(),this.maxContours=t.readUInt16(),this.maxCompositePoints=t.readUInt16(),this.maxComponentContours=t.readUInt16(),this.maxZones=t.readUInt16(),this.maxTwilightPoints=t.readUInt16(),this.maxStorage=t.readUInt16(),this.maxFunctionDefs=t.readUInt16(),this.maxInstructionDefs=t.readUInt16(),this.maxStackElements=t.readUInt16(),this.maxSizeOfInstructions=t.readUInt16(),this.maxComponentElements=t.readUInt16(),this.maxComponentDepth=t.readUInt16()},e}(We),ir=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"hmtx\",e.prototype.parse=function(t){var e,r,n,i,a,o,s;for(t.pos=this.offset,this.metrics=[],e=0,o=this.file.hhea.numberOfMetrics;0<=o?e<o:e>o;e=0<=o?++e:--e)this.metrics.push({advance:t.readUInt16(),lsb:t.readInt16()});for(n=this.file.maxp.numGlyphs-this.file.hhea.numberOfMetrics,this.leftSideBearings=function(){var r,i;for(i=[],e=r=0;0<=n?r<n:r>n;e=0<=n?++r:--r)i.push(t.readInt16());return i}(),this.widths=function(){var t,e,r,n;for(n=[],t=0,e=(r=this.metrics).length;t<e;t++)i=r[t],n.push(i.advance);return n}.call(this),r=this.widths[this.widths.length-1],s=[],e=a=0;0<=n?a<n:a>n;e=0<=n?++a:--a)s.push(this.widths.push(r));return s},e.prototype.forGlyph=function(t){return t in this.metrics?this.metrics[t]:{advance:this.metrics[this.metrics.length-1].advance,lsb:this.leftSideBearings[t-this.metrics.length]}},e}(We),ar=[].slice,or=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"glyf\",e.prototype.parse=function(){return this.cache={}},e.prototype.glyphFor=function(t){var e,r,n,i,a,o,s,c,u,l;return t in this.cache?this.cache[t]:(i=this.file.loca,e=this.file.contents,r=i.indexOf(t),0===(n=i.lengthOf(t))?this.cache[t]=null:(e.pos=this.offset+r,a=(o=new Ve(e.read(n))).readShort(),c=o.readShort(),l=o.readShort(),s=o.readShort(),u=o.readShort(),this.cache[t]=-1===a?new cr(o,c,l,s,u):new sr(o,a,c,l,s,u),this.cache[t]))},e.prototype.encode=function(t,e,r){var n,i,a,o,s;for(a=[],i=[],o=0,s=e.length;o<s;o++)n=t[e[o]],i.push(a.length),n&&(a=a.concat(n.encode(r)));return i.push(a.length),{table:a,offsets:i}},e}(We),sr=function(){function t(t,e,r,n,i,a){this.raw=t,this.numberOfContours=e,this.xMin=r,this.yMin=n,this.xMax=i,this.yMax=a,this.compound=!1}return t.prototype.encode=function(){return this.raw.data},t}(),cr=function(){function t(t,e,r,n,i){var a,o;for(this.raw=t,this.xMin=e,this.yMin=r,this.xMax=n,this.yMax=i,this.compound=!0,this.glyphIDs=[],this.glyphOffsets=[],a=this.raw;o=a.readShort(),this.glyphOffsets.push(a.pos),this.glyphIDs.push(a.readUInt16()),32&o;)a.pos+=1&o?4:2,128&o?a.pos+=8:64&o?a.pos+=4:8&o&&(a.pos+=2)}return 1,8,32,64,128,t.prototype.encode=function(){var t,e,r;for(e=new Ve(ar.call(this.raw.data)),t=0,r=this.glyphIDs.length;t<r;++t)e.pos=this.glyphOffsets[t];return e.data},t}(),ur=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return Je(e,t),e.prototype.tag=\"loca\",e.prototype.parse=function(t){var e,r;return t.pos=this.offset,e=this.file.head.indexToLocFormat,this.offsets=0===e?function(){var e,n;for(n=[],r=0,e=this.length;r<e;r+=2)n.push(2*t.readUInt16());return n}.call(this):function(){var e,n;for(n=[],r=0,e=this.length;r<e;r+=4)n.push(t.readUInt32());return n}.call(this)},e.prototype.indexOf=function(t){return this.offsets[t]},e.prototype.lengthOf=function(t){return this.offsets[t+1]-this.offsets[t]},e.prototype.encode=function(t,e){for(var r=new Uint32Array(this.offsets.length),n=0,i=0,a=0;a<r.length;++a)if(r[a]=n,i<e.length&&e[i]==a){++i,r[a]=n;var o=this.offsets[a],s=this.offsets[a+1]-o;s>0&&(n+=s)}for(var c=new Array(4*r.length),u=0;u<r.length;++u)c[4*u+3]=255&r[u],c[4*u+2]=(65280&r[u])>>8,c[4*u+1]=(16711680&r[u])>>16,c[4*u]=(4278190080&r[u])>>24;return c},e}(We),lr=function(){function t(t){this.font=t,this.subset={},this.unicodes={},this.next=33}return t.prototype.generateCmap=function(){var t,e,r,n,i;for(e in n=this.font.cmap.tables[0].codeMap,t={},i=this.subset)r=i[e],t[e]=n[r];return t},t.prototype.glyphsFor=function(t){var e,r,n,i,a,o,s;for(n={},a=0,o=t.length;a<o;a++)n[i=t[a]]=this.font.glyf.glyphFor(i);for(i in e=[],n)(null!=(r=n[i])?r.compound:void 0)&&e.push.apply(e,r.glyphIDs);if(e.length>0)for(i in s=this.glyphsFor(e))r=s[i],n[i]=r;return n},t.prototype.encode=function(t,e){var r,n,i,a,o,s,c,u,l,h,f,d,p,g,m;for(n in r=Ze.encode(this.generateCmap(),\"unicode\"),a=this.glyphsFor(t),f={0:0},m=r.charMap)f[(s=m[n]).old]=s.new;for(d in h=r.maxGlyphID,a)d in f||(f[d]=h++);return u=function(t){var e,r;for(e in r={},t)r[t[e]]=e;return r}(f),l=Object.keys(u).sort((function(t,e){return t-e})),p=function(){var t,e,r;for(r=[],t=0,e=l.length;t<e;t++)o=l[t],r.push(u[o]);return r}(),i=this.font.glyf.encode(a,p,f),c=this.font.loca.encode(i.offsets,p),g={cmap:this.font.cmap.raw(),glyf:i.table,loca:c,hmtx:this.font.hmtx.raw(),hhea:this.font.hhea.raw(),maxp:this.font.maxp.raw(),post:this.font.post.raw(),name:this.font.name.raw(),head:this.font.head.encode(e)},this.font.os2.exists&&(g[\"OS/2\"]=this.font.os2.raw()),this.font.directory.encode(g)},t}();M.API.PDFObject=function(){var t;function e(){}return t=function(t,e){return(Array(e+1).join(\"0\")+t).slice(-e)},e.convert=function(r){var n,i,a,o;if(Array.isArray(r))return\"[\"+function(){var t,i,a;for(a=[],t=0,i=r.length;t<i;t++)n=r[t],a.push(e.convert(n));return a}().join(\" \")+\"]\";if(\"string\"==typeof r)return\"/\"+r;if(null!=r?r.isString:void 0)return\"(\"+r+\")\";if(r instanceof Date)return\"(D:\"+t(r.getUTCFullYear(),4)+t(r.getUTCMonth(),2)+t(r.getUTCDate(),2)+t(r.getUTCHours(),2)+t(r.getUTCMinutes(),2)+t(r.getUTCSeconds(),2)+\"Z)\";if(\"[object Object]\"==={}.toString.call(r)){for(i in a=[\"<<\"],r)o=r[i],a.push(\"/\"+i+\" \"+e.convert(o));return a.push(\">>\"),a.join(\"\\n\")}return\"\"+r},e}(),t.AcroForm=xt,t.AcroFormAppearance=Lt,t.AcroFormButton=gt,t.AcroFormCheckBox=yt,t.AcroFormChoiceField=ht,t.AcroFormComboBox=dt,t.AcroFormEditBox=pt,t.AcroFormListBox=ft,t.AcroFormPasswordField=Nt,t.AcroFormPushButton=mt,t.AcroFormRadioButton=vt,t.AcroFormTextField=wt,t.GState=C,t.ShadingPattern=O,t.TilingPattern=B,t.default=M,t.jsPDF=M,Object.defineProperty(t,\"__esModule\",{value:!0})}));\n//# sourceMappingURL=jspdf.umd.min.js.map\n"}
}});
