<?php

declare(strict_types=1);

use Jose\Component\Encryption\Algorithm\KeyEncryption\Dir;

/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2020 Spomky-Labs
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 */

use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;

return function (ContainerConfigurator $container): void {
    $container = $container->services()
        ->defaults()
        ->private()
        ->autoconfigure()
        ->autowire();

    $container->set(Dir::class)
        ->tag('jose.algorithm', [
            'alias' => 'dir',
        ]);
};
