<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Api\Data;

interface HolidayInterface extends \Magento\Framework\Api\ExtensibleDataInterface
{
    /**
     * Table Fields
     */
    public const ENTITY_ID = 'entity_id';
    public const IS_SINGLE_DATE = 'is_single_date';
    public const NAME = 'name';
    public const DATE = 'date';
    public const STATUS = 'status';

    /**
     * Get entity id
     *
     * @return string|null
     */
    public function getEntityId();

    /**
     * Set entity id
     *
     * @param string $entityId
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setEntityId($entityId);

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus();

    /**
     * Set status
     *
     * @param string $status
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setStatus($status);

    /**
     * Get is_single_date
     *
     * @return string|null
     */
    public function getIsSingleDate();

    /**
     * Set is_single_date
     *
     * @param string $isSingleDate
     * @return\Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setIsSingleDate($isSingleDate);

    /**
     * Get name
     *
     * @return string|null
     */
    public function getName();

    /**
     * Set name
     *
     * @param string $name
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setName($name);

    /**
     * Get date
     *
     * @return string|null
     */
    public function getDate();

    /**
     * Set date
     *
     * @param string $date
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setDate($date);
}
