<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Block\Adminhtml\Catalog;

class Product extends \Magento\Catalog\Block\Adminhtml\Product
{
    /**
     * Retrieve options(except hotelbooking type) for 'Add Product' split button
     *
     * @return array
     */
    protected function _getAddProductButtonOptions()
    {
        $buttonOptions = [];
        $productTypes = $this->_typeFactory->create()->getTypes();
        uasort(
            $productTypes,
            function ($elementOne, $elementTwo) {
                return ($elementOne['sort_order'] < $elementTwo['sort_order']) ? -1 : 1;
            }
        );

        foreach ($productTypes as $proTypeId => $productType) {
            if ($proTypeId != 'hotelbooking') {
                $buttonOptions[$proTypeId] = [
                    'label' => __($productType['label']),
                    'onclick' => "setLocation('" . $this->_getProductCreateUrl($proTypeId) . "')",
                    'default' => \Magento\Catalog\Model\Product\Type::DEFAULT_TYPE == $proTypeId,
                ];
            }
        }

        return $buttonOptions;
    }
}
