<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Block\Adminhtml\Holiday;

use Magento\Framework\Registry;

class HolidayDetails extends \Magento\Backend\Block\Template
{
    /**
     * @var Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $dataHelper;

    /**
     * @var Magento\Framework\Registry $coreRegistry
     */
    private $coreRegistry;

    /**
     * @var Template
     */
    protected $_template = 'holiday/holiday_details.phtml';
    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $dataHelper
     * @param \Magento\Framework\Registry $coreRegistry
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Webkul\AdvancedBookingSystem\Helper\Data $dataHelper,
        \Magento\Framework\Registry $coreRegistry
    ) {
        $this->dataHelper = $dataHelper;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context);
    }

    /**
     * Get form data
     *
     * @return mixed
     */
    public function getFormData()
    {
        $id = $this->getRequest()->getParam('entity_id');

        if ($id) {
            $holidayData = $this->coreRegistry->registry('wk_advancebooking_holidays');
            if ($holidayData) {
                return $holidayData;
            }
        }

        return false;
    }

    /**
     * Json decode
     *
     * @param array $data
     * @return array
     */
    public function unserialize($data)
    {
        return $this->dataHelper->serializer->unserialize($data);
    }
}
