<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Block\Order\Cancellation;

use Magento\Framework\View\Element\Template;

/**
 * Back to order detail.
 */
class Back extends Template
{
    /**
     * @var Magento\Framework\App\Response\RedirectInterface
     */
    protected $redirect;
    
    /**
     * Constructor
     *
     * @param RedirectInterface $redirect
     * @param Template\Context  $context
     */
    public function __construct(
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        Template\Context $context
    ) {
        $this->redirect = $redirect;
        parent::__construct($context);
    }

    /**
     * Get Referer Url
     *
     * @return string
     */
    public function getRefererUrl()
    {
        return $this->redirect->getRefererUrl();
    }
}
