<?php

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Webkul\AdvancedBookingSystem\Setup\Patch\Data\CreateAttributes;
use Webkul\AdvancedBookingSystem\Setup\Patch\Data\InstallCancellationAttribute;
use Webkul\AdvancedBookingSystem\Setup\Patch\Data\InstallMaxGuestAllowedAttribute;

/**
 * Opreations on console command
 */
class DisableModule extends Command
{
    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    private $resource;

    /**
     * @var \Magento\Framework\Module\Manager
     */
    private $moduleManager;

    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute
     */
    private $eavAttribute;

    /**
     * @var \Magento\Framework\Module\Status
     */
    private $modStatus;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\ResourceConnection $resource
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param \Magento\Eav\Model\Entity\Attribute $entityAttribute
     * @param \Magento\Framework\Module\Status $modStatus
     */
    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource,
        \Magento\Framework\Module\Manager $moduleManager,
        \Magento\Eav\Model\Entity\Attribute $entityAttribute,
        \Magento\Framework\Module\Status $modStatus
    ) {
        $this->resource = $resource;
        $this->moduleManager = $moduleManager;
        $this->eavAttribute = $entityAttribute;
        $this->modStatus = $modStatus;
        parent::__construct();
    }

    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this->setName('advancedbookingsystem:disable')
            ->setDescription('Advanced Booking System Disable Command');
        parent::configure();
    }

    /**
     * @inheritdoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $exitCode = 0;
        if ($this->moduleManager->isEnabled('Webkul_AdvancedBookingSystem')) {
            $connection = $this->resource
                ->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);

            // delete AdvancedBookingSystem product attribute
            $this->eavAttribute->loadByCode('catalog_product', 'show_contact_button_to')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'renting_type')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'event_chart_image')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'price_charged_per')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'hotel_country')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'price_charged_per_hotel')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'price_charged_per_table')->delete();
            $this->eavAttribute->loadByCode('catalog_product', 'wk_holiday_list')->delete();

            // disable AdvancedBookingSystem
            $this->modStatus->setIsEnabled(false, ['Webkul_AdvancedBookingSystem']);

            try {
                // delete entry from patch_list table
                $tableName = $connection->getTableName('patch_list');
                $where = [
                    $connection->quoteIdentifier("patch_name") . 'IN (?)' =>
                    [CreateAttributes::class,
                    InstallCancellationAttribute::class,
                    InstallMaxGuestAllowedAttribute::class]
                ];
                $connection->delete($tableName, $where);

                // delete entry from setup_module table
                $tableName = $connection->getTableName('setup_module');
                $where = [
                    $connection->quoteIdentifier("module") . '=?' => "Webkul_AdvancedBookingSystem"
                ];
                $connection->delete($tableName, $where);

                $output->writeln('<info>Module Webkul_AdvancedBookingSystem has been disabled successfully.</info>');
            } catch (\E $e) {
                $output->writeln(sprintf(
                    '<error>%s</error>',
                    $e->getMessage()
                ));
                $exitCode = 1;
            }
        }
        return $exitCode;
    }
}
