<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Bookings;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

class Slots extends Action
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * @var \Webkul\AdvancedBookingSystem\Model\SlotFactory
     */
    private $slot;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    protected $jsonHelper;
    
    /**
     * @var \Magento\Framework\Controller\Result\RawFactory
     */
    protected $resultRawFactory;

    /**
     * Constructor
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Webkul\AdvancedBookingSystem\Model\SlotFactory $slot
     * @param \Magento\Framework\Json\Helper\Data $jsonHelper
     * @param \Magento\Framework\Controller\Result\RawFactory $resultRawFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Webkul\AdvancedBookingSystem\Model\SlotFactory $slot,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Controller\Result\RawFactory $resultRawFactory
    ) {
        parent::__construct($context);
        $this->helper = $helper;
        $this->slot = $slot;
        $this->jsonHelper = $jsonHelper;
        $this->resultRawFactory = $resultRawFactory;
    }

    /**
     * Execute
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        try {
            $data = $this->getRequest()->getParams();
            if (!empty($data['product_id']) && !empty($data['date'])) {
                $productId = $data['product_id'];
                $date = $data['date'];
                $helper = $this->helper;
                $slotModel = $this->slot->create();
                $slots = $helper->getSlots($productId);
                $info = [];
                if (array_key_exists($date, $slots)) {
                    $info = $slots[$date];
                }
                $date = date("d-m-Y", strtotime($date));
                $slots = [];
                if (!empty($info)) {
                    $parentId = $helper->getParentSlotId($productId);
                    $bookedSlots = $helper->getBookedSlotsQty($parentId);
                    foreach ($info as $key => $item) {
                        $currentTime = $helper->getCurrentTime();
                        $currentDate = strToTime($helper->getCurrentDate());
                        $startTime = strtotime($helper->convertTimeFromSeconds($item['startTime']));
                        $selectedDate = strtotime($date);
                        if ($currentDate == $selectedDate && $startTime <= $currentTime) {
                            continue;
                        } else {
                            $item['date'] = $date;
                            $slots[] = $helper->formatSlot($item, $bookedSlots);
                        }
                    }

                    if (!empty($slots)) {
                        $result = ['avl' => 1, 'msg' => "success", 'slots' => $slots, 'parent_id' => $parentId];
                    } else {
                        $result = ['avl' => 0, 'msg' => __("No slot available")];
                    }
                } else {
                    $result = ['avl' => 0, 'msg' => __("No slot available")];
                }
            } else {
                $result = ['avl' => 0, 'msg' => __("No slot available")];
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger("Controller_Booking_Slots execute : ".$e->getMessage());
        }
        $resultRaw = $this->resultRawFactory->create();
        return $this->jsonResponse($result);
    }

    /**
     * Create json response
     *
     * @param mixed $response
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function jsonResponse($response = '')
    {
        return $this->getResponse()->representJson(
            $this->jsonHelper->jsonEncode($response)
        );
    }

    /**
     * Check for is allowed.
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Webkul_AdvancedBookingSystem::bookings');
    }
}
