<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Holiday;

class Delete extends \Webkul\AdvancedBookingSystem\Controller\Adminhtml\Holiday
{
    /**
     * Authorization level of a basic admin session
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Webkul_AdvancedBookingSystem::holidays';

    /**
     * @var $bookingHolidaysFactory
     */
    protected $bookingHolidaysFactory;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Webkul\AdvancedBookingSystem\Model\HolidayFactory $bookingHolidaysFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Webkul\AdvancedBookingSystem\Model\HolidayFactory $bookingHolidaysFactory
    ) {
        $this->bookingHolidaysFactory = $bookingHolidaysFactory;
        parent::__construct($context, $coreRegistry);
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        // check if we know what should be deleted
        $id = $this->getRequest()->getParam('entity_id');
        if ($id) {
            try {
                // init model and delete
                $model = $this->bookingHolidaysFactory->create();
                $model->load($id);
                $model->delete();
                // display success message
                $this->messageManager->addSuccessMessage(__('You deleted the Holiday.'));
                // go to grid
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                // display error message
                $this->messageManager->addErrorMessage($e->getMessage());
                // go back to edit form
                return $resultRedirect->setPath('*/*/edit', ['entity_id' => $id]);
            }
        }
        // display error message
        $this->messageManager->addErrorMessage(__('We can\'t find a Holiday to delete.'));
        // go to grid
        return $resultRedirect->setPath('*/*/');
    }
}
