<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Holiday;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Webkul\AdvancedBookingSystem\Model\ResourceModel\Holiday\CollectionFactory;

class MassStatus extends \Magento\Backend\App\Action
{
    /**
     * Authorization level of a basic admin session
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Webkul_AdvancedBookingSystem::holidays';

    /**
     * @var Filter
     */
    protected $filter;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context           $context
     * @param Filter            $filter
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        parent::__construct($context);
    }

    /**
     * Update booking product(s) status action
     *
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $collection = $this->filter->getCollection(
            $this->collectionFactory->create()
        );
        $records = $collection->getSize();
        $currentStatus = (int) $this->getRequest()->getParam('status');
        foreach ($collection as $region) {
            $region->setStatus($currentStatus);
            $region->save();
        }
        $status = $currentStatus ? 'Enabled' : 'Disabled';
        $this->messageManager->addSuccess(__(
            'A total of %1 Holidays have been '.$status.' .',
            $records
        ));

        $resultRedirect = $this->resultRedirectFactory->create();
        return $resultRedirect->setPath('advancedbookingsystem/holiday/index');
    }
}
