<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Holiday;

use Magento\Framework\Exception\LocalizedException;

class Save extends \Magento\Backend\App\Action
{
    /**
     * Authorization level of a basic admin session
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Webkul_AdvancedBookingSystem::holidays';

    /**
     * @var $dataPersistor
     */
    protected $dataPersistor;

    /**
     * @var $dataPersistor
     */
    protected $dataHelper;

    /**
     * @var $bookingHolidaysFactory
     */
    protected $bookingHolidaysFactory;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\App\Request\DataPersistorInterface $dataPersistor
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $dataHelper
     * @param \Webkul\AdvancedBookingSystem\Model\HolidayFactory $bookingHolidaysFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\App\Request\DataPersistorInterface $dataPersistor,
        \Webkul\AdvancedBookingSystem\Helper\Data $dataHelper,
        \Webkul\AdvancedBookingSystem\Model\HolidayFactory $bookingHolidaysFactory
    ) {
        $this->dataPersistor = $dataPersistor;
        $this->dataHelper = $dataHelper;
        $this->bookingHolidaysFactory = $bookingHolidaysFactory;
        parent::__construct($context);
    }

    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        if ($data['holidaySelector'] == 1) {
            $data['is_single_date'] = 0;
            $data['from_date'] = $data['holiday_start'];
            $data['to_date'] = $data['holiday_end'];
        } else {
            $data['is_single_date'] = 1;
            $data['from_date'] = $data['holiday_date'];
            $data['to_date'] = $data['holiday_date'];
        }

        $temp = [
            'from' => $data['holiday_start'],
            'to' => $data['holiday_end'],
            'date' => $data['holiday_date']
        ];

        $data['date'] = $this->dataHelper->serializer->serialize($temp);

        if ($data) {
            $id = $this->getRequest()->getParam('entity_id');

            $model = $this->bookingHolidaysFactory->create()->load($id);
            if (!$model->getId() && $id) {
                $this->messageManager->addErrorMessage(__('This Holiday no longer exists.'));
                return $resultRedirect->setPath('*/*/');
            }

            $model->setData($data);

            try {
                $model->save();
                $this->messageManager->addSuccessMessage(__('You saved the Holiday.'));
                $this->dataPersistor->clear('wk_advancebooking_holidays');

                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['entity_id' => $model->getId()]);
                }
                return $resultRedirect->setPath('*/*/');
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong while saving the Holiday.'));
            }

            $this->dataPersistor->set('wk_advancebooking_holidays', $data);
            return $resultRedirect->setPath('*/*/edit', ['entity_id' => $this->getRequest()->getParam('entity_id')]);
        }
        return $resultRedirect->setPath('*/*/');
    }
}
