<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Hotelbooking\Question;

use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter as MassActionFilter;
use Webkul\AdvancedBookingSystem\Model\ResourceModel\Answer\CollectionFactory;

/**
 * Process mass delete answers operation
 */
class MassDeleteAnswer extends \Magento\Backend\App\Action
{
    /**
     * Massactions filter
     *
     * @var MassActionFilter
     */
    private $filter;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * Constructor
     *
     * @param Context           $context
     * @param MassActionFilter  $filter
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(
        Context $context,
        MassActionFilter $filter,
        CollectionFactory $collectionFactory
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $questionId = 0;

        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $records = $collection->getSize();
        $questionIds = array_unique($collection->getColumnValues('question_id'));
        $collection->walk('delete');

        if (count($questionIds)==1) {
            $questionId = implode("", $questionIds);
        }

        $this->messageManager->addSuccess(__(
            'A total of %1 record(s) have been deleted.',
            $records
        ));
        $resultRedirect = $this->resultRedirectFactory->create();
        return $resultRedirect->setPath(
            '*/*/view',
            ['question_id' => $questionId]
        );
    }
}
