<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Adminhtml\Hotelbooking;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;

class Updatestatus extends Action
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Model\QuestionFactory
     */
    private $questionModel;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;
    
    /**
     * @var Context
     */
    private $redirect;

    /**
     * @param Context $context
     * @param \Webkul\AdvancedBookingSystem\Model\QuestionFactory $questionModel
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        Context $context,
        \Webkul\AdvancedBookingSystem\Model\QuestionFactory $questionModel,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        parent::__construct($context);
        $this->redirect = $context->getRedirect();
        $this->questionModel = $questionModel;
        $this->helper = $helper;
    }

    /**
     * Execute
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $postItems = $this->getRequest()->getParams();
        $statuses = $this->helper->getQuestionStatuses();
        if (empty($postItems)) {
            $messages[] = __('Please correct the data sent.');
            $error = true;
        } else {
            try {
                $model = $this->questionModel->create()->load((int)$postItems['id']);
                $model->setStatus($postItems['status'])->save();
                $this->messageManager->addSuccess(__('Query has been %1.', $statuses[$postItems['status']]));
            } catch (\Exception $e) {
                $this->messageManager->addError(__($e->getMessage()));
            }
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setUrl($this->redirect->getRefererUrl());
        return $resultRedirect;
    }
}
