<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Booking;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Webkul\AdvancedBookingSystem\Helper\Customer as CustomerHelper;
use Webkul\AdvancedBookingSystem\Helper\Email as EmailHelper;
use Magento\Framework\Json\Helper\Data as JsonHelper;
use Magento\Catalog\Model\Product;

/**
 * Submit contact form data
 */
class Contact extends Action
{
    /**
     * @var CustomerHelper
     */
    private $customerHelper;

    /**
     * @var EmailHelper
     */
    private $emailHelper;

    /**
     * @var JsonHelper
     */
    private $jsonHelper;

    /**
     * @var Product
     */
    private $product;

    /**
     * @param Context $context
     * @param CustomerHelper $customerHelper
     * @param EmailHelper $emailHelper
     * @param JsonHelper $jsonHelper
     * @param Product $product
     */
    public function __construct(
        Context $context,
        CustomerHelper $customerHelper,
        EmailHelper $emailHelper,
        JsonHelper $jsonHelper,
        Product $product
    ) {
        $this->product = $product;
        $this->customerHelper = $customerHelper;
        $this->emailHelper = $emailHelper;
        $this->jsonHelper = $jsonHelper;
        parent::__construct($context);
    }

    /**
     * Sendmail to Seller action.
     *
     * @return \Magento\Framework\Controller\Result\Redirect
     */
    public function execute()
    {
        if ($this->getRequest()->getPostValue()) {
            $data = $this->getRequest()->getParams();
            if ($this->customerHelper->isCustomerLoggedIn()) {
                $buyerName = $this->customerHelper->getCustomerName();
                $buyerEmail = $this->customerHelper->getCustomerEmail();
            } else {
                $buyerEmail = $data['email'];
                $buyerName = $data['name'];
                if (strlen($buyerName) < 2) {
                    $buyerName = 'Guest';
                }
            }
            $emailTemplateVariables = [];
            $senderInfo = [];
            $receiverInfo = [];
            $emailTemplateVariables['myvar1'] = 'Admin';
            if (!isset($data['product-id'])) {
                $data['product-id'] = 0;
            } else {
                $emailTemplateVariables['myvar3'] = $this->product->load(
                    $data['product-id']
                )->getName();
            }
            $emailTemplateVariables['myvar4'] = $data['query'];
            $emailTemplateVariables['myvar6'] = (string)$data['subject'];
            $emailTemplateVariables['myvar5'] = $buyerEmail;
            $senderInfo = [
                'name' => $buyerName,
                'email' => $buyerEmail,
            ];
            $this->emailHelper->sendContactMailToAdmin(
                $data,
                $emailTemplateVariables,
                $senderInfo
            );
            $this->getResponse()->representJson(
                $this->jsonHelper->jsonEncode('true')
            );
        }
    }
}
