<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Booking;

use Magento\Framework\App\Action\Context;

class Slots extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * @var \Webkul\AdvancedBookingSystem\Model\SlotFactory
     */
    private $slot;

    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private $resultJson;

    /**
     * Constructor
     *
     * @param Context $context
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Webkul\AdvancedBookingSystem\Model\SlotFactory $slot
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJson
     */
    public function __construct(
        Context $context,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Webkul\AdvancedBookingSystem\Model\SlotFactory $slot,
        \Magento\Framework\Controller\Result\JsonFactory $resultJson
    ) {
        $this->helper = $helper;
        $this->slot = $slot;
        $this->resultJson = $resultJson;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        try {
            $data = $this->getRequest()->getParams();
            if (!empty($data['product_id']) && !empty($data['date'])) {
                $productId = $data['product_id'];
                $date = $data['date'];
                $helper = $this->helper;
                $slotModel = $this->slot->create();
                $slots = $helper->getSlots($productId);
                $info = [];
                if (array_key_exists($date, $slots)) {
                    $info = $slots[$date];
                }
                $date = date("d-m-Y", strtotime($date));
                $slots = [];
                if (!empty($info)) {
                    $parentId = $helper->getParentSlotId($productId);
                    $bookedSlots = $helper->getBookedSlotsQty($parentId);
                    foreach ($info as $key => $item) {
                        $currentTime = $helper->getCurrentTime();
                        $currentDate = strToTime($helper->getCurrentDate());
                        $startTime = strtotime($helper->convertTimeFromSeconds($item['startTime']));
                        $selectedDate = strtotime($date);
                        if ($currentDate == $selectedDate && $startTime <= $currentTime) {
                            continue;
                        } else {
                            $item['date'] = $date;
                            $slots[] = $helper->formatSlot($item, $bookedSlots);
                        }
                    }

                    if (!empty($slots)) {
                        $result = ['avl' => 1, 'msg' => "success", 'slots' => $slots, 'parent_id' => $parentId];
                    } else {
                        $result = ['avl' => 0, 'msg' => __("No slot available")];
                    }
                } else {
                    $result = ['avl' => 0, 'msg' => __("No slot available")];
                }
            } else {
                $result = ['avl' => 0, 'msg' => __("No slot available")];
            }
            return $this->resultJson->create()->setData($result);
        } catch (\Exception $e) {
            $this->helper->logDataInLogger("Controller_Booking_Slots execute : ".$e->getMessage());
        }
    }
}
