<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Booking;

use Magento\Framework\App\Action\Action;
use Magento\Checkout\Model\Session as CheckoutSession;

class UnsetMessage extends Action
{
    /**
     * @var Result Raw Factory
     */
    protected $resultRawFactory;

    /**
     * @var Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param CheckoutSession                       $checkoutSession
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        CheckoutSession $checkoutSession
    ) {
        parent::__construct($context);
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Execute
     */
    public function execute()
    {
        $params = $this->_request->getParams();
        if (isset($params['unset']) && $params['unset']) {
            if ($this->checkoutSession->getMessage()) {
                $this->checkoutSession->unsMessage();
            }
        }
    }
}
