<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Hotelbooking;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Data\Form\FormKey\Validator as FormKeyValidator;

class Submitanswer extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\Data\Form\FormKey\Validator
     */
    private $formKeyValidator;

    /**
     * @var \Webkul\AdvancedBookingSystem\Model\AnswerFactory
     */
    private $answerModel;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;
    
    /**
     * @var Context
     */
    private $redirect;

    /**
     * Constructor
     *
     * @param Context $context
     * @param FormKeyValidator $formKeyValidator
     * @param \Webkul\AdvancedBookingSystem\Model\AnswerFactory $answerModel
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        Context $context,
        FormKeyValidator $formKeyValidator,
        \Webkul\AdvancedBookingSystem\Model\AnswerFactory $answerModel,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $date
    ) {
        parent::__construct($context);
        $this->redirect = $context->getRedirect();
        $this->formKeyValidator = $formKeyValidator;
        $this->answerModel = $answerModel;
        $this->helper = $helper;
        $this->date = $date;
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setUrl($this->redirect->getRefererUrl());
        try {
            if ($this->getRequest()->isPost()) {
                $params = $this->getRequest()->getParams();
                if (!$this->formKeyValidator->validate($this->getRequest())) {
                    return $resultRedirect;
                }
                if ($params['customer_nick_name'] == "") {
                    $this->messageManager->addError(__('Please enter your nick name'));
                } elseif ($params['user_answer'] == "") {
                    $this->messageManager->addError(__('Please enter your answer'));
                } else {
                    $data['nick_name'] = $params['customer_nick_name'];
                    $data['answer'] = $params['user_answer'];
                    $data['question_id'] = $params['question_id'];
                    $data['customer_id'] = 0;
                    $data['status'] = 1;
                    $data['created_at'] = $this->date->date()->format('Y-m-d H:i:s');
                    $data['updated_at'] = $this->date->date()->format('Y-m-d H:i:s');
                    if ($this->helper->isCustomerLoggedIn()) {
                        $data['customer_id'] = $this->helper->getCustomerId();
                    }
                    $model = $this->answerModel->create()->setData($data)->save();
                    $id = $model->getId();
                    if ($id) {
                        $this->messageManager->addSuccess(
                            __('Your answer has been submitted successfully')
                        );
                    } else {
                        $this->messageManager->addError(
                            __('Something went wrong !!!')
                        );
                    }
                }
            }
        } catch (\Exception $e) {
            $this->messageManager->addError(
                __('Something Went Wrong, Please try again later.')
            );
        }
        
        return $resultRedirect;
    }
}
