<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Controller\Hotelbooking;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\View\Result\PageFactory;
use Webkul\AdvancedBookingSystem\Helper\Email as EmailHelper;
use Magento\Framework\Data\Form\FormKey\Validator as FormKeyValidator;

/**
 * Question processing controller
 */
class Submitquestion extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\Data\Form\FormKey\Validator
     */
    private $formKeyValidator;

    /**
     * @var \Webkul\AdvancedBookingSystem\Model\QuestionFactory
     */
    private $questionModel;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    private $helper;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

    /**
     * @var EmailHelper
     */
    private $emailHelper;

    /**
     * @var Context
     */
    private $redirect;

    /**
     * Constructor
     *
     * @param Context $context
     * @param FormKeyValidator $formKeyValidator
     * @param \Webkul\AdvancedBookingSystem\Model\QuestionFactory $questionModel
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     * @param EmailHelper $emailHelper
     */
    public function __construct(
        Context $context,
        FormKeyValidator $formKeyValidator,
        \Webkul\AdvancedBookingSystem\Model\QuestionFactory $questionModel,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        EmailHelper $emailHelper
    ) {
        parent::__construct($context);
        $this->redirect = $context->getRedirect();
        $this->formKeyValidator = $formKeyValidator;
        $this->questionModel = $questionModel;
        $this->helper = $helper;
        $this->date = $date;
        $this->emailHelper = $emailHelper;
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setUrl($this->redirect->getRefererUrl());
        try {
            if ($this->getRequest()->isPost()) {
                $params = $this->getRequest()->getParams();
                if (!$this->formKeyValidator->validate($this->getRequest())) {
                    return $resultRedirect;
                }
                if ($params['customer_nickname'] == "") {
                    $this->messageManager->addError(__('Please enter your nick name'));
                } elseif ($params['user_question'] == "") {
                    $this->messageManager->addError(__('Please enter your question'));
                } else {
                    $_product = $this->helper->getProduct($params['product_id']);
                    $data['product_id'] = $params['product_id'];
                    $data['product_name'] = $_product->getName();
                    $data['nick_name'] = $params['customer_nickname'];
                    $data['question'] = $params['user_question'];
                    $data['customer_id'] = 0;
                    $data['created_at'] = $this->date->gmtDate();
                    $data['updated_at'] = $this->date->gmtDate();
                    if ($this->helper->isCustomerLoggedIn()) {
                        $data['customer_id'] = $this->helper->getCustomerId();
                    }
                    if (!$this->helper->getConfigValue('auto_approve_question')) {
                        $data['status'] = \Webkul\AdvancedBookingSystem\Model\Question::STATUS_APPROVED;
                    }
                    $model = $this->questionModel->create()->setData($data)->save();
                    $id = $model->getId();
                    if ($id) {
                        $emailTemplateVariables = [];
                        $emailTemplateVariables['myvar1'] = 'Admin';
                        if (!empty($data['product_id'])) {
                            $_product = $this->helper->getProduct($data['product_id']);
                            $emailTemplateVariables['product_name'] = $_product->getName();
                            $emailTemplateVariables['product_sku'] = $_product->getSku();
                        } else {
                            $emailTemplateVariables['product_name'] = "hotel";
                            $emailTemplateVariables['product_sku'] = "hotel";
                        }
                        $emailTemplateVariables['question'] = $data['question'];
                        $emailTemplateVariables['subject'] = __(
                            "On booking of %1",
                            $emailTemplateVariables['product_name']
                        );
                        $emailTemplateVariables['subject'] = (string)$emailTemplateVariables['subject'];

                        $this->emailHelper->sendQuestionMailToAdmin(
                            $data,
                            $emailTemplateVariables
                        );
                        $this->messageManager->addSuccess(
                            __('Your query has been submitted successfully')
                        );
                    } else {
                        $this->messageManager->addError(
                            __('Something went wrong !!!')
                        );
                    }
                }
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Controller_Hotelbooking_Submitquestion_execute Exception : ".$e->getMessage()
            );
            $this->messageManager->addError(
                __('Something Went Wrong, Please try again later.')
            );
        }
        
        return $resultRedirect;
    }
}
