<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Mail\Template;
 
/**
 * Class to add attachment in email
 */
class TransportBuilder extends \Magento\Framework\Mail\Template\TransportBuilder
{
   /**
    * AddAttachment
    *
    * @param mixed $body
    * @param string $filename
    * @param mixed $mimeType
    * @param mixed $disposition
    * @param mixed $encoding
    * @return object
    */
    public function addAttachment(
        $body,
        $filename = null,
        $mimeType = \Laminas\Mime\Mime::TYPE_OCTETSTREAM,
        $disposition = \Laminas\Mime\Mime::DISPOSITION_ATTACHMENT,
        $encoding = \Laminas\Mime\Mime::ENCODING_BASE64
    ) {
        $attachmentPart = new \Laminas\Mime\Part();
        $attachmentPart->setContent($body)
            ->setType($mimeType)
            ->setFileName($filename)
            ->setEncoding($encoding)
            ->setDisposition($disposition);

        return $attachmentPart;
    }
}
