<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
declare(strict_types=1);

namespace Webkul\AdvancedBookingSystem\Model;

use Magento\Framework\GraphQl\Query\Resolver\TypeResolverInterface;

/**
 * Type Resolver for Booking and Hotel Booking Product
 */
class BookingProductTypeResolver implements TypeResolverInterface
{

    /**
     * BookingProduct ResolveType
     *
     * @param array $data
     * @return string
     */
    public function resolveType(array $data) : string
    {
        if (isset($data['type_id']) && $data['type_id'] == 'booking') {
            return "BookingProduct";
        } elseif (isset($data['type_id']) && $data['type_id'] == 'hotelbooking') {
            return "HotelBookingProduct";
        }
        return '';
    }
}
