<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Model;

class Holiday extends \Magento\Framework\Model\AbstractModel implements
    \Magento\Framework\DataObject\IdentityInterface,
    \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
{
    /**
     * cache tag of stores
     * @var CACHE_TAG
     */
    public const CACHE_TAG = 'wk_advancebooking_holidays';

    /**
     * @var $_cacheTag
     */
    protected $_cacheTag = 'wk_advancebooking_holidays';

    /**
     * @var $_eventPrefix
     */
    protected $_eventPrefix = 'wk_advancebooking_holidays';

    /**
     * Constructor
     */
    protected function _construct()
    {
        $this->_init(\Webkul\AdvancedBookingSystem\Model\ResourceModel\Holiday::class);
    }

    /**
     * @inheritdoc
     *
     * @return string
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritdoc
     *
     * @return string
     */
    public function getDefaultValues()
    {
        $values = [];
        return $values;
    }

    /**
     * Get entity_id
     *
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * Set entity id
     *
     * @param string $entityId
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * Set status
     *
     * @param string $status
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get is_single_date
     *
     * @return string|null
     */
    public function getIsSingleDate()
    {
        return $this->getData(self::IS_SINGLE_DATE);
    }

    /**
     * Set is_single_date
     *
     * @param string $isSingleDate
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setIsSingleDate($isSingleDate)
    {
        return $this->setData(self::IS_SINGLE_DATE, $isSingleDate);
    }

    /**
     * Get name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->getData(self::NAME);
    }

    /**
     * Set name
     *
     * @param string $name
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setName($name)
    {
        return $this->setData(self::NAME, $name);
    }

    /**
     * Get date
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->getData(self::DATE);
    }

    /**
     * Set date
     *
     * @param string $date
     * @return \Webkul\AdvancedBookingSystem\Api\Data\HolidayInterface
     */
    public function setDate($date)
    {
        return $this->setData(self::DATE, $date);
    }
}
