<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Model\Plugin;

use Webkul\AdvancedBookingSystem\Model\Product\Type\Hotelbooking;

/**
 * Class PriceBackend
 *
 *  Make price validation optional for hotelbooking product
 */
class PriceBackend
{
    /**
     * Around Validate
     *
     * @param \Magento\Catalog\Model\Product\Attribute\Backend\Price $subject
     * @param \Closure $proceed
     * @param \Magento\Catalog\Model\Product|\Magento\Framework\DataObject $object
     * @return bool
     */
    public function aroundValidate(
        \Magento\Catalog\Model\Product\Attribute\Backend\Price $subject,
        \Closure $proceed,
        $object
    ) {
        if ($object instanceof \Magento\Catalog\Model\Product
            && $object->getTypeId() == Hotelbooking::TYPE_CODE
        ) {
            return true;
        } else {
            return $proceed($object);
        }
    }
}
