<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Model;

use Webkul\AdvancedBookingSystem\Api\Data\QuestionInterface;
use Magento\Framework\DataObject\IdentityInterface;

class Question extends \Magento\Framework\Model\AbstractModel implements QuestionInterface, IdentityInterface
{
    /**
     * No route page id.
     */
    public const NOROUTE_ENTITY_ID = 'no-route';

    /**
     * AdvancedBookingSystem Question cache tag.
     */
    public const CACHE_TAG = 'hotelbooking_question';

    /**
     * @var string
     */
    protected $_cacheTag = 'hotelbooking_question';

    /**
     * Prefix of model events names.
     *
     * @var string
     */
    protected $_eventPrefix = 'hotelbooking_question';

    /**
     * Pending question status code
     */
    public const STATUS_PENDING = 0;

    /**
     * Approved question status code
     */
    public const STATUS_APPROVED = 1;

    /**
     * Not Approved question status code
     */
    public const STATUS_NOT_APPROVED = 2;

    /**
     * Initialize resource model.
     */
    protected function _construct()
    {
        $this->_init(\Webkul\AdvancedBookingSystem\Model\ResourceModel\Question::class);
    }

    /**
     * Load object data.
     *
     * @param int|null $id
     * @param string   $field
     *
     * @return $this
     */
    public function load($id, $field = null)
    {
        if ($id === null) {
            return $this->noRouteItems();
        }

        return parent::load($id, $field);
    }

    /**
     * Load No-Route Items.
     *
     * @return \Webkul\AdvancedBookingSystem\Model\Question
     */
    public function noRouteItems()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Get ID.
     *
     * @return int
     */
    public function getId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set ID.
     *
     * @param int $id
     *
     * @return \Webkul\AdvancedBookingSystem\Api\Data\QuestionInterface
     */
    public function setId($id)
    {
        return $this->setData(self::ENTITY_ID, $id);
    }
}
