<?php

declare(strict_types=1);

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Model\Resolver;

use Magento\Authorization\Model\UserContextInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthorizationException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Webkul\AdvancedBookingSystem\Helper\Data;

/**
 * Resolver for BookingSlots query
 */
class BookingSlots implements ResolverInterface
{
    /**
     * @var Data
     */
    private $dataHelper;

    /**
     *
     * @param Data $dataHelper
     */
    public function __construct(
        Data $dataHelper
    ) {
        $this->dataHelper = $dataHelper;
    }

    /**
     * BookingSlots Resolver
     *
     * @param \Magento\Framework\GraphQl\Config\Element\Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @throws GraphQlException
     * @return array
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        try {
            $productId = $args['productId'];
            $bookingInfo = $this->dataHelper->getBookingInfo($productId);
            if (!$bookingInfo['is_booking']) {
                throw new GraphQlNoSuchEntityException(__("Not a booking product"));
            }
            if (!isset($bookingInfo['info']) || empty($bookingInfo['info'])) {
                throw new GraphQlNoSuchEntityException(__("Product doesn't have slots."));
            }
            $tempbookingSlots = $this->dataHelper->getJsonDecodedString($bookingInfo['info']);
            $bookingSlots['Mon'] = isset($tempbookingSlots[1]) ? $tempbookingSlots[1] : [];
            $bookingSlots['Tue'] = isset($tempbookingSlots[2]) ? $tempbookingSlots[2] : [];
            $bookingSlots['Wed'] = isset($tempbookingSlots[3]) ? $tempbookingSlots[3] : [];
            $bookingSlots['Thu'] = isset($tempbookingSlots[4]) ? $tempbookingSlots[4] : [];
            $bookingSlots['Fri'] = isset($tempbookingSlots[5]) ? $tempbookingSlots[5] : [];
            $bookingSlots['Sat'] = isset($tempbookingSlots[6]) ? $tempbookingSlots[6] : [];
            $bookingSlots['Sun'] = isset($tempbookingSlots[7]) ? $tempbookingSlots[7] : [];
            return $bookingSlots;
        } catch (LocalizedException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()));
        }
    }
}
