<?php

declare(strict_types=1);

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Model\Resolver;

use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthorizationException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Webkul\AdvancedBookingSystem\Helper\Data;

/**
 * Resolver for HotelAmenities query
 */
class HotelAmenities implements ResolverInterface
{
    /**
     * @var Data
     */
    private $dataHelper;

    /**
     *
     * @param Data $dataHelper
     */
    public function __construct(
        Data $dataHelper
    ) {
        $this->dataHelper = $dataHelper;
    }

    /**
     * HotelAmenities Resolver
     *
     * @param \Magento\Framework\GraphQl\Config\Element\Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @throws GraphQlException
     * @return array
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        try {
            $productId = $args['productId'];
            $hotelAmenities = [];
            $helper = $this->dataHelper;
            $product = $helper->getProduct($productId);
            if (!$product) {
                throw new GraphQlNoSuchEntityException(__('Product doesn\'t exist'));
            }
            $productType = $product->getTypeId();
            $productSetId = $product->getAttributeSetId();
            $hotelAttrSetId = $helper->getProductAttributeSetIdByLabel(
                'Hotel Booking'
            );
            if ($productType != 'hotelbooking' || $productSetId != $hotelAttrSetId) {
                throw new GraphQlNoSuchEntityException(__('Not a Hotel Booking Type Product'));
            }
            if ($product['amenities'] && $product['amenities']!=="") {
                $amenities = explode(",", $product['amenities']);
                $allAmenities = $helper->getProductAttribute('amenities')->getOptions();
                foreach ($allAmenities as $option) {
                    if (in_array($option->getValue(), $amenities)) {
                        $amenitie['label'] = $option->getLabel();
                        $amenitie['imgAvailable'] = 0;
                        $amenitie['imgUrl'] = '';
                        $imageSrc = $helper->readDirectory($productId, $option->getValue());
                        if ($imageSrc) {
                            $amenitie['imgAvailable'] = 1;
                            $amenitie['imgUrl'] = $imageSrc;
                        }
                        array_push($hotelAmenities, $amenitie);
                    }
                }
            }
            return $hotelAmenities;
        } catch (LocalizedException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()));
        }
    }
}
