<?php

declare(strict_types=1);

/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Model\Resolver;

use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthorizationException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Webkul\AdvancedBookingSystem\Helper\Data;
use Magento\QuoteGraphQl\Model\Cart\GetCartForUser;

/**
 * Resolver for ValidateItems mutation
 */
class ValidateItems implements ResolverInterface
{
    /**
     * @var Data
     */
    private $helper;
    
    /**
     * @var GetCartForUser
     */
    private $getCartForUser;

    /**
     *
     * @param Data $helper
     * @param GetCartForUser $getCartForUser
     */
    public function __construct(
        Data $helper,
        GetCartForUser $getCartForUser
    ) {
        $this->helper = $helper;
        $this->getCartForUser = $getCartForUser;
    }

    /**
     * ValidateItems Resolver
     *
     * @param \Magento\Framework\GraphQl\Config\Element\Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @throws GraphQlException
     * @return string
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        try {
            if (empty($args['cartId'])) {
                throw new GraphQlInputException(__('Required parameter "cartId" is missing'));
            }
            $helper = &$this->helper;
            $maskedCartId = $args['cartId'];
            $userId = (int)$context->getUserId();
            $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
            $cart = $this->getCartForUser->getCartForCheckout($maskedCartId, $userId, $storeId);
            $items = $cart->getAllVisibleItems();
            $msg = null;
            foreach ($items as $item) {
                $msg .= $this->helper->processItem($item)." ";
            }
            return ($msg && $msg != " ") ? $msg : "Items validates successfully.";
        } catch (LocalizedException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()));
        }
    }
}
