<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\AdvancedBookingSystem\Model\Source;

use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;
use Magento\Framework\Data\OptionSourceInterface;

class Holiday extends AbstractSource implements OptionSourceInterface
{
    /**
     * Factory(country)
     *
     * @var \Webkul\AdvancedBookingSystem\Model\HolidayFactory
     */
    protected $holidayFactory;

    /**
     * @var \Magento\Framework\Serialize\SerializerInterface
     */
    private $serializer;
    
    /**
     * @var \Webkul\AdvancedBookingSystem\Model\ResourceModel\Holiday\CollectionFactory
     */
    private $holidayCollectionFactory;

    /**
     * Construct
     *
     * @param \Magento\Framework\Serialize\SerializerInterface $serializer
     * @param \Webkul\AdvancedBookingSystem\Model\ResourceModel\Holiday\CollectionFactory $holidayCollectionFactory
     */
    public function __construct(
        \Magento\Framework\Serialize\SerializerInterface $serializer,
        \Webkul\AdvancedBookingSystem\Model\ResourceModel\Holiday\CollectionFactory $holidayCollectionFactory
    ) {
        $this->serializer = $serializer;
        $this->holidayCollectionFactory = $holidayCollectionFactory;
    }

    /**
     * Retrieve option array
     *
     * @return array
     */
    public function getAllOptions()
    {
        $options = [];
        $holidays = $this->holidayCollectionFactory->create()
        ->addFieldToFilter('status', ['eq' => 1]);
        $holidays = $holidays->getData();
        foreach ($holidays as $holiday) {
            $date = $this->serializer->unserialize($holiday['date']);
            if ($holiday['is_single_date']) {
                $holiday['name'] .= ' ('.$date['date'].')';
            } else {
                if (!empty($date['from']) && !empty($date['to'])) {
                    $label = ' ('.$date['from'].' - '.$date['to'].')';
                    $holiday['name'] .= $label;
                }
            }
            $options[] = ['value'=>$holiday['entity_id'], 'label' => $holiday['name']];
        }
        return $options;
    }

    /**
     * Get serializer
     *
     * @return \Magento\Framework\Serialize\SerializerInterface
     */
    private function getSerializer()
    {
        if ($this->serializer === null) {
            $this->serializer = \Magento\Framework\App\ObjectManager::getInstance()
                ->get(\Magento\Framework\Serialize\SerializerInterface::class);
        }
        return $this->serializer;
    }
}
