<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer\Admin;

use Magento\Framework\Event\ObserverInterface;
use Webkul\AdvancedBookingSystem\Model\ResourceModel\Quote\CollectionFactory as QuoteCollection;
use Webkul\AdvancedBookingSystem\Model\Info;

class SalesQuoteItemSetProduct implements ObserverInterface
{
    /**
     * Quote session object
     *
     * @var \Magento\Backend\Model\Session\Quote
     */
    private $quoteSession;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Admin\Data
     */
    private $adminHelper;

     /**
      * @var QuoteCollection
      */
    private $quoteCollection;

    /**
     * Constructor classes for SalesQuoteItemSetProduct
     *
     * @param \Magento\Backend\Model\Session\Quote $quoteSession
     * @param \Webkul\AdvancedBookingSystem\Helper\Admin\Data $adminHelper
     * @param QuoteCollection $quoteCollection
     */
    public function __construct(
        \Magento\Backend\Model\Session\Quote $quoteSession,
        \Webkul\AdvancedBookingSystem\Helper\Admin\Data $adminHelper,
        QuoteCollection $quoteCollection
    ) {
        $this->quoteSession = $quoteSession;
        $this->adminHelper = $adminHelper;
        $this->quoteCollection = $quoteCollection;
    }

    /**
     * For adding cart items record in wk_bs_quote_item table for placing order from admin panel
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        // [product, quote_item]
        $item = $observer->getEvent()->getQuoteItem();
        $adminHelper = $this->adminHelper;
        if ($item->getBuyRequest()) {
            $data = $item->getBuyRequest()->getData();
            $productId = $item->getProduct()->getId();
            $itemId = (int) $item->getId();
            $paramData = $adminHelper->getParams();
            $paramItemData = $data;
            if (!empty($paramData['item'][$itemId])) {
                $paramItemData = $paramData['item'][$itemId];
                $data = $paramData['item'][$itemId];
            }
            $collection = $this->quoteCollection->create();
            $product = $adminHelper->getProduct($productId);
            $productSetId = $product->getAttributeSetId();
            $allowedAttrSetIDs = $adminHelper->getAllowedAttrSetIDs();
            $appointmentAttrSetId = $adminHelper->getProductAttributeSetIdByLabel(
                'Appointment Booking'
            );
            $eventAttrSetId = $adminHelper->getProductAttributeSetIdByLabel(
                'Event Booking'
            );
            $rentalAttrSetId = $adminHelper->getProductAttributeSetIdByLabel(
                'Rental Booking'
            );
            $hotelAttrSetId = $adminHelper->getProductAttributeSetIdByLabel(
                'Hotel Booking'
            );
            $tableAttrSetId = $adminHelper->getProductAttributeSetIdByLabel(
                'Table Booking'
            );
            $isThrowError = 0;
            if (in_array($productSetId, $allowedAttrSetIDs) || $productSetId==$hotelAttrSetId) {
                if ($appointmentAttrSetId == $productSetId) {
                    $adminHelper->processBookingSave(
                        $data,
                        $product,
                        $item,
                        $isThrowError
                    );
                } elseif ($eventAttrSetId == $productSetId) {
                    $adminHelper->processEventBookingSave(
                        $data,
                        $product,
                        $item,
                        $isThrowError
                    );
                } elseif ($rentalAttrSetId == $productSetId) {
                    $adminHelper->processRentBookingSave(
                        $data,
                        $product,
                        $item,
                        $isThrowError
                    );
                } elseif ($productSetId==$hotelAttrSetId) {
                    $adminHelper->processHotelBookingSave(
                        $data,
                        $product,
                        $item,
                        $isThrowError
                    );
                } elseif ($productSetId==$tableAttrSetId && $item->getId()) {
                    $itemId = (int) $item->getId();
                    $collection = $this->quoteCollection->create();
                    $bookingQuote = $adminHelper->getDataByField($itemId, 'item_id', $collection);
                    if (!$bookingQuote) {
                        $adminHelper->processTableBookingSave(
                            $data,
                            $product,
                            $item,
                            $isThrowError
                        );
                    }
                }
            } elseif (!empty($data['slot_id'])) {
                $adminHelper->processDefaultSlotData(
                    $data,
                    $item,
                    $productId,
                    $itemId,
                    $isThrowError
                );
            }
        }

        $this->updateHotelTableBookingItems($item);
    }

    /**
     * Update Hotel & Table Booking Items
     *
     * @param \Magento\Quote\Model\Quote\Item $item
     * @return void
     */
    public function updateHotelTableBookingItems($item)
    {
        // 2.  For adding cart items record in wk_bs_quote_item table for hotel booking
        if ($item->getBuyRequest()) {
            $data = $item->getBuyRequest()->getData();
            $itemId = (int) $item->getId();
            $productId = $item->getProductId();
            $paramData = $this->adminHelper->getParams();
            if (!empty($paramData['item'][$itemId])) {
                $data = $paramData['item'][$itemId];
            }
            if ($this->adminHelper->isBookingProduct($productId)) {
                $product = $this->adminHelper->getProduct($productId);
                if ($item->getProductType()=="hotelbooking") {
                    $this->adminHelper->checkIsHotelBookedForDateRange($data, $product, $item);
                } else {
                    $tableAttrSetId = $this->adminHelper->getProductAttributeSetIdByLabel(
                        'Table Booking'
                    );
                    if ($item->getProduct()->getAttributeSetId() == $tableAttrSetId) {
                        $this->adminHelper->checkIsCapacityAvailableForDateRange($data, $product, $item);
                    }
                }
            }
        }
    }
}
