<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;

class AfterInvoiceSave implements ObserverInterface
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Order
     */
    private $helper;
    
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $dataHelper;
    
    /**
     * @var \Webkul\AdvancedBookingSystem\Model\ResourceModel\Info\CollectionFactory
     */
    private $infoCollFactory;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Order                               $helper
     * @param \Webkul\AdvancedBookingSystem\Helper\Data                                $datahelper
     * @param \Webkul\AdvancedBookingSystem\Model\ResourceModel\Info\CollectionFactory $infoCollFactory
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Order $helper,
        \Webkul\AdvancedBookingSystem\Helper\Data $datahelper,
        \Webkul\AdvancedBookingSystem\Model\ResourceModel\Info\CollectionFactory $infoCollFactory
    ) {
        $this->helper = $helper;
        $this->dataHelper = $datahelper;
        $this->infoCollFactory = $infoCollFactory;
    }

    /**
     * Execute
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $order = $observer->getInvoice()->getOrder();
            foreach ($order->getItems() as $item) {
                $this->helper->checkBookingProduct($item->getProductId());
                 $product = $this->dataHelper->getProduct($item->getProductId());
                if ($product->getTypeId() == "hotelbooking") {
                    $this->setBookingInfo($item);
                }
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Observer_AfterInvoiceSave execute : ".$e->getMessage()
            );
        }
    }

    /**
     * SetBookingInfo
     *
     * @param object $item
     */
    protected function setBookingInfo($item)
    {
        $buyRequestdata = $item->getBuyRequest()->getData();

        $childProductId = null;
                
        if (isset($buyRequestdata['selected_configurable_option'])) {
            $childProductId = $buyRequestdata['selected_configurable_option'];
        } else {
            //if order placed from graphql then we have to get child product id from super_attribute
            $childProductId = $this->dataHelper->getChildFromProductAttribute(
                $item->getProductId(),
                $buyRequestdata['super_attribute']
            );
        }

        $bookingInfo = $this->dataHelper->getBookingInfo($item->getProductId());
        $infoItem = $this->infoCollFactory->create()
                          ->addFieldToFilter('id', ['eq'=>$bookingInfo['id']])
                          ->getFirstItem();
        $bookingInfoData = $this->dataHelper->getJsonDecodedString($bookingInfo['info']);
        foreach ($bookingInfoData as $Key => $value) {
            if ($Key == $childProductId) {
                $bookingInfoData[$childProductId]['qty'] -= $item->getQtyInvoiced();
            }
        }
        $totalSlots = $infoItem->getTotalSlots() - $item->getQtyInvoiced();
        $info = $this->helper->getJsonEcodedString($bookingInfoData);
        $infoItem->setInfo($info);
        $infoItem->setTotalSlots($totalSlots);
        $infoItem->save();
    }
}
