<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;

class AfterValidateProduct implements ObserverInterface
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * After validate product event handler.
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $product = $observer->getEvent()->getProduct();
        $productType = $product->getTypeId();
        $productSetId = $product->getAttributeSetId();
        $eventAttrSetId = $this->helper->getProductAttributeSetIdByLabel(
            'Event Booking'
        );
        if ($productType == "booking" && $productSetId == $eventAttrSetId) {
            $this->validateEventDate($product);
        }
    }

    /**
     * ValidateEventDate validate event date range
     *
     * @param \Magento\Catalog\Model\Product $product
     * @return void
     */
    private function validateEventDate($product)
    {
        $throw = false;
        try {
            if ($product->getEventDateTo()) {
                if ($product->getEventDateTo() <= $product->getEventDateFrom()) {
                    $throw = true;
                }
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Observer_AfterValidateProduct_validateEventDate Exception : ".$e->getMessage()
            );
        }
        if ($throw) {
            throw new \Magento\Framework\Exception\LocalizedException(
                __('Make sure the Event To Date is later than or the same as the Event From Date.')
            );
        }
    }
}
