<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\RequestInterface;

class BeforeViewProduct implements ObserverInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * Constructor
     *
     * @param RequestInterface                          $request
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        RequestInterface $request,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->request = $request;
        $this->helper = $helper;
    }

    /**
     * Execute
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $this->helper->logDataInLogger('BeforeViewProduct');
            $data = $this->request->getParams();
            $productId = $data['id'];
            $this->helper->enableOptions($productId);
            $this->helper->checkBookingProduct($productId);
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Observer_BeforeViewProduct execute : ".$e->getMessage()
            );
        }
    }
}
