<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;

class CartUpdateItemAfter implements ObserverInterface
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Magento\Framework\App\RequestInterface   $request
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->helper = $helper;
        $this->request = $request;
    }

    /**
     * Execute
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $this->helper->logDataInLogger('CartUpdateItemAfter ');
        $data = $this->request->getParams();
        $info = $observer->getEvent()->getInfo()->getData();
        $cart = $observer->getEvent()->getCart();
        $quote = $cart->getQuote();
        if (!empty($data['item_id']) && !empty($data['item_qty'])) {
            if (!empty($info[$data['item_id']])) {
                $itemId = $data['item_id'];
                $item = $quote->getItemById($itemId);
                if ($item) {
                    $productId = $item->getProductId();
                    if ($this->helper->isBookingProduct($productId)) {
                        $this->helper->processItem(
                            $item
                        );
                    }
                }
            }
        }
    }
}
