<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;

class SalesQuoteAddItem implements ObserverInterface
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * Execute
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $item = $observer->getEvent()->getQuoteItem();
        $this->helper->logDataInLogger('sales qote add item ');
        if ($item->getBuyRequest()) {
            $data = $item->getBuyRequest()->getData();
            $productId = $item->getProductId();
            if ($this->helper->isBookingProduct($productId)) {
                $product = $this->helper->getProduct($productId);
                if ($item->getProductType()=="hotelbooking") {
                    $this->helper->checkIsHotelBookedForDateRange($data, $product, $item);
                } else {
                    $tableAttrSetId = $this->helper->getProductAttributeSetIdByLabel(
                        'Table Booking'
                    );
                    if ($item->getProduct()->getAttributeSetId() == $tableAttrSetId) {
                        $this->helper->checkIsCapacityAvailableForDateRange($data, $product, $item);
                    }
                }
            }
        }
    }
}
