<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Observer;

use Magento\Framework\Event\ObserverInterface;
use Webkul\AdvancedBookingSystem\Model\ResourceModel\Quote\CollectionFactory as QuoteCollection;

class SalesQuoteItemProduct implements ObserverInterface
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

     /**
      * @var QuoteCollection
      */
    private $quoteCollection;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param QuoteCollection $quoteCollection
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        QuoteCollection $quoteCollection
    ) {
        $this->helper = $helper;
        $this->quoteCollection = $quoteCollection;
    }

    /**
     * Execute
     *
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $this->helper->logDataInLogger('sales quote item product ');
        $item = $observer->getEvent()->getQuoteItem();
        $helper = $this->helper;
        $actionName = $helper->getFullActionName();
        $notAllowedAction = [
            'checkout_index_index',
            'checkout_sidebar_updateItemQty'
        ];
        if ($item->getBuyRequest() && !in_array($actionName, $notAllowedAction)) {
            $data = $item->getBuyRequest()->getData();
            $productId = $item->getProduct()->getId();
            $itemId = (int) $item->getId();
            if ($this->helper->isBookingProduct($productId)) {
                $collection = $this->quoteCollection->create();
                $product = $helper->getProduct($productId);
                $productSetId = $product->getAttributeSetId();
                $allowedAttrSetIDs = $helper->getAllowedAttrSetIDs();
                $appointmentAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Appointment Booking'
                );
                $eventAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Event Booking'
                );
                $rentalAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Rental Booking'
                );
                $hotelAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Hotel Booking'
                );
                $tableAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Table Booking'
                );
                $isThrowError = 1;
                if (in_array($productSetId, $allowedAttrSetIDs) || $productSetId==$hotelAttrSetId) {
                    if ($appointmentAttrSetId == $productSetId) {
                        $helper->processBookingSave(
                            $data,
                            $product,
                            $item,
                            $isThrowError
                        );
                    } elseif ($eventAttrSetId == $productSetId) {
                        $helper->processEventBookingSave(
                            $data,
                            $product,
                            $item,
                            $isThrowError
                        );
                    } elseif ($rentalAttrSetId == $productSetId) {
                        $helper->processRentBookingSave(
                            $data,
                            $product,
                            $item,
                            $isThrowError
                        );
                    } elseif ($productSetId==$hotelAttrSetId) {
                        $helper->processHotelBookingSave(
                            $data,
                            $product,
                            $item,
                            $isThrowError
                        );
                    } elseif ($productSetId==$tableAttrSetId && $item->getId()) {
                        $itemId = (int) $item->getId();
                        $collection = $this->quoteCollection->create();
                        $bookingQuote = $helper->getDataByField($itemId, 'item_id', $collection);
                        if (!$bookingQuote) {
                            $helper->processTableBookingSave(
                                $data,
                                $product,
                                $item,
                                $isThrowError
                            );
                        }
                    }
                } elseif (!empty($data['slot_id'])) {
                    $helper->processDefaultSlotData(
                        $data,
                        $item,
                        $productId,
                        $itemId,
                        $isThrowError
                    );
                }
            }
        }
    }
}
