<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Cart\Item\Renderer;

class ActionsPlugin
{

    /**
     * Remove edit action from cart grid
     *
     * @param Magento\Checkout\Block\Cart\Item\Renderer\Actions $subject
     * @param object $item
     */
    public function beforeSetItem(\Magento\Checkout\Block\Cart\Item\Renderer\Actions $subject, $item)
    {
        $productType = $item->getProduct()->getTypeId();
        if ($productType == 'booking') {
            $subject->getLayout()->unsetElement('checkout.cart.item.renderers.default.actions.edit');
        }
    }
}
