<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Controller\Checkout\Cart;

use Magento\Framework\Controller\ResultFactory;

class Configure
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultFactory;

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * Constructor
     *
     * @param ResultFactory                               $resultFactory
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Webkul\AdvancedBookingSystem\Helper\Data   $helper
     */
    public function __construct(
        ResultFactory $resultFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->helper = $helper;
    }

    /**
     * After Execute
     *
     * @param \Magento\Checkout\Controller\Cart\Configure $subject
     * @param mixed $result
     */
    public function afterExecute(\Magento\Checkout\Controller\Cart\Configure $subject, $result)
    {
        try {
            if ($this->helper->canConfigureCart()) {
                $this->messageManager->addError(__("Can not configure booking."));
                return $this->resultFactory->create(
                    ResultFactory::TYPE_REDIRECT
                )->setPath('checkout/cart');
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Plugin_Controller_Checkout_Cart_Configure_afterExecute Exception : ".$e->getMessage()
            );
        }
        return $result;
    }
}
