<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Controller\Product;

class ViewPlugin
{
    /** @var \Webkul\AdvancedBookingSystem\Helper\Data */
    protected $helper;

    /**
     * Constructor
     *
     * @param Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * After Execute
     *
     * @param \Magento\Catalog\Controller\Product\View $subject
     * @param mixed $result
     */
    public function afterExecute(\Magento\Catalog\Controller\Product\View $subject, $result)
    {
        try {
            if ($subject->getRequest()->isAjax()) {
                $data = [
                    "list" => $result->getLayout()->getBlock('product_hotelbooking_askquestion')->toHtml()
                ];
                $subject->getResponse()->setBody(json_encode($data));
                return;
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Plugin_Controller_Catalog_Product_View_afterExecute Exception : ".$e->getMessage()
            );
        }
        return $result;
    }
}
