<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Model\CatalogInventory\Stock;

class Item
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(\Webkul\AdvancedBookingSystem\Helper\Data $helper)
    {
        $this->helper = $helper;
    }

    /**
     * After getQty
     *
     * @param \Magento\CatalogInventory\Model\Stock\Item $subject
     * @param mixed $result
     */
    public function afterGetQty(\Magento\CatalogInventory\Model\Stock\Item $subject, $result)
    {
        try {
            $productId = $subject->getProductId();
            $helper = $this->helper;
            if ($helper->isBookingProduct($productId, true)) {
                return $helper->getTotalBookingQty($productId);
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Plugin_Model_CatalogInventory_Stock_Item_afterGetQty Exception : ".$e->getMessage()
            );
        }
        return $result;
    }
}
